#pragma once

// @generated by aten/src/ATen/gen.py from Functions.h

#include <c10/core/Scalar.h>
#include <ATen/Tensor.h>
#include <c10/core/Storage.h>
#include <ATen/core/Generator.h>
#include <c10/util/Deprecated.h>
#include <ATen/NativeFunctions.h> // TODO: try to delete this
#include <ATen/DeviceGuard.h>
#include <c10/core/TensorOptions.h>
#include <ATen/core/Reduction.h>
#include <c10/util/Optional.h>
#include <ATen/TensorUtils.h>
#include <ATen/Context.h>
#include <ATen/TracerMode.h>

namespace at {

using native::tensor;

CAFFE2_API Tensor _cast_Byte(const Tensor & self, bool non_blocking=false);
CAFFE2_API Tensor _cast_Char(const Tensor & self, bool non_blocking=false);
CAFFE2_API Tensor _cast_Double(const Tensor & self, bool non_blocking=false);
CAFFE2_API Tensor _cast_Float(const Tensor & self, bool non_blocking=false);
CAFFE2_API Tensor _cast_Int(const Tensor & self, bool non_blocking=false);
CAFFE2_API Tensor _cast_Long(const Tensor & self, bool non_blocking=false);
CAFFE2_API Tensor _cast_Short(const Tensor & self, bool non_blocking=false);
CAFFE2_API Tensor _cast_Half(const Tensor & self, bool non_blocking=false);
CAFFE2_API std::vector<Tensor> align_tensors(TensorList tensors);
CAFFE2_API bool _use_cudnn_ctc_loss(const Tensor & log_probs, const Tensor & targets, IntArrayRef input_lengths, IntArrayRef target_lengths, int64_t blank);
CAFFE2_API std::tuple<Tensor,Tensor> _cudnn_ctc_loss(const Tensor & log_probs, const Tensor & targets, IntArrayRef input_lengths, IntArrayRef target_lengths, int64_t blank, bool deterministic, bool zero_infinity);
CAFFE2_API bool _use_cudnn_rnn_flatten_weight();
CAFFE2_API Tensor _cudnn_rnn_flatten_weight(TensorList weight_arr, int64_t weight_stride0, int64_t input_size, int64_t mode, int64_t hidden_size, int64_t num_layers, bool batch_first, bool bidirectional);
CAFFE2_API std::tuple<Tensor,Tensor,Tensor,Tensor,Tensor> _cudnn_rnn(const Tensor & input, TensorList weight, int64_t weight_stride0, const Tensor & weight_buf, const Tensor & hx, const Tensor & cx, int64_t mode, int64_t hidden_size, int64_t num_layers, bool batch_first, double dropout, bool train, bool bidirectional, IntArrayRef batch_sizes, const Tensor & dropout_state);
CAFFE2_API std::tuple<Tensor,Tensor,Tensor,std::vector<Tensor>> _cudnn_rnn_backward(const Tensor & input, TensorList weight, int64_t weight_stride0, const Tensor & weight_buf, const Tensor & hx, const Tensor & cx, const Tensor & output, const Tensor & grad_output, const Tensor & grad_hy, const Tensor & grad_cy, int64_t mode, int64_t hidden_size, int64_t num_layers, bool batch_first, double dropout, bool train, bool bidirectional, IntArrayRef batch_sizes, const Tensor & dropout_state, const Tensor & reserve, std::array<bool,4> output_mask);
CAFFE2_API Tensor _cudnn_init_dropout_state(double dropout, bool train, int64_t dropout_seed, const TensorOptions & options);
CAFFE2_API int64_t _debug_has_internal_overlap(const Tensor & self);
CAFFE2_API std::tuple<Tensor,Tensor> _fused_dropout(const Tensor & self, double p, c10::optional<Generator> generator=c10::nullopt);
CAFFE2_API Tensor _masked_scale(const Tensor & self, const Tensor & mask, double scale);
CAFFE2_API std::tuple<Tensor,Tensor> _sobol_engine_draw(const Tensor & quasi, int64_t n, const Tensor & sobolstate, int64_t dimension, int64_t num_generated, c10::optional<ScalarType> dtype);
CAFFE2_API Tensor & _sobol_engine_ff_(Tensor & self, int64_t n, const Tensor & sobolstate, int64_t dimension, int64_t num_generated);
CAFFE2_API Tensor & _sobol_engine_scramble_(Tensor & self, const Tensor & ltm, int64_t dimension);
CAFFE2_API Tensor & _sobol_engine_initialize_state_(Tensor & self, int64_t dimension);
CAFFE2_API Tensor _reshape_from_tensor(const Tensor & self, const Tensor & shape);
CAFFE2_API Tensor _shape_as_tensor(const Tensor & self);
CAFFE2_API Tensor dropout(const Tensor & input, double p, bool train);
CAFFE2_API Tensor & dropout_(Tensor & self, double p, bool train);
CAFFE2_API Tensor feature_dropout(const Tensor & input, double p, bool train);
CAFFE2_API Tensor & feature_dropout_(Tensor & self, double p, bool train);
CAFFE2_API Tensor alpha_dropout(const Tensor & input, double p, bool train);
CAFFE2_API Tensor & alpha_dropout_(Tensor & self, double p, bool train);
CAFFE2_API Tensor feature_alpha_dropout(const Tensor & input, double p, bool train);
CAFFE2_API Tensor & feature_alpha_dropout_(Tensor & self, double p, bool train);
CAFFE2_API Tensor abs(const Tensor & self);
CAFFE2_API Tensor & abs_(Tensor & self);
CAFFE2_API Tensor & abs_out(Tensor & out, const Tensor & self);
CAFFE2_API Tensor absolute(const Tensor & self);
CAFFE2_API Tensor & absolute_(Tensor & self);
CAFFE2_API Tensor & absolute_out(Tensor & out, const Tensor & self);
CAFFE2_API Tensor angle(const Tensor & self);
CAFFE2_API Tensor & angle_out(Tensor & out, const Tensor & self);
CAFFE2_API Tensor view_as_real(const Tensor & self);
CAFFE2_API Tensor view_as_complex(const Tensor & self);
CAFFE2_API Tensor real(const Tensor & self);
CAFFE2_API Tensor imag(const Tensor & self);
CAFFE2_API Tensor conj(const Tensor & self);
CAFFE2_API Tensor & conj_out(Tensor & out, const Tensor & self);
CAFFE2_API Tensor acos(const Tensor & self);
CAFFE2_API Tensor & acos_(Tensor & self);
CAFFE2_API Tensor & acos_out(Tensor & out, const Tensor & self);
CAFFE2_API Tensor avg_pool1d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride={}, IntArrayRef padding=0, bool ceil_mode=false, bool count_include_pad=true);
CAFFE2_API Tensor adaptive_avg_pool1d(const Tensor & self, IntArrayRef output_size);
CAFFE2_API std::tuple<Tensor,Tensor> adaptive_max_pool1d(const Tensor & self, IntArrayRef output_size);
CAFFE2_API Tensor add(const Tensor & self, const Tensor & other, Scalar alpha=1);
CAFFE2_API Tensor & add_out(Tensor & out, const Tensor & self, const Tensor & other, Scalar alpha=1);
CAFFE2_API Tensor add(const Tensor & self, Scalar other, Scalar alpha=1);
CAFFE2_API Tensor addmv(const Tensor & self, const Tensor & mat, const Tensor & vec, Scalar beta=1, Scalar alpha=1);
CAFFE2_API Tensor & addmv_(Tensor & self, const Tensor & mat, const Tensor & vec, Scalar beta=1, Scalar alpha=1);
CAFFE2_API Tensor & addmv_out(Tensor & out, const Tensor & self, const Tensor & mat, const Tensor & vec, Scalar beta=1, Scalar alpha=1);
CAFFE2_API Tensor & _addmv_impl_(Tensor & self, const Tensor & self2, const Tensor & mat, const Tensor & vec, Scalar beta=1, Scalar alpha=1);
CAFFE2_API Tensor addr(const Tensor & self, const Tensor & vec1, const Tensor & vec2, Scalar beta=1, Scalar alpha=1);
CAFFE2_API Tensor & addr_out(Tensor & out, const Tensor & self, const Tensor & vec1, const Tensor & vec2, Scalar beta=1, Scalar alpha=1);
CAFFE2_API Tensor affine_grid_generator(const Tensor & theta, IntArrayRef size, bool align_corners);
CAFFE2_API Tensor affine_grid_generator_backward(const Tensor & grad, IntArrayRef size, bool align_corners);
CAFFE2_API Tensor all(const Tensor & self, int64_t dim, bool keepdim=false);
CAFFE2_API Tensor & all_out(Tensor & out, const Tensor & self, int64_t dim, bool keepdim=false);
CAFFE2_API Tensor all(const Tensor & self, Dimname dim, bool keepdim=false);
CAFFE2_API Tensor & all_out(Tensor & out, const Tensor & self, Dimname dim, bool keepdim=false);
CAFFE2_API bool allclose(const Tensor & self, const Tensor & other, double rtol=1e-05, double atol=1e-08, bool equal_nan=false);
CAFFE2_API Tensor any(const Tensor & self, int64_t dim, bool keepdim=false);
CAFFE2_API Tensor & any_out(Tensor & out, const Tensor & self, int64_t dim, bool keepdim=false);
CAFFE2_API Tensor any(const Tensor & self, Dimname dim, bool keepdim=false);
CAFFE2_API Tensor & any_out(Tensor & out, const Tensor & self, Dimname dim, bool keepdim=false);
CAFFE2_API Tensor arange(Scalar end, const TensorOptions & options={});
CAFFE2_API Tensor arange(Scalar start, Scalar end, const TensorOptions & options={});
CAFFE2_API Tensor arange(Scalar start, Scalar end, Scalar step, const TensorOptions & options={});
CAFFE2_API Tensor & arange_out(Tensor & out, Scalar end);
CAFFE2_API Tensor & arange_out(Tensor & out, Scalar start, Scalar end, Scalar step=1);
CAFFE2_API Tensor _dim_arange(const Tensor & like, int64_t dim);
CAFFE2_API Tensor argmax(const Tensor & self, c10::optional<int64_t> dim=c10::nullopt, bool keepdim=false);
CAFFE2_API Tensor argmin(const Tensor & self, c10::optional<int64_t> dim=c10::nullopt, bool keepdim=false);
CAFFE2_API Tensor acosh(const Tensor & self);
CAFFE2_API Tensor & acosh_(Tensor & self);
CAFFE2_API Tensor & acosh_out(Tensor & out, const Tensor & self);
CAFFE2_API Tensor asinh(const Tensor & self);
CAFFE2_API Tensor & asinh_(Tensor & self);
CAFFE2_API Tensor & asinh_out(Tensor & out, const Tensor & self);
CAFFE2_API Tensor atanh(const Tensor & self);
CAFFE2_API Tensor & atanh_(Tensor & self);
CAFFE2_API Tensor & atanh_out(Tensor & out, const Tensor & self);
CAFFE2_API Tensor as_strided(const Tensor & self, IntArrayRef size, IntArrayRef stride, c10::optional<int64_t> storage_offset=c10::nullopt);
CAFFE2_API Tensor & as_strided_(Tensor & self, IntArrayRef size, IntArrayRef stride, c10::optional<int64_t> storage_offset=c10::nullopt);
CAFFE2_API Tensor asin(const Tensor & self);
CAFFE2_API Tensor & asin_(Tensor & self);
CAFFE2_API Tensor & asin_out(Tensor & out, const Tensor & self);
CAFFE2_API Tensor atan(const Tensor & self);
CAFFE2_API Tensor & atan_(Tensor & self);
CAFFE2_API Tensor & atan_out(Tensor & out, const Tensor & self);
CAFFE2_API Tensor baddbmm(const Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta=1, Scalar alpha=1);
CAFFE2_API Tensor & _baddbmm_mkl_(Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta=1, Scalar alpha=1);
CAFFE2_API Tensor & baddbmm_out(Tensor & out, const Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta=1, Scalar alpha=1);
CAFFE2_API Tensor bartlett_window(int64_t window_length, const TensorOptions & options={});
CAFFE2_API Tensor bartlett_window(int64_t window_length, bool periodic, const TensorOptions & options={});
CAFFE2_API Tensor batch_norm(const Tensor & input, const Tensor & weight, const Tensor & bias, const Tensor & running_mean, const Tensor & running_var, bool training, double momentum, double eps, bool cudnn_enabled);
CAFFE2_API Tensor quantized_batch_norm(const Tensor & input, const Tensor & weight, const Tensor & bias, const Tensor & mean, const Tensor & var, double eps, double output_scale, int64_t output_zero_point);
CAFFE2_API std::tuple<Tensor,Tensor,Tensor,Tensor,int64_t> _batch_norm_impl_index(const Tensor & input, const Tensor & weight, const Tensor & bias, const Tensor & running_mean, const Tensor & running_var, bool training, double momentum, double eps, bool cudnn_enabled);
CAFFE2_API std::tuple<Tensor,Tensor,Tensor> _batch_norm_impl_index_backward(int64_t impl_index, const Tensor & input, const Tensor & grad_output, const Tensor & weight, const Tensor & running_mean, const Tensor & running_var, const Tensor & save_mean, const Tensor & save_var_transform, bool train, double eps, std::array<bool,3> output_mask, const Tensor & reservedSpace);
CAFFE2_API Tensor bernoulli(const Tensor & self, c10::optional<Generator> generator=c10::nullopt);
CAFFE2_API Tensor & bernoulli_out(Tensor & out, const Tensor & self, c10::optional<Generator> generator=c10::nullopt);
CAFFE2_API Tensor bernoulli(const Tensor & self, double p, c10::optional<Generator> generator=c10::nullopt);
CAFFE2_API Tensor bilinear(const Tensor & input1, const Tensor & input2, const Tensor & weight, const Tensor & bias);
CAFFE2_API Tensor binary_cross_entropy(const Tensor & self, const Tensor & target, const Tensor & weight={}, int64_t reduction=at::Reduction::Mean);
CAFFE2_API Tensor & binary_cross_entropy_out(Tensor & out, const Tensor & self, const Tensor & target, const Tensor & weight={}, int64_t reduction=at::Reduction::Mean);
CAFFE2_API Tensor binary_cross_entropy_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight={}, int64_t reduction=at::Reduction::Mean);
CAFFE2_API Tensor & binary_cross_entropy_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight={}, int64_t reduction=at::Reduction::Mean);
CAFFE2_API Tensor binary_cross_entropy_with_logits(const Tensor & self, const Tensor & target, const Tensor & weight={}, const Tensor & pos_weight={}, int64_t reduction=at::Reduction::Mean);
CAFFE2_API Tensor binary_cross_entropy_with_logits_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight={}, const Tensor & pos_weight={}, int64_t reduction=at::Reduction::Mean);
CAFFE2_API Tensor bincount(const Tensor & self, const Tensor & weights={}, int64_t minlength=0);
CAFFE2_API Tensor bitwise_not(const Tensor & self);
CAFFE2_API Tensor & bitwise_not_out(Tensor & out, const Tensor & self);
CAFFE2_API Tensor logical_not(const Tensor & self);
CAFFE2_API Tensor & logical_not_out(Tensor & out, const Tensor & self);
CAFFE2_API Tensor logical_xor(const Tensor & self, const Tensor & other);
CAFFE2_API Tensor & logical_xor_out(Tensor & out, const Tensor & self, const Tensor & other);
CAFFE2_API Tensor logical_and(const Tensor & self, const Tensor & other);
CAFFE2_API Tensor & logical_and_out(Tensor & out, const Tensor & self, const Tensor & other);
CAFFE2_API Tensor logical_or(const Tensor & self, const Tensor & other);
CAFFE2_API Tensor & logical_or_out(Tensor & out, const Tensor & self, const Tensor & other);
CAFFE2_API Tensor blackman_window(int64_t window_length, const TensorOptions & options={});
CAFFE2_API Tensor blackman_window(int64_t window_length, bool periodic, const TensorOptions & options={});
CAFFE2_API Tensor bmm(const Tensor & self, const Tensor & mat2);
CAFFE2_API Tensor _bmm(const Tensor & self, const Tensor & mat2, bool deterministic=false);
CAFFE2_API Tensor & bmm_out(Tensor & out, const Tensor & self, const Tensor & mat2);
CAFFE2_API Tensor & _bmm_out(Tensor & out, const Tensor & self, const Tensor & mat2, bool deterministic=false);
CAFFE2_API std::vector<Tensor> broadcast_tensors(TensorList tensors);
CAFFE2_API Tensor cat(TensorList tensors, int64_t dim=0);
CAFFE2_API Tensor & cat_out(Tensor & out, TensorList tensors, int64_t dim=0);
CAFFE2_API Tensor cat(TensorList tensors, Dimname dim);
CAFFE2_API Tensor & cat_out(Tensor & out, TensorList tensors, Dimname dim);
CAFFE2_API Tensor block_diag(TensorList tensors);
CAFFE2_API Tensor ceil(const Tensor & self);
CAFFE2_API Tensor & ceil_(Tensor & self);
CAFFE2_API Tensor & ceil_out(Tensor & out, const Tensor & self);
CAFFE2_API Tensor chain_matmul(TensorList matrices);
CAFFE2_API std::vector<Tensor> chunk(const Tensor & self, int64_t chunks, int64_t dim=0);
CAFFE2_API Tensor clamp(const Tensor & self, c10::optional<Scalar> min=c10::nullopt, c10::optional<Scalar> max=c10::nullopt);
CAFFE2_API Tensor & clamp_(Tensor & self, c10::optional<Scalar> min=c10::nullopt, c10::optional<Scalar> max=c10::nullopt);
CAFFE2_API Tensor & clamp_out(Tensor & out, const Tensor & self, c10::optional<Scalar> min=c10::nullopt, c10::optional<Scalar> max=c10::nullopt);
CAFFE2_API Tensor clamp_max(const Tensor & self, Scalar max);
CAFFE2_API Tensor & clamp_max_(Tensor & self, Scalar max);
CAFFE2_API Tensor & clamp_max_out(Tensor & out, const Tensor & self, Scalar max);
CAFFE2_API Tensor clamp_min(const Tensor & self, Scalar min);
CAFFE2_API Tensor & clamp_min_(Tensor & self, Scalar min);
CAFFE2_API Tensor & clamp_min_out(Tensor & out, const Tensor & self, Scalar min);
CAFFE2_API bool cudnn_is_acceptable(const Tensor & self);
CAFFE2_API Tensor constant_pad_nd(const Tensor & self, IntArrayRef pad, Scalar value=0);
CAFFE2_API Tensor convolution(const Tensor & input, const Tensor & weight, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool transposed, IntArrayRef output_padding, int64_t groups);
CAFFE2_API Tensor convolution_overrideable(const Tensor & input, const Tensor & weight, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool transposed, IntArrayRef output_padding, int64_t groups);
CAFFE2_API std::tuple<Tensor,Tensor,Tensor> convolution_backward_overrideable(const Tensor & grad_output, const Tensor & input, const Tensor & weight, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool transposed, IntArrayRef output_padding, int64_t groups, std::array<bool,3> output_mask);
CAFFE2_API Tensor _convolution(const Tensor & input, const Tensor & weight, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool transposed, IntArrayRef output_padding, int64_t groups, bool benchmark, bool deterministic, bool cudnn_enabled);
CAFFE2_API Tensor _convolution_nogroup(const Tensor & input, const Tensor & weight, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool transposed, IntArrayRef output_padding);
CAFFE2_API std::tuple<Tensor,Tensor,Tensor> _convolution_double_backward(const Tensor & ggI, const Tensor & ggW, const Tensor & ggb, const Tensor & gO, const Tensor & weight, const Tensor & self, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool transposed, IntArrayRef output_padding, int64_t groups, bool benchmark, bool deterministic, bool cudnn_enabled, std::array<bool,3> output_mask);
CAFFE2_API Tensor conv1d(const Tensor & input, const Tensor & weight, const Tensor & bias={}, IntArrayRef stride=1, IntArrayRef padding=0, IntArrayRef dilation=1, int64_t groups=1);
CAFFE2_API Tensor conv2d(const Tensor & input, const Tensor & weight, const Tensor & bias={}, IntArrayRef stride=1, IntArrayRef padding=0, IntArrayRef dilation=1, int64_t groups=1);
CAFFE2_API Tensor conv3d(const Tensor & input, const Tensor & weight, const Tensor & bias={}, IntArrayRef stride=1, IntArrayRef padding=0, IntArrayRef dilation=1, int64_t groups=1);
CAFFE2_API Tensor conv_tbc(const Tensor & self, const Tensor & weight, const Tensor & bias, int64_t pad=0);
CAFFE2_API std::tuple<Tensor,Tensor,Tensor> conv_tbc_backward(const Tensor & self, const Tensor & input, const Tensor & weight, const Tensor & bias, int64_t pad);
CAFFE2_API Tensor conv_transpose1d(const Tensor & input, const Tensor & weight, const Tensor & bias={}, IntArrayRef stride=1, IntArrayRef padding=0, IntArrayRef output_padding=0, int64_t groups=1, IntArrayRef dilation=1);
CAFFE2_API Tensor conv_transpose2d(const Tensor & input, const Tensor & weight, const Tensor & bias={}, IntArrayRef stride=1, IntArrayRef padding=0, IntArrayRef output_padding=0, int64_t groups=1, IntArrayRef dilation=1);
CAFFE2_API Tensor conv_transpose3d(const Tensor & input, const Tensor & weight, const Tensor & bias={}, IntArrayRef stride=1, IntArrayRef padding=0, IntArrayRef output_padding=0, int64_t groups=1, IntArrayRef dilation=1);
CAFFE2_API Tensor _copy_from(const Tensor & self, const Tensor & dst, bool non_blocking=false);
CAFFE2_API Tensor cos(const Tensor & self);
CAFFE2_API Tensor & cos_(Tensor & self);
CAFFE2_API Tensor & cos_out(Tensor & out, const Tensor & self);
CAFFE2_API Tensor cosh(const Tensor & self);
CAFFE2_API Tensor & cosh_(Tensor & self);
CAFFE2_API Tensor & cosh_out(Tensor & out, const Tensor & self);
CAFFE2_API Tensor cosine_embedding_loss(const Tensor & input1, const Tensor & input2, const Tensor & target, double margin=0.0, int64_t reduction=at::Reduction::Mean);
CAFFE2_API Tensor cudnn_affine_grid_generator(const Tensor & theta, int64_t N, int64_t C, int64_t H, int64_t W);
CAFFE2_API Tensor cudnn_affine_grid_generator_backward(const Tensor & grad, int64_t N, int64_t C, int64_t H, int64_t W);
CAFFE2_API std::tuple<Tensor,Tensor,Tensor,Tensor> cudnn_batch_norm(const Tensor & input, const Tensor & weight, const Tensor & bias, const Tensor & running_mean, const Tensor & running_var, bool training, double exponential_average_factor, double epsilon);
CAFFE2_API std::tuple<Tensor,Tensor,Tensor> cudnn_batch_norm_backward(const Tensor & input, const Tensor & grad_output, const Tensor & weight, const Tensor & running_mean, const Tensor & running_var, const Tensor & save_mean, const Tensor & save_var, double epsilon, const Tensor & reserveSpace);
CAFFE2_API Tensor cudnn_convolution(const Tensor & self, const Tensor & weight, const Tensor & bias, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic);
CAFFE2_API Tensor cudnn_convolution(const Tensor & self, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic);
CAFFE2_API Tensor cudnn_convolution_backward_input(IntArrayRef self_size, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic);
CAFFE2_API std::tuple<Tensor,Tensor> cudnn_convolution_backward(const Tensor & self, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic, std::array<bool,2> output_mask);
CAFFE2_API Tensor cudnn_convolution_backward_weight(IntArrayRef weight_size, const Tensor & grad_output, const Tensor & self, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic);
CAFFE2_API Tensor cudnn_convolution_transpose(const Tensor & self, const Tensor & weight, const Tensor & bias, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic);
CAFFE2_API Tensor cudnn_convolution_transpose(const Tensor & self, const Tensor & weight, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic);
CAFFE2_API std::tuple<Tensor,Tensor> cudnn_convolution_transpose_backward(const Tensor & self, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic, std::array<bool,2> output_mask);
CAFFE2_API Tensor cudnn_convolution_transpose_backward_input(const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic);
CAFFE2_API Tensor cudnn_convolution_transpose_backward_weight(IntArrayRef weight_size, const Tensor & grad_output, const Tensor & self, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic);
CAFFE2_API Tensor cudnn_grid_sampler(const Tensor & self, const Tensor & grid);
CAFFE2_API std::tuple<Tensor,Tensor> cudnn_grid_sampler_backward(const Tensor & self, const Tensor & grid, const Tensor & grad_output);
CAFFE2_API std::tuple<Tensor,Tensor> cummax(const Tensor & self, int64_t dim);
CAFFE2_API std::tuple<Tensor &,Tensor &> cummax_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t dim);
CAFFE2_API std::tuple<Tensor,Tensor> cummax(const Tensor & self, Dimname dim);
CAFFE2_API std::tuple<Tensor &,Tensor &> cummax_out(Tensor & values, Tensor & indices, const Tensor & self, Dimname dim);
CAFFE2_API void _cummax_helper(const Tensor & self, Tensor & values, Tensor & indices, int64_t dim);
CAFFE2_API std::tuple<Tensor,Tensor> cummin(const Tensor & self, int64_t dim);
CAFFE2_API std::tuple<Tensor &,Tensor &> cummin_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t dim);
CAFFE2_API std::tuple<Tensor,Tensor> cummin(const Tensor & self, Dimname dim);
CAFFE2_API std::tuple<Tensor &,Tensor &> cummin_out(Tensor & values, Tensor & indices, const Tensor & self, Dimname dim);
CAFFE2_API void _cummin_helper(const Tensor & self, Tensor & values, Tensor & indices, int64_t dim);
CAFFE2_API Tensor cumprod(const Tensor & self, int64_t dim, c10::optional<ScalarType> dtype=c10::nullopt);
CAFFE2_API Tensor & cumprod_out(Tensor & out, const Tensor & self, int64_t dim, c10::optional<ScalarType> dtype=c10::nullopt);
CAFFE2_API Tensor cumprod(const Tensor & self, Dimname dim, c10::optional<ScalarType> dtype=c10::nullopt);
CAFFE2_API Tensor & cumprod_out(Tensor & out, const Tensor & self, Dimname dim, c10::optional<ScalarType> dtype=c10::nullopt);
CAFFE2_API Tensor cumsum(const Tensor & self, int64_t dim, c10::optional<ScalarType> dtype=c10::nullopt);
CAFFE2_API Tensor & cumsum_out(Tensor & out, const Tensor & self, int64_t dim, c10::optional<ScalarType> dtype=c10::nullopt);
CAFFE2_API Tensor cumsum(const Tensor & self, Dimname dim, c10::optional<ScalarType> dtype=c10::nullopt);
CAFFE2_API Tensor & cumsum_out(Tensor & out, const Tensor & self, Dimname dim, c10::optional<ScalarType> dtype=c10::nullopt);
CAFFE2_API Tensor ctc_loss(const Tensor & log_probs, const Tensor & targets, IntArrayRef input_lengths, IntArrayRef target_lengths, int64_t blank=0, int64_t reduction=at::Reduction::Mean, bool zero_infinity=false);
CAFFE2_API Tensor ctc_loss(const Tensor & log_probs, const Tensor & targets, const Tensor & input_lengths, const Tensor & target_lengths, int64_t blank=0, int64_t reduction=at::Reduction::Mean, bool zero_infinity=false);
CAFFE2_API std::tuple<Tensor,Tensor> _ctc_loss(const Tensor & log_probs, const Tensor & targets, IntArrayRef input_lengths, IntArrayRef target_lengths, int64_t blank=0, bool zero_infinity=false);
CAFFE2_API Tensor _ctc_loss_backward(const Tensor & grad, const Tensor & log_probs, const Tensor & targets, IntArrayRef input_lengths, IntArrayRef target_lengths, const Tensor & neg_log_likelihood, const Tensor & log_alpha, int64_t blank, bool zero_infinity=false);
CAFFE2_API Tensor det(const Tensor & self);
CAFFE2_API Tensor diag_embed(const Tensor & self, int64_t offset=0, int64_t dim1=-2, int64_t dim2=-1);
CAFFE2_API Tensor diagflat(const Tensor & self, int64_t offset=0);
CAFFE2_API Tensor diagonal(const Tensor & self, int64_t offset=0, int64_t dim1=0, int64_t dim2=1);
CAFFE2_API Tensor diagonal(const Tensor & self, Dimname outdim, Dimname dim1, Dimname dim2, int64_t offset=0);
CAFFE2_API Tensor div(const Tensor & self, const Tensor & other);
CAFFE2_API Tensor & div_out(Tensor & out, const Tensor & self, const Tensor & other);
CAFFE2_API Tensor div(const Tensor & self, Scalar other);
CAFFE2_API Tensor dot(const Tensor & self, const Tensor & tensor);
CAFFE2_API Tensor & dot_out(Tensor & out, const Tensor & self, const Tensor & tensor);
CAFFE2_API Tensor einsum(std::string equation, TensorList tensors);
CAFFE2_API Tensor embedding(const Tensor & weight, const Tensor & indices, int64_t padding_idx=-1, bool scale_grad_by_freq=false, bool sparse=false);
CAFFE2_API Tensor embedding_backward(const Tensor & grad, const Tensor & indices, int64_t num_weights, int64_t padding_idx, bool scale_grad_by_freq, bool sparse);
CAFFE2_API Tensor embedding_dense_backward(const Tensor & grad_output, const Tensor & indices, int64_t num_weights, int64_t padding_idx, bool scale_grad_by_freq);
CAFFE2_API Tensor & embedding_renorm_(Tensor & self, const Tensor & indices, double max_norm, double norm_type);
CAFFE2_API Tensor embedding_sparse_backward(const Tensor & grad, const Tensor & indices, int64_t num_weights, int64_t padding_idx, bool scale_grad_by_freq);
CAFFE2_API std::tuple<Tensor,Tensor,Tensor,Tensor> embedding_bag(const Tensor & weight, const Tensor & indices, const Tensor & offsets, bool scale_grad_by_freq=false, int64_t mode=0, bool sparse=false, const Tensor & per_sample_weights={}, bool include_last_offset=false);
CAFFE2_API std::tuple<Tensor,Tensor,Tensor,Tensor> _embedding_bag(const Tensor & weight, const Tensor & indices, const Tensor & offsets, bool scale_grad_by_freq=false, int64_t mode=0, bool sparse=false, const Tensor & per_sample_weights={}, bool include_last_offset=false);
CAFFE2_API Tensor _embedding_bag_backward(const Tensor & grad, const Tensor & indices, const Tensor & offsets, const Tensor & offset2bag, const Tensor & bag_size, const Tensor & maximum_indices, int64_t num_weights, bool scale_grad_by_freq, int64_t mode, bool sparse, const Tensor & per_sample_weights);
CAFFE2_API Tensor _embedding_bag_sparse_backward(const Tensor & grad, const Tensor & indices, const Tensor & offsets, const Tensor & offset2bag, const Tensor & bag_size, int64_t num_weights, bool scale_grad_by_freq, int64_t mode, const Tensor & per_sample_weights);
CAFFE2_API Tensor _embedding_bag_dense_backward(const Tensor & grad, const Tensor & indices, const Tensor & offsets, const Tensor & offset2bag, const Tensor & bag_size, const Tensor & maximum_indices, int64_t num_weights, bool scale_grad_by_freq, int64_t mode, const Tensor & per_sample_weights);
CAFFE2_API Tensor _embedding_bag_per_sample_weights_backward(const Tensor & grad, const Tensor & weight, const Tensor & indices, const Tensor & offsets, const Tensor & offset2bag, int64_t mode);
CAFFE2_API Tensor empty_meta(IntArrayRef size, const TensorOptions & options={}, c10::optional<MemoryFormat> memory_format=c10::nullopt);
CAFFE2_API Tensor empty(IntArrayRef size, c10::optional<DimnameList> names, const TensorOptions & options={}, c10::optional<MemoryFormat> memory_format=c10::nullopt);
CAFFE2_API Tensor empty(IntArrayRef size, const TensorOptions & options={}, c10::optional<MemoryFormat> memory_format=c10::nullopt);
CAFFE2_API Tensor _empty_affine_quantized(IntArrayRef size, const TensorOptions & options={}, double scale=1, int64_t zero_point=0, c10::optional<MemoryFormat> memory_format=MemoryFormat::Contiguous);
CAFFE2_API Tensor _empty_per_channel_affine_quantized(IntArrayRef size, const Tensor & scales, const Tensor & zero_points, int64_t axis, const TensorOptions & options={}, c10::optional<MemoryFormat> memory_format=MemoryFormat::Contiguous);
CAFFE2_API Tensor empty_quantized(IntArrayRef size, const Tensor & qtensor);
CAFFE2_API Tensor & empty_out(Tensor & out, IntArrayRef size, c10::optional<MemoryFormat> memory_format=c10::nullopt);
CAFFE2_API Tensor empty_like(const Tensor & self, const TensorOptions & options={}, c10::optional<MemoryFormat> memory_format=c10::nullopt);
CAFFE2_API Tensor empty_strided(IntArrayRef size, IntArrayRef stride, const TensorOptions & options={});
CAFFE2_API Tensor erf(const Tensor & self);
CAFFE2_API Tensor & erf_(Tensor & self);
CAFFE2_API Tensor & erf_out(Tensor & out, const Tensor & self);
CAFFE2_API Tensor erfc(const Tensor & self);
CAFFE2_API Tensor & erfc_(Tensor & self);
CAFFE2_API Tensor & erfc_out(Tensor & out, const Tensor & self);
CAFFE2_API Tensor exp(const Tensor & self);
CAFFE2_API Tensor & exp_(Tensor & self);
CAFFE2_API Tensor & exp_out(Tensor & out, const Tensor & self);
CAFFE2_API Tensor expm1(const Tensor & self);
CAFFE2_API Tensor & expm1_(Tensor & self);
CAFFE2_API Tensor & expm1_out(Tensor & out, const Tensor & self);
CAFFE2_API Tensor eye(int64_t n, const TensorOptions & options={});
CAFFE2_API Tensor eye(int64_t n, int64_t m, const TensorOptions & options={});
CAFFE2_API Tensor & eye_out(Tensor & out, int64_t n);
CAFFE2_API Tensor & eye_out(Tensor & out, int64_t n, int64_t m);
CAFFE2_API Tensor flatten(const Tensor & self, int64_t start_dim=0, int64_t end_dim=-1);
CAFFE2_API Tensor flatten(const Tensor & self, int64_t start_dim, int64_t end_dim, Dimname out_dim);
CAFFE2_API Tensor flatten(const Tensor & self, Dimname start_dim, Dimname end_dim, Dimname out_dim);
CAFFE2_API Tensor flatten(const Tensor & self, DimnameList dims, Dimname out_dim);
CAFFE2_API Tensor & fill_(Tensor & self, Scalar value);
CAFFE2_API Tensor & fill_(Tensor & self, const Tensor & value);
CAFFE2_API Tensor floor(const Tensor & self);
CAFFE2_API Tensor & floor_(Tensor & self);
CAFFE2_API Tensor & floor_out(Tensor & out, const Tensor & self);
CAFFE2_API Tensor floor_divide(const Tensor & self, const Tensor & other);
CAFFE2_API Tensor & floor_divide_out(Tensor & out, const Tensor & self, const Tensor & other);
CAFFE2_API Tensor floor_divide(const Tensor & self, Scalar other);
CAFFE2_API Tensor frac(const Tensor & self);
CAFFE2_API Tensor & frac_(Tensor & self);
CAFFE2_API Tensor & frac_out(Tensor & out, const Tensor & self);
CAFFE2_API Tensor full(IntArrayRef size, Scalar fill_value, c10::optional<DimnameList> names, const TensorOptions & options={});
CAFFE2_API Tensor full(IntArrayRef size, Scalar fill_value, const TensorOptions & options={});
CAFFE2_API Tensor & full_out(Tensor & out, IntArrayRef size, Scalar fill_value);
CAFFE2_API Tensor full_like(const Tensor & self, Scalar fill_value, const TensorOptions & options={}, c10::optional<MemoryFormat> memory_format=c10::nullopt);
CAFFE2_API Tensor from_file(std::string filename, c10::optional<bool> shared=c10::nullopt, c10::optional<int64_t> size=0, const TensorOptions & options={});
CAFFE2_API Tensor grid_sampler(const Tensor & input, const Tensor & grid, int64_t interpolation_mode, int64_t padding_mode, bool align_corners);
CAFFE2_API Tensor grid_sampler_2d(const Tensor & input, const Tensor & grid, int64_t interpolation_mode, int64_t padding_mode, bool align_corners);
CAFFE2_API std::tuple<Tensor,Tensor> grid_sampler_2d_backward(const Tensor & grad_output, const Tensor & input, const Tensor & grid, int64_t interpolation_mode, int64_t padding_mode, bool align_corners);
CAFFE2_API Tensor grid_sampler_3d(const Tensor & input, const Tensor & grid, int64_t interpolation_mode, int64_t padding_mode, bool align_corners);
CAFFE2_API std::tuple<Tensor,Tensor> grid_sampler_3d_backward(const Tensor & grad_output, const Tensor & input, const Tensor & grid, int64_t interpolation_mode, int64_t padding_mode, bool align_corners);
CAFFE2_API Tensor hann_window(int64_t window_length, const TensorOptions & options={});
CAFFE2_API Tensor hann_window(int64_t window_length, bool periodic, const TensorOptions & options={});
CAFFE2_API Tensor hamming_window(int64_t window_length, const TensorOptions & options={});
CAFFE2_API Tensor hamming_window(int64_t window_length, bool periodic, const TensorOptions & options={});
CAFFE2_API Tensor hamming_window(int64_t window_length, bool periodic, double alpha, const TensorOptions & options={});
CAFFE2_API Tensor hamming_window(int64_t window_length, bool periodic, double alpha, double beta, const TensorOptions & options={});
CAFFE2_API Tensor hinge_embedding_loss(const Tensor & self, const Tensor & target, double margin=1.0, int64_t reduction=at::Reduction::Mean);
CAFFE2_API Tensor ger(const Tensor & self, const Tensor & vec2);
CAFFE2_API Tensor & ger_out(Tensor & out, const Tensor & self, const Tensor & vec2);
CAFFE2_API Tensor group_norm(const Tensor & input, int64_t num_groups, const Tensor & weight={}, const Tensor & bias={}, double eps=1e-05, bool cudnn_enabled=true);
CAFFE2_API std::tuple<Tensor,Tensor,Tensor> native_group_norm(const Tensor & input, const Tensor & weight, const Tensor & bias, int64_t N, int64_t C, int64_t HxW, int64_t group, double eps);
CAFFE2_API std::tuple<Tensor,Tensor,Tensor> native_group_norm_backward(const Tensor & grad_out, const Tensor & input, const Tensor & mean, const Tensor & rstd, const Tensor & weight, int64_t N, int64_t C, int64_t HxW, int64_t group, std::array<bool,3> output_mask);
CAFFE2_API Tensor fft(const Tensor & self, int64_t signal_ndim, bool normalized=false);
CAFFE2_API Tensor ifft(const Tensor & self, int64_t signal_ndim, bool normalized=false);
CAFFE2_API Tensor rfft(const Tensor & self, int64_t signal_ndim, bool normalized=false, bool onesided=true);
CAFFE2_API Tensor irfft(const Tensor & self, int64_t signal_ndim, bool normalized=false, bool onesided=true, IntArrayRef signal_sizes={});
CAFFE2_API Tensor _fft_with_size(const Tensor & self, int64_t signal_ndim, bool complex_input, bool complex_output, bool inverse, IntArrayRef checked_signal_sizes, bool normalized, bool onesided, IntArrayRef output_sizes);
CAFFE2_API int64_t _cufft_get_plan_cache_size(int64_t device_index);
CAFFE2_API int64_t _cufft_get_plan_cache_max_size(int64_t device_index);
CAFFE2_API void _cufft_set_plan_cache_max_size(int64_t device_index, int64_t max_size);
CAFFE2_API void _cufft_clear_plan_cache(int64_t device_index);
CAFFE2_API Tensor index(const Tensor & self, TensorList indices);
CAFFE2_API Tensor index_copy(const Tensor & self, int64_t dim, const Tensor & index, const Tensor & source);
CAFFE2_API Tensor index_copy(const Tensor & self, Dimname dim, const Tensor & index, const Tensor & source);
CAFFE2_API Tensor & index_put_(Tensor & self, TensorList indices, const Tensor & values, bool accumulate=false);
CAFFE2_API Tensor index_put(const Tensor & self, TensorList indices, const Tensor & values, bool accumulate=false);
CAFFE2_API Tensor & _index_put_impl_(Tensor & self, TensorList indices, const Tensor & values, bool accumulate=false, bool unsafe=false);
CAFFE2_API Tensor instance_norm(const Tensor & input, const Tensor & weight, const Tensor & bias, const Tensor & running_mean, const Tensor & running_var, bool use_input_stats, double momentum, double eps, bool cudnn_enabled);
CAFFE2_API Tensor inverse(const Tensor & self);
CAFFE2_API Tensor & inverse_out(Tensor & out, const Tensor & self);
CAFFE2_API Tensor _inverse_helper(const Tensor & self);
CAFFE2_API Tensor isclose(const Tensor & self, const Tensor & other, double rtol=1e-05, double atol=1e-08, bool equal_nan=false);
CAFFE2_API Tensor isnan(const Tensor & self);
CAFFE2_API bool is_distributed(const Tensor & self);
CAFFE2_API bool is_floating_point(const Tensor & self);
CAFFE2_API bool is_complex(const Tensor & self);
CAFFE2_API bool is_nonzero(const Tensor & self);
CAFFE2_API bool is_same_size(const Tensor & self, const Tensor & other);
CAFFE2_API bool is_signed(const Tensor & self);
CAFFE2_API Tensor kl_div(const Tensor & self, const Tensor & target, int64_t reduction=at::Reduction::Mean, bool log_target=false);
CAFFE2_API Tensor kl_div_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction=at::Reduction::Mean, bool log_target=false);
CAFFE2_API std::tuple<Tensor,Tensor> kthvalue(const Tensor & self, int64_t k, int64_t dim=-1, bool keepdim=false);
CAFFE2_API std::tuple<Tensor &,Tensor &> kthvalue_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t k, int64_t dim=-1, bool keepdim=false);
CAFFE2_API std::tuple<Tensor,Tensor> kthvalue(const Tensor & self, int64_t k, Dimname dim, bool keepdim=false);
CAFFE2_API std::tuple<Tensor &,Tensor &> kthvalue_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t k, Dimname dim, bool keepdim=false);
CAFFE2_API Tensor layer_norm(const Tensor & input, IntArrayRef normalized_shape, const Tensor & weight={}, const Tensor & bias={}, double eps=1e-05, bool cudnn_enable=true);
CAFFE2_API std::tuple<Tensor,Tensor,Tensor> native_layer_norm(const Tensor & input, const Tensor & weight, const Tensor & bias, int64_t M, int64_t N, double eps);
CAFFE2_API std::tuple<Tensor,Tensor,Tensor> native_layer_norm_backward(const Tensor & grad_out, const Tensor & input, const Tensor & mean, const Tensor & rstd, const Tensor & weight, int64_t M, int64_t N, std::array<bool,3> output_mask);
CAFFE2_API Tensor linear(const Tensor & input, const Tensor & weight, const Tensor & bias={});
CAFFE2_API Tensor mkldnn_linear(const Tensor & input, const Tensor & weight, const Tensor & bias={});
CAFFE2_API Tensor fbgemm_linear_int8_weight_fp32_activation(const Tensor & input, const Tensor & weight, const Tensor & packed, const Tensor & col_offsets, Scalar weight_scale, Scalar weight_zero_point, const Tensor & bias);
CAFFE2_API Tensor fbgemm_linear_int8_weight(const Tensor & input, const Tensor & weight, const Tensor & packed, const Tensor & col_offsets, Scalar weight_scale, Scalar weight_zero_point, const Tensor & bias);
CAFFE2_API std::tuple<Tensor,Tensor,double,int64_t> fbgemm_linear_quantize_weight(const Tensor & input);
CAFFE2_API Tensor fbgemm_pack_gemm_matrix_fp16(const Tensor & input);
CAFFE2_API Tensor fbgemm_linear_fp16_weight_fp32_activation(const Tensor & input, const Tensor & packed_weight, const Tensor & bias);
CAFFE2_API Tensor fbgemm_linear_fp16_weight(const Tensor & input, const Tensor & packed_weight, const Tensor & bias);
CAFFE2_API Tensor fbgemm_pack_quantized_matrix(const Tensor & input);
CAFFE2_API Tensor fbgemm_pack_quantized_matrix(const Tensor & input, int64_t K, int64_t N);
CAFFE2_API Tensor linspace(Scalar start, Scalar end, int64_t steps=100, const TensorOptions & options={});
CAFFE2_API Tensor & linspace_out(Tensor & out, Scalar start, Scalar end, int64_t steps=100);
CAFFE2_API Tensor log(const Tensor & self);
CAFFE2_API Tensor & log_(Tensor & self);
CAFFE2_API Tensor & log_out(Tensor & out, const Tensor & self);
CAFFE2_API Tensor log10(const Tensor & self);
CAFFE2_API Tensor & log10_(Tensor & self);
CAFFE2_API Tensor & log10_out(Tensor & out, const Tensor & self);
CAFFE2_API Tensor log1p(const Tensor & self);
CAFFE2_API Tensor & log1p_(Tensor & self);
CAFFE2_API Tensor & log1p_out(Tensor & out, const Tensor & self);
CAFFE2_API Tensor log2(const Tensor & self);
CAFFE2_API Tensor & log2_(Tensor & self);
CAFFE2_API Tensor & log2_out(Tensor & out, const Tensor & self);
CAFFE2_API Tensor & logaddexp_out(Tensor & out, const Tensor & self, const Tensor & other);
CAFFE2_API Tensor logaddexp(const Tensor & self, const Tensor & other);
CAFFE2_API Tensor & logaddexp2_out(Tensor & out, const Tensor & self, const Tensor & other);
CAFFE2_API Tensor logaddexp2(const Tensor & self, const Tensor & other);
CAFFE2_API Tensor logdet(const Tensor & self);
CAFFE2_API Tensor logspace(Scalar start, Scalar end, int64_t steps=100, double base=10.0, const TensorOptions & options={});
CAFFE2_API Tensor & logspace_out(Tensor & out, Scalar start, Scalar end, int64_t steps=100, double base=10.0);
CAFFE2_API Tensor log_softmax(const Tensor & self, int64_t dim, c10::optional<ScalarType> dtype=c10::nullopt);
CAFFE2_API Tensor log_softmax(const Tensor & self, Dimname dim, c10::optional<ScalarType> dtype=c10::nullopt);
CAFFE2_API Tensor _log_softmax(const Tensor & self, int64_t dim, bool half_to_float);
CAFFE2_API Tensor _log_softmax_backward_data(const Tensor & grad_output, const Tensor & output, int64_t dim, const Tensor & self);
CAFFE2_API Tensor _logcumsumexp(const Tensor & self, int64_t dim);
CAFFE2_API Tensor & _logcumsumexp_out(Tensor & out, const Tensor & self, int64_t dim);
CAFFE2_API Tensor logcumsumexp(const Tensor & self, int64_t dim);
CAFFE2_API Tensor & logcumsumexp_out(Tensor & out, const Tensor & self, int64_t dim);
CAFFE2_API Tensor logcumsumexp(const Tensor & self, Dimname dim);
CAFFE2_API Tensor & logcumsumexp_out(Tensor & out, const Tensor & self, Dimname dim);
CAFFE2_API Tensor logsumexp(const Tensor & self, IntArrayRef dim, bool keepdim=false);
CAFFE2_API Tensor & logsumexp_out(Tensor & out, const Tensor & self, IntArrayRef dim, bool keepdim=false);
CAFFE2_API Tensor logsumexp(const Tensor & self, DimnameList dim, bool keepdim=false);
CAFFE2_API Tensor & logsumexp_out(Tensor & out, const Tensor & self, DimnameList dim, bool keepdim=false);
CAFFE2_API Tensor margin_ranking_loss(const Tensor & input1, const Tensor & input2, const Tensor & target, double margin=0.0, int64_t reduction=at::Reduction::Mean);
CAFFE2_API Tensor matmul(const Tensor & self, const Tensor & other);
CAFFE2_API Tensor & matmul_out(Tensor & out, const Tensor & self, const Tensor & other);
CAFFE2_API Tensor matrix_rank(const Tensor & self, double tol, bool symmetric=false);
CAFFE2_API Tensor matrix_rank(const Tensor & self, bool symmetric=false);
CAFFE2_API Tensor matrix_power(const Tensor & self, int64_t n);
CAFFE2_API std::tuple<Tensor,Tensor> max(const Tensor & self, int64_t dim, bool keepdim=false);
CAFFE2_API std::tuple<Tensor &,Tensor &> max_out(Tensor & max, Tensor & max_values, const Tensor & self, int64_t dim, bool keepdim=false);
CAFFE2_API Tensor max_values(const Tensor & self, IntArrayRef dim, bool keepdim=false);
CAFFE2_API std::tuple<Tensor,Tensor> max(const Tensor & self, Dimname dim, bool keepdim=false);
CAFFE2_API std::tuple<Tensor &,Tensor &> max_out(Tensor & max, Tensor & max_values, const Tensor & self, Dimname dim, bool keepdim=false);
CAFFE2_API Tensor max_values(const Tensor & self, DimnameList dim, bool keepdim=false);
CAFFE2_API std::tuple<Tensor,Tensor> max_pool1d_with_indices(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride={}, IntArrayRef padding=0, IntArrayRef dilation=1, bool ceil_mode=false);
CAFFE2_API Tensor max_pool1d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride={}, IntArrayRef padding=0, IntArrayRef dilation=1, bool ceil_mode=false);
CAFFE2_API Tensor max_pool2d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride={}, IntArrayRef padding=0, IntArrayRef dilation=1, bool ceil_mode=false);
CAFFE2_API Tensor mkldnn_max_pool2d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride={}, IntArrayRef padding=0, IntArrayRef dilation=1, bool ceil_mode=false);
CAFFE2_API Tensor quantized_max_pool2d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride={}, IntArrayRef padding=0, IntArrayRef dilation=1, bool ceil_mode=false);
CAFFE2_API Tensor max_pool3d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride={}, IntArrayRef padding=0, IntArrayRef dilation=1, bool ceil_mode=false);
CAFFE2_API Tensor mean(const Tensor & self, c10::optional<ScalarType> dtype=c10::nullopt);
CAFFE2_API Tensor mean(const Tensor & self, IntArrayRef dim, bool keepdim=false, c10::optional<ScalarType> dtype=c10::nullopt);
CAFFE2_API Tensor & mean_out(Tensor & out, const Tensor & self, IntArrayRef dim, bool keepdim=false, c10::optional<ScalarType> dtype=c10::nullopt);
CAFFE2_API Tensor mean(const Tensor & self, DimnameList dim, bool keepdim=false, c10::optional<ScalarType> dtype=c10::nullopt);
CAFFE2_API Tensor & mean_out(Tensor & out, const Tensor & self, DimnameList dim, bool keepdim=false, c10::optional<ScalarType> dtype=c10::nullopt);
CAFFE2_API std::tuple<Tensor,Tensor> median(const Tensor & self, int64_t dim, bool keepdim=false);
CAFFE2_API std::tuple<Tensor &,Tensor &> median_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t dim, bool keepdim=false);
CAFFE2_API std::tuple<Tensor,Tensor> median(const Tensor & self, Dimname dim, bool keepdim=false);
CAFFE2_API std::tuple<Tensor &,Tensor &> median_out(Tensor & values, Tensor & indices, const Tensor & self, Dimname dim, bool keepdim=false);
CAFFE2_API std::tuple<Tensor,Tensor> min(const Tensor & self, int64_t dim, bool keepdim=false);
CAFFE2_API std::tuple<Tensor &,Tensor &> min_out(Tensor & min, Tensor & min_indices, const Tensor & self, int64_t dim, bool keepdim=false);
CAFFE2_API Tensor min_values(const Tensor & self, IntArrayRef dim, bool keepdim=false);
CAFFE2_API std::tuple<Tensor,Tensor> min(const Tensor & self, Dimname dim, bool keepdim=false);
CAFFE2_API std::tuple<Tensor &,Tensor &> min_out(Tensor & min, Tensor & min_indices, const Tensor & self, Dimname dim, bool keepdim=false);
CAFFE2_API Tensor min_values(const Tensor & self, DimnameList dim, bool keepdim=false);
CAFFE2_API Tensor mkldnn_convolution(const Tensor & self, const Tensor & weight, const Tensor & bias, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups);
CAFFE2_API Tensor mkldnn_convolution_backward_input(IntArrayRef self_size, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool bias_defined);
CAFFE2_API std::tuple<Tensor,Tensor> mkldnn_convolution_backward_weights(IntArrayRef weight_size, const Tensor & grad_output, const Tensor & self, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool bias_defined);
CAFFE2_API std::tuple<Tensor,Tensor,Tensor> mkldnn_convolution_backward(const Tensor & self, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, std::array<bool,3> output_mask);
CAFFE2_API std::tuple<Tensor,Tensor,Tensor> miopen_batch_norm(const Tensor & input, const Tensor & weight, const Tensor & bias, const Tensor & running_mean, const Tensor & running_var, bool training, double exponential_average_factor, double epsilon);
CAFFE2_API std::tuple<Tensor,Tensor,Tensor> miopen_batch_norm_backward(const Tensor & input, const Tensor & grad_output, const Tensor & weight, const Tensor & running_mean, const Tensor & running_var, const Tensor & save_mean, const Tensor & save_var, double epsilon);
CAFFE2_API Tensor miopen_convolution(const Tensor & self, const Tensor & weight, const Tensor & bias, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic);
CAFFE2_API Tensor miopen_convolution_backward_input(IntArrayRef self_size, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic);
CAFFE2_API std::tuple<Tensor,Tensor,Tensor> miopen_convolution_backward(const Tensor & self, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic, std::array<bool,3> output_mask);
CAFFE2_API Tensor miopen_convolution_backward_bias(const Tensor & grad_output);
CAFFE2_API Tensor miopen_convolution_backward_weight(IntArrayRef weight_size, const Tensor & grad_output, const Tensor & self, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic);
CAFFE2_API Tensor miopen_convolution_transpose(const Tensor & self, const Tensor & weight, const Tensor & bias, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic);
CAFFE2_API std::tuple<Tensor,Tensor,Tensor> miopen_convolution_transpose_backward(const Tensor & self, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic, std::array<bool,3> output_mask);
CAFFE2_API Tensor miopen_convolution_transpose_backward_input(const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic);
CAFFE2_API Tensor miopen_convolution_transpose_backward_weight(IntArrayRef weight_size, const Tensor & grad_output, const Tensor & self, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic);
CAFFE2_API Tensor miopen_depthwise_convolution(const Tensor & self, const Tensor & weight, const Tensor & bias, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic);
CAFFE2_API Tensor miopen_depthwise_convolution_backward_input(IntArrayRef self_size, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic);
CAFFE2_API std::tuple<Tensor,Tensor,Tensor> miopen_depthwise_convolution_backward(const Tensor & self, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic, std::array<bool,3> output_mask);
CAFFE2_API Tensor miopen_depthwise_convolution_backward_weight(IntArrayRef weight_size, const Tensor & grad_output, const Tensor & self, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic);
CAFFE2_API std::tuple<Tensor,Tensor,Tensor,Tensor,Tensor> miopen_rnn(const Tensor & input, TensorList weight, int64_t weight_stride0, const Tensor & hx, const Tensor & cx, int64_t mode, int64_t hidden_size, int64_t num_layers, bool batch_first, double dropout, bool train, bool bidirectional, IntArrayRef batch_sizes, const Tensor & dropout_state);
CAFFE2_API std::tuple<Tensor,Tensor,Tensor,std::vector<Tensor>> miopen_rnn_backward(const Tensor & input, TensorList weight, int64_t weight_stride0, const Tensor & weight_buf, const Tensor & hx, const Tensor & cx, const Tensor & output, const Tensor & grad_output, const Tensor & grad_hy, const Tensor & grad_cy, int64_t mode, int64_t hidden_size, int64_t num_layers, bool batch_first, double dropout, bool train, bool bidirectional, IntArrayRef batch_sizes, const Tensor & dropout_state, const Tensor & reserve, std::array<bool,4> output_mask);
CAFFE2_API Tensor mm(const Tensor & self, const Tensor & mat2);
CAFFE2_API Tensor & mm_out(Tensor & out, const Tensor & self, const Tensor & mat2);
CAFFE2_API Tensor _sparse_mm(const Tensor & sparse, const Tensor & dense);
CAFFE2_API std::tuple<Tensor,Tensor> mode(const Tensor & self, int64_t dim=-1, bool keepdim=false);
CAFFE2_API std::tuple<Tensor &,Tensor &> mode_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t dim=-1, bool keepdim=false);
CAFFE2_API std::tuple<Tensor,Tensor> mode(const Tensor & self, Dimname dim, bool keepdim=false);
CAFFE2_API std::tuple<Tensor &,Tensor &> mode_out(Tensor & values, Tensor & indices, const Tensor & self, Dimname dim, bool keepdim=false);
CAFFE2_API Tensor mul(const Tensor & self, const Tensor & other);
CAFFE2_API Tensor & mul_out(Tensor & out, const Tensor & self, const Tensor & other);
CAFFE2_API Tensor mul(const Tensor & self, Scalar other);
CAFFE2_API Tensor mv(const Tensor & self, const Tensor & vec);
CAFFE2_API Tensor & mv_out(Tensor & out, const Tensor & self, const Tensor & vec);
CAFFE2_API Tensor mvlgamma(const Tensor & self, int64_t p);
CAFFE2_API Tensor narrow(const Tensor & self, int64_t dim, int64_t start, int64_t length);
CAFFE2_API Tensor narrow(const Tensor & self, int64_t dim, const Tensor & start, int64_t length);
CAFFE2_API std::tuple<Tensor,Tensor,Tensor> native_batch_norm(const Tensor & input, const Tensor & weight, const Tensor & bias, const Tensor & running_mean, const Tensor & running_var, bool training, double momentum, double eps);
CAFFE2_API std::tuple<Tensor &,Tensor &,Tensor &> native_batch_norm_out(Tensor & out, Tensor & save_mean, Tensor & save_invstd, const Tensor & input, const Tensor & weight, const Tensor & bias, const Tensor & running_mean, const Tensor & running_var, bool training, double momentum, double eps);
CAFFE2_API std::tuple<Tensor,Tensor> batch_norm_stats(const Tensor & input, double eps);
CAFFE2_API Tensor batch_norm_elemt(const Tensor & input, const Tensor & weight, const Tensor & bias, const Tensor & mean, const Tensor & invstd, double eps);
CAFFE2_API Tensor & batch_norm_elemt_out(Tensor & out, const Tensor & input, const Tensor & weight, const Tensor & bias, const Tensor & mean, const Tensor & invstd, double eps);
CAFFE2_API std::tuple<Tensor,Tensor> batch_norm_gather_stats(const Tensor & input, const Tensor & mean, const Tensor & invstd, const Tensor & running_mean, const Tensor & running_var, double momentum, double eps, int64_t count);
CAFFE2_API std::tuple<Tensor,Tensor> batch_norm_gather_stats_with_counts(const Tensor & input, const Tensor & mean, const Tensor & invstd, const Tensor & running_mean, const Tensor & running_var, double momentum, double eps, const Tensor & counts);
CAFFE2_API std::tuple<Tensor,Tensor,Tensor> native_batch_norm_backward(const Tensor & grad_out, const Tensor & input, const Tensor & weight, const Tensor & running_mean, const Tensor & running_var, const Tensor & save_mean, const Tensor & save_invstd, bool train, double eps, std::array<bool,3> output_mask);
CAFFE2_API std::tuple<Tensor,Tensor,Tensor,Tensor> batch_norm_backward_reduce(const Tensor & grad_out, const Tensor & input, const Tensor & mean, const Tensor & invstd, const Tensor & weight, bool input_g, bool weight_g, bool bias_g);
CAFFE2_API Tensor batch_norm_backward_elemt(const Tensor & grad_out, const Tensor & input, const Tensor & mean, const Tensor & invstd, const Tensor & weight, const Tensor & mean_dy, const Tensor & mean_dy_xmu);
CAFFE2_API std::tuple<Tensor,Tensor> batch_norm_update_stats(const Tensor & input, const Tensor & running_mean, const Tensor & running_var, double momentum);
CAFFE2_API bool is_vulkan_available();
CAFFE2_API bool _nnpack_available();
CAFFE2_API Tensor _nnpack_spatial_convolution(const Tensor & input, const Tensor & weight, const Tensor & bias, IntArrayRef padding, IntArrayRef stride=1);
CAFFE2_API std::tuple<Tensor,Tensor,Tensor> _nnpack_spatial_convolution_backward(const Tensor & input, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, std::array<bool,3> output_mask);
CAFFE2_API Tensor _nnpack_spatial_convolution_backward_input(const Tensor & input, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding);
CAFFE2_API Tensor _nnpack_spatial_convolution_backward_weight(const Tensor & input, IntArrayRef weightsize, const Tensor & grad_output, IntArrayRef padding);
CAFFE2_API Tensor ones(IntArrayRef size, c10::optional<DimnameList> names, const TensorOptions & options={});
CAFFE2_API Tensor ones(IntArrayRef size, const TensorOptions & options={});
CAFFE2_API Tensor & ones_out(Tensor & out, IntArrayRef size);
CAFFE2_API Tensor ones_like(const Tensor & self, const TensorOptions & options={}, c10::optional<MemoryFormat> memory_format=c10::nullopt);
CAFFE2_API Tensor pairwise_distance(const Tensor & x1, const Tensor & x2, double p=2, double eps=1e-06, bool keepdim=false);
CAFFE2_API Tensor cdist(const Tensor & x1, const Tensor & x2, double p=2, c10::optional<int64_t> compute_mode=c10::nullopt);
CAFFE2_API Tensor _euclidean_dist(const Tensor & x1, const Tensor & x2);
CAFFE2_API Tensor _cdist_forward(const Tensor & x1, const Tensor & x2, double p, c10::optional<int64_t> compute_mode);
CAFFE2_API Tensor _cdist_backward(const Tensor & grad, const Tensor & x1, const Tensor & x2, double p, const Tensor & cdist);
CAFFE2_API Tensor pdist(const Tensor & self, double p=2);
CAFFE2_API Tensor _pdist_forward(const Tensor & self, double p=2);
CAFFE2_API Tensor _pdist_backward(const Tensor & grad, const Tensor & self, double p, const Tensor & pdist);
CAFFE2_API Tensor cosine_similarity(const Tensor & x1, const Tensor & x2, int64_t dim=1, double eps=1e-08);
CAFFE2_API Tensor pixel_shuffle(const Tensor & self, int64_t upscale_factor);
CAFFE2_API Tensor channel_shuffle(const Tensor & self, int64_t groups);
CAFFE2_API Tensor pinverse(const Tensor & self, double rcond=1e-15);
CAFFE2_API Tensor poisson_nll_loss(const Tensor & input, const Tensor & target, bool log_input, bool full, double eps, int64_t reduction);
CAFFE2_API Tensor rad2deg(const Tensor & self);
CAFFE2_API Tensor & rad2deg_(Tensor & self);
CAFFE2_API Tensor & rad2deg_out(Tensor & out, const Tensor & self);
CAFFE2_API Tensor deg2rad(const Tensor & self);
CAFFE2_API Tensor & deg2rad_(Tensor & self);
CAFFE2_API Tensor & deg2rad_out(Tensor & out, const Tensor & self);
CAFFE2_API Tensor scalar_tensor(Scalar s, const TensorOptions & options={});
CAFFE2_API Tensor rand(IntArrayRef size, c10::optional<DimnameList> names, const TensorOptions & options={});
CAFFE2_API Tensor rand(IntArrayRef size, c10::optional<Generator> generator, c10::optional<DimnameList> names, const TensorOptions & options={});
CAFFE2_API Tensor rand(IntArrayRef size, const TensorOptions & options={});
CAFFE2_API Tensor rand(IntArrayRef size, c10::optional<Generator> generator, const TensorOptions & options={});
CAFFE2_API Tensor & rand_out(Tensor & out, IntArrayRef size);
CAFFE2_API Tensor & rand_out(Tensor & out, IntArrayRef size, c10::optional<Generator> generator);
CAFFE2_API Tensor rand_like(const Tensor & self, const TensorOptions & options={}, c10::optional<MemoryFormat> memory_format=c10::nullopt);
CAFFE2_API Tensor randint(int64_t high, IntArrayRef size, const TensorOptions & options={});
CAFFE2_API Tensor randint(int64_t high, IntArrayRef size, c10::optional<Generator> generator, const TensorOptions & options={});
CAFFE2_API Tensor randint(int64_t low, int64_t high, IntArrayRef size, const TensorOptions & options={});
CAFFE2_API Tensor randint(int64_t low, int64_t high, IntArrayRef size, c10::optional<Generator> generator, const TensorOptions & options={});
CAFFE2_API Tensor & randint_out(Tensor & out, int64_t high, IntArrayRef size);
CAFFE2_API Tensor & randint_out(Tensor & out, int64_t high, IntArrayRef size, c10::optional<Generator> generator);
CAFFE2_API Tensor & randint_out(Tensor & out, int64_t low, int64_t high, IntArrayRef size);
CAFFE2_API Tensor & randint_out(Tensor & out, int64_t low, int64_t high, IntArrayRef size, c10::optional<Generator> generator);
CAFFE2_API Tensor randint_like(const Tensor & self, int64_t high, const TensorOptions & options={}, c10::optional<MemoryFormat> memory_format=c10::nullopt);
CAFFE2_API Tensor randint_like(const Tensor & self, int64_t low, int64_t high, const TensorOptions & options={}, c10::optional<MemoryFormat> memory_format=c10::nullopt);
CAFFE2_API Tensor randn(IntArrayRef size, const TensorOptions & options={});
CAFFE2_API Tensor randn(IntArrayRef size, c10::optional<Generator> generator, const TensorOptions & options={});
CAFFE2_API Tensor randn(IntArrayRef size, c10::optional<DimnameList> names, const TensorOptions & options={});
CAFFE2_API Tensor randn(IntArrayRef size, c10::optional<Generator> generator, c10::optional<DimnameList> names, const TensorOptions & options={});
CAFFE2_API Tensor & randn_out(Tensor & out, IntArrayRef size);
CAFFE2_API Tensor & randn_out(Tensor & out, IntArrayRef size, c10::optional<Generator> generator);
CAFFE2_API Tensor randn_like(const Tensor & self, const TensorOptions & options={}, c10::optional<MemoryFormat> memory_format=c10::nullopt);
CAFFE2_API Tensor randperm(int64_t n, const TensorOptions & options={});
CAFFE2_API Tensor randperm(int64_t n, c10::optional<Generator> generator, const TensorOptions & options={});
CAFFE2_API Tensor & randperm_out(Tensor & out, int64_t n);
CAFFE2_API Tensor & randperm_out(Tensor & out, int64_t n, c10::optional<Generator> generator);
CAFFE2_API Tensor range(Scalar start, Scalar end, Scalar step=1, const TensorOptions & options={});
CAFFE2_API Tensor range(Scalar start, Scalar end, const TensorOptions & options={});
CAFFE2_API Tensor & range_out(Tensor & out, Scalar start, Scalar end, Scalar step=1);
CAFFE2_API Tensor reciprocal(const Tensor & self);
CAFFE2_API Tensor & reciprocal_(Tensor & self);
CAFFE2_API Tensor & reciprocal_out(Tensor & out, const Tensor & self);
CAFFE2_API Tensor neg(const Tensor & self);
CAFFE2_API Tensor & neg_(Tensor & self);
CAFFE2_API Tensor & neg_out(Tensor & out, const Tensor & self);
CAFFE2_API Tensor repeat_interleave(const Tensor & repeats);
CAFFE2_API Tensor repeat_interleave(const Tensor & self, const Tensor & repeats, c10::optional<int64_t> dim=c10::nullopt);
CAFFE2_API Tensor repeat_interleave(const Tensor & self, int64_t repeats, c10::optional<int64_t> dim=c10::nullopt);
CAFFE2_API Tensor reshape(const Tensor & self, IntArrayRef shape);
CAFFE2_API Tensor _mkldnn_reshape(const Tensor & self, IntArrayRef shape);
CAFFE2_API Tensor round(const Tensor & self);
CAFFE2_API Tensor & round_(Tensor & self);
CAFFE2_API Tensor & round_out(Tensor & out, const Tensor & self);
CAFFE2_API Tensor rrelu(const Tensor & self, Scalar lower=0.125, Scalar upper=0.3333333333333333, bool training=false, c10::optional<Generator> generator=c10::nullopt);
CAFFE2_API Tensor & rrelu_(Tensor & self, Scalar lower=0.125, Scalar upper=0.3333333333333333, bool training=false, c10::optional<Generator> generator=c10::nullopt);
CAFFE2_API Tensor relu(const Tensor & self);
CAFFE2_API Tensor & relu_(Tensor & self);
CAFFE2_API Tensor prelu(const Tensor & self, const Tensor & weight);
CAFFE2_API std::tuple<Tensor,Tensor> prelu_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight);
CAFFE2_API Tensor gelu(const Tensor & self);
CAFFE2_API Tensor gelu_backward(const Tensor & grad, const Tensor & self);
CAFFE2_API Tensor hardshrink(const Tensor & self, Scalar lambd=0.5);
CAFFE2_API Tensor hardshrink_backward(const Tensor & grad_out, const Tensor & self, Scalar lambd);
CAFFE2_API Tensor rsqrt(const Tensor & self);
CAFFE2_API Tensor & rsqrt_(Tensor & self);
CAFFE2_API Tensor & rsqrt_out(Tensor & out, const Tensor & self);
CAFFE2_API Tensor select(const Tensor & self, Dimname dim, int64_t index);
CAFFE2_API Tensor select(const Tensor & self, int64_t dim, int64_t index);
CAFFE2_API Tensor selu(const Tensor & self);
CAFFE2_API Tensor & selu_(Tensor & self);
CAFFE2_API Tensor celu(const Tensor & self, Scalar alpha=1.0);
CAFFE2_API Tensor & celu_(Tensor & self, Scalar alpha=1.0);
CAFFE2_API Tensor sigmoid(const Tensor & self);
CAFFE2_API Tensor & sigmoid_(Tensor & self);
CAFFE2_API Tensor & sigmoid_out(Tensor & out, const Tensor & self);
CAFFE2_API Tensor sin(const Tensor & self);
CAFFE2_API Tensor & sin_(Tensor & self);
CAFFE2_API Tensor & sin_out(Tensor & out, const Tensor & self);
CAFFE2_API Tensor sinh(const Tensor & self);
CAFFE2_API Tensor & sinh_(Tensor & self);
CAFFE2_API Tensor & sinh_out(Tensor & out, const Tensor & self);
CAFFE2_API Tensor detach(const Tensor & self);
CAFFE2_API Tensor & detach_(Tensor & self);
CAFFE2_API int64_t size(const Tensor & self, int64_t dim);
CAFFE2_API int64_t size(const Tensor & self, Dimname dim);
CAFFE2_API Tensor slice(const Tensor & self, int64_t dim=0, int64_t start=0, int64_t end=9223372036854775807, int64_t step=1);
CAFFE2_API std::tuple<Tensor,Tensor> slogdet(const Tensor & self);
CAFFE2_API Tensor smm(const Tensor & self, const Tensor & mat2);
CAFFE2_API Tensor softmax(const Tensor & self, int64_t dim, c10::optional<ScalarType> dtype=c10::nullopt);
CAFFE2_API Tensor softmax(const Tensor & self, Dimname dim, c10::optional<ScalarType> dtype=c10::nullopt);
CAFFE2_API Tensor _softmax(const Tensor & self, int64_t dim, bool half_to_float);
CAFFE2_API Tensor _softmax_backward_data(const Tensor & grad_output, const Tensor & output, int64_t dim, const Tensor & self);
CAFFE2_API std::vector<Tensor> split(const Tensor & self, int64_t split_size, int64_t dim=0);
CAFFE2_API std::vector<Tensor> split_with_sizes(const Tensor & self, IntArrayRef split_sizes, int64_t dim=0);
CAFFE2_API Tensor squeeze(const Tensor & self);
CAFFE2_API Tensor squeeze(const Tensor & self, int64_t dim);
CAFFE2_API Tensor squeeze(const Tensor & self, Dimname dim);
CAFFE2_API Tensor sspaddmm(const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta=1, Scalar alpha=1);
CAFFE2_API Tensor & sspaddmm_out(Tensor & out, const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta=1, Scalar alpha=1);
CAFFE2_API Tensor stack(TensorList tensors, int64_t dim=0);
CAFFE2_API Tensor & stack_out(Tensor & out, TensorList tensors, int64_t dim=0);
CAFFE2_API Tensor stft(const Tensor & self, int64_t n_fft, c10::optional<int64_t> hop_length=c10::nullopt, c10::optional<int64_t> win_length=c10::nullopt, const Tensor & window={}, bool normalized=false, bool onesided=true);
CAFFE2_API Tensor istft(const Tensor & self, int64_t n_fft, c10::optional<int64_t> hop_length=c10::nullopt, c10::optional<int64_t> win_length=c10::nullopt, const Tensor & window={}, bool center=true, bool normalized=false, bool onesided=true, c10::optional<int64_t> length=c10::nullopt);
CAFFE2_API int64_t stride(const Tensor & self, int64_t dim);
CAFFE2_API int64_t stride(const Tensor & self, Dimname dim);
CAFFE2_API Tensor sum(const Tensor & self, c10::optional<ScalarType> dtype=c10::nullopt);
CAFFE2_API Tensor sum(const Tensor & self, IntArrayRef dim, bool keepdim=false, c10::optional<ScalarType> dtype=c10::nullopt);
CAFFE2_API Tensor sum(const Tensor & self, DimnameList dim, bool keepdim=false, c10::optional<ScalarType> dtype=c10::nullopt);
CAFFE2_API Tensor & sum_out(Tensor & out, const Tensor & self, IntArrayRef dim, bool keepdim=false, c10::optional<ScalarType> dtype=c10::nullopt);
CAFFE2_API Tensor & sum_out(Tensor & out, const Tensor & self, DimnameList dim, bool keepdim=false, c10::optional<ScalarType> dtype=c10::nullopt);
CAFFE2_API Tensor sqrt(const Tensor & self);
CAFFE2_API Tensor & sqrt_(Tensor & self);
CAFFE2_API Tensor & sqrt_out(Tensor & out, const Tensor & self);
CAFFE2_API Tensor square(const Tensor & self);
CAFFE2_API Tensor & square_(Tensor & self);
CAFFE2_API Tensor std(const Tensor & self, bool unbiased=true);
CAFFE2_API Tensor std(const Tensor & self, IntArrayRef dim, bool unbiased=true, bool keepdim=false);
CAFFE2_API std::tuple<Tensor,Tensor> std_mean(const Tensor & self, bool unbiased=true);
CAFFE2_API std::tuple<Tensor,Tensor> std_mean(const Tensor & self, IntArrayRef dim, bool unbiased=true, bool keepdim=false);
CAFFE2_API std::tuple<Tensor,Tensor> std_mean(const Tensor & self, DimnameList dim, bool unbiased=true, bool keepdim=false);
CAFFE2_API Tensor & std_out(Tensor & out, const Tensor & self, IntArrayRef dim, bool unbiased=true, bool keepdim=false);
CAFFE2_API Tensor std(const Tensor & self, DimnameList dim, bool unbiased=true, bool keepdim=false);
CAFFE2_API Tensor & std_out(Tensor & out, const Tensor & self, DimnameList dim, bool unbiased=true, bool keepdim=false);
CAFFE2_API Tensor prod(const Tensor & self, c10::optional<ScalarType> dtype=c10::nullopt);
CAFFE2_API Tensor prod(const Tensor & self, int64_t dim, bool keepdim=false, c10::optional<ScalarType> dtype=c10::nullopt);
CAFFE2_API Tensor & prod_out(Tensor & out, const Tensor & self, int64_t dim, bool keepdim=false, c10::optional<ScalarType> dtype=c10::nullopt);
CAFFE2_API Tensor prod(const Tensor & self, Dimname dim, bool keepdim=false, c10::optional<ScalarType> dtype=c10::nullopt);
CAFFE2_API Tensor & prod_out(Tensor & out, const Tensor & self, Dimname dim, bool keepdim=false, c10::optional<ScalarType> dtype=c10::nullopt);
CAFFE2_API Tensor t(const Tensor & self);
CAFFE2_API Tensor tan(const Tensor & self);
CAFFE2_API Tensor & tan_(Tensor & self);
CAFFE2_API Tensor & tan_out(Tensor & out, const Tensor & self);
CAFFE2_API Tensor tanh(const Tensor & self);
CAFFE2_API Tensor & tanh_(Tensor & self);
CAFFE2_API Tensor & tanh_out(Tensor & out, const Tensor & self);
CAFFE2_API Tensor tensordot(const Tensor & self, const Tensor & other, IntArrayRef dims_self, IntArrayRef dims_other);
CAFFE2_API Tensor threshold(const Tensor & self, Scalar threshold, Scalar value);
CAFFE2_API Tensor & threshold_(Tensor & self, Scalar threshold, Scalar value);
CAFFE2_API Tensor & threshold_out(Tensor & out, const Tensor & self, Scalar threshold, Scalar value);
CAFFE2_API Tensor threshold_backward(const Tensor & grad_output, const Tensor & self, Scalar threshold);
CAFFE2_API Tensor transpose(const Tensor & self, int64_t dim0, int64_t dim1);
CAFFE2_API Tensor transpose(const Tensor & self, Dimname dim0, Dimname dim1);
CAFFE2_API Tensor _mkldnn_transpose(const Tensor & self, int64_t dim0, int64_t dim1);
CAFFE2_API Tensor & _mkldnn_transpose_(Tensor & self, int64_t dim0, int64_t dim1);
CAFFE2_API Tensor one_hot(const Tensor & self, int64_t num_classes=-1);
CAFFE2_API Tensor flip(const Tensor & self, IntArrayRef dims);
CAFFE2_API Tensor fliplr(const Tensor & self);
CAFFE2_API Tensor flipud(const Tensor & self);
CAFFE2_API Tensor roll(const Tensor & self, IntArrayRef shifts, IntArrayRef dims={});
CAFFE2_API Tensor rot90(const Tensor & self, int64_t k=1, IntArrayRef dims={0,1});
CAFFE2_API Tensor trapz(const Tensor & y, const Tensor & x, int64_t dim=-1);
CAFFE2_API Tensor trapz(const Tensor & y, double dx=1, int64_t dim=-1);
CAFFE2_API Tensor _trilinear(const Tensor & i1, const Tensor & i2, const Tensor & i3, IntArrayRef expand1, IntArrayRef expand2, IntArrayRef expand3, IntArrayRef sumdim, int64_t unroll_dim=1);
CAFFE2_API Tensor triplet_margin_loss(const Tensor & anchor, const Tensor & positive, const Tensor & negative, double margin=1.0, double p=2, double eps=1e-06, bool swap=false, int64_t reduction=at::Reduction::Mean);
CAFFE2_API Tensor true_divide(const Tensor & self, const Tensor & other);
CAFFE2_API Tensor & true_divide_out(Tensor & out, const Tensor & self, const Tensor & other);
CAFFE2_API Tensor true_divide(const Tensor & self, Scalar other);
CAFFE2_API Tensor trunc(const Tensor & self);
CAFFE2_API Tensor & trunc_(Tensor & self);
CAFFE2_API Tensor & trunc_out(Tensor & out, const Tensor & self);
CAFFE2_API bool _has_compatible_shallow_copy_type(const Tensor & self, const Tensor & from);
CAFFE2_API std::tuple<Tensor,Tensor> _unique(const Tensor & self, bool sorted=true, bool return_inverse=false);
CAFFE2_API std::tuple<Tensor,Tensor,Tensor> unique_dim(const Tensor & self, int64_t dim, bool sorted=true, bool return_inverse=false, bool return_counts=false);
CAFFE2_API std::tuple<Tensor,Tensor,Tensor> unique_consecutive(const Tensor & self, bool return_inverse=false, bool return_counts=false, c10::optional<int64_t> dim=c10::nullopt);
CAFFE2_API std::tuple<Tensor,Tensor,Tensor> unique_dim_consecutive(const Tensor & self, int64_t dim, bool return_inverse=false, bool return_counts=false);
CAFFE2_API std::tuple<Tensor,Tensor,Tensor> _unique2(const Tensor & self, bool sorted=true, bool return_inverse=false, bool return_counts=false);
CAFFE2_API Tensor _unsafe_view(const Tensor & self, IntArrayRef size);
CAFFE2_API Tensor unsqueeze(const Tensor & self, int64_t dim);
CAFFE2_API Tensor vander(const Tensor & x, c10::optional<int64_t> N=c10::nullopt, bool increasing=false);
CAFFE2_API Tensor var(const Tensor & self, bool unbiased=true);
CAFFE2_API Tensor var(const Tensor & self, IntArrayRef dim, bool unbiased=true, bool keepdim=false);
CAFFE2_API Tensor & var_out(Tensor & out, const Tensor & self, IntArrayRef dim, bool unbiased=true, bool keepdim=false);
CAFFE2_API Tensor var(const Tensor & self, DimnameList dim, bool unbiased=true, bool keepdim=false);
CAFFE2_API Tensor & var_out(Tensor & out, const Tensor & self, DimnameList dim, bool unbiased=true, bool keepdim=false);
CAFFE2_API std::tuple<Tensor,Tensor> var_mean(const Tensor & self, bool unbiased=true);
CAFFE2_API std::tuple<Tensor,Tensor> var_mean(const Tensor & self, IntArrayRef dim, bool unbiased=true, bool keepdim=false);
CAFFE2_API std::tuple<Tensor,Tensor> var_mean(const Tensor & self, DimnameList dim, bool unbiased=true, bool keepdim=false);
CAFFE2_API Tensor where(const Tensor & condition, const Tensor & self, const Tensor & other);
CAFFE2_API std::vector<Tensor> where(const Tensor & condition);
CAFFE2_API Tensor _s_where(const Tensor & condition, const Tensor & self, const Tensor & other);
CAFFE2_API Tensor norm_except_dim(const Tensor & v, int64_t pow=2, int64_t dim=0);
CAFFE2_API Tensor _weight_norm(const Tensor & v, const Tensor & g, int64_t dim=0);
CAFFE2_API std::tuple<Tensor,Tensor> _weight_norm_cuda_interface(const Tensor & v, const Tensor & g, int64_t dim=0);
CAFFE2_API std::tuple<Tensor,Tensor> _weight_norm_cuda_interface_backward(const Tensor & grad_w, const Tensor & saved_v, const Tensor & saved_g, const Tensor & saved_norms, int64_t dim);
CAFFE2_API std::tuple<Tensor,Tensor> _weight_norm_differentiable_backward(const Tensor & grad_w, const Tensor & saved_v, const Tensor & saved_g, const Tensor & saved_norms, int64_t dim);
CAFFE2_API Tensor zeros(IntArrayRef size, c10::optional<DimnameList> names, const TensorOptions & options={});
CAFFE2_API Tensor zeros(IntArrayRef size, const TensorOptions & options={});
CAFFE2_API Tensor & zeros_out(Tensor & out, IntArrayRef size);
CAFFE2_API Tensor zeros_like(const Tensor & self, const TensorOptions & options={}, c10::optional<MemoryFormat> memory_format=c10::nullopt);
CAFFE2_API Tensor _standard_gamma_grad(const Tensor & self, const Tensor & output);
CAFFE2_API Tensor _standard_gamma(const Tensor & self, c10::optional<Generator> generator=c10::nullopt);
CAFFE2_API Tensor _dirichlet_grad(const Tensor & x, const Tensor & alpha, const Tensor & total);
CAFFE2_API Tensor _sample_dirichlet(const Tensor & self, c10::optional<Generator> generator=c10::nullopt);
CAFFE2_API Tensor poisson(const Tensor & self, c10::optional<Generator> generator=c10::nullopt);
CAFFE2_API Tensor binomial(const Tensor & count, const Tensor & prob, c10::optional<Generator> generator=c10::nullopt);
CAFFE2_API Tensor native_norm(const Tensor & self, Scalar p=2);
CAFFE2_API Tensor _sparse_sum(const Tensor & self);
CAFFE2_API Tensor _sparse_sum(const Tensor & self, ScalarType dtype);
CAFFE2_API Tensor _sparse_sum(const Tensor & self, IntArrayRef dim);
CAFFE2_API Tensor _sparse_sum(const Tensor & self, IntArrayRef dim, ScalarType dtype);
CAFFE2_API Tensor _sparse_sum_backward(const Tensor & grad, const Tensor & self, IntArrayRef dim);
CAFFE2_API Tensor _sparse_softmax(const Tensor & self, int64_t dim, c10::optional<ScalarType> dtype=c10::nullopt);
CAFFE2_API Tensor _sparse_softmax(const Tensor & self, Dimname dim, c10::optional<ScalarType> dtype=c10::nullopt);
CAFFE2_API Tensor _sparse_softmax(const Tensor & self, int64_t dim, bool half_to_float);
CAFFE2_API Tensor _sparse_softmax_backward_data(const Tensor & grad_output, const Tensor & output, int64_t dim, const Tensor & self);
CAFFE2_API Tensor _sparse_log_softmax(const Tensor & self, int64_t dim, c10::optional<ScalarType> dtype=c10::nullopt);
CAFFE2_API Tensor _sparse_log_softmax(const Tensor & self, Dimname dim, c10::optional<ScalarType> dtype=c10::nullopt);
CAFFE2_API Tensor _sparse_log_softmax(const Tensor & self, int64_t dim, bool half_to_float);
CAFFE2_API Tensor _sparse_log_softmax_backward_data(const Tensor & grad_output, const Tensor & output, int64_t dim, const Tensor & self);
CAFFE2_API Tensor norm(const Tensor & self, c10::optional<Scalar> p, ScalarType dtype);
CAFFE2_API Tensor norm(const Tensor & self, Scalar p=2);
CAFFE2_API Tensor norm(const Tensor & self, c10::optional<Scalar> p, IntArrayRef dim, bool keepdim, ScalarType dtype);
CAFFE2_API Tensor norm(const Tensor & self, c10::optional<Scalar> p, IntArrayRef dim, bool keepdim=false);
CAFFE2_API Tensor & norm_out(Tensor & out, const Tensor & self, c10::optional<Scalar> p, IntArrayRef dim, bool keepdim, ScalarType dtype);
CAFFE2_API Tensor & norm_out(Tensor & out, const Tensor & self, c10::optional<Scalar> p, IntArrayRef dim, bool keepdim=false);
CAFFE2_API Tensor norm(const Tensor & self, c10::optional<Scalar> p, DimnameList dim, bool keepdim, ScalarType dtype);
CAFFE2_API Tensor norm(const Tensor & self, c10::optional<Scalar> p, DimnameList dim, bool keepdim=false);
CAFFE2_API Tensor & norm_out(Tensor & out, const Tensor & self, c10::optional<Scalar> p, DimnameList dim, bool keepdim, ScalarType dtype);
CAFFE2_API Tensor & norm_out(Tensor & out, const Tensor & self, c10::optional<Scalar> p, DimnameList dim, bool keepdim=false);
CAFFE2_API Tensor frobenius_norm(const Tensor & self);
CAFFE2_API Tensor frobenius_norm(const Tensor & self, IntArrayRef dim, bool keepdim=false);
CAFFE2_API Tensor & frobenius_norm_out(Tensor & out, const Tensor & self, IntArrayRef dim, bool keepdim=false);
CAFFE2_API Tensor nuclear_norm(const Tensor & self, bool keepdim=false);
CAFFE2_API Tensor & nuclear_norm_out(Tensor & out, const Tensor & self, bool keepdim=false);
CAFFE2_API Tensor nuclear_norm(const Tensor & self, IntArrayRef dim, bool keepdim=false);
CAFFE2_API Tensor & nuclear_norm_out(Tensor & out, const Tensor & self, IntArrayRef dim, bool keepdim=false);
CAFFE2_API Tensor clone(const Tensor & self, c10::optional<MemoryFormat> memory_format=c10::nullopt);
CAFFE2_API Tensor & resize_as_(Tensor & self, const Tensor & the_template, c10::optional<MemoryFormat> memory_format=c10::nullopt);
CAFFE2_API Tensor & pow_out(Tensor & out, const Tensor & self, Scalar exponent);
CAFFE2_API Tensor pow(const Tensor & self, Scalar exponent);
CAFFE2_API Tensor & zero_(Tensor & self);
CAFFE2_API Tensor & sub_out(Tensor & out, const Tensor & self, const Tensor & other, Scalar alpha=1);
CAFFE2_API Tensor sub(const Tensor & self, const Tensor & other, Scalar alpha=1);
CAFFE2_API Tensor sub(const Tensor & self, Scalar other, Scalar alpha=1);
CAFFE2_API Tensor rsub(const Tensor & self, const Tensor & other, Scalar alpha=1);
CAFFE2_API Tensor rsub(const Tensor & self, Scalar other, Scalar alpha=1);
CAFFE2_API Tensor _sparse_addmm(const Tensor & self, const Tensor & sparse, const Tensor & dense, Scalar beta=1, Scalar alpha=1);
CAFFE2_API Tensor & addmm_out(Tensor & out, const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta=1, Scalar alpha=1);
CAFFE2_API Tensor addmm(const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta=1, Scalar alpha=1);
CAFFE2_API Tensor sparse_coo_tensor(IntArrayRef size, const TensorOptions & options);
CAFFE2_API Tensor sparse_coo_tensor(const Tensor & indices, const Tensor & values, const TensorOptions & options={});
CAFFE2_API Tensor sparse_coo_tensor(const Tensor & indices, const Tensor & values, IntArrayRef size, const TensorOptions & options={});
CAFFE2_API Tensor _sparse_coo_tensor_unsafe(const Tensor & indices, const Tensor & values, IntArrayRef size, const TensorOptions & options={});
CAFFE2_API Tensor _sparse_coo_tensor_with_dims(int64_t sparse_dim, int64_t dense_dim, IntArrayRef size, const TensorOptions & options);
CAFFE2_API Tensor _sparse_coo_tensor_with_dims_and_tensors(int64_t sparse_dim, int64_t dense_dim, IntArrayRef size, const Tensor & indices, const Tensor & values, const TensorOptions & options);
CAFFE2_API Tensor to_dense_backward(const Tensor & grad, const Tensor & input);
CAFFE2_API Tensor & hspmm_out(Tensor & out, const Tensor & mat1, const Tensor & mat2);
CAFFE2_API Tensor hspmm(const Tensor & mat1, const Tensor & mat2);
CAFFE2_API Tensor & copy_sparse_to_sparse_(Tensor & self, const Tensor & src, bool non_blocking=false);
CAFFE2_API std::vector<Tensor> unbind(const Tensor & self, int64_t dim=0);
CAFFE2_API std::vector<Tensor> unbind(const Tensor & self, Dimname dim);
CAFFE2_API Tensor mkldnn_reorder_conv2d_weight(const Tensor & self, IntArrayRef padding=0, IntArrayRef stride=1, IntArrayRef dilation=1, int64_t groups=1);
CAFFE2_API Tensor to_mkldnn_backward(const Tensor & grad, const Tensor & input);
CAFFE2_API Tensor quantize_per_tensor(const Tensor & self, double scale, int64_t zero_point, ScalarType dtype);
CAFFE2_API std::vector<Tensor> quantize_per_tensor(TensorList tensors, const Tensor & scales, const Tensor & zero_points, ScalarType dtype);
CAFFE2_API Tensor quantize_per_channel(const Tensor & self, const Tensor & scales, const Tensor & zero_points, int64_t axis, ScalarType dtype);
CAFFE2_API Tensor dequantize(const Tensor & self);
CAFFE2_API std::vector<Tensor> dequantize(TensorList tensors);
CAFFE2_API double q_scale(const Tensor & self);
CAFFE2_API int64_t q_zero_point(const Tensor & self);
CAFFE2_API Tensor q_per_channel_scales(const Tensor & self);
CAFFE2_API Tensor q_per_channel_zero_points(const Tensor & self);
CAFFE2_API int64_t q_per_channel_axis(const Tensor & self);
CAFFE2_API Tensor int_repr(const Tensor & self);
CAFFE2_API Tensor _make_per_tensor_quantized_tensor(const Tensor & self, double scale, int64_t zero_point);
CAFFE2_API Tensor _make_per_channel_quantized_tensor(const Tensor & self, const Tensor & scale, const Tensor & zero_point, int64_t axis);
CAFFE2_API Tensor fake_quantize_per_tensor_affine(const Tensor & self, double scale, int64_t zero_point, int64_t quant_min, int64_t quant_max);
CAFFE2_API Tensor fake_quantize_per_tensor_affine_backward(const Tensor & grad, const Tensor & self, double scale, int64_t zero_point, int64_t quant_min, int64_t quant_max);
CAFFE2_API Tensor fake_quantize_per_channel_affine(const Tensor & self, const Tensor & scale, const Tensor & zero_point, int64_t axis, int64_t quant_min, int64_t quant_max);
CAFFE2_API Tensor fake_quantize_per_channel_affine_backward(const Tensor & grad, const Tensor & self, const Tensor & scale, const Tensor & zero_point, int64_t axis, int64_t quant_min, int64_t quant_max);
CAFFE2_API std::tuple<double,int64_t> _choose_qparams_per_tensor(const Tensor & self, bool reduce_range=false);
CAFFE2_API std::vector<Tensor> meshgrid(TensorList tensors);
CAFFE2_API Tensor cartesian_prod(TensorList tensors);
CAFFE2_API Tensor combinations(const Tensor & self, int64_t r=2, bool with_replacement=false);
CAFFE2_API ScalarType result_type(const Tensor & tensor, const Tensor & other);
CAFFE2_API ScalarType result_type(const Tensor & tensor, Scalar other);
CAFFE2_API ScalarType result_type(Scalar scalar, const Tensor & tensor);
CAFFE2_API ScalarType result_type(Scalar scalar1, Scalar scalar2);
CAFFE2_API bool can_cast(ScalarType from, ScalarType to);
CAFFE2_API ScalarType promote_types(ScalarType type1, ScalarType type2);
CAFFE2_API Scalar _local_scalar_dense(const Tensor & self);
CAFFE2_API std::tuple<Tensor,Tensor,Tensor> _thnn_fused_lstm_cell(const Tensor & input_gates, const Tensor & hidden_gates, const Tensor & cx, const Tensor & input_bias={}, const Tensor & hidden_bias={});
CAFFE2_API std::tuple<Tensor,Tensor,Tensor,Tensor,Tensor> _thnn_fused_lstm_cell_backward(const Tensor & grad_hy, const Tensor & grad_cy, const Tensor & cx, const Tensor & cy, const Tensor & workspace, bool has_bias);
CAFFE2_API std::tuple<Tensor,Tensor,Tensor,Tensor,Tensor> _thnn_differentiable_lstm_cell_backward(const Tensor & grad_hy, const Tensor & grad_cy, const Tensor & input_gates, const Tensor & hidden_gates, const Tensor & input_bias, const Tensor & hidden_bias, const Tensor & cx, const Tensor & cy);
CAFFE2_API std::tuple<Tensor,Tensor> _thnn_fused_gru_cell(const Tensor & input_gates, const Tensor & hidden_gates, const Tensor & hx, const Tensor & input_bias={}, const Tensor & hidden_bias={});
CAFFE2_API std::tuple<Tensor,Tensor,Tensor,Tensor,Tensor> _thnn_fused_gru_cell_backward(const Tensor & grad_hy, const Tensor & workspace, bool has_bias);
CAFFE2_API std::tuple<Tensor,Tensor,Tensor,Tensor,Tensor> _thnn_differentiable_gru_cell_backward(const Tensor & grad_hy, const Tensor & input_gates, const Tensor & hidden_gates, const Tensor & hx, const Tensor & input_bias, const Tensor & hidden_bias);
CAFFE2_API std::tuple<Tensor,Tensor,Tensor> lstm(const Tensor & input, TensorList hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional, bool batch_first);
CAFFE2_API std::tuple<Tensor,Tensor,Tensor> lstm(const Tensor & data, const Tensor & batch_sizes, TensorList hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional);
CAFFE2_API std::tuple<Tensor,Tensor> gru(const Tensor & input, const Tensor & hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional, bool batch_first);
CAFFE2_API std::tuple<Tensor,Tensor> gru(const Tensor & data, const Tensor & batch_sizes, const Tensor & hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional);
CAFFE2_API std::tuple<Tensor,Tensor> rnn_tanh(const Tensor & input, const Tensor & hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional, bool batch_first);
CAFFE2_API std::tuple<Tensor,Tensor> rnn_tanh(const Tensor & data, const Tensor & batch_sizes, const Tensor & hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional);
CAFFE2_API std::tuple<Tensor,Tensor> rnn_relu(const Tensor & input, const Tensor & hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional, bool batch_first);
CAFFE2_API std::tuple<Tensor,Tensor> rnn_relu(const Tensor & data, const Tensor & batch_sizes, const Tensor & hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional);
CAFFE2_API std::tuple<Tensor,Tensor> lstm_cell(const Tensor & input, TensorList hx, const Tensor & w_ih, const Tensor & w_hh, const Tensor & b_ih={}, const Tensor & b_hh={});
CAFFE2_API Tensor gru_cell(const Tensor & input, const Tensor & hx, const Tensor & w_ih, const Tensor & w_hh, const Tensor & b_ih={}, const Tensor & b_hh={});
CAFFE2_API Tensor rnn_tanh_cell(const Tensor & input, const Tensor & hx, const Tensor & w_ih, const Tensor & w_hh, const Tensor & b_ih={}, const Tensor & b_hh={});
CAFFE2_API Tensor rnn_relu_cell(const Tensor & input, const Tensor & hx, const Tensor & w_ih, const Tensor & w_hh, const Tensor & b_ih={}, const Tensor & b_hh={});
CAFFE2_API std::tuple<Tensor,Tensor> quantized_lstm_cell(const Tensor & input, TensorList hx, const Tensor & w_ih, const Tensor & w_hh, const Tensor & b_ih, const Tensor & b_hh, const Tensor & packed_ih, const Tensor & packed_hh, const Tensor & col_offsets_ih, const Tensor & col_offsets_hh, Scalar scale_ih, Scalar scale_hh, Scalar zero_point_ih, Scalar zero_point_hh);
CAFFE2_API Tensor quantized_gru_cell(const Tensor & input, const Tensor & hx, const Tensor & w_ih, const Tensor & w_hh, const Tensor & b_ih, const Tensor & b_hh, const Tensor & packed_ih, const Tensor & packed_hh, const Tensor & col_offsets_ih, const Tensor & col_offsets_hh, Scalar scale_ih, Scalar scale_hh, Scalar zero_point_ih, Scalar zero_point_hh);
CAFFE2_API Tensor quantized_rnn_relu_cell(const Tensor & input, const Tensor & hx, const Tensor & w_ih, const Tensor & w_hh, const Tensor & b_ih, const Tensor & b_hh, const Tensor & packed_ih, const Tensor & packed_hh, const Tensor & col_offsets_ih, const Tensor & col_offsets_hh, Scalar scale_ih, Scalar scale_hh, Scalar zero_point_ih, Scalar zero_point_hh);
CAFFE2_API Tensor quantized_rnn_tanh_cell(const Tensor & input, const Tensor & hx, const Tensor & w_ih, const Tensor & w_hh, const Tensor & b_ih, const Tensor & b_hh, const Tensor & packed_ih, const Tensor & packed_hh, const Tensor & col_offsets_ih, const Tensor & col_offsets_hh, Scalar scale_ih, Scalar scale_hh, Scalar zero_point_ih, Scalar zero_point_hh);
CAFFE2_API std::tuple<Tensor,Tensor> _pack_padded_sequence(const Tensor & input, const Tensor & lengths, bool batch_first);
CAFFE2_API Tensor _pack_padded_sequence_backward(const Tensor & grad, IntArrayRef input_size, const Tensor & batch_sizes, bool batch_first);
CAFFE2_API std::tuple<Tensor,Tensor> _pad_packed_sequence(const Tensor & data, const Tensor & batch_sizes, bool batch_first, Scalar padding_value, int64_t total_length);
CAFFE2_API Tensor masked_fill(const Tensor & self, const Tensor & mask, Scalar value);
CAFFE2_API Tensor masked_fill(const Tensor & self, const Tensor & mask, const Tensor & value);
CAFFE2_API Tensor masked_scatter(const Tensor & self, const Tensor & mask, const Tensor & source);
CAFFE2_API Tensor index_add(const Tensor & self, int64_t dim, const Tensor & index, const Tensor & source);
CAFFE2_API Tensor index_add(const Tensor & self, Dimname dim, const Tensor & index, const Tensor & source);
CAFFE2_API Tensor index_fill(const Tensor & self, int64_t dim, const Tensor & index, Scalar value);
CAFFE2_API Tensor index_fill(const Tensor & self, int64_t dim, const Tensor & index, const Tensor & value);
CAFFE2_API Tensor index_fill(const Tensor & self, Dimname dim, const Tensor & index, Scalar value);
CAFFE2_API Tensor index_fill(const Tensor & self, Dimname dim, const Tensor & index, const Tensor & value);
CAFFE2_API Tensor scatter(const Tensor & self, int64_t dim, const Tensor & index, const Tensor & src);
CAFFE2_API Tensor scatter(const Tensor & self, int64_t dim, const Tensor & index, Scalar value);
CAFFE2_API Tensor scatter(const Tensor & self, Dimname dim, const Tensor & index, const Tensor & src);
CAFFE2_API Tensor scatter(const Tensor & self, Dimname dim, const Tensor & index, Scalar value);
CAFFE2_API Tensor scatter_add(const Tensor & self, int64_t dim, const Tensor & index, const Tensor & src);
CAFFE2_API Tensor scatter_add(const Tensor & self, Dimname dim, const Tensor & index, const Tensor & src);
CAFFE2_API Tensor & bitwise_and_out(Tensor & out, const Tensor & self, const Tensor & other);
CAFFE2_API Tensor & bitwise_and_out(Tensor & out, const Tensor & self, Scalar other);
CAFFE2_API Tensor bitwise_and(const Tensor & self, Scalar other);
CAFFE2_API Tensor bitwise_and(const Tensor & self, const Tensor & other);
CAFFE2_API Tensor __and__(const Tensor & self, Scalar other);
CAFFE2_API Tensor __and__(const Tensor & self, const Tensor & other);
CAFFE2_API Tensor & bitwise_or_out(Tensor & out, const Tensor & self, const Tensor & other);
CAFFE2_API Tensor & bitwise_or_out(Tensor & out, const Tensor & self, Scalar other);
CAFFE2_API Tensor bitwise_or(const Tensor & self, Scalar other);
CAFFE2_API Tensor bitwise_or(const Tensor & self, const Tensor & other);
CAFFE2_API Tensor __or__(const Tensor & self, Scalar other);
CAFFE2_API Tensor __or__(const Tensor & self, const Tensor & other);
CAFFE2_API Tensor & bitwise_xor_out(Tensor & out, const Tensor & self, const Tensor & other);
CAFFE2_API Tensor & bitwise_xor_out(Tensor & out, const Tensor & self, Scalar other);
CAFFE2_API Tensor bitwise_xor(const Tensor & self, Scalar other);
CAFFE2_API Tensor bitwise_xor(const Tensor & self, const Tensor & other);
CAFFE2_API Tensor __xor__(const Tensor & self, Scalar other);
CAFFE2_API Tensor __xor__(const Tensor & self, const Tensor & other);
CAFFE2_API Tensor __lshift__(const Tensor & self, Scalar other);
CAFFE2_API Tensor __lshift__(const Tensor & self, const Tensor & other);
CAFFE2_API Tensor __rshift__(const Tensor & self, Scalar other);
CAFFE2_API Tensor __rshift__(const Tensor & self, const Tensor & other);
CAFFE2_API Tensor & addbmm_out(Tensor & out, const Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta=1, Scalar alpha=1);
CAFFE2_API Tensor addbmm(const Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta=1, Scalar alpha=1);
CAFFE2_API Tensor & diag_out(Tensor & out, const Tensor & self, int64_t diagonal=0);
CAFFE2_API Tensor diag(const Tensor & self, int64_t diagonal=0);
CAFFE2_API Tensor & cross_out(Tensor & out, const Tensor & self, const Tensor & other, c10::optional<int64_t> dim=c10::nullopt);
CAFFE2_API Tensor cross(const Tensor & self, const Tensor & other, c10::optional<int64_t> dim=c10::nullopt);
CAFFE2_API Tensor & triu_out(Tensor & out, const Tensor & self, int64_t diagonal=0);
CAFFE2_API Tensor triu(const Tensor & self, int64_t diagonal=0);
CAFFE2_API Tensor & tril_out(Tensor & out, const Tensor & self, int64_t diagonal=0);
CAFFE2_API Tensor tril(const Tensor & self, int64_t diagonal=0);
CAFFE2_API Tensor tril_indices(int64_t row, int64_t col, int64_t offset=0, const TensorOptions & options=at::kLong);
CAFFE2_API Tensor triu_indices(int64_t row, int64_t col, int64_t offset=0, const TensorOptions & options=at::kLong);
CAFFE2_API Tensor trace(const Tensor & self);
CAFFE2_API Tensor & ne_out(Tensor & out, const Tensor & self, Scalar other);
CAFFE2_API Tensor ne(const Tensor & self, Scalar other);
CAFFE2_API Tensor & ne_out(Tensor & out, const Tensor & self, const Tensor & other);
CAFFE2_API Tensor ne(const Tensor & self, const Tensor & other);
CAFFE2_API Tensor & eq_out(Tensor & out, const Tensor & self, Scalar other);
CAFFE2_API Tensor eq(const Tensor & self, Scalar other);
CAFFE2_API Tensor & eq_out(Tensor & out, const Tensor & self, const Tensor & other);
CAFFE2_API Tensor eq(const Tensor & self, const Tensor & other);
CAFFE2_API Tensor & ge_out(Tensor & out, const Tensor & self, Scalar other);
CAFFE2_API Tensor ge(const Tensor & self, Scalar other);
CAFFE2_API Tensor & ge_out(Tensor & out, const Tensor & self, const Tensor & other);
CAFFE2_API Tensor ge(const Tensor & self, const Tensor & other);
CAFFE2_API Tensor & le_out(Tensor & out, const Tensor & self, Scalar other);
CAFFE2_API Tensor le(const Tensor & self, Scalar other);
CAFFE2_API Tensor & le_out(Tensor & out, const Tensor & self, const Tensor & other);
CAFFE2_API Tensor le(const Tensor & self, const Tensor & other);
CAFFE2_API Tensor & gt_out(Tensor & out, const Tensor & self, Scalar other);
CAFFE2_API Tensor gt(const Tensor & self, Scalar other);
CAFFE2_API Tensor & gt_out(Tensor & out, const Tensor & self, const Tensor & other);
CAFFE2_API Tensor gt(const Tensor & self, const Tensor & other);
CAFFE2_API Tensor & lt_out(Tensor & out, const Tensor & self, Scalar other);
CAFFE2_API Tensor lt(const Tensor & self, Scalar other);
CAFFE2_API Tensor & lt_out(Tensor & out, const Tensor & self, const Tensor & other);
CAFFE2_API Tensor lt(const Tensor & self, const Tensor & other);
CAFFE2_API Tensor & take_out(Tensor & out, const Tensor & self, const Tensor & index);
CAFFE2_API Tensor take(const Tensor & self, const Tensor & index);
CAFFE2_API Tensor & index_select_out(Tensor & out, const Tensor & self, int64_t dim, const Tensor & index);
CAFFE2_API Tensor index_select(const Tensor & self, int64_t dim, const Tensor & index);
CAFFE2_API Tensor & index_select_out(Tensor & out, const Tensor & self, Dimname dim, const Tensor & index);
CAFFE2_API Tensor index_select(const Tensor & self, Dimname dim, const Tensor & index);
CAFFE2_API Tensor & masked_select_out(Tensor & out, const Tensor & self, const Tensor & mask);
CAFFE2_API Tensor masked_select(const Tensor & self, const Tensor & mask);
CAFFE2_API Tensor & nonzero_out(Tensor & out, const Tensor & self);
CAFFE2_API Tensor nonzero(const Tensor & self);
CAFFE2_API std::vector<Tensor> nonzero_numpy(const Tensor & self);
CAFFE2_API Tensor & gather_out(Tensor & out, const Tensor & self, int64_t dim, const Tensor & index, bool sparse_grad=false);
CAFFE2_API Tensor gather(const Tensor & self, int64_t dim, const Tensor & index, bool sparse_grad=false);
CAFFE2_API Tensor & gather_out(Tensor & out, const Tensor & self, Dimname dim, const Tensor & index, bool sparse_grad=false);
CAFFE2_API Tensor gather(const Tensor & self, Dimname dim, const Tensor & index, bool sparse_grad=false);
CAFFE2_API Tensor _gather_sparse_backward(const Tensor & self, int64_t dim, const Tensor & index, const Tensor & grad);
CAFFE2_API Tensor & addcmul_out(Tensor & out, const Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value=1);
CAFFE2_API Tensor addcmul(const Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value=1);
CAFFE2_API Tensor & addcdiv_out(Tensor & out, const Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value=1);
CAFFE2_API Tensor addcdiv(const Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value=1);
CAFFE2_API std::tuple<Tensor &,Tensor &> lstsq_out(Tensor & X, Tensor & qr, const Tensor & self, const Tensor & A);
CAFFE2_API std::tuple<Tensor,Tensor> lstsq(const Tensor & self, const Tensor & A);
CAFFE2_API std::tuple<Tensor &,Tensor &> triangular_solve_out(Tensor & X, Tensor & M, const Tensor & self, const Tensor & A, bool upper=true, bool transpose=false, bool unitriangular=false);
CAFFE2_API std::tuple<Tensor,Tensor> triangular_solve(const Tensor & self, const Tensor & A, bool upper=true, bool transpose=false, bool unitriangular=false);
CAFFE2_API std::tuple<Tensor,Tensor> _triangular_solve_helper(const Tensor & self, const Tensor & A, bool upper, bool transpose, bool unitriangular);
CAFFE2_API std::tuple<Tensor &,Tensor &> symeig_out(Tensor & e, Tensor & V, const Tensor & self, bool eigenvectors=false, bool upper=true);
CAFFE2_API std::tuple<Tensor,Tensor> symeig(const Tensor & self, bool eigenvectors=false, bool upper=true);
CAFFE2_API std::tuple<Tensor,Tensor> _symeig_helper(const Tensor & self, bool eigenvectors, bool upper);
CAFFE2_API std::tuple<Tensor &,Tensor &> eig_out(Tensor & e, Tensor & v, const Tensor & self, bool eigenvectors=false);
CAFFE2_API std::tuple<Tensor,Tensor> eig(const Tensor & self, bool eigenvectors=false);
CAFFE2_API std::tuple<Tensor &,Tensor &,Tensor &> svd_out(Tensor & U, Tensor & S, Tensor & V, const Tensor & self, bool some=true, bool compute_uv=true);
CAFFE2_API std::tuple<Tensor,Tensor,Tensor> svd(const Tensor & self, bool some=true, bool compute_uv=true);
CAFFE2_API std::tuple<Tensor,Tensor,Tensor> _svd_helper(const Tensor & self, bool some, bool compute_uv);
CAFFE2_API Tensor & cholesky_out(Tensor & out, const Tensor & self, bool upper=false);
CAFFE2_API Tensor cholesky(const Tensor & self, bool upper=false);
CAFFE2_API Tensor _cholesky_helper(const Tensor & self, bool upper);
CAFFE2_API Tensor & cholesky_solve_out(Tensor & out, const Tensor & self, const Tensor & input2, bool upper=false);
CAFFE2_API Tensor cholesky_solve(const Tensor & self, const Tensor & input2, bool upper=false);
CAFFE2_API Tensor _cholesky_solve_helper(const Tensor & self, const Tensor & A, bool upper);
CAFFE2_API std::tuple<Tensor,Tensor> solve(const Tensor & self, const Tensor & A);
CAFFE2_API std::tuple<Tensor &,Tensor &> solve_out(Tensor & solution, Tensor & lu, const Tensor & self, const Tensor & A);
CAFFE2_API std::tuple<Tensor,Tensor> _solve_helper(const Tensor & self, const Tensor & A);
CAFFE2_API Tensor & cholesky_inverse_out(Tensor & out, const Tensor & self, bool upper=false);
CAFFE2_API Tensor cholesky_inverse(const Tensor & self, bool upper=false);
CAFFE2_API std::tuple<Tensor &,Tensor &> qr_out(Tensor & Q, Tensor & R, const Tensor & self, bool some=true);
CAFFE2_API std::tuple<Tensor,Tensor> qr(const Tensor & self, bool some=true);
CAFFE2_API std::tuple<Tensor,Tensor> _qr_helper(const Tensor & self, bool some);
CAFFE2_API std::tuple<Tensor &,Tensor &> geqrf_out(Tensor & a, Tensor & tau, const Tensor & self);
CAFFE2_API std::tuple<Tensor,Tensor> geqrf(const Tensor & self);
CAFFE2_API Tensor & orgqr_out(Tensor & out, const Tensor & self, const Tensor & input2);
CAFFE2_API Tensor orgqr(const Tensor & self, const Tensor & input2);
CAFFE2_API Tensor & ormqr_out(Tensor & out, const Tensor & self, const Tensor & input2, const Tensor & input3, bool left=true, bool transpose=false);
CAFFE2_API Tensor ormqr(const Tensor & self, const Tensor & input2, const Tensor & input3, bool left=true, bool transpose=false);
CAFFE2_API std::tuple<Tensor,Tensor,Tensor> _lu_with_info(const Tensor & self, bool pivot=true, bool check_errors=true);
CAFFE2_API Tensor & lu_solve_out(Tensor & out, const Tensor & self, const Tensor & LU_data, const Tensor & LU_pivots);
CAFFE2_API Tensor lu_solve(const Tensor & self, const Tensor & LU_data, const Tensor & LU_pivots);
CAFFE2_API Tensor _lu_solve_helper(const Tensor & self, const Tensor & LU_data, const Tensor & LU_pivots);
CAFFE2_API Tensor & multinomial_out(Tensor & out, const Tensor & self, int64_t num_samples, bool replacement=false, c10::optional<Generator> generator=c10::nullopt);
CAFFE2_API Tensor multinomial(const Tensor & self, int64_t num_samples, bool replacement=false, c10::optional<Generator> generator=c10::nullopt);
CAFFE2_API std::tuple<Tensor,Tensor> _multinomial_alias_setup(const Tensor & probs);
CAFFE2_API Tensor _multinomial_alias_draw(const Tensor & J, const Tensor & q, int64_t num_samples, c10::optional<Generator> generator=c10::nullopt);
CAFFE2_API Tensor & lgamma_out(Tensor & out, const Tensor & self);
CAFFE2_API Tensor lgamma(const Tensor & self);
CAFFE2_API Tensor & digamma_out(Tensor & out, const Tensor & self);
CAFFE2_API Tensor digamma(const Tensor & self);
CAFFE2_API Tensor & polygamma_out(Tensor & out, int64_t n, const Tensor & self);
CAFFE2_API Tensor polygamma(int64_t n, const Tensor & self);
CAFFE2_API Tensor erfinv(const Tensor & self);
CAFFE2_API Tensor & erfinv_out(Tensor & out, const Tensor & self);
CAFFE2_API Tensor sign(const Tensor & self);
CAFFE2_API Tensor & sign_out(Tensor & out, const Tensor & self);
CAFFE2_API Tensor dist(const Tensor & self, const Tensor & other, Scalar p=2);
CAFFE2_API Tensor & atan2_out(Tensor & out, const Tensor & self, const Tensor & other);
CAFFE2_API Tensor atan2(const Tensor & self, const Tensor & other);
CAFFE2_API Tensor & lerp_out(Tensor & out, const Tensor & self, const Tensor & end, Scalar weight);
CAFFE2_API Tensor & lerp_out(Tensor & out, const Tensor & self, const Tensor & end, const Tensor & weight);
CAFFE2_API Tensor lerp(const Tensor & self, const Tensor & end, Scalar weight);
CAFFE2_API Tensor lerp(const Tensor & self, const Tensor & end, const Tensor & weight);
CAFFE2_API Tensor & histc_out(Tensor & out, const Tensor & self, int64_t bins=100, Scalar min=0, Scalar max=0);
CAFFE2_API Tensor histc(const Tensor & self, int64_t bins=100, Scalar min=0, Scalar max=0);
CAFFE2_API Tensor & fmod_out(Tensor & out, const Tensor & self, Scalar other);
CAFFE2_API Tensor fmod(const Tensor & self, Scalar other);
CAFFE2_API Tensor & fmod_out(Tensor & out, const Tensor & self, const Tensor & other);
CAFFE2_API Tensor fmod(const Tensor & self, const Tensor & other);
CAFFE2_API Tensor & remainder_out(Tensor & out, const Tensor & self, Scalar other);
CAFFE2_API Tensor remainder(const Tensor & self, Scalar other);
CAFFE2_API Tensor & remainder_out(Tensor & out, const Tensor & self, const Tensor & other);
CAFFE2_API Tensor remainder(const Tensor & self, const Tensor & other);
CAFFE2_API Tensor & min_out(Tensor & out, const Tensor & self, const Tensor & other);
CAFFE2_API Tensor min(const Tensor & self, const Tensor & other);
CAFFE2_API Tensor min(const Tensor & self);
CAFFE2_API Tensor & max_out(Tensor & out, const Tensor & self, const Tensor & other);
CAFFE2_API Tensor max(const Tensor & self, const Tensor & other);
CAFFE2_API Tensor max(const Tensor & self);
CAFFE2_API Tensor median(const Tensor & self);
CAFFE2_API std::tuple<Tensor &,Tensor &> sort_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t dim=-1, bool descending=false);
CAFFE2_API std::tuple<Tensor,Tensor> sort(const Tensor & self, int64_t dim=-1, bool descending=false);
CAFFE2_API std::tuple<Tensor &,Tensor &> sort_out(Tensor & values, Tensor & indices, const Tensor & self, Dimname dim, bool descending=false);
CAFFE2_API std::tuple<Tensor,Tensor> sort(const Tensor & self, Dimname dim, bool descending=false);
CAFFE2_API Tensor argsort(const Tensor & self, int64_t dim=-1, bool descending=false);
CAFFE2_API Tensor argsort(const Tensor & self, Dimname dim, bool descending=false);
CAFFE2_API std::tuple<Tensor &,Tensor &> topk_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t k, int64_t dim=-1, bool largest=true, bool sorted=true);
CAFFE2_API std::tuple<Tensor,Tensor> topk(const Tensor & self, int64_t k, int64_t dim=-1, bool largest=true, bool sorted=true);
CAFFE2_API Tensor all(const Tensor & self);
CAFFE2_API Tensor any(const Tensor & self);
CAFFE2_API Tensor & renorm_out(Tensor & out, const Tensor & self, Scalar p, int64_t dim, Scalar maxnorm);
CAFFE2_API Tensor renorm(const Tensor & self, Scalar p, int64_t dim, Scalar maxnorm);
CAFFE2_API Tensor unfold_backward(const Tensor & grad_in, IntArrayRef input_sizes, int64_t dim, int64_t size, int64_t step);
CAFFE2_API bool equal(const Tensor & self, const Tensor & other);
CAFFE2_API Tensor & pow_out(Tensor & out, const Tensor & self, const Tensor & exponent);
CAFFE2_API Tensor pow(const Tensor & self, const Tensor & exponent);
CAFFE2_API Tensor & pow_out(Tensor & out, Scalar self, const Tensor & exponent);
CAFFE2_API Tensor pow(Scalar self, const Tensor & exponent);
CAFFE2_API Tensor & normal_out(Tensor & out, const Tensor & mean, double std=1, c10::optional<Generator> generator=c10::nullopt);
CAFFE2_API Tensor normal(const Tensor & mean, double std=1, c10::optional<Generator> generator=c10::nullopt);
CAFFE2_API Tensor & normal_out(Tensor & out, double mean, const Tensor & std, c10::optional<Generator> generator=c10::nullopt);
CAFFE2_API Tensor normal(double mean, const Tensor & std, c10::optional<Generator> generator=c10::nullopt);
CAFFE2_API Tensor & normal_out(Tensor & out, const Tensor & mean, const Tensor & std, c10::optional<Generator> generator=c10::nullopt);
CAFFE2_API Tensor normal(const Tensor & mean, const Tensor & std, c10::optional<Generator> generator=c10::nullopt);
CAFFE2_API Tensor normal(double mean, double std, IntArrayRef size, c10::optional<Generator> generator=c10::nullopt, const TensorOptions & options={});
CAFFE2_API Tensor & normal_out(Tensor & out, double mean, double std, IntArrayRef size, c10::optional<Generator> generator=c10::nullopt);
CAFFE2_API Tensor alias(const Tensor & self);
CAFFE2_API Tensor _addr(const Tensor & self, const Tensor & vec1, const Tensor & vec2, Scalar beta=1, Scalar alpha=1);
CAFFE2_API Tensor & _addr_(Tensor & self, const Tensor & vec1, const Tensor & vec2, Scalar beta=1, Scalar alpha=1);
CAFFE2_API Tensor & _addr_out(Tensor & out, const Tensor & self, const Tensor & vec1, const Tensor & vec2, Scalar beta=1, Scalar alpha=1);
CAFFE2_API Tensor & _index_copy_(Tensor & self, int64_t dim, const Tensor & index, const Tensor & source);
CAFFE2_API Tensor _cumsum(const Tensor & self, int64_t dim);
CAFFE2_API Tensor & _cumsum_out(Tensor & out, const Tensor & self, int64_t dim);
CAFFE2_API Tensor _cumprod(const Tensor & self, int64_t dim);
CAFFE2_API Tensor & _cumprod_out(Tensor & out, const Tensor & self, int64_t dim);
CAFFE2_API void _amp_non_finite_check_and_unscale_(Tensor & self, Tensor & found_inf, const Tensor & inv_scale);
CAFFE2_API Tensor _amp_update_scale(Tensor & growth_tracker, const Tensor & current_scale, const Tensor & found_inf, double scale_growth_factor, double scale_backoff_factor, int64_t growth_interval);
CAFFE2_API Tensor _cat(TensorList tensors, int64_t dim=0);
CAFFE2_API Tensor & _cat_out(Tensor & out, TensorList tensors, int64_t dim=0);
CAFFE2_API std::tuple<Tensor,Tensor> _mode(const Tensor & self, int64_t dim=-1, bool keepdim=false);
CAFFE2_API std::tuple<Tensor &,Tensor &> _mode_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t dim=-1, bool keepdim=false);
CAFFE2_API Tensor bucketize(const Tensor & self, const Tensor & boundaries, bool out_int32=false, bool right=false);
CAFFE2_API Tensor & bucketize_out(Tensor & out, const Tensor & self, const Tensor & boundaries, bool out_int32=false, bool right=false);
CAFFE2_API Tensor bucketize(Scalar self, const Tensor & boundaries, bool out_int32=false, bool right=false);
CAFFE2_API Tensor searchsorted(const Tensor & sorted_sequence, const Tensor & self, bool out_int32=false, bool right=false);
CAFFE2_API Tensor & searchsorted_out(Tensor & out, const Tensor & sorted_sequence, const Tensor & self, bool out_int32=false, bool right=false);
CAFFE2_API Tensor searchsorted(const Tensor & sorted_sequence, Scalar self, bool out_int32=false, bool right=false);
CAFFE2_API Tensor & mse_loss_out(Tensor & out, const Tensor & self, const Tensor & target, int64_t reduction=at::Reduction::Mean);
CAFFE2_API Tensor mse_loss(const Tensor & self, const Tensor & target, int64_t reduction=at::Reduction::Mean);
CAFFE2_API Tensor & mse_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction);
CAFFE2_API Tensor mse_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction);
CAFFE2_API Tensor & l1_loss_out(Tensor & out, const Tensor & self, const Tensor & target, int64_t reduction=at::Reduction::Mean);
CAFFE2_API Tensor l1_loss(const Tensor & self, const Tensor & target, int64_t reduction=at::Reduction::Mean);
CAFFE2_API Tensor & l1_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction);
CAFFE2_API Tensor l1_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction);
CAFFE2_API Tensor & multi_margin_loss_out(Tensor & out, const Tensor & self, const Tensor & target, Scalar p=1, Scalar margin=1, const Tensor & weight={}, int64_t reduction=at::Reduction::Mean);
CAFFE2_API Tensor multi_margin_loss(const Tensor & self, const Tensor & target, Scalar p=1, Scalar margin=1, const Tensor & weight={}, int64_t reduction=at::Reduction::Mean);
CAFFE2_API Tensor & multi_margin_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, Scalar p, Scalar margin, const Tensor & weight={}, int64_t reduction=at::Reduction::Mean);
CAFFE2_API Tensor multi_margin_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, Scalar p, Scalar margin, const Tensor & weight={}, int64_t reduction=at::Reduction::Mean);
CAFFE2_API Tensor & multilabel_margin_loss_out(Tensor & out, const Tensor & self, const Tensor & target, int64_t reduction=at::Reduction::Mean);
CAFFE2_API Tensor multilabel_margin_loss(const Tensor & self, const Tensor & target, int64_t reduction=at::Reduction::Mean);
CAFFE2_API std::tuple<Tensor &,Tensor &> multilabel_margin_loss_forward_out(Tensor & output, Tensor & is_target, const Tensor & self, const Tensor & target, int64_t reduction);
CAFFE2_API std::tuple<Tensor,Tensor> multilabel_margin_loss_forward(const Tensor & self, const Tensor & target, int64_t reduction);
CAFFE2_API Tensor & multilabel_margin_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction, const Tensor & is_target);
CAFFE2_API Tensor multilabel_margin_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction, const Tensor & is_target);
CAFFE2_API Tensor & nll_loss_out(Tensor & out, const Tensor & self, const Tensor & target, const Tensor & weight={}, int64_t reduction=at::Reduction::Mean, int64_t ignore_index=-100);
CAFFE2_API Tensor nll_loss(const Tensor & self, const Tensor & target, const Tensor & weight={}, int64_t reduction=at::Reduction::Mean, int64_t ignore_index=-100);
CAFFE2_API std::tuple<Tensor &,Tensor &> nll_loss_forward_out(Tensor & output, Tensor & total_weight, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index);
CAFFE2_API std::tuple<Tensor,Tensor> nll_loss_forward(const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index);
CAFFE2_API Tensor & nll_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index, const Tensor & total_weight);
CAFFE2_API Tensor nll_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index, const Tensor & total_weight);
CAFFE2_API Tensor & nll_loss2d_out(Tensor & out, const Tensor & self, const Tensor & target, const Tensor & weight={}, int64_t reduction=at::Reduction::Mean, int64_t ignore_index=-100);
CAFFE2_API Tensor nll_loss2d(const Tensor & self, const Tensor & target, const Tensor & weight={}, int64_t reduction=at::Reduction::Mean, int64_t ignore_index=-100);
CAFFE2_API std::tuple<Tensor &,Tensor &> nll_loss2d_forward_out(Tensor & output, Tensor & total_weight, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index);
CAFFE2_API std::tuple<Tensor,Tensor> nll_loss2d_forward(const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index);
CAFFE2_API Tensor & nll_loss2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index, const Tensor & total_weight);
CAFFE2_API Tensor nll_loss2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index, const Tensor & total_weight);
CAFFE2_API Tensor & smooth_l1_loss_out(Tensor & out, const Tensor & self, const Tensor & target, int64_t reduction=at::Reduction::Mean);
CAFFE2_API Tensor smooth_l1_loss(const Tensor & self, const Tensor & target, int64_t reduction=at::Reduction::Mean);
CAFFE2_API Tensor & smooth_l1_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction);
CAFFE2_API Tensor smooth_l1_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction);
CAFFE2_API Tensor & soft_margin_loss_out(Tensor & out, const Tensor & self, const Tensor & target, int64_t reduction=at::Reduction::Mean);
CAFFE2_API Tensor soft_margin_loss(const Tensor & self, const Tensor & target, int64_t reduction=at::Reduction::Mean);
CAFFE2_API Tensor & soft_margin_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction);
CAFFE2_API Tensor soft_margin_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction);
CAFFE2_API Tensor & elu_out(Tensor & out, const Tensor & self, Scalar alpha=1, Scalar scale=1, Scalar input_scale=1);
CAFFE2_API Tensor elu(const Tensor & self, Scalar alpha=1, Scalar scale=1, Scalar input_scale=1);
CAFFE2_API Tensor & elu_backward_out(Tensor & grad_input, const Tensor & grad_output, Scalar alpha, Scalar scale, Scalar input_scale, const Tensor & output);
CAFFE2_API Tensor elu_backward(const Tensor & grad_output, Scalar alpha, Scalar scale, Scalar input_scale, const Tensor & output);
CAFFE2_API Tensor & elu_(Tensor & self, Scalar alpha=1, Scalar scale=1, Scalar input_scale=1);
CAFFE2_API Tensor & glu_out(Tensor & out, const Tensor & self, int64_t dim=-1);
CAFFE2_API Tensor glu(const Tensor & self, int64_t dim=-1);
CAFFE2_API Tensor & glu_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, int64_t dim);
CAFFE2_API Tensor glu_backward(const Tensor & grad_output, const Tensor & self, int64_t dim);
CAFFE2_API Tensor & hardsigmoid_out(Tensor & out, const Tensor & self);
CAFFE2_API Tensor hardsigmoid(const Tensor & self);
CAFFE2_API Tensor & hardsigmoid_(Tensor & self);
CAFFE2_API Tensor hardsigmoid_backward(const Tensor & grad_output, const Tensor & self);
CAFFE2_API Tensor & hardtanh_out(Tensor & out, const Tensor & self, Scalar min_val=-1, Scalar max_val=1);
CAFFE2_API Tensor hardtanh(const Tensor & self, Scalar min_val=-1, Scalar max_val=1);
CAFFE2_API Tensor & hardtanh_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, Scalar min_val, Scalar max_val);
CAFFE2_API Tensor hardtanh_backward(const Tensor & grad_output, const Tensor & self, Scalar min_val, Scalar max_val);
CAFFE2_API Tensor & hardtanh_(Tensor & self, Scalar min_val=-1, Scalar max_val=1);
CAFFE2_API Tensor & hardswish_out(Tensor & out, const Tensor & self);
CAFFE2_API Tensor hardswish(const Tensor & self);
CAFFE2_API Tensor & hardswish_(Tensor & self);
CAFFE2_API Tensor hardswish_backward(const Tensor & grad_output, const Tensor & self);
CAFFE2_API Tensor & leaky_relu_out(Tensor & out, const Tensor & self, Scalar negative_slope=0.01);
CAFFE2_API Tensor leaky_relu(const Tensor & self, Scalar negative_slope=0.01);
CAFFE2_API Tensor leaky_relu_backward(const Tensor & grad_output, const Tensor & self, Scalar negative_slope, bool self_is_result);
CAFFE2_API Tensor & leaky_relu_(Tensor & self, Scalar negative_slope=0.01);
CAFFE2_API Tensor & log_sigmoid_out(Tensor & out, const Tensor & self);
CAFFE2_API Tensor log_sigmoid(const Tensor & self);
CAFFE2_API std::tuple<Tensor &,Tensor &> log_sigmoid_forward_out(Tensor & output, Tensor & buffer, const Tensor & self);
CAFFE2_API std::tuple<Tensor,Tensor> log_sigmoid_forward(const Tensor & self);
CAFFE2_API Tensor & log_sigmoid_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & buffer);
CAFFE2_API Tensor log_sigmoid_backward(const Tensor & grad_output, const Tensor & self, const Tensor & buffer);
CAFFE2_API Tensor & rrelu_with_noise_out(Tensor & out, const Tensor & self, const Tensor & noise, Scalar lower=0.125, Scalar upper=0.3333333333333333, bool training=false, c10::optional<Generator> generator=c10::nullopt);
CAFFE2_API Tensor rrelu_with_noise(const Tensor & self, const Tensor & noise, Scalar lower=0.125, Scalar upper=0.3333333333333333, bool training=false, c10::optional<Generator> generator=c10::nullopt);
CAFFE2_API Tensor rrelu_with_noise_backward(const Tensor & grad_output, const Tensor & self, const Tensor & noise, Scalar lower, Scalar upper, bool training, bool self_is_result);
CAFFE2_API Tensor & rrelu_with_noise_(Tensor & self, const Tensor & noise, Scalar lower=0.125, Scalar upper=0.3333333333333333, bool training=false, c10::optional<Generator> generator=c10::nullopt);
CAFFE2_API Tensor & softplus_out(Tensor & out, const Tensor & self, Scalar beta=1, Scalar threshold=20);
CAFFE2_API Tensor softplus(const Tensor & self, Scalar beta=1, Scalar threshold=20);
CAFFE2_API Tensor & softplus_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, Scalar beta, Scalar threshold, const Tensor & output);
CAFFE2_API Tensor softplus_backward(const Tensor & grad_output, const Tensor & self, Scalar beta, Scalar threshold, const Tensor & output);
CAFFE2_API Tensor & softshrink_out(Tensor & out, const Tensor & self, Scalar lambd=0.5);
CAFFE2_API Tensor softshrink(const Tensor & self, Scalar lambd=0.5);
CAFFE2_API Tensor & softshrink_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, Scalar lambd);
CAFFE2_API Tensor softshrink_backward(const Tensor & grad_output, const Tensor & self, Scalar lambd);
CAFFE2_API Tensor & adaptive_avg_pool2d_out(Tensor & out, const Tensor & self, IntArrayRef output_size);
CAFFE2_API Tensor adaptive_avg_pool2d(const Tensor & self, IntArrayRef output_size);
CAFFE2_API Tensor mkldnn_adaptive_avg_pool2d(const Tensor & self, IntArrayRef output_size);
CAFFE2_API Tensor _adaptive_avg_pool2d(const Tensor & self, IntArrayRef output_size);
CAFFE2_API Tensor _adaptive_avg_pool2d_backward(const Tensor & grad_output, const Tensor & self);
CAFFE2_API Tensor & adaptive_avg_pool3d_out(Tensor & out, const Tensor & self, IntArrayRef output_size);
CAFFE2_API Tensor adaptive_avg_pool3d(const Tensor & self, IntArrayRef output_size);
CAFFE2_API Tensor & adaptive_avg_pool3d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self);
CAFFE2_API Tensor adaptive_avg_pool3d_backward(const Tensor & grad_output, const Tensor & self);
CAFFE2_API std::tuple<Tensor &,Tensor &> adaptive_max_pool2d_out(Tensor & out, Tensor & indices, const Tensor & self, IntArrayRef output_size);
CAFFE2_API std::tuple<Tensor,Tensor> adaptive_max_pool2d(const Tensor & self, IntArrayRef output_size);
CAFFE2_API Tensor & adaptive_max_pool2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & indices);
CAFFE2_API Tensor adaptive_max_pool2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & indices);
CAFFE2_API std::tuple<Tensor &,Tensor &> adaptive_max_pool3d_out(Tensor & out, Tensor & indices, const Tensor & self, IntArrayRef output_size);
CAFFE2_API std::tuple<Tensor,Tensor> adaptive_max_pool3d(const Tensor & self, IntArrayRef output_size);
CAFFE2_API Tensor & adaptive_max_pool3d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & indices);
CAFFE2_API Tensor adaptive_max_pool3d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & indices);
CAFFE2_API Tensor & avg_pool2d_out(Tensor & out, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride={}, IntArrayRef padding=0, bool ceil_mode=false, bool count_include_pad=true, c10::optional<int64_t> divisor_override=c10::nullopt);
CAFFE2_API Tensor avg_pool2d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride={}, IntArrayRef padding=0, bool ceil_mode=false, bool count_include_pad=true, c10::optional<int64_t> divisor_override=c10::nullopt);
CAFFE2_API Tensor & avg_pool2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad, c10::optional<int64_t> divisor_override);
CAFFE2_API Tensor avg_pool2d_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad, c10::optional<int64_t> divisor_override);
CAFFE2_API Tensor & avg_pool3d_out(Tensor & out, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride={}, IntArrayRef padding=0, bool ceil_mode=false, bool count_include_pad=true, c10::optional<int64_t> divisor_override=c10::nullopt);
CAFFE2_API Tensor avg_pool3d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride={}, IntArrayRef padding=0, bool ceil_mode=false, bool count_include_pad=true, c10::optional<int64_t> divisor_override=c10::nullopt);
CAFFE2_API Tensor & avg_pool3d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad, c10::optional<int64_t> divisor_override);
CAFFE2_API Tensor avg_pool3d_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad, c10::optional<int64_t> divisor_override);
CAFFE2_API std::tuple<Tensor &,Tensor &> fractional_max_pool2d_out(Tensor & output, Tensor & indices, const Tensor & self, IntArrayRef kernel_size, IntArrayRef output_size, const Tensor & random_samples);
CAFFE2_API std::tuple<Tensor,Tensor> fractional_max_pool2d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef output_size, const Tensor & random_samples);
CAFFE2_API Tensor & fractional_max_pool2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef output_size, const Tensor & indices);
CAFFE2_API Tensor fractional_max_pool2d_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef output_size, const Tensor & indices);
CAFFE2_API std::tuple<Tensor &,Tensor &> fractional_max_pool3d_out(Tensor & output, Tensor & indices, const Tensor & self, IntArrayRef kernel_size, IntArrayRef output_size, const Tensor & random_samples);
CAFFE2_API std::tuple<Tensor,Tensor> fractional_max_pool3d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef output_size, const Tensor & random_samples);
CAFFE2_API Tensor & fractional_max_pool3d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef output_size, const Tensor & indices);
CAFFE2_API Tensor fractional_max_pool3d_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef output_size, const Tensor & indices);
CAFFE2_API std::tuple<Tensor &,Tensor &> max_pool2d_with_indices_out(Tensor & out, Tensor & indices, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride={}, IntArrayRef padding=0, IntArrayRef dilation=1, bool ceil_mode=false);
CAFFE2_API std::tuple<Tensor,Tensor> max_pool2d_with_indices(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride={}, IntArrayRef padding=0, IntArrayRef dilation=1, bool ceil_mode=false);
CAFFE2_API Tensor & max_pool2d_with_indices_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode, const Tensor & indices);
CAFFE2_API Tensor max_pool2d_with_indices_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode, const Tensor & indices);
CAFFE2_API std::tuple<Tensor &,Tensor &> max_pool3d_with_indices_out(Tensor & out, Tensor & indices, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride={}, IntArrayRef padding=0, IntArrayRef dilation=1, bool ceil_mode=false);
CAFFE2_API std::tuple<Tensor,Tensor> max_pool3d_with_indices(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride={}, IntArrayRef padding=0, IntArrayRef dilation=1, bool ceil_mode=false);
CAFFE2_API Tensor & max_pool3d_with_indices_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode, const Tensor & indices);
CAFFE2_API Tensor max_pool3d_with_indices_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode, const Tensor & indices);
CAFFE2_API Tensor & max_unpool2d_out(Tensor & out, const Tensor & self, const Tensor & indices, IntArrayRef output_size);
CAFFE2_API Tensor max_unpool2d(const Tensor & self, const Tensor & indices, IntArrayRef output_size);
CAFFE2_API Tensor & max_unpool2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & indices, IntArrayRef output_size);
CAFFE2_API Tensor max_unpool2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & indices, IntArrayRef output_size);
CAFFE2_API Tensor & max_unpool3d_out(Tensor & out, const Tensor & self, const Tensor & indices, IntArrayRef output_size, IntArrayRef stride, IntArrayRef padding);
CAFFE2_API Tensor max_unpool3d(const Tensor & self, const Tensor & indices, IntArrayRef output_size, IntArrayRef stride, IntArrayRef padding);
CAFFE2_API Tensor & max_unpool3d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & indices, IntArrayRef output_size, IntArrayRef stride, IntArrayRef padding);
CAFFE2_API Tensor max_unpool3d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & indices, IntArrayRef output_size, IntArrayRef stride, IntArrayRef padding);
CAFFE2_API Tensor & reflection_pad1d_out(Tensor & out, const Tensor & self, IntArrayRef padding);
CAFFE2_API Tensor reflection_pad1d(const Tensor & self, IntArrayRef padding);
CAFFE2_API Tensor & reflection_pad1d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef padding);
CAFFE2_API Tensor reflection_pad1d_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef padding);
CAFFE2_API Tensor & reflection_pad2d_out(Tensor & out, const Tensor & self, IntArrayRef padding);
CAFFE2_API Tensor reflection_pad2d(const Tensor & self, IntArrayRef padding);
CAFFE2_API Tensor & reflection_pad2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef padding);
CAFFE2_API Tensor reflection_pad2d_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef padding);
CAFFE2_API Tensor & replication_pad1d_out(Tensor & out, const Tensor & self, IntArrayRef padding);
CAFFE2_API Tensor replication_pad1d(const Tensor & self, IntArrayRef padding);
CAFFE2_API Tensor & replication_pad1d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef padding);
CAFFE2_API Tensor replication_pad1d_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef padding);
CAFFE2_API Tensor & replication_pad2d_out(Tensor & out, const Tensor & self, IntArrayRef padding);
CAFFE2_API Tensor replication_pad2d(const Tensor & self, IntArrayRef padding);
CAFFE2_API Tensor & replication_pad2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef padding);
CAFFE2_API Tensor replication_pad2d_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef padding);
CAFFE2_API Tensor & replication_pad3d_out(Tensor & out, const Tensor & self, IntArrayRef padding);
CAFFE2_API Tensor replication_pad3d(const Tensor & self, IntArrayRef padding);
CAFFE2_API Tensor & replication_pad3d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef padding);
CAFFE2_API Tensor replication_pad3d_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef padding);
CAFFE2_API Tensor & upsample_linear1d_out(Tensor & out, const Tensor & self, IntArrayRef output_size, bool align_corners, c10::optional<double> scales=c10::nullopt);
CAFFE2_API Tensor upsample_linear1d(const Tensor & self, IntArrayRef output_size, bool align_corners, c10::optional<double> scales=c10::nullopt);
CAFFE2_API Tensor & upsample_linear1d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners, c10::optional<double> scales=c10::nullopt);
CAFFE2_API Tensor upsample_linear1d_backward(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners, c10::optional<double> scales=c10::nullopt);
CAFFE2_API Tensor & upsample_bilinear2d_out(Tensor & out, const Tensor & self, IntArrayRef output_size, bool align_corners, c10::optional<double> scales_h=c10::nullopt, c10::optional<double> scales_w=c10::nullopt);
CAFFE2_API Tensor upsample_bilinear2d(const Tensor & self, IntArrayRef output_size, bool align_corners, c10::optional<double> scales_h=c10::nullopt, c10::optional<double> scales_w=c10::nullopt);
CAFFE2_API Tensor & upsample_bilinear2d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners, c10::optional<double> scales_h=c10::nullopt, c10::optional<double> scales_w=c10::nullopt);
CAFFE2_API Tensor upsample_bilinear2d_backward(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners, c10::optional<double> scales_h=c10::nullopt, c10::optional<double> scales_w=c10::nullopt);
CAFFE2_API Tensor & upsample_bicubic2d_out(Tensor & out, const Tensor & self, IntArrayRef output_size, bool align_corners, c10::optional<double> scales_h=c10::nullopt, c10::optional<double> scales_w=c10::nullopt);
CAFFE2_API Tensor upsample_bicubic2d(const Tensor & self, IntArrayRef output_size, bool align_corners, c10::optional<double> scales_h=c10::nullopt, c10::optional<double> scales_w=c10::nullopt);
CAFFE2_API Tensor & upsample_bicubic2d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners, c10::optional<double> scales_h=c10::nullopt, c10::optional<double> scales_w=c10::nullopt);
CAFFE2_API Tensor upsample_bicubic2d_backward(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners, c10::optional<double> scales_h=c10::nullopt, c10::optional<double> scales_w=c10::nullopt);
CAFFE2_API Tensor & upsample_trilinear3d_out(Tensor & out, const Tensor & self, IntArrayRef output_size, bool align_corners, c10::optional<double> scales_d=c10::nullopt, c10::optional<double> scales_h=c10::nullopt, c10::optional<double> scales_w=c10::nullopt);
CAFFE2_API Tensor upsample_trilinear3d(const Tensor & self, IntArrayRef output_size, bool align_corners, c10::optional<double> scales_d=c10::nullopt, c10::optional<double> scales_h=c10::nullopt, c10::optional<double> scales_w=c10::nullopt);
CAFFE2_API Tensor & upsample_trilinear3d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners, c10::optional<double> scales_d=c10::nullopt, c10::optional<double> scales_h=c10::nullopt, c10::optional<double> scales_w=c10::nullopt);
CAFFE2_API Tensor upsample_trilinear3d_backward(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners, c10::optional<double> scales_d=c10::nullopt, c10::optional<double> scales_h=c10::nullopt, c10::optional<double> scales_w=c10::nullopt);
CAFFE2_API Tensor & upsample_nearest1d_out(Tensor & out, const Tensor & self, IntArrayRef output_size, c10::optional<double> scales=c10::nullopt);
CAFFE2_API Tensor upsample_nearest1d(const Tensor & self, IntArrayRef output_size, c10::optional<double> scales=c10::nullopt);
CAFFE2_API Tensor & upsample_nearest1d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, c10::optional<double> scales=c10::nullopt);
CAFFE2_API Tensor upsample_nearest1d_backward(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, c10::optional<double> scales=c10::nullopt);
CAFFE2_API Tensor & upsample_nearest2d_out(Tensor & out, const Tensor & self, IntArrayRef output_size, c10::optional<double> scales_h=c10::nullopt, c10::optional<double> scales_w=c10::nullopt);
CAFFE2_API Tensor upsample_nearest2d(const Tensor & self, IntArrayRef output_size, c10::optional<double> scales_h=c10::nullopt, c10::optional<double> scales_w=c10::nullopt);
CAFFE2_API Tensor & upsample_nearest2d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, c10::optional<double> scales_h=c10::nullopt, c10::optional<double> scales_w=c10::nullopt);
CAFFE2_API Tensor upsample_nearest2d_backward(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, c10::optional<double> scales_h=c10::nullopt, c10::optional<double> scales_w=c10::nullopt);
CAFFE2_API Tensor & upsample_nearest3d_out(Tensor & out, const Tensor & self, IntArrayRef output_size, c10::optional<double> scales_d=c10::nullopt, c10::optional<double> scales_h=c10::nullopt, c10::optional<double> scales_w=c10::nullopt);
CAFFE2_API Tensor upsample_nearest3d(const Tensor & self, IntArrayRef output_size, c10::optional<double> scales_d=c10::nullopt, c10::optional<double> scales_h=c10::nullopt, c10::optional<double> scales_w=c10::nullopt);
CAFFE2_API Tensor & upsample_nearest3d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, c10::optional<double> scales_d=c10::nullopt, c10::optional<double> scales_h=c10::nullopt, c10::optional<double> scales_w=c10::nullopt);
CAFFE2_API Tensor upsample_nearest3d_backward(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, c10::optional<double> scales_d=c10::nullopt, c10::optional<double> scales_h=c10::nullopt, c10::optional<double> scales_w=c10::nullopt);
CAFFE2_API Tensor & sigmoid_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & output);
CAFFE2_API Tensor sigmoid_backward(const Tensor & grad_output, const Tensor & output);
CAFFE2_API Tensor & tanh_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & output);
CAFFE2_API Tensor tanh_backward(const Tensor & grad_output, const Tensor & output);
CAFFE2_API Tensor & slow_conv_transpose2d_out(Tensor & out, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias={}, IntArrayRef stride=1, IntArrayRef padding=0, IntArrayRef output_padding=0, IntArrayRef dilation=1);
CAFFE2_API Tensor slow_conv_transpose2d(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias={}, IntArrayRef stride=1, IntArrayRef padding=0, IntArrayRef output_padding=0, IntArrayRef dilation=1);
CAFFE2_API std::tuple<Tensor &,Tensor &,Tensor &> slow_conv_transpose2d_backward_out(Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation, const Tensor & columns, const Tensor & ones);
CAFFE2_API std::tuple<Tensor,Tensor,Tensor> slow_conv_transpose2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation, const Tensor & columns, const Tensor & ones, std::array<bool,3> output_mask);
CAFFE2_API Tensor & slow_conv_transpose3d_out(Tensor & out, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias={}, IntArrayRef stride=1, IntArrayRef padding=0, IntArrayRef output_padding=0, IntArrayRef dilation=1);
CAFFE2_API Tensor slow_conv_transpose3d(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias={}, IntArrayRef stride=1, IntArrayRef padding=0, IntArrayRef output_padding=0, IntArrayRef dilation=1);
CAFFE2_API std::tuple<Tensor &,Tensor &,Tensor &> slow_conv_transpose3d_backward_out(Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation, const Tensor & finput, const Tensor & fgrad_input);
CAFFE2_API std::tuple<Tensor,Tensor,Tensor> slow_conv_transpose3d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation, const Tensor & finput, const Tensor & fgrad_input, std::array<bool,3> output_mask);
CAFFE2_API Tensor & thnn_conv2d_out(Tensor & out, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias={}, IntArrayRef stride=1, IntArrayRef padding=0);
CAFFE2_API Tensor thnn_conv2d(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias={}, IntArrayRef stride=1, IntArrayRef padding=0);
CAFFE2_API std::tuple<Tensor &,Tensor &,Tensor &> thnn_conv2d_forward_out(Tensor & output, Tensor & finput, Tensor & fgrad_input, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding);
CAFFE2_API std::tuple<Tensor,Tensor,Tensor> thnn_conv2d_forward(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding);
CAFFE2_API std::tuple<Tensor &,Tensor &,Tensor &> thnn_conv2d_backward_out(Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, const Tensor & finput, const Tensor & fgrad_input);
CAFFE2_API std::tuple<Tensor,Tensor,Tensor> thnn_conv2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, const Tensor & finput, const Tensor & fgrad_input, std::array<bool,3> output_mask);
CAFFE2_API Tensor & thnn_conv_depthwise2d_out(Tensor & out, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias={}, IntArrayRef stride=1, IntArrayRef padding=0, IntArrayRef dilation=1);
CAFFE2_API Tensor thnn_conv_depthwise2d(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias={}, IntArrayRef stride=1, IntArrayRef padding=0, IntArrayRef dilation=1);
CAFFE2_API Tensor & thnn_conv_depthwise2d_forward_out(Tensor & out, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation);
CAFFE2_API Tensor thnn_conv_depthwise2d_forward(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation);
CAFFE2_API std::tuple<Tensor &,Tensor &> thnn_conv_depthwise2d_backward_out(Tensor & grad_input, Tensor & grad_weight, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation);
CAFFE2_API std::tuple<Tensor,Tensor> thnn_conv_depthwise2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, std::array<bool,2> output_mask);
CAFFE2_API Tensor & slow_conv3d_out(Tensor & out, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias={}, IntArrayRef stride=1, IntArrayRef padding=0);
CAFFE2_API Tensor slow_conv3d(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias={}, IntArrayRef stride=1, IntArrayRef padding=0);
CAFFE2_API std::tuple<Tensor &,Tensor &,Tensor &> slow_conv3d_forward_out(Tensor & output, Tensor & finput, Tensor & fgrad_input, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding);
CAFFE2_API std::tuple<Tensor,Tensor,Tensor> slow_conv3d_forward(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding);
CAFFE2_API std::tuple<Tensor &,Tensor &,Tensor &> slow_conv3d_backward_out(Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, const Tensor & finput, const Tensor & fgrad_input);
CAFFE2_API std::tuple<Tensor,Tensor,Tensor> slow_conv3d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, const Tensor & finput, const Tensor & fgrad_input, std::array<bool,3> output_mask);
CAFFE2_API Tensor slow_conv_dilated2d(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias={}, IntArrayRef stride=1, IntArrayRef padding=0, IntArrayRef dilation=1);
CAFFE2_API std::tuple<Tensor,Tensor,Tensor> slow_conv_dilated2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, std::array<bool,3> output_mask);
CAFFE2_API Tensor slow_conv_dilated3d(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias={}, IntArrayRef stride=1, IntArrayRef padding=0, IntArrayRef dilation=1);
CAFFE2_API std::tuple<Tensor,Tensor,Tensor> slow_conv_dilated3d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, std::array<bool,3> output_mask);
CAFFE2_API Tensor & col2im_out(Tensor & out, const Tensor & self, IntArrayRef output_size, IntArrayRef kernel_size, IntArrayRef dilation, IntArrayRef padding, IntArrayRef stride);
CAFFE2_API Tensor col2im(const Tensor & self, IntArrayRef output_size, IntArrayRef kernel_size, IntArrayRef dilation, IntArrayRef padding, IntArrayRef stride);
CAFFE2_API Tensor & col2im_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef kernel_size, IntArrayRef dilation, IntArrayRef padding, IntArrayRef stride);
CAFFE2_API Tensor col2im_backward(const Tensor & grad_output, IntArrayRef kernel_size, IntArrayRef dilation, IntArrayRef padding, IntArrayRef stride);
CAFFE2_API Tensor & im2col_out(Tensor & out, const Tensor & self, IntArrayRef kernel_size, IntArrayRef dilation, IntArrayRef padding, IntArrayRef stride);
CAFFE2_API Tensor im2col(const Tensor & self, IntArrayRef kernel_size, IntArrayRef dilation, IntArrayRef padding, IntArrayRef stride);
CAFFE2_API Tensor & im2col_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef input_size, IntArrayRef kernel_size, IntArrayRef dilation, IntArrayRef padding, IntArrayRef stride);
CAFFE2_API Tensor im2col_backward(const Tensor & grad_output, IntArrayRef input_size, IntArrayRef kernel_size, IntArrayRef dilation, IntArrayRef padding, IntArrayRef stride);
CAFFE2_API Tensor isfinite(const Tensor & self);
CAFFE2_API Tensor isinf(const Tensor & self);
CAFFE2_API Tensor _test_serialization_subcmul(const Tensor & self, const Tensor & other, Scalar alpha=1);

inline Tensor from_blob(
    void* data,
    IntArrayRef sizes,
    IntArrayRef strides,
    const std::function<void(void*)>& deleter,
    const TensorOptions& options = {},
    const c10::optional<Device> target_device = c10::nullopt) {
  AutoNonVariableTypeMode guard;  // TODO: remove
  tracer::impl::NoTracerDispatchMode tracer_guard;
  auto device = (target_device.has_value()?
    target_device.value() : globalContext().getDeviceFromPtr(data, options.device().type()));
  if (options.device().has_index()) {
    TORCH_CHECK(
        options.device() == device,
        "Specified device ", options.device(),
        " does not match device of data ", device);
  }
  auto storage = Storage(
      Storage::use_byte_size_t(),
      detail::computeStorageNbytes(sizes, strides, options.dtype().itemsize()),
      InefficientStdFunctionContext::makeDataPtr(data, deleter, device),
      /*allocator=*/nullptr,
      /*resizable=*/false);
  return empty({0}, options).set_(storage, 0, sizes, strides);
}

inline Tensor from_blob(
    void* data,
    IntArrayRef sizes,
    const std::function<void(void*)>& deleter,
    const TensorOptions& options = {}) {
  return from_blob(data, sizes, detail::defaultStrides(sizes), deleter, options);
}

inline Tensor from_blob(
    void* data,
    IntArrayRef sizes,
    IntArrayRef strides,
    const TensorOptions& options = {}) {
  AutoNonVariableTypeMode guard;  // TODO: remove
  tracer::impl::NoTracerDispatchMode tracer_guard;
  auto device = globalContext().getDeviceFromPtr(data, options.device().type());
  if (options.device().has_index()) {
    TORCH_CHECK(
        options.device() == device,
        "Specified device ", options.device(),
        " does not match device of data ", device);
  }
  auto storage = Storage(
      Storage::use_byte_size_t(),
      detail::computeStorageNbytes(sizes, strides, options.dtype().itemsize()),
      DataPtr(data, nullptr, [](void*) {}, device),
      /*allocator=*/nullptr,
      /*resizable=*/false);
  return empty({0}, options).set_(storage, 0, sizes, strides);
}

inline Tensor from_blob(
    void* data,
    IntArrayRef sizes,
    const TensorOptions& options = {}) {
  return from_blob(data, sizes, detail::defaultStrides(sizes), options);
}

inline int64_t numel(const Tensor& tensor) {
  return tensor.numel();
}

}
