#pragma once

// @generated by aten/src/ATen/gen.py

#include <c10/core/Scalar.h>
#include <ATen/Tensor.h>
#include <c10/core/Storage.h>
#include <ATen/core/Generator.h>
#include <c10/util/Deprecated.h>
#include <ATen/NativeFunctions.h>
#include <ATen/DeviceGuard.h>
#include <c10/core/TensorOptions.h>
#include <ATen/core/Reduction.h>
#include <c10/util/Optional.h>
#include <ATen/TensorUtils.h>
#include <ATen/core/ATenDispatch.h>
#include <ATen/Context.h>

namespace at {

using native::tensor;

static inline Tensor _cast_Byte(const Tensor & self, bool non_blocking=false);
static inline Tensor _cast_Char(const Tensor & self, bool non_blocking=false);
static inline Tensor _cast_Double(const Tensor & self, bool non_blocking=false);
static inline Tensor _cast_Float(const Tensor & self, bool non_blocking=false);
static inline Tensor _cast_Int(const Tensor & self, bool non_blocking=false);
static inline Tensor _cast_Long(const Tensor & self, bool non_blocking=false);
static inline Tensor _cast_Short(const Tensor & self, bool non_blocking=false);
static inline Tensor _cast_Half(const Tensor & self, bool non_blocking=false);
static inline std::tuple<Tensor,Tensor> _cudnn_ctc_loss(const Tensor & log_probs, const Tensor & targets, IntArrayRef input_lengths, IntArrayRef target_lengths, int64_t blank, bool deterministic, bool zero_infinity);
static inline Tensor _cudnn_rnn_flatten_weight(TensorList weight_arr, int64_t weight_stride0, int64_t input_size, int64_t mode, int64_t hidden_size, int64_t num_layers, bool batch_first, bool bidirectional);
static inline std::tuple<Tensor,Tensor,Tensor,Tensor,Tensor> _cudnn_rnn(const Tensor & input, TensorList weight, int64_t weight_stride0, const Tensor & weight_buf, const Tensor & hx, const Tensor & cx, int64_t mode, int64_t hidden_size, int64_t num_layers, bool batch_first, double dropout, bool train, bool bidirectional, IntArrayRef batch_sizes, const Tensor & dropout_state);
static inline std::tuple<Tensor,Tensor,Tensor,std::vector<Tensor>> _cudnn_rnn_backward(const Tensor & input, TensorList weight, int64_t weight_stride0, const Tensor & weight_buf, const Tensor & hx, const Tensor & cx, const Tensor & output, const Tensor & grad_output, const Tensor & grad_hy, const Tensor & grad_cy, int64_t mode, int64_t hidden_size, int64_t num_layers, bool batch_first, double dropout, bool train, bool bidirectional, IntArrayRef batch_sizes, const Tensor & dropout_state, const Tensor & reserve, std::array<bool,4> output_mask);
static inline Tensor _cudnn_init_dropout_state(double dropout, bool train, int64_t dropout_seed, const TensorOptions & options);
static inline int64_t _debug_has_internal_overlap(const Tensor & self);
static inline std::tuple<Tensor,Tensor> _fused_dropout(const Tensor & self, double p, Generator * generator=nullptr);
static inline Tensor _masked_scale(const Tensor & self, const Tensor & mask, double scale);
static inline std::tuple<Tensor,Tensor> _sobol_engine_draw(const Tensor & quasi, int64_t n, const Tensor & sobolstate, int64_t dimension, int64_t num_generated, c10::optional<ScalarType> dtype);
static inline Tensor & _sobol_engine_ff_(Tensor & self, int64_t n, const Tensor & sobolstate, int64_t dimension, int64_t num_generated);
static inline Tensor & _sobol_engine_scramble_(Tensor & self, const Tensor & ltm, int64_t dimension);
static inline Tensor & _sobol_engine_initialize_state_(Tensor & self, int64_t dimension);
static inline Tensor _reshape_from_tensor(const Tensor & self, const Tensor & shape);
static inline Tensor _shape_as_tensor(const Tensor & self);
static inline Tensor dropout(const Tensor & input, double p, bool train);
static inline Tensor & dropout_(Tensor & self, double p, bool train);
static inline Tensor feature_dropout(const Tensor & input, double p, bool train);
static inline Tensor & feature_dropout_(Tensor & self, double p, bool train);
static inline Tensor alpha_dropout(const Tensor & input, double p, bool train);
static inline Tensor & alpha_dropout_(Tensor & self, double p, bool train);
static inline Tensor feature_alpha_dropout(const Tensor & input, double p, bool train);
static inline Tensor & feature_alpha_dropout_(Tensor & self, double p, bool train);
static inline Tensor abs(const Tensor & self);
static inline Tensor & abs_(Tensor & self);
static inline Tensor & abs_out(Tensor & out, const Tensor & self);
static inline Tensor acos(const Tensor & self);
static inline Tensor & acos_(Tensor & self);
static inline Tensor & acos_out(Tensor & out, const Tensor & self);
static inline Tensor avg_pool1d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride={}, IntArrayRef padding=0, bool ceil_mode=false, bool count_include_pad=true);
static inline Tensor adaptive_avg_pool1d(const Tensor & self, IntArrayRef output_size);
static inline std::tuple<Tensor,Tensor> adaptive_max_pool1d(const Tensor & self, IntArrayRef output_size);
static inline Tensor add(const Tensor & self, const Tensor & other, Scalar alpha=1);
static inline Tensor & add_out(Tensor & out, const Tensor & self, const Tensor & other, Scalar alpha=1);
static inline Tensor add(const Tensor & self, Scalar other, Scalar alpha=1);
static inline Tensor addmv(const Tensor & self, const Tensor & mat, const Tensor & vec, Scalar beta=1, Scalar alpha=1);
static inline Tensor & addmv_(Tensor & self, const Tensor & mat, const Tensor & vec, Scalar beta=1, Scalar alpha=1);
static inline Tensor & addmv_out(Tensor & out, const Tensor & self, const Tensor & mat, const Tensor & vec, Scalar beta=1, Scalar alpha=1);
static inline Tensor addr(const Tensor & self, const Tensor & vec1, const Tensor & vec2, Scalar beta=1, Scalar alpha=1);
static inline Tensor & addr_out(Tensor & out, const Tensor & self, const Tensor & vec1, const Tensor & vec2, Scalar beta=1, Scalar alpha=1);
static inline Tensor affine_grid_generator(const Tensor & theta, IntArrayRef size);
static inline Tensor affine_grid_generator_backward(const Tensor & grad, IntArrayRef size);
static inline Tensor all(const Tensor & self, int64_t dim, bool keepdim=false);
static inline Tensor & all_out(Tensor & out, const Tensor & self, int64_t dim, bool keepdim=false);
static inline bool allclose(const Tensor & self, const Tensor & other, double rtol=1e-05, double atol=1e-08, bool equal_nan=false);
static inline Tensor any(const Tensor & self, int64_t dim, bool keepdim=false);
static inline Tensor & any_out(Tensor & out, const Tensor & self, int64_t dim, bool keepdim=false);
static inline Tensor arange(Scalar end, const TensorOptions & options={});
static inline Tensor arange(Scalar start, Scalar end, const TensorOptions & options={});
static inline Tensor arange(Scalar start, Scalar end, Scalar step, const TensorOptions & options={});
static inline Tensor & arange_out(Tensor & out, Scalar end);
static inline Tensor & arange_out(Tensor & out, Scalar start, Scalar end, Scalar step=1);
static inline Tensor _dim_arange(const Tensor & like, int64_t dim);
static inline Tensor argmax(const Tensor & self, c10::optional<int64_t> dim=c10::nullopt, bool keepdim=false);
static inline Tensor argmin(const Tensor & self, c10::optional<int64_t> dim=c10::nullopt, bool keepdim=false);
static inline Tensor as_strided(const Tensor & self, IntArrayRef size, IntArrayRef stride, c10::optional<int64_t> storage_offset=c10::nullopt);
static inline Tensor & as_strided_(Tensor & self, IntArrayRef size, IntArrayRef stride, c10::optional<int64_t> storage_offset=c10::nullopt);
static inline Tensor asin(const Tensor & self);
static inline Tensor & asin_(Tensor & self);
static inline Tensor & asin_out(Tensor & out, const Tensor & self);
static inline Tensor atan(const Tensor & self);
static inline Tensor & atan_(Tensor & self);
static inline Tensor & atan_out(Tensor & out, const Tensor & self);
static inline Tensor baddbmm(const Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta=1, Scalar alpha=1);
static inline Tensor & _baddbmm_mkl_(Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta=1, Scalar alpha=1);
static inline Tensor & baddbmm_out(Tensor & out, const Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta=1, Scalar alpha=1);
static inline Tensor bartlett_window(int64_t window_length, const TensorOptions & options={});
static inline Tensor bartlett_window(int64_t window_length, bool periodic, const TensorOptions & options={});
static inline Tensor batch_norm(const Tensor & input, const Tensor & weight, const Tensor & bias, const Tensor & running_mean, const Tensor & running_var, bool training, double momentum, double eps, bool cudnn_enabled);
static inline std::tuple<Tensor,Tensor,Tensor,int64_t> _batch_norm_impl_index(const Tensor & input, const Tensor & weight, const Tensor & bias, const Tensor & running_mean, const Tensor & running_var, bool training, double momentum, double eps, bool cudnn_enabled);
static inline std::tuple<Tensor,Tensor,Tensor> _batch_norm_impl_index_backward(int64_t impl_index, const Tensor & input, const Tensor & grad_output, const Tensor & weight, const Tensor & running_mean, const Tensor & running_var, const Tensor & save_mean, const Tensor & save_var_transform, bool train, double eps, std::array<bool,3> output_mask);
static inline Tensor bernoulli(const Tensor & self, Generator * generator=nullptr);
static inline Tensor & bernoulli_out(Tensor & out, const Tensor & self, Generator * generator=nullptr);
static inline Tensor bernoulli(const Tensor & self, double p, Generator * generator=nullptr);
static inline Tensor bilinear(const Tensor & input1, const Tensor & input2, const Tensor & weight, const Tensor & bias);
static inline Tensor binary_cross_entropy_with_logits(const Tensor & self, const Tensor & target, const Tensor & weight={}, const Tensor & pos_weight={}, int64_t reduction=Reduction::Mean);
static inline Tensor binary_cross_entropy_with_logits_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight={}, const Tensor & pos_weight={}, int64_t reduction=Reduction::Mean);
static inline Tensor bincount(const Tensor & self, const Tensor & weights={}, int64_t minlength=0);
static inline Tensor bitwise_not(const Tensor & self);
static inline Tensor & bitwise_not_out(Tensor & out, const Tensor & self);
static inline Tensor blackman_window(int64_t window_length, const TensorOptions & options={});
static inline Tensor blackman_window(int64_t window_length, bool periodic, const TensorOptions & options={});
static inline Tensor bmm(const Tensor & self, const Tensor & mat2);
static inline Tensor & bmm_out(Tensor & out, const Tensor & self, const Tensor & mat2);
static inline std::vector<Tensor> broadcast_tensors(TensorList tensors);
static inline Tensor cat(TensorList tensors, int64_t dim=0);
static inline Tensor & cat_out(Tensor & out, TensorList tensors, int64_t dim=0);
static inline Tensor ceil(const Tensor & self);
static inline Tensor & ceil_(Tensor & self);
static inline Tensor & ceil_out(Tensor & out, const Tensor & self);
static inline Tensor chain_matmul(TensorList matrices);
static inline std::vector<Tensor> chunk(const Tensor & self, int64_t chunks, int64_t dim=0);
static inline Tensor clamp(const Tensor & self, c10::optional<Scalar> min=c10::nullopt, c10::optional<Scalar> max=c10::nullopt);
static inline Tensor & clamp_(Tensor & self, c10::optional<Scalar> min=c10::nullopt, c10::optional<Scalar> max=c10::nullopt);
static inline Tensor & clamp_out(Tensor & out, const Tensor & self, c10::optional<Scalar> min=c10::nullopt, c10::optional<Scalar> max=c10::nullopt);
static inline Tensor clamp_max(const Tensor & self, Scalar max);
static inline Tensor & clamp_max_(Tensor & self, Scalar max);
static inline Tensor & clamp_max_out(Tensor & out, const Tensor & self, Scalar max);
static inline Tensor clamp_min(const Tensor & self, Scalar min);
static inline Tensor & clamp_min_(Tensor & self, Scalar min);
static inline Tensor & clamp_min_out(Tensor & out, const Tensor & self, Scalar min);
static inline bool cudnn_is_acceptable(const Tensor & self);
static inline Tensor constant_pad_nd(const Tensor & self, IntArrayRef pad, Scalar value=0);
static inline Tensor convolution(const Tensor & input, const Tensor & weight, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool transposed, IntArrayRef output_padding, int64_t groups);
static inline Tensor _convolution(const Tensor & input, const Tensor & weight, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool transposed, IntArrayRef output_padding, int64_t groups, bool benchmark, bool deterministic, bool cudnn_enabled);
static inline Tensor _convolution_nogroup(const Tensor & input, const Tensor & weight, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool transposed, IntArrayRef output_padding);
static inline std::tuple<Tensor,Tensor,Tensor> _convolution_double_backward(const Tensor & ggI, const Tensor & ggW, const Tensor & ggb, const Tensor & gO, const Tensor & weight, const Tensor & self, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool transposed, IntArrayRef output_padding, int64_t groups, bool benchmark, bool deterministic, bool cudnn_enabled, std::array<bool,3> output_mask);
static inline Tensor conv1d(const Tensor & input, const Tensor & weight, const Tensor & bias={}, IntArrayRef stride=1, IntArrayRef padding=0, IntArrayRef dilation=1, int64_t groups=1);
static inline Tensor conv2d(const Tensor & input, const Tensor & weight, const Tensor & bias={}, IntArrayRef stride=1, IntArrayRef padding=0, IntArrayRef dilation=1, int64_t groups=1);
static inline Tensor conv3d(const Tensor & input, const Tensor & weight, const Tensor & bias={}, IntArrayRef stride=1, IntArrayRef padding=0, IntArrayRef dilation=1, int64_t groups=1);
static inline Tensor conv_tbc(const Tensor & self, const Tensor & weight, const Tensor & bias, int64_t pad=0);
static inline std::tuple<Tensor,Tensor,Tensor> conv_tbc_backward(const Tensor & self, const Tensor & input, const Tensor & weight, const Tensor & bias, int64_t pad);
static inline Tensor conv_transpose1d(const Tensor & input, const Tensor & weight, const Tensor & bias={}, IntArrayRef stride=1, IntArrayRef padding=0, IntArrayRef output_padding=0, int64_t groups=1, IntArrayRef dilation=1);
static inline Tensor conv_transpose2d(const Tensor & input, const Tensor & weight, const Tensor & bias={}, IntArrayRef stride=1, IntArrayRef padding=0, IntArrayRef output_padding=0, int64_t groups=1, IntArrayRef dilation=1);
static inline Tensor conv_transpose3d(const Tensor & input, const Tensor & weight, const Tensor & bias={}, IntArrayRef stride=1, IntArrayRef padding=0, IntArrayRef output_padding=0, int64_t groups=1, IntArrayRef dilation=1);
static inline Tensor _copy_from(const Tensor & self, const Tensor & dst, bool non_blocking=false);
static inline Tensor cos(const Tensor & self);
static inline Tensor & cos_(Tensor & self);
static inline Tensor & cos_out(Tensor & out, const Tensor & self);
static inline Tensor cosh(const Tensor & self);
static inline Tensor & cosh_(Tensor & self);
static inline Tensor & cosh_out(Tensor & out, const Tensor & self);
static inline Tensor cosine_embedding_loss(const Tensor & input1, const Tensor & input2, const Tensor & target, double margin=0.0, int64_t reduction=Reduction::Mean);
static inline Tensor cudnn_affine_grid_generator(const Tensor & theta, int64_t N, int64_t C, int64_t H, int64_t W);
static inline Tensor cudnn_affine_grid_generator_backward(const Tensor & grad, int64_t N, int64_t C, int64_t H, int64_t W);
static inline std::tuple<Tensor,Tensor,Tensor> cudnn_batch_norm(const Tensor & input, const Tensor & weight, const Tensor & bias, const Tensor & running_mean, const Tensor & running_var, bool training, double exponential_average_factor, double epsilon);
static inline std::tuple<Tensor,Tensor,Tensor> cudnn_batch_norm_backward(const Tensor & input, const Tensor & grad_output, const Tensor & weight, const Tensor & running_mean, const Tensor & running_var, const Tensor & save_mean, const Tensor & save_var, double epsilon);
static inline Tensor cudnn_convolution(const Tensor & self, const Tensor & weight, const Tensor & bias, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic);
static inline Tensor cudnn_convolution_backward_input(IntArrayRef self_size, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic);
static inline std::tuple<Tensor,Tensor,Tensor> cudnn_convolution_backward(const Tensor & self, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic, std::array<bool,3> output_mask);
static inline Tensor cudnn_convolution_backward_bias(const Tensor & grad_output);
static inline Tensor cudnn_convolution_backward_weight(IntArrayRef weight_size, const Tensor & grad_output, const Tensor & self, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic);
static inline Tensor cudnn_convolution_transpose(const Tensor & self, const Tensor & weight, const Tensor & bias, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic);
static inline std::tuple<Tensor,Tensor,Tensor> cudnn_convolution_transpose_backward(const Tensor & self, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic, std::array<bool,3> output_mask);
static inline Tensor cudnn_convolution_transpose_backward_bias(const Tensor & grad_output);
static inline Tensor cudnn_convolution_transpose_backward_input(const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic);
static inline Tensor cudnn_convolution_transpose_backward_weight(IntArrayRef weight_size, const Tensor & grad_output, const Tensor & self, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic);
static inline Tensor cudnn_grid_sampler(const Tensor & self, const Tensor & grid);
static inline std::tuple<Tensor,Tensor> cudnn_grid_sampler_backward(const Tensor & self, const Tensor & grid, const Tensor & grad_output);
static inline Tensor cumsum(const Tensor & self, int64_t dim, c10::optional<ScalarType> dtype=c10::nullopt);
static inline Tensor & cumsum_out(Tensor & out, const Tensor & self, int64_t dim, c10::optional<ScalarType> dtype=c10::nullopt);
static inline Tensor cumprod(const Tensor & self, int64_t dim, c10::optional<ScalarType> dtype=c10::nullopt);
static inline Tensor & cumprod_out(Tensor & out, const Tensor & self, int64_t dim, c10::optional<ScalarType> dtype=c10::nullopt);
static inline Tensor ctc_loss(const Tensor & log_probs, const Tensor & targets, IntArrayRef input_lengths, IntArrayRef target_lengths, int64_t blank=0, int64_t reduction=Reduction::Mean, bool zero_infinity=false);
static inline Tensor ctc_loss(const Tensor & log_probs, const Tensor & targets, const Tensor & input_lengths, const Tensor & target_lengths, int64_t blank=0, int64_t reduction=Reduction::Mean, bool zero_infinity=false);
static inline std::tuple<Tensor,Tensor> _ctc_loss(const Tensor & log_probs, const Tensor & targets, IntArrayRef input_lengths, IntArrayRef target_lengths, int64_t blank=0, bool zero_infinity=false);
static inline Tensor _ctc_loss_backward(const Tensor & grad, const Tensor & log_probs, const Tensor & targets, IntArrayRef input_lengths, IntArrayRef target_lengths, const Tensor & neg_log_likelihood, const Tensor & log_alpha, int64_t blank, bool zero_infinity=false);
static inline Tensor det(const Tensor & self);
static inline Tensor diag_embed(const Tensor & self, int64_t offset=0, int64_t dim1=-2, int64_t dim2=-1);
static inline Tensor diagflat(const Tensor & self, int64_t offset=0);
static inline Tensor diagonal(const Tensor & self, int64_t offset=0, int64_t dim1=0, int64_t dim2=1);
static inline Tensor div(const Tensor & self, const Tensor & other);
static inline Tensor & div_out(Tensor & out, const Tensor & self, const Tensor & other);
static inline Tensor div(const Tensor & self, Scalar other);
static inline Tensor dot(const Tensor & self, const Tensor & tensor);
static inline Tensor & dot_out(Tensor & out, const Tensor & self, const Tensor & tensor);
static inline Tensor einsum(std::string equation, TensorList tensors);
static inline Tensor embedding(const Tensor & weight, const Tensor & indices, int64_t padding_idx=-1, bool scale_grad_by_freq=false, bool sparse=false);
static inline Tensor embedding_backward(const Tensor & grad, const Tensor & indices, int64_t num_weights, int64_t padding_idx, bool scale_grad_by_freq, bool sparse);
static inline Tensor embedding_dense_backward(const Tensor & grad_output, const Tensor & indices, int64_t num_weights, int64_t padding_idx, bool scale_grad_by_freq);
static inline Tensor & embedding_renorm_(Tensor & self, const Tensor & indices, double max_norm, double norm_type);
static inline Tensor embedding_sparse_backward(const Tensor & grad, const Tensor & indices, int64_t num_weights, int64_t padding_idx, bool scale_grad_by_freq);
static inline std::tuple<Tensor,Tensor,Tensor,Tensor> embedding_bag(const Tensor & weight, const Tensor & indices, const Tensor & offsets, bool scale_grad_by_freq=false, int64_t mode=0, bool sparse=false, const Tensor & per_sample_weights={});
static inline std::tuple<Tensor,Tensor,Tensor,Tensor> _embedding_bag(const Tensor & weight, const Tensor & indices, const Tensor & offsets, bool scale_grad_by_freq=false, int64_t mode=0, bool sparse=false, const Tensor & per_sample_weights={});
static inline Tensor _embedding_bag_backward(const Tensor & grad, const Tensor & indices, const Tensor & offsets, const Tensor & offset2bag, const Tensor & bag_size, const Tensor & maximum_indices, int64_t num_weights, bool scale_grad_by_freq, int64_t mode, bool sparse, const Tensor & per_sample_weights);
static inline Tensor _embedding_bag_sparse_backward(const Tensor & grad, const Tensor & indices, const Tensor & offsets, const Tensor & offset2bag, const Tensor & bag_size, int64_t num_weights, bool scale_grad_by_freq, int64_t mode, const Tensor & per_sample_weights);
static inline Tensor _embedding_bag_dense_backward(const Tensor & grad, const Tensor & indices, const Tensor & offsets, const Tensor & offset2bag, const Tensor & bag_size, const Tensor & maximum_indices, int64_t num_weights, bool scale_grad_by_freq, int64_t mode, const Tensor & per_sample_weights);
static inline Tensor _embedding_bag_per_sample_weights_backward(const Tensor & grad, const Tensor & weight, const Tensor & indices, const Tensor & offsets, const Tensor & offset2bag, int64_t mode);
#ifdef BUILD_NAMEDTENSOR
static inline Tensor empty(IntArrayRef size, c10::optional<DimnameList> names, const TensorOptions & options={});
#endif
static inline Tensor empty(IntArrayRef size, const TensorOptions & options={}, c10::optional<MemoryFormat> memory_format=c10::nullopt);
static inline Tensor _empty_affine_quantized(IntArrayRef size, const TensorOptions & options={}, double scale=1, int64_t zero_point=0, c10::optional<MemoryFormat> memory_format=MemoryFormat::Contiguous);
static inline Tensor & empty_out(Tensor & out, IntArrayRef size, c10::optional<MemoryFormat> memory_format=c10::nullopt);
static inline Tensor empty_like(const Tensor & self);
static inline Tensor empty_like(const Tensor & self, const TensorOptions & options, c10::optional<MemoryFormat> memory_format=MemoryFormat::Contiguous);
static inline Tensor empty_strided(IntArrayRef size, IntArrayRef stride, const TensorOptions & options={});
static inline Tensor erf(const Tensor & self);
static inline Tensor & erf_(Tensor & self);
static inline Tensor & erf_out(Tensor & out, const Tensor & self);
static inline Tensor erfc(const Tensor & self);
static inline Tensor & erfc_(Tensor & self);
static inline Tensor & erfc_out(Tensor & out, const Tensor & self);
static inline Tensor exp(const Tensor & self);
static inline Tensor & exp_(Tensor & self);
static inline Tensor & exp_out(Tensor & out, const Tensor & self);
static inline Tensor expm1(const Tensor & self);
static inline Tensor & expm1_(Tensor & self);
static inline Tensor & expm1_out(Tensor & out, const Tensor & self);
static inline Tensor eye(int64_t n, const TensorOptions & options={});
static inline Tensor eye(int64_t n, int64_t m, const TensorOptions & options={});
static inline Tensor & eye_out(Tensor & out, int64_t n);
static inline Tensor & eye_out(Tensor & out, int64_t n, int64_t m);
static inline Tensor flatten(const Tensor & self, int64_t start_dim=0, int64_t end_dim=-1);
static inline Tensor & fill_(Tensor & self, Scalar value);
static inline Tensor & fill_(Tensor & self, const Tensor & value);
static inline Tensor floor(const Tensor & self);
static inline Tensor & floor_(Tensor & self);
static inline Tensor & floor_out(Tensor & out, const Tensor & self);
static inline Tensor frac(const Tensor & self);
static inline Tensor & frac_(Tensor & self);
static inline Tensor & frac_out(Tensor & out, const Tensor & self);
static inline Tensor full(IntArrayRef size, Scalar fill_value, const TensorOptions & options={});
static inline Tensor & full_out(Tensor & out, IntArrayRef size, Scalar fill_value);
static inline Tensor full_like(const Tensor & self, Scalar fill_value);
static inline Tensor full_like(const Tensor & self, Scalar fill_value, const TensorOptions & options);
static inline Tensor from_file(std::string filename, c10::optional<bool> shared=c10::nullopt, c10::optional<int64_t> size=0, const TensorOptions & options={});
static inline Tensor grid_sampler(const Tensor & input, const Tensor & grid, int64_t interpolation_mode, int64_t padding_mode);
static inline Tensor grid_sampler_2d(const Tensor & input, const Tensor & grid, int64_t interpolation_mode, int64_t padding_mode);
static inline std::tuple<Tensor,Tensor> grid_sampler_2d_backward(const Tensor & grad_output, const Tensor & input, const Tensor & grid, int64_t interpolation_mode, int64_t padding_mode);
static inline Tensor grid_sampler_3d(const Tensor & input, const Tensor & grid, int64_t interpolation_mode, int64_t padding_mode);
static inline std::tuple<Tensor,Tensor> grid_sampler_3d_backward(const Tensor & grad_output, const Tensor & input, const Tensor & grid, int64_t interpolation_mode, int64_t padding_mode);
static inline Tensor hann_window(int64_t window_length, const TensorOptions & options={});
static inline Tensor hann_window(int64_t window_length, bool periodic, const TensorOptions & options={});
static inline Tensor hamming_window(int64_t window_length, const TensorOptions & options={});
static inline Tensor hamming_window(int64_t window_length, bool periodic, const TensorOptions & options={});
static inline Tensor hamming_window(int64_t window_length, bool periodic, double alpha, const TensorOptions & options={});
static inline Tensor hamming_window(int64_t window_length, bool periodic, double alpha, double beta, const TensorOptions & options={});
static inline Tensor hinge_embedding_loss(const Tensor & self, const Tensor & target, double margin=1.0, int64_t reduction=Reduction::Mean);
static inline Tensor ger(const Tensor & self, const Tensor & vec2);
static inline Tensor & ger_out(Tensor & out, const Tensor & self, const Tensor & vec2);
static inline Tensor group_norm(const Tensor & input, int64_t num_groups, const Tensor & weight={}, const Tensor & bias={}, double eps=1e-05, bool cudnn_enabled=true);
static inline Tensor fft(const Tensor & self, int64_t signal_ndim, bool normalized=false);
static inline Tensor ifft(const Tensor & self, int64_t signal_ndim, bool normalized=false);
static inline Tensor rfft(const Tensor & self, int64_t signal_ndim, bool normalized=false, bool onesided=true);
static inline Tensor irfft(const Tensor & self, int64_t signal_ndim, bool normalized=false, bool onesided=true, IntArrayRef signal_sizes={});
static inline Tensor _fft_with_size(const Tensor & self, int64_t signal_ndim, bool complex_input, bool complex_output, bool inverse, IntArrayRef checked_signal_sizes, bool normalized, bool onesided, IntArrayRef output_sizes);
static inline int64_t _cufft_get_plan_cache_size(int64_t device_index);
static inline int64_t _cufft_get_plan_cache_max_size(int64_t device_index);
static inline void _cufft_set_plan_cache_max_size(int64_t device_index, int64_t max_size);
static inline void _cufft_clear_plan_cache(int64_t device_index);
static inline Tensor index(const Tensor & self, TensorList indices);
static inline Tensor index_copy(const Tensor & self, int64_t dim, const Tensor & index, const Tensor & source);
static inline Tensor & index_put_(Tensor & self, TensorList indices, const Tensor & values, bool accumulate=false);
static inline Tensor index_put(const Tensor & self, TensorList indices, const Tensor & values, bool accumulate=false);
static inline Tensor & _index_put_impl_(Tensor & self, TensorList indices, const Tensor & values, bool accumulate=false, bool unsafe=false);
static inline Tensor instance_norm(const Tensor & input, const Tensor & weight, const Tensor & bias, const Tensor & running_mean, const Tensor & running_var, bool use_input_stats, double momentum, double eps, bool cudnn_enabled);
static inline Tensor inverse(const Tensor & self);
static inline Tensor & inverse_out(Tensor & out, const Tensor & self);
static inline Tensor _inverse_helper(const Tensor & self);
static inline Tensor isclose(const Tensor & self, const Tensor & other, double rtol=1e-05, double atol=1e-08, bool equal_nan=false);
static inline Tensor isnan(const Tensor & self);
static inline bool is_distributed(const Tensor & self);
static inline bool is_floating_point(const Tensor & self);
static inline bool is_complex(const Tensor & self);
static inline bool is_nonzero(const Tensor & self);
static inline bool is_same_size(const Tensor & self, const Tensor & other);
static inline bool is_signed(const Tensor & self);
static inline Tensor kl_div(const Tensor & self, const Tensor & target, int64_t reduction=Reduction::Mean);
static inline Tensor kl_div_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction=Reduction::Mean);
static inline std::tuple<Tensor,Tensor> kthvalue(const Tensor & self, int64_t k, int64_t dim=-1, bool keepdim=false);
static inline std::tuple<Tensor &,Tensor &> kthvalue_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t k, int64_t dim=-1, bool keepdim=false);
static inline Tensor layer_norm(const Tensor & input, IntArrayRef normalized_shape, const Tensor & weight={}, const Tensor & bias={}, double eps=1e-05, bool cudnn_enable=true);
static inline std::tuple<Tensor,Tensor,Tensor> native_layer_norm(const Tensor & input, const Tensor & weight, const Tensor & bias, int64_t M, int64_t N, double eps);
static inline std::tuple<Tensor,Tensor,Tensor> native_layer_norm_backward(const Tensor & grad_out, const Tensor & input, const Tensor & mean, const Tensor & rstd, const Tensor & weight, int64_t M, int64_t N, std::array<bool,3> output_mask);
static inline std::tuple<Tensor,Tensor,Tensor> native_layer_norm_double_backward(const Tensor & ggI, const Tensor & ggW, const Tensor & ggb, const Tensor & gO, const Tensor & input, const Tensor & mean, const Tensor & rstd, const Tensor & weight, int64_t M, int64_t N, std::array<bool,3> output_mask);
static inline Tensor linear(const Tensor & input, const Tensor & weight, const Tensor & bias={});
static inline Tensor mkldnn_linear(const Tensor & input, const Tensor & weight, const Tensor & bias={});
static inline Tensor fbgemm_linear_int8_weight(const Tensor & input, const Tensor & weight, const Tensor & packed, const Tensor & col_offsets, Scalar weight_scale, Scalar weight_zero_point, const Tensor & bias);
static inline std::tuple<Tensor,Tensor,double,int64_t> fbgemm_linear_quantize_weight(const Tensor & input);
static inline Tensor fbgemm_pack_gemm_matrix_fp16(const Tensor & input);
static inline Tensor fbgemm_linear_fp16_weight(const Tensor & input, const Tensor & packed_weight, const Tensor & bias);
static inline Tensor fbgemm_pack_quantized_matrix(const Tensor & input, int64_t K, int64_t N);
static inline bool fbgemm_is_cpu_supported();
static inline Tensor linspace(Scalar start, Scalar end, int64_t steps=100, const TensorOptions & options={});
static inline Tensor & linspace_out(Tensor & out, Scalar start, Scalar end, int64_t steps=100);
static inline Tensor log(const Tensor & self);
static inline Tensor & log_(Tensor & self);
static inline Tensor & log_out(Tensor & out, const Tensor & self);
static inline Tensor log10(const Tensor & self);
static inline Tensor & log10_(Tensor & self);
static inline Tensor & log10_out(Tensor & out, const Tensor & self);
static inline Tensor log1p(const Tensor & self);
static inline Tensor & log1p_(Tensor & self);
static inline Tensor & log1p_out(Tensor & out, const Tensor & self);
static inline Tensor log2(const Tensor & self);
static inline Tensor & log2_(Tensor & self);
static inline Tensor & log2_out(Tensor & out, const Tensor & self);
static inline Tensor logdet(const Tensor & self);
static inline Tensor logspace(Scalar start, Scalar end, int64_t steps=100, double base=10.0, const TensorOptions & options={});
static inline Tensor & logspace_out(Tensor & out, Scalar start, Scalar end, int64_t steps=100, double base=10.0);
static inline Tensor log_softmax(const Tensor & self, int64_t dim, c10::optional<ScalarType> dtype=c10::nullopt);
static inline Tensor _log_softmax(const Tensor & self, int64_t dim, bool half_to_float);
static inline Tensor _log_softmax_backward_data(const Tensor & grad_output, const Tensor & output, int64_t dim, const Tensor & self);
static inline Tensor logsumexp(const Tensor & self, IntArrayRef dim, bool keepdim=false);
static inline Tensor & logsumexp_out(Tensor & out, const Tensor & self, IntArrayRef dim, bool keepdim=false);
static inline Tensor margin_ranking_loss(const Tensor & input1, const Tensor & input2, const Tensor & target, double margin=0.0, int64_t reduction=Reduction::Mean);
static inline Tensor matmul(const Tensor & self, const Tensor & other);
static inline Tensor & matmul_out(Tensor & out, const Tensor & self, const Tensor & other);
static inline Tensor matrix_rank(const Tensor & self, double tol, bool symmetric=false);
static inline Tensor matrix_rank(const Tensor & self, bool symmetric=false);
static inline Tensor matrix_power(const Tensor & self, int64_t n);
static inline std::tuple<Tensor,Tensor> max(const Tensor & self, int64_t dim, bool keepdim=false);
static inline std::tuple<Tensor &,Tensor &> max_out(Tensor & max, Tensor & max_values, const Tensor & self, int64_t dim, bool keepdim=false);
static inline Tensor max_values(const Tensor & self, IntArrayRef dim, bool keepdim=false);
static inline std::tuple<Tensor,Tensor> max_pool1d_with_indices(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride={}, IntArrayRef padding=0, IntArrayRef dilation=1, bool ceil_mode=false);
static inline Tensor max_pool1d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride={}, IntArrayRef padding=0, IntArrayRef dilation=1, bool ceil_mode=false);
static inline Tensor max_pool2d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride={}, IntArrayRef padding=0, IntArrayRef dilation=1, bool ceil_mode=false);
static inline Tensor mkldnn_max_pool2d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride={}, IntArrayRef padding=0, IntArrayRef dilation=1, bool ceil_mode=false);
static inline Tensor quantized_max_pool2d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride={}, IntArrayRef padding=0, IntArrayRef dilation=1);
static inline Tensor max_pool3d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride={}, IntArrayRef padding=0, IntArrayRef dilation=1, bool ceil_mode=false);
static inline Tensor mean(const Tensor & self, c10::optional<ScalarType> dtype=c10::nullopt);
static inline Tensor mean(const Tensor & self, IntArrayRef dim, bool keepdim=false, c10::optional<ScalarType> dtype=c10::nullopt);
static inline Tensor & mean_out(Tensor & out, const Tensor & self, IntArrayRef dim, bool keepdim=false, c10::optional<ScalarType> dtype=c10::nullopt);
static inline std::tuple<Tensor,Tensor> median(const Tensor & self, int64_t dim, bool keepdim=false);
static inline std::tuple<Tensor &,Tensor &> median_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t dim, bool keepdim=false);
static inline std::tuple<Tensor,Tensor> min(const Tensor & self, int64_t dim, bool keepdim=false);
static inline std::tuple<Tensor &,Tensor &> min_out(Tensor & min, Tensor & min_indices, const Tensor & self, int64_t dim, bool keepdim=false);
static inline Tensor min_values(const Tensor & self, IntArrayRef dim, bool keepdim=false);
static inline Tensor mkldnn_convolution(const Tensor & self, const Tensor & weight, const Tensor & bias, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups);
static inline Tensor mkldnn_convolution_backward_input(IntArrayRef self_size, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool bias_defined);
static inline std::tuple<Tensor,Tensor> mkldnn_convolution_backward_weights(IntArrayRef weight_size, const Tensor & grad_output, const Tensor & self, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool bias_defined);
static inline std::tuple<Tensor,Tensor,Tensor> mkldnn_convolution_backward(const Tensor & self, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, std::array<bool,3> output_mask);
static inline std::tuple<Tensor,Tensor,Tensor> miopen_batch_norm(const Tensor & input, const Tensor & weight, const Tensor & bias, const Tensor & running_mean, const Tensor & running_var, bool training, double exponential_average_factor, double epsilon);
static inline std::tuple<Tensor,Tensor,Tensor> miopen_batch_norm_backward(const Tensor & input, const Tensor & grad_output, const Tensor & weight, const Tensor & running_mean, const Tensor & running_var, const Tensor & save_mean, const Tensor & save_var, double epsilon);
static inline Tensor miopen_convolution(const Tensor & self, const Tensor & weight, const Tensor & bias, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic);
static inline Tensor miopen_convolution_backward_input(IntArrayRef self_size, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic);
static inline std::tuple<Tensor,Tensor,Tensor> miopen_convolution_backward(const Tensor & self, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic, std::array<bool,3> output_mask);
static inline Tensor miopen_convolution_backward_bias(const Tensor & grad_output);
static inline Tensor miopen_convolution_backward_weight(IntArrayRef weight_size, const Tensor & grad_output, const Tensor & self, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic);
static inline Tensor miopen_convolution_transpose(const Tensor & self, const Tensor & weight, const Tensor & bias, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic);
static inline std::tuple<Tensor,Tensor,Tensor> miopen_convolution_transpose_backward(const Tensor & self, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic, std::array<bool,3> output_mask);
static inline Tensor miopen_convolution_transpose_backward_input(const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic);
static inline Tensor miopen_convolution_transpose_backward_weight(IntArrayRef weight_size, const Tensor & grad_output, const Tensor & self, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic);
static inline Tensor miopen_depthwise_convolution(const Tensor & self, const Tensor & weight, const Tensor & bias, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic);
static inline Tensor miopen_depthwise_convolution_backward_input(IntArrayRef self_size, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic);
static inline std::tuple<Tensor,Tensor,Tensor> miopen_depthwise_convolution_backward(const Tensor & self, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic, std::array<bool,3> output_mask);
static inline Tensor miopen_depthwise_convolution_backward_weight(IntArrayRef weight_size, const Tensor & grad_output, const Tensor & self, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic);
static inline std::tuple<Tensor,Tensor,Tensor,Tensor,Tensor> miopen_rnn(const Tensor & input, TensorList weight, int64_t weight_stride0, const Tensor & hx, const Tensor & cx, int64_t mode, int64_t hidden_size, int64_t num_layers, bool batch_first, double dropout, bool train, bool bidirectional, IntArrayRef batch_sizes, const Tensor & dropout_state);
static inline std::tuple<Tensor,Tensor,Tensor,std::vector<Tensor>> miopen_rnn_backward(const Tensor & input, TensorList weight, int64_t weight_stride0, const Tensor & weight_buf, const Tensor & hx, const Tensor & cx, const Tensor & output, const Tensor & grad_output, const Tensor & grad_hy, const Tensor & grad_cy, int64_t mode, int64_t hidden_size, int64_t num_layers, bool batch_first, double dropout, bool train, bool bidirectional, IntArrayRef batch_sizes, const Tensor & dropout_state, const Tensor & reserve, std::array<bool,4> output_mask);
static inline Tensor mm(const Tensor & self, const Tensor & mat2);
static inline Tensor & mm_out(Tensor & out, const Tensor & self, const Tensor & mat2);
static inline Tensor _sparse_mm(const Tensor & sparse, const Tensor & dense);
static inline std::tuple<Tensor,Tensor> mode(const Tensor & self, int64_t dim=-1, bool keepdim=false);
static inline std::tuple<Tensor &,Tensor &> mode_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t dim=-1, bool keepdim=false);
static inline Tensor mul(const Tensor & self, const Tensor & other);
static inline Tensor & mul_out(Tensor & out, const Tensor & self, const Tensor & other);
static inline Tensor mul(const Tensor & self, Scalar other);
static inline Tensor mv(const Tensor & self, const Tensor & vec);
static inline Tensor & mv_out(Tensor & out, const Tensor & self, const Tensor & vec);
static inline Tensor mvlgamma(const Tensor & self, int64_t p);
static inline Tensor narrow(const Tensor & self, int64_t dim, int64_t start, int64_t length);
static inline std::tuple<Tensor,Tensor,Tensor> native_batch_norm(const Tensor & input, const Tensor & weight, const Tensor & bias, const Tensor & running_mean, const Tensor & running_var, bool training, double momentum, double eps);
static inline std::tuple<Tensor,Tensor> batch_norm_stats(const Tensor & input, double eps);
static inline Tensor batch_norm_elemt(const Tensor & input, const Tensor & weight, const Tensor & bias, const Tensor & mean, const Tensor & invstd, double eps);
static inline std::tuple<Tensor,Tensor> batch_norm_gather_stats(const Tensor & input, const Tensor & mean, const Tensor & invstd, const Tensor & running_mean, const Tensor & running_var, double momentum, double eps, int64_t count);
static inline std::tuple<Tensor,Tensor> batch_norm_gather_stats_with_counts(const Tensor & input, const Tensor & mean, const Tensor & invstd, const Tensor & running_mean, const Tensor & running_var, double momentum, double eps, IntArrayRef counts);
static inline std::tuple<Tensor,Tensor,Tensor> native_batch_norm_backward(const Tensor & grad_out, const Tensor & input, const Tensor & weight, const Tensor & running_mean, const Tensor & running_var, const Tensor & save_mean, const Tensor & save_invstd, bool train, double eps, std::array<bool,3> output_mask);
static inline std::tuple<Tensor,Tensor,Tensor,Tensor> batch_norm_backward_reduce(const Tensor & grad_out, const Tensor & input, const Tensor & mean, const Tensor & invstd, bool input_g, bool weight_g, bool bias_g);
static inline Tensor batch_norm_backward_elemt(const Tensor & grad_out, const Tensor & input, const Tensor & mean, const Tensor & invstd, const Tensor & weight, const Tensor & mean_dy, const Tensor & mean_dy_xmu);
static inline std::tuple<Tensor,Tensor> batch_norm_update_stats(const Tensor & input, const Tensor & running_mean, const Tensor & running_var, double momentum);
static inline bool _nnpack_available();
static inline Tensor _nnpack_spatial_convolution(const Tensor & input, const Tensor & weight, const Tensor & bias, IntArrayRef padding);
static inline std::tuple<Tensor,Tensor,Tensor> _nnpack_spatial_convolution_backward(const Tensor & input, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, std::array<bool,3> output_mask);
static inline Tensor _nnpack_spatial_convolution_backward_input(const Tensor & input, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding);
static inline Tensor _nnpack_spatial_convolution_backward_weight(const Tensor & input, IntArrayRef weightsize, const Tensor & grad_output, IntArrayRef padding);
static inline Tensor ones(IntArrayRef size, const TensorOptions & options={});
static inline Tensor & ones_out(Tensor & out, IntArrayRef size);
static inline Tensor ones_like(const Tensor & self);
static inline Tensor ones_like(const Tensor & self, const TensorOptions & options);
static inline Tensor pairwise_distance(const Tensor & x1, const Tensor & x2, double p=2, double eps=1e-06, bool keepdim=false);
static inline Tensor cdist(const Tensor & x1, const Tensor & x2, double p=2);
static inline Tensor _cdist_backward(const Tensor & grad, const Tensor & x1, const Tensor & x2, double p, const Tensor & cdist);
static inline Tensor pdist(const Tensor & self, double p=2);
static inline Tensor _pdist_forward(const Tensor & self, double p=2);
static inline Tensor _pdist_backward(const Tensor & grad, const Tensor & self, double p, const Tensor & pdist);
static inline Tensor cosine_similarity(const Tensor & x1, const Tensor & x2, int64_t dim=1, double eps=1e-08);
static inline Tensor pixel_shuffle(const Tensor & self, int64_t upscale_factor);
static inline Tensor pin_memory(const Tensor & self);
static inline Tensor pinverse(const Tensor & self, double rcond=1e-15);
static inline Tensor poisson_nll_loss(const Tensor & input, const Tensor & target, bool log_input, bool full, double eps, int64_t reduction);
static inline Tensor scalar_tensor(Scalar s, const TensorOptions & options={});
static inline Tensor rand(IntArrayRef size, const TensorOptions & options={});
static inline Tensor rand(IntArrayRef size, Generator * generator, const TensorOptions & options={});
static inline Tensor & rand_out(Tensor & out, IntArrayRef size);
static inline Tensor & rand_out(Tensor & out, IntArrayRef size, Generator * generator);
static inline Tensor rand_like(const Tensor & self);
static inline Tensor rand_like(const Tensor & self, const TensorOptions & options);
static inline Tensor randint(int64_t high, IntArrayRef size, const TensorOptions & options={});
static inline Tensor randint(int64_t high, IntArrayRef size, Generator * generator, const TensorOptions & options={});
static inline Tensor randint(int64_t low, int64_t high, IntArrayRef size, const TensorOptions & options={});
static inline Tensor randint(int64_t low, int64_t high, IntArrayRef size, Generator * generator, const TensorOptions & options={});
static inline Tensor & randint_out(Tensor & out, int64_t high, IntArrayRef size);
static inline Tensor & randint_out(Tensor & out, int64_t high, IntArrayRef size, Generator * generator);
static inline Tensor & randint_out(Tensor & out, int64_t low, int64_t high, IntArrayRef size);
static inline Tensor & randint_out(Tensor & out, int64_t low, int64_t high, IntArrayRef size, Generator * generator);
static inline Tensor randint_like(const Tensor & self, int64_t high);
static inline Tensor randint_like(const Tensor & self, int64_t low, int64_t high);
static inline Tensor randint_like(const Tensor & self, int64_t high, const TensorOptions & options);
static inline Tensor randint_like(const Tensor & self, int64_t low, int64_t high, const TensorOptions & options);
static inline Tensor randn(IntArrayRef size, const TensorOptions & options={});
static inline Tensor randn(IntArrayRef size, Generator * generator, const TensorOptions & options={});
static inline Tensor & randn_out(Tensor & out, IntArrayRef size);
static inline Tensor & randn_out(Tensor & out, IntArrayRef size, Generator * generator);
static inline Tensor randn_like(const Tensor & self);
static inline Tensor randn_like(const Tensor & self, const TensorOptions & options);
static inline Tensor randperm(int64_t n, const TensorOptions & options={});
static inline Tensor randperm(int64_t n, Generator * generator, const TensorOptions & options={});
static inline Tensor & randperm_out(Tensor & out, int64_t n);
static inline Tensor & randperm_out(Tensor & out, int64_t n, Generator * generator);
static inline Tensor range(Scalar start, Scalar end, Scalar step=1, const TensorOptions & options={});
static inline Tensor range(Scalar start, Scalar end, const TensorOptions & options={});
static inline Tensor & range_out(Tensor & out, Scalar start, Scalar end, Scalar step=1);
static inline Tensor reciprocal(const Tensor & self);
static inline Tensor & reciprocal_(Tensor & self);
static inline Tensor & reciprocal_out(Tensor & out, const Tensor & self);
static inline Tensor neg(const Tensor & self);
static inline Tensor & neg_(Tensor & self);
static inline Tensor & neg_out(Tensor & out, const Tensor & self);
static inline Tensor repeat_interleave(const Tensor & repeats);
static inline Tensor repeat_interleave(const Tensor & self, const Tensor & repeats, c10::optional<int64_t> dim=c10::nullopt);
static inline Tensor repeat_interleave(const Tensor & self, int64_t repeats, c10::optional<int64_t> dim=c10::nullopt);
static inline Tensor reshape(const Tensor & self, IntArrayRef shape);
static inline Tensor _mkldnn_reshape(const Tensor & self, IntArrayRef shape);
static inline Tensor round(const Tensor & self);
static inline Tensor & round_(Tensor & self);
static inline Tensor & round_out(Tensor & out, const Tensor & self);
static inline Tensor rrelu(const Tensor & self, Scalar lower=0.125, Scalar upper=0.333333333333, bool training=false, Generator * generator=nullptr);
static inline Tensor & rrelu_(Tensor & self, Scalar lower=0.125, Scalar upper=0.333333333333, bool training=false, Generator * generator=nullptr);
static inline Tensor relu(const Tensor & self);
static inline Tensor & relu_(Tensor & self);
static inline Tensor prelu(const Tensor & self, const Tensor & weight);
static inline std::tuple<Tensor,Tensor> prelu_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight);
static inline Tensor gelu(const Tensor & self);
static inline Tensor gelu_backward(const Tensor & grad, const Tensor & self);
static inline Tensor hardshrink(const Tensor & self, Scalar lambd=0.5);
static inline Tensor hardshrink_backward(const Tensor & grad_out, const Tensor & self, Scalar lambd);
static inline Tensor rsqrt(const Tensor & self);
static inline Tensor & rsqrt_(Tensor & self);
static inline Tensor & rsqrt_out(Tensor & out, const Tensor & self);
#ifdef BUILD_NAMEDTENSOR
static inline Tensor select(const Tensor & self, Dimname dim, int64_t index);
#endif
static inline Tensor select(const Tensor & self, int64_t dim, int64_t index);
static inline Tensor selu(const Tensor & self);
static inline Tensor & selu_(Tensor & self);
static inline Tensor celu(const Tensor & self, Scalar alpha=1.0);
static inline Tensor & celu_(Tensor & self, Scalar alpha=1.0);
static inline Tensor sigmoid(const Tensor & self);
static inline Tensor & sigmoid_(Tensor & self);
static inline Tensor & sigmoid_out(Tensor & out, const Tensor & self);
static inline Tensor sin(const Tensor & self);
static inline Tensor & sin_(Tensor & self);
static inline Tensor & sin_out(Tensor & out, const Tensor & self);
static inline Tensor sinh(const Tensor & self);
static inline Tensor & sinh_(Tensor & self);
static inline Tensor & sinh_out(Tensor & out, const Tensor & self);
static inline Tensor detach(const Tensor & self);
static inline Tensor & detach_(Tensor & self);
static inline int64_t size(const Tensor & self, int64_t dim);
#ifdef BUILD_NAMEDTENSOR
static inline int64_t size(const Tensor & self, Dimname dim);
#endif
static inline Tensor slice(const Tensor & self, int64_t dim=0, int64_t start=0, int64_t end=9223372036854775807, int64_t step=1);
static inline std::tuple<Tensor,Tensor> slogdet(const Tensor & self);
static inline Tensor smm(const Tensor & self, const Tensor & mat2);
static inline Tensor softmax(const Tensor & self, int64_t dim, c10::optional<ScalarType> dtype=c10::nullopt);
static inline Tensor _softmax(const Tensor & self, int64_t dim, bool half_to_float);
static inline Tensor _softmax_backward_data(const Tensor & grad_output, const Tensor & output, int64_t dim, const Tensor & self);
static inline Tensor & _sparse_add_out(Tensor & out, const Tensor & self, const Tensor & other, Scalar alpha=1);
static inline Tensor & _sparse_dense_add_out(Tensor & out, const Tensor & self, const Tensor & other, Scalar alpha=1);
static inline Tensor & _sparse_div_zerodim_out(Tensor & out, const Tensor & self, const Tensor & other);
static inline Tensor & _sparse_div_scalar_out(Tensor & out, const Tensor & self, Scalar other);
static inline Tensor & _sparse_mul_out(Tensor & out, const Tensor & self, const Tensor & other);
static inline Tensor & _sparse_mul_zerodim_out(Tensor & out, const Tensor & self, const Tensor & other);
static inline Tensor & _sparse_mul_scalar_out(Tensor & out, const Tensor & self, Scalar other);
static inline std::vector<Tensor> split(const Tensor & self, int64_t split_size, int64_t dim=0);
static inline std::vector<Tensor> split_with_sizes(const Tensor & self, IntArrayRef split_sizes, int64_t dim=0);
static inline Tensor squeeze(const Tensor & self);
static inline Tensor squeeze(const Tensor & self, int64_t dim);
static inline Tensor sspaddmm(const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta=1, Scalar alpha=1);
static inline Tensor & sspaddmm_out(Tensor & out, const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta=1, Scalar alpha=1);
static inline Tensor stack(TensorList tensors, int64_t dim=0);
static inline Tensor & stack_out(Tensor & out, TensorList tensors, int64_t dim=0);
static inline Tensor stft(const Tensor & self, int64_t n_fft, c10::optional<int64_t> hop_length=c10::nullopt, c10::optional<int64_t> win_length=c10::nullopt, const Tensor & window={}, bool normalized=false, bool onesided=true);
static inline int64_t stride(const Tensor & self, int64_t dim);
#ifdef BUILD_NAMEDTENSOR
static inline int64_t stride(const Tensor & self, Dimname dim);
#endif
static inline Tensor sum(const Tensor & self, c10::optional<ScalarType> dtype=c10::nullopt);
static inline Tensor sum(const Tensor & self, IntArrayRef dim, bool keepdim=false, c10::optional<ScalarType> dtype=c10::nullopt);
#ifdef BUILD_NAMEDTENSOR
static inline Tensor sum(const Tensor & self, DimnameList dim, bool keepdim=false, c10::optional<ScalarType> dtype=c10::nullopt);
#endif
static inline Tensor & sum_out(Tensor & out, const Tensor & self, IntArrayRef dim, bool keepdim=false, c10::optional<ScalarType> dtype=c10::nullopt);
#ifdef BUILD_NAMEDTENSOR
static inline Tensor & sum_out(Tensor & out, const Tensor & self, DimnameList dim, bool keepdim=false, c10::optional<ScalarType> dtype=c10::nullopt);
#endif
static inline Tensor sqrt(const Tensor & self);
static inline Tensor & sqrt_(Tensor & self);
static inline Tensor & sqrt_out(Tensor & out, const Tensor & self);
static inline Tensor std(const Tensor & self, bool unbiased=true);
static inline Tensor std(const Tensor & self, IntArrayRef dim, bool unbiased=true, bool keepdim=false);
static inline std::tuple<Tensor,Tensor> std_mean(const Tensor & self, bool unbiased=true);
static inline std::tuple<Tensor,Tensor> std_mean(const Tensor & self, IntArrayRef dim, bool unbiased=true, bool keepdim=false);
static inline Tensor & std_out(Tensor & out, const Tensor & self, IntArrayRef dim, bool unbiased=true, bool keepdim=false);
static inline Tensor prod(const Tensor & self, c10::optional<ScalarType> dtype=c10::nullopt);
static inline Tensor prod(const Tensor & self, int64_t dim, bool keepdim=false, c10::optional<ScalarType> dtype=c10::nullopt);
static inline Tensor & prod_out(Tensor & out, const Tensor & self, int64_t dim, bool keepdim=false, c10::optional<ScalarType> dtype=c10::nullopt);
#ifdef BUILD_NAMEDTENSOR
static inline Tensor prod(const Tensor & self, Dimname dim, bool keepdim=false, c10::optional<ScalarType> dtype=c10::nullopt);
#endif
#ifdef BUILD_NAMEDTENSOR
static inline Tensor & prod_out(Tensor & out, const Tensor & self, Dimname dim, bool keepdim=false, c10::optional<ScalarType> dtype=c10::nullopt);
#endif
static inline Tensor t(const Tensor & self);
static inline Tensor tan(const Tensor & self);
static inline Tensor & tan_(Tensor & self);
static inline Tensor & tan_out(Tensor & out, const Tensor & self);
static inline Tensor tanh(const Tensor & self);
static inline Tensor & tanh_(Tensor & self);
static inline Tensor & tanh_out(Tensor & out, const Tensor & self);
static inline Tensor tensordot(const Tensor & self, const Tensor & other, IntArrayRef dims_self, IntArrayRef dims_other);
static inline Tensor threshold(const Tensor & self, Scalar threshold, Scalar value);
static inline Tensor & threshold_(Tensor & self, Scalar threshold, Scalar value);
static inline Tensor & threshold_out(Tensor & out, const Tensor & self, Scalar threshold, Scalar value);
static inline Tensor threshold_backward(const Tensor & grad_output, const Tensor & self, Scalar threshold);
static inline Tensor transpose(const Tensor & self, int64_t dim0, int64_t dim1);
static inline Tensor _mkldnn_transpose(const Tensor & self, int64_t dim0, int64_t dim1);
static inline Tensor & _mkldnn_transpose_(Tensor & self, int64_t dim0, int64_t dim1);
static inline Tensor one_hot(const Tensor & self, int64_t num_classes=-1);
static inline Tensor flip(const Tensor & self, IntArrayRef dims);
static inline Tensor roll(const Tensor & self, IntArrayRef shifts, IntArrayRef dims={});
static inline Tensor rot90(const Tensor & self, int64_t k=1, IntArrayRef dims={0,1});
static inline Tensor trapz(const Tensor & y, const Tensor & x, int64_t dim=-1);
static inline Tensor trapz(const Tensor & y, double dx=1, int64_t dim=-1);
static inline Tensor _trilinear(const Tensor & i1, const Tensor & i2, const Tensor & i3, IntArrayRef expand1, IntArrayRef expand2, IntArrayRef expand3, IntArrayRef sumdim, int64_t unroll_dim=1);
static inline Tensor triplet_margin_loss(const Tensor & anchor, const Tensor & positive, const Tensor & negative, double margin=1.0, double p=2, double eps=1e-06, bool swap=false, int64_t reduction=Reduction::Mean);
static inline Tensor trunc(const Tensor & self);
static inline Tensor & trunc_(Tensor & self);
static inline Tensor & trunc_out(Tensor & out, const Tensor & self);
static inline bool _has_compatible_shallow_copy_type(const Tensor & self, const Tensor & from);
static inline std::tuple<Tensor,Tensor> _unique(const Tensor & self, bool sorted=true, bool return_inverse=false);
static inline std::tuple<Tensor,Tensor,Tensor> unique_dim(const Tensor & self, int64_t dim, bool sorted=true, bool return_inverse=false, bool return_counts=false);
static inline std::tuple<Tensor,Tensor,Tensor> unique_consecutive(const Tensor & self, bool return_inverse=false, bool return_counts=false, c10::optional<int64_t> dim=c10::nullopt);
static inline std::tuple<Tensor,Tensor,Tensor> unique_dim_consecutive(const Tensor & self, int64_t dim, bool return_inverse=false, bool return_counts=false);
static inline std::tuple<Tensor,Tensor,Tensor> _unique2(const Tensor & self, bool sorted=true, bool return_inverse=false, bool return_counts=false);
static inline Tensor _unsafe_view(const Tensor & self, IntArrayRef size);
static inline Tensor unsqueeze(const Tensor & self, int64_t dim);
static inline Tensor var(const Tensor & self, bool unbiased=true);
static inline Tensor var(const Tensor & self, IntArrayRef dim, bool unbiased=true, bool keepdim=false);
static inline Tensor & var_out(Tensor & out, const Tensor & self, IntArrayRef dim, bool unbiased=true, bool keepdim=false);
static inline std::tuple<Tensor,Tensor> var_mean(const Tensor & self, bool unbiased=true);
static inline std::tuple<Tensor,Tensor> var_mean(const Tensor & self, IntArrayRef dim, bool unbiased=true, bool keepdim=false);
static inline Tensor where(const Tensor & condition, const Tensor & self, const Tensor & other);
static inline std::vector<Tensor> where(const Tensor & condition);
static inline Tensor _s_where(const Tensor & condition, const Tensor & self, const Tensor & other);
static inline Tensor norm_except_dim(const Tensor & v, int64_t pow=2, int64_t dim=0);
static inline Tensor _weight_norm(const Tensor & v, const Tensor & g, int64_t dim=0);
static inline std::tuple<Tensor,Tensor> _weight_norm_cuda_interface(const Tensor & v, const Tensor & g, int64_t dim=0);
static inline std::tuple<Tensor,Tensor> _weight_norm_cuda_interface_backward(const Tensor & grad_w, const Tensor & saved_v, const Tensor & saved_g, const Tensor & saved_norms, int64_t dim);
static inline std::tuple<Tensor,Tensor> _weight_norm_differentiable_backward(const Tensor & grad_w, const Tensor & saved_v, const Tensor & saved_g, const Tensor & saved_norms, int64_t dim);
static inline Tensor zeros(IntArrayRef size, const TensorOptions & options={});
static inline Tensor & zeros_out(Tensor & out, IntArrayRef size);
static inline Tensor zeros_like(const Tensor & self);
static inline Tensor zeros_like(const Tensor & self, const TensorOptions & options);
static inline Tensor _standard_gamma_grad(const Tensor & self, const Tensor & output);
static inline Tensor _standard_gamma(const Tensor & self, Generator * generator=nullptr);
static inline Tensor _dirichlet_grad(const Tensor & x, const Tensor & alpha, const Tensor & total);
static inline Tensor _sample_dirichlet(const Tensor & self, Generator * generator=nullptr);
static inline Tensor poisson(const Tensor & self, Generator * generator=nullptr);
static inline Tensor native_norm(const Tensor & self, Scalar p=2);
static inline Tensor _sparse_sum(const Tensor & self);
static inline Tensor _sparse_sum(const Tensor & self, ScalarType dtype);
static inline Tensor _sparse_sum(const Tensor & self, IntArrayRef dim);
static inline Tensor _sparse_sum(const Tensor & self, IntArrayRef dim, ScalarType dtype);
static inline Tensor _sparse_sum_backward(const Tensor & grad, const Tensor & self, IntArrayRef dim);
static inline Tensor norm(const Tensor & self, c10::optional<Scalar> p, ScalarType dtype);
static inline Tensor norm(const Tensor & self, Scalar p=2);
static inline Tensor norm(const Tensor & self, c10::optional<Scalar> p, IntArrayRef dim, bool keepdim, ScalarType dtype);
static inline Tensor norm(const Tensor & self, c10::optional<Scalar> p, IntArrayRef dim, bool keepdim=false);
static inline Tensor & norm_out(Tensor & out, const Tensor & self, c10::optional<Scalar> p, IntArrayRef dim, bool keepdim, ScalarType dtype);
static inline Tensor & norm_out(Tensor & out, const Tensor & self, c10::optional<Scalar> p, IntArrayRef dim, bool keepdim=false);
static inline Tensor frobenius_norm(const Tensor & self);
static inline Tensor frobenius_norm(const Tensor & self, IntArrayRef dim, bool keepdim=false);
static inline Tensor & frobenius_norm_out(Tensor & out, const Tensor & self, IntArrayRef dim, bool keepdim=false);
static inline Tensor nuclear_norm(const Tensor & self, bool keepdim=false);
static inline Tensor & nuclear_norm_out(Tensor & out, const Tensor & self, bool keepdim=false);
static inline Tensor nuclear_norm(const Tensor & self, IntArrayRef dim, bool keepdim=false);
static inline Tensor & nuclear_norm_out(Tensor & out, const Tensor & self, IntArrayRef dim, bool keepdim=false);
static inline Tensor clone(const Tensor & self);
static inline Tensor & resize_as_(Tensor & self, const Tensor & the_template);
static inline Tensor & pow_out(Tensor & out, const Tensor & self, Scalar exponent);
static inline Tensor pow(const Tensor & self, Scalar exponent);
static inline Tensor & zero_(Tensor & self);
static inline Tensor & sub_out(Tensor & out, const Tensor & self, const Tensor & other, Scalar alpha=1);
static inline Tensor sub(const Tensor & self, const Tensor & other, Scalar alpha=1);
static inline Tensor sub(const Tensor & self, Scalar other, Scalar alpha=1);
static inline Tensor rsub(const Tensor & self, const Tensor & other, Scalar alpha=1);
static inline Tensor rsub(const Tensor & self, Scalar other, Scalar alpha=1);
static inline Tensor & s_native_addmm_out(Tensor & out, const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta=1, Scalar alpha=1);
static inline Tensor s_native_addmm(const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta=1, Scalar alpha=1);
static inline Tensor & s_native_addmm_(Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta=1, Scalar alpha=1);
static inline Tensor _sparse_addmm(const Tensor & self, const Tensor & sparse, const Tensor & dense, Scalar beta=1, Scalar alpha=1);
static inline Tensor & addmm_out(Tensor & out, const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta=1, Scalar alpha=1);
static inline Tensor addmm(const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta=1, Scalar alpha=1);
static inline Tensor sparse_coo_tensor(IntArrayRef size, const TensorOptions & options);
static inline Tensor sparse_coo_tensor(const Tensor & indices, const Tensor & values, const TensorOptions & options={});
static inline Tensor sparse_coo_tensor(const Tensor & indices, const Tensor & values, IntArrayRef size, const TensorOptions & options={});
static inline Tensor _sparse_coo_tensor_unsafe(const Tensor & indices, const Tensor & values, IntArrayRef size, const TensorOptions & options={});
static inline Tensor _sparse_coo_tensor_with_dims(int64_t sparse_dim, int64_t dense_dim, IntArrayRef size, const TensorOptions & options);
static inline Tensor _sparse_coo_tensor_with_dims_and_tensors(int64_t sparse_dim, int64_t dense_dim, IntArrayRef size, const Tensor & indices, const Tensor & values, const TensorOptions & options);
static inline Tensor to_dense_backward(const Tensor & grad, const Tensor & input);
static inline Tensor & hspmm_out(Tensor & out, const Tensor & mat1, const Tensor & mat2);
static inline Tensor hspmm(const Tensor & mat1, const Tensor & mat2);
static inline Tensor & copy_sparse_to_sparse_(Tensor & self, const Tensor & src, bool non_blocking=false);
static inline int64_t numel(const Tensor & self);
static inline std::vector<Tensor> unbind(const Tensor & self, int64_t dim=0);
static inline Tensor mkldnn_reorder_conv2d_weight(const Tensor & self, IntArrayRef padding=0, IntArrayRef stride=1, IntArrayRef dilation=1, int64_t groups=1);
static inline Tensor to_mkldnn_backward(const Tensor & grad, const Tensor & input);
static inline Tensor quantize_linear(const Tensor & self, double scale, int64_t zero_point, ScalarType dtype);
static inline Tensor quantize_linear_per_channel(const Tensor & self, const Tensor & scales, const Tensor & zero_points, IntArrayRef axis, ScalarType dtype);
static inline Tensor dequantize(const Tensor & self);
static inline Tensor _dequantize_linear(const Tensor & self, double scale, int64_t zero_point, ScalarType dtype);
static inline double q_scale(const Tensor & self);
static inline int64_t q_zero_point(const Tensor & self);
static inline Tensor int_repr(const Tensor & self);
static inline Tensor _per_tensor_affine_qtensor(const Tensor & self, double scale, int64_t zero_point);
static inline Tensor fake_quantize_per_tensor_affine(const Tensor & self, double scale, int64_t zero_point, int64_t quant_min, int64_t quant_max);
static inline Tensor fake_quantize_per_tensor_affine_backward(const Tensor & grad, const Tensor & self, double scale, int64_t zero_point, int64_t quant_min, int64_t quant_max);
static inline std::vector<Tensor> meshgrid(TensorList tensors);
static inline Tensor cartesian_prod(TensorList tensors);
static inline Tensor combinations(const Tensor & self, int64_t r=2, bool with_replacement=false);
static inline Scalar _local_scalar_dense(const Tensor & self);
static inline std::tuple<Tensor,Tensor,Tensor> _thnn_fused_lstm_cell(const Tensor & input_gates, const Tensor & hidden_gates, const Tensor & cx, const Tensor & input_bias={}, const Tensor & hidden_bias={});
static inline std::tuple<Tensor,Tensor,Tensor,Tensor,Tensor> _thnn_fused_lstm_cell_backward(const Tensor & grad_hy, const Tensor & grad_cy, const Tensor & cx, const Tensor & cy, const Tensor & workspace, bool has_bias);
static inline std::tuple<Tensor,Tensor> _thnn_fused_gru_cell(const Tensor & input_gates, const Tensor & hidden_gates, const Tensor & hx, const Tensor & input_bias={}, const Tensor & hidden_bias={});
static inline std::tuple<Tensor,Tensor,Tensor,Tensor,Tensor> _thnn_fused_gru_cell_backward(const Tensor & grad_hy, const Tensor & workspace, bool has_bias);
static inline std::tuple<Tensor,Tensor,Tensor> lstm(const Tensor & input, TensorList hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional, bool batch_first);
static inline std::tuple<Tensor,Tensor,Tensor> lstm(const Tensor & data, const Tensor & batch_sizes, TensorList hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional);
static inline std::tuple<Tensor,Tensor> gru(const Tensor & input, const Tensor & hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional, bool batch_first);
static inline std::tuple<Tensor,Tensor> gru(const Tensor & data, const Tensor & batch_sizes, const Tensor & hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional);
static inline std::tuple<Tensor,Tensor> rnn_tanh(const Tensor & input, const Tensor & hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional, bool batch_first);
static inline std::tuple<Tensor,Tensor> rnn_tanh(const Tensor & data, const Tensor & batch_sizes, const Tensor & hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional);
static inline std::tuple<Tensor,Tensor> rnn_relu(const Tensor & input, const Tensor & hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional, bool batch_first);
static inline std::tuple<Tensor,Tensor> rnn_relu(const Tensor & data, const Tensor & batch_sizes, const Tensor & hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional);
static inline std::tuple<Tensor,Tensor> lstm_cell(const Tensor & input, TensorList hx, const Tensor & w_ih, const Tensor & w_hh, const Tensor & b_ih={}, const Tensor & b_hh={});
static inline Tensor gru_cell(const Tensor & input, const Tensor & hx, const Tensor & w_ih, const Tensor & w_hh, const Tensor & b_ih={}, const Tensor & b_hh={});
static inline Tensor rnn_tanh_cell(const Tensor & input, const Tensor & hx, const Tensor & w_ih, const Tensor & w_hh, const Tensor & b_ih={}, const Tensor & b_hh={});
static inline Tensor rnn_relu_cell(const Tensor & input, const Tensor & hx, const Tensor & w_ih, const Tensor & w_hh, const Tensor & b_ih={}, const Tensor & b_hh={});
static inline std::tuple<Tensor,Tensor,Tensor> quantized_lstm(const Tensor & input, TensorList hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional, bool batch_first, c10::optional<ScalarType> dtype=c10::nullopt);
static inline std::tuple<Tensor,Tensor> quantized_gru(const Tensor & input, const Tensor & hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional, bool batch_first);
static inline std::tuple<Tensor,Tensor> quantized_gru(const Tensor & data, const Tensor & batch_sizes, const Tensor & hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional);
static inline std::tuple<Tensor,Tensor> quantized_lstm_cell(const Tensor & input, TensorList hx, const Tensor & w_ih, const Tensor & w_hh, const Tensor & b_ih, const Tensor & b_hh, const Tensor & packed_ih, const Tensor & packed_hh, const Tensor & col_offsets_ih, const Tensor & col_offsets_hh, Scalar scale_ih, Scalar scale_hh, Scalar zero_point_ih, Scalar zero_point_hh);
static inline Tensor quantized_gru_cell(const Tensor & input, const Tensor & hx, const Tensor & w_ih, const Tensor & w_hh, const Tensor & b_ih, const Tensor & b_hh, const Tensor & packed_ih, const Tensor & packed_hh, const Tensor & col_offsets_ih, const Tensor & col_offsets_hh, Scalar scale_ih, Scalar scale_hh, Scalar zero_point_ih, Scalar zero_point_hh);
static inline Tensor quantized_rnn_relu_cell(const Tensor & input, const Tensor & hx, const Tensor & w_ih, const Tensor & w_hh, const Tensor & b_ih, const Tensor & b_hh, const Tensor & packed_ih, const Tensor & packed_hh, const Tensor & col_offsets_ih, const Tensor & col_offsets_hh, Scalar scale_ih, Scalar scale_hh, Scalar zero_point_ih, Scalar zero_point_hh);
static inline Tensor quantized_rnn_tanh_cell(const Tensor & input, const Tensor & hx, const Tensor & w_ih, const Tensor & w_hh, const Tensor & b_ih, const Tensor & b_hh, const Tensor & packed_ih, const Tensor & packed_hh, const Tensor & col_offsets_ih, const Tensor & col_offsets_hh, Scalar scale_ih, Scalar scale_hh, Scalar zero_point_ih, Scalar zero_point_hh);
static inline std::tuple<Tensor,Tensor> _pack_padded_sequence(const Tensor & input, const Tensor & lengths, bool batch_first);
static inline Tensor _pack_padded_sequence_backward(const Tensor & grad, IntArrayRef input_size, const Tensor & batch_sizes, bool batch_first);
static inline std::tuple<Tensor,Tensor> _pad_packed_sequence(const Tensor & data, const Tensor & batch_sizes, bool batch_first, Scalar padding_value, int64_t total_length);
static inline Tensor masked_fill(const Tensor & self, const Tensor & mask, Scalar value);
static inline Tensor masked_fill(const Tensor & self, const Tensor & mask, const Tensor & value);
static inline Tensor masked_scatter(const Tensor & self, const Tensor & mask, const Tensor & source);
static inline Tensor index_add(const Tensor & self, int64_t dim, const Tensor & index, const Tensor & source);
static inline Tensor index_fill(const Tensor & self, int64_t dim, const Tensor & index, Scalar value);
static inline Tensor index_fill(const Tensor & self, int64_t dim, const Tensor & index, const Tensor & value);
static inline Tensor scatter(const Tensor & self, int64_t dim, const Tensor & index, const Tensor & src);
static inline Tensor scatter(const Tensor & self, int64_t dim, const Tensor & index, Scalar value);
static inline Tensor scatter_add(const Tensor & self, int64_t dim, const Tensor & index, const Tensor & src);
static inline Tensor __and__(const Tensor & self, Scalar other);
static inline Tensor __and__(const Tensor & self, const Tensor & other);
static inline Tensor __or__(const Tensor & self, Scalar other);
static inline Tensor __or__(const Tensor & self, const Tensor & other);
static inline Tensor __xor__(const Tensor & self, Scalar other);
static inline Tensor __xor__(const Tensor & self, const Tensor & other);
static inline Tensor __lshift__(const Tensor & self, Scalar other);
static inline Tensor __lshift__(const Tensor & self, const Tensor & other);
static inline Tensor __rshift__(const Tensor & self, Scalar other);
static inline Tensor __rshift__(const Tensor & self, const Tensor & other);
static inline Tensor & addbmm_out(Tensor & out, const Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta=1, Scalar alpha=1);
static inline Tensor addbmm(const Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta=1, Scalar alpha=1);
static inline Tensor & diag_out(Tensor & out, const Tensor & self, int64_t diagonal=0);
static inline Tensor diag(const Tensor & self, int64_t diagonal=0);
static inline Tensor & cross_out(Tensor & out, const Tensor & self, const Tensor & other, c10::optional<int64_t> dim=c10::nullopt);
static inline Tensor cross(const Tensor & self, const Tensor & other, c10::optional<int64_t> dim=c10::nullopt);
static inline Tensor & triu_out(Tensor & out, const Tensor & self, int64_t diagonal=0);
static inline Tensor triu(const Tensor & self, int64_t diagonal=0);
static inline Tensor & tril_out(Tensor & out, const Tensor & self, int64_t diagonal=0);
static inline Tensor tril(const Tensor & self, int64_t diagonal=0);
static inline Tensor tril_indices(int64_t row, int64_t col, int64_t offset=0, const TensorOptions & options=at::kLong);
static inline Tensor triu_indices(int64_t row, int64_t col, int64_t offset=0, const TensorOptions & options=at::kLong);
static inline Tensor trace(const Tensor & self);
static inline Tensor & ne_out(Tensor & out, const Tensor & self, Scalar other);
static inline Tensor ne(const Tensor & self, Scalar other);
static inline Tensor & ne_out(Tensor & out, const Tensor & self, const Tensor & other);
static inline Tensor ne(const Tensor & self, const Tensor & other);
static inline Tensor & eq_out(Tensor & out, const Tensor & self, Scalar other);
static inline Tensor eq(const Tensor & self, Scalar other);
static inline Tensor & eq_out(Tensor & out, const Tensor & self, const Tensor & other);
static inline Tensor eq(const Tensor & self, const Tensor & other);
static inline Tensor & ge_out(Tensor & out, const Tensor & self, Scalar other);
static inline Tensor ge(const Tensor & self, Scalar other);
static inline Tensor & ge_out(Tensor & out, const Tensor & self, const Tensor & other);
static inline Tensor ge(const Tensor & self, const Tensor & other);
static inline Tensor & le_out(Tensor & out, const Tensor & self, Scalar other);
static inline Tensor le(const Tensor & self, Scalar other);
static inline Tensor & le_out(Tensor & out, const Tensor & self, const Tensor & other);
static inline Tensor le(const Tensor & self, const Tensor & other);
static inline Tensor & gt_out(Tensor & out, const Tensor & self, Scalar other);
static inline Tensor gt(const Tensor & self, Scalar other);
static inline Tensor & gt_out(Tensor & out, const Tensor & self, const Tensor & other);
static inline Tensor gt(const Tensor & self, const Tensor & other);
static inline Tensor & lt_out(Tensor & out, const Tensor & self, Scalar other);
static inline Tensor lt(const Tensor & self, Scalar other);
static inline Tensor & lt_out(Tensor & out, const Tensor & self, const Tensor & other);
static inline Tensor lt(const Tensor & self, const Tensor & other);
static inline Tensor & take_out(Tensor & out, const Tensor & self, const Tensor & index);
static inline Tensor take(const Tensor & self, const Tensor & index);
static inline Tensor & index_select_out(Tensor & out, const Tensor & self, int64_t dim, const Tensor & index);
static inline Tensor index_select(const Tensor & self, int64_t dim, const Tensor & index);
static inline Tensor & masked_select_out(Tensor & out, const Tensor & self, const Tensor & mask);
static inline Tensor masked_select(const Tensor & self, const Tensor & mask);
static inline Tensor & nonzero_out(Tensor & out, const Tensor & self);
static inline Tensor nonzero(const Tensor & self);
static inline std::vector<Tensor> nonzero_numpy(const Tensor & self);
static inline Tensor & gather_out(Tensor & out, const Tensor & self, int64_t dim, const Tensor & index, bool sparse_grad=false);
static inline Tensor gather(const Tensor & self, int64_t dim, const Tensor & index, bool sparse_grad=false);
static inline Tensor _gather_sparse_backward(const Tensor & self, int64_t dim, const Tensor & index, const Tensor & grad);
static inline Tensor & addcmul_out(Tensor & out, const Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value=1);
static inline Tensor addcmul(const Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value=1);
static inline Tensor & addcdiv_out(Tensor & out, const Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value=1);
static inline Tensor addcdiv(const Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value=1);
static inline std::tuple<Tensor &,Tensor &> lstsq_out(Tensor & X, Tensor & qr, const Tensor & self, const Tensor & A);
static inline std::tuple<Tensor,Tensor> lstsq(const Tensor & self, const Tensor & A);
static inline std::tuple<Tensor &,Tensor &> triangular_solve_out(Tensor & X, Tensor & M, const Tensor & self, const Tensor & A, bool upper=true, bool transpose=false, bool unitriangular=false);
static inline std::tuple<Tensor,Tensor> triangular_solve(const Tensor & self, const Tensor & A, bool upper=true, bool transpose=false, bool unitriangular=false);
static inline std::tuple<Tensor,Tensor> _triangular_solve_helper(const Tensor & self, const Tensor & A, bool upper, bool transpose, bool unitriangular);
static inline std::tuple<Tensor &,Tensor &> symeig_out(Tensor & e, Tensor & V, const Tensor & self, bool eigenvectors=false, bool upper=true);
static inline std::tuple<Tensor,Tensor> symeig(const Tensor & self, bool eigenvectors=false, bool upper=true);
static inline std::tuple<Tensor,Tensor> _symeig_helper(const Tensor & self, bool eigenvectors, bool upper);
static inline std::tuple<Tensor &,Tensor &> eig_out(Tensor & e, Tensor & v, const Tensor & self, bool eigenvectors=false);
static inline std::tuple<Tensor,Tensor> eig(const Tensor & self, bool eigenvectors=false);
static inline std::tuple<Tensor &,Tensor &,Tensor &> svd_out(Tensor & U, Tensor & S, Tensor & V, const Tensor & self, bool some=true, bool compute_uv=true);
static inline std::tuple<Tensor,Tensor,Tensor> svd(const Tensor & self, bool some=true, bool compute_uv=true);
static inline std::tuple<Tensor,Tensor,Tensor> _svd_helper(const Tensor & self, bool some, bool compute_uv);
static inline Tensor & cholesky_out(Tensor & out, const Tensor & self, bool upper=false);
static inline Tensor cholesky(const Tensor & self, bool upper=false);
static inline Tensor _cholesky_helper(const Tensor & self, bool upper);
static inline Tensor & cholesky_solve_out(Tensor & out, const Tensor & self, const Tensor & input2, bool upper=false);
static inline Tensor cholesky_solve(const Tensor & self, const Tensor & input2, bool upper=false);
static inline Tensor _cholesky_solve_helper(const Tensor & self, const Tensor & A, bool upper);
static inline std::tuple<Tensor,Tensor> solve(const Tensor & self, const Tensor & A);
static inline std::tuple<Tensor &,Tensor &> solve_out(Tensor & solution, Tensor & lu, const Tensor & self, const Tensor & A);
static inline std::tuple<Tensor,Tensor> _solve_helper(const Tensor & self, const Tensor & A);
static inline Tensor & cholesky_inverse_out(Tensor & out, const Tensor & self, bool upper=false);
static inline Tensor cholesky_inverse(const Tensor & self, bool upper=false);
static inline std::tuple<Tensor &,Tensor &> qr_out(Tensor & Q, Tensor & R, const Tensor & self, bool some=true);
static inline std::tuple<Tensor,Tensor> qr(const Tensor & self, bool some=true);
static inline std::tuple<Tensor,Tensor> _qr_helper(const Tensor & self, bool some);
static inline std::tuple<Tensor &,Tensor &> geqrf_out(Tensor & a, Tensor & tau, const Tensor & self);
static inline std::tuple<Tensor,Tensor> geqrf(const Tensor & self);
static inline Tensor & orgqr_out(Tensor & out, const Tensor & self, const Tensor & input2);
static inline Tensor orgqr(const Tensor & self, const Tensor & input2);
static inline Tensor & ormqr_out(Tensor & out, const Tensor & self, const Tensor & input2, const Tensor & input3, bool left=true, bool transpose=false);
static inline Tensor ormqr(const Tensor & self, const Tensor & input2, const Tensor & input3, bool left=true, bool transpose=false);
static inline std::tuple<Tensor,Tensor,Tensor> _lu_with_info(const Tensor & self, bool pivot=true, bool check_errors=true);
static inline Tensor & lu_solve_out(Tensor & out, const Tensor & self, const Tensor & LU_data, const Tensor & LU_pivots);
static inline Tensor lu_solve(const Tensor & self, const Tensor & LU_data, const Tensor & LU_pivots);
static inline Tensor _lu_solve_helper(const Tensor & self, const Tensor & LU_data, const Tensor & LU_pivots);
static inline Tensor & multinomial_out(Tensor & out, const Tensor & self, int64_t num_samples, bool replacement=false, Generator * generator=nullptr);
static inline Tensor multinomial(const Tensor & self, int64_t num_samples, bool replacement=false, Generator * generator=nullptr);
static inline std::tuple<Tensor,Tensor> _multinomial_alias_setup(const Tensor & probs);
static inline Tensor _multinomial_alias_draw(const Tensor & J, const Tensor & q, int64_t num_samples, Generator * generator=nullptr);
static inline Tensor & lgamma_out(Tensor & out, const Tensor & self);
static inline Tensor lgamma(const Tensor & self);
static inline Tensor & digamma_out(Tensor & out, const Tensor & self);
static inline Tensor digamma(const Tensor & self);
static inline Tensor & polygamma_out(Tensor & out, int64_t n, const Tensor & self);
static inline Tensor polygamma(int64_t n, const Tensor & self);
static inline Tensor & erfinv_out(Tensor & out, const Tensor & self);
static inline Tensor erfinv(const Tensor & self);
static inline Tensor dist(const Tensor & self, const Tensor & other, Scalar p=2);
static inline Tensor & atan2_out(Tensor & out, const Tensor & self, const Tensor & other);
static inline Tensor atan2(const Tensor & self, const Tensor & other);
static inline Tensor & lerp_out(Tensor & out, const Tensor & self, const Tensor & end, Scalar weight);
static inline Tensor & lerp_out(Tensor & out, const Tensor & self, const Tensor & end, const Tensor & weight);
static inline Tensor lerp(const Tensor & self, const Tensor & end, Scalar weight);
static inline Tensor lerp(const Tensor & self, const Tensor & end, const Tensor & weight);
static inline Tensor & histc_out(Tensor & out, const Tensor & self, int64_t bins=100, Scalar min=0, Scalar max=0);
static inline Tensor histc(const Tensor & self, int64_t bins=100, Scalar min=0, Scalar max=0);
static inline Tensor & sign_out(Tensor & out, const Tensor & self);
static inline Tensor sign(const Tensor & self);
static inline Tensor & fmod_out(Tensor & out, const Tensor & self, Scalar other);
static inline Tensor fmod(const Tensor & self, Scalar other);
static inline Tensor & fmod_out(Tensor & out, const Tensor & self, const Tensor & other);
static inline Tensor fmod(const Tensor & self, const Tensor & other);
static inline Tensor & remainder_out(Tensor & out, const Tensor & self, Scalar other);
static inline Tensor remainder(const Tensor & self, Scalar other);
static inline Tensor & remainder_out(Tensor & out, const Tensor & self, const Tensor & other);
static inline Tensor remainder(const Tensor & self, const Tensor & other);
static inline Tensor & min_out(Tensor & out, const Tensor & self, const Tensor & other);
static inline Tensor min(const Tensor & self, const Tensor & other);
static inline Tensor min(const Tensor & self);
static inline Tensor & max_out(Tensor & out, const Tensor & self, const Tensor & other);
static inline Tensor max(const Tensor & self, const Tensor & other);
static inline Tensor max(const Tensor & self);
static inline Tensor median(const Tensor & self);
static inline std::tuple<Tensor &,Tensor &> sort_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t dim=-1, bool descending=false);
static inline std::tuple<Tensor,Tensor> sort(const Tensor & self, int64_t dim=-1, bool descending=false);
static inline Tensor argsort(const Tensor & self, int64_t dim=-1, bool descending=false);
static inline std::tuple<Tensor &,Tensor &> topk_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t k, int64_t dim=-1, bool largest=true, bool sorted=true);
static inline std::tuple<Tensor,Tensor> topk(const Tensor & self, int64_t k, int64_t dim=-1, bool largest=true, bool sorted=true);
static inline Tensor all(const Tensor & self);
static inline Tensor any(const Tensor & self);
static inline Tensor & renorm_out(Tensor & out, const Tensor & self, Scalar p, int64_t dim, Scalar maxnorm);
static inline Tensor renorm(const Tensor & self, Scalar p, int64_t dim, Scalar maxnorm);
static inline bool equal(const Tensor & self, const Tensor & other);
static inline Tensor & pow_out(Tensor & out, const Tensor & self, const Tensor & exponent);
static inline Tensor pow(const Tensor & self, const Tensor & exponent);
static inline Tensor & pow_out(Tensor & out, Scalar self, const Tensor & exponent);
static inline Tensor pow(Scalar self, const Tensor & exponent);
static inline Tensor & normal_out(Tensor & out, const Tensor & mean, double std=1, Generator * generator=nullptr);
static inline Tensor normal(const Tensor & mean, double std=1, Generator * generator=nullptr);
static inline Tensor & normal_out(Tensor & out, double mean, const Tensor & std, Generator * generator=nullptr);
static inline Tensor normal(double mean, const Tensor & std, Generator * generator=nullptr);
static inline Tensor & normal_out(Tensor & out, const Tensor & mean, const Tensor & std, Generator * generator=nullptr);
static inline Tensor normal(const Tensor & mean, const Tensor & std, Generator * generator=nullptr);
static inline Tensor normal(double mean, double std, IntArrayRef size, Generator * generator=nullptr, const TensorOptions & options={});
static inline Tensor & normal_out(Tensor & out, double mean, double std, IntArrayRef size, Generator * generator=nullptr);
static inline Tensor alias(const Tensor & self);
static inline Tensor _addr(const Tensor & self, const Tensor & vec1, const Tensor & vec2, Scalar beta=1, Scalar alpha=1);
static inline Tensor & _addr_(Tensor & self, const Tensor & vec1, const Tensor & vec2, Scalar beta=1, Scalar alpha=1);
static inline Tensor & _addr_out(Tensor & out, const Tensor & self, const Tensor & vec1, const Tensor & vec2, Scalar beta=1, Scalar alpha=1);
static inline Tensor & _index_copy_(Tensor & self, int64_t dim, const Tensor & index, const Tensor & source);
static inline Tensor _cumsum(const Tensor & self, int64_t dim);
static inline Tensor & _cumsum_out(Tensor & out, const Tensor & self, int64_t dim);
static inline Tensor _cumprod(const Tensor & self, int64_t dim);
static inline Tensor & _cumprod_out(Tensor & out, const Tensor & self, int64_t dim);
static inline Tensor _var(const Tensor & self, bool unbiased=true);
static inline Tensor _std(const Tensor & self, bool unbiased=true);
static inline Tensor & _addmm_out(Tensor & out, const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta=1, Scalar alpha=1);
static inline Tensor _addmm(const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta=1, Scalar alpha=1);
static inline Tensor & _addmm_(Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta=1, Scalar alpha=1);
static inline Tensor _cat(TensorList tensors, int64_t dim=0);
static inline Tensor & _cat_out(Tensor & out, TensorList tensors, int64_t dim=0);
static inline std::tuple<Tensor,Tensor> _mode(const Tensor & self, int64_t dim=-1, bool keepdim=false);
static inline std::tuple<Tensor &,Tensor &> _mode_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t dim=-1, bool keepdim=false);
static inline std::tuple<Tensor,Tensor> _max(const Tensor & self, int64_t dim, bool keepdim=false);
static inline std::tuple<Tensor &,Tensor &> _max_out(Tensor & max, Tensor & max_indices, const Tensor & self, int64_t dim, bool keepdim=false);
static inline std::tuple<Tensor,Tensor> _min(const Tensor & self, int64_t dim, bool keepdim=false);
static inline std::tuple<Tensor &,Tensor &> _min_out(Tensor & min, Tensor & min_indices, const Tensor & self, int64_t dim, bool keepdim=false);
static inline Tensor & binary_cross_entropy_out(Tensor & out, const Tensor & self, const Tensor & target, const Tensor & weight={}, int64_t reduction=Reduction::Mean);
static inline Tensor binary_cross_entropy(const Tensor & self, const Tensor & target, const Tensor & weight={}, int64_t reduction=Reduction::Mean);
static inline Tensor & binary_cross_entropy_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight={}, int64_t reduction=Reduction::Mean);
static inline Tensor binary_cross_entropy_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight={}, int64_t reduction=Reduction::Mean);
static inline Tensor & mse_loss_out(Tensor & out, const Tensor & self, const Tensor & target, int64_t reduction=Reduction::Mean);
static inline Tensor mse_loss(const Tensor & self, const Tensor & target, int64_t reduction=Reduction::Mean);
static inline Tensor & mse_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction);
static inline Tensor mse_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction);
static inline Tensor & l1_loss_out(Tensor & out, const Tensor & self, const Tensor & target, int64_t reduction=Reduction::Mean);
static inline Tensor l1_loss(const Tensor & self, const Tensor & target, int64_t reduction=Reduction::Mean);
static inline Tensor & l1_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction);
static inline Tensor l1_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction);
static inline Tensor & multi_margin_loss_out(Tensor & out, const Tensor & self, const Tensor & target, Scalar p=1, Scalar margin=1, const Tensor & weight={}, int64_t reduction=Reduction::Mean);
static inline Tensor multi_margin_loss(const Tensor & self, const Tensor & target, Scalar p=1, Scalar margin=1, const Tensor & weight={}, int64_t reduction=Reduction::Mean);
static inline Tensor & multi_margin_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, Scalar p, Scalar margin, const Tensor & weight={}, int64_t reduction=Reduction::Mean);
static inline Tensor multi_margin_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, Scalar p, Scalar margin, const Tensor & weight={}, int64_t reduction=Reduction::Mean);
static inline Tensor & multilabel_margin_loss_out(Tensor & out, const Tensor & self, const Tensor & target, int64_t reduction=Reduction::Mean);
static inline Tensor multilabel_margin_loss(const Tensor & self, const Tensor & target, int64_t reduction=Reduction::Mean);
static inline std::tuple<Tensor &,Tensor &> multilabel_margin_loss_forward_out(Tensor & output, Tensor & is_target, const Tensor & self, const Tensor & target, int64_t reduction);
static inline std::tuple<Tensor,Tensor> multilabel_margin_loss_forward(const Tensor & self, const Tensor & target, int64_t reduction);
static inline Tensor & multilabel_margin_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction, const Tensor & is_target);
static inline Tensor multilabel_margin_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction, const Tensor & is_target);
static inline Tensor & nll_loss_out(Tensor & out, const Tensor & self, const Tensor & target, const Tensor & weight={}, int64_t reduction=Reduction::Mean, int64_t ignore_index=-100);
static inline Tensor nll_loss(const Tensor & self, const Tensor & target, const Tensor & weight={}, int64_t reduction=Reduction::Mean, int64_t ignore_index=-100);
static inline std::tuple<Tensor &,Tensor &> nll_loss_forward_out(Tensor & output, Tensor & total_weight, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index);
static inline std::tuple<Tensor,Tensor> nll_loss_forward(const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index);
static inline Tensor & nll_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index, const Tensor & total_weight);
static inline Tensor nll_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index, const Tensor & total_weight);
static inline Tensor & nll_loss2d_out(Tensor & out, const Tensor & self, const Tensor & target, const Tensor & weight={}, int64_t reduction=Reduction::Mean, int64_t ignore_index=-100);
static inline Tensor nll_loss2d(const Tensor & self, const Tensor & target, const Tensor & weight={}, int64_t reduction=Reduction::Mean, int64_t ignore_index=-100);
static inline std::tuple<Tensor &,Tensor &> nll_loss2d_forward_out(Tensor & output, Tensor & total_weight, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index);
static inline std::tuple<Tensor,Tensor> nll_loss2d_forward(const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index);
static inline Tensor & nll_loss2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index, const Tensor & total_weight);
static inline Tensor nll_loss2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index, const Tensor & total_weight);
static inline Tensor & smooth_l1_loss_out(Tensor & out, const Tensor & self, const Tensor & target, int64_t reduction=Reduction::Mean);
static inline Tensor smooth_l1_loss(const Tensor & self, const Tensor & target, int64_t reduction=Reduction::Mean);
static inline Tensor & smooth_l1_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction);
static inline Tensor smooth_l1_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction);
static inline Tensor & soft_margin_loss_out(Tensor & out, const Tensor & self, const Tensor & target, int64_t reduction=Reduction::Mean);
static inline Tensor soft_margin_loss(const Tensor & self, const Tensor & target, int64_t reduction=Reduction::Mean);
static inline Tensor & soft_margin_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction);
static inline Tensor soft_margin_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction);
static inline Tensor & elu_out(Tensor & out, const Tensor & self, Scalar alpha=1, Scalar scale=1, Scalar input_scale=1);
static inline Tensor elu(const Tensor & self, Scalar alpha=1, Scalar scale=1, Scalar input_scale=1);
static inline Tensor & elu_backward_out(Tensor & grad_input, const Tensor & grad_output, Scalar alpha, Scalar scale, Scalar input_scale, const Tensor & output);
static inline Tensor elu_backward(const Tensor & grad_output, Scalar alpha, Scalar scale, Scalar input_scale, const Tensor & output);
static inline Tensor & elu_(Tensor & self, Scalar alpha=1, Scalar scale=1, Scalar input_scale=1);
static inline Tensor & glu_out(Tensor & out, const Tensor & self, int64_t dim=-1);
static inline Tensor glu(const Tensor & self, int64_t dim=-1);
static inline Tensor & glu_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, int64_t dim);
static inline Tensor glu_backward(const Tensor & grad_output, const Tensor & self, int64_t dim);
static inline Tensor & hardtanh_out(Tensor & out, const Tensor & self, Scalar min_val=-1, Scalar max_val=1);
static inline Tensor hardtanh(const Tensor & self, Scalar min_val=-1, Scalar max_val=1);
static inline Tensor & hardtanh_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, Scalar min_val, Scalar max_val);
static inline Tensor hardtanh_backward(const Tensor & grad_output, const Tensor & self, Scalar min_val, Scalar max_val);
static inline Tensor & hardtanh_(Tensor & self, Scalar min_val=-1, Scalar max_val=1);
static inline Tensor & leaky_relu_out(Tensor & out, const Tensor & self, Scalar negative_slope=0.01);
static inline Tensor leaky_relu(const Tensor & self, Scalar negative_slope=0.01);
static inline Tensor & leaky_relu_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, Scalar negative_slope);
static inline Tensor leaky_relu_backward(const Tensor & grad_output, const Tensor & self, Scalar negative_slope);
static inline Tensor & leaky_relu_(Tensor & self, Scalar negative_slope=0.01);
static inline Tensor & log_sigmoid_out(Tensor & out, const Tensor & self);
static inline Tensor log_sigmoid(const Tensor & self);
static inline std::tuple<Tensor &,Tensor &> log_sigmoid_forward_out(Tensor & output, Tensor & buffer, const Tensor & self);
static inline std::tuple<Tensor,Tensor> log_sigmoid_forward(const Tensor & self);
static inline Tensor & log_sigmoid_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & buffer);
static inline Tensor log_sigmoid_backward(const Tensor & grad_output, const Tensor & self, const Tensor & buffer);
static inline Tensor & rrelu_with_noise_out(Tensor & out, const Tensor & self, const Tensor & noise, Scalar lower=0.125, Scalar upper=0.333333333333, bool training=false, Generator * generator=nullptr);
static inline Tensor rrelu_with_noise(const Tensor & self, const Tensor & noise, Scalar lower=0.125, Scalar upper=0.333333333333, bool training=false, Generator * generator=nullptr);
static inline Tensor & rrelu_with_noise_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & noise, Scalar lower, Scalar upper, bool training);
static inline Tensor rrelu_with_noise_backward(const Tensor & grad_output, const Tensor & self, const Tensor & noise, Scalar lower, Scalar upper, bool training);
static inline Tensor & rrelu_with_noise_(Tensor & self, const Tensor & noise, Scalar lower=0.125, Scalar upper=0.333333333333, bool training=false, Generator * generator=nullptr);
static inline Tensor & softplus_out(Tensor & out, const Tensor & self, Scalar beta=1, Scalar threshold=20);
static inline Tensor softplus(const Tensor & self, Scalar beta=1, Scalar threshold=20);
static inline Tensor & softplus_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, Scalar beta, Scalar threshold, const Tensor & output);
static inline Tensor softplus_backward(const Tensor & grad_output, const Tensor & self, Scalar beta, Scalar threshold, const Tensor & output);
static inline Tensor & softshrink_out(Tensor & out, const Tensor & self, Scalar lambd=0.5);
static inline Tensor softshrink(const Tensor & self, Scalar lambd=0.5);
static inline Tensor & softshrink_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, Scalar lambd);
static inline Tensor softshrink_backward(const Tensor & grad_output, const Tensor & self, Scalar lambd);
static inline Tensor & adaptive_avg_pool2d_out(Tensor & out, const Tensor & self, IntArrayRef output_size);
static inline Tensor adaptive_avg_pool2d(const Tensor & self, IntArrayRef output_size);
static inline Tensor mkldnn_adaptive_avg_pool2d(const Tensor & self, IntArrayRef output_size);
static inline Tensor _adaptive_avg_pool2d(const Tensor & self, IntArrayRef output_size);
static inline Tensor _adaptive_avg_pool2d_backward(const Tensor & grad_output, const Tensor & self);
static inline Tensor & adaptive_avg_pool3d_out(Tensor & out, const Tensor & self, IntArrayRef output_size);
static inline Tensor adaptive_avg_pool3d(const Tensor & self, IntArrayRef output_size);
static inline Tensor & adaptive_avg_pool3d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self);
static inline Tensor adaptive_avg_pool3d_backward(const Tensor & grad_output, const Tensor & self);
static inline std::tuple<Tensor &,Tensor &> adaptive_max_pool2d_out(Tensor & out, Tensor & indices, const Tensor & self, IntArrayRef output_size);
static inline std::tuple<Tensor,Tensor> adaptive_max_pool2d(const Tensor & self, IntArrayRef output_size);
static inline Tensor & adaptive_max_pool2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & indices);
static inline Tensor adaptive_max_pool2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & indices);
static inline std::tuple<Tensor &,Tensor &> adaptive_max_pool3d_out(Tensor & out, Tensor & indices, const Tensor & self, IntArrayRef output_size);
static inline std::tuple<Tensor,Tensor> adaptive_max_pool3d(const Tensor & self, IntArrayRef output_size);
static inline Tensor & adaptive_max_pool3d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & indices);
static inline Tensor adaptive_max_pool3d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & indices);
static inline Tensor & avg_pool2d_out(Tensor & out, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride={}, IntArrayRef padding=0, bool ceil_mode=false, bool count_include_pad=true, c10::optional<int64_t> divisor_override=c10::nullopt);
static inline Tensor avg_pool2d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride={}, IntArrayRef padding=0, bool ceil_mode=false, bool count_include_pad=true, c10::optional<int64_t> divisor_override=c10::nullopt);
static inline Tensor & avg_pool2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad, c10::optional<int64_t> divisor_override);
static inline Tensor avg_pool2d_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad, c10::optional<int64_t> divisor_override);
static inline Tensor & avg_pool3d_out(Tensor & out, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride={}, IntArrayRef padding=0, bool ceil_mode=false, bool count_include_pad=true, c10::optional<int64_t> divisor_override=c10::nullopt);
static inline Tensor avg_pool3d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride={}, IntArrayRef padding=0, bool ceil_mode=false, bool count_include_pad=true, c10::optional<int64_t> divisor_override=c10::nullopt);
static inline Tensor & avg_pool3d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad, c10::optional<int64_t> divisor_override);
static inline Tensor avg_pool3d_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad, c10::optional<int64_t> divisor_override);
static inline std::tuple<Tensor &,Tensor &> fractional_max_pool2d_out(Tensor & output, Tensor & indices, const Tensor & self, IntArrayRef kernel_size, IntArrayRef output_size, const Tensor & random_samples);
static inline std::tuple<Tensor,Tensor> fractional_max_pool2d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef output_size, const Tensor & random_samples);
static inline Tensor & fractional_max_pool2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef output_size, const Tensor & indices);
static inline Tensor fractional_max_pool2d_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef output_size, const Tensor & indices);
static inline std::tuple<Tensor &,Tensor &> fractional_max_pool3d_out(Tensor & output, Tensor & indices, const Tensor & self, IntArrayRef kernel_size, IntArrayRef output_size, const Tensor & random_samples);
static inline std::tuple<Tensor,Tensor> fractional_max_pool3d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef output_size, const Tensor & random_samples);
static inline Tensor & fractional_max_pool3d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef output_size, const Tensor & indices);
static inline Tensor fractional_max_pool3d_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef output_size, const Tensor & indices);
static inline std::tuple<Tensor &,Tensor &> max_pool2d_with_indices_out(Tensor & out, Tensor & indices, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride={}, IntArrayRef padding=0, IntArrayRef dilation=1, bool ceil_mode=false);
static inline std::tuple<Tensor,Tensor> max_pool2d_with_indices(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride={}, IntArrayRef padding=0, IntArrayRef dilation=1, bool ceil_mode=false);
static inline Tensor & max_pool2d_with_indices_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode, const Tensor & indices);
static inline Tensor max_pool2d_with_indices_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode, const Tensor & indices);
static inline std::tuple<Tensor &,Tensor &> max_pool3d_with_indices_out(Tensor & out, Tensor & indices, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride={}, IntArrayRef padding=0, IntArrayRef dilation=1, bool ceil_mode=false);
static inline std::tuple<Tensor,Tensor> max_pool3d_with_indices(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride={}, IntArrayRef padding=0, IntArrayRef dilation=1, bool ceil_mode=false);
static inline Tensor & max_pool3d_with_indices_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode, const Tensor & indices);
static inline Tensor max_pool3d_with_indices_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode, const Tensor & indices);
static inline Tensor & max_unpool2d_out(Tensor & out, const Tensor & self, const Tensor & indices, IntArrayRef output_size);
static inline Tensor max_unpool2d(const Tensor & self, const Tensor & indices, IntArrayRef output_size);
static inline Tensor & max_unpool2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & indices, IntArrayRef output_size);
static inline Tensor max_unpool2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & indices, IntArrayRef output_size);
static inline Tensor & max_unpool3d_out(Tensor & out, const Tensor & self, const Tensor & indices, IntArrayRef output_size, IntArrayRef stride, IntArrayRef padding);
static inline Tensor max_unpool3d(const Tensor & self, const Tensor & indices, IntArrayRef output_size, IntArrayRef stride, IntArrayRef padding);
static inline Tensor & max_unpool3d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & indices, IntArrayRef output_size, IntArrayRef stride, IntArrayRef padding);
static inline Tensor max_unpool3d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & indices, IntArrayRef output_size, IntArrayRef stride, IntArrayRef padding);
static inline Tensor & reflection_pad1d_out(Tensor & out, const Tensor & self, IntArrayRef padding);
static inline Tensor reflection_pad1d(const Tensor & self, IntArrayRef padding);
static inline Tensor & reflection_pad1d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef padding);
static inline Tensor reflection_pad1d_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef padding);
static inline Tensor & reflection_pad2d_out(Tensor & out, const Tensor & self, IntArrayRef padding);
static inline Tensor reflection_pad2d(const Tensor & self, IntArrayRef padding);
static inline Tensor & reflection_pad2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef padding);
static inline Tensor reflection_pad2d_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef padding);
static inline Tensor & replication_pad1d_out(Tensor & out, const Tensor & self, IntArrayRef padding);
static inline Tensor replication_pad1d(const Tensor & self, IntArrayRef padding);
static inline Tensor & replication_pad1d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef padding);
static inline Tensor replication_pad1d_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef padding);
static inline Tensor & replication_pad2d_out(Tensor & out, const Tensor & self, IntArrayRef padding);
static inline Tensor replication_pad2d(const Tensor & self, IntArrayRef padding);
static inline Tensor & replication_pad2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef padding);
static inline Tensor replication_pad2d_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef padding);
static inline Tensor & replication_pad3d_out(Tensor & out, const Tensor & self, IntArrayRef padding);
static inline Tensor replication_pad3d(const Tensor & self, IntArrayRef padding);
static inline Tensor & replication_pad3d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef padding);
static inline Tensor replication_pad3d_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef padding);
static inline Tensor & upsample_linear1d_out(Tensor & out, const Tensor & self, IntArrayRef output_size, bool align_corners);
static inline Tensor upsample_linear1d(const Tensor & self, IntArrayRef output_size, bool align_corners);
static inline Tensor & upsample_linear1d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners);
static inline Tensor upsample_linear1d_backward(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners);
static inline Tensor & upsample_bilinear2d_out(Tensor & out, const Tensor & self, IntArrayRef output_size, bool align_corners);
static inline Tensor upsample_bilinear2d(const Tensor & self, IntArrayRef output_size, bool align_corners);
static inline Tensor & upsample_bilinear2d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners);
static inline Tensor upsample_bilinear2d_backward(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners);
static inline Tensor & upsample_bicubic2d_out(Tensor & out, const Tensor & self, IntArrayRef output_size, bool align_corners);
static inline Tensor upsample_bicubic2d(const Tensor & self, IntArrayRef output_size, bool align_corners);
static inline Tensor & upsample_bicubic2d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners);
static inline Tensor upsample_bicubic2d_backward(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners);
static inline Tensor & upsample_trilinear3d_out(Tensor & out, const Tensor & self, IntArrayRef output_size, bool align_corners);
static inline Tensor upsample_trilinear3d(const Tensor & self, IntArrayRef output_size, bool align_corners);
static inline Tensor & upsample_trilinear3d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners);
static inline Tensor upsample_trilinear3d_backward(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners);
static inline Tensor & upsample_nearest1d_out(Tensor & out, const Tensor & self, IntArrayRef output_size);
static inline Tensor upsample_nearest1d(const Tensor & self, IntArrayRef output_size);
static inline Tensor & upsample_nearest1d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size);
static inline Tensor upsample_nearest1d_backward(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size);
static inline Tensor & upsample_nearest2d_out(Tensor & out, const Tensor & self, IntArrayRef output_size);
static inline Tensor upsample_nearest2d(const Tensor & self, IntArrayRef output_size);
static inline Tensor & upsample_nearest2d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size);
static inline Tensor upsample_nearest2d_backward(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size);
static inline Tensor & upsample_nearest3d_out(Tensor & out, const Tensor & self, IntArrayRef output_size);
static inline Tensor upsample_nearest3d(const Tensor & self, IntArrayRef output_size);
static inline Tensor & upsample_nearest3d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size);
static inline Tensor upsample_nearest3d_backward(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size);
static inline Tensor & sigmoid_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & output);
static inline Tensor sigmoid_backward(const Tensor & grad_output, const Tensor & output);
static inline Tensor & tanh_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & output);
static inline Tensor tanh_backward(const Tensor & grad_output, const Tensor & output);
static inline Tensor & conv_transpose2d_out(Tensor & out, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias={}, IntArrayRef stride=1, IntArrayRef padding=0, IntArrayRef output_padding=0, IntArrayRef dilation=1);
static inline Tensor conv_transpose2d(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias={}, IntArrayRef stride=1, IntArrayRef padding=0, IntArrayRef output_padding=0, IntArrayRef dilation=1);
static inline std::tuple<Tensor &,Tensor &,Tensor &> conv_transpose2d_backward_out(Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation, const Tensor & columns, const Tensor & ones);
static inline std::tuple<Tensor,Tensor,Tensor> conv_transpose2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation, const Tensor & columns, const Tensor & ones, std::array<bool,3> output_mask);
static inline Tensor & conv_transpose3d_out(Tensor & out, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias={}, IntArrayRef stride=1, IntArrayRef padding=0, IntArrayRef output_padding=0, IntArrayRef dilation=1);
static inline Tensor conv_transpose3d(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias={}, IntArrayRef stride=1, IntArrayRef padding=0, IntArrayRef output_padding=0, IntArrayRef dilation=1);
static inline std::tuple<Tensor &,Tensor &,Tensor &> conv_transpose3d_backward_out(Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation, const Tensor & finput, const Tensor & fgrad_input);
static inline std::tuple<Tensor,Tensor,Tensor> conv_transpose3d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation, const Tensor & finput, const Tensor & fgrad_input, std::array<bool,3> output_mask);
static inline Tensor & thnn_conv2d_out(Tensor & out, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias={}, IntArrayRef stride=1, IntArrayRef padding=0);
static inline Tensor thnn_conv2d(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias={}, IntArrayRef stride=1, IntArrayRef padding=0);
static inline std::tuple<Tensor &,Tensor &,Tensor &> thnn_conv2d_forward_out(Tensor & output, Tensor & finput, Tensor & fgrad_input, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding);
static inline std::tuple<Tensor,Tensor,Tensor> thnn_conv2d_forward(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding);
static inline std::tuple<Tensor &,Tensor &,Tensor &> thnn_conv2d_backward_out(Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, const Tensor & finput, const Tensor & fgrad_input);
static inline std::tuple<Tensor,Tensor,Tensor> thnn_conv2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, const Tensor & finput, const Tensor & fgrad_input, std::array<bool,3> output_mask);
static inline Tensor & thnn_conv_depthwise2d_out(Tensor & out, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias={}, IntArrayRef stride=1, IntArrayRef padding=0, IntArrayRef dilation=1);
static inline Tensor thnn_conv_depthwise2d(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias={}, IntArrayRef stride=1, IntArrayRef padding=0, IntArrayRef dilation=1);
static inline Tensor & thnn_conv_depthwise2d_forward_out(Tensor & out, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation);
static inline Tensor thnn_conv_depthwise2d_forward(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation);
static inline std::tuple<Tensor &,Tensor &> thnn_conv_depthwise2d_backward_out(Tensor & grad_input, Tensor & grad_weight, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation);
static inline std::tuple<Tensor,Tensor> thnn_conv_depthwise2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, std::array<bool,2> output_mask);
static inline Tensor & thnn_conv3d_out(Tensor & out, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias={}, IntArrayRef stride=1, IntArrayRef padding=0);
static inline Tensor thnn_conv3d(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias={}, IntArrayRef stride=1, IntArrayRef padding=0);
static inline std::tuple<Tensor &,Tensor &,Tensor &> thnn_conv3d_forward_out(Tensor & output, Tensor & finput, Tensor & fgrad_input, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding);
static inline std::tuple<Tensor,Tensor,Tensor> thnn_conv3d_forward(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding);
static inline std::tuple<Tensor &,Tensor &,Tensor &> thnn_conv3d_backward_out(Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, const Tensor & finput, const Tensor & fgrad_input);
static inline std::tuple<Tensor,Tensor,Tensor> thnn_conv3d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, const Tensor & finput, const Tensor & fgrad_input, std::array<bool,3> output_mask);
static inline Tensor conv_dilated2d(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias={}, IntArrayRef stride=1, IntArrayRef padding=0, IntArrayRef dilation=1);
static inline std::tuple<Tensor,Tensor,Tensor> conv_dilated2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, std::array<bool,3> output_mask);
static inline Tensor conv_dilated3d(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias={}, IntArrayRef stride=1, IntArrayRef padding=0, IntArrayRef dilation=1);
static inline std::tuple<Tensor,Tensor,Tensor> conv_dilated3d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, std::array<bool,3> output_mask);
static inline Tensor & col2im_out(Tensor & out, const Tensor & self, IntArrayRef output_size, IntArrayRef kernel_size, IntArrayRef dilation, IntArrayRef padding, IntArrayRef stride);
static inline Tensor col2im(const Tensor & self, IntArrayRef output_size, IntArrayRef kernel_size, IntArrayRef dilation, IntArrayRef padding, IntArrayRef stride);
static inline Tensor & col2im_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef kernel_size, IntArrayRef dilation, IntArrayRef padding, IntArrayRef stride);
static inline Tensor col2im_backward(const Tensor & grad_output, IntArrayRef kernel_size, IntArrayRef dilation, IntArrayRef padding, IntArrayRef stride);
static inline Tensor & im2col_out(Tensor & out, const Tensor & self, IntArrayRef kernel_size, IntArrayRef dilation, IntArrayRef padding, IntArrayRef stride);
static inline Tensor im2col(const Tensor & self, IntArrayRef kernel_size, IntArrayRef dilation, IntArrayRef padding, IntArrayRef stride);
static inline Tensor & im2col_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef input_size, IntArrayRef kernel_size, IntArrayRef dilation, IntArrayRef padding, IntArrayRef stride);
static inline Tensor im2col_backward(const Tensor & grad_output, IntArrayRef input_size, IntArrayRef kernel_size, IntArrayRef dilation, IntArrayRef padding, IntArrayRef stride);

inline Tensor from_blob(
    void* data,
    IntArrayRef sizes,
    IntArrayRef strides,
    const std::function<void(void*)>& deleter,
    const TensorOptions& options = {}) {
  auto device = globalContext().getDeviceFromPtr(data, options.device().type());
  if (options.device().has_index()) {
    TORCH_CHECK(
        options.device() == device,
        "Specified device ", options.device(),
        " does not match device of data ", device);
  }
  auto storage = Storage(
      options.dtype(),
      detail::computeStorageSize(sizes, strides),
      InefficientStdFunctionContext::makeDataPtr(
          data, deleter, device),
      /*allocator=*/nullptr,
      /*resizable=*/false);
  return empty({0}, options).set_(storage, 0, sizes, strides);
}

inline Tensor from_blob(
    void* data,
    IntArrayRef sizes,
    const std::function<void(void*)>& deleter,
    const TensorOptions& options = {}) {
  return from_blob(data, sizes, detail::defaultStrides(sizes), deleter, options);
}

inline Tensor from_blob(
    void* data,
    IntArrayRef sizes,
    IntArrayRef strides,
    const TensorOptions& options = {}) {
  return from_blob(data, sizes, strides, [](void*) {}, options);
}

inline Tensor from_blob(
    void* data,
    IntArrayRef sizes,
    const TensorOptions& options = {}) {
  return from_blob(data, sizes, detail::defaultStrides(sizes), [](void*) {}, options);
}

namespace detail {

static inline Backend infer_backend(const Tensor & t) {
  TORCH_CHECK(t.defined(), "undefined Tensor");
  return tensorTypeIdToBackend(t.type_id());
}
static inline Backend infer_backend(const TensorList & tl) {
  TORCH_CHECK(tl.size() > 0, "expected a non-empty list of Tensors");
  return tensorTypeIdToBackend(tl[0].type_id());
}

static inline bool infer_is_variable(const Tensor & t) {
  TORCH_CHECK(t.defined(), "undefined Tensor");
  return t.is_variable();
}
static inline bool infer_is_variable(const TensorList & tl) {
  TORCH_CHECK(tl.size() > 0, "expected a non-empty list of Tensors");
  return tl[0].is_variable();
}


} // namespace detail

// function definitions are all static inline because
// they are one-line statically dispatched functions that
// invoke the actual dynamic dispatch on the correct argument
static inline Tensor _cast_Byte(const Tensor & self, bool non_blocking) {
    static auto table = globalATenDispatch().getOpTable("aten::_cast_Byte(Tensor self, bool non_blocking=False) -> Tensor");
    return table->getOp<Tensor (const Tensor &, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, non_blocking);
}
static inline Tensor _cast_Char(const Tensor & self, bool non_blocking) {
    static auto table = globalATenDispatch().getOpTable("aten::_cast_Char(Tensor self, bool non_blocking=False) -> Tensor");
    return table->getOp<Tensor (const Tensor &, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, non_blocking);
}
static inline Tensor _cast_Double(const Tensor & self, bool non_blocking) {
    static auto table = globalATenDispatch().getOpTable("aten::_cast_Double(Tensor self, bool non_blocking=False) -> Tensor");
    return table->getOp<Tensor (const Tensor &, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, non_blocking);
}
static inline Tensor _cast_Float(const Tensor & self, bool non_blocking) {
    static auto table = globalATenDispatch().getOpTable("aten::_cast_Float(Tensor self, bool non_blocking=False) -> Tensor");
    return table->getOp<Tensor (const Tensor &, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, non_blocking);
}
static inline Tensor _cast_Int(const Tensor & self, bool non_blocking) {
    static auto table = globalATenDispatch().getOpTable("aten::_cast_Int(Tensor self, bool non_blocking=False) -> Tensor");
    return table->getOp<Tensor (const Tensor &, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, non_blocking);
}
static inline Tensor _cast_Long(const Tensor & self, bool non_blocking) {
    static auto table = globalATenDispatch().getOpTable("aten::_cast_Long(Tensor self, bool non_blocking=False) -> Tensor");
    return table->getOp<Tensor (const Tensor &, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, non_blocking);
}
static inline Tensor _cast_Short(const Tensor & self, bool non_blocking) {
    static auto table = globalATenDispatch().getOpTable("aten::_cast_Short(Tensor self, bool non_blocking=False) -> Tensor");
    return table->getOp<Tensor (const Tensor &, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, non_blocking);
}
static inline Tensor _cast_Half(const Tensor & self, bool non_blocking) {
    static auto table = globalATenDispatch().getOpTable("aten::_cast_Half(Tensor self, bool non_blocking=False) -> Tensor");
    return table->getOp<Tensor (const Tensor &, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, non_blocking);
}
static inline std::tuple<Tensor,Tensor> _cudnn_ctc_loss(const Tensor & log_probs, const Tensor & targets, IntArrayRef input_lengths, IntArrayRef target_lengths, int64_t blank, bool deterministic, bool zero_infinity) {
    static auto table = globalATenDispatch().getOpTable("aten::_cudnn_ctc_loss(Tensor log_probs, Tensor targets, int[] input_lengths, int[] target_lengths, int blank, bool deterministic, bool zero_infinity) -> (Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor> (const Tensor &, const Tensor &, IntArrayRef, IntArrayRef, int64_t, bool, bool)>(at::detail::infer_backend(log_probs), at::detail::infer_is_variable(log_probs))(log_probs, targets, input_lengths, target_lengths, blank, deterministic, zero_infinity);
}
static inline Tensor _cudnn_rnn_flatten_weight(TensorList weight_arr, int64_t weight_stride0, int64_t input_size, int64_t mode, int64_t hidden_size, int64_t num_layers, bool batch_first, bool bidirectional) {
    static auto table = globalATenDispatch().getOpTable("aten::_cudnn_rnn_flatten_weight(Tensor[] weight_arr, int weight_stride0, int input_size, int mode, int hidden_size, int num_layers, bool batch_first, bool bidirectional) -> Tensor");
    return table->getOp<Tensor (TensorList, int64_t, int64_t, int64_t, int64_t, int64_t, bool, bool)>(at::detail::infer_backend(weight_arr), at::detail::infer_is_variable(weight_arr))(weight_arr, weight_stride0, input_size, mode, hidden_size, num_layers, batch_first, bidirectional);
}
static inline std::tuple<Tensor,Tensor,Tensor,Tensor,Tensor> _cudnn_rnn(const Tensor & input, TensorList weight, int64_t weight_stride0, const Tensor & weight_buf, const Tensor & hx, const Tensor & cx, int64_t mode, int64_t hidden_size, int64_t num_layers, bool batch_first, double dropout, bool train, bool bidirectional, IntArrayRef batch_sizes, const Tensor & dropout_state) {
    static auto table = globalATenDispatch().getOpTable("aten::_cudnn_rnn(Tensor input, Tensor[] weight, int weight_stride0, Tensor? weight_buf, Tensor hx, Tensor? cx, int mode, int hidden_size, int num_layers, bool batch_first, float dropout, bool train, bool bidirectional, int[] batch_sizes, Tensor? dropout_state) -> (Tensor, Tensor, Tensor, Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor,Tensor,Tensor,Tensor> (const Tensor &, TensorList, int64_t, const Tensor &, const Tensor &, const Tensor &, int64_t, int64_t, int64_t, bool, double, bool, bool, IntArrayRef, const Tensor &)>(at::detail::infer_backend(input), at::detail::infer_is_variable(input))(input, weight, weight_stride0, weight_buf, hx, cx, mode, hidden_size, num_layers, batch_first, dropout, train, bidirectional, batch_sizes, dropout_state);
}
static inline std::tuple<Tensor,Tensor,Tensor,std::vector<Tensor>> _cudnn_rnn_backward(const Tensor & input, TensorList weight, int64_t weight_stride0, const Tensor & weight_buf, const Tensor & hx, const Tensor & cx, const Tensor & output, const Tensor & grad_output, const Tensor & grad_hy, const Tensor & grad_cy, int64_t mode, int64_t hidden_size, int64_t num_layers, bool batch_first, double dropout, bool train, bool bidirectional, IntArrayRef batch_sizes, const Tensor & dropout_state, const Tensor & reserve, std::array<bool,4> output_mask) {
    static auto table = globalATenDispatch().getOpTable("aten::_cudnn_rnn_backward(Tensor input, Tensor[] weight, int weight_stride0, Tensor weight_buf, Tensor hx, Tensor? cx, Tensor output, Tensor? grad_output, Tensor? grad_hy, Tensor? grad_cy, int mode, int hidden_size, int num_layers, bool batch_first, float dropout, bool train, bool bidirectional, int[] batch_sizes, Tensor? dropout_state, Tensor reserve, bool[4] output_mask) -> (Tensor, Tensor, Tensor, Tensor[])");
    return table->getOp<std::tuple<Tensor,Tensor,Tensor,std::vector<Tensor>> (const Tensor &, TensorList, int64_t, const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, int64_t, int64_t, int64_t, bool, double, bool, bool, IntArrayRef, const Tensor &, const Tensor &, std::array<bool,4>)>(at::detail::infer_backend(input), at::detail::infer_is_variable(input))(input, weight, weight_stride0, weight_buf, hx, cx, output, grad_output, grad_hy, grad_cy, mode, hidden_size, num_layers, batch_first, dropout, train, bidirectional, batch_sizes, dropout_state, reserve, output_mask);
}
static inline Tensor _cudnn_init_dropout_state(double dropout, bool train, int64_t dropout_seed, const TensorOptions & options) {
    globalLegacyTypeDispatch().initForBackend(options.backend());
    static auto table = globalATenDispatch().getOpTable("aten::_cudnn_init_dropout_state(float dropout, bool train, int dropout_seed, *, ScalarType dtype, Layout layout, Device device, bool pin_memory=False) -> Tensor");
    return table->getOp<Tensor (double, bool, int64_t, const TensorOptions &)>(options.backend(), options.is_variable())(dropout, train, dropout_seed, options);
}
static inline int64_t _debug_has_internal_overlap(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::_debug_has_internal_overlap(Tensor self) -> int");
    return table->getOp<int64_t (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline std::tuple<Tensor,Tensor> _fused_dropout(const Tensor & self, double p, Generator * generator) {
    static auto table = globalATenDispatch().getOpTable("aten::_fused_dropout(Tensor self, float p, Generator? generator=None) -> (Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor> (const Tensor &, double, Generator *)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, p, generator);
}
static inline Tensor _masked_scale(const Tensor & self, const Tensor & mask, double scale) {
    static auto table = globalATenDispatch().getOpTable("aten::_masked_scale(Tensor self, Tensor mask, float scale) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, double)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, mask, scale);
}
static inline std::tuple<Tensor,Tensor> _sobol_engine_draw(const Tensor & quasi, int64_t n, const Tensor & sobolstate, int64_t dimension, int64_t num_generated, c10::optional<ScalarType> dtype) {
    static auto table = globalATenDispatch().getOpTable("aten::_sobol_engine_draw(Tensor quasi, int n, Tensor sobolstate, int dimension, int num_generated, ScalarType? dtype) -> (Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor> (const Tensor &, int64_t, const Tensor &, int64_t, int64_t, c10::optional<ScalarType>)>(at::detail::infer_backend(quasi), at::detail::infer_is_variable(quasi))(quasi, n, sobolstate, dimension, num_generated, dtype);
}
static inline Tensor & _sobol_engine_ff_(Tensor & self, int64_t n, const Tensor & sobolstate, int64_t dimension, int64_t num_generated) {
    static auto table = globalATenDispatch().getOpTable("aten::_sobol_engine_ff_(Tensor(a!) self, int n, Tensor sobolstate, int dimension, int num_generated) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, int64_t, const Tensor &, int64_t, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, n, sobolstate, dimension, num_generated);
}
static inline Tensor & _sobol_engine_scramble_(Tensor & self, const Tensor & ltm, int64_t dimension) {
    static auto table = globalATenDispatch().getOpTable("aten::_sobol_engine_scramble_(Tensor(a!) self, Tensor ltm, int dimension) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, ltm, dimension);
}
static inline Tensor & _sobol_engine_initialize_state_(Tensor & self, int64_t dimension) {
    static auto table = globalATenDispatch().getOpTable("aten::_sobol_engine_initialize_state_(Tensor(a!) self, int dimension) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dimension);
}
static inline Tensor _reshape_from_tensor(const Tensor & self, const Tensor & shape) {
    static auto table = globalATenDispatch().getOpTable("aten::_reshape_from_tensor(Tensor self, Tensor shape) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, shape);
}
static inline Tensor _shape_as_tensor(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::_shape_as_tensor(Tensor self) -> Tensor");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor dropout(const Tensor & input, double p, bool train) {
    static auto table = globalATenDispatch().getOpTable("aten::dropout(Tensor input, float p, bool train) -> Tensor");
    return table->getOp<Tensor (const Tensor &, double, bool)>(at::detail::infer_backend(input), at::detail::infer_is_variable(input))(input, p, train);
}
static inline Tensor & dropout_(Tensor & self, double p, bool train) {
    static auto table = globalATenDispatch().getOpTable("aten::dropout_(Tensor(a!) self, float p, bool train) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, double, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, p, train);
}
static inline Tensor feature_dropout(const Tensor & input, double p, bool train) {
    static auto table = globalATenDispatch().getOpTable("aten::feature_dropout(Tensor input, float p, bool train) -> Tensor");
    return table->getOp<Tensor (const Tensor &, double, bool)>(at::detail::infer_backend(input), at::detail::infer_is_variable(input))(input, p, train);
}
static inline Tensor & feature_dropout_(Tensor & self, double p, bool train) {
    static auto table = globalATenDispatch().getOpTable("aten::feature_dropout_(Tensor(a!) self, float p, bool train) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, double, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, p, train);
}
static inline Tensor alpha_dropout(const Tensor & input, double p, bool train) {
    static auto table = globalATenDispatch().getOpTable("aten::alpha_dropout(Tensor input, float p, bool train) -> Tensor");
    return table->getOp<Tensor (const Tensor &, double, bool)>(at::detail::infer_backend(input), at::detail::infer_is_variable(input))(input, p, train);
}
static inline Tensor & alpha_dropout_(Tensor & self, double p, bool train) {
    static auto table = globalATenDispatch().getOpTable("aten::alpha_dropout_(Tensor(a!) self, float p, bool train) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, double, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, p, train);
}
static inline Tensor feature_alpha_dropout(const Tensor & input, double p, bool train) {
    static auto table = globalATenDispatch().getOpTable("aten::feature_alpha_dropout(Tensor input, float p, bool train) -> Tensor");
    return table->getOp<Tensor (const Tensor &, double, bool)>(at::detail::infer_backend(input), at::detail::infer_is_variable(input))(input, p, train);
}
static inline Tensor & feature_alpha_dropout_(Tensor & self, double p, bool train) {
    static auto table = globalATenDispatch().getOpTable("aten::feature_alpha_dropout_(Tensor(a!) self, float p, bool train) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, double, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, p, train);
}
static inline Tensor abs(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::abs(Tensor self) -> Tensor");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & abs_(Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::abs_(Tensor(a!) self) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & abs_out(Tensor & out, const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::abs(Tensor self, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self);
}
static inline Tensor acos(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::acos(Tensor self) -> Tensor");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & acos_(Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::acos_(Tensor(a!) self) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & acos_out(Tensor & out, const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::acos(Tensor self, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self);
}
static inline Tensor avg_pool1d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad) {
    static auto table = globalATenDispatch().getOpTable("aten::avg_pool1d(Tensor self, int[1] kernel_size, int[1] stride=[], int[1] padding=0, bool ceil_mode=False, bool count_include_pad=True) -> Tensor");
    return table->getOp<Tensor (const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, bool, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, kernel_size, stride, padding, ceil_mode, count_include_pad);
}
static inline Tensor adaptive_avg_pool1d(const Tensor & self, IntArrayRef output_size) {
    static auto table = globalATenDispatch().getOpTable("aten::adaptive_avg_pool1d(Tensor self, int[1] output_size) -> Tensor");
    return table->getOp<Tensor (const Tensor &, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, output_size);
}
static inline std::tuple<Tensor,Tensor> adaptive_max_pool1d(const Tensor & self, IntArrayRef output_size) {
    static auto table = globalATenDispatch().getOpTable("aten::adaptive_max_pool1d(Tensor self, int[1] output_size) -> (Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor> (const Tensor &, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, output_size);
}
static inline Tensor add(const Tensor & self, const Tensor & other, Scalar alpha) {
    static auto table = globalATenDispatch().getOpTable("aten::add(Tensor self, Tensor other, *, Scalar alpha=1) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, other, alpha);
}
static inline Tensor & add_out(Tensor & out, const Tensor & self, const Tensor & other, Scalar alpha) {
    static auto table = globalATenDispatch().getOpTable("aten::add(Tensor self, Tensor other, *, Scalar alpha=1, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, other, alpha);
}
static inline Tensor add(const Tensor & self, Scalar other, Scalar alpha) {
    static auto table = globalATenDispatch().getOpTable("aten::add(Tensor self, Scalar other, Scalar alpha=1) -> Tensor");
    return table->getOp<Tensor (const Tensor &, Scalar, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, other, alpha);
}
static inline Tensor addmv(const Tensor & self, const Tensor & mat, const Tensor & vec, Scalar beta, Scalar alpha) {
    static auto table = globalATenDispatch().getOpTable("aten::addmv(Tensor self, Tensor mat, Tensor vec, *, Scalar beta=1, Scalar alpha=1) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, Scalar, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, mat, vec, beta, alpha);
}
static inline Tensor & addmv_(Tensor & self, const Tensor & mat, const Tensor & vec, Scalar beta, Scalar alpha) {
    static auto table = globalATenDispatch().getOpTable("aten::addmv_(Tensor(a!) self, Tensor mat, Tensor vec, *, Scalar beta=1, Scalar alpha=1) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, Scalar, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, mat, vec, beta, alpha);
}
static inline Tensor & addmv_out(Tensor & out, const Tensor & self, const Tensor & mat, const Tensor & vec, Scalar beta, Scalar alpha) {
    static auto table = globalATenDispatch().getOpTable("aten::addmv(Tensor self, Tensor mat, Tensor vec, *, Scalar beta=1, Scalar alpha=1, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, const Tensor &, Scalar, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, mat, vec, beta, alpha);
}
static inline Tensor addr(const Tensor & self, const Tensor & vec1, const Tensor & vec2, Scalar beta, Scalar alpha) {
    static auto table = globalATenDispatch().getOpTable("aten::addr(Tensor self, Tensor vec1, Tensor vec2, *, Scalar beta=1, Scalar alpha=1) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, Scalar, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, vec1, vec2, beta, alpha);
}
static inline Tensor & addr_out(Tensor & out, const Tensor & self, const Tensor & vec1, const Tensor & vec2, Scalar beta, Scalar alpha) {
    static auto table = globalATenDispatch().getOpTable("aten::addr(Tensor self, Tensor vec1, Tensor vec2, *, Scalar beta=1, Scalar alpha=1, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, const Tensor &, Scalar, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, vec1, vec2, beta, alpha);
}
static inline Tensor affine_grid_generator(const Tensor & theta, IntArrayRef size) {
    static auto table = globalATenDispatch().getOpTable("aten::affine_grid_generator(Tensor theta, int[] size) -> Tensor");
    return table->getOp<Tensor (const Tensor &, IntArrayRef)>(at::detail::infer_backend(theta), at::detail::infer_is_variable(theta))(theta, size);
}
static inline Tensor affine_grid_generator_backward(const Tensor & grad, IntArrayRef size) {
    static auto table = globalATenDispatch().getOpTable("aten::affine_grid_generator_backward(Tensor grad, int[] size) -> Tensor");
    return table->getOp<Tensor (const Tensor &, IntArrayRef)>(at::detail::infer_backend(grad), at::detail::infer_is_variable(grad))(grad, size);
}
static inline Tensor all(const Tensor & self, int64_t dim, bool keepdim) {
    static auto table = globalATenDispatch().getOpTable("aten::all(Tensor self, int dim, bool keepdim=False) -> Tensor");
    return table->getOp<Tensor (const Tensor &, int64_t, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dim, keepdim);
}
static inline Tensor & all_out(Tensor & out, const Tensor & self, int64_t dim, bool keepdim) {
    static auto table = globalATenDispatch().getOpTable("aten::all(Tensor self, int dim, bool keepdim=False, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, int64_t, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, dim, keepdim);
}
static inline bool allclose(const Tensor & self, const Tensor & other, double rtol, double atol, bool equal_nan) {
    static auto table = globalATenDispatch().getOpTable("aten::allclose(Tensor self, Tensor other, float rtol=1e-05, float atol=1e-08, bool equal_nan=False) -> bool");
    return table->getOp<bool (const Tensor &, const Tensor &, double, double, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, other, rtol, atol, equal_nan);
}
static inline Tensor any(const Tensor & self, int64_t dim, bool keepdim) {
    static auto table = globalATenDispatch().getOpTable("aten::any(Tensor self, int dim, bool keepdim=False) -> Tensor");
    return table->getOp<Tensor (const Tensor &, int64_t, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dim, keepdim);
}
static inline Tensor & any_out(Tensor & out, const Tensor & self, int64_t dim, bool keepdim) {
    static auto table = globalATenDispatch().getOpTable("aten::any(Tensor self, int dim, bool keepdim=False, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, int64_t, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, dim, keepdim);
}
static inline Tensor arange(Scalar end, const TensorOptions & options) {
    globalLegacyTypeDispatch().initForBackend(options.backend());
    static auto table = globalATenDispatch().getOpTable("aten::arange(Scalar end, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor");
    return table->getOp<Tensor (Scalar, const TensorOptions &)>(options.backend(), options.is_variable())(end, options);
}
static inline Tensor arange(Scalar start, Scalar end, const TensorOptions & options) {
    globalLegacyTypeDispatch().initForBackend(options.backend());
    static auto table = globalATenDispatch().getOpTable("aten::arange(Scalar start, Scalar end, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor");
    return table->getOp<Tensor (Scalar, Scalar, const TensorOptions &)>(options.backend(), options.is_variable())(start, end, options);
}
static inline Tensor arange(Scalar start, Scalar end, Scalar step, const TensorOptions & options) {
    globalLegacyTypeDispatch().initForBackend(options.backend());
    static auto table = globalATenDispatch().getOpTable("aten::arange(Scalar start, Scalar end, Scalar step, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor");
    return table->getOp<Tensor (Scalar, Scalar, Scalar, const TensorOptions &)>(options.backend(), options.is_variable())(start, end, step, options);
}
static inline Tensor & arange_out(Tensor & out, Scalar end) {
    static auto table = globalATenDispatch().getOpTable("aten::arange(Scalar end, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, Scalar)>(at::detail::infer_backend(out), at::detail::infer_is_variable(out))(out, end);
}
static inline Tensor & arange_out(Tensor & out, Scalar start, Scalar end, Scalar step) {
    static auto table = globalATenDispatch().getOpTable("aten::arange(Scalar start, Scalar end, Scalar step=1, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, Scalar, Scalar, Scalar)>(at::detail::infer_backend(out), at::detail::infer_is_variable(out))(out, start, end, step);
}
static inline Tensor _dim_arange(const Tensor & like, int64_t dim) {
    static auto table = globalATenDispatch().getOpTable("aten::_dim_arange(Tensor like, int dim) -> Tensor");
    return table->getOp<Tensor (const Tensor &, int64_t)>(at::detail::infer_backend(like), at::detail::infer_is_variable(like))(like, dim);
}
static inline Tensor argmax(const Tensor & self, c10::optional<int64_t> dim, bool keepdim) {
    static auto table = globalATenDispatch().getOpTable("aten::argmax(Tensor self, int? dim=None, bool keepdim=False) -> Tensor");
    return table->getOp<Tensor (const Tensor &, c10::optional<int64_t>, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dim, keepdim);
}
static inline Tensor argmin(const Tensor & self, c10::optional<int64_t> dim, bool keepdim) {
    static auto table = globalATenDispatch().getOpTable("aten::argmin(Tensor self, int? dim=None, bool keepdim=False) -> Tensor");
    return table->getOp<Tensor (const Tensor &, c10::optional<int64_t>, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dim, keepdim);
}
static inline Tensor as_strided(const Tensor & self, IntArrayRef size, IntArrayRef stride, c10::optional<int64_t> storage_offset) {
    static auto table = globalATenDispatch().getOpTable("aten::as_strided(Tensor(a) self, int[] size, int[] stride, int? storage_offset=None) -> Tensor(a)");
    return table->getOp<Tensor (const Tensor &, IntArrayRef, IntArrayRef, c10::optional<int64_t>)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, size, stride, storage_offset);
}
static inline Tensor & as_strided_(Tensor & self, IntArrayRef size, IntArrayRef stride, c10::optional<int64_t> storage_offset) {
    static auto table = globalATenDispatch().getOpTable("aten::as_strided_(Tensor(a!) self, int[] size, int[] stride, int? storage_offset=None) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, IntArrayRef, IntArrayRef, c10::optional<int64_t>)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, size, stride, storage_offset);
}
static inline Tensor asin(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::asin(Tensor self) -> Tensor");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & asin_(Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::asin_(Tensor(a!) self) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & asin_out(Tensor & out, const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::asin(Tensor self, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self);
}
static inline Tensor atan(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::atan(Tensor self) -> Tensor");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & atan_(Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::atan_(Tensor(a!) self) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & atan_out(Tensor & out, const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::atan(Tensor self, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self);
}
static inline Tensor baddbmm(const Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta, Scalar alpha) {
    static auto table = globalATenDispatch().getOpTable("aten::baddbmm(Tensor self, Tensor batch1, Tensor batch2, *, Scalar beta=1, Scalar alpha=1) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, Scalar, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, batch1, batch2, beta, alpha);
}
static inline Tensor & _baddbmm_mkl_(Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta, Scalar alpha) {
    static auto table = globalATenDispatch().getOpTable("aten::_baddbmm_mkl_(Tensor(a!) self, Tensor batch1, Tensor batch2, *, Scalar beta=1, Scalar alpha=1) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, Scalar, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, batch1, batch2, beta, alpha);
}
static inline Tensor & baddbmm_out(Tensor & out, const Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta, Scalar alpha) {
    static auto table = globalATenDispatch().getOpTable("aten::baddbmm(Tensor self, Tensor batch1, Tensor batch2, *, Scalar beta=1, Scalar alpha=1, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, const Tensor &, Scalar, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, batch1, batch2, beta, alpha);
}
static inline Tensor bartlett_window(int64_t window_length, const TensorOptions & options) {
    globalLegacyTypeDispatch().initForBackend(options.backend());
    static auto table = globalATenDispatch().getOpTable("aten::bartlett_window(int window_length, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor");
    return table->getOp<Tensor (int64_t, const TensorOptions &)>(options.backend(), options.is_variable())(window_length, options);
}
static inline Tensor bartlett_window(int64_t window_length, bool periodic, const TensorOptions & options) {
    globalLegacyTypeDispatch().initForBackend(options.backend());
    static auto table = globalATenDispatch().getOpTable("aten::bartlett_window(int window_length, bool periodic, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor");
    return table->getOp<Tensor (int64_t, bool, const TensorOptions &)>(options.backend(), options.is_variable())(window_length, periodic, options);
}
static inline Tensor batch_norm(const Tensor & input, const Tensor & weight, const Tensor & bias, const Tensor & running_mean, const Tensor & running_var, bool training, double momentum, double eps, bool cudnn_enabled) {
    static auto table = globalATenDispatch().getOpTable("aten::batch_norm(Tensor input, Tensor? weight, Tensor? bias, Tensor? running_mean, Tensor? running_var, bool training, float momentum, float eps, bool cudnn_enabled) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, bool, double, double, bool)>(at::detail::infer_backend(input), at::detail::infer_is_variable(input))(input, weight, bias, running_mean, running_var, training, momentum, eps, cudnn_enabled);
}
static inline std::tuple<Tensor,Tensor,Tensor,int64_t> _batch_norm_impl_index(const Tensor & input, const Tensor & weight, const Tensor & bias, const Tensor & running_mean, const Tensor & running_var, bool training, double momentum, double eps, bool cudnn_enabled) {
    static auto table = globalATenDispatch().getOpTable("aten::_batch_norm_impl_index(Tensor input, Tensor? weight, Tensor? bias, Tensor? running_mean, Tensor? running_var, bool training, float momentum, float eps, bool cudnn_enabled) -> (Tensor, Tensor, Tensor, int)");
    return table->getOp<std::tuple<Tensor,Tensor,Tensor,int64_t> (const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, bool, double, double, bool)>(at::detail::infer_backend(input), at::detail::infer_is_variable(input))(input, weight, bias, running_mean, running_var, training, momentum, eps, cudnn_enabled);
}
static inline std::tuple<Tensor,Tensor,Tensor> _batch_norm_impl_index_backward(int64_t impl_index, const Tensor & input, const Tensor & grad_output, const Tensor & weight, const Tensor & running_mean, const Tensor & running_var, const Tensor & save_mean, const Tensor & save_var_transform, bool train, double eps, std::array<bool,3> output_mask) {
    static auto table = globalATenDispatch().getOpTable("aten::_batch_norm_impl_index_backward(int impl_index, Tensor input, Tensor grad_output, Tensor? weight, Tensor? running_mean, Tensor? running_var, Tensor? save_mean, Tensor? save_var_transform, bool train, float eps, bool[3] output_mask) -> (Tensor, Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor,Tensor> (int64_t, const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, bool, double, std::array<bool,3>)>(at::detail::infer_backend(input), at::detail::infer_is_variable(input))(impl_index, input, grad_output, weight, running_mean, running_var, save_mean, save_var_transform, train, eps, output_mask);
}
static inline Tensor bernoulli(const Tensor & self, Generator * generator) {
    static auto table = globalATenDispatch().getOpTable("aten::bernoulli(Tensor self, *, Generator? generator=None) -> Tensor");
    return table->getOp<Tensor (const Tensor &, Generator *)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, generator);
}
static inline Tensor & bernoulli_out(Tensor & out, const Tensor & self, Generator * generator) {
    static auto table = globalATenDispatch().getOpTable("aten::bernoulli(Tensor self, *, Generator? generator=None, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, Generator *)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, generator);
}
static inline Tensor bernoulli(const Tensor & self, double p, Generator * generator) {
    static auto table = globalATenDispatch().getOpTable("aten::bernoulli(Tensor self, float p, *, Generator? generator=None) -> Tensor");
    return table->getOp<Tensor (const Tensor &, double, Generator *)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, p, generator);
}
static inline Tensor bilinear(const Tensor & input1, const Tensor & input2, const Tensor & weight, const Tensor & bias) {
    static auto table = globalATenDispatch().getOpTable("aten::bilinear(Tensor input1, Tensor input2, Tensor weight, Tensor? bias) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, const Tensor &)>(at::detail::infer_backend(input1), at::detail::infer_is_variable(input1))(input1, input2, weight, bias);
}
static inline Tensor binary_cross_entropy_with_logits(const Tensor & self, const Tensor & target, const Tensor & weight, const Tensor & pos_weight, int64_t reduction) {
    static auto table = globalATenDispatch().getOpTable("aten::binary_cross_entropy_with_logits(Tensor self, Tensor target, Tensor? weight=None, Tensor? pos_weight=None, int reduction=Mean) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, const Tensor &, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, target, weight, pos_weight, reduction);
}
static inline Tensor binary_cross_entropy_with_logits_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight, const Tensor & pos_weight, int64_t reduction) {
    static auto table = globalATenDispatch().getOpTable("aten::binary_cross_entropy_with_logits_backward(Tensor grad_output, Tensor self, Tensor target, Tensor? weight=None, Tensor? pos_weight=None, int reduction=Mean) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_output, self, target, weight, pos_weight, reduction);
}
static inline Tensor bincount(const Tensor & self, const Tensor & weights, int64_t minlength) {
    static auto table = globalATenDispatch().getOpTable("aten::bincount(Tensor self, Tensor? weights=None, int minlength=0) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, weights, minlength);
}
static inline Tensor bitwise_not(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::bitwise_not(Tensor self) -> Tensor");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & bitwise_not_out(Tensor & out, const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::bitwise_not(Tensor self, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self);
}
static inline Tensor blackman_window(int64_t window_length, const TensorOptions & options) {
    globalLegacyTypeDispatch().initForBackend(options.backend());
    static auto table = globalATenDispatch().getOpTable("aten::blackman_window(int window_length, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor");
    return table->getOp<Tensor (int64_t, const TensorOptions &)>(options.backend(), options.is_variable())(window_length, options);
}
static inline Tensor blackman_window(int64_t window_length, bool periodic, const TensorOptions & options) {
    globalLegacyTypeDispatch().initForBackend(options.backend());
    static auto table = globalATenDispatch().getOpTable("aten::blackman_window(int window_length, bool periodic, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor");
    return table->getOp<Tensor (int64_t, bool, const TensorOptions &)>(options.backend(), options.is_variable())(window_length, periodic, options);
}
static inline Tensor bmm(const Tensor & self, const Tensor & mat2) {
    static auto table = globalATenDispatch().getOpTable("aten::bmm(Tensor self, Tensor mat2) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, mat2);
}
static inline Tensor & bmm_out(Tensor & out, const Tensor & self, const Tensor & mat2) {
    static auto table = globalATenDispatch().getOpTable("aten::bmm(Tensor self, Tensor mat2, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, mat2);
}
static inline std::vector<Tensor> broadcast_tensors(TensorList tensors) {
    static auto table = globalATenDispatch().getOpTable("aten::broadcast_tensors(Tensor[] tensors) -> Tensor[]");
    return table->getOp<std::vector<Tensor> (TensorList)>(at::detail::infer_backend(tensors), at::detail::infer_is_variable(tensors))(tensors);
}
static inline Tensor cat(TensorList tensors, int64_t dim) {
    static auto table = globalATenDispatch().getOpTable("aten::cat(Tensor[] tensors, int dim=0) -> Tensor");
    return table->getOp<Tensor (TensorList, int64_t)>(at::detail::infer_backend(tensors), at::detail::infer_is_variable(tensors))(tensors, dim);
}
static inline Tensor & cat_out(Tensor & out, TensorList tensors, int64_t dim) {
    static auto table = globalATenDispatch().getOpTable("aten::cat(Tensor[] tensors, int dim=0, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, TensorList, int64_t)>(at::detail::infer_backend(out), at::detail::infer_is_variable(out))(out, tensors, dim);
}
static inline Tensor ceil(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::ceil(Tensor self) -> Tensor");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & ceil_(Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::ceil_(Tensor(a!) self) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & ceil_out(Tensor & out, const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::ceil(Tensor self, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self);
}
static inline Tensor chain_matmul(TensorList matrices) {
    static auto table = globalATenDispatch().getOpTable("aten::chain_matmul(Tensor[] matrices) -> Tensor");
    return table->getOp<Tensor (TensorList)>(at::detail::infer_backend(matrices), at::detail::infer_is_variable(matrices))(matrices);
}
static inline std::vector<Tensor> chunk(const Tensor & self, int64_t chunks, int64_t dim) {
    static auto table = globalATenDispatch().getOpTable("aten::chunk(Tensor(a) self, int chunks, int dim=0) -> Tensor(a)[]");
    return table->getOp<std::vector<Tensor> (const Tensor &, int64_t, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, chunks, dim);
}
static inline Tensor clamp(const Tensor & self, c10::optional<Scalar> min, c10::optional<Scalar> max) {
    static auto table = globalATenDispatch().getOpTable("aten::clamp(Tensor self, Scalar? min=None, Scalar? max=None) -> Tensor");
    return table->getOp<Tensor (const Tensor &, c10::optional<Scalar>, c10::optional<Scalar>)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, min, max);
}
static inline Tensor & clamp_(Tensor & self, c10::optional<Scalar> min, c10::optional<Scalar> max) {
    static auto table = globalATenDispatch().getOpTable("aten::clamp_(Tensor(a!) self, Scalar? min=None, Scalar? max=None) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, c10::optional<Scalar>, c10::optional<Scalar>)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, min, max);
}
static inline Tensor & clamp_out(Tensor & out, const Tensor & self, c10::optional<Scalar> min, c10::optional<Scalar> max) {
    static auto table = globalATenDispatch().getOpTable("aten::clamp(Tensor self, Scalar? min=None, Scalar? max=None, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, c10::optional<Scalar>, c10::optional<Scalar>)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, min, max);
}
static inline Tensor clamp_max(const Tensor & self, Scalar max) {
    static auto table = globalATenDispatch().getOpTable("aten::clamp_max(Tensor self, Scalar max) -> Tensor");
    return table->getOp<Tensor (const Tensor &, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, max);
}
static inline Tensor & clamp_max_(Tensor & self, Scalar max) {
    static auto table = globalATenDispatch().getOpTable("aten::clamp_max_(Tensor(a!) self, Scalar max) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, max);
}
static inline Tensor & clamp_max_out(Tensor & out, const Tensor & self, Scalar max) {
    static auto table = globalATenDispatch().getOpTable("aten::clamp_max(Tensor self, Scalar max, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, max);
}
static inline Tensor clamp_min(const Tensor & self, Scalar min) {
    static auto table = globalATenDispatch().getOpTable("aten::clamp_min(Tensor self, Scalar min) -> Tensor");
    return table->getOp<Tensor (const Tensor &, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, min);
}
static inline Tensor & clamp_min_(Tensor & self, Scalar min) {
    static auto table = globalATenDispatch().getOpTable("aten::clamp_min_(Tensor(a!) self, Scalar min) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, min);
}
static inline Tensor & clamp_min_out(Tensor & out, const Tensor & self, Scalar min) {
    static auto table = globalATenDispatch().getOpTable("aten::clamp_min(Tensor self, Scalar min, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, min);
}
static inline bool cudnn_is_acceptable(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::cudnn_is_acceptable(Tensor self) -> bool");
    return table->getOp<bool (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor constant_pad_nd(const Tensor & self, IntArrayRef pad, Scalar value) {
    static auto table = globalATenDispatch().getOpTable("aten::constant_pad_nd(Tensor self, int[] pad, Scalar value=0) -> Tensor");
    return table->getOp<Tensor (const Tensor &, IntArrayRef, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, pad, value);
}
static inline Tensor convolution(const Tensor & input, const Tensor & weight, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool transposed, IntArrayRef output_padding, int64_t groups) {
    static auto table = globalATenDispatch().getOpTable("aten::convolution(Tensor input, Tensor weight, Tensor? bias, int[] stride, int[] padding, int[] dilation, bool transposed, int[] output_padding, int groups) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, bool, IntArrayRef, int64_t)>(at::detail::infer_backend(input), at::detail::infer_is_variable(input))(input, weight, bias, stride, padding, dilation, transposed, output_padding, groups);
}
static inline Tensor _convolution(const Tensor & input, const Tensor & weight, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool transposed, IntArrayRef output_padding, int64_t groups, bool benchmark, bool deterministic, bool cudnn_enabled) {
    static auto table = globalATenDispatch().getOpTable("aten::_convolution(Tensor input, Tensor weight, Tensor? bias, int[] stride, int[] padding, int[] dilation, bool transposed, int[] output_padding, int groups, bool benchmark, bool deterministic, bool cudnn_enabled) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, bool, IntArrayRef, int64_t, bool, bool, bool)>(at::detail::infer_backend(input), at::detail::infer_is_variable(input))(input, weight, bias, stride, padding, dilation, transposed, output_padding, groups, benchmark, deterministic, cudnn_enabled);
}
static inline Tensor _convolution_nogroup(const Tensor & input, const Tensor & weight, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool transposed, IntArrayRef output_padding) {
    static auto table = globalATenDispatch().getOpTable("aten::_convolution_nogroup(Tensor input, Tensor weight, Tensor? bias, int[] stride, int[] padding, int[] dilation, bool transposed, int[] output_padding) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, bool, IntArrayRef)>(at::detail::infer_backend(input), at::detail::infer_is_variable(input))(input, weight, bias, stride, padding, dilation, transposed, output_padding);
}
static inline std::tuple<Tensor,Tensor,Tensor> _convolution_double_backward(const Tensor & ggI, const Tensor & ggW, const Tensor & ggb, const Tensor & gO, const Tensor & weight, const Tensor & self, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool transposed, IntArrayRef output_padding, int64_t groups, bool benchmark, bool deterministic, bool cudnn_enabled, std::array<bool,3> output_mask) {
    static auto table = globalATenDispatch().getOpTable("aten::_convolution_double_backward(Tensor? ggI, Tensor? ggW, Tensor? ggb, Tensor gO, Tensor weight, Tensor self, int[] stride, int[] padding, int[] dilation, bool transposed, int[] output_padding, int groups, bool benchmark, bool deterministic, bool cudnn_enabled, bool[3] output_mask) -> (Tensor, Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor,Tensor> (const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, bool, IntArrayRef, int64_t, bool, bool, bool, std::array<bool,3>)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(ggI, ggW, ggb, gO, weight, self, stride, padding, dilation, transposed, output_padding, groups, benchmark, deterministic, cudnn_enabled, output_mask);
}
static inline Tensor conv1d(const Tensor & input, const Tensor & weight, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, int64_t groups) {
    static auto table = globalATenDispatch().getOpTable("aten::conv1d(Tensor input, Tensor weight, Tensor? bias=None, int[1] stride=1, int[1] padding=0, int[1] dilation=1, int groups=1) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, int64_t)>(at::detail::infer_backend(input), at::detail::infer_is_variable(input))(input, weight, bias, stride, padding, dilation, groups);
}
static inline Tensor conv2d(const Tensor & input, const Tensor & weight, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, int64_t groups) {
    static auto table = globalATenDispatch().getOpTable("aten::conv2d(Tensor input, Tensor weight, Tensor? bias=None, int[2] stride=1, int[2] padding=0, int[2] dilation=1, int groups=1) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, int64_t)>(at::detail::infer_backend(input), at::detail::infer_is_variable(input))(input, weight, bias, stride, padding, dilation, groups);
}
static inline Tensor conv3d(const Tensor & input, const Tensor & weight, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, int64_t groups) {
    static auto table = globalATenDispatch().getOpTable("aten::conv3d(Tensor input, Tensor weight, Tensor? bias=None, int[3] stride=1, int[3] padding=0, int[3] dilation=1, int groups=1) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, int64_t)>(at::detail::infer_backend(input), at::detail::infer_is_variable(input))(input, weight, bias, stride, padding, dilation, groups);
}
static inline Tensor conv_tbc(const Tensor & self, const Tensor & weight, const Tensor & bias, int64_t pad) {
    static auto table = globalATenDispatch().getOpTable("aten::conv_tbc(Tensor self, Tensor weight, Tensor bias, int pad=0) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, weight, bias, pad);
}
static inline std::tuple<Tensor,Tensor,Tensor> conv_tbc_backward(const Tensor & self, const Tensor & input, const Tensor & weight, const Tensor & bias, int64_t pad) {
    static auto table = globalATenDispatch().getOpTable("aten::conv_tbc_backward(Tensor self, Tensor input, Tensor weight, Tensor bias, int pad) -> (Tensor, Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor,Tensor> (const Tensor &, const Tensor &, const Tensor &, const Tensor &, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, input, weight, bias, pad);
}
static inline Tensor conv_transpose1d(const Tensor & input, const Tensor & weight, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, int64_t groups, IntArrayRef dilation) {
    static auto table = globalATenDispatch().getOpTable("aten::conv_transpose1d(Tensor input, Tensor weight, Tensor? bias=None, int[1] stride=1, int[1] padding=0, int[1] output_padding=0, int groups=1, int[1] dilation=1) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, int64_t, IntArrayRef)>(at::detail::infer_backend(input), at::detail::infer_is_variable(input))(input, weight, bias, stride, padding, output_padding, groups, dilation);
}
static inline Tensor conv_transpose2d(const Tensor & input, const Tensor & weight, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, int64_t groups, IntArrayRef dilation) {
    static auto table = globalATenDispatch().getOpTable("aten::conv_transpose2d(Tensor input, Tensor weight, Tensor? bias=None, int[2] stride=1, int[2] padding=0, int[2] output_padding=0, int groups=1, int[2] dilation=1) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, int64_t, IntArrayRef)>(at::detail::infer_backend(input), at::detail::infer_is_variable(input))(input, weight, bias, stride, padding, output_padding, groups, dilation);
}
static inline Tensor conv_transpose3d(const Tensor & input, const Tensor & weight, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, int64_t groups, IntArrayRef dilation) {
    static auto table = globalATenDispatch().getOpTable("aten::conv_transpose3d(Tensor input, Tensor weight, Tensor? bias=None, int[3] stride=1, int[3] padding=0, int[3] output_padding=0, int groups=1, int[3] dilation=1) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, int64_t, IntArrayRef)>(at::detail::infer_backend(input), at::detail::infer_is_variable(input))(input, weight, bias, stride, padding, output_padding, groups, dilation);
}
static inline Tensor _copy_from(const Tensor & self, const Tensor & dst, bool non_blocking) {
    static auto table = globalATenDispatch().getOpTable("aten::_copy_from(Tensor self, Tensor dst, bool non_blocking=False) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dst, non_blocking);
}
static inline Tensor cos(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::cos(Tensor self) -> Tensor");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & cos_(Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::cos_(Tensor(a!) self) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & cos_out(Tensor & out, const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::cos(Tensor self, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self);
}
static inline Tensor cosh(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::cosh(Tensor self) -> Tensor");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & cosh_(Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::cosh_(Tensor(a!) self) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & cosh_out(Tensor & out, const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::cosh(Tensor self, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self);
}
static inline Tensor cosine_embedding_loss(const Tensor & input1, const Tensor & input2, const Tensor & target, double margin, int64_t reduction) {
    static auto table = globalATenDispatch().getOpTable("aten::cosine_embedding_loss(Tensor input1, Tensor input2, Tensor target, float margin=0.0, int reduction=Mean) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, double, int64_t)>(at::detail::infer_backend(input1), at::detail::infer_is_variable(input1))(input1, input2, target, margin, reduction);
}
static inline Tensor cudnn_affine_grid_generator(const Tensor & theta, int64_t N, int64_t C, int64_t H, int64_t W) {
    static auto table = globalATenDispatch().getOpTable("aten::cudnn_affine_grid_generator(Tensor theta, int N, int C, int H, int W) -> Tensor grid");
    return table->getOp<Tensor (const Tensor &, int64_t, int64_t, int64_t, int64_t)>(at::detail::infer_backend(theta), at::detail::infer_is_variable(theta))(theta, N, C, H, W);
}
static inline Tensor cudnn_affine_grid_generator_backward(const Tensor & grad, int64_t N, int64_t C, int64_t H, int64_t W) {
    static auto table = globalATenDispatch().getOpTable("aten::cudnn_affine_grid_generator_backward(Tensor grad, int N, int C, int H, int W) -> Tensor grad_theta");
    return table->getOp<Tensor (const Tensor &, int64_t, int64_t, int64_t, int64_t)>(at::detail::infer_backend(grad), at::detail::infer_is_variable(grad))(grad, N, C, H, W);
}
static inline std::tuple<Tensor,Tensor,Tensor> cudnn_batch_norm(const Tensor & input, const Tensor & weight, const Tensor & bias, const Tensor & running_mean, const Tensor & running_var, bool training, double exponential_average_factor, double epsilon) {
    static auto table = globalATenDispatch().getOpTable("aten::cudnn_batch_norm(Tensor input, Tensor weight, Tensor? bias, Tensor? running_mean, Tensor? running_var, bool training, float exponential_average_factor, float epsilon) -> (Tensor, Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor,Tensor> (const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, bool, double, double)>(at::detail::infer_backend(input), at::detail::infer_is_variable(input))(input, weight, bias, running_mean, running_var, training, exponential_average_factor, epsilon);
}
static inline std::tuple<Tensor,Tensor,Tensor> cudnn_batch_norm_backward(const Tensor & input, const Tensor & grad_output, const Tensor & weight, const Tensor & running_mean, const Tensor & running_var, const Tensor & save_mean, const Tensor & save_var, double epsilon) {
    static auto table = globalATenDispatch().getOpTable("aten::cudnn_batch_norm_backward(Tensor input, Tensor grad_output, Tensor weight, Tensor? running_mean, Tensor? running_var, Tensor? save_mean, Tensor? save_var, float epsilon) -> (Tensor, Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor,Tensor> (const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, double)>(at::detail::infer_backend(input), at::detail::infer_is_variable(input))(input, grad_output, weight, running_mean, running_var, save_mean, save_var, epsilon);
}
static inline Tensor cudnn_convolution(const Tensor & self, const Tensor & weight, const Tensor & bias, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic) {
    static auto table = globalATenDispatch().getOpTable("aten::cudnn_convolution(Tensor self, Tensor weight, Tensor? bias, int[] padding, int[] stride, int[] dilation, int groups, bool benchmark, bool deterministic) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, int64_t, bool, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, weight, bias, padding, stride, dilation, groups, benchmark, deterministic);
}
static inline Tensor cudnn_convolution_backward_input(IntArrayRef self_size, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic) {
    static auto table = globalATenDispatch().getOpTable("aten::cudnn_convolution_backward_input(int[] self_size, Tensor grad_output, Tensor weight, int[] padding, int[] stride, int[] dilation, int groups, bool benchmark, bool deterministic) -> Tensor");
    return table->getOp<Tensor (IntArrayRef, const Tensor &, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, int64_t, bool, bool)>(at::detail::infer_backend(grad_output), at::detail::infer_is_variable(grad_output))(self_size, grad_output, weight, padding, stride, dilation, groups, benchmark, deterministic);
}
static inline std::tuple<Tensor,Tensor,Tensor> cudnn_convolution_backward(const Tensor & self, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic, std::array<bool,3> output_mask) {
    static auto table = globalATenDispatch().getOpTable("aten::cudnn_convolution_backward(Tensor self, Tensor grad_output, Tensor weight, int[] padding, int[] stride, int[] dilation, int groups, bool benchmark, bool deterministic, bool[3] output_mask) -> (Tensor, Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor,Tensor> (const Tensor &, const Tensor &, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, int64_t, bool, bool, std::array<bool,3>)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, grad_output, weight, padding, stride, dilation, groups, benchmark, deterministic, output_mask);
}
static inline Tensor cudnn_convolution_backward_bias(const Tensor & grad_output) {
    static auto table = globalATenDispatch().getOpTable("aten::cudnn_convolution_backward_bias(Tensor grad_output) -> Tensor");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(grad_output), at::detail::infer_is_variable(grad_output))(grad_output);
}
static inline Tensor cudnn_convolution_backward_weight(IntArrayRef weight_size, const Tensor & grad_output, const Tensor & self, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic) {
    static auto table = globalATenDispatch().getOpTable("aten::cudnn_convolution_backward_weight(int[] weight_size, Tensor grad_output, Tensor self, int[] padding, int[] stride, int[] dilation, int groups, bool benchmark, bool deterministic) -> Tensor");
    return table->getOp<Tensor (IntArrayRef, const Tensor &, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, int64_t, bool, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(weight_size, grad_output, self, padding, stride, dilation, groups, benchmark, deterministic);
}
static inline Tensor cudnn_convolution_transpose(const Tensor & self, const Tensor & weight, const Tensor & bias, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic) {
    static auto table = globalATenDispatch().getOpTable("aten::cudnn_convolution_transpose(Tensor self, Tensor weight, Tensor? bias, int[] padding, int[] output_padding, int[] stride, int[] dilation, int groups, bool benchmark, bool deterministic) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, IntArrayRef, int64_t, bool, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, weight, bias, padding, output_padding, stride, dilation, groups, benchmark, deterministic);
}
static inline std::tuple<Tensor,Tensor,Tensor> cudnn_convolution_transpose_backward(const Tensor & self, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic, std::array<bool,3> output_mask) {
    static auto table = globalATenDispatch().getOpTable("aten::cudnn_convolution_transpose_backward(Tensor self, Tensor grad_output, Tensor weight, int[] padding, int[] output_padding, int[] stride, int[] dilation, int groups, bool benchmark, bool deterministic, bool[3] output_mask) -> (Tensor, Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor,Tensor> (const Tensor &, const Tensor &, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, IntArrayRef, int64_t, bool, bool, std::array<bool,3>)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, grad_output, weight, padding, output_padding, stride, dilation, groups, benchmark, deterministic, output_mask);
}
static inline Tensor cudnn_convolution_transpose_backward_bias(const Tensor & grad_output) {
    static auto table = globalATenDispatch().getOpTable("aten::cudnn_convolution_transpose_backward_bias(Tensor grad_output) -> Tensor");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(grad_output), at::detail::infer_is_variable(grad_output))(grad_output);
}
static inline Tensor cudnn_convolution_transpose_backward_input(const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic) {
    static auto table = globalATenDispatch().getOpTable("aten::cudnn_convolution_transpose_backward_input(Tensor grad_output, Tensor weight, int[] padding, int[] stride, int[] dilation, int groups, bool benchmark, bool deterministic) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, int64_t, bool, bool)>(at::detail::infer_backend(grad_output), at::detail::infer_is_variable(grad_output))(grad_output, weight, padding, stride, dilation, groups, benchmark, deterministic);
}
static inline Tensor cudnn_convolution_transpose_backward_weight(IntArrayRef weight_size, const Tensor & grad_output, const Tensor & self, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic) {
    static auto table = globalATenDispatch().getOpTable("aten::cudnn_convolution_transpose_backward_weight(int[] weight_size, Tensor grad_output, Tensor self, int[] padding, int[] stride, int[] dilation, int groups, bool benchmark, bool deterministic) -> Tensor");
    return table->getOp<Tensor (IntArrayRef, const Tensor &, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, int64_t, bool, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(weight_size, grad_output, self, padding, stride, dilation, groups, benchmark, deterministic);
}
static inline Tensor cudnn_grid_sampler(const Tensor & self, const Tensor & grid) {
    static auto table = globalATenDispatch().getOpTable("aten::cudnn_grid_sampler(Tensor self, Tensor grid) -> Tensor output");
    return table->getOp<Tensor (const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, grid);
}
static inline std::tuple<Tensor,Tensor> cudnn_grid_sampler_backward(const Tensor & self, const Tensor & grid, const Tensor & grad_output) {
    static auto table = globalATenDispatch().getOpTable("aten::cudnn_grid_sampler_backward(Tensor self, Tensor grid, Tensor grad_output) -> (Tensor grad_self, Tensor grad_grid)");
    return table->getOp<std::tuple<Tensor,Tensor> (const Tensor &, const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, grid, grad_output);
}
static inline Tensor cumsum(const Tensor & self, int64_t dim, c10::optional<ScalarType> dtype) {
    static auto table = globalATenDispatch().getOpTable("aten::cumsum(Tensor self, int dim, *, ScalarType? dtype=None) -> Tensor");
    return table->getOp<Tensor (const Tensor &, int64_t, c10::optional<ScalarType>)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dim, dtype);
}
static inline Tensor & cumsum_out(Tensor & out, const Tensor & self, int64_t dim, c10::optional<ScalarType> dtype) {
    static auto table = globalATenDispatch().getOpTable("aten::cumsum(Tensor self, int dim, *, ScalarType? dtype=None, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, int64_t, c10::optional<ScalarType>)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, dim, dtype);
}
static inline Tensor cumprod(const Tensor & self, int64_t dim, c10::optional<ScalarType> dtype) {
    static auto table = globalATenDispatch().getOpTable("aten::cumprod(Tensor self, int dim, *, ScalarType? dtype=None) -> Tensor");
    return table->getOp<Tensor (const Tensor &, int64_t, c10::optional<ScalarType>)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dim, dtype);
}
static inline Tensor & cumprod_out(Tensor & out, const Tensor & self, int64_t dim, c10::optional<ScalarType> dtype) {
    static auto table = globalATenDispatch().getOpTable("aten::cumprod(Tensor self, int dim, *, ScalarType? dtype=None, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, int64_t, c10::optional<ScalarType>)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, dim, dtype);
}
static inline Tensor ctc_loss(const Tensor & log_probs, const Tensor & targets, IntArrayRef input_lengths, IntArrayRef target_lengths, int64_t blank, int64_t reduction, bool zero_infinity) {
    static auto table = globalATenDispatch().getOpTable("aten::ctc_loss(Tensor log_probs, Tensor targets, int[] input_lengths, int[] target_lengths, int blank=0, int reduction=Mean, bool zero_infinity=False) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, IntArrayRef, IntArrayRef, int64_t, int64_t, bool)>(at::detail::infer_backend(log_probs), at::detail::infer_is_variable(log_probs))(log_probs, targets, input_lengths, target_lengths, blank, reduction, zero_infinity);
}
static inline Tensor ctc_loss(const Tensor & log_probs, const Tensor & targets, const Tensor & input_lengths, const Tensor & target_lengths, int64_t blank, int64_t reduction, bool zero_infinity) {
    static auto table = globalATenDispatch().getOpTable("aten::ctc_loss(Tensor log_probs, Tensor targets, Tensor input_lengths, Tensor target_lengths, int blank=0, int reduction=Mean, bool zero_infinity=False) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, const Tensor &, int64_t, int64_t, bool)>(at::detail::infer_backend(log_probs), at::detail::infer_is_variable(log_probs))(log_probs, targets, input_lengths, target_lengths, blank, reduction, zero_infinity);
}
static inline std::tuple<Tensor,Tensor> _ctc_loss(const Tensor & log_probs, const Tensor & targets, IntArrayRef input_lengths, IntArrayRef target_lengths, int64_t blank, bool zero_infinity) {
    static auto table = globalATenDispatch().getOpTable("aten::_ctc_loss(Tensor log_probs, Tensor targets, int[] input_lengths, int[] target_lengths, int blank=0, bool zero_infinity=False) -> (Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor> (const Tensor &, const Tensor &, IntArrayRef, IntArrayRef, int64_t, bool)>(at::detail::infer_backend(log_probs), at::detail::infer_is_variable(log_probs))(log_probs, targets, input_lengths, target_lengths, blank, zero_infinity);
}
static inline Tensor _ctc_loss_backward(const Tensor & grad, const Tensor & log_probs, const Tensor & targets, IntArrayRef input_lengths, IntArrayRef target_lengths, const Tensor & neg_log_likelihood, const Tensor & log_alpha, int64_t blank, bool zero_infinity) {
    static auto table = globalATenDispatch().getOpTable("aten::_ctc_loss_backward(Tensor grad, Tensor log_probs, Tensor targets, int[] input_lengths, int[] target_lengths, Tensor neg_log_likelihood, Tensor log_alpha, int blank, bool zero_infinity=False) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, IntArrayRef, IntArrayRef, const Tensor &, const Tensor &, int64_t, bool)>(at::detail::infer_backend(grad), at::detail::infer_is_variable(grad))(grad, log_probs, targets, input_lengths, target_lengths, neg_log_likelihood, log_alpha, blank, zero_infinity);
}
static inline Tensor det(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::det(Tensor self) -> Tensor");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor diag_embed(const Tensor & self, int64_t offset, int64_t dim1, int64_t dim2) {
    static auto table = globalATenDispatch().getOpTable("aten::diag_embed(Tensor self, int offset=0, int dim1=-2, int dim2=-1) -> Tensor");
    return table->getOp<Tensor (const Tensor &, int64_t, int64_t, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, offset, dim1, dim2);
}
static inline Tensor diagflat(const Tensor & self, int64_t offset) {
    static auto table = globalATenDispatch().getOpTable("aten::diagflat(Tensor self, int offset=0) -> Tensor");
    return table->getOp<Tensor (const Tensor &, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, offset);
}
static inline Tensor diagonal(const Tensor & self, int64_t offset, int64_t dim1, int64_t dim2) {
    static auto table = globalATenDispatch().getOpTable("aten::diagonal(Tensor(a) self, int offset=0, int dim1=0, int dim2=1) -> Tensor(a)");
    return table->getOp<Tensor (const Tensor &, int64_t, int64_t, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, offset, dim1, dim2);
}
static inline Tensor div(const Tensor & self, const Tensor & other) {
    static auto table = globalATenDispatch().getOpTable("aten::div(Tensor self, Tensor other) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, other);
}
static inline Tensor & div_out(Tensor & out, const Tensor & self, const Tensor & other) {
    static auto table = globalATenDispatch().getOpTable("aten::div(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, other);
}
static inline Tensor div(const Tensor & self, Scalar other) {
    static auto table = globalATenDispatch().getOpTable("aten::div(Tensor self, Scalar other) -> Tensor");
    return table->getOp<Tensor (const Tensor &, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, other);
}
static inline Tensor dot(const Tensor & self, const Tensor & tensor) {
    static auto table = globalATenDispatch().getOpTable("aten::dot(Tensor self, Tensor tensor) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, tensor);
}
static inline Tensor & dot_out(Tensor & out, const Tensor & self, const Tensor & tensor) {
    static auto table = globalATenDispatch().getOpTable("aten::dot(Tensor self, Tensor tensor, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, tensor);
}
static inline Tensor einsum(std::string equation, TensorList tensors) {
    static auto table = globalATenDispatch().getOpTable("aten::einsum(str equation, Tensor[] tensors) -> Tensor");
    return table->getOp<Tensor (std::string, TensorList)>(at::detail::infer_backend(tensors), at::detail::infer_is_variable(tensors))(equation, tensors);
}
static inline Tensor embedding(const Tensor & weight, const Tensor & indices, int64_t padding_idx, bool scale_grad_by_freq, bool sparse) {
    static auto table = globalATenDispatch().getOpTable("aten::embedding(Tensor weight, Tensor indices, int padding_idx=-1, bool scale_grad_by_freq=False, bool sparse=False) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, int64_t, bool, bool)>(at::detail::infer_backend(weight), at::detail::infer_is_variable(weight))(weight, indices, padding_idx, scale_grad_by_freq, sparse);
}
static inline Tensor embedding_backward(const Tensor & grad, const Tensor & indices, int64_t num_weights, int64_t padding_idx, bool scale_grad_by_freq, bool sparse) {
    static auto table = globalATenDispatch().getOpTable("aten::embedding_backward(Tensor grad, Tensor indices, int num_weights, int padding_idx, bool scale_grad_by_freq, bool sparse) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, int64_t, int64_t, bool, bool)>(at::detail::infer_backend(grad), at::detail::infer_is_variable(grad))(grad, indices, num_weights, padding_idx, scale_grad_by_freq, sparse);
}
static inline Tensor embedding_dense_backward(const Tensor & grad_output, const Tensor & indices, int64_t num_weights, int64_t padding_idx, bool scale_grad_by_freq) {
    static auto table = globalATenDispatch().getOpTable("aten::embedding_dense_backward(Tensor grad_output, Tensor indices, int num_weights, int padding_idx, bool scale_grad_by_freq) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, int64_t, int64_t, bool)>(at::detail::infer_backend(grad_output), at::detail::infer_is_variable(grad_output))(grad_output, indices, num_weights, padding_idx, scale_grad_by_freq);
}
static inline Tensor & embedding_renorm_(Tensor & self, const Tensor & indices, double max_norm, double norm_type) {
    static auto table = globalATenDispatch().getOpTable("aten::embedding_renorm_(Tensor(a!) self, Tensor indices, float max_norm, float norm_type) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, double, double)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, indices, max_norm, norm_type);
}
static inline Tensor embedding_sparse_backward(const Tensor & grad, const Tensor & indices, int64_t num_weights, int64_t padding_idx, bool scale_grad_by_freq) {
    static auto table = globalATenDispatch().getOpTable("aten::embedding_sparse_backward(Tensor grad, Tensor indices, int num_weights, int padding_idx, bool scale_grad_by_freq) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, int64_t, int64_t, bool)>(at::detail::infer_backend(grad), at::detail::infer_is_variable(grad))(grad, indices, num_weights, padding_idx, scale_grad_by_freq);
}
static inline std::tuple<Tensor,Tensor,Tensor,Tensor> embedding_bag(const Tensor & weight, const Tensor & indices, const Tensor & offsets, bool scale_grad_by_freq, int64_t mode, bool sparse, const Tensor & per_sample_weights) {
    static auto table = globalATenDispatch().getOpTable("aten::embedding_bag(Tensor weight, Tensor indices, Tensor offsets, bool scale_grad_by_freq=False, int mode=0, bool sparse=False, Tensor? per_sample_weights=None) -> (Tensor, Tensor, Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor,Tensor,Tensor> (const Tensor &, const Tensor &, const Tensor &, bool, int64_t, bool, const Tensor &)>(at::detail::infer_backend(weight), at::detail::infer_is_variable(weight))(weight, indices, offsets, scale_grad_by_freq, mode, sparse, per_sample_weights);
}
static inline std::tuple<Tensor,Tensor,Tensor,Tensor> _embedding_bag(const Tensor & weight, const Tensor & indices, const Tensor & offsets, bool scale_grad_by_freq, int64_t mode, bool sparse, const Tensor & per_sample_weights) {
    static auto table = globalATenDispatch().getOpTable("aten::_embedding_bag(Tensor weight, Tensor indices, Tensor offsets, bool scale_grad_by_freq=False, int mode=0, bool sparse=False, Tensor? per_sample_weights=None) -> (Tensor, Tensor, Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor,Tensor,Tensor> (const Tensor &, const Tensor &, const Tensor &, bool, int64_t, bool, const Tensor &)>(at::detail::infer_backend(weight), at::detail::infer_is_variable(weight))(weight, indices, offsets, scale_grad_by_freq, mode, sparse, per_sample_weights);
}
static inline Tensor _embedding_bag_backward(const Tensor & grad, const Tensor & indices, const Tensor & offsets, const Tensor & offset2bag, const Tensor & bag_size, const Tensor & maximum_indices, int64_t num_weights, bool scale_grad_by_freq, int64_t mode, bool sparse, const Tensor & per_sample_weights) {
    static auto table = globalATenDispatch().getOpTable("aten::_embedding_bag_backward(Tensor grad, Tensor indices, Tensor offsets, Tensor offset2bag, Tensor bag_size, Tensor maximum_indices, int num_weights, bool scale_grad_by_freq, int mode, bool sparse, Tensor? per_sample_weights) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, int64_t, bool, int64_t, bool, const Tensor &)>(at::detail::infer_backend(grad), at::detail::infer_is_variable(grad))(grad, indices, offsets, offset2bag, bag_size, maximum_indices, num_weights, scale_grad_by_freq, mode, sparse, per_sample_weights);
}
static inline Tensor _embedding_bag_sparse_backward(const Tensor & grad, const Tensor & indices, const Tensor & offsets, const Tensor & offset2bag, const Tensor & bag_size, int64_t num_weights, bool scale_grad_by_freq, int64_t mode, const Tensor & per_sample_weights) {
    static auto table = globalATenDispatch().getOpTable("aten::_embedding_bag_sparse_backward(Tensor grad, Tensor indices, Tensor offsets, Tensor offset2bag, Tensor bag_size, int num_weights, bool scale_grad_by_freq, int mode, Tensor? per_sample_weights) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, int64_t, bool, int64_t, const Tensor &)>(at::detail::infer_backend(grad), at::detail::infer_is_variable(grad))(grad, indices, offsets, offset2bag, bag_size, num_weights, scale_grad_by_freq, mode, per_sample_weights);
}
static inline Tensor _embedding_bag_dense_backward(const Tensor & grad, const Tensor & indices, const Tensor & offsets, const Tensor & offset2bag, const Tensor & bag_size, const Tensor & maximum_indices, int64_t num_weights, bool scale_grad_by_freq, int64_t mode, const Tensor & per_sample_weights) {
    static auto table = globalATenDispatch().getOpTable("aten::_embedding_bag_dense_backward(Tensor grad, Tensor indices, Tensor offsets, Tensor offset2bag, Tensor bag_size, Tensor maximum_indices, int num_weights, bool scale_grad_by_freq, int mode, Tensor? per_sample_weights) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, int64_t, bool, int64_t, const Tensor &)>(at::detail::infer_backend(grad), at::detail::infer_is_variable(grad))(grad, indices, offsets, offset2bag, bag_size, maximum_indices, num_weights, scale_grad_by_freq, mode, per_sample_weights);
}
static inline Tensor _embedding_bag_per_sample_weights_backward(const Tensor & grad, const Tensor & weight, const Tensor & indices, const Tensor & offsets, const Tensor & offset2bag, int64_t mode) {
    static auto table = globalATenDispatch().getOpTable("aten::_embedding_bag_per_sample_weights_backward(Tensor grad, Tensor weight, Tensor indices, Tensor offsets, Tensor offset2bag, int mode) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, int64_t)>(at::detail::infer_backend(grad), at::detail::infer_is_variable(grad))(grad, weight, indices, offsets, offset2bag, mode);
}
#ifdef BUILD_NAMEDTENSOR
static inline Tensor empty(IntArrayRef size, c10::optional<DimnameList> names, const TensorOptions & options) {
    globalLegacyTypeDispatch().initForBackend(options.backend());
    static auto table = globalATenDispatch().getOpTable("aten::empty(int[] size, *, Dimname[]? names, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor");
    return table->getOp<Tensor (IntArrayRef, c10::optional<DimnameList>, const TensorOptions &)>(options.backend(), options.is_variable())(size, names, options);
}
#endif
static inline Tensor empty(IntArrayRef size, const TensorOptions & options, c10::optional<MemoryFormat> memory_format) {
    globalLegacyTypeDispatch().initForBackend(options.backend());
    static auto table = globalATenDispatch().getOpTable("aten::empty(int[] size, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None, MemoryFormat? memory_format=None) -> Tensor");
    return table->getOp<Tensor (IntArrayRef, const TensorOptions &, c10::optional<MemoryFormat>)>(options.backend(), options.is_variable())(size, options, memory_format);
}
static inline Tensor _empty_affine_quantized(IntArrayRef size, const TensorOptions & options, double scale, int64_t zero_point, c10::optional<MemoryFormat> memory_format) {
    globalLegacyTypeDispatch().initForBackend(options.backend());
    static auto table = globalATenDispatch().getOpTable("aten::_empty_affine_quantized(int[] size, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None, float scale=1, int zero_point=0, MemoryFormat? memory_format=contiguous_format) -> Tensor");
    return table->getOp<Tensor (IntArrayRef, const TensorOptions &, double, int64_t, c10::optional<MemoryFormat>)>(options.backend(), options.is_variable())(size, options, scale, zero_point, memory_format);
}
static inline Tensor & empty_out(Tensor & out, IntArrayRef size, c10::optional<MemoryFormat> memory_format) {
    static auto table = globalATenDispatch().getOpTable("aten::empty(int[] size, *, MemoryFormat? memory_format=None, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, IntArrayRef, c10::optional<MemoryFormat>)>(at::detail::infer_backend(out), at::detail::infer_is_variable(out))(out, size, memory_format);
}
static inline Tensor empty_like(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::empty_like(Tensor self) -> Tensor");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor empty_like(const Tensor & self, const TensorOptions & options, c10::optional<MemoryFormat> memory_format) {
    globalLegacyTypeDispatch().initForBackend(options.backend());
    static auto table = globalATenDispatch().getOpTable("aten::empty_like(Tensor self, *, ScalarType dtype, Layout layout, Device device, bool pin_memory=False, MemoryFormat? memory_format=contiguous_format) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const TensorOptions &, c10::optional<MemoryFormat>)>(options.backend(), options.is_variable())(self, options, memory_format);
}
static inline Tensor empty_strided(IntArrayRef size, IntArrayRef stride, const TensorOptions & options) {
    globalLegacyTypeDispatch().initForBackend(options.backend());
    static auto table = globalATenDispatch().getOpTable("aten::empty_strided(int[] size, int[] stride, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor");
    return table->getOp<Tensor (IntArrayRef, IntArrayRef, const TensorOptions &)>(options.backend(), options.is_variable())(size, stride, options);
}
static inline Tensor erf(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::erf(Tensor self) -> Tensor");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & erf_(Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::erf_(Tensor(a!) self) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & erf_out(Tensor & out, const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::erf(Tensor self, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self);
}
static inline Tensor erfc(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::erfc(Tensor self) -> Tensor");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & erfc_(Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::erfc_(Tensor(a!) self) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & erfc_out(Tensor & out, const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::erfc(Tensor self, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self);
}
static inline Tensor exp(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::exp(Tensor self) -> Tensor");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & exp_(Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::exp_(Tensor(a!) self) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & exp_out(Tensor & out, const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::exp(Tensor self, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self);
}
static inline Tensor expm1(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::expm1(Tensor self) -> Tensor");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & expm1_(Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::expm1_(Tensor(a!) self) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & expm1_out(Tensor & out, const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::expm1(Tensor self, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self);
}
static inline Tensor eye(int64_t n, const TensorOptions & options) {
    globalLegacyTypeDispatch().initForBackend(options.backend());
    static auto table = globalATenDispatch().getOpTable("aten::eye(int n, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor");
    return table->getOp<Tensor (int64_t, const TensorOptions &)>(options.backend(), options.is_variable())(n, options);
}
static inline Tensor eye(int64_t n, int64_t m, const TensorOptions & options) {
    globalLegacyTypeDispatch().initForBackend(options.backend());
    static auto table = globalATenDispatch().getOpTable("aten::eye(int n, int m, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor");
    return table->getOp<Tensor (int64_t, int64_t, const TensorOptions &)>(options.backend(), options.is_variable())(n, m, options);
}
static inline Tensor & eye_out(Tensor & out, int64_t n) {
    static auto table = globalATenDispatch().getOpTable("aten::eye(int n, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, int64_t)>(at::detail::infer_backend(out), at::detail::infer_is_variable(out))(out, n);
}
static inline Tensor & eye_out(Tensor & out, int64_t n, int64_t m) {
    static auto table = globalATenDispatch().getOpTable("aten::eye(int n, int m, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, int64_t, int64_t)>(at::detail::infer_backend(out), at::detail::infer_is_variable(out))(out, n, m);
}
static inline Tensor flatten(const Tensor & self, int64_t start_dim, int64_t end_dim) {
    static auto table = globalATenDispatch().getOpTable("aten::flatten(Tensor self, int start_dim=0, int end_dim=-1) -> Tensor");
    return table->getOp<Tensor (const Tensor &, int64_t, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, start_dim, end_dim);
}
static inline Tensor & fill_(Tensor & self, Scalar value) {
    static auto table = globalATenDispatch().getOpTable("aten::fill_(Tensor(a!) self, Scalar value) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, value);
}
static inline Tensor & fill_(Tensor & self, const Tensor & value) {
    static auto table = globalATenDispatch().getOpTable("aten::fill_(Tensor(a!) self, Tensor value) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, value);
}
static inline Tensor floor(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::floor(Tensor self) -> Tensor");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & floor_(Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::floor_(Tensor(a!) self) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & floor_out(Tensor & out, const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::floor(Tensor self, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self);
}
static inline Tensor frac(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::frac(Tensor self) -> Tensor");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & frac_(Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::frac_(Tensor(a!) self) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & frac_out(Tensor & out, const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::frac(Tensor self, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self);
}
static inline Tensor full(IntArrayRef size, Scalar fill_value, const TensorOptions & options) {
    globalLegacyTypeDispatch().initForBackend(options.backend());
    static auto table = globalATenDispatch().getOpTable("aten::full(int[] size, Scalar fill_value, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor");
    return table->getOp<Tensor (IntArrayRef, Scalar, const TensorOptions &)>(options.backend(), options.is_variable())(size, fill_value, options);
}
static inline Tensor & full_out(Tensor & out, IntArrayRef size, Scalar fill_value) {
    static auto table = globalATenDispatch().getOpTable("aten::full(int[] size, Scalar fill_value, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, IntArrayRef, Scalar)>(at::detail::infer_backend(out), at::detail::infer_is_variable(out))(out, size, fill_value);
}
static inline Tensor full_like(const Tensor & self, Scalar fill_value) {
    static auto table = globalATenDispatch().getOpTable("aten::full_like(Tensor self, Scalar fill_value) -> Tensor");
    return table->getOp<Tensor (const Tensor &, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, fill_value);
}
static inline Tensor full_like(const Tensor & self, Scalar fill_value, const TensorOptions & options) {
    globalLegacyTypeDispatch().initForBackend(options.backend());
    static auto table = globalATenDispatch().getOpTable("aten::full_like(Tensor self, Scalar fill_value, *, ScalarType dtype, Layout layout, Device device, bool pin_memory=False) -> Tensor");
    return table->getOp<Tensor (const Tensor &, Scalar, const TensorOptions &)>(options.backend(), options.is_variable())(self, fill_value, options);
}
static inline Tensor from_file(std::string filename, c10::optional<bool> shared, c10::optional<int64_t> size, const TensorOptions & options) {
    globalLegacyTypeDispatch().initForBackend(options.backend());
    static auto table = globalATenDispatch().getOpTable("aten::from_file(str filename, bool? shared=None, int? size=0, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor");
    return table->getOp<Tensor (std::string, c10::optional<bool>, c10::optional<int64_t>, const TensorOptions &)>(options.backend(), options.is_variable())(filename, shared, size, options);
}
static inline Tensor grid_sampler(const Tensor & input, const Tensor & grid, int64_t interpolation_mode, int64_t padding_mode) {
    static auto table = globalATenDispatch().getOpTable("aten::grid_sampler(Tensor input, Tensor grid, int interpolation_mode, int padding_mode) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, int64_t, int64_t)>(at::detail::infer_backend(input), at::detail::infer_is_variable(input))(input, grid, interpolation_mode, padding_mode);
}
static inline Tensor grid_sampler_2d(const Tensor & input, const Tensor & grid, int64_t interpolation_mode, int64_t padding_mode) {
    static auto table = globalATenDispatch().getOpTable("aten::grid_sampler_2d(Tensor input, Tensor grid, int interpolation_mode, int padding_mode) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, int64_t, int64_t)>(at::detail::infer_backend(input), at::detail::infer_is_variable(input))(input, grid, interpolation_mode, padding_mode);
}
static inline std::tuple<Tensor,Tensor> grid_sampler_2d_backward(const Tensor & grad_output, const Tensor & input, const Tensor & grid, int64_t interpolation_mode, int64_t padding_mode) {
    static auto table = globalATenDispatch().getOpTable("aten::grid_sampler_2d_backward(Tensor grad_output, Tensor input, Tensor grid, int interpolation_mode, int padding_mode) -> (Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor> (const Tensor &, const Tensor &, const Tensor &, int64_t, int64_t)>(at::detail::infer_backend(grad_output), at::detail::infer_is_variable(grad_output))(grad_output, input, grid, interpolation_mode, padding_mode);
}
static inline Tensor grid_sampler_3d(const Tensor & input, const Tensor & grid, int64_t interpolation_mode, int64_t padding_mode) {
    static auto table = globalATenDispatch().getOpTable("aten::grid_sampler_3d(Tensor input, Tensor grid, int interpolation_mode, int padding_mode) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, int64_t, int64_t)>(at::detail::infer_backend(input), at::detail::infer_is_variable(input))(input, grid, interpolation_mode, padding_mode);
}
static inline std::tuple<Tensor,Tensor> grid_sampler_3d_backward(const Tensor & grad_output, const Tensor & input, const Tensor & grid, int64_t interpolation_mode, int64_t padding_mode) {
    static auto table = globalATenDispatch().getOpTable("aten::grid_sampler_3d_backward(Tensor grad_output, Tensor input, Tensor grid, int interpolation_mode, int padding_mode) -> (Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor> (const Tensor &, const Tensor &, const Tensor &, int64_t, int64_t)>(at::detail::infer_backend(grad_output), at::detail::infer_is_variable(grad_output))(grad_output, input, grid, interpolation_mode, padding_mode);
}
static inline Tensor hann_window(int64_t window_length, const TensorOptions & options) {
    globalLegacyTypeDispatch().initForBackend(options.backend());
    static auto table = globalATenDispatch().getOpTable("aten::hann_window(int window_length, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor");
    return table->getOp<Tensor (int64_t, const TensorOptions &)>(options.backend(), options.is_variable())(window_length, options);
}
static inline Tensor hann_window(int64_t window_length, bool periodic, const TensorOptions & options) {
    globalLegacyTypeDispatch().initForBackend(options.backend());
    static auto table = globalATenDispatch().getOpTable("aten::hann_window(int window_length, bool periodic, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor");
    return table->getOp<Tensor (int64_t, bool, const TensorOptions &)>(options.backend(), options.is_variable())(window_length, periodic, options);
}
static inline Tensor hamming_window(int64_t window_length, const TensorOptions & options) {
    globalLegacyTypeDispatch().initForBackend(options.backend());
    static auto table = globalATenDispatch().getOpTable("aten::hamming_window(int window_length, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor");
    return table->getOp<Tensor (int64_t, const TensorOptions &)>(options.backend(), options.is_variable())(window_length, options);
}
static inline Tensor hamming_window(int64_t window_length, bool periodic, const TensorOptions & options) {
    globalLegacyTypeDispatch().initForBackend(options.backend());
    static auto table = globalATenDispatch().getOpTable("aten::hamming_window(int window_length, bool periodic, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor");
    return table->getOp<Tensor (int64_t, bool, const TensorOptions &)>(options.backend(), options.is_variable())(window_length, periodic, options);
}
static inline Tensor hamming_window(int64_t window_length, bool periodic, double alpha, const TensorOptions & options) {
    globalLegacyTypeDispatch().initForBackend(options.backend());
    static auto table = globalATenDispatch().getOpTable("aten::hamming_window(int window_length, bool periodic, float alpha, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor");
    return table->getOp<Tensor (int64_t, bool, double, const TensorOptions &)>(options.backend(), options.is_variable())(window_length, periodic, alpha, options);
}
static inline Tensor hamming_window(int64_t window_length, bool periodic, double alpha, double beta, const TensorOptions & options) {
    globalLegacyTypeDispatch().initForBackend(options.backend());
    static auto table = globalATenDispatch().getOpTable("aten::hamming_window(int window_length, bool periodic, float alpha, float beta, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor");
    return table->getOp<Tensor (int64_t, bool, double, double, const TensorOptions &)>(options.backend(), options.is_variable())(window_length, periodic, alpha, beta, options);
}
static inline Tensor hinge_embedding_loss(const Tensor & self, const Tensor & target, double margin, int64_t reduction) {
    static auto table = globalATenDispatch().getOpTable("aten::hinge_embedding_loss(Tensor self, Tensor target, float margin=1.0, int reduction=Mean) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, double, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, target, margin, reduction);
}
static inline Tensor ger(const Tensor & self, const Tensor & vec2) {
    static auto table = globalATenDispatch().getOpTable("aten::ger(Tensor self, Tensor vec2) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, vec2);
}
static inline Tensor & ger_out(Tensor & out, const Tensor & self, const Tensor & vec2) {
    static auto table = globalATenDispatch().getOpTable("aten::ger(Tensor self, Tensor vec2, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, vec2);
}
static inline Tensor group_norm(const Tensor & input, int64_t num_groups, const Tensor & weight, const Tensor & bias, double eps, bool cudnn_enabled) {
    static auto table = globalATenDispatch().getOpTable("aten::group_norm(Tensor input, int num_groups, Tensor? weight=None, Tensor? bias=None, float eps=1e-05, bool cudnn_enabled=True) -> Tensor");
    return table->getOp<Tensor (const Tensor &, int64_t, const Tensor &, const Tensor &, double, bool)>(at::detail::infer_backend(input), at::detail::infer_is_variable(input))(input, num_groups, weight, bias, eps, cudnn_enabled);
}
static inline Tensor fft(const Tensor & self, int64_t signal_ndim, bool normalized) {
    static auto table = globalATenDispatch().getOpTable("aten::fft(Tensor self, int signal_ndim, bool normalized=False) -> Tensor");
    return table->getOp<Tensor (const Tensor &, int64_t, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, signal_ndim, normalized);
}
static inline Tensor ifft(const Tensor & self, int64_t signal_ndim, bool normalized) {
    static auto table = globalATenDispatch().getOpTable("aten::ifft(Tensor self, int signal_ndim, bool normalized=False) -> Tensor");
    return table->getOp<Tensor (const Tensor &, int64_t, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, signal_ndim, normalized);
}
static inline Tensor rfft(const Tensor & self, int64_t signal_ndim, bool normalized, bool onesided) {
    static auto table = globalATenDispatch().getOpTable("aten::rfft(Tensor self, int signal_ndim, bool normalized=False, bool onesided=True) -> Tensor");
    return table->getOp<Tensor (const Tensor &, int64_t, bool, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, signal_ndim, normalized, onesided);
}
static inline Tensor irfft(const Tensor & self, int64_t signal_ndim, bool normalized, bool onesided, IntArrayRef signal_sizes) {
    static auto table = globalATenDispatch().getOpTable("aten::irfft(Tensor self, int signal_ndim, bool normalized=False, bool onesided=True, int[] signal_sizes=[]) -> Tensor");
    return table->getOp<Tensor (const Tensor &, int64_t, bool, bool, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, signal_ndim, normalized, onesided, signal_sizes);
}
static inline Tensor _fft_with_size(const Tensor & self, int64_t signal_ndim, bool complex_input, bool complex_output, bool inverse, IntArrayRef checked_signal_sizes, bool normalized, bool onesided, IntArrayRef output_sizes) {
    static auto table = globalATenDispatch().getOpTable("aten::_fft_with_size(Tensor self, int signal_ndim, bool complex_input, bool complex_output, bool inverse, int[] checked_signal_sizes, bool normalized, bool onesided, int[] output_sizes) -> Tensor");
    return table->getOp<Tensor (const Tensor &, int64_t, bool, bool, bool, IntArrayRef, bool, bool, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, signal_ndim, complex_input, complex_output, inverse, checked_signal_sizes, normalized, onesided, output_sizes);
}
static inline int64_t _cufft_get_plan_cache_size(int64_t device_index) {
    static auto table = globalATenDispatch().getOpTable("aten::_cufft_get_plan_cache_size(int device_index) -> int");
    return table->getOp<int64_t (int64_t)>(Backend::CPU, false)(device_index);
}
static inline int64_t _cufft_get_plan_cache_max_size(int64_t device_index) {
    static auto table = globalATenDispatch().getOpTable("aten::_cufft_get_plan_cache_max_size(int device_index) -> int");
    return table->getOp<int64_t (int64_t)>(Backend::CPU, false)(device_index);
}
static inline void _cufft_set_plan_cache_max_size(int64_t device_index, int64_t max_size) {
    static auto table = globalATenDispatch().getOpTable("aten::_cufft_set_plan_cache_max_size(int device_index, int max_size) -> void");
    return table->getOp<void (int64_t, int64_t)>(Backend::CPU, false)(device_index, max_size);
}
static inline void _cufft_clear_plan_cache(int64_t device_index) {
    static auto table = globalATenDispatch().getOpTable("aten::_cufft_clear_plan_cache(int device_index) -> void");
    return table->getOp<void (int64_t)>(Backend::CPU, false)(device_index);
}
static inline Tensor index(const Tensor & self, TensorList indices) {
    static auto table = globalATenDispatch().getOpTable("aten::index(Tensor self, Tensor?[] indices) -> Tensor");
    return table->getOp<Tensor (const Tensor &, TensorList)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, indices);
}
static inline Tensor index_copy(const Tensor & self, int64_t dim, const Tensor & index, const Tensor & source) {
    static auto table = globalATenDispatch().getOpTable("aten::index_copy(Tensor self, int dim, Tensor index, Tensor source) -> Tensor");
    return table->getOp<Tensor (const Tensor &, int64_t, const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dim, index, source);
}
static inline Tensor & index_put_(Tensor & self, TensorList indices, const Tensor & values, bool accumulate) {
    static auto table = globalATenDispatch().getOpTable("aten::index_put_(Tensor(a!) self, Tensor?[] indices, Tensor values, bool accumulate=False) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, TensorList, const Tensor &, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, indices, values, accumulate);
}
static inline Tensor index_put(const Tensor & self, TensorList indices, const Tensor & values, bool accumulate) {
    static auto table = globalATenDispatch().getOpTable("aten::index_put(Tensor self, Tensor?[] indices, Tensor values, bool accumulate=False) -> Tensor");
    return table->getOp<Tensor (const Tensor &, TensorList, const Tensor &, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, indices, values, accumulate);
}
static inline Tensor & _index_put_impl_(Tensor & self, TensorList indices, const Tensor & values, bool accumulate, bool unsafe) {
    static auto table = globalATenDispatch().getOpTable("aten::_index_put_impl_(Tensor(a!) self, Tensor?[] indices, Tensor values, bool accumulate=False, bool unsafe=False) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, TensorList, const Tensor &, bool, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, indices, values, accumulate, unsafe);
}
static inline Tensor instance_norm(const Tensor & input, const Tensor & weight, const Tensor & bias, const Tensor & running_mean, const Tensor & running_var, bool use_input_stats, double momentum, double eps, bool cudnn_enabled) {
    static auto table = globalATenDispatch().getOpTable("aten::instance_norm(Tensor input, Tensor? weight, Tensor? bias, Tensor? running_mean, Tensor? running_var, bool use_input_stats, float momentum, float eps, bool cudnn_enabled) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, bool, double, double, bool)>(at::detail::infer_backend(input), at::detail::infer_is_variable(input))(input, weight, bias, running_mean, running_var, use_input_stats, momentum, eps, cudnn_enabled);
}
static inline Tensor inverse(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::inverse(Tensor self) -> Tensor");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & inverse_out(Tensor & out, const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::inverse(Tensor self, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self);
}
static inline Tensor _inverse_helper(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::_inverse_helper(Tensor self) -> Tensor");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor isclose(const Tensor & self, const Tensor & other, double rtol, double atol, bool equal_nan) {
    static auto table = globalATenDispatch().getOpTable("aten::isclose(Tensor self, Tensor other, float rtol=1e-05, float atol=1e-08, bool equal_nan=False) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, double, double, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, other, rtol, atol, equal_nan);
}
static inline Tensor isnan(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::isnan(Tensor self) -> Tensor");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline bool is_distributed(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::is_distributed(Tensor self) -> bool");
    return table->getOp<bool (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline bool is_floating_point(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::is_floating_point(Tensor self) -> bool");
    return table->getOp<bool (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline bool is_complex(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::is_complex(Tensor self) -> bool");
    return table->getOp<bool (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline bool is_nonzero(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::is_nonzero(Tensor self) -> bool");
    return table->getOp<bool (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline bool is_same_size(const Tensor & self, const Tensor & other) {
    static auto table = globalATenDispatch().getOpTable("aten::is_same_size(Tensor self, Tensor other) -> bool");
    return table->getOp<bool (const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, other);
}
static inline bool is_signed(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::is_signed(Tensor self) -> bool");
    return table->getOp<bool (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor kl_div(const Tensor & self, const Tensor & target, int64_t reduction) {
    static auto table = globalATenDispatch().getOpTable("aten::kl_div(Tensor self, Tensor target, int reduction=Mean) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, target, reduction);
}
static inline Tensor kl_div_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) {
    static auto table = globalATenDispatch().getOpTable("aten::kl_div_backward(Tensor grad_output, Tensor self, Tensor target, int reduction=Mean) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_output, self, target, reduction);
}
static inline std::tuple<Tensor,Tensor> kthvalue(const Tensor & self, int64_t k, int64_t dim, bool keepdim) {
    static auto table = globalATenDispatch().getOpTable("aten::kthvalue(Tensor self, int k, int dim=-1, bool keepdim=False) -> (Tensor values, Tensor indices)");
    return table->getOp<std::tuple<Tensor,Tensor> (const Tensor &, int64_t, int64_t, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, k, dim, keepdim);
}
static inline std::tuple<Tensor &,Tensor &> kthvalue_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t k, int64_t dim, bool keepdim) {
    static auto table = globalATenDispatch().getOpTable("aten::kthvalue(Tensor self, int k, int dim=-1, bool keepdim=False, *, Tensor(a!) values, Tensor(b!) indices) -> (Tensor(a!) values, Tensor(b!) indices)");
    return table->getOp<std::tuple<Tensor &,Tensor &> (Tensor &, Tensor &, const Tensor &, int64_t, int64_t, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(values, indices, self, k, dim, keepdim);
}
static inline Tensor layer_norm(const Tensor & input, IntArrayRef normalized_shape, const Tensor & weight, const Tensor & bias, double eps, bool cudnn_enable) {
    static auto table = globalATenDispatch().getOpTable("aten::layer_norm(Tensor input, int[] normalized_shape, Tensor? weight=None, Tensor? bias=None, float eps=1e-05, bool cudnn_enable=True) -> Tensor");
    return table->getOp<Tensor (const Tensor &, IntArrayRef, const Tensor &, const Tensor &, double, bool)>(at::detail::infer_backend(input), at::detail::infer_is_variable(input))(input, normalized_shape, weight, bias, eps, cudnn_enable);
}
static inline std::tuple<Tensor,Tensor,Tensor> native_layer_norm(const Tensor & input, const Tensor & weight, const Tensor & bias, int64_t M, int64_t N, double eps) {
    static auto table = globalATenDispatch().getOpTable("aten::native_layer_norm(Tensor input, Tensor? weight, Tensor? bias, int M, int N, float eps) -> (Tensor, Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor,Tensor> (const Tensor &, const Tensor &, const Tensor &, int64_t, int64_t, double)>(at::detail::infer_backend(input), at::detail::infer_is_variable(input))(input, weight, bias, M, N, eps);
}
static inline std::tuple<Tensor,Tensor,Tensor> native_layer_norm_backward(const Tensor & grad_out, const Tensor & input, const Tensor & mean, const Tensor & rstd, const Tensor & weight, int64_t M, int64_t N, std::array<bool,3> output_mask) {
    static auto table = globalATenDispatch().getOpTable("aten::native_layer_norm_backward(Tensor grad_out, Tensor input, Tensor mean, Tensor rstd, Tensor? weight, int M, int N, bool[3] output_mask) -> (Tensor, Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor,Tensor> (const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, int64_t, int64_t, std::array<bool,3>)>(at::detail::infer_backend(grad_out), at::detail::infer_is_variable(grad_out))(grad_out, input, mean, rstd, weight, M, N, output_mask);
}
static inline std::tuple<Tensor,Tensor,Tensor> native_layer_norm_double_backward(const Tensor & ggI, const Tensor & ggW, const Tensor & ggb, const Tensor & gO, const Tensor & input, const Tensor & mean, const Tensor & rstd, const Tensor & weight, int64_t M, int64_t N, std::array<bool,3> output_mask) {
    static auto table = globalATenDispatch().getOpTable("aten::native_layer_norm_double_backward(Tensor? ggI, Tensor? ggW, Tensor? ggb, Tensor gO, Tensor input, Tensor mean, Tensor rstd, Tensor? weight, int M, int N, bool[3] output_mask) -> (Tensor, Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor,Tensor> (const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, int64_t, int64_t, std::array<bool,3>)>(at::detail::infer_backend(gO), at::detail::infer_is_variable(gO))(ggI, ggW, ggb, gO, input, mean, rstd, weight, M, N, output_mask);
}
static inline Tensor linear(const Tensor & input, const Tensor & weight, const Tensor & bias) {
    static auto table = globalATenDispatch().getOpTable("aten::linear(Tensor input, Tensor weight, Tensor? bias=None) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &)>(at::detail::infer_backend(input), at::detail::infer_is_variable(input))(input, weight, bias);
}
static inline Tensor mkldnn_linear(const Tensor & input, const Tensor & weight, const Tensor & bias) {
    static auto table = globalATenDispatch().getOpTable("aten::mkldnn_linear(Tensor input, Tensor weight, Tensor? bias=None) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &)>(at::detail::infer_backend(input), at::detail::infer_is_variable(input))(input, weight, bias);
}
static inline Tensor fbgemm_linear_int8_weight(const Tensor & input, const Tensor & weight, const Tensor & packed, const Tensor & col_offsets, Scalar weight_scale, Scalar weight_zero_point, const Tensor & bias) {
    static auto table = globalATenDispatch().getOpTable("aten::fbgemm_linear_int8_weight(Tensor input, Tensor weight, Tensor packed, Tensor col_offsets, Scalar weight_scale, Scalar weight_zero_point, Tensor bias) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, const Tensor &, Scalar, Scalar, const Tensor &)>(at::detail::infer_backend(input), at::detail::infer_is_variable(input))(input, weight, packed, col_offsets, weight_scale, weight_zero_point, bias);
}
static inline std::tuple<Tensor,Tensor,double,int64_t> fbgemm_linear_quantize_weight(const Tensor & input) {
    static auto table = globalATenDispatch().getOpTable("aten::fbgemm_linear_quantize_weight(Tensor input) -> (Tensor, Tensor, float, int)");
    return table->getOp<std::tuple<Tensor,Tensor,double,int64_t> (const Tensor &)>(at::detail::infer_backend(input), at::detail::infer_is_variable(input))(input);
}
static inline Tensor fbgemm_pack_gemm_matrix_fp16(const Tensor & input) {
    static auto table = globalATenDispatch().getOpTable("aten::fbgemm_pack_gemm_matrix_fp16(Tensor input) -> Tensor");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(input), at::detail::infer_is_variable(input))(input);
}
static inline Tensor fbgemm_linear_fp16_weight(const Tensor & input, const Tensor & packed_weight, const Tensor & bias) {
    static auto table = globalATenDispatch().getOpTable("aten::fbgemm_linear_fp16_weight(Tensor input, Tensor packed_weight, Tensor bias) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &)>(at::detail::infer_backend(input), at::detail::infer_is_variable(input))(input, packed_weight, bias);
}
static inline Tensor fbgemm_pack_quantized_matrix(const Tensor & input, int64_t K, int64_t N) {
    static auto table = globalATenDispatch().getOpTable("aten::fbgemm_pack_quantized_matrix(Tensor input, int K, int N) -> Tensor");
    return table->getOp<Tensor (const Tensor &, int64_t, int64_t)>(at::detail::infer_backend(input), at::detail::infer_is_variable(input))(input, K, N);
}
static inline bool fbgemm_is_cpu_supported() {
    static auto table = globalATenDispatch().getOpTable("aten::fbgemm_is_cpu_supported() -> bool");
    return table->getOp<bool ()>(Backend::CPU, false)();
}
static inline Tensor linspace(Scalar start, Scalar end, int64_t steps, const TensorOptions & options) {
    globalLegacyTypeDispatch().initForBackend(options.backend());
    static auto table = globalATenDispatch().getOpTable("aten::linspace(Scalar start, Scalar end, int steps=100, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor");
    return table->getOp<Tensor (Scalar, Scalar, int64_t, const TensorOptions &)>(options.backend(), options.is_variable())(start, end, steps, options);
}
static inline Tensor & linspace_out(Tensor & out, Scalar start, Scalar end, int64_t steps) {
    static auto table = globalATenDispatch().getOpTable("aten::linspace(Scalar start, Scalar end, int steps=100, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, Scalar, Scalar, int64_t)>(at::detail::infer_backend(out), at::detail::infer_is_variable(out))(out, start, end, steps);
}
static inline Tensor log(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::log(Tensor self) -> Tensor");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & log_(Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::log_(Tensor(a!) self) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & log_out(Tensor & out, const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::log(Tensor self, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self);
}
static inline Tensor log10(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::log10(Tensor self) -> Tensor");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & log10_(Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::log10_(Tensor(a!) self) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & log10_out(Tensor & out, const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::log10(Tensor self, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self);
}
static inline Tensor log1p(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::log1p(Tensor self) -> Tensor");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & log1p_(Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::log1p_(Tensor(a!) self) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & log1p_out(Tensor & out, const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::log1p(Tensor self, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self);
}
static inline Tensor log2(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::log2(Tensor self) -> Tensor");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & log2_(Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::log2_(Tensor(a!) self) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & log2_out(Tensor & out, const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::log2(Tensor self, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self);
}
static inline Tensor logdet(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::logdet(Tensor self) -> Tensor");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor logspace(Scalar start, Scalar end, int64_t steps, double base, const TensorOptions & options) {
    globalLegacyTypeDispatch().initForBackend(options.backend());
    static auto table = globalATenDispatch().getOpTable("aten::logspace(Scalar start, Scalar end, int steps=100, float base=10.0, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor");
    return table->getOp<Tensor (Scalar, Scalar, int64_t, double, const TensorOptions &)>(options.backend(), options.is_variable())(start, end, steps, base, options);
}
static inline Tensor & logspace_out(Tensor & out, Scalar start, Scalar end, int64_t steps, double base) {
    static auto table = globalATenDispatch().getOpTable("aten::logspace(Scalar start, Scalar end, int steps=100, float base=10.0, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, Scalar, Scalar, int64_t, double)>(at::detail::infer_backend(out), at::detail::infer_is_variable(out))(out, start, end, steps, base);
}
static inline Tensor log_softmax(const Tensor & self, int64_t dim, c10::optional<ScalarType> dtype) {
    static auto table = globalATenDispatch().getOpTable("aten::log_softmax(Tensor self, int dim, ScalarType? dtype=None) -> Tensor");
    return table->getOp<Tensor (const Tensor &, int64_t, c10::optional<ScalarType>)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dim, dtype);
}
static inline Tensor _log_softmax(const Tensor & self, int64_t dim, bool half_to_float) {
    static auto table = globalATenDispatch().getOpTable("aten::_log_softmax(Tensor self, int dim, bool half_to_float) -> Tensor");
    return table->getOp<Tensor (const Tensor &, int64_t, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dim, half_to_float);
}
static inline Tensor _log_softmax_backward_data(const Tensor & grad_output, const Tensor & output, int64_t dim, const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::_log_softmax_backward_data(Tensor grad_output, Tensor output, int dim, Tensor self) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, int64_t, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_output, output, dim, self);
}
static inline Tensor logsumexp(const Tensor & self, IntArrayRef dim, bool keepdim) {
    static auto table = globalATenDispatch().getOpTable("aten::logsumexp(Tensor self, int[1] dim, bool keepdim=False) -> Tensor");
    return table->getOp<Tensor (const Tensor &, IntArrayRef, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dim, keepdim);
}
static inline Tensor & logsumexp_out(Tensor & out, const Tensor & self, IntArrayRef dim, bool keepdim) {
    static auto table = globalATenDispatch().getOpTable("aten::logsumexp(Tensor self, int[1] dim, bool keepdim=False, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, IntArrayRef, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, dim, keepdim);
}
static inline Tensor margin_ranking_loss(const Tensor & input1, const Tensor & input2, const Tensor & target, double margin, int64_t reduction) {
    static auto table = globalATenDispatch().getOpTable("aten::margin_ranking_loss(Tensor input1, Tensor input2, Tensor target, float margin=0.0, int reduction=Mean) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, double, int64_t)>(at::detail::infer_backend(input1), at::detail::infer_is_variable(input1))(input1, input2, target, margin, reduction);
}
static inline Tensor matmul(const Tensor & self, const Tensor & other) {
    static auto table = globalATenDispatch().getOpTable("aten::matmul(Tensor self, Tensor other) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, other);
}
static inline Tensor & matmul_out(Tensor & out, const Tensor & self, const Tensor & other) {
    static auto table = globalATenDispatch().getOpTable("aten::matmul(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, other);
}
static inline Tensor matrix_rank(const Tensor & self, double tol, bool symmetric) {
    static auto table = globalATenDispatch().getOpTable("aten::matrix_rank(Tensor self, float tol, bool symmetric=False) -> Tensor");
    return table->getOp<Tensor (const Tensor &, double, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, tol, symmetric);
}
static inline Tensor matrix_rank(const Tensor & self, bool symmetric) {
    static auto table = globalATenDispatch().getOpTable("aten::matrix_rank(Tensor self, bool symmetric=False) -> Tensor");
    return table->getOp<Tensor (const Tensor &, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, symmetric);
}
static inline Tensor matrix_power(const Tensor & self, int64_t n) {
    static auto table = globalATenDispatch().getOpTable("aten::matrix_power(Tensor self, int n) -> Tensor");
    return table->getOp<Tensor (const Tensor &, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, n);
}
static inline std::tuple<Tensor,Tensor> max(const Tensor & self, int64_t dim, bool keepdim) {
    static auto table = globalATenDispatch().getOpTable("aten::max(Tensor self, int dim, bool keepdim=False) -> (Tensor values, Tensor indices)");
    return table->getOp<std::tuple<Tensor,Tensor> (const Tensor &, int64_t, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dim, keepdim);
}
static inline std::tuple<Tensor &,Tensor &> max_out(Tensor & max, Tensor & max_values, const Tensor & self, int64_t dim, bool keepdim) {
    static auto table = globalATenDispatch().getOpTable("aten::max(Tensor self, int dim, bool keepdim=False, *, Tensor(a!) max, Tensor(b!) max_values) -> (Tensor(a!) values, Tensor(b!) indices)");
    return table->getOp<std::tuple<Tensor &,Tensor &> (Tensor &, Tensor &, const Tensor &, int64_t, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(max, max_values, self, dim, keepdim);
}
static inline Tensor max_values(const Tensor & self, IntArrayRef dim, bool keepdim) {
    static auto table = globalATenDispatch().getOpTable("aten::max_values(Tensor self, int[1] dim, bool keepdim=False) -> Tensor");
    return table->getOp<Tensor (const Tensor &, IntArrayRef, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dim, keepdim);
}
static inline std::tuple<Tensor,Tensor> max_pool1d_with_indices(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode) {
    static auto table = globalATenDispatch().getOpTable("aten::max_pool1d_with_indices(Tensor self, int[1] kernel_size, int[1] stride=[], int[1] padding=0, int[1] dilation=1, bool ceil_mode=False) -> (Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor> (const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, IntArrayRef, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, kernel_size, stride, padding, dilation, ceil_mode);
}
static inline Tensor max_pool1d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode) {
    static auto table = globalATenDispatch().getOpTable("aten::max_pool1d(Tensor self, int[1] kernel_size, int[1] stride=[], int[1] padding=0, int[1] dilation=1, bool ceil_mode=False) -> Tensor");
    return table->getOp<Tensor (const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, IntArrayRef, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, kernel_size, stride, padding, dilation, ceil_mode);
}
static inline Tensor max_pool2d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode) {
    static auto table = globalATenDispatch().getOpTable("aten::max_pool2d(Tensor self, int[2] kernel_size, int[2] stride=[], int[2] padding=0, int[2] dilation=1, bool ceil_mode=False) -> Tensor");
    return table->getOp<Tensor (const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, IntArrayRef, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, kernel_size, stride, padding, dilation, ceil_mode);
}
static inline Tensor mkldnn_max_pool2d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode) {
    static auto table = globalATenDispatch().getOpTable("aten::mkldnn_max_pool2d(Tensor self, int[2] kernel_size, int[2] stride=[], int[2] padding=0, int[2] dilation=1, bool ceil_mode=False) -> Tensor");
    return table->getOp<Tensor (const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, IntArrayRef, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, kernel_size, stride, padding, dilation, ceil_mode);
}
static inline Tensor quantized_max_pool2d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation) {
    static auto table = globalATenDispatch().getOpTable("aten::quantized_max_pool2d(Tensor self, int[2] kernel_size, int[2] stride=[], int[2] padding=0, int[2] dilation=1) -> Tensor");
    return table->getOp<Tensor (const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, kernel_size, stride, padding, dilation);
}
static inline Tensor max_pool3d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode) {
    static auto table = globalATenDispatch().getOpTable("aten::max_pool3d(Tensor self, int[3] kernel_size, int[3] stride=[], int[3] padding=0, int[3] dilation=1, bool ceil_mode=False) -> Tensor");
    return table->getOp<Tensor (const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, IntArrayRef, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, kernel_size, stride, padding, dilation, ceil_mode);
}
static inline Tensor mean(const Tensor & self, c10::optional<ScalarType> dtype) {
    static auto table = globalATenDispatch().getOpTable("aten::mean(Tensor self, *, ScalarType? dtype=None) -> Tensor");
    return table->getOp<Tensor (const Tensor &, c10::optional<ScalarType>)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dtype);
}
static inline Tensor mean(const Tensor & self, IntArrayRef dim, bool keepdim, c10::optional<ScalarType> dtype) {
    static auto table = globalATenDispatch().getOpTable("aten::mean(Tensor self, int[1] dim, bool keepdim=False, *, ScalarType? dtype=None) -> Tensor");
    return table->getOp<Tensor (const Tensor &, IntArrayRef, bool, c10::optional<ScalarType>)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dim, keepdim, dtype);
}
static inline Tensor & mean_out(Tensor & out, const Tensor & self, IntArrayRef dim, bool keepdim, c10::optional<ScalarType> dtype) {
    static auto table = globalATenDispatch().getOpTable("aten::mean(Tensor self, int[1] dim, bool keepdim=False, *, ScalarType? dtype=None, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, IntArrayRef, bool, c10::optional<ScalarType>)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, dim, keepdim, dtype);
}
static inline std::tuple<Tensor,Tensor> median(const Tensor & self, int64_t dim, bool keepdim) {
    static auto table = globalATenDispatch().getOpTable("aten::median(Tensor self, int dim, bool keepdim=False) -> (Tensor values, Tensor indices)");
    return table->getOp<std::tuple<Tensor,Tensor> (const Tensor &, int64_t, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dim, keepdim);
}
static inline std::tuple<Tensor &,Tensor &> median_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t dim, bool keepdim) {
    static auto table = globalATenDispatch().getOpTable("aten::median(Tensor self, int dim, bool keepdim=False, *, Tensor(a!) values, Tensor(b!) indices) -> (Tensor(a!) values, Tensor(b!) indices)");
    return table->getOp<std::tuple<Tensor &,Tensor &> (Tensor &, Tensor &, const Tensor &, int64_t, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(values, indices, self, dim, keepdim);
}
static inline std::tuple<Tensor,Tensor> min(const Tensor & self, int64_t dim, bool keepdim) {
    static auto table = globalATenDispatch().getOpTable("aten::min(Tensor self, int dim, bool keepdim=False) -> (Tensor values, Tensor indices)");
    return table->getOp<std::tuple<Tensor,Tensor> (const Tensor &, int64_t, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dim, keepdim);
}
static inline std::tuple<Tensor &,Tensor &> min_out(Tensor & min, Tensor & min_indices, const Tensor & self, int64_t dim, bool keepdim) {
    static auto table = globalATenDispatch().getOpTable("aten::min(Tensor self, int dim, bool keepdim=False, *, Tensor(a!) min, Tensor(b!) min_indices) -> (Tensor(a!) values, Tensor(b!) indices)");
    return table->getOp<std::tuple<Tensor &,Tensor &> (Tensor &, Tensor &, const Tensor &, int64_t, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(min, min_indices, self, dim, keepdim);
}
static inline Tensor min_values(const Tensor & self, IntArrayRef dim, bool keepdim) {
    static auto table = globalATenDispatch().getOpTable("aten::min_values(Tensor self, int[1] dim, bool keepdim=False) -> Tensor");
    return table->getOp<Tensor (const Tensor &, IntArrayRef, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dim, keepdim);
}
static inline Tensor mkldnn_convolution(const Tensor & self, const Tensor & weight, const Tensor & bias, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups) {
    static auto table = globalATenDispatch().getOpTable("aten::mkldnn_convolution(Tensor self, Tensor weight, Tensor? bias, int[] padding, int[] stride, int[] dilation, int groups) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, weight, bias, padding, stride, dilation, groups);
}
static inline Tensor mkldnn_convolution_backward_input(IntArrayRef self_size, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool bias_defined) {
    static auto table = globalATenDispatch().getOpTable("aten::mkldnn_convolution_backward_input(int[] self_size, Tensor grad_output, Tensor weight, int[] padding, int[] stride, int[] dilation, int groups, bool bias_defined) -> Tensor");
    return table->getOp<Tensor (IntArrayRef, const Tensor &, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, int64_t, bool)>(at::detail::infer_backend(grad_output), at::detail::infer_is_variable(grad_output))(self_size, grad_output, weight, padding, stride, dilation, groups, bias_defined);
}
static inline std::tuple<Tensor,Tensor> mkldnn_convolution_backward_weights(IntArrayRef weight_size, const Tensor & grad_output, const Tensor & self, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool bias_defined) {
    static auto table = globalATenDispatch().getOpTable("aten::mkldnn_convolution_backward_weights(int[] weight_size, Tensor grad_output, Tensor self, int[] padding, int[] stride, int[] dilation, int groups, bool bias_defined) -> (Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor> (IntArrayRef, const Tensor &, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, int64_t, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(weight_size, grad_output, self, padding, stride, dilation, groups, bias_defined);
}
static inline std::tuple<Tensor,Tensor,Tensor> mkldnn_convolution_backward(const Tensor & self, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, std::array<bool,3> output_mask) {
    static auto table = globalATenDispatch().getOpTable("aten::mkldnn_convolution_backward(Tensor self, Tensor grad_output, Tensor weight, int[] padding, int[] stride, int[] dilation, int groups, bool[3] output_mask) -> (Tensor, Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor,Tensor> (const Tensor &, const Tensor &, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, int64_t, std::array<bool,3>)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, grad_output, weight, padding, stride, dilation, groups, output_mask);
}
static inline std::tuple<Tensor,Tensor,Tensor> miopen_batch_norm(const Tensor & input, const Tensor & weight, const Tensor & bias, const Tensor & running_mean, const Tensor & running_var, bool training, double exponential_average_factor, double epsilon) {
    static auto table = globalATenDispatch().getOpTable("aten::miopen_batch_norm(Tensor input, Tensor weight, Tensor? bias, Tensor? running_mean, Tensor? running_var, bool training, float exponential_average_factor, float epsilon) -> (Tensor, Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor,Tensor> (const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, bool, double, double)>(at::detail::infer_backend(input), at::detail::infer_is_variable(input))(input, weight, bias, running_mean, running_var, training, exponential_average_factor, epsilon);
}
static inline std::tuple<Tensor,Tensor,Tensor> miopen_batch_norm_backward(const Tensor & input, const Tensor & grad_output, const Tensor & weight, const Tensor & running_mean, const Tensor & running_var, const Tensor & save_mean, const Tensor & save_var, double epsilon) {
    static auto table = globalATenDispatch().getOpTable("aten::miopen_batch_norm_backward(Tensor input, Tensor grad_output, Tensor weight, Tensor? running_mean, Tensor? running_var, Tensor? save_mean, Tensor? save_var, float epsilon) -> (Tensor, Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor,Tensor> (const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, double)>(at::detail::infer_backend(input), at::detail::infer_is_variable(input))(input, grad_output, weight, running_mean, running_var, save_mean, save_var, epsilon);
}
static inline Tensor miopen_convolution(const Tensor & self, const Tensor & weight, const Tensor & bias, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic) {
    static auto table = globalATenDispatch().getOpTable("aten::miopen_convolution(Tensor self, Tensor weight, Tensor? bias, int[] padding, int[] stride, int[] dilation, int groups, bool benchmark, bool deterministic) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, int64_t, bool, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, weight, bias, padding, stride, dilation, groups, benchmark, deterministic);
}
static inline Tensor miopen_convolution_backward_input(IntArrayRef self_size, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic) {
    static auto table = globalATenDispatch().getOpTable("aten::miopen_convolution_backward_input(int[] self_size, Tensor grad_output, Tensor weight, int[] padding, int[] stride, int[] dilation, int groups, bool benchmark, bool deterministic) -> Tensor");
    return table->getOp<Tensor (IntArrayRef, const Tensor &, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, int64_t, bool, bool)>(at::detail::infer_backend(grad_output), at::detail::infer_is_variable(grad_output))(self_size, grad_output, weight, padding, stride, dilation, groups, benchmark, deterministic);
}
static inline std::tuple<Tensor,Tensor,Tensor> miopen_convolution_backward(const Tensor & self, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic, std::array<bool,3> output_mask) {
    static auto table = globalATenDispatch().getOpTable("aten::miopen_convolution_backward(Tensor self, Tensor grad_output, Tensor weight, int[] padding, int[] stride, int[] dilation, int groups, bool benchmark, bool deterministic, bool[3] output_mask) -> (Tensor, Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor,Tensor> (const Tensor &, const Tensor &, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, int64_t, bool, bool, std::array<bool,3>)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, grad_output, weight, padding, stride, dilation, groups, benchmark, deterministic, output_mask);
}
static inline Tensor miopen_convolution_backward_bias(const Tensor & grad_output) {
    static auto table = globalATenDispatch().getOpTable("aten::miopen_convolution_backward_bias(Tensor grad_output) -> Tensor");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(grad_output), at::detail::infer_is_variable(grad_output))(grad_output);
}
static inline Tensor miopen_convolution_backward_weight(IntArrayRef weight_size, const Tensor & grad_output, const Tensor & self, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic) {
    static auto table = globalATenDispatch().getOpTable("aten::miopen_convolution_backward_weight(int[] weight_size, Tensor grad_output, Tensor self, int[] padding, int[] stride, int[] dilation, int groups, bool benchmark, bool deterministic) -> Tensor");
    return table->getOp<Tensor (IntArrayRef, const Tensor &, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, int64_t, bool, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(weight_size, grad_output, self, padding, stride, dilation, groups, benchmark, deterministic);
}
static inline Tensor miopen_convolution_transpose(const Tensor & self, const Tensor & weight, const Tensor & bias, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic) {
    static auto table = globalATenDispatch().getOpTable("aten::miopen_convolution_transpose(Tensor self, Tensor weight, Tensor? bias, int[] padding, int[] output_padding, int[] stride, int[] dilation, int groups, bool benchmark, bool deterministic) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, IntArrayRef, int64_t, bool, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, weight, bias, padding, output_padding, stride, dilation, groups, benchmark, deterministic);
}
static inline std::tuple<Tensor,Tensor,Tensor> miopen_convolution_transpose_backward(const Tensor & self, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic, std::array<bool,3> output_mask) {
    static auto table = globalATenDispatch().getOpTable("aten::miopen_convolution_transpose_backward(Tensor self, Tensor grad_output, Tensor weight, int[] padding, int[] output_padding, int[] stride, int[] dilation, int groups, bool benchmark, bool deterministic, bool[3] output_mask) -> (Tensor, Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor,Tensor> (const Tensor &, const Tensor &, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, IntArrayRef, int64_t, bool, bool, std::array<bool,3>)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, grad_output, weight, padding, output_padding, stride, dilation, groups, benchmark, deterministic, output_mask);
}
static inline Tensor miopen_convolution_transpose_backward_input(const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic) {
    static auto table = globalATenDispatch().getOpTable("aten::miopen_convolution_transpose_backward_input(Tensor grad_output, Tensor weight, int[] padding, int[] stride, int[] dilation, int groups, bool benchmark, bool deterministic) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, int64_t, bool, bool)>(at::detail::infer_backend(grad_output), at::detail::infer_is_variable(grad_output))(grad_output, weight, padding, stride, dilation, groups, benchmark, deterministic);
}
static inline Tensor miopen_convolution_transpose_backward_weight(IntArrayRef weight_size, const Tensor & grad_output, const Tensor & self, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic) {
    static auto table = globalATenDispatch().getOpTable("aten::miopen_convolution_transpose_backward_weight(int[] weight_size, Tensor grad_output, Tensor self, int[] padding, int[] stride, int[] dilation, int groups, bool benchmark, bool deterministic) -> Tensor");
    return table->getOp<Tensor (IntArrayRef, const Tensor &, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, int64_t, bool, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(weight_size, grad_output, self, padding, stride, dilation, groups, benchmark, deterministic);
}
static inline Tensor miopen_depthwise_convolution(const Tensor & self, const Tensor & weight, const Tensor & bias, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic) {
    static auto table = globalATenDispatch().getOpTable("aten::miopen_depthwise_convolution(Tensor self, Tensor weight, Tensor? bias, int[] padding, int[] stride, int[] dilation, int groups, bool benchmark, bool deterministic) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, int64_t, bool, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, weight, bias, padding, stride, dilation, groups, benchmark, deterministic);
}
static inline Tensor miopen_depthwise_convolution_backward_input(IntArrayRef self_size, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic) {
    static auto table = globalATenDispatch().getOpTable("aten::miopen_depthwise_convolution_backward_input(int[] self_size, Tensor grad_output, Tensor weight, int[] padding, int[] stride, int[] dilation, int groups, bool benchmark, bool deterministic) -> Tensor");
    return table->getOp<Tensor (IntArrayRef, const Tensor &, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, int64_t, bool, bool)>(at::detail::infer_backend(grad_output), at::detail::infer_is_variable(grad_output))(self_size, grad_output, weight, padding, stride, dilation, groups, benchmark, deterministic);
}
static inline std::tuple<Tensor,Tensor,Tensor> miopen_depthwise_convolution_backward(const Tensor & self, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic, std::array<bool,3> output_mask) {
    static auto table = globalATenDispatch().getOpTable("aten::miopen_depthwise_convolution_backward(Tensor self, Tensor grad_output, Tensor weight, int[] padding, int[] stride, int[] dilation, int groups, bool benchmark, bool deterministic, bool[3] output_mask) -> (Tensor, Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor,Tensor> (const Tensor &, const Tensor &, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, int64_t, bool, bool, std::array<bool,3>)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, grad_output, weight, padding, stride, dilation, groups, benchmark, deterministic, output_mask);
}
static inline Tensor miopen_depthwise_convolution_backward_weight(IntArrayRef weight_size, const Tensor & grad_output, const Tensor & self, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic) {
    static auto table = globalATenDispatch().getOpTable("aten::miopen_depthwise_convolution_backward_weight(int[] weight_size, Tensor grad_output, Tensor self, int[] padding, int[] stride, int[] dilation, int groups, bool benchmark, bool deterministic) -> Tensor");
    return table->getOp<Tensor (IntArrayRef, const Tensor &, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, int64_t, bool, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(weight_size, grad_output, self, padding, stride, dilation, groups, benchmark, deterministic);
}
static inline std::tuple<Tensor,Tensor,Tensor,Tensor,Tensor> miopen_rnn(const Tensor & input, TensorList weight, int64_t weight_stride0, const Tensor & hx, const Tensor & cx, int64_t mode, int64_t hidden_size, int64_t num_layers, bool batch_first, double dropout, bool train, bool bidirectional, IntArrayRef batch_sizes, const Tensor & dropout_state) {
    static auto table = globalATenDispatch().getOpTable("aten::miopen_rnn(Tensor input, Tensor[] weight, int weight_stride0, Tensor hx, Tensor? cx, int mode, int hidden_size, int num_layers, bool batch_first, float dropout, bool train, bool bidirectional, int[] batch_sizes, Tensor? dropout_state) -> (Tensor, Tensor, Tensor, Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor,Tensor,Tensor,Tensor> (const Tensor &, TensorList, int64_t, const Tensor &, const Tensor &, int64_t, int64_t, int64_t, bool, double, bool, bool, IntArrayRef, const Tensor &)>(at::detail::infer_backend(input), at::detail::infer_is_variable(input))(input, weight, weight_stride0, hx, cx, mode, hidden_size, num_layers, batch_first, dropout, train, bidirectional, batch_sizes, dropout_state);
}
static inline std::tuple<Tensor,Tensor,Tensor,std::vector<Tensor>> miopen_rnn_backward(const Tensor & input, TensorList weight, int64_t weight_stride0, const Tensor & weight_buf, const Tensor & hx, const Tensor & cx, const Tensor & output, const Tensor & grad_output, const Tensor & grad_hy, const Tensor & grad_cy, int64_t mode, int64_t hidden_size, int64_t num_layers, bool batch_first, double dropout, bool train, bool bidirectional, IntArrayRef batch_sizes, const Tensor & dropout_state, const Tensor & reserve, std::array<bool,4> output_mask) {
    static auto table = globalATenDispatch().getOpTable("aten::miopen_rnn_backward(Tensor input, Tensor[] weight, int weight_stride0, Tensor weight_buf, Tensor hx, Tensor? cx, Tensor output, Tensor? grad_output, Tensor? grad_hy, Tensor? grad_cy, int mode, int hidden_size, int num_layers, bool batch_first, float dropout, bool train, bool bidirectional, int[] batch_sizes, Tensor? dropout_state, Tensor reserve, bool[4] output_mask) -> (Tensor, Tensor, Tensor, Tensor[])");
    return table->getOp<std::tuple<Tensor,Tensor,Tensor,std::vector<Tensor>> (const Tensor &, TensorList, int64_t, const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, int64_t, int64_t, int64_t, bool, double, bool, bool, IntArrayRef, const Tensor &, const Tensor &, std::array<bool,4>)>(at::detail::infer_backend(input), at::detail::infer_is_variable(input))(input, weight, weight_stride0, weight_buf, hx, cx, output, grad_output, grad_hy, grad_cy, mode, hidden_size, num_layers, batch_first, dropout, train, bidirectional, batch_sizes, dropout_state, reserve, output_mask);
}
static inline Tensor mm(const Tensor & self, const Tensor & mat2) {
    static auto table = globalATenDispatch().getOpTable("aten::mm(Tensor self, Tensor mat2) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, mat2);
}
static inline Tensor & mm_out(Tensor & out, const Tensor & self, const Tensor & mat2) {
    static auto table = globalATenDispatch().getOpTable("aten::mm(Tensor self, Tensor mat2, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, mat2);
}
static inline Tensor _sparse_mm(const Tensor & sparse, const Tensor & dense) {
    static auto table = globalATenDispatch().getOpTable("aten::_sparse_mm(Tensor sparse, Tensor dense) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &)>(at::detail::infer_backend(sparse), at::detail::infer_is_variable(sparse))(sparse, dense);
}
static inline std::tuple<Tensor,Tensor> mode(const Tensor & self, int64_t dim, bool keepdim) {
    static auto table = globalATenDispatch().getOpTable("aten::mode(Tensor self, int dim=-1, bool keepdim=False) -> (Tensor values, Tensor indices)");
    return table->getOp<std::tuple<Tensor,Tensor> (const Tensor &, int64_t, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dim, keepdim);
}
static inline std::tuple<Tensor &,Tensor &> mode_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t dim, bool keepdim) {
    static auto table = globalATenDispatch().getOpTable("aten::mode(Tensor self, int dim=-1, bool keepdim=False, *, Tensor(a!) values, Tensor(b!) indices) -> (Tensor(a!) values, Tensor(b!) indices)");
    return table->getOp<std::tuple<Tensor &,Tensor &> (Tensor &, Tensor &, const Tensor &, int64_t, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(values, indices, self, dim, keepdim);
}
static inline Tensor mul(const Tensor & self, const Tensor & other) {
    static auto table = globalATenDispatch().getOpTable("aten::mul(Tensor self, Tensor other) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, other);
}
static inline Tensor & mul_out(Tensor & out, const Tensor & self, const Tensor & other) {
    static auto table = globalATenDispatch().getOpTable("aten::mul(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, other);
}
static inline Tensor mul(const Tensor & self, Scalar other) {
    static auto table = globalATenDispatch().getOpTable("aten::mul(Tensor self, Scalar other) -> Tensor");
    return table->getOp<Tensor (const Tensor &, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, other);
}
static inline Tensor mv(const Tensor & self, const Tensor & vec) {
    static auto table = globalATenDispatch().getOpTable("aten::mv(Tensor self, Tensor vec) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, vec);
}
static inline Tensor & mv_out(Tensor & out, const Tensor & self, const Tensor & vec) {
    static auto table = globalATenDispatch().getOpTable("aten::mv(Tensor self, Tensor vec, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, vec);
}
static inline Tensor mvlgamma(const Tensor & self, int64_t p) {
    static auto table = globalATenDispatch().getOpTable("aten::mvlgamma(Tensor self, int p) -> Tensor");
    return table->getOp<Tensor (const Tensor &, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, p);
}
static inline Tensor narrow(const Tensor & self, int64_t dim, int64_t start, int64_t length) {
    static auto table = globalATenDispatch().getOpTable("aten::narrow(Tensor(a) self, int dim, int start, int length) -> Tensor(a)");
    return table->getOp<Tensor (const Tensor &, int64_t, int64_t, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dim, start, length);
}
static inline std::tuple<Tensor,Tensor,Tensor> native_batch_norm(const Tensor & input, const Tensor & weight, const Tensor & bias, const Tensor & running_mean, const Tensor & running_var, bool training, double momentum, double eps) {
    static auto table = globalATenDispatch().getOpTable("aten::native_batch_norm(Tensor input, Tensor? weight, Tensor? bias, Tensor? running_mean, Tensor? running_var, bool training, float momentum, float eps) -> (Tensor, Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor,Tensor> (const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, bool, double, double)>(at::detail::infer_backend(input), at::detail::infer_is_variable(input))(input, weight, bias, running_mean, running_var, training, momentum, eps);
}
static inline std::tuple<Tensor,Tensor> batch_norm_stats(const Tensor & input, double eps) {
    static auto table = globalATenDispatch().getOpTable("aten::batch_norm_stats(Tensor input, float eps) -> (Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor> (const Tensor &, double)>(at::detail::infer_backend(input), at::detail::infer_is_variable(input))(input, eps);
}
static inline Tensor batch_norm_elemt(const Tensor & input, const Tensor & weight, const Tensor & bias, const Tensor & mean, const Tensor & invstd, double eps) {
    static auto table = globalATenDispatch().getOpTable("aten::batch_norm_elemt(Tensor input, Tensor? weight, Tensor? bias, Tensor mean, Tensor invstd, float eps) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, double)>(at::detail::infer_backend(input), at::detail::infer_is_variable(input))(input, weight, bias, mean, invstd, eps);
}
static inline std::tuple<Tensor,Tensor> batch_norm_gather_stats(const Tensor & input, const Tensor & mean, const Tensor & invstd, const Tensor & running_mean, const Tensor & running_var, double momentum, double eps, int64_t count) {
    static auto table = globalATenDispatch().getOpTable("aten::batch_norm_gather_stats(Tensor input, Tensor mean, Tensor invstd, Tensor? running_mean, Tensor? running_var, float momentum, float eps, int count) -> (Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor> (const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, double, double, int64_t)>(at::detail::infer_backend(input), at::detail::infer_is_variable(input))(input, mean, invstd, running_mean, running_var, momentum, eps, count);
}
static inline std::tuple<Tensor,Tensor> batch_norm_gather_stats_with_counts(const Tensor & input, const Tensor & mean, const Tensor & invstd, const Tensor & running_mean, const Tensor & running_var, double momentum, double eps, IntArrayRef counts) {
    static auto table = globalATenDispatch().getOpTable("aten::batch_norm_gather_stats_with_counts(Tensor input, Tensor mean, Tensor invstd, Tensor? running_mean, Tensor? running_var, float momentum, float eps, int[] counts) -> (Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor> (const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, double, double, IntArrayRef)>(at::detail::infer_backend(input), at::detail::infer_is_variable(input))(input, mean, invstd, running_mean, running_var, momentum, eps, counts);
}
static inline std::tuple<Tensor,Tensor,Tensor> native_batch_norm_backward(const Tensor & grad_out, const Tensor & input, const Tensor & weight, const Tensor & running_mean, const Tensor & running_var, const Tensor & save_mean, const Tensor & save_invstd, bool train, double eps, std::array<bool,3> output_mask) {
    static auto table = globalATenDispatch().getOpTable("aten::native_batch_norm_backward(Tensor grad_out, Tensor input, Tensor? weight, Tensor? running_mean, Tensor? running_var, Tensor? save_mean, Tensor? save_invstd, bool train, float eps, bool[3] output_mask) -> (Tensor, Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor,Tensor> (const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, bool, double, std::array<bool,3>)>(at::detail::infer_backend(grad_out), at::detail::infer_is_variable(grad_out))(grad_out, input, weight, running_mean, running_var, save_mean, save_invstd, train, eps, output_mask);
}
static inline std::tuple<Tensor,Tensor,Tensor,Tensor> batch_norm_backward_reduce(const Tensor & grad_out, const Tensor & input, const Tensor & mean, const Tensor & invstd, bool input_g, bool weight_g, bool bias_g) {
    static auto table = globalATenDispatch().getOpTable("aten::batch_norm_backward_reduce(Tensor grad_out, Tensor input, Tensor mean, Tensor invstd, bool input_g, bool weight_g, bool bias_g) -> (Tensor, Tensor, Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor,Tensor,Tensor> (const Tensor &, const Tensor &, const Tensor &, const Tensor &, bool, bool, bool)>(at::detail::infer_backend(grad_out), at::detail::infer_is_variable(grad_out))(grad_out, input, mean, invstd, input_g, weight_g, bias_g);
}
static inline Tensor batch_norm_backward_elemt(const Tensor & grad_out, const Tensor & input, const Tensor & mean, const Tensor & invstd, const Tensor & weight, const Tensor & mean_dy, const Tensor & mean_dy_xmu) {
    static auto table = globalATenDispatch().getOpTable("aten::batch_norm_backward_elemt(Tensor grad_out, Tensor input, Tensor mean, Tensor invstd, Tensor? weight, Tensor mean_dy, Tensor mean_dy_xmu) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &)>(at::detail::infer_backend(grad_out), at::detail::infer_is_variable(grad_out))(grad_out, input, mean, invstd, weight, mean_dy, mean_dy_xmu);
}
static inline std::tuple<Tensor,Tensor> batch_norm_update_stats(const Tensor & input, const Tensor & running_mean, const Tensor & running_var, double momentum) {
    static auto table = globalATenDispatch().getOpTable("aten::batch_norm_update_stats(Tensor input, Tensor? running_mean, Tensor? running_var, float momentum) -> (Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor> (const Tensor &, const Tensor &, const Tensor &, double)>(at::detail::infer_backend(input), at::detail::infer_is_variable(input))(input, running_mean, running_var, momentum);
}
static inline bool _nnpack_available() {
    static auto table = globalATenDispatch().getOpTable("aten::_nnpack_available() -> bool");
    return table->getOp<bool ()>(Backend::CPU, false)();
}
static inline Tensor _nnpack_spatial_convolution(const Tensor & input, const Tensor & weight, const Tensor & bias, IntArrayRef padding) {
    static auto table = globalATenDispatch().getOpTable("aten::_nnpack_spatial_convolution(Tensor input, Tensor weight, Tensor? bias, int[2] padding) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, IntArrayRef)>(at::detail::infer_backend(input), at::detail::infer_is_variable(input))(input, weight, bias, padding);
}
static inline std::tuple<Tensor,Tensor,Tensor> _nnpack_spatial_convolution_backward(const Tensor & input, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, std::array<bool,3> output_mask) {
    static auto table = globalATenDispatch().getOpTable("aten::_nnpack_spatial_convolution_backward(Tensor input, Tensor grad_output, Tensor weight, int[2] padding, bool[3] output_mask) -> (Tensor, Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor,Tensor> (const Tensor &, const Tensor &, const Tensor &, IntArrayRef, std::array<bool,3>)>(at::detail::infer_backend(input), at::detail::infer_is_variable(input))(input, grad_output, weight, padding, output_mask);
}
static inline Tensor _nnpack_spatial_convolution_backward_input(const Tensor & input, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding) {
    static auto table = globalATenDispatch().getOpTable("aten::_nnpack_spatial_convolution_backward_input(Tensor input, Tensor grad_output, Tensor weight, int[2] padding) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, IntArrayRef)>(at::detail::infer_backend(input), at::detail::infer_is_variable(input))(input, grad_output, weight, padding);
}
static inline Tensor _nnpack_spatial_convolution_backward_weight(const Tensor & input, IntArrayRef weightsize, const Tensor & grad_output, IntArrayRef padding) {
    static auto table = globalATenDispatch().getOpTable("aten::_nnpack_spatial_convolution_backward_weight(Tensor input, int[] weightsize, Tensor grad_output, int[2] padding) -> Tensor");
    return table->getOp<Tensor (const Tensor &, IntArrayRef, const Tensor &, IntArrayRef)>(at::detail::infer_backend(input), at::detail::infer_is_variable(input))(input, weightsize, grad_output, padding);
}
static inline Tensor ones(IntArrayRef size, const TensorOptions & options) {
    globalLegacyTypeDispatch().initForBackend(options.backend());
    static auto table = globalATenDispatch().getOpTable("aten::ones(int[] size, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor");
    return table->getOp<Tensor (IntArrayRef, const TensorOptions &)>(options.backend(), options.is_variable())(size, options);
}
static inline Tensor & ones_out(Tensor & out, IntArrayRef size) {
    static auto table = globalATenDispatch().getOpTable("aten::ones(int[] size, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, IntArrayRef)>(at::detail::infer_backend(out), at::detail::infer_is_variable(out))(out, size);
}
static inline Tensor ones_like(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::ones_like(Tensor self) -> Tensor");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor ones_like(const Tensor & self, const TensorOptions & options) {
    globalLegacyTypeDispatch().initForBackend(options.backend());
    static auto table = globalATenDispatch().getOpTable("aten::ones_like(Tensor self, *, ScalarType dtype, Layout layout, Device device, bool pin_memory=False) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const TensorOptions &)>(options.backend(), options.is_variable())(self, options);
}
static inline Tensor pairwise_distance(const Tensor & x1, const Tensor & x2, double p, double eps, bool keepdim) {
    static auto table = globalATenDispatch().getOpTable("aten::pairwise_distance(Tensor x1, Tensor x2, float p=2, float eps=1e-06, bool keepdim=False) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, double, double, bool)>(at::detail::infer_backend(x1), at::detail::infer_is_variable(x1))(x1, x2, p, eps, keepdim);
}
static inline Tensor cdist(const Tensor & x1, const Tensor & x2, double p) {
    static auto table = globalATenDispatch().getOpTable("aten::cdist(Tensor x1, Tensor x2, float p=2) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, double)>(at::detail::infer_backend(x1), at::detail::infer_is_variable(x1))(x1, x2, p);
}
static inline Tensor _cdist_backward(const Tensor & grad, const Tensor & x1, const Tensor & x2, double p, const Tensor & cdist) {
    static auto table = globalATenDispatch().getOpTable("aten::_cdist_backward(Tensor grad, Tensor x1, Tensor x2, float p, Tensor cdist) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, double, const Tensor &)>(at::detail::infer_backend(grad), at::detail::infer_is_variable(grad))(grad, x1, x2, p, cdist);
}
static inline Tensor pdist(const Tensor & self, double p) {
    static auto table = globalATenDispatch().getOpTable("aten::pdist(Tensor self, float p=2) -> Tensor");
    return table->getOp<Tensor (const Tensor &, double)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, p);
}
static inline Tensor _pdist_forward(const Tensor & self, double p) {
    static auto table = globalATenDispatch().getOpTable("aten::_pdist_forward(Tensor self, float p=2) -> Tensor");
    return table->getOp<Tensor (const Tensor &, double)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, p);
}
static inline Tensor _pdist_backward(const Tensor & grad, const Tensor & self, double p, const Tensor & pdist) {
    static auto table = globalATenDispatch().getOpTable("aten::_pdist_backward(Tensor grad, Tensor self, float p, Tensor pdist) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, double, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad, self, p, pdist);
}
static inline Tensor cosine_similarity(const Tensor & x1, const Tensor & x2, int64_t dim, double eps) {
    static auto table = globalATenDispatch().getOpTable("aten::cosine_similarity(Tensor x1, Tensor x2, int dim=1, float eps=1e-08) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, int64_t, double)>(at::detail::infer_backend(x1), at::detail::infer_is_variable(x1))(x1, x2, dim, eps);
}
static inline Tensor pixel_shuffle(const Tensor & self, int64_t upscale_factor) {
    static auto table = globalATenDispatch().getOpTable("aten::pixel_shuffle(Tensor self, int upscale_factor) -> Tensor");
    return table->getOp<Tensor (const Tensor &, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, upscale_factor);
}
static inline Tensor pin_memory(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::pin_memory(Tensor self) -> Tensor");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor pinverse(const Tensor & self, double rcond) {
    static auto table = globalATenDispatch().getOpTable("aten::pinverse(Tensor self, float rcond=1e-15) -> Tensor");
    return table->getOp<Tensor (const Tensor &, double)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, rcond);
}
static inline Tensor poisson_nll_loss(const Tensor & input, const Tensor & target, bool log_input, bool full, double eps, int64_t reduction) {
    static auto table = globalATenDispatch().getOpTable("aten::poisson_nll_loss(Tensor input, Tensor target, bool log_input, bool full, float eps, int reduction) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, bool, bool, double, int64_t)>(at::detail::infer_backend(input), at::detail::infer_is_variable(input))(input, target, log_input, full, eps, reduction);
}
static inline Tensor scalar_tensor(Scalar s, const TensorOptions & options) {
    globalLegacyTypeDispatch().initForBackend(options.backend());
    static auto table = globalATenDispatch().getOpTable("aten::scalar_tensor(Scalar s, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor");
    return table->getOp<Tensor (Scalar, const TensorOptions &)>(options.backend(), options.is_variable())(s, options);
}
static inline Tensor rand(IntArrayRef size, const TensorOptions & options) {
    globalLegacyTypeDispatch().initForBackend(options.backend());
    static auto table = globalATenDispatch().getOpTable("aten::rand(int[] size, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor");
    return table->getOp<Tensor (IntArrayRef, const TensorOptions &)>(options.backend(), options.is_variable())(size, options);
}
static inline Tensor rand(IntArrayRef size, Generator * generator, const TensorOptions & options) {
    globalLegacyTypeDispatch().initForBackend(options.backend());
    static auto table = globalATenDispatch().getOpTable("aten::rand(int[] size, *, Generator? generator, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor");
    return table->getOp<Tensor (IntArrayRef, Generator *, const TensorOptions &)>(options.backend(), options.is_variable())(size, generator, options);
}
static inline Tensor & rand_out(Tensor & out, IntArrayRef size) {
    static auto table = globalATenDispatch().getOpTable("aten::rand(int[] size, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, IntArrayRef)>(at::detail::infer_backend(out), at::detail::infer_is_variable(out))(out, size);
}
static inline Tensor & rand_out(Tensor & out, IntArrayRef size, Generator * generator) {
    static auto table = globalATenDispatch().getOpTable("aten::rand(int[] size, *, Generator? generator, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, IntArrayRef, Generator *)>(at::detail::infer_backend(out), at::detail::infer_is_variable(out))(out, size, generator);
}
static inline Tensor rand_like(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::rand_like(Tensor self) -> Tensor");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor rand_like(const Tensor & self, const TensorOptions & options) {
    globalLegacyTypeDispatch().initForBackend(options.backend());
    static auto table = globalATenDispatch().getOpTable("aten::rand_like(Tensor self, *, ScalarType dtype, Layout layout, Device device, bool pin_memory=False) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const TensorOptions &)>(options.backend(), options.is_variable())(self, options);
}
static inline Tensor randint(int64_t high, IntArrayRef size, const TensorOptions & options) {
    globalLegacyTypeDispatch().initForBackend(options.backend());
    static auto table = globalATenDispatch().getOpTable("aten::randint(int high, int[] size, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor");
    return table->getOp<Tensor (int64_t, IntArrayRef, const TensorOptions &)>(options.backend(), options.is_variable())(high, size, options);
}
static inline Tensor randint(int64_t high, IntArrayRef size, Generator * generator, const TensorOptions & options) {
    globalLegacyTypeDispatch().initForBackend(options.backend());
    static auto table = globalATenDispatch().getOpTable("aten::randint(int high, int[] size, *, Generator? generator, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor");
    return table->getOp<Tensor (int64_t, IntArrayRef, Generator *, const TensorOptions &)>(options.backend(), options.is_variable())(high, size, generator, options);
}
static inline Tensor randint(int64_t low, int64_t high, IntArrayRef size, const TensorOptions & options) {
    globalLegacyTypeDispatch().initForBackend(options.backend());
    static auto table = globalATenDispatch().getOpTable("aten::randint(int low, int high, int[] size, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor");
    return table->getOp<Tensor (int64_t, int64_t, IntArrayRef, const TensorOptions &)>(options.backend(), options.is_variable())(low, high, size, options);
}
static inline Tensor randint(int64_t low, int64_t high, IntArrayRef size, Generator * generator, const TensorOptions & options) {
    globalLegacyTypeDispatch().initForBackend(options.backend());
    static auto table = globalATenDispatch().getOpTable("aten::randint(int low, int high, int[] size, *, Generator? generator, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor");
    return table->getOp<Tensor (int64_t, int64_t, IntArrayRef, Generator *, const TensorOptions &)>(options.backend(), options.is_variable())(low, high, size, generator, options);
}
static inline Tensor & randint_out(Tensor & out, int64_t high, IntArrayRef size) {
    static auto table = globalATenDispatch().getOpTable("aten::randint(int high, int[] size, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, int64_t, IntArrayRef)>(at::detail::infer_backend(out), at::detail::infer_is_variable(out))(out, high, size);
}
static inline Tensor & randint_out(Tensor & out, int64_t high, IntArrayRef size, Generator * generator) {
    static auto table = globalATenDispatch().getOpTable("aten::randint(int high, int[] size, *, Generator? generator, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, int64_t, IntArrayRef, Generator *)>(at::detail::infer_backend(out), at::detail::infer_is_variable(out))(out, high, size, generator);
}
static inline Tensor & randint_out(Tensor & out, int64_t low, int64_t high, IntArrayRef size) {
    static auto table = globalATenDispatch().getOpTable("aten::randint(int low, int high, int[] size, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, int64_t, int64_t, IntArrayRef)>(at::detail::infer_backend(out), at::detail::infer_is_variable(out))(out, low, high, size);
}
static inline Tensor & randint_out(Tensor & out, int64_t low, int64_t high, IntArrayRef size, Generator * generator) {
    static auto table = globalATenDispatch().getOpTable("aten::randint(int low, int high, int[] size, *, Generator? generator, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, int64_t, int64_t, IntArrayRef, Generator *)>(at::detail::infer_backend(out), at::detail::infer_is_variable(out))(out, low, high, size, generator);
}
static inline Tensor randint_like(const Tensor & self, int64_t high) {
    static auto table = globalATenDispatch().getOpTable("aten::randint_like(Tensor self, int high) -> Tensor");
    return table->getOp<Tensor (const Tensor &, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, high);
}
static inline Tensor randint_like(const Tensor & self, int64_t low, int64_t high) {
    static auto table = globalATenDispatch().getOpTable("aten::randint_like(Tensor self, int low, int high) -> Tensor");
    return table->getOp<Tensor (const Tensor &, int64_t, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, low, high);
}
static inline Tensor randint_like(const Tensor & self, int64_t high, const TensorOptions & options) {
    globalLegacyTypeDispatch().initForBackend(options.backend());
    static auto table = globalATenDispatch().getOpTable("aten::randint_like(Tensor self, int high, *, ScalarType dtype, Layout layout, Device device, bool pin_memory=False) -> Tensor");
    return table->getOp<Tensor (const Tensor &, int64_t, const TensorOptions &)>(options.backend(), options.is_variable())(self, high, options);
}
static inline Tensor randint_like(const Tensor & self, int64_t low, int64_t high, const TensorOptions & options) {
    globalLegacyTypeDispatch().initForBackend(options.backend());
    static auto table = globalATenDispatch().getOpTable("aten::randint_like(Tensor self, int low, int high, *, ScalarType dtype, Layout layout, Device device, bool pin_memory=False) -> Tensor");
    return table->getOp<Tensor (const Tensor &, int64_t, int64_t, const TensorOptions &)>(options.backend(), options.is_variable())(self, low, high, options);
}
static inline Tensor randn(IntArrayRef size, const TensorOptions & options) {
    globalLegacyTypeDispatch().initForBackend(options.backend());
    static auto table = globalATenDispatch().getOpTable("aten::randn(int[] size, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor");
    return table->getOp<Tensor (IntArrayRef, const TensorOptions &)>(options.backend(), options.is_variable())(size, options);
}
static inline Tensor randn(IntArrayRef size, Generator * generator, const TensorOptions & options) {
    globalLegacyTypeDispatch().initForBackend(options.backend());
    static auto table = globalATenDispatch().getOpTable("aten::randn(int[] size, *, Generator? generator, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor");
    return table->getOp<Tensor (IntArrayRef, Generator *, const TensorOptions &)>(options.backend(), options.is_variable())(size, generator, options);
}
static inline Tensor & randn_out(Tensor & out, IntArrayRef size) {
    static auto table = globalATenDispatch().getOpTable("aten::randn(int[] size, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, IntArrayRef)>(at::detail::infer_backend(out), at::detail::infer_is_variable(out))(out, size);
}
static inline Tensor & randn_out(Tensor & out, IntArrayRef size, Generator * generator) {
    static auto table = globalATenDispatch().getOpTable("aten::randn(int[] size, *, Generator? generator, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, IntArrayRef, Generator *)>(at::detail::infer_backend(out), at::detail::infer_is_variable(out))(out, size, generator);
}
static inline Tensor randn_like(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::randn_like(Tensor self) -> Tensor");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor randn_like(const Tensor & self, const TensorOptions & options) {
    globalLegacyTypeDispatch().initForBackend(options.backend());
    static auto table = globalATenDispatch().getOpTable("aten::randn_like(Tensor self, *, ScalarType dtype, Layout layout, Device device, bool pin_memory=False) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const TensorOptions &)>(options.backend(), options.is_variable())(self, options);
}
static inline Tensor randperm(int64_t n, const TensorOptions & options) {
    globalLegacyTypeDispatch().initForBackend(options.backend());
    static auto table = globalATenDispatch().getOpTable("aten::randperm(int n, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor");
    return table->getOp<Tensor (int64_t, const TensorOptions &)>(options.backend(), options.is_variable())(n, options);
}
static inline Tensor randperm(int64_t n, Generator * generator, const TensorOptions & options) {
    globalLegacyTypeDispatch().initForBackend(options.backend());
    static auto table = globalATenDispatch().getOpTable("aten::randperm(int n, *, Generator? generator, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor");
    return table->getOp<Tensor (int64_t, Generator *, const TensorOptions &)>(options.backend(), options.is_variable())(n, generator, options);
}
static inline Tensor & randperm_out(Tensor & out, int64_t n) {
    static auto table = globalATenDispatch().getOpTable("aten::randperm(int n, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, int64_t)>(at::detail::infer_backend(out), at::detail::infer_is_variable(out))(out, n);
}
static inline Tensor & randperm_out(Tensor & out, int64_t n, Generator * generator) {
    static auto table = globalATenDispatch().getOpTable("aten::randperm(int n, *, Generator? generator, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, int64_t, Generator *)>(at::detail::infer_backend(out), at::detail::infer_is_variable(out))(out, n, generator);
}
static inline Tensor range(Scalar start, Scalar end, Scalar step, const TensorOptions & options) {
    globalLegacyTypeDispatch().initForBackend(options.backend());
    static auto table = globalATenDispatch().getOpTable("aten::range(Scalar start, Scalar end, Scalar step=1, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor");
    return table->getOp<Tensor (Scalar, Scalar, Scalar, const TensorOptions &)>(options.backend(), options.is_variable())(start, end, step, options);
}
static inline Tensor range(Scalar start, Scalar end, const TensorOptions & options) {
    globalLegacyTypeDispatch().initForBackend(options.backend());
    static auto table = globalATenDispatch().getOpTable("aten::range(Scalar start, Scalar end, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor");
    return table->getOp<Tensor (Scalar, Scalar, const TensorOptions &)>(options.backend(), options.is_variable())(start, end, options);
}
static inline Tensor & range_out(Tensor & out, Scalar start, Scalar end, Scalar step) {
    static auto table = globalATenDispatch().getOpTable("aten::range(Scalar start, Scalar end, Scalar step=1, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, Scalar, Scalar, Scalar)>(at::detail::infer_backend(out), at::detail::infer_is_variable(out))(out, start, end, step);
}
static inline Tensor reciprocal(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::reciprocal(Tensor self) -> Tensor");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & reciprocal_(Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::reciprocal_(Tensor(a!) self) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & reciprocal_out(Tensor & out, const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::reciprocal(Tensor self, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self);
}
static inline Tensor neg(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::neg(Tensor self) -> Tensor");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & neg_(Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::neg_(Tensor(a!) self) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & neg_out(Tensor & out, const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::neg(Tensor self, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self);
}
static inline Tensor repeat_interleave(const Tensor & repeats) {
    static auto table = globalATenDispatch().getOpTable("aten::repeat_interleave(Tensor repeats) -> Tensor");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(repeats), at::detail::infer_is_variable(repeats))(repeats);
}
static inline Tensor repeat_interleave(const Tensor & self, const Tensor & repeats, c10::optional<int64_t> dim) {
    static auto table = globalATenDispatch().getOpTable("aten::repeat_interleave(Tensor self, Tensor repeats, int? dim=None) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, c10::optional<int64_t>)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, repeats, dim);
}
static inline Tensor repeat_interleave(const Tensor & self, int64_t repeats, c10::optional<int64_t> dim) {
    static auto table = globalATenDispatch().getOpTable("aten::repeat_interleave(Tensor self, int repeats, int? dim=None) -> Tensor");
    return table->getOp<Tensor (const Tensor &, int64_t, c10::optional<int64_t>)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, repeats, dim);
}
static inline Tensor reshape(const Tensor & self, IntArrayRef shape) {
    static auto table = globalATenDispatch().getOpTable("aten::reshape(Tensor self, int[] shape) -> Tensor");
    return table->getOp<Tensor (const Tensor &, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, shape);
}
static inline Tensor _mkldnn_reshape(const Tensor & self, IntArrayRef shape) {
    static auto table = globalATenDispatch().getOpTable("aten::_mkldnn_reshape(Tensor self, int[] shape) -> Tensor");
    return table->getOp<Tensor (const Tensor &, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, shape);
}
static inline Tensor round(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::round(Tensor self) -> Tensor");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & round_(Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::round_(Tensor(a!) self) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & round_out(Tensor & out, const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::round(Tensor self, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self);
}
static inline Tensor rrelu(const Tensor & self, Scalar lower, Scalar upper, bool training, Generator * generator) {
    static auto table = globalATenDispatch().getOpTable("aten::rrelu(Tensor self, Scalar lower=0.125, Scalar upper=0.3333333333333333, bool training=False, Generator? generator=None) -> Tensor");
    return table->getOp<Tensor (const Tensor &, Scalar, Scalar, bool, Generator *)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, lower, upper, training, generator);
}
static inline Tensor & rrelu_(Tensor & self, Scalar lower, Scalar upper, bool training, Generator * generator) {
    static auto table = globalATenDispatch().getOpTable("aten::rrelu_(Tensor(a!) self, Scalar lower=0.125, Scalar upper=0.3333333333333333, bool training=False, Generator? generator=None) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, Scalar, Scalar, bool, Generator *)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, lower, upper, training, generator);
}
static inline Tensor relu(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::relu(Tensor self) -> Tensor");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & relu_(Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::relu_(Tensor(a!) self) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor prelu(const Tensor & self, const Tensor & weight) {
    static auto table = globalATenDispatch().getOpTable("aten::prelu(Tensor self, Tensor weight) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, weight);
}
static inline std::tuple<Tensor,Tensor> prelu_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight) {
    static auto table = globalATenDispatch().getOpTable("aten::prelu_backward(Tensor grad_output, Tensor self, Tensor weight) -> (Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor> (const Tensor &, const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_output, self, weight);
}
static inline Tensor gelu(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::gelu(Tensor self) -> Tensor");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor gelu_backward(const Tensor & grad, const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::gelu_backward(Tensor grad, Tensor self) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad, self);
}
static inline Tensor hardshrink(const Tensor & self, Scalar lambd) {
    static auto table = globalATenDispatch().getOpTable("aten::hardshrink(Tensor self, Scalar lambd=0.5) -> Tensor");
    return table->getOp<Tensor (const Tensor &, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, lambd);
}
static inline Tensor hardshrink_backward(const Tensor & grad_out, const Tensor & self, Scalar lambd) {
    static auto table = globalATenDispatch().getOpTable("aten::hardshrink_backward(Tensor grad_out, Tensor self, Scalar lambd) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_out, self, lambd);
}
static inline Tensor rsqrt(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::rsqrt(Tensor self) -> Tensor");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & rsqrt_(Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::rsqrt_(Tensor(a!) self) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & rsqrt_out(Tensor & out, const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::rsqrt(Tensor self, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self);
}
#ifdef BUILD_NAMEDTENSOR
static inline Tensor select(const Tensor & self, Dimname dim, int64_t index) {
    static auto table = globalATenDispatch().getOpTable("aten::select(Tensor(a) self, Dimname dim, int index) -> Tensor(a)");
    return table->getOp<Tensor (const Tensor &, Dimname, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dim, index);
}
#endif
static inline Tensor select(const Tensor & self, int64_t dim, int64_t index) {
    static auto table = globalATenDispatch().getOpTable("aten::select(Tensor(a) self, int dim, int index) -> Tensor(a)");
    return table->getOp<Tensor (const Tensor &, int64_t, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dim, index);
}
static inline Tensor selu(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::selu(Tensor self) -> Tensor");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & selu_(Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::selu_(Tensor(a!) self) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor celu(const Tensor & self, Scalar alpha) {
    static auto table = globalATenDispatch().getOpTable("aten::celu(Tensor self, Scalar alpha=1.0) -> Tensor");
    return table->getOp<Tensor (const Tensor &, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, alpha);
}
static inline Tensor & celu_(Tensor & self, Scalar alpha) {
    static auto table = globalATenDispatch().getOpTable("aten::celu_(Tensor(a!) self, Scalar alpha=1.0) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, alpha);
}
static inline Tensor sigmoid(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::sigmoid(Tensor self) -> Tensor");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & sigmoid_(Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::sigmoid_(Tensor(a!) self) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & sigmoid_out(Tensor & out, const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::sigmoid(Tensor self, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self);
}
static inline Tensor sin(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::sin(Tensor self) -> Tensor");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & sin_(Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::sin_(Tensor(a!) self) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & sin_out(Tensor & out, const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::sin(Tensor self, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self);
}
static inline Tensor sinh(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::sinh(Tensor self) -> Tensor");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & sinh_(Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::sinh_(Tensor(a!) self) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & sinh_out(Tensor & out, const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::sinh(Tensor self, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self);
}
static inline Tensor detach(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::detach(Tensor self) -> Tensor");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & detach_(Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::detach_(Tensor(a!) self) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline int64_t size(const Tensor & self, int64_t dim) {
    static auto table = globalATenDispatch().getOpTable("aten::size(Tensor self, int dim) -> int");
    return table->getOp<int64_t (const Tensor &, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dim);
}
#ifdef BUILD_NAMEDTENSOR
static inline int64_t size(const Tensor & self, Dimname dim) {
    static auto table = globalATenDispatch().getOpTable("aten::size(Tensor self, Dimname dim) -> int");
    return table->getOp<int64_t (const Tensor &, Dimname)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dim);
}
#endif
static inline Tensor slice(const Tensor & self, int64_t dim, int64_t start, int64_t end, int64_t step) {
    static auto table = globalATenDispatch().getOpTable("aten::slice(Tensor(a) self, int dim=0, int start=0, int end=9223372036854775807, int step=1) -> Tensor(a)");
    return table->getOp<Tensor (const Tensor &, int64_t, int64_t, int64_t, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dim, start, end, step);
}
static inline std::tuple<Tensor,Tensor> slogdet(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::slogdet(Tensor self) -> (Tensor sign, Tensor logabsdet)");
    return table->getOp<std::tuple<Tensor,Tensor> (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor smm(const Tensor & self, const Tensor & mat2) {
    static auto table = globalATenDispatch().getOpTable("aten::smm(Tensor self, Tensor mat2) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, mat2);
}
static inline Tensor softmax(const Tensor & self, int64_t dim, c10::optional<ScalarType> dtype) {
    static auto table = globalATenDispatch().getOpTable("aten::softmax(Tensor self, int dim, ScalarType? dtype=None) -> Tensor");
    return table->getOp<Tensor (const Tensor &, int64_t, c10::optional<ScalarType>)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dim, dtype);
}
static inline Tensor _softmax(const Tensor & self, int64_t dim, bool half_to_float) {
    static auto table = globalATenDispatch().getOpTable("aten::_softmax(Tensor self, int dim, bool half_to_float) -> Tensor");
    return table->getOp<Tensor (const Tensor &, int64_t, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dim, half_to_float);
}
static inline Tensor _softmax_backward_data(const Tensor & grad_output, const Tensor & output, int64_t dim, const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::_softmax_backward_data(Tensor grad_output, Tensor output, int dim, Tensor self) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, int64_t, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_output, output, dim, self);
}
static inline Tensor & _sparse_add_out(Tensor & out, const Tensor & self, const Tensor & other, Scalar alpha) {
    static auto table = globalATenDispatch().getOpTable("aten::_sparse_add(Tensor self, Tensor other, *, Scalar alpha=1, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, other, alpha);
}
static inline Tensor & _sparse_dense_add_out(Tensor & out, const Tensor & self, const Tensor & other, Scalar alpha) {
    static auto table = globalATenDispatch().getOpTable("aten::_sparse_dense_add(Tensor self, Tensor other, *, Scalar alpha=1, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, other, alpha);
}
static inline Tensor & _sparse_div_zerodim_out(Tensor & out, const Tensor & self, const Tensor & other) {
    static auto table = globalATenDispatch().getOpTable("aten::_sparse_div_zerodim(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, other);
}
static inline Tensor & _sparse_div_scalar_out(Tensor & out, const Tensor & self, Scalar other) {
    static auto table = globalATenDispatch().getOpTable("aten::_sparse_div_scalar(Tensor self, Scalar other, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, other);
}
static inline Tensor & _sparse_mul_out(Tensor & out, const Tensor & self, const Tensor & other) {
    static auto table = globalATenDispatch().getOpTable("aten::_sparse_mul(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, other);
}
static inline Tensor & _sparse_mul_zerodim_out(Tensor & out, const Tensor & self, const Tensor & other) {
    static auto table = globalATenDispatch().getOpTable("aten::_sparse_mul_zerodim(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, other);
}
static inline Tensor & _sparse_mul_scalar_out(Tensor & out, const Tensor & self, Scalar other) {
    static auto table = globalATenDispatch().getOpTable("aten::_sparse_mul_scalar(Tensor self, Scalar other, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, other);
}
static inline std::vector<Tensor> split(const Tensor & self, int64_t split_size, int64_t dim) {
    static auto table = globalATenDispatch().getOpTable("aten::split(Tensor(a) self, int split_size, int dim=0) -> Tensor(a)[]");
    return table->getOp<std::vector<Tensor> (const Tensor &, int64_t, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, split_size, dim);
}
static inline std::vector<Tensor> split_with_sizes(const Tensor & self, IntArrayRef split_sizes, int64_t dim) {
    static auto table = globalATenDispatch().getOpTable("aten::split_with_sizes(Tensor self, int[] split_sizes, int dim=0) -> Tensor[]");
    return table->getOp<std::vector<Tensor> (const Tensor &, IntArrayRef, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, split_sizes, dim);
}
static inline Tensor squeeze(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::squeeze(Tensor(a) self) -> Tensor(a)");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor squeeze(const Tensor & self, int64_t dim) {
    static auto table = globalATenDispatch().getOpTable("aten::squeeze(Tensor(a) self, int dim) -> Tensor(a)");
    return table->getOp<Tensor (const Tensor &, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dim);
}
static inline Tensor sspaddmm(const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta, Scalar alpha) {
    static auto table = globalATenDispatch().getOpTable("aten::sspaddmm(Tensor self, Tensor mat1, Tensor mat2, *, Scalar beta=1, Scalar alpha=1) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, Scalar, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, mat1, mat2, beta, alpha);
}
static inline Tensor & sspaddmm_out(Tensor & out, const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta, Scalar alpha) {
    static auto table = globalATenDispatch().getOpTable("aten::sspaddmm(Tensor self, Tensor mat1, Tensor mat2, *, Scalar beta=1, Scalar alpha=1, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, const Tensor &, Scalar, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, mat1, mat2, beta, alpha);
}
static inline Tensor stack(TensorList tensors, int64_t dim) {
    static auto table = globalATenDispatch().getOpTable("aten::stack(Tensor[] tensors, int dim=0) -> Tensor");
    return table->getOp<Tensor (TensorList, int64_t)>(at::detail::infer_backend(tensors), at::detail::infer_is_variable(tensors))(tensors, dim);
}
static inline Tensor & stack_out(Tensor & out, TensorList tensors, int64_t dim) {
    static auto table = globalATenDispatch().getOpTable("aten::stack(Tensor[] tensors, int dim=0, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, TensorList, int64_t)>(at::detail::infer_backend(out), at::detail::infer_is_variable(out))(out, tensors, dim);
}
static inline Tensor stft(const Tensor & self, int64_t n_fft, c10::optional<int64_t> hop_length, c10::optional<int64_t> win_length, const Tensor & window, bool normalized, bool onesided) {
    static auto table = globalATenDispatch().getOpTable("aten::stft(Tensor self, int n_fft, int? hop_length=None, int? win_length=None, Tensor? window=None, bool normalized=False, bool onesided=True) -> Tensor");
    return table->getOp<Tensor (const Tensor &, int64_t, c10::optional<int64_t>, c10::optional<int64_t>, const Tensor &, bool, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, n_fft, hop_length, win_length, window, normalized, onesided);
}
static inline int64_t stride(const Tensor & self, int64_t dim) {
    static auto table = globalATenDispatch().getOpTable("aten::stride(Tensor self, int dim) -> int");
    return table->getOp<int64_t (const Tensor &, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dim);
}
#ifdef BUILD_NAMEDTENSOR
static inline int64_t stride(const Tensor & self, Dimname dim) {
    static auto table = globalATenDispatch().getOpTable("aten::stride(Tensor self, Dimname dim) -> int");
    return table->getOp<int64_t (const Tensor &, Dimname)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dim);
}
#endif
static inline Tensor sum(const Tensor & self, c10::optional<ScalarType> dtype) {
    static auto table = globalATenDispatch().getOpTable("aten::sum(Tensor self, *, ScalarType? dtype=None) -> Tensor");
    return table->getOp<Tensor (const Tensor &, c10::optional<ScalarType>)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dtype);
}
static inline Tensor sum(const Tensor & self, IntArrayRef dim, bool keepdim, c10::optional<ScalarType> dtype) {
    static auto table = globalATenDispatch().getOpTable("aten::sum(Tensor self, int[1] dim, bool keepdim=False, *, ScalarType? dtype=None) -> Tensor");
    return table->getOp<Tensor (const Tensor &, IntArrayRef, bool, c10::optional<ScalarType>)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dim, keepdim, dtype);
}
#ifdef BUILD_NAMEDTENSOR
static inline Tensor sum(const Tensor & self, DimnameList dim, bool keepdim, c10::optional<ScalarType> dtype) {
    static auto table = globalATenDispatch().getOpTable("aten::sum(Tensor self, Dimname[1] dim, bool keepdim=False, *, ScalarType? dtype=None) -> Tensor");
    return table->getOp<Tensor (const Tensor &, DimnameList, bool, c10::optional<ScalarType>)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dim, keepdim, dtype);
}
#endif
static inline Tensor & sum_out(Tensor & out, const Tensor & self, IntArrayRef dim, bool keepdim, c10::optional<ScalarType> dtype) {
    static auto table = globalATenDispatch().getOpTable("aten::sum(Tensor self, int[1] dim, bool keepdim=False, *, ScalarType? dtype=None, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, IntArrayRef, bool, c10::optional<ScalarType>)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, dim, keepdim, dtype);
}
#ifdef BUILD_NAMEDTENSOR
static inline Tensor & sum_out(Tensor & out, const Tensor & self, DimnameList dim, bool keepdim, c10::optional<ScalarType> dtype) {
    static auto table = globalATenDispatch().getOpTable("aten::sum(Tensor self, Dimname[1] dim, bool keepdim=False, *, ScalarType? dtype=None, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, DimnameList, bool, c10::optional<ScalarType>)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, dim, keepdim, dtype);
}
#endif
static inline Tensor sqrt(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::sqrt(Tensor self) -> Tensor");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & sqrt_(Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::sqrt_(Tensor(a!) self) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & sqrt_out(Tensor & out, const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::sqrt(Tensor self, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self);
}
static inline Tensor std(const Tensor & self, bool unbiased) {
    static auto table = globalATenDispatch().getOpTable("aten::std(Tensor self, bool unbiased=True) -> Tensor");
    return table->getOp<Tensor (const Tensor &, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, unbiased);
}
static inline Tensor std(const Tensor & self, IntArrayRef dim, bool unbiased, bool keepdim) {
    static auto table = globalATenDispatch().getOpTable("aten::std(Tensor self, int[1] dim, bool unbiased=True, bool keepdim=False) -> Tensor");
    return table->getOp<Tensor (const Tensor &, IntArrayRef, bool, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dim, unbiased, keepdim);
}
static inline std::tuple<Tensor,Tensor> std_mean(const Tensor & self, bool unbiased) {
    static auto table = globalATenDispatch().getOpTable("aten::std_mean(Tensor self, bool unbiased=True) -> (Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor> (const Tensor &, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, unbiased);
}
static inline std::tuple<Tensor,Tensor> std_mean(const Tensor & self, IntArrayRef dim, bool unbiased, bool keepdim) {
    static auto table = globalATenDispatch().getOpTable("aten::std_mean(Tensor self, int[1] dim, bool unbiased=True, bool keepdim=False) -> (Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor> (const Tensor &, IntArrayRef, bool, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dim, unbiased, keepdim);
}
static inline Tensor & std_out(Tensor & out, const Tensor & self, IntArrayRef dim, bool unbiased, bool keepdim) {
    static auto table = globalATenDispatch().getOpTable("aten::std(Tensor self, int[1] dim, bool unbiased=True, bool keepdim=False, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, IntArrayRef, bool, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, dim, unbiased, keepdim);
}
static inline Tensor prod(const Tensor & self, c10::optional<ScalarType> dtype) {
    static auto table = globalATenDispatch().getOpTable("aten::prod(Tensor self, *, ScalarType? dtype=None) -> Tensor");
    return table->getOp<Tensor (const Tensor &, c10::optional<ScalarType>)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dtype);
}
static inline Tensor prod(const Tensor & self, int64_t dim, bool keepdim, c10::optional<ScalarType> dtype) {
    static auto table = globalATenDispatch().getOpTable("aten::prod(Tensor self, int dim, bool keepdim=False, *, ScalarType? dtype=None) -> Tensor");
    return table->getOp<Tensor (const Tensor &, int64_t, bool, c10::optional<ScalarType>)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dim, keepdim, dtype);
}
static inline Tensor & prod_out(Tensor & out, const Tensor & self, int64_t dim, bool keepdim, c10::optional<ScalarType> dtype) {
    static auto table = globalATenDispatch().getOpTable("aten::prod(Tensor self, int dim, bool keepdim=False, *, ScalarType? dtype=None, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, int64_t, bool, c10::optional<ScalarType>)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, dim, keepdim, dtype);
}
#ifdef BUILD_NAMEDTENSOR
static inline Tensor prod(const Tensor & self, Dimname dim, bool keepdim, c10::optional<ScalarType> dtype) {
    static auto table = globalATenDispatch().getOpTable("aten::prod(Tensor self, Dimname dim, bool keepdim=False, *, ScalarType? dtype=None) -> Tensor");
    return table->getOp<Tensor (const Tensor &, Dimname, bool, c10::optional<ScalarType>)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dim, keepdim, dtype);
}
#endif
#ifdef BUILD_NAMEDTENSOR
static inline Tensor & prod_out(Tensor & out, const Tensor & self, Dimname dim, bool keepdim, c10::optional<ScalarType> dtype) {
    static auto table = globalATenDispatch().getOpTable("aten::prod(Tensor self, Dimname dim, bool keepdim=False, *, ScalarType? dtype=None, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, Dimname, bool, c10::optional<ScalarType>)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, dim, keepdim, dtype);
}
#endif
static inline Tensor t(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::t(Tensor(a) self) -> Tensor(a)");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor tan(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::tan(Tensor self) -> Tensor");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & tan_(Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::tan_(Tensor(a!) self) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & tan_out(Tensor & out, const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::tan(Tensor self, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self);
}
static inline Tensor tanh(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::tanh(Tensor self) -> Tensor");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & tanh_(Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::tanh_(Tensor(a!) self) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & tanh_out(Tensor & out, const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::tanh(Tensor self, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self);
}
static inline Tensor tensordot(const Tensor & self, const Tensor & other, IntArrayRef dims_self, IntArrayRef dims_other) {
    static auto table = globalATenDispatch().getOpTable("aten::tensordot(Tensor self, Tensor other, int[] dims_self, int[] dims_other) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, IntArrayRef, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, other, dims_self, dims_other);
}
static inline Tensor threshold(const Tensor & self, Scalar threshold, Scalar value) {
    static auto table = globalATenDispatch().getOpTable("aten::threshold(Tensor self, Scalar threshold, Scalar value) -> Tensor");
    return table->getOp<Tensor (const Tensor &, Scalar, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, threshold, value);
}
static inline Tensor & threshold_(Tensor & self, Scalar threshold, Scalar value) {
    static auto table = globalATenDispatch().getOpTable("aten::threshold_(Tensor(a!) self, Scalar threshold, Scalar value) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, Scalar, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, threshold, value);
}
static inline Tensor & threshold_out(Tensor & out, const Tensor & self, Scalar threshold, Scalar value) {
    static auto table = globalATenDispatch().getOpTable("aten::threshold(Tensor self, Scalar threshold, Scalar value, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, Scalar, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, threshold, value);
}
static inline Tensor threshold_backward(const Tensor & grad_output, const Tensor & self, Scalar threshold) {
    static auto table = globalATenDispatch().getOpTable("aten::threshold_backward(Tensor grad_output, Tensor self, Scalar threshold) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_output, self, threshold);
}
static inline Tensor transpose(const Tensor & self, int64_t dim0, int64_t dim1) {
    static auto table = globalATenDispatch().getOpTable("aten::transpose(Tensor(a) self, int dim0, int dim1) -> Tensor(a)");
    return table->getOp<Tensor (const Tensor &, int64_t, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dim0, dim1);
}
static inline Tensor _mkldnn_transpose(const Tensor & self, int64_t dim0, int64_t dim1) {
    static auto table = globalATenDispatch().getOpTable("aten::_mkldnn_transpose(Tensor self, int dim0, int dim1) -> Tensor");
    return table->getOp<Tensor (const Tensor &, int64_t, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dim0, dim1);
}
static inline Tensor & _mkldnn_transpose_(Tensor & self, int64_t dim0, int64_t dim1) {
    static auto table = globalATenDispatch().getOpTable("aten::_mkldnn_transpose_(Tensor(a!) self, int dim0, int dim1) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, int64_t, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dim0, dim1);
}
static inline Tensor one_hot(const Tensor & self, int64_t num_classes) {
    static auto table = globalATenDispatch().getOpTable("aten::one_hot(Tensor self, int num_classes=-1) -> Tensor");
    return table->getOp<Tensor (const Tensor &, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, num_classes);
}
static inline Tensor flip(const Tensor & self, IntArrayRef dims) {
    static auto table = globalATenDispatch().getOpTable("aten::flip(Tensor self, int[] dims) -> Tensor");
    return table->getOp<Tensor (const Tensor &, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dims);
}
static inline Tensor roll(const Tensor & self, IntArrayRef shifts, IntArrayRef dims) {
    static auto table = globalATenDispatch().getOpTable("aten::roll(Tensor self, int[1] shifts, int[1] dims=[]) -> Tensor");
    return table->getOp<Tensor (const Tensor &, IntArrayRef, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, shifts, dims);
}
static inline Tensor rot90(const Tensor & self, int64_t k, IntArrayRef dims) {
    static auto table = globalATenDispatch().getOpTable("aten::rot90(Tensor self, int k=1, int[] dims=[0,1]) -> Tensor");
    return table->getOp<Tensor (const Tensor &, int64_t, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, k, dims);
}
static inline Tensor trapz(const Tensor & y, const Tensor & x, int64_t dim) {
    static auto table = globalATenDispatch().getOpTable("aten::trapz(Tensor y, Tensor x, *, int dim=-1) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, int64_t)>(at::detail::infer_backend(y), at::detail::infer_is_variable(y))(y, x, dim);
}
static inline Tensor trapz(const Tensor & y, double dx, int64_t dim) {
    static auto table = globalATenDispatch().getOpTable("aten::trapz(Tensor y, *, float dx=1, int dim=-1) -> Tensor");
    return table->getOp<Tensor (const Tensor &, double, int64_t)>(at::detail::infer_backend(y), at::detail::infer_is_variable(y))(y, dx, dim);
}
static inline Tensor _trilinear(const Tensor & i1, const Tensor & i2, const Tensor & i3, IntArrayRef expand1, IntArrayRef expand2, IntArrayRef expand3, IntArrayRef sumdim, int64_t unroll_dim) {
    static auto table = globalATenDispatch().getOpTable("aten::_trilinear(Tensor i1, Tensor i2, Tensor i3, int[] expand1, int[] expand2, int[] expand3, int[] sumdim, int unroll_dim=1) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, IntArrayRef, int64_t)>(at::detail::infer_backend(i1), at::detail::infer_is_variable(i1))(i1, i2, i3, expand1, expand2, expand3, sumdim, unroll_dim);
}
static inline Tensor triplet_margin_loss(const Tensor & anchor, const Tensor & positive, const Tensor & negative, double margin, double p, double eps, bool swap, int64_t reduction) {
    static auto table = globalATenDispatch().getOpTable("aten::triplet_margin_loss(Tensor anchor, Tensor positive, Tensor negative, float margin=1.0, float p=2, float eps=1e-06, bool swap=False, int reduction=Mean) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, double, double, double, bool, int64_t)>(at::detail::infer_backend(anchor), at::detail::infer_is_variable(anchor))(anchor, positive, negative, margin, p, eps, swap, reduction);
}
static inline Tensor trunc(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::trunc(Tensor self) -> Tensor");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & trunc_(Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::trunc_(Tensor(a!) self) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & trunc_out(Tensor & out, const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::trunc(Tensor self, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self);
}
static inline bool _has_compatible_shallow_copy_type(const Tensor & self, const Tensor & from) {
    static auto table = globalATenDispatch().getOpTable("aten::_has_compatible_shallow_copy_type(Tensor self, Tensor from) -> bool");
    return table->getOp<bool (const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, from);
}
static inline std::tuple<Tensor,Tensor> _unique(const Tensor & self, bool sorted, bool return_inverse) {
    static auto table = globalATenDispatch().getOpTable("aten::_unique(Tensor self, bool sorted=True, bool return_inverse=False) -> (Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor> (const Tensor &, bool, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, sorted, return_inverse);
}
static inline std::tuple<Tensor,Tensor,Tensor> unique_dim(const Tensor & self, int64_t dim, bool sorted, bool return_inverse, bool return_counts) {
    static auto table = globalATenDispatch().getOpTable("aten::unique_dim(Tensor self, int dim, bool sorted=True, bool return_inverse=False, bool return_counts=False) -> (Tensor, Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor,Tensor> (const Tensor &, int64_t, bool, bool, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dim, sorted, return_inverse, return_counts);
}
static inline std::tuple<Tensor,Tensor,Tensor> unique_consecutive(const Tensor & self, bool return_inverse, bool return_counts, c10::optional<int64_t> dim) {
    static auto table = globalATenDispatch().getOpTable("aten::unique_consecutive(Tensor self, bool return_inverse=False, bool return_counts=False, int? dim=None) -> (Tensor, Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor,Tensor> (const Tensor &, bool, bool, c10::optional<int64_t>)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, return_inverse, return_counts, dim);
}
static inline std::tuple<Tensor,Tensor,Tensor> unique_dim_consecutive(const Tensor & self, int64_t dim, bool return_inverse, bool return_counts) {
    static auto table = globalATenDispatch().getOpTable("aten::unique_dim_consecutive(Tensor self, int dim, bool return_inverse=False, bool return_counts=False) -> (Tensor, Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor,Tensor> (const Tensor &, int64_t, bool, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dim, return_inverse, return_counts);
}
static inline std::tuple<Tensor,Tensor,Tensor> _unique2(const Tensor & self, bool sorted, bool return_inverse, bool return_counts) {
    static auto table = globalATenDispatch().getOpTable("aten::_unique2(Tensor self, bool sorted=True, bool return_inverse=False, bool return_counts=False) -> (Tensor, Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor,Tensor> (const Tensor &, bool, bool, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, sorted, return_inverse, return_counts);
}
static inline Tensor _unsafe_view(const Tensor & self, IntArrayRef size) {
    static auto table = globalATenDispatch().getOpTable("aten::_unsafe_view(Tensor self, int[] size) -> Tensor");
    return table->getOp<Tensor (const Tensor &, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, size);
}
static inline Tensor unsqueeze(const Tensor & self, int64_t dim) {
    static auto table = globalATenDispatch().getOpTable("aten::unsqueeze(Tensor(a) self, int dim) -> Tensor(a)");
    return table->getOp<Tensor (const Tensor &, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dim);
}
static inline Tensor var(const Tensor & self, bool unbiased) {
    static auto table = globalATenDispatch().getOpTable("aten::var(Tensor self, bool unbiased=True) -> Tensor");
    return table->getOp<Tensor (const Tensor &, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, unbiased);
}
static inline Tensor var(const Tensor & self, IntArrayRef dim, bool unbiased, bool keepdim) {
    static auto table = globalATenDispatch().getOpTable("aten::var(Tensor self, int[1] dim, bool unbiased=True, bool keepdim=False) -> Tensor");
    return table->getOp<Tensor (const Tensor &, IntArrayRef, bool, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dim, unbiased, keepdim);
}
static inline Tensor & var_out(Tensor & out, const Tensor & self, IntArrayRef dim, bool unbiased, bool keepdim) {
    static auto table = globalATenDispatch().getOpTable("aten::var(Tensor self, int[1] dim, bool unbiased=True, bool keepdim=False, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, IntArrayRef, bool, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, dim, unbiased, keepdim);
}
static inline std::tuple<Tensor,Tensor> var_mean(const Tensor & self, bool unbiased) {
    static auto table = globalATenDispatch().getOpTable("aten::var_mean(Tensor self, bool unbiased=True) -> (Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor> (const Tensor &, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, unbiased);
}
static inline std::tuple<Tensor,Tensor> var_mean(const Tensor & self, IntArrayRef dim, bool unbiased, bool keepdim) {
    static auto table = globalATenDispatch().getOpTable("aten::var_mean(Tensor self, int[1] dim, bool unbiased=True, bool keepdim=False) -> (Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor> (const Tensor &, IntArrayRef, bool, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dim, unbiased, keepdim);
}
static inline Tensor where(const Tensor & condition, const Tensor & self, const Tensor & other) {
    static auto table = globalATenDispatch().getOpTable("aten::where(Tensor condition, Tensor self, Tensor other) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(condition, self, other);
}
static inline std::vector<Tensor> where(const Tensor & condition) {
    static auto table = globalATenDispatch().getOpTable("aten::where(Tensor condition) -> Tensor[]");
    return table->getOp<std::vector<Tensor> (const Tensor &)>(at::detail::infer_backend(condition), at::detail::infer_is_variable(condition))(condition);
}
static inline Tensor _s_where(const Tensor & condition, const Tensor & self, const Tensor & other) {
    static auto table = globalATenDispatch().getOpTable("aten::_s_where(Tensor condition, Tensor self, Tensor other) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(condition, self, other);
}
static inline Tensor norm_except_dim(const Tensor & v, int64_t pow, int64_t dim) {
    static auto table = globalATenDispatch().getOpTable("aten::norm_except_dim(Tensor v, int pow=2, int dim=0) -> Tensor");
    return table->getOp<Tensor (const Tensor &, int64_t, int64_t)>(at::detail::infer_backend(v), at::detail::infer_is_variable(v))(v, pow, dim);
}
static inline Tensor _weight_norm(const Tensor & v, const Tensor & g, int64_t dim) {
    static auto table = globalATenDispatch().getOpTable("aten::_weight_norm(Tensor v, Tensor g, int dim=0) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, int64_t)>(at::detail::infer_backend(v), at::detail::infer_is_variable(v))(v, g, dim);
}
static inline std::tuple<Tensor,Tensor> _weight_norm_cuda_interface(const Tensor & v, const Tensor & g, int64_t dim) {
    static auto table = globalATenDispatch().getOpTable("aten::_weight_norm_cuda_interface(Tensor v, Tensor g, int dim=0) -> (Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor> (const Tensor &, const Tensor &, int64_t)>(at::detail::infer_backend(v), at::detail::infer_is_variable(v))(v, g, dim);
}
static inline std::tuple<Tensor,Tensor> _weight_norm_cuda_interface_backward(const Tensor & grad_w, const Tensor & saved_v, const Tensor & saved_g, const Tensor & saved_norms, int64_t dim) {
    static auto table = globalATenDispatch().getOpTable("aten::_weight_norm_cuda_interface_backward(Tensor grad_w, Tensor saved_v, Tensor saved_g, Tensor saved_norms, int dim) -> (Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor> (const Tensor &, const Tensor &, const Tensor &, const Tensor &, int64_t)>(at::detail::infer_backend(grad_w), at::detail::infer_is_variable(grad_w))(grad_w, saved_v, saved_g, saved_norms, dim);
}
static inline std::tuple<Tensor,Tensor> _weight_norm_differentiable_backward(const Tensor & grad_w, const Tensor & saved_v, const Tensor & saved_g, const Tensor & saved_norms, int64_t dim) {
    static auto table = globalATenDispatch().getOpTable("aten::_weight_norm_differentiable_backward(Tensor grad_w, Tensor saved_v, Tensor saved_g, Tensor saved_norms, int dim) -> (Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor> (const Tensor &, const Tensor &, const Tensor &, const Tensor &, int64_t)>(at::detail::infer_backend(grad_w), at::detail::infer_is_variable(grad_w))(grad_w, saved_v, saved_g, saved_norms, dim);
}
static inline Tensor zeros(IntArrayRef size, const TensorOptions & options) {
    globalLegacyTypeDispatch().initForBackend(options.backend());
    static auto table = globalATenDispatch().getOpTable("aten::zeros(int[] size, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor");
    return table->getOp<Tensor (IntArrayRef, const TensorOptions &)>(options.backend(), options.is_variable())(size, options);
}
static inline Tensor & zeros_out(Tensor & out, IntArrayRef size) {
    static auto table = globalATenDispatch().getOpTable("aten::zeros(int[] size, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, IntArrayRef)>(at::detail::infer_backend(out), at::detail::infer_is_variable(out))(out, size);
}
static inline Tensor zeros_like(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::zeros_like(Tensor self) -> Tensor");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor zeros_like(const Tensor & self, const TensorOptions & options) {
    globalLegacyTypeDispatch().initForBackend(options.backend());
    static auto table = globalATenDispatch().getOpTable("aten::zeros_like(Tensor self, *, ScalarType dtype, Layout layout, Device device, bool pin_memory=False) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const TensorOptions &)>(options.backend(), options.is_variable())(self, options);
}
static inline Tensor _standard_gamma_grad(const Tensor & self, const Tensor & output) {
    static auto table = globalATenDispatch().getOpTable("aten::_standard_gamma_grad(Tensor self, Tensor output) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, output);
}
static inline Tensor _standard_gamma(const Tensor & self, Generator * generator) {
    static auto table = globalATenDispatch().getOpTable("aten::_standard_gamma(Tensor self, Generator? generator=None) -> Tensor");
    return table->getOp<Tensor (const Tensor &, Generator *)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, generator);
}
static inline Tensor _dirichlet_grad(const Tensor & x, const Tensor & alpha, const Tensor & total) {
    static auto table = globalATenDispatch().getOpTable("aten::_dirichlet_grad(Tensor x, Tensor alpha, Tensor total) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &)>(at::detail::infer_backend(x), at::detail::infer_is_variable(x))(x, alpha, total);
}
static inline Tensor _sample_dirichlet(const Tensor & self, Generator * generator) {
    static auto table = globalATenDispatch().getOpTable("aten::_sample_dirichlet(Tensor self, Generator? generator=None) -> Tensor");
    return table->getOp<Tensor (const Tensor &, Generator *)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, generator);
}
static inline Tensor poisson(const Tensor & self, Generator * generator) {
    static auto table = globalATenDispatch().getOpTable("aten::poisson(Tensor self, Generator? generator=None) -> Tensor");
    return table->getOp<Tensor (const Tensor &, Generator *)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, generator);
}
static inline Tensor native_norm(const Tensor & self, Scalar p) {
    static auto table = globalATenDispatch().getOpTable("aten::native_norm(Tensor self, Scalar p=2) -> Tensor");
    return table->getOp<Tensor (const Tensor &, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, p);
}
static inline Tensor _sparse_sum(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::_sparse_sum(Tensor self) -> Tensor");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor _sparse_sum(const Tensor & self, ScalarType dtype) {
    static auto table = globalATenDispatch().getOpTable("aten::_sparse_sum(Tensor self, *, ScalarType dtype) -> Tensor");
    return table->getOp<Tensor (const Tensor &, ScalarType)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dtype);
}
static inline Tensor _sparse_sum(const Tensor & self, IntArrayRef dim) {
    static auto table = globalATenDispatch().getOpTable("aten::_sparse_sum(Tensor self, int[1] dim) -> Tensor");
    return table->getOp<Tensor (const Tensor &, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dim);
}
static inline Tensor _sparse_sum(const Tensor & self, IntArrayRef dim, ScalarType dtype) {
    static auto table = globalATenDispatch().getOpTable("aten::_sparse_sum(Tensor self, int[1] dim, *, ScalarType dtype) -> Tensor");
    return table->getOp<Tensor (const Tensor &, IntArrayRef, ScalarType)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dim, dtype);
}
static inline Tensor _sparse_sum_backward(const Tensor & grad, const Tensor & self, IntArrayRef dim) {
    static auto table = globalATenDispatch().getOpTable("aten::_sparse_sum_backward(Tensor grad, Tensor self, int[] dim) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad, self, dim);
}
static inline Tensor norm(const Tensor & self, c10::optional<Scalar> p, ScalarType dtype) {
    static auto table = globalATenDispatch().getOpTable("aten::norm(Tensor self, Scalar? p, *, ScalarType dtype) -> Tensor");
    return table->getOp<Tensor (const Tensor &, c10::optional<Scalar>, ScalarType)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, p, dtype);
}
static inline Tensor norm(const Tensor & self, Scalar p) {
    static auto table = globalATenDispatch().getOpTable("aten::norm(Tensor self, Scalar p=2) -> Tensor");
    return table->getOp<Tensor (const Tensor &, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, p);
}
static inline Tensor norm(const Tensor & self, c10::optional<Scalar> p, IntArrayRef dim, bool keepdim, ScalarType dtype) {
    static auto table = globalATenDispatch().getOpTable("aten::norm(Tensor self, Scalar? p, int[1] dim, bool keepdim, *, ScalarType dtype) -> Tensor");
    return table->getOp<Tensor (const Tensor &, c10::optional<Scalar>, IntArrayRef, bool, ScalarType)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, p, dim, keepdim, dtype);
}
static inline Tensor norm(const Tensor & self, c10::optional<Scalar> p, IntArrayRef dim, bool keepdim) {
    static auto table = globalATenDispatch().getOpTable("aten::norm(Tensor self, Scalar? p, int[1] dim, bool keepdim=False) -> Tensor");
    return table->getOp<Tensor (const Tensor &, c10::optional<Scalar>, IntArrayRef, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, p, dim, keepdim);
}
static inline Tensor & norm_out(Tensor & out, const Tensor & self, c10::optional<Scalar> p, IntArrayRef dim, bool keepdim, ScalarType dtype) {
    static auto table = globalATenDispatch().getOpTable("aten::norm(Tensor self, Scalar? p, int[1] dim, bool keepdim, *, ScalarType dtype, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, c10::optional<Scalar>, IntArrayRef, bool, ScalarType)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, p, dim, keepdim, dtype);
}
static inline Tensor & norm_out(Tensor & out, const Tensor & self, c10::optional<Scalar> p, IntArrayRef dim, bool keepdim) {
    static auto table = globalATenDispatch().getOpTable("aten::norm(Tensor self, Scalar? p, int[1] dim, bool keepdim=False, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, c10::optional<Scalar>, IntArrayRef, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, p, dim, keepdim);
}
static inline Tensor frobenius_norm(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::frobenius_norm(Tensor self) -> Tensor");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor frobenius_norm(const Tensor & self, IntArrayRef dim, bool keepdim) {
    static auto table = globalATenDispatch().getOpTable("aten::frobenius_norm(Tensor self, int[1] dim, bool keepdim=False) -> Tensor");
    return table->getOp<Tensor (const Tensor &, IntArrayRef, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dim, keepdim);
}
static inline Tensor & frobenius_norm_out(Tensor & out, const Tensor & self, IntArrayRef dim, bool keepdim) {
    static auto table = globalATenDispatch().getOpTable("aten::frobenius_norm(Tensor self, int[1] dim, bool keepdim=False, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, IntArrayRef, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, dim, keepdim);
}
static inline Tensor nuclear_norm(const Tensor & self, bool keepdim) {
    static auto table = globalATenDispatch().getOpTable("aten::nuclear_norm(Tensor self, bool keepdim=False) -> Tensor");
    return table->getOp<Tensor (const Tensor &, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, keepdim);
}
static inline Tensor & nuclear_norm_out(Tensor & out, const Tensor & self, bool keepdim) {
    static auto table = globalATenDispatch().getOpTable("aten::nuclear_norm(Tensor self, bool keepdim=False, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, keepdim);
}
static inline Tensor nuclear_norm(const Tensor & self, IntArrayRef dim, bool keepdim) {
    static auto table = globalATenDispatch().getOpTable("aten::nuclear_norm(Tensor self, int[2] dim, bool keepdim=False) -> Tensor");
    return table->getOp<Tensor (const Tensor &, IntArrayRef, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dim, keepdim);
}
static inline Tensor & nuclear_norm_out(Tensor & out, const Tensor & self, IntArrayRef dim, bool keepdim) {
    static auto table = globalATenDispatch().getOpTable("aten::nuclear_norm(Tensor self, int[2] dim, bool keepdim=False, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, IntArrayRef, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, dim, keepdim);
}
static inline Tensor clone(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::clone(Tensor self) -> Tensor");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & resize_as_(Tensor & self, const Tensor & the_template) {
    static auto table = globalATenDispatch().getOpTable("aten::resize_as_(Tensor(a!) self, Tensor the_template) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, the_template);
}
static inline Tensor & pow_out(Tensor & out, const Tensor & self, Scalar exponent) {
    static auto table = globalATenDispatch().getOpTable("aten::pow(Tensor self, Scalar exponent, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, exponent);
}
static inline Tensor pow(const Tensor & self, Scalar exponent) {
    static auto table = globalATenDispatch().getOpTable("aten::pow(Tensor self, Scalar exponent) -> Tensor");
    return table->getOp<Tensor (const Tensor &, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, exponent);
}
static inline Tensor & zero_(Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::zero_(Tensor(a!) self) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & sub_out(Tensor & out, const Tensor & self, const Tensor & other, Scalar alpha) {
    static auto table = globalATenDispatch().getOpTable("aten::sub(Tensor self, Tensor other, *, Scalar alpha=1, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, other, alpha);
}
static inline Tensor sub(const Tensor & self, const Tensor & other, Scalar alpha) {
    static auto table = globalATenDispatch().getOpTable("aten::sub(Tensor self, Tensor other, *, Scalar alpha=1) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, other, alpha);
}
static inline Tensor sub(const Tensor & self, Scalar other, Scalar alpha) {
    static auto table = globalATenDispatch().getOpTable("aten::sub(Tensor self, Scalar other, Scalar alpha=1) -> Tensor");
    return table->getOp<Tensor (const Tensor &, Scalar, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, other, alpha);
}
static inline Tensor rsub(const Tensor & self, const Tensor & other, Scalar alpha) {
    static auto table = globalATenDispatch().getOpTable("aten::rsub(Tensor self, Tensor other, *, Scalar alpha=1) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, other, alpha);
}
static inline Tensor rsub(const Tensor & self, Scalar other, Scalar alpha) {
    static auto table = globalATenDispatch().getOpTable("aten::rsub(Tensor self, Scalar other, Scalar alpha=1) -> Tensor");
    return table->getOp<Tensor (const Tensor &, Scalar, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, other, alpha);
}
static inline Tensor & s_native_addmm_out(Tensor & out, const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta, Scalar alpha) {
    static auto table = globalATenDispatch().getOpTable("aten::s_native_addmm(Tensor self, Tensor mat1, Tensor mat2, *, Scalar beta=1, Scalar alpha=1, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, const Tensor &, Scalar, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, mat1, mat2, beta, alpha);
}
static inline Tensor s_native_addmm(const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta, Scalar alpha) {
    static auto table = globalATenDispatch().getOpTable("aten::s_native_addmm(Tensor self, Tensor mat1, Tensor mat2, *, Scalar beta=1, Scalar alpha=1) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, Scalar, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, mat1, mat2, beta, alpha);
}
static inline Tensor & s_native_addmm_(Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta, Scalar alpha) {
    static auto table = globalATenDispatch().getOpTable("aten::s_native_addmm_(Tensor(a!) self, Tensor mat1, Tensor mat2, *, Scalar beta=1, Scalar alpha=1) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, Scalar, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, mat1, mat2, beta, alpha);
}
static inline Tensor _sparse_addmm(const Tensor & self, const Tensor & sparse, const Tensor & dense, Scalar beta, Scalar alpha) {
    static auto table = globalATenDispatch().getOpTable("aten::_sparse_addmm(Tensor self, Tensor sparse, Tensor dense, *, Scalar beta=1, Scalar alpha=1) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, Scalar, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, sparse, dense, beta, alpha);
}
static inline Tensor & addmm_out(Tensor & out, const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta, Scalar alpha) {
    static auto table = globalATenDispatch().getOpTable("aten::addmm(Tensor self, Tensor mat1, Tensor mat2, *, Scalar beta=1, Scalar alpha=1, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, const Tensor &, Scalar, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, mat1, mat2, beta, alpha);
}
static inline Tensor addmm(const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta, Scalar alpha) {
    static auto table = globalATenDispatch().getOpTable("aten::addmm(Tensor self, Tensor mat1, Tensor mat2, *, Scalar beta=1, Scalar alpha=1) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, Scalar, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, mat1, mat2, beta, alpha);
}
static inline Tensor sparse_coo_tensor(IntArrayRef size, const TensorOptions & options) {
    globalLegacyTypeDispatch().initForBackend(options.backend());
    static auto table = globalATenDispatch().getOpTable("aten::sparse_coo_tensor(int[] size, *, ScalarType dtype, Layout layout, Device device, bool pin_memory=False) -> Tensor");
    return table->getOp<Tensor (IntArrayRef, const TensorOptions &)>(options.backend(), options.is_variable())(size, options);
}
static inline Tensor sparse_coo_tensor(const Tensor & indices, const Tensor & values, const TensorOptions & options) {
    globalLegacyTypeDispatch().initForBackend(options.backend());
    static auto table = globalATenDispatch().getOpTable("aten::sparse_coo_tensor(Tensor indices, Tensor values, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const TensorOptions &)>(options.backend(), options.is_variable())(indices, values, options);
}
static inline Tensor sparse_coo_tensor(const Tensor & indices, const Tensor & values, IntArrayRef size, const TensorOptions & options) {
    globalLegacyTypeDispatch().initForBackend(options.backend());
    static auto table = globalATenDispatch().getOpTable("aten::sparse_coo_tensor(Tensor indices, Tensor values, int[] size, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, IntArrayRef, const TensorOptions &)>(options.backend(), options.is_variable())(indices, values, size, options);
}
static inline Tensor _sparse_coo_tensor_unsafe(const Tensor & indices, const Tensor & values, IntArrayRef size, const TensorOptions & options) {
    globalLegacyTypeDispatch().initForBackend(options.backend());
    static auto table = globalATenDispatch().getOpTable("aten::_sparse_coo_tensor_unsafe(Tensor indices, Tensor values, int[] size, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, IntArrayRef, const TensorOptions &)>(options.backend(), options.is_variable())(indices, values, size, options);
}
static inline Tensor _sparse_coo_tensor_with_dims(int64_t sparse_dim, int64_t dense_dim, IntArrayRef size, const TensorOptions & options) {
    globalLegacyTypeDispatch().initForBackend(options.backend());
    static auto table = globalATenDispatch().getOpTable("aten::_sparse_coo_tensor_with_dims(int sparse_dim, int dense_dim, int[] size, *, ScalarType dtype, Layout layout, Device device, bool pin_memory=False) -> Tensor");
    return table->getOp<Tensor (int64_t, int64_t, IntArrayRef, const TensorOptions &)>(options.backend(), options.is_variable())(sparse_dim, dense_dim, size, options);
}
static inline Tensor _sparse_coo_tensor_with_dims_and_tensors(int64_t sparse_dim, int64_t dense_dim, IntArrayRef size, const Tensor & indices, const Tensor & values, const TensorOptions & options) {
    globalLegacyTypeDispatch().initForBackend(options.backend());
    static auto table = globalATenDispatch().getOpTable("aten::_sparse_coo_tensor_with_dims_and_tensors(int sparse_dim, int dense_dim, int[] size, Tensor indices, Tensor values, *, ScalarType dtype, Layout layout, Device device, bool pin_memory=False) -> Tensor");
    return table->getOp<Tensor (int64_t, int64_t, IntArrayRef, const Tensor &, const Tensor &, const TensorOptions &)>(options.backend(), options.is_variable())(sparse_dim, dense_dim, size, indices, values, options);
}
static inline Tensor to_dense_backward(const Tensor & grad, const Tensor & input) {
    static auto table = globalATenDispatch().getOpTable("aten::to_dense_backward(Tensor grad, Tensor input) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &)>(at::detail::infer_backend(grad), at::detail::infer_is_variable(grad))(grad, input);
}
static inline Tensor & hspmm_out(Tensor & out, const Tensor & mat1, const Tensor & mat2) {
    static auto table = globalATenDispatch().getOpTable("aten::hspmm(Tensor mat1, Tensor mat2, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &)>(at::detail::infer_backend(out), at::detail::infer_is_variable(out))(out, mat1, mat2);
}
static inline Tensor hspmm(const Tensor & mat1, const Tensor & mat2) {
    static auto table = globalATenDispatch().getOpTable("aten::hspmm(Tensor mat1, Tensor mat2) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &)>(at::detail::infer_backend(mat1), at::detail::infer_is_variable(mat1))(mat1, mat2);
}
static inline Tensor & copy_sparse_to_sparse_(Tensor & self, const Tensor & src, bool non_blocking) {
    static auto table = globalATenDispatch().getOpTable("aten::copy_sparse_to_sparse_(Tensor(a!) self, Tensor src, bool non_blocking=False) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, src, non_blocking);
}
static inline int64_t numel(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::numel(Tensor self) -> int");
    return table->getOp<int64_t (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline std::vector<Tensor> unbind(const Tensor & self, int64_t dim) {
    static auto table = globalATenDispatch().getOpTable("aten::unbind(Tensor(a) self, int dim=0) -> Tensor(a)[]");
    return table->getOp<std::vector<Tensor> (const Tensor &, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dim);
}
static inline Tensor mkldnn_reorder_conv2d_weight(const Tensor & self, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups) {
    static auto table = globalATenDispatch().getOpTable("aten::mkldnn_reorder_conv2d_weight(Tensor self, int[2] padding=0, int[2] stride=1, int[2] dilation=1, int groups=1) -> Tensor");
    return table->getOp<Tensor (const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, padding, stride, dilation, groups);
}
static inline Tensor to_mkldnn_backward(const Tensor & grad, const Tensor & input) {
    static auto table = globalATenDispatch().getOpTable("aten::to_mkldnn_backward(Tensor grad, Tensor input) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &)>(at::detail::infer_backend(grad), at::detail::infer_is_variable(grad))(grad, input);
}
static inline Tensor quantize_linear(const Tensor & self, double scale, int64_t zero_point, ScalarType dtype) {
    static auto table = globalATenDispatch().getOpTable("aten::quantize_linear(Tensor self, float scale, int zero_point, ScalarType dtype) -> Tensor");
    return table->getOp<Tensor (const Tensor &, double, int64_t, ScalarType)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, scale, zero_point, dtype);
}
static inline Tensor quantize_linear_per_channel(const Tensor & self, const Tensor & scales, const Tensor & zero_points, IntArrayRef axis, ScalarType dtype) {
    static auto table = globalATenDispatch().getOpTable("aten::quantize_linear_per_channel(Tensor self, Tensor scales, Tensor zero_points, int[] axis, ScalarType dtype) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, IntArrayRef, ScalarType)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, scales, zero_points, axis, dtype);
}
static inline Tensor dequantize(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::dequantize(Tensor self) -> Tensor");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor _dequantize_linear(const Tensor & self, double scale, int64_t zero_point, ScalarType dtype) {
    static auto table = globalATenDispatch().getOpTable("aten::_dequantize_linear(Tensor self, float scale, int zero_point, ScalarType dtype) -> Tensor");
    return table->getOp<Tensor (const Tensor &, double, int64_t, ScalarType)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, scale, zero_point, dtype);
}
static inline double q_scale(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::q_scale(Tensor self) -> float");
    return table->getOp<double (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline int64_t q_zero_point(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::q_zero_point(Tensor self) -> int");
    return table->getOp<int64_t (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor int_repr(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::int_repr(Tensor self) -> Tensor");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor _per_tensor_affine_qtensor(const Tensor & self, double scale, int64_t zero_point) {
    static auto table = globalATenDispatch().getOpTable("aten::_per_tensor_affine_qtensor(Tensor self, float scale, int zero_point) -> Tensor");
    return table->getOp<Tensor (const Tensor &, double, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, scale, zero_point);
}
static inline Tensor fake_quantize_per_tensor_affine(const Tensor & self, double scale, int64_t zero_point, int64_t quant_min, int64_t quant_max) {
    static auto table = globalATenDispatch().getOpTable("aten::fake_quantize_per_tensor_affine(Tensor self, float scale, int zero_point, int quant_min, int quant_max) -> Tensor");
    return table->getOp<Tensor (const Tensor &, double, int64_t, int64_t, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, scale, zero_point, quant_min, quant_max);
}
static inline Tensor fake_quantize_per_tensor_affine_backward(const Tensor & grad, const Tensor & self, double scale, int64_t zero_point, int64_t quant_min, int64_t quant_max) {
    static auto table = globalATenDispatch().getOpTable("aten::fake_quantize_per_tensor_affine_backward(Tensor grad, Tensor self, float scale, int zero_point, int quant_min, int quant_max) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, double, int64_t, int64_t, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad, self, scale, zero_point, quant_min, quant_max);
}
static inline std::vector<Tensor> meshgrid(TensorList tensors) {
    static auto table = globalATenDispatch().getOpTable("aten::meshgrid(Tensor[] tensors) -> Tensor[]");
    return table->getOp<std::vector<Tensor> (TensorList)>(at::detail::infer_backend(tensors), at::detail::infer_is_variable(tensors))(tensors);
}
static inline Tensor cartesian_prod(TensorList tensors) {
    static auto table = globalATenDispatch().getOpTable("aten::cartesian_prod(Tensor[] tensors) -> Tensor");
    return table->getOp<Tensor (TensorList)>(at::detail::infer_backend(tensors), at::detail::infer_is_variable(tensors))(tensors);
}
static inline Tensor combinations(const Tensor & self, int64_t r, bool with_replacement) {
    static auto table = globalATenDispatch().getOpTable("aten::combinations(Tensor self, int r=2, bool with_replacement=False) -> Tensor");
    return table->getOp<Tensor (const Tensor &, int64_t, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, r, with_replacement);
}
static inline Scalar _local_scalar_dense(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::_local_scalar_dense(Tensor self) -> Scalar");
    return table->getOp<Scalar (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline std::tuple<Tensor,Tensor,Tensor> _thnn_fused_lstm_cell(const Tensor & input_gates, const Tensor & hidden_gates, const Tensor & cx, const Tensor & input_bias, const Tensor & hidden_bias) {
    static auto table = globalATenDispatch().getOpTable("aten::_thnn_fused_lstm_cell(Tensor input_gates, Tensor hidden_gates, Tensor cx, Tensor? input_bias=None, Tensor? hidden_bias=None) -> (Tensor, Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor,Tensor> (const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &)>(at::detail::infer_backend(input_gates), at::detail::infer_is_variable(input_gates))(input_gates, hidden_gates, cx, input_bias, hidden_bias);
}
static inline std::tuple<Tensor,Tensor,Tensor,Tensor,Tensor> _thnn_fused_lstm_cell_backward(const Tensor & grad_hy, const Tensor & grad_cy, const Tensor & cx, const Tensor & cy, const Tensor & workspace, bool has_bias) {
    static auto table = globalATenDispatch().getOpTable("aten::_thnn_fused_lstm_cell_backward(Tensor? grad_hy, Tensor? grad_cy, Tensor cx, Tensor cy, Tensor workspace, bool has_bias) -> (Tensor, Tensor, Tensor, Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor,Tensor,Tensor,Tensor> (const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, bool)>(at::detail::infer_backend(cx), at::detail::infer_is_variable(cx))(grad_hy, grad_cy, cx, cy, workspace, has_bias);
}
static inline std::tuple<Tensor,Tensor> _thnn_fused_gru_cell(const Tensor & input_gates, const Tensor & hidden_gates, const Tensor & hx, const Tensor & input_bias, const Tensor & hidden_bias) {
    static auto table = globalATenDispatch().getOpTable("aten::_thnn_fused_gru_cell(Tensor input_gates, Tensor hidden_gates, Tensor hx, Tensor? input_bias=None, Tensor? hidden_bias=None) -> (Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor> (const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &)>(at::detail::infer_backend(input_gates), at::detail::infer_is_variable(input_gates))(input_gates, hidden_gates, hx, input_bias, hidden_bias);
}
static inline std::tuple<Tensor,Tensor,Tensor,Tensor,Tensor> _thnn_fused_gru_cell_backward(const Tensor & grad_hy, const Tensor & workspace, bool has_bias) {
    static auto table = globalATenDispatch().getOpTable("aten::_thnn_fused_gru_cell_backward(Tensor grad_hy, Tensor workspace, bool has_bias) -> (Tensor, Tensor, Tensor, Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor,Tensor,Tensor,Tensor> (const Tensor &, const Tensor &, bool)>(at::detail::infer_backend(grad_hy), at::detail::infer_is_variable(grad_hy))(grad_hy, workspace, has_bias);
}
static inline std::tuple<Tensor,Tensor,Tensor> lstm(const Tensor & input, TensorList hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional, bool batch_first) {
    static auto table = globalATenDispatch().getOpTable("aten::lstm(Tensor input, Tensor[] hx, Tensor[] params, bool has_biases, int num_layers, float dropout, bool train, bool bidirectional, bool batch_first) -> (Tensor, Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor,Tensor> (const Tensor &, TensorList, TensorList, bool, int64_t, double, bool, bool, bool)>(at::detail::infer_backend(input), at::detail::infer_is_variable(input))(input, hx, params, has_biases, num_layers, dropout, train, bidirectional, batch_first);
}
static inline std::tuple<Tensor,Tensor,Tensor> lstm(const Tensor & data, const Tensor & batch_sizes, TensorList hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional) {
    static auto table = globalATenDispatch().getOpTable("aten::lstm(Tensor data, Tensor batch_sizes, Tensor[] hx, Tensor[] params, bool has_biases, int num_layers, float dropout, bool train, bool bidirectional) -> (Tensor, Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor,Tensor> (const Tensor &, const Tensor &, TensorList, TensorList, bool, int64_t, double, bool, bool)>(at::detail::infer_backend(data), at::detail::infer_is_variable(data))(data, batch_sizes, hx, params, has_biases, num_layers, dropout, train, bidirectional);
}
static inline std::tuple<Tensor,Tensor> gru(const Tensor & input, const Tensor & hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional, bool batch_first) {
    static auto table = globalATenDispatch().getOpTable("aten::gru(Tensor input, Tensor hx, Tensor[] params, bool has_biases, int num_layers, float dropout, bool train, bool bidirectional, bool batch_first) -> (Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor> (const Tensor &, const Tensor &, TensorList, bool, int64_t, double, bool, bool, bool)>(at::detail::infer_backend(input), at::detail::infer_is_variable(input))(input, hx, params, has_biases, num_layers, dropout, train, bidirectional, batch_first);
}
static inline std::tuple<Tensor,Tensor> gru(const Tensor & data, const Tensor & batch_sizes, const Tensor & hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional) {
    static auto table = globalATenDispatch().getOpTable("aten::gru(Tensor data, Tensor batch_sizes, Tensor hx, Tensor[] params, bool has_biases, int num_layers, float dropout, bool train, bool bidirectional) -> (Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor> (const Tensor &, const Tensor &, const Tensor &, TensorList, bool, int64_t, double, bool, bool)>(at::detail::infer_backend(data), at::detail::infer_is_variable(data))(data, batch_sizes, hx, params, has_biases, num_layers, dropout, train, bidirectional);
}
static inline std::tuple<Tensor,Tensor> rnn_tanh(const Tensor & input, const Tensor & hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional, bool batch_first) {
    static auto table = globalATenDispatch().getOpTable("aten::rnn_tanh(Tensor input, Tensor hx, Tensor[] params, bool has_biases, int num_layers, float dropout, bool train, bool bidirectional, bool batch_first) -> (Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor> (const Tensor &, const Tensor &, TensorList, bool, int64_t, double, bool, bool, bool)>(at::detail::infer_backend(input), at::detail::infer_is_variable(input))(input, hx, params, has_biases, num_layers, dropout, train, bidirectional, batch_first);
}
static inline std::tuple<Tensor,Tensor> rnn_tanh(const Tensor & data, const Tensor & batch_sizes, const Tensor & hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional) {
    static auto table = globalATenDispatch().getOpTable("aten::rnn_tanh(Tensor data, Tensor batch_sizes, Tensor hx, Tensor[] params, bool has_biases, int num_layers, float dropout, bool train, bool bidirectional) -> (Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor> (const Tensor &, const Tensor &, const Tensor &, TensorList, bool, int64_t, double, bool, bool)>(at::detail::infer_backend(data), at::detail::infer_is_variable(data))(data, batch_sizes, hx, params, has_biases, num_layers, dropout, train, bidirectional);
}
static inline std::tuple<Tensor,Tensor> rnn_relu(const Tensor & input, const Tensor & hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional, bool batch_first) {
    static auto table = globalATenDispatch().getOpTable("aten::rnn_relu(Tensor input, Tensor hx, Tensor[] params, bool has_biases, int num_layers, float dropout, bool train, bool bidirectional, bool batch_first) -> (Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor> (const Tensor &, const Tensor &, TensorList, bool, int64_t, double, bool, bool, bool)>(at::detail::infer_backend(input), at::detail::infer_is_variable(input))(input, hx, params, has_biases, num_layers, dropout, train, bidirectional, batch_first);
}
static inline std::tuple<Tensor,Tensor> rnn_relu(const Tensor & data, const Tensor & batch_sizes, const Tensor & hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional) {
    static auto table = globalATenDispatch().getOpTable("aten::rnn_relu(Tensor data, Tensor batch_sizes, Tensor hx, Tensor[] params, bool has_biases, int num_layers, float dropout, bool train, bool bidirectional) -> (Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor> (const Tensor &, const Tensor &, const Tensor &, TensorList, bool, int64_t, double, bool, bool)>(at::detail::infer_backend(data), at::detail::infer_is_variable(data))(data, batch_sizes, hx, params, has_biases, num_layers, dropout, train, bidirectional);
}
static inline std::tuple<Tensor,Tensor> lstm_cell(const Tensor & input, TensorList hx, const Tensor & w_ih, const Tensor & w_hh, const Tensor & b_ih, const Tensor & b_hh) {
    static auto table = globalATenDispatch().getOpTable("aten::lstm_cell(Tensor input, Tensor[] hx, Tensor w_ih, Tensor w_hh, Tensor? b_ih=None, Tensor? b_hh=None) -> (Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor> (const Tensor &, TensorList, const Tensor &, const Tensor &, const Tensor &, const Tensor &)>(at::detail::infer_backend(input), at::detail::infer_is_variable(input))(input, hx, w_ih, w_hh, b_ih, b_hh);
}
static inline Tensor gru_cell(const Tensor & input, const Tensor & hx, const Tensor & w_ih, const Tensor & w_hh, const Tensor & b_ih, const Tensor & b_hh) {
    static auto table = globalATenDispatch().getOpTable("aten::gru_cell(Tensor input, Tensor hx, Tensor w_ih, Tensor w_hh, Tensor? b_ih=None, Tensor? b_hh=None) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &)>(at::detail::infer_backend(input), at::detail::infer_is_variable(input))(input, hx, w_ih, w_hh, b_ih, b_hh);
}
static inline Tensor rnn_tanh_cell(const Tensor & input, const Tensor & hx, const Tensor & w_ih, const Tensor & w_hh, const Tensor & b_ih, const Tensor & b_hh) {
    static auto table = globalATenDispatch().getOpTable("aten::rnn_tanh_cell(Tensor input, Tensor hx, Tensor w_ih, Tensor w_hh, Tensor? b_ih=None, Tensor? b_hh=None) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &)>(at::detail::infer_backend(input), at::detail::infer_is_variable(input))(input, hx, w_ih, w_hh, b_ih, b_hh);
}
static inline Tensor rnn_relu_cell(const Tensor & input, const Tensor & hx, const Tensor & w_ih, const Tensor & w_hh, const Tensor & b_ih, const Tensor & b_hh) {
    static auto table = globalATenDispatch().getOpTable("aten::rnn_relu_cell(Tensor input, Tensor hx, Tensor w_ih, Tensor w_hh, Tensor? b_ih=None, Tensor? b_hh=None) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &)>(at::detail::infer_backend(input), at::detail::infer_is_variable(input))(input, hx, w_ih, w_hh, b_ih, b_hh);
}
static inline std::tuple<Tensor,Tensor,Tensor> quantized_lstm(const Tensor & input, TensorList hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional, bool batch_first, c10::optional<ScalarType> dtype) {
    static auto table = globalATenDispatch().getOpTable("aten::quantized_lstm(Tensor input, Tensor[] hx, Tensor[] params, bool has_biases, int num_layers, float dropout, bool train, bool bidirectional, bool batch_first, *, ScalarType? dtype=None) -> (Tensor, Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor,Tensor> (const Tensor &, TensorList, TensorList, bool, int64_t, double, bool, bool, bool, c10::optional<ScalarType>)>(at::detail::infer_backend(input), at::detail::infer_is_variable(input))(input, hx, params, has_biases, num_layers, dropout, train, bidirectional, batch_first, dtype);
}
static inline std::tuple<Tensor,Tensor> quantized_gru(const Tensor & input, const Tensor & hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional, bool batch_first) {
    static auto table = globalATenDispatch().getOpTable("aten::quantized_gru(Tensor input, Tensor hx, Tensor[] params, bool has_biases, int num_layers, float dropout, bool train, bool bidirectional, bool batch_first) -> (Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor> (const Tensor &, const Tensor &, TensorList, bool, int64_t, double, bool, bool, bool)>(at::detail::infer_backend(input), at::detail::infer_is_variable(input))(input, hx, params, has_biases, num_layers, dropout, train, bidirectional, batch_first);
}
static inline std::tuple<Tensor,Tensor> quantized_gru(const Tensor & data, const Tensor & batch_sizes, const Tensor & hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional) {
    static auto table = globalATenDispatch().getOpTable("aten::quantized_gru(Tensor data, Tensor batch_sizes, Tensor hx, Tensor[] params, bool has_biases, int num_layers, float dropout, bool train, bool bidirectional) -> (Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor> (const Tensor &, const Tensor &, const Tensor &, TensorList, bool, int64_t, double, bool, bool)>(at::detail::infer_backend(data), at::detail::infer_is_variable(data))(data, batch_sizes, hx, params, has_biases, num_layers, dropout, train, bidirectional);
}
static inline std::tuple<Tensor,Tensor> quantized_lstm_cell(const Tensor & input, TensorList hx, const Tensor & w_ih, const Tensor & w_hh, const Tensor & b_ih, const Tensor & b_hh, const Tensor & packed_ih, const Tensor & packed_hh, const Tensor & col_offsets_ih, const Tensor & col_offsets_hh, Scalar scale_ih, Scalar scale_hh, Scalar zero_point_ih, Scalar zero_point_hh) {
    static auto table = globalATenDispatch().getOpTable("aten::quantized_lstm_cell(Tensor input, Tensor[] hx, Tensor w_ih, Tensor w_hh, Tensor b_ih, Tensor b_hh, Tensor packed_ih, Tensor packed_hh, Tensor col_offsets_ih, Tensor col_offsets_hh, Scalar scale_ih, Scalar scale_hh, Scalar zero_point_ih, Scalar zero_point_hh) -> (Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor> (const Tensor &, TensorList, const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, Scalar, Scalar, Scalar, Scalar)>(at::detail::infer_backend(input), at::detail::infer_is_variable(input))(input, hx, w_ih, w_hh, b_ih, b_hh, packed_ih, packed_hh, col_offsets_ih, col_offsets_hh, scale_ih, scale_hh, zero_point_ih, zero_point_hh);
}
static inline Tensor quantized_gru_cell(const Tensor & input, const Tensor & hx, const Tensor & w_ih, const Tensor & w_hh, const Tensor & b_ih, const Tensor & b_hh, const Tensor & packed_ih, const Tensor & packed_hh, const Tensor & col_offsets_ih, const Tensor & col_offsets_hh, Scalar scale_ih, Scalar scale_hh, Scalar zero_point_ih, Scalar zero_point_hh) {
    static auto table = globalATenDispatch().getOpTable("aten::quantized_gru_cell(Tensor input, Tensor hx, Tensor w_ih, Tensor w_hh, Tensor b_ih, Tensor b_hh, Tensor packed_ih, Tensor packed_hh, Tensor col_offsets_ih, Tensor col_offsets_hh, Scalar scale_ih, Scalar scale_hh, Scalar zero_point_ih, Scalar zero_point_hh) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, Scalar, Scalar, Scalar, Scalar)>(at::detail::infer_backend(input), at::detail::infer_is_variable(input))(input, hx, w_ih, w_hh, b_ih, b_hh, packed_ih, packed_hh, col_offsets_ih, col_offsets_hh, scale_ih, scale_hh, zero_point_ih, zero_point_hh);
}
static inline Tensor quantized_rnn_relu_cell(const Tensor & input, const Tensor & hx, const Tensor & w_ih, const Tensor & w_hh, const Tensor & b_ih, const Tensor & b_hh, const Tensor & packed_ih, const Tensor & packed_hh, const Tensor & col_offsets_ih, const Tensor & col_offsets_hh, Scalar scale_ih, Scalar scale_hh, Scalar zero_point_ih, Scalar zero_point_hh) {
    static auto table = globalATenDispatch().getOpTable("aten::quantized_rnn_relu_cell(Tensor input, Tensor hx, Tensor w_ih, Tensor w_hh, Tensor b_ih, Tensor b_hh, Tensor packed_ih, Tensor packed_hh, Tensor col_offsets_ih, Tensor col_offsets_hh, Scalar scale_ih, Scalar scale_hh, Scalar zero_point_ih, Scalar zero_point_hh) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, Scalar, Scalar, Scalar, Scalar)>(at::detail::infer_backend(input), at::detail::infer_is_variable(input))(input, hx, w_ih, w_hh, b_ih, b_hh, packed_ih, packed_hh, col_offsets_ih, col_offsets_hh, scale_ih, scale_hh, zero_point_ih, zero_point_hh);
}
static inline Tensor quantized_rnn_tanh_cell(const Tensor & input, const Tensor & hx, const Tensor & w_ih, const Tensor & w_hh, const Tensor & b_ih, const Tensor & b_hh, const Tensor & packed_ih, const Tensor & packed_hh, const Tensor & col_offsets_ih, const Tensor & col_offsets_hh, Scalar scale_ih, Scalar scale_hh, Scalar zero_point_ih, Scalar zero_point_hh) {
    static auto table = globalATenDispatch().getOpTable("aten::quantized_rnn_tanh_cell(Tensor input, Tensor hx, Tensor w_ih, Tensor w_hh, Tensor b_ih, Tensor b_hh, Tensor packed_ih, Tensor packed_hh, Tensor col_offsets_ih, Tensor col_offsets_hh, Scalar scale_ih, Scalar scale_hh, Scalar zero_point_ih, Scalar zero_point_hh) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, Scalar, Scalar, Scalar, Scalar)>(at::detail::infer_backend(input), at::detail::infer_is_variable(input))(input, hx, w_ih, w_hh, b_ih, b_hh, packed_ih, packed_hh, col_offsets_ih, col_offsets_hh, scale_ih, scale_hh, zero_point_ih, zero_point_hh);
}
static inline std::tuple<Tensor,Tensor> _pack_padded_sequence(const Tensor & input, const Tensor & lengths, bool batch_first) {
    static auto table = globalATenDispatch().getOpTable("aten::_pack_padded_sequence(Tensor input, Tensor lengths, bool batch_first) -> (Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor> (const Tensor &, const Tensor &, bool)>(at::detail::infer_backend(input), at::detail::infer_is_variable(input))(input, lengths, batch_first);
}
static inline Tensor _pack_padded_sequence_backward(const Tensor & grad, IntArrayRef input_size, const Tensor & batch_sizes, bool batch_first) {
    static auto table = globalATenDispatch().getOpTable("aten::_pack_padded_sequence_backward(Tensor grad, int[] input_size, Tensor batch_sizes, bool batch_first) -> Tensor");
    return table->getOp<Tensor (const Tensor &, IntArrayRef, const Tensor &, bool)>(at::detail::infer_backend(grad), at::detail::infer_is_variable(grad))(grad, input_size, batch_sizes, batch_first);
}
static inline std::tuple<Tensor,Tensor> _pad_packed_sequence(const Tensor & data, const Tensor & batch_sizes, bool batch_first, Scalar padding_value, int64_t total_length) {
    static auto table = globalATenDispatch().getOpTable("aten::_pad_packed_sequence(Tensor data, Tensor batch_sizes, bool batch_first, Scalar padding_value, int total_length) -> (Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor> (const Tensor &, const Tensor &, bool, Scalar, int64_t)>(at::detail::infer_backend(data), at::detail::infer_is_variable(data))(data, batch_sizes, batch_first, padding_value, total_length);
}
static inline Tensor masked_fill(const Tensor & self, const Tensor & mask, Scalar value) {
    static auto table = globalATenDispatch().getOpTable("aten::masked_fill(Tensor self, Tensor mask, Scalar value) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, mask, value);
}
static inline Tensor masked_fill(const Tensor & self, const Tensor & mask, const Tensor & value) {
    static auto table = globalATenDispatch().getOpTable("aten::masked_fill(Tensor self, Tensor mask, Tensor value) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, mask, value);
}
static inline Tensor masked_scatter(const Tensor & self, const Tensor & mask, const Tensor & source) {
    static auto table = globalATenDispatch().getOpTable("aten::masked_scatter(Tensor self, Tensor mask, Tensor source) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, mask, source);
}
static inline Tensor index_add(const Tensor & self, int64_t dim, const Tensor & index, const Tensor & source) {
    static auto table = globalATenDispatch().getOpTable("aten::index_add(Tensor self, int dim, Tensor index, Tensor source) -> Tensor");
    return table->getOp<Tensor (const Tensor &, int64_t, const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dim, index, source);
}
static inline Tensor index_fill(const Tensor & self, int64_t dim, const Tensor & index, Scalar value) {
    static auto table = globalATenDispatch().getOpTable("aten::index_fill(Tensor self, int dim, Tensor index, Scalar value) -> Tensor");
    return table->getOp<Tensor (const Tensor &, int64_t, const Tensor &, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dim, index, value);
}
static inline Tensor index_fill(const Tensor & self, int64_t dim, const Tensor & index, const Tensor & value) {
    static auto table = globalATenDispatch().getOpTable("aten::index_fill(Tensor self, int dim, Tensor index, Tensor value) -> Tensor");
    return table->getOp<Tensor (const Tensor &, int64_t, const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dim, index, value);
}
static inline Tensor scatter(const Tensor & self, int64_t dim, const Tensor & index, const Tensor & src) {
    static auto table = globalATenDispatch().getOpTable("aten::scatter(Tensor self, int dim, Tensor index, Tensor src) -> Tensor");
    return table->getOp<Tensor (const Tensor &, int64_t, const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dim, index, src);
}
static inline Tensor scatter(const Tensor & self, int64_t dim, const Tensor & index, Scalar value) {
    static auto table = globalATenDispatch().getOpTable("aten::scatter(Tensor self, int dim, Tensor index, Scalar value) -> Tensor");
    return table->getOp<Tensor (const Tensor &, int64_t, const Tensor &, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dim, index, value);
}
static inline Tensor scatter_add(const Tensor & self, int64_t dim, const Tensor & index, const Tensor & src) {
    static auto table = globalATenDispatch().getOpTable("aten::scatter_add(Tensor self, int dim, Tensor index, Tensor src) -> Tensor");
    return table->getOp<Tensor (const Tensor &, int64_t, const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dim, index, src);
}
static inline Tensor __and__(const Tensor & self, Scalar other) {
    static auto table = globalATenDispatch().getOpTable("aten::__and__(Tensor self, Scalar other) -> Tensor");
    return table->getOp<Tensor (const Tensor &, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, other);
}
static inline Tensor __and__(const Tensor & self, const Tensor & other) {
    static auto table = globalATenDispatch().getOpTable("aten::__and__(Tensor self, Tensor other) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, other);
}
static inline Tensor __or__(const Tensor & self, Scalar other) {
    static auto table = globalATenDispatch().getOpTable("aten::__or__(Tensor self, Scalar other) -> Tensor");
    return table->getOp<Tensor (const Tensor &, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, other);
}
static inline Tensor __or__(const Tensor & self, const Tensor & other) {
    static auto table = globalATenDispatch().getOpTable("aten::__or__(Tensor self, Tensor other) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, other);
}
static inline Tensor __xor__(const Tensor & self, Scalar other) {
    static auto table = globalATenDispatch().getOpTable("aten::__xor__(Tensor self, Scalar other) -> Tensor");
    return table->getOp<Tensor (const Tensor &, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, other);
}
static inline Tensor __xor__(const Tensor & self, const Tensor & other) {
    static auto table = globalATenDispatch().getOpTable("aten::__xor__(Tensor self, Tensor other) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, other);
}
static inline Tensor __lshift__(const Tensor & self, Scalar other) {
    static auto table = globalATenDispatch().getOpTable("aten::__lshift__(Tensor self, Scalar other) -> Tensor");
    return table->getOp<Tensor (const Tensor &, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, other);
}
static inline Tensor __lshift__(const Tensor & self, const Tensor & other) {
    static auto table = globalATenDispatch().getOpTable("aten::__lshift__(Tensor self, Tensor other) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, other);
}
static inline Tensor __rshift__(const Tensor & self, Scalar other) {
    static auto table = globalATenDispatch().getOpTable("aten::__rshift__(Tensor self, Scalar other) -> Tensor");
    return table->getOp<Tensor (const Tensor &, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, other);
}
static inline Tensor __rshift__(const Tensor & self, const Tensor & other) {
    static auto table = globalATenDispatch().getOpTable("aten::__rshift__(Tensor self, Tensor other) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, other);
}
static inline Tensor & addbmm_out(Tensor & out, const Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta, Scalar alpha) {
    static auto table = globalATenDispatch().getOpTable("aten::addbmm(Tensor self, Tensor batch1, Tensor batch2, *, Scalar beta=1, Scalar alpha=1, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, const Tensor &, Scalar, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, batch1, batch2, beta, alpha);
}
static inline Tensor addbmm(const Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta, Scalar alpha) {
    static auto table = globalATenDispatch().getOpTable("aten::addbmm(Tensor self, Tensor batch1, Tensor batch2, *, Scalar beta=1, Scalar alpha=1) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, Scalar, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, batch1, batch2, beta, alpha);
}
static inline Tensor & diag_out(Tensor & out, const Tensor & self, int64_t diagonal) {
    static auto table = globalATenDispatch().getOpTable("aten::diag(Tensor self, int diagonal=0, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, diagonal);
}
static inline Tensor diag(const Tensor & self, int64_t diagonal) {
    static auto table = globalATenDispatch().getOpTable("aten::diag(Tensor self, int diagonal=0) -> Tensor");
    return table->getOp<Tensor (const Tensor &, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, diagonal);
}
static inline Tensor & cross_out(Tensor & out, const Tensor & self, const Tensor & other, c10::optional<int64_t> dim) {
    static auto table = globalATenDispatch().getOpTable("aten::cross(Tensor self, Tensor other, int? dim=None, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, c10::optional<int64_t>)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, other, dim);
}
static inline Tensor cross(const Tensor & self, const Tensor & other, c10::optional<int64_t> dim) {
    static auto table = globalATenDispatch().getOpTable("aten::cross(Tensor self, Tensor other, int? dim=None) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, c10::optional<int64_t>)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, other, dim);
}
static inline Tensor & triu_out(Tensor & out, const Tensor & self, int64_t diagonal) {
    static auto table = globalATenDispatch().getOpTable("aten::triu(Tensor self, int diagonal=0, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, diagonal);
}
static inline Tensor triu(const Tensor & self, int64_t diagonal) {
    static auto table = globalATenDispatch().getOpTable("aten::triu(Tensor self, int diagonal=0) -> Tensor");
    return table->getOp<Tensor (const Tensor &, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, diagonal);
}
static inline Tensor & tril_out(Tensor & out, const Tensor & self, int64_t diagonal) {
    static auto table = globalATenDispatch().getOpTable("aten::tril(Tensor self, int diagonal=0, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, diagonal);
}
static inline Tensor tril(const Tensor & self, int64_t diagonal) {
    static auto table = globalATenDispatch().getOpTable("aten::tril(Tensor self, int diagonal=0) -> Tensor");
    return table->getOp<Tensor (const Tensor &, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, diagonal);
}
static inline Tensor tril_indices(int64_t row, int64_t col, int64_t offset, const TensorOptions & options) {
    globalLegacyTypeDispatch().initForBackend(options.backend());
    static auto table = globalATenDispatch().getOpTable("aten::tril_indices(int row, int col, int offset=0, *, ScalarType? dtype=long, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor");
    return table->getOp<Tensor (int64_t, int64_t, int64_t, const TensorOptions &)>(options.backend(), options.is_variable())(row, col, offset, options);
}
static inline Tensor triu_indices(int64_t row, int64_t col, int64_t offset, const TensorOptions & options) {
    globalLegacyTypeDispatch().initForBackend(options.backend());
    static auto table = globalATenDispatch().getOpTable("aten::triu_indices(int row, int col, int offset=0, *, ScalarType? dtype=long, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor");
    return table->getOp<Tensor (int64_t, int64_t, int64_t, const TensorOptions &)>(options.backend(), options.is_variable())(row, col, offset, options);
}
static inline Tensor trace(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::trace(Tensor self) -> Tensor");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & ne_out(Tensor & out, const Tensor & self, Scalar other) {
    static auto table = globalATenDispatch().getOpTable("aten::ne(Tensor self, Scalar other, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, other);
}
static inline Tensor ne(const Tensor & self, Scalar other) {
    static auto table = globalATenDispatch().getOpTable("aten::ne(Tensor self, Scalar other) -> Tensor");
    return table->getOp<Tensor (const Tensor &, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, other);
}
static inline Tensor & ne_out(Tensor & out, const Tensor & self, const Tensor & other) {
    static auto table = globalATenDispatch().getOpTable("aten::ne(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, other);
}
static inline Tensor ne(const Tensor & self, const Tensor & other) {
    static auto table = globalATenDispatch().getOpTable("aten::ne(Tensor self, Tensor other) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, other);
}
static inline Tensor & eq_out(Tensor & out, const Tensor & self, Scalar other) {
    static auto table = globalATenDispatch().getOpTable("aten::eq(Tensor self, Scalar other, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, other);
}
static inline Tensor eq(const Tensor & self, Scalar other) {
    static auto table = globalATenDispatch().getOpTable("aten::eq(Tensor self, Scalar other) -> Tensor");
    return table->getOp<Tensor (const Tensor &, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, other);
}
static inline Tensor & eq_out(Tensor & out, const Tensor & self, const Tensor & other) {
    static auto table = globalATenDispatch().getOpTable("aten::eq(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, other);
}
static inline Tensor eq(const Tensor & self, const Tensor & other) {
    static auto table = globalATenDispatch().getOpTable("aten::eq(Tensor self, Tensor other) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, other);
}
static inline Tensor & ge_out(Tensor & out, const Tensor & self, Scalar other) {
    static auto table = globalATenDispatch().getOpTable("aten::ge(Tensor self, Scalar other, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, other);
}
static inline Tensor ge(const Tensor & self, Scalar other) {
    static auto table = globalATenDispatch().getOpTable("aten::ge(Tensor self, Scalar other) -> Tensor");
    return table->getOp<Tensor (const Tensor &, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, other);
}
static inline Tensor & ge_out(Tensor & out, const Tensor & self, const Tensor & other) {
    static auto table = globalATenDispatch().getOpTable("aten::ge(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, other);
}
static inline Tensor ge(const Tensor & self, const Tensor & other) {
    static auto table = globalATenDispatch().getOpTable("aten::ge(Tensor self, Tensor other) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, other);
}
static inline Tensor & le_out(Tensor & out, const Tensor & self, Scalar other) {
    static auto table = globalATenDispatch().getOpTable("aten::le(Tensor self, Scalar other, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, other);
}
static inline Tensor le(const Tensor & self, Scalar other) {
    static auto table = globalATenDispatch().getOpTable("aten::le(Tensor self, Scalar other) -> Tensor");
    return table->getOp<Tensor (const Tensor &, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, other);
}
static inline Tensor & le_out(Tensor & out, const Tensor & self, const Tensor & other) {
    static auto table = globalATenDispatch().getOpTable("aten::le(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, other);
}
static inline Tensor le(const Tensor & self, const Tensor & other) {
    static auto table = globalATenDispatch().getOpTable("aten::le(Tensor self, Tensor other) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, other);
}
static inline Tensor & gt_out(Tensor & out, const Tensor & self, Scalar other) {
    static auto table = globalATenDispatch().getOpTable("aten::gt(Tensor self, Scalar other, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, other);
}
static inline Tensor gt(const Tensor & self, Scalar other) {
    static auto table = globalATenDispatch().getOpTable("aten::gt(Tensor self, Scalar other) -> Tensor");
    return table->getOp<Tensor (const Tensor &, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, other);
}
static inline Tensor & gt_out(Tensor & out, const Tensor & self, const Tensor & other) {
    static auto table = globalATenDispatch().getOpTable("aten::gt(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, other);
}
static inline Tensor gt(const Tensor & self, const Tensor & other) {
    static auto table = globalATenDispatch().getOpTable("aten::gt(Tensor self, Tensor other) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, other);
}
static inline Tensor & lt_out(Tensor & out, const Tensor & self, Scalar other) {
    static auto table = globalATenDispatch().getOpTable("aten::lt(Tensor self, Scalar other, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, other);
}
static inline Tensor lt(const Tensor & self, Scalar other) {
    static auto table = globalATenDispatch().getOpTable("aten::lt(Tensor self, Scalar other) -> Tensor");
    return table->getOp<Tensor (const Tensor &, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, other);
}
static inline Tensor & lt_out(Tensor & out, const Tensor & self, const Tensor & other) {
    static auto table = globalATenDispatch().getOpTable("aten::lt(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, other);
}
static inline Tensor lt(const Tensor & self, const Tensor & other) {
    static auto table = globalATenDispatch().getOpTable("aten::lt(Tensor self, Tensor other) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, other);
}
static inline Tensor & take_out(Tensor & out, const Tensor & self, const Tensor & index) {
    static auto table = globalATenDispatch().getOpTable("aten::take(Tensor self, Tensor index, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, index);
}
static inline Tensor take(const Tensor & self, const Tensor & index) {
    static auto table = globalATenDispatch().getOpTable("aten::take(Tensor self, Tensor index) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, index);
}
static inline Tensor & index_select_out(Tensor & out, const Tensor & self, int64_t dim, const Tensor & index) {
    static auto table = globalATenDispatch().getOpTable("aten::index_select(Tensor self, int dim, Tensor index, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, int64_t, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, dim, index);
}
static inline Tensor index_select(const Tensor & self, int64_t dim, const Tensor & index) {
    static auto table = globalATenDispatch().getOpTable("aten::index_select(Tensor self, int dim, Tensor index) -> Tensor");
    return table->getOp<Tensor (const Tensor &, int64_t, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dim, index);
}
static inline Tensor & masked_select_out(Tensor & out, const Tensor & self, const Tensor & mask) {
    static auto table = globalATenDispatch().getOpTable("aten::masked_select(Tensor self, Tensor mask, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, mask);
}
static inline Tensor masked_select(const Tensor & self, const Tensor & mask) {
    static auto table = globalATenDispatch().getOpTable("aten::masked_select(Tensor self, Tensor mask) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, mask);
}
static inline Tensor & nonzero_out(Tensor & out, const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::nonzero(Tensor self, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self);
}
static inline Tensor nonzero(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::nonzero(Tensor self) -> Tensor");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline std::vector<Tensor> nonzero_numpy(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::nonzero_numpy(Tensor self) -> Tensor[]");
    return table->getOp<std::vector<Tensor> (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & gather_out(Tensor & out, const Tensor & self, int64_t dim, const Tensor & index, bool sparse_grad) {
    static auto table = globalATenDispatch().getOpTable("aten::gather(Tensor self, int dim, Tensor index, *, bool sparse_grad=False, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, int64_t, const Tensor &, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, dim, index, sparse_grad);
}
static inline Tensor gather(const Tensor & self, int64_t dim, const Tensor & index, bool sparse_grad) {
    static auto table = globalATenDispatch().getOpTable("aten::gather(Tensor self, int dim, Tensor index, *, bool sparse_grad=False) -> Tensor");
    return table->getOp<Tensor (const Tensor &, int64_t, const Tensor &, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dim, index, sparse_grad);
}
static inline Tensor _gather_sparse_backward(const Tensor & self, int64_t dim, const Tensor & index, const Tensor & grad) {
    static auto table = globalATenDispatch().getOpTable("aten::_gather_sparse_backward(Tensor self, int dim, Tensor index, Tensor grad) -> Tensor");
    return table->getOp<Tensor (const Tensor &, int64_t, const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dim, index, grad);
}
static inline Tensor & addcmul_out(Tensor & out, const Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value) {
    static auto table = globalATenDispatch().getOpTable("aten::addcmul(Tensor self, Tensor tensor1, Tensor tensor2, *, Scalar value=1, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, const Tensor &, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, tensor1, tensor2, value);
}
static inline Tensor addcmul(const Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value) {
    static auto table = globalATenDispatch().getOpTable("aten::addcmul(Tensor self, Tensor tensor1, Tensor tensor2, *, Scalar value=1) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, tensor1, tensor2, value);
}
static inline Tensor & addcdiv_out(Tensor & out, const Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value) {
    static auto table = globalATenDispatch().getOpTable("aten::addcdiv(Tensor self, Tensor tensor1, Tensor tensor2, *, Scalar value=1, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, const Tensor &, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, tensor1, tensor2, value);
}
static inline Tensor addcdiv(const Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value) {
    static auto table = globalATenDispatch().getOpTable("aten::addcdiv(Tensor self, Tensor tensor1, Tensor tensor2, *, Scalar value=1) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, tensor1, tensor2, value);
}
static inline std::tuple<Tensor &,Tensor &> lstsq_out(Tensor & X, Tensor & qr, const Tensor & self, const Tensor & A) {
    static auto table = globalATenDispatch().getOpTable("aten::lstsq(Tensor self, Tensor A, *, Tensor(a!) X, Tensor(b!) qr) -> (Tensor(a!) solution, Tensor(b!) QR)");
    return table->getOp<std::tuple<Tensor &,Tensor &> (Tensor &, Tensor &, const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(X, qr, self, A);
}
static inline std::tuple<Tensor,Tensor> lstsq(const Tensor & self, const Tensor & A) {
    static auto table = globalATenDispatch().getOpTable("aten::lstsq(Tensor self, Tensor A) -> (Tensor solution, Tensor QR)");
    return table->getOp<std::tuple<Tensor,Tensor> (const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, A);
}
static inline std::tuple<Tensor &,Tensor &> triangular_solve_out(Tensor & X, Tensor & M, const Tensor & self, const Tensor & A, bool upper, bool transpose, bool unitriangular) {
    static auto table = globalATenDispatch().getOpTable("aten::triangular_solve(Tensor self, Tensor A, bool upper=True, bool transpose=False, bool unitriangular=False, *, Tensor(a!) X, Tensor(b!) M) -> (Tensor(a!) solution, Tensor(b!) cloned_coefficient)");
    return table->getOp<std::tuple<Tensor &,Tensor &> (Tensor &, Tensor &, const Tensor &, const Tensor &, bool, bool, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(X, M, self, A, upper, transpose, unitriangular);
}
static inline std::tuple<Tensor,Tensor> triangular_solve(const Tensor & self, const Tensor & A, bool upper, bool transpose, bool unitriangular) {
    static auto table = globalATenDispatch().getOpTable("aten::triangular_solve(Tensor self, Tensor A, bool upper=True, bool transpose=False, bool unitriangular=False) -> (Tensor solution, Tensor cloned_coefficient)");
    return table->getOp<std::tuple<Tensor,Tensor> (const Tensor &, const Tensor &, bool, bool, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, A, upper, transpose, unitriangular);
}
static inline std::tuple<Tensor,Tensor> _triangular_solve_helper(const Tensor & self, const Tensor & A, bool upper, bool transpose, bool unitriangular) {
    static auto table = globalATenDispatch().getOpTable("aten::_triangular_solve_helper(Tensor self, Tensor A, bool upper, bool transpose, bool unitriangular) -> (Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor> (const Tensor &, const Tensor &, bool, bool, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, A, upper, transpose, unitriangular);
}
static inline std::tuple<Tensor &,Tensor &> symeig_out(Tensor & e, Tensor & V, const Tensor & self, bool eigenvectors, bool upper) {
    static auto table = globalATenDispatch().getOpTable("aten::symeig(Tensor self, bool eigenvectors=False, bool upper=True, *, Tensor(a!) e, Tensor(b!) V) -> (Tensor(a!) eigenvalues, Tensor(b!) eigenvectors)");
    return table->getOp<std::tuple<Tensor &,Tensor &> (Tensor &, Tensor &, const Tensor &, bool, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(e, V, self, eigenvectors, upper);
}
static inline std::tuple<Tensor,Tensor> symeig(const Tensor & self, bool eigenvectors, bool upper) {
    static auto table = globalATenDispatch().getOpTable("aten::symeig(Tensor self, bool eigenvectors=False, bool upper=True) -> (Tensor eigenvalues, Tensor eigenvectors)");
    return table->getOp<std::tuple<Tensor,Tensor> (const Tensor &, bool, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, eigenvectors, upper);
}
static inline std::tuple<Tensor,Tensor> _symeig_helper(const Tensor & self, bool eigenvectors, bool upper) {
    static auto table = globalATenDispatch().getOpTable("aten::_symeig_helper(Tensor self, bool eigenvectors, bool upper) -> (Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor> (const Tensor &, bool, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, eigenvectors, upper);
}
static inline std::tuple<Tensor &,Tensor &> eig_out(Tensor & e, Tensor & v, const Tensor & self, bool eigenvectors) {
    static auto table = globalATenDispatch().getOpTable("aten::eig(Tensor self, bool eigenvectors=False, *, Tensor(a!) e, Tensor(b!) v) -> (Tensor(a!) eigenvalues, Tensor(b!) eigenvectors)");
    return table->getOp<std::tuple<Tensor &,Tensor &> (Tensor &, Tensor &, const Tensor &, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(e, v, self, eigenvectors);
}
static inline std::tuple<Tensor,Tensor> eig(const Tensor & self, bool eigenvectors) {
    static auto table = globalATenDispatch().getOpTable("aten::eig(Tensor self, bool eigenvectors=False) -> (Tensor eigenvalues, Tensor eigenvectors)");
    return table->getOp<std::tuple<Tensor,Tensor> (const Tensor &, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, eigenvectors);
}
static inline std::tuple<Tensor &,Tensor &,Tensor &> svd_out(Tensor & U, Tensor & S, Tensor & V, const Tensor & self, bool some, bool compute_uv) {
    static auto table = globalATenDispatch().getOpTable("aten::svd(Tensor self, bool some=True, bool compute_uv=True, *, Tensor(a!) U, Tensor(b!) S, Tensor(c!) V) -> (Tensor(a!) U, Tensor(b!) S, Tensor(c!) V)");
    return table->getOp<std::tuple<Tensor &,Tensor &,Tensor &> (Tensor &, Tensor &, Tensor &, const Tensor &, bool, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(U, S, V, self, some, compute_uv);
}
static inline std::tuple<Tensor,Tensor,Tensor> svd(const Tensor & self, bool some, bool compute_uv) {
    static auto table = globalATenDispatch().getOpTable("aten::svd(Tensor self, bool some=True, bool compute_uv=True) -> (Tensor U, Tensor S, Tensor V)");
    return table->getOp<std::tuple<Tensor,Tensor,Tensor> (const Tensor &, bool, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, some, compute_uv);
}
static inline std::tuple<Tensor,Tensor,Tensor> _svd_helper(const Tensor & self, bool some, bool compute_uv) {
    static auto table = globalATenDispatch().getOpTable("aten::_svd_helper(Tensor self, bool some, bool compute_uv) -> (Tensor, Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor,Tensor> (const Tensor &, bool, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, some, compute_uv);
}
static inline Tensor & cholesky_out(Tensor & out, const Tensor & self, bool upper) {
    static auto table = globalATenDispatch().getOpTable("aten::cholesky(Tensor self, bool upper=False, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, upper);
}
static inline Tensor cholesky(const Tensor & self, bool upper) {
    static auto table = globalATenDispatch().getOpTable("aten::cholesky(Tensor self, bool upper=False) -> Tensor");
    return table->getOp<Tensor (const Tensor &, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, upper);
}
static inline Tensor _cholesky_helper(const Tensor & self, bool upper) {
    static auto table = globalATenDispatch().getOpTable("aten::_cholesky_helper(Tensor self, bool upper) -> Tensor");
    return table->getOp<Tensor (const Tensor &, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, upper);
}
static inline Tensor & cholesky_solve_out(Tensor & out, const Tensor & self, const Tensor & input2, bool upper) {
    static auto table = globalATenDispatch().getOpTable("aten::cholesky_solve(Tensor self, Tensor input2, bool upper=False, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, input2, upper);
}
static inline Tensor cholesky_solve(const Tensor & self, const Tensor & input2, bool upper) {
    static auto table = globalATenDispatch().getOpTable("aten::cholesky_solve(Tensor self, Tensor input2, bool upper=False) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, input2, upper);
}
static inline Tensor _cholesky_solve_helper(const Tensor & self, const Tensor & A, bool upper) {
    static auto table = globalATenDispatch().getOpTable("aten::_cholesky_solve_helper(Tensor self, Tensor A, bool upper) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, A, upper);
}
static inline std::tuple<Tensor,Tensor> solve(const Tensor & self, const Tensor & A) {
    static auto table = globalATenDispatch().getOpTable("aten::solve(Tensor self, Tensor A) -> (Tensor solution, Tensor LU)");
    return table->getOp<std::tuple<Tensor,Tensor> (const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, A);
}
static inline std::tuple<Tensor &,Tensor &> solve_out(Tensor & solution, Tensor & lu, const Tensor & self, const Tensor & A) {
    static auto table = globalATenDispatch().getOpTable("aten::solve(Tensor self, Tensor A, *, Tensor(a!) solution, Tensor(b!) lu) -> (Tensor(a!) solution, Tensor(b!) LU)");
    return table->getOp<std::tuple<Tensor &,Tensor &> (Tensor &, Tensor &, const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(solution, lu, self, A);
}
static inline std::tuple<Tensor,Tensor> _solve_helper(const Tensor & self, const Tensor & A) {
    static auto table = globalATenDispatch().getOpTable("aten::_solve_helper(Tensor self, Tensor A) -> (Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor> (const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, A);
}
static inline Tensor & cholesky_inverse_out(Tensor & out, const Tensor & self, bool upper) {
    static auto table = globalATenDispatch().getOpTable("aten::cholesky_inverse(Tensor self, bool upper=False, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, upper);
}
static inline Tensor cholesky_inverse(const Tensor & self, bool upper) {
    static auto table = globalATenDispatch().getOpTable("aten::cholesky_inverse(Tensor self, bool upper=False) -> Tensor");
    return table->getOp<Tensor (const Tensor &, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, upper);
}
static inline std::tuple<Tensor &,Tensor &> qr_out(Tensor & Q, Tensor & R, const Tensor & self, bool some) {
    static auto table = globalATenDispatch().getOpTable("aten::qr(Tensor self, bool some=True, *, Tensor(a!) Q, Tensor(b!) R) -> (Tensor(a!) Q, Tensor(b!) R)");
    return table->getOp<std::tuple<Tensor &,Tensor &> (Tensor &, Tensor &, const Tensor &, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(Q, R, self, some);
}
static inline std::tuple<Tensor,Tensor> qr(const Tensor & self, bool some) {
    static auto table = globalATenDispatch().getOpTable("aten::qr(Tensor self, bool some=True) -> (Tensor Q, Tensor R)");
    return table->getOp<std::tuple<Tensor,Tensor> (const Tensor &, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, some);
}
static inline std::tuple<Tensor,Tensor> _qr_helper(const Tensor & self, bool some) {
    static auto table = globalATenDispatch().getOpTable("aten::_qr_helper(Tensor self, bool some) -> (Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor> (const Tensor &, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, some);
}
static inline std::tuple<Tensor &,Tensor &> geqrf_out(Tensor & a, Tensor & tau, const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::geqrf(Tensor self, *, Tensor(a!) a, Tensor(b!) tau) -> (Tensor(a!) a, Tensor(b!) tau)");
    return table->getOp<std::tuple<Tensor &,Tensor &> (Tensor &, Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(a, tau, self);
}
static inline std::tuple<Tensor,Tensor> geqrf(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::geqrf(Tensor self) -> (Tensor a, Tensor tau)");
    return table->getOp<std::tuple<Tensor,Tensor> (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & orgqr_out(Tensor & out, const Tensor & self, const Tensor & input2) {
    static auto table = globalATenDispatch().getOpTable("aten::orgqr(Tensor self, Tensor input2, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, input2);
}
static inline Tensor orgqr(const Tensor & self, const Tensor & input2) {
    static auto table = globalATenDispatch().getOpTable("aten::orgqr(Tensor self, Tensor input2) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, input2);
}
static inline Tensor & ormqr_out(Tensor & out, const Tensor & self, const Tensor & input2, const Tensor & input3, bool left, bool transpose) {
    static auto table = globalATenDispatch().getOpTable("aten::ormqr(Tensor self, Tensor input2, Tensor input3, bool left=True, bool transpose=False, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, const Tensor &, bool, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, input2, input3, left, transpose);
}
static inline Tensor ormqr(const Tensor & self, const Tensor & input2, const Tensor & input3, bool left, bool transpose) {
    static auto table = globalATenDispatch().getOpTable("aten::ormqr(Tensor self, Tensor input2, Tensor input3, bool left=True, bool transpose=False) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, bool, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, input2, input3, left, transpose);
}
static inline std::tuple<Tensor,Tensor,Tensor> _lu_with_info(const Tensor & self, bool pivot, bool check_errors) {
    static auto table = globalATenDispatch().getOpTable("aten::_lu_with_info(Tensor self, bool pivot=True, bool check_errors=True) -> (Tensor, Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor,Tensor> (const Tensor &, bool, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, pivot, check_errors);
}
static inline Tensor & lu_solve_out(Tensor & out, const Tensor & self, const Tensor & LU_data, const Tensor & LU_pivots) {
    static auto table = globalATenDispatch().getOpTable("aten::lu_solve(Tensor self, Tensor LU_data, Tensor LU_pivots, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, LU_data, LU_pivots);
}
static inline Tensor lu_solve(const Tensor & self, const Tensor & LU_data, const Tensor & LU_pivots) {
    static auto table = globalATenDispatch().getOpTable("aten::lu_solve(Tensor self, Tensor LU_data, Tensor LU_pivots) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, LU_data, LU_pivots);
}
static inline Tensor _lu_solve_helper(const Tensor & self, const Tensor & LU_data, const Tensor & LU_pivots) {
    static auto table = globalATenDispatch().getOpTable("aten::_lu_solve_helper(Tensor self, Tensor LU_data, Tensor LU_pivots) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, LU_data, LU_pivots);
}
static inline Tensor & multinomial_out(Tensor & out, const Tensor & self, int64_t num_samples, bool replacement, Generator * generator) {
    static auto table = globalATenDispatch().getOpTable("aten::multinomial(Tensor self, int num_samples, bool replacement=False, *, Generator? generator=None, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, int64_t, bool, Generator *)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, num_samples, replacement, generator);
}
static inline Tensor multinomial(const Tensor & self, int64_t num_samples, bool replacement, Generator * generator) {
    static auto table = globalATenDispatch().getOpTable("aten::multinomial(Tensor self, int num_samples, bool replacement=False, *, Generator? generator=None) -> Tensor");
    return table->getOp<Tensor (const Tensor &, int64_t, bool, Generator *)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, num_samples, replacement, generator);
}
static inline std::tuple<Tensor,Tensor> _multinomial_alias_setup(const Tensor & probs) {
    static auto table = globalATenDispatch().getOpTable("aten::_multinomial_alias_setup(Tensor probs) -> (Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor> (const Tensor &)>(at::detail::infer_backend(probs), at::detail::infer_is_variable(probs))(probs);
}
static inline Tensor _multinomial_alias_draw(const Tensor & J, const Tensor & q, int64_t num_samples, Generator * generator) {
    static auto table = globalATenDispatch().getOpTable("aten::_multinomial_alias_draw(Tensor J, Tensor q, int num_samples, *, Generator? generator=None) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, int64_t, Generator *)>(at::detail::infer_backend(J), at::detail::infer_is_variable(J))(J, q, num_samples, generator);
}
static inline Tensor & lgamma_out(Tensor & out, const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::lgamma(Tensor self, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self);
}
static inline Tensor lgamma(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::lgamma(Tensor self) -> Tensor");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & digamma_out(Tensor & out, const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::digamma(Tensor self, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self);
}
static inline Tensor digamma(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::digamma(Tensor self) -> Tensor");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & polygamma_out(Tensor & out, int64_t n, const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::polygamma(int n, Tensor self, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, int64_t, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, n, self);
}
static inline Tensor polygamma(int64_t n, const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::polygamma(int n, Tensor self) -> Tensor");
    return table->getOp<Tensor (int64_t, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(n, self);
}
static inline Tensor & erfinv_out(Tensor & out, const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::erfinv(Tensor self, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self);
}
static inline Tensor erfinv(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::erfinv(Tensor self) -> Tensor");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor dist(const Tensor & self, const Tensor & other, Scalar p) {
    static auto table = globalATenDispatch().getOpTable("aten::dist(Tensor self, Tensor other, Scalar p=2) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, other, p);
}
static inline Tensor & atan2_out(Tensor & out, const Tensor & self, const Tensor & other) {
    static auto table = globalATenDispatch().getOpTable("aten::atan2(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, other);
}
static inline Tensor atan2(const Tensor & self, const Tensor & other) {
    static auto table = globalATenDispatch().getOpTable("aten::atan2(Tensor self, Tensor other) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, other);
}
static inline Tensor & lerp_out(Tensor & out, const Tensor & self, const Tensor & end, Scalar weight) {
    static auto table = globalATenDispatch().getOpTable("aten::lerp(Tensor self, Tensor end, Scalar weight, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, end, weight);
}
static inline Tensor & lerp_out(Tensor & out, const Tensor & self, const Tensor & end, const Tensor & weight) {
    static auto table = globalATenDispatch().getOpTable("aten::lerp(Tensor self, Tensor end, Tensor weight, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, end, weight);
}
static inline Tensor lerp(const Tensor & self, const Tensor & end, Scalar weight) {
    static auto table = globalATenDispatch().getOpTable("aten::lerp(Tensor self, Tensor end, Scalar weight) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, end, weight);
}
static inline Tensor lerp(const Tensor & self, const Tensor & end, const Tensor & weight) {
    static auto table = globalATenDispatch().getOpTable("aten::lerp(Tensor self, Tensor end, Tensor weight) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, end, weight);
}
static inline Tensor & histc_out(Tensor & out, const Tensor & self, int64_t bins, Scalar min, Scalar max) {
    static auto table = globalATenDispatch().getOpTable("aten::histc(Tensor self, int bins=100, Scalar min=0, Scalar max=0, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, int64_t, Scalar, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, bins, min, max);
}
static inline Tensor histc(const Tensor & self, int64_t bins, Scalar min, Scalar max) {
    static auto table = globalATenDispatch().getOpTable("aten::histc(Tensor self, int bins=100, Scalar min=0, Scalar max=0) -> Tensor");
    return table->getOp<Tensor (const Tensor &, int64_t, Scalar, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, bins, min, max);
}
static inline Tensor & sign_out(Tensor & out, const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::sign(Tensor self, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self);
}
static inline Tensor sign(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::sign(Tensor self) -> Tensor");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & fmod_out(Tensor & out, const Tensor & self, Scalar other) {
    static auto table = globalATenDispatch().getOpTable("aten::fmod(Tensor self, Scalar other, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, other);
}
static inline Tensor fmod(const Tensor & self, Scalar other) {
    static auto table = globalATenDispatch().getOpTable("aten::fmod(Tensor self, Scalar other) -> Tensor");
    return table->getOp<Tensor (const Tensor &, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, other);
}
static inline Tensor & fmod_out(Tensor & out, const Tensor & self, const Tensor & other) {
    static auto table = globalATenDispatch().getOpTable("aten::fmod(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, other);
}
static inline Tensor fmod(const Tensor & self, const Tensor & other) {
    static auto table = globalATenDispatch().getOpTable("aten::fmod(Tensor self, Tensor other) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, other);
}
static inline Tensor & remainder_out(Tensor & out, const Tensor & self, Scalar other) {
    static auto table = globalATenDispatch().getOpTable("aten::remainder(Tensor self, Scalar other, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, other);
}
static inline Tensor remainder(const Tensor & self, Scalar other) {
    static auto table = globalATenDispatch().getOpTable("aten::remainder(Tensor self, Scalar other) -> Tensor");
    return table->getOp<Tensor (const Tensor &, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, other);
}
static inline Tensor & remainder_out(Tensor & out, const Tensor & self, const Tensor & other) {
    static auto table = globalATenDispatch().getOpTable("aten::remainder(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, other);
}
static inline Tensor remainder(const Tensor & self, const Tensor & other) {
    static auto table = globalATenDispatch().getOpTable("aten::remainder(Tensor self, Tensor other) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, other);
}
static inline Tensor & min_out(Tensor & out, const Tensor & self, const Tensor & other) {
    static auto table = globalATenDispatch().getOpTable("aten::min(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, other);
}
static inline Tensor min(const Tensor & self, const Tensor & other) {
    static auto table = globalATenDispatch().getOpTable("aten::min(Tensor self, Tensor other) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, other);
}
static inline Tensor min(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::min(Tensor self) -> Tensor");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & max_out(Tensor & out, const Tensor & self, const Tensor & other) {
    static auto table = globalATenDispatch().getOpTable("aten::max(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, other);
}
static inline Tensor max(const Tensor & self, const Tensor & other) {
    static auto table = globalATenDispatch().getOpTable("aten::max(Tensor self, Tensor other) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, other);
}
static inline Tensor max(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::max(Tensor self) -> Tensor");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor median(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::median(Tensor self) -> Tensor");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline std::tuple<Tensor &,Tensor &> sort_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t dim, bool descending) {
    static auto table = globalATenDispatch().getOpTable("aten::sort(Tensor self, int dim=-1, bool descending=False, *, Tensor(a!) values, Tensor(b!) indices) -> (Tensor(a!) values, Tensor(b!) indices)");
    return table->getOp<std::tuple<Tensor &,Tensor &> (Tensor &, Tensor &, const Tensor &, int64_t, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(values, indices, self, dim, descending);
}
static inline std::tuple<Tensor,Tensor> sort(const Tensor & self, int64_t dim, bool descending) {
    static auto table = globalATenDispatch().getOpTable("aten::sort(Tensor self, int dim=-1, bool descending=False) -> (Tensor values, Tensor indices)");
    return table->getOp<std::tuple<Tensor,Tensor> (const Tensor &, int64_t, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dim, descending);
}
static inline Tensor argsort(const Tensor & self, int64_t dim, bool descending) {
    static auto table = globalATenDispatch().getOpTable("aten::argsort(Tensor self, int dim=-1, bool descending=False) -> Tensor");
    return table->getOp<Tensor (const Tensor &, int64_t, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dim, descending);
}
static inline std::tuple<Tensor &,Tensor &> topk_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t k, int64_t dim, bool largest, bool sorted) {
    static auto table = globalATenDispatch().getOpTable("aten::topk(Tensor self, int k, int dim=-1, bool largest=True, bool sorted=True, *, Tensor(a!) values, Tensor(b!) indices) ->(Tensor(a!) values, Tensor(b!) indices)");
    return table->getOp<std::tuple<Tensor &,Tensor &> (Tensor &, Tensor &, const Tensor &, int64_t, int64_t, bool, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(values, indices, self, k, dim, largest, sorted);
}
static inline std::tuple<Tensor,Tensor> topk(const Tensor & self, int64_t k, int64_t dim, bool largest, bool sorted) {
    static auto table = globalATenDispatch().getOpTable("aten::topk(Tensor self, int k, int dim=-1, bool largest=True, bool sorted=True) -> (Tensor values, Tensor indices)");
    return table->getOp<std::tuple<Tensor,Tensor> (const Tensor &, int64_t, int64_t, bool, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, k, dim, largest, sorted);
}
static inline Tensor all(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::all(Tensor self) -> Tensor");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor any(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::any(Tensor self) -> Tensor");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & renorm_out(Tensor & out, const Tensor & self, Scalar p, int64_t dim, Scalar maxnorm) {
    static auto table = globalATenDispatch().getOpTable("aten::renorm(Tensor self, Scalar p, int dim, Scalar maxnorm, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, Scalar, int64_t, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, p, dim, maxnorm);
}
static inline Tensor renorm(const Tensor & self, Scalar p, int64_t dim, Scalar maxnorm) {
    static auto table = globalATenDispatch().getOpTable("aten::renorm(Tensor self, Scalar p, int dim, Scalar maxnorm) -> Tensor");
    return table->getOp<Tensor (const Tensor &, Scalar, int64_t, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, p, dim, maxnorm);
}
static inline bool equal(const Tensor & self, const Tensor & other) {
    static auto table = globalATenDispatch().getOpTable("aten::equal(Tensor self, Tensor other) -> bool");
    return table->getOp<bool (const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, other);
}
static inline Tensor & pow_out(Tensor & out, const Tensor & self, const Tensor & exponent) {
    static auto table = globalATenDispatch().getOpTable("aten::pow(Tensor self, Tensor exponent, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, exponent);
}
static inline Tensor pow(const Tensor & self, const Tensor & exponent) {
    static auto table = globalATenDispatch().getOpTable("aten::pow(Tensor self, Tensor exponent) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, exponent);
}
static inline Tensor & pow_out(Tensor & out, Scalar self, const Tensor & exponent) {
    static auto table = globalATenDispatch().getOpTable("aten::pow(Scalar self, Tensor exponent, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, Scalar, const Tensor &)>(at::detail::infer_backend(out), at::detail::infer_is_variable(out))(out, self, exponent);
}
static inline Tensor pow(Scalar self, const Tensor & exponent) {
    static auto table = globalATenDispatch().getOpTable("aten::pow(Scalar self, Tensor exponent) -> Tensor");
    return table->getOp<Tensor (Scalar, const Tensor &)>(at::detail::infer_backend(exponent), at::detail::infer_is_variable(exponent))(self, exponent);
}
static inline Tensor & normal_out(Tensor & out, const Tensor & mean, double std, Generator * generator) {
    static auto table = globalATenDispatch().getOpTable("aten::normal(Tensor mean, float std=1, *, Generator? generator=None, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, double, Generator *)>(at::detail::infer_backend(out), at::detail::infer_is_variable(out))(out, mean, std, generator);
}
static inline Tensor normal(const Tensor & mean, double std, Generator * generator) {
    static auto table = globalATenDispatch().getOpTable("aten::normal(Tensor mean, float std=1, *, Generator? generator=None) -> Tensor");
    return table->getOp<Tensor (const Tensor &, double, Generator *)>(at::detail::infer_backend(mean), at::detail::infer_is_variable(mean))(mean, std, generator);
}
static inline Tensor & normal_out(Tensor & out, double mean, const Tensor & std, Generator * generator) {
    static auto table = globalATenDispatch().getOpTable("aten::normal(float mean, Tensor std, *, Generator? generator=None, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, double, const Tensor &, Generator *)>(at::detail::infer_backend(out), at::detail::infer_is_variable(out))(out, mean, std, generator);
}
static inline Tensor normal(double mean, const Tensor & std, Generator * generator) {
    static auto table = globalATenDispatch().getOpTable("aten::normal(float mean, Tensor std, *, Generator? generator=None) -> Tensor");
    return table->getOp<Tensor (double, const Tensor &, Generator *)>(at::detail::infer_backend(std), at::detail::infer_is_variable(std))(mean, std, generator);
}
static inline Tensor & normal_out(Tensor & out, const Tensor & mean, const Tensor & std, Generator * generator) {
    static auto table = globalATenDispatch().getOpTable("aten::normal(Tensor mean, Tensor std, *, Generator? generator=None, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, Generator *)>(at::detail::infer_backend(out), at::detail::infer_is_variable(out))(out, mean, std, generator);
}
static inline Tensor normal(const Tensor & mean, const Tensor & std, Generator * generator) {
    static auto table = globalATenDispatch().getOpTable("aten::normal(Tensor mean, Tensor std, *, Generator? generator=None) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, Generator *)>(at::detail::infer_backend(mean), at::detail::infer_is_variable(mean))(mean, std, generator);
}
static inline Tensor normal(double mean, double std, IntArrayRef size, Generator * generator, const TensorOptions & options) {
    globalLegacyTypeDispatch().initForBackend(options.backend());
    static auto table = globalATenDispatch().getOpTable("aten::normal(float mean, float std, int[] size, *, Generator? generator=None, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor");
    return table->getOp<Tensor (double, double, IntArrayRef, Generator *, const TensorOptions &)>(options.backend(), options.is_variable())(mean, std, size, generator, options);
}
static inline Tensor & normal_out(Tensor & out, double mean, double std, IntArrayRef size, Generator * generator) {
    static auto table = globalATenDispatch().getOpTable("aten::normal(float mean, float std, int[] size, *, Generator? generator=None, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, double, double, IntArrayRef, Generator *)>(at::detail::infer_backend(out), at::detail::infer_is_variable(out))(out, mean, std, size, generator);
}
static inline Tensor alias(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::alias(Tensor(a) self) -> Tensor(a)");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor _addr(const Tensor & self, const Tensor & vec1, const Tensor & vec2, Scalar beta, Scalar alpha) {
    static auto table = globalATenDispatch().getOpTable("aten::_addr(Tensor self, Tensor vec1, Tensor vec2, *, Scalar beta=1, Scalar alpha=1) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, Scalar, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, vec1, vec2, beta, alpha);
}
static inline Tensor & _addr_(Tensor & self, const Tensor & vec1, const Tensor & vec2, Scalar beta, Scalar alpha) {
    static auto table = globalATenDispatch().getOpTable("aten::_addr_(Tensor(a!) self, Tensor vec1, Tensor vec2, *, Scalar beta=1, Scalar alpha=1) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, Scalar, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, vec1, vec2, beta, alpha);
}
static inline Tensor & _addr_out(Tensor & out, const Tensor & self, const Tensor & vec1, const Tensor & vec2, Scalar beta, Scalar alpha) {
    static auto table = globalATenDispatch().getOpTable("aten::_addr(Tensor self, Tensor vec1, Tensor vec2, *, Scalar beta=1, Scalar alpha=1, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, const Tensor &, Scalar, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, vec1, vec2, beta, alpha);
}
static inline Tensor & _index_copy_(Tensor & self, int64_t dim, const Tensor & index, const Tensor & source) {
    static auto table = globalATenDispatch().getOpTable("aten::_index_copy_(Tensor(a!) self, int dim, Tensor index, Tensor source) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, int64_t, const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dim, index, source);
}
static inline Tensor _cumsum(const Tensor & self, int64_t dim) {
    static auto table = globalATenDispatch().getOpTable("aten::_cumsum(Tensor self, int dim) -> Tensor");
    return table->getOp<Tensor (const Tensor &, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dim);
}
static inline Tensor & _cumsum_out(Tensor & out, const Tensor & self, int64_t dim) {
    static auto table = globalATenDispatch().getOpTable("aten::_cumsum(Tensor self, int dim, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, dim);
}
static inline Tensor _cumprod(const Tensor & self, int64_t dim) {
    static auto table = globalATenDispatch().getOpTable("aten::_cumprod(Tensor self, int dim) -> Tensor");
    return table->getOp<Tensor (const Tensor &, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dim);
}
static inline Tensor & _cumprod_out(Tensor & out, const Tensor & self, int64_t dim) {
    static auto table = globalATenDispatch().getOpTable("aten::_cumprod(Tensor self, int dim, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, dim);
}
static inline Tensor _var(const Tensor & self, bool unbiased) {
    static auto table = globalATenDispatch().getOpTable("aten::_var(Tensor self, bool unbiased=True) -> Tensor");
    return table->getOp<Tensor (const Tensor &, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, unbiased);
}
static inline Tensor _std(const Tensor & self, bool unbiased) {
    static auto table = globalATenDispatch().getOpTable("aten::_std(Tensor self, bool unbiased=True) -> Tensor");
    return table->getOp<Tensor (const Tensor &, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, unbiased);
}
static inline Tensor & _addmm_out(Tensor & out, const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta, Scalar alpha) {
    static auto table = globalATenDispatch().getOpTable("aten::_addmm(Tensor self, Tensor mat1, Tensor mat2, *, Scalar beta=1, Scalar alpha=1, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, const Tensor &, Scalar, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, mat1, mat2, beta, alpha);
}
static inline Tensor _addmm(const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta, Scalar alpha) {
    static auto table = globalATenDispatch().getOpTable("aten::_addmm(Tensor self, Tensor mat1, Tensor mat2, *, Scalar beta=1, Scalar alpha=1) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, Scalar, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, mat1, mat2, beta, alpha);
}
static inline Tensor & _addmm_(Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta, Scalar alpha) {
    static auto table = globalATenDispatch().getOpTable("aten::_addmm_(Tensor(a!) self, Tensor mat1, Tensor mat2, *, Scalar beta=1, Scalar alpha=1) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, Scalar, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, mat1, mat2, beta, alpha);
}
static inline Tensor _cat(TensorList tensors, int64_t dim) {
    static auto table = globalATenDispatch().getOpTable("aten::_cat(Tensor[] tensors, int dim=0) -> Tensor");
    return table->getOp<Tensor (TensorList, int64_t)>(at::detail::infer_backend(tensors), at::detail::infer_is_variable(tensors))(tensors, dim);
}
static inline Tensor & _cat_out(Tensor & out, TensorList tensors, int64_t dim) {
    static auto table = globalATenDispatch().getOpTable("aten::_cat(Tensor[] tensors, int dim=0, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, TensorList, int64_t)>(at::detail::infer_backend(out), at::detail::infer_is_variable(out))(out, tensors, dim);
}
static inline std::tuple<Tensor,Tensor> _mode(const Tensor & self, int64_t dim, bool keepdim) {
    static auto table = globalATenDispatch().getOpTable("aten::_mode(Tensor self, int dim=-1, bool keepdim=False) -> (Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor> (const Tensor &, int64_t, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dim, keepdim);
}
static inline std::tuple<Tensor &,Tensor &> _mode_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t dim, bool keepdim) {
    static auto table = globalATenDispatch().getOpTable("aten::_mode(Tensor self, int dim=-1, bool keepdim=False, *, Tensor(a!) values, Tensor(b!) indices) -> (Tensor(a!), Tensor(b!))");
    return table->getOp<std::tuple<Tensor &,Tensor &> (Tensor &, Tensor &, const Tensor &, int64_t, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(values, indices, self, dim, keepdim);
}
static inline std::tuple<Tensor,Tensor> _max(const Tensor & self, int64_t dim, bool keepdim) {
    static auto table = globalATenDispatch().getOpTable("aten::_max(Tensor self, int dim, bool keepdim=False) -> (Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor> (const Tensor &, int64_t, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dim, keepdim);
}
static inline std::tuple<Tensor &,Tensor &> _max_out(Tensor & max, Tensor & max_indices, const Tensor & self, int64_t dim, bool keepdim) {
    static auto table = globalATenDispatch().getOpTable("aten::_max(Tensor self, int dim, bool keepdim=False, *, Tensor(a!) max, Tensor(b!) max_indices) -> (Tensor(a!), Tensor(b!))");
    return table->getOp<std::tuple<Tensor &,Tensor &> (Tensor &, Tensor &, const Tensor &, int64_t, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(max, max_indices, self, dim, keepdim);
}
static inline std::tuple<Tensor,Tensor> _min(const Tensor & self, int64_t dim, bool keepdim) {
    static auto table = globalATenDispatch().getOpTable("aten::_min(Tensor self, int dim, bool keepdim=False) -> (Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor> (const Tensor &, int64_t, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dim, keepdim);
}
static inline std::tuple<Tensor &,Tensor &> _min_out(Tensor & min, Tensor & min_indices, const Tensor & self, int64_t dim, bool keepdim) {
    static auto table = globalATenDispatch().getOpTable("aten::_min(Tensor self, int dim, bool keepdim=False, *, Tensor(a!) min, Tensor(b!) min_indices) -> (Tensor(a!), Tensor(b!))");
    return table->getOp<std::tuple<Tensor &,Tensor &> (Tensor &, Tensor &, const Tensor &, int64_t, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(min, min_indices, self, dim, keepdim);
}
static inline Tensor & binary_cross_entropy_out(Tensor & out, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction) {
    static auto table = globalATenDispatch().getOpTable("aten::binary_cross_entropy(Tensor self, Tensor target, Tensor? weight=None, int reduction=Mean, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, const Tensor &, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, target, weight, reduction);
}
static inline Tensor binary_cross_entropy(const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction) {
    static auto table = globalATenDispatch().getOpTable("aten::binary_cross_entropy(Tensor self, Tensor target, Tensor? weight=None, int reduction=Mean) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, target, weight, reduction);
}
static inline Tensor & binary_cross_entropy_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction) {
    static auto table = globalATenDispatch().getOpTable("aten::binary_cross_entropy_backward(Tensor grad_output, Tensor self, Tensor target, Tensor? weight=None, int reduction=Mean, *, Tensor(a!) grad_input) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_input, grad_output, self, target, weight, reduction);
}
static inline Tensor binary_cross_entropy_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction) {
    static auto table = globalATenDispatch().getOpTable("aten::binary_cross_entropy_backward(Tensor grad_output, Tensor self, Tensor target, Tensor? weight=None, int reduction=Mean) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, const Tensor &, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_output, self, target, weight, reduction);
}
static inline Tensor & mse_loss_out(Tensor & out, const Tensor & self, const Tensor & target, int64_t reduction) {
    static auto table = globalATenDispatch().getOpTable("aten::mse_loss(Tensor self, Tensor target, int reduction=Mean, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, target, reduction);
}
static inline Tensor mse_loss(const Tensor & self, const Tensor & target, int64_t reduction) {
    static auto table = globalATenDispatch().getOpTable("aten::mse_loss(Tensor self, Tensor target, int reduction=Mean) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, target, reduction);
}
static inline Tensor & mse_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) {
    static auto table = globalATenDispatch().getOpTable("aten::mse_loss_backward(Tensor grad_output, Tensor self, Tensor target, int reduction, *, Tensor(a!) grad_input) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, const Tensor &, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_input, grad_output, self, target, reduction);
}
static inline Tensor mse_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) {
    static auto table = globalATenDispatch().getOpTable("aten::mse_loss_backward(Tensor grad_output, Tensor self, Tensor target, int reduction) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_output, self, target, reduction);
}
static inline Tensor & l1_loss_out(Tensor & out, const Tensor & self, const Tensor & target, int64_t reduction) {
    static auto table = globalATenDispatch().getOpTable("aten::l1_loss(Tensor self, Tensor target, int reduction=Mean, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, target, reduction);
}
static inline Tensor l1_loss(const Tensor & self, const Tensor & target, int64_t reduction) {
    static auto table = globalATenDispatch().getOpTable("aten::l1_loss(Tensor self, Tensor target, int reduction=Mean) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, target, reduction);
}
static inline Tensor & l1_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) {
    static auto table = globalATenDispatch().getOpTable("aten::l1_loss_backward(Tensor grad_output, Tensor self, Tensor target, int reduction, *, Tensor(a!) grad_input) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, const Tensor &, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_input, grad_output, self, target, reduction);
}
static inline Tensor l1_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) {
    static auto table = globalATenDispatch().getOpTable("aten::l1_loss_backward(Tensor grad_output, Tensor self, Tensor target, int reduction) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_output, self, target, reduction);
}
static inline Tensor & multi_margin_loss_out(Tensor & out, const Tensor & self, const Tensor & target, Scalar p, Scalar margin, const Tensor & weight, int64_t reduction) {
    static auto table = globalATenDispatch().getOpTable("aten::multi_margin_loss(Tensor self, Tensor target, Scalar p=1, Scalar margin=1, Tensor? weight=None, int reduction=Mean, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, Scalar, Scalar, const Tensor &, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, target, p, margin, weight, reduction);
}
static inline Tensor multi_margin_loss(const Tensor & self, const Tensor & target, Scalar p, Scalar margin, const Tensor & weight, int64_t reduction) {
    static auto table = globalATenDispatch().getOpTable("aten::multi_margin_loss(Tensor self, Tensor target, Scalar p=1, Scalar margin=1, Tensor? weight=None, int reduction=Mean) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, Scalar, Scalar, const Tensor &, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, target, p, margin, weight, reduction);
}
static inline Tensor & multi_margin_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, Scalar p, Scalar margin, const Tensor & weight, int64_t reduction) {
    static auto table = globalATenDispatch().getOpTable("aten::multi_margin_loss_backward(Tensor grad_output, Tensor self, Tensor target, Scalar p, Scalar margin, Tensor? weight=None, int reduction=Mean, *, Tensor(a!) grad_input) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, const Tensor &, Scalar, Scalar, const Tensor &, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_input, grad_output, self, target, p, margin, weight, reduction);
}
static inline Tensor multi_margin_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, Scalar p, Scalar margin, const Tensor & weight, int64_t reduction) {
    static auto table = globalATenDispatch().getOpTable("aten::multi_margin_loss_backward(Tensor grad_output, Tensor self, Tensor target, Scalar p, Scalar margin, Tensor? weight=None, int reduction=Mean) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, Scalar, Scalar, const Tensor &, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_output, self, target, p, margin, weight, reduction);
}
static inline Tensor & multilabel_margin_loss_out(Tensor & out, const Tensor & self, const Tensor & target, int64_t reduction) {
    static auto table = globalATenDispatch().getOpTable("aten::multilabel_margin_loss(Tensor self, Tensor target, int reduction=Mean, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, target, reduction);
}
static inline Tensor multilabel_margin_loss(const Tensor & self, const Tensor & target, int64_t reduction) {
    static auto table = globalATenDispatch().getOpTable("aten::multilabel_margin_loss(Tensor self, Tensor target, int reduction=Mean) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, target, reduction);
}
static inline std::tuple<Tensor &,Tensor &> multilabel_margin_loss_forward_out(Tensor & output, Tensor & is_target, const Tensor & self, const Tensor & target, int64_t reduction) {
    static auto table = globalATenDispatch().getOpTable("aten::multilabel_margin_loss_forward(Tensor self, Tensor target, int reduction, *, Tensor(a!) output, Tensor(b!) is_target) -> (Tensor(a!), Tensor(b!))");
    return table->getOp<std::tuple<Tensor &,Tensor &> (Tensor &, Tensor &, const Tensor &, const Tensor &, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(output, is_target, self, target, reduction);
}
static inline std::tuple<Tensor,Tensor> multilabel_margin_loss_forward(const Tensor & self, const Tensor & target, int64_t reduction) {
    static auto table = globalATenDispatch().getOpTable("aten::multilabel_margin_loss_forward(Tensor self, Tensor target, int reduction) -> (Tensor output, Tensor is_target)");
    return table->getOp<std::tuple<Tensor,Tensor> (const Tensor &, const Tensor &, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, target, reduction);
}
static inline Tensor & multilabel_margin_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction, const Tensor & is_target) {
    static auto table = globalATenDispatch().getOpTable("aten::multilabel_margin_loss_backward(Tensor grad_output, Tensor self, Tensor target, int reduction, Tensor is_target, *, Tensor(a!) grad_input) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, const Tensor &, int64_t, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_input, grad_output, self, target, reduction, is_target);
}
static inline Tensor multilabel_margin_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction, const Tensor & is_target) {
    static auto table = globalATenDispatch().getOpTable("aten::multilabel_margin_loss_backward(Tensor grad_output, Tensor self, Tensor target, int reduction, Tensor is_target) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, int64_t, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_output, self, target, reduction, is_target);
}
static inline Tensor & nll_loss_out(Tensor & out, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index) {
    static auto table = globalATenDispatch().getOpTable("aten::nll_loss(Tensor self, Tensor target, Tensor? weight=None, int reduction=Mean, int ignore_index=-100, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, const Tensor &, int64_t, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, target, weight, reduction, ignore_index);
}
static inline Tensor nll_loss(const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index) {
    static auto table = globalATenDispatch().getOpTable("aten::nll_loss(Tensor self, Tensor target, Tensor? weight=None, int reduction=Mean, int ignore_index=-100) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, int64_t, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, target, weight, reduction, ignore_index);
}
static inline std::tuple<Tensor &,Tensor &> nll_loss_forward_out(Tensor & output, Tensor & total_weight, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index) {
    static auto table = globalATenDispatch().getOpTable("aten::nll_loss_forward(Tensor self, Tensor target, Tensor? weight, int reduction, int ignore_index, *, Tensor(a!) output, Tensor(b!) total_weight) -> (Tensor(a!), Tensor(b!))");
    return table->getOp<std::tuple<Tensor &,Tensor &> (Tensor &, Tensor &, const Tensor &, const Tensor &, const Tensor &, int64_t, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(output, total_weight, self, target, weight, reduction, ignore_index);
}
static inline std::tuple<Tensor,Tensor> nll_loss_forward(const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index) {
    static auto table = globalATenDispatch().getOpTable("aten::nll_loss_forward(Tensor self, Tensor target, Tensor? weight, int reduction, int ignore_index) -> (Tensor output, Tensor total_weight)");
    return table->getOp<std::tuple<Tensor,Tensor> (const Tensor &, const Tensor &, const Tensor &, int64_t, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, target, weight, reduction, ignore_index);
}
static inline Tensor & nll_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index, const Tensor & total_weight) {
    static auto table = globalATenDispatch().getOpTable("aten::nll_loss_backward(Tensor grad_output, Tensor self, Tensor target, Tensor? weight, int reduction, int ignore_index, Tensor total_weight, *, Tensor(a!) grad_input) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, int64_t, int64_t, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_input, grad_output, self, target, weight, reduction, ignore_index, total_weight);
}
static inline Tensor nll_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index, const Tensor & total_weight) {
    static auto table = globalATenDispatch().getOpTable("aten::nll_loss_backward(Tensor grad_output, Tensor self, Tensor target, Tensor? weight, int reduction, int ignore_index, Tensor total_weight) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, const Tensor &, int64_t, int64_t, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_output, self, target, weight, reduction, ignore_index, total_weight);
}
static inline Tensor & nll_loss2d_out(Tensor & out, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index) {
    static auto table = globalATenDispatch().getOpTable("aten::nll_loss2d(Tensor self, Tensor target, Tensor? weight=None, int reduction=Mean, int ignore_index=-100, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, const Tensor &, int64_t, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, target, weight, reduction, ignore_index);
}
static inline Tensor nll_loss2d(const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index) {
    static auto table = globalATenDispatch().getOpTable("aten::nll_loss2d(Tensor self, Tensor target, Tensor? weight=None, int reduction=Mean, int ignore_index=-100) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, int64_t, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, target, weight, reduction, ignore_index);
}
static inline std::tuple<Tensor &,Tensor &> nll_loss2d_forward_out(Tensor & output, Tensor & total_weight, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index) {
    static auto table = globalATenDispatch().getOpTable("aten::nll_loss2d_forward(Tensor self, Tensor target, Tensor? weight, int reduction, int ignore_index, *, Tensor(a!) output, Tensor(b!) total_weight) -> (Tensor(a!), Tensor(b!))");
    return table->getOp<std::tuple<Tensor &,Tensor &> (Tensor &, Tensor &, const Tensor &, const Tensor &, const Tensor &, int64_t, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(output, total_weight, self, target, weight, reduction, ignore_index);
}
static inline std::tuple<Tensor,Tensor> nll_loss2d_forward(const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index) {
    static auto table = globalATenDispatch().getOpTable("aten::nll_loss2d_forward(Tensor self, Tensor target, Tensor? weight, int reduction, int ignore_index) -> (Tensor output, Tensor total_weight)");
    return table->getOp<std::tuple<Tensor,Tensor> (const Tensor &, const Tensor &, const Tensor &, int64_t, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, target, weight, reduction, ignore_index);
}
static inline Tensor & nll_loss2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index, const Tensor & total_weight) {
    static auto table = globalATenDispatch().getOpTable("aten::nll_loss2d_backward(Tensor grad_output, Tensor self, Tensor target, Tensor? weight, int reduction, int ignore_index, Tensor total_weight, *, Tensor(a!) grad_input) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, const Tensor &, const Tensor &, int64_t, int64_t, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_input, grad_output, self, target, weight, reduction, ignore_index, total_weight);
}
static inline Tensor nll_loss2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index, const Tensor & total_weight) {
    static auto table = globalATenDispatch().getOpTable("aten::nll_loss2d_backward(Tensor grad_output, Tensor self, Tensor target, Tensor? weight, int reduction, int ignore_index, Tensor total_weight) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, const Tensor &, int64_t, int64_t, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_output, self, target, weight, reduction, ignore_index, total_weight);
}
static inline Tensor & smooth_l1_loss_out(Tensor & out, const Tensor & self, const Tensor & target, int64_t reduction) {
    static auto table = globalATenDispatch().getOpTable("aten::smooth_l1_loss(Tensor self, Tensor target, int reduction=Mean, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, target, reduction);
}
static inline Tensor smooth_l1_loss(const Tensor & self, const Tensor & target, int64_t reduction) {
    static auto table = globalATenDispatch().getOpTable("aten::smooth_l1_loss(Tensor self, Tensor target, int reduction=Mean) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, target, reduction);
}
static inline Tensor & smooth_l1_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) {
    static auto table = globalATenDispatch().getOpTable("aten::smooth_l1_loss_backward(Tensor grad_output, Tensor self, Tensor target, int reduction, *, Tensor(a!) grad_input) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, const Tensor &, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_input, grad_output, self, target, reduction);
}
static inline Tensor smooth_l1_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) {
    static auto table = globalATenDispatch().getOpTable("aten::smooth_l1_loss_backward(Tensor grad_output, Tensor self, Tensor target, int reduction) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_output, self, target, reduction);
}
static inline Tensor & soft_margin_loss_out(Tensor & out, const Tensor & self, const Tensor & target, int64_t reduction) {
    static auto table = globalATenDispatch().getOpTable("aten::soft_margin_loss(Tensor self, Tensor target, int reduction=Mean, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, target, reduction);
}
static inline Tensor soft_margin_loss(const Tensor & self, const Tensor & target, int64_t reduction) {
    static auto table = globalATenDispatch().getOpTable("aten::soft_margin_loss(Tensor self, Tensor target, int reduction=Mean) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, target, reduction);
}
static inline Tensor & soft_margin_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) {
    static auto table = globalATenDispatch().getOpTable("aten::soft_margin_loss_backward(Tensor grad_output, Tensor self, Tensor target, int reduction, *, Tensor(a!) grad_input) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, const Tensor &, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_input, grad_output, self, target, reduction);
}
static inline Tensor soft_margin_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) {
    static auto table = globalATenDispatch().getOpTable("aten::soft_margin_loss_backward(Tensor grad_output, Tensor self, Tensor target, int reduction) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_output, self, target, reduction);
}
static inline Tensor & elu_out(Tensor & out, const Tensor & self, Scalar alpha, Scalar scale, Scalar input_scale) {
    static auto table = globalATenDispatch().getOpTable("aten::elu(Tensor self, Scalar alpha=1, Scalar scale=1, Scalar input_scale=1, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, Scalar, Scalar, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, alpha, scale, input_scale);
}
static inline Tensor elu(const Tensor & self, Scalar alpha, Scalar scale, Scalar input_scale) {
    static auto table = globalATenDispatch().getOpTable("aten::elu(Tensor self, Scalar alpha=1, Scalar scale=1, Scalar input_scale=1) -> Tensor");
    return table->getOp<Tensor (const Tensor &, Scalar, Scalar, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, alpha, scale, input_scale);
}
static inline Tensor & elu_backward_out(Tensor & grad_input, const Tensor & grad_output, Scalar alpha, Scalar scale, Scalar input_scale, const Tensor & output) {
    static auto table = globalATenDispatch().getOpTable("aten::elu_backward(Tensor grad_output, Scalar alpha, Scalar scale, Scalar input_scale, Tensor output, *, Tensor(a!) grad_input) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, Scalar, Scalar, Scalar, const Tensor &)>(at::detail::infer_backend(grad_input), at::detail::infer_is_variable(grad_input))(grad_input, grad_output, alpha, scale, input_scale, output);
}
static inline Tensor elu_backward(const Tensor & grad_output, Scalar alpha, Scalar scale, Scalar input_scale, const Tensor & output) {
    static auto table = globalATenDispatch().getOpTable("aten::elu_backward(Tensor grad_output, Scalar alpha, Scalar scale, Scalar input_scale, Tensor output) -> Tensor");
    return table->getOp<Tensor (const Tensor &, Scalar, Scalar, Scalar, const Tensor &)>(at::detail::infer_backend(grad_output), at::detail::infer_is_variable(grad_output))(grad_output, alpha, scale, input_scale, output);
}
static inline Tensor & elu_(Tensor & self, Scalar alpha, Scalar scale, Scalar input_scale) {
    static auto table = globalATenDispatch().getOpTable("aten::elu_(Tensor(a!) self, Scalar alpha=1, Scalar scale=1, Scalar input_scale=1) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, Scalar, Scalar, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, alpha, scale, input_scale);
}
static inline Tensor & glu_out(Tensor & out, const Tensor & self, int64_t dim) {
    static auto table = globalATenDispatch().getOpTable("aten::glu(Tensor self, int dim=-1, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, dim);
}
static inline Tensor glu(const Tensor & self, int64_t dim) {
    static auto table = globalATenDispatch().getOpTable("aten::glu(Tensor self, int dim=-1) -> Tensor");
    return table->getOp<Tensor (const Tensor &, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, dim);
}
static inline Tensor & glu_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, int64_t dim) {
    static auto table = globalATenDispatch().getOpTable("aten::glu_backward(Tensor grad_output, Tensor self, int dim, *, Tensor(a!) grad_input) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_input, grad_output, self, dim);
}
static inline Tensor glu_backward(const Tensor & grad_output, const Tensor & self, int64_t dim) {
    static auto table = globalATenDispatch().getOpTable("aten::glu_backward(Tensor grad_output, Tensor self, int dim) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, int64_t)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_output, self, dim);
}
static inline Tensor & hardtanh_out(Tensor & out, const Tensor & self, Scalar min_val, Scalar max_val) {
    static auto table = globalATenDispatch().getOpTable("aten::hardtanh(Tensor self, Scalar min_val=-1, Scalar max_val=1, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, Scalar, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, min_val, max_val);
}
static inline Tensor hardtanh(const Tensor & self, Scalar min_val, Scalar max_val) {
    static auto table = globalATenDispatch().getOpTable("aten::hardtanh(Tensor self, Scalar min_val=-1, Scalar max_val=1) -> Tensor");
    return table->getOp<Tensor (const Tensor &, Scalar, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, min_val, max_val);
}
static inline Tensor & hardtanh_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, Scalar min_val, Scalar max_val) {
    static auto table = globalATenDispatch().getOpTable("aten::hardtanh_backward(Tensor grad_output, Tensor self, Scalar min_val, Scalar max_val, *, Tensor(a!) grad_input) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, Scalar, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_input, grad_output, self, min_val, max_val);
}
static inline Tensor hardtanh_backward(const Tensor & grad_output, const Tensor & self, Scalar min_val, Scalar max_val) {
    static auto table = globalATenDispatch().getOpTable("aten::hardtanh_backward(Tensor grad_output, Tensor self, Scalar min_val, Scalar max_val) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, Scalar, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_output, self, min_val, max_val);
}
static inline Tensor & hardtanh_(Tensor & self, Scalar min_val, Scalar max_val) {
    static auto table = globalATenDispatch().getOpTable("aten::hardtanh_(Tensor(a!) self, Scalar min_val=-1, Scalar max_val=1) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, Scalar, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, min_val, max_val);
}
static inline Tensor & leaky_relu_out(Tensor & out, const Tensor & self, Scalar negative_slope) {
    static auto table = globalATenDispatch().getOpTable("aten::leaky_relu(Tensor self, Scalar negative_slope=0.01, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, negative_slope);
}
static inline Tensor leaky_relu(const Tensor & self, Scalar negative_slope) {
    static auto table = globalATenDispatch().getOpTable("aten::leaky_relu(Tensor self, Scalar negative_slope=0.01) -> Tensor");
    return table->getOp<Tensor (const Tensor &, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, negative_slope);
}
static inline Tensor & leaky_relu_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, Scalar negative_slope) {
    static auto table = globalATenDispatch().getOpTable("aten::leaky_relu_backward(Tensor grad_output, Tensor self, Scalar negative_slope, *, Tensor(a!) grad_input) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_input, grad_output, self, negative_slope);
}
static inline Tensor leaky_relu_backward(const Tensor & grad_output, const Tensor & self, Scalar negative_slope) {
    static auto table = globalATenDispatch().getOpTable("aten::leaky_relu_backward(Tensor grad_output, Tensor self, Scalar negative_slope) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_output, self, negative_slope);
}
static inline Tensor & leaky_relu_(Tensor & self, Scalar negative_slope) {
    static auto table = globalATenDispatch().getOpTable("aten::leaky_relu_(Tensor(a!) self, Scalar negative_slope=0.01) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, negative_slope);
}
static inline Tensor & log_sigmoid_out(Tensor & out, const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::log_sigmoid(Tensor self, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self);
}
static inline Tensor log_sigmoid(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::log_sigmoid(Tensor self) -> Tensor");
    return table->getOp<Tensor (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline std::tuple<Tensor &,Tensor &> log_sigmoid_forward_out(Tensor & output, Tensor & buffer, const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::log_sigmoid_forward(Tensor self, *, Tensor(a!) output, Tensor(b!) buffer) -> (Tensor(a!), Tensor(b!))");
    return table->getOp<std::tuple<Tensor &,Tensor &> (Tensor &, Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(output, buffer, self);
}
static inline std::tuple<Tensor,Tensor> log_sigmoid_forward(const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::log_sigmoid_forward(Tensor self) -> (Tensor output, Tensor buffer)");
    return table->getOp<std::tuple<Tensor,Tensor> (const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self);
}
static inline Tensor & log_sigmoid_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & buffer) {
    static auto table = globalATenDispatch().getOpTable("aten::log_sigmoid_backward(Tensor grad_output, Tensor self, Tensor buffer, *, Tensor(a!) grad_input) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_input, grad_output, self, buffer);
}
static inline Tensor log_sigmoid_backward(const Tensor & grad_output, const Tensor & self, const Tensor & buffer) {
    static auto table = globalATenDispatch().getOpTable("aten::log_sigmoid_backward(Tensor grad_output, Tensor self, Tensor buffer) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_output, self, buffer);
}
static inline Tensor & rrelu_with_noise_out(Tensor & out, const Tensor & self, const Tensor & noise, Scalar lower, Scalar upper, bool training, Generator * generator) {
    static auto table = globalATenDispatch().getOpTable("aten::rrelu_with_noise(Tensor self, Tensor noise, Scalar lower=0.125, Scalar upper=0.3333333333333333, bool training=False, Generator? generator=None, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, Scalar, Scalar, bool, Generator *)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, noise, lower, upper, training, generator);
}
static inline Tensor rrelu_with_noise(const Tensor & self, const Tensor & noise, Scalar lower, Scalar upper, bool training, Generator * generator) {
    static auto table = globalATenDispatch().getOpTable("aten::rrelu_with_noise(Tensor self, Tensor noise, Scalar lower=0.125, Scalar upper=0.3333333333333333, bool training=False, Generator? generator=None) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, Scalar, Scalar, bool, Generator *)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, noise, lower, upper, training, generator);
}
static inline Tensor & rrelu_with_noise_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & noise, Scalar lower, Scalar upper, bool training) {
    static auto table = globalATenDispatch().getOpTable("aten::rrelu_with_noise_backward(Tensor grad_output, Tensor self, Tensor noise, Scalar lower, Scalar upper, bool training, *, Tensor(a!) grad_input) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, const Tensor &, Scalar, Scalar, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_input, grad_output, self, noise, lower, upper, training);
}
static inline Tensor rrelu_with_noise_backward(const Tensor & grad_output, const Tensor & self, const Tensor & noise, Scalar lower, Scalar upper, bool training) {
    static auto table = globalATenDispatch().getOpTable("aten::rrelu_with_noise_backward(Tensor grad_output, Tensor self, Tensor noise, Scalar lower, Scalar upper, bool training) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, Scalar, Scalar, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_output, self, noise, lower, upper, training);
}
static inline Tensor & rrelu_with_noise_(Tensor & self, const Tensor & noise, Scalar lower, Scalar upper, bool training, Generator * generator) {
    static auto table = globalATenDispatch().getOpTable("aten::rrelu_with_noise_(Tensor(a!) self, Tensor noise, Scalar lower=0.125, Scalar upper=0.3333333333333333, bool training=False, Generator? generator=None) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, Scalar, Scalar, bool, Generator *)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, noise, lower, upper, training, generator);
}
static inline Tensor & softplus_out(Tensor & out, const Tensor & self, Scalar beta, Scalar threshold) {
    static auto table = globalATenDispatch().getOpTable("aten::softplus(Tensor self, Scalar beta=1, Scalar threshold=20, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, Scalar, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, beta, threshold);
}
static inline Tensor softplus(const Tensor & self, Scalar beta, Scalar threshold) {
    static auto table = globalATenDispatch().getOpTable("aten::softplus(Tensor self, Scalar beta=1, Scalar threshold=20) -> Tensor");
    return table->getOp<Tensor (const Tensor &, Scalar, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, beta, threshold);
}
static inline Tensor & softplus_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, Scalar beta, Scalar threshold, const Tensor & output) {
    static auto table = globalATenDispatch().getOpTable("aten::softplus_backward(Tensor grad_output, Tensor self, Scalar beta, Scalar threshold, Tensor output, *, Tensor(a!) grad_input) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, Scalar, Scalar, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_input, grad_output, self, beta, threshold, output);
}
static inline Tensor softplus_backward(const Tensor & grad_output, const Tensor & self, Scalar beta, Scalar threshold, const Tensor & output) {
    static auto table = globalATenDispatch().getOpTable("aten::softplus_backward(Tensor grad_output, Tensor self, Scalar beta, Scalar threshold, Tensor output) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, Scalar, Scalar, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_output, self, beta, threshold, output);
}
static inline Tensor & softshrink_out(Tensor & out, const Tensor & self, Scalar lambd) {
    static auto table = globalATenDispatch().getOpTable("aten::softshrink(Tensor self, Scalar lambd=0.5, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, lambd);
}
static inline Tensor softshrink(const Tensor & self, Scalar lambd) {
    static auto table = globalATenDispatch().getOpTable("aten::softshrink(Tensor self, Scalar lambd=0.5) -> Tensor");
    return table->getOp<Tensor (const Tensor &, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, lambd);
}
static inline Tensor & softshrink_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, Scalar lambd) {
    static auto table = globalATenDispatch().getOpTable("aten::softshrink_backward(Tensor grad_output, Tensor self, Scalar lambd, *, Tensor(a!) grad_input) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_input, grad_output, self, lambd);
}
static inline Tensor softshrink_backward(const Tensor & grad_output, const Tensor & self, Scalar lambd) {
    static auto table = globalATenDispatch().getOpTable("aten::softshrink_backward(Tensor grad_output, Tensor self, Scalar lambd) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, Scalar)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_output, self, lambd);
}
static inline Tensor & adaptive_avg_pool2d_out(Tensor & out, const Tensor & self, IntArrayRef output_size) {
    static auto table = globalATenDispatch().getOpTable("aten::adaptive_avg_pool2d(Tensor self, int[2] output_size, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, output_size);
}
static inline Tensor adaptive_avg_pool2d(const Tensor & self, IntArrayRef output_size) {
    static auto table = globalATenDispatch().getOpTable("aten::adaptive_avg_pool2d(Tensor self, int[2] output_size) -> Tensor");
    return table->getOp<Tensor (const Tensor &, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, output_size);
}
static inline Tensor mkldnn_adaptive_avg_pool2d(const Tensor & self, IntArrayRef output_size) {
    static auto table = globalATenDispatch().getOpTable("aten::mkldnn_adaptive_avg_pool2d(Tensor self, int[2] output_size) -> Tensor");
    return table->getOp<Tensor (const Tensor &, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, output_size);
}
static inline Tensor _adaptive_avg_pool2d(const Tensor & self, IntArrayRef output_size) {
    static auto table = globalATenDispatch().getOpTable("aten::_adaptive_avg_pool2d(Tensor self, int[2] output_size) -> Tensor");
    return table->getOp<Tensor (const Tensor &, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, output_size);
}
static inline Tensor _adaptive_avg_pool2d_backward(const Tensor & grad_output, const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::_adaptive_avg_pool2d_backward(Tensor grad_output, Tensor self) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_output, self);
}
static inline Tensor & adaptive_avg_pool3d_out(Tensor & out, const Tensor & self, IntArrayRef output_size) {
    static auto table = globalATenDispatch().getOpTable("aten::adaptive_avg_pool3d(Tensor self, int[3] output_size, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, output_size);
}
static inline Tensor adaptive_avg_pool3d(const Tensor & self, IntArrayRef output_size) {
    static auto table = globalATenDispatch().getOpTable("aten::adaptive_avg_pool3d(Tensor self, int[3] output_size) -> Tensor");
    return table->getOp<Tensor (const Tensor &, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, output_size);
}
static inline Tensor & adaptive_avg_pool3d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::adaptive_avg_pool3d_backward(Tensor grad_output, Tensor self, *, Tensor(a!) grad_input) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_input, grad_output, self);
}
static inline Tensor adaptive_avg_pool3d_backward(const Tensor & grad_output, const Tensor & self) {
    static auto table = globalATenDispatch().getOpTable("aten::adaptive_avg_pool3d_backward(Tensor grad_output, Tensor self) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_output, self);
}
static inline std::tuple<Tensor &,Tensor &> adaptive_max_pool2d_out(Tensor & out, Tensor & indices, const Tensor & self, IntArrayRef output_size) {
    static auto table = globalATenDispatch().getOpTable("aten::adaptive_max_pool2d(Tensor self, int[2] output_size, *, Tensor(a!) out, Tensor(b!) indices) -> (Tensor(a!), Tensor(b!))");
    return table->getOp<std::tuple<Tensor &,Tensor &> (Tensor &, Tensor &, const Tensor &, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, indices, self, output_size);
}
static inline std::tuple<Tensor,Tensor> adaptive_max_pool2d(const Tensor & self, IntArrayRef output_size) {
    static auto table = globalATenDispatch().getOpTable("aten::adaptive_max_pool2d(Tensor self, int[2] output_size) -> (Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor> (const Tensor &, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, output_size);
}
static inline Tensor & adaptive_max_pool2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & indices) {
    static auto table = globalATenDispatch().getOpTable("aten::adaptive_max_pool2d_backward(Tensor grad_output, Tensor self, Tensor indices, *, Tensor(a!) grad_input) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_input, grad_output, self, indices);
}
static inline Tensor adaptive_max_pool2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & indices) {
    static auto table = globalATenDispatch().getOpTable("aten::adaptive_max_pool2d_backward(Tensor grad_output, Tensor self, Tensor indices) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_output, self, indices);
}
static inline std::tuple<Tensor &,Tensor &> adaptive_max_pool3d_out(Tensor & out, Tensor & indices, const Tensor & self, IntArrayRef output_size) {
    static auto table = globalATenDispatch().getOpTable("aten::adaptive_max_pool3d(Tensor self, int[3] output_size, *, Tensor(a!) out, Tensor(b!) indices) -> (Tensor(a!), Tensor(b!))");
    return table->getOp<std::tuple<Tensor &,Tensor &> (Tensor &, Tensor &, const Tensor &, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, indices, self, output_size);
}
static inline std::tuple<Tensor,Tensor> adaptive_max_pool3d(const Tensor & self, IntArrayRef output_size) {
    static auto table = globalATenDispatch().getOpTable("aten::adaptive_max_pool3d(Tensor self, int[3] output_size) -> (Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor> (const Tensor &, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, output_size);
}
static inline Tensor & adaptive_max_pool3d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & indices) {
    static auto table = globalATenDispatch().getOpTable("aten::adaptive_max_pool3d_backward(Tensor grad_output, Tensor self, Tensor indices, *, Tensor(a!) grad_input) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_input, grad_output, self, indices);
}
static inline Tensor adaptive_max_pool3d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & indices) {
    static auto table = globalATenDispatch().getOpTable("aten::adaptive_max_pool3d_backward(Tensor grad_output, Tensor self, Tensor indices) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_output, self, indices);
}
static inline Tensor & avg_pool2d_out(Tensor & out, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad, c10::optional<int64_t> divisor_override) {
    static auto table = globalATenDispatch().getOpTable("aten::avg_pool2d(Tensor self, int[2] kernel_size, int[2] stride=[], int[2] padding=0, bool ceil_mode=False, bool count_include_pad=True, int? divisor_override=None, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, bool, bool, c10::optional<int64_t>)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, kernel_size, stride, padding, ceil_mode, count_include_pad, divisor_override);
}
static inline Tensor avg_pool2d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad, c10::optional<int64_t> divisor_override) {
    static auto table = globalATenDispatch().getOpTable("aten::avg_pool2d(Tensor self, int[2] kernel_size, int[2] stride=[], int[2] padding=0, bool ceil_mode=False, bool count_include_pad=True, int? divisor_override=None) -> Tensor");
    return table->getOp<Tensor (const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, bool, bool, c10::optional<int64_t>)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, kernel_size, stride, padding, ceil_mode, count_include_pad, divisor_override);
}
static inline Tensor & avg_pool2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad, c10::optional<int64_t> divisor_override) {
    static auto table = globalATenDispatch().getOpTable("aten::avg_pool2d_backward(Tensor grad_output, Tensor self, int[2] kernel_size, int[2] stride, int[2] padding, bool ceil_mode, bool count_include_pad, int? divisor_override, *, Tensor(a!) grad_input) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, bool, bool, c10::optional<int64_t>)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_input, grad_output, self, kernel_size, stride, padding, ceil_mode, count_include_pad, divisor_override);
}
static inline Tensor avg_pool2d_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad, c10::optional<int64_t> divisor_override) {
    static auto table = globalATenDispatch().getOpTable("aten::avg_pool2d_backward(Tensor grad_output, Tensor self, int[2] kernel_size, int[2] stride, int[2] padding, bool ceil_mode, bool count_include_pad, int? divisor_override) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, bool, bool, c10::optional<int64_t>)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_output, self, kernel_size, stride, padding, ceil_mode, count_include_pad, divisor_override);
}
static inline Tensor & avg_pool3d_out(Tensor & out, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad, c10::optional<int64_t> divisor_override) {
    static auto table = globalATenDispatch().getOpTable("aten::avg_pool3d(Tensor self, int[3] kernel_size, int[3] stride=[], int[3] padding=0, bool ceil_mode=False, bool count_include_pad=True, int? divisor_override=None, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, bool, bool, c10::optional<int64_t>)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, kernel_size, stride, padding, ceil_mode, count_include_pad, divisor_override);
}
static inline Tensor avg_pool3d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad, c10::optional<int64_t> divisor_override) {
    static auto table = globalATenDispatch().getOpTable("aten::avg_pool3d(Tensor self, int[3] kernel_size, int[3] stride=[], int[3] padding=0, bool ceil_mode=False, bool count_include_pad=True, int? divisor_override=None) -> Tensor");
    return table->getOp<Tensor (const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, bool, bool, c10::optional<int64_t>)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, kernel_size, stride, padding, ceil_mode, count_include_pad, divisor_override);
}
static inline Tensor & avg_pool3d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad, c10::optional<int64_t> divisor_override) {
    static auto table = globalATenDispatch().getOpTable("aten::avg_pool3d_backward(Tensor grad_output, Tensor self, int[3] kernel_size, int[3] stride, int[3] padding, bool ceil_mode, bool count_include_pad, int? divisor_override, *, Tensor(a!) grad_input) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, bool, bool, c10::optional<int64_t>)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_input, grad_output, self, kernel_size, stride, padding, ceil_mode, count_include_pad, divisor_override);
}
static inline Tensor avg_pool3d_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad, c10::optional<int64_t> divisor_override) {
    static auto table = globalATenDispatch().getOpTable("aten::avg_pool3d_backward(Tensor grad_output, Tensor self, int[3] kernel_size, int[3] stride, int[3] padding, bool ceil_mode, bool count_include_pad, int? divisor_override) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, bool, bool, c10::optional<int64_t>)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_output, self, kernel_size, stride, padding, ceil_mode, count_include_pad, divisor_override);
}
static inline std::tuple<Tensor &,Tensor &> fractional_max_pool2d_out(Tensor & output, Tensor & indices, const Tensor & self, IntArrayRef kernel_size, IntArrayRef output_size, const Tensor & random_samples) {
    static auto table = globalATenDispatch().getOpTable("aten::fractional_max_pool2d(Tensor self, int[2] kernel_size, int[2] output_size, Tensor random_samples, *, Tensor(a!) output, Tensor(b!) indices) -> (Tensor(a!), Tensor(b!))");
    return table->getOp<std::tuple<Tensor &,Tensor &> (Tensor &, Tensor &, const Tensor &, IntArrayRef, IntArrayRef, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(output, indices, self, kernel_size, output_size, random_samples);
}
static inline std::tuple<Tensor,Tensor> fractional_max_pool2d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef output_size, const Tensor & random_samples) {
    static auto table = globalATenDispatch().getOpTable("aten::fractional_max_pool2d(Tensor self, int[2] kernel_size, int[2] output_size, Tensor random_samples) -> (Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor> (const Tensor &, IntArrayRef, IntArrayRef, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, kernel_size, output_size, random_samples);
}
static inline Tensor & fractional_max_pool2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef output_size, const Tensor & indices) {
    static auto table = globalATenDispatch().getOpTable("aten::fractional_max_pool2d_backward(Tensor grad_output, Tensor self, int[2] kernel_size, int[2] output_size, Tensor indices, *, Tensor(a!) grad_input) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, IntArrayRef, IntArrayRef, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_input, grad_output, self, kernel_size, output_size, indices);
}
static inline Tensor fractional_max_pool2d_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef output_size, const Tensor & indices) {
    static auto table = globalATenDispatch().getOpTable("aten::fractional_max_pool2d_backward(Tensor grad_output, Tensor self, int[2] kernel_size, int[2] output_size, Tensor indices) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, IntArrayRef, IntArrayRef, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_output, self, kernel_size, output_size, indices);
}
static inline std::tuple<Tensor &,Tensor &> fractional_max_pool3d_out(Tensor & output, Tensor & indices, const Tensor & self, IntArrayRef kernel_size, IntArrayRef output_size, const Tensor & random_samples) {
    static auto table = globalATenDispatch().getOpTable("aten::fractional_max_pool3d(Tensor self, int[3] kernel_size, int[3] output_size, Tensor random_samples, *, Tensor(a!) output, Tensor(b!) indices) -> (Tensor(a!), Tensor(b!))");
    return table->getOp<std::tuple<Tensor &,Tensor &> (Tensor &, Tensor &, const Tensor &, IntArrayRef, IntArrayRef, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(output, indices, self, kernel_size, output_size, random_samples);
}
static inline std::tuple<Tensor,Tensor> fractional_max_pool3d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef output_size, const Tensor & random_samples) {
    static auto table = globalATenDispatch().getOpTable("aten::fractional_max_pool3d(Tensor self, int[3] kernel_size, int[3] output_size, Tensor random_samples) -> (Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor> (const Tensor &, IntArrayRef, IntArrayRef, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, kernel_size, output_size, random_samples);
}
static inline Tensor & fractional_max_pool3d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef output_size, const Tensor & indices) {
    static auto table = globalATenDispatch().getOpTable("aten::fractional_max_pool3d_backward(Tensor grad_output, Tensor self, int[3] kernel_size, int[3] output_size, Tensor indices, *, Tensor(a!) grad_input) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, IntArrayRef, IntArrayRef, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_input, grad_output, self, kernel_size, output_size, indices);
}
static inline Tensor fractional_max_pool3d_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef output_size, const Tensor & indices) {
    static auto table = globalATenDispatch().getOpTable("aten::fractional_max_pool3d_backward(Tensor grad_output, Tensor self, int[3] kernel_size, int[3] output_size, Tensor indices) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, IntArrayRef, IntArrayRef, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_output, self, kernel_size, output_size, indices);
}
static inline std::tuple<Tensor &,Tensor &> max_pool2d_with_indices_out(Tensor & out, Tensor & indices, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode) {
    static auto table = globalATenDispatch().getOpTable("aten::max_pool2d_with_indices(Tensor self, int[2] kernel_size, int[2] stride=[], int[2] padding=0, int[2] dilation=1, bool ceil_mode=False, *, Tensor(a!) out, Tensor(b!) indices) -> (Tensor(a!), Tensor(b!))");
    return table->getOp<std::tuple<Tensor &,Tensor &> (Tensor &, Tensor &, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, IntArrayRef, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, indices, self, kernel_size, stride, padding, dilation, ceil_mode);
}
static inline std::tuple<Tensor,Tensor> max_pool2d_with_indices(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode) {
    static auto table = globalATenDispatch().getOpTable("aten::max_pool2d_with_indices(Tensor self, int[2] kernel_size, int[2] stride=[], int[2] padding=0, int[2] dilation=1, bool ceil_mode=False) -> (Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor> (const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, IntArrayRef, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, kernel_size, stride, padding, dilation, ceil_mode);
}
static inline Tensor & max_pool2d_with_indices_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode, const Tensor & indices) {
    static auto table = globalATenDispatch().getOpTable("aten::max_pool2d_with_indices_backward(Tensor grad_output, Tensor self, int[2] kernel_size, int[2] stride, int[2] padding, int[2] dilation, bool ceil_mode, Tensor indices, *, Tensor(a!) grad_input) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, IntArrayRef, bool, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_input, grad_output, self, kernel_size, stride, padding, dilation, ceil_mode, indices);
}
static inline Tensor max_pool2d_with_indices_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode, const Tensor & indices) {
    static auto table = globalATenDispatch().getOpTable("aten::max_pool2d_with_indices_backward(Tensor grad_output, Tensor self, int[2] kernel_size, int[2] stride, int[2] padding, int[2] dilation, bool ceil_mode, Tensor indices) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, IntArrayRef, bool, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_output, self, kernel_size, stride, padding, dilation, ceil_mode, indices);
}
static inline std::tuple<Tensor &,Tensor &> max_pool3d_with_indices_out(Tensor & out, Tensor & indices, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode) {
    static auto table = globalATenDispatch().getOpTable("aten::max_pool3d_with_indices(Tensor self, int[3] kernel_size, int[3] stride=[], int[3] padding=0, int[3] dilation=1, bool ceil_mode=False, *, Tensor(a!) out, Tensor(b!) indices) -> (Tensor(a!), Tensor(b!))");
    return table->getOp<std::tuple<Tensor &,Tensor &> (Tensor &, Tensor &, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, IntArrayRef, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, indices, self, kernel_size, stride, padding, dilation, ceil_mode);
}
static inline std::tuple<Tensor,Tensor> max_pool3d_with_indices(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode) {
    static auto table = globalATenDispatch().getOpTable("aten::max_pool3d_with_indices(Tensor self, int[3] kernel_size, int[3] stride=[], int[3] padding=0, int[3] dilation=1, bool ceil_mode=False) -> (Tensor, Tensor)");
    return table->getOp<std::tuple<Tensor,Tensor> (const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, IntArrayRef, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, kernel_size, stride, padding, dilation, ceil_mode);
}
static inline Tensor & max_pool3d_with_indices_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode, const Tensor & indices) {
    static auto table = globalATenDispatch().getOpTable("aten::max_pool3d_with_indices_backward(Tensor grad_output, Tensor self, int[3] kernel_size, int[3] stride, int[3] padding, int[3] dilation, bool ceil_mode, Tensor indices, *, Tensor(a!) grad_input) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, IntArrayRef, bool, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_input, grad_output, self, kernel_size, stride, padding, dilation, ceil_mode, indices);
}
static inline Tensor max_pool3d_with_indices_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode, const Tensor & indices) {
    static auto table = globalATenDispatch().getOpTable("aten::max_pool3d_with_indices_backward(Tensor grad_output, Tensor self, int[3] kernel_size, int[3] stride, int[3] padding, int[3] dilation, bool ceil_mode, Tensor indices) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, IntArrayRef, bool, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_output, self, kernel_size, stride, padding, dilation, ceil_mode, indices);
}
static inline Tensor & max_unpool2d_out(Tensor & out, const Tensor & self, const Tensor & indices, IntArrayRef output_size) {
    static auto table = globalATenDispatch().getOpTable("aten::max_unpool2d(Tensor self, Tensor indices, int[2] output_size, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, indices, output_size);
}
static inline Tensor max_unpool2d(const Tensor & self, const Tensor & indices, IntArrayRef output_size) {
    static auto table = globalATenDispatch().getOpTable("aten::max_unpool2d(Tensor self, Tensor indices, int[2] output_size) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, indices, output_size);
}
static inline Tensor & max_unpool2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & indices, IntArrayRef output_size) {
    static auto table = globalATenDispatch().getOpTable("aten::max_unpool2d_backward(Tensor grad_output, Tensor self, Tensor indices, int[2] output_size, *, Tensor(a!) grad_input) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, const Tensor &, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_input, grad_output, self, indices, output_size);
}
static inline Tensor max_unpool2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & indices, IntArrayRef output_size) {
    static auto table = globalATenDispatch().getOpTable("aten::max_unpool2d_backward(Tensor grad_output, Tensor self, Tensor indices, int[2] output_size) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_output, self, indices, output_size);
}
static inline Tensor & max_unpool3d_out(Tensor & out, const Tensor & self, const Tensor & indices, IntArrayRef output_size, IntArrayRef stride, IntArrayRef padding) {
    static auto table = globalATenDispatch().getOpTable("aten::max_unpool3d(Tensor self, Tensor indices, int[3] output_size, int[3] stride, int[3] padding, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, indices, output_size, stride, padding);
}
static inline Tensor max_unpool3d(const Tensor & self, const Tensor & indices, IntArrayRef output_size, IntArrayRef stride, IntArrayRef padding) {
    static auto table = globalATenDispatch().getOpTable("aten::max_unpool3d(Tensor self, Tensor indices, int[3] output_size, int[3] stride, int[3] padding) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, indices, output_size, stride, padding);
}
static inline Tensor & max_unpool3d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & indices, IntArrayRef output_size, IntArrayRef stride, IntArrayRef padding) {
    static auto table = globalATenDispatch().getOpTable("aten::max_unpool3d_backward(Tensor grad_output, Tensor self, Tensor indices, int[3] output_size, int[3] stride, int[3] padding, *, Tensor(a!) grad_input) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_input, grad_output, self, indices, output_size, stride, padding);
}
static inline Tensor max_unpool3d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & indices, IntArrayRef output_size, IntArrayRef stride, IntArrayRef padding) {
    static auto table = globalATenDispatch().getOpTable("aten::max_unpool3d_backward(Tensor grad_output, Tensor self, Tensor indices, int[3] output_size, int[3] stride, int[3] padding) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_output, self, indices, output_size, stride, padding);
}
static inline Tensor & reflection_pad1d_out(Tensor & out, const Tensor & self, IntArrayRef padding) {
    static auto table = globalATenDispatch().getOpTable("aten::reflection_pad1d(Tensor self, int[2] padding, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, padding);
}
static inline Tensor reflection_pad1d(const Tensor & self, IntArrayRef padding) {
    static auto table = globalATenDispatch().getOpTable("aten::reflection_pad1d(Tensor self, int[2] padding) -> Tensor");
    return table->getOp<Tensor (const Tensor &, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, padding);
}
static inline Tensor & reflection_pad1d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef padding) {
    static auto table = globalATenDispatch().getOpTable("aten::reflection_pad1d_backward(Tensor grad_output, Tensor self, int[2] padding, *, Tensor(a!) grad_input) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_input, grad_output, self, padding);
}
static inline Tensor reflection_pad1d_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef padding) {
    static auto table = globalATenDispatch().getOpTable("aten::reflection_pad1d_backward(Tensor grad_output, Tensor self, int[2] padding) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_output, self, padding);
}
static inline Tensor & reflection_pad2d_out(Tensor & out, const Tensor & self, IntArrayRef padding) {
    static auto table = globalATenDispatch().getOpTable("aten::reflection_pad2d(Tensor self, int[4] padding, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, padding);
}
static inline Tensor reflection_pad2d(const Tensor & self, IntArrayRef padding) {
    static auto table = globalATenDispatch().getOpTable("aten::reflection_pad2d(Tensor self, int[4] padding) -> Tensor");
    return table->getOp<Tensor (const Tensor &, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, padding);
}
static inline Tensor & reflection_pad2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef padding) {
    static auto table = globalATenDispatch().getOpTable("aten::reflection_pad2d_backward(Tensor grad_output, Tensor self, int[4] padding, *, Tensor(a!) grad_input) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_input, grad_output, self, padding);
}
static inline Tensor reflection_pad2d_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef padding) {
    static auto table = globalATenDispatch().getOpTable("aten::reflection_pad2d_backward(Tensor grad_output, Tensor self, int[4] padding) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_output, self, padding);
}
static inline Tensor & replication_pad1d_out(Tensor & out, const Tensor & self, IntArrayRef padding) {
    static auto table = globalATenDispatch().getOpTable("aten::replication_pad1d(Tensor self, int[2] padding, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, padding);
}
static inline Tensor replication_pad1d(const Tensor & self, IntArrayRef padding) {
    static auto table = globalATenDispatch().getOpTable("aten::replication_pad1d(Tensor self, int[2] padding) -> Tensor");
    return table->getOp<Tensor (const Tensor &, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, padding);
}
static inline Tensor & replication_pad1d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef padding) {
    static auto table = globalATenDispatch().getOpTable("aten::replication_pad1d_backward(Tensor grad_output, Tensor self, int[2] padding, *, Tensor(a!) grad_input) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_input, grad_output, self, padding);
}
static inline Tensor replication_pad1d_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef padding) {
    static auto table = globalATenDispatch().getOpTable("aten::replication_pad1d_backward(Tensor grad_output, Tensor self, int[2] padding) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_output, self, padding);
}
static inline Tensor & replication_pad2d_out(Tensor & out, const Tensor & self, IntArrayRef padding) {
    static auto table = globalATenDispatch().getOpTable("aten::replication_pad2d(Tensor self, int[4] padding, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, padding);
}
static inline Tensor replication_pad2d(const Tensor & self, IntArrayRef padding) {
    static auto table = globalATenDispatch().getOpTable("aten::replication_pad2d(Tensor self, int[4] padding) -> Tensor");
    return table->getOp<Tensor (const Tensor &, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, padding);
}
static inline Tensor & replication_pad2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef padding) {
    static auto table = globalATenDispatch().getOpTable("aten::replication_pad2d_backward(Tensor grad_output, Tensor self, int[4] padding, *, Tensor(a!) grad_input) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_input, grad_output, self, padding);
}
static inline Tensor replication_pad2d_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef padding) {
    static auto table = globalATenDispatch().getOpTable("aten::replication_pad2d_backward(Tensor grad_output, Tensor self, int[4] padding) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_output, self, padding);
}
static inline Tensor & replication_pad3d_out(Tensor & out, const Tensor & self, IntArrayRef padding) {
    static auto table = globalATenDispatch().getOpTable("aten::replication_pad3d(Tensor self, int[6] padding, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, padding);
}
static inline Tensor replication_pad3d(const Tensor & self, IntArrayRef padding) {
    static auto table = globalATenDispatch().getOpTable("aten::replication_pad3d(Tensor self, int[6] padding) -> Tensor");
    return table->getOp<Tensor (const Tensor &, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, padding);
}
static inline Tensor & replication_pad3d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef padding) {
    static auto table = globalATenDispatch().getOpTable("aten::replication_pad3d_backward(Tensor grad_output, Tensor self, int[6] padding, *, Tensor(a!) grad_input) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_input, grad_output, self, padding);
}
static inline Tensor replication_pad3d_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef padding) {
    static auto table = globalATenDispatch().getOpTable("aten::replication_pad3d_backward(Tensor grad_output, Tensor self, int[6] padding) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_output, self, padding);
}
static inline Tensor & upsample_linear1d_out(Tensor & out, const Tensor & self, IntArrayRef output_size, bool align_corners) {
    static auto table = globalATenDispatch().getOpTable("aten::upsample_linear1d(Tensor self, int[1] output_size, bool align_corners, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, IntArrayRef, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, output_size, align_corners);
}
static inline Tensor upsample_linear1d(const Tensor & self, IntArrayRef output_size, bool align_corners) {
    static auto table = globalATenDispatch().getOpTable("aten::upsample_linear1d(Tensor self, int[1] output_size, bool align_corners) -> Tensor");
    return table->getOp<Tensor (const Tensor &, IntArrayRef, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, output_size, align_corners);
}
static inline Tensor & upsample_linear1d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners) {
    static auto table = globalATenDispatch().getOpTable("aten::upsample_linear1d_backward(Tensor grad_output, int[1] output_size, int[3] input_size, bool align_corners, *, Tensor(a!) grad_input) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, IntArrayRef, IntArrayRef, bool)>(at::detail::infer_backend(grad_input), at::detail::infer_is_variable(grad_input))(grad_input, grad_output, output_size, input_size, align_corners);
}
static inline Tensor upsample_linear1d_backward(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners) {
    static auto table = globalATenDispatch().getOpTable("aten::upsample_linear1d_backward(Tensor grad_output, int[1] output_size, int[3] input_size, bool align_corners) -> Tensor");
    return table->getOp<Tensor (const Tensor &, IntArrayRef, IntArrayRef, bool)>(at::detail::infer_backend(grad_output), at::detail::infer_is_variable(grad_output))(grad_output, output_size, input_size, align_corners);
}
static inline Tensor & upsample_bilinear2d_out(Tensor & out, const Tensor & self, IntArrayRef output_size, bool align_corners) {
    static auto table = globalATenDispatch().getOpTable("aten::upsample_bilinear2d(Tensor self, int[2] output_size, bool align_corners, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, IntArrayRef, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, output_size, align_corners);
}
static inline Tensor upsample_bilinear2d(const Tensor & self, IntArrayRef output_size, bool align_corners) {
    static auto table = globalATenDispatch().getOpTable("aten::upsample_bilinear2d(Tensor self, int[2] output_size, bool align_corners) -> Tensor");
    return table->getOp<Tensor (const Tensor &, IntArrayRef, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, output_size, align_corners);
}
static inline Tensor & upsample_bilinear2d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners) {
    static auto table = globalATenDispatch().getOpTable("aten::upsample_bilinear2d_backward(Tensor grad_output, int[2] output_size, int[4] input_size, bool align_corners, *, Tensor(a!) grad_input) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, IntArrayRef, IntArrayRef, bool)>(at::detail::infer_backend(grad_input), at::detail::infer_is_variable(grad_input))(grad_input, grad_output, output_size, input_size, align_corners);
}
static inline Tensor upsample_bilinear2d_backward(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners) {
    static auto table = globalATenDispatch().getOpTable("aten::upsample_bilinear2d_backward(Tensor grad_output, int[2] output_size, int[4] input_size, bool align_corners) -> Tensor");
    return table->getOp<Tensor (const Tensor &, IntArrayRef, IntArrayRef, bool)>(at::detail::infer_backend(grad_output), at::detail::infer_is_variable(grad_output))(grad_output, output_size, input_size, align_corners);
}
static inline Tensor & upsample_bicubic2d_out(Tensor & out, const Tensor & self, IntArrayRef output_size, bool align_corners) {
    static auto table = globalATenDispatch().getOpTable("aten::upsample_bicubic2d(Tensor self, int[2] output_size, bool align_corners, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, IntArrayRef, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, output_size, align_corners);
}
static inline Tensor upsample_bicubic2d(const Tensor & self, IntArrayRef output_size, bool align_corners) {
    static auto table = globalATenDispatch().getOpTable("aten::upsample_bicubic2d(Tensor self, int[2] output_size, bool align_corners) -> Tensor");
    return table->getOp<Tensor (const Tensor &, IntArrayRef, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, output_size, align_corners);
}
static inline Tensor & upsample_bicubic2d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners) {
    static auto table = globalATenDispatch().getOpTable("aten::upsample_bicubic2d_backward(Tensor grad_output, int[2] output_size, int[4] input_size, bool align_corners, *, Tensor(a!) grad_input) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, IntArrayRef, IntArrayRef, bool)>(at::detail::infer_backend(grad_input), at::detail::infer_is_variable(grad_input))(grad_input, grad_output, output_size, input_size, align_corners);
}
static inline Tensor upsample_bicubic2d_backward(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners) {
    static auto table = globalATenDispatch().getOpTable("aten::upsample_bicubic2d_backward(Tensor grad_output, int[2] output_size, int[4] input_size, bool align_corners) -> Tensor");
    return table->getOp<Tensor (const Tensor &, IntArrayRef, IntArrayRef, bool)>(at::detail::infer_backend(grad_output), at::detail::infer_is_variable(grad_output))(grad_output, output_size, input_size, align_corners);
}
static inline Tensor & upsample_trilinear3d_out(Tensor & out, const Tensor & self, IntArrayRef output_size, bool align_corners) {
    static auto table = globalATenDispatch().getOpTable("aten::upsample_trilinear3d(Tensor self, int[3] output_size, bool align_corners, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, IntArrayRef, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, output_size, align_corners);
}
static inline Tensor upsample_trilinear3d(const Tensor & self, IntArrayRef output_size, bool align_corners) {
    static auto table = globalATenDispatch().getOpTable("aten::upsample_trilinear3d(Tensor self, int[3] output_size, bool align_corners) -> Tensor");
    return table->getOp<Tensor (const Tensor &, IntArrayRef, bool)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, output_size, align_corners);
}
static inline Tensor & upsample_trilinear3d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners) {
    static auto table = globalATenDispatch().getOpTable("aten::upsample_trilinear3d_backward(Tensor grad_output, int[3] output_size, int[5] input_size, bool align_corners, *, Tensor(a!) grad_input) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, IntArrayRef, IntArrayRef, bool)>(at::detail::infer_backend(grad_input), at::detail::infer_is_variable(grad_input))(grad_input, grad_output, output_size, input_size, align_corners);
}
static inline Tensor upsample_trilinear3d_backward(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners) {
    static auto table = globalATenDispatch().getOpTable("aten::upsample_trilinear3d_backward(Tensor grad_output, int[3] output_size, int[5] input_size, bool align_corners) -> Tensor");
    return table->getOp<Tensor (const Tensor &, IntArrayRef, IntArrayRef, bool)>(at::detail::infer_backend(grad_output), at::detail::infer_is_variable(grad_output))(grad_output, output_size, input_size, align_corners);
}
static inline Tensor & upsample_nearest1d_out(Tensor & out, const Tensor & self, IntArrayRef output_size) {
    static auto table = globalATenDispatch().getOpTable("aten::upsample_nearest1d(Tensor self, int[1] output_size, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, output_size);
}
static inline Tensor upsample_nearest1d(const Tensor & self, IntArrayRef output_size) {
    static auto table = globalATenDispatch().getOpTable("aten::upsample_nearest1d(Tensor self, int[1] output_size) -> Tensor");
    return table->getOp<Tensor (const Tensor &, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, output_size);
}
static inline Tensor & upsample_nearest1d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size) {
    static auto table = globalATenDispatch().getOpTable("aten::upsample_nearest1d_backward(Tensor grad_output, int[1] output_size, int[3] input_size, *, Tensor(a!) grad_input) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, IntArrayRef, IntArrayRef)>(at::detail::infer_backend(grad_input), at::detail::infer_is_variable(grad_input))(grad_input, grad_output, output_size, input_size);
}
static inline Tensor upsample_nearest1d_backward(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size) {
    static auto table = globalATenDispatch().getOpTable("aten::upsample_nearest1d_backward(Tensor grad_output, int[1] output_size, int[3] input_size) -> Tensor");
    return table->getOp<Tensor (const Tensor &, IntArrayRef, IntArrayRef)>(at::detail::infer_backend(grad_output), at::detail::infer_is_variable(grad_output))(grad_output, output_size, input_size);
}
static inline Tensor & upsample_nearest2d_out(Tensor & out, const Tensor & self, IntArrayRef output_size) {
    static auto table = globalATenDispatch().getOpTable("aten::upsample_nearest2d(Tensor self, int[2] output_size, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, output_size);
}
static inline Tensor upsample_nearest2d(const Tensor & self, IntArrayRef output_size) {
    static auto table = globalATenDispatch().getOpTable("aten::upsample_nearest2d(Tensor self, int[2] output_size) -> Tensor");
    return table->getOp<Tensor (const Tensor &, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, output_size);
}
static inline Tensor & upsample_nearest2d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size) {
    static auto table = globalATenDispatch().getOpTable("aten::upsample_nearest2d_backward(Tensor grad_output, int[2] output_size, int[4] input_size, *, Tensor(a!) grad_input) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, IntArrayRef, IntArrayRef)>(at::detail::infer_backend(grad_input), at::detail::infer_is_variable(grad_input))(grad_input, grad_output, output_size, input_size);
}
static inline Tensor upsample_nearest2d_backward(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size) {
    static auto table = globalATenDispatch().getOpTable("aten::upsample_nearest2d_backward(Tensor grad_output, int[2] output_size, int[4] input_size) -> Tensor");
    return table->getOp<Tensor (const Tensor &, IntArrayRef, IntArrayRef)>(at::detail::infer_backend(grad_output), at::detail::infer_is_variable(grad_output))(grad_output, output_size, input_size);
}
static inline Tensor & upsample_nearest3d_out(Tensor & out, const Tensor & self, IntArrayRef output_size) {
    static auto table = globalATenDispatch().getOpTable("aten::upsample_nearest3d(Tensor self, int[3] output_size, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, output_size);
}
static inline Tensor upsample_nearest3d(const Tensor & self, IntArrayRef output_size) {
    static auto table = globalATenDispatch().getOpTable("aten::upsample_nearest3d(Tensor self, int[3] output_size) -> Tensor");
    return table->getOp<Tensor (const Tensor &, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, output_size);
}
static inline Tensor & upsample_nearest3d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size) {
    static auto table = globalATenDispatch().getOpTable("aten::upsample_nearest3d_backward(Tensor grad_output, int[3] output_size, int[5] input_size, *, Tensor(a!) grad_input) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, IntArrayRef, IntArrayRef)>(at::detail::infer_backend(grad_input), at::detail::infer_is_variable(grad_input))(grad_input, grad_output, output_size, input_size);
}
static inline Tensor upsample_nearest3d_backward(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size) {
    static auto table = globalATenDispatch().getOpTable("aten::upsample_nearest3d_backward(Tensor grad_output, int[3] output_size, int[5] input_size) -> Tensor");
    return table->getOp<Tensor (const Tensor &, IntArrayRef, IntArrayRef)>(at::detail::infer_backend(grad_output), at::detail::infer_is_variable(grad_output))(grad_output, output_size, input_size);
}
static inline Tensor & sigmoid_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & output) {
    static auto table = globalATenDispatch().getOpTable("aten::sigmoid_backward(Tensor grad_output, Tensor output, *, Tensor(a!) grad_input) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &)>(at::detail::infer_backend(grad_input), at::detail::infer_is_variable(grad_input))(grad_input, grad_output, output);
}
static inline Tensor sigmoid_backward(const Tensor & grad_output, const Tensor & output) {
    static auto table = globalATenDispatch().getOpTable("aten::sigmoid_backward(Tensor grad_output, Tensor output) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &)>(at::detail::infer_backend(grad_output), at::detail::infer_is_variable(grad_output))(grad_output, output);
}
static inline Tensor & tanh_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & output) {
    static auto table = globalATenDispatch().getOpTable("aten::tanh_backward(Tensor grad_output, Tensor output, *, Tensor(a!) grad_input) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &)>(at::detail::infer_backend(grad_input), at::detail::infer_is_variable(grad_input))(grad_input, grad_output, output);
}
static inline Tensor tanh_backward(const Tensor & grad_output, const Tensor & output) {
    static auto table = globalATenDispatch().getOpTable("aten::tanh_backward(Tensor grad_output, Tensor output) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &)>(at::detail::infer_backend(grad_output), at::detail::infer_is_variable(grad_output))(grad_output, output);
}
static inline Tensor & conv_transpose2d_out(Tensor & out, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation) {
    static auto table = globalATenDispatch().getOpTable("aten::conv_transpose2d(Tensor self, Tensor weight, int[2] kernel_size, Tensor? bias=None, int[2] stride=1, int[2] padding=0, int[2] output_padding=0, int[2] dilation=1, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, IntArrayRef, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, weight, kernel_size, bias, stride, padding, output_padding, dilation);
}
static inline Tensor conv_transpose2d(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation) {
    static auto table = globalATenDispatch().getOpTable("aten::conv_transpose2d(Tensor self, Tensor weight, int[2] kernel_size, Tensor? bias=None, int[2] stride=1, int[2] padding=0, int[2] output_padding=0, int[2] dilation=1) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, IntArrayRef, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, weight, kernel_size, bias, stride, padding, output_padding, dilation);
}
static inline std::tuple<Tensor &,Tensor &,Tensor &> conv_transpose2d_backward_out(Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation, const Tensor & columns, const Tensor & ones) {
    static auto table = globalATenDispatch().getOpTable("aten::conv_transpose2d_backward(Tensor grad_output, Tensor self, Tensor weight, int[2] kernel_size, int[2] stride, int[2] padding, int[2] output_padding, int[2] dilation, Tensor columns, Tensor ones, *, Tensor?(a!) grad_input, Tensor?(b!) grad_weight, Tensor?(c!) grad_bias) -> (Tensor(a!), Tensor(b!), Tensor(c!))");
    return table->getOp<std::tuple<Tensor &,Tensor &,Tensor &> (Tensor &, Tensor &, Tensor &, const Tensor &, const Tensor &, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, IntArrayRef, IntArrayRef, const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_input, grad_weight, grad_bias, grad_output, self, weight, kernel_size, stride, padding, output_padding, dilation, columns, ones);
}
static inline std::tuple<Tensor,Tensor,Tensor> conv_transpose2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation, const Tensor & columns, const Tensor & ones, std::array<bool,3> output_mask) {
    static auto table = globalATenDispatch().getOpTable("aten::conv_transpose2d_backward(Tensor grad_output, Tensor self, Tensor weight, int[2] kernel_size, int[2] stride, int[2] padding, int[2] output_padding, int[2] dilation, Tensor columns, Tensor ones, bool[3] output_mask) -> (Tensor grad_input, Tensor grad_weight, Tensor grad_bias)");
    return table->getOp<std::tuple<Tensor,Tensor,Tensor> (const Tensor &, const Tensor &, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, IntArrayRef, IntArrayRef, const Tensor &, const Tensor &, std::array<bool,3>)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_output, self, weight, kernel_size, stride, padding, output_padding, dilation, columns, ones, output_mask);
}
static inline Tensor & conv_transpose3d_out(Tensor & out, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation) {
    static auto table = globalATenDispatch().getOpTable("aten::conv_transpose3d(Tensor self, Tensor weight, int[3] kernel_size, Tensor? bias=None, int[3] stride=1, int[3] padding=0, int[3] output_padding=0, int[3] dilation=1, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, IntArrayRef, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, weight, kernel_size, bias, stride, padding, output_padding, dilation);
}
static inline Tensor conv_transpose3d(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation) {
    static auto table = globalATenDispatch().getOpTable("aten::conv_transpose3d(Tensor self, Tensor weight, int[3] kernel_size, Tensor? bias=None, int[3] stride=1, int[3] padding=0, int[3] output_padding=0, int[3] dilation=1) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, IntArrayRef, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, weight, kernel_size, bias, stride, padding, output_padding, dilation);
}
static inline std::tuple<Tensor &,Tensor &,Tensor &> conv_transpose3d_backward_out(Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation, const Tensor & finput, const Tensor & fgrad_input) {
    static auto table = globalATenDispatch().getOpTable("aten::conv_transpose3d_backward(Tensor grad_output, Tensor self, Tensor weight, int[3] kernel_size, int[3] stride, int[3] padding, int[3] output_padding, int[3] dilation, Tensor finput, Tensor fgrad_input, *, Tensor?(a!) grad_input, Tensor?(b!) grad_weight, Tensor?(c!) grad_bias) -> (Tensor(a!), Tensor(b!), Tensor(c!))");
    return table->getOp<std::tuple<Tensor &,Tensor &,Tensor &> (Tensor &, Tensor &, Tensor &, const Tensor &, const Tensor &, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, IntArrayRef, IntArrayRef, const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_input, grad_weight, grad_bias, grad_output, self, weight, kernel_size, stride, padding, output_padding, dilation, finput, fgrad_input);
}
static inline std::tuple<Tensor,Tensor,Tensor> conv_transpose3d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation, const Tensor & finput, const Tensor & fgrad_input, std::array<bool,3> output_mask) {
    static auto table = globalATenDispatch().getOpTable("aten::conv_transpose3d_backward(Tensor grad_output, Tensor self, Tensor weight, int[3] kernel_size, int[3] stride, int[3] padding, int[3] output_padding, int[3] dilation, Tensor finput, Tensor fgrad_input, bool[3] output_mask) -> (Tensor grad_input, Tensor grad_weight, Tensor grad_bias)");
    return table->getOp<std::tuple<Tensor,Tensor,Tensor> (const Tensor &, const Tensor &, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, IntArrayRef, IntArrayRef, const Tensor &, const Tensor &, std::array<bool,3>)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_output, self, weight, kernel_size, stride, padding, output_padding, dilation, finput, fgrad_input, output_mask);
}
static inline Tensor & thnn_conv2d_out(Tensor & out, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding) {
    static auto table = globalATenDispatch().getOpTable("aten::thnn_conv2d(Tensor self, Tensor weight, int[2] kernel_size, Tensor? bias=None, int[2] stride=1, int[2] padding=0, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, IntArrayRef, const Tensor &, IntArrayRef, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, weight, kernel_size, bias, stride, padding);
}
static inline Tensor thnn_conv2d(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding) {
    static auto table = globalATenDispatch().getOpTable("aten::thnn_conv2d(Tensor self, Tensor weight, int[2] kernel_size, Tensor? bias=None, int[2] stride=1, int[2] padding=0) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, IntArrayRef, const Tensor &, IntArrayRef, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, weight, kernel_size, bias, stride, padding);
}
static inline std::tuple<Tensor &,Tensor &,Tensor &> thnn_conv2d_forward_out(Tensor & output, Tensor & finput, Tensor & fgrad_input, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding) {
    static auto table = globalATenDispatch().getOpTable("aten::thnn_conv2d_forward(Tensor self, Tensor weight, int[2] kernel_size, Tensor? bias, int[2] stride, int[2] padding, *, Tensor(a!) output, Tensor(b!) finput, Tensor(c!) fgrad_input) -> (Tensor(a!), Tensor(b!), Tensor(c!))");
    return table->getOp<std::tuple<Tensor &,Tensor &,Tensor &> (Tensor &, Tensor &, Tensor &, const Tensor &, const Tensor &, IntArrayRef, const Tensor &, IntArrayRef, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(output, finput, fgrad_input, self, weight, kernel_size, bias, stride, padding);
}
static inline std::tuple<Tensor,Tensor,Tensor> thnn_conv2d_forward(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding) {
    static auto table = globalATenDispatch().getOpTable("aten::thnn_conv2d_forward(Tensor self, Tensor weight, int[2] kernel_size, Tensor? bias, int[2] stride, int[2] padding) -> (Tensor output, Tensor finput, Tensor fgrad_input)");
    return table->getOp<std::tuple<Tensor,Tensor,Tensor> (const Tensor &, const Tensor &, IntArrayRef, const Tensor &, IntArrayRef, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, weight, kernel_size, bias, stride, padding);
}
static inline std::tuple<Tensor &,Tensor &,Tensor &> thnn_conv2d_backward_out(Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, const Tensor & finput, const Tensor & fgrad_input) {
    static auto table = globalATenDispatch().getOpTable("aten::thnn_conv2d_backward(Tensor grad_output, Tensor self, Tensor weight, int[2] kernel_size, int[2] stride, int[2] padding, Tensor finput, Tensor fgrad_input, *, Tensor?(a!) grad_input, Tensor?(b!) grad_weight, Tensor?(c!) grad_bias) -> (Tensor(a!), Tensor(b!), Tensor(c!))");
    return table->getOp<std::tuple<Tensor &,Tensor &,Tensor &> (Tensor &, Tensor &, Tensor &, const Tensor &, const Tensor &, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_input, grad_weight, grad_bias, grad_output, self, weight, kernel_size, stride, padding, finput, fgrad_input);
}
static inline std::tuple<Tensor,Tensor,Tensor> thnn_conv2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, const Tensor & finput, const Tensor & fgrad_input, std::array<bool,3> output_mask) {
    static auto table = globalATenDispatch().getOpTable("aten::thnn_conv2d_backward(Tensor grad_output, Tensor self, Tensor weight, int[2] kernel_size, int[2] stride, int[2] padding, Tensor finput, Tensor fgrad_input, bool[3] output_mask) -> (Tensor grad_input, Tensor grad_weight, Tensor grad_bias)");
    return table->getOp<std::tuple<Tensor,Tensor,Tensor> (const Tensor &, const Tensor &, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, const Tensor &, const Tensor &, std::array<bool,3>)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_output, self, weight, kernel_size, stride, padding, finput, fgrad_input, output_mask);
}
static inline Tensor & thnn_conv_depthwise2d_out(Tensor & out, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation) {
    static auto table = globalATenDispatch().getOpTable("aten::thnn_conv_depthwise2d(Tensor self, Tensor weight, int[2] kernel_size, Tensor? bias=None, int[2] stride=1, int[2] padding=0, int[2] dilation=1, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, IntArrayRef, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, weight, kernel_size, bias, stride, padding, dilation);
}
static inline Tensor thnn_conv_depthwise2d(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation) {
    static auto table = globalATenDispatch().getOpTable("aten::thnn_conv_depthwise2d(Tensor self, Tensor weight, int[2] kernel_size, Tensor? bias=None, int[2] stride=1, int[2] padding=0, int[2] dilation=1) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, IntArrayRef, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, weight, kernel_size, bias, stride, padding, dilation);
}
static inline Tensor & thnn_conv_depthwise2d_forward_out(Tensor & out, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation) {
    static auto table = globalATenDispatch().getOpTable("aten::thnn_conv_depthwise2d_forward(Tensor self, Tensor weight, int[2] kernel_size, Tensor? bias, int[2] stride, int[2] padding, int[2] dilation, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, IntArrayRef, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, weight, kernel_size, bias, stride, padding, dilation);
}
static inline Tensor thnn_conv_depthwise2d_forward(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation) {
    static auto table = globalATenDispatch().getOpTable("aten::thnn_conv_depthwise2d_forward(Tensor self, Tensor weight, int[2] kernel_size, Tensor? bias, int[2] stride, int[2] padding, int[2] dilation) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, IntArrayRef, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, weight, kernel_size, bias, stride, padding, dilation);
}
static inline std::tuple<Tensor &,Tensor &> thnn_conv_depthwise2d_backward_out(Tensor & grad_input, Tensor & grad_weight, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation) {
    static auto table = globalATenDispatch().getOpTable("aten::thnn_conv_depthwise2d_backward(Tensor grad_output, Tensor self, Tensor weight, int[2] kernel_size, int[2] stride, int[2] padding, int[2] dilation, *, Tensor?(a!) grad_input, Tensor?(b!) grad_weight) -> (Tensor(a!), Tensor(b!))");
    return table->getOp<std::tuple<Tensor &,Tensor &> (Tensor &, Tensor &, const Tensor &, const Tensor &, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_input, grad_weight, grad_output, self, weight, kernel_size, stride, padding, dilation);
}
static inline std::tuple<Tensor,Tensor> thnn_conv_depthwise2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, std::array<bool,2> output_mask) {
    static auto table = globalATenDispatch().getOpTable("aten::thnn_conv_depthwise2d_backward(Tensor grad_output, Tensor self, Tensor weight, int[2] kernel_size, int[2] stride, int[2] padding, int[2] dilation, bool[2] output_mask) -> (Tensor grad_input, Tensor grad_weight)");
    return table->getOp<std::tuple<Tensor,Tensor> (const Tensor &, const Tensor &, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, IntArrayRef, std::array<bool,2>)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_output, self, weight, kernel_size, stride, padding, dilation, output_mask);
}
static inline Tensor & thnn_conv3d_out(Tensor & out, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding) {
    static auto table = globalATenDispatch().getOpTable("aten::thnn_conv3d(Tensor self, Tensor weight, int[3] kernel_size, Tensor? bias=None, int[3] stride=1, int[3] padding=0, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, const Tensor &, IntArrayRef, const Tensor &, IntArrayRef, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, weight, kernel_size, bias, stride, padding);
}
static inline Tensor thnn_conv3d(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding) {
    static auto table = globalATenDispatch().getOpTable("aten::thnn_conv3d(Tensor self, Tensor weight, int[3] kernel_size, Tensor? bias=None, int[3] stride=1, int[3] padding=0) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, IntArrayRef, const Tensor &, IntArrayRef, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, weight, kernel_size, bias, stride, padding);
}
static inline std::tuple<Tensor &,Tensor &,Tensor &> thnn_conv3d_forward_out(Tensor & output, Tensor & finput, Tensor & fgrad_input, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding) {
    static auto table = globalATenDispatch().getOpTable("aten::thnn_conv3d_forward(Tensor self, Tensor weight, int[3] kernel_size, Tensor? bias, int[3] stride, int[3] padding, *, Tensor(a!) output, Tensor(b!) finput, Tensor(c!) fgrad_input) -> (Tensor(a!), Tensor(b!), Tensor(c!))");
    return table->getOp<std::tuple<Tensor &,Tensor &,Tensor &> (Tensor &, Tensor &, Tensor &, const Tensor &, const Tensor &, IntArrayRef, const Tensor &, IntArrayRef, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(output, finput, fgrad_input, self, weight, kernel_size, bias, stride, padding);
}
static inline std::tuple<Tensor,Tensor,Tensor> thnn_conv3d_forward(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding) {
    static auto table = globalATenDispatch().getOpTable("aten::thnn_conv3d_forward(Tensor self, Tensor weight, int[3] kernel_size, Tensor? bias, int[3] stride, int[3] padding) -> (Tensor output, Tensor finput, Tensor fgrad_input)");
    return table->getOp<std::tuple<Tensor,Tensor,Tensor> (const Tensor &, const Tensor &, IntArrayRef, const Tensor &, IntArrayRef, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, weight, kernel_size, bias, stride, padding);
}
static inline std::tuple<Tensor &,Tensor &,Tensor &> thnn_conv3d_backward_out(Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, const Tensor & finput, const Tensor & fgrad_input) {
    static auto table = globalATenDispatch().getOpTable("aten::thnn_conv3d_backward(Tensor grad_output, Tensor self, Tensor weight, int[3] kernel_size, int[3] stride, int[3] padding, Tensor finput, Tensor fgrad_input, *, Tensor?(a!) grad_input, Tensor?(b!) grad_weight, Tensor?(c!) grad_bias) -> (Tensor(a!), Tensor(b!), Tensor(c!))");
    return table->getOp<std::tuple<Tensor &,Tensor &,Tensor &> (Tensor &, Tensor &, Tensor &, const Tensor &, const Tensor &, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, const Tensor &, const Tensor &)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_input, grad_weight, grad_bias, grad_output, self, weight, kernel_size, stride, padding, finput, fgrad_input);
}
static inline std::tuple<Tensor,Tensor,Tensor> thnn_conv3d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, const Tensor & finput, const Tensor & fgrad_input, std::array<bool,3> output_mask) {
    static auto table = globalATenDispatch().getOpTable("aten::thnn_conv3d_backward(Tensor grad_output, Tensor self, Tensor weight, int[3] kernel_size, int[3] stride, int[3] padding, Tensor finput, Tensor fgrad_input, bool[3] output_mask) -> (Tensor grad_input, Tensor grad_weight, Tensor grad_bias)");
    return table->getOp<std::tuple<Tensor,Tensor,Tensor> (const Tensor &, const Tensor &, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, const Tensor &, const Tensor &, std::array<bool,3>)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_output, self, weight, kernel_size, stride, padding, finput, fgrad_input, output_mask);
}
static inline Tensor conv_dilated2d(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation) {
    static auto table = globalATenDispatch().getOpTable("aten::conv_dilated2d(Tensor self, Tensor weight, int[2] kernel_size, Tensor? bias=None, int[2] stride=1, int[2] padding=0, int[2] dilation=1) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, IntArrayRef, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, weight, kernel_size, bias, stride, padding, dilation);
}
static inline std::tuple<Tensor,Tensor,Tensor> conv_dilated2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, std::array<bool,3> output_mask) {
    static auto table = globalATenDispatch().getOpTable("aten::conv_dilated2d_backward(Tensor grad_output, Tensor self, Tensor weight, int[2] kernel_size, int[2] stride, int[2] padding, int[2] dilation, bool[3] output_mask) -> (Tensor grad_input, Tensor grad_weight, Tensor grad_bias)");
    return table->getOp<std::tuple<Tensor,Tensor,Tensor> (const Tensor &, const Tensor &, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, IntArrayRef, std::array<bool,3>)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_output, self, weight, kernel_size, stride, padding, dilation, output_mask);
}
static inline Tensor conv_dilated3d(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation) {
    static auto table = globalATenDispatch().getOpTable("aten::conv_dilated3d(Tensor self, Tensor weight, int[3] kernel_size, Tensor? bias=None, int[3] stride=1, int[3] padding=0, int[3] dilation=1) -> Tensor");
    return table->getOp<Tensor (const Tensor &, const Tensor &, IntArrayRef, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, weight, kernel_size, bias, stride, padding, dilation);
}
static inline std::tuple<Tensor,Tensor,Tensor> conv_dilated3d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, std::array<bool,3> output_mask) {
    static auto table = globalATenDispatch().getOpTable("aten::conv_dilated3d_backward(Tensor grad_output, Tensor self, Tensor weight, int[3] kernel_size, int[3] stride, int[3] padding, int[3] dilation, bool[3] output_mask) -> (Tensor grad_input, Tensor grad_weight, Tensor grad_bias)");
    return table->getOp<std::tuple<Tensor,Tensor,Tensor> (const Tensor &, const Tensor &, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, IntArrayRef, std::array<bool,3>)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(grad_output, self, weight, kernel_size, stride, padding, dilation, output_mask);
}
static inline Tensor & col2im_out(Tensor & out, const Tensor & self, IntArrayRef output_size, IntArrayRef kernel_size, IntArrayRef dilation, IntArrayRef padding, IntArrayRef stride) {
    static auto table = globalATenDispatch().getOpTable("aten::col2im(Tensor self, int[2] output_size, int[2] kernel_size, int[2] dilation, int[2] padding, int[2] stride, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, IntArrayRef, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, output_size, kernel_size, dilation, padding, stride);
}
static inline Tensor col2im(const Tensor & self, IntArrayRef output_size, IntArrayRef kernel_size, IntArrayRef dilation, IntArrayRef padding, IntArrayRef stride) {
    static auto table = globalATenDispatch().getOpTable("aten::col2im(Tensor self, int[2] output_size, int[2] kernel_size, int[2] dilation, int[2] padding, int[2] stride) -> Tensor");
    return table->getOp<Tensor (const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, IntArrayRef, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, output_size, kernel_size, dilation, padding, stride);
}
static inline Tensor & col2im_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef kernel_size, IntArrayRef dilation, IntArrayRef padding, IntArrayRef stride) {
    static auto table = globalATenDispatch().getOpTable("aten::col2im_backward(Tensor grad_output, int[2] kernel_size, int[2] dilation, int[2] padding, int[2] stride, *, Tensor(a!) grad_input) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, IntArrayRef)>(at::detail::infer_backend(grad_input), at::detail::infer_is_variable(grad_input))(grad_input, grad_output, kernel_size, dilation, padding, stride);
}
static inline Tensor col2im_backward(const Tensor & grad_output, IntArrayRef kernel_size, IntArrayRef dilation, IntArrayRef padding, IntArrayRef stride) {
    static auto table = globalATenDispatch().getOpTable("aten::col2im_backward(Tensor grad_output, int[2] kernel_size, int[2] dilation, int[2] padding, int[2] stride) -> Tensor");
    return table->getOp<Tensor (const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, IntArrayRef)>(at::detail::infer_backend(grad_output), at::detail::infer_is_variable(grad_output))(grad_output, kernel_size, dilation, padding, stride);
}
static inline Tensor & im2col_out(Tensor & out, const Tensor & self, IntArrayRef kernel_size, IntArrayRef dilation, IntArrayRef padding, IntArrayRef stride) {
    static auto table = globalATenDispatch().getOpTable("aten::im2col(Tensor self, int[2] kernel_size, int[2] dilation, int[2] padding, int[2] stride, *, Tensor(a!) out) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(out, self, kernel_size, dilation, padding, stride);
}
static inline Tensor im2col(const Tensor & self, IntArrayRef kernel_size, IntArrayRef dilation, IntArrayRef padding, IntArrayRef stride) {
    static auto table = globalATenDispatch().getOpTable("aten::im2col(Tensor self, int[2] kernel_size, int[2] dilation, int[2] padding, int[2] stride) -> Tensor");
    return table->getOp<Tensor (const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, IntArrayRef)>(at::detail::infer_backend(self), at::detail::infer_is_variable(self))(self, kernel_size, dilation, padding, stride);
}
static inline Tensor & im2col_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef input_size, IntArrayRef kernel_size, IntArrayRef dilation, IntArrayRef padding, IntArrayRef stride) {
    static auto table = globalATenDispatch().getOpTable("aten::im2col_backward(Tensor grad_output, int[2] input_size, int[2] kernel_size, int[2] dilation, int[2] padding, int[2] stride, *, Tensor(a!) grad_input) -> Tensor(a!)");
    return table->getOp<Tensor & (Tensor &, const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, IntArrayRef, IntArrayRef)>(at::detail::infer_backend(grad_input), at::detail::infer_is_variable(grad_input))(grad_input, grad_output, input_size, kernel_size, dilation, padding, stride);
}
static inline Tensor im2col_backward(const Tensor & grad_output, IntArrayRef input_size, IntArrayRef kernel_size, IntArrayRef dilation, IntArrayRef padding, IntArrayRef stride) {
    static auto table = globalATenDispatch().getOpTable("aten::im2col_backward(Tensor grad_output, int[2] input_size, int[2] kernel_size, int[2] dilation, int[2] padding, int[2] stride) -> Tensor");
    return table->getOp<Tensor (const Tensor &, IntArrayRef, IntArrayRef, IntArrayRef, IntArrayRef, IntArrayRef)>(at::detail::infer_backend(grad_output), at::detail::infer_is_variable(grad_output))(grad_output, input_size, kernel_size, dilation, padding, stride);
}

}
