#pragma once

// @generated by aten/src/ATen/gen.py

#include <ATen/Context.h>
#include <ATen/Utils.h>



namespace at {

struct MkldnnCPUType final {
  static Tensor add(const Tensor & self, const Tensor & other, Scalar alpha);
  static Tensor & add_(Tensor & self, const Tensor & other, Scalar alpha);
  static Tensor & add_out(Tensor & out, const Tensor & self, const Tensor & other, Scalar alpha);
  static Tensor empty(IntArrayRef size, const TensorOptions & options, c10::optional<MemoryFormat> memory_format);
  static Tensor mkldnn_linear(const Tensor & input, const Tensor & weight, const Tensor & bias);
  static Tensor mkldnn_max_pool2d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode);
  static Tensor mul(const Tensor & self, const Tensor & other);
  static Tensor & mul_(Tensor & self, const Tensor & other);
  static Tensor & mul_out(Tensor & out, const Tensor & self, const Tensor & other);
  static std::tuple<Tensor,Tensor,Tensor> native_batch_norm(const Tensor & input, const Tensor & weight, const Tensor & bias, const Tensor & running_mean, const Tensor & running_var, bool training, double momentum, double eps);
  static Tensor _mkldnn_reshape(const Tensor & self, IntArrayRef shape);
  static Tensor relu(const Tensor & self);
  static Tensor & relu_(Tensor & self);
  static Tensor sigmoid(const Tensor & self);
  static Tensor & sigmoid_(Tensor & self);
  static Tensor _softmax(const Tensor & self, int64_t dim, bool half_to_float);
  static Tensor _mkldnn_transpose(const Tensor & self, int64_t dim0, int64_t dim1);
  static Tensor & _mkldnn_transpose_(Tensor & self, int64_t dim0, int64_t dim1);
  static Tensor clone(const Tensor & self);
  static Tensor & zero_(Tensor & self);
  static Tensor to_dense(const Tensor & self);
  static Tensor mkldnn_reorder_conv2d_weight(const Tensor & self, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups);
  static Tensor view(const Tensor & self, IntArrayRef size);
  static Tensor & adaptive_avg_pool2d_out(Tensor & out, const Tensor & self, IntArrayRef output_size);
  static Tensor mkldnn_adaptive_avg_pool2d(const Tensor & self, IntArrayRef output_size);
  static Tensor & avg_pool2d_out(Tensor & out, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad, c10::optional<int64_t> divisor_override);
  static Tensor avg_pool2d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad, c10::optional<int64_t> divisor_override);
};

} // namespace at
