#pragma once

// @generated by aten/src/ATen/gen.py from TypeDefault.h

#include <c10/core/TensorOptions.h>
#include <c10/core/Scalar.h>
#include <c10/core/QScheme.h>
#include <c10/core/MemoryFormat.h>
#include <c10/util/ArrayRef.h>
#include <c10/util/intrusive_ptr.h>
#include <torch/csrc/WindowsTorchApiMacro.h>
#include <ATen/Dimname.h>

namespace c10 {
struct Storage;
}

namespace at {

class Tensor;
using TensorList = ArrayRef<Tensor>;

class Context;
struct Generator;

struct Quantizer;
// This is temporary typedef to enable Quantizer in aten native function API
// we'll remove them when we are actually exposing Quantizer class
// to frontend
using ConstQuantizerPtr = const c10::intrusive_ptr<Quantizer>&;

namespace TypeDefault {
  Tensor _cast_Byte(const Tensor & self, bool non_blocking);
  Tensor _cast_Char(const Tensor & self, bool non_blocking);
  Tensor _cast_Double(const Tensor & self, bool non_blocking);
  Tensor _cast_Float(const Tensor & self, bool non_blocking);
  Tensor _cast_Int(const Tensor & self, bool non_blocking);
  Tensor _cast_Long(const Tensor & self, bool non_blocking);
  Tensor _cast_Short(const Tensor & self, bool non_blocking);
  Tensor _cast_Half(const Tensor & self, bool non_blocking);
  void backward(const Tensor & self, const Tensor & gradient, bool keep_graph, bool create_graph);
  void set_data(const Tensor & self, const Tensor & new_data);
  Tensor data(const Tensor & self);
  bool is_leaf(const Tensor & self);
  int64_t output_nr(const Tensor & self);
  int64_t _version(const Tensor & self);
  Tensor & requires_grad_(Tensor & self, bool _requires_grad);
  void retain_grad(const Tensor & self);
  Tensor & rename_(Tensor & self, c10::optional<DimnameList> names);
  Tensor rename(const Tensor & self, c10::optional<DimnameList> names);
  Tensor align_to(const Tensor & self, DimnameList names);
  Tensor align_to_ellipsis_idx(const Tensor & self, DimnameList order, int64_t ellipsis_idx);
  Tensor align_as(const Tensor & self, const Tensor & other);
  std::vector<Tensor> align_tensors(TensorList tensors);
  Tensor refine_names(const Tensor & self, DimnameList names);
  Tensor unflatten_Dimname(const Tensor & self, Dimname dim, IntArrayRef sizes, DimnameList names);
  Tensor unflatten_int(const Tensor & self, int64_t dim, IntArrayRef sizes, DimnameList names);
  bool _use_cudnn_rnn_flatten_weight();
  int64_t _debug_has_internal_overlap(const Tensor & self);
  std::tuple<Tensor,Tensor> _sobol_engine_draw(const Tensor & quasi, int64_t n, const Tensor & sobolstate, int64_t dimension, int64_t num_generated, c10::optional<ScalarType> dtype);
  Tensor & _sobol_engine_ff_(Tensor & self, int64_t n, const Tensor & sobolstate, int64_t dimension, int64_t num_generated);
  Tensor & _sobol_engine_scramble_(Tensor & self, const Tensor & ltm, int64_t dimension);
  Tensor & _sobol_engine_initialize_state_(Tensor & self, int64_t dimension);
  Tensor _reshape_from_tensor(const Tensor & self, const Tensor & shape);
  Tensor _shape_as_tensor(const Tensor & self);
  Tensor dropout(const Tensor & input, double p, bool train);
  Tensor & dropout_(Tensor & self, double p, bool train);
  Tensor feature_dropout(const Tensor & input, double p, bool train);
  Tensor & feature_dropout_(Tensor & self, double p, bool train);
  Tensor alpha_dropout(const Tensor & input, double p, bool train);
  Tensor & alpha_dropout_(Tensor & self, double p, bool train);
  Tensor feature_alpha_dropout(const Tensor & input, double p, bool train);
  Tensor & feature_alpha_dropout_(Tensor & self, double p, bool train);
  Tensor abs(const Tensor & self);
  Tensor & abs_(Tensor & self);
  Tensor & abs_out_out(Tensor & out, const Tensor & self);
  Tensor angle(const Tensor & self);
  Tensor & angle_out_out(Tensor & out, const Tensor & self);
  Tensor real(const Tensor & self);
  Tensor imag(const Tensor & self);
  Tensor conj(const Tensor & self);
  Tensor & conj_out_out(Tensor & out, const Tensor & self);
  Tensor acos(const Tensor & self);
  Tensor & acos_(Tensor & self);
  Tensor & acos_out_out(Tensor & out, const Tensor & self);
  Tensor avg_pool1d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad);
  Tensor adaptive_avg_pool1d(const Tensor & self, IntArrayRef output_size);
  std::tuple<Tensor,Tensor> adaptive_max_pool1d(const Tensor & self, IntArrayRef output_size);
  Tensor add_Scalar(const Tensor & self, Scalar other, Scalar alpha);
  Tensor & add__Scalar(Tensor & self, Scalar other, Scalar alpha);
  Tensor addr(const Tensor & self, const Tensor & vec1, const Tensor & vec2, Scalar beta, Scalar alpha);
  Tensor & addr_(Tensor & self, const Tensor & vec1, const Tensor & vec2, Scalar beta, Scalar alpha);
  Tensor & addr_out_out(Tensor & out, const Tensor & self, const Tensor & vec1, const Tensor & vec2, Scalar beta, Scalar alpha);
  Tensor affine_grid_generator(const Tensor & theta, IntArrayRef size, bool align_corners);
  Tensor affine_grid_generator_backward(const Tensor & grad, IntArrayRef size, bool align_corners);
  Tensor all_dim(const Tensor & self, int64_t dim, bool keepdim);
  Tensor & all_out_out(Tensor & out, const Tensor & self, int64_t dim, bool keepdim);
  Tensor all_dimname(const Tensor & self, Dimname dim, bool keepdim);
  Tensor & all_out_dimname_out(Tensor & out, const Tensor & self, Dimname dim, bool keepdim);
  bool allclose(const Tensor & self, const Tensor & other, double rtol, double atol, bool equal_nan);
  Tensor any_dim(const Tensor & self, int64_t dim, bool keepdim);
  Tensor & any_out_out(Tensor & out, const Tensor & self, int64_t dim, bool keepdim);
  Tensor any_dimname(const Tensor & self, Dimname dim, bool keepdim);
  Tensor & any_out_dimname_out(Tensor & out, const Tensor & self, Dimname dim, bool keepdim);
  Tensor arange(Scalar end, const TensorOptions & options);
  Tensor arange_start(Scalar start, Scalar end, const TensorOptions & options);
  Tensor arange_start_step(Scalar start, Scalar end, Scalar step, const TensorOptions & options);
  Tensor & arange_out_out(Tensor & out, Scalar end);
  Tensor _dim_arange(const Tensor & like, int64_t dim);
  Tensor & as_strided_(Tensor & self, IntArrayRef size, IntArrayRef stride, c10::optional<int64_t> storage_offset);
  Tensor asin(const Tensor & self);
  Tensor & asin_(Tensor & self);
  Tensor & asin_out_out(Tensor & out, const Tensor & self);
  Tensor atan(const Tensor & self);
  Tensor & _baddbmm_mkl_(Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta, Scalar alpha);
  Tensor bartlett_window(int64_t window_length, const TensorOptions & options);
  Tensor bartlett_window_periodic(int64_t window_length, bool periodic, const TensorOptions & options);
  Tensor batch_norm(const Tensor & input, const Tensor & weight, const Tensor & bias, const Tensor & running_mean, const Tensor & running_var, bool training, double momentum, double eps, bool cudnn_enabled);
  std::tuple<Tensor,Tensor,Tensor,Tensor,int64_t> _batch_norm_impl_index(const Tensor & input, const Tensor & weight, const Tensor & bias, const Tensor & running_mean, const Tensor & running_var, bool training, double momentum, double eps, bool cudnn_enabled);
  std::tuple<Tensor,Tensor,Tensor> _batch_norm_impl_index_backward(int64_t impl_index, const Tensor & input, const Tensor & grad_output, const Tensor & weight, const Tensor & running_mean, const Tensor & running_var, const Tensor & save_mean, const Tensor & save_var_transform, bool train, double eps, std::array<bool,3> output_mask, const Tensor & reservedSpace);
  Tensor bernoulli(const Tensor & self, Generator * generator);
  Tensor & bernoulli_out_out(Tensor & out, const Tensor & self, Generator * generator);
  Tensor bernoulli_p(const Tensor & self, double p, Generator * generator);
  Tensor bilinear(const Tensor & input1, const Tensor & input2, const Tensor & weight, const Tensor & bias);
  Tensor binary_cross_entropy_with_logits(const Tensor & self, const Tensor & target, const Tensor & weight, const Tensor & pos_weight, int64_t reduction);
  Tensor binary_cross_entropy_with_logits_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight, const Tensor & pos_weight, int64_t reduction);
  Tensor bitwise_not(const Tensor & self);
  Tensor & bitwise_not_(Tensor & self);
  Tensor logical_not(const Tensor & self);
  Tensor & logical_not_(Tensor & self);
  Tensor logical_xor(const Tensor & self, const Tensor & other);
  Tensor & logical_xor_(Tensor & self, const Tensor & other);
  Tensor logical_and(const Tensor & self, const Tensor & other);
  Tensor & logical_and_(Tensor & self, const Tensor & other);
  Tensor logical_or(const Tensor & self, const Tensor & other);
  Tensor & logical_or_(Tensor & self, const Tensor & other);
  Tensor blackman_window(int64_t window_length, const TensorOptions & options);
  Tensor blackman_window_periodic(int64_t window_length, bool periodic, const TensorOptions & options);
  std::vector<Tensor> broadcast_tensors(TensorList tensors);
  Tensor cat(TensorList tensors, int64_t dim);
  Tensor & cat_out_out(Tensor & out, TensorList tensors, int64_t dim);
  Tensor cat_names(TensorList tensors, Dimname dim);
  Tensor & cat_out_names_out(Tensor & out, TensorList tensors, Dimname dim);
  Tensor ceil(const Tensor & self);
  Tensor & ceil_(Tensor & self);
  Tensor chain_matmul(TensorList matrices);
  std::vector<Tensor> chunk(const Tensor & self, int64_t chunks, int64_t dim);
  Tensor clamp_max(const Tensor & self, Scalar max);
  Tensor clamp_min(const Tensor & self, Scalar min);
  bool cudnn_is_acceptable(const Tensor & self);
  Tensor constant_pad_nd(const Tensor & self, IntArrayRef pad, Scalar value);
  Tensor contiguous(const Tensor & self, MemoryFormat memory_format);
  Tensor convolution(const Tensor & input, const Tensor & weight, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool transposed, IntArrayRef output_padding, int64_t groups);
  Tensor convolution_overrideable(const Tensor & input, const Tensor & weight, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool transposed, IntArrayRef output_padding, int64_t groups);
  std::tuple<Tensor,Tensor,Tensor> convolution_backward_overrideable(const Tensor & grad_output, const Tensor & input, const Tensor & weight, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool transposed, IntArrayRef output_padding, int64_t groups, std::array<bool,3> output_mask);
  Tensor _convolution(const Tensor & input, const Tensor & weight, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool transposed, IntArrayRef output_padding, int64_t groups, bool benchmark, bool deterministic, bool cudnn_enabled);
  Tensor _convolution_nogroup(const Tensor & input, const Tensor & weight, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool transposed, IntArrayRef output_padding);
  std::tuple<Tensor,Tensor,Tensor> _convolution_double_backward(const Tensor & ggI, const Tensor & ggW, const Tensor & ggb, const Tensor & gO, const Tensor & weight, const Tensor & self, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool transposed, IntArrayRef output_padding, int64_t groups, bool benchmark, bool deterministic, bool cudnn_enabled, std::array<bool,3> output_mask);
  Tensor conv1d(const Tensor & input, const Tensor & weight, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, int64_t groups);
  Tensor conv2d(const Tensor & input, const Tensor & weight, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, int64_t groups);
  Tensor conv3d(const Tensor & input, const Tensor & weight, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, int64_t groups);
  Tensor conv_tbc(const Tensor & self, const Tensor & weight, const Tensor & bias, int64_t pad);
  std::tuple<Tensor,Tensor,Tensor> conv_tbc_backward(const Tensor & self, const Tensor & input, const Tensor & weight, const Tensor & bias, int64_t pad);
  Tensor conv_transpose1d(const Tensor & input, const Tensor & weight, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, int64_t groups, IntArrayRef dilation);
  Tensor conv_transpose2d_input(const Tensor & input, const Tensor & weight, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, int64_t groups, IntArrayRef dilation);
  Tensor conv_transpose3d_input(const Tensor & input, const Tensor & weight, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, int64_t groups, IntArrayRef dilation);
  Tensor & copy_(Tensor & self, const Tensor & src, bool non_blocking);
  Tensor cos(const Tensor & self);
  Tensor cosh(const Tensor & self);
  Tensor cosine_embedding_loss(const Tensor & input1, const Tensor & input2, const Tensor & target, double margin, int64_t reduction);
  std::tuple<Tensor,Tensor> cummax(const Tensor & self, int64_t dim);
  std::tuple<Tensor &,Tensor &> cummax_out_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t dim);
  std::tuple<Tensor,Tensor> cummax_dimname(const Tensor & self, Dimname dim);
  std::tuple<Tensor &,Tensor &> cummax_out_dimname_out(Tensor & values, Tensor & indices, const Tensor & self, Dimname dim);
  std::tuple<Tensor,Tensor> cummin(const Tensor & self, int64_t dim);
  std::tuple<Tensor &,Tensor &> cummin_out_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t dim);
  std::tuple<Tensor,Tensor> cummin_dimname(const Tensor & self, Dimname dim);
  std::tuple<Tensor &,Tensor &> cummin_out_dimname_out(Tensor & values, Tensor & indices, const Tensor & self, Dimname dim);
  Tensor cumprod(const Tensor & self, int64_t dim, c10::optional<ScalarType> dtype);
  Tensor & cumprod_out_out(Tensor & out, const Tensor & self, int64_t dim, c10::optional<ScalarType> dtype);
  Tensor cumprod_dimname(const Tensor & self, Dimname dim, c10::optional<ScalarType> dtype);
  Tensor & cumprod_out_dimname_out(Tensor & out, const Tensor & self, Dimname dim, c10::optional<ScalarType> dtype);
  Tensor cumsum(const Tensor & self, int64_t dim, c10::optional<ScalarType> dtype);
  Tensor & cumsum_out_out(Tensor & out, const Tensor & self, int64_t dim, c10::optional<ScalarType> dtype);
  Tensor cumsum_dimname(const Tensor & self, Dimname dim, c10::optional<ScalarType> dtype);
  Tensor & cumsum_out_dimname_out(Tensor & out, const Tensor & self, Dimname dim, c10::optional<ScalarType> dtype);
  Tensor ctc_loss_IntList(const Tensor & log_probs, const Tensor & targets, IntArrayRef input_lengths, IntArrayRef target_lengths, int64_t blank, int64_t reduction, bool zero_infinity);
  Tensor ctc_loss_Tensor(const Tensor & log_probs, const Tensor & targets, const Tensor & input_lengths, const Tensor & target_lengths, int64_t blank, int64_t reduction, bool zero_infinity);
  Tensor det(const Tensor & self);
  Tensor diag_embed(const Tensor & self, int64_t offset, int64_t dim1, int64_t dim2);
  Tensor diagflat(const Tensor & self, int64_t offset);
  Tensor diagonal(const Tensor & self, int64_t offset, int64_t dim1, int64_t dim2);
  Tensor diagonal_Dimname(const Tensor & self, Dimname outdim, Dimname dim1, Dimname dim2, int64_t offset);
  Tensor & fill_diagonal_(Tensor & self, Scalar fill_value, bool wrap);
  Tensor div_Scalar(const Tensor & self, Scalar other);
  Tensor & div__Scalar(Tensor & self, Scalar other);
  Tensor & dot_out_out(Tensor & out, const Tensor & self, const Tensor & tensor);
  Tensor einsum(std::string equation, TensorList tensors);
  Tensor embedding(const Tensor & weight, const Tensor & indices, int64_t padding_idx, bool scale_grad_by_freq, bool sparse);
  Tensor embedding_backward(const Tensor & grad, const Tensor & indices, int64_t num_weights, int64_t padding_idx, bool scale_grad_by_freq, bool sparse);
  Tensor embedding_sparse_backward(const Tensor & grad, const Tensor & indices, int64_t num_weights, int64_t padding_idx, bool scale_grad_by_freq);
  std::tuple<Tensor,Tensor,Tensor,Tensor> embedding_bag(const Tensor & weight, const Tensor & indices, const Tensor & offsets, bool scale_grad_by_freq, int64_t mode, bool sparse, const Tensor & per_sample_weights, bool include_last_offset);
  Tensor _embedding_bag_backward(const Tensor & grad, const Tensor & indices, const Tensor & offsets, const Tensor & offset2bag, const Tensor & bag_size, const Tensor & maximum_indices, int64_t num_weights, bool scale_grad_by_freq, int64_t mode, bool sparse, const Tensor & per_sample_weights);
  Tensor _embedding_bag_sparse_backward(const Tensor & grad, const Tensor & indices, const Tensor & offsets, const Tensor & offset2bag, const Tensor & bag_size, int64_t num_weights, bool scale_grad_by_freq, int64_t mode, const Tensor & per_sample_weights);
  Tensor empty_names(IntArrayRef size, c10::optional<DimnameList> names, const TensorOptions & options, c10::optional<MemoryFormat> memory_format);
  Tensor new_empty(const Tensor & self, IntArrayRef size, const TensorOptions & options);
  Tensor new_full(const Tensor & self, IntArrayRef size, Scalar fill_value, const TensorOptions & options);
  Tensor new_zeros(const Tensor & self, IntArrayRef size, const TensorOptions & options);
  Tensor & resize_(Tensor & self, IntArrayRef size, c10::optional<MemoryFormat> memory_format);
  Tensor & empty_out_out(Tensor & out, IntArrayRef size, c10::optional<MemoryFormat> memory_format);
  Tensor empty_like(const Tensor & self, const TensorOptions & options, c10::optional<MemoryFormat> memory_format);
  Tensor erf(const Tensor & self);
  Tensor erfc(const Tensor & self);
  Tensor exp(const Tensor & self);
  Tensor expm1(const Tensor & self);
  Tensor & expm1_(Tensor & self);
  Tensor expand(const Tensor & self, IntArrayRef size, bool implicit);
  Tensor expand_as(const Tensor & self, const Tensor & other);
  Tensor eye(int64_t n, const TensorOptions & options);
  Tensor eye_m(int64_t n, int64_t m, const TensorOptions & options);
  Tensor flatten_using_ints(const Tensor & self, int64_t start_dim, int64_t end_dim);
  Tensor flatten_named_out_dim(const Tensor & self, int64_t start_dim, int64_t end_dim, Dimname out_dim);
  Tensor flatten_using_names(const Tensor & self, Dimname start_dim, Dimname end_dim, Dimname out_dim);
  Tensor flatten_DimnameList(const Tensor & self, DimnameList dims, Dimname out_dim);
  Tensor & fill__Scalar(Tensor & self, Scalar value);
  Tensor & fill__Tensor(Tensor & self, const Tensor & value);
  Tensor floor(const Tensor & self);
  Tensor & floor_(Tensor & self);
  Tensor floor_divide_Scalar(const Tensor & self, Scalar other);
  Tensor & floor_divide__Scalar(Tensor & self, Scalar other);
  Tensor frac(const Tensor & self);
  Tensor & frac_(Tensor & self);
  Tensor & frac_out_out(Tensor & out, const Tensor & self);
  Tensor full_names(IntArrayRef size, Scalar fill_value, c10::optional<DimnameList> names, const TensorOptions & options);
  Tensor full(IntArrayRef size, Scalar fill_value, const TensorOptions & options);
  Tensor & full_out_out(Tensor & out, IntArrayRef size, Scalar fill_value);
  Tensor full_like(const Tensor & self, Scalar fill_value, const TensorOptions & options, c10::optional<MemoryFormat> memory_format);
  Tensor grid_sampler(const Tensor & input, const Tensor & grid, int64_t interpolation_mode, int64_t padding_mode, bool align_corners);
  Tensor hann_window(int64_t window_length, const TensorOptions & options);
  Tensor hann_window_periodic(int64_t window_length, bool periodic, const TensorOptions & options);
  Tensor hamming_window(int64_t window_length, const TensorOptions & options);
  Tensor hamming_window_periodic(int64_t window_length, bool periodic, const TensorOptions & options);
  Tensor hamming_window_periodic_alpha(int64_t window_length, bool periodic, double alpha, const TensorOptions & options);
  Tensor hamming_window_periodic_alpha_beta(int64_t window_length, bool periodic, double alpha, double beta, const TensorOptions & options);
  Tensor hinge_embedding_loss(const Tensor & self, const Tensor & target, double margin, int64_t reduction);
  Tensor ger(const Tensor & self, const Tensor & vec2);
  Tensor & ger_out_out(Tensor & out, const Tensor & self, const Tensor & vec2);
  Tensor group_norm(const Tensor & input, int64_t num_groups, const Tensor & weight, const Tensor & bias, double eps, bool cudnn_enabled);
  Tensor fft(const Tensor & self, int64_t signal_ndim, bool normalized);
  Tensor ifft(const Tensor & self, int64_t signal_ndim, bool normalized);
  Tensor rfft(const Tensor & self, int64_t signal_ndim, bool normalized, bool onesided);
  Tensor irfft(const Tensor & self, int64_t signal_ndim, bool normalized, bool onesided, IntArrayRef signal_sizes);
  int64_t _cufft_get_plan_cache_size(int64_t device_index);
  int64_t _cufft_get_plan_cache_max_size(int64_t device_index);
  void _cufft_set_plan_cache_max_size(int64_t device_index, int64_t max_size);
  void _cufft_clear_plan_cache(int64_t device_index);
  Tensor index_Tensor(const Tensor & self, TensorList indices);
  Tensor & index_copy_(Tensor & self, int64_t dim, const Tensor & index, const Tensor & source);
  Tensor index_copy(const Tensor & self, int64_t dim, const Tensor & index, const Tensor & source);
  Tensor & index_copy__dimname(Tensor & self, Dimname dim, const Tensor & index, const Tensor & source);
  Tensor index_copy_dimname(const Tensor & self, Dimname dim, const Tensor & index, const Tensor & source);
  Tensor & index_put_(Tensor & self, TensorList indices, const Tensor & values, bool accumulate);
  Tensor index_put(const Tensor & self, TensorList indices, const Tensor & values, bool accumulate);
  Tensor & _index_put_impl_(Tensor & self, TensorList indices, const Tensor & values, bool accumulate, bool unsafe);
  Tensor instance_norm(const Tensor & input, const Tensor & weight, const Tensor & bias, const Tensor & running_mean, const Tensor & running_var, bool use_input_stats, double momentum, double eps, bool cudnn_enabled);
  Tensor inverse(const Tensor & self);
  Tensor & inverse_out_out(Tensor & out, const Tensor & self);
  Tensor isclose(const Tensor & self, const Tensor & other, double rtol, double atol, bool equal_nan);
  bool is_distributed(const Tensor & self);
  bool is_floating_point(const Tensor & self);
  bool is_complex(const Tensor & self);
  bool is_nonzero(const Tensor & self);
  bool is_same_size(const Tensor & self, const Tensor & other);
  bool is_signed(const Tensor & self);
  Tensor kl_div(const Tensor & self, const Tensor & target, int64_t reduction);
  std::tuple<Tensor,Tensor> kthvalue(const Tensor & self, int64_t k, int64_t dim, bool keepdim);
  std::tuple<Tensor,Tensor> kthvalue_dimname(const Tensor & self, int64_t k, Dimname dim, bool keepdim);
  std::tuple<Tensor &,Tensor &> kthvalue_out_dimname_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t k, Dimname dim, bool keepdim);
  Tensor layer_norm(const Tensor & input, IntArrayRef normalized_shape, const Tensor & weight, const Tensor & bias, double eps, bool cudnn_enable);
  Tensor linear(const Tensor & input, const Tensor & weight, const Tensor & bias);
  Tensor fbgemm_linear_int8_weight_fp32_activation(const Tensor & input, const Tensor & weight, const Tensor & packed, const Tensor & col_offsets, Scalar weight_scale, Scalar weight_zero_point, const Tensor & bias);
  Tensor fbgemm_linear_int8_weight(const Tensor & input, const Tensor & weight, const Tensor & packed, const Tensor & col_offsets, Scalar weight_scale, Scalar weight_zero_point, const Tensor & bias);
  std::tuple<Tensor,Tensor,double,int64_t> fbgemm_linear_quantize_weight(const Tensor & input);
  Tensor fbgemm_pack_gemm_matrix_fp16(const Tensor & input);
  Tensor fbgemm_linear_fp16_weight_fp32_activation(const Tensor & input, const Tensor & packed_weight, const Tensor & bias);
  Tensor fbgemm_linear_fp16_weight(const Tensor & input, const Tensor & packed_weight, const Tensor & bias);
  Tensor fbgemm_pack_quantized_matrix(const Tensor & input);
  Tensor fbgemm_pack_quantized_matrix_KN(const Tensor & input, int64_t K, int64_t N);
  Tensor linspace(Scalar start, Scalar end, int64_t steps, const TensorOptions & options);
  Tensor log(const Tensor & self);
  Tensor & log_(Tensor & self);
  Tensor log10(const Tensor & self);
  Tensor & log10_(Tensor & self);
  Tensor log1p(const Tensor & self);
  Tensor log2(const Tensor & self);
  Tensor & log2_(Tensor & self);
  Tensor logdet(const Tensor & self);
  Tensor logspace(Scalar start, Scalar end, int64_t steps, double base, const TensorOptions & options);
  Tensor log_softmax_int(const Tensor & self, int64_t dim, c10::optional<ScalarType> dtype);
  Tensor log_softmax_Dimname(const Tensor & self, Dimname dim, c10::optional<ScalarType> dtype);
  Tensor logsumexp(const Tensor & self, IntArrayRef dim, bool keepdim);
  Tensor & logsumexp_out_out(Tensor & out, const Tensor & self, IntArrayRef dim, bool keepdim);
  Tensor logsumexp_names(const Tensor & self, DimnameList dim, bool keepdim);
  Tensor & logsumexp_out_names_out(Tensor & out, const Tensor & self, DimnameList dim, bool keepdim);
  Tensor margin_ranking_loss(const Tensor & input1, const Tensor & input2, const Tensor & target, double margin, int64_t reduction);
  Tensor matmul(const Tensor & self, const Tensor & other);
  Tensor & matmul_out_out(Tensor & out, const Tensor & self, const Tensor & other);
  Tensor matrix_rank_tol(const Tensor & self, double tol, bool symmetric);
  Tensor matrix_rank(const Tensor & self, bool symmetric);
  Tensor matrix_power(const Tensor & self, int64_t n);
  std::tuple<Tensor,Tensor> max_dim(const Tensor & self, int64_t dim, bool keepdim);
  std::tuple<Tensor &,Tensor &> max_out_dim_max(Tensor & max, Tensor & max_values, const Tensor & self, int64_t dim, bool keepdim);
  Tensor max_values(const Tensor & self, IntArrayRef dim, bool keepdim);
  std::tuple<Tensor,Tensor> max_names_dim(const Tensor & self, Dimname dim, bool keepdim);
  std::tuple<Tensor &,Tensor &> max_out_names_dim_max(Tensor & max, Tensor & max_values, const Tensor & self, Dimname dim, bool keepdim);
  Tensor max_values_names(const Tensor & self, DimnameList dim, bool keepdim);
  std::tuple<Tensor,Tensor> max_pool1d_with_indices(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode);
  Tensor max_pool1d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode);
  Tensor max_pool2d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode);
  Tensor max_pool3d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode);
  Tensor mean_names_dim(const Tensor & self, DimnameList dim, bool keepdim, c10::optional<ScalarType> dtype);
  Tensor & mean_out_names_out(Tensor & out, const Tensor & self, DimnameList dim, bool keepdim, c10::optional<ScalarType> dtype);
  std::tuple<Tensor,Tensor> median_dim(const Tensor & self, int64_t dim, bool keepdim);
  std::tuple<Tensor &,Tensor &> median_out_dim_values(Tensor & values, Tensor & indices, const Tensor & self, int64_t dim, bool keepdim);
  std::tuple<Tensor,Tensor> median_names_dim(const Tensor & self, Dimname dim, bool keepdim);
  std::tuple<Tensor &,Tensor &> median_out_names_dim_values(Tensor & values, Tensor & indices, const Tensor & self, Dimname dim, bool keepdim);
  std::tuple<Tensor,Tensor> min_dim(const Tensor & self, int64_t dim, bool keepdim);
  std::tuple<Tensor &,Tensor &> min_out_dim_min(Tensor & min, Tensor & min_indices, const Tensor & self, int64_t dim, bool keepdim);
  Tensor min_values(const Tensor & self, IntArrayRef dim, bool keepdim);
  std::tuple<Tensor,Tensor> min_names_dim(const Tensor & self, Dimname dim, bool keepdim);
  std::tuple<Tensor &,Tensor &> min_out_names_dim_min(Tensor & min, Tensor & min_indices, const Tensor & self, Dimname dim, bool keepdim);
  Tensor min_values_names(const Tensor & self, DimnameList dim, bool keepdim);
  Tensor mkldnn_convolution(const Tensor & self, const Tensor & weight, const Tensor & bias, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups);
  Tensor mkldnn_convolution_backward_input(IntArrayRef self_size, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool bias_defined);
  std::tuple<Tensor,Tensor> mkldnn_convolution_backward_weights(IntArrayRef weight_size, const Tensor & grad_output, const Tensor & self, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool bias_defined);
  std::tuple<Tensor,Tensor,Tensor> mkldnn_convolution_backward(const Tensor & self, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, std::array<bool,3> output_mask);
  Tensor _sparse_mm(const Tensor & sparse, const Tensor & dense);
  std::tuple<Tensor,Tensor> mode(const Tensor & self, int64_t dim, bool keepdim);
  std::tuple<Tensor &,Tensor &> mode_out_values(Tensor & values, Tensor & indices, const Tensor & self, int64_t dim, bool keepdim);
  std::tuple<Tensor,Tensor> mode_dimname(const Tensor & self, Dimname dim, bool keepdim);
  std::tuple<Tensor &,Tensor &> mode_out_dimname_out(Tensor & values, Tensor & indices, const Tensor & self, Dimname dim, bool keepdim);
  Tensor mul_Scalar(const Tensor & self, Scalar other);
  Tensor & mul__Scalar(Tensor & self, Scalar other);
  Tensor mvlgamma(const Tensor & self, int64_t p);
  Tensor & mvlgamma_(Tensor & self, int64_t p);
  Tensor narrow(const Tensor & self, int64_t dim, int64_t start, int64_t length);
  Tensor narrow_Tensor(const Tensor & self, int64_t dim, const Tensor & start, int64_t length);
  bool _nnpack_available();
  Tensor _nnpack_spatial_convolution(const Tensor & input, const Tensor & weight, const Tensor & bias, IntArrayRef padding, IntArrayRef stride);
  std::tuple<Tensor,Tensor,Tensor> _nnpack_spatial_convolution_backward(const Tensor & input, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, std::array<bool,3> output_mask);
  Tensor _nnpack_spatial_convolution_backward_input(const Tensor & input, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding);
  Tensor _nnpack_spatial_convolution_backward_weight(const Tensor & input, IntArrayRef weightsize, const Tensor & grad_output, IntArrayRef padding);
  Tensor ones_names(IntArrayRef size, c10::optional<DimnameList> names, const TensorOptions & options);
  Tensor ones(IntArrayRef size, const TensorOptions & options);
  Tensor & ones_out_out(Tensor & out, IntArrayRef size);
  Tensor ones_like(const Tensor & self, const TensorOptions & options, c10::optional<MemoryFormat> memory_format);
  Tensor pairwise_distance(const Tensor & x1, const Tensor & x2, double p, double eps, bool keepdim);
  Tensor cdist(const Tensor & x1, const Tensor & x2, double p, c10::optional<int64_t> compute_mode);
  Tensor _cdist_forward(const Tensor & x1, const Tensor & x2, double p, c10::optional<int64_t> compute_mode);
  Tensor _cdist_backward(const Tensor & grad, const Tensor & x1, const Tensor & x2, double p, const Tensor & cdist);
  Tensor pdist(const Tensor & self, double p);
  Tensor _pdist_forward(const Tensor & self, double p);
  Tensor _pdist_backward(const Tensor & grad, const Tensor & self, double p, const Tensor & pdist);
  Tensor cosine_similarity(const Tensor & x1, const Tensor & x2, int64_t dim, double eps);
  Tensor permute(const Tensor & self, IntArrayRef dims);
  Tensor numpy_T(const Tensor & self);
  Tensor pixel_shuffle(const Tensor & self, int64_t upscale_factor);
  bool is_pinned(const Tensor & self);
  Tensor pin_memory(const Tensor & self);
  Tensor pinverse(const Tensor & self, double rcond);
  Tensor poisson_nll_loss(const Tensor & input, const Tensor & target, bool log_input, bool full, double eps, int64_t reduction);
  Tensor scalar_tensor(Scalar s, const TensorOptions & options);
  Tensor rand_names(IntArrayRef size, c10::optional<DimnameList> names, const TensorOptions & options);
  Tensor rand_generator_with_names(IntArrayRef size, Generator * generator, c10::optional<DimnameList> names, const TensorOptions & options);
  Tensor rand(IntArrayRef size, const TensorOptions & options);
  Tensor rand_generator(IntArrayRef size, Generator * generator, const TensorOptions & options);
  Tensor & rand_out_out(Tensor & out, IntArrayRef size);
  Tensor & rand_out_generator_out(Tensor & out, IntArrayRef size, Generator * generator);
  Tensor rand_like(const Tensor & self, const TensorOptions & options, c10::optional<MemoryFormat> memory_format);
  Tensor randint(int64_t high, IntArrayRef size, const TensorOptions & options);
  Tensor randint_generator(int64_t high, IntArrayRef size, Generator * generator, const TensorOptions & options);
  Tensor randint_low(int64_t low, int64_t high, IntArrayRef size, const TensorOptions & options);
  Tensor randint_low_generator(int64_t low, int64_t high, IntArrayRef size, Generator * generator, const TensorOptions & options);
  Tensor & randint_out_out(Tensor & out, int64_t high, IntArrayRef size);
  Tensor & randint_out_generator_out(Tensor & out, int64_t high, IntArrayRef size, Generator * generator);
  Tensor & randint_out_low_out(Tensor & out, int64_t low, int64_t high, IntArrayRef size);
  Tensor & randint_out_low_generator_out(Tensor & out, int64_t low, int64_t high, IntArrayRef size, Generator * generator);
  Tensor randint_like(const Tensor & self, int64_t high, const TensorOptions & options, c10::optional<MemoryFormat> memory_format);
  Tensor randint_like_low_dtype(const Tensor & self, int64_t low, int64_t high, const TensorOptions & options, c10::optional<MemoryFormat> memory_format);
  Tensor randn(IntArrayRef size, const TensorOptions & options);
  Tensor randn_generator(IntArrayRef size, Generator * generator, const TensorOptions & options);
  Tensor randn_names(IntArrayRef size, c10::optional<DimnameList> names, const TensorOptions & options);
  Tensor randn_generator_with_names(IntArrayRef size, Generator * generator, c10::optional<DimnameList> names, const TensorOptions & options);
  Tensor & randn_out_out(Tensor & out, IntArrayRef size);
  Tensor & randn_out_generator_out(Tensor & out, IntArrayRef size, Generator * generator);
  Tensor randn_like(const Tensor & self, const TensorOptions & options, c10::optional<MemoryFormat> memory_format);
  Tensor randperm(int64_t n, const TensorOptions & options);
  Tensor randperm_generator(int64_t n, Generator * generator, const TensorOptions & options);
  Tensor & randperm_out_out(Tensor & out, int64_t n);
  Tensor range_step(Scalar start, Scalar end, Scalar step, const TensorOptions & options);
  Tensor range(Scalar start, Scalar end, const TensorOptions & options);
  Tensor reciprocal(const Tensor & self);
  Tensor & reciprocal_(Tensor & self);
  Tensor & reciprocal_out_out(Tensor & out, const Tensor & self);
  Tensor neg(const Tensor & self);
  Tensor & neg_(Tensor & self);
  Tensor repeat(const Tensor & self, IntArrayRef repeats);
  Tensor repeat_interleave_self_Tensor(const Tensor & self, const Tensor & repeats, c10::optional<int64_t> dim);
  Tensor repeat_interleave_self_int(const Tensor & self, int64_t repeats, c10::optional<int64_t> dim);
  Tensor reshape(const Tensor & self, IntArrayRef shape);
  Tensor reshape_as(const Tensor & self, const Tensor & other);
  Tensor round(const Tensor & self);
  Tensor & round_(Tensor & self);
  Tensor rrelu(const Tensor & self, Scalar lower, Scalar upper, bool training, Generator * generator);
  Tensor & rrelu_(Tensor & self, Scalar lower, Scalar upper, bool training, Generator * generator);
  Tensor hardshrink(const Tensor & self, Scalar lambd);
  Tensor hardshrink_backward(const Tensor & grad_out, const Tensor & self, Scalar lambd);
  Tensor rsqrt(const Tensor & self);
  Tensor & rsqrt_(Tensor & self);
  Tensor select_Dimname(const Tensor & self, Dimname dim, int64_t index);
  Tensor select_int(const Tensor & self, int64_t dim, int64_t index);
  Tensor selu(const Tensor & self);
  Tensor & selu_(Tensor & self);
  Tensor celu(const Tensor & self, Scalar alpha);
  Tensor & celu_(Tensor & self, Scalar alpha);
  Tensor & sigmoid_out_out(Tensor & out, const Tensor & self);
  Tensor sin(const Tensor & self);
  Tensor & sin_(Tensor & self);
  Tensor sinh(const Tensor & self);
  Tensor & sinh_(Tensor & self);
  Tensor & sinh_out_out(Tensor & out, const Tensor & self);
  Tensor detach(const Tensor & self);
  Tensor & detach_(Tensor & self);
  int64_t size_int(const Tensor & self, int64_t dim);
  int64_t size_Dimname(const Tensor & self, Dimname dim);
  Tensor slice_Tensor(const Tensor & self, int64_t dim, int64_t start, int64_t end, int64_t step);
  std::tuple<Tensor,Tensor> slogdet(const Tensor & self);
  Tensor smm(const Tensor & self, const Tensor & mat2);
  Tensor softmax_int(const Tensor & self, int64_t dim, c10::optional<ScalarType> dtype);
  Tensor softmax_Dimname(const Tensor & self, Dimname dim, c10::optional<ScalarType> dtype);
  std::vector<Tensor> split_Tensor(const Tensor & self, int64_t split_size, int64_t dim);
  std::vector<Tensor> split_with_sizes(const Tensor & self, IntArrayRef split_sizes, int64_t dim);
  Tensor squeeze(const Tensor & self);
  Tensor squeeze_dim(const Tensor & self, int64_t dim);
  Tensor squeeze_dimname(const Tensor & self, Dimname dim);
  Tensor & squeeze_(Tensor & self);
  Tensor & squeeze__dim(Tensor & self, int64_t dim);
  Tensor & squeeze__dimname(Tensor & self, Dimname dim);
  Tensor sspaddmm(const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta, Scalar alpha);
  Tensor stack(TensorList tensors, int64_t dim);
  Tensor & stack_out_out(Tensor & out, TensorList tensors, int64_t dim);
  Tensor stft(const Tensor & self, int64_t n_fft, c10::optional<int64_t> hop_length, c10::optional<int64_t> win_length, const Tensor & window, bool normalized, bool onesided);
  int64_t stride_int(const Tensor & self, int64_t dim);
  int64_t stride_Dimname(const Tensor & self, Dimname dim);
  Tensor sum(const Tensor & self, c10::optional<ScalarType> dtype);
  Tensor sum_dim_IntList(const Tensor & self, IntArrayRef dim, bool keepdim, c10::optional<ScalarType> dtype);
  Tensor sum_dim_DimnameList(const Tensor & self, DimnameList dim, bool keepdim, c10::optional<ScalarType> dtype);
  Tensor & sum_out_IntList_out(Tensor & out, const Tensor & self, IntArrayRef dim, bool keepdim, c10::optional<ScalarType> dtype);
  Tensor & sum_out_DimnameList_out(Tensor & out, const Tensor & self, DimnameList dim, bool keepdim, c10::optional<ScalarType> dtype);
  Tensor sum_to_size(const Tensor & self, IntArrayRef size);
  Tensor sqrt(const Tensor & self);
  Tensor & sqrt_(Tensor & self);
  Tensor & sqrt_out_out(Tensor & out, const Tensor & self);
  Tensor square(const Tensor & self);
  Tensor & square_(Tensor & self);
  Tensor std(const Tensor & self, bool unbiased);
  Tensor std_dim(const Tensor & self, IntArrayRef dim, bool unbiased, bool keepdim);
  std::tuple<Tensor,Tensor> std_mean(const Tensor & self, bool unbiased);
  std::tuple<Tensor,Tensor> std_mean_dim(const Tensor & self, IntArrayRef dim, bool unbiased, bool keepdim);
  std::tuple<Tensor,Tensor> std_mean_names_dim(const Tensor & self, DimnameList dim, bool unbiased, bool keepdim);
  Tensor & std_out_out(Tensor & out, const Tensor & self, IntArrayRef dim, bool unbiased, bool keepdim);
  Tensor std_names_dim(const Tensor & self, DimnameList dim, bool unbiased, bool keepdim);
  Tensor & std_out_names_out(Tensor & out, const Tensor & self, DimnameList dim, bool unbiased, bool keepdim);
  Tensor prod(const Tensor & self, c10::optional<ScalarType> dtype);
  Tensor prod_dim_int(const Tensor & self, int64_t dim, bool keepdim, c10::optional<ScalarType> dtype);
  Tensor & prod_out_int_out(Tensor & out, const Tensor & self, int64_t dim, bool keepdim, c10::optional<ScalarType> dtype);
  Tensor prod_dim_Dimname(const Tensor & self, Dimname dim, bool keepdim, c10::optional<ScalarType> dtype);
  Tensor & prod_out_Dimname_out(Tensor & out, const Tensor & self, Dimname dim, bool keepdim, c10::optional<ScalarType> dtype);
  Tensor t(const Tensor & self);
  Tensor & t_(Tensor & self);
  Tensor tan(const Tensor & self);
  Tensor tensordot(const Tensor & self, const Tensor & other, IntArrayRef dims_self, IntArrayRef dims_other);
  Tensor transpose_int(const Tensor & self, int64_t dim0, int64_t dim1);
  Tensor transpose_Dimname(const Tensor & self, Dimname dim0, Dimname dim1);
  Tensor & transpose_(Tensor & self, int64_t dim0, int64_t dim1);
  Tensor one_hot(const Tensor & self, int64_t num_classes);
  Tensor rot90(const Tensor & self, int64_t k, IntArrayRef dims);
  Tensor trapz_x(const Tensor & y, const Tensor & x, int64_t dim);
  Tensor trapz_dx(const Tensor & y, double dx, int64_t dim);
  Tensor _trilinear(const Tensor & i1, const Tensor & i2, const Tensor & i3, IntArrayRef expand1, IntArrayRef expand2, IntArrayRef expand3, IntArrayRef sumdim, int64_t unroll_dim);
  Tensor triplet_margin_loss(const Tensor & anchor, const Tensor & positive, const Tensor & negative, double margin, double p, double eps, bool swap, int64_t reduction);
  Tensor true_divide_Scalar(const Tensor & self, Scalar other);
  Tensor & true_divide__Scalar(Tensor & self, Scalar other);
  Tensor trunc(const Tensor & self);
  Tensor & trunc_(Tensor & self);
  Tensor type_as(const Tensor & self, const Tensor & other);
  bool _has_compatible_shallow_copy_type(const Tensor & self, const Tensor & from);
  Tensor _unsafe_view(const Tensor & self, IntArrayRef size);
  Tensor unsqueeze(const Tensor & self, int64_t dim);
  Tensor & unsqueeze_(Tensor & self, int64_t dim);
  Tensor var(const Tensor & self, bool unbiased);
  Tensor var_dim(const Tensor & self, IntArrayRef dim, bool unbiased, bool keepdim);
  Tensor & var_out_out(Tensor & out, const Tensor & self, IntArrayRef dim, bool unbiased, bool keepdim);
  Tensor var_names_dim(const Tensor & self, DimnameList dim, bool unbiased, bool keepdim);
  Tensor & var_out_names_out(Tensor & out, const Tensor & self, DimnameList dim, bool unbiased, bool keepdim);
  std::tuple<Tensor,Tensor> var_mean(const Tensor & self, bool unbiased);
  std::tuple<Tensor,Tensor> var_mean_dim(const Tensor & self, IntArrayRef dim, bool unbiased, bool keepdim);
  std::tuple<Tensor,Tensor> var_mean_names_dim(const Tensor & self, DimnameList dim, bool unbiased, bool keepdim);
  Tensor view_as(const Tensor & self, const Tensor & other);
  Tensor where_self(const Tensor & condition, const Tensor & self, const Tensor & other);
  std::vector<Tensor> where(const Tensor & condition);
  Tensor _s_where(const Tensor & condition, const Tensor & self, const Tensor & other);
  Tensor norm_except_dim(const Tensor & v, int64_t pow, int64_t dim);
  Tensor _weight_norm(const Tensor & v, const Tensor & g, int64_t dim);
  std::tuple<Tensor,Tensor> _weight_norm_differentiable_backward(const Tensor & grad_w, const Tensor & saved_v, const Tensor & saved_g, const Tensor & saved_norms, int64_t dim);
  Tensor zeros_names(IntArrayRef size, c10::optional<DimnameList> names, const TensorOptions & options);
  Tensor zeros(IntArrayRef size, const TensorOptions & options);
  Tensor & zeros_out_out(Tensor & out, IntArrayRef size);
  Tensor zeros_like(const Tensor & self, const TensorOptions & options, c10::optional<MemoryFormat> memory_format);
  Tensor _sparse_sum(const Tensor & self);
  Tensor _sparse_sum_dtype(const Tensor & self, ScalarType dtype);
  Tensor _sparse_sum_dim(const Tensor & self, IntArrayRef dim);
  Tensor _sparse_sum_dim_dtype(const Tensor & self, IntArrayRef dim, ScalarType dtype);
  Tensor norm_ScalarOpt_dtype(const Tensor & self, c10::optional<Scalar> p, ScalarType dtype);
  Tensor norm_Scalar(const Tensor & self, Scalar p);
  Tensor norm_ScalarOpt_dim_dtype(const Tensor & self, c10::optional<Scalar> p, IntArrayRef dim, bool keepdim, ScalarType dtype);
  Tensor norm_ScalarOpt_dim(const Tensor & self, c10::optional<Scalar> p, IntArrayRef dim, bool keepdim);
  Tensor & norm_out_dtype_out(Tensor & out, const Tensor & self, c10::optional<Scalar> p, IntArrayRef dim, bool keepdim, ScalarType dtype);
  Tensor & norm_out_out(Tensor & out, const Tensor & self, c10::optional<Scalar> p, IntArrayRef dim, bool keepdim);
  Tensor norm_names_ScalarOpt_dim_dtype(const Tensor & self, c10::optional<Scalar> p, DimnameList dim, bool keepdim, ScalarType dtype);
  Tensor norm_names_ScalarOpt_dim(const Tensor & self, c10::optional<Scalar> p, DimnameList dim, bool keepdim);
  Tensor & norm_out_names_dtype_out(Tensor & out, const Tensor & self, c10::optional<Scalar> p, DimnameList dim, bool keepdim, ScalarType dtype);
  Tensor & norm_out_names_out(Tensor & out, const Tensor & self, c10::optional<Scalar> p, DimnameList dim, bool keepdim);
  Tensor frobenius_norm(const Tensor & self);
  Tensor frobenius_norm_dim(const Tensor & self, IntArrayRef dim, bool keepdim);
  Tensor & frobenius_norm_out_out(Tensor & out, const Tensor & self, IntArrayRef dim, bool keepdim);
  Tensor nuclear_norm(const Tensor & self, bool keepdim);
  Tensor & nuclear_norm_out_out(Tensor & out, const Tensor & self, bool keepdim);
  Tensor nuclear_norm_dim(const Tensor & self, IntArrayRef dim, bool keepdim);
  Tensor & nuclear_norm_out_dim_out(Tensor & out, const Tensor & self, IntArrayRef dim, bool keepdim);
  Tensor & resize_as_(Tensor & self, const Tensor & the_template, c10::optional<MemoryFormat> memory_format);
  Tensor sub_Scalar(const Tensor & self, Scalar other, Scalar alpha);
  Tensor & sub__Scalar(Tensor & self, Scalar other, Scalar alpha);
  Tensor rsub_Tensor(const Tensor & self, const Tensor & other, Scalar alpha);
  Tensor rsub_Scalar(const Tensor & self, Scalar other, Scalar alpha);
  Tensor _sparse_addmm(const Tensor & self, const Tensor & sparse, const Tensor & dense, Scalar beta, Scalar alpha);
  Tensor sparse_coo_tensor_size(IntArrayRef size, const TensorOptions & options);
  Tensor sparse_coo_tensor_indices(const Tensor & indices, const Tensor & values, const TensorOptions & options);
  Tensor sparse_coo_tensor_indices_size(const Tensor & indices, const Tensor & values, IntArrayRef size, const TensorOptions & options);
  Tensor _sparse_coo_tensor_unsafe(const Tensor & indices, const Tensor & values, IntArrayRef size, const TensorOptions & options);
  Tensor to_dense_backward(const Tensor & grad, const Tensor & input);
  std::vector<Tensor> unbind_int(const Tensor & self, int64_t dim);
  std::vector<Tensor> unbind_Dimname(const Tensor & self, Dimname dim);
  Tensor to_mkldnn_backward(const Tensor & grad, const Tensor & input);
  Tensor fake_quantize_per_tensor_affine(const Tensor & self, double scale, int64_t zero_point, int64_t quant_min, int64_t quant_max);
  Tensor fake_quantize_per_tensor_affine_backward(const Tensor & grad, const Tensor & self, double scale, int64_t zero_point, int64_t quant_min, int64_t quant_max);
  Tensor fake_quantize_per_channel_affine(const Tensor & self, const Tensor & scale, const Tensor & zero_point, int64_t axis, int64_t quant_min, int64_t quant_max);
  Tensor fake_quantize_per_channel_affine_backward(const Tensor & grad, const Tensor & self, const Tensor & scale, const Tensor & zero_point, int64_t axis, int64_t quant_min, int64_t quant_max);
  Tensor to_dtype_layout(const Tensor & self, const TensorOptions & options, bool non_blocking, bool copy, c10::optional<MemoryFormat> memory_format);
  Tensor to_device(const Tensor & self, Device device, ScalarType dtype, bool non_blocking, bool copy, c10::optional<MemoryFormat> memory_format);
  Tensor to_dtype(const Tensor & self, ScalarType dtype, bool non_blocking, bool copy, c10::optional<MemoryFormat> memory_format);
  Tensor to_other(const Tensor & self, const Tensor & other, bool non_blocking, bool copy, c10::optional<MemoryFormat> memory_format);
  std::vector<Tensor> meshgrid(TensorList tensors);
  Tensor cartesian_prod(TensorList tensors);
  Tensor combinations(const Tensor & self, int64_t r, bool with_replacement);
  Scalar item(const Tensor & self);
  ScalarType result_type_Tensor(const Tensor & tensor, const Tensor & other);
  ScalarType result_type_Scalar(const Tensor & tensor, Scalar other);
  ScalarType result_type_Scalar_Tensor(Scalar scalar, const Tensor & tensor);
  ScalarType result_type_Scalar_Scalar(Scalar scalar1, Scalar scalar2);
  bool can_cast(ScalarType from, ScalarType to);
  ScalarType promote_types(ScalarType type1, ScalarType type2);
  std::tuple<Tensor,Tensor,Tensor,Tensor,Tensor> _thnn_differentiable_lstm_cell_backward(const Tensor & grad_hy, const Tensor & grad_cy, const Tensor & input_gates, const Tensor & hidden_gates, const Tensor & input_bias, const Tensor & hidden_bias, const Tensor & cx, const Tensor & cy);
  std::tuple<Tensor,Tensor,Tensor,Tensor,Tensor> _thnn_differentiable_gru_cell_backward(const Tensor & grad_hy, const Tensor & input_gates, const Tensor & hidden_gates, const Tensor & hx, const Tensor & input_bias, const Tensor & hidden_bias);
  std::tuple<Tensor,Tensor,Tensor> lstm_input(const Tensor & input, TensorList hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional, bool batch_first);
  std::tuple<Tensor,Tensor,Tensor> lstm_data(const Tensor & data, const Tensor & batch_sizes, TensorList hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional);
  std::tuple<Tensor,Tensor> gru_input(const Tensor & input, const Tensor & hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional, bool batch_first);
  std::tuple<Tensor,Tensor> gru_data(const Tensor & data, const Tensor & batch_sizes, const Tensor & hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional);
  std::tuple<Tensor,Tensor> rnn_tanh_input(const Tensor & input, const Tensor & hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional, bool batch_first);
  std::tuple<Tensor,Tensor> rnn_tanh_data(const Tensor & data, const Tensor & batch_sizes, const Tensor & hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional);
  std::tuple<Tensor,Tensor> rnn_relu_input(const Tensor & input, const Tensor & hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional, bool batch_first);
  std::tuple<Tensor,Tensor> rnn_relu_data(const Tensor & data, const Tensor & batch_sizes, const Tensor & hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional);
  std::tuple<Tensor,Tensor> lstm_cell(const Tensor & input, TensorList hx, const Tensor & w_ih, const Tensor & w_hh, const Tensor & b_ih, const Tensor & b_hh);
  Tensor gru_cell(const Tensor & input, const Tensor & hx, const Tensor & w_ih, const Tensor & w_hh, const Tensor & b_ih, const Tensor & b_hh);
  Tensor rnn_tanh_cell(const Tensor & input, const Tensor & hx, const Tensor & w_ih, const Tensor & w_hh, const Tensor & b_ih, const Tensor & b_hh);
  Tensor rnn_relu_cell(const Tensor & input, const Tensor & hx, const Tensor & w_ih, const Tensor & w_hh, const Tensor & b_ih, const Tensor & b_hh);
  std::tuple<Tensor,Tensor,Tensor> quantized_lstm(const Tensor & input, TensorList hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional, bool batch_first, c10::optional<ScalarType> dtype, bool use_dynamic);
  std::tuple<Tensor,Tensor,Tensor> quantized_lstm_data(const Tensor & data, const Tensor & batch_sizes, TensorList hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional, c10::optional<ScalarType> dtype, bool use_dynamic);
  std::tuple<Tensor,Tensor> quantized_gru_input(const Tensor & input, const Tensor & hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional, bool batch_first);
  std::tuple<Tensor,Tensor> quantized_gru_data(const Tensor & data, const Tensor & batch_sizes, const Tensor & hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional);
  std::tuple<Tensor,Tensor> quantized_lstm_cell(const Tensor & input, TensorList hx, const Tensor & w_ih, const Tensor & w_hh, const Tensor & b_ih, const Tensor & b_hh, const Tensor & packed_ih, const Tensor & packed_hh, const Tensor & col_offsets_ih, const Tensor & col_offsets_hh, Scalar scale_ih, Scalar scale_hh, Scalar zero_point_ih, Scalar zero_point_hh);
  Tensor quantized_gru_cell(const Tensor & input, const Tensor & hx, const Tensor & w_ih, const Tensor & w_hh, const Tensor & b_ih, const Tensor & b_hh, const Tensor & packed_ih, const Tensor & packed_hh, const Tensor & col_offsets_ih, const Tensor & col_offsets_hh, Scalar scale_ih, Scalar scale_hh, Scalar zero_point_ih, Scalar zero_point_hh);
  Tensor quantized_rnn_relu_cell(const Tensor & input, const Tensor & hx, const Tensor & w_ih, const Tensor & w_hh, const Tensor & b_ih, const Tensor & b_hh, const Tensor & packed_ih, const Tensor & packed_hh, const Tensor & col_offsets_ih, const Tensor & col_offsets_hh, Scalar scale_ih, Scalar scale_hh, Scalar zero_point_ih, Scalar zero_point_hh);
  Tensor quantized_rnn_tanh_cell(const Tensor & input, const Tensor & hx, const Tensor & w_ih, const Tensor & w_hh, const Tensor & b_ih, const Tensor & b_hh, const Tensor & packed_ih, const Tensor & packed_hh, const Tensor & col_offsets_ih, const Tensor & col_offsets_hh, Scalar scale_ih, Scalar scale_hh, Scalar zero_point_ih, Scalar zero_point_hh);
  std::tuple<Tensor,Tensor> _pack_padded_sequence(const Tensor & input, const Tensor & lengths, bool batch_first);
  Tensor _pack_padded_sequence_backward(const Tensor & grad, IntArrayRef input_size, const Tensor & batch_sizes, bool batch_first);
  std::tuple<Tensor,Tensor> _pad_packed_sequence(const Tensor & data, const Tensor & batch_sizes, bool batch_first, Scalar padding_value, int64_t total_length);
  Tensor masked_fill_Scalar(const Tensor & self, const Tensor & mask, Scalar value);
  Tensor masked_fill_Tensor(const Tensor & self, const Tensor & mask, const Tensor & value);
  Tensor masked_scatter(const Tensor & self, const Tensor & mask, const Tensor & source);
  Tensor index_add(const Tensor & self, int64_t dim, const Tensor & index, const Tensor & source);
  Tensor index_add_dimname(const Tensor & self, Dimname dim, const Tensor & index, const Tensor & source);
  Tensor index_fill_int_Scalar(const Tensor & self, int64_t dim, const Tensor & index, Scalar value);
  Tensor index_fill_int_Tensor(const Tensor & self, int64_t dim, const Tensor & index, const Tensor & value);
  Tensor & index_fill__Dimname_Scalar(Tensor & self, Dimname dim, const Tensor & index, Scalar value);
  Tensor & index_fill__Dimname_Tensor(Tensor & self, Dimname dim, const Tensor & index, const Tensor & value);
  Tensor index_fill_Dimname_Scalar(const Tensor & self, Dimname dim, const Tensor & index, Scalar value);
  Tensor index_fill_Dimname_Tensor(const Tensor & self, Dimname dim, const Tensor & index, const Tensor & value);
  Tensor scatter_src(const Tensor & self, int64_t dim, const Tensor & index, const Tensor & src);
  Tensor scatter_value(const Tensor & self, int64_t dim, const Tensor & index, Scalar value);
  Tensor scatter_dimname_src(const Tensor & self, Dimname dim, const Tensor & index, const Tensor & src);
  Tensor scatter_dimname_value(const Tensor & self, Dimname dim, const Tensor & index, Scalar value);
  Tensor scatter_add(const Tensor & self, int64_t dim, const Tensor & index, const Tensor & src);
  Tensor scatter_add_dimname(const Tensor & self, Dimname dim, const Tensor & index, const Tensor & src);
  Tensor & lt__Scalar(Tensor & self, Scalar other);
  Tensor & lt__Tensor(Tensor & self, const Tensor & other);
  Tensor & gt__Scalar(Tensor & self, Scalar other);
  Tensor & gt__Tensor(Tensor & self, const Tensor & other);
  Tensor & le__Scalar(Tensor & self, Scalar other);
  Tensor & le__Tensor(Tensor & self, const Tensor & other);
  Tensor & ge__Scalar(Tensor & self, Scalar other);
  Tensor & ge__Tensor(Tensor & self, const Tensor & other);
  Tensor & eq__Scalar(Tensor & self, Scalar other);
  Tensor & eq__Tensor(Tensor & self, const Tensor & other);
  Tensor & ne__Scalar(Tensor & self, Scalar other);
  Tensor & ne__Tensor(Tensor & self, const Tensor & other);
  Tensor bitwise_and_Scalar(const Tensor & self, Scalar other);
  Tensor bitwise_and_Tensor(const Tensor & self, const Tensor & other);
  Tensor & bitwise_and__Scalar(Tensor & self, Scalar other);
  Tensor & bitwise_and__Tensor(Tensor & self, const Tensor & other);
  Tensor __and___Scalar(const Tensor & self, Scalar other);
  Tensor __and___Tensor(const Tensor & self, const Tensor & other);
  Tensor & __iand___Scalar(Tensor & self, Scalar other);
  Tensor & __iand___Tensor(Tensor & self, const Tensor & other);
  Tensor bitwise_or_Scalar(const Tensor & self, Scalar other);
  Tensor bitwise_or_Tensor(const Tensor & self, const Tensor & other);
  Tensor & bitwise_or__Scalar(Tensor & self, Scalar other);
  Tensor & bitwise_or__Tensor(Tensor & self, const Tensor & other);
  Tensor __or___Scalar(const Tensor & self, Scalar other);
  Tensor __or___Tensor(const Tensor & self, const Tensor & other);
  Tensor & __ior___Scalar(Tensor & self, Scalar other);
  Tensor & __ior___Tensor(Tensor & self, const Tensor & other);
  Tensor bitwise_xor_Scalar(const Tensor & self, Scalar other);
  Tensor bitwise_xor_Tensor(const Tensor & self, const Tensor & other);
  Tensor & bitwise_xor__Scalar(Tensor & self, Scalar other);
  Tensor & bitwise_xor__Tensor(Tensor & self, const Tensor & other);
  Tensor __xor___Scalar(const Tensor & self, Scalar other);
  Tensor __xor___Tensor(const Tensor & self, const Tensor & other);
  Tensor & __ixor___Scalar(Tensor & self, Scalar other);
  Tensor & __ixor___Tensor(Tensor & self, const Tensor & other);
  Tensor & atan2_(Tensor & self, const Tensor & other);
  Tensor & digamma_(Tensor & self);
  Tensor & polygamma_(Tensor & self, int64_t n);
  Tensor & addcdiv_(Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value);
  Tensor & random__from(Tensor & self, int64_t from, c10::optional<int64_t> to, Generator * generator);
  Tensor & random__to(Tensor & self, int64_t to, Generator * generator);
  Tensor & random_(Tensor & self, Generator * generator);
  Tensor & cauchy_(Tensor & self, double median, double sigma, Generator * generator);
  Tensor & log_normal_(Tensor & self, double mean, double std, Generator * generator);
  Tensor & exponential_(Tensor & self, double lambd, Generator * generator);
  Tensor & geometric_(Tensor & self, double p, Generator * generator);
  Tensor & cross_out_out(Tensor & out, const Tensor & self, const Tensor & other, c10::optional<int64_t> dim);
  Tensor cross(const Tensor & self, const Tensor & other, c10::optional<int64_t> dim);
  Tensor triu(const Tensor & self, int64_t diagonal);
  Tensor tril(const Tensor & self, int64_t diagonal);
  Tensor & index_select_out_dimname_out(Tensor & out, const Tensor & self, Dimname dim, const Tensor & index);
  Tensor index_select_dimname(const Tensor & self, Dimname dim, const Tensor & index);
  std::vector<Tensor> nonzero_numpy(const Tensor & self);
  Tensor & gather_out_dimname_out(Tensor & out, const Tensor & self, Dimname dim, const Tensor & index, bool sparse_grad);
  Tensor gather_dimname(const Tensor & self, Dimname dim, const Tensor & index, bool sparse_grad);
  Tensor _gather_sparse_backward(const Tensor & self, int64_t dim, const Tensor & index, const Tensor & grad);
  Tensor & addcmul_out_out(Tensor & out, const Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value);
  Tensor addcmul(const Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value);
  Tensor & addcmul_(Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value);
  Tensor & addcdiv_out_out(Tensor & out, const Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value);
  Tensor addcdiv(const Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value);
  std::tuple<Tensor &,Tensor &> triangular_solve_out_X(Tensor & X, Tensor & M, const Tensor & self, const Tensor & A, bool upper, bool transpose, bool unitriangular);
  std::tuple<Tensor,Tensor> triangular_solve(const Tensor & self, const Tensor & A, bool upper, bool transpose, bool unitriangular);
  std::tuple<Tensor &,Tensor &> symeig_out_e(Tensor & e, Tensor & V, const Tensor & self, bool eigenvectors, bool upper);
  std::tuple<Tensor,Tensor> symeig(const Tensor & self, bool eigenvectors, bool upper);
  std::tuple<Tensor &,Tensor &,Tensor &> svd_out_U(Tensor & U, Tensor & S, Tensor & V, const Tensor & self, bool some, bool compute_uv);
  std::tuple<Tensor,Tensor,Tensor> svd(const Tensor & self, bool some, bool compute_uv);
  Tensor & cholesky_out_out(Tensor & out, const Tensor & self, bool upper);
  Tensor cholesky(const Tensor & self, bool upper);
  Tensor & cholesky_solve_out_out(Tensor & out, const Tensor & self, const Tensor & input2, bool upper);
  Tensor cholesky_solve(const Tensor & self, const Tensor & input2, bool upper);
  std::tuple<Tensor,Tensor> solve(const Tensor & self, const Tensor & A);
  std::tuple<Tensor &,Tensor &> solve_out_solution(Tensor & solution, Tensor & lu, const Tensor & self, const Tensor & A);
  std::tuple<Tensor &,Tensor &> qr_out_Q(Tensor & Q, Tensor & R, const Tensor & self, bool some);
  std::tuple<Tensor,Tensor> qr(const Tensor & self, bool some);
  Tensor & lu_solve_out_out(Tensor & out, const Tensor & self, const Tensor & LU_data, const Tensor & LU_pivots);
  Tensor lu_solve(const Tensor & self, const Tensor & LU_data, const Tensor & LU_pivots);
  Tensor & digamma_out_out(Tensor & out, const Tensor & self);
  Tensor digamma(const Tensor & self);
  Tensor & polygamma_out_out(Tensor & out, int64_t n, const Tensor & self);
  Tensor polygamma(int64_t n, const Tensor & self);
  Tensor sign(const Tensor & self);
  Tensor & sign_(Tensor & self);
  Tensor dist(const Tensor & self, const Tensor & other, Scalar p);
  Tensor & atan2_out_out(Tensor & out, const Tensor & self, const Tensor & other);
  Tensor atan2(const Tensor & self, const Tensor & other);
  Tensor & min_out_out(Tensor & out, const Tensor & self, const Tensor & other);
  Tensor min_other(const Tensor & self, const Tensor & other);
  Tensor & max_out_out(Tensor & out, const Tensor & self, const Tensor & other);
  Tensor max_other(const Tensor & self, const Tensor & other);
  std::tuple<Tensor &,Tensor &> sort_out_dimname_values(Tensor & values, Tensor & indices, const Tensor & self, Dimname dim, bool descending);
  std::tuple<Tensor,Tensor> sort_dimname(const Tensor & self, Dimname dim, bool descending);
  Tensor argsort(const Tensor & self, int64_t dim, bool descending);
  Tensor argsort_dimname(const Tensor & self, Dimname dim, bool descending);
  Tensor all(const Tensor & self);
  Tensor normal_float_float(double mean, double std, IntArrayRef size, Generator * generator, const TensorOptions & options);
  Tensor & normal_out_float_float_out(Tensor & out, double mean, double std, IntArrayRef size, Generator * generator);
  Tensor alias(const Tensor & self);
  Tensor & mse_loss_out_out(Tensor & out, const Tensor & self, const Tensor & target, int64_t reduction);
  Tensor mse_loss(const Tensor & self, const Tensor & target, int64_t reduction);
  Tensor & l1_loss_out_out(Tensor & out, const Tensor & self, const Tensor & target, int64_t reduction);
  Tensor l1_loss(const Tensor & self, const Tensor & target, int64_t reduction);
  Tensor l1_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction);
  Tensor & multilabel_margin_loss_out_out(Tensor & out, const Tensor & self, const Tensor & target, int64_t reduction);
  Tensor multilabel_margin_loss(const Tensor & self, const Tensor & target, int64_t reduction);
  Tensor & nll_loss_out_out(Tensor & out, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index);
  Tensor nll_loss(const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index);
  Tensor & nll_loss2d_out_out(Tensor & out, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index);
  Tensor nll_loss2d(const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index);
  Tensor smooth_l1_loss(const Tensor & self, const Tensor & target, int64_t reduction);
  Tensor smooth_l1_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction);
  Tensor & soft_margin_loss_out_out(Tensor & out, const Tensor & self, const Tensor & target, int64_t reduction);
  Tensor soft_margin_loss(const Tensor & self, const Tensor & target, int64_t reduction);
  Tensor & soft_margin_loss_backward_out_grad_input(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction);
  Tensor soft_margin_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction);
  Tensor elu_backward(const Tensor & grad_output, Scalar alpha, Scalar scale, Scalar input_scale, const Tensor & output);
  Tensor & hardsigmoid_out_out(Tensor & out, const Tensor & self);
  Tensor hardsigmoid(const Tensor & self);
  Tensor & hardsigmoid_(Tensor & self);
  Tensor hardsigmoid_backward(const Tensor & grad_output, const Tensor & self);
  Tensor hardtanh_backward(const Tensor & grad_output, const Tensor & self, Scalar min_val, Scalar max_val);
  Tensor leaky_relu_backward(const Tensor & grad_output, const Tensor & self, Scalar negative_slope, bool self_is_result);
  Tensor & log_sigmoid_out_out(Tensor & out, const Tensor & self);
  Tensor log_sigmoid(const Tensor & self);
  Tensor rrelu_with_noise_backward(const Tensor & grad_output, const Tensor & self, const Tensor & noise, Scalar lower, Scalar upper, bool training, bool self_is_result);
  Tensor & softplus_out_out(Tensor & out, const Tensor & self, Scalar beta, Scalar threshold);
  Tensor softplus(const Tensor & self, Scalar beta, Scalar threshold);
  Tensor softplus_backward(const Tensor & grad_output, const Tensor & self, Scalar beta, Scalar threshold, const Tensor & output);
  Tensor & softshrink_out_out(Tensor & out, const Tensor & self, Scalar lambd);
  Tensor softshrink(const Tensor & self, Scalar lambd);
  Tensor softshrink_backward(const Tensor & grad_output, const Tensor & self, Scalar lambd);
  Tensor adaptive_avg_pool2d(const Tensor & self, IntArrayRef output_size);
  Tensor sigmoid_backward(const Tensor & grad_output, const Tensor & output);
  Tensor tanh_backward(const Tensor & grad_output, const Tensor & output);
  Tensor & thnn_conv2d_out_out(Tensor & out, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding);
  Tensor thnn_conv2d(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding);
  Tensor & thnn_conv_depthwise2d_out_out(Tensor & out, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation);
  Tensor thnn_conv_depthwise2d(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation);
  Tensor & slow_conv3d_out_out(Tensor & out, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding);
  Tensor slow_conv3d(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding);
  Tensor isfinite(const Tensor & self);
  Tensor isinf(const Tensor & self);
}  // namespace TypeDefault

} // namespace at
