#pragma once

// @generated by tools/codegen/gen.py from Functions.h

#include <c10/core/Scalar.h>
#include <ATen/Tensor.h>
#include <c10/core/Storage.h>
#include <ATen/core/Generator.h>
#include <c10/util/Deprecated.h>
#include <ATen/DeviceGuard.h>
#include <c10/core/TensorOptions.h>
#include <ATen/core/Reduction.h>
#include <c10/util/Optional.h>
#include <ATen/TensorUtils.h>
#include <ATen/Context.h>
#include <ATen/TracerMode.h>
#include <ATen/core/op_registration/hacky_wrapper_for_legacy_signatures.h>

namespace at {

// These functions are defined in ATen/Utils.cpp.
#define TENSOR(T, S)                                                          \
  TORCH_API Tensor tensor(ArrayRef<T> values, const TensorOptions& options); \
  inline Tensor tensor(                                                       \
      std::initializer_list<T> values, const TensorOptions& options) {        \
    return at::tensor(ArrayRef<T>(values), options);                          \
  }                                                                           \
  inline Tensor tensor(T value, const TensorOptions& options) {               \
    return at::tensor(ArrayRef<T>(value), options);                           \
  }                                                                           \
  inline Tensor tensor(ArrayRef<T> values) {                                  \
    return at::tensor(std::move(values), at::dtype(k##S));                    \
  }                                                                           \
  inline Tensor tensor(std::initializer_list<T> values) {                     \
    return at::tensor(ArrayRef<T>(values));                                   \
  }                                                                           \
  inline Tensor tensor(T value) {                                             \
    return at::tensor(ArrayRef<T>(value));                                    \
  }
AT_FORALL_SCALAR_TYPES_AND3(Bool, Half, BFloat16, TENSOR)
AT_FORALL_COMPLEX_TYPES(TENSOR)
#undef TENSOR

TORCH_API Tensor _cast_Byte(const Tensor & self, bool non_blocking=false);
TORCH_API Tensor _cast_Char(const Tensor & self, bool non_blocking=false);
TORCH_API Tensor _cast_Double(const Tensor & self, bool non_blocking=false);
TORCH_API Tensor _cast_Float(const Tensor & self, bool non_blocking=false);
TORCH_API Tensor _cast_Int(const Tensor & self, bool non_blocking=false);
TORCH_API Tensor _cast_Long(const Tensor & self, bool non_blocking=false);
TORCH_API Tensor _cast_Short(const Tensor & self, bool non_blocking=false);
TORCH_API Tensor _cast_Half(const Tensor & self, bool non_blocking=false);
TORCH_API Tensor _make_dual(const Tensor & primal, const Tensor & tangent, int64_t level);
TORCH_API std::tuple<Tensor,Tensor> _unpack_dual(const Tensor & dual, int64_t level);
TORCH_API std::vector<Tensor> align_tensors(TensorList tensors);
TORCH_API bool _use_cudnn_ctc_loss(const Tensor & log_probs, const Tensor & targets, IntArrayRef input_lengths, IntArrayRef target_lengths, int64_t blank);
TORCH_API std::tuple<Tensor,Tensor> _cudnn_ctc_loss(const Tensor & log_probs, const Tensor & targets, IntArrayRef input_lengths, IntArrayRef target_lengths, int64_t blank, bool deterministic, bool zero_infinity);
TORCH_API bool _use_cudnn_rnn_flatten_weight();
TORCH_API Tensor _cudnn_rnn_flatten_weight(TensorList weight_arr, int64_t weight_stride0, int64_t input_size, int64_t mode, int64_t hidden_size, int64_t proj_size, int64_t num_layers, bool batch_first, bool bidirectional);
TORCH_API std::tuple<Tensor,Tensor,Tensor,Tensor,Tensor> _cudnn_rnn(const Tensor & input, TensorList weight, int64_t weight_stride0, const c10::optional<Tensor> & weight_buf, const Tensor & hx, const c10::optional<Tensor> & cx, int64_t mode, int64_t hidden_size, int64_t proj_size, int64_t num_layers, bool batch_first, double dropout, bool train, bool bidirectional, IntArrayRef batch_sizes, const c10::optional<Tensor> & dropout_state);
TORCH_API std::tuple<Tensor,Tensor,Tensor,std::vector<Tensor>> _cudnn_rnn_backward(const Tensor & input, TensorList weight, int64_t weight_stride0, const Tensor & weight_buf, const Tensor & hx, const c10::optional<Tensor> & cx, const Tensor & output, const c10::optional<Tensor> & grad_output, const c10::optional<Tensor> & grad_hy, const c10::optional<Tensor> & grad_cy, int64_t mode, int64_t hidden_size, int64_t proj_size, int64_t num_layers, bool batch_first, double dropout, bool train, bool bidirectional, IntArrayRef batch_sizes, const c10::optional<Tensor> & dropout_state, const Tensor & reserve, std::array<bool,4> output_mask);
TORCH_API Tensor _cudnn_init_dropout_state(double dropout, bool train, int64_t dropout_seed, TensorOptions options);
TORCH_API Tensor _cudnn_init_dropout_state(double dropout, bool train, int64_t dropout_seed, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory);
TORCH_API int64_t _debug_has_internal_overlap(const Tensor & self);
TORCH_API std::tuple<Tensor,Tensor> _fused_dropout(const Tensor & self, double p, c10::optional<Generator> generator=c10::nullopt);
TORCH_API Tensor _masked_scale(const Tensor & self, const Tensor & mask, double scale);
TORCH_API std::tuple<Tensor,Tensor> _sobol_engine_draw(const Tensor & quasi, int64_t n, const Tensor & sobolstate, int64_t dimension, int64_t num_generated, c10::optional<ScalarType> dtype);
TORCH_API Tensor & _sobol_engine_ff_(Tensor & self, int64_t n, const Tensor & sobolstate, int64_t dimension, int64_t num_generated);
TORCH_API Tensor & _sobol_engine_scramble_(Tensor & self, const Tensor & ltm, int64_t dimension);
TORCH_API Tensor & _sobol_engine_initialize_state_(Tensor & self, int64_t dimension);
TORCH_API Tensor _reshape_from_tensor(const Tensor & self, const Tensor & shape);
TORCH_API Tensor _shape_as_tensor(const Tensor & self);
TORCH_API Tensor dropout(const Tensor & input, double p, bool train);
TORCH_API Tensor & dropout_(Tensor & self, double p, bool train);
TORCH_API Tensor feature_dropout(const Tensor & input, double p, bool train);
TORCH_API Tensor & feature_dropout_(Tensor & self, double p, bool train);
TORCH_API Tensor alpha_dropout(const Tensor & input, double p, bool train);
TORCH_API Tensor & alpha_dropout_(Tensor & self, double p, bool train);
TORCH_API Tensor feature_alpha_dropout(const Tensor & input, double p, bool train);
TORCH_API Tensor & feature_alpha_dropout_(Tensor & self, double p, bool train);
TORCH_API Tensor abs(const Tensor & self);
TORCH_API Tensor & abs_(Tensor & self);
TORCH_API Tensor & abs_out(Tensor & out, const Tensor & self);
TORCH_API Tensor & abs_outf(const Tensor & self, Tensor & out);
TORCH_API Tensor absolute(const Tensor & self);
TORCH_API Tensor & absolute_out(Tensor & out, const Tensor & self);
TORCH_API Tensor & absolute_outf(const Tensor & self, Tensor & out);
TORCH_API Tensor angle(const Tensor & self);
TORCH_API Tensor & angle_out(Tensor & out, const Tensor & self);
TORCH_API Tensor & angle_outf(const Tensor & self, Tensor & out);
TORCH_API Tensor view_as_real(const Tensor & self);
TORCH_API Tensor view_as_complex(const Tensor & self);
TORCH_API Tensor sgn(const Tensor & self);
TORCH_API Tensor & sgn_out(Tensor & out, const Tensor & self);
TORCH_API Tensor & sgn_outf(const Tensor & self, Tensor & out);
TORCH_API Tensor real(const Tensor & self);
TORCH_API Tensor imag(const Tensor & self);
TORCH_API Tensor conj(const Tensor & self);
TORCH_API Tensor & conj_out(Tensor & out, const Tensor & self);
TORCH_API Tensor & conj_outf(const Tensor & self, Tensor & out);
TORCH_API Tensor _conj(const Tensor & self);
TORCH_API Tensor acos(const Tensor & self);
TORCH_API Tensor & acos_(Tensor & self);
TORCH_API Tensor & acos_out(Tensor & out, const Tensor & self);
TORCH_API Tensor & acos_outf(const Tensor & self, Tensor & out);
TORCH_API Tensor arccos(const Tensor & self);
TORCH_API Tensor & arccos_(Tensor & self);
TORCH_API Tensor & arccos_out(Tensor & out, const Tensor & self);
TORCH_API Tensor & arccos_outf(const Tensor & self, Tensor & out);
TORCH_API Tensor avg_pool1d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride={}, IntArrayRef padding=0, bool ceil_mode=false, bool count_include_pad=true);
TORCH_API Tensor adaptive_avg_pool1d(const Tensor & self, IntArrayRef output_size);
TORCH_API std::tuple<Tensor,Tensor> adaptive_max_pool1d(const Tensor & self, IntArrayRef output_size);
TORCH_API Tensor add(const Tensor & self, const Tensor & other, Scalar alpha=1);
TORCH_API Tensor & add_out(Tensor & out, const Tensor & self, const Tensor & other, Scalar alpha=1);
TORCH_API Tensor & add_outf(const Tensor & self, const Tensor & other, Scalar alpha, Tensor & out);
TORCH_API Tensor _add_relu(const Tensor & self, const Tensor & other, Scalar alpha=1);
TORCH_API Tensor & _add_relu_(Tensor & self, const Tensor & other, Scalar alpha=1);
TORCH_API Tensor & _add_relu_out(Tensor & out, const Tensor & self, const Tensor & other, Scalar alpha=1);
TORCH_API Tensor & _add_relu_outf(const Tensor & self, const Tensor & other, Scalar alpha, Tensor & out);
TORCH_API Tensor add(const Tensor & self, Scalar other, Scalar alpha=1);
TORCH_API Tensor addmv(const Tensor & self, const Tensor & mat, const Tensor & vec, Scalar beta=1, Scalar alpha=1);
TORCH_API Tensor & addmv_(Tensor & self, const Tensor & mat, const Tensor & vec, Scalar beta=1, Scalar alpha=1);
TORCH_API Tensor & addmv_out(Tensor & out, const Tensor & self, const Tensor & mat, const Tensor & vec, Scalar beta=1, Scalar alpha=1);
TORCH_API Tensor & addmv_outf(const Tensor & self, const Tensor & mat, const Tensor & vec, Scalar beta, Scalar alpha, Tensor & out);
TORCH_API Tensor & _addmv_impl_(Tensor & self, const Tensor & self2, const Tensor & mat, const Tensor & vec, Scalar beta=1, Scalar alpha=1);
TORCH_API Tensor addr(const Tensor & self, const Tensor & vec1, const Tensor & vec2, Scalar beta=1, Scalar alpha=1);
TORCH_API Tensor & addr_out(Tensor & out, const Tensor & self, const Tensor & vec1, const Tensor & vec2, Scalar beta=1, Scalar alpha=1);
TORCH_API Tensor & addr_outf(const Tensor & self, const Tensor & vec1, const Tensor & vec2, Scalar beta, Scalar alpha, Tensor & out);
TORCH_API Tensor affine_grid_generator(const Tensor & theta, IntArrayRef size, bool align_corners);
TORCH_API Tensor affine_grid_generator_backward(const Tensor & grad, IntArrayRef size, bool align_corners);
TORCH_API Tensor all(const Tensor & self, int64_t dim, bool keepdim=false);
TORCH_API Tensor & all_out(Tensor & out, const Tensor & self, int64_t dim, bool keepdim=false);
TORCH_API Tensor & all_outf(const Tensor & self, int64_t dim, bool keepdim, Tensor & out);
TORCH_API Tensor all(const Tensor & self, Dimname dim, bool keepdim=false);
TORCH_API Tensor & all_out(Tensor & out, const Tensor & self, Dimname dim, bool keepdim=false);
TORCH_API Tensor & all_outf(const Tensor & self, Dimname dim, bool keepdim, Tensor & out);
TORCH_API bool allclose(const Tensor & self, const Tensor & other, double rtol=1e-05, double atol=1e-08, bool equal_nan=false);
TORCH_API Tensor any(const Tensor & self, int64_t dim, bool keepdim=false);
TORCH_API Tensor & any_out(Tensor & out, const Tensor & self, int64_t dim, bool keepdim=false);
TORCH_API Tensor & any_outf(const Tensor & self, int64_t dim, bool keepdim, Tensor & out);
TORCH_API Tensor any(const Tensor & self, Dimname dim, bool keepdim=false);
TORCH_API Tensor & any_out(Tensor & out, const Tensor & self, Dimname dim, bool keepdim=false);
TORCH_API Tensor & any_outf(const Tensor & self, Dimname dim, bool keepdim, Tensor & out);
TORCH_API Tensor arange(Scalar end, TensorOptions options={});
TORCH_API Tensor arange(Scalar end, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory);
TORCH_API Tensor arange(Scalar start, Scalar end, TensorOptions options={});
TORCH_API Tensor arange(Scalar start, Scalar end, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory);
TORCH_API Tensor arange(Scalar start, Scalar end, Scalar step, TensorOptions options={});
TORCH_API Tensor arange(Scalar start, Scalar end, Scalar step, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory);
TORCH_API Tensor & arange_out(Tensor & out, Scalar end);
TORCH_API Tensor & arange_outf(Scalar end, Tensor & out);
TORCH_API Tensor & arange_out(Tensor & out, Scalar start, Scalar end, Scalar step=1);
TORCH_API Tensor & arange_outf(Scalar start, Scalar end, Scalar step, Tensor & out);
TORCH_API Tensor _dim_arange(const Tensor & like, int64_t dim);
TORCH_API Tensor argmax(const Tensor & self, c10::optional<int64_t> dim=c10::nullopt, bool keepdim=false);
TORCH_API Tensor & argmax_out(Tensor & out, const Tensor & self, c10::optional<int64_t> dim=c10::nullopt, bool keepdim=false);
TORCH_API Tensor & argmax_outf(const Tensor & self, c10::optional<int64_t> dim, bool keepdim, Tensor & out);
TORCH_API Tensor argmin(const Tensor & self, c10::optional<int64_t> dim=c10::nullopt, bool keepdim=false);
TORCH_API Tensor & argmin_out(Tensor & out, const Tensor & self, c10::optional<int64_t> dim=c10::nullopt, bool keepdim=false);
TORCH_API Tensor & argmin_outf(const Tensor & self, c10::optional<int64_t> dim, bool keepdim, Tensor & out);
TORCH_API Tensor acosh(const Tensor & self);
TORCH_API Tensor & acosh_(Tensor & self);
TORCH_API Tensor & acosh_out(Tensor & out, const Tensor & self);
TORCH_API Tensor & acosh_outf(const Tensor & self, Tensor & out);
TORCH_API Tensor arccosh(const Tensor & self);
TORCH_API Tensor & arccosh_(Tensor & self);
TORCH_API Tensor & arccosh_out(Tensor & out, const Tensor & self);
TORCH_API Tensor & arccosh_outf(const Tensor & self, Tensor & out);
TORCH_API Tensor asinh(const Tensor & self);
TORCH_API Tensor & asinh_(Tensor & self);
TORCH_API Tensor & asinh_out(Tensor & out, const Tensor & self);
TORCH_API Tensor & asinh_outf(const Tensor & self, Tensor & out);
TORCH_API Tensor arcsinh(const Tensor & self);
TORCH_API Tensor & arcsinh_(Tensor & self);
TORCH_API Tensor & arcsinh_out(Tensor & out, const Tensor & self);
TORCH_API Tensor & arcsinh_outf(const Tensor & self, Tensor & out);
TORCH_API Tensor atanh(const Tensor & self);
TORCH_API Tensor & atanh_(Tensor & self);
TORCH_API Tensor & atanh_out(Tensor & out, const Tensor & self);
TORCH_API Tensor & atanh_outf(const Tensor & self, Tensor & out);
TORCH_API Tensor arctanh(const Tensor & self);
TORCH_API Tensor & arctanh_(Tensor & self);
TORCH_API Tensor & arctanh_out(Tensor & out, const Tensor & self);
TORCH_API Tensor & arctanh_outf(const Tensor & self, Tensor & out);
TORCH_API Tensor as_strided(const Tensor & self, IntArrayRef size, IntArrayRef stride, c10::optional<int64_t> storage_offset=c10::nullopt);
TORCH_API Tensor & as_strided_(Tensor & self, IntArrayRef size, IntArrayRef stride, c10::optional<int64_t> storage_offset=c10::nullopt);
TORCH_API Tensor asin(const Tensor & self);
TORCH_API Tensor & asin_(Tensor & self);
TORCH_API Tensor & asin_out(Tensor & out, const Tensor & self);
TORCH_API Tensor & asin_outf(const Tensor & self, Tensor & out);
TORCH_API Tensor arcsin(const Tensor & self);
TORCH_API Tensor & arcsin_(Tensor & self);
TORCH_API Tensor & arcsin_out(Tensor & out, const Tensor & self);
TORCH_API Tensor & arcsin_outf(const Tensor & self, Tensor & out);
TORCH_API Tensor atan(const Tensor & self);
TORCH_API Tensor & atan_(Tensor & self);
TORCH_API Tensor & atan_out(Tensor & out, const Tensor & self);
TORCH_API Tensor & atan_outf(const Tensor & self, Tensor & out);
TORCH_API Tensor arctan(const Tensor & self);
TORCH_API Tensor & arctan_(Tensor & self);
TORCH_API Tensor & arctan_out(Tensor & out, const Tensor & self);
TORCH_API Tensor & arctan_outf(const Tensor & self, Tensor & out);
TORCH_API Tensor atleast_1d(const Tensor & self);
TORCH_API std::vector<Tensor> atleast_1d(TensorList tensors);
TORCH_API Tensor atleast_2d(const Tensor & self);
TORCH_API std::vector<Tensor> atleast_2d(TensorList tensors);
TORCH_API Tensor atleast_3d(const Tensor & self);
TORCH_API std::vector<Tensor> atleast_3d(TensorList tensors);
TORCH_API Tensor baddbmm(const Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta=1, Scalar alpha=1);
TORCH_API Tensor & _baddbmm_mkl_(Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta=1, Scalar alpha=1);
TORCH_API Tensor & baddbmm_out(Tensor & out, const Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta=1, Scalar alpha=1);
TORCH_API Tensor & baddbmm_outf(const Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta, Scalar alpha, Tensor & out);
TORCH_API Tensor bartlett_window(int64_t window_length, TensorOptions options={});
TORCH_API Tensor bartlett_window(int64_t window_length, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory);
TORCH_API Tensor bartlett_window(int64_t window_length, bool periodic, TensorOptions options={});
TORCH_API Tensor bartlett_window(int64_t window_length, bool periodic, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory);
TORCH_API Tensor batch_norm(const Tensor & input, const c10::optional<Tensor> & weight, const c10::optional<Tensor> & bias, const c10::optional<Tensor> & running_mean, const c10::optional<Tensor> & running_var, bool training, double momentum, double eps, bool cudnn_enabled);
TORCH_API Tensor quantized_batch_norm(const Tensor & input, const c10::optional<Tensor> & weight, const c10::optional<Tensor> & bias, const Tensor & mean, const Tensor & var, double eps, double output_scale, int64_t output_zero_point);
TORCH_API std::tuple<Tensor,Tensor,Tensor,Tensor,int64_t> _batch_norm_impl_index(const Tensor & input, const c10::optional<Tensor> & weight, const c10::optional<Tensor> & bias, const c10::optional<Tensor> & running_mean, const c10::optional<Tensor> & running_var, bool training, double momentum, double eps, bool cudnn_enabled);
TORCH_API std::tuple<Tensor,Tensor,Tensor> _batch_norm_impl_index_backward(int64_t impl_index, const Tensor & input, const Tensor & grad_output, const c10::optional<Tensor> & weight, const c10::optional<Tensor> & running_mean, const c10::optional<Tensor> & running_var, const c10::optional<Tensor> & save_mean, const c10::optional<Tensor> & save_var_transform, bool train, double eps, std::array<bool,3> output_mask, const Tensor & reservedSpace);
TORCH_API Tensor bernoulli(const Tensor & self, c10::optional<Generator> generator=c10::nullopt);
TORCH_API Tensor & bernoulli_out(Tensor & out, const Tensor & self, c10::optional<Generator> generator=c10::nullopt);
TORCH_API Tensor & bernoulli_outf(const Tensor & self, c10::optional<Generator> generator, Tensor & out);
TORCH_API Tensor bernoulli(const Tensor & self, double p, c10::optional<Generator> generator=c10::nullopt);
TORCH_API Tensor bilinear(const Tensor & input1, const Tensor & input2, const Tensor & weight, const c10::optional<Tensor> & bias);
TORCH_API Tensor binary_cross_entropy(const Tensor & self, const Tensor & target, const c10::optional<Tensor> & weight={}, int64_t reduction=at::Reduction::Mean);
TORCH_API Tensor & binary_cross_entropy_out(Tensor & out, const Tensor & self, const Tensor & target, const c10::optional<Tensor> & weight={}, int64_t reduction=at::Reduction::Mean);
TORCH_API Tensor & binary_cross_entropy_outf(const Tensor & self, const Tensor & target, const c10::optional<Tensor> & weight, int64_t reduction, Tensor & out);
TORCH_API Tensor binary_cross_entropy_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, const c10::optional<Tensor> & weight={}, int64_t reduction=at::Reduction::Mean);
TORCH_API Tensor & binary_cross_entropy_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, const c10::optional<Tensor> & weight={}, int64_t reduction=at::Reduction::Mean);
TORCH_API Tensor & binary_cross_entropy_backward_outf(const Tensor & grad_output, const Tensor & self, const Tensor & target, const c10::optional<Tensor> & weight, int64_t reduction, Tensor & grad_input);
TORCH_API Tensor binary_cross_entropy_with_logits(const Tensor & self, const Tensor & target, const c10::optional<Tensor> & weight={}, const c10::optional<Tensor> & pos_weight={}, int64_t reduction=at::Reduction::Mean);
TORCH_API Tensor binary_cross_entropy_with_logits_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, const c10::optional<Tensor> & weight={}, const c10::optional<Tensor> & pos_weight={}, int64_t reduction=at::Reduction::Mean);
TORCH_API Tensor bincount(const Tensor & self, const c10::optional<Tensor> & weights={}, int64_t minlength=0);
TORCH_API Tensor bitwise_not(const Tensor & self);
TORCH_API Tensor & bitwise_not_out(Tensor & out, const Tensor & self);
TORCH_API Tensor & bitwise_not_outf(const Tensor & self, Tensor & out);
TORCH_API Tensor copysign(const Tensor & self, const Tensor & other);
TORCH_API Tensor & copysign_out(Tensor & out, const Tensor & self, const Tensor & other);
TORCH_API Tensor & copysign_outf(const Tensor & self, const Tensor & other, Tensor & out);
TORCH_API Tensor copysign(const Tensor & self, Scalar other);
TORCH_API Tensor logical_not(const Tensor & self);
TORCH_API Tensor & logical_not_out(Tensor & out, const Tensor & self);
TORCH_API Tensor & logical_not_outf(const Tensor & self, Tensor & out);
TORCH_API Tensor logical_xor(const Tensor & self, const Tensor & other);
TORCH_API Tensor & logical_xor_out(Tensor & out, const Tensor & self, const Tensor & other);
TORCH_API Tensor & logical_xor_outf(const Tensor & self, const Tensor & other, Tensor & out);
TORCH_API Tensor logical_and(const Tensor & self, const Tensor & other);
TORCH_API Tensor & logical_and_out(Tensor & out, const Tensor & self, const Tensor & other);
TORCH_API Tensor & logical_and_outf(const Tensor & self, const Tensor & other, Tensor & out);
TORCH_API Tensor logical_or(const Tensor & self, const Tensor & other);
TORCH_API Tensor & logical_or_out(Tensor & out, const Tensor & self, const Tensor & other);
TORCH_API Tensor & logical_or_outf(const Tensor & self, const Tensor & other, Tensor & out);
TORCH_API Tensor blackman_window(int64_t window_length, TensorOptions options={});
TORCH_API Tensor blackman_window(int64_t window_length, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory);
TORCH_API Tensor blackman_window(int64_t window_length, bool periodic, TensorOptions options={});
TORCH_API Tensor blackman_window(int64_t window_length, bool periodic, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory);
TORCH_API Tensor bmm(const Tensor & self, const Tensor & mat2);
TORCH_API Tensor _bmm(const Tensor & self, const Tensor & mat2, bool deterministic=false);
TORCH_API Tensor & bmm_out(Tensor & out, const Tensor & self, const Tensor & mat2);
TORCH_API Tensor & bmm_outf(const Tensor & self, const Tensor & mat2, Tensor & out);
TORCH_API Tensor & _bmm_out(Tensor & out, const Tensor & self, const Tensor & mat2, bool deterministic=false);
TORCH_API Tensor & _bmm_outf(const Tensor & self, const Tensor & mat2, bool deterministic, Tensor & out);
TORCH_API std::vector<Tensor> broadcast_tensors(TensorList tensors);
TORCH_API Tensor broadcast_to(const Tensor & self, IntArrayRef size);
TORCH_API Tensor cat(TensorList tensors, int64_t dim=0);
TORCH_API Tensor & cat_out(Tensor & out, TensorList tensors, int64_t dim=0);
TORCH_API Tensor & cat_outf(TensorList tensors, int64_t dim, Tensor & out);
TORCH_API Tensor cat(TensorList tensors, Dimname dim);
TORCH_API Tensor & cat_out(Tensor & out, TensorList tensors, Dimname dim);
TORCH_API Tensor & cat_outf(TensorList tensors, Dimname dim, Tensor & out);
TORCH_API Tensor block_diag(TensorList tensors);
TORCH_API Tensor ceil(const Tensor & self);
TORCH_API Tensor & ceil_(Tensor & self);
TORCH_API Tensor & ceil_out(Tensor & out, const Tensor & self);
TORCH_API Tensor & ceil_outf(const Tensor & self, Tensor & out);
TORCH_API Tensor chain_matmul(TensorList matrices);
TORCH_API std::vector<Tensor> unsafe_chunk(const Tensor & self, int64_t chunks, int64_t dim=0);
TORCH_API std::vector<Tensor> chunk(const Tensor & self, int64_t chunks, int64_t dim=0);
TORCH_API std::vector<Tensor> tensor_split(const Tensor & self, int64_t sections, int64_t dim=0);
TORCH_API std::vector<Tensor> tensor_split(const Tensor & self, IntArrayRef indices, int64_t dim=0);
TORCH_API std::vector<Tensor> tensor_split(const Tensor & self, const Tensor & tensor_indices_or_sections, int64_t dim=0);
TORCH_API Tensor clamp(const Tensor & self, c10::optional<Scalar> min=c10::nullopt, c10::optional<Scalar> max=c10::nullopt);
TORCH_API Tensor & clamp_(Tensor & self, c10::optional<Scalar> min=c10::nullopt, c10::optional<Scalar> max=c10::nullopt);
TORCH_API Tensor & clamp_out(Tensor & out, const Tensor & self, c10::optional<Scalar> min=c10::nullopt, c10::optional<Scalar> max=c10::nullopt);
TORCH_API Tensor & clamp_outf(const Tensor & self, c10::optional<Scalar> min, c10::optional<Scalar> max, Tensor & out);
TORCH_API Tensor clamp_max(const Tensor & self, Scalar max);
TORCH_API Tensor & clamp_max_(Tensor & self, Scalar max);
TORCH_API Tensor & clamp_max_out(Tensor & out, const Tensor & self, Scalar max);
TORCH_API Tensor & clamp_max_outf(const Tensor & self, Scalar max, Tensor & out);
TORCH_API Tensor clamp_min(const Tensor & self, Scalar min);
TORCH_API Tensor & clamp_min_(Tensor & self, Scalar min);
TORCH_API Tensor & clamp_min_out(Tensor & out, const Tensor & self, Scalar min);
TORCH_API Tensor & clamp_min_outf(const Tensor & self, Scalar min, Tensor & out);
TORCH_API Tensor clip(const Tensor & self, c10::optional<Scalar> min=c10::nullopt, c10::optional<Scalar> max=c10::nullopt);
TORCH_API Tensor & clip_(Tensor & self, c10::optional<Scalar> min=c10::nullopt, c10::optional<Scalar> max=c10::nullopt);
TORCH_API Tensor & clip_out(Tensor & out, const Tensor & self, c10::optional<Scalar> min=c10::nullopt, c10::optional<Scalar> max=c10::nullopt);
TORCH_API Tensor & clip_outf(const Tensor & self, c10::optional<Scalar> min, c10::optional<Scalar> max, Tensor & out);
TORCH_API bool cudnn_is_acceptable(const Tensor & self);
TORCH_API Tensor complex(const Tensor & real, const Tensor & imag);
TORCH_API Tensor & complex_out(Tensor & out, const Tensor & real, const Tensor & imag);
TORCH_API Tensor & complex_outf(const Tensor & real, const Tensor & imag, Tensor & out);
TORCH_API Tensor polar(const Tensor & abs, const Tensor & angle);
TORCH_API Tensor & polar_out(Tensor & out, const Tensor & abs, const Tensor & angle);
TORCH_API Tensor & polar_outf(const Tensor & abs, const Tensor & angle, Tensor & out);
TORCH_API Tensor constant_pad_nd(const Tensor & self, IntArrayRef pad, Scalar value=0);
TORCH_API Tensor convolution(const Tensor & input, const Tensor & weight, const c10::optional<Tensor> & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool transposed, IntArrayRef output_padding, int64_t groups);
TORCH_API Tensor convolution_overrideable(const Tensor & input, const Tensor & weight, const c10::optional<Tensor> & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool transposed, IntArrayRef output_padding, int64_t groups);
TORCH_API std::tuple<Tensor,Tensor,Tensor> convolution_backward_overrideable(const Tensor & grad_output, const Tensor & input, const Tensor & weight, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool transposed, IntArrayRef output_padding, int64_t groups, std::array<bool,3> output_mask);
TORCH_API Tensor _convolution(const Tensor & input, const Tensor & weight, const c10::optional<Tensor> & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool transposed, IntArrayRef output_padding, int64_t groups, bool benchmark, bool deterministic, bool cudnn_enabled, bool allow_tf32);
TORCH_API Tensor _convolution(const Tensor & input, const Tensor & weight, const c10::optional<Tensor> & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool transposed, IntArrayRef output_padding, int64_t groups, bool benchmark, bool deterministic, bool cudnn_enabled);
TORCH_API Tensor _convolution_nogroup(const Tensor & input, const Tensor & weight, const c10::optional<Tensor> & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool transposed, IntArrayRef output_padding);
TORCH_API std::tuple<Tensor,Tensor,Tensor> _convolution_double_backward(const c10::optional<Tensor> & ggI, const c10::optional<Tensor> & ggW, const c10::optional<Tensor> & ggb, const Tensor & gO, const Tensor & weight, const Tensor & self, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool transposed, IntArrayRef output_padding, int64_t groups, bool benchmark, bool deterministic, bool cudnn_enabled, bool allow_tf32, std::array<bool,3> output_mask);
TORCH_API Tensor conv1d(const Tensor & input, const Tensor & weight, const c10::optional<Tensor> & bias={}, IntArrayRef stride=1, IntArrayRef padding=0, IntArrayRef dilation=1, int64_t groups=1);
TORCH_API Tensor conv2d(const Tensor & input, const Tensor & weight, const c10::optional<Tensor> & bias={}, IntArrayRef stride=1, IntArrayRef padding=0, IntArrayRef dilation=1, int64_t groups=1);
TORCH_API Tensor conv3d(const Tensor & input, const Tensor & weight, const c10::optional<Tensor> & bias={}, IntArrayRef stride=1, IntArrayRef padding=0, IntArrayRef dilation=1, int64_t groups=1);
TORCH_API Tensor conv_tbc(const Tensor & self, const Tensor & weight, const Tensor & bias, int64_t pad=0);
TORCH_API std::tuple<Tensor,Tensor,Tensor> conv_tbc_backward(const Tensor & self, const Tensor & input, const Tensor & weight, const Tensor & bias, int64_t pad);
TORCH_API Tensor conv_transpose1d(const Tensor & input, const Tensor & weight, const c10::optional<Tensor> & bias={}, IntArrayRef stride=1, IntArrayRef padding=0, IntArrayRef output_padding=0, int64_t groups=1, IntArrayRef dilation=1);
TORCH_API Tensor conv_transpose2d(const Tensor & input, const Tensor & weight, const c10::optional<Tensor> & bias={}, IntArrayRef stride=1, IntArrayRef padding=0, IntArrayRef output_padding=0, int64_t groups=1, IntArrayRef dilation=1);
TORCH_API Tensor conv_transpose3d(const Tensor & input, const Tensor & weight, const c10::optional<Tensor> & bias={}, IntArrayRef stride=1, IntArrayRef padding=0, IntArrayRef output_padding=0, int64_t groups=1, IntArrayRef dilation=1);
TORCH_API Tensor _copy_from(const Tensor & self, const Tensor & dst, bool non_blocking=false);
TORCH_API Tensor cos(const Tensor & self);
TORCH_API Tensor & cos_(Tensor & self);
TORCH_API Tensor & cos_out(Tensor & out, const Tensor & self);
TORCH_API Tensor & cos_outf(const Tensor & self, Tensor & out);
TORCH_API Tensor cosh(const Tensor & self);
TORCH_API Tensor & cosh_(Tensor & self);
TORCH_API Tensor & cosh_out(Tensor & out, const Tensor & self);
TORCH_API Tensor & cosh_outf(const Tensor & self, Tensor & out);
TORCH_API Tensor cosine_embedding_loss(const Tensor & input1, const Tensor & input2, const Tensor & target, double margin=0.0, int64_t reduction=at::Reduction::Mean);
TORCH_API Tensor count_nonzero(const Tensor & self, IntArrayRef dim);
TORCH_API Tensor count_nonzero(const Tensor & self, c10::optional<int64_t> dim=c10::nullopt);
TORCH_API Tensor cudnn_affine_grid_generator(const Tensor & theta, int64_t N, int64_t C, int64_t H, int64_t W);
TORCH_API Tensor cudnn_affine_grid_generator_backward(const Tensor & grad, int64_t N, int64_t C, int64_t H, int64_t W);
TORCH_API std::tuple<Tensor,Tensor,Tensor,Tensor> cudnn_batch_norm(const Tensor & input, const Tensor & weight, const c10::optional<Tensor> & bias, const c10::optional<Tensor> & running_mean, const c10::optional<Tensor> & running_var, bool training, double exponential_average_factor, double epsilon);
TORCH_API std::tuple<Tensor,Tensor,Tensor> cudnn_batch_norm_backward(const Tensor & input, const Tensor & grad_output, const Tensor & weight, const c10::optional<Tensor> & running_mean, const c10::optional<Tensor> & running_var, const c10::optional<Tensor> & save_mean, const c10::optional<Tensor> & save_var, double epsilon, const Tensor & reserveSpace);
TORCH_API Tensor cudnn_convolution(const Tensor & self, const Tensor & weight, const c10::optional<Tensor> & bias, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic);
TORCH_API Tensor cudnn_convolution(const Tensor & self, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic);
TORCH_API Tensor cudnn_convolution(const Tensor & self, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic, bool allow_tf32);
TORCH_API Tensor cudnn_convolution_backward_input(IntArrayRef self_size, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic, bool allow_tf32);
TORCH_API std::tuple<Tensor,Tensor> cudnn_convolution_backward(const Tensor & self, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic, bool allow_tf32, std::array<bool,2> output_mask);
TORCH_API Tensor cudnn_convolution_backward_weight(IntArrayRef weight_size, const Tensor & grad_output, const Tensor & self, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic, bool allow_tf32);
TORCH_API Tensor cudnn_convolution_transpose(const Tensor & self, const Tensor & weight, const c10::optional<Tensor> & bias, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic);
TORCH_API Tensor cudnn_convolution_transpose(const Tensor & self, const Tensor & weight, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic);
TORCH_API Tensor cudnn_convolution_transpose(const Tensor & self, const Tensor & weight, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic, bool allow_tf32);
TORCH_API std::tuple<Tensor,Tensor> cudnn_convolution_transpose_backward(const Tensor & self, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic, bool allow_tf32, std::array<bool,2> output_mask);
TORCH_API Tensor cudnn_convolution_transpose_backward_input(const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic, bool allow_tf32);
TORCH_API Tensor cudnn_convolution_transpose_backward_weight(IntArrayRef weight_size, const Tensor & grad_output, const Tensor & self, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic, bool allow_tf32);
TORCH_API Tensor cudnn_grid_sampler(const Tensor & self, const Tensor & grid);
TORCH_API std::tuple<Tensor,Tensor> cudnn_grid_sampler_backward(const Tensor & self, const Tensor & grid, const Tensor & grad_output);
TORCH_API std::tuple<Tensor,Tensor> cummax(const Tensor & self, int64_t dim);
TORCH_API std::tuple<Tensor &,Tensor &> cummax_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t dim);
TORCH_API std::tuple<Tensor &,Tensor &> cummax_outf(const Tensor & self, int64_t dim, Tensor & values, Tensor & indices);
TORCH_API std::tuple<Tensor,Tensor> cummax(const Tensor & self, Dimname dim);
TORCH_API std::tuple<Tensor &,Tensor &> cummax_out(Tensor & values, Tensor & indices, const Tensor & self, Dimname dim);
TORCH_API std::tuple<Tensor &,Tensor &> cummax_outf(const Tensor & self, Dimname dim, Tensor & values, Tensor & indices);
TORCH_API void _cummax_helper(const Tensor & self, Tensor & values, Tensor & indices, int64_t dim);
TORCH_API std::tuple<Tensor,Tensor> cummin(const Tensor & self, int64_t dim);
TORCH_API std::tuple<Tensor &,Tensor &> cummin_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t dim);
TORCH_API std::tuple<Tensor &,Tensor &> cummin_outf(const Tensor & self, int64_t dim, Tensor & values, Tensor & indices);
TORCH_API std::tuple<Tensor,Tensor> cummin(const Tensor & self, Dimname dim);
TORCH_API std::tuple<Tensor &,Tensor &> cummin_out(Tensor & values, Tensor & indices, const Tensor & self, Dimname dim);
TORCH_API std::tuple<Tensor &,Tensor &> cummin_outf(const Tensor & self, Dimname dim, Tensor & values, Tensor & indices);
TORCH_API void _cummin_helper(const Tensor & self, Tensor & values, Tensor & indices, int64_t dim);
TORCH_API Tensor cummaxmin_backward(const Tensor & grad, const Tensor & input, const Tensor & indices, int64_t dim);
TORCH_API Tensor cumprod(const Tensor & self, int64_t dim, c10::optional<ScalarType> dtype=c10::nullopt);
TORCH_API Tensor & cumprod_out(Tensor & out, const Tensor & self, int64_t dim, c10::optional<ScalarType> dtype=c10::nullopt);
TORCH_API Tensor & cumprod_outf(const Tensor & self, int64_t dim, c10::optional<ScalarType> dtype, Tensor & out);
TORCH_API Tensor cumprod(const Tensor & self, Dimname dim, c10::optional<ScalarType> dtype=c10::nullopt);
TORCH_API Tensor & cumprod_out(Tensor & out, const Tensor & self, Dimname dim, c10::optional<ScalarType> dtype=c10::nullopt);
TORCH_API Tensor & cumprod_outf(const Tensor & self, Dimname dim, c10::optional<ScalarType> dtype, Tensor & out);
TORCH_API Tensor cumprod_backward(const Tensor & grad, const Tensor & input, int64_t dim);
TORCH_API Tensor cumsum(const Tensor & self, int64_t dim, c10::optional<ScalarType> dtype=c10::nullopt);
TORCH_API Tensor & cumsum_out(Tensor & out, const Tensor & self, int64_t dim, c10::optional<ScalarType> dtype=c10::nullopt);
TORCH_API Tensor & cumsum_outf(const Tensor & self, int64_t dim, c10::optional<ScalarType> dtype, Tensor & out);
TORCH_API Tensor cumsum(const Tensor & self, Dimname dim, c10::optional<ScalarType> dtype=c10::nullopt);
TORCH_API Tensor & cumsum_out(Tensor & out, const Tensor & self, Dimname dim, c10::optional<ScalarType> dtype=c10::nullopt);
TORCH_API Tensor & cumsum_outf(const Tensor & self, Dimname dim, c10::optional<ScalarType> dtype, Tensor & out);
TORCH_API Tensor ctc_loss(const Tensor & log_probs, const Tensor & targets, IntArrayRef input_lengths, IntArrayRef target_lengths, int64_t blank=0, int64_t reduction=at::Reduction::Mean, bool zero_infinity=false);
TORCH_API Tensor ctc_loss(const Tensor & log_probs, const Tensor & targets, const Tensor & input_lengths, const Tensor & target_lengths, int64_t blank=0, int64_t reduction=at::Reduction::Mean, bool zero_infinity=false);
TORCH_API std::tuple<Tensor,Tensor> _ctc_loss(const Tensor & log_probs, const Tensor & targets, IntArrayRef input_lengths, IntArrayRef target_lengths, int64_t blank=0, bool zero_infinity=false);
TORCH_API Tensor _ctc_loss_backward(const Tensor & grad, const Tensor & log_probs, const Tensor & targets, IntArrayRef input_lengths, IntArrayRef target_lengths, const Tensor & neg_log_likelihood, const Tensor & log_alpha, int64_t blank, bool zero_infinity=false);
TORCH_API Tensor diag_embed(const Tensor & self, int64_t offset=0, int64_t dim1=-2, int64_t dim2=-1);
TORCH_API Tensor diagflat(const Tensor & self, int64_t offset=0);
TORCH_API Tensor diagonal(const Tensor & self, int64_t offset=0, int64_t dim1=0, int64_t dim2=1);
TORCH_API Tensor diagonal(const Tensor & self, Dimname outdim, Dimname dim1, Dimname dim2, int64_t offset=0);
TORCH_API Tensor diagonal_backward(const Tensor & grad, IntArrayRef input_sizes, int64_t offset, int64_t dim1, int64_t dim2);
TORCH_API Tensor diff(const Tensor & self, int64_t n=1, int64_t dim=-1, const c10::optional<Tensor> & prepend={}, const c10::optional<Tensor> & append={});
TORCH_API Tensor & diff_out(Tensor & out, const Tensor & self, int64_t n=1, int64_t dim=-1, const c10::optional<Tensor> & prepend={}, const c10::optional<Tensor> & append={});
TORCH_API Tensor & diff_outf(const Tensor & self, int64_t n, int64_t dim, const c10::optional<Tensor> & prepend, const c10::optional<Tensor> & append, Tensor & out);
TORCH_API Tensor div(const Tensor & self, const Tensor & other);
TORCH_API Tensor & div_out(Tensor & out, const Tensor & self, const Tensor & other);
TORCH_API Tensor & div_outf(const Tensor & self, const Tensor & other, Tensor & out);
TORCH_API Tensor div(const Tensor & self, const Tensor & other, std::string rounding_mode);
TORCH_API Tensor & div_out(Tensor & out, const Tensor & self, const Tensor & other, std::string rounding_mode);
TORCH_API Tensor & div_outf(const Tensor & self, const Tensor & other, std::string rounding_mode, Tensor & out);
TORCH_API Tensor div(const Tensor & self, Scalar other);
TORCH_API Tensor div(const Tensor & self, Scalar other, std::string rounding_mode);
TORCH_API Tensor divide(const Tensor & self, const Tensor & other);
TORCH_API Tensor & divide_out(Tensor & out, const Tensor & self, const Tensor & other);
TORCH_API Tensor & divide_outf(const Tensor & self, const Tensor & other, Tensor & out);
TORCH_API Tensor divide(const Tensor & self, Scalar other);
TORCH_API Tensor divide(const Tensor & self, const Tensor & other, std::string rounding_mode);
TORCH_API Tensor & divide_out(Tensor & out, const Tensor & self, const Tensor & other, std::string rounding_mode);
TORCH_API Tensor & divide_outf(const Tensor & self, const Tensor & other, std::string rounding_mode, Tensor & out);
TORCH_API Tensor divide(const Tensor & self, Scalar other, std::string rounding_mode);
TORCH_API Tensor true_divide(const Tensor & self, const Tensor & other);
TORCH_API Tensor & true_divide_out(Tensor & out, const Tensor & self, const Tensor & other);
TORCH_API Tensor & true_divide_outf(const Tensor & self, const Tensor & other, Tensor & out);
TORCH_API Tensor true_divide(const Tensor & self, Scalar other);
TORCH_API Tensor dot(const Tensor & self, const Tensor & tensor);
TORCH_API Tensor & dot_out(Tensor & out, const Tensor & self, const Tensor & tensor);
TORCH_API Tensor & dot_outf(const Tensor & self, const Tensor & tensor, Tensor & out);
TORCH_API Tensor vdot(const Tensor & self, const Tensor & other);
TORCH_API Tensor & vdot_out(Tensor & out, const Tensor & self, const Tensor & other);
TORCH_API Tensor & vdot_outf(const Tensor & self, const Tensor & other, Tensor & out);
TORCH_API Tensor einsum(std::string equation, TensorList tensors);
TORCH_API Tensor embedding(const Tensor & weight, const Tensor & indices, int64_t padding_idx=-1, bool scale_grad_by_freq=false, bool sparse=false);
TORCH_API Tensor embedding_backward(const Tensor & grad, const Tensor & indices, int64_t num_weights, int64_t padding_idx, bool scale_grad_by_freq, bool sparse);
TORCH_API Tensor embedding_dense_backward(const Tensor & grad_output, const Tensor & indices, int64_t num_weights, int64_t padding_idx, bool scale_grad_by_freq);
TORCH_API Tensor & embedding_renorm_(Tensor & self, const Tensor & indices, double max_norm, double norm_type);
TORCH_API Tensor embedding_sparse_backward(const Tensor & grad, const Tensor & indices, int64_t num_weights, int64_t padding_idx, bool scale_grad_by_freq);
TORCH_API std::tuple<Tensor,Tensor,Tensor,Tensor> _embedding_bag_forward_only(const Tensor & weight, const Tensor & indices, const Tensor & offsets, bool scale_grad_by_freq=false, int64_t mode=0, bool sparse=false, const c10::optional<Tensor> & per_sample_weights={}, bool include_last_offset=false);
TORCH_API std::tuple<Tensor,Tensor> _rowwise_prune(const Tensor & weight, const Tensor & mask, ScalarType compressed_indices_dtype);
TORCH_API Tensor row_stack(TensorList tensors);
TORCH_API Tensor & row_stack_out(Tensor & out, TensorList tensors);
TORCH_API Tensor & row_stack_outf(TensorList tensors, Tensor & out);
TORCH_API std::tuple<Tensor,Tensor,Tensor,Tensor> embedding_bag(const Tensor & weight, const Tensor & indices, const Tensor & offsets, bool scale_grad_by_freq=false, int64_t mode=0, bool sparse=false, const c10::optional<Tensor> & per_sample_weights={}, bool include_last_offset=false);
TORCH_API std::tuple<Tensor,Tensor,Tensor,Tensor> _embedding_bag(const Tensor & weight, const Tensor & indices, const Tensor & offsets, bool scale_grad_by_freq=false, int64_t mode=0, bool sparse=false, const c10::optional<Tensor> & per_sample_weights={}, bool include_last_offset=false);
TORCH_API Tensor _embedding_bag_backward(const Tensor & grad, const Tensor & indices, const Tensor & offsets, const Tensor & offset2bag, const Tensor & bag_size, const Tensor & maximum_indices, int64_t num_weights, bool scale_grad_by_freq, int64_t mode, bool sparse, const c10::optional<Tensor> & per_sample_weights);
TORCH_API Tensor _embedding_bag_sparse_backward(const Tensor & grad, const Tensor & indices, const Tensor & offsets, const Tensor & offset2bag, const Tensor & bag_size, int64_t num_weights, bool scale_grad_by_freq, int64_t mode, const c10::optional<Tensor> & per_sample_weights);
TORCH_API Tensor _embedding_bag_dense_backward(const Tensor & grad, const Tensor & indices, const Tensor & offsets, const Tensor & offset2bag, const Tensor & bag_size, const Tensor & maximum_indices, int64_t num_weights, bool scale_grad_by_freq, int64_t mode, const c10::optional<Tensor> & per_sample_weights);
TORCH_API Tensor _embedding_bag_per_sample_weights_backward(const Tensor & grad, const Tensor & weight, const Tensor & indices, const Tensor & offsets, const Tensor & offset2bag, int64_t mode);
TORCH_API Tensor empty_meta(IntArrayRef size, TensorOptions options={}, c10::optional<MemoryFormat> memory_format=c10::nullopt);
TORCH_API Tensor empty_meta(IntArrayRef size, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory, c10::optional<MemoryFormat> memory_format);
TORCH_API Tensor empty(IntArrayRef size, c10::optional<DimnameList> names, TensorOptions options={}, c10::optional<MemoryFormat> memory_format=c10::nullopt);
TORCH_API Tensor empty(IntArrayRef size, c10::optional<DimnameList> names, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory, c10::optional<MemoryFormat> memory_format);
TORCH_API Tensor empty(IntArrayRef size, TensorOptions options={}, c10::optional<MemoryFormat> memory_format=c10::nullopt);
TORCH_API Tensor empty(IntArrayRef size, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory, c10::optional<MemoryFormat> memory_format);
TORCH_API Tensor _empty_affine_quantized(IntArrayRef size, TensorOptions options={}, double scale=1, int64_t zero_point=0, c10::optional<MemoryFormat> memory_format=MemoryFormat::Contiguous);
TORCH_API Tensor _empty_affine_quantized(IntArrayRef size, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory, double scale, int64_t zero_point, c10::optional<MemoryFormat> memory_format);
TORCH_API Tensor _empty_per_channel_affine_quantized(IntArrayRef size, const Tensor & scales, const Tensor & zero_points, int64_t axis, TensorOptions options={}, c10::optional<MemoryFormat> memory_format=MemoryFormat::Contiguous);
TORCH_API Tensor _empty_per_channel_affine_quantized(IntArrayRef size, const Tensor & scales, const Tensor & zero_points, int64_t axis, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory, c10::optional<MemoryFormat> memory_format);
TORCH_API Tensor empty_quantized(IntArrayRef size, const Tensor & qtensor);
TORCH_API Tensor & empty_out(Tensor & out, IntArrayRef size, c10::optional<MemoryFormat> memory_format=c10::nullopt);
TORCH_API Tensor & empty_outf(IntArrayRef size, c10::optional<MemoryFormat> memory_format, Tensor & out);
TORCH_API Tensor empty_like(const Tensor & self, TensorOptions options={}, c10::optional<MemoryFormat> memory_format=c10::nullopt);
TORCH_API Tensor empty_like(const Tensor & self, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory, c10::optional<MemoryFormat> memory_format);
TORCH_API Tensor empty_strided(IntArrayRef size, IntArrayRef stride, TensorOptions options={});
TORCH_API Tensor empty_strided(IntArrayRef size, IntArrayRef stride, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory);
TORCH_API Tensor erf(const Tensor & self);
TORCH_API Tensor & erf_(Tensor & self);
TORCH_API Tensor & erf_out(Tensor & out, const Tensor & self);
TORCH_API Tensor & erf_outf(const Tensor & self, Tensor & out);
TORCH_API Tensor erfc(const Tensor & self);
TORCH_API Tensor & erfc_(Tensor & self);
TORCH_API Tensor & erfc_out(Tensor & out, const Tensor & self);
TORCH_API Tensor & erfc_outf(const Tensor & self, Tensor & out);
TORCH_API Tensor exp(const Tensor & self);
TORCH_API Tensor & exp_(Tensor & self);
TORCH_API Tensor & exp_out(Tensor & out, const Tensor & self);
TORCH_API Tensor & exp_outf(const Tensor & self, Tensor & out);
TORCH_API Tensor exp2(const Tensor & self);
TORCH_API Tensor & exp2_(Tensor & self);
TORCH_API Tensor & exp2_out(Tensor & out, const Tensor & self);
TORCH_API Tensor & exp2_outf(const Tensor & self, Tensor & out);
TORCH_API Tensor expm1(const Tensor & self);
TORCH_API Tensor & expm1_(Tensor & self);
TORCH_API Tensor & expm1_out(Tensor & out, const Tensor & self);
TORCH_API Tensor & expm1_outf(const Tensor & self, Tensor & out);
TORCH_API Tensor eye(int64_t n, TensorOptions options={});
TORCH_API Tensor eye(int64_t n, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory);
TORCH_API Tensor eye(int64_t n, int64_t m, TensorOptions options={});
TORCH_API Tensor eye(int64_t n, int64_t m, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory);
TORCH_API Tensor & eye_out(Tensor & out, int64_t n);
TORCH_API Tensor & eye_outf(int64_t n, Tensor & out);
TORCH_API Tensor & eye_out(Tensor & out, int64_t n, int64_t m);
TORCH_API Tensor & eye_outf(int64_t n, int64_t m, Tensor & out);
TORCH_API Tensor flatten(const Tensor & self, int64_t start_dim=0, int64_t end_dim=-1);
TORCH_API Tensor flatten(const Tensor & self, int64_t start_dim, int64_t end_dim, Dimname out_dim);
TORCH_API Tensor flatten(const Tensor & self, Dimname start_dim, Dimname end_dim, Dimname out_dim);
TORCH_API Tensor flatten(const Tensor & self, DimnameList dims, Dimname out_dim);
TORCH_API Tensor & fill_(Tensor & self, Scalar value);
TORCH_API Tensor & fill_(Tensor & self, const Tensor & value);
TORCH_API Tensor floor(const Tensor & self);
TORCH_API Tensor & floor_(Tensor & self);
TORCH_API Tensor & floor_out(Tensor & out, const Tensor & self);
TORCH_API Tensor & floor_outf(const Tensor & self, Tensor & out);
TORCH_API Tensor floor_divide(const Tensor & self, const Tensor & other);
TORCH_API Tensor & floor_divide_out(Tensor & out, const Tensor & self, const Tensor & other);
TORCH_API Tensor & floor_divide_outf(const Tensor & self, const Tensor & other, Tensor & out);
TORCH_API Tensor floor_divide(const Tensor & self, Scalar other);
TORCH_API Tensor frac(const Tensor & self);
TORCH_API Tensor & frac_(Tensor & self);
TORCH_API Tensor & frac_out(Tensor & out, const Tensor & self);
TORCH_API Tensor & frac_outf(const Tensor & self, Tensor & out);
TORCH_API Tensor full(IntArrayRef size, Scalar fill_value, c10::optional<DimnameList> names, TensorOptions options={});
TORCH_API Tensor full(IntArrayRef size, Scalar fill_value, c10::optional<DimnameList> names, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory);
TORCH_API Tensor full(IntArrayRef size, Scalar fill_value, TensorOptions options={});
TORCH_API Tensor full(IntArrayRef size, Scalar fill_value, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory);
TORCH_API Tensor & full_out(Tensor & out, IntArrayRef size, Scalar fill_value);
TORCH_API Tensor & full_outf(IntArrayRef size, Scalar fill_value, Tensor & out);
TORCH_API Tensor full_like(const Tensor & self, Scalar fill_value, TensorOptions options={}, c10::optional<MemoryFormat> memory_format=c10::nullopt);
TORCH_API Tensor full_like(const Tensor & self, Scalar fill_value, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory, c10::optional<MemoryFormat> memory_format);
TORCH_API Tensor from_file(std::string filename, c10::optional<bool> shared=c10::nullopt, c10::optional<int64_t> size=0, TensorOptions options={});
TORCH_API Tensor from_file(std::string filename, c10::optional<bool> shared, c10::optional<int64_t> size, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory);
TORCH_API Tensor & gcd_out(Tensor & out, const Tensor & self, const Tensor & other);
TORCH_API Tensor & gcd_outf(const Tensor & self, const Tensor & other, Tensor & out);
TORCH_API Tensor gcd(const Tensor & self, const Tensor & other);
TORCH_API Tensor & gcd_(Tensor & self, const Tensor & other);
TORCH_API Tensor & lcm_out(Tensor & out, const Tensor & self, const Tensor & other);
TORCH_API Tensor & lcm_outf(const Tensor & self, const Tensor & other, Tensor & out);
TORCH_API Tensor lcm(const Tensor & self, const Tensor & other);
TORCH_API Tensor & lcm_(Tensor & self, const Tensor & other);
TORCH_API Tensor grid_sampler(const Tensor & input, const Tensor & grid, int64_t interpolation_mode, int64_t padding_mode, bool align_corners);
TORCH_API Tensor grid_sampler_2d(const Tensor & input, const Tensor & grid, int64_t interpolation_mode, int64_t padding_mode, bool align_corners);
TORCH_API std::tuple<Tensor,Tensor> grid_sampler_2d_backward(const Tensor & grad_output, const Tensor & input, const Tensor & grid, int64_t interpolation_mode, int64_t padding_mode, bool align_corners);
TORCH_API Tensor _grid_sampler_2d_cpu_fallback(const Tensor & input, const Tensor & grid, int64_t interpolation_mode, int64_t padding_mode, bool align_corners);
TORCH_API std::tuple<Tensor,Tensor> _grid_sampler_2d_cpu_fallback_backward(const Tensor & grad_output, const Tensor & input, const Tensor & grid, int64_t interpolation_mode, int64_t padding_mode, bool align_corners);
TORCH_API Tensor grid_sampler_3d(const Tensor & input, const Tensor & grid, int64_t interpolation_mode, int64_t padding_mode, bool align_corners);
TORCH_API std::tuple<Tensor,Tensor> grid_sampler_3d_backward(const Tensor & grad_output, const Tensor & input, const Tensor & grid, int64_t interpolation_mode, int64_t padding_mode, bool align_corners);
TORCH_API Tensor hann_window(int64_t window_length, TensorOptions options={});
TORCH_API Tensor hann_window(int64_t window_length, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory);
TORCH_API Tensor hann_window(int64_t window_length, bool periodic, TensorOptions options={});
TORCH_API Tensor hann_window(int64_t window_length, bool periodic, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory);
TORCH_API Tensor hamming_window(int64_t window_length, TensorOptions options={});
TORCH_API Tensor hamming_window(int64_t window_length, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory);
TORCH_API Tensor hamming_window(int64_t window_length, bool periodic, TensorOptions options={});
TORCH_API Tensor hamming_window(int64_t window_length, bool periodic, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory);
TORCH_API Tensor hamming_window(int64_t window_length, bool periodic, double alpha, TensorOptions options={});
TORCH_API Tensor hamming_window(int64_t window_length, bool periodic, double alpha, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory);
TORCH_API Tensor hamming_window(int64_t window_length, bool periodic, double alpha, double beta, TensorOptions options={});
TORCH_API Tensor hamming_window(int64_t window_length, bool periodic, double alpha, double beta, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory);
TORCH_API Tensor kaiser_window(int64_t window_length, TensorOptions options={});
TORCH_API Tensor kaiser_window(int64_t window_length, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory);
TORCH_API Tensor kaiser_window(int64_t window_length, bool periodic, TensorOptions options={});
TORCH_API Tensor kaiser_window(int64_t window_length, bool periodic, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory);
TORCH_API Tensor kaiser_window(int64_t window_length, bool periodic, double beta, TensorOptions options={});
TORCH_API Tensor kaiser_window(int64_t window_length, bool periodic, double beta, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory);
TORCH_API Tensor hinge_embedding_loss(const Tensor & self, const Tensor & target, double margin=1.0, int64_t reduction=at::Reduction::Mean);
TORCH_API Tensor group_norm(const Tensor & input, int64_t num_groups, const c10::optional<Tensor> & weight={}, const c10::optional<Tensor> & bias={}, double eps=1e-05, bool cudnn_enabled=true);
TORCH_API std::tuple<Tensor,Tensor,Tensor> native_group_norm(const Tensor & input, const c10::optional<Tensor> & weight, const c10::optional<Tensor> & bias, int64_t N, int64_t C, int64_t HxW, int64_t group, double eps);
TORCH_API std::tuple<Tensor,Tensor,Tensor> native_group_norm_backward(const Tensor & grad_out, const Tensor & input, const Tensor & mean, const Tensor & rstd, const c10::optional<Tensor> & weight, int64_t N, int64_t C, int64_t HxW, int64_t group, std::array<bool,3> output_mask);
TORCH_API Tensor _fft_r2c(const Tensor & self, IntArrayRef dim, int64_t normalization, bool onesided);
TORCH_API Tensor & _fft_r2c_out(Tensor & out, const Tensor & self, IntArrayRef dim, int64_t normalization, bool onesided);
TORCH_API Tensor & _fft_r2c_outf(const Tensor & self, IntArrayRef dim, int64_t normalization, bool onesided, Tensor & out);
TORCH_API Tensor _fft_c2r(const Tensor & self, IntArrayRef dim, int64_t normalization, int64_t last_dim_size);
TORCH_API Tensor & _fft_c2r_out(Tensor & out, const Tensor & self, IntArrayRef dim, int64_t normalization, int64_t last_dim_size);
TORCH_API Tensor & _fft_c2r_outf(const Tensor & self, IntArrayRef dim, int64_t normalization, int64_t last_dim_size, Tensor & out);
TORCH_API Tensor _fft_c2c(const Tensor & self, IntArrayRef dim, int64_t normalization, bool forward);
TORCH_API Tensor & _fft_c2c_out(Tensor & out, const Tensor & self, IntArrayRef dim, int64_t normalization, bool forward);
TORCH_API Tensor & _fft_c2c_outf(const Tensor & self, IntArrayRef dim, int64_t normalization, bool forward, Tensor & out);
TORCH_API int64_t _cufft_get_plan_cache_size(int64_t device_index);
TORCH_API int64_t _cufft_get_plan_cache_max_size(int64_t device_index);
TORCH_API void _cufft_set_plan_cache_max_size(int64_t device_index, int64_t max_size);
TORCH_API void _cufft_clear_plan_cache(int64_t device_index);
TORCH_API Tensor index(const Tensor & self, const c10::List<c10::optional<Tensor>> & indices);
TORCH_API Tensor index_copy(const Tensor & self, int64_t dim, const Tensor & index, const Tensor & source);
TORCH_API Tensor index_copy(const Tensor & self, Dimname dim, const Tensor & index, const Tensor & source);
TORCH_API Tensor & index_put_(Tensor & self, const c10::List<c10::optional<Tensor>> & indices, const Tensor & values, bool accumulate=false);
TORCH_API Tensor index_put(const Tensor & self, const c10::List<c10::optional<Tensor>> & indices, const Tensor & values, bool accumulate=false);
TORCH_API Tensor & _index_put_impl_(Tensor & self, const c10::List<c10::optional<Tensor>> & indices, const Tensor & values, bool accumulate=false, bool unsafe=false);
TORCH_API Tensor instance_norm(const Tensor & input, const c10::optional<Tensor> & weight, const c10::optional<Tensor> & bias, const c10::optional<Tensor> & running_mean, const c10::optional<Tensor> & running_var, bool use_input_stats, double momentum, double eps, bool cudnn_enabled);
TORCH_API Tensor inverse(const Tensor & self);
TORCH_API Tensor & inverse_out(Tensor & out, const Tensor & self);
TORCH_API Tensor & inverse_outf(const Tensor & self, Tensor & out);
TORCH_API Tensor _inverse_helper(const Tensor & self);
TORCH_API Tensor isclose(const Tensor & self, const Tensor & other, double rtol=1e-05, double atol=1e-08, bool equal_nan=false);
TORCH_API Tensor isnan(const Tensor & self);
TORCH_API bool is_distributed(const Tensor & self);
TORCH_API bool is_floating_point(const Tensor & self);
TORCH_API bool is_complex(const Tensor & self);
TORCH_API Tensor isreal(const Tensor & self);
TORCH_API bool is_nonzero(const Tensor & self);
TORCH_API bool is_same_size(const Tensor & self, const Tensor & other);
TORCH_API bool is_signed(const Tensor & self);
TORCH_API Tensor kl_div(const Tensor & self, const Tensor & target, int64_t reduction=at::Reduction::Mean, bool log_target=false);
TORCH_API Tensor kl_div_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction=at::Reduction::Mean, bool log_target=false);
TORCH_API Tensor kron(const Tensor & self, const Tensor & other);
TORCH_API Tensor & kron_out(Tensor & out, const Tensor & self, const Tensor & other);
TORCH_API Tensor & kron_outf(const Tensor & self, const Tensor & other, Tensor & out);
TORCH_API std::tuple<Tensor,Tensor> kthvalue(const Tensor & self, int64_t k, int64_t dim=-1, bool keepdim=false);
TORCH_API std::tuple<Tensor &,Tensor &> kthvalue_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t k, int64_t dim=-1, bool keepdim=false);
TORCH_API std::tuple<Tensor &,Tensor &> kthvalue_outf(const Tensor & self, int64_t k, int64_t dim, bool keepdim, Tensor & values, Tensor & indices);
TORCH_API std::tuple<Tensor,Tensor> kthvalue(const Tensor & self, int64_t k, Dimname dim, bool keepdim=false);
TORCH_API std::tuple<Tensor &,Tensor &> kthvalue_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t k, Dimname dim, bool keepdim=false);
TORCH_API std::tuple<Tensor &,Tensor &> kthvalue_outf(const Tensor & self, int64_t k, Dimname dim, bool keepdim, Tensor & values, Tensor & indices);
TORCH_API Tensor layer_norm(const Tensor & input, IntArrayRef normalized_shape, const c10::optional<Tensor> & weight={}, const c10::optional<Tensor> & bias={}, double eps=1e-05, bool cudnn_enable=true);
TORCH_API std::tuple<Tensor,Tensor,Tensor> native_layer_norm(const Tensor & input, IntArrayRef normalized_shape, const c10::optional<Tensor> & weight, const c10::optional<Tensor> & bias, double eps);
TORCH_API std::tuple<Tensor,Tensor,Tensor> native_layer_norm_backward(const Tensor & grad_out, const Tensor & input, IntArrayRef normalized_shape, const Tensor & mean, const Tensor & rstd, const c10::optional<Tensor> & weight, const c10::optional<Tensor> & bias, std::array<bool,3> output_mask);
TORCH_API Tensor nan_to_num(const Tensor & self, c10::optional<double> nan=c10::nullopt, c10::optional<double> posinf=c10::nullopt, c10::optional<double> neginf=c10::nullopt);
TORCH_API Tensor & nan_to_num_(Tensor & self, c10::optional<double> nan=c10::nullopt, c10::optional<double> posinf=c10::nullopt, c10::optional<double> neginf=c10::nullopt);
TORCH_API Tensor & nan_to_num_out(Tensor & out, const Tensor & self, c10::optional<double> nan=c10::nullopt, c10::optional<double> posinf=c10::nullopt, c10::optional<double> neginf=c10::nullopt);
TORCH_API Tensor & nan_to_num_outf(const Tensor & self, c10::optional<double> nan, c10::optional<double> posinf, c10::optional<double> neginf, Tensor & out);
TORCH_API Tensor linear(const Tensor & input, const Tensor & weight, const c10::optional<Tensor> & bias={});
TORCH_API Tensor mkldnn_linear(const Tensor & self, const Tensor & weight, const c10::optional<Tensor> & bias={});
TORCH_API Tensor mkldnn_linear_backward_input(IntArrayRef input_size, const Tensor & grad_output, const Tensor & weight);
TORCH_API std::tuple<Tensor,Tensor> mkldnn_linear_backward_weights(const Tensor & grad_output, const Tensor & input, const Tensor & weight, bool bias_defined);
TORCH_API std::tuple<Tensor,Tensor,Tensor> mkldnn_linear_backward(const Tensor & self, const Tensor & grad_output, const Tensor & weight, std::array<bool,3> output_mask);
TORCH_API Tensor fbgemm_linear_int8_weight_fp32_activation(const Tensor & input, const Tensor & weight, const Tensor & packed, const Tensor & col_offsets, Scalar weight_scale, Scalar weight_zero_point, const Tensor & bias);
TORCH_API Tensor fbgemm_linear_int8_weight(const Tensor & input, const Tensor & weight, const Tensor & packed, const Tensor & col_offsets, Scalar weight_scale, Scalar weight_zero_point, const Tensor & bias);
TORCH_API std::tuple<Tensor,Tensor,double,int64_t> fbgemm_linear_quantize_weight(const Tensor & input);
TORCH_API Tensor fbgemm_pack_gemm_matrix_fp16(const Tensor & input);
TORCH_API Tensor fbgemm_linear_fp16_weight_fp32_activation(const Tensor & input, const Tensor & packed_weight, const Tensor & bias);
TORCH_API Tensor fbgemm_linear_fp16_weight(const Tensor & input, const Tensor & packed_weight, const Tensor & bias);
TORCH_API Tensor fbgemm_pack_quantized_matrix(const Tensor & input);
TORCH_API Tensor fbgemm_pack_quantized_matrix(const Tensor & input, int64_t K, int64_t N);
TORCH_API Tensor ldexp(const Tensor & self, const Tensor & other);
TORCH_API Tensor & ldexp_(Tensor & self, const Tensor & other);
TORCH_API Tensor & ldexp_out(Tensor & out, const Tensor & self, const Tensor & other);
TORCH_API Tensor & ldexp_outf(const Tensor & self, const Tensor & other, Tensor & out);
TORCH_API Tensor linspace(Scalar start, Scalar end, c10::optional<int64_t> steps=c10::nullopt, TensorOptions options={});
TORCH_API Tensor linspace(Scalar start, Scalar end, c10::optional<int64_t> steps, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory);
TORCH_API Tensor & linspace_out(Tensor & out, Scalar start, Scalar end, c10::optional<int64_t> steps=c10::nullopt);
TORCH_API Tensor & linspace_outf(Scalar start, Scalar end, c10::optional<int64_t> steps, Tensor & out);
TORCH_API Tensor log(const Tensor & self);
TORCH_API Tensor & log_(Tensor & self);
TORCH_API Tensor & log_out(Tensor & out, const Tensor & self);
TORCH_API Tensor & log_outf(const Tensor & self, Tensor & out);
TORCH_API Tensor log10(const Tensor & self);
TORCH_API Tensor & log10_(Tensor & self);
TORCH_API Tensor & log10_out(Tensor & out, const Tensor & self);
TORCH_API Tensor & log10_outf(const Tensor & self, Tensor & out);
TORCH_API Tensor log1p(const Tensor & self);
TORCH_API Tensor & log1p_(Tensor & self);
TORCH_API Tensor & log1p_out(Tensor & out, const Tensor & self);
TORCH_API Tensor & log1p_outf(const Tensor & self, Tensor & out);
TORCH_API Tensor log2(const Tensor & self);
TORCH_API Tensor & log2_(Tensor & self);
TORCH_API Tensor & log2_out(Tensor & out, const Tensor & self);
TORCH_API Tensor & log2_outf(const Tensor & self, Tensor & out);
TORCH_API Tensor & logaddexp_out(Tensor & out, const Tensor & self, const Tensor & other);
TORCH_API Tensor & logaddexp_outf(const Tensor & self, const Tensor & other, Tensor & out);
TORCH_API Tensor logaddexp(const Tensor & self, const Tensor & other);
TORCH_API Tensor & logaddexp2_out(Tensor & out, const Tensor & self, const Tensor & other);
TORCH_API Tensor & logaddexp2_outf(const Tensor & self, const Tensor & other, Tensor & out);
TORCH_API Tensor logaddexp2(const Tensor & self, const Tensor & other);
TORCH_API Tensor xlogy(const Tensor & self, const Tensor & other);
TORCH_API Tensor xlogy(Scalar self, const Tensor & other);
TORCH_API Tensor xlogy(const Tensor & self, Scalar other);
TORCH_API Tensor & xlogy_(Tensor & self, const Tensor & other);
TORCH_API Tensor & xlogy_(Tensor & self, Scalar other);
TORCH_API Tensor & xlogy_out(Tensor & out, const Tensor & self, const Tensor & other);
TORCH_API Tensor & xlogy_outf(const Tensor & self, const Tensor & other, Tensor & out);
TORCH_API Tensor & xlogy_out(Tensor & out, Scalar self, const Tensor & other);
TORCH_API Tensor & xlogy_outf(Scalar self, const Tensor & other, Tensor & out);
TORCH_API Tensor & xlogy_out(Tensor & out, const Tensor & self, Scalar other);
TORCH_API Tensor & xlogy_outf(const Tensor & self, Scalar other, Tensor & out);
TORCH_API Tensor logdet(const Tensor & self);
TORCH_API Tensor logspace(Scalar start, Scalar end, c10::optional<int64_t> steps=c10::nullopt, double base=10.0, TensorOptions options={});
TORCH_API Tensor logspace(Scalar start, Scalar end, c10::optional<int64_t> steps, double base, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory);
TORCH_API Tensor & logspace_out(Tensor & out, Scalar start, Scalar end, c10::optional<int64_t> steps=c10::nullopt, double base=10.0);
TORCH_API Tensor & logspace_outf(Scalar start, Scalar end, c10::optional<int64_t> steps, double base, Tensor & out);
TORCH_API Tensor log_softmax(const Tensor & self, int64_t dim, c10::optional<ScalarType> dtype=c10::nullopt);
TORCH_API Tensor log_softmax(const Tensor & self, Dimname dim, c10::optional<ScalarType> dtype=c10::nullopt);
TORCH_API Tensor _log_softmax(const Tensor & self, int64_t dim, bool half_to_float);
TORCH_API Tensor _log_softmax_backward_data(const Tensor & grad_output, const Tensor & output, int64_t dim, const Tensor & self);
TORCH_API Tensor _logcumsumexp(const Tensor & self, int64_t dim);
TORCH_API Tensor & _logcumsumexp_out(Tensor & out, const Tensor & self, int64_t dim);
TORCH_API Tensor & _logcumsumexp_outf(const Tensor & self, int64_t dim, Tensor & out);
TORCH_API Tensor logcumsumexp(const Tensor & self, int64_t dim);
TORCH_API Tensor & logcumsumexp_out(Tensor & out, const Tensor & self, int64_t dim);
TORCH_API Tensor & logcumsumexp_outf(const Tensor & self, int64_t dim, Tensor & out);
TORCH_API Tensor logcumsumexp(const Tensor & self, Dimname dim);
TORCH_API Tensor & logcumsumexp_out(Tensor & out, const Tensor & self, Dimname dim);
TORCH_API Tensor & logcumsumexp_outf(const Tensor & self, Dimname dim, Tensor & out);
TORCH_API Tensor logsumexp(const Tensor & self, IntArrayRef dim, bool keepdim=false);
TORCH_API Tensor & logsumexp_out(Tensor & out, const Tensor & self, IntArrayRef dim, bool keepdim=false);
TORCH_API Tensor & logsumexp_outf(const Tensor & self, IntArrayRef dim, bool keepdim, Tensor & out);
TORCH_API Tensor logsumexp(const Tensor & self, DimnameList dim, bool keepdim=false);
TORCH_API Tensor & logsumexp_out(Tensor & out, const Tensor & self, DimnameList dim, bool keepdim=false);
TORCH_API Tensor & logsumexp_outf(const Tensor & self, DimnameList dim, bool keepdim, Tensor & out);
TORCH_API Tensor margin_ranking_loss(const Tensor & input1, const Tensor & input2, const Tensor & target, double margin=0.0, int64_t reduction=at::Reduction::Mean);
TORCH_API Tensor matmul(const Tensor & self, const Tensor & other);
TORCH_API Tensor & matmul_out(Tensor & out, const Tensor & self, const Tensor & other);
TORCH_API Tensor & matmul_outf(const Tensor & self, const Tensor & other, Tensor & out);
TORCH_API Tensor matrix_rank(const Tensor & self, double tol, bool symmetric=false);
TORCH_API Tensor matrix_rank(const Tensor & self, bool symmetric=false);
TORCH_API Tensor matrix_power(const Tensor & self, int64_t n);
TORCH_API Tensor matrix_exp(const Tensor & self);
TORCH_API Tensor matrix_exp_backward(const Tensor & self, const Tensor & grad);
TORCH_API std::tuple<Tensor,Tensor> _aminmax(const Tensor & self);
TORCH_API std::tuple<Tensor,Tensor> _aminmax(const Tensor & self, int64_t dim, bool keepdim=false);
TORCH_API Tensor _compute_linear_combination(const Tensor & input, const Tensor & coefficients);
TORCH_API Tensor & _compute_linear_combination_out(Tensor & out, const Tensor & input, const Tensor & coefficients);
TORCH_API Tensor & _compute_linear_combination_outf(const Tensor & input, const Tensor & coefficients, Tensor & out);
TORCH_API std::tuple<Tensor,Tensor> max(const Tensor & self, int64_t dim, bool keepdim=false);
TORCH_API std::tuple<Tensor &,Tensor &> max_out(Tensor & max, Tensor & max_values, const Tensor & self, int64_t dim, bool keepdim=false);
TORCH_API std::tuple<Tensor &,Tensor &> max_outf(const Tensor & self, int64_t dim, bool keepdim, Tensor & max, Tensor & max_values);
TORCH_API std::tuple<Tensor,Tensor> max(const Tensor & self, Dimname dim, bool keepdim=false);
TORCH_API std::tuple<Tensor &,Tensor &> max_out(Tensor & max, Tensor & max_values, const Tensor & self, Dimname dim, bool keepdim=false);
TORCH_API std::tuple<Tensor &,Tensor &> max_outf(const Tensor & self, Dimname dim, bool keepdim, Tensor & max, Tensor & max_values);
TORCH_API Tensor value_selecting_reduction_backward(const Tensor & grad, int64_t dim, const Tensor & indices, IntArrayRef sizes, bool keepdim);
TORCH_API Tensor amax(const Tensor & self, IntArrayRef dim={}, bool keepdim=false);
TORCH_API Tensor & amax_out(Tensor & out, const Tensor & self, IntArrayRef dim={}, bool keepdim=false);
TORCH_API Tensor & amax_outf(const Tensor & self, IntArrayRef dim, bool keepdim, Tensor & out);
TORCH_API std::tuple<Tensor,Tensor> max_pool1d_with_indices(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride={}, IntArrayRef padding=0, IntArrayRef dilation=1, bool ceil_mode=false);
TORCH_API Tensor max_pool1d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride={}, IntArrayRef padding=0, IntArrayRef dilation=1, bool ceil_mode=false);
TORCH_API Tensor max_pool2d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride={}, IntArrayRef padding=0, IntArrayRef dilation=1, bool ceil_mode=false);
TORCH_API Tensor mkldnn_max_pool2d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride={}, IntArrayRef padding=0, IntArrayRef dilation=1, bool ceil_mode=false);
TORCH_API Tensor mkldnn_max_pool3d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride={}, IntArrayRef padding=0, IntArrayRef dilation=1, bool ceil_mode=false);
TORCH_API Tensor quantized_max_pool1d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride={}, IntArrayRef padding=0, IntArrayRef dilation=1, bool ceil_mode=false);
TORCH_API Tensor quantized_max_pool2d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride={}, IntArrayRef padding=0, IntArrayRef dilation=1, bool ceil_mode=false);
TORCH_API Tensor max_pool3d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride={}, IntArrayRef padding=0, IntArrayRef dilation=1, bool ceil_mode=false);
TORCH_API Tensor mean(const Tensor & self, c10::optional<ScalarType> dtype=c10::nullopt);
TORCH_API Tensor mean(const Tensor & self, IntArrayRef dim, bool keepdim=false, c10::optional<ScalarType> dtype=c10::nullopt);
TORCH_API Tensor & mean_out(Tensor & out, const Tensor & self, IntArrayRef dim, bool keepdim=false, c10::optional<ScalarType> dtype=c10::nullopt);
TORCH_API Tensor & mean_outf(const Tensor & self, IntArrayRef dim, bool keepdim, c10::optional<ScalarType> dtype, Tensor & out);
TORCH_API Tensor mean(const Tensor & self, DimnameList dim, bool keepdim=false, c10::optional<ScalarType> dtype=c10::nullopt);
TORCH_API Tensor & mean_out(Tensor & out, const Tensor & self, DimnameList dim, bool keepdim=false, c10::optional<ScalarType> dtype=c10::nullopt);
TORCH_API Tensor & mean_outf(const Tensor & self, DimnameList dim, bool keepdim, c10::optional<ScalarType> dtype, Tensor & out);
TORCH_API Tensor median(const Tensor & self);
TORCH_API std::tuple<Tensor,Tensor> median(const Tensor & self, int64_t dim, bool keepdim=false);
TORCH_API std::tuple<Tensor &,Tensor &> median_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t dim, bool keepdim=false);
TORCH_API std::tuple<Tensor &,Tensor &> median_outf(const Tensor & self, int64_t dim, bool keepdim, Tensor & values, Tensor & indices);
TORCH_API std::tuple<Tensor,Tensor> median(const Tensor & self, Dimname dim, bool keepdim=false);
TORCH_API std::tuple<Tensor &,Tensor &> median_out(Tensor & values, Tensor & indices, const Tensor & self, Dimname dim, bool keepdim=false);
TORCH_API std::tuple<Tensor &,Tensor &> median_outf(const Tensor & self, Dimname dim, bool keepdim, Tensor & values, Tensor & indices);
TORCH_API Tensor nanmedian(const Tensor & self);
TORCH_API std::tuple<Tensor,Tensor> nanmedian(const Tensor & self, int64_t dim, bool keepdim=false);
TORCH_API std::tuple<Tensor &,Tensor &> nanmedian_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t dim, bool keepdim=false);
TORCH_API std::tuple<Tensor &,Tensor &> nanmedian_outf(const Tensor & self, int64_t dim, bool keepdim, Tensor & values, Tensor & indices);
TORCH_API std::tuple<Tensor,Tensor> nanmedian(const Tensor & self, Dimname dim, bool keepdim=false);
TORCH_API std::tuple<Tensor &,Tensor &> nanmedian_out(Tensor & values, Tensor & indices, const Tensor & self, Dimname dim, bool keepdim=false);
TORCH_API std::tuple<Tensor &,Tensor &> nanmedian_outf(const Tensor & self, Dimname dim, bool keepdim, Tensor & values, Tensor & indices);
TORCH_API std::tuple<Tensor,Tensor> min(const Tensor & self, int64_t dim, bool keepdim=false);
TORCH_API std::tuple<Tensor &,Tensor &> min_out(Tensor & min, Tensor & min_indices, const Tensor & self, int64_t dim, bool keepdim=false);
TORCH_API std::tuple<Tensor &,Tensor &> min_outf(const Tensor & self, int64_t dim, bool keepdim, Tensor & min, Tensor & min_indices);
TORCH_API std::tuple<Tensor,Tensor> min(const Tensor & self, Dimname dim, bool keepdim=false);
TORCH_API std::tuple<Tensor &,Tensor &> min_out(Tensor & min, Tensor & min_indices, const Tensor & self, Dimname dim, bool keepdim=false);
TORCH_API std::tuple<Tensor &,Tensor &> min_outf(const Tensor & self, Dimname dim, bool keepdim, Tensor & min, Tensor & min_indices);
TORCH_API Tensor amin(const Tensor & self, IntArrayRef dim={}, bool keepdim=false);
TORCH_API Tensor & amin_out(Tensor & out, const Tensor & self, IntArrayRef dim={}, bool keepdim=false);
TORCH_API Tensor & amin_outf(const Tensor & self, IntArrayRef dim, bool keepdim, Tensor & out);
TORCH_API Tensor mkldnn_convolution(const Tensor & self, const Tensor & weight, const c10::optional<Tensor> & bias, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups);
TORCH_API Tensor mkldnn_convolution_backward_input(IntArrayRef self_size, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool bias_defined);
TORCH_API std::tuple<Tensor,Tensor> mkldnn_convolution_backward_weights(IntArrayRef weight_size, const Tensor & grad_output, const Tensor & self, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool bias_defined);
TORCH_API std::tuple<Tensor,Tensor,Tensor> mkldnn_convolution_backward(const Tensor & self, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, std::array<bool,3> output_mask);
TORCH_API std::tuple<Tensor,Tensor,Tensor> miopen_batch_norm(const Tensor & input, const Tensor & weight, const c10::optional<Tensor> & bias, const c10::optional<Tensor> & running_mean, const c10::optional<Tensor> & running_var, bool training, double exponential_average_factor, double epsilon);
TORCH_API std::tuple<Tensor,Tensor,Tensor> miopen_batch_norm_backward(const Tensor & input, const Tensor & grad_output, const Tensor & weight, const c10::optional<Tensor> & running_mean, const c10::optional<Tensor> & running_var, const c10::optional<Tensor> & save_mean, const c10::optional<Tensor> & save_var, double epsilon);
TORCH_API Tensor miopen_convolution(const Tensor & self, const Tensor & weight, const c10::optional<Tensor> & bias, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic);
TORCH_API Tensor miopen_convolution_backward_input(IntArrayRef self_size, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic);
TORCH_API std::tuple<Tensor,Tensor,Tensor> miopen_convolution_backward(const Tensor & self, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic, std::array<bool,3> output_mask);
TORCH_API Tensor miopen_convolution_backward_bias(const Tensor & grad_output);
TORCH_API Tensor miopen_convolution_backward_weight(IntArrayRef weight_size, const Tensor & grad_output, const Tensor & self, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic);
TORCH_API Tensor miopen_convolution_transpose(const Tensor & self, const Tensor & weight, const c10::optional<Tensor> & bias, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic);
TORCH_API std::tuple<Tensor,Tensor,Tensor> miopen_convolution_transpose_backward(const Tensor & self, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic, std::array<bool,3> output_mask);
TORCH_API Tensor miopen_convolution_transpose_backward_input(const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic);
TORCH_API Tensor miopen_convolution_transpose_backward_weight(IntArrayRef weight_size, const Tensor & grad_output, const Tensor & self, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic);
TORCH_API Tensor miopen_depthwise_convolution(const Tensor & self, const Tensor & weight, const c10::optional<Tensor> & bias, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic);
TORCH_API Tensor miopen_depthwise_convolution_backward_input(IntArrayRef self_size, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic);
TORCH_API std::tuple<Tensor,Tensor,Tensor> miopen_depthwise_convolution_backward(const Tensor & self, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic, std::array<bool,3> output_mask);
TORCH_API Tensor miopen_depthwise_convolution_backward_weight(IntArrayRef weight_size, const Tensor & grad_output, const Tensor & self, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic);
TORCH_API std::tuple<Tensor,Tensor,Tensor,Tensor,Tensor> miopen_rnn(const Tensor & input, TensorList weight, int64_t weight_stride0, const Tensor & hx, const c10::optional<Tensor> & cx, int64_t mode, int64_t hidden_size, int64_t num_layers, bool batch_first, double dropout, bool train, bool bidirectional, IntArrayRef batch_sizes, const c10::optional<Tensor> & dropout_state);
TORCH_API std::tuple<Tensor,Tensor,Tensor,std::vector<Tensor>> miopen_rnn_backward(const Tensor & input, TensorList weight, int64_t weight_stride0, const Tensor & weight_buf, const Tensor & hx, const c10::optional<Tensor> & cx, const Tensor & output, const c10::optional<Tensor> & grad_output, const c10::optional<Tensor> & grad_hy, const c10::optional<Tensor> & grad_cy, int64_t mode, int64_t hidden_size, int64_t num_layers, bool batch_first, double dropout, bool train, bool bidirectional, IntArrayRef batch_sizes, const c10::optional<Tensor> & dropout_state, const Tensor & reserve, std::array<bool,4> output_mask);
TORCH_API Tensor mm(const Tensor & self, const Tensor & mat2);
TORCH_API Tensor & mm_out(Tensor & out, const Tensor & self, const Tensor & mat2);
TORCH_API Tensor & mm_outf(const Tensor & self, const Tensor & mat2, Tensor & out);
TORCH_API Tensor _sparse_mm(const Tensor & sparse, const Tensor & dense);
TORCH_API Tensor _sparse_sparse_matmul(const Tensor & self, const Tensor & other);
TORCH_API Tensor _sparse_matrix_mask_helper(const Tensor & t, const Tensor & mask_indices);
TORCH_API std::tuple<Tensor,Tensor> mode(const Tensor & self, int64_t dim=-1, bool keepdim=false);
TORCH_API std::tuple<Tensor &,Tensor &> mode_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t dim=-1, bool keepdim=false);
TORCH_API std::tuple<Tensor &,Tensor &> mode_outf(const Tensor & self, int64_t dim, bool keepdim, Tensor & values, Tensor & indices);
TORCH_API std::tuple<Tensor,Tensor> mode(const Tensor & self, Dimname dim, bool keepdim=false);
TORCH_API std::tuple<Tensor &,Tensor &> mode_out(Tensor & values, Tensor & indices, const Tensor & self, Dimname dim, bool keepdim=false);
TORCH_API std::tuple<Tensor &,Tensor &> mode_outf(const Tensor & self, Dimname dim, bool keepdim, Tensor & values, Tensor & indices);
TORCH_API Tensor mul(const Tensor & self, const Tensor & other);
TORCH_API Tensor & mul_out(Tensor & out, const Tensor & self, const Tensor & other);
TORCH_API Tensor & mul_outf(const Tensor & self, const Tensor & other, Tensor & out);
TORCH_API Tensor mul(const Tensor & self, Scalar other);
TORCH_API Tensor multiply(const Tensor & self, const Tensor & other);
TORCH_API Tensor & multiply_out(Tensor & out, const Tensor & self, const Tensor & other);
TORCH_API Tensor & multiply_outf(const Tensor & self, const Tensor & other, Tensor & out);
TORCH_API Tensor multiply(const Tensor & self, Scalar other);
TORCH_API Tensor mv(const Tensor & self, const Tensor & vec);
TORCH_API Tensor & mv_out(Tensor & out, const Tensor & self, const Tensor & vec);
TORCH_API Tensor & mv_outf(const Tensor & self, const Tensor & vec, Tensor & out);
TORCH_API Tensor mvlgamma(const Tensor & self, int64_t p);
TORCH_API Tensor narrow_copy(const Tensor & self, int64_t dim, int64_t start, int64_t length);
TORCH_API Tensor & narrow_copy_out(Tensor & out, const Tensor & self, int64_t dim, int64_t start, int64_t length);
TORCH_API Tensor & narrow_copy_outf(const Tensor & self, int64_t dim, int64_t start, int64_t length, Tensor & out);
TORCH_API Tensor narrow(const Tensor & self, int64_t dim, int64_t start, int64_t length);
TORCH_API Tensor narrow(const Tensor & self, int64_t dim, const Tensor & start, int64_t length);
TORCH_API std::tuple<Tensor,Tensor,Tensor> native_batch_norm(const Tensor & input, const c10::optional<Tensor> & weight, const c10::optional<Tensor> & bias, const c10::optional<Tensor> & running_mean, const c10::optional<Tensor> & running_var, bool training, double momentum, double eps);
TORCH_API std::tuple<Tensor &,Tensor &,Tensor &> native_batch_norm_out(Tensor & out, Tensor & save_mean, Tensor & save_invstd, const Tensor & input, const c10::optional<Tensor> & weight, const c10::optional<Tensor> & bias, const c10::optional<Tensor> & running_mean, const c10::optional<Tensor> & running_var, bool training, double momentum, double eps);
TORCH_API std::tuple<Tensor &,Tensor &,Tensor &> native_batch_norm_outf(const Tensor & input, const c10::optional<Tensor> & weight, const c10::optional<Tensor> & bias, const c10::optional<Tensor> & running_mean, const c10::optional<Tensor> & running_var, bool training, double momentum, double eps, Tensor & out, Tensor & save_mean, Tensor & save_invstd);
TORCH_API std::tuple<Tensor,Tensor> batch_norm_stats(const Tensor & input, double eps);
TORCH_API Tensor batch_norm_elemt(const Tensor & input, const c10::optional<Tensor> & weight, const c10::optional<Tensor> & bias, const Tensor & mean, const Tensor & invstd, double eps);
TORCH_API Tensor & batch_norm_elemt_out(Tensor & out, const Tensor & input, const c10::optional<Tensor> & weight, const c10::optional<Tensor> & bias, const Tensor & mean, const Tensor & invstd, double eps);
TORCH_API Tensor & batch_norm_elemt_outf(const Tensor & input, const c10::optional<Tensor> & weight, const c10::optional<Tensor> & bias, const Tensor & mean, const Tensor & invstd, double eps, Tensor & out);
TORCH_API std::tuple<Tensor,Tensor> batch_norm_gather_stats(const Tensor & input, const Tensor & mean, const Tensor & invstd, const c10::optional<Tensor> & running_mean, const c10::optional<Tensor> & running_var, double momentum, double eps, int64_t count);
TORCH_API std::tuple<Tensor,Tensor> batch_norm_gather_stats_with_counts(const Tensor & input, const Tensor & mean, const Tensor & invstd, const c10::optional<Tensor> & running_mean, const c10::optional<Tensor> & running_var, double momentum, double eps, const Tensor & counts);
TORCH_API std::tuple<Tensor,Tensor,Tensor> native_batch_norm_backward(const Tensor & grad_out, const Tensor & input, const c10::optional<Tensor> & weight, const c10::optional<Tensor> & running_mean, const c10::optional<Tensor> & running_var, const c10::optional<Tensor> & save_mean, const c10::optional<Tensor> & save_invstd, bool train, double eps, std::array<bool,3> output_mask);
TORCH_API std::tuple<Tensor,Tensor,Tensor,Tensor> batch_norm_backward_reduce(const Tensor & grad_out, const Tensor & input, const Tensor & mean, const Tensor & invstd, const c10::optional<Tensor> & weight, bool input_g, bool weight_g, bool bias_g);
TORCH_API Tensor batch_norm_backward_elemt(const Tensor & grad_out, const Tensor & input, const Tensor & mean, const Tensor & invstd, const c10::optional<Tensor> & weight, const Tensor & mean_dy, const Tensor & mean_dy_xmu);
TORCH_API std::tuple<Tensor,Tensor> batch_norm_update_stats(const Tensor & input, const c10::optional<Tensor> & running_mean, const c10::optional<Tensor> & running_var, double momentum);
TORCH_API bool is_vulkan_available();
TORCH_API bool _nnpack_available();
TORCH_API Tensor _nnpack_spatial_convolution(const Tensor & input, const Tensor & weight, const c10::optional<Tensor> & bias, IntArrayRef padding, IntArrayRef stride=1);
TORCH_API std::tuple<Tensor,Tensor,Tensor> _nnpack_spatial_convolution_backward(const Tensor & input, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, std::array<bool,3> output_mask);
TORCH_API Tensor _nnpack_spatial_convolution_backward_input(const Tensor & input, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding);
TORCH_API Tensor _nnpack_spatial_convolution_backward_weight(const Tensor & input, IntArrayRef weightsize, const Tensor & grad_output, IntArrayRef padding);
TORCH_API Tensor ones(IntArrayRef size, c10::optional<DimnameList> names, TensorOptions options={});
TORCH_API Tensor ones(IntArrayRef size, c10::optional<DimnameList> names, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory);
TORCH_API Tensor ones(IntArrayRef size, TensorOptions options={});
TORCH_API Tensor ones(IntArrayRef size, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory);
TORCH_API Tensor & ones_out(Tensor & out, IntArrayRef size);
TORCH_API Tensor & ones_outf(IntArrayRef size, Tensor & out);
TORCH_API Tensor ones_like(const Tensor & self, TensorOptions options={}, c10::optional<MemoryFormat> memory_format=c10::nullopt);
TORCH_API Tensor ones_like(const Tensor & self, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory, c10::optional<MemoryFormat> memory_format);
TORCH_API Tensor pairwise_distance(const Tensor & x1, const Tensor & x2, double p=2, double eps=1e-06, bool keepdim=false);
TORCH_API Tensor cdist(const Tensor & x1, const Tensor & x2, double p=2, c10::optional<int64_t> compute_mode=c10::nullopt);
TORCH_API Tensor _euclidean_dist(const Tensor & x1, const Tensor & x2);
TORCH_API Tensor _cdist_forward(const Tensor & x1, const Tensor & x2, double p, c10::optional<int64_t> compute_mode);
TORCH_API Tensor _cdist_backward(const Tensor & grad, const Tensor & x1, const Tensor & x2, double p, const Tensor & cdist);
TORCH_API Tensor pdist(const Tensor & self, double p=2);
TORCH_API Tensor _pdist_forward(const Tensor & self, double p=2);
TORCH_API Tensor _pdist_backward(const Tensor & grad, const Tensor & self, double p, const Tensor & pdist);
TORCH_API Tensor cosine_similarity(const Tensor & x1, const Tensor & x2, int64_t dim=1, double eps=1e-08);
TORCH_API Tensor movedim(const Tensor & self, IntArrayRef source, IntArrayRef destination);
TORCH_API Tensor movedim(const Tensor & self, int64_t source, int64_t destination);
TORCH_API Tensor moveaxis(const Tensor & self, IntArrayRef source, IntArrayRef destination);
TORCH_API Tensor moveaxis(const Tensor & self, int64_t source, int64_t destination);
TORCH_API Tensor pixel_shuffle(const Tensor & self, int64_t upscale_factor);
TORCH_API Tensor pixel_unshuffle(const Tensor & self, int64_t downscale_factor);
TORCH_API Tensor channel_shuffle(const Tensor & self, int64_t groups);
TORCH_API Tensor pinverse(const Tensor & self, double rcond=1e-15);
TORCH_API Tensor poisson_nll_loss(const Tensor & input, const Tensor & target, bool log_input, bool full, double eps, int64_t reduction);
TORCH_API Tensor rad2deg(const Tensor & self);
TORCH_API Tensor & rad2deg_(Tensor & self);
TORCH_API Tensor & rad2deg_out(Tensor & out, const Tensor & self);
TORCH_API Tensor & rad2deg_outf(const Tensor & self, Tensor & out);
TORCH_API Tensor deg2rad(const Tensor & self);
TORCH_API Tensor & deg2rad_(Tensor & self);
TORCH_API Tensor & deg2rad_out(Tensor & out, const Tensor & self);
TORCH_API Tensor & deg2rad_outf(const Tensor & self, Tensor & out);
TORCH_API Tensor scalar_tensor(Scalar s, TensorOptions options={});
TORCH_API Tensor scalar_tensor(Scalar s, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory);
TORCH_API Tensor rand(IntArrayRef size, c10::optional<DimnameList> names, TensorOptions options={});
TORCH_API Tensor rand(IntArrayRef size, c10::optional<DimnameList> names, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory);
TORCH_API Tensor rand(IntArrayRef size, c10::optional<Generator> generator, c10::optional<DimnameList> names, TensorOptions options={});
TORCH_API Tensor rand(IntArrayRef size, c10::optional<Generator> generator, c10::optional<DimnameList> names, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory);
TORCH_API Tensor rand(IntArrayRef size, TensorOptions options={});
TORCH_API Tensor rand(IntArrayRef size, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory);
TORCH_API Tensor rand(IntArrayRef size, c10::optional<Generator> generator, TensorOptions options={});
TORCH_API Tensor rand(IntArrayRef size, c10::optional<Generator> generator, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory);
TORCH_API Tensor & rand_out(Tensor & out, IntArrayRef size);
TORCH_API Tensor & rand_outf(IntArrayRef size, Tensor & out);
TORCH_API Tensor & rand_out(Tensor & out, IntArrayRef size, c10::optional<Generator> generator);
TORCH_API Tensor & rand_outf(IntArrayRef size, c10::optional<Generator> generator, Tensor & out);
TORCH_API Tensor rand_like(const Tensor & self, TensorOptions options={}, c10::optional<MemoryFormat> memory_format=c10::nullopt);
TORCH_API Tensor rand_like(const Tensor & self, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory, c10::optional<MemoryFormat> memory_format);
TORCH_API Tensor randint(int64_t high, IntArrayRef size, TensorOptions options={});
TORCH_API Tensor randint(int64_t high, IntArrayRef size, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory);
TORCH_API Tensor randint(int64_t high, IntArrayRef size, c10::optional<Generator> generator, TensorOptions options={});
TORCH_API Tensor randint(int64_t high, IntArrayRef size, c10::optional<Generator> generator, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory);
TORCH_API Tensor randint(int64_t low, int64_t high, IntArrayRef size, TensorOptions options={});
TORCH_API Tensor randint(int64_t low, int64_t high, IntArrayRef size, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory);
TORCH_API Tensor randint(int64_t low, int64_t high, IntArrayRef size, c10::optional<Generator> generator, TensorOptions options={});
TORCH_API Tensor randint(int64_t low, int64_t high, IntArrayRef size, c10::optional<Generator> generator, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory);
TORCH_API Tensor & randint_out(Tensor & out, int64_t high, IntArrayRef size);
TORCH_API Tensor & randint_outf(int64_t high, IntArrayRef size, Tensor & out);
TORCH_API Tensor & randint_out(Tensor & out, int64_t high, IntArrayRef size, c10::optional<Generator> generator);
TORCH_API Tensor & randint_outf(int64_t high, IntArrayRef size, c10::optional<Generator> generator, Tensor & out);
TORCH_API Tensor & randint_out(Tensor & out, int64_t low, int64_t high, IntArrayRef size);
TORCH_API Tensor & randint_outf(int64_t low, int64_t high, IntArrayRef size, Tensor & out);
TORCH_API Tensor & randint_out(Tensor & out, int64_t low, int64_t high, IntArrayRef size, c10::optional<Generator> generator);
TORCH_API Tensor & randint_outf(int64_t low, int64_t high, IntArrayRef size, c10::optional<Generator> generator, Tensor & out);
TORCH_API Tensor randint_like(const Tensor & self, int64_t high, TensorOptions options={}, c10::optional<MemoryFormat> memory_format=c10::nullopt);
TORCH_API Tensor randint_like(const Tensor & self, int64_t high, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory, c10::optional<MemoryFormat> memory_format);
TORCH_API Tensor randint_like(const Tensor & self, int64_t low, int64_t high, TensorOptions options={}, c10::optional<MemoryFormat> memory_format=c10::nullopt);
TORCH_API Tensor randint_like(const Tensor & self, int64_t low, int64_t high, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory, c10::optional<MemoryFormat> memory_format);
TORCH_API Tensor randn(IntArrayRef size, TensorOptions options={});
TORCH_API Tensor randn(IntArrayRef size, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory);
TORCH_API Tensor randn(IntArrayRef size, c10::optional<Generator> generator, TensorOptions options={});
TORCH_API Tensor randn(IntArrayRef size, c10::optional<Generator> generator, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory);
TORCH_API Tensor randn(IntArrayRef size, c10::optional<DimnameList> names, TensorOptions options={});
TORCH_API Tensor randn(IntArrayRef size, c10::optional<DimnameList> names, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory);
TORCH_API Tensor randn(IntArrayRef size, c10::optional<Generator> generator, c10::optional<DimnameList> names, TensorOptions options={});
TORCH_API Tensor randn(IntArrayRef size, c10::optional<Generator> generator, c10::optional<DimnameList> names, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory);
TORCH_API Tensor & randn_out(Tensor & out, IntArrayRef size);
TORCH_API Tensor & randn_outf(IntArrayRef size, Tensor & out);
TORCH_API Tensor & randn_out(Tensor & out, IntArrayRef size, c10::optional<Generator> generator);
TORCH_API Tensor & randn_outf(IntArrayRef size, c10::optional<Generator> generator, Tensor & out);
TORCH_API Tensor randn_like(const Tensor & self, TensorOptions options={}, c10::optional<MemoryFormat> memory_format=c10::nullopt);
TORCH_API Tensor randn_like(const Tensor & self, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory, c10::optional<MemoryFormat> memory_format);
TORCH_API Tensor randperm(int64_t n, TensorOptions options={});
TORCH_API Tensor randperm(int64_t n, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory);
TORCH_API Tensor randperm(int64_t n, c10::optional<Generator> generator, TensorOptions options={});
TORCH_API Tensor randperm(int64_t n, c10::optional<Generator> generator, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory);
TORCH_API Tensor & randperm_out(Tensor & out, int64_t n);
TORCH_API Tensor & randperm_outf(int64_t n, Tensor & out);
TORCH_API Tensor & randperm_out(Tensor & out, int64_t n, c10::optional<Generator> generator);
TORCH_API Tensor & randperm_outf(int64_t n, c10::optional<Generator> generator, Tensor & out);
TORCH_API Tensor range(Scalar start, Scalar end, Scalar step=1, TensorOptions options={});
TORCH_API Tensor range(Scalar start, Scalar end, Scalar step, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory);
TORCH_API Tensor range(Scalar start, Scalar end, TensorOptions options={});
TORCH_API Tensor range(Scalar start, Scalar end, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory);
TORCH_API Tensor & range_out(Tensor & out, Scalar start, Scalar end, Scalar step=1);
TORCH_API Tensor & range_outf(Scalar start, Scalar end, Scalar step, Tensor & out);
TORCH_API Tensor ravel(const Tensor & self);
TORCH_API Tensor reciprocal(const Tensor & self);
TORCH_API Tensor & reciprocal_(Tensor & self);
TORCH_API Tensor & reciprocal_out(Tensor & out, const Tensor & self);
TORCH_API Tensor & reciprocal_outf(const Tensor & self, Tensor & out);
TORCH_API Tensor neg(const Tensor & self);
TORCH_API Tensor & neg_(Tensor & self);
TORCH_API Tensor & neg_out(Tensor & out, const Tensor & self);
TORCH_API Tensor & neg_outf(const Tensor & self, Tensor & out);
TORCH_API Tensor negative(const Tensor & self);
TORCH_API Tensor & negative_(Tensor & self);
TORCH_API Tensor & negative_out(Tensor & out, const Tensor & self);
TORCH_API Tensor & negative_outf(const Tensor & self, Tensor & out);
TORCH_API Tensor repeat_interleave(const Tensor & repeats);
TORCH_API Tensor repeat_interleave(const Tensor & self, const Tensor & repeats, c10::optional<int64_t> dim=c10::nullopt);
TORCH_API Tensor repeat_interleave(const Tensor & self, int64_t repeats, c10::optional<int64_t> dim=c10::nullopt);
TORCH_API Tensor reshape(const Tensor & self, IntArrayRef shape);
TORCH_API Tensor _mkldnn_reshape(const Tensor & self, IntArrayRef shape);
TORCH_API Tensor round(const Tensor & self);
TORCH_API Tensor & round_(Tensor & self);
TORCH_API Tensor & round_out(Tensor & out, const Tensor & self);
TORCH_API Tensor & round_outf(const Tensor & self, Tensor & out);
TORCH_API Tensor rrelu(const Tensor & self, Scalar lower=0.125, Scalar upper=0.3333333333333333, bool training=false, c10::optional<Generator> generator=c10::nullopt);
TORCH_API Tensor & rrelu_(Tensor & self, Scalar lower=0.125, Scalar upper=0.3333333333333333, bool training=false, c10::optional<Generator> generator=c10::nullopt);
TORCH_API Tensor relu(const Tensor & self);
TORCH_API Tensor & relu_(Tensor & self);
TORCH_API Tensor prelu(const Tensor & self, const Tensor & weight);
TORCH_API std::tuple<Tensor,Tensor> prelu_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight);
TORCH_API Tensor gelu(const Tensor & self);
TORCH_API Tensor gelu_backward(const Tensor & grad, const Tensor & self);
TORCH_API Tensor infinitely_differentiable_gelu_backward(const Tensor & grad, const Tensor & self);
TORCH_API Tensor hardshrink(const Tensor & self, Scalar lambd=0.5);
TORCH_API Tensor hardshrink_backward(const Tensor & grad_out, const Tensor & self, Scalar lambd);
TORCH_API Tensor rsqrt(const Tensor & self);
TORCH_API Tensor & rsqrt_(Tensor & self);
TORCH_API Tensor & rsqrt_out(Tensor & out, const Tensor & self);
TORCH_API Tensor & rsqrt_outf(const Tensor & self, Tensor & out);
TORCH_API Tensor select(const Tensor & self, Dimname dim, int64_t index);
TORCH_API Tensor select(const Tensor & self, int64_t dim, int64_t index);
TORCH_API Tensor select_backward(const Tensor & grad, IntArrayRef input_sizes, int64_t dim, int64_t index);
TORCH_API Tensor selu(const Tensor & self);
TORCH_API Tensor & selu_(Tensor & self);
TORCH_API Tensor celu(const Tensor & self, Scalar alpha=1.0);
TORCH_API Tensor & celu_(Tensor & self, Scalar alpha=1.0);
TORCH_API Tensor silu(const Tensor & self);
TORCH_API Tensor & silu_(Tensor & self);
TORCH_API Tensor & silu_out(Tensor & out, const Tensor & self);
TORCH_API Tensor & silu_outf(const Tensor & self, Tensor & out);
TORCH_API Tensor silu_backward(const Tensor & grad_output, const Tensor & self);
TORCH_API Tensor sigmoid(const Tensor & self);
TORCH_API Tensor & sigmoid_(Tensor & self);
TORCH_API Tensor & sigmoid_out(Tensor & out, const Tensor & self);
TORCH_API Tensor & sigmoid_outf(const Tensor & self, Tensor & out);
TORCH_API Tensor logit(const Tensor & self, c10::optional<double> eps=c10::nullopt);
TORCH_API Tensor & logit_(Tensor & self, c10::optional<double> eps=c10::nullopt);
TORCH_API Tensor & logit_out(Tensor & out, const Tensor & self, c10::optional<double> eps=c10::nullopt);
TORCH_API Tensor & logit_outf(const Tensor & self, c10::optional<double> eps, Tensor & out);
TORCH_API Tensor sin(const Tensor & self);
TORCH_API Tensor & sin_(Tensor & self);
TORCH_API Tensor & sin_out(Tensor & out, const Tensor & self);
TORCH_API Tensor & sin_outf(const Tensor & self, Tensor & out);
TORCH_API Tensor sinc(const Tensor & self);
TORCH_API Tensor & sinc_(Tensor & self);
TORCH_API Tensor & sinc_out(Tensor & out, const Tensor & self);
TORCH_API Tensor & sinc_outf(const Tensor & self, Tensor & out);
TORCH_API Tensor sinh(const Tensor & self);
TORCH_API Tensor & sinh_(Tensor & self);
TORCH_API Tensor & sinh_out(Tensor & out, const Tensor & self);
TORCH_API Tensor & sinh_outf(const Tensor & self, Tensor & out);
TORCH_API Tensor detach(const Tensor & self);
TORCH_API Tensor & detach_(Tensor & self);
TORCH_API int64_t __dispatch_size(const Tensor & self, int64_t dim);
TORCH_API int64_t size(const Tensor & self, Dimname dim);
TORCH_API Tensor slice(const Tensor & self, int64_t dim=0, c10::optional<int64_t> start=0, c10::optional<int64_t> end=9223372036854775807, int64_t step=1);
TORCH_API Tensor slice_backward(const Tensor & grad, IntArrayRef input_sizes, int64_t dim, int64_t start, int64_t end, int64_t step);
TORCH_API std::tuple<Tensor,Tensor> slogdet(const Tensor & self);
TORCH_API Tensor smm(const Tensor & self, const Tensor & mat2);
TORCH_API Tensor softmax(const Tensor & self, int64_t dim, c10::optional<ScalarType> dtype=c10::nullopt);
TORCH_API Tensor softmax(const Tensor & self, Dimname dim, c10::optional<ScalarType> dtype=c10::nullopt);
TORCH_API Tensor _softmax(const Tensor & self, int64_t dim, bool half_to_float);
TORCH_API Tensor _softmax_backward_data(const Tensor & grad_output, const Tensor & output, int64_t dim, const Tensor & self);
TORCH_API std::vector<Tensor> unsafe_split(const Tensor & self, int64_t split_size, int64_t dim=0);
TORCH_API std::vector<Tensor> split(const Tensor & self, int64_t split_size, int64_t dim=0);
TORCH_API std::vector<Tensor> unsafe_split_with_sizes(const Tensor & self, IntArrayRef split_sizes, int64_t dim=0);
TORCH_API std::vector<Tensor> split_with_sizes(const Tensor & self, IntArrayRef split_sizes, int64_t dim=0);
TORCH_API Tensor squeeze(const Tensor & self);
TORCH_API Tensor squeeze(const Tensor & self, int64_t dim);
TORCH_API Tensor squeeze(const Tensor & self, Dimname dim);
TORCH_API Tensor sspaddmm(const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta=1, Scalar alpha=1);
TORCH_API Tensor & sspaddmm_out(Tensor & out, const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta=1, Scalar alpha=1);
TORCH_API Tensor & sspaddmm_outf(const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta, Scalar alpha, Tensor & out);
TORCH_API Tensor stack(TensorList tensors, int64_t dim=0);
TORCH_API Tensor & stack_out(Tensor & out, TensorList tensors, int64_t dim=0);
TORCH_API Tensor & stack_outf(TensorList tensors, int64_t dim, Tensor & out);
TORCH_API Tensor _stack(TensorList tensors, int64_t dim=0);
TORCH_API Tensor & _stack_out(Tensor & out, TensorList tensors, int64_t dim=0);
TORCH_API Tensor & _stack_outf(TensorList tensors, int64_t dim, Tensor & out);
TORCH_API Tensor hstack(TensorList tensors);
TORCH_API Tensor & hstack_out(Tensor & out, TensorList tensors);
TORCH_API Tensor & hstack_outf(TensorList tensors, Tensor & out);
TORCH_API Tensor vstack(TensorList tensors);
TORCH_API Tensor & vstack_out(Tensor & out, TensorList tensors);
TORCH_API Tensor & vstack_outf(TensorList tensors, Tensor & out);
TORCH_API Tensor dstack(TensorList tensors);
TORCH_API Tensor & dstack_out(Tensor & out, TensorList tensors);
TORCH_API Tensor & dstack_outf(TensorList tensors, Tensor & out);
TORCH_API Tensor stft(const Tensor & self, int64_t n_fft, c10::optional<int64_t> hop_length=c10::nullopt, c10::optional<int64_t> win_length=c10::nullopt, const c10::optional<Tensor> & window={}, bool normalized=false, c10::optional<bool> onesided=c10::nullopt, c10::optional<bool> return_complex=c10::nullopt);
TORCH_API Tensor istft(const Tensor & self, int64_t n_fft, c10::optional<int64_t> hop_length=c10::nullopt, c10::optional<int64_t> win_length=c10::nullopt, const c10::optional<Tensor> & window={}, bool center=true, bool normalized=false, c10::optional<bool> onesided=c10::nullopt, c10::optional<int64_t> length=c10::nullopt, bool return_complex=false);
TORCH_API int64_t __dispatch_stride(const Tensor & self, int64_t dim);
TORCH_API int64_t stride(const Tensor & self, Dimname dim);
TORCH_API Tensor sum(const Tensor & self, c10::optional<ScalarType> dtype=c10::nullopt);
TORCH_API Tensor sum(const Tensor & self, IntArrayRef dim, bool keepdim=false, c10::optional<ScalarType> dtype=c10::nullopt);
TORCH_API Tensor sum(const Tensor & self, DimnameList dim, bool keepdim=false, c10::optional<ScalarType> dtype=c10::nullopt);
TORCH_API Tensor & sum_out(Tensor & out, const Tensor & self, IntArrayRef dim, bool keepdim=false, c10::optional<ScalarType> dtype=c10::nullopt);
TORCH_API Tensor & sum_outf(const Tensor & self, IntArrayRef dim, bool keepdim, c10::optional<ScalarType> dtype, Tensor & out);
TORCH_API Tensor & sum_out(Tensor & out, const Tensor & self, DimnameList dim, bool keepdim=false, c10::optional<ScalarType> dtype=c10::nullopt);
TORCH_API Tensor & sum_outf(const Tensor & self, DimnameList dim, bool keepdim, c10::optional<ScalarType> dtype, Tensor & out);
TORCH_API Tensor nansum(const Tensor & self, c10::optional<ScalarType> dtype=c10::nullopt);
TORCH_API Tensor nansum(const Tensor & self, IntArrayRef dim, bool keepdim=false, c10::optional<ScalarType> dtype=c10::nullopt);
TORCH_API Tensor & nansum_out(Tensor & out, const Tensor & self, IntArrayRef dim, bool keepdim=false, c10::optional<ScalarType> dtype=c10::nullopt);
TORCH_API Tensor & nansum_outf(const Tensor & self, IntArrayRef dim, bool keepdim, c10::optional<ScalarType> dtype, Tensor & out);
TORCH_API Tensor sqrt(const Tensor & self);
TORCH_API Tensor & sqrt_(Tensor & self);
TORCH_API Tensor & sqrt_out(Tensor & out, const Tensor & self);
TORCH_API Tensor & sqrt_outf(const Tensor & self, Tensor & out);
TORCH_API Tensor square(const Tensor & self);
TORCH_API Tensor & square_(Tensor & self);
TORCH_API Tensor std(const Tensor & self, bool unbiased=true);
TORCH_API Tensor std(const Tensor & self, IntArrayRef dim, bool unbiased=true, bool keepdim=false);
TORCH_API std::tuple<Tensor,Tensor> std_mean(const Tensor & self, bool unbiased=true);
TORCH_API std::tuple<Tensor,Tensor> std_mean(const Tensor & self, IntArrayRef dim, bool unbiased=true, bool keepdim=false);
TORCH_API std::tuple<Tensor,Tensor> std_mean(const Tensor & self, DimnameList dim, bool unbiased=true, bool keepdim=false);
TORCH_API Tensor & std_out(Tensor & out, const Tensor & self, IntArrayRef dim, bool unbiased=true, bool keepdim=false);
TORCH_API Tensor & std_outf(const Tensor & self, IntArrayRef dim, bool unbiased, bool keepdim, Tensor & out);
TORCH_API Tensor std(const Tensor & self, DimnameList dim, bool unbiased=true, bool keepdim=false);
TORCH_API Tensor & std_out(Tensor & out, const Tensor & self, DimnameList dim, bool unbiased=true, bool keepdim=false);
TORCH_API Tensor & std_outf(const Tensor & self, DimnameList dim, bool unbiased, bool keepdim, Tensor & out);
TORCH_API Tensor prod(const Tensor & self, c10::optional<ScalarType> dtype=c10::nullopt);
TORCH_API Tensor prod(const Tensor & self, int64_t dim, bool keepdim=false, c10::optional<ScalarType> dtype=c10::nullopt);
TORCH_API Tensor & prod_out(Tensor & out, const Tensor & self, int64_t dim, bool keepdim=false, c10::optional<ScalarType> dtype=c10::nullopt);
TORCH_API Tensor & prod_outf(const Tensor & self, int64_t dim, bool keepdim, c10::optional<ScalarType> dtype, Tensor & out);
TORCH_API Tensor prod(const Tensor & self, Dimname dim, bool keepdim=false, c10::optional<ScalarType> dtype=c10::nullopt);
TORCH_API Tensor & prod_out(Tensor & out, const Tensor & self, Dimname dim, bool keepdim=false, c10::optional<ScalarType> dtype=c10::nullopt);
TORCH_API Tensor & prod_outf(const Tensor & self, Dimname dim, bool keepdim, c10::optional<ScalarType> dtype, Tensor & out);
TORCH_API Tensor t(const Tensor & self);
TORCH_API Tensor tan(const Tensor & self);
TORCH_API Tensor & tan_(Tensor & self);
TORCH_API Tensor & tan_out(Tensor & out, const Tensor & self);
TORCH_API Tensor & tan_outf(const Tensor & self, Tensor & out);
TORCH_API Tensor tanh(const Tensor & self);
TORCH_API Tensor & tanh_(Tensor & self);
TORCH_API Tensor & tanh_out(Tensor & out, const Tensor & self);
TORCH_API Tensor & tanh_outf(const Tensor & self, Tensor & out);
TORCH_API Tensor tensordot(const Tensor & self, const Tensor & other, IntArrayRef dims_self, IntArrayRef dims_other);
TORCH_API Tensor & tensordot_out(Tensor & out, const Tensor & self, const Tensor & other, IntArrayRef dims_self, IntArrayRef dims_other);
TORCH_API Tensor & tensordot_outf(const Tensor & self, const Tensor & other, IntArrayRef dims_self, IntArrayRef dims_other, Tensor & out);
TORCH_API Tensor threshold(const Tensor & self, Scalar threshold, Scalar value);
TORCH_API Tensor & threshold_(Tensor & self, Scalar threshold, Scalar value);
TORCH_API Tensor & threshold_out(Tensor & out, const Tensor & self, Scalar threshold, Scalar value);
TORCH_API Tensor & threshold_outf(const Tensor & self, Scalar threshold, Scalar value, Tensor & out);
TORCH_API Tensor threshold_backward(const Tensor & grad_output, const Tensor & self, Scalar threshold);
TORCH_API Tensor tile(const Tensor & self, IntArrayRef dims);
TORCH_API Tensor transpose(const Tensor & self, int64_t dim0, int64_t dim1);
TORCH_API Tensor transpose(const Tensor & self, Dimname dim0, Dimname dim1);
TORCH_API Tensor _mkldnn_transpose(const Tensor & self, int64_t dim0, int64_t dim1);
TORCH_API Tensor & _mkldnn_transpose_(Tensor & self, int64_t dim0, int64_t dim1);
TORCH_API Tensor one_hot(const Tensor & self, int64_t num_classes=-1);
TORCH_API Tensor flip(const Tensor & self, IntArrayRef dims);
TORCH_API Tensor fliplr(const Tensor & self);
TORCH_API Tensor flipud(const Tensor & self);
TORCH_API Tensor roll(const Tensor & self, IntArrayRef shifts, IntArrayRef dims={});
TORCH_API Tensor rot90(const Tensor & self, int64_t k=1, IntArrayRef dims={0,1});
TORCH_API Tensor trapz(const Tensor & y, const Tensor & x, int64_t dim=-1);
TORCH_API Tensor trapz(const Tensor & y, double dx=1, int64_t dim=-1);
TORCH_API Tensor _trilinear(const Tensor & i1, const Tensor & i2, const Tensor & i3, IntArrayRef expand1, IntArrayRef expand2, IntArrayRef expand3, IntArrayRef sumdim, int64_t unroll_dim=1);
TORCH_API Tensor triplet_margin_loss(const Tensor & anchor, const Tensor & positive, const Tensor & negative, double margin=1.0, double p=2, double eps=1e-06, bool swap=false, int64_t reduction=at::Reduction::Mean);
TORCH_API Tensor trunc(const Tensor & self);
TORCH_API Tensor & trunc_(Tensor & self);
TORCH_API Tensor & trunc_out(Tensor & out, const Tensor & self);
TORCH_API Tensor & trunc_outf(const Tensor & self, Tensor & out);
TORCH_API Tensor fix(const Tensor & self);
TORCH_API Tensor & fix_(Tensor & self);
TORCH_API Tensor & fix_out(Tensor & out, const Tensor & self);
TORCH_API Tensor & fix_outf(const Tensor & self, Tensor & out);
TORCH_API bool _has_compatible_shallow_copy_type(const Tensor & self, const Tensor & from);
TORCH_API std::tuple<Tensor,Tensor> _unique(const Tensor & self, bool sorted=true, bool return_inverse=false);
TORCH_API std::tuple<Tensor,Tensor,Tensor> unique_dim(const Tensor & self, int64_t dim, bool sorted=true, bool return_inverse=false, bool return_counts=false);
TORCH_API std::tuple<Tensor,Tensor,Tensor> unique_consecutive(const Tensor & self, bool return_inverse=false, bool return_counts=false, c10::optional<int64_t> dim=c10::nullopt);
TORCH_API std::tuple<Tensor,Tensor,Tensor> unique_dim_consecutive(const Tensor & self, int64_t dim, bool return_inverse=false, bool return_counts=false);
TORCH_API std::tuple<Tensor,Tensor,Tensor> _unique2(const Tensor & self, bool sorted=true, bool return_inverse=false, bool return_counts=false);
TORCH_API Tensor _unsafe_view(const Tensor & self, IntArrayRef size);
TORCH_API Tensor unsqueeze(const Tensor & self, int64_t dim);
TORCH_API Tensor vander(const Tensor & x, c10::optional<int64_t> N=c10::nullopt, bool increasing=false);
TORCH_API Tensor var(const Tensor & self, bool unbiased=true);
TORCH_API Tensor var(const Tensor & self, IntArrayRef dim, bool unbiased=true, bool keepdim=false);
TORCH_API Tensor & var_out(Tensor & out, const Tensor & self, IntArrayRef dim, bool unbiased=true, bool keepdim=false);
TORCH_API Tensor & var_outf(const Tensor & self, IntArrayRef dim, bool unbiased, bool keepdim, Tensor & out);
TORCH_API Tensor var(const Tensor & self, DimnameList dim, bool unbiased=true, bool keepdim=false);
TORCH_API Tensor & var_out(Tensor & out, const Tensor & self, DimnameList dim, bool unbiased=true, bool keepdim=false);
TORCH_API Tensor & var_outf(const Tensor & self, DimnameList dim, bool unbiased, bool keepdim, Tensor & out);
TORCH_API std::tuple<Tensor,Tensor> var_mean(const Tensor & self, bool unbiased=true);
TORCH_API std::tuple<Tensor,Tensor> var_mean(const Tensor & self, IntArrayRef dim, bool unbiased=true, bool keepdim=false);
TORCH_API std::tuple<Tensor,Tensor> var_mean(const Tensor & self, DimnameList dim, bool unbiased=true, bool keepdim=false);
TORCH_API Tensor where(const Tensor & condition, const Tensor & self, const Tensor & other);
TORCH_API Tensor where(const Tensor & condition, Scalar self, const Tensor & other);
TORCH_API Tensor where(const Tensor & condition, const Tensor & self, Scalar other);
TORCH_API Tensor where(const Tensor & condition, Scalar self, Scalar other);
TORCH_API std::vector<Tensor> where(const Tensor & condition);
TORCH_API Tensor _s_where(const Tensor & condition, const Tensor & self, const Tensor & other);
TORCH_API Tensor norm_except_dim(const Tensor & v, int64_t pow=2, int64_t dim=0);
TORCH_API Tensor _weight_norm(const Tensor & v, const Tensor & g, int64_t dim=0);
TORCH_API std::tuple<Tensor,Tensor> _weight_norm_cuda_interface(const Tensor & v, const Tensor & g, int64_t dim=0);
TORCH_API std::tuple<Tensor,Tensor> _weight_norm_cuda_interface_backward(const Tensor & grad_w, const Tensor & saved_v, const Tensor & saved_g, const Tensor & saved_norms, int64_t dim);
TORCH_API std::tuple<Tensor,Tensor> _weight_norm_differentiable_backward(const Tensor & grad_w, const Tensor & saved_v, const Tensor & saved_g, const Tensor & saved_norms, int64_t dim);
TORCH_API Tensor zeros(IntArrayRef size, c10::optional<DimnameList> names, TensorOptions options={});
TORCH_API Tensor zeros(IntArrayRef size, c10::optional<DimnameList> names, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory);
TORCH_API Tensor zeros(IntArrayRef size, TensorOptions options={});
TORCH_API Tensor zeros(IntArrayRef size, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory);
TORCH_API Tensor & zeros_out(Tensor & out, IntArrayRef size);
TORCH_API Tensor & zeros_outf(IntArrayRef size, Tensor & out);
TORCH_API Tensor zeros_like(const Tensor & self, TensorOptions options={}, c10::optional<MemoryFormat> memory_format=c10::nullopt);
TORCH_API Tensor zeros_like(const Tensor & self, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory, c10::optional<MemoryFormat> memory_format);
TORCH_API Tensor _standard_gamma_grad(const Tensor & self, const Tensor & output);
TORCH_API Tensor _standard_gamma(const Tensor & self, c10::optional<Generator> generator=c10::nullopt);
TORCH_API Tensor _dirichlet_grad(const Tensor & x, const Tensor & alpha, const Tensor & total);
TORCH_API Tensor _sample_dirichlet(const Tensor & self, c10::optional<Generator> generator=c10::nullopt);
TORCH_API Tensor poisson(const Tensor & self, c10::optional<Generator> generator=c10::nullopt);
TORCH_API Tensor binomial(const Tensor & count, const Tensor & prob, c10::optional<Generator> generator=c10::nullopt);
TORCH_API Tensor native_norm(const Tensor & self, Scalar p=2);
TORCH_API Tensor native_norm(const Tensor & self, c10::optional<Scalar> p, IntArrayRef dim, bool keepdim, c10::optional<ScalarType> dtype);
TORCH_API Tensor _sparse_sum(const Tensor & self);
TORCH_API Tensor _sparse_sum(const Tensor & self, ScalarType dtype);
TORCH_API Tensor _sparse_sum(const Tensor & self, IntArrayRef dim);
TORCH_API Tensor _sparse_sum(const Tensor & self, IntArrayRef dim, ScalarType dtype);
TORCH_API Tensor _sparse_sum_backward(const Tensor & grad, const Tensor & self, IntArrayRef dim);
TORCH_API Tensor _sparse_softmax(const Tensor & self, int64_t dim, c10::optional<ScalarType> dtype=c10::nullopt);
TORCH_API Tensor _sparse_softmax(const Tensor & self, Dimname dim, c10::optional<ScalarType> dtype=c10::nullopt);
TORCH_API Tensor _sparse_softmax(const Tensor & self, int64_t dim, bool half_to_float);
TORCH_API Tensor _sparse_softmax_backward_data(const Tensor & grad_output, const Tensor & output, int64_t dim, const Tensor & self);
TORCH_API Tensor _sparse_log_softmax(const Tensor & self, int64_t dim, c10::optional<ScalarType> dtype=c10::nullopt);
TORCH_API Tensor _sparse_log_softmax(const Tensor & self, Dimname dim, c10::optional<ScalarType> dtype=c10::nullopt);
TORCH_API Tensor _sparse_log_softmax(const Tensor & self, int64_t dim, bool half_to_float);
TORCH_API Tensor _sparse_log_softmax_backward_data(const Tensor & grad_output, const Tensor & output, int64_t dim, const Tensor & self);
TORCH_API Tensor norm(const Tensor & self, c10::optional<Scalar> p, ScalarType dtype);
TORCH_API Tensor norm(const Tensor & self, Scalar p=2);
TORCH_API Tensor norm(const Tensor & self, c10::optional<Scalar> p, IntArrayRef dim, bool keepdim, ScalarType dtype);
TORCH_API Tensor norm(const Tensor & self, c10::optional<Scalar> p, IntArrayRef dim, bool keepdim=false);
TORCH_API Tensor & norm_out(Tensor & out, const Tensor & self, c10::optional<Scalar> p, IntArrayRef dim, bool keepdim, ScalarType dtype);
TORCH_API Tensor & norm_outf(const Tensor & self, c10::optional<Scalar> p, IntArrayRef dim, bool keepdim, ScalarType dtype, Tensor & out);
TORCH_API Tensor & norm_out(Tensor & out, const Tensor & self, c10::optional<Scalar> p, IntArrayRef dim, bool keepdim=false);
TORCH_API Tensor & norm_outf(const Tensor & self, c10::optional<Scalar> p, IntArrayRef dim, bool keepdim, Tensor & out);
TORCH_API Tensor norm(const Tensor & self, c10::optional<Scalar> p, DimnameList dim, bool keepdim, ScalarType dtype);
TORCH_API Tensor norm(const Tensor & self, c10::optional<Scalar> p, DimnameList dim, bool keepdim=false);
TORCH_API Tensor & norm_out(Tensor & out, const Tensor & self, c10::optional<Scalar> p, DimnameList dim, bool keepdim, ScalarType dtype);
TORCH_API Tensor & norm_outf(const Tensor & self, c10::optional<Scalar> p, DimnameList dim, bool keepdim, ScalarType dtype, Tensor & out);
TORCH_API Tensor & norm_out(Tensor & out, const Tensor & self, c10::optional<Scalar> p, DimnameList dim, bool keepdim=false);
TORCH_API Tensor & norm_outf(const Tensor & self, c10::optional<Scalar> p, DimnameList dim, bool keepdim, Tensor & out);
TORCH_API Tensor frobenius_norm(const Tensor & self);
TORCH_API Tensor frobenius_norm(const Tensor & self, IntArrayRef dim, bool keepdim=false);
TORCH_API Tensor & frobenius_norm_out(Tensor & out, const Tensor & self, IntArrayRef dim, bool keepdim=false);
TORCH_API Tensor & frobenius_norm_outf(const Tensor & self, IntArrayRef dim, bool keepdim, Tensor & out);
TORCH_API Tensor nuclear_norm(const Tensor & self, bool keepdim=false);
TORCH_API Tensor & nuclear_norm_out(Tensor & out, const Tensor & self, bool keepdim=false);
TORCH_API Tensor & nuclear_norm_outf(const Tensor & self, bool keepdim, Tensor & out);
TORCH_API Tensor nuclear_norm(const Tensor & self, IntArrayRef dim, bool keepdim=false);
TORCH_API Tensor & nuclear_norm_out(Tensor & out, const Tensor & self, IntArrayRef dim, bool keepdim=false);
TORCH_API Tensor & nuclear_norm_outf(const Tensor & self, IntArrayRef dim, bool keepdim, Tensor & out);
TORCH_API Tensor clone(const Tensor & self, c10::optional<MemoryFormat> memory_format=c10::nullopt);
TORCH_API Tensor & resize_as_(Tensor & self, const Tensor & the_template, c10::optional<MemoryFormat> memory_format=c10::nullopt);
TORCH_API Tensor & zero_(Tensor & self);
TORCH_API Tensor & sub_out(Tensor & out, const Tensor & self, const Tensor & other, Scalar alpha=1);
TORCH_API Tensor & sub_outf(const Tensor & self, const Tensor & other, Scalar alpha, Tensor & out);
TORCH_API Tensor sub(const Tensor & self, const Tensor & other, Scalar alpha=1);
TORCH_API Tensor sub(const Tensor & self, Scalar other, Scalar alpha=1);
TORCH_API Tensor & subtract_out(Tensor & out, const Tensor & self, const Tensor & other, Scalar alpha=1);
TORCH_API Tensor & subtract_outf(const Tensor & self, const Tensor & other, Scalar alpha, Tensor & out);
TORCH_API Tensor subtract(const Tensor & self, const Tensor & other, Scalar alpha=1);
TORCH_API Tensor subtract(const Tensor & self, Scalar other, Scalar alpha=1);
TORCH_API Tensor rsub(const Tensor & self, const Tensor & other, Scalar alpha=1);
TORCH_API Tensor & heaviside_out(Tensor & out, const Tensor & self, const Tensor & values);
TORCH_API Tensor & heaviside_outf(const Tensor & self, const Tensor & values, Tensor & out);
TORCH_API Tensor heaviside(const Tensor & self, const Tensor & values);
TORCH_API Tensor rsub(const Tensor & self, Scalar other, Scalar alpha=1);
TORCH_API Tensor _sparse_addmm(const Tensor & self, const Tensor & sparse, const Tensor & dense, Scalar beta=1, Scalar alpha=1);
TORCH_API Tensor & addmm_out(Tensor & out, const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta=1, Scalar alpha=1);
TORCH_API Tensor & addmm_outf(const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta, Scalar alpha, Tensor & out);
TORCH_API Tensor addmm(const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta=1, Scalar alpha=1);
TORCH_API Tensor sparse_coo_tensor(IntArrayRef size, TensorOptions options);
TORCH_API Tensor sparse_coo_tensor(IntArrayRef size, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory);
TORCH_API Tensor sparse_coo_tensor(const Tensor & indices, const Tensor & values, TensorOptions options={});
TORCH_API Tensor sparse_coo_tensor(const Tensor & indices, const Tensor & values, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory);
TORCH_API Tensor sparse_coo_tensor(const Tensor & indices, const Tensor & values, IntArrayRef size, TensorOptions options={});
TORCH_API Tensor sparse_coo_tensor(const Tensor & indices, const Tensor & values, IntArrayRef size, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory);
TORCH_API Tensor _sparse_coo_tensor_unsafe(const Tensor & indices, const Tensor & values, IntArrayRef size, TensorOptions options={});
TORCH_API Tensor _sparse_coo_tensor_unsafe(const Tensor & indices, const Tensor & values, IntArrayRef size, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory);
TORCH_API void _validate_sparse_coo_tensor_args(const Tensor & indices, const Tensor & values, IntArrayRef size);
TORCH_API Tensor _sparse_coo_tensor_with_dims(int64_t sparse_dim, int64_t dense_dim, IntArrayRef size, TensorOptions options);
TORCH_API Tensor _sparse_coo_tensor_with_dims(int64_t sparse_dim, int64_t dense_dim, IntArrayRef size, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory);
TORCH_API Tensor _sparse_coo_tensor_with_dims_and_tensors(int64_t sparse_dim, int64_t dense_dim, IntArrayRef size, const Tensor & indices, const Tensor & values, TensorOptions options);
TORCH_API Tensor _sparse_coo_tensor_with_dims_and_tensors(int64_t sparse_dim, int64_t dense_dim, IntArrayRef size, const Tensor & indices, const Tensor & values, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory);
TORCH_API Tensor to_dense_backward(const Tensor & grad, const Tensor & input);
TORCH_API Tensor & hspmm_out(Tensor & out, const Tensor & mat1, const Tensor & mat2);
TORCH_API Tensor & hspmm_outf(const Tensor & mat1, const Tensor & mat2, Tensor & out);
TORCH_API Tensor hspmm(const Tensor & mat1, const Tensor & mat2);
TORCH_API Tensor & copy_sparse_to_sparse_(Tensor & self, const Tensor & src, bool non_blocking=false);
TORCH_API std::vector<Tensor> unbind(const Tensor & self, int64_t dim=0);
TORCH_API std::vector<Tensor> unbind(const Tensor & self, Dimname dim);
TORCH_API Tensor mkldnn_reorder_conv2d_weight(const Tensor & self, IntArrayRef padding=0, IntArrayRef stride=1, IntArrayRef dilation=1, int64_t groups=1);
TORCH_API Tensor mkldnn_reorder_conv3d_weight(const Tensor & self, IntArrayRef padding=0, IntArrayRef stride=1, IntArrayRef dilation=1, int64_t groups=1);
TORCH_API Tensor to_mkldnn_backward(const Tensor & grad, const Tensor & input);
TORCH_API Tensor quantize_per_tensor(const Tensor & self, double scale, int64_t zero_point, ScalarType dtype);
TORCH_API std::vector<Tensor> quantize_per_tensor(TensorList tensors, const Tensor & scales, const Tensor & zero_points, ScalarType dtype);
TORCH_API Tensor quantize_per_channel(const Tensor & self, const Tensor & scales, const Tensor & zero_points, int64_t axis, ScalarType dtype);
TORCH_API Tensor dequantize(const Tensor & self);
TORCH_API std::vector<Tensor> dequantize(TensorList tensors);
TORCH_API double q_scale(const Tensor & self);
TORCH_API int64_t q_zero_point(const Tensor & self);
TORCH_API Tensor q_per_channel_scales(const Tensor & self);
TORCH_API Tensor q_per_channel_zero_points(const Tensor & self);
TORCH_API int64_t q_per_channel_axis(const Tensor & self);
TORCH_API Tensor int_repr(const Tensor & self);
TORCH_API Tensor _make_per_tensor_quantized_tensor(const Tensor & self, double scale, int64_t zero_point);
TORCH_API Tensor _make_per_channel_quantized_tensor(const Tensor & self, const Tensor & scale, const Tensor & zero_point, int64_t axis);
TORCH_API Tensor fake_quantize_per_tensor_affine(const Tensor & self, double scale, int64_t zero_point, int64_t quant_min, int64_t quant_max);
TORCH_API std::tuple<Tensor,Tensor> fake_quantize_per_tensor_affine_cachemask(const Tensor & self, double scale, int64_t zero_point, int64_t quant_min, int64_t quant_max);
TORCH_API Tensor fake_quantize_per_tensor_affine_cachemask_backward(const Tensor & grad, const Tensor & mask);
TORCH_API Tensor _fake_quantize_learnable_per_tensor_affine(const Tensor & self, const Tensor & scale, const Tensor & zero_point, int64_t quant_min, int64_t quant_max, double grad_factor=1.0);
TORCH_API std::tuple<Tensor,Tensor,Tensor> _fake_quantize_learnable_per_tensor_affine_backward(const Tensor & grad, const Tensor & self, const Tensor & scale, const Tensor & zero_point, int64_t quant_min, int64_t quant_max, double grad_factor=1.0);
TORCH_API Tensor fake_quantize_per_channel_affine(const Tensor & self, const Tensor & scale, const Tensor & zero_point, int64_t axis, int64_t quant_min, int64_t quant_max);
TORCH_API std::tuple<Tensor,Tensor> fake_quantize_per_channel_affine_cachemask(const Tensor & self, const Tensor & scale, const Tensor & zero_point, int64_t axis, int64_t quant_min, int64_t quant_max);
TORCH_API Tensor fake_quantize_per_channel_affine_cachemask_backward(const Tensor & grad, const Tensor & mask);
TORCH_API Tensor _fake_quantize_learnable_per_channel_affine(const Tensor & self, const Tensor & scale, const Tensor & zero_point, int64_t axis, int64_t quant_min, int64_t quant_max, double grad_factor=1.0);
TORCH_API std::tuple<Tensor,Tensor,Tensor> _fake_quantize_learnable_per_channel_affine_backward(const Tensor & grad, const Tensor & self, const Tensor & scale, const Tensor & zero_point, int64_t axis, int64_t quant_min, int64_t quant_max, double grad_factor=1.0);
TORCH_API std::tuple<double,int64_t> _choose_qparams_per_tensor(const Tensor & self, bool reduce_range=false);
TORCH_API Tensor _saturate_weight_to_fp16(const Tensor & weight);
TORCH_API std::tuple<Tensor,Tensor> choose_qparams_optimized(const Tensor & input, int64_t numel, int64_t n_bins, double ratio, int64_t bit_width);
TORCH_API std::vector<Tensor> meshgrid(TensorList tensors);
TORCH_API Tensor cartesian_prod(TensorList tensors);
TORCH_API Tensor combinations(const Tensor & self, int64_t r=2, bool with_replacement=false);
TORCH_API ScalarType result_type(const Tensor & tensor, const Tensor & other);
TORCH_API ScalarType result_type(const Tensor & tensor, Scalar other);
TORCH_API ScalarType result_type(Scalar scalar, const Tensor & tensor);
TORCH_API ScalarType result_type(Scalar scalar1, Scalar scalar2);
TORCH_API bool can_cast(ScalarType from, ScalarType to);
TORCH_API ScalarType promote_types(ScalarType type1, ScalarType type2);
TORCH_API Scalar _local_scalar_dense(const Tensor & self);
TORCH_API std::tuple<Tensor,Tensor,Tensor> _thnn_fused_lstm_cell(const Tensor & input_gates, const Tensor & hidden_gates, const Tensor & cx, const c10::optional<Tensor> & input_bias={}, const c10::optional<Tensor> & hidden_bias={});
TORCH_API std::tuple<Tensor,Tensor,Tensor,Tensor,Tensor> _thnn_fused_lstm_cell_backward(const c10::optional<Tensor> & grad_hy, const c10::optional<Tensor> & grad_cy, const Tensor & cx, const Tensor & cy, const Tensor & workspace, bool has_bias);
TORCH_API std::tuple<Tensor,Tensor,Tensor,Tensor,Tensor> _thnn_differentiable_lstm_cell_backward(const c10::optional<Tensor> & grad_hy, const c10::optional<Tensor> & grad_cy, const Tensor & input_gates, const Tensor & hidden_gates, const c10::optional<Tensor> & input_bias, const c10::optional<Tensor> & hidden_bias, const Tensor & cx, const Tensor & cy);
TORCH_API std::tuple<Tensor,Tensor> _thnn_fused_gru_cell(const Tensor & input_gates, const Tensor & hidden_gates, const Tensor & hx, const c10::optional<Tensor> & input_bias={}, const c10::optional<Tensor> & hidden_bias={});
TORCH_API std::tuple<Tensor,Tensor,Tensor,Tensor,Tensor> _thnn_fused_gru_cell_backward(const Tensor & grad_hy, const Tensor & workspace, bool has_bias);
TORCH_API std::tuple<Tensor,Tensor,Tensor,Tensor,Tensor> _thnn_differentiable_gru_cell_backward(const Tensor & grad_hy, const Tensor & input_gates, const Tensor & hidden_gates, const Tensor & hx, const c10::optional<Tensor> & input_bias, const c10::optional<Tensor> & hidden_bias);
TORCH_API std::tuple<Tensor,Tensor,Tensor> lstm(const Tensor & input, TensorList hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional, bool batch_first);
TORCH_API std::tuple<Tensor,Tensor,Tensor> lstm(const Tensor & data, const Tensor & batch_sizes, TensorList hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional);
TORCH_API std::tuple<Tensor,Tensor> gru(const Tensor & input, const Tensor & hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional, bool batch_first);
TORCH_API std::tuple<Tensor,Tensor> gru(const Tensor & data, const Tensor & batch_sizes, const Tensor & hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional);
TORCH_API std::tuple<Tensor,Tensor> rnn_tanh(const Tensor & input, const Tensor & hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional, bool batch_first);
TORCH_API std::tuple<Tensor,Tensor> rnn_tanh(const Tensor & data, const Tensor & batch_sizes, const Tensor & hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional);
TORCH_API std::tuple<Tensor,Tensor> rnn_relu(const Tensor & input, const Tensor & hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional, bool batch_first);
TORCH_API std::tuple<Tensor,Tensor> rnn_relu(const Tensor & data, const Tensor & batch_sizes, const Tensor & hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional);
TORCH_API std::tuple<Tensor,Tensor> lstm_cell(const Tensor & input, TensorList hx, const Tensor & w_ih, const Tensor & w_hh, const c10::optional<Tensor> & b_ih={}, const c10::optional<Tensor> & b_hh={});
TORCH_API Tensor gru_cell(const Tensor & input, const Tensor & hx, const Tensor & w_ih, const Tensor & w_hh, const c10::optional<Tensor> & b_ih={}, const c10::optional<Tensor> & b_hh={});
TORCH_API Tensor rnn_tanh_cell(const Tensor & input, const Tensor & hx, const Tensor & w_ih, const Tensor & w_hh, const c10::optional<Tensor> & b_ih={}, const c10::optional<Tensor> & b_hh={});
TORCH_API Tensor rnn_relu_cell(const Tensor & input, const Tensor & hx, const Tensor & w_ih, const Tensor & w_hh, const c10::optional<Tensor> & b_ih={}, const c10::optional<Tensor> & b_hh={});
TORCH_API std::tuple<Tensor,Tensor> quantized_lstm_cell(const Tensor & input, TensorList hx, const Tensor & w_ih, const Tensor & w_hh, const Tensor & b_ih, const Tensor & b_hh, const Tensor & packed_ih, const Tensor & packed_hh, const Tensor & col_offsets_ih, const Tensor & col_offsets_hh, Scalar scale_ih, Scalar scale_hh, Scalar zero_point_ih, Scalar zero_point_hh);
TORCH_API Tensor quantized_gru_cell(const Tensor & input, const Tensor & hx, const Tensor & w_ih, const Tensor & w_hh, const Tensor & b_ih, const Tensor & b_hh, const Tensor & packed_ih, const Tensor & packed_hh, const Tensor & col_offsets_ih, const Tensor & col_offsets_hh, Scalar scale_ih, Scalar scale_hh, Scalar zero_point_ih, Scalar zero_point_hh);
TORCH_API Tensor quantized_rnn_relu_cell(const Tensor & input, const Tensor & hx, const Tensor & w_ih, const Tensor & w_hh, const Tensor & b_ih, const Tensor & b_hh, const Tensor & packed_ih, const Tensor & packed_hh, const Tensor & col_offsets_ih, const Tensor & col_offsets_hh, Scalar scale_ih, Scalar scale_hh, Scalar zero_point_ih, Scalar zero_point_hh);
TORCH_API Tensor quantized_rnn_tanh_cell(const Tensor & input, const Tensor & hx, const Tensor & w_ih, const Tensor & w_hh, const Tensor & b_ih, const Tensor & b_hh, const Tensor & packed_ih, const Tensor & packed_hh, const Tensor & col_offsets_ih, const Tensor & col_offsets_hh, Scalar scale_ih, Scalar scale_hh, Scalar zero_point_ih, Scalar zero_point_hh);
TORCH_API std::tuple<Tensor,Tensor> _pack_padded_sequence(const Tensor & input, const Tensor & lengths, bool batch_first);
TORCH_API Tensor _pack_padded_sequence_backward(const Tensor & grad, IntArrayRef input_size, const Tensor & batch_sizes, bool batch_first);
TORCH_API std::tuple<Tensor,Tensor> _pad_packed_sequence(const Tensor & data, const Tensor & batch_sizes, bool batch_first, Scalar padding_value, int64_t total_length);
TORCH_API Tensor masked_fill(const Tensor & self, const Tensor & mask, Scalar value);
TORCH_API Tensor masked_fill(const Tensor & self, const Tensor & mask, const Tensor & value);
TORCH_API Tensor masked_scatter(const Tensor & self, const Tensor & mask, const Tensor & source);
TORCH_API Tensor index_add(const Tensor & self, int64_t dim, const Tensor & index, const Tensor & source);
TORCH_API Tensor index_add(const Tensor & self, Dimname dim, const Tensor & index, const Tensor & source);
TORCH_API Tensor index_fill(const Tensor & self, int64_t dim, const Tensor & index, Scalar value);
TORCH_API Tensor index_fill(const Tensor & self, int64_t dim, const Tensor & index, const Tensor & value);
TORCH_API Tensor index_fill(const Tensor & self, Dimname dim, const Tensor & index, Scalar value);
TORCH_API Tensor index_fill(const Tensor & self, Dimname dim, const Tensor & index, const Tensor & value);
TORCH_API Tensor scatter(const Tensor & self, int64_t dim, const Tensor & index, const Tensor & src);
TORCH_API Tensor scatter(const Tensor & self, int64_t dim, const Tensor & index, Scalar value);
TORCH_API Tensor scatter(const Tensor & self, Dimname dim, const Tensor & index, const Tensor & src);
TORCH_API Tensor scatter(const Tensor & self, Dimname dim, const Tensor & index, Scalar value);
TORCH_API Tensor scatter_add(const Tensor & self, int64_t dim, const Tensor & index, const Tensor & src);
TORCH_API Tensor scatter_add(const Tensor & self, Dimname dim, const Tensor & index, const Tensor & src);
TORCH_API Tensor & bitwise_and_out(Tensor & out, const Tensor & self, const Tensor & other);
TORCH_API Tensor & bitwise_and_outf(const Tensor & self, const Tensor & other, Tensor & out);
TORCH_API Tensor & bitwise_and_out(Tensor & out, const Tensor & self, Scalar other);
TORCH_API Tensor & bitwise_and_outf(const Tensor & self, Scalar other, Tensor & out);
TORCH_API Tensor bitwise_and(const Tensor & self, Scalar other);
TORCH_API Tensor bitwise_and(const Tensor & self, const Tensor & other);
TORCH_API Tensor __and__(const Tensor & self, Scalar other);
TORCH_API Tensor __and__(const Tensor & self, const Tensor & other);
TORCH_API Tensor & bitwise_or_out(Tensor & out, const Tensor & self, const Tensor & other);
TORCH_API Tensor & bitwise_or_outf(const Tensor & self, const Tensor & other, Tensor & out);
TORCH_API Tensor & bitwise_or_out(Tensor & out, const Tensor & self, Scalar other);
TORCH_API Tensor & bitwise_or_outf(const Tensor & self, Scalar other, Tensor & out);
TORCH_API Tensor bitwise_or(const Tensor & self, Scalar other);
TORCH_API Tensor bitwise_or(const Tensor & self, const Tensor & other);
TORCH_API Tensor __or__(const Tensor & self, Scalar other);
TORCH_API Tensor __or__(const Tensor & self, const Tensor & other);
TORCH_API Tensor & bitwise_xor_out(Tensor & out, const Tensor & self, const Tensor & other);
TORCH_API Tensor & bitwise_xor_outf(const Tensor & self, const Tensor & other, Tensor & out);
TORCH_API Tensor & bitwise_xor_out(Tensor & out, const Tensor & self, Scalar other);
TORCH_API Tensor & bitwise_xor_outf(const Tensor & self, Scalar other, Tensor & out);
TORCH_API Tensor bitwise_xor(const Tensor & self, Scalar other);
TORCH_API Tensor bitwise_xor(const Tensor & self, const Tensor & other);
TORCH_API Tensor __xor__(const Tensor & self, Scalar other);
TORCH_API Tensor __xor__(const Tensor & self, const Tensor & other);
TORCH_API Tensor __lshift__(const Tensor & self, Scalar other);
TORCH_API Tensor __lshift__(const Tensor & self, const Tensor & other);
TORCH_API Tensor __rshift__(const Tensor & self, Scalar other);
TORCH_API Tensor __rshift__(const Tensor & self, const Tensor & other);
TORCH_API Tensor & addbmm_out(Tensor & out, const Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta=1, Scalar alpha=1);
TORCH_API Tensor & addbmm_outf(const Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta, Scalar alpha, Tensor & out);
TORCH_API Tensor addbmm(const Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta=1, Scalar alpha=1);
TORCH_API Tensor & diag_out(Tensor & out, const Tensor & self, int64_t diagonal=0);
TORCH_API Tensor & diag_outf(const Tensor & self, int64_t diagonal, Tensor & out);
TORCH_API Tensor diag(const Tensor & self, int64_t diagonal=0);
TORCH_API Tensor diag_backward(const Tensor & grad, IntArrayRef input_sizes, int64_t diagonal);
TORCH_API Tensor & cross_out(Tensor & out, const Tensor & self, const Tensor & other, c10::optional<int64_t> dim=c10::nullopt);
TORCH_API Tensor & cross_outf(const Tensor & self, const Tensor & other, c10::optional<int64_t> dim, Tensor & out);
TORCH_API Tensor cross(const Tensor & self, const Tensor & other, c10::optional<int64_t> dim=c10::nullopt);
TORCH_API Tensor & triu_out(Tensor & out, const Tensor & self, int64_t diagonal=0);
TORCH_API Tensor & triu_outf(const Tensor & self, int64_t diagonal, Tensor & out);
TORCH_API Tensor triu(const Tensor & self, int64_t diagonal=0);
TORCH_API Tensor & tril_out(Tensor & out, const Tensor & self, int64_t diagonal=0);
TORCH_API Tensor & tril_outf(const Tensor & self, int64_t diagonal, Tensor & out);
TORCH_API Tensor tril(const Tensor & self, int64_t diagonal=0);
TORCH_API Tensor tril_indices(int64_t row, int64_t col, int64_t offset=0, TensorOptions options=at::kLong);
TORCH_API Tensor tril_indices(int64_t row, int64_t col, int64_t offset, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory);
TORCH_API Tensor triu_indices(int64_t row, int64_t col, int64_t offset=0, TensorOptions options=at::kLong);
TORCH_API Tensor triu_indices(int64_t row, int64_t col, int64_t offset, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory);
TORCH_API Tensor trace(const Tensor & self);
TORCH_API Tensor trace_backward(const Tensor & grad, IntArrayRef sizes);
TORCH_API Tensor & ne_out(Tensor & out, const Tensor & self, Scalar other);
TORCH_API Tensor & ne_outf(const Tensor & self, Scalar other, Tensor & out);
TORCH_API Tensor ne(const Tensor & self, Scalar other);
TORCH_API Tensor & ne_out(Tensor & out, const Tensor & self, const Tensor & other);
TORCH_API Tensor & ne_outf(const Tensor & self, const Tensor & other, Tensor & out);
TORCH_API Tensor ne(const Tensor & self, const Tensor & other);
TORCH_API Tensor & not_equal_out(Tensor & out, const Tensor & self, Scalar other);
TORCH_API Tensor & not_equal_outf(const Tensor & self, Scalar other, Tensor & out);
TORCH_API Tensor not_equal(const Tensor & self, Scalar other);
TORCH_API Tensor & not_equal_out(Tensor & out, const Tensor & self, const Tensor & other);
TORCH_API Tensor & not_equal_outf(const Tensor & self, const Tensor & other, Tensor & out);
TORCH_API Tensor not_equal(const Tensor & self, const Tensor & other);
TORCH_API Tensor & eq_out(Tensor & out, const Tensor & self, Scalar other);
TORCH_API Tensor & eq_outf(const Tensor & self, Scalar other, Tensor & out);
TORCH_API Tensor eq(const Tensor & self, Scalar other);
TORCH_API Tensor & eq_out(Tensor & out, const Tensor & self, const Tensor & other);
TORCH_API Tensor & eq_outf(const Tensor & self, const Tensor & other, Tensor & out);
TORCH_API Tensor eq(const Tensor & self, const Tensor & other);
TORCH_API Tensor & ge_out(Tensor & out, const Tensor & self, Scalar other);
TORCH_API Tensor & ge_outf(const Tensor & self, Scalar other, Tensor & out);
TORCH_API Tensor ge(const Tensor & self, Scalar other);
TORCH_API Tensor & ge_out(Tensor & out, const Tensor & self, const Tensor & other);
TORCH_API Tensor & ge_outf(const Tensor & self, const Tensor & other, Tensor & out);
TORCH_API Tensor ge(const Tensor & self, const Tensor & other);
TORCH_API Tensor & greater_equal_out(Tensor & out, const Tensor & self, Scalar other);
TORCH_API Tensor & greater_equal_outf(const Tensor & self, Scalar other, Tensor & out);
TORCH_API Tensor greater_equal(const Tensor & self, Scalar other);
TORCH_API Tensor & greater_equal_out(Tensor & out, const Tensor & self, const Tensor & other);
TORCH_API Tensor & greater_equal_outf(const Tensor & self, const Tensor & other, Tensor & out);
TORCH_API Tensor greater_equal(const Tensor & self, const Tensor & other);
TORCH_API Tensor & le_out(Tensor & out, const Tensor & self, Scalar other);
TORCH_API Tensor & le_outf(const Tensor & self, Scalar other, Tensor & out);
TORCH_API Tensor le(const Tensor & self, Scalar other);
TORCH_API Tensor & le_out(Tensor & out, const Tensor & self, const Tensor & other);
TORCH_API Tensor & le_outf(const Tensor & self, const Tensor & other, Tensor & out);
TORCH_API Tensor le(const Tensor & self, const Tensor & other);
TORCH_API Tensor & less_equal_out(Tensor & out, const Tensor & self, Scalar other);
TORCH_API Tensor & less_equal_outf(const Tensor & self, Scalar other, Tensor & out);
TORCH_API Tensor less_equal(const Tensor & self, Scalar other);
TORCH_API Tensor & less_equal_out(Tensor & out, const Tensor & self, const Tensor & other);
TORCH_API Tensor & less_equal_outf(const Tensor & self, const Tensor & other, Tensor & out);
TORCH_API Tensor less_equal(const Tensor & self, const Tensor & other);
TORCH_API Tensor & gt_out(Tensor & out, const Tensor & self, Scalar other);
TORCH_API Tensor & gt_outf(const Tensor & self, Scalar other, Tensor & out);
TORCH_API Tensor gt(const Tensor & self, Scalar other);
TORCH_API Tensor & gt_out(Tensor & out, const Tensor & self, const Tensor & other);
TORCH_API Tensor & gt_outf(const Tensor & self, const Tensor & other, Tensor & out);
TORCH_API Tensor gt(const Tensor & self, const Tensor & other);
TORCH_API Tensor & greater_out(Tensor & out, const Tensor & self, Scalar other);
TORCH_API Tensor & greater_outf(const Tensor & self, Scalar other, Tensor & out);
TORCH_API Tensor greater(const Tensor & self, Scalar other);
TORCH_API Tensor & greater_out(Tensor & out, const Tensor & self, const Tensor & other);
TORCH_API Tensor & greater_outf(const Tensor & self, const Tensor & other, Tensor & out);
TORCH_API Tensor greater(const Tensor & self, const Tensor & other);
TORCH_API Tensor & lt_out(Tensor & out, const Tensor & self, Scalar other);
TORCH_API Tensor & lt_outf(const Tensor & self, Scalar other, Tensor & out);
TORCH_API Tensor lt(const Tensor & self, Scalar other);
TORCH_API Tensor & lt_out(Tensor & out, const Tensor & self, const Tensor & other);
TORCH_API Tensor & lt_outf(const Tensor & self, const Tensor & other, Tensor & out);
TORCH_API Tensor lt(const Tensor & self, const Tensor & other);
TORCH_API Tensor & less_out(Tensor & out, const Tensor & self, Scalar other);
TORCH_API Tensor & less_outf(const Tensor & self, Scalar other, Tensor & out);
TORCH_API Tensor less(const Tensor & self, Scalar other);
TORCH_API Tensor & less_out(Tensor & out, const Tensor & self, const Tensor & other);
TORCH_API Tensor & less_outf(const Tensor & self, const Tensor & other, Tensor & out);
TORCH_API Tensor less(const Tensor & self, const Tensor & other);
TORCH_API Tensor & take_out(Tensor & out, const Tensor & self, const Tensor & index);
TORCH_API Tensor & take_outf(const Tensor & self, const Tensor & index, Tensor & out);
TORCH_API Tensor take(const Tensor & self, const Tensor & index);
TORCH_API Tensor take_backward(const Tensor & grad, const Tensor & input, const Tensor & index);
TORCH_API Tensor & index_select_out(Tensor & out, const Tensor & self, int64_t dim, const Tensor & index);
TORCH_API Tensor & index_select_outf(const Tensor & self, int64_t dim, const Tensor & index, Tensor & out);
TORCH_API Tensor index_select(const Tensor & self, int64_t dim, const Tensor & index);
TORCH_API Tensor & index_select_out(Tensor & out, const Tensor & self, Dimname dim, const Tensor & index);
TORCH_API Tensor & index_select_outf(const Tensor & self, Dimname dim, const Tensor & index, Tensor & out);
TORCH_API Tensor index_select(const Tensor & self, Dimname dim, const Tensor & index);
TORCH_API Tensor index_select_backward(const Tensor & grad, IntArrayRef self_sizes, int64_t dim, const Tensor & index);
TORCH_API Tensor & masked_select_out(Tensor & out, const Tensor & self, const Tensor & mask);
TORCH_API Tensor & masked_select_outf(const Tensor & self, const Tensor & mask, Tensor & out);
TORCH_API Tensor masked_select(const Tensor & self, const Tensor & mask);
TORCH_API Tensor masked_select_backward(const Tensor & grad, const Tensor & input, const Tensor & mask);
TORCH_API Tensor & nonzero_out(Tensor & out, const Tensor & self);
TORCH_API Tensor & nonzero_outf(const Tensor & self, Tensor & out);
TORCH_API Tensor nonzero(const Tensor & self);
TORCH_API std::vector<Tensor> nonzero_numpy(const Tensor & self);
TORCH_API Tensor & gather_out(Tensor & out, const Tensor & self, int64_t dim, const Tensor & index, bool sparse_grad=false);
TORCH_API Tensor & gather_outf(const Tensor & self, int64_t dim, const Tensor & index, bool sparse_grad, Tensor & out);
TORCH_API Tensor gather(const Tensor & self, int64_t dim, const Tensor & index, bool sparse_grad=false);
TORCH_API Tensor gather_backward(const Tensor & grad, const Tensor & self, int64_t dim, const Tensor & index, bool sparse_grad);
TORCH_API Tensor & gather_out(Tensor & out, const Tensor & self, Dimname dim, const Tensor & index, bool sparse_grad=false);
TORCH_API Tensor & gather_outf(const Tensor & self, Dimname dim, const Tensor & index, bool sparse_grad, Tensor & out);
TORCH_API Tensor gather(const Tensor & self, Dimname dim, const Tensor & index, bool sparse_grad=false);
TORCH_API Tensor _gather_sparse_backward(const Tensor & self, int64_t dim, const Tensor & index, const Tensor & grad);
TORCH_API Tensor & addcmul_out(Tensor & out, const Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value=1);
TORCH_API Tensor & addcmul_outf(const Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value, Tensor & out);
TORCH_API Tensor addcmul(const Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value=1);
TORCH_API Tensor & addcdiv_out(Tensor & out, const Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value=1);
TORCH_API Tensor & addcdiv_outf(const Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value, Tensor & out);
TORCH_API Tensor addcdiv(const Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value=1);
TORCH_API std::tuple<Tensor &,Tensor &> lstsq_out(Tensor & X, Tensor & qr, const Tensor & self, const Tensor & A);
TORCH_API std::tuple<Tensor &,Tensor &> lstsq_outf(const Tensor & self, const Tensor & A, Tensor & X, Tensor & qr);
TORCH_API std::tuple<Tensor,Tensor> lstsq(const Tensor & self, const Tensor & A);
TORCH_API std::tuple<Tensor &,Tensor &> triangular_solve_out(Tensor & X, Tensor & M, const Tensor & self, const Tensor & A, bool upper=true, bool transpose=false, bool unitriangular=false);
TORCH_API std::tuple<Tensor &,Tensor &> triangular_solve_outf(const Tensor & self, const Tensor & A, bool upper, bool transpose, bool unitriangular, Tensor & X, Tensor & M);
TORCH_API std::tuple<Tensor,Tensor> triangular_solve(const Tensor & self, const Tensor & A, bool upper=true, bool transpose=false, bool unitriangular=false);
TORCH_API std::tuple<Tensor,Tensor> _triangular_solve_helper(const Tensor & self, const Tensor & A, bool upper, bool transpose, bool unitriangular);
TORCH_API std::tuple<Tensor &,Tensor &> symeig_out(Tensor & e, Tensor & V, const Tensor & self, bool eigenvectors=false, bool upper=true);
TORCH_API std::tuple<Tensor &,Tensor &> symeig_outf(const Tensor & self, bool eigenvectors, bool upper, Tensor & e, Tensor & V);
TORCH_API std::tuple<Tensor,Tensor> symeig(const Tensor & self, bool eigenvectors=false, bool upper=true);
TORCH_API std::tuple<Tensor,Tensor> _symeig_helper(const Tensor & self, bool eigenvectors, bool upper);
TORCH_API std::tuple<Tensor &,Tensor &> eig_out(Tensor & e, Tensor & v, const Tensor & self, bool eigenvectors=false);
TORCH_API std::tuple<Tensor &,Tensor &> eig_outf(const Tensor & self, bool eigenvectors, Tensor & e, Tensor & v);
TORCH_API std::tuple<Tensor,Tensor> eig(const Tensor & self, bool eigenvectors=false);
TORCH_API std::tuple<Tensor &,Tensor &,Tensor &> svd_out(Tensor & U, Tensor & S, Tensor & V, const Tensor & self, bool some=true, bool compute_uv=true);
TORCH_API std::tuple<Tensor &,Tensor &,Tensor &> svd_outf(const Tensor & self, bool some, bool compute_uv, Tensor & U, Tensor & S, Tensor & V);
TORCH_API std::tuple<Tensor,Tensor,Tensor> svd(const Tensor & self, bool some=true, bool compute_uv=true);
TORCH_API std::tuple<Tensor,Tensor,Tensor> _svd_helper(const Tensor & self, bool some, bool compute_uv);
TORCH_API Tensor swapaxes(const Tensor & self, int64_t axis0, int64_t axis1);
TORCH_API Tensor swapdims(const Tensor & self, int64_t dim0, int64_t dim1);
TORCH_API Tensor & cholesky_out(Tensor & out, const Tensor & self, bool upper=false);
TORCH_API Tensor & cholesky_outf(const Tensor & self, bool upper, Tensor & out);
TORCH_API Tensor cholesky(const Tensor & self, bool upper=false);
TORCH_API Tensor _cholesky_helper(const Tensor & self, bool upper);
TORCH_API Tensor & cholesky_solve_out(Tensor & out, const Tensor & self, const Tensor & input2, bool upper=false);
TORCH_API Tensor & cholesky_solve_outf(const Tensor & self, const Tensor & input2, bool upper, Tensor & out);
TORCH_API Tensor cholesky_solve(const Tensor & self, const Tensor & input2, bool upper=false);
TORCH_API Tensor _cholesky_solve_helper(const Tensor & self, const Tensor & A, bool upper);
TORCH_API std::tuple<Tensor,Tensor> solve(const Tensor & self, const Tensor & A);
TORCH_API std::tuple<Tensor &,Tensor &> solve_out(Tensor & solution, Tensor & lu, const Tensor & self, const Tensor & A);
TORCH_API std::tuple<Tensor &,Tensor &> solve_outf(const Tensor & self, const Tensor & A, Tensor & solution, Tensor & lu);
TORCH_API std::tuple<Tensor,Tensor> _solve_helper(const Tensor & self, const Tensor & A);
TORCH_API Tensor cholesky_inverse(const Tensor & self, bool upper=false);
TORCH_API Tensor & cholesky_inverse_out(Tensor & out, const Tensor & self, bool upper=false);
TORCH_API Tensor & cholesky_inverse_outf(const Tensor & self, bool upper, Tensor & out);
TORCH_API std::tuple<Tensor &,Tensor &> qr_out(Tensor & Q, Tensor & R, const Tensor & self, bool some=true);
TORCH_API std::tuple<Tensor &,Tensor &> qr_outf(const Tensor & self, bool some, Tensor & Q, Tensor & R);
TORCH_API std::tuple<Tensor,Tensor> qr(const Tensor & self, bool some=true);
TORCH_API std::tuple<Tensor &,Tensor &> geqrf_out(Tensor & a, Tensor & tau, const Tensor & self);
TORCH_API std::tuple<Tensor &,Tensor &> geqrf_outf(const Tensor & self, Tensor & a, Tensor & tau);
TORCH_API std::tuple<Tensor,Tensor> geqrf(const Tensor & self);
TORCH_API Tensor & orgqr_out(Tensor & out, const Tensor & self, const Tensor & input2);
TORCH_API Tensor & orgqr_outf(const Tensor & self, const Tensor & input2, Tensor & out);
TORCH_API Tensor orgqr(const Tensor & self, const Tensor & input2);
TORCH_API Tensor & ormqr_out(Tensor & out, const Tensor & self, const Tensor & input2, const Tensor & input3, bool left=true, bool transpose=false);
TORCH_API Tensor & ormqr_outf(const Tensor & self, const Tensor & input2, const Tensor & input3, bool left, bool transpose, Tensor & out);
TORCH_API Tensor ormqr(const Tensor & self, const Tensor & input2, const Tensor & input3, bool left=true, bool transpose=false);
TORCH_API std::tuple<Tensor,Tensor,Tensor> _lu_with_info(const Tensor & self, bool pivot=true, bool check_errors=true);
TORCH_API Tensor & lu_solve_out(Tensor & out, const Tensor & self, const Tensor & LU_data, const Tensor & LU_pivots);
TORCH_API Tensor & lu_solve_outf(const Tensor & self, const Tensor & LU_data, const Tensor & LU_pivots, Tensor & out);
TORCH_API Tensor lu_solve(const Tensor & self, const Tensor & LU_data, const Tensor & LU_pivots);
TORCH_API Tensor _lu_solve_helper(const Tensor & self, const Tensor & LU_data, const Tensor & LU_pivots);
TORCH_API Tensor & multinomial_out(Tensor & out, const Tensor & self, int64_t num_samples, bool replacement=false, c10::optional<Generator> generator=c10::nullopt);
TORCH_API Tensor & multinomial_outf(const Tensor & self, int64_t num_samples, bool replacement, c10::optional<Generator> generator, Tensor & out);
TORCH_API Tensor multinomial(const Tensor & self, int64_t num_samples, bool replacement=false, c10::optional<Generator> generator=c10::nullopt);
TORCH_API Tensor & lgamma_out(Tensor & out, const Tensor & self);
TORCH_API Tensor & lgamma_outf(const Tensor & self, Tensor & out);
TORCH_API Tensor lgamma(const Tensor & self);
TORCH_API Tensor & digamma_out(Tensor & out, const Tensor & self);
TORCH_API Tensor & digamma_outf(const Tensor & self, Tensor & out);
TORCH_API Tensor digamma(const Tensor & self);
TORCH_API Tensor & polygamma_out(Tensor & out, int64_t n, const Tensor & self);
TORCH_API Tensor & polygamma_outf(int64_t n, const Tensor & self, Tensor & out);
TORCH_API Tensor polygamma(int64_t n, const Tensor & self);
TORCH_API Tensor erfinv(const Tensor & self);
TORCH_API Tensor & erfinv_out(Tensor & out, const Tensor & self);
TORCH_API Tensor & erfinv_outf(const Tensor & self, Tensor & out);
TORCH_API Tensor i0(const Tensor & self);
TORCH_API Tensor & i0_(Tensor & self);
TORCH_API Tensor & i0_out(Tensor & out, const Tensor & self);
TORCH_API Tensor & i0_outf(const Tensor & self, Tensor & out);
TORCH_API Tensor sign(const Tensor & self);
TORCH_API Tensor & sign_out(Tensor & out, const Tensor & self);
TORCH_API Tensor & sign_outf(const Tensor & self, Tensor & out);
TORCH_API Tensor signbit(const Tensor & self);
TORCH_API Tensor & signbit_out(Tensor & out, const Tensor & self);
TORCH_API Tensor & signbit_outf(const Tensor & self, Tensor & out);
TORCH_API Tensor dist(const Tensor & self, const Tensor & other, Scalar p=2);
TORCH_API Tensor & atan2_out(Tensor & out, const Tensor & self, const Tensor & other);
TORCH_API Tensor & atan2_outf(const Tensor & self, const Tensor & other, Tensor & out);
TORCH_API Tensor atan2(const Tensor & self, const Tensor & other);
TORCH_API Tensor & lerp_out(Tensor & out, const Tensor & self, const Tensor & end, Scalar weight);
TORCH_API Tensor & lerp_outf(const Tensor & self, const Tensor & end, Scalar weight, Tensor & out);
TORCH_API Tensor & lerp_out(Tensor & out, const Tensor & self, const Tensor & end, const Tensor & weight);
TORCH_API Tensor & lerp_outf(const Tensor & self, const Tensor & end, const Tensor & weight, Tensor & out);
TORCH_API Tensor lerp(const Tensor & self, const Tensor & end, Scalar weight);
TORCH_API Tensor lerp(const Tensor & self, const Tensor & end, const Tensor & weight);
TORCH_API Tensor & histc_out(Tensor & out, const Tensor & self, int64_t bins=100, Scalar min=0, Scalar max=0);
TORCH_API Tensor & histc_outf(const Tensor & self, int64_t bins, Scalar min, Scalar max, Tensor & out);
TORCH_API Tensor histc(const Tensor & self, int64_t bins=100, Scalar min=0, Scalar max=0);
TORCH_API Tensor & fmod_out(Tensor & out, const Tensor & self, Scalar other);
TORCH_API Tensor & fmod_outf(const Tensor & self, Scalar other, Tensor & out);
TORCH_API Tensor fmod(const Tensor & self, Scalar other);
TORCH_API Tensor & fmod_out(Tensor & out, const Tensor & self, const Tensor & other);
TORCH_API Tensor & fmod_outf(const Tensor & self, const Tensor & other, Tensor & out);
TORCH_API Tensor fmod(const Tensor & self, const Tensor & other);
TORCH_API Tensor & hypot_out(Tensor & out, const Tensor & self, const Tensor & other);
TORCH_API Tensor & hypot_outf(const Tensor & self, const Tensor & other, Tensor & out);
TORCH_API Tensor hypot(const Tensor & self, const Tensor & other);
TORCH_API Tensor & igamma_out(Tensor & out, const Tensor & self, const Tensor & other);
TORCH_API Tensor & igamma_outf(const Tensor & self, const Tensor & other, Tensor & out);
TORCH_API Tensor igamma(const Tensor & self, const Tensor & other);
TORCH_API Tensor & igammac_out(Tensor & out, const Tensor & self, const Tensor & other);
TORCH_API Tensor & igammac_outf(const Tensor & self, const Tensor & other, Tensor & out);
TORCH_API Tensor igammac(const Tensor & self, const Tensor & other);
TORCH_API Tensor & nextafter_out(Tensor & out, const Tensor & self, const Tensor & other);
TORCH_API Tensor & nextafter_outf(const Tensor & self, const Tensor & other, Tensor & out);
TORCH_API Tensor nextafter(const Tensor & self, const Tensor & other);
TORCH_API Tensor & remainder_out(Tensor & out, const Tensor & self, Scalar other);
TORCH_API Tensor & remainder_outf(const Tensor & self, Scalar other, Tensor & out);
TORCH_API Tensor remainder(const Tensor & self, Scalar other);
TORCH_API Tensor & remainder_out(Tensor & out, const Tensor & self, const Tensor & other);
TORCH_API Tensor & remainder_outf(const Tensor & self, const Tensor & other, Tensor & out);
TORCH_API Tensor remainder(const Tensor & self, const Tensor & other);
TORCH_API Tensor min(const Tensor & self);
TORCH_API Tensor fmin(const Tensor & self, const Tensor & other);
TORCH_API Tensor & fmin_out(Tensor & out, const Tensor & self, const Tensor & other);
TORCH_API Tensor & fmin_outf(const Tensor & self, const Tensor & other, Tensor & out);
TORCH_API Tensor max(const Tensor & self);
TORCH_API Tensor fmax(const Tensor & self, const Tensor & other);
TORCH_API Tensor & fmax_out(Tensor & out, const Tensor & self, const Tensor & other);
TORCH_API Tensor & fmax_outf(const Tensor & self, const Tensor & other, Tensor & out);
TORCH_API Tensor maximum(const Tensor & self, const Tensor & other);
TORCH_API Tensor & maximum_out(Tensor & out, const Tensor & self, const Tensor & other);
TORCH_API Tensor & maximum_outf(const Tensor & self, const Tensor & other, Tensor & out);
TORCH_API Tensor max(const Tensor & self, const Tensor & other);
TORCH_API Tensor & max_out(Tensor & out, const Tensor & self, const Tensor & other);
TORCH_API Tensor & max_outf(const Tensor & self, const Tensor & other, Tensor & out);
TORCH_API Tensor minimum(const Tensor & self, const Tensor & other);
TORCH_API Tensor & minimum_out(Tensor & out, const Tensor & self, const Tensor & other);
TORCH_API Tensor & minimum_outf(const Tensor & self, const Tensor & other, Tensor & out);
TORCH_API Tensor & min_out(Tensor & out, const Tensor & self, const Tensor & other);
TORCH_API Tensor & min_outf(const Tensor & self, const Tensor & other, Tensor & out);
TORCH_API Tensor min(const Tensor & self, const Tensor & other);
TORCH_API Tensor & quantile_out(Tensor & out, const Tensor & self, double q, c10::optional<int64_t> dim=c10::nullopt, bool keepdim=false);
TORCH_API Tensor & quantile_outf(const Tensor & self, double q, c10::optional<int64_t> dim, bool keepdim, Tensor & out);
TORCH_API Tensor quantile(const Tensor & self, double q, c10::optional<int64_t> dim=c10::nullopt, bool keepdim=false);
TORCH_API Tensor & quantile_out(Tensor & out, const Tensor & self, const Tensor & q, c10::optional<int64_t> dim=c10::nullopt, bool keepdim=false);
TORCH_API Tensor & quantile_outf(const Tensor & self, const Tensor & q, c10::optional<int64_t> dim, bool keepdim, Tensor & out);
TORCH_API Tensor quantile(const Tensor & self, const Tensor & q, c10::optional<int64_t> dim=c10::nullopt, bool keepdim=false);
TORCH_API Tensor & nanquantile_out(Tensor & out, const Tensor & self, double q, c10::optional<int64_t> dim=c10::nullopt, bool keepdim=false);
TORCH_API Tensor & nanquantile_outf(const Tensor & self, double q, c10::optional<int64_t> dim, bool keepdim, Tensor & out);
TORCH_API Tensor nanquantile(const Tensor & self, double q, c10::optional<int64_t> dim=c10::nullopt, bool keepdim=false);
TORCH_API Tensor & nanquantile_out(Tensor & out, const Tensor & self, const Tensor & q, c10::optional<int64_t> dim=c10::nullopt, bool keepdim=false);
TORCH_API Tensor & nanquantile_outf(const Tensor & self, const Tensor & q, c10::optional<int64_t> dim, bool keepdim, Tensor & out);
TORCH_API Tensor nanquantile(const Tensor & self, const Tensor & q, c10::optional<int64_t> dim=c10::nullopt, bool keepdim=false);
TORCH_API std::tuple<Tensor &,Tensor &> sort_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t dim=-1, bool descending=false);
TORCH_API std::tuple<Tensor &,Tensor &> sort_outf(const Tensor & self, int64_t dim, bool descending, Tensor & values, Tensor & indices);
TORCH_API std::tuple<Tensor,Tensor> sort(const Tensor & self, int64_t dim=-1, bool descending=false);
TORCH_API std::tuple<Tensor &,Tensor &> sort_out(Tensor & values, Tensor & indices, const Tensor & self, Dimname dim, bool descending=false);
TORCH_API std::tuple<Tensor &,Tensor &> sort_outf(const Tensor & self, Dimname dim, bool descending, Tensor & values, Tensor & indices);
TORCH_API std::tuple<Tensor,Tensor> sort(const Tensor & self, Dimname dim, bool descending=false);
TORCH_API Tensor & msort_out(Tensor & out, const Tensor & self);
TORCH_API Tensor & msort_outf(const Tensor & self, Tensor & out);
TORCH_API Tensor msort(const Tensor & self);
TORCH_API Tensor argsort(const Tensor & self, int64_t dim=-1, bool descending=false);
TORCH_API Tensor argsort(const Tensor & self, Dimname dim, bool descending=false);
TORCH_API std::tuple<Tensor &,Tensor &> topk_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t k, int64_t dim=-1, bool largest=true, bool sorted=true);
TORCH_API std::tuple<Tensor &,Tensor &> topk_outf(const Tensor & self, int64_t k, int64_t dim, bool largest, bool sorted, Tensor & values, Tensor & indices);
TORCH_API std::tuple<Tensor,Tensor> topk(const Tensor & self, int64_t k, int64_t dim=-1, bool largest=true, bool sorted=true);
TORCH_API Tensor all(const Tensor & self);
TORCH_API Tensor any(const Tensor & self);
TORCH_API Tensor & renorm_out(Tensor & out, const Tensor & self, Scalar p, int64_t dim, Scalar maxnorm);
TORCH_API Tensor & renorm_outf(const Tensor & self, Scalar p, int64_t dim, Scalar maxnorm, Tensor & out);
TORCH_API Tensor renorm(const Tensor & self, Scalar p, int64_t dim, Scalar maxnorm);
TORCH_API Tensor unfold_backward(const Tensor & grad_in, IntArrayRef input_sizes, int64_t dim, int64_t size, int64_t step);
TORCH_API bool equal(const Tensor & self, const Tensor & other);
TORCH_API Tensor & pow_out(Tensor & out, const Tensor & self, const Tensor & exponent);
TORCH_API Tensor & pow_outf(const Tensor & self, const Tensor & exponent, Tensor & out);
TORCH_API Tensor pow(const Tensor & self, const Tensor & exponent);
TORCH_API Tensor & pow_out(Tensor & out, Scalar self, const Tensor & exponent);
TORCH_API Tensor & pow_outf(Scalar self, const Tensor & exponent, Tensor & out);
TORCH_API Tensor pow(Scalar self, const Tensor & exponent);
TORCH_API Tensor & pow_out(Tensor & out, const Tensor & self, Scalar exponent);
TORCH_API Tensor & pow_outf(const Tensor & self, Scalar exponent, Tensor & out);
TORCH_API Tensor pow(const Tensor & self, Scalar exponent);
TORCH_API Tensor & float_power_out(Tensor & out, const Tensor & self, const Tensor & exponent);
TORCH_API Tensor & float_power_outf(const Tensor & self, const Tensor & exponent, Tensor & out);
TORCH_API Tensor float_power(const Tensor & self, const Tensor & exponent);
TORCH_API Tensor & float_power_out(Tensor & out, Scalar self, const Tensor & exponent);
TORCH_API Tensor & float_power_outf(Scalar self, const Tensor & exponent, Tensor & out);
TORCH_API Tensor float_power(Scalar self, const Tensor & exponent);
TORCH_API Tensor & float_power_out(Tensor & out, const Tensor & self, Scalar exponent);
TORCH_API Tensor & float_power_outf(const Tensor & self, Scalar exponent, Tensor & out);
TORCH_API Tensor float_power(const Tensor & self, Scalar exponent);
TORCH_API Tensor & normal_out(Tensor & out, const Tensor & mean, double std=1, c10::optional<Generator> generator=c10::nullopt);
TORCH_API Tensor & normal_outf(const Tensor & mean, double std, c10::optional<Generator> generator, Tensor & out);
TORCH_API Tensor normal(const Tensor & mean, double std=1, c10::optional<Generator> generator=c10::nullopt);
TORCH_API Tensor & normal_out(Tensor & out, double mean, const Tensor & std, c10::optional<Generator> generator=c10::nullopt);
TORCH_API Tensor & normal_outf(double mean, const Tensor & std, c10::optional<Generator> generator, Tensor & out);
TORCH_API Tensor normal(double mean, const Tensor & std, c10::optional<Generator> generator=c10::nullopt);
TORCH_API Tensor & normal_out(Tensor & out, const Tensor & mean, const Tensor & std, c10::optional<Generator> generator=c10::nullopt);
TORCH_API Tensor & normal_outf(const Tensor & mean, const Tensor & std, c10::optional<Generator> generator, Tensor & out);
TORCH_API Tensor normal(const Tensor & mean, const Tensor & std, c10::optional<Generator> generator=c10::nullopt);
TORCH_API Tensor normal(double mean, double std, IntArrayRef size, c10::optional<Generator> generator=c10::nullopt, TensorOptions options={});
TORCH_API Tensor normal(double mean, double std, IntArrayRef size, c10::optional<Generator> generator, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory);
TORCH_API Tensor & normal_out(Tensor & out, double mean, double std, IntArrayRef size, c10::optional<Generator> generator=c10::nullopt);
TORCH_API Tensor & normal_outf(double mean, double std, IntArrayRef size, c10::optional<Generator> generator, Tensor & out);
TORCH_API Tensor alias(const Tensor & self);
TORCH_API Tensor & _index_copy_(Tensor & self, int64_t dim, const Tensor & index, const Tensor & source);
TORCH_API Tensor _cumsum(const Tensor & self, int64_t dim);
TORCH_API Tensor & _cumsum_out(Tensor & out, const Tensor & self, int64_t dim);
TORCH_API Tensor & _cumsum_outf(const Tensor & self, int64_t dim, Tensor & out);
TORCH_API Tensor _cumprod(const Tensor & self, int64_t dim);
TORCH_API Tensor & _cumprod_out(Tensor & out, const Tensor & self, int64_t dim);
TORCH_API Tensor & _cumprod_outf(const Tensor & self, int64_t dim, Tensor & out);
TORCH_API Tensor _var(const Tensor & self, bool unbiased=true);
TORCH_API Tensor _std(const Tensor & self, bool unbiased=true);
TORCH_API void _amp_foreach_non_finite_check_and_unscale_(TensorList self, Tensor & found_inf, const Tensor & inv_scale);
TORCH_API Tensor _amp_update_scale(Tensor & growth_tracker, const Tensor & current_scale, const Tensor & found_inf, double scale_growth_factor, double scale_backoff_factor, int64_t growth_interval);
TORCH_API Tensor _cat(TensorList tensors, int64_t dim=0);
TORCH_API Tensor & _cat_out(Tensor & out, TensorList tensors, int64_t dim=0);
TORCH_API Tensor & _cat_outf(TensorList tensors, int64_t dim, Tensor & out);
TORCH_API std::vector<Tensor> _foreach_add(TensorList tensors, Scalar scalar);
TORCH_API void _foreach_add_(TensorList self, Scalar scalar);
TORCH_API std::vector<Tensor> _foreach_sub(TensorList tensors, Scalar scalar);
TORCH_API void _foreach_sub_(TensorList self, Scalar scalar);
TORCH_API std::vector<Tensor> _foreach_mul(TensorList tensors, Scalar scalar);
TORCH_API void _foreach_mul_(TensorList self, Scalar scalar);
TORCH_API std::vector<Tensor> _foreach_div(TensorList tensors, Scalar scalar);
TORCH_API void _foreach_div_(TensorList self, Scalar scalar);
TORCH_API std::vector<Tensor> _foreach_add(TensorList tensors1, TensorList tensors2, Scalar alpha=1);
TORCH_API void _foreach_add_(TensorList self, TensorList other, Scalar alpha=1);
TORCH_API std::vector<Tensor> _foreach_sub(TensorList tensors1, TensorList tensors2, Scalar alpha=1);
TORCH_API void _foreach_sub_(TensorList self, TensorList other, Scalar alpha=1);
TORCH_API std::vector<Tensor> _foreach_mul(TensorList tensors1, TensorList tensors2);
TORCH_API void _foreach_mul_(TensorList self, TensorList other);
TORCH_API std::vector<Tensor> _foreach_div(TensorList tensors1, TensorList tensors2);
TORCH_API void _foreach_div_(TensorList self, TensorList other);
TORCH_API std::vector<Tensor> _foreach_add(TensorList tensors, ArrayRef<double> scalars);
TORCH_API void _foreach_add_(TensorList self, ArrayRef<double> scalars);
TORCH_API std::vector<Tensor> _foreach_sub(TensorList tensors, ArrayRef<double> scalars);
TORCH_API void _foreach_sub_(TensorList self, ArrayRef<double> scalars);
TORCH_API std::vector<Tensor> _foreach_div(TensorList tensors, ArrayRef<double> scalars);
TORCH_API void _foreach_div_(TensorList self, ArrayRef<double> scalars);
TORCH_API std::vector<Tensor> _foreach_mul(TensorList tensors, ArrayRef<double> scalars);
TORCH_API void _foreach_mul_(TensorList self, ArrayRef<double> scalars);
TORCH_API std::vector<Tensor> _foreach_exp(TensorList tensors);
TORCH_API void _foreach_zero_(TensorList self);
TORCH_API void _foreach_exp_(TensorList self);
TORCH_API std::vector<Tensor> _foreach_sqrt(TensorList tensors);
TORCH_API void _foreach_sqrt_(TensorList self);
TORCH_API std::vector<Tensor> _foreach_abs(TensorList tensors);
TORCH_API void _foreach_abs_(TensorList self);
TORCH_API std::vector<Tensor> _foreach_acos(TensorList tensors);
TORCH_API void _foreach_acos_(TensorList self);
TORCH_API std::vector<Tensor> _foreach_asin(TensorList tensors);
TORCH_API void _foreach_asin_(TensorList self);
TORCH_API std::vector<Tensor> _foreach_atan(TensorList tensors);
TORCH_API void _foreach_atan_(TensorList self);
TORCH_API std::vector<Tensor> _foreach_ceil(TensorList tensors);
TORCH_API void _foreach_ceil_(TensorList self);
TORCH_API std::vector<Tensor> _foreach_cos(TensorList tensors);
TORCH_API void _foreach_cos_(TensorList self);
TORCH_API std::vector<Tensor> _foreach_cosh(TensorList tensors);
TORCH_API void _foreach_cosh_(TensorList self);
TORCH_API std::vector<Tensor> _foreach_erf(TensorList tensors);
TORCH_API void _foreach_erf_(TensorList self);
TORCH_API std::vector<Tensor> _foreach_erfc(TensorList tensors);
TORCH_API void _foreach_erfc_(TensorList self);
TORCH_API std::vector<Tensor> _foreach_expm1(TensorList tensors);
TORCH_API void _foreach_expm1_(TensorList self);
TORCH_API std::vector<Tensor> _foreach_floor(TensorList tensors);
TORCH_API void _foreach_floor_(TensorList self);
TORCH_API std::vector<Tensor> _foreach_log(TensorList tensors);
TORCH_API void _foreach_log_(TensorList self);
TORCH_API std::vector<Tensor> _foreach_log10(TensorList tensors);
TORCH_API void _foreach_log10_(TensorList self);
TORCH_API std::vector<Tensor> _foreach_log1p(TensorList tensors);
TORCH_API void _foreach_log1p_(TensorList self);
TORCH_API std::vector<Tensor> _foreach_log2(TensorList tensors);
TORCH_API void _foreach_log2_(TensorList self);
TORCH_API std::vector<Tensor> _foreach_neg(TensorList tensors);
TORCH_API void _foreach_neg_(TensorList self);
TORCH_API std::vector<Tensor> _foreach_tan(TensorList tensors);
TORCH_API void _foreach_tan_(TensorList self);
TORCH_API std::vector<Tensor> _foreach_tanh(TensorList tensors);
TORCH_API void _foreach_tanh_(TensorList self);
TORCH_API std::vector<Tensor> _foreach_sin(TensorList tensors);
TORCH_API void _foreach_sin_(TensorList self);
TORCH_API std::vector<Tensor> _foreach_sinh(TensorList tensors);
TORCH_API void _foreach_sinh_(TensorList self);
TORCH_API std::vector<Tensor> _foreach_round(TensorList tensors);
TORCH_API void _foreach_round_(TensorList self);
TORCH_API std::vector<Tensor> _foreach_lgamma(TensorList tensors);
TORCH_API void _foreach_lgamma_(TensorList self);
TORCH_API std::vector<Tensor> _foreach_frac(TensorList tensors);
TORCH_API void _foreach_frac_(TensorList self);
TORCH_API std::vector<Tensor> _foreach_reciprocal(TensorList tensors);
TORCH_API void _foreach_reciprocal_(TensorList self);
TORCH_API std::vector<Tensor> _foreach_sigmoid(TensorList tensors);
TORCH_API void _foreach_sigmoid_(TensorList self);
TORCH_API std::vector<Tensor> _foreach_trunc(TensorList tensors);
TORCH_API void _foreach_trunc_(TensorList self);
TORCH_API void _foreach_addcdiv_(TensorList self, TensorList tensor1, TensorList tensor2, Scalar value=1);
TORCH_API void _foreach_addcmul_(TensorList self, TensorList tensor1, TensorList tensor2, Scalar value=1);
TORCH_API void _foreach_addcdiv_(TensorList self, TensorList tensor1, TensorList tensor2, ArrayRef<double> scalars);
TORCH_API void _foreach_addcmul_(TensorList self, TensorList tensor1, TensorList tensor2, ArrayRef<double> scalars);
TORCH_API std::vector<Tensor> _foreach_addcdiv(TensorList input, TensorList tensor1, TensorList tensor2, Scalar value=1);
TORCH_API std::vector<Tensor> _foreach_addcmul(TensorList input, TensorList tensor1, TensorList tensor2, Scalar value=1);
TORCH_API std::vector<Tensor> _foreach_addcdiv(TensorList input, TensorList tensor1, TensorList tensor2, ArrayRef<double> scalars);
TORCH_API std::vector<Tensor> _foreach_addcmul(TensorList input, TensorList tensor1, TensorList tensor2, ArrayRef<double> scalars);
TORCH_API std::vector<Tensor> _foreach_maximum(TensorList tensors1, TensorList tensors2);
TORCH_API std::vector<Tensor> _foreach_minimum(TensorList tensors1, TensorList tensors2);
TORCH_API std::tuple<Tensor,Tensor> _mode(const Tensor & self, int64_t dim=-1, bool keepdim=false);
TORCH_API std::tuple<Tensor &,Tensor &> _mode_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t dim=-1, bool keepdim=false);
TORCH_API std::tuple<Tensor &,Tensor &> _mode_outf(const Tensor & self, int64_t dim, bool keepdim, Tensor & values, Tensor & indices);
TORCH_API Tensor bucketize(const Tensor & self, const Tensor & boundaries, bool out_int32=false, bool right=false);
TORCH_API Tensor & bucketize_out(Tensor & out, const Tensor & self, const Tensor & boundaries, bool out_int32=false, bool right=false);
TORCH_API Tensor & bucketize_outf(const Tensor & self, const Tensor & boundaries, bool out_int32, bool right, Tensor & out);
TORCH_API Tensor bucketize(Scalar self, const Tensor & boundaries, bool out_int32=false, bool right=false);
TORCH_API Tensor searchsorted(const Tensor & sorted_sequence, const Tensor & self, bool out_int32=false, bool right=false);
TORCH_API Tensor & searchsorted_out(Tensor & out, const Tensor & sorted_sequence, const Tensor & self, bool out_int32=false, bool right=false);
TORCH_API Tensor & searchsorted_outf(const Tensor & sorted_sequence, const Tensor & self, bool out_int32, bool right, Tensor & out);
TORCH_API Tensor searchsorted(const Tensor & sorted_sequence, Scalar self, bool out_int32=false, bool right=false);
TORCH_API Tensor & mse_loss_out(Tensor & out, const Tensor & self, const Tensor & target, int64_t reduction=at::Reduction::Mean);
TORCH_API Tensor & mse_loss_outf(const Tensor & self, const Tensor & target, int64_t reduction, Tensor & out);
TORCH_API Tensor mse_loss(const Tensor & self, const Tensor & target, int64_t reduction=at::Reduction::Mean);
TORCH_API Tensor & mse_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction);
TORCH_API Tensor & mse_loss_backward_outf(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction, Tensor & grad_input);
TORCH_API Tensor mse_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction);
TORCH_API Tensor & l1_loss_out(Tensor & out, const Tensor & self, const Tensor & target, int64_t reduction=at::Reduction::Mean);
TORCH_API Tensor & l1_loss_outf(const Tensor & self, const Tensor & target, int64_t reduction, Tensor & out);
TORCH_API Tensor l1_loss(const Tensor & self, const Tensor & target, int64_t reduction=at::Reduction::Mean);
TORCH_API Tensor & l1_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction);
TORCH_API Tensor & l1_loss_backward_outf(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction, Tensor & grad_input);
TORCH_API Tensor l1_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction);
TORCH_API Tensor & multi_margin_loss_out(Tensor & out, const Tensor & self, const Tensor & target, Scalar p=1, Scalar margin=1, const c10::optional<Tensor> & weight={}, int64_t reduction=at::Reduction::Mean);
TORCH_API Tensor & multi_margin_loss_outf(const Tensor & self, const Tensor & target, Scalar p, Scalar margin, const c10::optional<Tensor> & weight, int64_t reduction, Tensor & out);
TORCH_API Tensor multi_margin_loss(const Tensor & self, const Tensor & target, Scalar p=1, Scalar margin=1, const c10::optional<Tensor> & weight={}, int64_t reduction=at::Reduction::Mean);
TORCH_API Tensor & multi_margin_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, Scalar p, Scalar margin, const c10::optional<Tensor> & weight={}, int64_t reduction=at::Reduction::Mean);
TORCH_API Tensor & multi_margin_loss_backward_outf(const Tensor & grad_output, const Tensor & self, const Tensor & target, Scalar p, Scalar margin, const c10::optional<Tensor> & weight, int64_t reduction, Tensor & grad_input);
TORCH_API Tensor multi_margin_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, Scalar p, Scalar margin, const c10::optional<Tensor> & weight={}, int64_t reduction=at::Reduction::Mean);
TORCH_API Tensor & multilabel_margin_loss_out(Tensor & out, const Tensor & self, const Tensor & target, int64_t reduction=at::Reduction::Mean);
TORCH_API Tensor & multilabel_margin_loss_outf(const Tensor & self, const Tensor & target, int64_t reduction, Tensor & out);
TORCH_API Tensor multilabel_margin_loss(const Tensor & self, const Tensor & target, int64_t reduction=at::Reduction::Mean);
TORCH_API std::tuple<Tensor &,Tensor &> multilabel_margin_loss_forward_out(Tensor & output, Tensor & is_target, const Tensor & self, const Tensor & target, int64_t reduction);
TORCH_API std::tuple<Tensor &,Tensor &> multilabel_margin_loss_forward_outf(const Tensor & self, const Tensor & target, int64_t reduction, Tensor & output, Tensor & is_target);
TORCH_API std::tuple<Tensor,Tensor> multilabel_margin_loss_forward(const Tensor & self, const Tensor & target, int64_t reduction);
TORCH_API Tensor & multilabel_margin_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction, const Tensor & is_target);
TORCH_API Tensor & multilabel_margin_loss_backward_outf(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction, const Tensor & is_target, Tensor & grad_input);
TORCH_API Tensor multilabel_margin_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction, const Tensor & is_target);
TORCH_API Tensor & nll_loss_out(Tensor & out, const Tensor & self, const Tensor & target, const c10::optional<Tensor> & weight={}, int64_t reduction=at::Reduction::Mean, int64_t ignore_index=-100);
TORCH_API Tensor & nll_loss_outf(const Tensor & self, const Tensor & target, const c10::optional<Tensor> & weight, int64_t reduction, int64_t ignore_index, Tensor & out);
TORCH_API Tensor nll_loss(const Tensor & self, const Tensor & target, const c10::optional<Tensor> & weight={}, int64_t reduction=at::Reduction::Mean, int64_t ignore_index=-100);
TORCH_API std::tuple<Tensor &,Tensor &> nll_loss_forward_out(Tensor & output, Tensor & total_weight, const Tensor & self, const Tensor & target, const c10::optional<Tensor> & weight, int64_t reduction, int64_t ignore_index);
TORCH_API std::tuple<Tensor &,Tensor &> nll_loss_forward_outf(const Tensor & self, const Tensor & target, const c10::optional<Tensor> & weight, int64_t reduction, int64_t ignore_index, Tensor & output, Tensor & total_weight);
TORCH_API std::tuple<Tensor,Tensor> nll_loss_forward(const Tensor & self, const Tensor & target, const c10::optional<Tensor> & weight, int64_t reduction, int64_t ignore_index);
TORCH_API Tensor & nll_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, const c10::optional<Tensor> & weight, int64_t reduction, int64_t ignore_index, const Tensor & total_weight);
TORCH_API Tensor & nll_loss_backward_outf(const Tensor & grad_output, const Tensor & self, const Tensor & target, const c10::optional<Tensor> & weight, int64_t reduction, int64_t ignore_index, const Tensor & total_weight, Tensor & grad_input);
TORCH_API Tensor nll_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, const c10::optional<Tensor> & weight, int64_t reduction, int64_t ignore_index, const Tensor & total_weight);
TORCH_API Tensor & nll_loss2d_out(Tensor & out, const Tensor & self, const Tensor & target, const c10::optional<Tensor> & weight={}, int64_t reduction=at::Reduction::Mean, int64_t ignore_index=-100);
TORCH_API Tensor & nll_loss2d_outf(const Tensor & self, const Tensor & target, const c10::optional<Tensor> & weight, int64_t reduction, int64_t ignore_index, Tensor & out);
TORCH_API Tensor nll_loss2d(const Tensor & self, const Tensor & target, const c10::optional<Tensor> & weight={}, int64_t reduction=at::Reduction::Mean, int64_t ignore_index=-100);
TORCH_API std::tuple<Tensor &,Tensor &> nll_loss2d_forward_out(Tensor & output, Tensor & total_weight, const Tensor & self, const Tensor & target, const c10::optional<Tensor> & weight, int64_t reduction, int64_t ignore_index);
TORCH_API std::tuple<Tensor &,Tensor &> nll_loss2d_forward_outf(const Tensor & self, const Tensor & target, const c10::optional<Tensor> & weight, int64_t reduction, int64_t ignore_index, Tensor & output, Tensor & total_weight);
TORCH_API std::tuple<Tensor,Tensor> nll_loss2d_forward(const Tensor & self, const Tensor & target, const c10::optional<Tensor> & weight, int64_t reduction, int64_t ignore_index);
TORCH_API Tensor & nll_loss2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, const c10::optional<Tensor> & weight, int64_t reduction, int64_t ignore_index, const Tensor & total_weight);
TORCH_API Tensor & nll_loss2d_backward_outf(const Tensor & grad_output, const Tensor & self, const Tensor & target, const c10::optional<Tensor> & weight, int64_t reduction, int64_t ignore_index, const Tensor & total_weight, Tensor & grad_input);
TORCH_API Tensor nll_loss2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, const c10::optional<Tensor> & weight, int64_t reduction, int64_t ignore_index, const Tensor & total_weight);
TORCH_API Tensor & smooth_l1_loss_out(Tensor & out, const Tensor & self, const Tensor & target, int64_t reduction=at::Reduction::Mean, double beta=1.0);
TORCH_API Tensor & smooth_l1_loss_outf(const Tensor & self, const Tensor & target, int64_t reduction, double beta, Tensor & out);
TORCH_API Tensor smooth_l1_loss(const Tensor & self, const Tensor & target, int64_t reduction=at::Reduction::Mean, double beta=1.0);
TORCH_API Tensor & smooth_l1_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction, double beta);
TORCH_API Tensor & smooth_l1_loss_backward_outf(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction, double beta, Tensor & grad_input);
TORCH_API Tensor smooth_l1_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction, double beta);
TORCH_API Tensor & soft_margin_loss_out(Tensor & out, const Tensor & self, const Tensor & target, int64_t reduction=at::Reduction::Mean);
TORCH_API Tensor & soft_margin_loss_outf(const Tensor & self, const Tensor & target, int64_t reduction, Tensor & out);
TORCH_API Tensor soft_margin_loss(const Tensor & self, const Tensor & target, int64_t reduction=at::Reduction::Mean);
TORCH_API Tensor & soft_margin_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction);
TORCH_API Tensor & soft_margin_loss_backward_outf(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction, Tensor & grad_input);
TORCH_API Tensor soft_margin_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction);
TORCH_API Tensor & elu_out(Tensor & out, const Tensor & self, Scalar alpha=1, Scalar scale=1, Scalar input_scale=1);
TORCH_API Tensor & elu_outf(const Tensor & self, Scalar alpha, Scalar scale, Scalar input_scale, Tensor & out);
TORCH_API Tensor elu(const Tensor & self, Scalar alpha=1, Scalar scale=1, Scalar input_scale=1);
TORCH_API Tensor elu_backward(const Tensor & grad_output, Scalar alpha, Scalar scale, Scalar input_scale, bool is_result, const Tensor & self_or_result);
TORCH_API Tensor & elu_(Tensor & self, Scalar alpha=1, Scalar scale=1, Scalar input_scale=1);
TORCH_API Tensor & glu_out(Tensor & out, const Tensor & self, int64_t dim=-1);
TORCH_API Tensor & glu_outf(const Tensor & self, int64_t dim, Tensor & out);
TORCH_API Tensor glu(const Tensor & self, int64_t dim=-1);
TORCH_API Tensor & glu_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, int64_t dim);
TORCH_API Tensor & glu_backward_outf(const Tensor & grad_output, const Tensor & self, int64_t dim, Tensor & grad_input);
TORCH_API Tensor glu_backward(const Tensor & grad_output, const Tensor & self, int64_t dim);
TORCH_API Tensor & hardsigmoid_out(Tensor & out, const Tensor & self);
TORCH_API Tensor & hardsigmoid_outf(const Tensor & self, Tensor & out);
TORCH_API Tensor hardsigmoid(const Tensor & self);
TORCH_API Tensor & hardsigmoid_(Tensor & self);
TORCH_API Tensor hardsigmoid_backward(const Tensor & grad_output, const Tensor & self);
TORCH_API Tensor & hardtanh_out(Tensor & out, const Tensor & self, Scalar min_val=-1, Scalar max_val=1);
TORCH_API Tensor & hardtanh_outf(const Tensor & self, Scalar min_val, Scalar max_val, Tensor & out);
TORCH_API Tensor hardtanh(const Tensor & self, Scalar min_val=-1, Scalar max_val=1);
TORCH_API Tensor & hardtanh_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, Scalar min_val, Scalar max_val);
TORCH_API Tensor & hardtanh_backward_outf(const Tensor & grad_output, const Tensor & self, Scalar min_val, Scalar max_val, Tensor & grad_input);
TORCH_API Tensor hardtanh_backward(const Tensor & grad_output, const Tensor & self, Scalar min_val, Scalar max_val);
TORCH_API Tensor & hardtanh_(Tensor & self, Scalar min_val=-1, Scalar max_val=1);
TORCH_API Tensor & hardswish_out(Tensor & out, const Tensor & self);
TORCH_API Tensor & hardswish_outf(const Tensor & self, Tensor & out);
TORCH_API Tensor hardswish(const Tensor & self);
TORCH_API Tensor & hardswish_(Tensor & self);
TORCH_API Tensor hardswish_backward(const Tensor & grad_output, const Tensor & self);
TORCH_API Tensor & leaky_relu_out(Tensor & out, const Tensor & self, Scalar negative_slope=0.01);
TORCH_API Tensor & leaky_relu_outf(const Tensor & self, Scalar negative_slope, Tensor & out);
TORCH_API Tensor leaky_relu(const Tensor & self, Scalar negative_slope=0.01);
TORCH_API Tensor leaky_relu_backward(const Tensor & grad_output, const Tensor & self, Scalar negative_slope, bool self_is_result);
TORCH_API Tensor & leaky_relu_(Tensor & self, Scalar negative_slope=0.01);
TORCH_API Tensor & log_sigmoid_out(Tensor & out, const Tensor & self);
TORCH_API Tensor & log_sigmoid_outf(const Tensor & self, Tensor & out);
TORCH_API Tensor log_sigmoid(const Tensor & self);
TORCH_API std::tuple<Tensor &,Tensor &> log_sigmoid_forward_out(Tensor & output, Tensor & buffer, const Tensor & self);
TORCH_API std::tuple<Tensor &,Tensor &> log_sigmoid_forward_outf(const Tensor & self, Tensor & output, Tensor & buffer);
TORCH_API std::tuple<Tensor,Tensor> log_sigmoid_forward(const Tensor & self);
TORCH_API Tensor & log_sigmoid_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & buffer);
TORCH_API Tensor & log_sigmoid_backward_outf(const Tensor & grad_output, const Tensor & self, const Tensor & buffer, Tensor & grad_input);
TORCH_API Tensor log_sigmoid_backward(const Tensor & grad_output, const Tensor & self, const Tensor & buffer);
TORCH_API Tensor & rrelu_with_noise_out(Tensor & out, const Tensor & self, const Tensor & noise, Scalar lower=0.125, Scalar upper=0.3333333333333333, bool training=false, c10::optional<Generator> generator=c10::nullopt);
TORCH_API Tensor & rrelu_with_noise_outf(const Tensor & self, const Tensor & noise, Scalar lower, Scalar upper, bool training, c10::optional<Generator> generator, Tensor & out);
TORCH_API Tensor rrelu_with_noise(const Tensor & self, const Tensor & noise, Scalar lower=0.125, Scalar upper=0.3333333333333333, bool training=false, c10::optional<Generator> generator=c10::nullopt);
TORCH_API Tensor rrelu_with_noise_backward(const Tensor & grad_output, const Tensor & self, const Tensor & noise, Scalar lower, Scalar upper, bool training, bool self_is_result);
TORCH_API Tensor & rrelu_with_noise_(Tensor & self, const Tensor & noise, Scalar lower=0.125, Scalar upper=0.3333333333333333, bool training=false, c10::optional<Generator> generator=c10::nullopt);
TORCH_API Tensor & softplus_out(Tensor & out, const Tensor & self, Scalar beta=1, Scalar threshold=20);
TORCH_API Tensor & softplus_outf(const Tensor & self, Scalar beta, Scalar threshold, Tensor & out);
TORCH_API Tensor softplus(const Tensor & self, Scalar beta=1, Scalar threshold=20);
TORCH_API Tensor & softplus_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, Scalar beta, Scalar threshold, const Tensor & output);
TORCH_API Tensor & softplus_backward_outf(const Tensor & grad_output, const Tensor & self, Scalar beta, Scalar threshold, const Tensor & output, Tensor & grad_input);
TORCH_API Tensor softplus_backward(const Tensor & grad_output, const Tensor & self, Scalar beta, Scalar threshold, const Tensor & output);
TORCH_API Tensor & softshrink_out(Tensor & out, const Tensor & self, Scalar lambd=0.5);
TORCH_API Tensor & softshrink_outf(const Tensor & self, Scalar lambd, Tensor & out);
TORCH_API Tensor softshrink(const Tensor & self, Scalar lambd=0.5);
TORCH_API Tensor & softshrink_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, Scalar lambd);
TORCH_API Tensor & softshrink_backward_outf(const Tensor & grad_output, const Tensor & self, Scalar lambd, Tensor & grad_input);
TORCH_API Tensor softshrink_backward(const Tensor & grad_output, const Tensor & self, Scalar lambd);
TORCH_API Tensor & adaptive_avg_pool2d_out(Tensor & out, const Tensor & self, IntArrayRef output_size);
TORCH_API Tensor & adaptive_avg_pool2d_outf(const Tensor & self, IntArrayRef output_size, Tensor & out);
TORCH_API Tensor adaptive_avg_pool2d(const Tensor & self, IntArrayRef output_size);
TORCH_API Tensor mkldnn_adaptive_avg_pool2d(const Tensor & self, IntArrayRef output_size);
TORCH_API Tensor _adaptive_avg_pool2d(const Tensor & self, IntArrayRef output_size);
TORCH_API Tensor _adaptive_avg_pool2d_backward(const Tensor & grad_output, const Tensor & self);
TORCH_API Tensor & adaptive_avg_pool3d_out(Tensor & out, const Tensor & self, IntArrayRef output_size);
TORCH_API Tensor & adaptive_avg_pool3d_outf(const Tensor & self, IntArrayRef output_size, Tensor & out);
TORCH_API Tensor adaptive_avg_pool3d(const Tensor & self, IntArrayRef output_size);
TORCH_API Tensor & adaptive_avg_pool3d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self);
TORCH_API Tensor & adaptive_avg_pool3d_backward_outf(const Tensor & grad_output, const Tensor & self, Tensor & grad_input);
TORCH_API Tensor adaptive_avg_pool3d_backward(const Tensor & grad_output, const Tensor & self);
TORCH_API std::tuple<Tensor &,Tensor &> adaptive_max_pool2d_out(Tensor & out, Tensor & indices, const Tensor & self, IntArrayRef output_size);
TORCH_API std::tuple<Tensor &,Tensor &> adaptive_max_pool2d_outf(const Tensor & self, IntArrayRef output_size, Tensor & out, Tensor & indices);
TORCH_API std::tuple<Tensor,Tensor> adaptive_max_pool2d(const Tensor & self, IntArrayRef output_size);
TORCH_API Tensor & adaptive_max_pool2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & indices);
TORCH_API Tensor & adaptive_max_pool2d_backward_outf(const Tensor & grad_output, const Tensor & self, const Tensor & indices, Tensor & grad_input);
TORCH_API Tensor adaptive_max_pool2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & indices);
TORCH_API std::tuple<Tensor &,Tensor &> adaptive_max_pool3d_out(Tensor & out, Tensor & indices, const Tensor & self, IntArrayRef output_size);
TORCH_API std::tuple<Tensor &,Tensor &> adaptive_max_pool3d_outf(const Tensor & self, IntArrayRef output_size, Tensor & out, Tensor & indices);
TORCH_API std::tuple<Tensor,Tensor> adaptive_max_pool3d(const Tensor & self, IntArrayRef output_size);
TORCH_API Tensor & adaptive_max_pool3d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & indices);
TORCH_API Tensor & adaptive_max_pool3d_backward_outf(const Tensor & grad_output, const Tensor & self, const Tensor & indices, Tensor & grad_input);
TORCH_API Tensor adaptive_max_pool3d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & indices);
TORCH_API Tensor & avg_pool2d_out(Tensor & out, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride={}, IntArrayRef padding=0, bool ceil_mode=false, bool count_include_pad=true, c10::optional<int64_t> divisor_override=c10::nullopt);
TORCH_API Tensor & avg_pool2d_outf(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad, c10::optional<int64_t> divisor_override, Tensor & out);
TORCH_API Tensor avg_pool2d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride={}, IntArrayRef padding=0, bool ceil_mode=false, bool count_include_pad=true, c10::optional<int64_t> divisor_override=c10::nullopt);
TORCH_API Tensor & avg_pool2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad, c10::optional<int64_t> divisor_override);
TORCH_API Tensor & avg_pool2d_backward_outf(const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad, c10::optional<int64_t> divisor_override, Tensor & grad_input);
TORCH_API Tensor avg_pool2d_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad, c10::optional<int64_t> divisor_override);
TORCH_API Tensor & avg_pool3d_out(Tensor & out, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride={}, IntArrayRef padding=0, bool ceil_mode=false, bool count_include_pad=true, c10::optional<int64_t> divisor_override=c10::nullopt);
TORCH_API Tensor & avg_pool3d_outf(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad, c10::optional<int64_t> divisor_override, Tensor & out);
TORCH_API Tensor avg_pool3d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride={}, IntArrayRef padding=0, bool ceil_mode=false, bool count_include_pad=true, c10::optional<int64_t> divisor_override=c10::nullopt);
TORCH_API Tensor & avg_pool3d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad, c10::optional<int64_t> divisor_override);
TORCH_API Tensor & avg_pool3d_backward_outf(const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad, c10::optional<int64_t> divisor_override, Tensor & grad_input);
TORCH_API Tensor avg_pool3d_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad, c10::optional<int64_t> divisor_override);
TORCH_API std::tuple<Tensor &,Tensor &> fractional_max_pool2d_out(Tensor & output, Tensor & indices, const Tensor & self, IntArrayRef kernel_size, IntArrayRef output_size, const Tensor & random_samples);
TORCH_API std::tuple<Tensor &,Tensor &> fractional_max_pool2d_outf(const Tensor & self, IntArrayRef kernel_size, IntArrayRef output_size, const Tensor & random_samples, Tensor & output, Tensor & indices);
TORCH_API std::tuple<Tensor,Tensor> fractional_max_pool2d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef output_size, const Tensor & random_samples);
TORCH_API Tensor & fractional_max_pool2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef output_size, const Tensor & indices);
TORCH_API Tensor & fractional_max_pool2d_backward_outf(const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef output_size, const Tensor & indices, Tensor & grad_input);
TORCH_API Tensor fractional_max_pool2d_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef output_size, const Tensor & indices);
TORCH_API std::tuple<Tensor &,Tensor &> fractional_max_pool3d_out(Tensor & output, Tensor & indices, const Tensor & self, IntArrayRef kernel_size, IntArrayRef output_size, const Tensor & random_samples);
TORCH_API std::tuple<Tensor &,Tensor &> fractional_max_pool3d_outf(const Tensor & self, IntArrayRef kernel_size, IntArrayRef output_size, const Tensor & random_samples, Tensor & output, Tensor & indices);
TORCH_API std::tuple<Tensor,Tensor> fractional_max_pool3d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef output_size, const Tensor & random_samples);
TORCH_API Tensor & fractional_max_pool3d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef output_size, const Tensor & indices);
TORCH_API Tensor & fractional_max_pool3d_backward_outf(const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef output_size, const Tensor & indices, Tensor & grad_input);
TORCH_API Tensor fractional_max_pool3d_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef output_size, const Tensor & indices);
TORCH_API std::tuple<Tensor &,Tensor &> max_pool2d_with_indices_out(Tensor & out, Tensor & indices, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride={}, IntArrayRef padding=0, IntArrayRef dilation=1, bool ceil_mode=false);
TORCH_API std::tuple<Tensor &,Tensor &> max_pool2d_with_indices_outf(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode, Tensor & out, Tensor & indices);
TORCH_API std::tuple<Tensor,Tensor> max_pool2d_with_indices(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride={}, IntArrayRef padding=0, IntArrayRef dilation=1, bool ceil_mode=false);
TORCH_API Tensor & max_pool2d_with_indices_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode, const Tensor & indices);
TORCH_API Tensor & max_pool2d_with_indices_backward_outf(const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode, const Tensor & indices, Tensor & grad_input);
TORCH_API Tensor max_pool2d_with_indices_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode, const Tensor & indices);
TORCH_API std::tuple<Tensor &,Tensor &> max_pool3d_with_indices_out(Tensor & out, Tensor & indices, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride={}, IntArrayRef padding=0, IntArrayRef dilation=1, bool ceil_mode=false);
TORCH_API std::tuple<Tensor &,Tensor &> max_pool3d_with_indices_outf(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode, Tensor & out, Tensor & indices);
TORCH_API std::tuple<Tensor,Tensor> max_pool3d_with_indices(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride={}, IntArrayRef padding=0, IntArrayRef dilation=1, bool ceil_mode=false);
TORCH_API Tensor & max_pool3d_with_indices_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode, const Tensor & indices);
TORCH_API Tensor & max_pool3d_with_indices_backward_outf(const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode, const Tensor & indices, Tensor & grad_input);
TORCH_API Tensor max_pool3d_with_indices_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode, const Tensor & indices);
TORCH_API Tensor & max_unpool2d_out(Tensor & out, const Tensor & self, const Tensor & indices, IntArrayRef output_size);
TORCH_API Tensor & max_unpool2d_outf(const Tensor & self, const Tensor & indices, IntArrayRef output_size, Tensor & out);
TORCH_API Tensor max_unpool2d(const Tensor & self, const Tensor & indices, IntArrayRef output_size);
TORCH_API Tensor & max_unpool2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & indices, IntArrayRef output_size);
TORCH_API Tensor & max_unpool2d_backward_outf(const Tensor & grad_output, const Tensor & self, const Tensor & indices, IntArrayRef output_size, Tensor & grad_input);
TORCH_API Tensor max_unpool2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & indices, IntArrayRef output_size);
TORCH_API Tensor & max_unpool3d_out(Tensor & out, const Tensor & self, const Tensor & indices, IntArrayRef output_size, IntArrayRef stride, IntArrayRef padding);
TORCH_API Tensor & max_unpool3d_outf(const Tensor & self, const Tensor & indices, IntArrayRef output_size, IntArrayRef stride, IntArrayRef padding, Tensor & out);
TORCH_API Tensor max_unpool3d(const Tensor & self, const Tensor & indices, IntArrayRef output_size, IntArrayRef stride, IntArrayRef padding);
TORCH_API Tensor & max_unpool3d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & indices, IntArrayRef output_size, IntArrayRef stride, IntArrayRef padding);
TORCH_API Tensor & max_unpool3d_backward_outf(const Tensor & grad_output, const Tensor & self, const Tensor & indices, IntArrayRef output_size, IntArrayRef stride, IntArrayRef padding, Tensor & grad_input);
TORCH_API Tensor max_unpool3d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & indices, IntArrayRef output_size, IntArrayRef stride, IntArrayRef padding);
TORCH_API Tensor & reflection_pad1d_out(Tensor & out, const Tensor & self, IntArrayRef padding);
TORCH_API Tensor & reflection_pad1d_outf(const Tensor & self, IntArrayRef padding, Tensor & out);
TORCH_API Tensor reflection_pad1d(const Tensor & self, IntArrayRef padding);
TORCH_API Tensor & reflection_pad1d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef padding);
TORCH_API Tensor & reflection_pad1d_backward_outf(const Tensor & grad_output, const Tensor & self, IntArrayRef padding, Tensor & grad_input);
TORCH_API Tensor reflection_pad1d_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef padding);
TORCH_API Tensor & reflection_pad2d_out(Tensor & out, const Tensor & self, IntArrayRef padding);
TORCH_API Tensor & reflection_pad2d_outf(const Tensor & self, IntArrayRef padding, Tensor & out);
TORCH_API Tensor reflection_pad2d(const Tensor & self, IntArrayRef padding);
TORCH_API Tensor & reflection_pad2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef padding);
TORCH_API Tensor & reflection_pad2d_backward_outf(const Tensor & grad_output, const Tensor & self, IntArrayRef padding, Tensor & grad_input);
TORCH_API Tensor reflection_pad2d_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef padding);
TORCH_API Tensor & replication_pad1d_out(Tensor & out, const Tensor & self, IntArrayRef padding);
TORCH_API Tensor & replication_pad1d_outf(const Tensor & self, IntArrayRef padding, Tensor & out);
TORCH_API Tensor replication_pad1d(const Tensor & self, IntArrayRef padding);
TORCH_API Tensor & replication_pad1d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef padding);
TORCH_API Tensor & replication_pad1d_backward_outf(const Tensor & grad_output, const Tensor & self, IntArrayRef padding, Tensor & grad_input);
TORCH_API Tensor replication_pad1d_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef padding);
TORCH_API Tensor & replication_pad2d_out(Tensor & out, const Tensor & self, IntArrayRef padding);
TORCH_API Tensor & replication_pad2d_outf(const Tensor & self, IntArrayRef padding, Tensor & out);
TORCH_API Tensor replication_pad2d(const Tensor & self, IntArrayRef padding);
TORCH_API Tensor & replication_pad2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef padding);
TORCH_API Tensor & replication_pad2d_backward_outf(const Tensor & grad_output, const Tensor & self, IntArrayRef padding, Tensor & grad_input);
TORCH_API Tensor replication_pad2d_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef padding);
TORCH_API Tensor & replication_pad3d_out(Tensor & out, const Tensor & self, IntArrayRef padding);
TORCH_API Tensor & replication_pad3d_outf(const Tensor & self, IntArrayRef padding, Tensor & out);
TORCH_API Tensor replication_pad3d(const Tensor & self, IntArrayRef padding);
TORCH_API Tensor & replication_pad3d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef padding);
TORCH_API Tensor & replication_pad3d_backward_outf(const Tensor & grad_output, const Tensor & self, IntArrayRef padding, Tensor & grad_input);
TORCH_API Tensor replication_pad3d_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef padding);
TORCH_API Tensor upsample_linear1d(const Tensor & input, c10::optional<IntArrayRef> output_size, bool align_corners, c10::optional<ArrayRef<double>> scale_factors);
TORCH_API Tensor upsample_linear1d_backward(const Tensor & grad_output, c10::optional<IntArrayRef> output_size, IntArrayRef input_size, bool align_corners, c10::optional<ArrayRef<double>> scale_factors);
TORCH_API Tensor upsample_bilinear2d(const Tensor & input, c10::optional<IntArrayRef> output_size, bool align_corners, c10::optional<ArrayRef<double>> scale_factors);
TORCH_API Tensor upsample_bilinear2d_backward(const Tensor & grad_output, c10::optional<IntArrayRef> output_size, IntArrayRef input_size, bool align_corners, c10::optional<ArrayRef<double>> scale_factors);
TORCH_API Tensor upsample_trilinear3d(const Tensor & input, c10::optional<IntArrayRef> output_size, bool align_corners, c10::optional<ArrayRef<double>> scale_factors);
TORCH_API Tensor upsample_trilinear3d_backward(const Tensor & grad_output, c10::optional<IntArrayRef> output_size, IntArrayRef input_size, bool align_corners, c10::optional<ArrayRef<double>> scale_factors);
TORCH_API Tensor upsample_bicubic2d(const Tensor & input, c10::optional<IntArrayRef> output_size, bool align_corners, c10::optional<ArrayRef<double>> scale_factors);
TORCH_API Tensor upsample_bicubic2d_backward(const Tensor & grad_output, c10::optional<IntArrayRef> output_size, IntArrayRef input_size, bool align_corners, c10::optional<ArrayRef<double>> scale_factors);
TORCH_API Tensor upsample_nearest1d(const Tensor & input, c10::optional<IntArrayRef> output_size, c10::optional<ArrayRef<double>> scale_factors);
TORCH_API Tensor upsample_nearest1d_backward(const Tensor & grad_output, c10::optional<IntArrayRef> output_size, IntArrayRef input_size, c10::optional<ArrayRef<double>> scale_factors);
TORCH_API Tensor upsample_nearest2d(const Tensor & input, c10::optional<IntArrayRef> output_size, c10::optional<ArrayRef<double>> scale_factors);
TORCH_API Tensor upsample_nearest2d_backward(const Tensor & grad_output, c10::optional<IntArrayRef> output_size, IntArrayRef input_size, c10::optional<ArrayRef<double>> scale_factors);
TORCH_API Tensor upsample_nearest3d(const Tensor & input, c10::optional<IntArrayRef> output_size, c10::optional<ArrayRef<double>> scale_factors);
TORCH_API Tensor upsample_nearest3d_backward(const Tensor & grad_output, c10::optional<IntArrayRef> output_size, IntArrayRef input_size, c10::optional<ArrayRef<double>> scale_factors);
TORCH_API Tensor & upsample_linear1d_out(Tensor & out, const Tensor & self, IntArrayRef output_size, bool align_corners, c10::optional<double> scales=c10::nullopt);
TORCH_API Tensor & upsample_linear1d_outf(const Tensor & self, IntArrayRef output_size, bool align_corners, c10::optional<double> scales, Tensor & out);
TORCH_API Tensor upsample_linear1d(const Tensor & self, IntArrayRef output_size, bool align_corners, c10::optional<double> scales=c10::nullopt);
TORCH_API Tensor & upsample_linear1d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners, c10::optional<double> scales=c10::nullopt);
TORCH_API Tensor & upsample_linear1d_backward_outf(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners, c10::optional<double> scales, Tensor & grad_input);
TORCH_API Tensor upsample_linear1d_backward(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners, c10::optional<double> scales=c10::nullopt);
TORCH_API Tensor & upsample_bilinear2d_out(Tensor & out, const Tensor & self, IntArrayRef output_size, bool align_corners, c10::optional<double> scales_h=c10::nullopt, c10::optional<double> scales_w=c10::nullopt);
TORCH_API Tensor & upsample_bilinear2d_outf(const Tensor & self, IntArrayRef output_size, bool align_corners, c10::optional<double> scales_h, c10::optional<double> scales_w, Tensor & out);
TORCH_API Tensor upsample_bilinear2d(const Tensor & self, IntArrayRef output_size, bool align_corners, c10::optional<double> scales_h=c10::nullopt, c10::optional<double> scales_w=c10::nullopt);
TORCH_API Tensor & upsample_bilinear2d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners, c10::optional<double> scales_h=c10::nullopt, c10::optional<double> scales_w=c10::nullopt);
TORCH_API Tensor & upsample_bilinear2d_backward_outf(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners, c10::optional<double> scales_h, c10::optional<double> scales_w, Tensor & grad_input);
TORCH_API Tensor upsample_bilinear2d_backward(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners, c10::optional<double> scales_h=c10::nullopt, c10::optional<double> scales_w=c10::nullopt);
TORCH_API Tensor & upsample_bicubic2d_out(Tensor & out, const Tensor & self, IntArrayRef output_size, bool align_corners, c10::optional<double> scales_h=c10::nullopt, c10::optional<double> scales_w=c10::nullopt);
TORCH_API Tensor & upsample_bicubic2d_outf(const Tensor & self, IntArrayRef output_size, bool align_corners, c10::optional<double> scales_h, c10::optional<double> scales_w, Tensor & out);
TORCH_API Tensor upsample_bicubic2d(const Tensor & self, IntArrayRef output_size, bool align_corners, c10::optional<double> scales_h=c10::nullopt, c10::optional<double> scales_w=c10::nullopt);
TORCH_API Tensor & upsample_bicubic2d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners, c10::optional<double> scales_h=c10::nullopt, c10::optional<double> scales_w=c10::nullopt);
TORCH_API Tensor & upsample_bicubic2d_backward_outf(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners, c10::optional<double> scales_h, c10::optional<double> scales_w, Tensor & grad_input);
TORCH_API Tensor upsample_bicubic2d_backward(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners, c10::optional<double> scales_h=c10::nullopt, c10::optional<double> scales_w=c10::nullopt);
TORCH_API Tensor & upsample_trilinear3d_out(Tensor & out, const Tensor & self, IntArrayRef output_size, bool align_corners, c10::optional<double> scales_d=c10::nullopt, c10::optional<double> scales_h=c10::nullopt, c10::optional<double> scales_w=c10::nullopt);
TORCH_API Tensor & upsample_trilinear3d_outf(const Tensor & self, IntArrayRef output_size, bool align_corners, c10::optional<double> scales_d, c10::optional<double> scales_h, c10::optional<double> scales_w, Tensor & out);
TORCH_API Tensor upsample_trilinear3d(const Tensor & self, IntArrayRef output_size, bool align_corners, c10::optional<double> scales_d=c10::nullopt, c10::optional<double> scales_h=c10::nullopt, c10::optional<double> scales_w=c10::nullopt);
TORCH_API Tensor & upsample_trilinear3d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners, c10::optional<double> scales_d=c10::nullopt, c10::optional<double> scales_h=c10::nullopt, c10::optional<double> scales_w=c10::nullopt);
TORCH_API Tensor & upsample_trilinear3d_backward_outf(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners, c10::optional<double> scales_d, c10::optional<double> scales_h, c10::optional<double> scales_w, Tensor & grad_input);
TORCH_API Tensor upsample_trilinear3d_backward(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners, c10::optional<double> scales_d=c10::nullopt, c10::optional<double> scales_h=c10::nullopt, c10::optional<double> scales_w=c10::nullopt);
TORCH_API Tensor & upsample_nearest1d_out(Tensor & out, const Tensor & self, IntArrayRef output_size, c10::optional<double> scales=c10::nullopt);
TORCH_API Tensor & upsample_nearest1d_outf(const Tensor & self, IntArrayRef output_size, c10::optional<double> scales, Tensor & out);
TORCH_API Tensor upsample_nearest1d(const Tensor & self, IntArrayRef output_size, c10::optional<double> scales=c10::nullopt);
TORCH_API Tensor & upsample_nearest1d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, c10::optional<double> scales=c10::nullopt);
TORCH_API Tensor & upsample_nearest1d_backward_outf(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, c10::optional<double> scales, Tensor & grad_input);
TORCH_API Tensor upsample_nearest1d_backward(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, c10::optional<double> scales=c10::nullopt);
TORCH_API Tensor & upsample_nearest2d_out(Tensor & out, const Tensor & self, IntArrayRef output_size, c10::optional<double> scales_h=c10::nullopt, c10::optional<double> scales_w=c10::nullopt);
TORCH_API Tensor & upsample_nearest2d_outf(const Tensor & self, IntArrayRef output_size, c10::optional<double> scales_h, c10::optional<double> scales_w, Tensor & out);
TORCH_API Tensor upsample_nearest2d(const Tensor & self, IntArrayRef output_size, c10::optional<double> scales_h=c10::nullopt, c10::optional<double> scales_w=c10::nullopt);
TORCH_API Tensor & upsample_nearest2d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, c10::optional<double> scales_h=c10::nullopt, c10::optional<double> scales_w=c10::nullopt);
TORCH_API Tensor & upsample_nearest2d_backward_outf(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, c10::optional<double> scales_h, c10::optional<double> scales_w, Tensor & grad_input);
TORCH_API Tensor upsample_nearest2d_backward(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, c10::optional<double> scales_h=c10::nullopt, c10::optional<double> scales_w=c10::nullopt);
TORCH_API Tensor & upsample_nearest3d_out(Tensor & out, const Tensor & self, IntArrayRef output_size, c10::optional<double> scales_d=c10::nullopt, c10::optional<double> scales_h=c10::nullopt, c10::optional<double> scales_w=c10::nullopt);
TORCH_API Tensor & upsample_nearest3d_outf(const Tensor & self, IntArrayRef output_size, c10::optional<double> scales_d, c10::optional<double> scales_h, c10::optional<double> scales_w, Tensor & out);
TORCH_API Tensor upsample_nearest3d(const Tensor & self, IntArrayRef output_size, c10::optional<double> scales_d=c10::nullopt, c10::optional<double> scales_h=c10::nullopt, c10::optional<double> scales_w=c10::nullopt);
TORCH_API Tensor & upsample_nearest3d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, c10::optional<double> scales_d=c10::nullopt, c10::optional<double> scales_h=c10::nullopt, c10::optional<double> scales_w=c10::nullopt);
TORCH_API Tensor & upsample_nearest3d_backward_outf(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, c10::optional<double> scales_d, c10::optional<double> scales_h, c10::optional<double> scales_w, Tensor & grad_input);
TORCH_API Tensor upsample_nearest3d_backward(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, c10::optional<double> scales_d=c10::nullopt, c10::optional<double> scales_h=c10::nullopt, c10::optional<double> scales_w=c10::nullopt);
TORCH_API Tensor & sigmoid_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & output);
TORCH_API Tensor & sigmoid_backward_outf(const Tensor & grad_output, const Tensor & output, Tensor & grad_input);
TORCH_API Tensor sigmoid_backward(const Tensor & grad_output, const Tensor & output);
TORCH_API Tensor & logit_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, c10::optional<double> eps=c10::nullopt);
TORCH_API Tensor & logit_backward_outf(const Tensor & grad_output, const Tensor & self, c10::optional<double> eps, Tensor & grad_input);
TORCH_API Tensor logit_backward(const Tensor & grad_output, const Tensor & self, c10::optional<double> eps=c10::nullopt);
TORCH_API Tensor & tanh_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & output);
TORCH_API Tensor & tanh_backward_outf(const Tensor & grad_output, const Tensor & output, Tensor & grad_input);
TORCH_API Tensor tanh_backward(const Tensor & grad_output, const Tensor & output);
TORCH_API Tensor & slow_conv_transpose2d_out(Tensor & out, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const c10::optional<Tensor> & bias={}, IntArrayRef stride=1, IntArrayRef padding=0, IntArrayRef output_padding=0, IntArrayRef dilation=1);
TORCH_API Tensor & slow_conv_transpose2d_outf(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const c10::optional<Tensor> & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation, Tensor & out);
TORCH_API Tensor slow_conv_transpose2d(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const c10::optional<Tensor> & bias={}, IntArrayRef stride=1, IntArrayRef padding=0, IntArrayRef output_padding=0, IntArrayRef dilation=1);
TORCH_API std::tuple<Tensor &,Tensor &,Tensor &> slow_conv_transpose2d_backward_out(Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation, const Tensor & columns, const Tensor & ones);
TORCH_API std::tuple<Tensor &,Tensor &,Tensor &> slow_conv_transpose2d_backward_outf(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation, const Tensor & columns, const Tensor & ones, Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias);
TORCH_API std::tuple<Tensor,Tensor,Tensor> slow_conv_transpose2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation, const Tensor & columns, const Tensor & ones, std::array<bool,3> output_mask);
TORCH_API Tensor & slow_conv_transpose3d_out(Tensor & out, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const c10::optional<Tensor> & bias={}, IntArrayRef stride=1, IntArrayRef padding=0, IntArrayRef output_padding=0, IntArrayRef dilation=1);
TORCH_API Tensor & slow_conv_transpose3d_outf(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const c10::optional<Tensor> & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation, Tensor & out);
TORCH_API Tensor slow_conv_transpose3d(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const c10::optional<Tensor> & bias={}, IntArrayRef stride=1, IntArrayRef padding=0, IntArrayRef output_padding=0, IntArrayRef dilation=1);
TORCH_API std::tuple<Tensor &,Tensor &,Tensor &> slow_conv_transpose3d_backward_out(Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation, const Tensor & finput, const Tensor & fgrad_input);
TORCH_API std::tuple<Tensor &,Tensor &,Tensor &> slow_conv_transpose3d_backward_outf(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation, const Tensor & finput, const Tensor & fgrad_input, Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias);
TORCH_API std::tuple<Tensor,Tensor,Tensor> slow_conv_transpose3d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation, const Tensor & finput, const Tensor & fgrad_input, std::array<bool,3> output_mask);
TORCH_API Tensor & thnn_conv2d_out(Tensor & out, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const c10::optional<Tensor> & bias={}, IntArrayRef stride=1, IntArrayRef padding=0);
TORCH_API Tensor & thnn_conv2d_outf(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const c10::optional<Tensor> & bias, IntArrayRef stride, IntArrayRef padding, Tensor & out);
TORCH_API Tensor thnn_conv2d(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const c10::optional<Tensor> & bias={}, IntArrayRef stride=1, IntArrayRef padding=0);
TORCH_API std::tuple<Tensor &,Tensor &,Tensor &> thnn_conv2d_forward_out(Tensor & output, Tensor & finput, Tensor & fgrad_input, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const c10::optional<Tensor> & bias, IntArrayRef stride, IntArrayRef padding);
TORCH_API std::tuple<Tensor &,Tensor &,Tensor &> thnn_conv2d_forward_outf(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const c10::optional<Tensor> & bias, IntArrayRef stride, IntArrayRef padding, Tensor & output, Tensor & finput, Tensor & fgrad_input);
TORCH_API std::tuple<Tensor,Tensor,Tensor> thnn_conv2d_forward(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const c10::optional<Tensor> & bias, IntArrayRef stride, IntArrayRef padding);
TORCH_API std::tuple<Tensor &,Tensor &,Tensor &> thnn_conv2d_backward_out(Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, const Tensor & finput, const Tensor & fgrad_input);
TORCH_API std::tuple<Tensor &,Tensor &,Tensor &> thnn_conv2d_backward_outf(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, const Tensor & finput, const Tensor & fgrad_input, Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias);
TORCH_API std::tuple<Tensor,Tensor,Tensor> thnn_conv2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, const Tensor & finput, const Tensor & fgrad_input, std::array<bool,3> output_mask);
TORCH_API Tensor & thnn_conv_depthwise2d_out(Tensor & out, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const c10::optional<Tensor> & bias={}, IntArrayRef stride=1, IntArrayRef padding=0, IntArrayRef dilation=1);
TORCH_API Tensor & thnn_conv_depthwise2d_outf(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const c10::optional<Tensor> & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, Tensor & out);
TORCH_API Tensor thnn_conv_depthwise2d(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const c10::optional<Tensor> & bias={}, IntArrayRef stride=1, IntArrayRef padding=0, IntArrayRef dilation=1);
TORCH_API Tensor & thnn_conv_depthwise2d_forward_out(Tensor & out, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const c10::optional<Tensor> & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation);
TORCH_API Tensor & thnn_conv_depthwise2d_forward_outf(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const c10::optional<Tensor> & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, Tensor & out);
TORCH_API Tensor thnn_conv_depthwise2d_forward(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const c10::optional<Tensor> & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation);
TORCH_API std::tuple<Tensor &,Tensor &> thnn_conv_depthwise2d_backward_out(Tensor & grad_input, Tensor & grad_weight, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation);
TORCH_API std::tuple<Tensor &,Tensor &> thnn_conv_depthwise2d_backward_outf(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, Tensor & grad_input, Tensor & grad_weight);
TORCH_API std::tuple<Tensor,Tensor> thnn_conv_depthwise2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, std::array<bool,2> output_mask);
TORCH_API Tensor & slow_conv3d_out(Tensor & out, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const c10::optional<Tensor> & bias={}, IntArrayRef stride=1, IntArrayRef padding=0);
TORCH_API Tensor & slow_conv3d_outf(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const c10::optional<Tensor> & bias, IntArrayRef stride, IntArrayRef padding, Tensor & out);
TORCH_API Tensor slow_conv3d(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const c10::optional<Tensor> & bias={}, IntArrayRef stride=1, IntArrayRef padding=0);
TORCH_API std::tuple<Tensor &,Tensor &,Tensor &> slow_conv3d_forward_out(Tensor & output, Tensor & finput, Tensor & fgrad_input, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const c10::optional<Tensor> & bias, IntArrayRef stride, IntArrayRef padding);
TORCH_API std::tuple<Tensor &,Tensor &,Tensor &> slow_conv3d_forward_outf(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const c10::optional<Tensor> & bias, IntArrayRef stride, IntArrayRef padding, Tensor & output, Tensor & finput, Tensor & fgrad_input);
TORCH_API std::tuple<Tensor,Tensor,Tensor> slow_conv3d_forward(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const c10::optional<Tensor> & bias, IntArrayRef stride, IntArrayRef padding);
TORCH_API std::tuple<Tensor &,Tensor &,Tensor &> slow_conv3d_backward_out(Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, const Tensor & finput, const Tensor & fgrad_input);
TORCH_API std::tuple<Tensor &,Tensor &,Tensor &> slow_conv3d_backward_outf(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, const Tensor & finput, const Tensor & fgrad_input, Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias);
TORCH_API std::tuple<Tensor,Tensor,Tensor> slow_conv3d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, const Tensor & finput, const Tensor & fgrad_input, std::array<bool,3> output_mask);
TORCH_API Tensor slow_conv_dilated2d(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const c10::optional<Tensor> & bias={}, IntArrayRef stride=1, IntArrayRef padding=0, IntArrayRef dilation=1);
TORCH_API std::tuple<Tensor,Tensor,Tensor> slow_conv_dilated2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, std::array<bool,3> output_mask);
TORCH_API Tensor slow_conv_dilated3d(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const c10::optional<Tensor> & bias={}, IntArrayRef stride=1, IntArrayRef padding=0, IntArrayRef dilation=1);
TORCH_API std::tuple<Tensor,Tensor,Tensor> slow_conv_dilated3d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, std::array<bool,3> output_mask);
TORCH_API Tensor & col2im_out(Tensor & out, const Tensor & self, IntArrayRef output_size, IntArrayRef kernel_size, IntArrayRef dilation, IntArrayRef padding, IntArrayRef stride);
TORCH_API Tensor & col2im_outf(const Tensor & self, IntArrayRef output_size, IntArrayRef kernel_size, IntArrayRef dilation, IntArrayRef padding, IntArrayRef stride, Tensor & out);
TORCH_API Tensor col2im(const Tensor & self, IntArrayRef output_size, IntArrayRef kernel_size, IntArrayRef dilation, IntArrayRef padding, IntArrayRef stride);
TORCH_API Tensor & col2im_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef kernel_size, IntArrayRef dilation, IntArrayRef padding, IntArrayRef stride);
TORCH_API Tensor & col2im_backward_outf(const Tensor & grad_output, IntArrayRef kernel_size, IntArrayRef dilation, IntArrayRef padding, IntArrayRef stride, Tensor & grad_input);
TORCH_API Tensor col2im_backward(const Tensor & grad_output, IntArrayRef kernel_size, IntArrayRef dilation, IntArrayRef padding, IntArrayRef stride);
TORCH_API Tensor column_stack(TensorList tensors);
TORCH_API Tensor & column_stack_out(Tensor & out, TensorList tensors);
TORCH_API Tensor & column_stack_outf(TensorList tensors, Tensor & out);
TORCH_API Tensor & im2col_out(Tensor & out, const Tensor & self, IntArrayRef kernel_size, IntArrayRef dilation, IntArrayRef padding, IntArrayRef stride);
TORCH_API Tensor & im2col_outf(const Tensor & self, IntArrayRef kernel_size, IntArrayRef dilation, IntArrayRef padding, IntArrayRef stride, Tensor & out);
TORCH_API Tensor im2col(const Tensor & self, IntArrayRef kernel_size, IntArrayRef dilation, IntArrayRef padding, IntArrayRef stride);
TORCH_API Tensor & im2col_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef input_size, IntArrayRef kernel_size, IntArrayRef dilation, IntArrayRef padding, IntArrayRef stride);
TORCH_API Tensor & im2col_backward_outf(const Tensor & grad_output, IntArrayRef input_size, IntArrayRef kernel_size, IntArrayRef dilation, IntArrayRef padding, IntArrayRef stride, Tensor & grad_input);
TORCH_API Tensor im2col_backward(const Tensor & grad_output, IntArrayRef input_size, IntArrayRef kernel_size, IntArrayRef dilation, IntArrayRef padding, IntArrayRef stride);
TORCH_API Tensor isfinite(const Tensor & self);
TORCH_API Tensor isinf(const Tensor & self);
TORCH_API Tensor isposinf(const Tensor & self);
TORCH_API Tensor & isposinf_out(Tensor & out, const Tensor & self);
TORCH_API Tensor & isposinf_outf(const Tensor & self, Tensor & out);
TORCH_API Tensor isneginf(const Tensor & self);
TORCH_API Tensor & isneginf_out(Tensor & out, const Tensor & self);
TORCH_API Tensor & isneginf_outf(const Tensor & self, Tensor & out);
TORCH_API Tensor _add_batch_dim(const Tensor & self, int64_t batch_dim, int64_t level);
TORCH_API Tensor _remove_batch_dim(const Tensor & self, int64_t level, int64_t batch_size, int64_t out_dim);
TORCH_API Tensor fft_fft(const Tensor & self, c10::optional<int64_t> n=c10::nullopt, int64_t dim=-1, c10::optional<std::string> norm=c10::nullopt);
TORCH_API Tensor & fft_fft_out(Tensor & out, const Tensor & self, c10::optional<int64_t> n=c10::nullopt, int64_t dim=-1, c10::optional<std::string> norm=c10::nullopt);
TORCH_API Tensor & fft_fft_outf(const Tensor & self, c10::optional<int64_t> n, int64_t dim, c10::optional<std::string> norm, Tensor & out);
TORCH_API Tensor fft_ifft(const Tensor & self, c10::optional<int64_t> n=c10::nullopt, int64_t dim=-1, c10::optional<std::string> norm=c10::nullopt);
TORCH_API Tensor & fft_ifft_out(Tensor & out, const Tensor & self, c10::optional<int64_t> n=c10::nullopt, int64_t dim=-1, c10::optional<std::string> norm=c10::nullopt);
TORCH_API Tensor & fft_ifft_outf(const Tensor & self, c10::optional<int64_t> n, int64_t dim, c10::optional<std::string> norm, Tensor & out);
TORCH_API Tensor fft_rfft(const Tensor & self, c10::optional<int64_t> n=c10::nullopt, int64_t dim=-1, c10::optional<std::string> norm=c10::nullopt);
TORCH_API Tensor & fft_rfft_out(Tensor & out, const Tensor & self, c10::optional<int64_t> n=c10::nullopt, int64_t dim=-1, c10::optional<std::string> norm=c10::nullopt);
TORCH_API Tensor & fft_rfft_outf(const Tensor & self, c10::optional<int64_t> n, int64_t dim, c10::optional<std::string> norm, Tensor & out);
TORCH_API Tensor fft_irfft(const Tensor & self, c10::optional<int64_t> n=c10::nullopt, int64_t dim=-1, c10::optional<std::string> norm=c10::nullopt);
TORCH_API Tensor & fft_irfft_out(Tensor & out, const Tensor & self, c10::optional<int64_t> n=c10::nullopt, int64_t dim=-1, c10::optional<std::string> norm=c10::nullopt);
TORCH_API Tensor & fft_irfft_outf(const Tensor & self, c10::optional<int64_t> n, int64_t dim, c10::optional<std::string> norm, Tensor & out);
TORCH_API Tensor fft_hfft(const Tensor & self, c10::optional<int64_t> n=c10::nullopt, int64_t dim=-1, c10::optional<std::string> norm=c10::nullopt);
TORCH_API Tensor & fft_hfft_out(Tensor & out, const Tensor & self, c10::optional<int64_t> n=c10::nullopt, int64_t dim=-1, c10::optional<std::string> norm=c10::nullopt);
TORCH_API Tensor & fft_hfft_outf(const Tensor & self, c10::optional<int64_t> n, int64_t dim, c10::optional<std::string> norm, Tensor & out);
TORCH_API Tensor fft_ihfft(const Tensor & self, c10::optional<int64_t> n=c10::nullopt, int64_t dim=-1, c10::optional<std::string> norm=c10::nullopt);
TORCH_API Tensor & fft_ihfft_out(Tensor & out, const Tensor & self, c10::optional<int64_t> n=c10::nullopt, int64_t dim=-1, c10::optional<std::string> norm=c10::nullopt);
TORCH_API Tensor & fft_ihfft_outf(const Tensor & self, c10::optional<int64_t> n, int64_t dim, c10::optional<std::string> norm, Tensor & out);
TORCH_API Tensor fft_fft2(const Tensor & self, c10::optional<IntArrayRef> s=c10::nullopt, IntArrayRef dim={-2,-1}, c10::optional<std::string> norm=c10::nullopt);
TORCH_API Tensor & fft_fft2_out(Tensor & out, const Tensor & self, c10::optional<IntArrayRef> s=c10::nullopt, IntArrayRef dim={-2,-1}, c10::optional<std::string> norm=c10::nullopt);
TORCH_API Tensor & fft_fft2_outf(const Tensor & self, c10::optional<IntArrayRef> s, IntArrayRef dim, c10::optional<std::string> norm, Tensor & out);
TORCH_API Tensor fft_ifft2(const Tensor & self, c10::optional<IntArrayRef> s=c10::nullopt, IntArrayRef dim={-2,-1}, c10::optional<std::string> norm=c10::nullopt);
TORCH_API Tensor & fft_ifft2_out(Tensor & out, const Tensor & self, c10::optional<IntArrayRef> s=c10::nullopt, IntArrayRef dim={-2,-1}, c10::optional<std::string> norm=c10::nullopt);
TORCH_API Tensor & fft_ifft2_outf(const Tensor & self, c10::optional<IntArrayRef> s, IntArrayRef dim, c10::optional<std::string> norm, Tensor & out);
TORCH_API Tensor fft_rfft2(const Tensor & self, c10::optional<IntArrayRef> s=c10::nullopt, IntArrayRef dim={-2,-1}, c10::optional<std::string> norm=c10::nullopt);
TORCH_API Tensor & fft_rfft2_out(Tensor & out, const Tensor & self, c10::optional<IntArrayRef> s=c10::nullopt, IntArrayRef dim={-2,-1}, c10::optional<std::string> norm=c10::nullopt);
TORCH_API Tensor & fft_rfft2_outf(const Tensor & self, c10::optional<IntArrayRef> s, IntArrayRef dim, c10::optional<std::string> norm, Tensor & out);
TORCH_API Tensor fft_irfft2(const Tensor & self, c10::optional<IntArrayRef> s=c10::nullopt, IntArrayRef dim={-2,-1}, c10::optional<std::string> norm=c10::nullopt);
TORCH_API Tensor & fft_irfft2_out(Tensor & out, const Tensor & self, c10::optional<IntArrayRef> s=c10::nullopt, IntArrayRef dim={-2,-1}, c10::optional<std::string> norm=c10::nullopt);
TORCH_API Tensor & fft_irfft2_outf(const Tensor & self, c10::optional<IntArrayRef> s, IntArrayRef dim, c10::optional<std::string> norm, Tensor & out);
TORCH_API Tensor fft_fftn(const Tensor & self, c10::optional<IntArrayRef> s=c10::nullopt, c10::optional<IntArrayRef> dim=c10::nullopt, c10::optional<std::string> norm=c10::nullopt);
TORCH_API Tensor & fft_fftn_out(Tensor & out, const Tensor & self, c10::optional<IntArrayRef> s=c10::nullopt, c10::optional<IntArrayRef> dim=c10::nullopt, c10::optional<std::string> norm=c10::nullopt);
TORCH_API Tensor & fft_fftn_outf(const Tensor & self, c10::optional<IntArrayRef> s, c10::optional<IntArrayRef> dim, c10::optional<std::string> norm, Tensor & out);
TORCH_API Tensor fft_ifftn(const Tensor & self, c10::optional<IntArrayRef> s=c10::nullopt, c10::optional<IntArrayRef> dim=c10::nullopt, c10::optional<std::string> norm=c10::nullopt);
TORCH_API Tensor & fft_ifftn_out(Tensor & out, const Tensor & self, c10::optional<IntArrayRef> s=c10::nullopt, c10::optional<IntArrayRef> dim=c10::nullopt, c10::optional<std::string> norm=c10::nullopt);
TORCH_API Tensor & fft_ifftn_outf(const Tensor & self, c10::optional<IntArrayRef> s, c10::optional<IntArrayRef> dim, c10::optional<std::string> norm, Tensor & out);
TORCH_API Tensor fft_rfftn(const Tensor & self, c10::optional<IntArrayRef> s=c10::nullopt, c10::optional<IntArrayRef> dim=c10::nullopt, c10::optional<std::string> norm=c10::nullopt);
TORCH_API Tensor & fft_rfftn_out(Tensor & out, const Tensor & self, c10::optional<IntArrayRef> s=c10::nullopt, c10::optional<IntArrayRef> dim=c10::nullopt, c10::optional<std::string> norm=c10::nullopt);
TORCH_API Tensor & fft_rfftn_outf(const Tensor & self, c10::optional<IntArrayRef> s, c10::optional<IntArrayRef> dim, c10::optional<std::string> norm, Tensor & out);
TORCH_API Tensor fft_irfftn(const Tensor & self, c10::optional<IntArrayRef> s=c10::nullopt, c10::optional<IntArrayRef> dim=c10::nullopt, c10::optional<std::string> norm=c10::nullopt);
TORCH_API Tensor & fft_irfftn_out(Tensor & out, const Tensor & self, c10::optional<IntArrayRef> s=c10::nullopt, c10::optional<IntArrayRef> dim=c10::nullopt, c10::optional<std::string> norm=c10::nullopt);
TORCH_API Tensor & fft_irfftn_outf(const Tensor & self, c10::optional<IntArrayRef> s, c10::optional<IntArrayRef> dim, c10::optional<std::string> norm, Tensor & out);
TORCH_API Tensor fft_fftfreq(int64_t n, double d=1.0, TensorOptions options={});
TORCH_API Tensor fft_fftfreq(int64_t n, double d, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory);
TORCH_API Tensor & fft_fftfreq_out(Tensor & out, int64_t n, double d=1.0);
TORCH_API Tensor & fft_fftfreq_outf(int64_t n, double d, Tensor & out);
TORCH_API Tensor fft_rfftfreq(int64_t n, double d=1.0, TensorOptions options={});
TORCH_API Tensor fft_rfftfreq(int64_t n, double d, c10::optional<ScalarType> dtype, c10::optional<Layout> layout, c10::optional<Device> device, c10::optional<bool> pin_memory);
TORCH_API Tensor & fft_rfftfreq_out(Tensor & out, int64_t n, double d=1.0);
TORCH_API Tensor & fft_rfftfreq_outf(int64_t n, double d, Tensor & out);
TORCH_API Tensor fft_fftshift(const Tensor & self, c10::optional<IntArrayRef> dim=c10::nullopt);
TORCH_API Tensor fft_ifftshift(const Tensor & self, c10::optional<IntArrayRef> dim=c10::nullopt);
TORCH_API Tensor linalg_cholesky(const Tensor & self);
TORCH_API Tensor & linalg_cholesky_out(Tensor & out, const Tensor & self);
TORCH_API Tensor & linalg_cholesky_outf(const Tensor & self, Tensor & out);
TORCH_API Tensor linalg_det(const Tensor & self);
TORCH_API Tensor det(const Tensor & self);
TORCH_API std::tuple<Tensor,Tensor> linalg_slogdet(const Tensor & self);
TORCH_API std::tuple<Tensor &,Tensor &> linalg_slogdet_out(Tensor & sign, Tensor & logabsdet, const Tensor & self);
TORCH_API std::tuple<Tensor &,Tensor &> linalg_slogdet_outf(const Tensor & self, Tensor & sign, Tensor & logabsdet);
TORCH_API std::tuple<Tensor,Tensor> _syevd_helper(const Tensor & self, bool compute_eigenvectors, std::string uplo);
TORCH_API std::tuple<Tensor,Tensor> linalg_eigh(const Tensor & self, std::string UPLO="L");
TORCH_API std::tuple<Tensor &,Tensor &> linalg_eigh_out(Tensor & eigvals, Tensor & eigvecs, const Tensor & self, std::string UPLO="L");
TORCH_API std::tuple<Tensor &,Tensor &> linalg_eigh_outf(const Tensor & self, std::string UPLO, Tensor & eigvals, Tensor & eigvecs);
TORCH_API Tensor linalg_eigvalsh(const Tensor & self, std::string UPLO="L");
TORCH_API Tensor & linalg_eigvalsh_out(Tensor & out, const Tensor & self, std::string UPLO="L");
TORCH_API Tensor & linalg_eigvalsh_outf(const Tensor & self, std::string UPLO, Tensor & out);
TORCH_API Tensor & _linalg_inv_out_helper_(Tensor & self, Tensor & infos_lu, Tensor & infos_getri);
TORCH_API Tensor linalg_inv(const Tensor & self);
TORCH_API Tensor & linalg_inv_out(Tensor & out, const Tensor & self);
TORCH_API Tensor & linalg_inv_outf(const Tensor & self, Tensor & out);
TORCH_API Tensor inner(const Tensor & self, const Tensor & other);
TORCH_API Tensor & inner_out(Tensor & out, const Tensor & self, const Tensor & other);
TORCH_API Tensor & inner_outf(const Tensor & self, const Tensor & other, Tensor & out);
TORCH_API Tensor outer(const Tensor & self, const Tensor & vec2);
TORCH_API Tensor & outer_out(Tensor & out, const Tensor & self, const Tensor & vec2);
TORCH_API Tensor & outer_outf(const Tensor & self, const Tensor & vec2, Tensor & out);
TORCH_API Tensor ger(const Tensor & self, const Tensor & vec2);
TORCH_API Tensor & ger_out(Tensor & out, const Tensor & self, const Tensor & vec2);
TORCH_API Tensor & ger_outf(const Tensor & self, const Tensor & vec2, Tensor & out);
TORCH_API Tensor linalg_norm(const Tensor & self, c10::optional<Scalar> ord=c10::nullopt, c10::optional<IntArrayRef> dim=c10::nullopt, bool keepdim=false, c10::optional<ScalarType> dtype=c10::nullopt);
TORCH_API Tensor linalg_norm(const Tensor & self, std::string ord, c10::optional<IntArrayRef> dim=c10::nullopt, bool keepdim=false, c10::optional<ScalarType> dtype=c10::nullopt);
TORCH_API Tensor & linalg_norm_out(Tensor & out, const Tensor & self, c10::optional<Scalar> ord=c10::nullopt, c10::optional<IntArrayRef> dim=c10::nullopt, bool keepdim=false, c10::optional<ScalarType> dtype=c10::nullopt);
TORCH_API Tensor & linalg_norm_outf(const Tensor & self, c10::optional<Scalar> ord, c10::optional<IntArrayRef> dim, bool keepdim, c10::optional<ScalarType> dtype, Tensor & out);
TORCH_API Tensor & linalg_norm_out(Tensor & out, const Tensor & self, std::string ord, c10::optional<IntArrayRef> dim=c10::nullopt, bool keepdim=false, c10::optional<ScalarType> dtype=c10::nullopt);
TORCH_API Tensor & linalg_norm_outf(const Tensor & self, std::string ord, c10::optional<IntArrayRef> dim, bool keepdim, c10::optional<ScalarType> dtype, Tensor & out);
TORCH_API std::tuple<Tensor &,Tensor &,Tensor &> linalg_svd_out(Tensor & U, Tensor & S, Tensor & V, const Tensor & self, bool full_matrices=true, bool compute_uv=true);
TORCH_API std::tuple<Tensor &,Tensor &,Tensor &> linalg_svd_outf(const Tensor & self, bool full_matrices, bool compute_uv, Tensor & U, Tensor & S, Tensor & V);
TORCH_API std::tuple<Tensor,Tensor,Tensor> linalg_svd(const Tensor & self, bool full_matrices=true, bool compute_uv=true);
TORCH_API Tensor linalg_cond(const Tensor & self, c10::optional<Scalar> p=c10::nullopt);
TORCH_API Tensor & linalg_cond_out(Tensor & out, const Tensor & self, c10::optional<Scalar> p=c10::nullopt);
TORCH_API Tensor & linalg_cond_outf(const Tensor & self, c10::optional<Scalar> p, Tensor & out);
TORCH_API Tensor linalg_cond(const Tensor & self, std::string p);
TORCH_API Tensor & linalg_cond_out(Tensor & out, const Tensor & self, std::string p);
TORCH_API Tensor & linalg_cond_outf(const Tensor & self, std::string p, Tensor & out);
TORCH_API Tensor linalg_pinv(const Tensor & self, double rcond=1e-15, bool hermitian=false);
TORCH_API Tensor linalg_pinv(const Tensor & self, const Tensor & rcond, bool hermitian=false);
TORCH_API Tensor & linalg_pinv_out(Tensor & out, const Tensor & self, double rcond=1e-15, bool hermitian=false);
TORCH_API Tensor & linalg_pinv_outf(const Tensor & self, double rcond, bool hermitian, Tensor & out);
TORCH_API Tensor & linalg_pinv_out(Tensor & out, const Tensor & self, const Tensor & rcond, bool hermitian=false);
TORCH_API Tensor & linalg_pinv_outf(const Tensor & self, const Tensor & rcond, bool hermitian, Tensor & out);
TORCH_API Tensor & _linalg_solve_out_helper_(Tensor & self, Tensor & other, Tensor & infos);
TORCH_API Tensor linalg_solve(const Tensor & input, const Tensor & other);
TORCH_API Tensor & linalg_solve_out(Tensor & out, const Tensor & input, const Tensor & other);
TORCH_API Tensor & linalg_solve_outf(const Tensor & input, const Tensor & other, Tensor & out);
TORCH_API Tensor linalg_tensorinv(const Tensor & self, int64_t ind=2);
TORCH_API Tensor & linalg_tensorinv_out(Tensor & out, const Tensor & self, int64_t ind=2);
TORCH_API Tensor & linalg_tensorinv_outf(const Tensor & self, int64_t ind, Tensor & out);
TORCH_API Tensor linalg_tensorsolve(const Tensor & self, const Tensor & other, c10::optional<IntArrayRef> dims=c10::nullopt);
TORCH_API Tensor & linalg_tensorsolve_out(Tensor & out, const Tensor & self, const Tensor & other, c10::optional<IntArrayRef> dims=c10::nullopt);
TORCH_API Tensor & linalg_tensorsolve_outf(const Tensor & self, const Tensor & other, c10::optional<IntArrayRef> dims, Tensor & out);
TORCH_API std::tuple<Tensor,Tensor> linalg_qr(const Tensor & self, std::string mode="reduced");
TORCH_API std::tuple<Tensor &,Tensor &> linalg_qr_out(Tensor & Q, Tensor & R, const Tensor & self, std::string mode="reduced");
TORCH_API std::tuple<Tensor &,Tensor &> linalg_qr_outf(const Tensor & self, std::string mode, Tensor & Q, Tensor & R);
TORCH_API std::tuple<Tensor,Tensor> _linalg_qr_helper(const Tensor & self, std::string mode);
TORCH_API Tensor linalg_matrix_rank(const Tensor & self, c10::optional<double> tol=c10::nullopt, bool hermitian=false);
TORCH_API Tensor & linalg_matrix_rank_out(Tensor & out, const Tensor & self, c10::optional<double> tol=c10::nullopt, bool hermitian=false);
TORCH_API Tensor & linalg_matrix_rank_outf(const Tensor & self, c10::optional<double> tol, bool hermitian, Tensor & out);
TORCH_API Tensor _test_serialization_subcmul(const Tensor & self, const Tensor & other, Scalar alpha=1);
TORCH_API Tensor _test_optional_intlist(const Tensor & values, c10::optional<IntArrayRef> addends);
TORCH_API Tensor _test_optional_filled_intlist(const Tensor & values, c10::optional<IntArrayRef> addends);
TORCH_API Tensor _test_optional_floatlist(const Tensor & values, c10::optional<ArrayRef<double>> addends);
TORCH_API Tensor _test_string_default(const Tensor & dummy, std::string a="\"'\\", std::string b="\"'\\");
TORCH_API Tensor _test_ambiguous_defaults(const Tensor & dummy, int64_t a=1, int64_t b=1);
TORCH_API Tensor _test_ambiguous_defaults(const Tensor & dummy, int64_t a, std::string b);

// Special C++ only overloads for std()-like functions (See gh-40287)
// These are needed because int -> bool conversion takes precedence over int -> IntArrayRef
// So, for example std(0) would select the std(unbiased=False) overload
TORCH_API Tensor var(const Tensor& self, int dim);
TORCH_API std::tuple<Tensor,Tensor> var_mean(const Tensor& self, int dim);
TORCH_API Tensor std(const Tensor& self, int dim);
TORCH_API std::tuple<Tensor,Tensor> std_mean(const Tensor& self, int dim);

namespace {
  inline std::vector<int64_t> zero_sizes(const TensorOptions& options) {
    if (options.has_memory_format()) {
      auto memory_format = *options.memory_format_opt();
      if (at::MemoryFormat::ChannelsLast == memory_format) {
        return {0, 0, 0, 0};
      }
      if (at::MemoryFormat::ChannelsLast3d == memory_format) {
        return {0, 0, 0, 0, 0};
      }
    }
    return {0};
  }
}

inline Tensor from_blob(
    void* data,
    IntArrayRef sizes,
    IntArrayRef strides,
    const std::function<void(void*)>& deleter,
    const TensorOptions& options = {},
    const c10::optional<Device> target_device = c10::nullopt) {
  AutoNonVariableTypeMode guard;  // TODO: remove
  tracer::impl::NoTracerDispatchMode tracer_guard;
  auto device = (target_device.has_value()?
    target_device.value() : globalContext().getDeviceFromPtr(data, options.device().type()));
  if (options.device().has_index()) {
    TORCH_CHECK(
        options.device() == device,
        "Specified device ", options.device(),
        " does not match device of data ", device);
  }
  auto storage = Storage(
      Storage::use_byte_size_t(),
      detail::computeStorageNbytes(sizes, strides, options.dtype().itemsize()),
      InefficientStdFunctionContext::makeDataPtr(data, deleter, device),
      /*allocator=*/nullptr,
      /*resizable=*/false);
  return empty(IntArrayRef(zero_sizes(options)), options).set_(storage, 0, sizes, strides);
}

inline Tensor from_blob(
    void* data,
    IntArrayRef sizes,
    const std::function<void(void*)>& deleter,
    const TensorOptions& options = {}) {
  return from_blob(data, sizes, detail::defaultStrides(sizes), deleter, options);
}

inline Tensor from_blob(
    void* data,
    IntArrayRef sizes,
    IntArrayRef strides,
    const TensorOptions& options = {}) {
  AutoNonVariableTypeMode guard;  // TODO: remove
  tracer::impl::NoTracerDispatchMode tracer_guard;
  auto device = globalContext().getDeviceFromPtr(data, options.device().type());
  if (options.device().has_index()) {
    TORCH_CHECK(
        options.device() == device,
        "Specified device ", options.device(),
        " does not match device of data ", device);
  }
  auto storage = Storage(
      Storage::use_byte_size_t(),
      detail::computeStorageNbytes(sizes, strides, options.dtype().itemsize()),
      DataPtr(data, nullptr, [](void*) {}, device),
      /*allocator=*/nullptr,
      /*resizable=*/false);
  return empty(IntArrayRef(zero_sizes(options)), options).set_(storage, 0, sizes, strides);
}

inline Tensor from_blob(
    void* data,
    IntArrayRef sizes,
    const TensorOptions& options = {}) {
  return from_blob(data, sizes, detail::defaultStrides(sizes), options);
}

inline int64_t numel(const Tensor& tensor) {
  return tensor.numel();
}

inline int64_t size(const Tensor& tensor, int64_t dim) {
  return tensor.size(dim);
}

inline int64_t stride(const Tensor& tensor, int64_t dim) {
  return tensor.stride(dim);
}

}
