#pragma once

// @generated from tools/autograd/templates/VariableType.h

#include <ATen/ATen.h>

#include <ATen/TypeDefault.h>

#include <torch/csrc/WindowsTorchApiMacro.h>

#include <cstdint> // for size_t
#include <functional> // for function
#include <memory> // for unique_ptr
#include <string>
#include <vector>

namespace torch { namespace autograd {

struct Variable;
using at::Context;
using at::Device;
using at::Generator;
using at::IntArrayRef;
using at::Scalar;
using at::ScalarType;
using at::SparseTensorRef;
using at::Storage;
using at::Tensor;
using at::TensorList;
using at::TensorOptions;
using at::Type;
using c10::optional;

struct TORCH_API VariableType final : public at::TypeDefault {
  VariableType(Context* context, at::TypeExtendedInterface* baseType);
  at::Backend backend() const override;
  at::Allocator* allocator() const override;
  at::Device getDeviceFromPtr(void * data) const override;
  std::unique_ptr<at::Generator> generator() const override;
  const char * toString() const override;
  at::TypeID ID() const override;
  at::Type & toBackend(at::Backend b) const override;
  at::Type & toScalarType(at::ScalarType s) const override;
  Storage unsafeStorageFromTH(void * th_pointer, bool retain) const override;
  at::Tensor unsafeTensorFromTH(void * th_pointer, bool retain) const override;

  static at::TypeExtendedInterface* getVariableTypeFromBaseType(const at::Type& baseType);
  static bool isVariableType(const at::Type& type);
  static std::vector<at::Type*> allCUDATypes();
  static std::vector<at::Type*> allCPUTypes();

  void backward(
      Tensor& self,
      c10::optional<Tensor> gradient,
      bool keep_graph,
      bool create_graph) const override;
  void set_data(Tensor & self, Tensor new_data) const override;

  Tensor __and__(const Tensor & self, Scalar other) const override;
  Tensor __and__(const Tensor & self, const Tensor & other) const override;
  Tensor & __iand__(Tensor & self, Scalar other) const override;
  Tensor & __iand__(Tensor & self, const Tensor & other) const override;
  Tensor & __ilshift__(Tensor & self, Scalar other) const override;
  Tensor & __ilshift__(Tensor & self, const Tensor & other) const override;
  Tensor & __ior__(Tensor & self, Scalar other) const override;
  Tensor & __ior__(Tensor & self, const Tensor & other) const override;
  Tensor & __irshift__(Tensor & self, Scalar other) const override;
  Tensor & __irshift__(Tensor & self, const Tensor & other) const override;
  Tensor & __ixor__(Tensor & self, Scalar other) const override;
  Tensor & __ixor__(Tensor & self, const Tensor & other) const override;
  Tensor __lshift__(const Tensor & self, Scalar other) const override;
  Tensor __lshift__(const Tensor & self, const Tensor & other) const override;
  Tensor __or__(const Tensor & self, Scalar other) const override;
  Tensor __or__(const Tensor & self, const Tensor & other) const override;
  Tensor __rshift__(const Tensor & self, Scalar other) const override;
  Tensor __rshift__(const Tensor & self, const Tensor & other) const override;
  Tensor __xor__(const Tensor & self, Scalar other) const override;
  Tensor __xor__(const Tensor & self, const Tensor & other) const override;
  Tensor _adaptive_avg_pool2d(const Tensor & self, IntArrayRef output_size) const override;
  Tensor _adaptive_avg_pool2d_backward(const Tensor & grad_output, const Tensor & self) const override;
  Tensor & _baddbmm_mkl_(Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta, Scalar alpha) const override;
  std::tuple<Tensor,Tensor,Tensor,int64_t> _batch_norm_impl_index(const Tensor & input, const Tensor & weight, const Tensor & bias, const Tensor & running_mean, const Tensor & running_var, bool training, double momentum, double eps, bool cudnn_enabled) const override;
  std::tuple<Tensor,Tensor,Tensor> _batch_norm_impl_index_backward(int64_t impl_index, const Tensor & input, const Tensor & grad_output, const Tensor & weight, const Tensor & running_mean, const Tensor & running_var, const Tensor & save_mean, const Tensor & save_var_transform, bool train, double eps, std::array<bool,3> output_mask) const override;
  Tensor _cast_Byte(const Tensor & self, bool non_blocking) const override;
  Tensor _cast_Char(const Tensor & self, bool non_blocking) const override;
  Tensor _cast_Double(const Tensor & self, bool non_blocking) const override;
  Tensor _cast_Float(const Tensor & self, bool non_blocking) const override;
  Tensor _cast_Half(const Tensor & self, bool non_blocking) const override;
  Tensor _cast_Int(const Tensor & self, bool non_blocking) const override;
  Tensor _cast_Long(const Tensor & self, bool non_blocking) const override;
  Tensor _cast_Short(const Tensor & self, bool non_blocking) const override;
  Tensor _cdist_backward(const Tensor & grad, const Tensor & x1, const Tensor & x2, double p, const Tensor & cdist) const override;
  Tensor _cholesky_helper(const Tensor & self, bool upper) const override;
  Tensor _cholesky_solve_helper(const Tensor & self, const Tensor & A, bool upper) const override;
  Tensor & _coalesced_(Tensor & self, bool coalesced) const override;
  Tensor _convolution(const Tensor & input, const Tensor & weight, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool transposed, IntArrayRef output_padding, int64_t groups, bool benchmark, bool deterministic, bool cudnn_enabled) const override;
  std::tuple<Tensor,Tensor,Tensor> _convolution_double_backward(const Tensor & ggI, const Tensor & ggW, const Tensor & ggb, const Tensor & gO, const Tensor & weight, const Tensor & self, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool transposed, IntArrayRef output_padding, int64_t groups, bool benchmark, bool deterministic, bool cudnn_enabled, std::array<bool,3> output_mask) const override;
  Tensor _convolution_nogroup(const Tensor & input, const Tensor & weight, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool transposed, IntArrayRef output_padding) const override;
  void _copy_same_type_(Tensor & self, const Tensor & src) const override;
  std::tuple<Tensor,Tensor> _ctc_loss(const Tensor & log_probs, const Tensor & targets, IntArrayRef input_lengths, IntArrayRef target_lengths, int64_t blank, bool zero_infinity) const override;
  Tensor _ctc_loss_backward(const Tensor & grad, const Tensor & log_probs, const Tensor & targets, IntArrayRef input_lengths, IntArrayRef target_lengths, const Tensor & neg_log_likelihood, const Tensor & log_alpha, int64_t blank, bool zero_infinity) const override;
  std::tuple<Tensor,Tensor> _cudnn_ctc_loss(const Tensor & log_probs, const Tensor & targets, IntArrayRef input_lengths, IntArrayRef target_lengths, int64_t blank, bool deterministic, bool zero_infinity) const override;
  Tensor _cudnn_init_dropout_state(double dropout, bool train, int64_t dropout_seed, const TensorOptions & options) const override;
  std::tuple<Tensor,Tensor,Tensor,Tensor,Tensor> _cudnn_rnn(const Tensor & input, TensorList weight, int64_t weight_stride0, const Tensor & weight_buf, const Tensor & hx, const Tensor & cx, int64_t mode, int64_t hidden_size, int64_t num_layers, bool batch_first, double dropout, bool train, bool bidirectional, IntArrayRef batch_sizes, const Tensor & dropout_state) const override;
  std::tuple<Tensor,Tensor,Tensor,std::vector<Tensor>> _cudnn_rnn_backward(const Tensor & input, TensorList weight, int64_t weight_stride0, const Tensor & weight_buf, const Tensor & hx, const Tensor & cx, const Tensor & output, const Tensor & grad_output, const Tensor & grad_hy, const Tensor & grad_cy, int64_t mode, int64_t hidden_size, int64_t num_layers, bool batch_first, double dropout, bool train, bool bidirectional, IntArrayRef batch_sizes, const Tensor & dropout_state, const Tensor & reserve, std::array<bool,4> output_mask) const override;
  Tensor _cudnn_rnn_flatten_weight(TensorList weight_arr, int64_t weight_stride0, int64_t input_size, int64_t mode, int64_t hidden_size, int64_t num_layers, bool batch_first, bool bidirectional) const override;
  void _cufft_clear_plan_cache(int64_t device_index) const override;
  int64_t _cufft_get_plan_cache_max_size(int64_t device_index) const override;
  int64_t _cufft_get_plan_cache_size(int64_t device_index) const override;
  void _cufft_set_plan_cache_max_size(int64_t device_index, int64_t max_size) const override;
  int64_t _debug_has_internal_overlap(const Tensor & self) const override;
  int64_t _dimI(const Tensor & self) const override;
  int64_t _dimV(const Tensor & self) const override;
  Tensor _dim_arange(const Tensor & like, int64_t dim) const override;
  Tensor _dirichlet_grad(const Tensor & x, const Tensor & alpha, const Tensor & total) const override;
  Tensor & _dirichlet_grad_out(Tensor & out, const Tensor & x, const Tensor & alpha, const Tensor & total) const override;
  std::tuple<Tensor,Tensor,Tensor,Tensor> _embedding_bag(const Tensor & weight, const Tensor & indices, const Tensor & offsets, bool scale_grad_by_freq, int64_t mode, bool sparse, const Tensor & per_sample_weights) const override;
  Tensor _embedding_bag_backward(const Tensor & grad, const Tensor & indices, const Tensor & offsets, const Tensor & offset2bag, const Tensor & bag_size, const Tensor & maximum_indices, int64_t num_weights, bool scale_grad_by_freq, int64_t mode, bool sparse, const Tensor & per_sample_weights) const override;
  Tensor _embedding_bag_dense_backward(const Tensor & grad, const Tensor & indices, const Tensor & offsets, const Tensor & offset2bag, const Tensor & bag_size, const Tensor & maximum_indices, int64_t num_weights, bool scale_grad_by_freq, int64_t mode, const Tensor & per_sample_weights) const override;
  Tensor _embedding_bag_per_sample_weights_backward(const Tensor & grad, const Tensor & weight, const Tensor & indices, const Tensor & offsets, const Tensor & offset2bag, int64_t mode) const override;
  Tensor _embedding_bag_sparse_backward(const Tensor & grad, const Tensor & indices, const Tensor & offsets, const Tensor & offset2bag, const Tensor & bag_size, int64_t num_weights, bool scale_grad_by_freq, int64_t mode, const Tensor & per_sample_weights) const override;
  Tensor _empty_affine_quantized(IntArrayRef size, const TensorOptions & options, double scale, int64_t zero_point) const override;
  Tensor _fft_with_size(const Tensor & self, int64_t signal_ndim, bool complex_input, bool complex_output, bool inverse, IntArrayRef checked_signal_sizes, bool normalized, bool onesided, IntArrayRef output_sizes) const override;
  std::tuple<Tensor,Tensor> _fused_dropout(const Tensor & self, double p, Generator * generator) const override;
  Tensor _gather_sparse_backward(const Tensor & self, int64_t dim, const Tensor & index, const Tensor & grad) const override;
  Tensor _indices(const Tensor & self) const override;
  Tensor _inverse_helper(const Tensor & self) const override;
  Scalar _local_scalar_dense(const Tensor & self) const override;
  Tensor _log_softmax(const Tensor & self, int64_t dim, bool half_to_float) const override;
  Tensor _log_softmax_backward_data(const Tensor & grad_output, const Tensor & output, int64_t dim, const Tensor & self) const override;
  std::tuple<Tensor,Tensor,Tensor> _lu_with_info(const Tensor & self, bool pivot, bool check_errors) const override;
  Tensor _masked_scale(const Tensor & self, const Tensor & mask, double scale) const override;
  Tensor _multinomial_alias_draw(const Tensor & J, const Tensor & q, int64_t num_samples, Generator * generator) const override;
  std::tuple<Tensor,Tensor> _multinomial_alias_setup(const Tensor & probs) const override;
  bool _nnpack_available() const override;
  Tensor _nnpack_spatial_convolution(const Tensor & input, const Tensor & weight, const Tensor & bias, IntArrayRef padding) const override;
  std::tuple<Tensor,Tensor,Tensor> _nnpack_spatial_convolution_backward(const Tensor & input, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, std::array<bool,3> output_mask) const override;
  Tensor _nnpack_spatial_convolution_backward_input(const Tensor & input, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding) const override;
  Tensor _nnpack_spatial_convolution_backward_weight(const Tensor & input, IntArrayRef weightsize, const Tensor & grad_output, IntArrayRef padding) const override;
  int64_t _nnz(const Tensor & self) const override;
  std::tuple<Tensor,Tensor> _pack_padded_sequence(const Tensor & input, const Tensor & lengths, bool batch_first) const override;
  Tensor _pack_padded_sequence_backward(const Tensor & grad, IntArrayRef input_size, const Tensor & batch_sizes, bool batch_first) const override;
  std::tuple<Tensor,Tensor> _pad_packed_sequence(const Tensor & data, const Tensor & batch_sizes, bool batch_first, Scalar padding_value, int64_t total_length) const override;
  Tensor _pdist_backward(const Tensor & grad, const Tensor & self, double p, const Tensor & pdist) const override;
  Tensor _pdist_forward(const Tensor & self, double p) const override;
  Tensor _reshape_from_tensor(const Tensor & self, const Tensor & shape) const override;
  Tensor _s_copy_from(const Tensor & self, const Tensor & dst, bool non_blocking) const override;
  Tensor _s_where(const Tensor & condition, const Tensor & self, const Tensor & other) const override;
  Tensor _sample_dirichlet(const Tensor & self, Generator * generator) const override;
  Tensor _shape_as_tensor(const Tensor & self) const override;
  std::tuple<Tensor,Tensor> _sobol_engine_draw(const Tensor & quasi, int64_t n, const Tensor & sobolstate, int64_t dimension, int64_t num_generated, c10::optional<ScalarType> dtype) const override;
  Tensor & _sobol_engine_ff_(Tensor & self, int64_t n, const Tensor & sobolstate, int64_t dimension, int64_t num_generated) const override;
  Tensor & _sobol_engine_initialize_state_(Tensor & self, int64_t dimension) const override;
  Tensor & _sobol_engine_scramble_(Tensor & self, const Tensor & ltm, int64_t dimension) const override;
  Tensor _softmax(const Tensor & self, int64_t dim, bool half_to_float) const override;
  Tensor _softmax_backward_data(const Tensor & grad_output, const Tensor & output, int64_t dim, const Tensor & self) const override;
  std::tuple<Tensor,Tensor> _solve_helper(const Tensor & self, const Tensor & A) const override;
  Tensor & _sparse_add_out(Tensor & out, const Tensor & self, const Tensor & other, Scalar alpha) const override;
  Tensor _sparse_addmm(const Tensor & self, const Tensor & sparse, const Tensor & dense, Scalar beta, Scalar alpha) const override;
  Tensor _sparse_coo_tensor_unsafe(const Tensor & indices, const Tensor & values, IntArrayRef size, const TensorOptions & options) const override;
  Tensor _sparse_coo_tensor_with_dims(int64_t sparse_dim, int64_t dense_dim, IntArrayRef size, const TensorOptions & options) const override;
  Tensor _sparse_coo_tensor_with_dims_and_tensors(int64_t sparse_dim, int64_t dense_dim, IntArrayRef size, const Tensor & indices, const Tensor & values, const TensorOptions & options) const override;
  Tensor & _sparse_dense_add_out(Tensor & out, const Tensor & self, SparseTensorRef other, Scalar alpha) const override;
  Tensor & _sparse_div_scalar_out(Tensor & out, const Tensor & self, Scalar other) const override;
  Tensor & _sparse_div_zerodim_out(Tensor & out, const Tensor & self, const Tensor & other) const override;
  Tensor _sparse_mm(const Tensor & sparse, const Tensor & dense) const override;
  Tensor & _sparse_mul_out(Tensor & out, const Tensor & self, const Tensor & other) const override;
  Tensor & _sparse_mul_scalar_out(Tensor & out, const Tensor & self, Scalar other) const override;
  Tensor & _sparse_mul_zerodim_out(Tensor & out, const Tensor & self, const Tensor & other) const override;
  Tensor _sparse_sum(const Tensor & self) const override;
  Tensor _sparse_sum(const Tensor & self, ScalarType dtype) const override;
  Tensor _sparse_sum(const Tensor & self, IntArrayRef dim) const override;
  Tensor _sparse_sum(const Tensor & self, IntArrayRef dim, ScalarType dtype) const override;
  Tensor _sparse_sum_backward(const Tensor & grad, const Tensor & self, IntArrayRef dim) const override;
  Tensor _standard_gamma(const Tensor & self, Generator * generator) const override;
  Tensor _standard_gamma_grad(const Tensor & self, const Tensor & output) const override;
  Tensor _th_abs(const Tensor & self) const override;
  Tensor & _th_abs_out(Tensor & result, const Tensor & self) const override;
  Tensor _th_acos(const Tensor & self) const override;
  Tensor & _th_acos_out(Tensor & result, const Tensor & self) const override;
  Tensor s__th_addbmm(const Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta, Scalar alpha) const override;
  Tensor & _th_addbmm_(Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta, Scalar alpha) const override;
  Tensor & s__th_addbmm_out(Tensor & result, const Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta, Scalar alpha) const override;
  Tensor s__th_addcdiv(const Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value) const override;
  Tensor & s__th_addcdiv_(Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value) const override;
  Tensor & s__th_addcdiv_out(Tensor & result, const Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value) const override;
  Tensor s__th_addcmul(const Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value) const override;
  Tensor & s__th_addcmul_(Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value) const override;
  Tensor & s__th_addcmul_out(Tensor & result, const Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value) const override;
  Tensor s__th_addmm(const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta, Scalar alpha) const override;
  Tensor & _th_addmm_(Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta, Scalar alpha) const override;
  Tensor & s__th_addmm_out(Tensor & result, const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta, Scalar alpha) const override;
  Tensor s__th_addmv(const Tensor & self, const Tensor & mat, const Tensor & vec, Scalar beta, Scalar alpha) const override;
  Tensor & _th_addmv_(Tensor & self, const Tensor & mat, const Tensor & vec, Scalar beta, Scalar alpha) const override;
  Tensor & s__th_addmv_out(Tensor & result, const Tensor & self, const Tensor & mat, const Tensor & vec, Scalar beta, Scalar alpha) const override;
  Tensor s__th_addr(const Tensor & self, const Tensor & vec1, const Tensor & vec2, Scalar beta, Scalar alpha) const override;
  Tensor & _th_addr_(Tensor & self, const Tensor & vec1, const Tensor & vec2, Scalar beta, Scalar alpha) const override;
  Tensor & s__th_addr_out(Tensor & result, const Tensor & self, const Tensor & vec1, const Tensor & vec2, Scalar beta, Scalar alpha) const override;
  Tensor _th_alias(const Tensor & self) const override;
  Tensor _th_and(const Tensor & self, Scalar other) const override;
  Tensor s__th_and(const Tensor & self, const Tensor & other) const override;
  Tensor & _th_and_out(Tensor & result, const Tensor & self, Scalar other) const override;
  Tensor & s__th_and_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  Tensor _th_asin(const Tensor & self) const override;
  Tensor & _th_asin_out(Tensor & result, const Tensor & self) const override;
  Tensor _th_atan(const Tensor & self) const override;
  Tensor s__th_atan2(const Tensor & self, const Tensor & other) const override;
  Tensor & s__th_atan2_(Tensor & self, const Tensor & other) const override;
  Tensor & s__th_atan2_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  Tensor & _th_atan_out(Tensor & result, const Tensor & self) const override;
  Tensor s__th_baddbmm(const Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta, Scalar alpha) const override;
  Tensor & s__th_baddbmm_out(Tensor & result, const Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta, Scalar alpha) const override;
  Tensor _th_bmm(const Tensor & self, const Tensor & mat2) const override;
  Tensor & _th_bmm_out(Tensor & result, const Tensor & self, const Tensor & mat2) const override;
  Tensor _th_btrisolve(const Tensor & self, const Tensor & LU_data, const Tensor & LU_pivots) const override;
  Tensor & _th_btrisolve_out(Tensor & result, const Tensor & self, const Tensor & LU_data, const Tensor & LU_pivots) const override;
  Tensor _th_cat(TensorList tensors, int64_t dim) const override;
  Tensor & _th_cat_out(Tensor & self, TensorList tensors, int64_t dim) const override;
  Tensor & _th_cauchy_(Tensor & self, double median, double sigma, Generator * generator) const override;
  Tensor _th_ceil(const Tensor & self) const override;
  Tensor & _th_ceil_out(Tensor & result, const Tensor & self) const override;
  Tensor _th_clamp(const Tensor & self, Scalar min, Scalar max) const override;
  Tensor _th_clamp_max(const Tensor & self, Scalar max) const override;
  Tensor & _th_clamp_max_out(Tensor & result, const Tensor & self, Scalar max) const override;
  Tensor _th_clamp_min(const Tensor & self, Scalar min) const override;
  Tensor & _th_clamp_min_out(Tensor & result, const Tensor & self, Scalar min) const override;
  Tensor & _th_clamp_out(Tensor & result, const Tensor & self, Scalar min, Scalar max) const override;
  Tensor _th_clone(const Tensor & self) const override;
  Tensor & _th_copy_ignoring_overlaps_(Tensor & self, const Tensor & src) const override;
  Tensor _th_cos(const Tensor & self) const override;
  Tensor & _th_cos_out(Tensor & result, const Tensor & self) const override;
  Tensor _th_cosh(const Tensor & self) const override;
  Tensor & _th_cosh_out(Tensor & result, const Tensor & self) const override;
  Tensor _th_cross_kernel(const Tensor & self, const Tensor & other, int64_t dim) const override;
  Tensor & _th_cross_kernel_out(Tensor & result, const Tensor & self, const Tensor & other, int64_t dim) const override;
  Tensor _th_cumprod(const Tensor & self, int64_t dim) const override;
  Tensor & _th_cumprod_out(Tensor & result, const Tensor & self, int64_t dim) const override;
  Tensor _th_cumsum(const Tensor & self, int64_t dim) const override;
  Tensor & _th_cumsum_out(Tensor & result, const Tensor & self, int64_t dim) const override;
  Tensor _th_diag(const Tensor & self, int64_t diagonal) const override;
  Tensor & _th_diag_out(Tensor & result, const Tensor & self, int64_t diagonal) const override;
  Tensor _th_digamma(const Tensor & self) const override;
  Tensor & _th_digamma_(Tensor & self) const override;
  Tensor & _th_digamma_out(Tensor & result, const Tensor & self) const override;
  Tensor _th_dirichlet_grad(const Tensor & x, const Tensor & alpha, const Tensor & total) const override;
  Tensor & _th_dirichlet_grad_out(Tensor & output, const Tensor & x, const Tensor & alpha, const Tensor & total) const override;
  Tensor s__th_dist(const Tensor & self, const Tensor & other, Scalar p) const override;
  Tensor _th_dot(const Tensor & self, const Tensor & tensor) const override;
  std::tuple<Tensor,Tensor> _th_eig(const Tensor & self, bool eigenvectors) const override;
  std::tuple<Tensor &,Tensor &> _th_eig_out(Tensor & res1, Tensor & res2, const Tensor & self, bool eigenvectors) const override;
  Tensor _th_eq(const Tensor & self, Scalar other) const override;
  Tensor s__th_eq(const Tensor & self, const Tensor & other) const override;
  Tensor & _th_eq_(Tensor & self, Scalar other) const override;
  Tensor & s__th_eq_(Tensor & self, const Tensor & other) const override;
  Tensor & _th_eq_out(Tensor & result, const Tensor & self, Scalar other) const override;
  Tensor & s__th_eq_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  bool _th_equal(const Tensor & self, const Tensor & other) const override;
  Tensor _th_erf(const Tensor & self) const override;
  Tensor & _th_erf_out(Tensor & result, const Tensor & self) const override;
  Tensor _th_erfc(const Tensor & self) const override;
  Tensor & _th_erfc_out(Tensor & result, const Tensor & self) const override;
  Tensor _th_erfinv(const Tensor & self) const override;
  Tensor & _th_erfinv_(Tensor & self) const override;
  Tensor & _th_erfinv_out(Tensor & result, const Tensor & self) const override;
  Tensor _th_exp(const Tensor & self) const override;
  Tensor & _th_exp_out(Tensor & result, const Tensor & self) const override;
  Tensor _th_expm1(const Tensor & self) const override;
  Tensor & _th_expm1_out(Tensor & result, const Tensor & self) const override;
  Tensor & _th_exponential_(Tensor & self, double lambd, Generator * generator) const override;
  Tensor & _th_fill_(Tensor & self, Scalar value) const override;
  Tensor & _th_fill_(Tensor & self, const Tensor & value) const override;
  Tensor _th_floor(const Tensor & self) const override;
  Tensor & _th_floor_out(Tensor & result, const Tensor & self) const override;
  Tensor _th_fmod(const Tensor & self, Scalar other) const override;
  Tensor s__th_fmod(const Tensor & self, const Tensor & other) const override;
  Tensor & _th_fmod_(Tensor & self, Scalar other) const override;
  Tensor & s__th_fmod_(Tensor & self, const Tensor & other) const override;
  Tensor & _th_fmod_out(Tensor & result, const Tensor & self, Scalar other) const override;
  Tensor & s__th_fmod_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  Tensor _th_frac(const Tensor & self) const override;
  Tensor & _th_frac_(Tensor & self) const override;
  Tensor & _th_frac_out(Tensor & result, const Tensor & self) const override;
  Tensor _th_gather(const Tensor & self, int64_t dim, const Tensor & index) const override;
  Tensor & _th_gather_out(Tensor & result, const Tensor & self, int64_t dim, const Tensor & index) const override;
  Tensor _th_ge(const Tensor & self, Scalar other) const override;
  Tensor s__th_ge(const Tensor & self, const Tensor & other) const override;
  Tensor & _th_ge_(Tensor & self, Scalar other) const override;
  Tensor & s__th_ge_(Tensor & self, const Tensor & other) const override;
  Tensor & _th_ge_out(Tensor & result, const Tensor & self, Scalar other) const override;
  Tensor & s__th_ge_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  std::tuple<Tensor,Tensor> _th_gels(const Tensor & self, const Tensor & A) const override;
  std::tuple<Tensor &,Tensor &> _th_gels_out(Tensor & res1, Tensor & res2, const Tensor & self, const Tensor & A) const override;
  Tensor & _th_geometric_(Tensor & self, double p, Generator * generator) const override;
  std::tuple<Tensor,Tensor> _th_geqrf(const Tensor & self) const override;
  std::tuple<Tensor &,Tensor &> _th_geqrf_out(Tensor & res1, Tensor & res2, const Tensor & self) const override;
  Tensor _th_ger(const Tensor & self, const Tensor & vec2) const override;
  Tensor & _th_ger_out(Tensor & result, const Tensor & self, const Tensor & vec2) const override;
  Tensor _th_getri_single(const Tensor & self) const override;
  Tensor & _th_getri_single_out(Tensor & output, const Tensor & self) const override;
  Tensor _th_gt(const Tensor & self, Scalar other) const override;
  Tensor s__th_gt(const Tensor & self, const Tensor & other) const override;
  Tensor & _th_gt_(Tensor & self, Scalar other) const override;
  Tensor & s__th_gt_(Tensor & self, const Tensor & other) const override;
  Tensor & _th_gt_out(Tensor & result, const Tensor & self, Scalar other) const override;
  Tensor & s__th_gt_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  Tensor _th_histc(const Tensor & self, int64_t bins, Scalar min, Scalar max) const override;
  Tensor & _th_histc_out(Tensor & result, const Tensor & self, int64_t bins, Scalar min, Scalar max) const override;
  Tensor & _th_iand_(Tensor & self, Scalar other) const override;
  Tensor & s__th_iand_(Tensor & self, const Tensor & other) const override;
  Tensor & _th_ilshift_(Tensor & self, Scalar other) const override;
  Tensor & s__th_ilshift_(Tensor & self, const Tensor & other) const override;
  Tensor & _th_index_add_(Tensor & self, int64_t dim, const Tensor & index, const Tensor & source) const override;
  Tensor & _th_index_copy_(Tensor & self, int64_t dim, const Tensor & index, const Tensor & source) const override;
  Tensor & _th_index_fill_(Tensor & self, int64_t dim, const Tensor & index, Scalar value) const override;
  Tensor & _th_index_fill_(Tensor & self, int64_t dim, const Tensor & index, const Tensor & value) const override;
  Tensor _th_index_select(const Tensor & self, int64_t dim, const Tensor & index) const override;
  Tensor & _th_index_select_out(Tensor & result, const Tensor & self, int64_t dim, const Tensor & index) const override;
  Tensor & _th_ior_(Tensor & self, Scalar other) const override;
  Tensor & s__th_ior_(Tensor & self, const Tensor & other) const override;
  Tensor & _th_irshift_(Tensor & self, Scalar other) const override;
  Tensor & s__th_irshift_(Tensor & self, const Tensor & other) const override;
  bool _th_is_set_to(const Tensor & self, const Tensor & tensor) const override;
  Tensor & _th_ixor_(Tensor & self, Scalar other) const override;
  Tensor & s__th_ixor_(Tensor & self, const Tensor & other) const override;
  Tensor _th_le(const Tensor & self, Scalar other) const override;
  Tensor s__th_le(const Tensor & self, const Tensor & other) const override;
  Tensor & _th_le_(Tensor & self, Scalar other) const override;
  Tensor & s__th_le_(Tensor & self, const Tensor & other) const override;
  Tensor & _th_le_out(Tensor & result, const Tensor & self, Scalar other) const override;
  Tensor & s__th_le_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  Tensor _th_lgamma(const Tensor & self) const override;
  Tensor & _th_lgamma_(Tensor & self) const override;
  Tensor & _th_lgamma_out(Tensor & result, const Tensor & self) const override;
  Tensor _th_log(const Tensor & self) const override;
  Tensor _th_log10(const Tensor & self) const override;
  Tensor & _th_log10_out(Tensor & result, const Tensor & self) const override;
  Tensor _th_log1p(const Tensor & self) const override;
  Tensor & _th_log1p_out(Tensor & result, const Tensor & self) const override;
  Tensor _th_log2(const Tensor & self) const override;
  Tensor & _th_log2_out(Tensor & result, const Tensor & self) const override;
  Tensor & _th_log_normal_(Tensor & self, double mean, double std, Generator * generator) const override;
  Tensor & _th_log_out(Tensor & result, const Tensor & self) const override;
  Tensor _th_lshift(const Tensor & self, Scalar other) const override;
  Tensor s__th_lshift(const Tensor & self, const Tensor & other) const override;
  Tensor & _th_lshift_out(Tensor & result, const Tensor & self, Scalar other) const override;
  Tensor & s__th_lshift_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  Tensor _th_lt(const Tensor & self, Scalar other) const override;
  Tensor s__th_lt(const Tensor & self, const Tensor & other) const override;
  Tensor & _th_lt_(Tensor & self, Scalar other) const override;
  Tensor & s__th_lt_(Tensor & self, const Tensor & other) const override;
  Tensor & _th_lt_out(Tensor & result, const Tensor & self, Scalar other) const override;
  Tensor & s__th_lt_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  Tensor & s__th_masked_fill_(Tensor & self, const Tensor & mask, Scalar value) const override;
  Tensor & s__th_masked_fill_(Tensor & self, const Tensor & mask, const Tensor & value) const override;
  Tensor & s__th_masked_scatter_(Tensor & self, const Tensor & mask, const Tensor & source) const override;
  Tensor s__th_masked_select(const Tensor & self, const Tensor & mask) const override;
  Tensor & s__th_masked_select_out(Tensor & result, const Tensor & self, const Tensor & mask) const override;
  Tensor s__th_max(const Tensor & self, const Tensor & other) const override;
  Tensor _th_max(const Tensor & self) const override;
  std::tuple<Tensor,Tensor> _th_max(const Tensor & self, int64_t dim, bool keepdim) const override;
  Tensor & s__th_max_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  std::tuple<Tensor &,Tensor &> _th_max_out(Tensor & max, Tensor & max_indices, const Tensor & self, int64_t dim, bool keepdim) const override;
  Tensor s__th_min(const Tensor & self, const Tensor & other) const override;
  Tensor _th_min(const Tensor & self) const override;
  std::tuple<Tensor,Tensor> _th_min(const Tensor & self, int64_t dim, bool keepdim) const override;
  Tensor & s__th_min_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  std::tuple<Tensor &,Tensor &> _th_min_out(Tensor & min, Tensor & min_indices, const Tensor & self, int64_t dim, bool keepdim) const override;
  Tensor _th_mm(const Tensor & self, const Tensor & mat2) const override;
  Tensor & _th_mm_out(Tensor & result, const Tensor & self, const Tensor & mat2) const override;
  std::tuple<Tensor,Tensor> _th_mode(const Tensor & self, int64_t dim, bool keepdim) const override;
  std::tuple<Tensor &,Tensor &> _th_mode_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t dim, bool keepdim) const override;
  Tensor _th_multinomial(const Tensor & self, int64_t num_samples, bool replacement, Generator * generator) const override;
  Tensor _th_multinomial_alias_draw(const Tensor & q, const Tensor & J, int64_t num_samples, Generator * generator) const override;
  Tensor & _th_multinomial_alias_draw_out(Tensor & result, const Tensor & q, const Tensor & J, int64_t num_samples, Generator * generator) const override;
  std::tuple<Tensor,Tensor> _th_multinomial_alias_setup(const Tensor & probs) const override;
  std::tuple<Tensor &,Tensor &> _th_multinomial_alias_setup_out(Tensor & J, Tensor & q, const Tensor & probs) const override;
  Tensor & _th_multinomial_out(Tensor & result, const Tensor & self, int64_t num_samples, bool replacement, Generator * generator) const override;
  Tensor _th_mv(const Tensor & self, const Tensor & vec) const override;
  Tensor & _th_mv_out(Tensor & result, const Tensor & self, const Tensor & vec) const override;
  Tensor _th_ne(const Tensor & self, Scalar other) const override;
  Tensor s__th_ne(const Tensor & self, const Tensor & other) const override;
  Tensor & _th_ne_(Tensor & self, Scalar other) const override;
  Tensor & s__th_ne_(Tensor & self, const Tensor & other) const override;
  Tensor & _th_ne_out(Tensor & result, const Tensor & self, Scalar other) const override;
  Tensor & s__th_ne_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  Tensor _th_neg(const Tensor & self) const override;
  Tensor & _th_neg_(Tensor & self) const override;
  Tensor & _th_neg_out(Tensor & result, const Tensor & self) const override;
  Tensor _th_nonzero(const Tensor & self) const override;
  Tensor & _th_nonzero_out(Tensor & result, const Tensor & self) const override;
  Tensor _th_normal(const Tensor & mean, double std, Generator * generator) const override;
  Tensor _th_normal(double mean, const Tensor & std, Generator * generator) const override;
  Tensor _th_normal(const Tensor & mean, const Tensor & std, Generator * generator) const override;
  Tensor & _th_normal_(Tensor & self, double mean, double std, Generator * generator) const override;
  Tensor & _th_normal_out(Tensor & output, const Tensor & mean, double std, Generator * generator) const override;
  Tensor & _th_normal_out(Tensor & output, double mean, const Tensor & std, Generator * generator) const override;
  Tensor & _th_normal_out(Tensor & output, const Tensor & mean, const Tensor & std, Generator * generator) const override;
  Tensor _th_or(const Tensor & self, Scalar other) const override;
  Tensor s__th_or(const Tensor & self, const Tensor & other) const override;
  Tensor & _th_or_out(Tensor & result, const Tensor & self, Scalar other) const override;
  Tensor & s__th_or_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  Tensor _th_orgqr(const Tensor & self, const Tensor & input2) const override;
  Tensor & _th_orgqr_out(Tensor & result, const Tensor & self, const Tensor & input2) const override;
  Tensor _th_ormqr(const Tensor & self, const Tensor & input2, const Tensor & input3, bool left, bool transpose) const override;
  Tensor & _th_ormqr_out(Tensor & result, const Tensor & self, const Tensor & input2, const Tensor & input3, bool left, bool transpose) const override;
  Tensor _th_polygamma(int64_t n, const Tensor & self) const override;
  Tensor & _th_polygamma_(Tensor & self, int64_t n) const override;
  Tensor & _th_polygamma_out(Tensor & result, int64_t n, const Tensor & self) const override;
  Tensor _th_potri(const Tensor & self, bool upper) const override;
  Tensor & _th_potri_out(Tensor & output, const Tensor & self, bool upper) const override;
  Tensor _th_pow(const Tensor & self, Scalar exponent) const override;
  Tensor s__th_pow(const Tensor & self, const Tensor & exponent) const override;
  Tensor _th_pow(Scalar self, const Tensor & exponent) const override;
  Tensor & _th_pow_(Tensor & self, Scalar exponent) const override;
  Tensor & s__th_pow_(Tensor & self, const Tensor & exponent) const override;
  Tensor & _th_pow_out(Tensor & result, const Tensor & self, Scalar exponent) const override;
  Tensor & s__th_pow_out(Tensor & result, const Tensor & self, const Tensor & exponent) const override;
  Tensor & _th_pow_out(Tensor & result, Scalar self, const Tensor & exponent) const override;
  std::tuple<Tensor,Tensor> _th_pstrf(const Tensor & self, bool upper, Scalar tol) const override;
  std::tuple<Tensor &,Tensor &> _th_pstrf_out(Tensor & res1, Tensor & res2, const Tensor & self, bool upper, Scalar tol) const override;
  Tensor & _th_put_(Tensor & self, const Tensor & index, const Tensor & source, bool accumulate) const override;
  std::tuple<Tensor,Tensor> _th_qr(const Tensor & self) const override;
  std::tuple<Tensor &,Tensor &> _th_qr_out(Tensor & res1, Tensor & res2, const Tensor & self) const override;
  Tensor & _th_random_(Tensor & self, int64_t from, int64_t to, Generator * generator) const override;
  Tensor & _th_random_(Tensor & self, int64_t to, Generator * generator) const override;
  Tensor & _th_random_(Tensor & self, Generator * generator) const override;
  Tensor _th_reciprocal(const Tensor & self) const override;
  Tensor & _th_reciprocal_(Tensor & self) const override;
  Tensor & _th_reciprocal_out(Tensor & result, const Tensor & self) const override;
  Tensor _th_remainder(const Tensor & self, Scalar other) const override;
  Tensor s__th_remainder(const Tensor & self, const Tensor & other) const override;
  Tensor & _th_remainder_(Tensor & self, Scalar other) const override;
  Tensor & s__th_remainder_(Tensor & self, const Tensor & other) const override;
  Tensor & _th_remainder_out(Tensor & result, const Tensor & self, Scalar other) const override;
  Tensor & s__th_remainder_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  Tensor _th_renorm(const Tensor & self, Scalar p, int64_t dim, Scalar maxnorm) const override;
  Tensor & _th_renorm_(Tensor & self, Scalar p, int64_t dim, Scalar maxnorm) const override;
  Tensor & _th_renorm_out(Tensor & result, const Tensor & self, Scalar p, int64_t dim, Scalar maxnorm) const override;
  Tensor & _th_resize_as_(Tensor & self, const Tensor & the_template) const override;
  Tensor _th_round(const Tensor & self) const override;
  Tensor & _th_round_out(Tensor & result, const Tensor & self) const override;
  Tensor _th_rshift(const Tensor & self, Scalar other) const override;
  Tensor s__th_rshift(const Tensor & self, const Tensor & other) const override;
  Tensor & _th_rshift_out(Tensor & result, const Tensor & self, Scalar other) const override;
  Tensor & s__th_rshift_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  Tensor _th_rsqrt(const Tensor & self) const override;
  Tensor & _th_rsqrt_out(Tensor & result, const Tensor & self) const override;
  Tensor & _th_scatter_(Tensor & self, int64_t dim, const Tensor & index, const Tensor & src) const override;
  Tensor & _th_scatter_(Tensor & self, int64_t dim, const Tensor & index, Scalar value) const override;
  Tensor & _th_scatter_add_(Tensor & self, int64_t dim, const Tensor & index, const Tensor & src) const override;
  Tensor & _th_set_(Tensor & self, Storage source) const override;
  Tensor & _th_set_(Tensor & self, Storage source, int64_t storage_offset, IntArrayRef size, IntArrayRef stride) const override;
  Tensor & _th_set_(Tensor & self, const Tensor & source) const override;
  Tensor & _th_set_(Tensor & self) const override;
  Tensor _th_sigmoid(const Tensor & self) const override;
  Tensor & _th_sigmoid_out(Tensor & result, const Tensor & self) const override;
  Tensor _th_sign(const Tensor & self) const override;
  Tensor & _th_sign_(Tensor & self) const override;
  Tensor & _th_sign_out(Tensor & result, const Tensor & self) const override;
  Tensor _th_sin(const Tensor & self) const override;
  Tensor & _th_sin_out(Tensor & result, const Tensor & self) const override;
  Tensor _th_sinh(const Tensor & self) const override;
  Tensor & _th_sinh_out(Tensor & result, const Tensor & self) const override;
  std::tuple<Tensor,Tensor> _th_sort(const Tensor & self, int64_t dim, bool descending) const override;
  std::tuple<Tensor &,Tensor &> _th_sort_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t dim, bool descending) const override;
  Tensor _th_sqrt(const Tensor & self) const override;
  Tensor & _th_sqrt_out(Tensor & result, const Tensor & self) const override;
  Tensor _th_std(const Tensor & self, int64_t dim, bool unbiased, bool keepdim) const override;
  Tensor _th_std(const Tensor & self, bool unbiased) const override;
  Tensor & _th_std_out(Tensor & result, const Tensor & self, int64_t dim, bool unbiased, bool keepdim) const override;
  std::tuple<Tensor,Tensor,Tensor> _th_svd(const Tensor & self, bool some, bool compute_uv) const override;
  std::tuple<Tensor &,Tensor &,Tensor &> _th_svd_out(Tensor & res1, Tensor & res2, Tensor & res3, const Tensor & self, bool some, bool compute_uv) const override;
  std::tuple<Tensor,Tensor> _th_symeig(const Tensor & self, bool eigenvectors, bool upper) const override;
  std::tuple<Tensor &,Tensor &> _th_symeig_out(Tensor & res1, Tensor & res2, const Tensor & self, bool eigenvectors, bool upper) const override;
  Tensor _th_take(const Tensor & self, const Tensor & index) const override;
  Tensor & _th_take_out(Tensor & result, const Tensor & self, const Tensor & index) const override;
  Tensor _th_tan(const Tensor & self) const override;
  Tensor & _th_tan_out(Tensor & result, const Tensor & self) const override;
  Tensor _th_tanh(const Tensor & self) const override;
  Tensor & _th_tanh_out(Tensor & result, const Tensor & self) const override;
  std::tuple<Tensor,Tensor> _th_topk(const Tensor & self, int64_t k, int64_t dim, bool largest, bool sorted) const override;
  std::tuple<Tensor &,Tensor &> _th_topk_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t k, int64_t dim, bool largest, bool sorted) const override;
  Tensor _th_trace(const Tensor & self) const override;
  Tensor _th_trunc(const Tensor & self) const override;
  Tensor & _th_trunc_out(Tensor & result, const Tensor & self) const override;
  Tensor _th_unfold(const Tensor & self, int64_t dimension, int64_t size, int64_t step) const override;
  Tensor & _th_unfold_out(Tensor & result, const Tensor & self, int64_t dimension, int64_t size, int64_t step) const override;
  Tensor & _th_uniform_(Tensor & self, double from, double to, Generator * generator) const override;
  Tensor _th_var(const Tensor & self, int64_t dim, bool unbiased, bool keepdim) const override;
  Tensor _th_var(const Tensor & self, bool unbiased) const override;
  Tensor & _th_var_out(Tensor & result, const Tensor & self, int64_t dim, bool unbiased, bool keepdim) const override;
  Tensor _th_view(const Tensor & self, IntArrayRef size) const override;
  Tensor _th_xor(const Tensor & self, Scalar other) const override;
  Tensor s__th_xor(const Tensor & self, const Tensor & other) const override;
  Tensor & _th_xor_out(Tensor & result, const Tensor & self, Scalar other) const override;
  Tensor & s__th_xor_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  Tensor & _th_zero_(Tensor & self) const override;
  Tensor _thnn_adaptive_avg_pool3d_backward(const Tensor & grad_output, const Tensor & self) const override;
  Tensor & _thnn_adaptive_avg_pool3d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self) const override;
  Tensor _thnn_adaptive_avg_pool3d_forward(const Tensor & self, IntArrayRef output_size) const override;
  Tensor & _thnn_adaptive_avg_pool3d_forward_out(Tensor & output, const Tensor & self, IntArrayRef output_size) const override;
  Tensor _thnn_avg_pool2d_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad) const override;
  Tensor & _thnn_avg_pool2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad) const override;
  Tensor _thnn_avg_pool2d_forward(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad) const override;
  Tensor & _thnn_avg_pool2d_forward_out(Tensor & output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad) const override;
  Tensor _thnn_avg_pool3d_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad) const override;
  Tensor & _thnn_avg_pool3d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad) const override;
  Tensor _thnn_avg_pool3d_forward(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad) const override;
  Tensor & _thnn_avg_pool3d_forward_out(Tensor & output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad) const override;
  Tensor _thnn_binary_cross_entropy_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction) const override;
  Tensor & _thnn_binary_cross_entropy_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction) const override;
  Tensor _thnn_binary_cross_entropy_forward(const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction) const override;
  Tensor & _thnn_binary_cross_entropy_forward_out(Tensor & output, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction) const override;
  Tensor _thnn_col2im_backward(const Tensor & grad_output, IntArrayRef kernel_size, IntArrayRef dilation, IntArrayRef padding, IntArrayRef stride) const override;
  Tensor & _thnn_col2im_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef kernel_size, IntArrayRef dilation, IntArrayRef padding, IntArrayRef stride) const override;
  Tensor _thnn_col2im_forward(const Tensor & self, IntArrayRef output_size, IntArrayRef kernel_size, IntArrayRef dilation, IntArrayRef padding, IntArrayRef stride) const override;
  Tensor & _thnn_col2im_forward_out(Tensor & output, const Tensor & self, IntArrayRef output_size, IntArrayRef kernel_size, IntArrayRef dilation, IntArrayRef padding, IntArrayRef stride) const override;
  std::tuple<Tensor,Tensor,Tensor> _thnn_conv2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, const Tensor & finput, const Tensor & fgrad_input, std::array<bool,3> output_mask) const override;
  std::tuple<Tensor &,Tensor &,Tensor &> _thnn_conv2d_backward_out(Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, const Tensor & finput, const Tensor & fgrad_input) const override;
  std::tuple<Tensor,Tensor,Tensor> _thnn_conv2d_forward(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding) const override;
  std::tuple<Tensor &,Tensor &,Tensor &> _thnn_conv2d_forward_out(Tensor & output, Tensor & finput, Tensor & fgrad_input, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding) const override;
  std::tuple<Tensor,Tensor,Tensor> _thnn_conv3d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, const Tensor & finput, const Tensor & fgrad_input, std::array<bool,3> output_mask) const override;
  std::tuple<Tensor &,Tensor &,Tensor &> _thnn_conv3d_backward_out(Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, const Tensor & finput, const Tensor & fgrad_input) const override;
  std::tuple<Tensor,Tensor,Tensor> _thnn_conv3d_forward(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding) const override;
  std::tuple<Tensor &,Tensor &,Tensor &> _thnn_conv3d_forward_out(Tensor & output, Tensor & finput, Tensor & fgrad_input, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding) const override;
  std::tuple<Tensor,Tensor> _thnn_conv_depthwise2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, std::array<bool,2> output_mask) const override;
  std::tuple<Tensor &,Tensor &> _thnn_conv_depthwise2d_backward_out(Tensor & grad_input, Tensor & grad_weight, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation) const override;
  Tensor _thnn_conv_depthwise2d_forward(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation) const override;
  Tensor & _thnn_conv_depthwise2d_forward_out(Tensor & output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation) const override;
  std::tuple<Tensor,Tensor,Tensor> _thnn_conv_dilated2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, const Tensor & columns, const Tensor & ones, std::array<bool,3> output_mask) const override;
  std::tuple<Tensor &,Tensor &,Tensor &> _thnn_conv_dilated2d_backward_out(Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, const Tensor & columns, const Tensor & ones) const override;
  std::tuple<Tensor,Tensor,Tensor> _thnn_conv_dilated2d_forward(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation) const override;
  std::tuple<Tensor &,Tensor &,Tensor &> _thnn_conv_dilated2d_forward_out(Tensor & output, Tensor & columns, Tensor & ones, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation) const override;
  std::tuple<Tensor,Tensor,Tensor> _thnn_conv_dilated3d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, const Tensor & columns, const Tensor & ones, std::array<bool,3> output_mask) const override;
  std::tuple<Tensor &,Tensor &,Tensor &> _thnn_conv_dilated3d_backward_out(Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, const Tensor & columns, const Tensor & ones) const override;
  std::tuple<Tensor,Tensor,Tensor> _thnn_conv_dilated3d_forward(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation) const override;
  std::tuple<Tensor &,Tensor &,Tensor &> _thnn_conv_dilated3d_forward_out(Tensor & output, Tensor & columns, Tensor & ones, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation) const override;
  std::tuple<Tensor,Tensor,Tensor> _thnn_conv_transpose2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation, const Tensor & columns, const Tensor & ones, std::array<bool,3> output_mask) const override;
  std::tuple<Tensor &,Tensor &,Tensor &> _thnn_conv_transpose2d_backward_out(Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation, const Tensor & columns, const Tensor & ones) const override;
  std::tuple<Tensor,Tensor,Tensor> _thnn_conv_transpose2d_forward(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation) const override;
  std::tuple<Tensor &,Tensor &,Tensor &> _thnn_conv_transpose2d_forward_out(Tensor & output, Tensor & columns, Tensor & ones, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation) const override;
  std::tuple<Tensor,Tensor,Tensor> _thnn_conv_transpose3d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation, const Tensor & finput, const Tensor & fgrad_input, std::array<bool,3> output_mask) const override;
  std::tuple<Tensor &,Tensor &,Tensor &> _thnn_conv_transpose3d_backward_out(Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation, const Tensor & finput, const Tensor & fgrad_input) const override;
  std::tuple<Tensor,Tensor,Tensor> _thnn_conv_transpose3d_forward(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation) const override;
  std::tuple<Tensor &,Tensor &,Tensor &> _thnn_conv_transpose3d_forward_out(Tensor & output, Tensor & finput, Tensor & fgrad_input, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation) const override;
  Tensor & _thnn_elu_(Tensor & self, Scalar alpha, Scalar scale, Scalar input_scale) const override;
  Tensor _thnn_elu_backward(const Tensor & grad_output, Scalar alpha, Scalar scale, Scalar input_scale, const Tensor & output) const override;
  Tensor & _thnn_elu_backward_out(Tensor & grad_input, const Tensor & grad_output, Scalar alpha, Scalar scale, Scalar input_scale, const Tensor & output) const override;
  Tensor _thnn_elu_forward(const Tensor & self, Scalar alpha, Scalar scale, Scalar input_scale) const override;
  Tensor & _thnn_elu_forward_(Tensor & self, Scalar alpha, Scalar scale, Scalar input_scale) const override;
  Tensor & _thnn_elu_forward_out(Tensor & output, const Tensor & self, Scalar alpha, Scalar scale, Scalar input_scale) const override;
  std::tuple<Tensor,Tensor> _thnn_fused_gru_cell(const Tensor & input_gates, const Tensor & hidden_gates, const Tensor & hx, const Tensor & input_bias, const Tensor & hidden_bias) const override;
  std::tuple<Tensor,Tensor,Tensor,Tensor,Tensor> _thnn_fused_gru_cell_backward(const Tensor & grad_hy, const Tensor & workspace, bool has_bias) const override;
  std::tuple<Tensor,Tensor,Tensor> _thnn_fused_lstm_cell(const Tensor & input_gates, const Tensor & hidden_gates, const Tensor & cx, const Tensor & input_bias, const Tensor & hidden_bias) const override;
  std::tuple<Tensor,Tensor,Tensor,Tensor,Tensor> _thnn_fused_lstm_cell_backward(const Tensor & grad_hy, const Tensor & grad_cy, const Tensor & cx, const Tensor & cy, const Tensor & workspace, bool has_bias) const override;
  Tensor _thnn_glu_backward(const Tensor & grad_output, const Tensor & self, int64_t dim) const override;
  Tensor & _thnn_glu_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, int64_t dim) const override;
  Tensor _thnn_glu_forward(const Tensor & self, int64_t dim) const override;
  Tensor & _thnn_glu_forward_out(Tensor & output, const Tensor & self, int64_t dim) const override;
  Tensor & _thnn_hardtanh_(Tensor & self, Scalar min_val, Scalar max_val) const override;
  Tensor _thnn_hardtanh_backward(const Tensor & grad_output, const Tensor & self, Scalar min_val, Scalar max_val) const override;
  Tensor & _thnn_hardtanh_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, Scalar min_val, Scalar max_val) const override;
  Tensor _thnn_hardtanh_forward(const Tensor & self, Scalar min_val, Scalar max_val) const override;
  Tensor & _thnn_hardtanh_forward_(Tensor & self, Scalar min_val, Scalar max_val) const override;
  Tensor & _thnn_hardtanh_forward_out(Tensor & output, const Tensor & self, Scalar min_val, Scalar max_val) const override;
  Tensor _thnn_im2col_backward(const Tensor & grad_output, IntArrayRef input_size, IntArrayRef kernel_size, IntArrayRef dilation, IntArrayRef padding, IntArrayRef stride) const override;
  Tensor & _thnn_im2col_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef input_size, IntArrayRef kernel_size, IntArrayRef dilation, IntArrayRef padding, IntArrayRef stride) const override;
  Tensor _thnn_im2col_forward(const Tensor & self, IntArrayRef kernel_size, IntArrayRef dilation, IntArrayRef padding, IntArrayRef stride) const override;
  Tensor & _thnn_im2col_forward_out(Tensor & output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef dilation, IntArrayRef padding, IntArrayRef stride) const override;
  Tensor _thnn_l1_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) const override;
  Tensor & _thnn_l1_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) const override;
  Tensor _thnn_l1_loss_forward(const Tensor & self, const Tensor & target, int64_t reduction) const override;
  Tensor & _thnn_l1_loss_forward_out(Tensor & output, const Tensor & self, const Tensor & target, int64_t reduction) const override;
  Tensor & _thnn_leaky_relu_(Tensor & self, Scalar negative_slope) const override;
  Tensor _thnn_leaky_relu_backward(const Tensor & grad_output, const Tensor & self, Scalar negative_slope) const override;
  Tensor & _thnn_leaky_relu_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, Scalar negative_slope) const override;
  Tensor _thnn_leaky_relu_forward(const Tensor & self, Scalar negative_slope) const override;
  Tensor & _thnn_leaky_relu_forward_(Tensor & self, Scalar negative_slope) const override;
  Tensor & _thnn_leaky_relu_forward_out(Tensor & output, const Tensor & self, Scalar negative_slope) const override;
  Tensor _thnn_log_sigmoid_backward(const Tensor & grad_output, const Tensor & self, const Tensor & buffer) const override;
  Tensor & _thnn_log_sigmoid_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & buffer) const override;
  std::tuple<Tensor,Tensor> _thnn_log_sigmoid_forward(const Tensor & self) const override;
  std::tuple<Tensor &,Tensor &> _thnn_log_sigmoid_forward_out(Tensor & output, Tensor & buffer, const Tensor & self) const override;
  Tensor _thnn_max_pool2d_with_indices_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode, const Tensor & indices) const override;
  Tensor & _thnn_max_pool2d_with_indices_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode, const Tensor & indices) const override;
  std::tuple<Tensor,Tensor> _thnn_max_pool2d_with_indices_forward(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode) const override;
  std::tuple<Tensor &,Tensor &> _thnn_max_pool2d_with_indices_forward_out(Tensor & output, Tensor & indices, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode) const override;
  Tensor _thnn_max_pool3d_with_indices_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode, const Tensor & indices) const override;
  Tensor & _thnn_max_pool3d_with_indices_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode, const Tensor & indices) const override;
  std::tuple<Tensor,Tensor> _thnn_max_pool3d_with_indices_forward(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode) const override;
  std::tuple<Tensor &,Tensor &> _thnn_max_pool3d_with_indices_forward_out(Tensor & output, Tensor & indices, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode) const override;
  Tensor _thnn_max_unpool2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & indices, IntArrayRef output_size) const override;
  Tensor & _thnn_max_unpool2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & indices, IntArrayRef output_size) const override;
  Tensor _thnn_max_unpool2d_forward(const Tensor & self, const Tensor & indices, IntArrayRef output_size) const override;
  Tensor & _thnn_max_unpool2d_forward_out(Tensor & output, const Tensor & self, const Tensor & indices, IntArrayRef output_size) const override;
  Tensor _thnn_max_unpool3d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & indices, IntArrayRef output_size, IntArrayRef stride, IntArrayRef padding) const override;
  Tensor & _thnn_max_unpool3d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & indices, IntArrayRef output_size, IntArrayRef stride, IntArrayRef padding) const override;
  Tensor _thnn_max_unpool3d_forward(const Tensor & self, const Tensor & indices, IntArrayRef output_size, IntArrayRef stride, IntArrayRef padding) const override;
  Tensor & _thnn_max_unpool3d_forward_out(Tensor & output, const Tensor & self, const Tensor & indices, IntArrayRef output_size, IntArrayRef stride, IntArrayRef padding) const override;
  Tensor _thnn_mse_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) const override;
  Tensor & _thnn_mse_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) const override;
  Tensor _thnn_mse_loss_forward(const Tensor & self, const Tensor & target, int64_t reduction) const override;
  Tensor & _thnn_mse_loss_forward_out(Tensor & output, const Tensor & self, const Tensor & target, int64_t reduction) const override;
  Tensor _thnn_multi_margin_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, Scalar p, Scalar margin, const Tensor & weight, int64_t reduction) const override;
  Tensor & _thnn_multi_margin_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, Scalar p, Scalar margin, const Tensor & weight, int64_t reduction) const override;
  Tensor _thnn_multi_margin_loss_forward(const Tensor & self, const Tensor & target, Scalar p, Scalar margin, const Tensor & weight, int64_t reduction) const override;
  Tensor & _thnn_multi_margin_loss_forward_out(Tensor & output, const Tensor & self, const Tensor & target, Scalar p, Scalar margin, const Tensor & weight, int64_t reduction) const override;
  Tensor _thnn_multilabel_margin_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction, const Tensor & is_target) const override;
  Tensor & _thnn_multilabel_margin_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction, const Tensor & is_target) const override;
  std::tuple<Tensor,Tensor> _thnn_multilabel_margin_loss_forward(const Tensor & self, const Tensor & target, int64_t reduction) const override;
  std::tuple<Tensor &,Tensor &> _thnn_multilabel_margin_loss_forward_out(Tensor & output, Tensor & is_target, const Tensor & self, const Tensor & target, int64_t reduction) const override;
  Tensor _thnn_nll_loss2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index, const Tensor & total_weight) const override;
  Tensor & _thnn_nll_loss2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index, const Tensor & total_weight) const override;
  std::tuple<Tensor,Tensor> _thnn_nll_loss2d_forward(const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index) const override;
  std::tuple<Tensor &,Tensor &> _thnn_nll_loss2d_forward_out(Tensor & output, Tensor & total_weight, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index) const override;
  Tensor _thnn_nll_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index, const Tensor & total_weight) const override;
  Tensor & _thnn_nll_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index, const Tensor & total_weight) const override;
  std::tuple<Tensor,Tensor> _thnn_nll_loss_forward(const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index) const override;
  std::tuple<Tensor &,Tensor &> _thnn_nll_loss_forward_out(Tensor & output, Tensor & total_weight, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index) const override;
  Tensor & _thnn_rrelu_with_noise_(Tensor & self, const Tensor & noise, Scalar lower, Scalar upper, bool training, Generator * generator) const override;
  Tensor _thnn_rrelu_with_noise_backward(const Tensor & grad_output, const Tensor & self, const Tensor & noise, Scalar lower, Scalar upper, bool training) const override;
  Tensor & _thnn_rrelu_with_noise_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & noise, Scalar lower, Scalar upper, bool training) const override;
  Tensor _thnn_rrelu_with_noise_forward(const Tensor & self, const Tensor & noise, Scalar lower, Scalar upper, bool training, Generator * generator) const override;
  Tensor & _thnn_rrelu_with_noise_forward_(Tensor & self, const Tensor & noise, Scalar lower, Scalar upper, bool training, Generator * generator) const override;
  Tensor & _thnn_rrelu_with_noise_forward_out(Tensor & output, const Tensor & self, const Tensor & noise, Scalar lower, Scalar upper, bool training, Generator * generator) const override;
  Tensor _thnn_sigmoid_backward(const Tensor & grad_output, const Tensor & output) const override;
  Tensor & _thnn_sigmoid_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & output) const override;
  Tensor _thnn_sigmoid_forward(const Tensor & self) const override;
  Tensor & _thnn_sigmoid_forward_out(Tensor & output, const Tensor & self) const override;
  Tensor _thnn_smooth_l1_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) const override;
  Tensor & _thnn_smooth_l1_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) const override;
  Tensor _thnn_smooth_l1_loss_forward(const Tensor & self, const Tensor & target, int64_t reduction) const override;
  Tensor & _thnn_smooth_l1_loss_forward_out(Tensor & output, const Tensor & self, const Tensor & target, int64_t reduction) const override;
  Tensor _thnn_soft_margin_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) const override;
  Tensor & _thnn_soft_margin_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) const override;
  Tensor _thnn_soft_margin_loss_forward(const Tensor & self, const Tensor & target, int64_t reduction) const override;
  Tensor & _thnn_soft_margin_loss_forward_out(Tensor & output, const Tensor & self, const Tensor & target, int64_t reduction) const override;
  Tensor _thnn_softplus_backward(const Tensor & grad_output, const Tensor & self, Scalar beta, Scalar threshold, const Tensor & output) const override;
  Tensor & _thnn_softplus_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, Scalar beta, Scalar threshold, const Tensor & output) const override;
  Tensor _thnn_softplus_forward(const Tensor & self, Scalar beta, Scalar threshold) const override;
  Tensor & _thnn_softplus_forward_out(Tensor & output, const Tensor & self, Scalar beta, Scalar threshold) const override;
  Tensor _thnn_softshrink_backward(const Tensor & grad_output, const Tensor & self, Scalar lambd) const override;
  Tensor & _thnn_softshrink_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, Scalar lambd) const override;
  Tensor _thnn_softshrink_forward(const Tensor & self, Scalar lambd) const override;
  Tensor & _thnn_softshrink_forward_out(Tensor & output, const Tensor & self, Scalar lambd) const override;
  Tensor _thnn_tanh_backward(const Tensor & grad_output, const Tensor & output) const override;
  Tensor & _thnn_tanh_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & output) const override;
  Tensor _thnn_tanh_forward(const Tensor & self) const override;
  Tensor & _thnn_tanh_forward_out(Tensor & output, const Tensor & self) const override;
  Tensor _thnn_upsample_bicubic2d_backward(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners) const override;
  Tensor & _thnn_upsample_bicubic2d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners) const override;
  Tensor _thnn_upsample_bicubic2d_forward(const Tensor & self, IntArrayRef output_size, bool align_corners) const override;
  Tensor & _thnn_upsample_bicubic2d_forward_out(Tensor & output, const Tensor & self, IntArrayRef output_size, bool align_corners) const override;
  Tensor _thnn_upsample_bilinear2d_backward(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners) const override;
  Tensor & _thnn_upsample_bilinear2d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners) const override;
  Tensor _thnn_upsample_bilinear2d_forward(const Tensor & self, IntArrayRef output_size, bool align_corners) const override;
  Tensor & _thnn_upsample_bilinear2d_forward_out(Tensor & output, const Tensor & self, IntArrayRef output_size, bool align_corners) const override;
  Tensor _thnn_upsample_linear1d_backward(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners) const override;
  Tensor & _thnn_upsample_linear1d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners) const override;
  Tensor _thnn_upsample_linear1d_forward(const Tensor & self, IntArrayRef output_size, bool align_corners) const override;
  Tensor & _thnn_upsample_linear1d_forward_out(Tensor & output, const Tensor & self, IntArrayRef output_size, bool align_corners) const override;
  Tensor _thnn_upsample_nearest1d_backward(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size) const override;
  Tensor & _thnn_upsample_nearest1d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size) const override;
  Tensor _thnn_upsample_nearest1d_forward(const Tensor & self, IntArrayRef output_size) const override;
  Tensor & _thnn_upsample_nearest1d_forward_out(Tensor & output, const Tensor & self, IntArrayRef output_size) const override;
  Tensor _thnn_upsample_nearest2d_backward(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size) const override;
  Tensor & _thnn_upsample_nearest2d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size) const override;
  Tensor _thnn_upsample_nearest2d_forward(const Tensor & self, IntArrayRef output_size) const override;
  Tensor & _thnn_upsample_nearest2d_forward_out(Tensor & output, const Tensor & self, IntArrayRef output_size) const override;
  Tensor _thnn_upsample_nearest3d_backward(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size) const override;
  Tensor & _thnn_upsample_nearest3d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size) const override;
  Tensor _thnn_upsample_nearest3d_forward(const Tensor & self, IntArrayRef output_size) const override;
  Tensor & _thnn_upsample_nearest3d_forward_out(Tensor & output, const Tensor & self, IntArrayRef output_size) const override;
  Tensor _thnn_upsample_trilinear3d_backward(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners) const override;
  Tensor & _thnn_upsample_trilinear3d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners) const override;
  Tensor _thnn_upsample_trilinear3d_forward(const Tensor & self, IntArrayRef output_size, bool align_corners) const override;
  Tensor & _thnn_upsample_trilinear3d_forward_out(Tensor & output, const Tensor & self, IntArrayRef output_size, bool align_corners) const override;
  std::tuple<Tensor,Tensor> _triangular_solve_helper(const Tensor & self, const Tensor & A, bool upper, bool transpose, bool unitriangular) const override;
  Tensor _trilinear(const Tensor & i1, const Tensor & i2, const Tensor & i3, IntArrayRef expand1, IntArrayRef expand2, IntArrayRef expand3, IntArrayRef sumdim, int64_t unroll_dim) const override;
  std::tuple<Tensor,Tensor> _unique(const Tensor & self, bool sorted, bool return_inverse) const override;
  std::tuple<Tensor,Tensor,Tensor> _unique2(const Tensor & self, bool sorted, bool return_inverse, bool return_counts) const override;
  Tensor _unsafe_view(const Tensor & self, IntArrayRef size) const override;
  Tensor _values(const Tensor & self) const override;
  Tensor _weight_norm(const Tensor & v, const Tensor & g, int64_t dim) const override;
  std::tuple<Tensor,Tensor> _weight_norm_cuda_interface(const Tensor & v, const Tensor & g, int64_t dim) const override;
  std::tuple<Tensor,Tensor> _weight_norm_cuda_interface_backward(const Tensor & grad_w, const Tensor & saved_v, const Tensor & saved_g, const Tensor & saved_norms, int64_t dim) const override;
  std::tuple<Tensor,Tensor> _weight_norm_differentiable_backward(const Tensor & grad_w, const Tensor & saved_v, const Tensor & saved_g, const Tensor & saved_norms, int64_t dim) const override;
  Tensor abs(const Tensor & self) const override;
  Tensor & abs_(Tensor & self) const override;
  Tensor & abs_out(Tensor & out, const Tensor & self) const override;
  Tensor acos(const Tensor & self) const override;
  Tensor & acos_(Tensor & self) const override;
  Tensor & acos_out(Tensor & out, const Tensor & self) const override;
  Tensor adaptive_avg_pool1d(const Tensor & self, IntArrayRef output_size) const override;
  Tensor adaptive_avg_pool2d(const Tensor & self, IntArrayRef output_size) const override;
  Tensor & adaptive_avg_pool2d_out(Tensor & out, const Tensor & self, IntArrayRef output_size) const override;
  Tensor adaptive_avg_pool3d(const Tensor & self, IntArrayRef output_size) const override;
  Tensor adaptive_avg_pool3d_backward(const Tensor & grad_output, const Tensor & self) const override;
  Tensor & adaptive_avg_pool3d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self) const override;
  Tensor & adaptive_avg_pool3d_out(Tensor & out, const Tensor & self, IntArrayRef output_size) const override;
  std::tuple<Tensor,Tensor> adaptive_max_pool1d(const Tensor & self, IntArrayRef output_size) const override;
  std::tuple<Tensor,Tensor> adaptive_max_pool2d(const Tensor & self, IntArrayRef output_size) const override;
  Tensor adaptive_max_pool2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & indices) const override;
  Tensor & adaptive_max_pool2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & indices) const override;
  std::tuple<Tensor &,Tensor &> adaptive_max_pool2d_out(Tensor & out, Tensor & indices, const Tensor & self, IntArrayRef output_size) const override;
  std::tuple<Tensor,Tensor> adaptive_max_pool3d(const Tensor & self, IntArrayRef output_size) const override;
  Tensor adaptive_max_pool3d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & indices) const override;
  Tensor & adaptive_max_pool3d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & indices) const override;
  std::tuple<Tensor &,Tensor &> adaptive_max_pool3d_out(Tensor & out, Tensor & indices, const Tensor & self, IntArrayRef output_size) const override;
  Tensor add(const Tensor & self, const Tensor & other, Scalar alpha) const override;
  Tensor add(const Tensor & self, Scalar other, Scalar alpha) const override;
  Tensor & add_(Tensor & self, const Tensor & other, Scalar alpha) const override;
  Tensor & add_(Tensor & self, Scalar other, Scalar alpha) const override;
  Tensor & add_out(Tensor & out, const Tensor & self, const Tensor & other, Scalar alpha) const override;
  Tensor addbmm(const Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta, Scalar alpha) const override;
  Tensor & addbmm_(Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta, Scalar alpha) const override;
  Tensor & addbmm_out(Tensor & out, const Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta, Scalar alpha) const override;
  Tensor addcdiv(const Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value) const override;
  Tensor & addcdiv_(Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value) const override;
  Tensor & addcdiv_out(Tensor & out, const Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value) const override;
  Tensor addcmul(const Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value) const override;
  Tensor & addcmul_(Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value) const override;
  Tensor & addcmul_out(Tensor & out, const Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value) const override;
  Tensor addmm(const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta, Scalar alpha) const override;
  Tensor & addmm_(Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta, Scalar alpha) const override;
  Tensor & addmm_out(Tensor & out, const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta, Scalar alpha) const override;
  Tensor addmv(const Tensor & self, const Tensor & mat, const Tensor & vec, Scalar beta, Scalar alpha) const override;
  Tensor & addmv_(Tensor & self, const Tensor & mat, const Tensor & vec, Scalar beta, Scalar alpha) const override;
  Tensor & addmv_out(Tensor & out, const Tensor & self, const Tensor & mat, const Tensor & vec, Scalar beta, Scalar alpha) const override;
  Tensor addr(const Tensor & self, const Tensor & vec1, const Tensor & vec2, Scalar beta, Scalar alpha) const override;
  Tensor & addr_(Tensor & self, const Tensor & vec1, const Tensor & vec2, Scalar beta, Scalar alpha) const override;
  Tensor & addr_out(Tensor & out, const Tensor & self, const Tensor & vec1, const Tensor & vec2, Scalar beta, Scalar alpha) const override;
  Tensor affine_grid_generator(const Tensor & theta, IntArrayRef size) const override;
  Tensor affine_grid_generator_backward(const Tensor & grad, IntArrayRef size) const override;
  Tensor alias(const Tensor & self) const override;
  Tensor all(const Tensor & self, int64_t dim, bool keepdim) const override;
  Tensor all(const Tensor & self) const override;
  Tensor & all_out(Tensor & out, const Tensor & self, int64_t dim, bool keepdim) const override;
  bool allclose(const Tensor & self, const Tensor & other, double rtol, double atol, bool equal_nan) const override;
  Tensor alpha_dropout(const Tensor & input, double p, bool train) const override;
  Tensor & alpha_dropout_(Tensor & self, double p, bool train) const override;
  Tensor any(const Tensor & self, int64_t dim, bool keepdim) const override;
  Tensor any(const Tensor & self) const override;
  Tensor & any_out(Tensor & out, const Tensor & self, int64_t dim, bool keepdim) const override;
  Tensor arange(Scalar end, const TensorOptions & options) const override;
  Tensor arange(Scalar start, Scalar end, const TensorOptions & options) const override;
  Tensor arange(Scalar start, Scalar end, Scalar step, const TensorOptions & options) const override;
  Tensor & arange_out(Tensor & out, Scalar end) const override;
  Tensor & arange_out(Tensor & out, Scalar start, Scalar end, Scalar step) const override;
  Tensor argmax(const Tensor & self, c10::optional<int64_t> dim, bool keepdim) const override;
  Tensor argmin(const Tensor & self, c10::optional<int64_t> dim, bool keepdim) const override;
  Tensor argsort(const Tensor & self, int64_t dim, bool descending) const override;
  Tensor as_strided(const Tensor & self, IntArrayRef size, IntArrayRef stride, c10::optional<int64_t> storage_offset) const override;
  Tensor & as_strided_(Tensor & self, IntArrayRef size, IntArrayRef stride, c10::optional<int64_t> storage_offset) const override;
  Tensor asin(const Tensor & self) const override;
  Tensor & asin_(Tensor & self) const override;
  Tensor & asin_out(Tensor & out, const Tensor & self) const override;
  Tensor atan(const Tensor & self) const override;
  Tensor atan2(const Tensor & self, const Tensor & other) const override;
  Tensor & atan2_(Tensor & self, const Tensor & other) const override;
  Tensor & atan2_out(Tensor & out, const Tensor & self, const Tensor & other) const override;
  Tensor & atan_(Tensor & self) const override;
  Tensor & atan_out(Tensor & out, const Tensor & self) const override;
  Tensor avg_pool1d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad) const override;
  Tensor avg_pool2d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad) const override;
  Tensor avg_pool2d_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad) const override;
  Tensor & avg_pool2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad) const override;
  Tensor & avg_pool2d_out(Tensor & out, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad) const override;
  Tensor avg_pool3d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad) const override;
  Tensor avg_pool3d_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad) const override;
  Tensor & avg_pool3d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad) const override;
  Tensor & avg_pool3d_out(Tensor & out, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad) const override;
  Tensor baddbmm(const Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta, Scalar alpha) const override;
  Tensor & baddbmm_(Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta, Scalar alpha) const override;
  Tensor & baddbmm_out(Tensor & out, const Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta, Scalar alpha) const override;
  Tensor bartlett_window(int64_t window_length, const TensorOptions & options) const override;
  Tensor bartlett_window(int64_t window_length, bool periodic, const TensorOptions & options) const override;
  Tensor batch_norm(const Tensor & input, const Tensor & weight, const Tensor & bias, const Tensor & running_mean, const Tensor & running_var, bool training, double momentum, double eps, bool cudnn_enabled) const override;
  Tensor batch_norm_backward_elemt(const Tensor & grad_out, const Tensor & input, const Tensor & mean, const Tensor & invstd, const Tensor & weight, const Tensor & mean_dy, const Tensor & mean_dy_xmu) const override;
  std::tuple<Tensor,Tensor,Tensor,Tensor> batch_norm_backward_reduce(const Tensor & grad_out, const Tensor & input, const Tensor & mean, const Tensor & invstd, bool input_g, bool weight_g, bool bias_g) const override;
  Tensor batch_norm_elemt(const Tensor & input, const Tensor & weight, const Tensor & bias, const Tensor & mean, const Tensor & invstd, double eps) const override;
  std::tuple<Tensor,Tensor> batch_norm_gather_stats(const Tensor & input, const Tensor & mean, const Tensor & invstd, const Tensor & running_mean, const Tensor & running_var, double momentum, double eps, int64_t count) const override;
  std::tuple<Tensor,Tensor> batch_norm_stats(const Tensor & input, double eps) const override;
  std::tuple<Tensor,Tensor> batch_norm_update_stats(const Tensor & input, const Tensor & running_mean, const Tensor & running_var, double momentum) const override;
  Tensor bernoulli(const Tensor & self, Generator * generator) const override;
  Tensor bernoulli(const Tensor & self, double p, Generator * generator) const override;
  Tensor & bernoulli_(Tensor & self, const Tensor & p, Generator * generator) const override;
  Tensor & bernoulli_(Tensor & self, double p, Generator * generator) const override;
  Tensor & bernoulli_out(Tensor & out, const Tensor & self, Generator * generator) const override;
  Tensor bilinear(const Tensor & input1, const Tensor & input2, const Tensor & weight, const Tensor & bias) const override;
  Tensor binary_cross_entropy(const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction) const override;
  Tensor binary_cross_entropy_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction) const override;
  Tensor & binary_cross_entropy_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction) const override;
  Tensor & binary_cross_entropy_out(Tensor & out, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction) const override;
  Tensor binary_cross_entropy_with_logits(const Tensor & self, const Tensor & target, const Tensor & weight, const Tensor & pos_weight, int64_t reduction) const override;
  Tensor binary_cross_entropy_with_logits_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight, const Tensor & pos_weight, int64_t reduction) const override;
  Tensor bincount(const Tensor & self, const Tensor & weights, int64_t minlength) const override;
  Tensor blackman_window(int64_t window_length, const TensorOptions & options) const override;
  Tensor blackman_window(int64_t window_length, bool periodic, const TensorOptions & options) const override;
  Tensor bmm(const Tensor & self, const Tensor & mat2) const override;
  Tensor & bmm_out(Tensor & out, const Tensor & self, const Tensor & mat2) const override;
  std::vector<Tensor> broadcast_tensors(TensorList tensors) const override;
  Tensor cartesian_prod(TensorList tensors) const override;
  Tensor cat(TensorList tensors, int64_t dim) const override;
  Tensor & cat_out(Tensor & out, TensorList tensors, int64_t dim) const override;
  Tensor & cauchy_(Tensor & self, double median, double sigma, Generator * generator) const override;
  Tensor cdist(const Tensor & x1, const Tensor & x2, double p) const override;
  Tensor ceil(const Tensor & self) const override;
  Tensor & ceil_(Tensor & self) const override;
  Tensor & ceil_out(Tensor & out, const Tensor & self) const override;
  Tensor celu(const Tensor & self, Scalar alpha) const override;
  Tensor & celu_(Tensor & self, Scalar alpha) const override;
  Tensor chain_matmul(TensorList matrices) const override;
  Tensor cholesky(const Tensor & self, bool upper) const override;
  Tensor cholesky_inverse(const Tensor & self, bool upper) const override;
  Tensor & cholesky_inverse_out(Tensor & out, const Tensor & self, bool upper) const override;
  Tensor & cholesky_out(Tensor & out, const Tensor & self, bool upper) const override;
  Tensor cholesky_solve(const Tensor & self, const Tensor & input2, bool upper) const override;
  Tensor & cholesky_solve_out(Tensor & out, const Tensor & self, const Tensor & input2, bool upper) const override;
  std::vector<Tensor> chunk(const Tensor & self, int64_t chunks, int64_t dim) const override;
  Tensor clamp(const Tensor & self, c10::optional<Scalar> min, c10::optional<Scalar> max) const override;
  Tensor & clamp_(Tensor & self, c10::optional<Scalar> min, c10::optional<Scalar> max) const override;
  Tensor clamp_max(const Tensor & self, Scalar max) const override;
  Tensor & clamp_max_(Tensor & self, Scalar max) const override;
  Tensor & clamp_max_out(Tensor & out, const Tensor & self, Scalar max) const override;
  Tensor clamp_min(const Tensor & self, Scalar min) const override;
  Tensor & clamp_min_(Tensor & self, Scalar min) const override;
  Tensor & clamp_min_out(Tensor & out, const Tensor & self, Scalar min) const override;
  Tensor & clamp_out(Tensor & out, const Tensor & self, c10::optional<Scalar> min, c10::optional<Scalar> max) const override;
  Tensor clone(const Tensor & self) const override;
  Tensor coalesce(const Tensor & self) const override;
  Tensor combinations(const Tensor & self, int64_t r, bool with_replacement) const override;
  Tensor constant_pad_nd(const Tensor & self, IntArrayRef pad, Scalar value) const override;
  Tensor contiguous(const Tensor & self) const override;
  Tensor conv1d(const Tensor & input, const Tensor & weight, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, int64_t groups) const override;
  Tensor conv2d(const Tensor & input, const Tensor & weight, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, int64_t groups) const override;
  Tensor conv3d(const Tensor & input, const Tensor & weight, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, int64_t groups) const override;
  Tensor conv_tbc(const Tensor & self, const Tensor & weight, const Tensor & bias, int64_t pad) const override;
  std::tuple<Tensor,Tensor,Tensor> conv_tbc_backward(const Tensor & self, const Tensor & input, const Tensor & weight, const Tensor & bias, int64_t pad) const override;
  Tensor conv_transpose1d(const Tensor & input, const Tensor & weight, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, int64_t groups, IntArrayRef dilation) const override;
  Tensor conv_transpose2d(const Tensor & input, const Tensor & weight, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, int64_t groups, IntArrayRef dilation) const override;
  Tensor conv_transpose3d(const Tensor & input, const Tensor & weight, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, int64_t groups, IntArrayRef dilation) const override;
  Tensor convolution(const Tensor & input, const Tensor & weight, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool transposed, IntArrayRef output_padding, int64_t groups) const override;
  Tensor & copy_(Tensor & self, const Tensor & src, bool non_blocking) const override;
  Tensor & copy_sparse_to_sparse_(Tensor & self, const Tensor & src, bool non_blocking) const override;
  Tensor cos(const Tensor & self) const override;
  Tensor & cos_(Tensor & self) const override;
  Tensor & cos_out(Tensor & out, const Tensor & self) const override;
  Tensor cosh(const Tensor & self) const override;
  Tensor & cosh_(Tensor & self) const override;
  Tensor & cosh_out(Tensor & out, const Tensor & self) const override;
  Tensor cosine_embedding_loss(const Tensor & input1, const Tensor & input2, const Tensor & target, double margin, int64_t reduction) const override;
  Tensor cosine_similarity(const Tensor & x1, const Tensor & x2, int64_t dim, double eps) const override;
  Tensor cross(const Tensor & self, const Tensor & other, c10::optional<int64_t> dim) const override;
  Tensor & cross_out(Tensor & out, const Tensor & self, const Tensor & other, c10::optional<int64_t> dim) const override;
  Tensor ctc_loss(const Tensor & log_probs, const Tensor & targets, IntArrayRef input_lengths, IntArrayRef target_lengths, int64_t blank, int64_t reduction, bool zero_infinity) const override;
  Tensor ctc_loss(const Tensor & log_probs, const Tensor & targets, const Tensor & input_lengths, const Tensor & target_lengths, int64_t blank, int64_t reduction, bool zero_infinity) const override;
  Tensor cudnn_affine_grid_generator(const Tensor & theta, int64_t N, int64_t C, int64_t H, int64_t W) const override;
  Tensor cudnn_affine_grid_generator_backward(const Tensor & grad, int64_t N, int64_t C, int64_t H, int64_t W) const override;
  std::tuple<Tensor,Tensor,Tensor> cudnn_batch_norm(const Tensor & input, const Tensor & weight, const Tensor & bias, const Tensor & running_mean, const Tensor & running_var, bool training, double exponential_average_factor, double epsilon) const override;
  std::tuple<Tensor,Tensor,Tensor> cudnn_batch_norm_backward(const Tensor & input, const Tensor & grad_output, const Tensor & weight, const Tensor & running_mean, const Tensor & running_var, const Tensor & save_mean, const Tensor & save_var, double epsilon) const override;
  Tensor cudnn_convolution(const Tensor & self, const Tensor & weight, const Tensor & bias, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic) const override;
  std::tuple<Tensor,Tensor,Tensor> cudnn_convolution_backward(const Tensor & self, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic, std::array<bool,3> output_mask) const override;
  Tensor cudnn_convolution_backward_bias(const Tensor & grad_output) const override;
  Tensor cudnn_convolution_backward_input(IntArrayRef self_size, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic) const override;
  Tensor cudnn_convolution_backward_weight(IntArrayRef weight_size, const Tensor & grad_output, const Tensor & self, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic) const override;
  Tensor cudnn_convolution_transpose(const Tensor & self, const Tensor & weight, const Tensor & bias, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic) const override;
  std::tuple<Tensor,Tensor,Tensor> cudnn_convolution_transpose_backward(const Tensor & self, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic, std::array<bool,3> output_mask) const override;
  Tensor cudnn_convolution_transpose_backward_bias(const Tensor & grad_output) const override;
  Tensor cudnn_convolution_transpose_backward_input(const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic) const override;
  Tensor cudnn_convolution_transpose_backward_weight(IntArrayRef weight_size, const Tensor & grad_output, const Tensor & self, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic) const override;
  Tensor cudnn_grid_sampler(const Tensor & self, const Tensor & grid) const override;
  std::tuple<Tensor,Tensor> cudnn_grid_sampler_backward(const Tensor & self, const Tensor & grid, const Tensor & grad_output) const override;
  bool cudnn_is_acceptable(const Tensor & self) const override;
  Tensor cumprod(const Tensor & self, int64_t dim, ScalarType dtype) const override;
  Tensor cumprod(const Tensor & self, int64_t dim) const override;
  Tensor & cumprod_out(Tensor & out, const Tensor & self, int64_t dim, ScalarType dtype) const override;
  Tensor & cumprod_out(Tensor & out, const Tensor & self, int64_t dim) const override;
  Tensor cumsum(const Tensor & self, int64_t dim, ScalarType dtype) const override;
  Tensor cumsum(const Tensor & self, int64_t dim) const override;
  Tensor & cumsum_out(Tensor & out, const Tensor & self, int64_t dim, ScalarType dtype) const override;
  Tensor & cumsum_out(Tensor & out, const Tensor & self, int64_t dim) const override;
  void* data_ptr(const Tensor & self) const override;
  int64_t dense_dim(const Tensor & self) const override;
  Tensor dequantize(const Tensor & self) const override;
  Tensor det(const Tensor & self) const override;
  Tensor detach(const Tensor & self) const override;
  Tensor & detach_(Tensor & self) const override;
  Tensor diag(const Tensor & self, int64_t diagonal) const override;
  Tensor diag_embed(const Tensor & self, int64_t offset, int64_t dim1, int64_t dim2) const override;
  Tensor & diag_out(Tensor & out, const Tensor & self, int64_t diagonal) const override;
  Tensor diagflat(const Tensor & self, int64_t offset) const override;
  Tensor diagonal(const Tensor & self, int64_t offset, int64_t dim1, int64_t dim2) const override;
  Tensor digamma(const Tensor & self) const override;
  Tensor & digamma_(Tensor & self) const override;
  Tensor & digamma_out(Tensor & out, const Tensor & self) const override;
  Tensor dist(const Tensor & self, const Tensor & other, Scalar p) const override;
  Tensor div(const Tensor & self, const Tensor & other) const override;
  Tensor div(const Tensor & self, Scalar other) const override;
  Tensor & div_(Tensor & self, const Tensor & other) const override;
  Tensor & div_(Tensor & self, Scalar other) const override;
  Tensor & div_out(Tensor & out, const Tensor & self, const Tensor & other) const override;
  Tensor dot(const Tensor & self, const Tensor & tensor) const override;
  Tensor & dot_out(Tensor & out, const Tensor & self, const Tensor & tensor) const override;
  Tensor dropout(const Tensor & input, double p, bool train) const override;
  Tensor & dropout_(Tensor & self, double p, bool train) const override;
  std::tuple<Tensor,Tensor> eig(const Tensor & self, bool eigenvectors) const override;
  std::tuple<Tensor &,Tensor &> eig_out(Tensor & e, Tensor & v, const Tensor & self, bool eigenvectors) const override;
  Tensor einsum(std::string equation, TensorList tensors) const override;
  Tensor elu(const Tensor & self, Scalar alpha, Scalar scale, Scalar input_scale) const override;
  Tensor & elu_(Tensor & self, Scalar alpha, Scalar scale, Scalar input_scale) const override;
  Tensor elu_backward(const Tensor & grad_output, Scalar alpha, Scalar scale, Scalar input_scale, const Tensor & output) const override;
  Tensor & elu_backward_out(Tensor & grad_input, const Tensor & grad_output, Scalar alpha, Scalar scale, Scalar input_scale, const Tensor & output) const override;
  Tensor & elu_out(Tensor & out, const Tensor & self, Scalar alpha, Scalar scale, Scalar input_scale) const override;
  Tensor embedding(const Tensor & weight, const Tensor & indices, int64_t padding_idx, bool scale_grad_by_freq, bool sparse) const override;
  Tensor embedding_backward(const Tensor & grad, const Tensor & indices, int64_t num_weights, int64_t padding_idx, bool scale_grad_by_freq, bool sparse) const override;
  std::tuple<Tensor,Tensor,Tensor,Tensor> embedding_bag(const Tensor & weight, const Tensor & indices, const Tensor & offsets, bool scale_grad_by_freq, int64_t mode, bool sparse, const Tensor & per_sample_weights) const override;
  Tensor embedding_dense_backward(const Tensor & grad_output, const Tensor & indices, int64_t num_weights, int64_t padding_idx, bool scale_grad_by_freq) const override;
  Tensor & embedding_renorm_(Tensor & self, const Tensor & indices, double max_norm, double norm_type) const override;
  Tensor embedding_sparse_backward(const Tensor & grad, const Tensor & indices, int64_t num_weights, int64_t padding_idx, bool scale_grad_by_freq) const override;
  Tensor empty(IntArrayRef size, const TensorOptions & options) const override;
  Tensor empty_like(const Tensor & self) const override;
  Tensor empty_like(const Tensor & self, const TensorOptions & options) const override;
  Tensor & empty_out(Tensor & out, IntArrayRef size) const override;
  Tensor empty_strided(IntArrayRef size, IntArrayRef stride, const TensorOptions & options) const override;
  Tensor eq(const Tensor & self, Scalar other) const override;
  Tensor eq(const Tensor & self, const Tensor & other) const override;
  Tensor & eq_(Tensor & self, Scalar other) const override;
  Tensor & eq_(Tensor & self, const Tensor & other) const override;
  Tensor & eq_out(Tensor & out, const Tensor & self, Scalar other) const override;
  Tensor & eq_out(Tensor & out, const Tensor & self, const Tensor & other) const override;
  bool equal(const Tensor & self, const Tensor & other) const override;
  Tensor erf(const Tensor & self) const override;
  Tensor & erf_(Tensor & self) const override;
  Tensor & erf_out(Tensor & out, const Tensor & self) const override;
  Tensor erfc(const Tensor & self) const override;
  Tensor & erfc_(Tensor & self) const override;
  Tensor & erfc_out(Tensor & out, const Tensor & self) const override;
  Tensor erfinv(const Tensor & self) const override;
  Tensor & erfinv_(Tensor & self) const override;
  Tensor & erfinv_out(Tensor & out, const Tensor & self) const override;
  Tensor exp(const Tensor & self) const override;
  Tensor & exp_(Tensor & self) const override;
  Tensor & exp_out(Tensor & out, const Tensor & self) const override;
  Tensor expand(const Tensor & self, IntArrayRef size, bool implicit) const override;
  Tensor expand_as(const Tensor & self, const Tensor & other) const override;
  Tensor expm1(const Tensor & self) const override;
  Tensor & expm1_(Tensor & self) const override;
  Tensor & expm1_out(Tensor & out, const Tensor & self) const override;
  Tensor & exponential_(Tensor & self, double lambd, Generator * generator) const override;
  Tensor eye(int64_t n, const TensorOptions & options) const override;
  Tensor eye(int64_t n, int64_t m, const TensorOptions & options) const override;
  Tensor & eye_out(Tensor & out, int64_t n) const override;
  Tensor & eye_out(Tensor & out, int64_t n, int64_t m) const override;
  bool fbgemm_is_cpu_supported() const override;
  Tensor fbgemm_linear_int8_weight(const Tensor & input, const Tensor & weight, const Tensor & packed, const Tensor & col_offsets, Scalar weight_scale, Scalar weight_zero_point, const Tensor & bias) const override;
  std::tuple<Tensor,Tensor,double,int64_t> fbgemm_linear_quantize_weight(const Tensor & input) const override;
  Tensor fbgemm_pack_quantized_matrix(const Tensor & input, int64_t K, int64_t N) const override;
  Tensor feature_alpha_dropout(const Tensor & input, double p, bool train) const override;
  Tensor & feature_alpha_dropout_(Tensor & self, double p, bool train) const override;
  Tensor feature_dropout(const Tensor & input, double p, bool train) const override;
  Tensor & feature_dropout_(Tensor & self, double p, bool train) const override;
  Tensor fft(const Tensor & self, int64_t signal_ndim, bool normalized) const override;
  Tensor & fill_(Tensor & self, Scalar value) const override;
  Tensor & fill_(Tensor & self, const Tensor & value) const override;
  Tensor flatten(const Tensor & self, int64_t start_dim, int64_t end_dim) const override;
  Tensor flip(const Tensor & self, IntArrayRef dims) const override;
  Tensor floor(const Tensor & self) const override;
  Tensor & floor_(Tensor & self) const override;
  Tensor & floor_out(Tensor & out, const Tensor & self) const override;
  Tensor fmod(const Tensor & self, Scalar other) const override;
  Tensor fmod(const Tensor & self, const Tensor & other) const override;
  Tensor & fmod_(Tensor & self, Scalar other) const override;
  Tensor & fmod_(Tensor & self, const Tensor & other) const override;
  Tensor & fmod_out(Tensor & out, const Tensor & self, Scalar other) const override;
  Tensor & fmod_out(Tensor & out, const Tensor & self, const Tensor & other) const override;
  Tensor frac(const Tensor & self) const override;
  Tensor & frac_(Tensor & self) const override;
  Tensor & frac_out(Tensor & out, const Tensor & self) const override;
  std::tuple<Tensor,Tensor> fractional_max_pool2d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef output_size, const Tensor & random_samples) const override;
  Tensor fractional_max_pool2d_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef output_size, const Tensor & indices) const override;
  Tensor & fractional_max_pool2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef output_size, const Tensor & indices) const override;
  std::tuple<Tensor &,Tensor &> fractional_max_pool2d_out(Tensor & output, Tensor & indices, const Tensor & self, IntArrayRef kernel_size, IntArrayRef output_size, const Tensor & random_samples) const override;
  std::tuple<Tensor,Tensor> fractional_max_pool3d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef output_size, const Tensor & random_samples) const override;
  Tensor fractional_max_pool3d_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef output_size, const Tensor & indices) const override;
  Tensor & fractional_max_pool3d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef output_size, const Tensor & indices) const override;
  std::tuple<Tensor &,Tensor &> fractional_max_pool3d_out(Tensor & output, Tensor & indices, const Tensor & self, IntArrayRef kernel_size, IntArrayRef output_size, const Tensor & random_samples) const override;
  Tensor frobenius_norm(const Tensor & self) const override;
  Tensor frobenius_norm(const Tensor & self, IntArrayRef dim, bool keepdim) const override;
  Tensor & frobenius_norm_out(Tensor & out, const Tensor & self, IntArrayRef dim, bool keepdim) const override;
  Tensor from_file(std::string filename, c10::optional<bool> shared, c10::optional<int64_t> size, const TensorOptions & options) const override;
  Tensor full(IntArrayRef size, Scalar fill_value, const TensorOptions & options) const override;
  Tensor full_like(const Tensor & self, Scalar fill_value) const override;
  Tensor full_like(const Tensor & self, Scalar fill_value, const TensorOptions & options) const override;
  Tensor & full_out(Tensor & out, IntArrayRef size, Scalar fill_value) const override;
  Tensor gather(const Tensor & self, int64_t dim, const Tensor & index, bool sparse_grad) const override;
  Tensor & gather_out(Tensor & out, const Tensor & self, int64_t dim, const Tensor & index, bool sparse_grad) const override;
  Tensor ge(const Tensor & self, Scalar other) const override;
  Tensor ge(const Tensor & self, const Tensor & other) const override;
  Tensor & ge_(Tensor & self, Scalar other) const override;
  Tensor & ge_(Tensor & self, const Tensor & other) const override;
  Tensor & ge_out(Tensor & out, const Tensor & self, Scalar other) const override;
  Tensor & ge_out(Tensor & out, const Tensor & self, const Tensor & other) const override;
  std::tuple<Tensor,Tensor> gels(const Tensor & self, const Tensor & A) const override;
  std::tuple<Tensor &,Tensor &> gels_out(Tensor & X, Tensor & qr, const Tensor & self, const Tensor & A) const override;
  Tensor & geometric_(Tensor & self, double p, Generator * generator) const override;
  std::tuple<Tensor,Tensor> geqrf(const Tensor & self) const override;
  std::tuple<Tensor &,Tensor &> geqrf_out(Tensor & a, Tensor & tau, const Tensor & self) const override;
  Tensor ger(const Tensor & self, const Tensor & vec2) const override;
  Tensor & ger_out(Tensor & out, const Tensor & self, const Tensor & vec2) const override;
  Tensor glu(const Tensor & self, int64_t dim) const override;
  Tensor glu_backward(const Tensor & grad_output, const Tensor & self, int64_t dim) const override;
  Tensor & glu_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, int64_t dim) const override;
  Tensor & glu_out(Tensor & out, const Tensor & self, int64_t dim) const override;
  Tensor grid_sampler(const Tensor & input, const Tensor & grid, int64_t interpolation_mode, int64_t padding_mode) const override;
  Tensor grid_sampler_2d(const Tensor & input, const Tensor & grid, int64_t interpolation_mode, int64_t padding_mode) const override;
  std::tuple<Tensor,Tensor> grid_sampler_2d_backward(const Tensor & grad_output, const Tensor & input, const Tensor & grid, int64_t interpolation_mode, int64_t padding_mode) const override;
  Tensor grid_sampler_3d(const Tensor & input, const Tensor & grid, int64_t interpolation_mode, int64_t padding_mode) const override;
  std::tuple<Tensor,Tensor> grid_sampler_3d_backward(const Tensor & grad_output, const Tensor & input, const Tensor & grid, int64_t interpolation_mode, int64_t padding_mode) const override;
  Tensor group_norm(const Tensor & input, int64_t num_groups, const Tensor & weight, const Tensor & bias, double eps, bool cudnn_enabled) const override;
  std::tuple<Tensor,Tensor> gru(const Tensor & input, const Tensor & hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional, bool batch_first) const override;
  std::tuple<Tensor,Tensor> gru(const Tensor & data, const Tensor & batch_sizes, const Tensor & hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional) const override;
  Tensor gru_cell(const Tensor & input, const Tensor & hx, const Tensor & w_ih, const Tensor & w_hh, const Tensor & b_ih, const Tensor & b_hh) const override;
  Tensor gt(const Tensor & self, Scalar other) const override;
  Tensor gt(const Tensor & self, const Tensor & other) const override;
  Tensor & gt_(Tensor & self, Scalar other) const override;
  Tensor & gt_(Tensor & self, const Tensor & other) const override;
  Tensor & gt_out(Tensor & out, const Tensor & self, Scalar other) const override;
  Tensor & gt_out(Tensor & out, const Tensor & self, const Tensor & other) const override;
  Tensor hamming_window(int64_t window_length, const TensorOptions & options) const override;
  Tensor hamming_window(int64_t window_length, bool periodic, const TensorOptions & options) const override;
  Tensor hamming_window(int64_t window_length, bool periodic, double alpha, const TensorOptions & options) const override;
  Tensor hamming_window(int64_t window_length, bool periodic, double alpha, double beta, const TensorOptions & options) const override;
  Tensor hann_window(int64_t window_length, const TensorOptions & options) const override;
  Tensor hann_window(int64_t window_length, bool periodic, const TensorOptions & options) const override;
  Tensor hardshrink(const Tensor & self, Scalar lambd) const override;
  Tensor hardshrink_backward(const Tensor & grad_out, const Tensor & self, Scalar lambd) const override;
  Tensor hardtanh(const Tensor & self, Scalar min_val, Scalar max_val) const override;
  Tensor & hardtanh_(Tensor & self, Scalar min_val, Scalar max_val) const override;
  Tensor hardtanh_backward(const Tensor & grad_output, const Tensor & self, Scalar min_val, Scalar max_val) const override;
  Tensor & hardtanh_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, Scalar min_val, Scalar max_val) const override;
  Tensor & hardtanh_out(Tensor & out, const Tensor & self, Scalar min_val, Scalar max_val) const override;
  Tensor hinge_embedding_loss(const Tensor & self, const Tensor & target, double margin, int64_t reduction) const override;
  Tensor histc(const Tensor & self, int64_t bins, Scalar min, Scalar max) const override;
  Tensor & histc_out(Tensor & out, const Tensor & self, int64_t bins, Scalar min, Scalar max) const override;
  Tensor hspmm(const Tensor & mat1, const Tensor & mat2) const override;
  Tensor & hspmm_out(Tensor & out, const Tensor & mat1, const Tensor & mat2) const override;
  Tensor ifft(const Tensor & self, int64_t signal_ndim, bool normalized) const override;
  Tensor index(const Tensor & self, TensorList indices) const override;
  Tensor index_add(const Tensor & self, int64_t dim, const Tensor & index, const Tensor & source) const override;
  Tensor & index_add_(Tensor & self, int64_t dim, const Tensor & index, const Tensor & source) const override;
  Tensor index_copy(const Tensor & self, int64_t dim, const Tensor & index, const Tensor & source) const override;
  Tensor & index_copy_(Tensor & self, int64_t dim, const Tensor & index, const Tensor & source) const override;
  Tensor index_fill(const Tensor & self, int64_t dim, const Tensor & index, Scalar value) const override;
  Tensor index_fill(const Tensor & self, int64_t dim, const Tensor & index, const Tensor & value) const override;
  Tensor & index_fill_(Tensor & self, int64_t dim, const Tensor & index, Scalar value) const override;
  Tensor & index_fill_(Tensor & self, int64_t dim, const Tensor & index, const Tensor & value) const override;
  Tensor index_put(const Tensor & self, TensorList indices, const Tensor & values, bool accumulate) const override;
  Tensor & index_put_(Tensor & self, TensorList indices, const Tensor & values, bool accumulate) const override;
  Tensor index_select(const Tensor & self, int64_t dim, const Tensor & index) const override;
  Tensor & index_select_out(Tensor & out, const Tensor & self, int64_t dim, const Tensor & index) const override;
  Tensor indices(const Tensor & self) const override;
  Tensor instance_norm(const Tensor & input, const Tensor & weight, const Tensor & bias, const Tensor & running_mean, const Tensor & running_var, bool use_input_stats, double momentum, double eps, bool cudnn_enabled) const override;
  Tensor int_repr(const Tensor & self) const override;
  Tensor inverse(const Tensor & self) const override;
  Tensor & inverse_out(Tensor & out, const Tensor & self) const override;
  Tensor irfft(const Tensor & self, int64_t signal_ndim, bool normalized, bool onesided, IntArrayRef signal_sizes) const override;
  bool is_coalesced(const Tensor & self) const override;
  bool is_complex(const Tensor & self) const override;
  bool is_distributed(const Tensor & self) const override;
  bool is_floating_point(const Tensor & self) const override;
  bool is_nonzero(const Tensor & self) const override;
  bool is_same_size(const Tensor & self, const Tensor & other) const override;
  bool is_set_to(const Tensor & self, const Tensor & tensor) const override;
  bool is_signed(const Tensor & self) const override;
  Tensor isclose(const Tensor & self, const Tensor & other, double rtol, double atol, bool equal_nan) const override;
  Tensor isnan(const Tensor & self) const override;
  Scalar item(const Tensor & self) const override;
  Tensor kl_div(const Tensor & self, const Tensor & target, int64_t reduction) const override;
  Tensor kl_div_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) const override;
  std::tuple<Tensor,Tensor> kthvalue(const Tensor & self, int64_t k, int64_t dim, bool keepdim) const override;
  std::tuple<Tensor &,Tensor &> kthvalue_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t k, int64_t dim, bool keepdim) const override;
  Tensor l1_loss(const Tensor & self, const Tensor & target, int64_t reduction) const override;
  Tensor l1_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) const override;
  Tensor & l1_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) const override;
  Tensor & l1_loss_out(Tensor & out, const Tensor & self, const Tensor & target, int64_t reduction) const override;
  Tensor layer_norm(const Tensor & input, IntArrayRef normalized_shape, const Tensor & weight, const Tensor & bias, double eps, bool cudnn_enable) const override;
  Tensor le(const Tensor & self, Scalar other) const override;
  Tensor le(const Tensor & self, const Tensor & other) const override;
  Tensor & le_(Tensor & self, Scalar other) const override;
  Tensor & le_(Tensor & self, const Tensor & other) const override;
  Tensor & le_out(Tensor & out, const Tensor & self, Scalar other) const override;
  Tensor & le_out(Tensor & out, const Tensor & self, const Tensor & other) const override;
  Tensor leaky_relu(const Tensor & self, Scalar negative_slope) const override;
  Tensor & leaky_relu_(Tensor & self, Scalar negative_slope) const override;
  Tensor leaky_relu_backward(const Tensor & grad_output, const Tensor & self, Scalar negative_slope) const override;
  Tensor & leaky_relu_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, Scalar negative_slope) const override;
  Tensor & leaky_relu_out(Tensor & out, const Tensor & self, Scalar negative_slope) const override;
  Tensor lerp(const Tensor & self, const Tensor & end, Scalar weight) const override;
  Tensor lerp(const Tensor & self, const Tensor & end, const Tensor & weight) const override;
  Tensor & lerp_(Tensor & self, const Tensor & end, Scalar weight) const override;
  Tensor & lerp_(Tensor & self, const Tensor & end, const Tensor & weight) const override;
  Tensor & lerp_out(Tensor & out, const Tensor & self, const Tensor & end, Scalar weight) const override;
  Tensor & lerp_out(Tensor & out, const Tensor & self, const Tensor & end, const Tensor & weight) const override;
  Tensor lgamma(const Tensor & self) const override;
  Tensor & lgamma_(Tensor & self) const override;
  Tensor & lgamma_out(Tensor & out, const Tensor & self) const override;
  Tensor linear(const Tensor & input, const Tensor & weight, const Tensor & bias) const override;
  Tensor linspace(Scalar start, Scalar end, int64_t steps, const TensorOptions & options) const override;
  Tensor & linspace_out(Tensor & out, Scalar start, Scalar end, int64_t steps) const override;
  Tensor log(const Tensor & self) const override;
  Tensor log10(const Tensor & self) const override;
  Tensor & log10_(Tensor & self) const override;
  Tensor & log10_out(Tensor & out, const Tensor & self) const override;
  Tensor log1p(const Tensor & self) const override;
  Tensor & log1p_(Tensor & self) const override;
  Tensor & log1p_out(Tensor & out, const Tensor & self) const override;
  Tensor log2(const Tensor & self) const override;
  Tensor & log2_(Tensor & self) const override;
  Tensor & log2_out(Tensor & out, const Tensor & self) const override;
  Tensor & log_(Tensor & self) const override;
  Tensor & log_normal_(Tensor & self, double mean, double std, Generator * generator) const override;
  Tensor & log_out(Tensor & out, const Tensor & self) const override;
  Tensor log_sigmoid(const Tensor & self) const override;
  Tensor log_sigmoid_backward(const Tensor & grad_output, const Tensor & self, const Tensor & buffer) const override;
  Tensor & log_sigmoid_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & buffer) const override;
  std::tuple<Tensor,Tensor> log_sigmoid_forward(const Tensor & self) const override;
  std::tuple<Tensor &,Tensor &> log_sigmoid_forward_out(Tensor & output, Tensor & buffer, const Tensor & self) const override;
  Tensor & log_sigmoid_out(Tensor & out, const Tensor & self) const override;
  Tensor log_softmax(const Tensor & self, int64_t dim, ScalarType dtype) const override;
  Tensor log_softmax(const Tensor & self, int64_t dim) const override;
  Tensor logdet(const Tensor & self) const override;
  Tensor logspace(Scalar start, Scalar end, int64_t steps, double base, const TensorOptions & options) const override;
  Tensor & logspace_out(Tensor & out, Scalar start, Scalar end, int64_t steps, double base) const override;
  Tensor logsumexp(const Tensor & self, IntArrayRef dim, bool keepdim) const override;
  Tensor & logsumexp_out(Tensor & out, const Tensor & self, IntArrayRef dim, bool keepdim) const override;
  std::tuple<Tensor,Tensor,Tensor> lstm(const Tensor & input, TensorList hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional, bool batch_first) const override;
  std::tuple<Tensor,Tensor,Tensor> lstm(const Tensor & data, const Tensor & batch_sizes, TensorList hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional) const override;
  std::tuple<Tensor,Tensor> lstm_cell(const Tensor & input, TensorList hx, const Tensor & w_ih, const Tensor & w_hh, const Tensor & b_ih, const Tensor & b_hh) const override;
  Tensor lt(const Tensor & self, Scalar other) const override;
  Tensor lt(const Tensor & self, const Tensor & other) const override;
  Tensor & lt_(Tensor & self, Scalar other) const override;
  Tensor & lt_(Tensor & self, const Tensor & other) const override;
  Tensor & lt_out(Tensor & out, const Tensor & self, Scalar other) const override;
  Tensor & lt_out(Tensor & out, const Tensor & self, const Tensor & other) const override;
  Tensor lu_solve(const Tensor & self, const Tensor & LU_data, const Tensor & LU_pivots) const override;
  Tensor & lu_solve_out(Tensor & out, const Tensor & self, const Tensor & LU_data, const Tensor & LU_pivots) const override;
  Tensor margin_ranking_loss(const Tensor & input1, const Tensor & input2, const Tensor & target, double margin, int64_t reduction) const override;
  Tensor masked_fill(const Tensor & self, const Tensor & mask, Scalar value) const override;
  Tensor masked_fill(const Tensor & self, const Tensor & mask, const Tensor & value) const override;
  Tensor & masked_fill_(Tensor & self, const Tensor & mask, Scalar value) const override;
  Tensor & masked_fill_(Tensor & self, const Tensor & mask, const Tensor & value) const override;
  Tensor masked_scatter(const Tensor & self, const Tensor & mask, const Tensor & source) const override;
  Tensor & masked_scatter_(Tensor & self, const Tensor & mask, const Tensor & source) const override;
  Tensor masked_select(const Tensor & self, const Tensor & mask) const override;
  Tensor & masked_select_out(Tensor & out, const Tensor & self, const Tensor & mask) const override;
  Tensor matmul(const Tensor & self, const Tensor & other) const override;
  Tensor & matmul_out(Tensor & out, const Tensor & self, const Tensor & other) const override;
  Tensor matrix_power(const Tensor & self, int64_t n) const override;
  Tensor matrix_rank(const Tensor & self, double tol, bool symmetric) const override;
  Tensor matrix_rank(const Tensor & self, bool symmetric) const override;
  std::tuple<Tensor,Tensor> max(const Tensor & self, int64_t dim, bool keepdim) const override;
  Tensor max(const Tensor & self, const Tensor & other) const override;
  Tensor max(const Tensor & self) const override;
  std::tuple<Tensor &,Tensor &> max_out(Tensor & max, Tensor & max_values, const Tensor & self, int64_t dim, bool keepdim) const override;
  Tensor & max_out(Tensor & out, const Tensor & self, const Tensor & other) const override;
  Tensor max_pool1d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode) const override;
  std::tuple<Tensor,Tensor> max_pool1d_with_indices(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode) const override;
  Tensor max_pool2d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode) const override;
  std::tuple<Tensor,Tensor> max_pool2d_with_indices(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode) const override;
  Tensor max_pool2d_with_indices_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode, const Tensor & indices) const override;
  Tensor & max_pool2d_with_indices_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode, const Tensor & indices) const override;
  std::tuple<Tensor &,Tensor &> max_pool2d_with_indices_out(Tensor & output, Tensor & indices, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode) const override;
  Tensor max_pool3d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode) const override;
  std::tuple<Tensor,Tensor> max_pool3d_with_indices(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode) const override;
  Tensor max_pool3d_with_indices_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode, const Tensor & indices) const override;
  Tensor & max_pool3d_with_indices_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode, const Tensor & indices) const override;
  std::tuple<Tensor &,Tensor &> max_pool3d_with_indices_out(Tensor & output, Tensor & indices, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode) const override;
  Tensor max_unpool2d(const Tensor & self, const Tensor & indices, IntArrayRef output_size) const override;
  Tensor max_unpool2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & indices, IntArrayRef output_size) const override;
  Tensor & max_unpool2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & indices, IntArrayRef output_size) const override;
  Tensor & max_unpool2d_out(Tensor & out, const Tensor & self, const Tensor & indices, IntArrayRef output_size) const override;
  Tensor max_unpool3d(const Tensor & self, const Tensor & indices, IntArrayRef output_size, IntArrayRef stride, IntArrayRef padding) const override;
  Tensor max_unpool3d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & indices, IntArrayRef output_size, IntArrayRef stride, IntArrayRef padding) const override;
  Tensor & max_unpool3d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & indices, IntArrayRef output_size, IntArrayRef stride, IntArrayRef padding) const override;
  Tensor & max_unpool3d_out(Tensor & out, const Tensor & self, const Tensor & indices, IntArrayRef output_size, IntArrayRef stride, IntArrayRef padding) const override;
  Tensor max_values(const Tensor & self, IntArrayRef dim, bool keepdim) const override;
  Tensor mean(const Tensor & self, ScalarType dtype) const override;
  Tensor mean(const Tensor & self) const override;
  Tensor mean(const Tensor & self, IntArrayRef dim, bool keepdim, ScalarType dtype) const override;
  Tensor mean(const Tensor & self, IntArrayRef dim, bool keepdim) const override;
  Tensor mean(const Tensor & self, IntArrayRef dim, ScalarType dtype) const override;
  Tensor & mean_out(Tensor & out, const Tensor & self, IntArrayRef dim, bool keepdim, ScalarType dtype) const override;
  Tensor & mean_out(Tensor & out, const Tensor & self, IntArrayRef dim, bool keepdim) const override;
  Tensor & mean_out(Tensor & out, const Tensor & self, IntArrayRef dim, ScalarType dtype) const override;
  std::tuple<Tensor,Tensor> median(const Tensor & self, int64_t dim, bool keepdim) const override;
  Tensor median(const Tensor & self) const override;
  std::tuple<Tensor &,Tensor &> median_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t dim, bool keepdim) const override;
  std::vector<Tensor> meshgrid(TensorList tensors) const override;
  std::tuple<Tensor,Tensor> min(const Tensor & self, int64_t dim, bool keepdim) const override;
  Tensor min(const Tensor & self, const Tensor & other) const override;
  Tensor min(const Tensor & self) const override;
  std::tuple<Tensor &,Tensor &> min_out(Tensor & min, Tensor & min_indices, const Tensor & self, int64_t dim, bool keepdim) const override;
  Tensor & min_out(Tensor & out, const Tensor & self, const Tensor & other) const override;
  Tensor min_values(const Tensor & self, IntArrayRef dim, bool keepdim) const override;
  std::tuple<Tensor,Tensor,Tensor> miopen_batch_norm(const Tensor & input, const Tensor & weight, const Tensor & bias, const Tensor & running_mean, const Tensor & running_var, bool training, double exponential_average_factor, double epsilon) const override;
  std::tuple<Tensor,Tensor,Tensor> miopen_batch_norm_backward(const Tensor & input, const Tensor & grad_output, const Tensor & weight, const Tensor & running_mean, const Tensor & running_var, const Tensor & save_mean, const Tensor & save_var, double epsilon) const override;
  Tensor miopen_convolution(const Tensor & self, const Tensor & weight, const Tensor & bias, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic) const override;
  std::tuple<Tensor,Tensor,Tensor> miopen_convolution_backward(const Tensor & self, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic, std::array<bool,3> output_mask) const override;
  Tensor miopen_convolution_backward_bias(const Tensor & grad_output) const override;
  Tensor miopen_convolution_backward_input(IntArrayRef self_size, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic) const override;
  Tensor miopen_convolution_backward_weight(IntArrayRef weight_size, const Tensor & grad_output, const Tensor & self, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic) const override;
  Tensor miopen_convolution_transpose(const Tensor & self, const Tensor & weight, const Tensor & bias, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic) const override;
  std::tuple<Tensor,Tensor,Tensor> miopen_convolution_transpose_backward(const Tensor & self, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic, std::array<bool,3> output_mask) const override;
  Tensor miopen_convolution_transpose_backward_input(const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic) const override;
  Tensor miopen_convolution_transpose_backward_weight(IntArrayRef weight_size, const Tensor & grad_output, const Tensor & self, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic) const override;
  Tensor miopen_depthwise_convolution(const Tensor & self, const Tensor & weight, const Tensor & bias, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic) const override;
  std::tuple<Tensor,Tensor,Tensor> miopen_depthwise_convolution_backward(const Tensor & self, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic, std::array<bool,3> output_mask) const override;
  Tensor miopen_depthwise_convolution_backward_input(IntArrayRef self_size, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic) const override;
  Tensor miopen_depthwise_convolution_backward_weight(IntArrayRef weight_size, const Tensor & grad_output, const Tensor & self, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic) const override;
  Tensor mkldnn_convolution(const Tensor & self, const Tensor & weight, const Tensor & bias, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups) const override;
  std::tuple<Tensor,Tensor,Tensor> mkldnn_convolution_backward(const Tensor & self, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, std::array<bool,3> output_mask) const override;
  Tensor mkldnn_convolution_backward_input(IntArrayRef self_size, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool bias_defined) const override;
  std::tuple<Tensor,Tensor> mkldnn_convolution_backward_weights(IntArrayRef weight_size, const Tensor & grad_output, const Tensor & self, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool bias_defined) const override;
  Tensor mkldnn_linear(const Tensor & input, const Tensor & weight, const Tensor & bias) const override;
  Tensor mkldnn_max_pool2d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode) const override;
  Tensor mkldnn_reorder_conv2d_weight(const Tensor & self, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups) const override;
  Tensor mkldnn_reshape(const Tensor & self, IntArrayRef shape) const override;
  Tensor mm(const Tensor & self, const Tensor & mat2) const override;
  Tensor & mm_out(Tensor & out, const Tensor & self, const Tensor & mat2) const override;
  std::tuple<Tensor,Tensor> mode(const Tensor & self, int64_t dim, bool keepdim) const override;
  std::tuple<Tensor &,Tensor &> mode_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t dim, bool keepdim) const override;
  Tensor mse_loss(const Tensor & self, const Tensor & target, int64_t reduction) const override;
  Tensor mse_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) const override;
  Tensor & mse_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) const override;
  Tensor & mse_loss_out(Tensor & out, const Tensor & self, const Tensor & target, int64_t reduction) const override;
  Tensor mul(const Tensor & self, const Tensor & other) const override;
  Tensor mul(const Tensor & self, Scalar other) const override;
  Tensor & mul_(Tensor & self, const Tensor & other) const override;
  Tensor & mul_(Tensor & self, Scalar other) const override;
  Tensor & mul_out(Tensor & out, const Tensor & self, const Tensor & other) const override;
  Tensor multi_margin_loss(const Tensor & self, const Tensor & target, Scalar p, Scalar margin, const Tensor & weight, int64_t reduction) const override;
  Tensor multi_margin_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, Scalar p, Scalar margin, const Tensor & weight, int64_t reduction) const override;
  Tensor & multi_margin_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, Scalar p, Scalar margin, const Tensor & weight, int64_t reduction) const override;
  Tensor & multi_margin_loss_out(Tensor & out, const Tensor & self, const Tensor & target, Scalar p, Scalar margin, const Tensor & weight, int64_t reduction) const override;
  Tensor multilabel_margin_loss(const Tensor & self, const Tensor & target, int64_t reduction) const override;
  Tensor multilabel_margin_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction, const Tensor & is_target) const override;
  Tensor & multilabel_margin_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction, const Tensor & is_target) const override;
  std::tuple<Tensor,Tensor> multilabel_margin_loss_forward(const Tensor & self, const Tensor & target, int64_t reduction) const override;
  std::tuple<Tensor &,Tensor &> multilabel_margin_loss_forward_out(Tensor & output, Tensor & is_target, const Tensor & self, const Tensor & target, int64_t reduction) const override;
  Tensor & multilabel_margin_loss_out(Tensor & out, const Tensor & self, const Tensor & target, int64_t reduction) const override;
  Tensor multinomial(const Tensor & self, int64_t num_samples, bool replacement, Generator * generator) const override;
  Tensor & multinomial_out(Tensor & out, const Tensor & self, int64_t num_samples, bool replacement, Generator * generator) const override;
  Tensor mv(const Tensor & self, const Tensor & vec) const override;
  Tensor & mv_out(Tensor & out, const Tensor & self, const Tensor & vec) const override;
  Tensor mvlgamma(const Tensor & self, int64_t p) const override;
  Tensor & mvlgamma_(Tensor & self, int64_t p) const override;
  Tensor narrow(const Tensor & self, int64_t dim, int64_t start, int64_t length) const override;
  Tensor narrow_copy(const Tensor & self, int64_t dim, int64_t start, int64_t length) const override;
  std::tuple<Tensor,Tensor,Tensor> native_batch_norm(const Tensor & input, const Tensor & weight, const Tensor & bias, const Tensor & running_mean, const Tensor & running_var, bool training, double momentum, double eps) const override;
  std::tuple<Tensor,Tensor,Tensor> native_batch_norm_backward(const Tensor & grad_out, const Tensor & input, const Tensor & weight, const Tensor & running_mean, const Tensor & running_var, const Tensor & save_mean, const Tensor & save_invstd, bool train, double eps, std::array<bool,3> output_mask) const override;
  Tensor native_norm(const Tensor & self, Scalar p) const override;
  Tensor ne(const Tensor & self, Scalar other) const override;
  Tensor ne(const Tensor & self, const Tensor & other) const override;
  Tensor & ne_(Tensor & self, Scalar other) const override;
  Tensor & ne_(Tensor & self, const Tensor & other) const override;
  Tensor & ne_out(Tensor & out, const Tensor & self, Scalar other) const override;
  Tensor & ne_out(Tensor & out, const Tensor & self, const Tensor & other) const override;
  Tensor neg(const Tensor & self) const override;
  Tensor & neg_(Tensor & self) const override;
  Tensor & neg_out(Tensor & out, const Tensor & self) const override;
  Tensor nll_loss(const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index) const override;
  Tensor nll_loss2d(const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index) const override;
  Tensor nll_loss2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index, const Tensor & total_weight) const override;
  Tensor & nll_loss2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index, const Tensor & total_weight) const override;
  std::tuple<Tensor,Tensor> nll_loss2d_forward(const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index) const override;
  std::tuple<Tensor &,Tensor &> nll_loss2d_forward_out(Tensor & output, Tensor & total_weight, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index) const override;
  Tensor & nll_loss2d_out(Tensor & out, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index) const override;
  Tensor nll_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index, const Tensor & total_weight) const override;
  Tensor & nll_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index, const Tensor & total_weight) const override;
  std::tuple<Tensor,Tensor> nll_loss_forward(const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index) const override;
  std::tuple<Tensor &,Tensor &> nll_loss_forward_out(Tensor & output, Tensor & total_weight, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index) const override;
  Tensor & nll_loss_out(Tensor & out, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index) const override;
  Tensor nonzero(const Tensor & self) const override;
  Tensor & nonzero_out(Tensor & out, const Tensor & self) const override;
  Tensor norm(const Tensor & self, c10::optional<Scalar> p, ScalarType dtype) const override;
  Tensor norm(const Tensor & self, Scalar p) const override;
  Tensor norm(const Tensor & self, c10::optional<Scalar> p, IntArrayRef dim, bool keepdim, ScalarType dtype) const override;
  Tensor norm(const Tensor & self, c10::optional<Scalar> p, IntArrayRef dim, bool keepdim) const override;
  Tensor norm_except_dim(const Tensor & v, int64_t pow, int64_t dim) const override;
  Tensor & norm_out(Tensor & out, const Tensor & self, c10::optional<Scalar> p, IntArrayRef dim, bool keepdim, ScalarType dtype) const override;
  Tensor & norm_out(Tensor & out, const Tensor & self, c10::optional<Scalar> p, IntArrayRef dim, bool keepdim) const override;
  Tensor normal(const Tensor & mean, double std, Generator * generator) const override;
  Tensor normal(double mean, const Tensor & std, Generator * generator) const override;
  Tensor normal(const Tensor & mean, const Tensor & std, Generator * generator) const override;
  Tensor & normal_(Tensor & self, double mean, double std, Generator * generator) const override;
  Tensor & normal_out(Tensor & out, const Tensor & mean, double std, Generator * generator) const override;
  Tensor & normal_out(Tensor & out, double mean, const Tensor & std, Generator * generator) const override;
  Tensor & normal_out(Tensor & out, const Tensor & mean, const Tensor & std, Generator * generator) const override;
  Tensor nuclear_norm(const Tensor & self, bool keepdim) const override;
  Tensor & nuclear_norm_out(Tensor & out, const Tensor & self, bool keepdim) const override;
  int64_t numel(const Tensor & self) const override;
  Tensor one_hot(const Tensor & self, int64_t num_classes) const override;
  Tensor ones(IntArrayRef size, const TensorOptions & options) const override;
  Tensor ones_like(const Tensor & self) const override;
  Tensor ones_like(const Tensor & self, const TensorOptions & options) const override;
  Tensor & ones_out(Tensor & out, IntArrayRef size) const override;
  Tensor orgqr(const Tensor & self, const Tensor & input2) const override;
  Tensor & orgqr_out(Tensor & out, const Tensor & self, const Tensor & input2) const override;
  Tensor ormqr(const Tensor & self, const Tensor & input2, const Tensor & input3, bool left, bool transpose) const override;
  Tensor & ormqr_out(Tensor & out, const Tensor & self, const Tensor & input2, const Tensor & input3, bool left, bool transpose) const override;
  Tensor pairwise_distance(const Tensor & x1, const Tensor & x2, double p, double eps, bool keepdim) const override;
  Tensor pdist(const Tensor & self, double p) const override;
  Tensor permute(const Tensor & self, IntArrayRef dims) const override;
  Tensor pin_memory(const Tensor & self) const override;
  Tensor pinverse(const Tensor & self, double rcond) const override;
  Tensor pixel_shuffle(const Tensor & self, int64_t upscale_factor) const override;
  Tensor poisson(const Tensor & self, Generator * generator) const override;
  Tensor polygamma(int64_t n, const Tensor & self) const override;
  Tensor & polygamma_(Tensor & self, int64_t n) const override;
  Tensor & polygamma_out(Tensor & out, int64_t n, const Tensor & self) const override;
  Tensor pow(const Tensor & self, Scalar exponent) const override;
  Tensor pow(const Tensor & self, const Tensor & exponent) const override;
  Tensor pow(Scalar self, const Tensor & exponent) const override;
  Tensor & pow_(Tensor & self, Scalar exponent) const override;
  Tensor & pow_(Tensor & self, const Tensor & exponent) const override;
  Tensor & pow_out(Tensor & out, const Tensor & self, Scalar exponent) const override;
  Tensor & pow_out(Tensor & out, const Tensor & self, const Tensor & exponent) const override;
  Tensor & pow_out(Tensor & out, Scalar self, const Tensor & exponent) const override;
  Tensor prelu(const Tensor & self, const Tensor & weight) const override;
  std::tuple<Tensor,Tensor> prelu_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight) const override;
  Tensor prod(const Tensor & self, ScalarType dtype) const override;
  Tensor prod(const Tensor & self) const override;
  Tensor prod(const Tensor & self, int64_t dim, bool keepdim, ScalarType dtype) const override;
  Tensor prod(const Tensor & self, int64_t dim, bool keepdim) const override;
  Tensor prod(const Tensor & self, int64_t dim, ScalarType dtype) const override;
  Tensor & prod_out(Tensor & out, const Tensor & self, int64_t dim, bool keepdim, ScalarType dtype) const override;
  Tensor & prod_out(Tensor & out, const Tensor & self, int64_t dim, bool keepdim) const override;
  Tensor & prod_out(Tensor & out, const Tensor & self, int64_t dim, ScalarType dtype) const override;
  std::tuple<Tensor,Tensor> pstrf(const Tensor & self, bool upper, Scalar tol) const override;
  std::tuple<Tensor &,Tensor &> pstrf_out(Tensor & u, Tensor & pivot, const Tensor & self, bool upper, Scalar tol) const override;
  Tensor & put_(Tensor & self, const Tensor & index, const Tensor & source, bool accumulate) const override;
  Scalar q_scale(const Tensor & self) const override;
  Scalar q_zero_point(const Tensor & self) const override;
  std::tuple<Tensor,Tensor> qr(const Tensor & self) const override;
  std::tuple<Tensor &,Tensor &> qr_out(Tensor & Q, Tensor & R, const Tensor & self) const override;
  Tensor quantize_linear(const Tensor & self, double scale, int64_t zero_point) const override;
  Tensor quantized_gru_cell(const Tensor & input, const Tensor & hx, const Tensor & w_ih, const Tensor & w_hh, const Tensor & b_ih, const Tensor & b_hh, const Tensor & packed_ih, const Tensor & packed_hh, const Tensor & col_offsets_ih, const Tensor & col_offsets_hh, Scalar scale_ih, Scalar scale_hh, Scalar zero_point_ih, Scalar zero_point_hh) const override;
  std::tuple<Tensor,Tensor,Tensor> quantized_lstm(const Tensor & input, TensorList hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional, bool batch_first) const override;
  std::tuple<Tensor,Tensor> quantized_lstm_cell(const Tensor & input, TensorList hx, const Tensor & w_ih, const Tensor & w_hh, const Tensor & b_ih, const Tensor & b_hh, const Tensor & packed_ih, const Tensor & packed_hh, const Tensor & col_offsets_ih, const Tensor & col_offsets_hh, Scalar scale_ih, Scalar scale_hh, Scalar zero_point_ih, Scalar zero_point_hh) const override;
  Tensor quantized_rnn_relu_cell(const Tensor & input, const Tensor & hx, const Tensor & w_ih, const Tensor & w_hh, const Tensor & b_ih, const Tensor & b_hh, const Tensor & packed_ih, const Tensor & packed_hh, const Tensor & col_offsets_ih, const Tensor & col_offsets_hh, Scalar scale_ih, Scalar scale_hh, Scalar zero_point_ih, Scalar zero_point_hh) const override;
  Tensor quantized_rnn_tanh_cell(const Tensor & input, const Tensor & hx, const Tensor & w_ih, const Tensor & w_hh, const Tensor & b_ih, const Tensor & b_hh, const Tensor & packed_ih, const Tensor & packed_hh, const Tensor & col_offsets_ih, const Tensor & col_offsets_hh, Scalar scale_ih, Scalar scale_hh, Scalar zero_point_ih, Scalar zero_point_hh) const override;
  Tensor rand(IntArrayRef size, const TensorOptions & options) const override;
  Tensor rand(IntArrayRef size, Generator * generator, const TensorOptions & options) const override;
  Tensor rand_like(const Tensor & self) const override;
  Tensor rand_like(const Tensor & self, const TensorOptions & options) const override;
  Tensor & rand_out(Tensor & out, IntArrayRef size) const override;
  Tensor & rand_out(Tensor & out, IntArrayRef size, Generator * generator) const override;
  Tensor randint(int64_t high, IntArrayRef size, const TensorOptions & options) const override;
  Tensor randint(int64_t high, IntArrayRef size, Generator * generator, const TensorOptions & options) const override;
  Tensor randint(int64_t low, int64_t high, IntArrayRef size, const TensorOptions & options) const override;
  Tensor randint(int64_t low, int64_t high, IntArrayRef size, Generator * generator, const TensorOptions & options) const override;
  Tensor randint_like(const Tensor & self, int64_t high) const override;
  Tensor randint_like(const Tensor & self, int64_t low, int64_t high) const override;
  Tensor randint_like(const Tensor & self, int64_t high, const TensorOptions & options) const override;
  Tensor randint_like(const Tensor & self, int64_t low, int64_t high, const TensorOptions & options) const override;
  Tensor & randint_out(Tensor & out, int64_t high, IntArrayRef size) const override;
  Tensor & randint_out(Tensor & out, int64_t high, IntArrayRef size, Generator * generator) const override;
  Tensor & randint_out(Tensor & out, int64_t low, int64_t high, IntArrayRef size) const override;
  Tensor & randint_out(Tensor & out, int64_t low, int64_t high, IntArrayRef size, Generator * generator) const override;
  Tensor randn(IntArrayRef size, const TensorOptions & options) const override;
  Tensor randn(IntArrayRef size, Generator * generator, const TensorOptions & options) const override;
  Tensor randn_like(const Tensor & self) const override;
  Tensor randn_like(const Tensor & self, const TensorOptions & options) const override;
  Tensor & randn_out(Tensor & out, IntArrayRef size) const override;
  Tensor & randn_out(Tensor & out, IntArrayRef size, Generator * generator) const override;
  Tensor & random_(Tensor & self, int64_t from, int64_t to, Generator * generator) const override;
  Tensor & random_(Tensor & self, int64_t to, Generator * generator) const override;
  Tensor & random_(Tensor & self, Generator * generator) const override;
  Tensor randperm(int64_t n, const TensorOptions & options) const override;
  Tensor randperm(int64_t n, Generator * generator, const TensorOptions & options) const override;
  Tensor & randperm_out(Tensor & out, int64_t n) const override;
  Tensor & randperm_out(Tensor & out, int64_t n, Generator * generator) const override;
  Tensor range(Scalar start, Scalar end, Scalar step, const TensorOptions & options) const override;
  Tensor range(Scalar start, Scalar end, const TensorOptions & options) const override;
  Tensor & range_out(Tensor & out, Scalar start, Scalar end, Scalar step) const override;
  Tensor reciprocal(const Tensor & self) const override;
  Tensor & reciprocal_(Tensor & self) const override;
  Tensor & reciprocal_out(Tensor & out, const Tensor & self) const override;
  Tensor reflection_pad1d(const Tensor & self, IntArrayRef padding) const override;
  Tensor reflection_pad1d_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef padding) const override;
  Tensor & reflection_pad1d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef padding) const override;
  Tensor & reflection_pad1d_out(Tensor & out, const Tensor & self, IntArrayRef padding) const override;
  Tensor reflection_pad2d(const Tensor & self, IntArrayRef padding) const override;
  Tensor reflection_pad2d_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef padding) const override;
  Tensor & reflection_pad2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef padding) const override;
  Tensor & reflection_pad2d_out(Tensor & out, const Tensor & self, IntArrayRef padding) const override;
  Tensor relu(const Tensor & self) const override;
  Tensor & relu_(Tensor & self) const override;
  Tensor remainder(const Tensor & self, Scalar other) const override;
  Tensor remainder(const Tensor & self, const Tensor & other) const override;
  Tensor & remainder_(Tensor & self, Scalar other) const override;
  Tensor & remainder_(Tensor & self, const Tensor & other) const override;
  Tensor & remainder_out(Tensor & out, const Tensor & self, Scalar other) const override;
  Tensor & remainder_out(Tensor & out, const Tensor & self, const Tensor & other) const override;
  Tensor renorm(const Tensor & self, Scalar p, int64_t dim, Scalar maxnorm) const override;
  Tensor & renorm_(Tensor & self, Scalar p, int64_t dim, Scalar maxnorm) const override;
  Tensor & renorm_out(Tensor & out, const Tensor & self, Scalar p, int64_t dim, Scalar maxnorm) const override;
  Tensor repeat(const Tensor & self, IntArrayRef repeats) const override;
  Tensor repeat_interleave(const Tensor & repeats) const override;
  Tensor repeat_interleave(const Tensor & self, const Tensor & repeats, c10::optional<int64_t> dim) const override;
  Tensor repeat_interleave(const Tensor & self, int64_t repeats, c10::optional<int64_t> dim) const override;
  Tensor replication_pad1d(const Tensor & self, IntArrayRef padding) const override;
  Tensor replication_pad1d_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef padding) const override;
  Tensor & replication_pad1d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef padding) const override;
  Tensor & replication_pad1d_out(Tensor & out, const Tensor & self, IntArrayRef padding) const override;
  Tensor replication_pad2d(const Tensor & self, IntArrayRef padding) const override;
  Tensor replication_pad2d_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef padding) const override;
  Tensor & replication_pad2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef padding) const override;
  Tensor & replication_pad2d_out(Tensor & out, const Tensor & self, IntArrayRef padding) const override;
  Tensor replication_pad3d(const Tensor & self, IntArrayRef padding) const override;
  Tensor replication_pad3d_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef padding) const override;
  Tensor & replication_pad3d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef padding) const override;
  Tensor & replication_pad3d_out(Tensor & out, const Tensor & self, IntArrayRef padding) const override;
  Tensor reshape(const Tensor & self, IntArrayRef shape) const override;
  Tensor reshape_as(const Tensor & self, const Tensor & other) const override;
  Tensor & resize_(Tensor & self, IntArrayRef size) const override;
  Tensor & resize_as_(Tensor & self, const Tensor & the_template) const override;
  Tensor rfft(const Tensor & self, int64_t signal_ndim, bool normalized, bool onesided) const override;
  std::tuple<Tensor,Tensor> rnn_relu(const Tensor & input, const Tensor & hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional, bool batch_first) const override;
  std::tuple<Tensor,Tensor> rnn_relu(const Tensor & data, const Tensor & batch_sizes, const Tensor & hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional) const override;
  Tensor rnn_relu_cell(const Tensor & input, const Tensor & hx, const Tensor & w_ih, const Tensor & w_hh, const Tensor & b_ih, const Tensor & b_hh) const override;
  std::tuple<Tensor,Tensor> rnn_tanh(const Tensor & input, const Tensor & hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional, bool batch_first) const override;
  std::tuple<Tensor,Tensor> rnn_tanh(const Tensor & data, const Tensor & batch_sizes, const Tensor & hx, TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional) const override;
  Tensor rnn_tanh_cell(const Tensor & input, const Tensor & hx, const Tensor & w_ih, const Tensor & w_hh, const Tensor & b_ih, const Tensor & b_hh) const override;
  Tensor roll(const Tensor & self, IntArrayRef shifts, IntArrayRef dims) const override;
  Tensor rot90(const Tensor & self, int64_t k, IntArrayRef dims) const override;
  Tensor round(const Tensor & self) const override;
  Tensor & round_(Tensor & self) const override;
  Tensor & round_out(Tensor & out, const Tensor & self) const override;
  Tensor rrelu(const Tensor & self, Scalar lower, Scalar upper, bool training, Generator * generator) const override;
  Tensor & rrelu_(Tensor & self, Scalar lower, Scalar upper, bool training, Generator * generator) const override;
  Tensor rrelu_with_noise(const Tensor & self, const Tensor & noise, Scalar lower, Scalar upper, bool training, Generator * generator) const override;
  Tensor & rrelu_with_noise_(Tensor & self, const Tensor & noise, Scalar lower, Scalar upper, bool training, Generator * generator) const override;
  Tensor rrelu_with_noise_backward(const Tensor & grad_output, const Tensor & self, const Tensor & noise, Scalar lower, Scalar upper, bool training) const override;
  Tensor & rrelu_with_noise_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & noise, Scalar lower, Scalar upper, bool training) const override;
  Tensor & rrelu_with_noise_out(Tensor & out, const Tensor & self, const Tensor & noise, Scalar lower, Scalar upper, bool training, Generator * generator) const override;
  Tensor rsqrt(const Tensor & self) const override;
  Tensor & rsqrt_(Tensor & self) const override;
  Tensor & rsqrt_out(Tensor & out, const Tensor & self) const override;
  Tensor rsub(const Tensor & self, const Tensor & other, Scalar alpha) const override;
  Tensor rsub(const Tensor & self, Scalar other, Scalar alpha) const override;
  Tensor & s_copy_(Tensor & self, const Tensor & src, bool non_blocking) const override;
  Tensor s_native_addmm(const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta, Scalar alpha) const override;
  Tensor & s_native_addmm_(Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta, Scalar alpha) const override;
  Tensor & s_native_addmm_out(Tensor & out, const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta, Scalar alpha) const override;
  Tensor scalar_tensor(Scalar s, const TensorOptions & options) const override;
  Tensor scatter(const Tensor & self, int64_t dim, const Tensor & index, const Tensor & src) const override;
  Tensor scatter(const Tensor & self, int64_t dim, const Tensor & index, Scalar value) const override;
  Tensor & scatter_(Tensor & self, int64_t dim, const Tensor & index, const Tensor & src) const override;
  Tensor & scatter_(Tensor & self, int64_t dim, const Tensor & index, Scalar value) const override;
  Tensor scatter_add(const Tensor & self, int64_t dim, const Tensor & index, const Tensor & src) const override;
  Tensor & scatter_add_(Tensor & self, int64_t dim, const Tensor & index, const Tensor & src) const override;
  Tensor select(const Tensor & self, int64_t dim, int64_t index) const override;
  Tensor selu(const Tensor & self) const override;
  Tensor & selu_(Tensor & self) const override;
  Tensor & set_(Tensor & self, Storage source) const override;
  Tensor & set_(Tensor & self, Storage source, int64_t storage_offset, IntArrayRef size, IntArrayRef stride) const override;
  Tensor & set_(Tensor & self, const Tensor & source) const override;
  Tensor & set_(Tensor & self) const override;
  Tensor sigmoid(const Tensor & self) const override;
  Tensor & sigmoid_(Tensor & self) const override;
  Tensor sigmoid_backward(const Tensor & grad_output, const Tensor & output) const override;
  Tensor & sigmoid_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & output) const override;
  Tensor & sigmoid_out(Tensor & out, const Tensor & self) const override;
  Tensor sign(const Tensor & self) const override;
  Tensor & sign_(Tensor & self) const override;
  Tensor & sign_out(Tensor & out, const Tensor & self) const override;
  Tensor sin(const Tensor & self) const override;
  Tensor & sin_(Tensor & self) const override;
  Tensor & sin_out(Tensor & out, const Tensor & self) const override;
  Tensor sinh(const Tensor & self) const override;
  Tensor & sinh_(Tensor & self) const override;
  Tensor & sinh_out(Tensor & out, const Tensor & self) const override;
  int64_t size(const Tensor & self, int64_t dim) const override;
  Tensor slice(const Tensor & self, int64_t dim, int64_t start, int64_t end, int64_t step) const override;
  std::tuple<Tensor,Tensor> slogdet(const Tensor & self) const override;
  Tensor smm(const Tensor & self, const Tensor & mat2) const override;
  Tensor smooth_l1_loss(const Tensor & self, const Tensor & target, int64_t reduction) const override;
  Tensor smooth_l1_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) const override;
  Tensor & smooth_l1_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) const override;
  Tensor & smooth_l1_loss_out(Tensor & out, const Tensor & self, const Tensor & target, int64_t reduction) const override;
  Tensor soft_margin_loss(const Tensor & self, const Tensor & target, int64_t reduction) const override;
  Tensor soft_margin_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) const override;
  Tensor & soft_margin_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) const override;
  Tensor & soft_margin_loss_out(Tensor & out, const Tensor & self, const Tensor & target, int64_t reduction) const override;
  Tensor softmax(const Tensor & self, int64_t dim, ScalarType dtype) const override;
  Tensor softmax(const Tensor & self, int64_t dim) const override;
  Tensor softplus(const Tensor & self, Scalar beta, Scalar threshold) const override;
  Tensor softplus_backward(const Tensor & grad_output, const Tensor & self, Scalar beta, Scalar threshold, const Tensor & output) const override;
  Tensor & softplus_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, Scalar beta, Scalar threshold, const Tensor & output) const override;
  Tensor & softplus_out(Tensor & out, const Tensor & self, Scalar beta, Scalar threshold) const override;
  Tensor softshrink(const Tensor & self, Scalar lambd) const override;
  Tensor softshrink_backward(const Tensor & grad_output, const Tensor & self, Scalar lambd) const override;
  Tensor & softshrink_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, Scalar lambd) const override;
  Tensor & softshrink_out(Tensor & out, const Tensor & self, Scalar lambd) const override;
  std::tuple<Tensor,Tensor> solve(const Tensor & self, const Tensor & A) const override;
  std::tuple<Tensor &,Tensor &> solve_out(Tensor & solution, Tensor & lu, const Tensor & self, const Tensor & A) const override;
  std::tuple<Tensor,Tensor> sort(const Tensor & self, int64_t dim, bool descending) const override;
  std::tuple<Tensor &,Tensor &> sort_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t dim, bool descending) const override;
  Tensor sparse_coo_tensor(IntArrayRef size, const TensorOptions & options) const override;
  Tensor sparse_coo_tensor(const Tensor & indices, const Tensor & values, const TensorOptions & options) const override;
  Tensor sparse_coo_tensor(const Tensor & indices, const Tensor & values, IntArrayRef size, const TensorOptions & options) const override;
  int64_t sparse_dim(const Tensor & self) const override;
  Tensor sparse_mask(const Tensor & self, SparseTensorRef mask) const override;
  Tensor & sparse_resize_(Tensor & self, IntArrayRef size, int64_t sparse_dim, int64_t dense_dim) const override;
  Tensor & sparse_resize_and_clear_(Tensor & self, IntArrayRef size, int64_t sparse_dim, int64_t dense_dim) const override;
  std::vector<Tensor> split(const Tensor & self, int64_t split_size, int64_t dim) const override;
  std::vector<Tensor> split_with_sizes(const Tensor & self, IntArrayRef split_sizes, int64_t dim) const override;
  Tensor sqrt(const Tensor & self) const override;
  Tensor & sqrt_(Tensor & self) const override;
  Tensor & sqrt_out(Tensor & out, const Tensor & self) const override;
  Tensor squeeze(const Tensor & self) const override;
  Tensor squeeze(const Tensor & self, int64_t dim) const override;
  Tensor & squeeze_(Tensor & self) const override;
  Tensor & squeeze_(Tensor & self, int64_t dim) const override;
  Tensor sspaddmm(const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta, Scalar alpha) const override;
  Tensor & sspaddmm_out(Tensor & out, const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta, Scalar alpha) const override;
  Tensor stack(TensorList tensors, int64_t dim) const override;
  Tensor & stack_out(Tensor & out, TensorList tensors, int64_t dim) const override;
  Tensor std(const Tensor & self, bool unbiased) const override;
  Tensor std(const Tensor & self, IntArrayRef dim, bool unbiased, bool keepdim) const override;
  Tensor & std_out(Tensor & out, const Tensor & self, IntArrayRef dim, bool unbiased, bool keepdim) const override;
  Tensor stft(const Tensor & self, int64_t n_fft, c10::optional<int64_t> hop_length, c10::optional<int64_t> win_length, const Tensor & window, bool normalized, bool onesided) const override;
  int64_t stride(const Tensor & self, int64_t dim) const override;
  Tensor sub(const Tensor & self, const Tensor & other, Scalar alpha) const override;
  Tensor sub(const Tensor & self, Scalar other, Scalar alpha) const override;
  Tensor & sub_(Tensor & self, const Tensor & other, Scalar alpha) const override;
  Tensor & sub_(Tensor & self, Scalar other, Scalar alpha) const override;
  Tensor & sub_out(Tensor & out, const Tensor & self, const Tensor & other, Scalar alpha) const override;
  Tensor sum(const Tensor & self, ScalarType dtype) const override;
  Tensor sum(const Tensor & self) const override;
  Tensor sum(const Tensor & self, IntArrayRef dim, bool keepdim, ScalarType dtype) const override;
  Tensor sum(const Tensor & self, IntArrayRef dim, bool keepdim) const override;
  Tensor sum(const Tensor & self, IntArrayRef dim, ScalarType dtype) const override;
  Tensor & sum_out(Tensor & out, const Tensor & self, IntArrayRef dim, bool keepdim, ScalarType dtype) const override;
  Tensor & sum_out(Tensor & out, const Tensor & self, IntArrayRef dim, bool keepdim) const override;
  Tensor & sum_out(Tensor & out, const Tensor & self, IntArrayRef dim, ScalarType dtype) const override;
  Tensor sum_to_size(const Tensor & self, IntArrayRef size) const override;
  std::tuple<Tensor,Tensor,Tensor> svd(const Tensor & self, bool some, bool compute_uv) const override;
  std::tuple<Tensor &,Tensor &,Tensor &> svd_out(Tensor & U, Tensor & S, Tensor & V, const Tensor & self, bool some, bool compute_uv) const override;
  std::tuple<Tensor,Tensor> symeig(const Tensor & self, bool eigenvectors, bool upper) const override;
  std::tuple<Tensor &,Tensor &> symeig_out(Tensor & e, Tensor & V, const Tensor & self, bool eigenvectors, bool upper) const override;
  Tensor t(const Tensor & self) const override;
  Tensor & t_(Tensor & self) const override;
  Tensor take(const Tensor & self, const Tensor & index) const override;
  Tensor & take_out(Tensor & out, const Tensor & self, const Tensor & index) const override;
  Tensor tan(const Tensor & self) const override;
  Tensor & tan_(Tensor & self) const override;
  Tensor & tan_out(Tensor & out, const Tensor & self) const override;
  Tensor tanh(const Tensor & self) const override;
  Tensor & tanh_(Tensor & self) const override;
  Tensor tanh_backward(const Tensor & grad_output, const Tensor & output) const override;
  Tensor & tanh_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & output) const override;
  Tensor & tanh_out(Tensor & out, const Tensor & self) const override;
  Tensor tensordot(const Tensor & self, const Tensor & other, IntArrayRef dims_self, IntArrayRef dims_other) const override;
  Tensor thnn_col2im(const Tensor & self, IntArrayRef output_size, IntArrayRef kernel_size, IntArrayRef dilation, IntArrayRef padding, IntArrayRef stride) const override;
  Tensor thnn_col2im_backward(const Tensor & grad_output, IntArrayRef kernel_size, IntArrayRef dilation, IntArrayRef padding, IntArrayRef stride) const override;
  Tensor thnn_conv2d(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding) const override;
  std::tuple<Tensor,Tensor,Tensor> thnn_conv2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, const Tensor & finput, const Tensor & fgrad_input, std::array<bool,3> output_mask) const override;
  std::tuple<Tensor &,Tensor &,Tensor &> thnn_conv2d_backward_out(Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, const Tensor & finput, const Tensor & fgrad_input) const override;
  std::tuple<Tensor,Tensor,Tensor> thnn_conv2d_forward(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding) const override;
  std::tuple<Tensor &,Tensor &,Tensor &> thnn_conv2d_forward_out(Tensor & output, Tensor & finput, Tensor & fgrad_input, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding) const override;
  Tensor & thnn_conv2d_out(Tensor & out, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding) const override;
  Tensor thnn_conv3d(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding) const override;
  std::tuple<Tensor,Tensor,Tensor> thnn_conv3d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, const Tensor & finput, const Tensor & fgrad_input, std::array<bool,3> output_mask) const override;
  std::tuple<Tensor &,Tensor &,Tensor &> thnn_conv3d_backward_out(Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, const Tensor & finput, const Tensor & fgrad_input) const override;
  std::tuple<Tensor,Tensor,Tensor> thnn_conv3d_forward(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding) const override;
  std::tuple<Tensor &,Tensor &,Tensor &> thnn_conv3d_forward_out(Tensor & output, Tensor & finput, Tensor & fgrad_input, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding) const override;
  Tensor & thnn_conv3d_out(Tensor & out, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding) const override;
  Tensor thnn_conv_depthwise2d(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation) const override;
  std::tuple<Tensor,Tensor> thnn_conv_depthwise2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, std::array<bool,2> output_mask) const override;
  std::tuple<Tensor &,Tensor &> thnn_conv_depthwise2d_backward_out(Tensor & grad_input, Tensor & grad_weight, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation) const override;
  Tensor thnn_conv_depthwise2d_forward(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation) const override;
  Tensor & thnn_conv_depthwise2d_forward_out(Tensor & out, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation) const override;
  Tensor & thnn_conv_depthwise2d_out(Tensor & out, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation) const override;
  Tensor thnn_conv_dilated2d(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation) const override;
  std::tuple<Tensor,Tensor,Tensor> thnn_conv_dilated2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, const Tensor & columns, const Tensor & ones, std::array<bool,3> output_mask) const override;
  std::tuple<Tensor &,Tensor &,Tensor &> thnn_conv_dilated2d_backward_out(Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, const Tensor & columns, const Tensor & ones) const override;
  std::tuple<Tensor,Tensor,Tensor> thnn_conv_dilated2d_forward(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation) const override;
  std::tuple<Tensor &,Tensor &,Tensor &> thnn_conv_dilated2d_forward_out(Tensor & output, Tensor & columns, Tensor & ones, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation) const override;
  Tensor & thnn_conv_dilated2d_out(Tensor & out, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation) const override;
  Tensor thnn_conv_dilated3d(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation) const override;
  std::tuple<Tensor,Tensor,Tensor> thnn_conv_dilated3d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, const Tensor & columns, const Tensor & ones, std::array<bool,3> output_mask) const override;
  std::tuple<Tensor &,Tensor &,Tensor &> thnn_conv_dilated3d_backward_out(Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, const Tensor & columns, const Tensor & ones) const override;
  std::tuple<Tensor,Tensor,Tensor> thnn_conv_dilated3d_forward(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation) const override;
  std::tuple<Tensor &,Tensor &,Tensor &> thnn_conv_dilated3d_forward_out(Tensor & output, Tensor & columns, Tensor & ones, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation) const override;
  Tensor & thnn_conv_dilated3d_out(Tensor & out, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation) const override;
  Tensor thnn_conv_transpose2d(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation) const override;
  std::tuple<Tensor,Tensor,Tensor> thnn_conv_transpose2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation, const Tensor & columns, const Tensor & ones, std::array<bool,3> output_mask) const override;
  std::tuple<Tensor &,Tensor &,Tensor &> thnn_conv_transpose2d_backward_out(Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation, const Tensor & columns, const Tensor & ones) const override;
  std::tuple<Tensor,Tensor,Tensor> thnn_conv_transpose2d_forward(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation) const override;
  std::tuple<Tensor &,Tensor &,Tensor &> thnn_conv_transpose2d_forward_out(Tensor & output, Tensor & columns, Tensor & ones, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation) const override;
  Tensor & thnn_conv_transpose2d_out(Tensor & out, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation) const override;
  Tensor thnn_conv_transpose3d(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation) const override;
  std::tuple<Tensor,Tensor,Tensor> thnn_conv_transpose3d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation, const Tensor & finput, const Tensor & fgrad_input, std::array<bool,3> output_mask) const override;
  std::tuple<Tensor &,Tensor &,Tensor &> thnn_conv_transpose3d_backward_out(Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation, const Tensor & finput, const Tensor & fgrad_input) const override;
  std::tuple<Tensor,Tensor,Tensor> thnn_conv_transpose3d_forward(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation) const override;
  std::tuple<Tensor &,Tensor &,Tensor &> thnn_conv_transpose3d_forward_out(Tensor & output, Tensor & finput, Tensor & fgrad_input, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation) const override;
  Tensor & thnn_conv_transpose3d_out(Tensor & out, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation) const override;
  Tensor thnn_im2col(const Tensor & self, IntArrayRef kernel_size, IntArrayRef dilation, IntArrayRef padding, IntArrayRef stride) const override;
  Tensor thnn_im2col_backward(const Tensor & grad_output, IntArrayRef input_size, IntArrayRef kernel_size, IntArrayRef dilation, IntArrayRef padding, IntArrayRef stride) const override;
  Tensor threshold(const Tensor & self, Scalar threshold, Scalar value) const override;
  Tensor & threshold_(Tensor & self, Scalar threshold, Scalar value) const override;
  Tensor threshold_backward(const Tensor & grad_output, const Tensor & self, Scalar threshold) const override;
  Tensor & threshold_out(Tensor & out, const Tensor & self, Scalar threshold, Scalar value) const override;
  Tensor to(const Tensor & self, const TensorOptions & options, bool non_blocking, bool copy) const override;
  Tensor to(const Tensor & self, Device device, ScalarType dtype, bool non_blocking, bool copy) const override;
  Tensor to(const Tensor & self, ScalarType dtype, bool non_blocking, bool copy) const override;
  Tensor to(const Tensor & self, const Tensor & other, bool non_blocking, bool copy) const override;
  Tensor to_dense(const Tensor & self) const override;
  Tensor to_dense_backward(const Tensor & grad, const Tensor & input) const override;
  Tensor to_mkldnn(const Tensor & self) const override;
  Tensor to_mkldnn_backward(const Tensor & grad, const Tensor & input) const override;
  Tensor to_sparse(const Tensor & self, int64_t sparse_dim) const override;
  Tensor to_sparse(const Tensor & self) const override;
  std::tuple<Tensor,Tensor> topk(const Tensor & self, int64_t k, int64_t dim, bool largest, bool sorted) const override;
  std::tuple<Tensor &,Tensor &> topk_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t k, int64_t dim, bool largest, bool sorted) const override;
  Tensor trace(const Tensor & self) const override;
  Tensor transpose(const Tensor & self, int64_t dim0, int64_t dim1) const override;
  Tensor & transpose_(Tensor & self, int64_t dim0, int64_t dim1) const override;
  std::tuple<Tensor,Tensor> triangular_solve(const Tensor & self, const Tensor & A, bool upper, bool transpose, bool unitriangular) const override;
  std::tuple<Tensor &,Tensor &> triangular_solve_out(Tensor & X, Tensor & M, const Tensor & self, const Tensor & A, bool upper, bool transpose, bool unitriangular) const override;
  Tensor tril(const Tensor & self, int64_t diagonal) const override;
  Tensor & tril_(Tensor & self, int64_t diagonal) const override;
  Tensor tril_indices(int64_t row, int64_t col, int64_t offset, const TensorOptions & options) const override;
  Tensor & tril_out(Tensor & out, const Tensor & self, int64_t diagonal) const override;
  Tensor triplet_margin_loss(const Tensor & anchor, const Tensor & positive, const Tensor & negative, double margin, double p, double eps, bool swap, int64_t reduction) const override;
  Tensor triu(const Tensor & self, int64_t diagonal) const override;
  Tensor & triu_(Tensor & self, int64_t diagonal) const override;
  Tensor triu_indices(int64_t row, int64_t col, int64_t offset, const TensorOptions & options) const override;
  Tensor & triu_out(Tensor & out, const Tensor & self, int64_t diagonal) const override;
  Tensor trunc(const Tensor & self) const override;
  Tensor & trunc_(Tensor & self) const override;
  Tensor & trunc_out(Tensor & out, const Tensor & self) const override;
  Tensor type_as(const Tensor & self, const Tensor & other) const override;
  std::vector<Tensor> unbind(const Tensor & self, int64_t dim) const override;
  Tensor unfold(const Tensor & self, int64_t dimension, int64_t size, int64_t step) const override;
  Tensor & uniform_(Tensor & self, double from, double to, Generator * generator) const override;
  std::tuple<Tensor,Tensor,Tensor> unique_consecutive(const Tensor & self, bool return_inverse, bool return_counts, c10::optional<int64_t> dim) const override;
  std::tuple<Tensor,Tensor,Tensor> unique_dim(const Tensor & self, int64_t dim, bool sorted, bool return_inverse, bool return_counts) const override;
  std::tuple<Tensor,Tensor,Tensor> unique_dim_consecutive(const Tensor & self, int64_t dim, bool return_inverse, bool return_counts) const override;
  Tensor unsqueeze(const Tensor & self, int64_t dim) const override;
  Tensor & unsqueeze_(Tensor & self, int64_t dim) const override;
  Tensor upsample_bicubic2d(const Tensor & self, IntArrayRef output_size, bool align_corners) const override;
  Tensor upsample_bicubic2d_backward(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners) const override;
  Tensor & upsample_bicubic2d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners) const override;
  Tensor & upsample_bicubic2d_out(Tensor & out, const Tensor & self, IntArrayRef output_size, bool align_corners) const override;
  Tensor upsample_bilinear2d(const Tensor & self, IntArrayRef output_size, bool align_corners) const override;
  Tensor upsample_bilinear2d_backward(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners) const override;
  Tensor & upsample_bilinear2d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners) const override;
  Tensor & upsample_bilinear2d_out(Tensor & out, const Tensor & self, IntArrayRef output_size, bool align_corners) const override;
  Tensor upsample_linear1d(const Tensor & self, IntArrayRef output_size, bool align_corners) const override;
  Tensor upsample_linear1d_backward(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners) const override;
  Tensor & upsample_linear1d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners) const override;
  Tensor & upsample_linear1d_out(Tensor & out, const Tensor & self, IntArrayRef output_size, bool align_corners) const override;
  Tensor upsample_nearest1d(const Tensor & self, IntArrayRef output_size) const override;
  Tensor upsample_nearest1d_backward(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size) const override;
  Tensor & upsample_nearest1d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size) const override;
  Tensor & upsample_nearest1d_out(Tensor & out, const Tensor & self, IntArrayRef output_size) const override;
  Tensor upsample_nearest2d(const Tensor & self, IntArrayRef output_size) const override;
  Tensor upsample_nearest2d_backward(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size) const override;
  Tensor & upsample_nearest2d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size) const override;
  Tensor & upsample_nearest2d_out(Tensor & out, const Tensor & self, IntArrayRef output_size) const override;
  Tensor upsample_nearest3d(const Tensor & self, IntArrayRef output_size) const override;
  Tensor upsample_nearest3d_backward(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size) const override;
  Tensor & upsample_nearest3d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size) const override;
  Tensor & upsample_nearest3d_out(Tensor & out, const Tensor & self, IntArrayRef output_size) const override;
  Tensor upsample_trilinear3d(const Tensor & self, IntArrayRef output_size, bool align_corners) const override;
  Tensor upsample_trilinear3d_backward(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners) const override;
  Tensor & upsample_trilinear3d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners) const override;
  Tensor & upsample_trilinear3d_out(Tensor & out, const Tensor & self, IntArrayRef output_size, bool align_corners) const override;
  Tensor values(const Tensor & self) const override;
  Tensor var(const Tensor & self, bool unbiased) const override;
  Tensor var(const Tensor & self, IntArrayRef dim, bool unbiased, bool keepdim) const override;
  Tensor & var_out(Tensor & out, const Tensor & self, IntArrayRef dim, bool unbiased, bool keepdim) const override;
  Tensor view(const Tensor & self, IntArrayRef size) const override;
  Tensor view_as(const Tensor & self, const Tensor & other) const override;
  Tensor where(const Tensor & condition, const Tensor & self, const Tensor & other) const override;
  Tensor & zero_(Tensor & self) const override;
  Tensor zeros(IntArrayRef size, const TensorOptions & options) const override;
  Tensor zeros_like(const Tensor & self) const override;
  Tensor zeros_like(const Tensor & self, const TensorOptions & options) const override;
  Tensor & zeros_out(Tensor & out, IntArrayRef size) const override;

private:
  // checks that t is actually a Variable
  static const Variable & checked_cast_variable(const Tensor & t, const char * name, int pos);
  static Variable & checked_cast_variable(Tensor & t, const char * name, int pos);
  static at::Tensor & unpack(Tensor & t, const char * name, int pos);
  static const at::Tensor & unpack(const Tensor & t, const char * name, int pos);
  static at::SparseTensorRef unpack(SparseTensorRef t, const char * name, int pos);
  static at::Tensor unpack_opt(const Tensor & t, const char * name, int pos);
  static std::vector<at::Tensor> unpack(at::TensorList tl, const char *name, int pos);

  at::TypeExtendedInterface* baseType;
  std::string str;
  size_t id_;
};

}} // namespace torch::autograd
