#pragma once

// an external backend might generate file within its code tree
// and check all the source files within the tree with clang-format.
// so, disable it since the backend might have a different config.
// clang-format off

// Autogenerated file by gen_backend_stubs.py. Do not edit directly!

#include <ATen/Tensor.h>

namespace torch {
namespace lazy {

struct LazyNativeFunctions {

static ::std::tuple<at::Tensor,at::Tensor,at::Tensor> convolution_backward(const at::Tensor & grad_output, const at::Tensor & input, const at::Tensor & weight, at::OptionalIntArrayRef bias_sizes, at::IntArrayRef stride, at::IntArrayRef padding, at::IntArrayRef dilation, bool transposed, at::IntArrayRef output_padding, int64_t groups, ::std::array<bool,3> output_mask);
static ::std::tuple<at::Tensor,at::Tensor,at::Tensor> native_batch_norm(const at::Tensor & input, const c10::optional<at::Tensor> & weight, const c10::optional<at::Tensor> & bias, const c10::optional<at::Tensor> & running_mean, const c10::optional<at::Tensor> & running_var, bool training, double momentum, double eps);
static ::std::tuple<at::Tensor,at::Tensor,at::Tensor> native_batch_norm_backward(const at::Tensor & grad_out, const at::Tensor & input, const c10::optional<at::Tensor> & weight, const c10::optional<at::Tensor> & running_mean, const c10::optional<at::Tensor> & running_var, const c10::optional<at::Tensor> & save_mean, const c10::optional<at::Tensor> & save_invstd, bool train, double eps, ::std::array<bool,3> output_mask);
static ::std::tuple<at::Tensor,at::Tensor,at::Tensor> native_layer_norm(const at::Tensor & input, at::IntArrayRef normalized_shape, const c10::optional<at::Tensor> & weight, const c10::optional<at::Tensor> & bias, double eps);
static ::std::tuple<at::Tensor,at::Tensor,at::Tensor> native_layer_norm_backward(const at::Tensor & grad_out, const at::Tensor & input, at::IntArrayRef normalized_shape, const at::Tensor & mean, const at::Tensor & rstd, const c10::optional<at::Tensor> & weight, const c10::optional<at::Tensor> & bias, ::std::array<bool,3> output_mask);
static ::std::tuple<at::Tensor,at::Tensor> grid_sampler_2d_backward(const at::Tensor & grad_output, const at::Tensor & input, const at::Tensor & grid, int64_t interpolation_mode, int64_t padding_mode, bool align_corners, ::std::array<bool,2> output_mask);
static ::std::tuple<at::Tensor,at::Tensor> log_sigmoid_forward(const at::Tensor & self);
static ::std::tuple<at::Tensor,at::Tensor> max(const at::Tensor & self, int64_t dim, bool keepdim);
static ::std::tuple<at::Tensor,at::Tensor> max_pool2d_with_indices(const at::Tensor & self, at::IntArrayRef kernel_size, at::IntArrayRef stride, at::IntArrayRef padding, at::IntArrayRef dilation, bool ceil_mode);
static ::std::tuple<at::Tensor,at::Tensor> max_pool3d_with_indices(const at::Tensor & self, at::IntArrayRef kernel_size, at::IntArrayRef stride, at::IntArrayRef padding, at::IntArrayRef dilation, bool ceil_mode);
static ::std::tuple<at::Tensor,at::Tensor> native_dropout(const at::Tensor & input, double p, c10::optional<bool> train);
static ::std::tuple<at::Tensor,at::Tensor> nll_loss2d_forward(const at::Tensor & self, const at::Tensor & target, const c10::optional<at::Tensor> & weight, int64_t reduction, int64_t ignore_index);
static ::std::tuple<at::Tensor,at::Tensor> nll_loss_forward(const at::Tensor & self, const at::Tensor & target, const c10::optional<at::Tensor> & weight, int64_t reduction, int64_t ignore_index);
static ::std::tuple<at::Tensor,at::Tensor> sort(const at::Tensor & self, int64_t dim, bool descending);
static ::std::tuple<at::Tensor,at::Tensor> topk(const at::Tensor & self, int64_t k, int64_t dim, bool largest, bool sorted);
static at::Tensor & arange_out(const at::Scalar & start, const at::Scalar & end, const at::Scalar & step, at::Tensor & out);
static at::Tensor & fill_(at::Tensor & self, const at::Scalar & value);
static at::Tensor & normal_(at::Tensor & self, double mean, double std, c10::optional<at::Generator> generator);
static at::Tensor & squeeze_(at::Tensor & self);
static at::Tensor & squeeze_(at::Tensor & self, int64_t dim);
static at::Tensor & t_(at::Tensor & self);
static at::Tensor & transpose_(at::Tensor & self, int64_t dim0, int64_t dim1);
static at::Tensor & unsqueeze_(at::Tensor & self, int64_t dim);
static at::Tensor _adaptive_avg_pool2d(const at::Tensor & self, at::IntArrayRef output_size);
static at::Tensor _adaptive_avg_pool2d_backward(const at::Tensor & grad_output, const at::Tensor & self);
static at::Tensor _copy_from(const at::Tensor & self, const at::Tensor & dst, bool non_blocking);
static at::Tensor _copy_from_and_resize(const at::Tensor & self, const at::Tensor & dst);
static at::Tensor _log_softmax(const at::Tensor & self, int64_t dim, bool half_to_float);
static at::Tensor _log_softmax_backward_data(const at::Tensor & grad_output, const at::Tensor & output, int64_t dim, at::ScalarType input_dtype);
static at::Tensor _softmax(const at::Tensor & self, int64_t dim, bool half_to_float);
static at::Tensor _softmax_backward_data(const at::Tensor & grad_output, const at::Tensor & output, int64_t dim, at::ScalarType input_dtype);
static at::Tensor _to_copy(const at::Tensor & self, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory, bool non_blocking, c10::optional<at::MemoryFormat> memory_format);
static at::Tensor _unsafe_view(const at::Tensor & self, at::IntArrayRef size);
static at::Tensor abs(const at::Tensor & self);
static at::Tensor add(const at::Tensor & self, const at::Tensor & other, const at::Scalar & alpha);
static at::Tensor addcdiv(const at::Tensor & self, const at::Tensor & tensor1, const at::Tensor & tensor2, const at::Scalar & value);
static at::Tensor addcmul(const at::Tensor & self, const at::Tensor & tensor1, const at::Tensor & tensor2, const at::Scalar & value);
static at::Tensor addmm(const at::Tensor & self, const at::Tensor & mat1, const at::Tensor & mat2, const at::Scalar & beta, const at::Scalar & alpha);
static at::Tensor alias(const at::Tensor & self);
static at::Tensor all(const at::Tensor & self);
static at::Tensor any(const at::Tensor & self);
static at::Tensor as_strided(const at::Tensor & self, at::IntArrayRef size, at::IntArrayRef stride, c10::optional<int64_t> storage_offset);
static at::Tensor avg_pool2d(const at::Tensor & self, at::IntArrayRef kernel_size, at::IntArrayRef stride, at::IntArrayRef padding, bool ceil_mode, bool count_include_pad, c10::optional<int64_t> divisor_override);
static at::Tensor avg_pool2d_backward(const at::Tensor & grad_output, const at::Tensor & self, at::IntArrayRef kernel_size, at::IntArrayRef stride, at::IntArrayRef padding, bool ceil_mode, bool count_include_pad, c10::optional<int64_t> divisor_override);
static at::Tensor baddbmm(const at::Tensor & self, const at::Tensor & batch1, const at::Tensor & batch2, const at::Scalar & beta, const at::Scalar & alpha);
static at::Tensor bernoulli(const at::Tensor & self, c10::optional<at::Generator> generator);
static at::Tensor bernoulli(const at::Tensor & self, double p, c10::optional<at::Generator> generator);
static at::Tensor binary_cross_entropy(const at::Tensor & self, const at::Tensor & target, const c10::optional<at::Tensor> & weight, int64_t reduction);
static at::Tensor binary_cross_entropy_backward(const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & target, const c10::optional<at::Tensor> & weight, int64_t reduction);
static at::Tensor bitwise_and(const at::Tensor & self, const at::Tensor & other);
static at::Tensor bitwise_or(const at::Tensor & self, const at::Tensor & other);
static at::Tensor bmm(const at::Tensor & self, const at::Tensor & mat2);
static at::Tensor cat(at::TensorList tensors, int64_t dim);
static at::Tensor clamp(const at::Tensor & self, const c10::optional<at::Scalar> & min, const c10::optional<at::Scalar> & max);
static at::Tensor clamp_min(const at::Tensor & self, const at::Scalar & min);
static at::Tensor clone(const at::Tensor & self, c10::optional<at::MemoryFormat> memory_format);
static at::Tensor constant_pad_nd(const at::Tensor & self, at::IntArrayRef pad, const at::Scalar & value);
static at::Tensor convolution(const at::Tensor & input, const at::Tensor & weight, const c10::optional<at::Tensor> & bias, at::IntArrayRef stride, at::IntArrayRef padding, at::IntArrayRef dilation, bool transposed, at::IntArrayRef output_padding, int64_t groups);
static at::Tensor cos(const at::Tensor & self);
static at::Tensor cumsum(const at::Tensor & self, int64_t dim, c10::optional<at::ScalarType> dtype);
static at::Tensor diagonal(const at::Tensor & self, int64_t offset, int64_t dim1, int64_t dim2);
static at::Tensor div(const at::Tensor & self, const at::Tensor & other);
static at::Tensor div(const at::Tensor & self, const at::Tensor & other, c10::optional<c10::string_view> rounding_mode);
static at::Tensor elu(const at::Tensor & self, const at::Scalar & alpha, const at::Scalar & scale, const at::Scalar & input_scale);
static at::Tensor elu_backward(const at::Tensor & grad_output, const at::Scalar & alpha, const at::Scalar & scale, const at::Scalar & input_scale, bool is_result, const at::Tensor & self_or_result);
static at::Tensor embedding(const at::Tensor & weight, const at::Tensor & indices, int64_t padding_idx, bool scale_grad_by_freq, bool sparse);
static at::Tensor embedding_dense_backward(const at::Tensor & grad_output, const at::Tensor & indices, int64_t num_weights, int64_t padding_idx, bool scale_grad_by_freq);
static at::Tensor empty(at::IntArrayRef size, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory, c10::optional<at::MemoryFormat> memory_format);
static at::Tensor empty_strided(at::IntArrayRef size, at::IntArrayRef stride, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory);
static at::Tensor eq(const at::Tensor & self, const at::Scalar & other);
static at::Tensor eq(const at::Tensor & self, const at::Tensor & other);
static at::Tensor exp(const at::Tensor & self);
static at::Tensor expand(const at::Tensor & self, at::IntArrayRef size, bool implicit);
static at::Tensor flip(const at::Tensor & self, at::IntArrayRef dims);
static at::Tensor floor(const at::Tensor & self);
static at::Tensor frac(const at::Tensor & self);
static at::Tensor gather(const at::Tensor & self, int64_t dim, const at::Tensor & index, bool sparse_grad);
static at::Tensor ge(const at::Tensor & self, const at::Scalar & other);
static at::Tensor ge(const at::Tensor & self, const at::Tensor & other);
static at::Tensor gelu(const at::Tensor & self, c10::string_view approximate);
static at::Tensor gelu_backward(const at::Tensor & grad_output, const at::Tensor & self, c10::string_view approximate);
static at::Tensor glu(const at::Tensor & self, int64_t dim);
static at::Tensor glu_backward(const at::Tensor & grad_output, const at::Tensor & self, int64_t dim);
static at::Tensor glu_jvp(const at::Tensor & glu, const at::Tensor & x, const at::Tensor & dx, int64_t dim);
static at::Tensor grid_sampler_2d(const at::Tensor & input, const at::Tensor & grid, int64_t interpolation_mode, int64_t padding_mode, bool align_corners);
static at::Tensor gt(const at::Tensor & self, const at::Scalar & other);
static at::Tensor gt(const at::Tensor & self, const at::Tensor & other);
static at::Tensor hardsigmoid(const at::Tensor & self);
static at::Tensor index_select(const at::Tensor & self, int64_t dim, const at::Tensor & index);
static at::Tensor kl_div_backward(const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & target, int64_t reduction, bool log_target);
static at::Tensor l1_loss_backward(const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & target, int64_t reduction);
static at::Tensor le(const at::Tensor & self, const at::Scalar & other);
static at::Tensor le(const at::Tensor & self, const at::Tensor & other);
static at::Tensor leaky_relu(const at::Tensor & self, const at::Scalar & negative_slope);
static at::Tensor leaky_relu_backward(const at::Tensor & grad_output, const at::Tensor & self, const at::Scalar & negative_slope, bool self_is_result);
static at::Tensor log(const at::Tensor & self);
static at::Tensor log2(const at::Tensor & self);
static at::Tensor log_sigmoid_backward(const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & buffer);
static at::Tensor logdet(const at::Tensor & self);
static at::Tensor lt(const at::Tensor & self, const at::Scalar & other);
static at::Tensor lt(const at::Tensor & self, const at::Tensor & other);
static at::Tensor masked_fill(const at::Tensor & self, const at::Tensor & mask, const at::Scalar & value);
static at::Tensor masked_fill(const at::Tensor & self, const at::Tensor & mask, const at::Tensor & value);
static at::Tensor max(const at::Tensor & self);
static at::Tensor max_pool2d_with_indices_backward(const at::Tensor & grad_output, const at::Tensor & self, at::IntArrayRef kernel_size, at::IntArrayRef stride, at::IntArrayRef padding, at::IntArrayRef dilation, bool ceil_mode, const at::Tensor & indices);
static at::Tensor max_pool3d_with_indices_backward(const at::Tensor & grad_output, const at::Tensor & self, at::IntArrayRef kernel_size, at::IntArrayRef stride, at::IntArrayRef padding, at::IntArrayRef dilation, bool ceil_mode, const at::Tensor & indices);
static at::Tensor maximum(const at::Tensor & self, const at::Tensor & other);
static at::Tensor mean(const at::Tensor & self, at::IntArrayRef dim, bool keepdim, c10::optional<at::ScalarType> dtype);
static at::Tensor mean(const at::Tensor & self, c10::optional<at::ScalarType> dtype);
static at::Tensor min(const at::Tensor & self);
static at::Tensor minimum(const at::Tensor & self, const at::Tensor & other);
static at::Tensor mm(const at::Tensor & self, const at::Tensor & mat2);
static at::Tensor mul(const at::Tensor & self, const at::Tensor & other);
static at::Tensor mv(const at::Tensor & self, const at::Tensor & vec);
static at::Tensor narrow(const at::Tensor & self, int64_t dim, int64_t start, int64_t length);
static at::Tensor narrow_copy(const at::Tensor & self, int64_t dim, int64_t start, c10::SymInt length);
static at::Tensor native_dropout_backward(const at::Tensor & grad_output, const at::Tensor & mask, double scale);
static at::Tensor ne(const at::Tensor & self, const at::Scalar & other);
static at::Tensor ne(const at::Tensor & self, const at::Tensor & other);
static at::Tensor neg(const at::Tensor & self);
static at::Tensor nll_loss2d_backward(const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & target, const c10::optional<at::Tensor> & weight, int64_t reduction, int64_t ignore_index, const at::Tensor & total_weight);
static at::Tensor nll_loss_backward(const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & target, const c10::optional<at::Tensor> & weight, int64_t reduction, int64_t ignore_index, const at::Tensor & total_weight);
static at::Tensor nonzero(const at::Tensor & self);
static at::Tensor norm(const at::Tensor & self, const c10::optional<at::Scalar> & p, at::IntArrayRef dim, bool keepdim);
static at::Tensor permute(const at::Tensor & self, at::IntArrayRef dims);
static at::Tensor pow(const at::Tensor & self, const at::Scalar & exponent);
static at::Tensor pow(const at::Tensor & self, const at::Tensor & exponent);
static at::Tensor random_functional(const at::Tensor & self, c10::optional<at::Generator> generator);
static at::Tensor random_functional(const at::Tensor & self, int64_t from, c10::optional<int64_t> to, c10::optional<at::Generator> generator);
static at::Tensor random_functional(const at::Tensor & self, int64_t to, c10::optional<at::Generator> generator);
static at::Tensor reciprocal(const at::Tensor & self);
static at::Tensor relu(const at::Tensor & self);
static at::Tensor remainder(const at::Tensor & self, const at::Tensor & other);
static at::Tensor repeat(const at::Tensor & self, at::IntArrayRef repeats);
static at::Tensor rsqrt(const at::Tensor & self);
static at::Tensor scatter_add(const at::Tensor & self, int64_t dim, const at::Tensor & index, const at::Tensor & src);
static at::Tensor select(const at::Tensor & self, int64_t dim, int64_t index);
static at::Tensor sgn(const at::Tensor & self);
static at::Tensor sigmoid(const at::Tensor & self);
static at::Tensor sigmoid_backward(const at::Tensor & grad_output, const at::Tensor & output);
static at::Tensor silu(const at::Tensor & self);
static at::Tensor slice(const at::Tensor & self, int64_t dim, c10::optional<int64_t> start, c10::optional<int64_t> end, int64_t step);
static at::Tensor smooth_l1_loss(const at::Tensor & self, const at::Tensor & target, int64_t reduction, double beta);
static at::Tensor smooth_l1_loss_backward(const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & target, int64_t reduction, double beta);
static at::Tensor softplus(const at::Tensor & self, const at::Scalar & beta, const at::Scalar & threshold);
static at::Tensor softplus_backward(const at::Tensor & grad_output, const at::Tensor & self, const at::Scalar & beta, const at::Scalar & threshold);
static at::Tensor sqrt(const at::Tensor & self);
static at::Tensor squeeze(const at::Tensor & self);
static at::Tensor squeeze(const at::Tensor & self, int64_t dim);
static at::Tensor stack(at::TensorList tensors, int64_t dim);
static at::Tensor std(const at::Tensor & self, at::IntArrayRef dim, bool unbiased, bool keepdim);
static at::Tensor std(const at::Tensor & self, at::OptionalIntArrayRef dim, c10::optional<int64_t> correction, bool keepdim);
static at::Tensor std(const at::Tensor & self, bool unbiased);
static at::Tensor sub(const at::Tensor & self, const at::Tensor & other, const at::Scalar & alpha);
static at::Tensor sum(const at::Tensor & self, at::IntArrayRef dim, bool keepdim, c10::optional<at::ScalarType> dtype);
static at::Tensor sum(const at::Tensor & self, c10::optional<at::ScalarType> dtype);
static at::Tensor t(const at::Tensor & self);
static at::Tensor tanh(const at::Tensor & self);
static at::Tensor tanh_backward(const at::Tensor & grad_output, const at::Tensor & output);
static at::Tensor threshold(const at::Tensor & self, const at::Scalar & threshold, const at::Scalar & value);
static at::Tensor threshold_backward(const at::Tensor & grad_output, const at::Tensor & self, const at::Scalar & threshold);
static at::Tensor trace(const at::Tensor & self);
static at::Tensor transpose(const at::Tensor & self, int64_t dim0, int64_t dim1);
static at::Tensor tril(const at::Tensor & self, int64_t diagonal);
static at::Tensor triu(const at::Tensor & self, int64_t diagonal);
static at::Tensor trunc(const at::Tensor & self);
static at::Tensor unsqueeze(const at::Tensor & self, int64_t dim);
static at::Tensor upsample_bilinear2d(const at::Tensor & self, at::IntArrayRef output_size, bool align_corners, c10::optional<double> scales_h, c10::optional<double> scales_w);
static at::Tensor upsample_bilinear2d_backward(const at::Tensor & grad_output, at::IntArrayRef output_size, at::IntArrayRef input_size, bool align_corners, c10::optional<double> scales_h, c10::optional<double> scales_w);
static at::Tensor upsample_nearest2d(const at::Tensor & self, at::IntArrayRef output_size, c10::optional<double> scales_h, c10::optional<double> scales_w);
static at::Tensor upsample_nearest2d_backward(const at::Tensor & grad_output, at::IntArrayRef output_size, at::IntArrayRef input_size, c10::optional<double> scales_h, c10::optional<double> scales_w);
static at::Tensor view(const at::Tensor & self, at::IntArrayRef size);
static at::Tensor zero_functional(const at::Tensor & self);
static const at::Tensor & as_strided_(const at::Tensor & self, at::IntArrayRef size, at::IntArrayRef stride, c10::optional<int64_t> storage_offset);
static at::Tensor max_pool3d(const at::Tensor & self, at::IntArrayRef kernel_size, at::IntArrayRef stride, at::IntArrayRef padding, at::IntArrayRef dilation, bool ceil_mode);

};
} // namespace lazy
} // namespace torch
