#pragma once

// @generated by aten/src/ATen/gen.py

#include <ATen/Context.h>
#include <ATen/Utils.h>

#include <ATen/DeviceGuard.h>
#include <ATen/cuda/ATenCUDAGeneral.h>
#include <ATen/cuda/CUDADevice.h>
#include <ATen/cuda/CUDAContext.h>

namespace at {

struct CUDAType final {
  static std::tuple<Tensor,Tensor> _cudnn_ctc_loss(const Tensor & log_probs, const Tensor & targets, IntArrayRef input_lengths, IntArrayRef target_lengths, int64_t blank, bool deterministic, bool zero_infinity);
  static Tensor _cudnn_rnn_flatten_weight(TensorList weight_arr, int64_t weight_stride0, int64_t input_size, int64_t mode, int64_t hidden_size, int64_t num_layers, bool batch_first, bool bidirectional);
  static std::tuple<Tensor,Tensor,Tensor,Tensor,Tensor> _cudnn_rnn(const Tensor & input, TensorList weight, int64_t weight_stride0, const Tensor & weight_buf, const Tensor & hx, const Tensor & cx, int64_t mode, int64_t hidden_size, int64_t num_layers, bool batch_first, double dropout, bool train, bool bidirectional, IntArrayRef batch_sizes, const Tensor & dropout_state);
  static std::tuple<Tensor,Tensor,Tensor,std::vector<Tensor>> _cudnn_rnn_backward(const Tensor & input, TensorList weight, int64_t weight_stride0, const Tensor & weight_buf, const Tensor & hx, const Tensor & cx, const Tensor & output, const Tensor & grad_output, const Tensor & grad_hy, const Tensor & grad_cy, int64_t mode, int64_t hidden_size, int64_t num_layers, bool batch_first, double dropout, bool train, bool bidirectional, IntArrayRef batch_sizes, const Tensor & dropout_state, const Tensor & reserve, std::array<bool,4> output_mask);
  static Tensor _cudnn_init_dropout_state(double dropout, bool train, int64_t dropout_seed, const TensorOptions & options);
  static std::tuple<Tensor,Tensor> _fused_dropout(const Tensor & self, double p, Generator * generator);
  static Tensor _masked_scale(const Tensor & self, const Tensor & mask, double scale);
  static Tensor & abs_(Tensor & self);
  static Tensor & abs_out(Tensor & out, const Tensor & self);
  static Tensor & acos_(Tensor & self);
  static Tensor & acos_out(Tensor & out, const Tensor & self);
  static Tensor add(const Tensor & self, const Tensor & other, Scalar alpha);
  static Tensor & add_(Tensor & self, const Tensor & other, Scalar alpha);
  static Tensor & add_out(Tensor & out, const Tensor & self, const Tensor & other, Scalar alpha);
  static Tensor addmv(const Tensor & self, const Tensor & mat, const Tensor & vec, Scalar beta, Scalar alpha);
  static Tensor & addmv_(Tensor & self, const Tensor & mat, const Tensor & vec, Scalar beta, Scalar alpha);
  static Tensor & addmv_out(Tensor & out, const Tensor & self, const Tensor & mat, const Tensor & vec, Scalar beta, Scalar alpha);
  static Tensor & arange_out(Tensor & out, Scalar start, Scalar end, Scalar step);
  static Tensor as_strided(const Tensor & self, IntArrayRef size, IntArrayRef stride, c10::optional<int64_t> storage_offset);
  static Tensor & asin_(Tensor & self);
  static Tensor & asin_out(Tensor & out, const Tensor & self);
  static Tensor & atan_(Tensor & self);
  static Tensor & atan_out(Tensor & out, const Tensor & self);
  static Tensor baddbmm(const Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta, Scalar alpha);
  static Tensor & baddbmm_(Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta, Scalar alpha);
  static Tensor & baddbmm_out(Tensor & out, const Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta, Scalar alpha);
  static Tensor & bernoulli_(Tensor & self, const Tensor & p, Generator * generator);
  static Tensor & bernoulli_(Tensor & self, double p, Generator * generator);
  static Tensor bincount(const Tensor & self, const Tensor & weights, int64_t minlength);
  static Tensor & bitwise_not_out(Tensor & out, const Tensor & self);
  static Tensor bmm(const Tensor & self, const Tensor & mat2);
  static Tensor & bmm_out(Tensor & out, const Tensor & self, const Tensor & mat2);
  static Tensor & ceil_(Tensor & self);
  static Tensor & ceil_out(Tensor & out, const Tensor & self);
  static Tensor & clamp_(Tensor & self, c10::optional<Scalar> min, c10::optional<Scalar> max);
  static Tensor & clamp_out(Tensor & out, const Tensor & self, c10::optional<Scalar> min, c10::optional<Scalar> max);
  static Tensor & clamp_max_(Tensor & self, Scalar max);
  static Tensor & clamp_max_out(Tensor & out, const Tensor & self, Scalar max);
  static Tensor & clamp_min_(Tensor & self, Scalar min);
  static Tensor & clamp_min_out(Tensor & out, const Tensor & self, Scalar min);
  static Tensor & cos_(Tensor & self);
  static Tensor & cos_out(Tensor & out, const Tensor & self);
  static Tensor & cosh_(Tensor & self);
  static Tensor & cosh_out(Tensor & out, const Tensor & self);
  static Tensor cudnn_affine_grid_generator(const Tensor & theta, int64_t N, int64_t C, int64_t H, int64_t W);
  static Tensor cudnn_affine_grid_generator_backward(const Tensor & grad, int64_t N, int64_t C, int64_t H, int64_t W);
  static std::tuple<Tensor,Tensor,Tensor> cudnn_batch_norm(const Tensor & input, const Tensor & weight, const Tensor & bias, const Tensor & running_mean, const Tensor & running_var, bool training, double exponential_average_factor, double epsilon);
  static std::tuple<Tensor,Tensor,Tensor> cudnn_batch_norm_backward(const Tensor & input, const Tensor & grad_output, const Tensor & weight, const Tensor & running_mean, const Tensor & running_var, const Tensor & save_mean, const Tensor & save_var, double epsilon);
  static Tensor cudnn_convolution(const Tensor & self, const Tensor & weight, const Tensor & bias, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic);
  static Tensor cudnn_convolution_backward_input(IntArrayRef self_size, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic);
  static std::tuple<Tensor,Tensor,Tensor> cudnn_convolution_backward(const Tensor & self, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic, std::array<bool,3> output_mask);
  static Tensor cudnn_convolution_backward_bias(const Tensor & grad_output);
  static Tensor cudnn_convolution_backward_weight(IntArrayRef weight_size, const Tensor & grad_output, const Tensor & self, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic);
  static Tensor cudnn_convolution_transpose(const Tensor & self, const Tensor & weight, const Tensor & bias, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic);
  static std::tuple<Tensor,Tensor,Tensor> cudnn_convolution_transpose_backward(const Tensor & self, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic, std::array<bool,3> output_mask);
  static Tensor cudnn_convolution_transpose_backward_bias(const Tensor & grad_output);
  static Tensor cudnn_convolution_transpose_backward_input(const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic);
  static Tensor cudnn_convolution_transpose_backward_weight(IntArrayRef weight_size, const Tensor & grad_output, const Tensor & self, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic);
  static Tensor cudnn_grid_sampler(const Tensor & self, const Tensor & grid);
  static std::tuple<Tensor,Tensor> cudnn_grid_sampler_backward(const Tensor & self, const Tensor & grid, const Tensor & grad_output);
  static std::tuple<Tensor,Tensor> _ctc_loss(const Tensor & log_probs, const Tensor & targets, IntArrayRef input_lengths, IntArrayRef target_lengths, int64_t blank, bool zero_infinity);
  static Tensor _ctc_loss_backward(const Tensor & grad, const Tensor & log_probs, const Tensor & targets, IntArrayRef input_lengths, IntArrayRef target_lengths, const Tensor & neg_log_likelihood, const Tensor & log_alpha, int64_t blank, bool zero_infinity);
  static Tensor dot(const Tensor & self, const Tensor & tensor);
  static Tensor embedding_dense_backward(const Tensor & grad_output, const Tensor & indices, int64_t num_weights, int64_t padding_idx, bool scale_grad_by_freq);
  static Tensor & embedding_renorm_(Tensor & self, const Tensor & indices, double max_norm, double norm_type);
  static std::tuple<Tensor,Tensor,Tensor,Tensor> _embedding_bag(const Tensor & weight, const Tensor & indices, const Tensor & offsets, bool scale_grad_by_freq, int64_t mode, bool sparse, const Tensor & per_sample_weights);
  static Tensor _embedding_bag_dense_backward(const Tensor & grad, const Tensor & indices, const Tensor & offsets, const Tensor & offset2bag, const Tensor & bag_size, const Tensor & maximum_indices, int64_t num_weights, bool scale_grad_by_freq, int64_t mode, const Tensor & per_sample_weights);
  static Tensor _embedding_bag_per_sample_weights_backward(const Tensor & grad, const Tensor & weight, const Tensor & indices, const Tensor & offsets, const Tensor & offset2bag, int64_t mode);
  static Tensor empty(IntArrayRef size, const TensorOptions & options, c10::optional<MemoryFormat> memory_format);
  static Tensor & resize_(Tensor & self, IntArrayRef size);
  static Tensor empty_strided(IntArrayRef size, IntArrayRef stride, const TensorOptions & options);
  static Tensor & erf_(Tensor & self);
  static Tensor & erf_out(Tensor & out, const Tensor & self);
  static Tensor & erfc_(Tensor & self);
  static Tensor & erfc_out(Tensor & out, const Tensor & self);
  static Tensor & exp_(Tensor & self);
  static Tensor & exp_out(Tensor & out, const Tensor & self);
  static Tensor & expm1_(Tensor & self);
  static Tensor & expm1_out(Tensor & out, const Tensor & self);
  static Tensor & eye_out(Tensor & out, int64_t n);
  static Tensor & eye_out(Tensor & out, int64_t n, int64_t m);
  static Tensor & floor_(Tensor & self);
  static Tensor & floor_out(Tensor & out, const Tensor & self);
  static Tensor & frac_(Tensor & self);
  static Tensor & frac_out(Tensor & out, const Tensor & self);
  static Tensor grid_sampler_2d(const Tensor & input, const Tensor & grid, int64_t interpolation_mode, int64_t padding_mode);
  static std::tuple<Tensor,Tensor> grid_sampler_2d_backward(const Tensor & grad_output, const Tensor & input, const Tensor & grid, int64_t interpolation_mode, int64_t padding_mode);
  static Tensor grid_sampler_3d(const Tensor & input, const Tensor & grid, int64_t interpolation_mode, int64_t padding_mode);
  static std::tuple<Tensor,Tensor> grid_sampler_3d_backward(const Tensor & grad_output, const Tensor & input, const Tensor & grid, int64_t interpolation_mode, int64_t padding_mode);
  static Tensor ger(const Tensor & self, const Tensor & vec2);
  static Tensor & ger_out(Tensor & out, const Tensor & self, const Tensor & vec2);
  static Tensor _fft_with_size(const Tensor & self, int64_t signal_ndim, bool complex_input, bool complex_output, bool inverse, IntArrayRef checked_signal_sizes, bool normalized, bool onesided, IntArrayRef output_sizes);
  static Tensor _inverse_helper(const Tensor & self);
  static Tensor kl_div_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction);
  static std::tuple<Tensor &,Tensor &> kthvalue_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t k, int64_t dim, bool keepdim);
  static Tensor & linspace_out(Tensor & out, Scalar start, Scalar end, int64_t steps);
  static Tensor & log_(Tensor & self);
  static Tensor & log_out(Tensor & out, const Tensor & self);
  static Tensor & log10_(Tensor & self);
  static Tensor & log10_out(Tensor & out, const Tensor & self);
  static Tensor & log1p_(Tensor & self);
  static Tensor & log1p_out(Tensor & out, const Tensor & self);
  static Tensor & log2_(Tensor & self);
  static Tensor & log2_out(Tensor & out, const Tensor & self);
  static Tensor & logspace_out(Tensor & out, Scalar start, Scalar end, int64_t steps, double base);
  static Tensor _log_softmax(const Tensor & self, int64_t dim, bool half_to_float);
  static Tensor _log_softmax_backward_data(const Tensor & grad_output, const Tensor & output, int64_t dim, const Tensor & self);
  static std::tuple<Tensor,Tensor,Tensor> miopen_batch_norm(const Tensor & input, const Tensor & weight, const Tensor & bias, const Tensor & running_mean, const Tensor & running_var, bool training, double exponential_average_factor, double epsilon);
  static std::tuple<Tensor,Tensor,Tensor> miopen_batch_norm_backward(const Tensor & input, const Tensor & grad_output, const Tensor & weight, const Tensor & running_mean, const Tensor & running_var, const Tensor & save_mean, const Tensor & save_var, double epsilon);
  static Tensor miopen_convolution(const Tensor & self, const Tensor & weight, const Tensor & bias, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic);
  static Tensor miopen_convolution_backward_input(IntArrayRef self_size, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic);
  static std::tuple<Tensor,Tensor,Tensor> miopen_convolution_backward(const Tensor & self, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic, std::array<bool,3> output_mask);
  static Tensor miopen_convolution_backward_bias(const Tensor & grad_output);
  static Tensor miopen_convolution_backward_weight(IntArrayRef weight_size, const Tensor & grad_output, const Tensor & self, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic);
  static Tensor miopen_convolution_transpose(const Tensor & self, const Tensor & weight, const Tensor & bias, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic);
  static std::tuple<Tensor,Tensor,Tensor> miopen_convolution_transpose_backward(const Tensor & self, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic, std::array<bool,3> output_mask);
  static Tensor miopen_convolution_transpose_backward_input(const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic);
  static Tensor miopen_convolution_transpose_backward_weight(IntArrayRef weight_size, const Tensor & grad_output, const Tensor & self, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic);
  static Tensor miopen_depthwise_convolution(const Tensor & self, const Tensor & weight, const Tensor & bias, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic);
  static Tensor miopen_depthwise_convolution_backward_input(IntArrayRef self_size, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic);
  static std::tuple<Tensor,Tensor,Tensor> miopen_depthwise_convolution_backward(const Tensor & self, const Tensor & grad_output, const Tensor & weight, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic, std::array<bool,3> output_mask);
  static Tensor miopen_depthwise_convolution_backward_weight(IntArrayRef weight_size, const Tensor & grad_output, const Tensor & self, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic);
  static std::tuple<Tensor,Tensor,Tensor,Tensor,Tensor> miopen_rnn(const Tensor & input, TensorList weight, int64_t weight_stride0, const Tensor & hx, const Tensor & cx, int64_t mode, int64_t hidden_size, int64_t num_layers, bool batch_first, double dropout, bool train, bool bidirectional, IntArrayRef batch_sizes, const Tensor & dropout_state);
  static std::tuple<Tensor,Tensor,Tensor,std::vector<Tensor>> miopen_rnn_backward(const Tensor & input, TensorList weight, int64_t weight_stride0, const Tensor & weight_buf, const Tensor & hx, const Tensor & cx, const Tensor & output, const Tensor & grad_output, const Tensor & grad_hy, const Tensor & grad_cy, int64_t mode, int64_t hidden_size, int64_t num_layers, bool batch_first, double dropout, bool train, bool bidirectional, IntArrayRef batch_sizes, const Tensor & dropout_state, const Tensor & reserve, std::array<bool,4> output_mask);
  static Tensor mm(const Tensor & self, const Tensor & mat2);
  static Tensor & mm_out(Tensor & out, const Tensor & self, const Tensor & mat2);
  static Tensor mul(const Tensor & self, const Tensor & other);
  static Tensor & mul_(Tensor & self, const Tensor & other);
  static Tensor & mul_out(Tensor & out, const Tensor & self, const Tensor & other);
  static Tensor mv(const Tensor & self, const Tensor & vec);
  static Tensor & mv_out(Tensor & out, const Tensor & self, const Tensor & vec);
  static Tensor narrow_copy(const Tensor & self, int64_t dim, int64_t start, int64_t length);
  static std::tuple<Tensor,Tensor,Tensor> native_batch_norm(const Tensor & input, const Tensor & weight, const Tensor & bias, const Tensor & running_mean, const Tensor & running_var, bool training, double momentum, double eps);
  static std::tuple<Tensor,Tensor> batch_norm_stats(const Tensor & input, double eps);
  static Tensor batch_norm_elemt(const Tensor & input, const Tensor & weight, const Tensor & bias, const Tensor & mean, const Tensor & invstd, double eps);
  static std::tuple<Tensor,Tensor> batch_norm_gather_stats(const Tensor & input, const Tensor & mean, const Tensor & invstd, const Tensor & running_mean, const Tensor & running_var, double momentum, double eps, int64_t count);
  static std::tuple<Tensor,Tensor> batch_norm_gather_stats_with_counts(const Tensor & input, const Tensor & mean, const Tensor & invstd, const Tensor & running_mean, const Tensor & running_var, double momentum, double eps, IntArrayRef counts);
  static std::tuple<Tensor,Tensor,Tensor> native_batch_norm_backward(const Tensor & grad_out, const Tensor & input, const Tensor & weight, const Tensor & running_mean, const Tensor & running_var, const Tensor & save_mean, const Tensor & save_invstd, bool train, double eps, std::array<bool,3> output_mask);
  static std::tuple<Tensor,Tensor,Tensor,Tensor> batch_norm_backward_reduce(const Tensor & grad_out, const Tensor & input, const Tensor & mean, const Tensor & invstd, bool input_g, bool weight_g, bool bias_g);
  static Tensor batch_norm_backward_elemt(const Tensor & grad_out, const Tensor & input, const Tensor & mean, const Tensor & invstd, const Tensor & weight, const Tensor & mean_dy, const Tensor & mean_dy_xmu);
  static std::tuple<Tensor,Tensor> batch_norm_update_stats(const Tensor & input, const Tensor & running_mean, const Tensor & running_var, double momentum);
  static Tensor & randperm_out(Tensor & out, int64_t n, Generator * generator);
  static Tensor & range_out(Tensor & out, Scalar start, Scalar end, Scalar step);
  static Tensor & reciprocal_(Tensor & self);
  static Tensor & reciprocal_out(Tensor & out, const Tensor & self);
  static Tensor & neg_(Tensor & self);
  static Tensor & neg_out(Tensor & out, const Tensor & self);
  static Tensor repeat_interleave(const Tensor & repeats);
  static Tensor & round_(Tensor & self);
  static Tensor & round_out(Tensor & out, const Tensor & self);
  static Tensor relu(const Tensor & self);
  static Tensor & relu_(Tensor & self);
  static Tensor prelu(const Tensor & self, const Tensor & weight);
  static std::tuple<Tensor,Tensor> prelu_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight);
  static Tensor gelu(const Tensor & self);
  static Tensor gelu_backward(const Tensor & grad, const Tensor & self);
  static Tensor hardshrink(const Tensor & self, Scalar lambd);
  static Tensor hardshrink_backward(const Tensor & grad_out, const Tensor & self, Scalar lambd);
  static Tensor & rsqrt_(Tensor & self);
  static Tensor & rsqrt_out(Tensor & out, const Tensor & self);
  static Tensor sigmoid(const Tensor & self);
  static Tensor & sigmoid_(Tensor & self);
  static Tensor & sigmoid_out(Tensor & out, const Tensor & self);
  static Tensor & sin_(Tensor & self);
  static Tensor & sin_out(Tensor & out, const Tensor & self);
  static Tensor & sinh_(Tensor & self);
  static Tensor & sinh_out(Tensor & out, const Tensor & self);
  static Tensor _softmax(const Tensor & self, int64_t dim, bool half_to_float);
  static Tensor _softmax_backward_data(const Tensor & grad_output, const Tensor & output, int64_t dim, const Tensor & self);
  static Tensor & _sparse_dense_add_out(Tensor & out, const Tensor & self, const Tensor & other, Scalar alpha);
  static Tensor & sspaddmm_out(Tensor & out, const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta, Scalar alpha);
  static Tensor & sqrt_(Tensor & self);
  static Tensor & sqrt_out(Tensor & out, const Tensor & self);
  static Tensor & tan_(Tensor & self);
  static Tensor & tan_out(Tensor & out, const Tensor & self);
  static Tensor & tanh_(Tensor & self);
  static Tensor & tanh_out(Tensor & out, const Tensor & self);
  static Tensor flip(const Tensor & self, IntArrayRef dims);
  static Tensor roll(const Tensor & self, IntArrayRef shifts, IntArrayRef dims);
  static Tensor & trunc_(Tensor & self);
  static Tensor & trunc_out(Tensor & out, const Tensor & self);
  static std::tuple<Tensor,Tensor> _unique(const Tensor & self, bool sorted, bool return_inverse);
  static std::tuple<Tensor,Tensor,Tensor> unique_dim(const Tensor & self, int64_t dim, bool sorted, bool return_inverse, bool return_counts);
  static std::tuple<Tensor,Tensor,Tensor> unique_consecutive(const Tensor & self, bool return_inverse, bool return_counts, c10::optional<int64_t> dim);
  static std::tuple<Tensor,Tensor,Tensor> unique_dim_consecutive(const Tensor & self, int64_t dim, bool return_inverse, bool return_counts);
  static std::tuple<Tensor,Tensor,Tensor> _unique2(const Tensor & self, bool sorted, bool return_inverse, bool return_counts);
  static Tensor _s_where(const Tensor & condition, const Tensor & self, const Tensor & other);
  static std::tuple<Tensor,Tensor> _weight_norm_cuda_interface(const Tensor & v, const Tensor & g, int64_t dim);
  static std::tuple<Tensor,Tensor> _weight_norm_cuda_interface_backward(const Tensor & grad_w, const Tensor & saved_v, const Tensor & saved_g, const Tensor & saved_norms, int64_t dim);
  static Tensor _standard_gamma_grad(const Tensor & self, const Tensor & output);
  static Tensor _standard_gamma(const Tensor & self, Generator * generator);
  static Tensor _dirichlet_grad(const Tensor & x, const Tensor & alpha, const Tensor & total);
  static Tensor _sample_dirichlet(const Tensor & self, Generator * generator);
  static Tensor poisson(const Tensor & self, Generator * generator);
  static Tensor clone(const Tensor & self);
  static Tensor & resize_as_(Tensor & self, const Tensor & the_template);
  static Tensor & pow_out(Tensor & out, const Tensor & self, Scalar exponent);
  static Tensor pow(const Tensor & self, Scalar exponent);
  static Tensor & zero_(Tensor & self);
  static Tensor & s_native_addmm_out(Tensor & out, const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta, Scalar alpha);
  static Tensor s_native_addmm(const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta, Scalar alpha);
  static Tensor & s_native_addmm_(Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta, Scalar alpha);
  static Tensor sparse_mask(const Tensor & self, const Tensor & mask);
  static Tensor to_sparse(const Tensor & self, int64_t sparse_dim);
  static Tensor to_sparse(const Tensor & self);
  static Tensor fake_quantize_per_tensor_affine(const Tensor & self, double scale, int64_t zero_point, int64_t quant_min, int64_t quant_max);
  static Tensor fake_quantize_per_tensor_affine_backward(const Tensor & grad, const Tensor & self, double scale, int64_t zero_point, int64_t quant_min, int64_t quant_max);
  static Scalar _local_scalar_dense(const Tensor & self);
  static std::tuple<Tensor,Tensor,Tensor> _thnn_fused_lstm_cell(const Tensor & input_gates, const Tensor & hidden_gates, const Tensor & cx, const Tensor & input_bias, const Tensor & hidden_bias);
  static std::tuple<Tensor,Tensor,Tensor,Tensor,Tensor> _thnn_fused_lstm_cell_backward(const Tensor & grad_hy, const Tensor & grad_cy, const Tensor & cx, const Tensor & cy, const Tensor & workspace, bool has_bias);
  static std::tuple<Tensor,Tensor> _thnn_fused_gru_cell(const Tensor & input_gates, const Tensor & hidden_gates, const Tensor & hx, const Tensor & input_bias, const Tensor & hidden_bias);
  static std::tuple<Tensor,Tensor,Tensor,Tensor,Tensor> _thnn_fused_gru_cell_backward(const Tensor & grad_hy, const Tensor & workspace, bool has_bias);
  static Tensor & set_(Tensor & self, Storage source);
  static Tensor & set_(Tensor & self, Storage source, int64_t storage_offset, IntArrayRef size, IntArrayRef stride);
  static Tensor & set_(Tensor & self, const Tensor & source);
  static Tensor & set_(Tensor & self);
  static bool is_set_to(const Tensor & self, const Tensor & tensor);
  static Tensor & masked_fill_(Tensor & self, const Tensor & mask, Scalar value);
  static Tensor & masked_fill_(Tensor & self, const Tensor & mask, const Tensor & value);
  static Tensor & masked_scatter_(Tensor & self, const Tensor & mask, const Tensor & source);
  static Tensor view(const Tensor & self, IntArrayRef size);
  static Tensor & put_(Tensor & self, const Tensor & index, const Tensor & source, bool accumulate);
  static Tensor & index_add_(Tensor & self, int64_t dim, const Tensor & index, const Tensor & source);
  static Tensor & index_fill_(Tensor & self, int64_t dim, const Tensor & index, Scalar value);
  static Tensor & index_fill_(Tensor & self, int64_t dim, const Tensor & index, const Tensor & value);
  static Tensor & scatter_(Tensor & self, int64_t dim, const Tensor & index, const Tensor & src);
  static Tensor & scatter_(Tensor & self, int64_t dim, const Tensor & index, Scalar value);
  static Tensor & scatter_add_(Tensor & self, int64_t dim, const Tensor & index, const Tensor & src);
  static Tensor & lt_(Tensor & self, Scalar other);
  static Tensor & lt_(Tensor & self, const Tensor & other);
  static Tensor & gt_(Tensor & self, Scalar other);
  static Tensor & gt_(Tensor & self, const Tensor & other);
  static Tensor & le_(Tensor & self, Scalar other);
  static Tensor & le_(Tensor & self, const Tensor & other);
  static Tensor & ge_(Tensor & self, Scalar other);
  static Tensor & ge_(Tensor & self, const Tensor & other);
  static Tensor & eq_(Tensor & self, Scalar other);
  static Tensor & eq_(Tensor & self, const Tensor & other);
  static Tensor & ne_(Tensor & self, Scalar other);
  static Tensor & ne_(Tensor & self, const Tensor & other);
  static Tensor __and__(const Tensor & self, Scalar other);
  static Tensor __and__(const Tensor & self, const Tensor & other);
  static Tensor & __iand__(Tensor & self, Scalar other);
  static Tensor & __iand__(Tensor & self, const Tensor & other);
  static Tensor __or__(const Tensor & self, Scalar other);
  static Tensor __or__(const Tensor & self, const Tensor & other);
  static Tensor & __ior__(Tensor & self, Scalar other);
  static Tensor & __ior__(Tensor & self, const Tensor & other);
  static Tensor __xor__(const Tensor & self, Scalar other);
  static Tensor __xor__(const Tensor & self, const Tensor & other);
  static Tensor & __ixor__(Tensor & self, Scalar other);
  static Tensor & __ixor__(Tensor & self, const Tensor & other);
  static Tensor __lshift__(const Tensor & self, Scalar other);
  static Tensor __lshift__(const Tensor & self, const Tensor & other);
  static Tensor & __ilshift__(Tensor & self, Scalar other);
  static Tensor & __ilshift__(Tensor & self, const Tensor & other);
  static Tensor __rshift__(const Tensor & self, Scalar other);
  static Tensor __rshift__(const Tensor & self, const Tensor & other);
  static Tensor & __irshift__(Tensor & self, Scalar other);
  static Tensor & __irshift__(Tensor & self, const Tensor & other);
  static Tensor & lgamma_(Tensor & self);
  static Tensor & atan2_(Tensor & self, const Tensor & other);
  static Tensor & tril_(Tensor & self, int64_t diagonal);
  static Tensor & triu_(Tensor & self, int64_t diagonal);
  static Tensor & digamma_(Tensor & self);
  static Tensor & polygamma_(Tensor & self, int64_t n);
  static Tensor & erfinv_(Tensor & self);
  static Tensor & renorm_(Tensor & self, Scalar p, int64_t dim, Scalar maxnorm);
  static Tensor & pow_(Tensor & self, Scalar exponent);
  static Tensor & pow_(Tensor & self, const Tensor & exponent);
  static Tensor & lerp_(Tensor & self, const Tensor & end, Scalar weight);
  static Tensor & lerp_(Tensor & self, const Tensor & end, const Tensor & weight);
  static Tensor & sign_(Tensor & self);
  static Tensor & fmod_(Tensor & self, Scalar other);
  static Tensor & fmod_(Tensor & self, const Tensor & other);
  static Tensor & remainder_(Tensor & self, Scalar other);
  static Tensor & remainder_(Tensor & self, const Tensor & other);
  static Tensor & addbmm_(Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta, Scalar alpha);
  static Tensor & addbmm_out(Tensor & out, const Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta, Scalar alpha);
  static Tensor addbmm(const Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta, Scalar alpha);
  static Tensor & addcmul_(Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value);
  static Tensor & addcdiv_(Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value);
  static Tensor & random_(Tensor & self, int64_t from, int64_t to, Generator * generator);
  static Tensor & random_(Tensor & self, int64_t to, Generator * generator);
  static Tensor & random_(Tensor & self, Generator * generator);
  static Tensor & uniform_(Tensor & self, double from, double to, Generator * generator);
  static Tensor & normal_(Tensor & self, double mean, double std, Generator * generator);
  static Tensor & cauchy_(Tensor & self, double median, double sigma, Generator * generator);
  static Tensor & log_normal_(Tensor & self, double mean, double std, Generator * generator);
  static Tensor & exponential_(Tensor & self, double lambd, Generator * generator);
  static Tensor & geometric_(Tensor & self, double p, Generator * generator);
  static Tensor & diag_out(Tensor & out, const Tensor & self, int64_t diagonal);
  static Tensor diag(const Tensor & self, int64_t diagonal);
  static Tensor & triu_out(Tensor & out, const Tensor & self, int64_t diagonal);
  static Tensor & tril_out(Tensor & out, const Tensor & self, int64_t diagonal);
  static Tensor tril_indices(int64_t row, int64_t col, int64_t offset, const TensorOptions & options);
  static Tensor triu_indices(int64_t row, int64_t col, int64_t offset, const TensorOptions & options);
  static Tensor trace(const Tensor & self);
  static Tensor & ne_out(Tensor & out, const Tensor & self, Scalar other);
  static Tensor ne(const Tensor & self, Scalar other);
  static Tensor & ne_out(Tensor & out, const Tensor & self, const Tensor & other);
  static Tensor ne(const Tensor & self, const Tensor & other);
  static Tensor & eq_out(Tensor & out, const Tensor & self, Scalar other);
  static Tensor eq(const Tensor & self, Scalar other);
  static Tensor & eq_out(Tensor & out, const Tensor & self, const Tensor & other);
  static Tensor eq(const Tensor & self, const Tensor & other);
  static Tensor & ge_out(Tensor & out, const Tensor & self, Scalar other);
  static Tensor ge(const Tensor & self, Scalar other);
  static Tensor & ge_out(Tensor & out, const Tensor & self, const Tensor & other);
  static Tensor ge(const Tensor & self, const Tensor & other);
  static Tensor & le_out(Tensor & out, const Tensor & self, Scalar other);
  static Tensor le(const Tensor & self, Scalar other);
  static Tensor & le_out(Tensor & out, const Tensor & self, const Tensor & other);
  static Tensor le(const Tensor & self, const Tensor & other);
  static Tensor & gt_out(Tensor & out, const Tensor & self, Scalar other);
  static Tensor gt(const Tensor & self, Scalar other);
  static Tensor & gt_out(Tensor & out, const Tensor & self, const Tensor & other);
  static Tensor gt(const Tensor & self, const Tensor & other);
  static Tensor & lt_out(Tensor & out, const Tensor & self, Scalar other);
  static Tensor lt(const Tensor & self, Scalar other);
  static Tensor & lt_out(Tensor & out, const Tensor & self, const Tensor & other);
  static Tensor lt(const Tensor & self, const Tensor & other);
  static Tensor & take_out(Tensor & out, const Tensor & self, const Tensor & index);
  static Tensor take(const Tensor & self, const Tensor & index);
  static Tensor & index_select_out(Tensor & out, const Tensor & self, int64_t dim, const Tensor & index);
  static Tensor index_select(const Tensor & self, int64_t dim, const Tensor & index);
  static Tensor & masked_select_out(Tensor & out, const Tensor & self, const Tensor & mask);
  static Tensor masked_select(const Tensor & self, const Tensor & mask);
  static Tensor & nonzero_out(Tensor & out, const Tensor & self);
  static Tensor nonzero(const Tensor & self);
  static Tensor & gather_out(Tensor & out, const Tensor & self, int64_t dim, const Tensor & index, bool sparse_grad);
  static Tensor gather(const Tensor & self, int64_t dim, const Tensor & index, bool sparse_grad);
  static Tensor & addcmul_out(Tensor & out, const Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value);
  static Tensor addcmul(const Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value);
  static Tensor & addcdiv_out(Tensor & out, const Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value);
  static Tensor addcdiv(const Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value);
  static std::tuple<Tensor &,Tensor &> lstsq_out(Tensor & X, Tensor & qr, const Tensor & self, const Tensor & A);
  static std::tuple<Tensor,Tensor> lstsq(const Tensor & self, const Tensor & A);
  static std::tuple<Tensor,Tensor> _triangular_solve_helper(const Tensor & self, const Tensor & A, bool upper, bool transpose, bool unitriangular);
  static std::tuple<Tensor,Tensor> _symeig_helper(const Tensor & self, bool eigenvectors, bool upper);
  static std::tuple<Tensor &,Tensor &> eig_out(Tensor & e, Tensor & v, const Tensor & self, bool eigenvectors);
  static std::tuple<Tensor,Tensor> eig(const Tensor & self, bool eigenvectors);
  static std::tuple<Tensor,Tensor,Tensor> _svd_helper(const Tensor & self, bool some, bool compute_uv);
  static Tensor _cholesky_helper(const Tensor & self, bool upper);
  static Tensor _cholesky_solve_helper(const Tensor & self, const Tensor & A, bool upper);
  static std::tuple<Tensor,Tensor> _solve_helper(const Tensor & self, const Tensor & A);
  static Tensor & cholesky_inverse_out(Tensor & out, const Tensor & self, bool upper);
  static Tensor cholesky_inverse(const Tensor & self, bool upper);
  static std::tuple<Tensor,Tensor> _qr_helper(const Tensor & self, bool some);
  static std::tuple<Tensor &,Tensor &> geqrf_out(Tensor & a, Tensor & tau, const Tensor & self);
  static std::tuple<Tensor,Tensor> geqrf(const Tensor & self);
  static std::tuple<Tensor,Tensor,Tensor> _lu_with_info(const Tensor & self, bool pivot, bool check_errors);
  static Tensor _lu_solve_helper(const Tensor & self, const Tensor & LU_data, const Tensor & LU_pivots);
  static Tensor & multinomial_out(Tensor & out, const Tensor & self, int64_t num_samples, bool replacement, Generator * generator);
  static Tensor multinomial(const Tensor & self, int64_t num_samples, bool replacement, Generator * generator);
  static std::tuple<Tensor,Tensor> _multinomial_alias_setup(const Tensor & probs);
  static Tensor _multinomial_alias_draw(const Tensor & J, const Tensor & q, int64_t num_samples, Generator * generator);
  static Tensor & lgamma_out(Tensor & out, const Tensor & self);
  static Tensor lgamma(const Tensor & self);
  static Tensor & digamma_out(Tensor & out, const Tensor & self);
  static Tensor digamma(const Tensor & self);
  static Tensor & polygamma_out(Tensor & out, int64_t n, const Tensor & self);
  static Tensor polygamma(int64_t n, const Tensor & self);
  static Tensor & erfinv_out(Tensor & out, const Tensor & self);
  static Tensor erfinv(const Tensor & self);
  static Tensor dist(const Tensor & self, const Tensor & other, Scalar p);
  static Tensor & atan2_out(Tensor & out, const Tensor & self, const Tensor & other);
  static Tensor atan2(const Tensor & self, const Tensor & other);
  static Tensor & lerp_out(Tensor & out, const Tensor & self, const Tensor & end, Scalar weight);
  static Tensor & lerp_out(Tensor & out, const Tensor & self, const Tensor & end, const Tensor & weight);
  static Tensor lerp(const Tensor & self, const Tensor & end, Scalar weight);
  static Tensor lerp(const Tensor & self, const Tensor & end, const Tensor & weight);
  static Tensor & histc_out(Tensor & out, const Tensor & self, int64_t bins, Scalar min, Scalar max);
  static Tensor histc(const Tensor & self, int64_t bins, Scalar min, Scalar max);
  static Tensor & sign_out(Tensor & out, const Tensor & self);
  static Tensor sign(const Tensor & self);
  static Tensor & fmod_out(Tensor & out, const Tensor & self, Scalar other);
  static Tensor fmod(const Tensor & self, Scalar other);
  static Tensor & fmod_out(Tensor & out, const Tensor & self, const Tensor & other);
  static Tensor fmod(const Tensor & self, const Tensor & other);
  static Tensor & remainder_out(Tensor & out, const Tensor & self, Scalar other);
  static Tensor remainder(const Tensor & self, Scalar other);
  static Tensor & remainder_out(Tensor & out, const Tensor & self, const Tensor & other);
  static Tensor remainder(const Tensor & self, const Tensor & other);
  static Tensor & min_out(Tensor & out, const Tensor & self, const Tensor & other);
  static Tensor min(const Tensor & self, const Tensor & other);
  static Tensor min(const Tensor & self);
  static Tensor & max_out(Tensor & out, const Tensor & self, const Tensor & other);
  static Tensor max(const Tensor & self, const Tensor & other);
  static Tensor max(const Tensor & self);
  static Tensor median(const Tensor & self);
  static std::tuple<Tensor &,Tensor &> sort_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t dim, bool descending);
  static std::tuple<Tensor,Tensor> sort(const Tensor & self, int64_t dim, bool descending);
  static std::tuple<Tensor &,Tensor &> topk_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t k, int64_t dim, bool largest, bool sorted);
  static Tensor & renorm_out(Tensor & out, const Tensor & self, Scalar p, int64_t dim, Scalar maxnorm);
  static Tensor renorm(const Tensor & self, Scalar p, int64_t dim, Scalar maxnorm);
  static Tensor unfold(const Tensor & self, int64_t dimension, int64_t size, int64_t step);
  static bool equal(const Tensor & self, const Tensor & other);
  static Tensor & pow_out(Tensor & out, const Tensor & self, const Tensor & exponent);
  static Tensor pow(const Tensor & self, const Tensor & exponent);
  static Tensor & pow_out(Tensor & out, Scalar self, const Tensor & exponent);
  static Tensor pow(Scalar self, const Tensor & exponent);
  static Tensor & normal_out(Tensor & out, const Tensor & mean, double std, Generator * generator);
  static Tensor normal(const Tensor & mean, double std, Generator * generator);
  static Tensor & normal_out(Tensor & out, double mean, const Tensor & std, Generator * generator);
  static Tensor normal(double mean, const Tensor & std, Generator * generator);
  static Tensor & normal_out(Tensor & out, const Tensor & mean, const Tensor & std, Generator * generator);
  static Tensor normal(const Tensor & mean, const Tensor & std, Generator * generator);
  static Tensor _addr(const Tensor & self, const Tensor & vec1, const Tensor & vec2, Scalar beta, Scalar alpha);
  static Tensor & _addr_(Tensor & self, const Tensor & vec1, const Tensor & vec2, Scalar beta, Scalar alpha);
  static Tensor & _addr_out(Tensor & out, const Tensor & self, const Tensor & vec1, const Tensor & vec2, Scalar beta, Scalar alpha);
  static Tensor & _index_copy_(Tensor & self, int64_t dim, const Tensor & index, const Tensor & source);
  static Tensor _cumsum(const Tensor & self, int64_t dim);
  static Tensor & _cumsum_out(Tensor & out, const Tensor & self, int64_t dim);
  static Tensor _cumprod(const Tensor & self, int64_t dim);
  static Tensor & _cumprod_out(Tensor & out, const Tensor & self, int64_t dim);
  static Tensor _var(const Tensor & self, bool unbiased);
  static Tensor _std(const Tensor & self, bool unbiased);
  static Tensor & _addmm_out(Tensor & out, const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta, Scalar alpha);
  static Tensor _addmm(const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta, Scalar alpha);
  static Tensor & _addmm_(Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta, Scalar alpha);
  static Tensor _cat(TensorList tensors, int64_t dim);
  static Tensor & _cat_out(Tensor & out, TensorList tensors, int64_t dim);
  static std::tuple<Tensor,Tensor> _mode(const Tensor & self, int64_t dim, bool keepdim);
  static std::tuple<Tensor &,Tensor &> _mode_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t dim, bool keepdim);
  static std::tuple<Tensor,Tensor> _max(const Tensor & self, int64_t dim, bool keepdim);
  static std::tuple<Tensor &,Tensor &> _max_out(Tensor & max, Tensor & max_indices, const Tensor & self, int64_t dim, bool keepdim);
  static std::tuple<Tensor,Tensor> _min(const Tensor & self, int64_t dim, bool keepdim);
  static std::tuple<Tensor &,Tensor &> _min_out(Tensor & min, Tensor & min_indices, const Tensor & self, int64_t dim, bool keepdim);
  static Tensor & binary_cross_entropy_out(Tensor & out, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction);
  static Tensor binary_cross_entropy(const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction);
  static Tensor & binary_cross_entropy_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction);
  static Tensor binary_cross_entropy_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction);
  static Tensor & mse_loss_out(Tensor & out, const Tensor & self, const Tensor & target, int64_t reduction);
  static Tensor mse_loss(const Tensor & self, const Tensor & target, int64_t reduction);
  static Tensor & mse_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction);
  static Tensor mse_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction);
  static Tensor & l1_loss_out(Tensor & out, const Tensor & self, const Tensor & target, int64_t reduction);
  static Tensor l1_loss(const Tensor & self, const Tensor & target, int64_t reduction);
  static Tensor & l1_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction);
  static Tensor l1_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction);
  static Tensor & multi_margin_loss_out(Tensor & out, const Tensor & self, const Tensor & target, Scalar p, Scalar margin, const Tensor & weight, int64_t reduction);
  static Tensor multi_margin_loss(const Tensor & self, const Tensor & target, Scalar p, Scalar margin, const Tensor & weight, int64_t reduction);
  static Tensor & multi_margin_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, Scalar p, Scalar margin, const Tensor & weight, int64_t reduction);
  static Tensor multi_margin_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, Scalar p, Scalar margin, const Tensor & weight, int64_t reduction);
  static std::tuple<Tensor &,Tensor &> multilabel_margin_loss_forward_out(Tensor & output, Tensor & is_target, const Tensor & self, const Tensor & target, int64_t reduction);
  static std::tuple<Tensor,Tensor> multilabel_margin_loss_forward(const Tensor & self, const Tensor & target, int64_t reduction);
  static Tensor & multilabel_margin_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction, const Tensor & is_target);
  static Tensor multilabel_margin_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction, const Tensor & is_target);
  static std::tuple<Tensor &,Tensor &> nll_loss_forward_out(Tensor & output, Tensor & total_weight, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index);
  static std::tuple<Tensor,Tensor> nll_loss_forward(const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index);
  static Tensor & nll_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index, const Tensor & total_weight);
  static Tensor nll_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index, const Tensor & total_weight);
  static std::tuple<Tensor &,Tensor &> nll_loss2d_forward_out(Tensor & output, Tensor & total_weight, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index);
  static std::tuple<Tensor,Tensor> nll_loss2d_forward(const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index);
  static Tensor & nll_loss2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index, const Tensor & total_weight);
  static Tensor nll_loss2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index, const Tensor & total_weight);
  static Tensor & smooth_l1_loss_out(Tensor & out, const Tensor & self, const Tensor & target, int64_t reduction);
  static Tensor smooth_l1_loss(const Tensor & self, const Tensor & target, int64_t reduction);
  static Tensor & smooth_l1_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction);
  static Tensor smooth_l1_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction);
  static Tensor & soft_margin_loss_out(Tensor & out, const Tensor & self, const Tensor & target, int64_t reduction);
  static Tensor soft_margin_loss(const Tensor & self, const Tensor & target, int64_t reduction);
  static Tensor & soft_margin_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction);
  static Tensor soft_margin_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction);
  static Tensor & elu_out(Tensor & out, const Tensor & self, Scalar alpha, Scalar scale, Scalar input_scale);
  static Tensor elu(const Tensor & self, Scalar alpha, Scalar scale, Scalar input_scale);
  static Tensor & elu_backward_out(Tensor & grad_input, const Tensor & grad_output, Scalar alpha, Scalar scale, Scalar input_scale, const Tensor & output);
  static Tensor elu_backward(const Tensor & grad_output, Scalar alpha, Scalar scale, Scalar input_scale, const Tensor & output);
  static Tensor & elu_(Tensor & self, Scalar alpha, Scalar scale, Scalar input_scale);
  static Tensor & glu_out(Tensor & out, const Tensor & self, int64_t dim);
  static Tensor glu(const Tensor & self, int64_t dim);
  static Tensor & glu_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, int64_t dim);
  static Tensor glu_backward(const Tensor & grad_output, const Tensor & self, int64_t dim);
  static Tensor & hardtanh_out(Tensor & out, const Tensor & self, Scalar min_val, Scalar max_val);
  static Tensor hardtanh(const Tensor & self, Scalar min_val, Scalar max_val);
  static Tensor & hardtanh_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, Scalar min_val, Scalar max_val);
  static Tensor hardtanh_backward(const Tensor & grad_output, const Tensor & self, Scalar min_val, Scalar max_val);
  static Tensor & hardtanh_(Tensor & self, Scalar min_val, Scalar max_val);
  static Tensor & leaky_relu_out(Tensor & out, const Tensor & self, Scalar negative_slope);
  static Tensor leaky_relu(const Tensor & self, Scalar negative_slope);
  static Tensor & leaky_relu_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, Scalar negative_slope);
  static Tensor leaky_relu_backward(const Tensor & grad_output, const Tensor & self, Scalar negative_slope);
  static Tensor & leaky_relu_(Tensor & self, Scalar negative_slope);
  static std::tuple<Tensor &,Tensor &> log_sigmoid_forward_out(Tensor & output, Tensor & buffer, const Tensor & self);
  static std::tuple<Tensor,Tensor> log_sigmoid_forward(const Tensor & self);
  static Tensor & log_sigmoid_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & buffer);
  static Tensor log_sigmoid_backward(const Tensor & grad_output, const Tensor & self, const Tensor & buffer);
  static Tensor & rrelu_with_noise_out(Tensor & out, const Tensor & self, const Tensor & noise, Scalar lower, Scalar upper, bool training, Generator * generator);
  static Tensor rrelu_with_noise(const Tensor & self, const Tensor & noise, Scalar lower, Scalar upper, bool training, Generator * generator);
  static Tensor & rrelu_with_noise_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & noise, Scalar lower, Scalar upper, bool training);
  static Tensor rrelu_with_noise_backward(const Tensor & grad_output, const Tensor & self, const Tensor & noise, Scalar lower, Scalar upper, bool training);
  static Tensor & rrelu_with_noise_(Tensor & self, const Tensor & noise, Scalar lower, Scalar upper, bool training, Generator * generator);
  static Tensor & softplus_out(Tensor & out, const Tensor & self, Scalar beta, Scalar threshold);
  static Tensor softplus(const Tensor & self, Scalar beta, Scalar threshold);
  static Tensor & softplus_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, Scalar beta, Scalar threshold, const Tensor & output);
  static Tensor softplus_backward(const Tensor & grad_output, const Tensor & self, Scalar beta, Scalar threshold, const Tensor & output);
  static Tensor & softshrink_out(Tensor & out, const Tensor & self, Scalar lambd);
  static Tensor softshrink(const Tensor & self, Scalar lambd);
  static Tensor & softshrink_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, Scalar lambd);
  static Tensor softshrink_backward(const Tensor & grad_output, const Tensor & self, Scalar lambd);
  static Tensor & adaptive_avg_pool2d_out(Tensor & out, const Tensor & self, IntArrayRef output_size);
  static Tensor _adaptive_avg_pool2d(const Tensor & self, IntArrayRef output_size);
  static Tensor _adaptive_avg_pool2d_backward(const Tensor & grad_output, const Tensor & self);
  static Tensor & adaptive_avg_pool3d_out(Tensor & out, const Tensor & self, IntArrayRef output_size);
  static Tensor adaptive_avg_pool3d(const Tensor & self, IntArrayRef output_size);
  static Tensor & adaptive_avg_pool3d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self);
  static Tensor adaptive_avg_pool3d_backward(const Tensor & grad_output, const Tensor & self);
  static std::tuple<Tensor &,Tensor &> adaptive_max_pool2d_out(Tensor & out, Tensor & indices, const Tensor & self, IntArrayRef output_size);
  static std::tuple<Tensor,Tensor> adaptive_max_pool2d(const Tensor & self, IntArrayRef output_size);
  static Tensor & adaptive_max_pool2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & indices);
  static Tensor adaptive_max_pool2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & indices);
  static std::tuple<Tensor &,Tensor &> adaptive_max_pool3d_out(Tensor & out, Tensor & indices, const Tensor & self, IntArrayRef output_size);
  static std::tuple<Tensor,Tensor> adaptive_max_pool3d(const Tensor & self, IntArrayRef output_size);
  static Tensor & adaptive_max_pool3d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & indices);
  static Tensor adaptive_max_pool3d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & indices);
  static Tensor & avg_pool2d_out(Tensor & out, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad, c10::optional<int64_t> divisor_override);
  static Tensor avg_pool2d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad, c10::optional<int64_t> divisor_override);
  static Tensor & avg_pool2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad, c10::optional<int64_t> divisor_override);
  static Tensor avg_pool2d_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad, c10::optional<int64_t> divisor_override);
  static Tensor & avg_pool3d_out(Tensor & out, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad, c10::optional<int64_t> divisor_override);
  static Tensor avg_pool3d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad, c10::optional<int64_t> divisor_override);
  static Tensor & avg_pool3d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad, c10::optional<int64_t> divisor_override);
  static Tensor avg_pool3d_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad, c10::optional<int64_t> divisor_override);
  static std::tuple<Tensor &,Tensor &> fractional_max_pool2d_out(Tensor & output, Tensor & indices, const Tensor & self, IntArrayRef kernel_size, IntArrayRef output_size, const Tensor & random_samples);
  static std::tuple<Tensor,Tensor> fractional_max_pool2d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef output_size, const Tensor & random_samples);
  static Tensor & fractional_max_pool2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef output_size, const Tensor & indices);
  static Tensor fractional_max_pool2d_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef output_size, const Tensor & indices);
  static std::tuple<Tensor &,Tensor &> fractional_max_pool3d_out(Tensor & output, Tensor & indices, const Tensor & self, IntArrayRef kernel_size, IntArrayRef output_size, const Tensor & random_samples);
  static std::tuple<Tensor,Tensor> fractional_max_pool3d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef output_size, const Tensor & random_samples);
  static Tensor & fractional_max_pool3d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef output_size, const Tensor & indices);
  static Tensor fractional_max_pool3d_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef output_size, const Tensor & indices);
  static std::tuple<Tensor &,Tensor &> max_pool2d_with_indices_out(Tensor & out, Tensor & indices, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode);
  static std::tuple<Tensor,Tensor> max_pool2d_with_indices(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode);
  static Tensor & max_pool2d_with_indices_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode, const Tensor & indices);
  static Tensor max_pool2d_with_indices_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode, const Tensor & indices);
  static std::tuple<Tensor &,Tensor &> max_pool3d_with_indices_out(Tensor & out, Tensor & indices, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode);
  static std::tuple<Tensor,Tensor> max_pool3d_with_indices(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode);
  static Tensor & max_pool3d_with_indices_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode, const Tensor & indices);
  static Tensor max_pool3d_with_indices_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode, const Tensor & indices);
  static Tensor & max_unpool2d_out(Tensor & out, const Tensor & self, const Tensor & indices, IntArrayRef output_size);
  static Tensor max_unpool2d(const Tensor & self, const Tensor & indices, IntArrayRef output_size);
  static Tensor & max_unpool2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & indices, IntArrayRef output_size);
  static Tensor max_unpool2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & indices, IntArrayRef output_size);
  static Tensor & max_unpool3d_out(Tensor & out, const Tensor & self, const Tensor & indices, IntArrayRef output_size, IntArrayRef stride, IntArrayRef padding);
  static Tensor max_unpool3d(const Tensor & self, const Tensor & indices, IntArrayRef output_size, IntArrayRef stride, IntArrayRef padding);
  static Tensor & max_unpool3d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & indices, IntArrayRef output_size, IntArrayRef stride, IntArrayRef padding);
  static Tensor max_unpool3d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & indices, IntArrayRef output_size, IntArrayRef stride, IntArrayRef padding);
  static Tensor & reflection_pad1d_out(Tensor & out, const Tensor & self, IntArrayRef padding);
  static Tensor reflection_pad1d(const Tensor & self, IntArrayRef padding);
  static Tensor & reflection_pad1d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef padding);
  static Tensor reflection_pad1d_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef padding);
  static Tensor & reflection_pad2d_out(Tensor & out, const Tensor & self, IntArrayRef padding);
  static Tensor reflection_pad2d(const Tensor & self, IntArrayRef padding);
  static Tensor & reflection_pad2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef padding);
  static Tensor reflection_pad2d_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef padding);
  static Tensor & replication_pad1d_out(Tensor & out, const Tensor & self, IntArrayRef padding);
  static Tensor replication_pad1d(const Tensor & self, IntArrayRef padding);
  static Tensor & replication_pad1d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef padding);
  static Tensor replication_pad1d_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef padding);
  static Tensor & replication_pad2d_out(Tensor & out, const Tensor & self, IntArrayRef padding);
  static Tensor replication_pad2d(const Tensor & self, IntArrayRef padding);
  static Tensor & replication_pad2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef padding);
  static Tensor replication_pad2d_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef padding);
  static Tensor & replication_pad3d_out(Tensor & out, const Tensor & self, IntArrayRef padding);
  static Tensor replication_pad3d(const Tensor & self, IntArrayRef padding);
  static Tensor & replication_pad3d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntArrayRef padding);
  static Tensor replication_pad3d_backward(const Tensor & grad_output, const Tensor & self, IntArrayRef padding);
  static Tensor & upsample_linear1d_out(Tensor & out, const Tensor & self, IntArrayRef output_size, bool align_corners);
  static Tensor upsample_linear1d(const Tensor & self, IntArrayRef output_size, bool align_corners);
  static Tensor & upsample_linear1d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners);
  static Tensor upsample_linear1d_backward(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners);
  static Tensor & upsample_bilinear2d_out(Tensor & out, const Tensor & self, IntArrayRef output_size, bool align_corners);
  static Tensor upsample_bilinear2d(const Tensor & self, IntArrayRef output_size, bool align_corners);
  static Tensor & upsample_bilinear2d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners);
  static Tensor upsample_bilinear2d_backward(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners);
  static Tensor & upsample_bicubic2d_out(Tensor & out, const Tensor & self, IntArrayRef output_size, bool align_corners);
  static Tensor upsample_bicubic2d(const Tensor & self, IntArrayRef output_size, bool align_corners);
  static Tensor & upsample_bicubic2d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners);
  static Tensor upsample_bicubic2d_backward(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners);
  static Tensor & upsample_trilinear3d_out(Tensor & out, const Tensor & self, IntArrayRef output_size, bool align_corners);
  static Tensor upsample_trilinear3d(const Tensor & self, IntArrayRef output_size, bool align_corners);
  static Tensor & upsample_trilinear3d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners);
  static Tensor upsample_trilinear3d_backward(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size, bool align_corners);
  static Tensor & upsample_nearest1d_out(Tensor & out, const Tensor & self, IntArrayRef output_size);
  static Tensor upsample_nearest1d(const Tensor & self, IntArrayRef output_size);
  static Tensor & upsample_nearest1d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size);
  static Tensor upsample_nearest1d_backward(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size);
  static Tensor & upsample_nearest2d_out(Tensor & out, const Tensor & self, IntArrayRef output_size);
  static Tensor upsample_nearest2d(const Tensor & self, IntArrayRef output_size);
  static Tensor & upsample_nearest2d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size);
  static Tensor upsample_nearest2d_backward(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size);
  static Tensor & upsample_nearest3d_out(Tensor & out, const Tensor & self, IntArrayRef output_size);
  static Tensor upsample_nearest3d(const Tensor & self, IntArrayRef output_size);
  static Tensor & upsample_nearest3d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size);
  static Tensor upsample_nearest3d_backward(const Tensor & grad_output, IntArrayRef output_size, IntArrayRef input_size);
  static Tensor & sigmoid_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & output);
  static Tensor sigmoid_backward(const Tensor & grad_output, const Tensor & output);
  static Tensor & tanh_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & output);
  static Tensor tanh_backward(const Tensor & grad_output, const Tensor & output);
  static Tensor & conv_transpose2d_out(Tensor & out, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation);
  static Tensor conv_transpose2d(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation);
  static std::tuple<Tensor &,Tensor &,Tensor &> conv_transpose2d_backward_out(Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation, const Tensor & columns, const Tensor & ones);
  static std::tuple<Tensor,Tensor,Tensor> conv_transpose2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation, const Tensor & columns, const Tensor & ones, std::array<bool,3> output_mask);
  static Tensor & conv_transpose3d_out(Tensor & out, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation);
  static Tensor conv_transpose3d(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation);
  static std::tuple<Tensor &,Tensor &,Tensor &> conv_transpose3d_backward_out(Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation, const Tensor & finput, const Tensor & fgrad_input);
  static std::tuple<Tensor,Tensor,Tensor> conv_transpose3d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef output_padding, IntArrayRef dilation, const Tensor & finput, const Tensor & fgrad_input, std::array<bool,3> output_mask);
  static std::tuple<Tensor &,Tensor &,Tensor &> thnn_conv2d_forward_out(Tensor & output, Tensor & finput, Tensor & fgrad_input, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding);
  static std::tuple<Tensor,Tensor,Tensor> thnn_conv2d_forward(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding);
  static std::tuple<Tensor &,Tensor &,Tensor &> thnn_conv2d_backward_out(Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, const Tensor & finput, const Tensor & fgrad_input);
  static std::tuple<Tensor,Tensor,Tensor> thnn_conv2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, const Tensor & finput, const Tensor & fgrad_input, std::array<bool,3> output_mask);
  static Tensor & thnn_conv_depthwise2d_forward_out(Tensor & out, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation);
  static Tensor thnn_conv_depthwise2d_forward(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation);
  static std::tuple<Tensor &,Tensor &> thnn_conv_depthwise2d_backward_out(Tensor & grad_input, Tensor & grad_weight, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation);
  static std::tuple<Tensor,Tensor> thnn_conv_depthwise2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, std::array<bool,2> output_mask);
  static Tensor conv_dilated2d(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation);
  static std::tuple<Tensor,Tensor,Tensor> conv_dilated2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, std::array<bool,3> output_mask);
  static Tensor conv_dilated3d(const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, const Tensor & bias, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation);
  static std::tuple<Tensor,Tensor,Tensor> conv_dilated3d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, std::array<bool,3> output_mask);
  static Tensor & col2im_out(Tensor & out, const Tensor & self, IntArrayRef output_size, IntArrayRef kernel_size, IntArrayRef dilation, IntArrayRef padding, IntArrayRef stride);
  static Tensor col2im(const Tensor & self, IntArrayRef output_size, IntArrayRef kernel_size, IntArrayRef dilation, IntArrayRef padding, IntArrayRef stride);
  static Tensor & col2im_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef kernel_size, IntArrayRef dilation, IntArrayRef padding, IntArrayRef stride);
  static Tensor col2im_backward(const Tensor & grad_output, IntArrayRef kernel_size, IntArrayRef dilation, IntArrayRef padding, IntArrayRef stride);
  static Tensor & im2col_out(Tensor & out, const Tensor & self, IntArrayRef kernel_size, IntArrayRef dilation, IntArrayRef padding, IntArrayRef stride);
  static Tensor im2col(const Tensor & self, IntArrayRef kernel_size, IntArrayRef dilation, IntArrayRef padding, IntArrayRef stride);
  static Tensor & im2col_backward_out(Tensor & grad_input, const Tensor & grad_output, IntArrayRef input_size, IntArrayRef kernel_size, IntArrayRef dilation, IntArrayRef padding, IntArrayRef stride);
  static Tensor im2col_backward(const Tensor & grad_output, IntArrayRef input_size, IntArrayRef kernel_size, IntArrayRef dilation, IntArrayRef padding, IntArrayRef stride);
};

} // namespace at
