#pragma once

// @generated by tools/codegen/gen.py from Functions.h

#include <c10/core/Scalar.h>
#include <ATen/Tensor.h>
#include <c10/core/Storage.h>
#include <ATen/core/Generator.h>
#include <c10/util/Deprecated.h>
#include <ATen/DeviceGuard.h>
#include <c10/core/TensorOptions.h>
#include <ATen/core/Reduction.h>
#include <c10/util/Optional.h>
#include <ATen/TensorUtils.h>
#include <ATen/Context.h>
#include <ATen/TracerMode.h>
#include <ATen/Operators.h>



namespace at {

// These functions are defined in ATen/Utils.cpp.
#define TENSOR(T, S)                                                          \
  TORCH_API Tensor tensor(ArrayRef<T> values, const TensorOptions& options); \
  inline Tensor tensor(                                                       \
      std::initializer_list<T> values, const TensorOptions& options) {        \
    return at::tensor(ArrayRef<T>(values), options);                          \
  }                                                                           \
  inline Tensor tensor(T value, const TensorOptions& options) {               \
    return at::tensor(ArrayRef<T>(value), options);                           \
  }                                                                           \
  inline Tensor tensor(ArrayRef<T> values) {                                  \
    return at::tensor(std::move(values), at::dtype(k##S));                    \
  }                                                                           \
  inline Tensor tensor(std::initializer_list<T> values) {                     \
    return at::tensor(ArrayRef<T>(values));                                   \
  }                                                                           \
  inline Tensor tensor(T value) {                                             \
    return at::tensor(ArrayRef<T>(value));                                    \
  }
AT_FORALL_SCALAR_TYPES_AND3(Bool, Half, BFloat16, TENSOR)
AT_FORALL_COMPLEX_TYPES(TENSOR)
#undef TENSOR


// aten::_cast_Byte(Tensor self, bool non_blocking=False) -> Tensor
TORCH_API inline at::Tensor _cast_Byte(const at::Tensor & self, bool non_blocking=false) {
    return at::_ops::_cast_Byte::call(self, non_blocking);
}

// aten::_cast_Char(Tensor self, bool non_blocking=False) -> Tensor
TORCH_API inline at::Tensor _cast_Char(const at::Tensor & self, bool non_blocking=false) {
    return at::_ops::_cast_Char::call(self, non_blocking);
}

// aten::_cast_Double(Tensor self, bool non_blocking=False) -> Tensor
TORCH_API inline at::Tensor _cast_Double(const at::Tensor & self, bool non_blocking=false) {
    return at::_ops::_cast_Double::call(self, non_blocking);
}

// aten::_cast_Float(Tensor self, bool non_blocking=False) -> Tensor
TORCH_API inline at::Tensor _cast_Float(const at::Tensor & self, bool non_blocking=false) {
    return at::_ops::_cast_Float::call(self, non_blocking);
}

// aten::_cast_Int(Tensor self, bool non_blocking=False) -> Tensor
TORCH_API inline at::Tensor _cast_Int(const at::Tensor & self, bool non_blocking=false) {
    return at::_ops::_cast_Int::call(self, non_blocking);
}

// aten::_cast_Long(Tensor self, bool non_blocking=False) -> Tensor
TORCH_API inline at::Tensor _cast_Long(const at::Tensor & self, bool non_blocking=false) {
    return at::_ops::_cast_Long::call(self, non_blocking);
}

// aten::_cast_Short(Tensor self, bool non_blocking=False) -> Tensor
TORCH_API inline at::Tensor _cast_Short(const at::Tensor & self, bool non_blocking=false) {
    return at::_ops::_cast_Short::call(self, non_blocking);
}

// aten::_cast_Half(Tensor self, bool non_blocking=False) -> Tensor
TORCH_API inline at::Tensor _cast_Half(const at::Tensor & self, bool non_blocking=false) {
    return at::_ops::_cast_Half::call(self, non_blocking);
}

// aten::_make_dual(Tensor(a) primal, Tensor tangent, int level) -> Tensor(a)
TORCH_API inline at::Tensor _make_dual(const at::Tensor & primal, const at::Tensor & tangent, int64_t level) {
    return at::_ops::_make_dual::call(primal, tangent, level);
}

// aten::_unpack_dual(Tensor(a) dual, int level) -> (Tensor(a) primal, Tensor tangent)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> _unpack_dual(const at::Tensor & dual, int64_t level) {
    return at::_ops::_unpack_dual::call(dual, level);
}

// aten::align_tensors(Tensor[] tensors) -> Tensor[]
TORCH_API inline ::std::vector<at::Tensor> align_tensors(at::TensorList tensors) {
    return at::_ops::align_tensors::call(tensors);
}

// aten::_assert_async(Tensor self) -> ()
TORCH_API inline void _assert_async(const at::Tensor & self) {
    return at::_ops::_assert_async::call(self);
}

// aten::_use_cudnn_ctc_loss(Tensor log_probs, Tensor targets, int[] input_lengths, int[] target_lengths, int blank) -> bool
TORCH_API inline bool _use_cudnn_ctc_loss(const at::Tensor & log_probs, const at::Tensor & targets, at::IntArrayRef input_lengths, at::IntArrayRef target_lengths, int64_t blank) {
    return at::_ops::_use_cudnn_ctc_loss::call(log_probs, targets, input_lengths, target_lengths, blank);
}

// aten::_cudnn_ctc_loss(Tensor log_probs, Tensor targets, int[] input_lengths, int[] target_lengths, int blank, bool deterministic, bool zero_infinity) -> (Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> _cudnn_ctc_loss(const at::Tensor & log_probs, const at::Tensor & targets, at::IntArrayRef input_lengths, at::IntArrayRef target_lengths, int64_t blank, bool deterministic, bool zero_infinity) {
    return at::_ops::_cudnn_ctc_loss::call(log_probs, targets, input_lengths, target_lengths, blank, deterministic, zero_infinity);
}

// aten::_use_cudnn_rnn_flatten_weight() -> bool
TORCH_API inline bool _use_cudnn_rnn_flatten_weight() {
    return at::_ops::_use_cudnn_rnn_flatten_weight::call();
}

// aten::_cudnn_rnn_flatten_weight(Tensor[] weight_arr, int weight_stride0, int input_size, int mode, int hidden_size, int proj_size, int num_layers, bool batch_first, bool bidirectional) -> Tensor
TORCH_API inline at::Tensor _cudnn_rnn_flatten_weight(at::TensorList weight_arr, int64_t weight_stride0, int64_t input_size, int64_t mode, int64_t hidden_size, int64_t proj_size, int64_t num_layers, bool batch_first, bool bidirectional) {
    return at::_ops::_cudnn_rnn_flatten_weight::call(weight_arr, weight_stride0, input_size, mode, hidden_size, proj_size, num_layers, batch_first, bidirectional);
}

// aten::_cudnn_rnn(Tensor input, Tensor[] weight, int weight_stride0, Tensor? weight_buf, Tensor hx, Tensor? cx, int mode, int hidden_size, int proj_size, int num_layers, bool batch_first, float dropout, bool train, bool bidirectional, int[] batch_sizes, Tensor? dropout_state) -> (Tensor, Tensor, Tensor, Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor,at::Tensor,at::Tensor,at::Tensor> _cudnn_rnn(const at::Tensor & input, at::TensorList weight, int64_t weight_stride0, const c10::optional<at::Tensor> & weight_buf, const at::Tensor & hx, const c10::optional<at::Tensor> & cx, int64_t mode, int64_t hidden_size, int64_t proj_size, int64_t num_layers, bool batch_first, double dropout, bool train, bool bidirectional, at::IntArrayRef batch_sizes, const c10::optional<at::Tensor> & dropout_state) {
    return at::_ops::_cudnn_rnn::call(input, weight, weight_stride0, weight_buf, hx, cx, mode, hidden_size, proj_size, num_layers, batch_first, dropout, train, bidirectional, batch_sizes, dropout_state);
}

// aten::_cudnn_rnn_backward(Tensor input, Tensor[] weight, int weight_stride0, Tensor weight_buf, Tensor hx, Tensor? cx, Tensor output, Tensor? grad_output, Tensor? grad_hy, Tensor? grad_cy, int mode, int hidden_size, int proj_size, int num_layers, bool batch_first, float dropout, bool train, bool bidirectional, int[] batch_sizes, Tensor? dropout_state, Tensor reserve, bool[4] output_mask) -> (Tensor, Tensor, Tensor, Tensor[])
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor,at::Tensor,::std::vector<at::Tensor>> _cudnn_rnn_backward(const at::Tensor & input, at::TensorList weight, int64_t weight_stride0, const at::Tensor & weight_buf, const at::Tensor & hx, const c10::optional<at::Tensor> & cx, const at::Tensor & output, const c10::optional<at::Tensor> & grad_output, const c10::optional<at::Tensor> & grad_hy, const c10::optional<at::Tensor> & grad_cy, int64_t mode, int64_t hidden_size, int64_t proj_size, int64_t num_layers, bool batch_first, double dropout, bool train, bool bidirectional, at::IntArrayRef batch_sizes, const c10::optional<at::Tensor> & dropout_state, const at::Tensor & reserve, ::std::array<bool,4> output_mask) {
    return at::_ops::_cudnn_rnn_backward::call(input, weight, weight_stride0, weight_buf, hx, cx, output, grad_output, grad_hy, grad_cy, mode, hidden_size, proj_size, num_layers, batch_first, dropout, train, bidirectional, batch_sizes, dropout_state, reserve, output_mask);
}

// aten::_cudnn_init_dropout_state(float dropout, bool train, int dropout_seed, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=False) -> Tensor
TORCH_API inline at::Tensor _cudnn_init_dropout_state(double dropout, bool train, int64_t dropout_seed, at::TensorOptions options) {
    return at::_ops::_cudnn_init_dropout_state::call(dropout, train, dropout_seed, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt());
}

// aten::_cudnn_init_dropout_state(float dropout, bool train, int dropout_seed, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=False) -> Tensor
TORCH_API inline at::Tensor _cudnn_init_dropout_state(double dropout, bool train, int64_t dropout_seed, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory) {
    return at::_ops::_cudnn_init_dropout_state::call(dropout, train, dropout_seed, dtype, layout, device, pin_memory);
}

// aten::_debug_has_internal_overlap(Tensor self) -> int
TORCH_API inline int64_t _debug_has_internal_overlap(const at::Tensor & self) {
    return at::_ops::_debug_has_internal_overlap::call(self);
}

// aten::_fused_dropout(Tensor self, float p, Generator? generator=None) -> (Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> _fused_dropout(const at::Tensor & self, double p, c10::optional<at::Generator> generator=c10::nullopt) {
    return at::_ops::_fused_dropout::call(self, p, generator);
}

// aten::_masked_scale(Tensor self, Tensor mask, float scale) -> Tensor
TORCH_API inline at::Tensor _masked_scale(const at::Tensor & self, const at::Tensor & mask, double scale) {
    return at::_ops::_masked_scale::call(self, mask, scale);
}

// aten::_sobol_engine_draw(Tensor quasi, int n, Tensor sobolstate, int dimension, int num_generated, ScalarType? dtype) -> (Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> _sobol_engine_draw(const at::Tensor & quasi, int64_t n, const at::Tensor & sobolstate, int64_t dimension, int64_t num_generated, c10::optional<at::ScalarType> dtype) {
    return at::_ops::_sobol_engine_draw::call(quasi, n, sobolstate, dimension, num_generated, dtype);
}

// aten::_sobol_engine_ff_(Tensor(a!) self, int n, Tensor sobolstate, int dimension, int num_generated) -> Tensor(a!)
TORCH_API inline at::Tensor & _sobol_engine_ff_(at::Tensor & self, int64_t n, const at::Tensor & sobolstate, int64_t dimension, int64_t num_generated) {
    return at::_ops::_sobol_engine_ff_::call(self, n, sobolstate, dimension, num_generated);
}

// aten::_sobol_engine_scramble_(Tensor(a!) self, Tensor ltm, int dimension) -> Tensor(a!)
TORCH_API inline at::Tensor & _sobol_engine_scramble_(at::Tensor & self, const at::Tensor & ltm, int64_t dimension) {
    return at::_ops::_sobol_engine_scramble_::call(self, ltm, dimension);
}

// aten::_sobol_engine_initialize_state_(Tensor(a!) self, int dimension) -> Tensor(a!)
TORCH_API inline at::Tensor & _sobol_engine_initialize_state_(at::Tensor & self, int64_t dimension) {
    return at::_ops::_sobol_engine_initialize_state_::call(self, dimension);
}

// aten::_reshape_from_tensor(Tensor self, Tensor shape) -> Tensor
TORCH_API inline at::Tensor _reshape_from_tensor(const at::Tensor & self, const at::Tensor & shape) {
    return at::_ops::_reshape_from_tensor::call(self, shape);
}

// aten::_shape_as_tensor(Tensor self) -> Tensor
TORCH_API inline at::Tensor _shape_as_tensor(const at::Tensor & self) {
    return at::_ops::_shape_as_tensor::call(self);
}

// aten::dropout(Tensor input, float p, bool train) -> Tensor
TORCH_API inline at::Tensor dropout(const at::Tensor & input, double p, bool train) {
    return at::_ops::dropout::call(input, p, train);
}

// aten::dropout_(Tensor(a!) self, float p, bool train) -> Tensor(a!)
TORCH_API inline at::Tensor & dropout_(at::Tensor & self, double p, bool train) {
    return at::_ops::dropout_::call(self, p, train);
}

// aten::feature_dropout(Tensor input, float p, bool train) -> Tensor
TORCH_API inline at::Tensor feature_dropout(const at::Tensor & input, double p, bool train) {
    return at::_ops::feature_dropout::call(input, p, train);
}

// aten::feature_dropout_(Tensor(a!) self, float p, bool train) -> Tensor(a!)
TORCH_API inline at::Tensor & feature_dropout_(at::Tensor & self, double p, bool train) {
    return at::_ops::feature_dropout_::call(self, p, train);
}

// aten::alpha_dropout(Tensor input, float p, bool train) -> Tensor
TORCH_API inline at::Tensor alpha_dropout(const at::Tensor & input, double p, bool train) {
    return at::_ops::alpha_dropout::call(input, p, train);
}

// aten::alpha_dropout_(Tensor(a!) self, float p, bool train) -> Tensor(a!)
TORCH_API inline at::Tensor & alpha_dropout_(at::Tensor & self, double p, bool train) {
    return at::_ops::alpha_dropout_::call(self, p, train);
}

// aten::feature_alpha_dropout(Tensor input, float p, bool train) -> Tensor
TORCH_API inline at::Tensor feature_alpha_dropout(const at::Tensor & input, double p, bool train) {
    return at::_ops::feature_alpha_dropout::call(input, p, train);
}

// aten::feature_alpha_dropout_(Tensor(a!) self, float p, bool train) -> Tensor(a!)
TORCH_API inline at::Tensor & feature_alpha_dropout_(at::Tensor & self, double p, bool train) {
    return at::_ops::feature_alpha_dropout_::call(self, p, train);
}

// aten::abs(Tensor self) -> Tensor
TORCH_API inline at::Tensor abs(const at::Tensor & self) {
    return at::_ops::abs::call(self);
}

// aten::abs_(Tensor(a!) self) -> Tensor(a!)
TORCH_API inline at::Tensor & abs_(at::Tensor & self) {
    return at::_ops::abs_::call(self);
}

// aten::abs.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & abs_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::abs_out::call(self, out);
}

// aten::abs.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & abs_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::abs_out::call(self, out);
}

// aten::absolute(Tensor self) -> Tensor
TORCH_API inline at::Tensor absolute(const at::Tensor & self) {
    return at::_ops::absolute::call(self);
}

// aten::absolute.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & absolute_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::absolute_out::call(self, out);
}

// aten::absolute.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & absolute_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::absolute_out::call(self, out);
}

// aten::angle(Tensor self) -> Tensor
TORCH_API inline at::Tensor angle(const at::Tensor & self) {
    return at::_ops::angle::call(self);
}

// aten::angle.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & angle_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::angle_out::call(self, out);
}

// aten::angle.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & angle_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::angle_out::call(self, out);
}

// aten::view_as_real(Tensor(a) self) -> Tensor(a)
TORCH_API inline at::Tensor view_as_real(const at::Tensor & self) {
    return at::_ops::view_as_real::call(self);
}

// aten::view_as_complex(Tensor(a) self) -> Tensor(a)
TORCH_API inline at::Tensor view_as_complex(const at::Tensor & self) {
    return at::_ops::view_as_complex::call(self);
}

// aten::sgn(Tensor self) -> Tensor
TORCH_API inline at::Tensor sgn(const at::Tensor & self) {
    return at::_ops::sgn::call(self);
}

// aten::sgn.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & sgn_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::sgn_out::call(self, out);
}

// aten::sgn.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & sgn_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::sgn_out::call(self, out);
}

// aten::real(Tensor(a) self) -> Tensor(a)
TORCH_API inline at::Tensor real(const at::Tensor & self) {
    return at::_ops::real::call(self);
}

// aten::imag(Tensor(a) self) -> Tensor(a)
TORCH_API inline at::Tensor imag(const at::Tensor & self) {
    return at::_ops::imag::call(self);
}

// aten::_conj(Tensor(a) self) -> Tensor(a)
TORCH_API inline at::Tensor _conj(const at::Tensor & self) {
    return at::_ops::_conj::call(self);
}

// aten::conj(Tensor(a) self) -> Tensor(a)
TORCH_API inline at::Tensor __dispatch_conj(const at::Tensor & self) {
    return at::_ops::conj::call(self);
}

// aten::_conj_physical(Tensor self) -> Tensor
TORCH_API inline at::Tensor _conj_physical(const at::Tensor & self) {
    return at::_ops::_conj_physical::call(self);
}

// aten::conj_physical(Tensor self) -> Tensor
TORCH_API inline at::Tensor conj_physical(const at::Tensor & self) {
    return at::_ops::conj_physical::call(self);
}

// aten::conj_physical.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & conj_physical_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::conj_physical_out::call(self, out);
}

// aten::conj_physical.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & conj_physical_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::conj_physical_out::call(self, out);
}

// aten::conj_physical_(Tensor(a!) self) -> Tensor(a!)
TORCH_API inline at::Tensor & conj_physical_(at::Tensor & self) {
    return at::_ops::conj_physical_::call(self);
}

// aten::resolve_conj(Tensor(a) self) -> Tensor(a)
TORCH_API inline at::Tensor resolve_conj(const at::Tensor & self) {
    return at::_ops::resolve_conj::call(self);
}

// aten::resolve_neg(Tensor(a) self) -> Tensor(a)
TORCH_API inline at::Tensor resolve_neg(const at::Tensor & self) {
    return at::_ops::resolve_neg::call(self);
}

// aten::_neg_view(Tensor(a) self) -> Tensor(a)
TORCH_API inline at::Tensor _neg_view(const at::Tensor & self) {
    return at::_ops::_neg_view::call(self);
}

// aten::acos(Tensor self) -> Tensor
TORCH_API inline at::Tensor acos(const at::Tensor & self) {
    return at::_ops::acos::call(self);
}

// aten::acos_(Tensor(a!) self) -> Tensor(a!)
TORCH_API inline at::Tensor & acos_(at::Tensor & self) {
    return at::_ops::acos_::call(self);
}

// aten::acos.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & acos_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::acos_out::call(self, out);
}

// aten::acos.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & acos_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::acos_out::call(self, out);
}

// aten::arccos(Tensor self) -> Tensor
TORCH_API inline at::Tensor arccos(const at::Tensor & self) {
    return at::_ops::arccos::call(self);
}

// aten::arccos_(Tensor(a!) self) -> Tensor(a!)
TORCH_API inline at::Tensor & arccos_(at::Tensor & self) {
    return at::_ops::arccos_::call(self);
}

// aten::arccos.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & arccos_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::arccos_out::call(self, out);
}

// aten::arccos.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & arccos_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::arccos_out::call(self, out);
}

// aten::avg_pool1d(Tensor self, int[1] kernel_size, int[1] stride=[], int[1] padding=0, bool ceil_mode=False, bool count_include_pad=True) -> Tensor
TORCH_API inline at::Tensor avg_pool1d(const at::Tensor & self, at::IntArrayRef kernel_size, at::IntArrayRef stride={}, at::IntArrayRef padding=0, bool ceil_mode=false, bool count_include_pad=true) {
    return at::_ops::avg_pool1d::call(self, kernel_size, stride, padding, ceil_mode, count_include_pad);
}

// aten::adaptive_avg_pool1d(Tensor self, int[1] output_size) -> Tensor
TORCH_API inline at::Tensor adaptive_avg_pool1d(const at::Tensor & self, at::IntArrayRef output_size) {
    return at::_ops::adaptive_avg_pool1d::call(self, output_size);
}

// aten::adaptive_max_pool1d(Tensor self, int[1] output_size) -> (Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> adaptive_max_pool1d(const at::Tensor & self, at::IntArrayRef output_size) {
    return at::_ops::adaptive_max_pool1d::call(self, output_size);
}

// aten::add.Tensor(Tensor self, Tensor other, *, Scalar alpha=1) -> Tensor
TORCH_API inline at::Tensor add(const at::Tensor & self, const at::Tensor & other, const at::Scalar & alpha=1) {
    return at::_ops::add_Tensor::call(self, other, alpha);
}

// aten::add.out(Tensor self, Tensor other, *, Scalar alpha=1, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & add_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & other, const at::Scalar & alpha=1) {
    return at::_ops::add_out::call(self, other, alpha, out);
}

// aten::add.out(Tensor self, Tensor other, *, Scalar alpha=1, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & add_outf(const at::Tensor & self, const at::Tensor & other, const at::Scalar & alpha, at::Tensor & out) {
    return at::_ops::add_out::call(self, other, alpha, out);
}

// aten::_add_relu.Tensor(Tensor self, Tensor other, *, Scalar alpha=1) -> Tensor
TORCH_API inline at::Tensor _add_relu(const at::Tensor & self, const at::Tensor & other, const at::Scalar & alpha=1) {
    return at::_ops::_add_relu_Tensor::call(self, other, alpha);
}

// aten::_add_relu_.Tensor(Tensor(a!) self, Tensor other, *, Scalar alpha=1) -> Tensor(a!)
TORCH_API inline at::Tensor & _add_relu_(at::Tensor & self, const at::Tensor & other, const at::Scalar & alpha=1) {
    return at::_ops::_add_relu__Tensor::call(self, other, alpha);
}

// aten::_add_relu.out(Tensor self, Tensor other, *, Scalar alpha=1, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & _add_relu_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & other, const at::Scalar & alpha=1) {
    return at::_ops::_add_relu_out::call(self, other, alpha, out);
}

// aten::_add_relu.out(Tensor self, Tensor other, *, Scalar alpha=1, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & _add_relu_outf(const at::Tensor & self, const at::Tensor & other, const at::Scalar & alpha, at::Tensor & out) {
    return at::_ops::_add_relu_out::call(self, other, alpha, out);
}

// aten::_add_relu.Scalar(Tensor self, Scalar other, Scalar alpha=1) -> Tensor
TORCH_API inline at::Tensor _add_relu(const at::Tensor & self, const at::Scalar & other, const at::Scalar & alpha=1) {
    return at::_ops::_add_relu_Scalar::call(self, other, alpha);
}

// aten::_add_relu_.Scalar(Tensor(a!) self, Scalar other, Scalar alpha=1) -> Tensor(a!)
TORCH_API inline at::Tensor & _add_relu_(at::Tensor & self, const at::Scalar & other, const at::Scalar & alpha=1) {
    return at::_ops::_add_relu__Scalar::call(self, other, alpha);
}

// aten::add.Scalar(Tensor self, Scalar other, Scalar alpha=1) -> Tensor
TORCH_API inline at::Tensor add(const at::Tensor & self, const at::Scalar & other, const at::Scalar & alpha=1) {
    return at::_ops::add_Scalar::call(self, other, alpha);
}

// aten::addmv(Tensor self, Tensor mat, Tensor vec, *, Scalar beta=1, Scalar alpha=1) -> Tensor
TORCH_API inline at::Tensor addmv(const at::Tensor & self, const at::Tensor & mat, const at::Tensor & vec, const at::Scalar & beta=1, const at::Scalar & alpha=1) {
    return at::_ops::addmv::call(self, mat, vec, beta, alpha);
}

// aten::addmv_(Tensor(a!) self, Tensor mat, Tensor vec, *, Scalar beta=1, Scalar alpha=1) -> Tensor(a!)
TORCH_API inline at::Tensor & addmv_(at::Tensor & self, const at::Tensor & mat, const at::Tensor & vec, const at::Scalar & beta=1, const at::Scalar & alpha=1) {
    return at::_ops::addmv_::call(self, mat, vec, beta, alpha);
}

// aten::addmv.out(Tensor self, Tensor mat, Tensor vec, *, Scalar beta=1, Scalar alpha=1, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & addmv_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & mat, const at::Tensor & vec, const at::Scalar & beta=1, const at::Scalar & alpha=1) {
    return at::_ops::addmv_out::call(self, mat, vec, beta, alpha, out);
}

// aten::addmv.out(Tensor self, Tensor mat, Tensor vec, *, Scalar beta=1, Scalar alpha=1, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & addmv_outf(const at::Tensor & self, const at::Tensor & mat, const at::Tensor & vec, const at::Scalar & beta, const at::Scalar & alpha, at::Tensor & out) {
    return at::_ops::addmv_out::call(self, mat, vec, beta, alpha, out);
}

// aten::addr(Tensor self, Tensor vec1, Tensor vec2, *, Scalar beta=1, Scalar alpha=1) -> Tensor
TORCH_API inline at::Tensor addr(const at::Tensor & self, const at::Tensor & vec1, const at::Tensor & vec2, const at::Scalar & beta=1, const at::Scalar & alpha=1) {
    return at::_ops::addr::call(self, vec1, vec2, beta, alpha);
}

// aten::addr.out(Tensor self, Tensor vec1, Tensor vec2, *, Scalar beta=1, Scalar alpha=1, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & addr_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & vec1, const at::Tensor & vec2, const at::Scalar & beta=1, const at::Scalar & alpha=1) {
    return at::_ops::addr_out::call(self, vec1, vec2, beta, alpha, out);
}

// aten::addr.out(Tensor self, Tensor vec1, Tensor vec2, *, Scalar beta=1, Scalar alpha=1, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & addr_outf(const at::Tensor & self, const at::Tensor & vec1, const at::Tensor & vec2, const at::Scalar & beta, const at::Scalar & alpha, at::Tensor & out) {
    return at::_ops::addr_out::call(self, vec1, vec2, beta, alpha, out);
}

// aten::affine_grid_generator(Tensor theta, int[] size, bool align_corners) -> Tensor
TORCH_API inline at::Tensor affine_grid_generator(const at::Tensor & theta, at::IntArrayRef size, bool align_corners) {
    return at::_ops::affine_grid_generator::call(theta, size, align_corners);
}

// aten::affine_grid_generator_backward(Tensor grad, int[] size, bool align_corners) -> Tensor
TORCH_API inline at::Tensor affine_grid_generator_backward(const at::Tensor & grad, at::IntArrayRef size, bool align_corners) {
    return at::_ops::affine_grid_generator_backward::call(grad, size, align_corners);
}

// aten::all.dim(Tensor self, int dim, bool keepdim=False) -> Tensor
TORCH_API inline at::Tensor all(const at::Tensor & self, int64_t dim, bool keepdim=false) {
    return at::_ops::all_dim::call(self, dim, keepdim);
}

// aten::all.out(Tensor self, int dim, bool keepdim=False, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & all_out(at::Tensor & out, const at::Tensor & self, int64_t dim, bool keepdim=false) {
    return at::_ops::all_out::call(self, dim, keepdim, out);
}

// aten::all.out(Tensor self, int dim, bool keepdim=False, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & all_outf(const at::Tensor & self, int64_t dim, bool keepdim, at::Tensor & out) {
    return at::_ops::all_out::call(self, dim, keepdim, out);
}

// aten::all.dimname(Tensor self, Dimname dim, bool keepdim=False) -> Tensor
TORCH_API inline at::Tensor all(const at::Tensor & self, at::Dimname dim, bool keepdim=false) {
    return at::_ops::all_dimname::call(self, dim, keepdim);
}

// aten::all.dimname_out(Tensor self, Dimname dim, bool keepdim=False, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & all_out(at::Tensor & out, const at::Tensor & self, at::Dimname dim, bool keepdim=false) {
    return at::_ops::all_dimname_out::call(self, dim, keepdim, out);
}

// aten::all.dimname_out(Tensor self, Dimname dim, bool keepdim=False, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & all_outf(const at::Tensor & self, at::Dimname dim, bool keepdim, at::Tensor & out) {
    return at::_ops::all_dimname_out::call(self, dim, keepdim, out);
}

// aten::allclose(Tensor self, Tensor other, float rtol=1e-05, float atol=1e-08, bool equal_nan=False) -> bool
TORCH_API inline bool allclose(const at::Tensor & self, const at::Tensor & other, double rtol=1e-05, double atol=1e-08, bool equal_nan=false) {
    return at::_ops::allclose::call(self, other, rtol, atol, equal_nan);
}

// aten::any.dim(Tensor self, int dim, bool keepdim=False) -> Tensor
TORCH_API inline at::Tensor any(const at::Tensor & self, int64_t dim, bool keepdim=false) {
    return at::_ops::any_dim::call(self, dim, keepdim);
}

// aten::any.out(Tensor self, int dim, bool keepdim=False, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & any_out(at::Tensor & out, const at::Tensor & self, int64_t dim, bool keepdim=false) {
    return at::_ops::any_out::call(self, dim, keepdim, out);
}

// aten::any.out(Tensor self, int dim, bool keepdim=False, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & any_outf(const at::Tensor & self, int64_t dim, bool keepdim, at::Tensor & out) {
    return at::_ops::any_out::call(self, dim, keepdim, out);
}

// aten::any.dimname(Tensor self, Dimname dim, bool keepdim=False) -> Tensor
TORCH_API inline at::Tensor any(const at::Tensor & self, at::Dimname dim, bool keepdim=false) {
    return at::_ops::any_dimname::call(self, dim, keepdim);
}

// aten::any.dimname_out(Tensor self, Dimname dim, bool keepdim=False, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & any_out(at::Tensor & out, const at::Tensor & self, at::Dimname dim, bool keepdim=false) {
    return at::_ops::any_dimname_out::call(self, dim, keepdim, out);
}

// aten::any.dimname_out(Tensor self, Dimname dim, bool keepdim=False, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & any_outf(const at::Tensor & self, at::Dimname dim, bool keepdim, at::Tensor & out) {
    return at::_ops::any_dimname_out::call(self, dim, keepdim, out);
}

// aten::arange(Scalar end, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor arange(const at::Scalar & end, at::TensorOptions options={}) {
    return at::_ops::arange::call(end, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt());
}

// aten::arange(Scalar end, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor arange(const at::Scalar & end, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory) {
    return at::_ops::arange::call(end, dtype, layout, device, pin_memory);
}

// aten::arange.start(Scalar start, Scalar end, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor arange(const at::Scalar & start, const at::Scalar & end, at::TensorOptions options={}) {
    return at::_ops::arange_start::call(start, end, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt());
}

// aten::arange.start(Scalar start, Scalar end, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor arange(const at::Scalar & start, const at::Scalar & end, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory) {
    return at::_ops::arange_start::call(start, end, dtype, layout, device, pin_memory);
}

// aten::arange.start_step(Scalar start, Scalar end, Scalar step, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor arange(const at::Scalar & start, const at::Scalar & end, const at::Scalar & step, at::TensorOptions options={}) {
    return at::_ops::arange_start_step::call(start, end, step, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt());
}

// aten::arange.start_step(Scalar start, Scalar end, Scalar step, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor arange(const at::Scalar & start, const at::Scalar & end, const at::Scalar & step, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory) {
    return at::_ops::arange_start_step::call(start, end, step, dtype, layout, device, pin_memory);
}

// aten::arange.out(Scalar end, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & arange_out(at::Tensor & out, const at::Scalar & end) {
    return at::_ops::arange_out::call(end, out);
}

// aten::arange.out(Scalar end, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & arange_outf(const at::Scalar & end, at::Tensor & out) {
    return at::_ops::arange_out::call(end, out);
}

// aten::arange.start_out(Scalar start, Scalar end, Scalar step=1, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & arange_out(at::Tensor & out, const at::Scalar & start, const at::Scalar & end, const at::Scalar & step=1) {
    return at::_ops::arange_start_out::call(start, end, step, out);
}

// aten::arange.start_out(Scalar start, Scalar end, Scalar step=1, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & arange_outf(const at::Scalar & start, const at::Scalar & end, const at::Scalar & step, at::Tensor & out) {
    return at::_ops::arange_start_out::call(start, end, step, out);
}

// aten::_dim_arange(Tensor like, int dim) -> Tensor
TORCH_API inline at::Tensor _dim_arange(const at::Tensor & like, int64_t dim) {
    return at::_ops::_dim_arange::call(like, dim);
}

// aten::argmax(Tensor self, int? dim=None, bool keepdim=False) -> Tensor
TORCH_API inline at::Tensor argmax(const at::Tensor & self, c10::optional<int64_t> dim=c10::nullopt, bool keepdim=false) {
    return at::_ops::argmax::call(self, dim, keepdim);
}

// aten::argmax.out(Tensor self, int? dim=None, bool keepdim=False, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & argmax_out(at::Tensor & out, const at::Tensor & self, c10::optional<int64_t> dim=c10::nullopt, bool keepdim=false) {
    return at::_ops::argmax_out::call(self, dim, keepdim, out);
}

// aten::argmax.out(Tensor self, int? dim=None, bool keepdim=False, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & argmax_outf(const at::Tensor & self, c10::optional<int64_t> dim, bool keepdim, at::Tensor & out) {
    return at::_ops::argmax_out::call(self, dim, keepdim, out);
}

// aten::argmin(Tensor self, int? dim=None, bool keepdim=False) -> Tensor
TORCH_API inline at::Tensor argmin(const at::Tensor & self, c10::optional<int64_t> dim=c10::nullopt, bool keepdim=false) {
    return at::_ops::argmin::call(self, dim, keepdim);
}

// aten::argmin.out(Tensor self, int? dim=None, bool keepdim=False, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & argmin_out(at::Tensor & out, const at::Tensor & self, c10::optional<int64_t> dim=c10::nullopt, bool keepdim=false) {
    return at::_ops::argmin_out::call(self, dim, keepdim, out);
}

// aten::argmin.out(Tensor self, int? dim=None, bool keepdim=False, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & argmin_outf(const at::Tensor & self, c10::optional<int64_t> dim, bool keepdim, at::Tensor & out) {
    return at::_ops::argmin_out::call(self, dim, keepdim, out);
}

// aten::acosh(Tensor self) -> Tensor
TORCH_API inline at::Tensor acosh(const at::Tensor & self) {
    return at::_ops::acosh::call(self);
}

// aten::acosh_(Tensor(a!) self) -> Tensor(a!)
TORCH_API inline at::Tensor & acosh_(at::Tensor & self) {
    return at::_ops::acosh_::call(self);
}

// aten::acosh.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & acosh_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::acosh_out::call(self, out);
}

// aten::acosh.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & acosh_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::acosh_out::call(self, out);
}

// aten::arccosh(Tensor self) -> Tensor
TORCH_API inline at::Tensor arccosh(const at::Tensor & self) {
    return at::_ops::arccosh::call(self);
}

// aten::arccosh_(Tensor(a!) self) -> Tensor(a!)
TORCH_API inline at::Tensor & arccosh_(at::Tensor & self) {
    return at::_ops::arccosh_::call(self);
}

// aten::arccosh.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & arccosh_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::arccosh_out::call(self, out);
}

// aten::arccosh.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & arccosh_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::arccosh_out::call(self, out);
}

// aten::asinh(Tensor self) -> Tensor
TORCH_API inline at::Tensor asinh(const at::Tensor & self) {
    return at::_ops::asinh::call(self);
}

// aten::asinh_(Tensor(a!) self) -> Tensor(a!)
TORCH_API inline at::Tensor & asinh_(at::Tensor & self) {
    return at::_ops::asinh_::call(self);
}

// aten::asinh.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & asinh_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::asinh_out::call(self, out);
}

// aten::asinh.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & asinh_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::asinh_out::call(self, out);
}

// aten::arcsinh(Tensor self) -> Tensor
TORCH_API inline at::Tensor arcsinh(const at::Tensor & self) {
    return at::_ops::arcsinh::call(self);
}

// aten::arcsinh_(Tensor(a!) self) -> Tensor(a!)
TORCH_API inline at::Tensor & arcsinh_(at::Tensor & self) {
    return at::_ops::arcsinh_::call(self);
}

// aten::arcsinh.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & arcsinh_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::arcsinh_out::call(self, out);
}

// aten::arcsinh.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & arcsinh_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::arcsinh_out::call(self, out);
}

// aten::atanh(Tensor self) -> Tensor
TORCH_API inline at::Tensor atanh(const at::Tensor & self) {
    return at::_ops::atanh::call(self);
}

// aten::atanh_(Tensor(a!) self) -> Tensor(a!)
TORCH_API inline at::Tensor & atanh_(at::Tensor & self) {
    return at::_ops::atanh_::call(self);
}

// aten::atanh.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & atanh_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::atanh_out::call(self, out);
}

// aten::atanh.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & atanh_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::atanh_out::call(self, out);
}

// aten::arctanh(Tensor self) -> Tensor
TORCH_API inline at::Tensor arctanh(const at::Tensor & self) {
    return at::_ops::arctanh::call(self);
}

// aten::arctanh_(Tensor(a!) self) -> Tensor(a!)
TORCH_API inline at::Tensor & arctanh_(at::Tensor & self) {
    return at::_ops::arctanh_::call(self);
}

// aten::arctanh.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & arctanh_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::arctanh_out::call(self, out);
}

// aten::arctanh.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & arctanh_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::arctanh_out::call(self, out);
}

// aten::as_strided(Tensor(a) self, int[] size, int[] stride, int? storage_offset=None) -> Tensor(a)
TORCH_API inline at::Tensor as_strided(const at::Tensor & self, at::IntArrayRef size, at::IntArrayRef stride, c10::optional<int64_t> storage_offset=c10::nullopt) {
    return at::_ops::as_strided::call(self, size, stride, storage_offset);
}

// aten::as_strided_(Tensor(a!) self, int[] size, int[] stride, int? storage_offset=None) -> Tensor(a!)
TORCH_API inline const at::Tensor & as_strided_(const at::Tensor & self, at::IntArrayRef size, at::IntArrayRef stride, c10::optional<int64_t> storage_offset=c10::nullopt) {
    return at::_ops::as_strided_::call(self, size, stride, storage_offset);
}

// aten::asin(Tensor self) -> Tensor
TORCH_API inline at::Tensor asin(const at::Tensor & self) {
    return at::_ops::asin::call(self);
}

// aten::asin_(Tensor(a!) self) -> Tensor(a!)
TORCH_API inline at::Tensor & asin_(at::Tensor & self) {
    return at::_ops::asin_::call(self);
}

// aten::asin.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & asin_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::asin_out::call(self, out);
}

// aten::asin.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & asin_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::asin_out::call(self, out);
}

// aten::arcsin(Tensor self) -> Tensor
TORCH_API inline at::Tensor arcsin(const at::Tensor & self) {
    return at::_ops::arcsin::call(self);
}

// aten::arcsin_(Tensor(a!) self) -> Tensor(a!)
TORCH_API inline at::Tensor & arcsin_(at::Tensor & self) {
    return at::_ops::arcsin_::call(self);
}

// aten::arcsin.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & arcsin_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::arcsin_out::call(self, out);
}

// aten::arcsin.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & arcsin_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::arcsin_out::call(self, out);
}

// aten::atan(Tensor self) -> Tensor
TORCH_API inline at::Tensor atan(const at::Tensor & self) {
    return at::_ops::atan::call(self);
}

// aten::atan_(Tensor(a!) self) -> Tensor(a!)
TORCH_API inline at::Tensor & atan_(at::Tensor & self) {
    return at::_ops::atan_::call(self);
}

// aten::atan.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & atan_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::atan_out::call(self, out);
}

// aten::atan.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & atan_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::atan_out::call(self, out);
}

// aten::arctan(Tensor self) -> Tensor
TORCH_API inline at::Tensor arctan(const at::Tensor & self) {
    return at::_ops::arctan::call(self);
}

// aten::arctan_(Tensor(a!) self) -> Tensor(a!)
TORCH_API inline at::Tensor & arctan_(at::Tensor & self) {
    return at::_ops::arctan_::call(self);
}

// aten::arctan.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & arctan_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::arctan_out::call(self, out);
}

// aten::arctan.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & arctan_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::arctan_out::call(self, out);
}

// aten::atleast_1d(Tensor self) -> Tensor
TORCH_API inline at::Tensor atleast_1d(const at::Tensor & self) {
    return at::_ops::atleast_1d::call(self);
}

// aten::atleast_1d.Sequence(Tensor[] tensors) -> Tensor[]
TORCH_API inline ::std::vector<at::Tensor> atleast_1d(at::TensorList tensors) {
    return at::_ops::atleast_1d_Sequence::call(tensors);
}

// aten::atleast_2d(Tensor self) -> Tensor
TORCH_API inline at::Tensor atleast_2d(const at::Tensor & self) {
    return at::_ops::atleast_2d::call(self);
}

// aten::atleast_2d.Sequence(Tensor[] tensors) -> Tensor[]
TORCH_API inline ::std::vector<at::Tensor> atleast_2d(at::TensorList tensors) {
    return at::_ops::atleast_2d_Sequence::call(tensors);
}

// aten::atleast_3d(Tensor self) -> Tensor
TORCH_API inline at::Tensor atleast_3d(const at::Tensor & self) {
    return at::_ops::atleast_3d::call(self);
}

// aten::atleast_3d.Sequence(Tensor[] tensors) -> Tensor[]
TORCH_API inline ::std::vector<at::Tensor> atleast_3d(at::TensorList tensors) {
    return at::_ops::atleast_3d_Sequence::call(tensors);
}

// aten::baddbmm(Tensor self, Tensor batch1, Tensor batch2, *, Scalar beta=1, Scalar alpha=1) -> Tensor
TORCH_API inline at::Tensor baddbmm(const at::Tensor & self, const at::Tensor & batch1, const at::Tensor & batch2, const at::Scalar & beta=1, const at::Scalar & alpha=1) {
    return at::_ops::baddbmm::call(self, batch1, batch2, beta, alpha);
}

// aten::_baddbmm_mkl_(Tensor(a!) self, Tensor batch1, Tensor batch2, *, Scalar beta=1, Scalar alpha=1) -> Tensor(a!)
TORCH_API inline at::Tensor & _baddbmm_mkl_(at::Tensor & self, const at::Tensor & batch1, const at::Tensor & batch2, const at::Scalar & beta=1, const at::Scalar & alpha=1) {
    return at::_ops::_baddbmm_mkl_::call(self, batch1, batch2, beta, alpha);
}

// aten::baddbmm.out(Tensor self, Tensor batch1, Tensor batch2, *, Scalar beta=1, Scalar alpha=1, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & baddbmm_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & batch1, const at::Tensor & batch2, const at::Scalar & beta=1, const at::Scalar & alpha=1) {
    return at::_ops::baddbmm_out::call(self, batch1, batch2, beta, alpha, out);
}

// aten::baddbmm.out(Tensor self, Tensor batch1, Tensor batch2, *, Scalar beta=1, Scalar alpha=1, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & baddbmm_outf(const at::Tensor & self, const at::Tensor & batch1, const at::Tensor & batch2, const at::Scalar & beta, const at::Scalar & alpha, at::Tensor & out) {
    return at::_ops::baddbmm_out::call(self, batch1, batch2, beta, alpha, out);
}

// aten::bartlett_window(int window_length, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor bartlett_window(int64_t window_length, at::TensorOptions options={}) {
    return at::_ops::bartlett_window::call(window_length, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt());
}

// aten::bartlett_window(int window_length, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor bartlett_window(int64_t window_length, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory) {
    return at::_ops::bartlett_window::call(window_length, dtype, layout, device, pin_memory);
}

// aten::bartlett_window.periodic(int window_length, bool periodic, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor bartlett_window(int64_t window_length, bool periodic, at::TensorOptions options={}) {
    return at::_ops::bartlett_window_periodic::call(window_length, periodic, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt());
}

// aten::bartlett_window.periodic(int window_length, bool periodic, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor bartlett_window(int64_t window_length, bool periodic, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory) {
    return at::_ops::bartlett_window_periodic::call(window_length, periodic, dtype, layout, device, pin_memory);
}

// aten::batch_norm(Tensor input, Tensor? weight, Tensor? bias, Tensor? running_mean, Tensor? running_var, bool training, float momentum, float eps, bool cudnn_enabled) -> Tensor
TORCH_API inline at::Tensor batch_norm(const at::Tensor & input, const c10::optional<at::Tensor> & weight, const c10::optional<at::Tensor> & bias, const c10::optional<at::Tensor> & running_mean, const c10::optional<at::Tensor> & running_var, bool training, double momentum, double eps, bool cudnn_enabled) {
    return at::_ops::batch_norm::call(input, weight, bias, running_mean, running_var, training, momentum, eps, cudnn_enabled);
}

// aten::quantized_batch_norm(Tensor input, Tensor? weight, Tensor? bias, Tensor mean, Tensor var, float eps, float output_scale, int output_zero_point) -> Tensor
TORCH_API inline at::Tensor quantized_batch_norm(const at::Tensor & input, const c10::optional<at::Tensor> & weight, const c10::optional<at::Tensor> & bias, const at::Tensor & mean, const at::Tensor & var, double eps, double output_scale, int64_t output_zero_point) {
    return at::_ops::quantized_batch_norm::call(input, weight, bias, mean, var, eps, output_scale, output_zero_point);
}

// aten::_batch_norm_impl_index(Tensor input, Tensor? weight, Tensor? bias, Tensor? running_mean, Tensor? running_var, bool training, float momentum, float eps, bool cudnn_enabled) -> (Tensor, Tensor, Tensor, Tensor, int)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor,at::Tensor,at::Tensor,int64_t> _batch_norm_impl_index(const at::Tensor & input, const c10::optional<at::Tensor> & weight, const c10::optional<at::Tensor> & bias, const c10::optional<at::Tensor> & running_mean, const c10::optional<at::Tensor> & running_var, bool training, double momentum, double eps, bool cudnn_enabled) {
    return at::_ops::_batch_norm_impl_index::call(input, weight, bias, running_mean, running_var, training, momentum, eps, cudnn_enabled);
}

// aten::_batch_norm_impl_index_backward(int impl_index, Tensor input, Tensor grad_output, Tensor? weight, Tensor? running_mean, Tensor? running_var, Tensor? save_mean, Tensor? save_var_transform, bool train, float eps, bool[3] output_mask, Tensor reservedSpace) -> (Tensor, Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor,at::Tensor> _batch_norm_impl_index_backward(int64_t impl_index, const at::Tensor & input, const at::Tensor & grad_output, const c10::optional<at::Tensor> & weight, const c10::optional<at::Tensor> & running_mean, const c10::optional<at::Tensor> & running_var, const c10::optional<at::Tensor> & save_mean, const c10::optional<at::Tensor> & save_var_transform, bool train, double eps, ::std::array<bool,3> output_mask, const at::Tensor & reservedSpace) {
    return at::_ops::_batch_norm_impl_index_backward::call(impl_index, input, grad_output, weight, running_mean, running_var, save_mean, save_var_transform, train, eps, output_mask, reservedSpace);
}

// aten::bernoulli(Tensor self, *, Generator? generator=None) -> Tensor
TORCH_API inline at::Tensor bernoulli(const at::Tensor & self, c10::optional<at::Generator> generator=c10::nullopt) {
    return at::_ops::bernoulli::call(self, generator);
}

// aten::bernoulli.out(Tensor self, *, Generator? generator=None, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & bernoulli_out(at::Tensor & out, const at::Tensor & self, c10::optional<at::Generator> generator=c10::nullopt) {
    return at::_ops::bernoulli_out::call(self, generator, out);
}

// aten::bernoulli.out(Tensor self, *, Generator? generator=None, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & bernoulli_outf(const at::Tensor & self, c10::optional<at::Generator> generator, at::Tensor & out) {
    return at::_ops::bernoulli_out::call(self, generator, out);
}

// aten::bernoulli.p(Tensor self, float p, *, Generator? generator=None) -> Tensor
TORCH_API inline at::Tensor bernoulli(const at::Tensor & self, double p, c10::optional<at::Generator> generator=c10::nullopt) {
    return at::_ops::bernoulli_p::call(self, p, generator);
}

// aten::bilinear(Tensor input1, Tensor input2, Tensor weight, Tensor? bias) -> Tensor
TORCH_API inline at::Tensor bilinear(const at::Tensor & input1, const at::Tensor & input2, const at::Tensor & weight, const c10::optional<at::Tensor> & bias) {
    return at::_ops::bilinear::call(input1, input2, weight, bias);
}

// aten::binary_cross_entropy(Tensor self, Tensor target, Tensor? weight=None, int reduction=Mean) -> Tensor
TORCH_API inline at::Tensor binary_cross_entropy(const at::Tensor & self, const at::Tensor & target, const c10::optional<at::Tensor> & weight={}, int64_t reduction=at::Reduction::Mean) {
    return at::_ops::binary_cross_entropy::call(self, target, weight, reduction);
}

// aten::binary_cross_entropy.out(Tensor self, Tensor target, Tensor? weight=None, int reduction=Mean, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & binary_cross_entropy_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & target, const c10::optional<at::Tensor> & weight={}, int64_t reduction=at::Reduction::Mean) {
    return at::_ops::binary_cross_entropy_out::call(self, target, weight, reduction, out);
}

// aten::binary_cross_entropy.out(Tensor self, Tensor target, Tensor? weight=None, int reduction=Mean, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & binary_cross_entropy_outf(const at::Tensor & self, const at::Tensor & target, const c10::optional<at::Tensor> & weight, int64_t reduction, at::Tensor & out) {
    return at::_ops::binary_cross_entropy_out::call(self, target, weight, reduction, out);
}

// aten::binary_cross_entropy_backward(Tensor grad_output, Tensor self, Tensor target, Tensor? weight=None, int reduction=Mean) -> Tensor
TORCH_API inline at::Tensor binary_cross_entropy_backward(const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & target, const c10::optional<at::Tensor> & weight={}, int64_t reduction=at::Reduction::Mean) {
    return at::_ops::binary_cross_entropy_backward::call(grad_output, self, target, weight, reduction);
}

// aten::binary_cross_entropy_backward.grad_input(Tensor grad_output, Tensor self, Tensor target, Tensor? weight=None, int reduction=Mean, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & binary_cross_entropy_backward_out(at::Tensor & grad_input, const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & target, const c10::optional<at::Tensor> & weight={}, int64_t reduction=at::Reduction::Mean) {
    return at::_ops::binary_cross_entropy_backward_grad_input::call(grad_output, self, target, weight, reduction, grad_input);
}

// aten::binary_cross_entropy_backward.grad_input(Tensor grad_output, Tensor self, Tensor target, Tensor? weight=None, int reduction=Mean, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & binary_cross_entropy_backward_outf(const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & target, const c10::optional<at::Tensor> & weight, int64_t reduction, at::Tensor & grad_input) {
    return at::_ops::binary_cross_entropy_backward_grad_input::call(grad_output, self, target, weight, reduction, grad_input);
}

// aten::binary_cross_entropy_with_logits(Tensor self, Tensor target, Tensor? weight=None, Tensor? pos_weight=None, int reduction=Mean) -> Tensor
TORCH_API inline at::Tensor binary_cross_entropy_with_logits(const at::Tensor & self, const at::Tensor & target, const c10::optional<at::Tensor> & weight={}, const c10::optional<at::Tensor> & pos_weight={}, int64_t reduction=at::Reduction::Mean) {
    return at::_ops::binary_cross_entropy_with_logits::call(self, target, weight, pos_weight, reduction);
}

// aten::binary_cross_entropy_with_logits_backward(Tensor grad_output, Tensor self, Tensor target, Tensor? weight=None, Tensor? pos_weight=None, int reduction=Mean) -> Tensor
TORCH_API inline at::Tensor binary_cross_entropy_with_logits_backward(const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & target, const c10::optional<at::Tensor> & weight={}, const c10::optional<at::Tensor> & pos_weight={}, int64_t reduction=at::Reduction::Mean) {
    return at::_ops::binary_cross_entropy_with_logits_backward::call(grad_output, self, target, weight, pos_weight, reduction);
}

// aten::bincount(Tensor self, Tensor? weights=None, int minlength=0) -> Tensor
TORCH_API inline at::Tensor bincount(const at::Tensor & self, const c10::optional<at::Tensor> & weights={}, int64_t minlength=0) {
    return at::_ops::bincount::call(self, weights, minlength);
}

// aten::bitwise_not(Tensor self) -> Tensor
TORCH_API inline at::Tensor bitwise_not(const at::Tensor & self) {
    return at::_ops::bitwise_not::call(self);
}

// aten::bitwise_not.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & bitwise_not_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::bitwise_not_out::call(self, out);
}

// aten::bitwise_not.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & bitwise_not_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::bitwise_not_out::call(self, out);
}

// aten::copysign.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & copysign_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::copysign_out::call(self, other, out);
}

// aten::copysign.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & copysign_outf(const at::Tensor & self, const at::Tensor & other, at::Tensor & out) {
    return at::_ops::copysign_out::call(self, other, out);
}

// aten::copysign.Tensor(Tensor self, Tensor other) -> Tensor
TORCH_API inline at::Tensor copysign(const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::copysign_Tensor::call(self, other);
}

// aten::copysign.Scalar(Tensor self, Scalar other) -> Tensor
TORCH_API inline at::Tensor copysign(const at::Tensor & self, const at::Scalar & other) {
    return at::_ops::copysign_Scalar::call(self, other);
}

// aten::copysign.Scalar_out(Tensor self, Scalar other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & copysign_out(at::Tensor & out, const at::Tensor & self, const at::Scalar & other) {
    return at::_ops::copysign_Scalar_out::call(self, other, out);
}

// aten::copysign.Scalar_out(Tensor self, Scalar other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & copysign_outf(const at::Tensor & self, const at::Scalar & other, at::Tensor & out) {
    return at::_ops::copysign_Scalar_out::call(self, other, out);
}

// aten::logical_not(Tensor self) -> Tensor
TORCH_API inline at::Tensor logical_not(const at::Tensor & self) {
    return at::_ops::logical_not::call(self);
}

// aten::logical_not.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & logical_not_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::logical_not_out::call(self, out);
}

// aten::logical_not.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & logical_not_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::logical_not_out::call(self, out);
}

// aten::logical_xor(Tensor self, Tensor other) -> Tensor
TORCH_API inline at::Tensor logical_xor(const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::logical_xor::call(self, other);
}

// aten::logical_xor.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & logical_xor_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::logical_xor_out::call(self, other, out);
}

// aten::logical_xor.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & logical_xor_outf(const at::Tensor & self, const at::Tensor & other, at::Tensor & out) {
    return at::_ops::logical_xor_out::call(self, other, out);
}

// aten::logical_and(Tensor self, Tensor other) -> Tensor
TORCH_API inline at::Tensor logical_and(const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::logical_and::call(self, other);
}

// aten::logical_and.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & logical_and_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::logical_and_out::call(self, other, out);
}

// aten::logical_and.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & logical_and_outf(const at::Tensor & self, const at::Tensor & other, at::Tensor & out) {
    return at::_ops::logical_and_out::call(self, other, out);
}

// aten::logical_or(Tensor self, Tensor other) -> Tensor
TORCH_API inline at::Tensor logical_or(const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::logical_or::call(self, other);
}

// aten::logical_or.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & logical_or_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::logical_or_out::call(self, other, out);
}

// aten::logical_or.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & logical_or_outf(const at::Tensor & self, const at::Tensor & other, at::Tensor & out) {
    return at::_ops::logical_or_out::call(self, other, out);
}

// aten::blackman_window(int window_length, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor blackman_window(int64_t window_length, at::TensorOptions options={}) {
    return at::_ops::blackman_window::call(window_length, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt());
}

// aten::blackman_window(int window_length, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor blackman_window(int64_t window_length, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory) {
    return at::_ops::blackman_window::call(window_length, dtype, layout, device, pin_memory);
}

// aten::blackman_window.periodic(int window_length, bool periodic, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor blackman_window(int64_t window_length, bool periodic, at::TensorOptions options={}) {
    return at::_ops::blackman_window_periodic::call(window_length, periodic, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt());
}

// aten::blackman_window.periodic(int window_length, bool periodic, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor blackman_window(int64_t window_length, bool periodic, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory) {
    return at::_ops::blackman_window_periodic::call(window_length, periodic, dtype, layout, device, pin_memory);
}

// aten::bmm(Tensor self, Tensor mat2) -> Tensor
TORCH_API inline at::Tensor bmm(const at::Tensor & self, const at::Tensor & mat2) {
    return at::_ops::bmm::call(self, mat2);
}

// aten::bmm.out(Tensor self, Tensor mat2, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & bmm_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & mat2) {
    return at::_ops::bmm_out::call(self, mat2, out);
}

// aten::bmm.out(Tensor self, Tensor mat2, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & bmm_outf(const at::Tensor & self, const at::Tensor & mat2, at::Tensor & out) {
    return at::_ops::bmm_out::call(self, mat2, out);
}

// aten::broadcast_tensors(Tensor[] tensors) -> Tensor[]
TORCH_API inline ::std::vector<at::Tensor> broadcast_tensors(at::TensorList tensors) {
    return at::_ops::broadcast_tensors::call(tensors);
}

// aten::broadcast_to(Tensor(a) self, int[] size) -> Tensor(a)
TORCH_API inline at::Tensor broadcast_to(const at::Tensor & self, at::IntArrayRef size) {
    return at::_ops::broadcast_to::call(self, size);
}

// aten::cat(Tensor[] tensors, int dim=0) -> Tensor
TORCH_API inline at::Tensor cat(at::TensorList tensors, int64_t dim=0) {
    return at::_ops::cat::call(tensors, dim);
}

// aten::cat.out(Tensor[] tensors, int dim=0, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & cat_out(at::Tensor & out, at::TensorList tensors, int64_t dim=0) {
    return at::_ops::cat_out::call(tensors, dim, out);
}

// aten::cat.out(Tensor[] tensors, int dim=0, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & cat_outf(at::TensorList tensors, int64_t dim, at::Tensor & out) {
    return at::_ops::cat_out::call(tensors, dim, out);
}

// aten::cat.names(Tensor[] tensors, Dimname dim) -> Tensor
TORCH_API inline at::Tensor cat(at::TensorList tensors, at::Dimname dim) {
    return at::_ops::cat_names::call(tensors, dim);
}

// aten::cat.names_out(Tensor[] tensors, Dimname dim, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & cat_out(at::Tensor & out, at::TensorList tensors, at::Dimname dim) {
    return at::_ops::cat_names_out::call(tensors, dim, out);
}

// aten::cat.names_out(Tensor[] tensors, Dimname dim, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & cat_outf(at::TensorList tensors, at::Dimname dim, at::Tensor & out) {
    return at::_ops::cat_names_out::call(tensors, dim, out);
}

// aten::concat(Tensor[] tensors, int dim=0) -> Tensor
TORCH_API inline at::Tensor concat(at::TensorList tensors, int64_t dim=0) {
    return at::_ops::concat::call(tensors, dim);
}

// aten::concat.out(Tensor[] tensors, int dim=0, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & concat_out(at::Tensor & out, at::TensorList tensors, int64_t dim=0) {
    return at::_ops::concat_out::call(tensors, dim, out);
}

// aten::concat.out(Tensor[] tensors, int dim=0, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & concat_outf(at::TensorList tensors, int64_t dim, at::Tensor & out) {
    return at::_ops::concat_out::call(tensors, dim, out);
}

// aten::concat.names(Tensor[] tensors, Dimname dim) -> Tensor
TORCH_API inline at::Tensor concat(at::TensorList tensors, at::Dimname dim) {
    return at::_ops::concat_names::call(tensors, dim);
}

// aten::concat.names_out(Tensor[] tensors, Dimname dim, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & concat_out(at::Tensor & out, at::TensorList tensors, at::Dimname dim) {
    return at::_ops::concat_names_out::call(tensors, dim, out);
}

// aten::concat.names_out(Tensor[] tensors, Dimname dim, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & concat_outf(at::TensorList tensors, at::Dimname dim, at::Tensor & out) {
    return at::_ops::concat_names_out::call(tensors, dim, out);
}

// aten::block_diag(Tensor[] tensors) -> Tensor
TORCH_API inline at::Tensor block_diag(at::TensorList tensors) {
    return at::_ops::block_diag::call(tensors);
}

// aten::ceil(Tensor self) -> Tensor
TORCH_API inline at::Tensor ceil(const at::Tensor & self) {
    return at::_ops::ceil::call(self);
}

// aten::ceil_(Tensor(a!) self) -> Tensor(a!)
TORCH_API inline at::Tensor & ceil_(at::Tensor & self) {
    return at::_ops::ceil_::call(self);
}

// aten::ceil.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & ceil_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::ceil_out::call(self, out);
}

// aten::ceil.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & ceil_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::ceil_out::call(self, out);
}

// aten::chain_matmul(Tensor[] matrices) -> Tensor
TORCH_API inline at::Tensor chain_matmul(at::TensorList matrices) {
    return at::_ops::chain_matmul::call(matrices);
}

// aten::chain_matmul.out(Tensor[] matrices, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & chain_matmul_out(at::Tensor & out, at::TensorList matrices) {
    return at::_ops::chain_matmul_out::call(matrices, out);
}

// aten::chain_matmul.out(Tensor[] matrices, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & chain_matmul_outf(at::TensorList matrices, at::Tensor & out) {
    return at::_ops::chain_matmul_out::call(matrices, out);
}

// aten::unsafe_chunk(Tensor self, int chunks, int dim=0) -> Tensor[]
TORCH_API inline ::std::vector<at::Tensor> unsafe_chunk(const at::Tensor & self, int64_t chunks, int64_t dim=0) {
    return at::_ops::unsafe_chunk::call(self, chunks, dim);
}

// aten::chunk(Tensor(a) self, int chunks, int dim=0) -> Tensor(a)[]
TORCH_API inline ::std::vector<at::Tensor> chunk(const at::Tensor & self, int64_t chunks, int64_t dim=0) {
    return at::_ops::chunk::call(self, chunks, dim);
}

// aten::tensor_split.sections(Tensor(a) self, int sections, int dim=0) -> Tensor(a)[]
TORCH_API inline ::std::vector<at::Tensor> tensor_split(const at::Tensor & self, int64_t sections, int64_t dim=0) {
    return at::_ops::tensor_split_sections::call(self, sections, dim);
}

// aten::tensor_split.indices(Tensor(a) self, int[] indices, int dim=0) -> Tensor(a)[]
TORCH_API inline ::std::vector<at::Tensor> tensor_split(const at::Tensor & self, at::IntArrayRef indices, int64_t dim=0) {
    return at::_ops::tensor_split_indices::call(self, indices, dim);
}

// aten::tensor_split.tensor_indices_or_sections(Tensor(a) self, Tensor tensor_indices_or_sections, int dim=0) -> Tensor(a)[]
TORCH_API inline ::std::vector<at::Tensor> tensor_split(const at::Tensor & self, const at::Tensor & tensor_indices_or_sections, int64_t dim=0) {
    return at::_ops::tensor_split_tensor_indices_or_sections::call(self, tensor_indices_or_sections, dim);
}

// aten::clamp(Tensor self, Scalar? min=None, Scalar? max=None) -> Tensor
TORCH_API inline at::Tensor clamp(const at::Tensor & self, const c10::optional<at::Scalar> & min, const c10::optional<at::Scalar> & max=c10::nullopt) {
    return at::_ops::clamp::call(self, min, max);
}

// aten::clamp.Tensor(Tensor self, Tensor? min=None, Tensor? max=None) -> Tensor
TORCH_API inline at::Tensor clamp(const at::Tensor & self, const c10::optional<at::Tensor> & min={}, const c10::optional<at::Tensor> & max={}) {
    return at::_ops::clamp_Tensor::call(self, min, max);
}

// aten::clamp_(Tensor(a!) self, Scalar? min=None, Scalar? max=None) -> Tensor(a!)
TORCH_API inline at::Tensor & clamp_(at::Tensor & self, const c10::optional<at::Scalar> & min, const c10::optional<at::Scalar> & max=c10::nullopt) {
    return at::_ops::clamp_::call(self, min, max);
}

// aten::clamp_.Tensor(Tensor(a!) self, Tensor? min=None, Tensor? max=None) -> Tensor(a!)
TORCH_API inline at::Tensor & clamp_(at::Tensor & self, const c10::optional<at::Tensor> & min={}, const c10::optional<at::Tensor> & max={}) {
    return at::_ops::clamp__Tensor::call(self, min, max);
}

// aten::clamp.out(Tensor self, Scalar? min=None, Scalar? max=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & clamp_out(at::Tensor & out, const at::Tensor & self, const c10::optional<at::Scalar> & min, const c10::optional<at::Scalar> & max=c10::nullopt) {
    return at::_ops::clamp_out::call(self, min, max, out);
}

// aten::clamp.out(Tensor self, Scalar? min=None, Scalar? max=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & clamp_outf(const at::Tensor & self, const c10::optional<at::Scalar> & min, const c10::optional<at::Scalar> & max, at::Tensor & out) {
    return at::_ops::clamp_out::call(self, min, max, out);
}

// aten::clamp.Tensor_out(Tensor self, Tensor? min=None, Tensor? max=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & clamp_out(at::Tensor & out, const at::Tensor & self, const c10::optional<at::Tensor> & min={}, const c10::optional<at::Tensor> & max={}) {
    return at::_ops::clamp_Tensor_out::call(self, min, max, out);
}

// aten::clamp.Tensor_out(Tensor self, Tensor? min=None, Tensor? max=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & clamp_outf(const at::Tensor & self, const c10::optional<at::Tensor> & min, const c10::optional<at::Tensor> & max, at::Tensor & out) {
    return at::_ops::clamp_Tensor_out::call(self, min, max, out);
}

// aten::clamp_max(Tensor self, Scalar max) -> Tensor
TORCH_API inline at::Tensor clamp_max(const at::Tensor & self, const at::Scalar & max) {
    return at::_ops::clamp_max::call(self, max);
}

// aten::clamp_max.Tensor(Tensor self, Tensor max) -> Tensor
TORCH_API inline at::Tensor clamp_max(const at::Tensor & self, const at::Tensor & max) {
    return at::_ops::clamp_max_Tensor::call(self, max);
}

// aten::clamp_max_(Tensor(a!) self, Scalar max) -> Tensor(a!)
TORCH_API inline at::Tensor & clamp_max_(at::Tensor & self, const at::Scalar & max) {
    return at::_ops::clamp_max_::call(self, max);
}

// aten::clamp_max_.Tensor(Tensor(a!) self, Tensor max) -> Tensor(a!)
TORCH_API inline at::Tensor & clamp_max_(at::Tensor & self, const at::Tensor & max) {
    return at::_ops::clamp_max__Tensor::call(self, max);
}

// aten::clamp_max.out(Tensor self, Scalar max, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & clamp_max_out(at::Tensor & out, const at::Tensor & self, const at::Scalar & max) {
    return at::_ops::clamp_max_out::call(self, max, out);
}

// aten::clamp_max.out(Tensor self, Scalar max, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & clamp_max_outf(const at::Tensor & self, const at::Scalar & max, at::Tensor & out) {
    return at::_ops::clamp_max_out::call(self, max, out);
}

// aten::clamp_max.Tensor_out(Tensor self, Tensor max, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & clamp_max_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & max) {
    return at::_ops::clamp_max_Tensor_out::call(self, max, out);
}

// aten::clamp_max.Tensor_out(Tensor self, Tensor max, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & clamp_max_outf(const at::Tensor & self, const at::Tensor & max, at::Tensor & out) {
    return at::_ops::clamp_max_Tensor_out::call(self, max, out);
}

// aten::clamp_min(Tensor self, Scalar min) -> Tensor
TORCH_API inline at::Tensor clamp_min(const at::Tensor & self, const at::Scalar & min) {
    return at::_ops::clamp_min::call(self, min);
}

// aten::clamp_min.Tensor(Tensor self, Tensor min) -> Tensor
TORCH_API inline at::Tensor clamp_min(const at::Tensor & self, const at::Tensor & min) {
    return at::_ops::clamp_min_Tensor::call(self, min);
}

// aten::clamp_min_(Tensor(a!) self, Scalar min) -> Tensor(a!)
TORCH_API inline at::Tensor & clamp_min_(at::Tensor & self, const at::Scalar & min) {
    return at::_ops::clamp_min_::call(self, min);
}

// aten::clamp_min_.Tensor(Tensor(a!) self, Tensor min) -> Tensor(a!)
TORCH_API inline at::Tensor & clamp_min_(at::Tensor & self, const at::Tensor & min) {
    return at::_ops::clamp_min__Tensor::call(self, min);
}

// aten::clamp_min.out(Tensor self, Scalar min, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & clamp_min_out(at::Tensor & out, const at::Tensor & self, const at::Scalar & min) {
    return at::_ops::clamp_min_out::call(self, min, out);
}

// aten::clamp_min.out(Tensor self, Scalar min, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & clamp_min_outf(const at::Tensor & self, const at::Scalar & min, at::Tensor & out) {
    return at::_ops::clamp_min_out::call(self, min, out);
}

// aten::clamp_min.Tensor_out(Tensor self, Tensor min, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & clamp_min_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & min) {
    return at::_ops::clamp_min_Tensor_out::call(self, min, out);
}

// aten::clamp_min.Tensor_out(Tensor self, Tensor min, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & clamp_min_outf(const at::Tensor & self, const at::Tensor & min, at::Tensor & out) {
    return at::_ops::clamp_min_Tensor_out::call(self, min, out);
}

// aten::clip(Tensor self, Scalar? min=None, Scalar? max=None) -> Tensor
TORCH_API inline at::Tensor clip(const at::Tensor & self, const c10::optional<at::Scalar> & min, const c10::optional<at::Scalar> & max=c10::nullopt) {
    return at::_ops::clip::call(self, min, max);
}

// aten::clip.Tensor(Tensor self, Tensor? min=None, Tensor? max=None) -> Tensor
TORCH_API inline at::Tensor clip(const at::Tensor & self, const c10::optional<at::Tensor> & min={}, const c10::optional<at::Tensor> & max={}) {
    return at::_ops::clip_Tensor::call(self, min, max);
}

// aten::clip_(Tensor(a!) self, Scalar? min=None, Scalar? max=None) -> Tensor(a!)
TORCH_API inline at::Tensor & clip_(at::Tensor & self, const c10::optional<at::Scalar> & min, const c10::optional<at::Scalar> & max=c10::nullopt) {
    return at::_ops::clip_::call(self, min, max);
}

// aten::clip_.Tensor(Tensor(a!) self, Tensor? min=None, Tensor? max=None) -> Tensor(a!)
TORCH_API inline at::Tensor & clip_(at::Tensor & self, const c10::optional<at::Tensor> & min={}, const c10::optional<at::Tensor> & max={}) {
    return at::_ops::clip__Tensor::call(self, min, max);
}

// aten::clip.out(Tensor self, Scalar? min=None, Scalar? max=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & clip_out(at::Tensor & out, const at::Tensor & self, const c10::optional<at::Scalar> & min, const c10::optional<at::Scalar> & max=c10::nullopt) {
    return at::_ops::clip_out::call(self, min, max, out);
}

// aten::clip.out(Tensor self, Scalar? min=None, Scalar? max=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & clip_outf(const at::Tensor & self, const c10::optional<at::Scalar> & min, const c10::optional<at::Scalar> & max, at::Tensor & out) {
    return at::_ops::clip_out::call(self, min, max, out);
}

// aten::clip.Tensor_out(Tensor self, Tensor? min=None, Tensor? max=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & clip_out(at::Tensor & out, const at::Tensor & self, const c10::optional<at::Tensor> & min={}, const c10::optional<at::Tensor> & max={}) {
    return at::_ops::clip_Tensor_out::call(self, min, max, out);
}

// aten::clip.Tensor_out(Tensor self, Tensor? min=None, Tensor? max=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & clip_outf(const at::Tensor & self, const c10::optional<at::Tensor> & min, const c10::optional<at::Tensor> & max, at::Tensor & out) {
    return at::_ops::clip_Tensor_out::call(self, min, max, out);
}

// aten::cudnn_is_acceptable(Tensor self) -> bool
TORCH_API inline bool cudnn_is_acceptable(const at::Tensor & self) {
    return at::_ops::cudnn_is_acceptable::call(self);
}

// aten::complex(Tensor real, Tensor imag) -> Tensor
TORCH_API inline at::Tensor complex(const at::Tensor & real, const at::Tensor & imag) {
    return at::_ops::complex::call(real, imag);
}

// aten::complex.out(Tensor real, Tensor imag, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & complex_out(at::Tensor & out, const at::Tensor & real, const at::Tensor & imag) {
    return at::_ops::complex_out::call(real, imag, out);
}

// aten::complex.out(Tensor real, Tensor imag, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & complex_outf(const at::Tensor & real, const at::Tensor & imag, at::Tensor & out) {
    return at::_ops::complex_out::call(real, imag, out);
}

// aten::polar(Tensor abs, Tensor angle) -> Tensor
TORCH_API inline at::Tensor polar(const at::Tensor & abs, const at::Tensor & angle) {
    return at::_ops::polar::call(abs, angle);
}

// aten::polar.out(Tensor abs, Tensor angle, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & polar_out(at::Tensor & out, const at::Tensor & abs, const at::Tensor & angle) {
    return at::_ops::polar_out::call(abs, angle, out);
}

// aten::polar.out(Tensor abs, Tensor angle, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & polar_outf(const at::Tensor & abs, const at::Tensor & angle, at::Tensor & out) {
    return at::_ops::polar_out::call(abs, angle, out);
}

// aten::constant_pad_nd(Tensor self, int[] pad, Scalar value=0) -> Tensor
TORCH_API inline at::Tensor constant_pad_nd(const at::Tensor & self, at::IntArrayRef pad, const at::Scalar & value=0) {
    return at::_ops::constant_pad_nd::call(self, pad, value);
}

// aten::convolution(Tensor input, Tensor weight, Tensor? bias, int[] stride, int[] padding, int[] dilation, bool transposed, int[] output_padding, int groups) -> Tensor
TORCH_API inline at::Tensor convolution(const at::Tensor & input, const at::Tensor & weight, const c10::optional<at::Tensor> & bias, at::IntArrayRef stride, at::IntArrayRef padding, at::IntArrayRef dilation, bool transposed, at::IntArrayRef output_padding, int64_t groups) {
    return at::_ops::convolution::call(input, weight, bias, stride, padding, dilation, transposed, output_padding, groups);
}

// aten::convolution_overrideable(Tensor input, Tensor weight, Tensor? bias, int[] stride, int[] padding, int[] dilation, bool transposed, int[] output_padding, int groups) -> Tensor
TORCH_API inline at::Tensor convolution_overrideable(const at::Tensor & input, const at::Tensor & weight, const c10::optional<at::Tensor> & bias, at::IntArrayRef stride, at::IntArrayRef padding, at::IntArrayRef dilation, bool transposed, at::IntArrayRef output_padding, int64_t groups) {
    return at::_ops::convolution_overrideable::call(input, weight, bias, stride, padding, dilation, transposed, output_padding, groups);
}

// aten::convolution_backward_overrideable(Tensor grad_output, Tensor input, Tensor weight, int[] stride, int[] padding, int[] dilation, bool transposed, int[] output_padding, int groups, bool[3] output_mask) -> (Tensor grad_input, Tensor grad_weight, Tensor grad_bias)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor,at::Tensor> convolution_backward_overrideable(const at::Tensor & grad_output, const at::Tensor & input, const at::Tensor & weight, at::IntArrayRef stride, at::IntArrayRef padding, at::IntArrayRef dilation, bool transposed, at::IntArrayRef output_padding, int64_t groups, ::std::array<bool,3> output_mask) {
    return at::_ops::convolution_backward_overrideable::call(grad_output, input, weight, stride, padding, dilation, transposed, output_padding, groups, output_mask);
}

// aten::_convolution(Tensor input, Tensor weight, Tensor? bias, int[] stride, int[] padding, int[] dilation, bool transposed, int[] output_padding, int groups, bool benchmark, bool deterministic, bool cudnn_enabled, bool allow_tf32) -> Tensor
TORCH_API inline at::Tensor _convolution(const at::Tensor & input, const at::Tensor & weight, const c10::optional<at::Tensor> & bias, at::IntArrayRef stride, at::IntArrayRef padding, at::IntArrayRef dilation, bool transposed, at::IntArrayRef output_padding, int64_t groups, bool benchmark, bool deterministic, bool cudnn_enabled, bool allow_tf32) {
    return at::_ops::_convolution::call(input, weight, bias, stride, padding, dilation, transposed, output_padding, groups, benchmark, deterministic, cudnn_enabled, allow_tf32);
}

// aten::_convolution.deprecated(Tensor input, Tensor weight, Tensor? bias, int[] stride, int[] padding, int[] dilation, bool transposed, int[] output_padding, int groups, bool benchmark, bool deterministic, bool cudnn_enabled) -> Tensor
TORCH_API inline at::Tensor _convolution(const at::Tensor & input, const at::Tensor & weight, const c10::optional<at::Tensor> & bias, at::IntArrayRef stride, at::IntArrayRef padding, at::IntArrayRef dilation, bool transposed, at::IntArrayRef output_padding, int64_t groups, bool benchmark, bool deterministic, bool cudnn_enabled) {
    return at::_ops::_convolution_deprecated::call(input, weight, bias, stride, padding, dilation, transposed, output_padding, groups, benchmark, deterministic, cudnn_enabled);
}

// aten::_convolution_mode(Tensor input, Tensor weight, Tensor? bias, int[] stride, str padding, int[] dilation, int groups) -> Tensor
TORCH_API inline at::Tensor _convolution_mode(const at::Tensor & input, const at::Tensor & weight, const c10::optional<at::Tensor> & bias, at::IntArrayRef stride, c10::string_view padding, at::IntArrayRef dilation, int64_t groups) {
    return at::_ops::_convolution_mode::call(input, weight, bias, stride, padding, dilation, groups);
}

// aten::_convolution_nogroup(Tensor input, Tensor weight, Tensor? bias, int[] stride, int[] padding, int[] dilation, bool transposed, int[] output_padding) -> Tensor
TORCH_API inline at::Tensor _convolution_nogroup(const at::Tensor & input, const at::Tensor & weight, const c10::optional<at::Tensor> & bias, at::IntArrayRef stride, at::IntArrayRef padding, at::IntArrayRef dilation, bool transposed, at::IntArrayRef output_padding) {
    return at::_ops::_convolution_nogroup::call(input, weight, bias, stride, padding, dilation, transposed, output_padding);
}

// aten::_convolution_double_backward(Tensor? ggI, Tensor? ggW, Tensor? ggb, Tensor gO, Tensor weight, Tensor self, int[] stride, int[] padding, int[] dilation, bool transposed, int[] output_padding, int groups, bool benchmark, bool deterministic, bool cudnn_enabled, bool allow_tf32, bool[3] output_mask) -> (Tensor, Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor,at::Tensor> _convolution_double_backward(const c10::optional<at::Tensor> & ggI, const c10::optional<at::Tensor> & ggW, const c10::optional<at::Tensor> & ggb, const at::Tensor & gO, const at::Tensor & weight, const at::Tensor & self, at::IntArrayRef stride, at::IntArrayRef padding, at::IntArrayRef dilation, bool transposed, at::IntArrayRef output_padding, int64_t groups, bool benchmark, bool deterministic, bool cudnn_enabled, bool allow_tf32, ::std::array<bool,3> output_mask) {
    return at::_ops::_convolution_double_backward::call(ggI, ggW, ggb, gO, weight, self, stride, padding, dilation, transposed, output_padding, groups, benchmark, deterministic, cudnn_enabled, allow_tf32, output_mask);
}

// aten::conv1d(Tensor input, Tensor weight, Tensor? bias=None, int[1] stride=1, int[1] padding=0, int[1] dilation=1, int groups=1) -> Tensor
TORCH_API inline at::Tensor conv1d(const at::Tensor & input, const at::Tensor & weight, const c10::optional<at::Tensor> & bias={}, at::IntArrayRef stride=1, at::IntArrayRef padding=0, at::IntArrayRef dilation=1, int64_t groups=1) {
    return at::_ops::conv1d::call(input, weight, bias, stride, padding, dilation, groups);
}

// aten::conv2d(Tensor input, Tensor weight, Tensor? bias=None, int[2] stride=1, int[2] padding=0, int[2] dilation=1, int groups=1) -> Tensor
TORCH_API inline at::Tensor conv2d(const at::Tensor & input, const at::Tensor & weight, const c10::optional<at::Tensor> & bias={}, at::IntArrayRef stride=1, at::IntArrayRef padding=0, at::IntArrayRef dilation=1, int64_t groups=1) {
    return at::_ops::conv2d::call(input, weight, bias, stride, padding, dilation, groups);
}

// aten::conv3d(Tensor input, Tensor weight, Tensor? bias=None, int[3] stride=1, int[3] padding=0, int[3] dilation=1, int groups=1) -> Tensor
TORCH_API inline at::Tensor conv3d(const at::Tensor & input, const at::Tensor & weight, const c10::optional<at::Tensor> & bias={}, at::IntArrayRef stride=1, at::IntArrayRef padding=0, at::IntArrayRef dilation=1, int64_t groups=1) {
    return at::_ops::conv3d::call(input, weight, bias, stride, padding, dilation, groups);
}

// aten::conv1d.padding(Tensor input, Tensor weight, Tensor? bias=None, int[1] stride=1, str padding="valid", int[1] dilation=1, int groups=1) -> Tensor
TORCH_API inline at::Tensor conv1d(const at::Tensor & input, const at::Tensor & weight, const c10::optional<at::Tensor> & bias, at::IntArrayRef stride, c10::string_view padding, at::IntArrayRef dilation=1, int64_t groups=1) {
    return at::_ops::conv1d_padding::call(input, weight, bias, stride, padding, dilation, groups);
}

// aten::conv2d.padding(Tensor input, Tensor weight, Tensor? bias=None, int[2] stride=1, str padding="valid", int[2] dilation=1, int groups=1) -> Tensor
TORCH_API inline at::Tensor conv2d(const at::Tensor & input, const at::Tensor & weight, const c10::optional<at::Tensor> & bias, at::IntArrayRef stride, c10::string_view padding, at::IntArrayRef dilation=1, int64_t groups=1) {
    return at::_ops::conv2d_padding::call(input, weight, bias, stride, padding, dilation, groups);
}

// aten::conv3d.padding(Tensor input, Tensor weight, Tensor? bias=None, int[3] stride=1, str padding="valid", int[3] dilation=1, int groups=1) -> Tensor
TORCH_API inline at::Tensor conv3d(const at::Tensor & input, const at::Tensor & weight, const c10::optional<at::Tensor> & bias, at::IntArrayRef stride, c10::string_view padding, at::IntArrayRef dilation=1, int64_t groups=1) {
    return at::_ops::conv3d_padding::call(input, weight, bias, stride, padding, dilation, groups);
}

// aten::conv_tbc(Tensor self, Tensor weight, Tensor bias, int pad=0) -> Tensor
TORCH_API inline at::Tensor conv_tbc(const at::Tensor & self, const at::Tensor & weight, const at::Tensor & bias, int64_t pad=0) {
    return at::_ops::conv_tbc::call(self, weight, bias, pad);
}

// aten::conv_tbc_backward(Tensor self, Tensor input, Tensor weight, Tensor bias, int pad) -> (Tensor, Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor,at::Tensor> conv_tbc_backward(const at::Tensor & self, const at::Tensor & input, const at::Tensor & weight, const at::Tensor & bias, int64_t pad) {
    return at::_ops::conv_tbc_backward::call(self, input, weight, bias, pad);
}

// aten::conv_transpose1d(Tensor input, Tensor weight, Tensor? bias=None, int[1] stride=1, int[1] padding=0, int[1] output_padding=0, int groups=1, int[1] dilation=1) -> Tensor
TORCH_API inline at::Tensor conv_transpose1d(const at::Tensor & input, const at::Tensor & weight, const c10::optional<at::Tensor> & bias={}, at::IntArrayRef stride=1, at::IntArrayRef padding=0, at::IntArrayRef output_padding=0, int64_t groups=1, at::IntArrayRef dilation=1) {
    return at::_ops::conv_transpose1d::call(input, weight, bias, stride, padding, output_padding, groups, dilation);
}

// aten::conv_transpose2d.input(Tensor input, Tensor weight, Tensor? bias=None, int[2] stride=1, int[2] padding=0, int[2] output_padding=0, int groups=1, int[2] dilation=1) -> Tensor
TORCH_API inline at::Tensor conv_transpose2d(const at::Tensor & input, const at::Tensor & weight, const c10::optional<at::Tensor> & bias={}, at::IntArrayRef stride=1, at::IntArrayRef padding=0, at::IntArrayRef output_padding=0, int64_t groups=1, at::IntArrayRef dilation=1) {
    return at::_ops::conv_transpose2d_input::call(input, weight, bias, stride, padding, output_padding, groups, dilation);
}

// aten::conv_transpose3d.input(Tensor input, Tensor weight, Tensor? bias=None, int[3] stride=1, int[3] padding=0, int[3] output_padding=0, int groups=1, int[3] dilation=1) -> Tensor
TORCH_API inline at::Tensor conv_transpose3d(const at::Tensor & input, const at::Tensor & weight, const c10::optional<at::Tensor> & bias={}, at::IntArrayRef stride=1, at::IntArrayRef padding=0, at::IntArrayRef output_padding=0, int64_t groups=1, at::IntArrayRef dilation=1) {
    return at::_ops::conv_transpose3d_input::call(input, weight, bias, stride, padding, output_padding, groups, dilation);
}

// aten::_copy_from(Tensor self, Tensor dst, bool non_blocking=False) -> Tensor
TORCH_API inline at::Tensor _copy_from(const at::Tensor & self, const at::Tensor & dst, bool non_blocking=false) {
    return at::_ops::_copy_from::call(self, dst, non_blocking);
}

// aten::_copy_from_and_resize(Tensor self, Tensor dst) -> Tensor
TORCH_API inline at::Tensor _copy_from_and_resize(const at::Tensor & self, const at::Tensor & dst) {
    return at::_ops::_copy_from_and_resize::call(self, dst);
}

// aten::cos(Tensor self) -> Tensor
TORCH_API inline at::Tensor cos(const at::Tensor & self) {
    return at::_ops::cos::call(self);
}

// aten::cos_(Tensor(a!) self) -> Tensor(a!)
TORCH_API inline at::Tensor & cos_(at::Tensor & self) {
    return at::_ops::cos_::call(self);
}

// aten::cos.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & cos_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::cos_out::call(self, out);
}

// aten::cos.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & cos_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::cos_out::call(self, out);
}

// aten::cosh(Tensor self) -> Tensor
TORCH_API inline at::Tensor cosh(const at::Tensor & self) {
    return at::_ops::cosh::call(self);
}

// aten::cosh_(Tensor(a!) self) -> Tensor(a!)
TORCH_API inline at::Tensor & cosh_(at::Tensor & self) {
    return at::_ops::cosh_::call(self);
}

// aten::cosh.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & cosh_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::cosh_out::call(self, out);
}

// aten::cosh.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & cosh_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::cosh_out::call(self, out);
}

// aten::cosine_embedding_loss(Tensor input1, Tensor input2, Tensor target, float margin=0.0, int reduction=Mean) -> Tensor
TORCH_API inline at::Tensor cosine_embedding_loss(const at::Tensor & input1, const at::Tensor & input2, const at::Tensor & target, double margin=0.0, int64_t reduction=at::Reduction::Mean) {
    return at::_ops::cosine_embedding_loss::call(input1, input2, target, margin, reduction);
}

// aten::count_nonzero.dim_IntList(Tensor self, int[] dim) -> Tensor
TORCH_API inline at::Tensor count_nonzero(const at::Tensor & self, at::IntArrayRef dim) {
    return at::_ops::count_nonzero_dim_IntList::call(self, dim);
}

// aten::count_nonzero(Tensor self, int? dim=None) -> Tensor
TORCH_API inline at::Tensor count_nonzero(const at::Tensor & self, c10::optional<int64_t> dim=c10::nullopt) {
    return at::_ops::count_nonzero::call(self, dim);
}

// aten::cov(Tensor self, *, int correction=1, Tensor? fweights=None, Tensor? aweights=None) -> Tensor
TORCH_API inline at::Tensor cov(const at::Tensor & self, int64_t correction=1, const c10::optional<at::Tensor> & fweights={}, const c10::optional<at::Tensor> & aweights={}) {
    return at::_ops::cov::call(self, correction, fweights, aweights);
}

// aten::corrcoef(Tensor self) -> Tensor
TORCH_API inline at::Tensor corrcoef(const at::Tensor & self) {
    return at::_ops::corrcoef::call(self);
}

// aten::cudnn_affine_grid_generator(Tensor theta, int N, int C, int H, int W) -> Tensor grid
TORCH_API inline at::Tensor cudnn_affine_grid_generator(const at::Tensor & theta, int64_t N, int64_t C, int64_t H, int64_t W) {
    return at::_ops::cudnn_affine_grid_generator::call(theta, N, C, H, W);
}

// aten::cudnn_affine_grid_generator_backward(Tensor grad, int N, int C, int H, int W) -> Tensor grad_theta
TORCH_API inline at::Tensor cudnn_affine_grid_generator_backward(const at::Tensor & grad, int64_t N, int64_t C, int64_t H, int64_t W) {
    return at::_ops::cudnn_affine_grid_generator_backward::call(grad, N, C, H, W);
}

// aten::cudnn_batch_norm(Tensor input, Tensor weight, Tensor? bias, Tensor? running_mean, Tensor? running_var, bool training, float exponential_average_factor, float epsilon) -> (Tensor, Tensor, Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor,at::Tensor,at::Tensor> cudnn_batch_norm(const at::Tensor & input, const at::Tensor & weight, const c10::optional<at::Tensor> & bias, const c10::optional<at::Tensor> & running_mean, const c10::optional<at::Tensor> & running_var, bool training, double exponential_average_factor, double epsilon) {
    return at::_ops::cudnn_batch_norm::call(input, weight, bias, running_mean, running_var, training, exponential_average_factor, epsilon);
}

// aten::cudnn_batch_norm_backward(Tensor input, Tensor grad_output, Tensor weight, Tensor? running_mean, Tensor? running_var, Tensor? save_mean, Tensor? save_var, float epsilon, Tensor reserveSpace) -> (Tensor, Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor,at::Tensor> cudnn_batch_norm_backward(const at::Tensor & input, const at::Tensor & grad_output, const at::Tensor & weight, const c10::optional<at::Tensor> & running_mean, const c10::optional<at::Tensor> & running_var, const c10::optional<at::Tensor> & save_mean, const c10::optional<at::Tensor> & save_var, double epsilon, const at::Tensor & reserveSpace) {
    return at::_ops::cudnn_batch_norm_backward::call(input, grad_output, weight, running_mean, running_var, save_mean, save_var, epsilon, reserveSpace);
}

// aten::cudnn_convolution.deprecated(Tensor self, Tensor weight, Tensor? bias, int[] padding, int[] stride, int[] dilation, int groups, bool benchmark, bool deterministic) -> Tensor
TORCH_API inline at::Tensor cudnn_convolution(const at::Tensor & self, const at::Tensor & weight, const c10::optional<at::Tensor> & bias, at::IntArrayRef padding, at::IntArrayRef stride, at::IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic) {
    return at::_ops::cudnn_convolution_deprecated::call(self, weight, bias, padding, stride, dilation, groups, benchmark, deterministic);
}

// aten::cudnn_convolution.deprecated2(Tensor self, Tensor weight, int[] padding, int[] stride, int[] dilation, int groups, bool benchmark, bool deterministic) -> Tensor
TORCH_API inline at::Tensor cudnn_convolution(const at::Tensor & self, const at::Tensor & weight, at::IntArrayRef padding, at::IntArrayRef stride, at::IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic) {
    return at::_ops::cudnn_convolution_deprecated2::call(self, weight, padding, stride, dilation, groups, benchmark, deterministic);
}

// aten::cudnn_convolution(Tensor self, Tensor weight, int[] padding, int[] stride, int[] dilation, int groups, bool benchmark, bool deterministic, bool allow_tf32) -> Tensor
TORCH_API inline at::Tensor cudnn_convolution(const at::Tensor & self, const at::Tensor & weight, at::IntArrayRef padding, at::IntArrayRef stride, at::IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic, bool allow_tf32) {
    return at::_ops::cudnn_convolution::call(self, weight, padding, stride, dilation, groups, benchmark, deterministic, allow_tf32);
}

// aten::cudnn_convolution_backward_input(int[] self_size, Tensor grad_output, Tensor weight, int[] padding, int[] stride, int[] dilation, int groups, bool benchmark, bool deterministic, bool allow_tf32) -> Tensor
TORCH_API inline at::Tensor cudnn_convolution_backward_input(at::IntArrayRef self_size, const at::Tensor & grad_output, const at::Tensor & weight, at::IntArrayRef padding, at::IntArrayRef stride, at::IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic, bool allow_tf32) {
    return at::_ops::cudnn_convolution_backward_input::call(self_size, grad_output, weight, padding, stride, dilation, groups, benchmark, deterministic, allow_tf32);
}

// aten::cudnn_convolution_backward(Tensor self, Tensor grad_output, Tensor weight, int[] padding, int[] stride, int[] dilation, int groups, bool benchmark, bool deterministic, bool allow_tf32, bool[2] output_mask) -> (Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> cudnn_convolution_backward(const at::Tensor & self, const at::Tensor & grad_output, const at::Tensor & weight, at::IntArrayRef padding, at::IntArrayRef stride, at::IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic, bool allow_tf32, ::std::array<bool,2> output_mask) {
    return at::_ops::cudnn_convolution_backward::call(self, grad_output, weight, padding, stride, dilation, groups, benchmark, deterministic, allow_tf32, output_mask);
}

// aten::cudnn_convolution_backward_weight(int[] weight_size, Tensor grad_output, Tensor self, int[] padding, int[] stride, int[] dilation, int groups, bool benchmark, bool deterministic, bool allow_tf32) -> Tensor
TORCH_API inline at::Tensor cudnn_convolution_backward_weight(at::IntArrayRef weight_size, const at::Tensor & grad_output, const at::Tensor & self, at::IntArrayRef padding, at::IntArrayRef stride, at::IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic, bool allow_tf32) {
    return at::_ops::cudnn_convolution_backward_weight::call(weight_size, grad_output, self, padding, stride, dilation, groups, benchmark, deterministic, allow_tf32);
}

// aten::cudnn_convolution_transpose.deprecated(Tensor self, Tensor weight, Tensor? bias, int[] padding, int[] output_padding, int[] stride, int[] dilation, int groups, bool benchmark, bool deterministic) -> Tensor
TORCH_API inline at::Tensor cudnn_convolution_transpose(const at::Tensor & self, const at::Tensor & weight, const c10::optional<at::Tensor> & bias, at::IntArrayRef padding, at::IntArrayRef output_padding, at::IntArrayRef stride, at::IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic) {
    return at::_ops::cudnn_convolution_transpose_deprecated::call(self, weight, bias, padding, output_padding, stride, dilation, groups, benchmark, deterministic);
}

// aten::cudnn_convolution_transpose.deprecated2(Tensor self, Tensor weight, int[] padding, int[] output_padding, int[] stride, int[] dilation, int groups, bool benchmark, bool deterministic) -> Tensor
TORCH_API inline at::Tensor cudnn_convolution_transpose(const at::Tensor & self, const at::Tensor & weight, at::IntArrayRef padding, at::IntArrayRef output_padding, at::IntArrayRef stride, at::IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic) {
    return at::_ops::cudnn_convolution_transpose_deprecated2::call(self, weight, padding, output_padding, stride, dilation, groups, benchmark, deterministic);
}

// aten::cudnn_convolution_transpose(Tensor self, Tensor weight, int[] padding, int[] output_padding, int[] stride, int[] dilation, int groups, bool benchmark, bool deterministic, bool allow_tf32) -> Tensor
TORCH_API inline at::Tensor cudnn_convolution_transpose(const at::Tensor & self, const at::Tensor & weight, at::IntArrayRef padding, at::IntArrayRef output_padding, at::IntArrayRef stride, at::IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic, bool allow_tf32) {
    return at::_ops::cudnn_convolution_transpose::call(self, weight, padding, output_padding, stride, dilation, groups, benchmark, deterministic, allow_tf32);
}

// aten::cudnn_convolution_transpose_backward(Tensor self, Tensor grad_output, Tensor weight, int[] padding, int[] output_padding, int[] stride, int[] dilation, int groups, bool benchmark, bool deterministic, bool allow_tf32, bool[2] output_mask) -> (Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> cudnn_convolution_transpose_backward(const at::Tensor & self, const at::Tensor & grad_output, const at::Tensor & weight, at::IntArrayRef padding, at::IntArrayRef output_padding, at::IntArrayRef stride, at::IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic, bool allow_tf32, ::std::array<bool,2> output_mask) {
    return at::_ops::cudnn_convolution_transpose_backward::call(self, grad_output, weight, padding, output_padding, stride, dilation, groups, benchmark, deterministic, allow_tf32, output_mask);
}

// aten::cudnn_convolution_transpose_backward_input(Tensor grad_output, Tensor weight, int[] padding, int[] stride, int[] dilation, int groups, bool benchmark, bool deterministic, bool allow_tf32) -> Tensor
TORCH_API inline at::Tensor cudnn_convolution_transpose_backward_input(const at::Tensor & grad_output, const at::Tensor & weight, at::IntArrayRef padding, at::IntArrayRef stride, at::IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic, bool allow_tf32) {
    return at::_ops::cudnn_convolution_transpose_backward_input::call(grad_output, weight, padding, stride, dilation, groups, benchmark, deterministic, allow_tf32);
}

// aten::cudnn_convolution_transpose_backward_weight(int[] weight_size, Tensor grad_output, Tensor self, int[] padding, int[] stride, int[] dilation, int groups, bool benchmark, bool deterministic, bool allow_tf32) -> Tensor
TORCH_API inline at::Tensor cudnn_convolution_transpose_backward_weight(at::IntArrayRef weight_size, const at::Tensor & grad_output, const at::Tensor & self, at::IntArrayRef padding, at::IntArrayRef stride, at::IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic, bool allow_tf32) {
    return at::_ops::cudnn_convolution_transpose_backward_weight::call(weight_size, grad_output, self, padding, stride, dilation, groups, benchmark, deterministic, allow_tf32);
}

// aten::cudnn_convolution_relu(Tensor self, Tensor weight, Tensor? bias, int[] stride, int[] padding, int[] dilation, int groups) -> Tensor
TORCH_API inline at::Tensor cudnn_convolution_relu(const at::Tensor & self, const at::Tensor & weight, const c10::optional<at::Tensor> & bias, at::IntArrayRef stride, at::IntArrayRef padding, at::IntArrayRef dilation, int64_t groups) {
    return at::_ops::cudnn_convolution_relu::call(self, weight, bias, stride, padding, dilation, groups);
}

// aten::cudnn_convolution_add_relu(Tensor self, Tensor weight, Tensor z, Scalar? alpha, Tensor? bias, int[] stride, int[] padding, int[] dilation, int groups) -> Tensor
TORCH_API inline at::Tensor cudnn_convolution_add_relu(const at::Tensor & self, const at::Tensor & weight, const at::Tensor & z, const c10::optional<at::Scalar> & alpha, const c10::optional<at::Tensor> & bias, at::IntArrayRef stride, at::IntArrayRef padding, at::IntArrayRef dilation, int64_t groups) {
    return at::_ops::cudnn_convolution_add_relu::call(self, weight, z, alpha, bias, stride, padding, dilation, groups);
}

// aten::cudnn_grid_sampler(Tensor self, Tensor grid) -> Tensor output
TORCH_API inline at::Tensor cudnn_grid_sampler(const at::Tensor & self, const at::Tensor & grid) {
    return at::_ops::cudnn_grid_sampler::call(self, grid);
}

// aten::cudnn_grid_sampler_backward(Tensor self, Tensor grid, Tensor grad_output) -> (Tensor grad_self, Tensor grad_grid)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> cudnn_grid_sampler_backward(const at::Tensor & self, const at::Tensor & grid, const at::Tensor & grad_output) {
    return at::_ops::cudnn_grid_sampler_backward::call(self, grid, grad_output);
}

// aten::cummax(Tensor self, int dim) -> (Tensor values, Tensor indices)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> cummax(const at::Tensor & self, int64_t dim) {
    return at::_ops::cummax::call(self, dim);
}

// aten::cummax.out(Tensor self, int dim, *, Tensor(a!) values, Tensor(b!) indices) -> (Tensor(a!) values, Tensor(b!) indices)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> cummax_out(at::Tensor & values, at::Tensor & indices, const at::Tensor & self, int64_t dim) {
    return at::_ops::cummax_out::call(self, dim, values, indices);
}

// aten::cummax.out(Tensor self, int dim, *, Tensor(a!) values, Tensor(b!) indices) -> (Tensor(a!) values, Tensor(b!) indices)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> cummax_outf(const at::Tensor & self, int64_t dim, at::Tensor & values, at::Tensor & indices) {
    return at::_ops::cummax_out::call(self, dim, values, indices);
}

// aten::cummax.dimname(Tensor self, Dimname dim) -> (Tensor values, Tensor indices)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> cummax(const at::Tensor & self, at::Dimname dim) {
    return at::_ops::cummax_dimname::call(self, dim);
}

// aten::cummax.dimname_out(Tensor self, Dimname dim, *, Tensor(a!) values, Tensor(b!) indices) -> (Tensor(a!) values, Tensor(b!) indices)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> cummax_out(at::Tensor & values, at::Tensor & indices, const at::Tensor & self, at::Dimname dim) {
    return at::_ops::cummax_dimname_out::call(self, dim, values, indices);
}

// aten::cummax.dimname_out(Tensor self, Dimname dim, *, Tensor(a!) values, Tensor(b!) indices) -> (Tensor(a!) values, Tensor(b!) indices)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> cummax_outf(const at::Tensor & self, at::Dimname dim, at::Tensor & values, at::Tensor & indices) {
    return at::_ops::cummax_dimname_out::call(self, dim, values, indices);
}

// aten::_cummax_helper(Tensor self, Tensor(a!) values, Tensor(b!) indices, int dim) -> ()
TORCH_API inline void _cummax_helper(const at::Tensor & self, at::Tensor & values, at::Tensor & indices, int64_t dim) {
    return at::_ops::_cummax_helper::call(self, values, indices, dim);
}

// aten::cummin(Tensor self, int dim) -> (Tensor values, Tensor indices)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> cummin(const at::Tensor & self, int64_t dim) {
    return at::_ops::cummin::call(self, dim);
}

// aten::cummin.out(Tensor self, int dim, *, Tensor(a!) values, Tensor(b!) indices) -> (Tensor(a!) values, Tensor(b!) indices)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> cummin_out(at::Tensor & values, at::Tensor & indices, const at::Tensor & self, int64_t dim) {
    return at::_ops::cummin_out::call(self, dim, values, indices);
}

// aten::cummin.out(Tensor self, int dim, *, Tensor(a!) values, Tensor(b!) indices) -> (Tensor(a!) values, Tensor(b!) indices)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> cummin_outf(const at::Tensor & self, int64_t dim, at::Tensor & values, at::Tensor & indices) {
    return at::_ops::cummin_out::call(self, dim, values, indices);
}

// aten::cummin.dimname(Tensor self, Dimname dim) -> (Tensor values, Tensor indices)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> cummin(const at::Tensor & self, at::Dimname dim) {
    return at::_ops::cummin_dimname::call(self, dim);
}

// aten::cummin.dimname_out(Tensor self, Dimname dim, *, Tensor(a!) values, Tensor(b!) indices) -> (Tensor(a!) values, Tensor(b!) indices)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> cummin_out(at::Tensor & values, at::Tensor & indices, const at::Tensor & self, at::Dimname dim) {
    return at::_ops::cummin_dimname_out::call(self, dim, values, indices);
}

// aten::cummin.dimname_out(Tensor self, Dimname dim, *, Tensor(a!) values, Tensor(b!) indices) -> (Tensor(a!) values, Tensor(b!) indices)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> cummin_outf(const at::Tensor & self, at::Dimname dim, at::Tensor & values, at::Tensor & indices) {
    return at::_ops::cummin_dimname_out::call(self, dim, values, indices);
}

// aten::_cummin_helper(Tensor self, Tensor(a!) values, Tensor(b!) indices, int dim) -> ()
TORCH_API inline void _cummin_helper(const at::Tensor & self, at::Tensor & values, at::Tensor & indices, int64_t dim) {
    return at::_ops::_cummin_helper::call(self, values, indices, dim);
}

// aten::cummaxmin_backward(Tensor grad, Tensor input, Tensor indices, int dim) -> Tensor
TORCH_API inline at::Tensor cummaxmin_backward(const at::Tensor & grad, const at::Tensor & input, const at::Tensor & indices, int64_t dim) {
    return at::_ops::cummaxmin_backward::call(grad, input, indices, dim);
}

// aten::cumprod(Tensor self, int dim, *, ScalarType? dtype=None) -> Tensor
TORCH_API inline at::Tensor cumprod(const at::Tensor & self, int64_t dim, c10::optional<at::ScalarType> dtype=c10::nullopt) {
    return at::_ops::cumprod::call(self, dim, dtype);
}

// aten::cumprod.out(Tensor self, int dim, *, ScalarType? dtype=None, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & cumprod_out(at::Tensor & out, const at::Tensor & self, int64_t dim, c10::optional<at::ScalarType> dtype=c10::nullopt) {
    return at::_ops::cumprod_out::call(self, dim, dtype, out);
}

// aten::cumprod.out(Tensor self, int dim, *, ScalarType? dtype=None, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & cumprod_outf(const at::Tensor & self, int64_t dim, c10::optional<at::ScalarType> dtype, at::Tensor & out) {
    return at::_ops::cumprod_out::call(self, dim, dtype, out);
}

// aten::cumprod.dimname(Tensor self, Dimname dim, *, ScalarType? dtype=None) -> Tensor
TORCH_API inline at::Tensor cumprod(const at::Tensor & self, at::Dimname dim, c10::optional<at::ScalarType> dtype=c10::nullopt) {
    return at::_ops::cumprod_dimname::call(self, dim, dtype);
}

// aten::cumprod.dimname_out(Tensor self, Dimname dim, *, ScalarType? dtype=None, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & cumprod_out(at::Tensor & out, const at::Tensor & self, at::Dimname dim, c10::optional<at::ScalarType> dtype=c10::nullopt) {
    return at::_ops::cumprod_dimname_out::call(self, dim, dtype, out);
}

// aten::cumprod.dimname_out(Tensor self, Dimname dim, *, ScalarType? dtype=None, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & cumprod_outf(const at::Tensor & self, at::Dimname dim, c10::optional<at::ScalarType> dtype, at::Tensor & out) {
    return at::_ops::cumprod_dimname_out::call(self, dim, dtype, out);
}

// aten::cumprod_backward(Tensor grad, Tensor input, int dim, Tensor output) -> Tensor
TORCH_API inline at::Tensor cumprod_backward(const at::Tensor & grad, const at::Tensor & input, int64_t dim, const at::Tensor & output) {
    return at::_ops::cumprod_backward::call(grad, input, dim, output);
}

// aten::cumsum(Tensor self, int dim, *, ScalarType? dtype=None) -> Tensor
TORCH_API inline at::Tensor cumsum(const at::Tensor & self, int64_t dim, c10::optional<at::ScalarType> dtype=c10::nullopt) {
    return at::_ops::cumsum::call(self, dim, dtype);
}

// aten::cumsum.out(Tensor self, int dim, *, ScalarType? dtype=None, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & cumsum_out(at::Tensor & out, const at::Tensor & self, int64_t dim, c10::optional<at::ScalarType> dtype=c10::nullopt) {
    return at::_ops::cumsum_out::call(self, dim, dtype, out);
}

// aten::cumsum.out(Tensor self, int dim, *, ScalarType? dtype=None, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & cumsum_outf(const at::Tensor & self, int64_t dim, c10::optional<at::ScalarType> dtype, at::Tensor & out) {
    return at::_ops::cumsum_out::call(self, dim, dtype, out);
}

// aten::cumsum.dimname(Tensor self, Dimname dim, *, ScalarType? dtype=None) -> Tensor
TORCH_API inline at::Tensor cumsum(const at::Tensor & self, at::Dimname dim, c10::optional<at::ScalarType> dtype=c10::nullopt) {
    return at::_ops::cumsum_dimname::call(self, dim, dtype);
}

// aten::cumsum.dimname_out(Tensor self, Dimname dim, *, ScalarType? dtype=None, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & cumsum_out(at::Tensor & out, const at::Tensor & self, at::Dimname dim, c10::optional<at::ScalarType> dtype=c10::nullopt) {
    return at::_ops::cumsum_dimname_out::call(self, dim, dtype, out);
}

// aten::cumsum.dimname_out(Tensor self, Dimname dim, *, ScalarType? dtype=None, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & cumsum_outf(const at::Tensor & self, at::Dimname dim, c10::optional<at::ScalarType> dtype, at::Tensor & out) {
    return at::_ops::cumsum_dimname_out::call(self, dim, dtype, out);
}

// aten::cumulative_trapezoid.x(Tensor y, Tensor x, *, int dim=-1) -> Tensor
TORCH_API inline at::Tensor cumulative_trapezoid(const at::Tensor & y, const at::Tensor & x, int64_t dim=-1) {
    return at::_ops::cumulative_trapezoid_x::call(y, x, dim);
}

// aten::cumulative_trapezoid.dx(Tensor y, *, Scalar dx=1, int dim=-1) -> Tensor
TORCH_API inline at::Tensor cumulative_trapezoid(const at::Tensor & y, const at::Scalar & dx=1, int64_t dim=-1) {
    return at::_ops::cumulative_trapezoid_dx::call(y, dx, dim);
}

// aten::ctc_loss.IntList(Tensor log_probs, Tensor targets, int[] input_lengths, int[] target_lengths, int blank=0, int reduction=Mean, bool zero_infinity=False) -> Tensor
TORCH_API inline at::Tensor ctc_loss(const at::Tensor & log_probs, const at::Tensor & targets, at::IntArrayRef input_lengths, at::IntArrayRef target_lengths, int64_t blank=0, int64_t reduction=at::Reduction::Mean, bool zero_infinity=false) {
    return at::_ops::ctc_loss_IntList::call(log_probs, targets, input_lengths, target_lengths, blank, reduction, zero_infinity);
}

// aten::ctc_loss.Tensor(Tensor log_probs, Tensor targets, Tensor input_lengths, Tensor target_lengths, int blank=0, int reduction=Mean, bool zero_infinity=False) -> Tensor
TORCH_API inline at::Tensor ctc_loss(const at::Tensor & log_probs, const at::Tensor & targets, const at::Tensor & input_lengths, const at::Tensor & target_lengths, int64_t blank=0, int64_t reduction=at::Reduction::Mean, bool zero_infinity=false) {
    return at::_ops::ctc_loss_Tensor::call(log_probs, targets, input_lengths, target_lengths, blank, reduction, zero_infinity);
}

// aten::_ctc_loss(Tensor log_probs, Tensor targets, int[] input_lengths, int[] target_lengths, int blank=0, bool zero_infinity=False) -> (Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> _ctc_loss(const at::Tensor & log_probs, const at::Tensor & targets, at::IntArrayRef input_lengths, at::IntArrayRef target_lengths, int64_t blank=0, bool zero_infinity=false) {
    return at::_ops::_ctc_loss::call(log_probs, targets, input_lengths, target_lengths, blank, zero_infinity);
}

// aten::_ctc_loss_backward(Tensor grad, Tensor log_probs, Tensor targets, int[] input_lengths, int[] target_lengths, Tensor neg_log_likelihood, Tensor log_alpha, int blank, bool zero_infinity=False) -> Tensor
TORCH_API inline at::Tensor _ctc_loss_backward(const at::Tensor & grad, const at::Tensor & log_probs, const at::Tensor & targets, at::IntArrayRef input_lengths, at::IntArrayRef target_lengths, const at::Tensor & neg_log_likelihood, const at::Tensor & log_alpha, int64_t blank, bool zero_infinity=false) {
    return at::_ops::_ctc_loss_backward::call(grad, log_probs, targets, input_lengths, target_lengths, neg_log_likelihood, log_alpha, blank, zero_infinity);
}

// aten::diag_embed(Tensor self, int offset=0, int dim1=-2, int dim2=-1) -> Tensor
TORCH_API inline at::Tensor diag_embed(const at::Tensor & self, int64_t offset=0, int64_t dim1=-2, int64_t dim2=-1) {
    return at::_ops::diag_embed::call(self, offset, dim1, dim2);
}

// aten::diagflat(Tensor self, int offset=0) -> Tensor
TORCH_API inline at::Tensor diagflat(const at::Tensor & self, int64_t offset=0) {
    return at::_ops::diagflat::call(self, offset);
}

// aten::diagonal(Tensor(a) self, int offset=0, int dim1=0, int dim2=1) -> Tensor(a)
TORCH_API inline at::Tensor diagonal(const at::Tensor & self, int64_t offset=0, int64_t dim1=0, int64_t dim2=1) {
    return at::_ops::diagonal::call(self, offset, dim1, dim2);
}

// aten::diagonal.Dimname(Tensor(a) self, *, Dimname outdim, Dimname dim1, Dimname dim2, int offset=0) -> Tensor(a)
TORCH_API inline at::Tensor diagonal(const at::Tensor & self, at::Dimname outdim, at::Dimname dim1, at::Dimname dim2, int64_t offset=0) {
    return at::_ops::diagonal_Dimname::call(self, outdim, dim1, dim2, offset);
}

// aten::diagonal_backward(Tensor grad_output, int[] input_sizes, int offset, int dim1, int dim2) -> Tensor
TORCH_API inline at::Tensor diagonal_backward(const at::Tensor & grad_output, at::IntArrayRef input_sizes, int64_t offset, int64_t dim1, int64_t dim2) {
    return at::_ops::diagonal_backward::call(grad_output, input_sizes, offset, dim1, dim2);
}

// aten::diff(Tensor self, int n=1, int dim=-1, Tensor? prepend=None, Tensor? append=None) -> Tensor
TORCH_API inline at::Tensor diff(const at::Tensor & self, int64_t n=1, int64_t dim=-1, const c10::optional<at::Tensor> & prepend={}, const c10::optional<at::Tensor> & append={}) {
    return at::_ops::diff::call(self, n, dim, prepend, append);
}

// aten::diff.out(Tensor self, int n=1, int dim=-1, Tensor? prepend=None, Tensor? append=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & diff_out(at::Tensor & out, const at::Tensor & self, int64_t n=1, int64_t dim=-1, const c10::optional<at::Tensor> & prepend={}, const c10::optional<at::Tensor> & append={}) {
    return at::_ops::diff_out::call(self, n, dim, prepend, append, out);
}

// aten::diff.out(Tensor self, int n=1, int dim=-1, Tensor? prepend=None, Tensor? append=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & diff_outf(const at::Tensor & self, int64_t n, int64_t dim, const c10::optional<at::Tensor> & prepend, const c10::optional<at::Tensor> & append, at::Tensor & out) {
    return at::_ops::diff_out::call(self, n, dim, prepend, append, out);
}

// aten::gradient.scalarint(Tensor self, *, Scalar? spacing=None, int? dim=None, int edge_order=1) -> Tensor[]
TORCH_API inline ::std::vector<at::Tensor> gradient(const at::Tensor & self, const c10::optional<at::Scalar> & spacing=c10::nullopt, c10::optional<int64_t> dim=c10::nullopt, int64_t edge_order=1) {
    return at::_ops::gradient_scalarint::call(self, spacing, dim, edge_order);
}

// aten::gradient.scalararray(Tensor self, *, Scalar spacing, int[] dim, int edge_order=1) -> Tensor[]
TORCH_API inline ::std::vector<at::Tensor> gradient(const at::Tensor & self, const at::Scalar & spacing, at::IntArrayRef dim, int64_t edge_order=1) {
    return at::_ops::gradient_scalararray::call(self, spacing, dim, edge_order);
}

// aten::gradient.array(Tensor self, *, int[] dim, int edge_order=1) -> Tensor[]
TORCH_API inline ::std::vector<at::Tensor> gradient(const at::Tensor & self, at::IntArrayRef dim, int64_t edge_order=1) {
    return at::_ops::gradient_array::call(self, dim, edge_order);
}

// aten::gradient.scalarrayint(Tensor self, *, Scalar[] spacing, int? dim=None, int edge_order=1) -> Tensor[]
TORCH_API inline ::std::vector<at::Tensor> gradient(const at::Tensor & self, at::ArrayRef<at::Scalar> spacing, c10::optional<int64_t> dim=c10::nullopt, int64_t edge_order=1) {
    return at::_ops::gradient_scalarrayint::call(self, spacing, dim, edge_order);
}

// aten::gradient.scalarrayarray(Tensor self, *, Scalar[] spacing, int[] dim, int edge_order=1) -> Tensor[]
TORCH_API inline ::std::vector<at::Tensor> gradient(const at::Tensor & self, at::ArrayRef<at::Scalar> spacing, at::IntArrayRef dim, int64_t edge_order=1) {
    return at::_ops::gradient_scalarrayarray::call(self, spacing, dim, edge_order);
}

// aten::gradient.tensorarrayint(Tensor self, *, Tensor[] spacing, int? dim=None, int edge_order=1) -> Tensor[]
TORCH_API inline ::std::vector<at::Tensor> gradient(const at::Tensor & self, at::TensorList spacing, c10::optional<int64_t> dim=c10::nullopt, int64_t edge_order=1) {
    return at::_ops::gradient_tensorarrayint::call(self, spacing, dim, edge_order);
}

// aten::gradient.tensorarray(Tensor self, *, Tensor[] spacing, int[] dim, int edge_order=1) -> Tensor[]
TORCH_API inline ::std::vector<at::Tensor> gradient(const at::Tensor & self, at::TensorList spacing, at::IntArrayRef dim, int64_t edge_order=1) {
    return at::_ops::gradient_tensorarray::call(self, spacing, dim, edge_order);
}

// aten::div.Tensor(Tensor self, Tensor other) -> Tensor
TORCH_API inline at::Tensor div(const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::div_Tensor::call(self, other);
}

// aten::div.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & div_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::div_out::call(self, other, out);
}

// aten::div.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & div_outf(const at::Tensor & self, const at::Tensor & other, at::Tensor & out) {
    return at::_ops::div_out::call(self, other, out);
}

// aten::div.Tensor_mode(Tensor self, Tensor other, *, str? rounding_mode) -> Tensor
TORCH_API inline at::Tensor div(const at::Tensor & self, const at::Tensor & other, c10::optional<c10::string_view> rounding_mode) {
    return at::_ops::div_Tensor_mode::call(self, other, rounding_mode);
}

// aten::div.out_mode(Tensor self, Tensor other, *, str? rounding_mode, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & div_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & other, c10::optional<c10::string_view> rounding_mode) {
    return at::_ops::div_out_mode::call(self, other, rounding_mode, out);
}

// aten::div.out_mode(Tensor self, Tensor other, *, str? rounding_mode, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & div_outf(const at::Tensor & self, const at::Tensor & other, c10::optional<c10::string_view> rounding_mode, at::Tensor & out) {
    return at::_ops::div_out_mode::call(self, other, rounding_mode, out);
}

// aten::div.Scalar(Tensor self, Scalar other) -> Tensor
TORCH_API inline at::Tensor div(const at::Tensor & self, const at::Scalar & other) {
    return at::_ops::div_Scalar::call(self, other);
}

// aten::div.Scalar_mode(Tensor self, Scalar other, *, str? rounding_mode) -> Tensor
TORCH_API inline at::Tensor div(const at::Tensor & self, const at::Scalar & other, c10::optional<c10::string_view> rounding_mode) {
    return at::_ops::div_Scalar_mode::call(self, other, rounding_mode);
}

// aten::divide.Tensor(Tensor self, Tensor other) -> Tensor
TORCH_API inline at::Tensor divide(const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::divide_Tensor::call(self, other);
}

// aten::divide.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & divide_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::divide_out::call(self, other, out);
}

// aten::divide.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & divide_outf(const at::Tensor & self, const at::Tensor & other, at::Tensor & out) {
    return at::_ops::divide_out::call(self, other, out);
}

// aten::divide.Scalar(Tensor self, Scalar other) -> Tensor
TORCH_API inline at::Tensor divide(const at::Tensor & self, const at::Scalar & other) {
    return at::_ops::divide_Scalar::call(self, other);
}

// aten::divide.Tensor_mode(Tensor self, Tensor other, *, str? rounding_mode) -> Tensor
TORCH_API inline at::Tensor divide(const at::Tensor & self, const at::Tensor & other, c10::optional<c10::string_view> rounding_mode) {
    return at::_ops::divide_Tensor_mode::call(self, other, rounding_mode);
}

// aten::divide.out_mode(Tensor self, Tensor other, *, str? rounding_mode, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & divide_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & other, c10::optional<c10::string_view> rounding_mode) {
    return at::_ops::divide_out_mode::call(self, other, rounding_mode, out);
}

// aten::divide.out_mode(Tensor self, Tensor other, *, str? rounding_mode, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & divide_outf(const at::Tensor & self, const at::Tensor & other, c10::optional<c10::string_view> rounding_mode, at::Tensor & out) {
    return at::_ops::divide_out_mode::call(self, other, rounding_mode, out);
}

// aten::divide.Scalar_mode(Tensor self, Scalar other, *, str? rounding_mode) -> Tensor
TORCH_API inline at::Tensor divide(const at::Tensor & self, const at::Scalar & other, c10::optional<c10::string_view> rounding_mode) {
    return at::_ops::divide_Scalar_mode::call(self, other, rounding_mode);
}

// aten::true_divide.Tensor(Tensor self, Tensor other) -> Tensor
TORCH_API inline at::Tensor true_divide(const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::true_divide_Tensor::call(self, other);
}

// aten::true_divide.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & true_divide_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::true_divide_out::call(self, other, out);
}

// aten::true_divide.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & true_divide_outf(const at::Tensor & self, const at::Tensor & other, at::Tensor & out) {
    return at::_ops::true_divide_out::call(self, other, out);
}

// aten::true_divide.Scalar(Tensor self, Scalar other) -> Tensor
TORCH_API inline at::Tensor true_divide(const at::Tensor & self, const at::Scalar & other) {
    return at::_ops::true_divide_Scalar::call(self, other);
}

// aten::dot(Tensor self, Tensor tensor) -> Tensor
TORCH_API inline at::Tensor dot(const at::Tensor & self, const at::Tensor & tensor) {
    return at::_ops::dot::call(self, tensor);
}

// aten::dot.out(Tensor self, Tensor tensor, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & dot_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & tensor) {
    return at::_ops::dot_out::call(self, tensor, out);
}

// aten::dot.out(Tensor self, Tensor tensor, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & dot_outf(const at::Tensor & self, const at::Tensor & tensor, at::Tensor & out) {
    return at::_ops::dot_out::call(self, tensor, out);
}

// aten::vdot(Tensor self, Tensor other) -> Tensor
TORCH_API inline at::Tensor vdot(const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::vdot::call(self, other);
}

// aten::vdot.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & vdot_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::vdot_out::call(self, other, out);
}

// aten::vdot.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & vdot_outf(const at::Tensor & self, const at::Tensor & other, at::Tensor & out) {
    return at::_ops::vdot_out::call(self, other, out);
}

// aten::einsum(str equation, Tensor[] tensors) -> Tensor
TORCH_API inline at::Tensor einsum(c10::string_view equation, at::TensorList tensors) {
    return at::_ops::einsum::call(equation, tensors);
}

// aten::embedding(Tensor weight, Tensor indices, int padding_idx=-1, bool scale_grad_by_freq=False, bool sparse=False) -> Tensor
TORCH_API inline at::Tensor embedding(const at::Tensor & weight, const at::Tensor & indices, int64_t padding_idx=-1, bool scale_grad_by_freq=false, bool sparse=false) {
    return at::_ops::embedding::call(weight, indices, padding_idx, scale_grad_by_freq, sparse);
}

// aten::embedding_backward(Tensor grad, Tensor indices, int num_weights, int padding_idx, bool scale_grad_by_freq, bool sparse) -> Tensor
TORCH_API inline at::Tensor embedding_backward(const at::Tensor & grad, const at::Tensor & indices, int64_t num_weights, int64_t padding_idx, bool scale_grad_by_freq, bool sparse) {
    return at::_ops::embedding_backward::call(grad, indices, num_weights, padding_idx, scale_grad_by_freq, sparse);
}

// aten::embedding_dense_backward(Tensor grad_output, Tensor indices, int num_weights, int padding_idx, bool scale_grad_by_freq) -> Tensor
TORCH_API inline at::Tensor embedding_dense_backward(const at::Tensor & grad_output, const at::Tensor & indices, int64_t num_weights, int64_t padding_idx, bool scale_grad_by_freq) {
    return at::_ops::embedding_dense_backward::call(grad_output, indices, num_weights, padding_idx, scale_grad_by_freq);
}

// aten::embedding_renorm_(Tensor(a!) self, Tensor indices, float max_norm, float norm_type) -> Tensor(a!)
TORCH_API inline at::Tensor & embedding_renorm_(at::Tensor & self, const at::Tensor & indices, double max_norm, double norm_type) {
    return at::_ops::embedding_renorm_::call(self, indices, max_norm, norm_type);
}

// aten::embedding_sparse_backward(Tensor grad, Tensor indices, int num_weights, int padding_idx, bool scale_grad_by_freq) -> Tensor
TORCH_API inline at::Tensor embedding_sparse_backward(const at::Tensor & grad, const at::Tensor & indices, int64_t num_weights, int64_t padding_idx, bool scale_grad_by_freq) {
    return at::_ops::embedding_sparse_backward::call(grad, indices, num_weights, padding_idx, scale_grad_by_freq);
}

// aten::_embedding_bag_forward_only(Tensor weight, Tensor indices, Tensor offsets, bool scale_grad_by_freq=False, int mode=0, bool sparse=False, Tensor? per_sample_weights=None, bool include_last_offset=False, int padding_idx=-1) -> (Tensor, Tensor, Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor,at::Tensor,at::Tensor> _embedding_bag_forward_only(const at::Tensor & weight, const at::Tensor & indices, const at::Tensor & offsets, bool scale_grad_by_freq=false, int64_t mode=0, bool sparse=false, const c10::optional<at::Tensor> & per_sample_weights={}, bool include_last_offset=false, int64_t padding_idx=-1) {
    return at::_ops::_embedding_bag_forward_only::call(weight, indices, offsets, scale_grad_by_freq, mode, sparse, per_sample_weights, include_last_offset, padding_idx);
}

// aten::_rowwise_prune(Tensor weight, Tensor mask, ScalarType compressed_indices_dtype) -> (Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> _rowwise_prune(const at::Tensor & weight, const at::Tensor & mask, at::ScalarType compressed_indices_dtype) {
    return at::_ops::_rowwise_prune::call(weight, mask, compressed_indices_dtype);
}

// aten::row_stack(Tensor[] tensors) -> Tensor
TORCH_API inline at::Tensor row_stack(at::TensorList tensors) {
    return at::_ops::row_stack::call(tensors);
}

// aten::row_stack.out(Tensor[] tensors, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & row_stack_out(at::Tensor & out, at::TensorList tensors) {
    return at::_ops::row_stack_out::call(tensors, out);
}

// aten::row_stack.out(Tensor[] tensors, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & row_stack_outf(at::TensorList tensors, at::Tensor & out) {
    return at::_ops::row_stack_out::call(tensors, out);
}

// aten::embedding_bag(Tensor weight, Tensor indices, Tensor offsets, bool scale_grad_by_freq=False, int mode=0, bool sparse=False, Tensor? per_sample_weights=None, bool include_last_offset=False) -> (Tensor, Tensor, Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor,at::Tensor,at::Tensor> embedding_bag(const at::Tensor & weight, const at::Tensor & indices, const at::Tensor & offsets, bool scale_grad_by_freq=false, int64_t mode=0, bool sparse=false, const c10::optional<at::Tensor> & per_sample_weights={}, bool include_last_offset=false) {
    return at::_ops::embedding_bag::call(weight, indices, offsets, scale_grad_by_freq, mode, sparse, per_sample_weights, include_last_offset);
}

// aten::embedding_bag.padding_idx(Tensor weight, Tensor indices, Tensor offsets, bool scale_grad_by_freq, int mode, bool sparse, Tensor? per_sample_weights, bool include_last_offset, int? padding_idx) -> (Tensor, Tensor, Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor,at::Tensor,at::Tensor> embedding_bag(const at::Tensor & weight, const at::Tensor & indices, const at::Tensor & offsets, bool scale_grad_by_freq, int64_t mode, bool sparse, const c10::optional<at::Tensor> & per_sample_weights, bool include_last_offset, c10::optional<int64_t> padding_idx) {
    return at::_ops::embedding_bag_padding_idx::call(weight, indices, offsets, scale_grad_by_freq, mode, sparse, per_sample_weights, include_last_offset, padding_idx);
}

// aten::_embedding_bag(Tensor weight, Tensor indices, Tensor offsets, bool scale_grad_by_freq=False, int mode=0, bool sparse=False, Tensor? per_sample_weights=None, bool include_last_offset=False, int padding_idx=-1) -> (Tensor, Tensor, Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor,at::Tensor,at::Tensor> _embedding_bag(const at::Tensor & weight, const at::Tensor & indices, const at::Tensor & offsets, bool scale_grad_by_freq=false, int64_t mode=0, bool sparse=false, const c10::optional<at::Tensor> & per_sample_weights={}, bool include_last_offset=false, int64_t padding_idx=-1) {
    return at::_ops::_embedding_bag::call(weight, indices, offsets, scale_grad_by_freq, mode, sparse, per_sample_weights, include_last_offset, padding_idx);
}

// aten::_embedding_bag_backward(Tensor grad, Tensor indices, Tensor offsets, Tensor offset2bag, Tensor bag_size, Tensor maximum_indices, int num_weights, bool scale_grad_by_freq, int mode, bool sparse, Tensor? per_sample_weights, int padding_idx=-1) -> Tensor
TORCH_API inline at::Tensor _embedding_bag_backward(const at::Tensor & grad, const at::Tensor & indices, const at::Tensor & offsets, const at::Tensor & offset2bag, const at::Tensor & bag_size, const at::Tensor & maximum_indices, int64_t num_weights, bool scale_grad_by_freq, int64_t mode, bool sparse, const c10::optional<at::Tensor> & per_sample_weights, int64_t padding_idx=-1) {
    return at::_ops::_embedding_bag_backward::call(grad, indices, offsets, offset2bag, bag_size, maximum_indices, num_weights, scale_grad_by_freq, mode, sparse, per_sample_weights, padding_idx);
}

// aten::_embedding_bag_sparse_backward(Tensor grad, Tensor indices, Tensor offsets, Tensor offset2bag, Tensor bag_size, int num_weights, bool scale_grad_by_freq, int mode, Tensor? per_sample_weights, int padding_idx=-1) -> Tensor
TORCH_API inline at::Tensor _embedding_bag_sparse_backward(const at::Tensor & grad, const at::Tensor & indices, const at::Tensor & offsets, const at::Tensor & offset2bag, const at::Tensor & bag_size, int64_t num_weights, bool scale_grad_by_freq, int64_t mode, const c10::optional<at::Tensor> & per_sample_weights, int64_t padding_idx=-1) {
    return at::_ops::_embedding_bag_sparse_backward::call(grad, indices, offsets, offset2bag, bag_size, num_weights, scale_grad_by_freq, mode, per_sample_weights, padding_idx);
}

// aten::_embedding_bag_dense_backward(Tensor grad, Tensor indices, Tensor offset2bag, Tensor bag_size, Tensor maximum_indices, int num_weights, bool scale_grad_by_freq, int mode, Tensor? per_sample_weights, int padding_idx=-1) -> Tensor
TORCH_API inline at::Tensor _embedding_bag_dense_backward(const at::Tensor & grad, const at::Tensor & indices, const at::Tensor & offset2bag, const at::Tensor & bag_size, const at::Tensor & maximum_indices, int64_t num_weights, bool scale_grad_by_freq, int64_t mode, const c10::optional<at::Tensor> & per_sample_weights, int64_t padding_idx=-1) {
    return at::_ops::_embedding_bag_dense_backward::call(grad, indices, offset2bag, bag_size, maximum_indices, num_weights, scale_grad_by_freq, mode, per_sample_weights, padding_idx);
}

// aten::_embedding_bag_per_sample_weights_backward(Tensor grad, Tensor weight, Tensor indices, Tensor offsets, Tensor offset2bag, int mode, int padding_idx=-1) -> Tensor
TORCH_API inline at::Tensor _embedding_bag_per_sample_weights_backward(const at::Tensor & grad, const at::Tensor & weight, const at::Tensor & indices, const at::Tensor & offsets, const at::Tensor & offset2bag, int64_t mode, int64_t padding_idx=-1) {
    return at::_ops::_embedding_bag_per_sample_weights_backward::call(grad, weight, indices, offsets, offset2bag, mode, padding_idx);
}

// aten::empty.names(int[] size, *, Dimname[]? names, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None, MemoryFormat? memory_format=None) -> Tensor
TORCH_API inline at::Tensor empty(at::IntArrayRef size, c10::optional<at::DimnameList> names, at::TensorOptions options={}, c10::optional<at::MemoryFormat> memory_format=c10::nullopt) {
    return at::_ops::empty_names::call(size, names, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt(), c10::impl::check_tensor_options_and_extract_memory_format(options, memory_format));
}

// aten::empty.names(int[] size, *, Dimname[]? names, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None, MemoryFormat? memory_format=None) -> Tensor
TORCH_API inline at::Tensor empty(at::IntArrayRef size, c10::optional<at::DimnameList> names, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory, c10::optional<at::MemoryFormat> memory_format) {
    return at::_ops::empty_names::call(size, names, dtype, layout, device, pin_memory, memory_format);
}

// aten::empty.memory_format(int[] size, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None, MemoryFormat? memory_format=None) -> Tensor
TORCH_API inline at::Tensor empty(at::IntArrayRef size, at::TensorOptions options={}, c10::optional<at::MemoryFormat> memory_format=c10::nullopt) {
    return at::_ops::empty_memory_format::call(size, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt(), c10::impl::check_tensor_options_and_extract_memory_format(options, memory_format));
}

// aten::empty.memory_format(int[] size, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None, MemoryFormat? memory_format=None) -> Tensor
TORCH_API inline at::Tensor empty(at::IntArrayRef size, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory, c10::optional<at::MemoryFormat> memory_format) {
    return at::_ops::empty_memory_format::call(size, dtype, layout, device, pin_memory, memory_format);
}

// aten::_empty_affine_quantized(int[] size, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None, float scale=1, int zero_point=0, MemoryFormat? memory_format=contiguous_format) -> Tensor
TORCH_API inline at::Tensor _empty_affine_quantized(at::IntArrayRef size, at::TensorOptions options={}, double scale=1, int64_t zero_point=0, c10::optional<at::MemoryFormat> memory_format=MemoryFormat::Contiguous) {
    return at::_ops::_empty_affine_quantized::call(size, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt(), scale, zero_point, c10::impl::check_tensor_options_and_extract_memory_format(options, memory_format));
}

// aten::_empty_affine_quantized(int[] size, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None, float scale=1, int zero_point=0, MemoryFormat? memory_format=contiguous_format) -> Tensor
TORCH_API inline at::Tensor _empty_affine_quantized(at::IntArrayRef size, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory, double scale, int64_t zero_point, c10::optional<at::MemoryFormat> memory_format) {
    return at::_ops::_empty_affine_quantized::call(size, dtype, layout, device, pin_memory, scale, zero_point, memory_format);
}

// aten::_empty_per_channel_affine_quantized(int[] size, *, Tensor scales, Tensor zero_points, int axis, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None, MemoryFormat? memory_format=contiguous_format) -> Tensor
TORCH_API inline at::Tensor _empty_per_channel_affine_quantized(at::IntArrayRef size, const at::Tensor & scales, const at::Tensor & zero_points, int64_t axis, at::TensorOptions options={}, c10::optional<at::MemoryFormat> memory_format=MemoryFormat::Contiguous) {
    return at::_ops::_empty_per_channel_affine_quantized::call(size, scales, zero_points, axis, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt(), c10::impl::check_tensor_options_and_extract_memory_format(options, memory_format));
}

// aten::_empty_per_channel_affine_quantized(int[] size, *, Tensor scales, Tensor zero_points, int axis, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None, MemoryFormat? memory_format=contiguous_format) -> Tensor
TORCH_API inline at::Tensor _empty_per_channel_affine_quantized(at::IntArrayRef size, const at::Tensor & scales, const at::Tensor & zero_points, int64_t axis, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory, c10::optional<at::MemoryFormat> memory_format) {
    return at::_ops::_empty_per_channel_affine_quantized::call(size, scales, zero_points, axis, dtype, layout, device, pin_memory, memory_format);
}

// aten::empty_quantized(int[] size, Tensor qtensor, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None, MemoryFormat? memory_format=None) -> Tensor
TORCH_API inline at::Tensor empty_quantized(at::IntArrayRef size, const at::Tensor & qtensor, at::TensorOptions options={}, c10::optional<at::MemoryFormat> memory_format=c10::nullopt) {
    return at::_ops::empty_quantized::call(size, qtensor, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt(), c10::impl::check_tensor_options_and_extract_memory_format(options, memory_format));
}

// aten::empty_quantized(int[] size, Tensor qtensor, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None, MemoryFormat? memory_format=None) -> Tensor
TORCH_API inline at::Tensor empty_quantized(at::IntArrayRef size, const at::Tensor & qtensor, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory, c10::optional<at::MemoryFormat> memory_format) {
    return at::_ops::empty_quantized::call(size, qtensor, dtype, layout, device, pin_memory, memory_format);
}

// aten::empty.out(int[] size, *, MemoryFormat? memory_format=None, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & empty_out(at::Tensor & out, at::IntArrayRef size, c10::optional<at::MemoryFormat> memory_format=c10::nullopt) {
    return at::_ops::empty_out::call(size, memory_format, out);
}

// aten::empty.out(int[] size, *, MemoryFormat? memory_format=None, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & empty_outf(at::IntArrayRef size, c10::optional<at::MemoryFormat> memory_format, at::Tensor & out) {
    return at::_ops::empty_out::call(size, memory_format, out);
}

// aten::empty_like(Tensor self, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None, MemoryFormat? memory_format=None) -> Tensor
TORCH_API inline at::Tensor empty_like(const at::Tensor & self, at::TensorOptions options={}, c10::optional<at::MemoryFormat> memory_format=c10::nullopt) {
    return at::_ops::empty_like::call(self, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt(), c10::impl::check_tensor_options_and_extract_memory_format(options, memory_format));
}

// aten::empty_like(Tensor self, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None, MemoryFormat? memory_format=None) -> Tensor
TORCH_API inline at::Tensor empty_like(const at::Tensor & self, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory, c10::optional<at::MemoryFormat> memory_format) {
    return at::_ops::empty_like::call(self, dtype, layout, device, pin_memory, memory_format);
}

// aten::empty_strided(int[] size, int[] stride, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor empty_strided(at::IntArrayRef size, at::IntArrayRef stride, at::TensorOptions options={}) {
    return at::_ops::empty_strided::call(size, stride, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt());
}

// aten::empty_strided(int[] size, int[] stride, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor empty_strided(at::IntArrayRef size, at::IntArrayRef stride, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory) {
    return at::_ops::empty_strided::call(size, stride, dtype, layout, device, pin_memory);
}

// aten::erf(Tensor self) -> Tensor
TORCH_API inline at::Tensor erf(const at::Tensor & self) {
    return at::_ops::erf::call(self);
}

// aten::erf_(Tensor(a!) self) -> Tensor(a!)
TORCH_API inline at::Tensor & erf_(at::Tensor & self) {
    return at::_ops::erf_::call(self);
}

// aten::erf.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & erf_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::erf_out::call(self, out);
}

// aten::erf.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & erf_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::erf_out::call(self, out);
}

// aten::erfc(Tensor self) -> Tensor
TORCH_API inline at::Tensor erfc(const at::Tensor & self) {
    return at::_ops::erfc::call(self);
}

// aten::erfc_(Tensor(a!) self) -> Tensor(a!)
TORCH_API inline at::Tensor & erfc_(at::Tensor & self) {
    return at::_ops::erfc_::call(self);
}

// aten::erfc.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & erfc_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::erfc_out::call(self, out);
}

// aten::erfc.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & erfc_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::erfc_out::call(self, out);
}

// aten::exp(Tensor self) -> Tensor
TORCH_API inline at::Tensor exp(const at::Tensor & self) {
    return at::_ops::exp::call(self);
}

// aten::exp_(Tensor(a!) self) -> Tensor(a!)
TORCH_API inline at::Tensor & exp_(at::Tensor & self) {
    return at::_ops::exp_::call(self);
}

// aten::exp.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & exp_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::exp_out::call(self, out);
}

// aten::exp.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & exp_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::exp_out::call(self, out);
}

// aten::exp2(Tensor self) -> Tensor
TORCH_API inline at::Tensor exp2(const at::Tensor & self) {
    return at::_ops::exp2::call(self);
}

// aten::exp2_(Tensor(a!) self) -> Tensor(a!)
TORCH_API inline at::Tensor & exp2_(at::Tensor & self) {
    return at::_ops::exp2_::call(self);
}

// aten::exp2.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & exp2_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::exp2_out::call(self, out);
}

// aten::exp2.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & exp2_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::exp2_out::call(self, out);
}

// aten::expm1(Tensor self) -> Tensor
TORCH_API inline at::Tensor expm1(const at::Tensor & self) {
    return at::_ops::expm1::call(self);
}

// aten::expm1_(Tensor(a!) self) -> Tensor(a!)
TORCH_API inline at::Tensor & expm1_(at::Tensor & self) {
    return at::_ops::expm1_::call(self);
}

// aten::expm1.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & expm1_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::expm1_out::call(self, out);
}

// aten::expm1.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & expm1_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::expm1_out::call(self, out);
}

// aten::eye(int n, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor eye(int64_t n, at::TensorOptions options={}) {
    return at::_ops::eye::call(n, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt());
}

// aten::eye(int n, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor eye(int64_t n, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory) {
    return at::_ops::eye::call(n, dtype, layout, device, pin_memory);
}

// aten::eye.m(int n, int m, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor eye(int64_t n, int64_t m, at::TensorOptions options={}) {
    return at::_ops::eye_m::call(n, m, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt());
}

// aten::eye.m(int n, int m, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor eye(int64_t n, int64_t m, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory) {
    return at::_ops::eye_m::call(n, m, dtype, layout, device, pin_memory);
}

// aten::eye.out(int n, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & eye_out(at::Tensor & out, int64_t n) {
    return at::_ops::eye_out::call(n, out);
}

// aten::eye.out(int n, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & eye_outf(int64_t n, at::Tensor & out) {
    return at::_ops::eye_out::call(n, out);
}

// aten::eye.m_out(int n, int m, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & eye_out(at::Tensor & out, int64_t n, int64_t m) {
    return at::_ops::eye_m_out::call(n, m, out);
}

// aten::eye.m_out(int n, int m, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & eye_outf(int64_t n, int64_t m, at::Tensor & out) {
    return at::_ops::eye_m_out::call(n, m, out);
}

// aten::flatten.using_ints(Tensor(a) self, int start_dim=0, int end_dim=-1) -> Tensor(a)
TORCH_API inline at::Tensor flatten(const at::Tensor & self, int64_t start_dim=0, int64_t end_dim=-1) {
    return at::_ops::flatten_using_ints::call(self, start_dim, end_dim);
}

// aten::flatten.named_out_dim(Tensor(a) self, int start_dim, int end_dim, Dimname out_dim) -> Tensor(a)
TORCH_API inline at::Tensor flatten(const at::Tensor & self, int64_t start_dim, int64_t end_dim, at::Dimname out_dim) {
    return at::_ops::flatten_named_out_dim::call(self, start_dim, end_dim, out_dim);
}

// aten::flatten.using_names(Tensor(a) self, Dimname start_dim, Dimname end_dim, Dimname out_dim) -> Tensor(a)
TORCH_API inline at::Tensor flatten(const at::Tensor & self, at::Dimname start_dim, at::Dimname end_dim, at::Dimname out_dim) {
    return at::_ops::flatten_using_names::call(self, start_dim, end_dim, out_dim);
}

// aten::flatten.DimnameList(Tensor(a) self, Dimname[] dims, Dimname out_dim) -> Tensor(a)
TORCH_API inline at::Tensor flatten(const at::Tensor & self, at::DimnameList dims, at::Dimname out_dim) {
    return at::_ops::flatten_DimnameList::call(self, dims, out_dim);
}

// aten::fill_.Scalar(Tensor(a!) self, Scalar value) -> Tensor(a!)
TORCH_API inline at::Tensor & fill_(at::Tensor & self, const at::Scalar & value) {
    return at::_ops::fill__Scalar::call(self, value);
}

// aten::fill_.Tensor(Tensor(a!) self, Tensor value) -> Tensor(a!)
TORCH_API inline at::Tensor & fill_(at::Tensor & self, const at::Tensor & value) {
    return at::_ops::fill__Tensor::call(self, value);
}

// aten::floor(Tensor self) -> Tensor
TORCH_API inline at::Tensor floor(const at::Tensor & self) {
    return at::_ops::floor::call(self);
}

// aten::floor_(Tensor(a!) self) -> Tensor(a!)
TORCH_API inline at::Tensor & floor_(at::Tensor & self) {
    return at::_ops::floor_::call(self);
}

// aten::floor.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & floor_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::floor_out::call(self, out);
}

// aten::floor.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & floor_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::floor_out::call(self, out);
}

// aten::floor_divide(Tensor self, Tensor other) -> Tensor
TORCH_API inline at::Tensor floor_divide(const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::floor_divide::call(self, other);
}

// aten::floor_divide.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & floor_divide_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::floor_divide_out::call(self, other, out);
}

// aten::floor_divide.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & floor_divide_outf(const at::Tensor & self, const at::Tensor & other, at::Tensor & out) {
    return at::_ops::floor_divide_out::call(self, other, out);
}

// aten::floor_divide.Scalar(Tensor self, Scalar other) -> Tensor
TORCH_API inline at::Tensor floor_divide(const at::Tensor & self, const at::Scalar & other) {
    return at::_ops::floor_divide_Scalar::call(self, other);
}

// aten::frac(Tensor self) -> Tensor
TORCH_API inline at::Tensor frac(const at::Tensor & self) {
    return at::_ops::frac::call(self);
}

// aten::frac_(Tensor(a!) self) -> Tensor(a!)
TORCH_API inline at::Tensor & frac_(at::Tensor & self) {
    return at::_ops::frac_::call(self);
}

// aten::frac.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & frac_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::frac_out::call(self, out);
}

// aten::frac.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & frac_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::frac_out::call(self, out);
}

// aten::full.names(int[] size, Scalar fill_value, *, Dimname[]? names, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor full(at::IntArrayRef size, const at::Scalar & fill_value, c10::optional<at::DimnameList> names, at::TensorOptions options={}) {
    return at::_ops::full_names::call(size, fill_value, names, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt());
}

// aten::full.names(int[] size, Scalar fill_value, *, Dimname[]? names, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor full(at::IntArrayRef size, const at::Scalar & fill_value, c10::optional<at::DimnameList> names, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory) {
    return at::_ops::full_names::call(size, fill_value, names, dtype, layout, device, pin_memory);
}

// aten::full(int[] size, Scalar fill_value, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor full(at::IntArrayRef size, const at::Scalar & fill_value, at::TensorOptions options={}) {
    return at::_ops::full::call(size, fill_value, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt());
}

// aten::full(int[] size, Scalar fill_value, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor full(at::IntArrayRef size, const at::Scalar & fill_value, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory) {
    return at::_ops::full::call(size, fill_value, dtype, layout, device, pin_memory);
}

// aten::full.out(int[] size, Scalar fill_value, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & full_out(at::Tensor & out, at::IntArrayRef size, const at::Scalar & fill_value) {
    return at::_ops::full_out::call(size, fill_value, out);
}

// aten::full.out(int[] size, Scalar fill_value, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & full_outf(at::IntArrayRef size, const at::Scalar & fill_value, at::Tensor & out) {
    return at::_ops::full_out::call(size, fill_value, out);
}

// aten::full_like(Tensor self, Scalar fill_value, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None, MemoryFormat? memory_format=None) -> Tensor
TORCH_API inline at::Tensor full_like(const at::Tensor & self, const at::Scalar & fill_value, at::TensorOptions options={}, c10::optional<at::MemoryFormat> memory_format=c10::nullopt) {
    return at::_ops::full_like::call(self, fill_value, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt(), c10::impl::check_tensor_options_and_extract_memory_format(options, memory_format));
}

// aten::full_like(Tensor self, Scalar fill_value, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None, MemoryFormat? memory_format=None) -> Tensor
TORCH_API inline at::Tensor full_like(const at::Tensor & self, const at::Scalar & fill_value, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory, c10::optional<at::MemoryFormat> memory_format) {
    return at::_ops::full_like::call(self, fill_value, dtype, layout, device, pin_memory, memory_format);
}

// aten::from_file(str filename, bool? shared=None, int? size=0, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor from_file(c10::string_view filename, c10::optional<bool> shared=c10::nullopt, c10::optional<int64_t> size=0, at::TensorOptions options={}) {
    return at::_ops::from_file::call(filename, shared, size, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt());
}

// aten::from_file(str filename, bool? shared=None, int? size=0, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor from_file(c10::string_view filename, c10::optional<bool> shared, c10::optional<int64_t> size, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory) {
    return at::_ops::from_file::call(filename, shared, size, dtype, layout, device, pin_memory);
}

// aten::gcd.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & gcd_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::gcd_out::call(self, other, out);
}

// aten::gcd.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & gcd_outf(const at::Tensor & self, const at::Tensor & other, at::Tensor & out) {
    return at::_ops::gcd_out::call(self, other, out);
}

// aten::gcd(Tensor self, Tensor other) -> Tensor
TORCH_API inline at::Tensor gcd(const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::gcd::call(self, other);
}

// aten::gcd_(Tensor(a!) self, Tensor other) -> Tensor(a!)
TORCH_API inline at::Tensor & gcd_(at::Tensor & self, const at::Tensor & other) {
    return at::_ops::gcd_::call(self, other);
}

// aten::lcm.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & lcm_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::lcm_out::call(self, other, out);
}

// aten::lcm.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & lcm_outf(const at::Tensor & self, const at::Tensor & other, at::Tensor & out) {
    return at::_ops::lcm_out::call(self, other, out);
}

// aten::lcm(Tensor self, Tensor other) -> Tensor
TORCH_API inline at::Tensor lcm(const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::lcm::call(self, other);
}

// aten::lcm_(Tensor(a!) self, Tensor other) -> Tensor(a!)
TORCH_API inline at::Tensor & lcm_(at::Tensor & self, const at::Tensor & other) {
    return at::_ops::lcm_::call(self, other);
}

// aten::grid_sampler(Tensor input, Tensor grid, int interpolation_mode, int padding_mode, bool align_corners) -> Tensor
TORCH_API inline at::Tensor grid_sampler(const at::Tensor & input, const at::Tensor & grid, int64_t interpolation_mode, int64_t padding_mode, bool align_corners) {
    return at::_ops::grid_sampler::call(input, grid, interpolation_mode, padding_mode, align_corners);
}

// aten::grid_sampler_2d(Tensor input, Tensor grid, int interpolation_mode, int padding_mode, bool align_corners) -> Tensor
TORCH_API inline at::Tensor grid_sampler_2d(const at::Tensor & input, const at::Tensor & grid, int64_t interpolation_mode, int64_t padding_mode, bool align_corners) {
    return at::_ops::grid_sampler_2d::call(input, grid, interpolation_mode, padding_mode, align_corners);
}

// aten::grid_sampler_2d_backward(Tensor grad_output, Tensor input, Tensor grid, int interpolation_mode, int padding_mode, bool align_corners) -> (Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> grid_sampler_2d_backward(const at::Tensor & grad_output, const at::Tensor & input, const at::Tensor & grid, int64_t interpolation_mode, int64_t padding_mode, bool align_corners) {
    return at::_ops::grid_sampler_2d_backward::call(grad_output, input, grid, interpolation_mode, padding_mode, align_corners);
}

// aten::_grid_sampler_2d_cpu_fallback(Tensor input, Tensor grid, int interpolation_mode, int padding_mode, bool align_corners) -> Tensor
TORCH_API inline at::Tensor _grid_sampler_2d_cpu_fallback(const at::Tensor & input, const at::Tensor & grid, int64_t interpolation_mode, int64_t padding_mode, bool align_corners) {
    return at::_ops::_grid_sampler_2d_cpu_fallback::call(input, grid, interpolation_mode, padding_mode, align_corners);
}

// aten::_grid_sampler_2d_cpu_fallback_backward(Tensor grad_output, Tensor input, Tensor grid, int interpolation_mode, int padding_mode, bool align_corners) -> (Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> _grid_sampler_2d_cpu_fallback_backward(const at::Tensor & grad_output, const at::Tensor & input, const at::Tensor & grid, int64_t interpolation_mode, int64_t padding_mode, bool align_corners) {
    return at::_ops::_grid_sampler_2d_cpu_fallback_backward::call(grad_output, input, grid, interpolation_mode, padding_mode, align_corners);
}

// aten::grid_sampler_3d(Tensor input, Tensor grid, int interpolation_mode, int padding_mode, bool align_corners) -> Tensor
TORCH_API inline at::Tensor grid_sampler_3d(const at::Tensor & input, const at::Tensor & grid, int64_t interpolation_mode, int64_t padding_mode, bool align_corners) {
    return at::_ops::grid_sampler_3d::call(input, grid, interpolation_mode, padding_mode, align_corners);
}

// aten::grid_sampler_3d_backward(Tensor grad_output, Tensor input, Tensor grid, int interpolation_mode, int padding_mode, bool align_corners) -> (Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> grid_sampler_3d_backward(const at::Tensor & grad_output, const at::Tensor & input, const at::Tensor & grid, int64_t interpolation_mode, int64_t padding_mode, bool align_corners) {
    return at::_ops::grid_sampler_3d_backward::call(grad_output, input, grid, interpolation_mode, padding_mode, align_corners);
}

// aten::hann_window(int window_length, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor hann_window(int64_t window_length, at::TensorOptions options={}) {
    return at::_ops::hann_window::call(window_length, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt());
}

// aten::hann_window(int window_length, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor hann_window(int64_t window_length, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory) {
    return at::_ops::hann_window::call(window_length, dtype, layout, device, pin_memory);
}

// aten::hann_window.periodic(int window_length, bool periodic, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor hann_window(int64_t window_length, bool periodic, at::TensorOptions options={}) {
    return at::_ops::hann_window_periodic::call(window_length, periodic, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt());
}

// aten::hann_window.periodic(int window_length, bool periodic, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor hann_window(int64_t window_length, bool periodic, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory) {
    return at::_ops::hann_window_periodic::call(window_length, periodic, dtype, layout, device, pin_memory);
}

// aten::hamming_window(int window_length, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor hamming_window(int64_t window_length, at::TensorOptions options={}) {
    return at::_ops::hamming_window::call(window_length, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt());
}

// aten::hamming_window(int window_length, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor hamming_window(int64_t window_length, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory) {
    return at::_ops::hamming_window::call(window_length, dtype, layout, device, pin_memory);
}

// aten::hamming_window.periodic(int window_length, bool periodic, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor hamming_window(int64_t window_length, bool periodic, at::TensorOptions options={}) {
    return at::_ops::hamming_window_periodic::call(window_length, periodic, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt());
}

// aten::hamming_window.periodic(int window_length, bool periodic, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor hamming_window(int64_t window_length, bool periodic, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory) {
    return at::_ops::hamming_window_periodic::call(window_length, periodic, dtype, layout, device, pin_memory);
}

// aten::hamming_window.periodic_alpha(int window_length, bool periodic, float alpha, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor hamming_window(int64_t window_length, bool periodic, double alpha, at::TensorOptions options={}) {
    return at::_ops::hamming_window_periodic_alpha::call(window_length, periodic, alpha, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt());
}

// aten::hamming_window.periodic_alpha(int window_length, bool periodic, float alpha, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor hamming_window(int64_t window_length, bool periodic, double alpha, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory) {
    return at::_ops::hamming_window_periodic_alpha::call(window_length, periodic, alpha, dtype, layout, device, pin_memory);
}

// aten::hamming_window.periodic_alpha_beta(int window_length, bool periodic, float alpha, float beta, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor hamming_window(int64_t window_length, bool periodic, double alpha, double beta, at::TensorOptions options={}) {
    return at::_ops::hamming_window_periodic_alpha_beta::call(window_length, periodic, alpha, beta, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt());
}

// aten::hamming_window.periodic_alpha_beta(int window_length, bool periodic, float alpha, float beta, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor hamming_window(int64_t window_length, bool periodic, double alpha, double beta, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory) {
    return at::_ops::hamming_window_periodic_alpha_beta::call(window_length, periodic, alpha, beta, dtype, layout, device, pin_memory);
}

// aten::kaiser_window(int window_length, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor kaiser_window(int64_t window_length, at::TensorOptions options={}) {
    return at::_ops::kaiser_window::call(window_length, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt());
}

// aten::kaiser_window(int window_length, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor kaiser_window(int64_t window_length, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory) {
    return at::_ops::kaiser_window::call(window_length, dtype, layout, device, pin_memory);
}

// aten::kaiser_window.periodic(int window_length, bool periodic, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor kaiser_window(int64_t window_length, bool periodic, at::TensorOptions options={}) {
    return at::_ops::kaiser_window_periodic::call(window_length, periodic, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt());
}

// aten::kaiser_window.periodic(int window_length, bool periodic, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor kaiser_window(int64_t window_length, bool periodic, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory) {
    return at::_ops::kaiser_window_periodic::call(window_length, periodic, dtype, layout, device, pin_memory);
}

// aten::kaiser_window.beta(int window_length, bool periodic, float beta, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor kaiser_window(int64_t window_length, bool periodic, double beta, at::TensorOptions options={}) {
    return at::_ops::kaiser_window_beta::call(window_length, periodic, beta, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt());
}

// aten::kaiser_window.beta(int window_length, bool periodic, float beta, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor kaiser_window(int64_t window_length, bool periodic, double beta, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory) {
    return at::_ops::kaiser_window_beta::call(window_length, periodic, beta, dtype, layout, device, pin_memory);
}

// aten::hinge_embedding_loss(Tensor self, Tensor target, float margin=1.0, int reduction=Mean) -> Tensor
TORCH_API inline at::Tensor hinge_embedding_loss(const at::Tensor & self, const at::Tensor & target, double margin=1.0, int64_t reduction=at::Reduction::Mean) {
    return at::_ops::hinge_embedding_loss::call(self, target, margin, reduction);
}

// aten::group_norm(Tensor input, int num_groups, Tensor? weight=None, Tensor? bias=None, float eps=1e-05, bool cudnn_enabled=True) -> Tensor
TORCH_API inline at::Tensor group_norm(const at::Tensor & input, int64_t num_groups, const c10::optional<at::Tensor> & weight={}, const c10::optional<at::Tensor> & bias={}, double eps=1e-05, bool cudnn_enabled=true) {
    return at::_ops::group_norm::call(input, num_groups, weight, bias, eps, cudnn_enabled);
}

// aten::native_group_norm(Tensor input, Tensor? weight, Tensor? bias, int N, int C, int HxW, int group, float eps) -> (Tensor, Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor,at::Tensor> native_group_norm(const at::Tensor & input, const c10::optional<at::Tensor> & weight, const c10::optional<at::Tensor> & bias, int64_t N, int64_t C, int64_t HxW, int64_t group, double eps) {
    return at::_ops::native_group_norm::call(input, weight, bias, N, C, HxW, group, eps);
}

// aten::native_group_norm_backward(Tensor grad_out, Tensor input, Tensor mean, Tensor rstd, Tensor? weight, int N, int C, int HxW, int group, bool[3] output_mask) -> (Tensor, Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor,at::Tensor> native_group_norm_backward(const at::Tensor & grad_out, const at::Tensor & input, const at::Tensor & mean, const at::Tensor & rstd, const c10::optional<at::Tensor> & weight, int64_t N, int64_t C, int64_t HxW, int64_t group, ::std::array<bool,3> output_mask) {
    return at::_ops::native_group_norm_backward::call(grad_out, input, mean, rstd, weight, N, C, HxW, group, output_mask);
}

// aten::_fft_r2c(Tensor self, int[] dim, int normalization, bool onesided) -> Tensor
TORCH_API inline at::Tensor _fft_r2c(const at::Tensor & self, at::IntArrayRef dim, int64_t normalization, bool onesided) {
    return at::_ops::_fft_r2c::call(self, dim, normalization, onesided);
}

// aten::_fft_r2c.out(Tensor self, int[] dim, int normalization, bool onesided, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & _fft_r2c_out(at::Tensor & out, const at::Tensor & self, at::IntArrayRef dim, int64_t normalization, bool onesided) {
    return at::_ops::_fft_r2c_out::call(self, dim, normalization, onesided, out);
}

// aten::_fft_r2c.out(Tensor self, int[] dim, int normalization, bool onesided, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & _fft_r2c_outf(const at::Tensor & self, at::IntArrayRef dim, int64_t normalization, bool onesided, at::Tensor & out) {
    return at::_ops::_fft_r2c_out::call(self, dim, normalization, onesided, out);
}

// aten::_fft_c2r(Tensor self, int[] dim, int normalization, int last_dim_size) -> Tensor
TORCH_API inline at::Tensor _fft_c2r(const at::Tensor & self, at::IntArrayRef dim, int64_t normalization, int64_t last_dim_size) {
    return at::_ops::_fft_c2r::call(self, dim, normalization, last_dim_size);
}

// aten::_fft_c2r.out(Tensor self, int[] dim, int normalization, int last_dim_size, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & _fft_c2r_out(at::Tensor & out, const at::Tensor & self, at::IntArrayRef dim, int64_t normalization, int64_t last_dim_size) {
    return at::_ops::_fft_c2r_out::call(self, dim, normalization, last_dim_size, out);
}

// aten::_fft_c2r.out(Tensor self, int[] dim, int normalization, int last_dim_size, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & _fft_c2r_outf(const at::Tensor & self, at::IntArrayRef dim, int64_t normalization, int64_t last_dim_size, at::Tensor & out) {
    return at::_ops::_fft_c2r_out::call(self, dim, normalization, last_dim_size, out);
}

// aten::_fft_c2c(Tensor self, int[] dim, int normalization, bool forward) -> Tensor
TORCH_API inline at::Tensor _fft_c2c(const at::Tensor & self, at::IntArrayRef dim, int64_t normalization, bool forward) {
    return at::_ops::_fft_c2c::call(self, dim, normalization, forward);
}

// aten::_fft_c2c.out(Tensor self, int[] dim, int normalization, bool forward, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & _fft_c2c_out(at::Tensor & out, const at::Tensor & self, at::IntArrayRef dim, int64_t normalization, bool forward) {
    return at::_ops::_fft_c2c_out::call(self, dim, normalization, forward, out);
}

// aten::_fft_c2c.out(Tensor self, int[] dim, int normalization, bool forward, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & _fft_c2c_outf(const at::Tensor & self, at::IntArrayRef dim, int64_t normalization, bool forward, at::Tensor & out) {
    return at::_ops::_fft_c2c_out::call(self, dim, normalization, forward, out);
}

// aten::_cufft_get_plan_cache_size(int device_index) -> int
TORCH_API inline int64_t _cufft_get_plan_cache_size(int64_t device_index) {
    return at::_ops::_cufft_get_plan_cache_size::call(device_index);
}

// aten::_cufft_get_plan_cache_max_size(int device_index) -> int
TORCH_API inline int64_t _cufft_get_plan_cache_max_size(int64_t device_index) {
    return at::_ops::_cufft_get_plan_cache_max_size::call(device_index);
}

// aten::_cufft_set_plan_cache_max_size(int device_index, int max_size) -> ()
TORCH_API inline void _cufft_set_plan_cache_max_size(int64_t device_index, int64_t max_size) {
    return at::_ops::_cufft_set_plan_cache_max_size::call(device_index, max_size);
}

// aten::_cufft_clear_plan_cache(int device_index) -> ()
TORCH_API inline void _cufft_clear_plan_cache(int64_t device_index) {
    return at::_ops::_cufft_clear_plan_cache::call(device_index);
}

// aten::index.Tensor(Tensor self, Tensor?[] indices) -> Tensor
TORCH_API inline at::Tensor index(const at::Tensor & self, const c10::List<c10::optional<at::Tensor>> & indices) {
    return at::_ops::index_Tensor::call(self, indices);
}

// aten::index_copy(Tensor self, int dim, Tensor index, Tensor source) -> Tensor
TORCH_API inline at::Tensor index_copy(const at::Tensor & self, int64_t dim, const at::Tensor & index, const at::Tensor & source) {
    return at::_ops::index_copy::call(self, dim, index, source);
}

// aten::index_copy.dimname(Tensor self, Dimname dim, Tensor index, Tensor source) -> Tensor
TORCH_API inline at::Tensor index_copy(const at::Tensor & self, at::Dimname dim, const at::Tensor & index, const at::Tensor & source) {
    return at::_ops::index_copy_dimname::call(self, dim, index, source);
}

// aten::index_put_(Tensor(a!) self, Tensor?[] indices, Tensor values, bool accumulate=False) -> Tensor(a!)
TORCH_API inline at::Tensor & index_put_(at::Tensor & self, const c10::List<c10::optional<at::Tensor>> & indices, const at::Tensor & values, bool accumulate=false) {
    return at::_ops::index_put_::call(self, indices, values, accumulate);
}

// aten::index_put(Tensor self, Tensor?[] indices, Tensor values, bool accumulate=False) -> Tensor
TORCH_API inline at::Tensor index_put(const at::Tensor & self, const c10::List<c10::optional<at::Tensor>> & indices, const at::Tensor & values, bool accumulate=false) {
    return at::_ops::index_put::call(self, indices, values, accumulate);
}

// aten::_index_put_impl_(Tensor(a!) self, Tensor?[] indices, Tensor values, bool accumulate=False, bool unsafe=False) -> Tensor(a!)
TORCH_API inline at::Tensor & _index_put_impl_(at::Tensor & self, const c10::List<c10::optional<at::Tensor>> & indices, const at::Tensor & values, bool accumulate=false, bool unsafe=false) {
    return at::_ops::_index_put_impl_::call(self, indices, values, accumulate, unsafe);
}

// aten::instance_norm(Tensor input, Tensor? weight, Tensor? bias, Tensor? running_mean, Tensor? running_var, bool use_input_stats, float momentum, float eps, bool cudnn_enabled) -> Tensor
TORCH_API inline at::Tensor instance_norm(const at::Tensor & input, const c10::optional<at::Tensor> & weight, const c10::optional<at::Tensor> & bias, const c10::optional<at::Tensor> & running_mean, const c10::optional<at::Tensor> & running_var, bool use_input_stats, double momentum, double eps, bool cudnn_enabled) {
    return at::_ops::instance_norm::call(input, weight, bias, running_mean, running_var, use_input_stats, momentum, eps, cudnn_enabled);
}

// aten::inverse(Tensor self) -> Tensor
TORCH_API inline at::Tensor inverse(const at::Tensor & self) {
    return at::_ops::inverse::call(self);
}

// aten::inverse.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & inverse_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::inverse_out::call(self, out);
}

// aten::inverse.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & inverse_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::inverse_out::call(self, out);
}

// aten::_inverse_helper(Tensor self) -> Tensor
TORCH_API inline at::Tensor _inverse_helper(const at::Tensor & self) {
    return at::_ops::_inverse_helper::call(self);
}

// aten::isclose(Tensor self, Tensor other, float rtol=1e-05, float atol=1e-08, bool equal_nan=False) -> Tensor
TORCH_API inline at::Tensor isclose(const at::Tensor & self, const at::Tensor & other, double rtol=1e-05, double atol=1e-08, bool equal_nan=false) {
    return at::_ops::isclose::call(self, other, rtol, atol, equal_nan);
}

// aten::isin.Tensor_Tensor_out(Tensor elements, Tensor test_elements, *, bool assume_unique=False, bool invert=False, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & isin_out(at::Tensor & out, const at::Tensor & elements, const at::Tensor & test_elements, bool assume_unique=false, bool invert=false) {
    return at::_ops::isin_Tensor_Tensor_out::call(elements, test_elements, assume_unique, invert, out);
}

// aten::isin.Tensor_Tensor_out(Tensor elements, Tensor test_elements, *, bool assume_unique=False, bool invert=False, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & isin_outf(const at::Tensor & elements, const at::Tensor & test_elements, bool assume_unique, bool invert, at::Tensor & out) {
    return at::_ops::isin_Tensor_Tensor_out::call(elements, test_elements, assume_unique, invert, out);
}

// aten::isin.Tensor_Tensor(Tensor elements, Tensor test_elements, *, bool assume_unique=False, bool invert=False) -> Tensor
TORCH_API inline at::Tensor isin(const at::Tensor & elements, const at::Tensor & test_elements, bool assume_unique=false, bool invert=false) {
    return at::_ops::isin_Tensor_Tensor::call(elements, test_elements, assume_unique, invert);
}

// aten::isin.Tensor_Scalar_out(Tensor elements, Scalar test_element, *, bool assume_unique=False, bool invert=False, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & isin_out(at::Tensor & out, const at::Tensor & elements, const at::Scalar & test_element, bool assume_unique=false, bool invert=false) {
    return at::_ops::isin_Tensor_Scalar_out::call(elements, test_element, assume_unique, invert, out);
}

// aten::isin.Tensor_Scalar_out(Tensor elements, Scalar test_element, *, bool assume_unique=False, bool invert=False, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & isin_outf(const at::Tensor & elements, const at::Scalar & test_element, bool assume_unique, bool invert, at::Tensor & out) {
    return at::_ops::isin_Tensor_Scalar_out::call(elements, test_element, assume_unique, invert, out);
}

// aten::isin.Tensor_Scalar(Tensor elements, Scalar test_element, *, bool assume_unique=False, bool invert=False) -> Tensor
TORCH_API inline at::Tensor isin(const at::Tensor & elements, const at::Scalar & test_element, bool assume_unique=false, bool invert=false) {
    return at::_ops::isin_Tensor_Scalar::call(elements, test_element, assume_unique, invert);
}

// aten::isin.Scalar_Tensor_out(Scalar element, Tensor test_elements, *, bool assume_unique=False, bool invert=False, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & isin_out(at::Tensor & out, const at::Scalar & element, const at::Tensor & test_elements, bool assume_unique=false, bool invert=false) {
    return at::_ops::isin_Scalar_Tensor_out::call(element, test_elements, assume_unique, invert, out);
}

// aten::isin.Scalar_Tensor_out(Scalar element, Tensor test_elements, *, bool assume_unique=False, bool invert=False, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & isin_outf(const at::Scalar & element, const at::Tensor & test_elements, bool assume_unique, bool invert, at::Tensor & out) {
    return at::_ops::isin_Scalar_Tensor_out::call(element, test_elements, assume_unique, invert, out);
}

// aten::isin.Scalar_Tensor(Scalar element, Tensor test_elements, *, bool assume_unique=False, bool invert=False) -> Tensor
TORCH_API inline at::Tensor isin(const at::Scalar & element, const at::Tensor & test_elements, bool assume_unique=false, bool invert=false) {
    return at::_ops::isin_Scalar_Tensor::call(element, test_elements, assume_unique, invert);
}

// aten::isnan(Tensor self) -> Tensor
TORCH_API inline at::Tensor isnan(const at::Tensor & self) {
    return at::_ops::isnan::call(self);
}

// aten::is_distributed(Tensor self) -> bool
TORCH_API inline bool is_distributed(const at::Tensor & self) {
    return at::_ops::is_distributed::call(self);
}

// aten::is_floating_point(Tensor self) -> bool
TORCH_API inline bool __dispatch_is_floating_point(const at::Tensor & self) {
    return at::_ops::is_floating_point::call(self);
}

// aten::is_complex(Tensor self) -> bool
TORCH_API inline bool __dispatch_is_complex(const at::Tensor & self) {
    return at::_ops::is_complex::call(self);
}

// aten::is_conj(Tensor self) -> bool
TORCH_API inline bool __dispatch_is_conj(const at::Tensor & self) {
    return at::_ops::is_conj::call(self);
}

// aten::is_neg(Tensor self) -> bool
TORCH_API inline bool __dispatch_is_neg(const at::Tensor & self) {
    return at::_ops::is_neg::call(self);
}

// aten::isreal(Tensor self) -> Tensor
TORCH_API inline at::Tensor isreal(const at::Tensor & self) {
    return at::_ops::isreal::call(self);
}

// aten::is_nonzero(Tensor self) -> bool
TORCH_API inline bool is_nonzero(const at::Tensor & self) {
    return at::_ops::is_nonzero::call(self);
}

// aten::is_same_size(Tensor self, Tensor other) -> bool
TORCH_API inline bool is_same_size(const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::is_same_size::call(self, other);
}

// aten::is_signed(Tensor self) -> bool
TORCH_API inline bool __dispatch_is_signed(const at::Tensor & self) {
    return at::_ops::is_signed::call(self);
}

// aten::is_inference(Tensor self) -> bool
TORCH_API inline bool __dispatch_is_inference(const at::Tensor & self) {
    return at::_ops::is_inference::call(self);
}

// aten::kl_div(Tensor self, Tensor target, int reduction=Mean, *, bool log_target=False) -> Tensor
TORCH_API inline at::Tensor kl_div(const at::Tensor & self, const at::Tensor & target, int64_t reduction=at::Reduction::Mean, bool log_target=false) {
    return at::_ops::kl_div::call(self, target, reduction, log_target);
}

// aten::kl_div_backward(Tensor grad_output, Tensor self, Tensor target, int reduction=Mean, *, bool log_target=False) -> Tensor
TORCH_API inline at::Tensor kl_div_backward(const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & target, int64_t reduction=at::Reduction::Mean, bool log_target=false) {
    return at::_ops::kl_div_backward::call(grad_output, self, target, reduction, log_target);
}

// aten::kron(Tensor self, Tensor other) -> Tensor
TORCH_API inline at::Tensor kron(const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::kron::call(self, other);
}

// aten::kron.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & kron_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::kron_out::call(self, other, out);
}

// aten::kron.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & kron_outf(const at::Tensor & self, const at::Tensor & other, at::Tensor & out) {
    return at::_ops::kron_out::call(self, other, out);
}

// aten::kthvalue(Tensor self, int k, int dim=-1, bool keepdim=False) -> (Tensor values, Tensor indices)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> kthvalue(const at::Tensor & self, int64_t k, int64_t dim=-1, bool keepdim=false) {
    return at::_ops::kthvalue::call(self, k, dim, keepdim);
}

// aten::kthvalue.values(Tensor self, int k, int dim=-1, bool keepdim=False, *, Tensor(a!) values, Tensor(b!) indices) -> (Tensor(a!) values, Tensor(b!) indices)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> kthvalue_out(at::Tensor & values, at::Tensor & indices, const at::Tensor & self, int64_t k, int64_t dim=-1, bool keepdim=false) {
    return at::_ops::kthvalue_values::call(self, k, dim, keepdim, values, indices);
}

// aten::kthvalue.values(Tensor self, int k, int dim=-1, bool keepdim=False, *, Tensor(a!) values, Tensor(b!) indices) -> (Tensor(a!) values, Tensor(b!) indices)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> kthvalue_outf(const at::Tensor & self, int64_t k, int64_t dim, bool keepdim, at::Tensor & values, at::Tensor & indices) {
    return at::_ops::kthvalue_values::call(self, k, dim, keepdim, values, indices);
}

// aten::kthvalue.dimname(Tensor self, int k, Dimname dim, bool keepdim=False) -> (Tensor values, Tensor indices)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> kthvalue(const at::Tensor & self, int64_t k, at::Dimname dim, bool keepdim=false) {
    return at::_ops::kthvalue_dimname::call(self, k, dim, keepdim);
}

// aten::kthvalue.dimname_out(Tensor self, int k, Dimname dim, bool keepdim=False, *, Tensor(a!) values, Tensor(b!) indices) -> (Tensor(a!) values, Tensor(b!) indices)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> kthvalue_out(at::Tensor & values, at::Tensor & indices, const at::Tensor & self, int64_t k, at::Dimname dim, bool keepdim=false) {
    return at::_ops::kthvalue_dimname_out::call(self, k, dim, keepdim, values, indices);
}

// aten::kthvalue.dimname_out(Tensor self, int k, Dimname dim, bool keepdim=False, *, Tensor(a!) values, Tensor(b!) indices) -> (Tensor(a!) values, Tensor(b!) indices)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> kthvalue_outf(const at::Tensor & self, int64_t k, at::Dimname dim, bool keepdim, at::Tensor & values, at::Tensor & indices) {
    return at::_ops::kthvalue_dimname_out::call(self, k, dim, keepdim, values, indices);
}

// aten::layer_norm(Tensor input, int[] normalized_shape, Tensor? weight=None, Tensor? bias=None, float eps=1e-05, bool cudnn_enable=True) -> Tensor
TORCH_API inline at::Tensor layer_norm(const at::Tensor & input, at::IntArrayRef normalized_shape, const c10::optional<at::Tensor> & weight={}, const c10::optional<at::Tensor> & bias={}, double eps=1e-05, bool cudnn_enable=true) {
    return at::_ops::layer_norm::call(input, normalized_shape, weight, bias, eps, cudnn_enable);
}

// aten::native_layer_norm(Tensor input, int[] normalized_shape, Tensor? weight, Tensor? bias, float eps) -> (Tensor, Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor,at::Tensor> native_layer_norm(const at::Tensor & input, at::IntArrayRef normalized_shape, const c10::optional<at::Tensor> & weight, const c10::optional<at::Tensor> & bias, double eps) {
    return at::_ops::native_layer_norm::call(input, normalized_shape, weight, bias, eps);
}

// aten::native_layer_norm_backward(Tensor grad_out, Tensor input, int[] normalized_shape, Tensor mean, Tensor rstd, Tensor? weight, Tensor? bias, bool[3] output_mask) -> (Tensor, Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor,at::Tensor> native_layer_norm_backward(const at::Tensor & grad_out, const at::Tensor & input, at::IntArrayRef normalized_shape, const at::Tensor & mean, const at::Tensor & rstd, const c10::optional<at::Tensor> & weight, const c10::optional<at::Tensor> & bias, ::std::array<bool,3> output_mask) {
    return at::_ops::native_layer_norm_backward::call(grad_out, input, normalized_shape, mean, rstd, weight, bias, output_mask);
}

// aten::nan_to_num(Tensor self, float? nan=None, float? posinf=None, float? neginf=None) -> Tensor
TORCH_API inline at::Tensor nan_to_num(const at::Tensor & self, c10::optional<double> nan=c10::nullopt, c10::optional<double> posinf=c10::nullopt, c10::optional<double> neginf=c10::nullopt) {
    return at::_ops::nan_to_num::call(self, nan, posinf, neginf);
}

// aten::nan_to_num_(Tensor(a!) self, float? nan=None, float? posinf=None, float? neginf=None) -> Tensor(a!)
TORCH_API inline at::Tensor & nan_to_num_(at::Tensor & self, c10::optional<double> nan=c10::nullopt, c10::optional<double> posinf=c10::nullopt, c10::optional<double> neginf=c10::nullopt) {
    return at::_ops::nan_to_num_::call(self, nan, posinf, neginf);
}

// aten::nan_to_num.out(Tensor self, float? nan=None, float? posinf=None, float? neginf=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & nan_to_num_out(at::Tensor & out, const at::Tensor & self, c10::optional<double> nan=c10::nullopt, c10::optional<double> posinf=c10::nullopt, c10::optional<double> neginf=c10::nullopt) {
    return at::_ops::nan_to_num_out::call(self, nan, posinf, neginf, out);
}

// aten::nan_to_num.out(Tensor self, float? nan=None, float? posinf=None, float? neginf=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & nan_to_num_outf(const at::Tensor & self, c10::optional<double> nan, c10::optional<double> posinf, c10::optional<double> neginf, at::Tensor & out) {
    return at::_ops::nan_to_num_out::call(self, nan, posinf, neginf, out);
}

// aten::linear(Tensor input, Tensor weight, Tensor? bias=None) -> Tensor
TORCH_API inline at::Tensor linear(const at::Tensor & input, const at::Tensor & weight, const c10::optional<at::Tensor> & bias={}) {
    return at::_ops::linear::call(input, weight, bias);
}

// aten::linear.out(Tensor input, Tensor weight, Tensor? bias=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & linear_out(at::Tensor & out, const at::Tensor & input, const at::Tensor & weight, const c10::optional<at::Tensor> & bias={}) {
    return at::_ops::linear_out::call(input, weight, bias, out);
}

// aten::linear.out(Tensor input, Tensor weight, Tensor? bias=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & linear_outf(const at::Tensor & input, const at::Tensor & weight, const c10::optional<at::Tensor> & bias, at::Tensor & out) {
    return at::_ops::linear_out::call(input, weight, bias, out);
}

// aten::mkldnn_linear(Tensor self, Tensor weight, Tensor? bias=None) -> Tensor
TORCH_API inline at::Tensor mkldnn_linear(const at::Tensor & self, const at::Tensor & weight, const c10::optional<at::Tensor> & bias={}) {
    return at::_ops::mkldnn_linear::call(self, weight, bias);
}

// aten::mkldnn_linear_backward_input(int[] input_size, Tensor grad_output, Tensor weight) -> Tensor
TORCH_API inline at::Tensor mkldnn_linear_backward_input(at::IntArrayRef input_size, const at::Tensor & grad_output, const at::Tensor & weight) {
    return at::_ops::mkldnn_linear_backward_input::call(input_size, grad_output, weight);
}

// aten::mkldnn_linear_backward_weights(Tensor grad_output, Tensor input, Tensor weight, bool bias_defined) -> (Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> mkldnn_linear_backward_weights(const at::Tensor & grad_output, const at::Tensor & input, const at::Tensor & weight, bool bias_defined) {
    return at::_ops::mkldnn_linear_backward_weights::call(grad_output, input, weight, bias_defined);
}

// aten::mkldnn_linear_backward(Tensor self, Tensor grad_output, Tensor weight, bool[3] output_mask) -> (Tensor, Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor,at::Tensor> mkldnn_linear_backward(const at::Tensor & self, const at::Tensor & grad_output, const at::Tensor & weight, ::std::array<bool,3> output_mask) {
    return at::_ops::mkldnn_linear_backward::call(self, grad_output, weight, output_mask);
}

// aten::fbgemm_linear_int8_weight_fp32_activation(Tensor input, Tensor weight, Tensor packed, Tensor col_offsets, Scalar weight_scale, Scalar weight_zero_point, Tensor bias) -> Tensor
TORCH_API inline at::Tensor fbgemm_linear_int8_weight_fp32_activation(const at::Tensor & input, const at::Tensor & weight, const at::Tensor & packed, const at::Tensor & col_offsets, const at::Scalar & weight_scale, const at::Scalar & weight_zero_point, const at::Tensor & bias) {
    return at::_ops::fbgemm_linear_int8_weight_fp32_activation::call(input, weight, packed, col_offsets, weight_scale, weight_zero_point, bias);
}

// aten::fbgemm_linear_int8_weight(Tensor input, Tensor weight, Tensor packed, Tensor col_offsets, Scalar weight_scale, Scalar weight_zero_point, Tensor bias) -> Tensor
TORCH_API inline at::Tensor fbgemm_linear_int8_weight(const at::Tensor & input, const at::Tensor & weight, const at::Tensor & packed, const at::Tensor & col_offsets, const at::Scalar & weight_scale, const at::Scalar & weight_zero_point, const at::Tensor & bias) {
    return at::_ops::fbgemm_linear_int8_weight::call(input, weight, packed, col_offsets, weight_scale, weight_zero_point, bias);
}

// aten::fbgemm_linear_quantize_weight(Tensor input) -> (Tensor, Tensor, float, int)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor,double,int64_t> fbgemm_linear_quantize_weight(const at::Tensor & input) {
    return at::_ops::fbgemm_linear_quantize_weight::call(input);
}

// aten::fbgemm_pack_gemm_matrix_fp16(Tensor input) -> Tensor
TORCH_API inline at::Tensor fbgemm_pack_gemm_matrix_fp16(const at::Tensor & input) {
    return at::_ops::fbgemm_pack_gemm_matrix_fp16::call(input);
}

// aten::fbgemm_linear_fp16_weight_fp32_activation(Tensor input, Tensor packed_weight, Tensor bias) -> Tensor
TORCH_API inline at::Tensor fbgemm_linear_fp16_weight_fp32_activation(const at::Tensor & input, const at::Tensor & packed_weight, const at::Tensor & bias) {
    return at::_ops::fbgemm_linear_fp16_weight_fp32_activation::call(input, packed_weight, bias);
}

// aten::fbgemm_linear_fp16_weight(Tensor input, Tensor packed_weight, Tensor bias) -> Tensor
TORCH_API inline at::Tensor fbgemm_linear_fp16_weight(const at::Tensor & input, const at::Tensor & packed_weight, const at::Tensor & bias) {
    return at::_ops::fbgemm_linear_fp16_weight::call(input, packed_weight, bias);
}

// aten::fbgemm_pack_quantized_matrix(Tensor input) -> Tensor
TORCH_API inline at::Tensor fbgemm_pack_quantized_matrix(const at::Tensor & input) {
    return at::_ops::fbgemm_pack_quantized_matrix::call(input);
}

// aten::fbgemm_pack_quantized_matrix.KN(Tensor input, int K, int N) -> Tensor
TORCH_API inline at::Tensor fbgemm_pack_quantized_matrix(const at::Tensor & input, int64_t K, int64_t N) {
    return at::_ops::fbgemm_pack_quantized_matrix_KN::call(input, K, N);
}

// aten::ldexp.Tensor(Tensor self, Tensor other) -> Tensor
TORCH_API inline at::Tensor ldexp(const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::ldexp_Tensor::call(self, other);
}

// aten::ldexp_(Tensor(a!) self, Tensor other) -> Tensor(a!)
TORCH_API inline at::Tensor & ldexp_(at::Tensor & self, const at::Tensor & other) {
    return at::_ops::ldexp_::call(self, other);
}

// aten::ldexp.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & ldexp_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::ldexp_out::call(self, other, out);
}

// aten::ldexp.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & ldexp_outf(const at::Tensor & self, const at::Tensor & other, at::Tensor & out) {
    return at::_ops::ldexp_out::call(self, other, out);
}

// aten::linspace(Scalar start, Scalar end, int? steps=None, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor linspace(const at::Scalar & start, const at::Scalar & end, c10::optional<int64_t> steps=c10::nullopt, at::TensorOptions options={}) {
    return at::_ops::linspace::call(start, end, steps, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt());
}

// aten::linspace(Scalar start, Scalar end, int? steps=None, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor linspace(const at::Scalar & start, const at::Scalar & end, c10::optional<int64_t> steps, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory) {
    return at::_ops::linspace::call(start, end, steps, dtype, layout, device, pin_memory);
}

// aten::linspace.out(Scalar start, Scalar end, int? steps=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & linspace_out(at::Tensor & out, const at::Scalar & start, const at::Scalar & end, c10::optional<int64_t> steps=c10::nullopt) {
    return at::_ops::linspace_out::call(start, end, steps, out);
}

// aten::linspace.out(Scalar start, Scalar end, int? steps=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & linspace_outf(const at::Scalar & start, const at::Scalar & end, c10::optional<int64_t> steps, at::Tensor & out) {
    return at::_ops::linspace_out::call(start, end, steps, out);
}

// aten::log(Tensor self) -> Tensor
TORCH_API inline at::Tensor log(const at::Tensor & self) {
    return at::_ops::log::call(self);
}

// aten::log_(Tensor(a!) self) -> Tensor(a!)
TORCH_API inline at::Tensor & log_(at::Tensor & self) {
    return at::_ops::log_::call(self);
}

// aten::log.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & log_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::log_out::call(self, out);
}

// aten::log.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & log_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::log_out::call(self, out);
}

// aten::log10(Tensor self) -> Tensor
TORCH_API inline at::Tensor log10(const at::Tensor & self) {
    return at::_ops::log10::call(self);
}

// aten::log10_(Tensor(a!) self) -> Tensor(a!)
TORCH_API inline at::Tensor & log10_(at::Tensor & self) {
    return at::_ops::log10_::call(self);
}

// aten::log10.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & log10_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::log10_out::call(self, out);
}

// aten::log10.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & log10_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::log10_out::call(self, out);
}

// aten::log1p(Tensor self) -> Tensor
TORCH_API inline at::Tensor log1p(const at::Tensor & self) {
    return at::_ops::log1p::call(self);
}

// aten::log1p_(Tensor(a!) self) -> Tensor(a!)
TORCH_API inline at::Tensor & log1p_(at::Tensor & self) {
    return at::_ops::log1p_::call(self);
}

// aten::log1p.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & log1p_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::log1p_out::call(self, out);
}

// aten::log1p.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & log1p_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::log1p_out::call(self, out);
}

// aten::log2(Tensor self) -> Tensor
TORCH_API inline at::Tensor log2(const at::Tensor & self) {
    return at::_ops::log2::call(self);
}

// aten::log2_(Tensor(a!) self) -> Tensor(a!)
TORCH_API inline at::Tensor & log2_(at::Tensor & self) {
    return at::_ops::log2_::call(self);
}

// aten::log2.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & log2_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::log2_out::call(self, out);
}

// aten::log2.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & log2_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::log2_out::call(self, out);
}

// aten::logaddexp.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & logaddexp_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::logaddexp_out::call(self, other, out);
}

// aten::logaddexp.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & logaddexp_outf(const at::Tensor & self, const at::Tensor & other, at::Tensor & out) {
    return at::_ops::logaddexp_out::call(self, other, out);
}

// aten::logaddexp(Tensor self, Tensor other) -> Tensor
TORCH_API inline at::Tensor logaddexp(const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::logaddexp::call(self, other);
}

// aten::logaddexp2.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & logaddexp2_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::logaddexp2_out::call(self, other, out);
}

// aten::logaddexp2.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & logaddexp2_outf(const at::Tensor & self, const at::Tensor & other, at::Tensor & out) {
    return at::_ops::logaddexp2_out::call(self, other, out);
}

// aten::logaddexp2(Tensor self, Tensor other) -> Tensor
TORCH_API inline at::Tensor logaddexp2(const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::logaddexp2::call(self, other);
}

// aten::xlogy.Tensor(Tensor self, Tensor other) -> Tensor
TORCH_API inline at::Tensor xlogy(const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::xlogy_Tensor::call(self, other);
}

// aten::xlogy.Scalar_Self(Scalar self, Tensor other) -> Tensor
TORCH_API inline at::Tensor xlogy(const at::Scalar & self, const at::Tensor & other) {
    return at::_ops::xlogy_Scalar_Self::call(self, other);
}

// aten::xlogy.Scalar_Other(Tensor self, Scalar other) -> Tensor
TORCH_API inline at::Tensor xlogy(const at::Tensor & self, const at::Scalar & other) {
    return at::_ops::xlogy_Scalar_Other::call(self, other);
}

// aten::xlogy_.Tensor(Tensor(a!) self, Tensor other) -> Tensor(a!)
TORCH_API inline at::Tensor & xlogy_(at::Tensor & self, const at::Tensor & other) {
    return at::_ops::xlogy__Tensor::call(self, other);
}

// aten::xlogy_.Scalar_Other(Tensor(a!) self, Scalar other) -> Tensor(a!)
TORCH_API inline at::Tensor & xlogy_(at::Tensor & self, const at::Scalar & other) {
    return at::_ops::xlogy__Scalar_Other::call(self, other);
}

// aten::xlogy.OutTensor(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & xlogy_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::xlogy_OutTensor::call(self, other, out);
}

// aten::xlogy.OutTensor(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & xlogy_outf(const at::Tensor & self, const at::Tensor & other, at::Tensor & out) {
    return at::_ops::xlogy_OutTensor::call(self, other, out);
}

// aten::xlogy.OutScalar_Self(Scalar self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & xlogy_out(at::Tensor & out, const at::Scalar & self, const at::Tensor & other) {
    return at::_ops::xlogy_OutScalar_Self::call(self, other, out);
}

// aten::xlogy.OutScalar_Self(Scalar self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & xlogy_outf(const at::Scalar & self, const at::Tensor & other, at::Tensor & out) {
    return at::_ops::xlogy_OutScalar_Self::call(self, other, out);
}

// aten::xlogy.OutScalar_Other(Tensor self, Scalar other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & xlogy_out(at::Tensor & out, const at::Tensor & self, const at::Scalar & other) {
    return at::_ops::xlogy_OutScalar_Other::call(self, other, out);
}

// aten::xlogy.OutScalar_Other(Tensor self, Scalar other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & xlogy_outf(const at::Tensor & self, const at::Scalar & other, at::Tensor & out) {
    return at::_ops::xlogy_OutScalar_Other::call(self, other, out);
}

// aten::logdet(Tensor self) -> Tensor
TORCH_API inline at::Tensor logdet(const at::Tensor & self) {
    return at::_ops::logdet::call(self);
}

// aten::logspace(Scalar start, Scalar end, int? steps=None, float base=10.0, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor logspace(const at::Scalar & start, const at::Scalar & end, c10::optional<int64_t> steps=c10::nullopt, double base=10.0, at::TensorOptions options={}) {
    return at::_ops::logspace::call(start, end, steps, base, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt());
}

// aten::logspace(Scalar start, Scalar end, int? steps=None, float base=10.0, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor logspace(const at::Scalar & start, const at::Scalar & end, c10::optional<int64_t> steps, double base, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory) {
    return at::_ops::logspace::call(start, end, steps, base, dtype, layout, device, pin_memory);
}

// aten::logspace.out(Scalar start, Scalar end, int? steps=None, float base=10.0, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & logspace_out(at::Tensor & out, const at::Scalar & start, const at::Scalar & end, c10::optional<int64_t> steps=c10::nullopt, double base=10.0) {
    return at::_ops::logspace_out::call(start, end, steps, base, out);
}

// aten::logspace.out(Scalar start, Scalar end, int? steps=None, float base=10.0, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & logspace_outf(const at::Scalar & start, const at::Scalar & end, c10::optional<int64_t> steps, double base, at::Tensor & out) {
    return at::_ops::logspace_out::call(start, end, steps, base, out);
}

// aten::log_softmax.int(Tensor self, int dim, ScalarType? dtype=None) -> Tensor
TORCH_API inline at::Tensor log_softmax(const at::Tensor & self, int64_t dim, c10::optional<at::ScalarType> dtype=c10::nullopt) {
    return at::_ops::log_softmax_int::call(self, dim, dtype);
}

// aten::log_softmax.Dimname(Tensor self, Dimname dim, *, ScalarType? dtype=None) -> Tensor
TORCH_API inline at::Tensor log_softmax(const at::Tensor & self, at::Dimname dim, c10::optional<at::ScalarType> dtype=c10::nullopt) {
    return at::_ops::log_softmax_Dimname::call(self, dim, dtype);
}

// aten::_log_softmax(Tensor self, int dim, bool half_to_float) -> Tensor
TORCH_API inline at::Tensor _log_softmax(const at::Tensor & self, int64_t dim, bool half_to_float) {
    return at::_ops::_log_softmax::call(self, dim, half_to_float);
}

// aten::_log_softmax.out(Tensor self, int dim, bool half_to_float, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & _log_softmax_out(at::Tensor & out, const at::Tensor & self, int64_t dim, bool half_to_float) {
    return at::_ops::_log_softmax_out::call(self, dim, half_to_float, out);
}

// aten::_log_softmax.out(Tensor self, int dim, bool half_to_float, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & _log_softmax_outf(const at::Tensor & self, int64_t dim, bool half_to_float, at::Tensor & out) {
    return at::_ops::_log_softmax_out::call(self, dim, half_to_float, out);
}

// aten::_log_softmax_backward_data(Tensor grad_output, Tensor output, int dim, Tensor self) -> Tensor
TORCH_API inline at::Tensor _log_softmax_backward_data(const at::Tensor & grad_output, const at::Tensor & output, int64_t dim, const at::Tensor & self) {
    return at::_ops::_log_softmax_backward_data::call(grad_output, output, dim, self);
}

// aten::_log_softmax_backward_data.out(Tensor grad_output, Tensor output, int dim, Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & _log_softmax_backward_data_out(at::Tensor & out, const at::Tensor & grad_output, const at::Tensor & output, int64_t dim, const at::Tensor & self) {
    return at::_ops::_log_softmax_backward_data_out::call(grad_output, output, dim, self, out);
}

// aten::_log_softmax_backward_data.out(Tensor grad_output, Tensor output, int dim, Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & _log_softmax_backward_data_outf(const at::Tensor & grad_output, const at::Tensor & output, int64_t dim, const at::Tensor & self, at::Tensor & out) {
    return at::_ops::_log_softmax_backward_data_out::call(grad_output, output, dim, self, out);
}

// aten::_logcumsumexp(Tensor self, int dim) -> Tensor
TORCH_API inline at::Tensor _logcumsumexp(const at::Tensor & self, int64_t dim) {
    return at::_ops::_logcumsumexp::call(self, dim);
}

// aten::_logcumsumexp.out(Tensor self, int dim, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & _logcumsumexp_out(at::Tensor & out, const at::Tensor & self, int64_t dim) {
    return at::_ops::_logcumsumexp_out::call(self, dim, out);
}

// aten::_logcumsumexp.out(Tensor self, int dim, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & _logcumsumexp_outf(const at::Tensor & self, int64_t dim, at::Tensor & out) {
    return at::_ops::_logcumsumexp_out::call(self, dim, out);
}

// aten::logcumsumexp(Tensor self, int dim) -> Tensor
TORCH_API inline at::Tensor logcumsumexp(const at::Tensor & self, int64_t dim) {
    return at::_ops::logcumsumexp::call(self, dim);
}

// aten::logcumsumexp.out(Tensor self, int dim, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & logcumsumexp_out(at::Tensor & out, const at::Tensor & self, int64_t dim) {
    return at::_ops::logcumsumexp_out::call(self, dim, out);
}

// aten::logcumsumexp.out(Tensor self, int dim, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & logcumsumexp_outf(const at::Tensor & self, int64_t dim, at::Tensor & out) {
    return at::_ops::logcumsumexp_out::call(self, dim, out);
}

// aten::logcumsumexp.dimname(Tensor self, Dimname dim) -> Tensor
TORCH_API inline at::Tensor logcumsumexp(const at::Tensor & self, at::Dimname dim) {
    return at::_ops::logcumsumexp_dimname::call(self, dim);
}

// aten::logcumsumexp.dimname_out(Tensor self, Dimname dim, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & logcumsumexp_out(at::Tensor & out, const at::Tensor & self, at::Dimname dim) {
    return at::_ops::logcumsumexp_dimname_out::call(self, dim, out);
}

// aten::logcumsumexp.dimname_out(Tensor self, Dimname dim, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & logcumsumexp_outf(const at::Tensor & self, at::Dimname dim, at::Tensor & out) {
    return at::_ops::logcumsumexp_dimname_out::call(self, dim, out);
}

// aten::logsumexp(Tensor self, int[1] dim, bool keepdim=False) -> Tensor
TORCH_API inline at::Tensor logsumexp(const at::Tensor & self, at::IntArrayRef dim, bool keepdim=false) {
    return at::_ops::logsumexp::call(self, dim, keepdim);
}

// aten::logsumexp.out(Tensor self, int[1] dim, bool keepdim=False, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & logsumexp_out(at::Tensor & out, const at::Tensor & self, at::IntArrayRef dim, bool keepdim=false) {
    return at::_ops::logsumexp_out::call(self, dim, keepdim, out);
}

// aten::logsumexp.out(Tensor self, int[1] dim, bool keepdim=False, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & logsumexp_outf(const at::Tensor & self, at::IntArrayRef dim, bool keepdim, at::Tensor & out) {
    return at::_ops::logsumexp_out::call(self, dim, keepdim, out);
}

// aten::logsumexp.names(Tensor self, Dimname[1] dim, bool keepdim=False) -> Tensor
TORCH_API inline at::Tensor logsumexp(const at::Tensor & self, at::DimnameList dim, bool keepdim=false) {
    return at::_ops::logsumexp_names::call(self, dim, keepdim);
}

// aten::logsumexp.names_out(Tensor self, Dimname[1] dim, bool keepdim=False, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & logsumexp_out(at::Tensor & out, const at::Tensor & self, at::DimnameList dim, bool keepdim=false) {
    return at::_ops::logsumexp_names_out::call(self, dim, keepdim, out);
}

// aten::logsumexp.names_out(Tensor self, Dimname[1] dim, bool keepdim=False, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & logsumexp_outf(const at::Tensor & self, at::DimnameList dim, bool keepdim, at::Tensor & out) {
    return at::_ops::logsumexp_names_out::call(self, dim, keepdim, out);
}

// aten::margin_ranking_loss(Tensor input1, Tensor input2, Tensor target, float margin=0.0, int reduction=Mean) -> Tensor
TORCH_API inline at::Tensor margin_ranking_loss(const at::Tensor & input1, const at::Tensor & input2, const at::Tensor & target, double margin=0.0, int64_t reduction=at::Reduction::Mean) {
    return at::_ops::margin_ranking_loss::call(input1, input2, target, margin, reduction);
}

// aten::matmul(Tensor self, Tensor other) -> Tensor
TORCH_API inline at::Tensor matmul(const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::matmul::call(self, other);
}

// aten::matmul.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & matmul_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::matmul_out::call(self, other, out);
}

// aten::matmul.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & matmul_outf(const at::Tensor & self, const at::Tensor & other, at::Tensor & out) {
    return at::_ops::matmul_out::call(self, other, out);
}

// aten::matrix_rank.tol(Tensor self, float tol, bool symmetric=False) -> Tensor
TORCH_API inline at::Tensor matrix_rank(const at::Tensor & self, double tol, bool symmetric=false) {
    return at::_ops::matrix_rank_tol::call(self, tol, symmetric);
}

// aten::matrix_rank(Tensor self, bool symmetric=False) -> Tensor
TORCH_API inline at::Tensor matrix_rank(const at::Tensor & self, bool symmetric=false) {
    return at::_ops::matrix_rank::call(self, symmetric);
}

// aten::matrix_power(Tensor self, int n) -> Tensor
TORCH_API inline at::Tensor matrix_power(const at::Tensor & self, int64_t n) {
    return at::_ops::matrix_power::call(self, n);
}

// aten::matrix_power.out(Tensor self, int n, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & matrix_power_out(at::Tensor & out, const at::Tensor & self, int64_t n) {
    return at::_ops::matrix_power_out::call(self, n, out);
}

// aten::matrix_power.out(Tensor self, int n, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & matrix_power_outf(const at::Tensor & self, int64_t n, at::Tensor & out) {
    return at::_ops::matrix_power_out::call(self, n, out);
}

// aten::matrix_exp(Tensor self) -> Tensor
TORCH_API inline at::Tensor matrix_exp(const at::Tensor & self) {
    return at::_ops::matrix_exp::call(self);
}

// aten::matrix_exp_backward(Tensor self, Tensor grad) -> Tensor
TORCH_API inline at::Tensor matrix_exp_backward(const at::Tensor & self, const at::Tensor & grad) {
    return at::_ops::matrix_exp_backward::call(self, grad);
}

// aten::_aminmax(Tensor self) -> (Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> _aminmax(const at::Tensor & self) {
    return at::_ops::_aminmax::call(self);
}

// aten::_aminmax.dim(Tensor self, int dim, bool keepdim=False) -> (Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> _aminmax(const at::Tensor & self, int64_t dim, bool keepdim=false) {
    return at::_ops::_aminmax_dim::call(self, dim, keepdim);
}

// aten::aminmax(Tensor self, *, int? dim=None, bool keepdim=False) -> (Tensor min, Tensor max)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> aminmax(const at::Tensor & self, c10::optional<int64_t> dim=c10::nullopt, bool keepdim=false) {
    return at::_ops::aminmax::call(self, dim, keepdim);
}

// aten::aminmax.out(Tensor self, *, int? dim=None, bool keepdim=False, Tensor(a!) min, Tensor(b!) max) -> (Tensor(a!) min, Tensor(b!) max)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> aminmax_out(at::Tensor & min, at::Tensor & max, const at::Tensor & self, c10::optional<int64_t> dim=c10::nullopt, bool keepdim=false) {
    return at::_ops::aminmax_out::call(self, dim, keepdim, min, max);
}

// aten::aminmax.out(Tensor self, *, int? dim=None, bool keepdim=False, Tensor(a!) min, Tensor(b!) max) -> (Tensor(a!) min, Tensor(b!) max)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> aminmax_outf(const at::Tensor & self, c10::optional<int64_t> dim, bool keepdim, at::Tensor & min, at::Tensor & max) {
    return at::_ops::aminmax_out::call(self, dim, keepdim, min, max);
}

// aten::_compute_linear_combination(Tensor input, Tensor coefficients) -> Tensor
TORCH_API inline at::Tensor _compute_linear_combination(const at::Tensor & input, const at::Tensor & coefficients) {
    return at::_ops::_compute_linear_combination::call(input, coefficients);
}

// aten::_compute_linear_combination.out(Tensor input, Tensor coefficients, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & _compute_linear_combination_out(at::Tensor & out, const at::Tensor & input, const at::Tensor & coefficients) {
    return at::_ops::_compute_linear_combination_out::call(input, coefficients, out);
}

// aten::_compute_linear_combination.out(Tensor input, Tensor coefficients, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & _compute_linear_combination_outf(const at::Tensor & input, const at::Tensor & coefficients, at::Tensor & out) {
    return at::_ops::_compute_linear_combination_out::call(input, coefficients, out);
}

// aten::max.dim(Tensor self, int dim, bool keepdim=False) -> (Tensor values, Tensor indices)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> max(const at::Tensor & self, int64_t dim, bool keepdim=false) {
    return at::_ops::max_dim::call(self, dim, keepdim);
}

// aten::max.dim_max(Tensor self, int dim, bool keepdim=False, *, Tensor(a!) max, Tensor(b!) max_values) -> (Tensor(a!) values, Tensor(b!) indices)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> max_out(at::Tensor & max, at::Tensor & max_values, const at::Tensor & self, int64_t dim, bool keepdim=false) {
    return at::_ops::max_dim_max::call(self, dim, keepdim, max, max_values);
}

// aten::max.dim_max(Tensor self, int dim, bool keepdim=False, *, Tensor(a!) max, Tensor(b!) max_values) -> (Tensor(a!) values, Tensor(b!) indices)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> max_outf(const at::Tensor & self, int64_t dim, bool keepdim, at::Tensor & max, at::Tensor & max_values) {
    return at::_ops::max_dim_max::call(self, dim, keepdim, max, max_values);
}

// aten::max.names_dim(Tensor self, Dimname dim, bool keepdim=False) -> (Tensor values, Tensor indices)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> max(const at::Tensor & self, at::Dimname dim, bool keepdim=false) {
    return at::_ops::max_names_dim::call(self, dim, keepdim);
}

// aten::max.names_dim_max(Tensor self, Dimname dim, bool keepdim=False, *, Tensor(a!) max, Tensor(b!) max_values) -> (Tensor(a!) values, Tensor(b!) indices)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> max_out(at::Tensor & max, at::Tensor & max_values, const at::Tensor & self, at::Dimname dim, bool keepdim=false) {
    return at::_ops::max_names_dim_max::call(self, dim, keepdim, max, max_values);
}

// aten::max.names_dim_max(Tensor self, Dimname dim, bool keepdim=False, *, Tensor(a!) max, Tensor(b!) max_values) -> (Tensor(a!) values, Tensor(b!) indices)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> max_outf(const at::Tensor & self, at::Dimname dim, bool keepdim, at::Tensor & max, at::Tensor & max_values) {
    return at::_ops::max_names_dim_max::call(self, dim, keepdim, max, max_values);
}

// aten::value_selecting_reduction_backward(Tensor grad, int dim, Tensor indices, int[] sizes, bool keepdim) -> Tensor
TORCH_API inline at::Tensor value_selecting_reduction_backward(const at::Tensor & grad, int64_t dim, const at::Tensor & indices, at::IntArrayRef sizes, bool keepdim) {
    return at::_ops::value_selecting_reduction_backward::call(grad, dim, indices, sizes, keepdim);
}

// aten::amax(Tensor self, int[1] dim=[], bool keepdim=False) -> Tensor
TORCH_API inline at::Tensor amax(const at::Tensor & self, at::IntArrayRef dim={}, bool keepdim=false) {
    return at::_ops::amax::call(self, dim, keepdim);
}

// aten::amax.out(Tensor self, int[1] dim=[], bool keepdim=False, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & amax_out(at::Tensor & out, const at::Tensor & self, at::IntArrayRef dim={}, bool keepdim=false) {
    return at::_ops::amax_out::call(self, dim, keepdim, out);
}

// aten::amax.out(Tensor self, int[1] dim=[], bool keepdim=False, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & amax_outf(const at::Tensor & self, at::IntArrayRef dim, bool keepdim, at::Tensor & out) {
    return at::_ops::amax_out::call(self, dim, keepdim, out);
}

// aten::max_pool1d_with_indices(Tensor self, int[1] kernel_size, int[1] stride=[], int[1] padding=0, int[1] dilation=1, bool ceil_mode=False) -> (Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> max_pool1d_with_indices(const at::Tensor & self, at::IntArrayRef kernel_size, at::IntArrayRef stride={}, at::IntArrayRef padding=0, at::IntArrayRef dilation=1, bool ceil_mode=false) {
    return at::_ops::max_pool1d_with_indices::call(self, kernel_size, stride, padding, dilation, ceil_mode);
}

// aten::max_pool1d(Tensor self, int[1] kernel_size, int[1] stride=[], int[1] padding=0, int[1] dilation=1, bool ceil_mode=False) -> Tensor
TORCH_API inline at::Tensor max_pool1d(const at::Tensor & self, at::IntArrayRef kernel_size, at::IntArrayRef stride={}, at::IntArrayRef padding=0, at::IntArrayRef dilation=1, bool ceil_mode=false) {
    return at::_ops::max_pool1d::call(self, kernel_size, stride, padding, dilation, ceil_mode);
}

// aten::max_pool2d(Tensor self, int[2] kernel_size, int[2] stride=[], int[2] padding=0, int[2] dilation=1, bool ceil_mode=False) -> Tensor
TORCH_API inline at::Tensor max_pool2d(const at::Tensor & self, at::IntArrayRef kernel_size, at::IntArrayRef stride={}, at::IntArrayRef padding=0, at::IntArrayRef dilation=1, bool ceil_mode=false) {
    return at::_ops::max_pool2d::call(self, kernel_size, stride, padding, dilation, ceil_mode);
}

// aten::mkldnn_max_pool2d(Tensor self, int[2] kernel_size, int[2] stride=[], int[2] padding=0, int[2] dilation=1, bool ceil_mode=False) -> Tensor
TORCH_API inline at::Tensor mkldnn_max_pool2d(const at::Tensor & self, at::IntArrayRef kernel_size, at::IntArrayRef stride={}, at::IntArrayRef padding=0, at::IntArrayRef dilation=1, bool ceil_mode=false) {
    return at::_ops::mkldnn_max_pool2d::call(self, kernel_size, stride, padding, dilation, ceil_mode);
}

// aten::mkldnn_max_pool2d_backward(Tensor grad_output, Tensor output, Tensor input, int[2] kernel_size, int[2] stride=[], int[2] padding=0, int[2] dilation=1, bool ceil_mode=False) -> Tensor
TORCH_API inline at::Tensor mkldnn_max_pool2d_backward(const at::Tensor & grad_output, const at::Tensor & output, const at::Tensor & input, at::IntArrayRef kernel_size, at::IntArrayRef stride={}, at::IntArrayRef padding=0, at::IntArrayRef dilation=1, bool ceil_mode=false) {
    return at::_ops::mkldnn_max_pool2d_backward::call(grad_output, output, input, kernel_size, stride, padding, dilation, ceil_mode);
}

// aten::mkldnn_max_pool3d(Tensor self, int[3] kernel_size, int[3] stride=[], int[3] padding=0, int[3] dilation=1, bool ceil_mode=False) -> Tensor
TORCH_API inline at::Tensor mkldnn_max_pool3d(const at::Tensor & self, at::IntArrayRef kernel_size, at::IntArrayRef stride={}, at::IntArrayRef padding=0, at::IntArrayRef dilation=1, bool ceil_mode=false) {
    return at::_ops::mkldnn_max_pool3d::call(self, kernel_size, stride, padding, dilation, ceil_mode);
}

// aten::mkldnn_max_pool3d_backward(Tensor grad_output, Tensor output, Tensor input, int[3] kernel_size, int[3] stride=[], int[3] padding=0, int[3] dilation=1, bool ceil_mode=False) -> Tensor
TORCH_API inline at::Tensor mkldnn_max_pool3d_backward(const at::Tensor & grad_output, const at::Tensor & output, const at::Tensor & input, at::IntArrayRef kernel_size, at::IntArrayRef stride={}, at::IntArrayRef padding=0, at::IntArrayRef dilation=1, bool ceil_mode=false) {
    return at::_ops::mkldnn_max_pool3d_backward::call(grad_output, output, input, kernel_size, stride, padding, dilation, ceil_mode);
}

// aten::quantized_max_pool1d(Tensor self, int[1] kernel_size, int[1] stride=[], int[1] padding=0, int[1] dilation=1, bool ceil_mode=False) -> Tensor
TORCH_API inline at::Tensor quantized_max_pool1d(const at::Tensor & self, at::IntArrayRef kernel_size, at::IntArrayRef stride={}, at::IntArrayRef padding=0, at::IntArrayRef dilation=1, bool ceil_mode=false) {
    return at::_ops::quantized_max_pool1d::call(self, kernel_size, stride, padding, dilation, ceil_mode);
}

// aten::quantized_max_pool2d(Tensor self, int[2] kernel_size, int[2] stride=[], int[2] padding=0, int[2] dilation=1, bool ceil_mode=False) -> Tensor
TORCH_API inline at::Tensor quantized_max_pool2d(const at::Tensor & self, at::IntArrayRef kernel_size, at::IntArrayRef stride={}, at::IntArrayRef padding=0, at::IntArrayRef dilation=1, bool ceil_mode=false) {
    return at::_ops::quantized_max_pool2d::call(self, kernel_size, stride, padding, dilation, ceil_mode);
}

// aten::max_pool3d(Tensor self, int[3] kernel_size, int[3] stride=[], int[3] padding=0, int[3] dilation=1, bool ceil_mode=False) -> Tensor
TORCH_API inline at::Tensor max_pool3d(const at::Tensor & self, at::IntArrayRef kernel_size, at::IntArrayRef stride={}, at::IntArrayRef padding=0, at::IntArrayRef dilation=1, bool ceil_mode=false) {
    return at::_ops::max_pool3d::call(self, kernel_size, stride, padding, dilation, ceil_mode);
}

// aten::mean(Tensor self, *, ScalarType? dtype=None) -> Tensor
TORCH_API inline at::Tensor mean(const at::Tensor & self, c10::optional<at::ScalarType> dtype=c10::nullopt) {
    return at::_ops::mean::call(self, dtype);
}

// aten::mean.dim(Tensor self, int[1] dim, bool keepdim=False, *, ScalarType? dtype=None) -> Tensor
TORCH_API inline at::Tensor mean(const at::Tensor & self, at::IntArrayRef dim, bool keepdim=false, c10::optional<at::ScalarType> dtype=c10::nullopt) {
    return at::_ops::mean_dim::call(self, dim, keepdim, dtype);
}

// aten::mean.out(Tensor self, int[1] dim, bool keepdim=False, *, ScalarType? dtype=None, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & mean_out(at::Tensor & out, const at::Tensor & self, at::IntArrayRef dim, bool keepdim=false, c10::optional<at::ScalarType> dtype=c10::nullopt) {
    return at::_ops::mean_out::call(self, dim, keepdim, dtype, out);
}

// aten::mean.out(Tensor self, int[1] dim, bool keepdim=False, *, ScalarType? dtype=None, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & mean_outf(const at::Tensor & self, at::IntArrayRef dim, bool keepdim, c10::optional<at::ScalarType> dtype, at::Tensor & out) {
    return at::_ops::mean_out::call(self, dim, keepdim, dtype, out);
}

// aten::mean.names_dim(Tensor self, Dimname[1] dim, bool keepdim=False, *, ScalarType? dtype=None) -> Tensor
TORCH_API inline at::Tensor mean(const at::Tensor & self, at::DimnameList dim, bool keepdim=false, c10::optional<at::ScalarType> dtype=c10::nullopt) {
    return at::_ops::mean_names_dim::call(self, dim, keepdim, dtype);
}

// aten::mean.names_out(Tensor self, Dimname[1] dim, bool keepdim=False, *, ScalarType? dtype=None, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & mean_out(at::Tensor & out, const at::Tensor & self, at::DimnameList dim, bool keepdim=false, c10::optional<at::ScalarType> dtype=c10::nullopt) {
    return at::_ops::mean_names_out::call(self, dim, keepdim, dtype, out);
}

// aten::mean.names_out(Tensor self, Dimname[1] dim, bool keepdim=False, *, ScalarType? dtype=None, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & mean_outf(const at::Tensor & self, at::DimnameList dim, bool keepdim, c10::optional<at::ScalarType> dtype, at::Tensor & out) {
    return at::_ops::mean_names_out::call(self, dim, keepdim, dtype, out);
}

// aten::nanmean(Tensor self, int[1] dim=[], bool keepdim=False, *, ScalarType? dtype=None) -> Tensor
TORCH_API inline at::Tensor nanmean(const at::Tensor & self, at::IntArrayRef dim={}, bool keepdim=false, c10::optional<at::ScalarType> dtype=c10::nullopt) {
    return at::_ops::nanmean::call(self, dim, keepdim, dtype);
}

// aten::nanmean.out(Tensor self, int[1] dim=[], bool keepdim=False, *, ScalarType? dtype=None, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & nanmean_out(at::Tensor & out, const at::Tensor & self, at::IntArrayRef dim={}, bool keepdim=false, c10::optional<at::ScalarType> dtype=c10::nullopt) {
    return at::_ops::nanmean_out::call(self, dim, keepdim, dtype, out);
}

// aten::nanmean.out(Tensor self, int[1] dim=[], bool keepdim=False, *, ScalarType? dtype=None, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & nanmean_outf(const at::Tensor & self, at::IntArrayRef dim, bool keepdim, c10::optional<at::ScalarType> dtype, at::Tensor & out) {
    return at::_ops::nanmean_out::call(self, dim, keepdim, dtype, out);
}

// aten::median(Tensor self) -> Tensor
TORCH_API inline at::Tensor median(const at::Tensor & self) {
    return at::_ops::median::call(self);
}

// aten::median.dim(Tensor self, int dim, bool keepdim=False) -> (Tensor values, Tensor indices)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> median(const at::Tensor & self, int64_t dim, bool keepdim=false) {
    return at::_ops::median_dim::call(self, dim, keepdim);
}

// aten::median.dim_values(Tensor self, int dim, bool keepdim=False, *, Tensor(a!) values, Tensor(b!) indices) -> (Tensor(a!) values, Tensor(b!) indices)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> median_out(at::Tensor & values, at::Tensor & indices, const at::Tensor & self, int64_t dim, bool keepdim=false) {
    return at::_ops::median_dim_values::call(self, dim, keepdim, values, indices);
}

// aten::median.dim_values(Tensor self, int dim, bool keepdim=False, *, Tensor(a!) values, Tensor(b!) indices) -> (Tensor(a!) values, Tensor(b!) indices)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> median_outf(const at::Tensor & self, int64_t dim, bool keepdim, at::Tensor & values, at::Tensor & indices) {
    return at::_ops::median_dim_values::call(self, dim, keepdim, values, indices);
}

// aten::median.names_dim(Tensor self, Dimname dim, bool keepdim=False) -> (Tensor values, Tensor indices)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> median(const at::Tensor & self, at::Dimname dim, bool keepdim=false) {
    return at::_ops::median_names_dim::call(self, dim, keepdim);
}

// aten::median.names_dim_values(Tensor self, Dimname dim, bool keepdim=False, *, Tensor(a!) values, Tensor(b!) indices) -> (Tensor(a!) values, Tensor(b!) indices)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> median_out(at::Tensor & values, at::Tensor & indices, const at::Tensor & self, at::Dimname dim, bool keepdim=false) {
    return at::_ops::median_names_dim_values::call(self, dim, keepdim, values, indices);
}

// aten::median.names_dim_values(Tensor self, Dimname dim, bool keepdim=False, *, Tensor(a!) values, Tensor(b!) indices) -> (Tensor(a!) values, Tensor(b!) indices)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> median_outf(const at::Tensor & self, at::Dimname dim, bool keepdim, at::Tensor & values, at::Tensor & indices) {
    return at::_ops::median_names_dim_values::call(self, dim, keepdim, values, indices);
}

// aten::nanmedian(Tensor self) -> Tensor
TORCH_API inline at::Tensor nanmedian(const at::Tensor & self) {
    return at::_ops::nanmedian::call(self);
}

// aten::nanmedian.dim(Tensor self, int dim, bool keepdim=False) -> (Tensor values, Tensor indices)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> nanmedian(const at::Tensor & self, int64_t dim, bool keepdim=false) {
    return at::_ops::nanmedian_dim::call(self, dim, keepdim);
}

// aten::nanmedian.dim_values(Tensor self, int dim, bool keepdim=False, *, Tensor(a!) values, Tensor(b!) indices) -> (Tensor(a!) values, Tensor(b!) indices)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> nanmedian_out(at::Tensor & values, at::Tensor & indices, const at::Tensor & self, int64_t dim, bool keepdim=false) {
    return at::_ops::nanmedian_dim_values::call(self, dim, keepdim, values, indices);
}

// aten::nanmedian.dim_values(Tensor self, int dim, bool keepdim=False, *, Tensor(a!) values, Tensor(b!) indices) -> (Tensor(a!) values, Tensor(b!) indices)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> nanmedian_outf(const at::Tensor & self, int64_t dim, bool keepdim, at::Tensor & values, at::Tensor & indices) {
    return at::_ops::nanmedian_dim_values::call(self, dim, keepdim, values, indices);
}

// aten::nanmedian.names_dim(Tensor self, Dimname dim, bool keepdim=False) -> (Tensor values, Tensor indices)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> nanmedian(const at::Tensor & self, at::Dimname dim, bool keepdim=false) {
    return at::_ops::nanmedian_names_dim::call(self, dim, keepdim);
}

// aten::nanmedian.names_dim_values(Tensor self, Dimname dim, bool keepdim=False, *, Tensor(a!) values, Tensor(b!) indices) -> (Tensor(a!) values, Tensor(b!) indices)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> nanmedian_out(at::Tensor & values, at::Tensor & indices, const at::Tensor & self, at::Dimname dim, bool keepdim=false) {
    return at::_ops::nanmedian_names_dim_values::call(self, dim, keepdim, values, indices);
}

// aten::nanmedian.names_dim_values(Tensor self, Dimname dim, bool keepdim=False, *, Tensor(a!) values, Tensor(b!) indices) -> (Tensor(a!) values, Tensor(b!) indices)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> nanmedian_outf(const at::Tensor & self, at::Dimname dim, bool keepdim, at::Tensor & values, at::Tensor & indices) {
    return at::_ops::nanmedian_names_dim_values::call(self, dim, keepdim, values, indices);
}

// aten::min.dim(Tensor self, int dim, bool keepdim=False) -> (Tensor values, Tensor indices)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> min(const at::Tensor & self, int64_t dim, bool keepdim=false) {
    return at::_ops::min_dim::call(self, dim, keepdim);
}

// aten::min.dim_min(Tensor self, int dim, bool keepdim=False, *, Tensor(a!) min, Tensor(b!) min_indices) -> (Tensor(a!) values, Tensor(b!) indices)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> min_out(at::Tensor & min, at::Tensor & min_indices, const at::Tensor & self, int64_t dim, bool keepdim=false) {
    return at::_ops::min_dim_min::call(self, dim, keepdim, min, min_indices);
}

// aten::min.dim_min(Tensor self, int dim, bool keepdim=False, *, Tensor(a!) min, Tensor(b!) min_indices) -> (Tensor(a!) values, Tensor(b!) indices)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> min_outf(const at::Tensor & self, int64_t dim, bool keepdim, at::Tensor & min, at::Tensor & min_indices) {
    return at::_ops::min_dim_min::call(self, dim, keepdim, min, min_indices);
}

// aten::min.names_dim(Tensor self, Dimname dim, bool keepdim=False) -> (Tensor values, Tensor indices)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> min(const at::Tensor & self, at::Dimname dim, bool keepdim=false) {
    return at::_ops::min_names_dim::call(self, dim, keepdim);
}

// aten::min.names_dim_min(Tensor self, Dimname dim, bool keepdim=False, *, Tensor(a!) min, Tensor(b!) min_indices) -> (Tensor(a!) values, Tensor(b!) indices)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> min_out(at::Tensor & min, at::Tensor & min_indices, const at::Tensor & self, at::Dimname dim, bool keepdim=false) {
    return at::_ops::min_names_dim_min::call(self, dim, keepdim, min, min_indices);
}

// aten::min.names_dim_min(Tensor self, Dimname dim, bool keepdim=False, *, Tensor(a!) min, Tensor(b!) min_indices) -> (Tensor(a!) values, Tensor(b!) indices)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> min_outf(const at::Tensor & self, at::Dimname dim, bool keepdim, at::Tensor & min, at::Tensor & min_indices) {
    return at::_ops::min_names_dim_min::call(self, dim, keepdim, min, min_indices);
}

// aten::amin(Tensor self, int[1] dim=[], bool keepdim=False) -> Tensor
TORCH_API inline at::Tensor amin(const at::Tensor & self, at::IntArrayRef dim={}, bool keepdim=false) {
    return at::_ops::amin::call(self, dim, keepdim);
}

// aten::amin.out(Tensor self, int[1] dim=[], bool keepdim=False, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & amin_out(at::Tensor & out, const at::Tensor & self, at::IntArrayRef dim={}, bool keepdim=false) {
    return at::_ops::amin_out::call(self, dim, keepdim, out);
}

// aten::amin.out(Tensor self, int[1] dim=[], bool keepdim=False, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & amin_outf(const at::Tensor & self, at::IntArrayRef dim, bool keepdim, at::Tensor & out) {
    return at::_ops::amin_out::call(self, dim, keepdim, out);
}

// aten::mkldnn_convolution(Tensor self, Tensor weight, Tensor? bias, int[] padding, int[] stride, int[] dilation, int groups) -> Tensor
TORCH_API inline at::Tensor mkldnn_convolution(const at::Tensor & self, const at::Tensor & weight, const c10::optional<at::Tensor> & bias, at::IntArrayRef padding, at::IntArrayRef stride, at::IntArrayRef dilation, int64_t groups) {
    return at::_ops::mkldnn_convolution::call(self, weight, bias, padding, stride, dilation, groups);
}

// aten::mkldnn_convolution_backward_input(int[] self_size, Tensor grad_output, Tensor weight, int[] padding, int[] stride, int[] dilation, int groups, bool bias_defined) -> Tensor
TORCH_API inline at::Tensor mkldnn_convolution_backward_input(at::IntArrayRef self_size, const at::Tensor & grad_output, const at::Tensor & weight, at::IntArrayRef padding, at::IntArrayRef stride, at::IntArrayRef dilation, int64_t groups, bool bias_defined) {
    return at::_ops::mkldnn_convolution_backward_input::call(self_size, grad_output, weight, padding, stride, dilation, groups, bias_defined);
}

// aten::mkldnn_convolution_backward_weights(int[] weight_size, Tensor grad_output, Tensor self, int[] padding, int[] stride, int[] dilation, int groups, bool bias_defined) -> (Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> mkldnn_convolution_backward_weights(at::IntArrayRef weight_size, const at::Tensor & grad_output, const at::Tensor & self, at::IntArrayRef padding, at::IntArrayRef stride, at::IntArrayRef dilation, int64_t groups, bool bias_defined) {
    return at::_ops::mkldnn_convolution_backward_weights::call(weight_size, grad_output, self, padding, stride, dilation, groups, bias_defined);
}

// aten::mkldnn_convolution_backward(Tensor self, Tensor grad_output, Tensor weight, int[] padding, int[] stride, int[] dilation, int groups, bool[3] output_mask) -> (Tensor, Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor,at::Tensor> mkldnn_convolution_backward(const at::Tensor & self, const at::Tensor & grad_output, const at::Tensor & weight, at::IntArrayRef padding, at::IntArrayRef stride, at::IntArrayRef dilation, int64_t groups, ::std::array<bool,3> output_mask) {
    return at::_ops::mkldnn_convolution_backward::call(self, grad_output, weight, padding, stride, dilation, groups, output_mask);
}

// aten::miopen_batch_norm(Tensor input, Tensor weight, Tensor? bias, Tensor? running_mean, Tensor? running_var, bool training, float exponential_average_factor, float epsilon) -> (Tensor, Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor,at::Tensor> miopen_batch_norm(const at::Tensor & input, const at::Tensor & weight, const c10::optional<at::Tensor> & bias, const c10::optional<at::Tensor> & running_mean, const c10::optional<at::Tensor> & running_var, bool training, double exponential_average_factor, double epsilon) {
    return at::_ops::miopen_batch_norm::call(input, weight, bias, running_mean, running_var, training, exponential_average_factor, epsilon);
}

// aten::miopen_batch_norm_backward(Tensor input, Tensor grad_output, Tensor weight, Tensor? running_mean, Tensor? running_var, Tensor? save_mean, Tensor? save_var, float epsilon) -> (Tensor, Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor,at::Tensor> miopen_batch_norm_backward(const at::Tensor & input, const at::Tensor & grad_output, const at::Tensor & weight, const c10::optional<at::Tensor> & running_mean, const c10::optional<at::Tensor> & running_var, const c10::optional<at::Tensor> & save_mean, const c10::optional<at::Tensor> & save_var, double epsilon) {
    return at::_ops::miopen_batch_norm_backward::call(input, grad_output, weight, running_mean, running_var, save_mean, save_var, epsilon);
}

// aten::miopen_convolution(Tensor self, Tensor weight, Tensor? bias, int[] padding, int[] stride, int[] dilation, int groups, bool benchmark, bool deterministic) -> Tensor
TORCH_API inline at::Tensor miopen_convolution(const at::Tensor & self, const at::Tensor & weight, const c10::optional<at::Tensor> & bias, at::IntArrayRef padding, at::IntArrayRef stride, at::IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic) {
    return at::_ops::miopen_convolution::call(self, weight, bias, padding, stride, dilation, groups, benchmark, deterministic);
}

// aten::miopen_convolution_backward_input(int[] self_size, Tensor grad_output, Tensor weight, int[] padding, int[] stride, int[] dilation, int groups, bool benchmark, bool deterministic) -> Tensor
TORCH_API inline at::Tensor miopen_convolution_backward_input(at::IntArrayRef self_size, const at::Tensor & grad_output, const at::Tensor & weight, at::IntArrayRef padding, at::IntArrayRef stride, at::IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic) {
    return at::_ops::miopen_convolution_backward_input::call(self_size, grad_output, weight, padding, stride, dilation, groups, benchmark, deterministic);
}

// aten::miopen_convolution_backward(Tensor self, Tensor grad_output, Tensor weight, int[] padding, int[] stride, int[] dilation, int groups, bool benchmark, bool deterministic, bool[3] output_mask) -> (Tensor, Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor,at::Tensor> miopen_convolution_backward(const at::Tensor & self, const at::Tensor & grad_output, const at::Tensor & weight, at::IntArrayRef padding, at::IntArrayRef stride, at::IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic, ::std::array<bool,3> output_mask) {
    return at::_ops::miopen_convolution_backward::call(self, grad_output, weight, padding, stride, dilation, groups, benchmark, deterministic, output_mask);
}

// aten::miopen_convolution_backward_bias(Tensor grad_output) -> Tensor
TORCH_API inline at::Tensor miopen_convolution_backward_bias(const at::Tensor & grad_output) {
    return at::_ops::miopen_convolution_backward_bias::call(grad_output);
}

// aten::miopen_convolution_backward_weight(int[] weight_size, Tensor grad_output, Tensor self, int[] padding, int[] stride, int[] dilation, int groups, bool benchmark, bool deterministic) -> Tensor
TORCH_API inline at::Tensor miopen_convolution_backward_weight(at::IntArrayRef weight_size, const at::Tensor & grad_output, const at::Tensor & self, at::IntArrayRef padding, at::IntArrayRef stride, at::IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic) {
    return at::_ops::miopen_convolution_backward_weight::call(weight_size, grad_output, self, padding, stride, dilation, groups, benchmark, deterministic);
}

// aten::miopen_convolution_transpose(Tensor self, Tensor weight, Tensor? bias, int[] padding, int[] output_padding, int[] stride, int[] dilation, int groups, bool benchmark, bool deterministic) -> Tensor
TORCH_API inline at::Tensor miopen_convolution_transpose(const at::Tensor & self, const at::Tensor & weight, const c10::optional<at::Tensor> & bias, at::IntArrayRef padding, at::IntArrayRef output_padding, at::IntArrayRef stride, at::IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic) {
    return at::_ops::miopen_convolution_transpose::call(self, weight, bias, padding, output_padding, stride, dilation, groups, benchmark, deterministic);
}

// aten::miopen_convolution_transpose_backward(Tensor self, Tensor grad_output, Tensor weight, int[] padding, int[] output_padding, int[] stride, int[] dilation, int groups, bool benchmark, bool deterministic, bool[3] output_mask) -> (Tensor, Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor,at::Tensor> miopen_convolution_transpose_backward(const at::Tensor & self, const at::Tensor & grad_output, const at::Tensor & weight, at::IntArrayRef padding, at::IntArrayRef output_padding, at::IntArrayRef stride, at::IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic, ::std::array<bool,3> output_mask) {
    return at::_ops::miopen_convolution_transpose_backward::call(self, grad_output, weight, padding, output_padding, stride, dilation, groups, benchmark, deterministic, output_mask);
}

// aten::miopen_convolution_transpose_backward_input(Tensor grad_output, Tensor weight, int[] padding, int[] stride, int[] dilation, int groups, bool benchmark, bool deterministic) -> Tensor
TORCH_API inline at::Tensor miopen_convolution_transpose_backward_input(const at::Tensor & grad_output, const at::Tensor & weight, at::IntArrayRef padding, at::IntArrayRef stride, at::IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic) {
    return at::_ops::miopen_convolution_transpose_backward_input::call(grad_output, weight, padding, stride, dilation, groups, benchmark, deterministic);
}

// aten::miopen_convolution_transpose_backward_weight(int[] weight_size, Tensor grad_output, Tensor self, int[] padding, int[] stride, int[] dilation, int groups, bool benchmark, bool deterministic) -> Tensor
TORCH_API inline at::Tensor miopen_convolution_transpose_backward_weight(at::IntArrayRef weight_size, const at::Tensor & grad_output, const at::Tensor & self, at::IntArrayRef padding, at::IntArrayRef stride, at::IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic) {
    return at::_ops::miopen_convolution_transpose_backward_weight::call(weight_size, grad_output, self, padding, stride, dilation, groups, benchmark, deterministic);
}

// aten::miopen_depthwise_convolution(Tensor self, Tensor weight, Tensor? bias, int[] padding, int[] stride, int[] dilation, int groups, bool benchmark, bool deterministic) -> Tensor
TORCH_API inline at::Tensor miopen_depthwise_convolution(const at::Tensor & self, const at::Tensor & weight, const c10::optional<at::Tensor> & bias, at::IntArrayRef padding, at::IntArrayRef stride, at::IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic) {
    return at::_ops::miopen_depthwise_convolution::call(self, weight, bias, padding, stride, dilation, groups, benchmark, deterministic);
}

// aten::miopen_depthwise_convolution_backward_input(int[] self_size, Tensor grad_output, Tensor weight, int[] padding, int[] stride, int[] dilation, int groups, bool benchmark, bool deterministic) -> Tensor
TORCH_API inline at::Tensor miopen_depthwise_convolution_backward_input(at::IntArrayRef self_size, const at::Tensor & grad_output, const at::Tensor & weight, at::IntArrayRef padding, at::IntArrayRef stride, at::IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic) {
    return at::_ops::miopen_depthwise_convolution_backward_input::call(self_size, grad_output, weight, padding, stride, dilation, groups, benchmark, deterministic);
}

// aten::miopen_depthwise_convolution_backward(Tensor self, Tensor grad_output, Tensor weight, int[] padding, int[] stride, int[] dilation, int groups, bool benchmark, bool deterministic, bool[3] output_mask) -> (Tensor, Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor,at::Tensor> miopen_depthwise_convolution_backward(const at::Tensor & self, const at::Tensor & grad_output, const at::Tensor & weight, at::IntArrayRef padding, at::IntArrayRef stride, at::IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic, ::std::array<bool,3> output_mask) {
    return at::_ops::miopen_depthwise_convolution_backward::call(self, grad_output, weight, padding, stride, dilation, groups, benchmark, deterministic, output_mask);
}

// aten::miopen_depthwise_convolution_backward_weight(int[] weight_size, Tensor grad_output, Tensor self, int[] padding, int[] stride, int[] dilation, int groups, bool benchmark, bool deterministic) -> Tensor
TORCH_API inline at::Tensor miopen_depthwise_convolution_backward_weight(at::IntArrayRef weight_size, const at::Tensor & grad_output, const at::Tensor & self, at::IntArrayRef padding, at::IntArrayRef stride, at::IntArrayRef dilation, int64_t groups, bool benchmark, bool deterministic) {
    return at::_ops::miopen_depthwise_convolution_backward_weight::call(weight_size, grad_output, self, padding, stride, dilation, groups, benchmark, deterministic);
}

// aten::miopen_rnn(Tensor input, Tensor[] weight, int weight_stride0, Tensor hx, Tensor? cx, int mode, int hidden_size, int num_layers, bool batch_first, float dropout, bool train, bool bidirectional, int[] batch_sizes, Tensor? dropout_state) -> (Tensor, Tensor, Tensor, Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor,at::Tensor,at::Tensor,at::Tensor> miopen_rnn(const at::Tensor & input, at::TensorList weight, int64_t weight_stride0, const at::Tensor & hx, const c10::optional<at::Tensor> & cx, int64_t mode, int64_t hidden_size, int64_t num_layers, bool batch_first, double dropout, bool train, bool bidirectional, at::IntArrayRef batch_sizes, const c10::optional<at::Tensor> & dropout_state) {
    return at::_ops::miopen_rnn::call(input, weight, weight_stride0, hx, cx, mode, hidden_size, num_layers, batch_first, dropout, train, bidirectional, batch_sizes, dropout_state);
}

// aten::miopen_rnn_backward(Tensor input, Tensor[] weight, int weight_stride0, Tensor weight_buf, Tensor hx, Tensor? cx, Tensor output, Tensor? grad_output, Tensor? grad_hy, Tensor? grad_cy, int mode, int hidden_size, int num_layers, bool batch_first, float dropout, bool train, bool bidirectional, int[] batch_sizes, Tensor? dropout_state, Tensor reserve, bool[4] output_mask) -> (Tensor, Tensor, Tensor, Tensor[])
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor,at::Tensor,::std::vector<at::Tensor>> miopen_rnn_backward(const at::Tensor & input, at::TensorList weight, int64_t weight_stride0, const at::Tensor & weight_buf, const at::Tensor & hx, const c10::optional<at::Tensor> & cx, const at::Tensor & output, const c10::optional<at::Tensor> & grad_output, const c10::optional<at::Tensor> & grad_hy, const c10::optional<at::Tensor> & grad_cy, int64_t mode, int64_t hidden_size, int64_t num_layers, bool batch_first, double dropout, bool train, bool bidirectional, at::IntArrayRef batch_sizes, const c10::optional<at::Tensor> & dropout_state, const at::Tensor & reserve, ::std::array<bool,4> output_mask) {
    return at::_ops::miopen_rnn_backward::call(input, weight, weight_stride0, weight_buf, hx, cx, output, grad_output, grad_hy, grad_cy, mode, hidden_size, num_layers, batch_first, dropout, train, bidirectional, batch_sizes, dropout_state, reserve, output_mask);
}

// aten::mm(Tensor self, Tensor mat2) -> Tensor
TORCH_API inline at::Tensor mm(const at::Tensor & self, const at::Tensor & mat2) {
    return at::_ops::mm::call(self, mat2);
}

// aten::mm.out(Tensor self, Tensor mat2, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & mm_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & mat2) {
    return at::_ops::mm_out::call(self, mat2, out);
}

// aten::mm.out(Tensor self, Tensor mat2, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & mm_outf(const at::Tensor & self, const at::Tensor & mat2, at::Tensor & out) {
    return at::_ops::mm_out::call(self, mat2, out);
}

// aten::_sparse_mm(Tensor sparse, Tensor dense) -> Tensor
TORCH_API inline at::Tensor _sparse_mm(const at::Tensor & sparse, const at::Tensor & dense) {
    return at::_ops::_sparse_mm::call(sparse, dense);
}

// aten::_sparse_sparse_matmul(Tensor self, Tensor other) -> Tensor
TORCH_API inline at::Tensor _sparse_sparse_matmul(const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::_sparse_sparse_matmul::call(self, other);
}

// aten::_sparse_mask_helper(Tensor t, Tensor mask_indices) -> Tensor
TORCH_API inline at::Tensor _sparse_mask_helper(const at::Tensor & t, const at::Tensor & mask_indices) {
    return at::_ops::_sparse_mask_helper::call(t, mask_indices);
}

// aten::mode(Tensor self, int dim=-1, bool keepdim=False) -> (Tensor values, Tensor indices)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> mode(const at::Tensor & self, int64_t dim=-1, bool keepdim=false) {
    return at::_ops::mode::call(self, dim, keepdim);
}

// aten::mode.values(Tensor self, int dim=-1, bool keepdim=False, *, Tensor(a!) values, Tensor(b!) indices) -> (Tensor(a!) values, Tensor(b!) indices)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> mode_out(at::Tensor & values, at::Tensor & indices, const at::Tensor & self, int64_t dim=-1, bool keepdim=false) {
    return at::_ops::mode_values::call(self, dim, keepdim, values, indices);
}

// aten::mode.values(Tensor self, int dim=-1, bool keepdim=False, *, Tensor(a!) values, Tensor(b!) indices) -> (Tensor(a!) values, Tensor(b!) indices)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> mode_outf(const at::Tensor & self, int64_t dim, bool keepdim, at::Tensor & values, at::Tensor & indices) {
    return at::_ops::mode_values::call(self, dim, keepdim, values, indices);
}

// aten::mode.dimname(Tensor self, Dimname dim, bool keepdim=False) -> (Tensor values, Tensor indices)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> mode(const at::Tensor & self, at::Dimname dim, bool keepdim=false) {
    return at::_ops::mode_dimname::call(self, dim, keepdim);
}

// aten::mode.dimname_out(Tensor self, Dimname dim, bool keepdim=False, *, Tensor(a!) values, Tensor(b!) indices) -> (Tensor(a!) values, Tensor(b!) indices)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> mode_out(at::Tensor & values, at::Tensor & indices, const at::Tensor & self, at::Dimname dim, bool keepdim=false) {
    return at::_ops::mode_dimname_out::call(self, dim, keepdim, values, indices);
}

// aten::mode.dimname_out(Tensor self, Dimname dim, bool keepdim=False, *, Tensor(a!) values, Tensor(b!) indices) -> (Tensor(a!) values, Tensor(b!) indices)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> mode_outf(const at::Tensor & self, at::Dimname dim, bool keepdim, at::Tensor & values, at::Tensor & indices) {
    return at::_ops::mode_dimname_out::call(self, dim, keepdim, values, indices);
}

// aten::mul.Tensor(Tensor self, Tensor other) -> Tensor
TORCH_API inline at::Tensor mul(const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::mul_Tensor::call(self, other);
}

// aten::mul.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & mul_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::mul_out::call(self, other, out);
}

// aten::mul.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & mul_outf(const at::Tensor & self, const at::Tensor & other, at::Tensor & out) {
    return at::_ops::mul_out::call(self, other, out);
}

// aten::mul.Scalar(Tensor self, Scalar other) -> Tensor
TORCH_API inline at::Tensor mul(const at::Tensor & self, const at::Scalar & other) {
    return at::_ops::mul_Scalar::call(self, other);
}

// aten::multiply.Tensor(Tensor self, Tensor other) -> Tensor
TORCH_API inline at::Tensor multiply(const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::multiply_Tensor::call(self, other);
}

// aten::multiply.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & multiply_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::multiply_out::call(self, other, out);
}

// aten::multiply.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & multiply_outf(const at::Tensor & self, const at::Tensor & other, at::Tensor & out) {
    return at::_ops::multiply_out::call(self, other, out);
}

// aten::multiply.Scalar(Tensor self, Scalar other) -> Tensor
TORCH_API inline at::Tensor multiply(const at::Tensor & self, const at::Scalar & other) {
    return at::_ops::multiply_Scalar::call(self, other);
}

// aten::mv(Tensor self, Tensor vec) -> Tensor
TORCH_API inline at::Tensor mv(const at::Tensor & self, const at::Tensor & vec) {
    return at::_ops::mv::call(self, vec);
}

// aten::mv.out(Tensor self, Tensor vec, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & mv_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & vec) {
    return at::_ops::mv_out::call(self, vec, out);
}

// aten::mv.out(Tensor self, Tensor vec, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & mv_outf(const at::Tensor & self, const at::Tensor & vec, at::Tensor & out) {
    return at::_ops::mv_out::call(self, vec, out);
}

// aten::mvlgamma.out(Tensor self, int p, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & mvlgamma_out(at::Tensor & out, const at::Tensor & self, int64_t p) {
    return at::_ops::mvlgamma_out::call(self, p, out);
}

// aten::mvlgamma.out(Tensor self, int p, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & mvlgamma_outf(const at::Tensor & self, int64_t p, at::Tensor & out) {
    return at::_ops::mvlgamma_out::call(self, p, out);
}

// aten::mvlgamma(Tensor self, int p) -> Tensor
TORCH_API inline at::Tensor mvlgamma(const at::Tensor & self, int64_t p) {
    return at::_ops::mvlgamma::call(self, p);
}

// aten::narrow_copy(Tensor self, int dim, int start, int length) -> Tensor
TORCH_API inline at::Tensor narrow_copy(const at::Tensor & self, int64_t dim, int64_t start, int64_t length) {
    return at::_ops::narrow_copy::call(self, dim, start, length);
}

// aten::narrow_copy.out(Tensor self, int dim, int start, int length, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & narrow_copy_out(at::Tensor & out, const at::Tensor & self, int64_t dim, int64_t start, int64_t length) {
    return at::_ops::narrow_copy_out::call(self, dim, start, length, out);
}

// aten::narrow_copy.out(Tensor self, int dim, int start, int length, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & narrow_copy_outf(const at::Tensor & self, int64_t dim, int64_t start, int64_t length, at::Tensor & out) {
    return at::_ops::narrow_copy_out::call(self, dim, start, length, out);
}

// aten::narrow(Tensor(a) self, int dim, int start, int length) -> Tensor(a)
TORCH_API inline at::Tensor narrow(const at::Tensor & self, int64_t dim, int64_t start, int64_t length) {
    return at::_ops::narrow::call(self, dim, start, length);
}

// aten::narrow.Tensor(Tensor(a) self, int dim, Tensor start, int length) -> Tensor(a)
TORCH_API inline at::Tensor narrow(const at::Tensor & self, int64_t dim, const at::Tensor & start, int64_t length) {
    return at::_ops::narrow_Tensor::call(self, dim, start, length);
}

// aten::native_batch_norm(Tensor input, Tensor? weight, Tensor? bias, Tensor? running_mean, Tensor? running_var, bool training, float momentum, float eps) -> (Tensor, Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor,at::Tensor> native_batch_norm(const at::Tensor & input, const c10::optional<at::Tensor> & weight, const c10::optional<at::Tensor> & bias, const c10::optional<at::Tensor> & running_mean, const c10::optional<at::Tensor> & running_var, bool training, double momentum, double eps) {
    return at::_ops::native_batch_norm::call(input, weight, bias, running_mean, running_var, training, momentum, eps);
}

// aten::native_batch_norm.out(Tensor input, Tensor? weight, Tensor? bias, Tensor? running_mean, Tensor? running_var, bool training, float momentum, float eps, *, Tensor(a!) out, Tensor(b!) save_mean, Tensor(c!) save_invstd) -> (Tensor(a!), Tensor(b!), Tensor(c!))
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &,at::Tensor &> native_batch_norm_out(at::Tensor & out, at::Tensor & save_mean, at::Tensor & save_invstd, const at::Tensor & input, const c10::optional<at::Tensor> & weight, const c10::optional<at::Tensor> & bias, const c10::optional<at::Tensor> & running_mean, const c10::optional<at::Tensor> & running_var, bool training, double momentum, double eps) {
    return at::_ops::native_batch_norm_out::call(input, weight, bias, running_mean, running_var, training, momentum, eps, out, save_mean, save_invstd);
}

// aten::native_batch_norm.out(Tensor input, Tensor? weight, Tensor? bias, Tensor? running_mean, Tensor? running_var, bool training, float momentum, float eps, *, Tensor(a!) out, Tensor(b!) save_mean, Tensor(c!) save_invstd) -> (Tensor(a!), Tensor(b!), Tensor(c!))
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &,at::Tensor &> native_batch_norm_outf(const at::Tensor & input, const c10::optional<at::Tensor> & weight, const c10::optional<at::Tensor> & bias, const c10::optional<at::Tensor> & running_mean, const c10::optional<at::Tensor> & running_var, bool training, double momentum, double eps, at::Tensor & out, at::Tensor & save_mean, at::Tensor & save_invstd) {
    return at::_ops::native_batch_norm_out::call(input, weight, bias, running_mean, running_var, training, momentum, eps, out, save_mean, save_invstd);
}

// aten::batch_norm_stats(Tensor input, float eps) -> (Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> batch_norm_stats(const at::Tensor & input, double eps) {
    return at::_ops::batch_norm_stats::call(input, eps);
}

// aten::batch_norm_elemt(Tensor input, Tensor? weight, Tensor? bias, Tensor mean, Tensor invstd, float eps) -> Tensor
TORCH_API inline at::Tensor batch_norm_elemt(const at::Tensor & input, const c10::optional<at::Tensor> & weight, const c10::optional<at::Tensor> & bias, const at::Tensor & mean, const at::Tensor & invstd, double eps) {
    return at::_ops::batch_norm_elemt::call(input, weight, bias, mean, invstd, eps);
}

// aten::batch_norm_elemt.out(Tensor input, Tensor? weight, Tensor? bias, Tensor mean, Tensor invstd, float eps, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & batch_norm_elemt_out(at::Tensor & out, const at::Tensor & input, const c10::optional<at::Tensor> & weight, const c10::optional<at::Tensor> & bias, const at::Tensor & mean, const at::Tensor & invstd, double eps) {
    return at::_ops::batch_norm_elemt_out::call(input, weight, bias, mean, invstd, eps, out);
}

// aten::batch_norm_elemt.out(Tensor input, Tensor? weight, Tensor? bias, Tensor mean, Tensor invstd, float eps, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & batch_norm_elemt_outf(const at::Tensor & input, const c10::optional<at::Tensor> & weight, const c10::optional<at::Tensor> & bias, const at::Tensor & mean, const at::Tensor & invstd, double eps, at::Tensor & out) {
    return at::_ops::batch_norm_elemt_out::call(input, weight, bias, mean, invstd, eps, out);
}

// aten::batch_norm_gather_stats(Tensor input, Tensor mean, Tensor invstd, Tensor? running_mean, Tensor? running_var, float momentum, float eps, int count) -> (Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> batch_norm_gather_stats(const at::Tensor & input, const at::Tensor & mean, const at::Tensor & invstd, const c10::optional<at::Tensor> & running_mean, const c10::optional<at::Tensor> & running_var, double momentum, double eps, int64_t count) {
    return at::_ops::batch_norm_gather_stats::call(input, mean, invstd, running_mean, running_var, momentum, eps, count);
}

// aten::batch_norm_gather_stats_with_counts(Tensor input, Tensor mean, Tensor invstd, Tensor? running_mean, Tensor? running_var, float momentum, float eps, Tensor counts) -> (Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> batch_norm_gather_stats_with_counts(const at::Tensor & input, const at::Tensor & mean, const at::Tensor & invstd, const c10::optional<at::Tensor> & running_mean, const c10::optional<at::Tensor> & running_var, double momentum, double eps, const at::Tensor & counts) {
    return at::_ops::batch_norm_gather_stats_with_counts::call(input, mean, invstd, running_mean, running_var, momentum, eps, counts);
}

// aten::native_batch_norm_backward(Tensor grad_out, Tensor input, Tensor? weight, Tensor? running_mean, Tensor? running_var, Tensor? save_mean, Tensor? save_invstd, bool train, float eps, bool[3] output_mask) -> (Tensor, Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor,at::Tensor> native_batch_norm_backward(const at::Tensor & grad_out, const at::Tensor & input, const c10::optional<at::Tensor> & weight, const c10::optional<at::Tensor> & running_mean, const c10::optional<at::Tensor> & running_var, const c10::optional<at::Tensor> & save_mean, const c10::optional<at::Tensor> & save_invstd, bool train, double eps, ::std::array<bool,3> output_mask) {
    return at::_ops::native_batch_norm_backward::call(grad_out, input, weight, running_mean, running_var, save_mean, save_invstd, train, eps, output_mask);
}

// aten::batch_norm_backward_reduce(Tensor grad_out, Tensor input, Tensor mean, Tensor invstd, Tensor? weight, bool input_g, bool weight_g, bool bias_g) -> (Tensor, Tensor, Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor,at::Tensor,at::Tensor> batch_norm_backward_reduce(const at::Tensor & grad_out, const at::Tensor & input, const at::Tensor & mean, const at::Tensor & invstd, const c10::optional<at::Tensor> & weight, bool input_g, bool weight_g, bool bias_g) {
    return at::_ops::batch_norm_backward_reduce::call(grad_out, input, mean, invstd, weight, input_g, weight_g, bias_g);
}

// aten::batch_norm_backward_elemt(Tensor grad_out, Tensor input, Tensor mean, Tensor invstd, Tensor? weight, Tensor mean_dy, Tensor mean_dy_xmu, Tensor count) -> Tensor
TORCH_API inline at::Tensor batch_norm_backward_elemt(const at::Tensor & grad_out, const at::Tensor & input, const at::Tensor & mean, const at::Tensor & invstd, const c10::optional<at::Tensor> & weight, const at::Tensor & mean_dy, const at::Tensor & mean_dy_xmu, const at::Tensor & count) {
    return at::_ops::batch_norm_backward_elemt::call(grad_out, input, mean, invstd, weight, mean_dy, mean_dy_xmu, count);
}

// aten::batch_norm_update_stats(Tensor input, Tensor? running_mean, Tensor? running_var, float momentum) -> (Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> batch_norm_update_stats(const at::Tensor & input, const c10::optional<at::Tensor> & running_mean, const c10::optional<at::Tensor> & running_var, double momentum) {
    return at::_ops::batch_norm_update_stats::call(input, running_mean, running_var, momentum);
}

// aten::is_vulkan_available() -> bool
TORCH_API inline bool is_vulkan_available() {
    return at::_ops::is_vulkan_available::call();
}

// aten::_nnpack_available() -> bool
TORCH_API inline bool _nnpack_available() {
    return at::_ops::_nnpack_available::call();
}

// aten::_nnpack_spatial_convolution(Tensor input, Tensor weight, Tensor? bias, int[2] padding, int[2] stride=1) -> Tensor
TORCH_API inline at::Tensor _nnpack_spatial_convolution(const at::Tensor & input, const at::Tensor & weight, const c10::optional<at::Tensor> & bias, at::IntArrayRef padding, at::IntArrayRef stride=1) {
    return at::_ops::_nnpack_spatial_convolution::call(input, weight, bias, padding, stride);
}

// aten::_nnpack_spatial_convolution_backward(Tensor input, Tensor grad_output, Tensor weight, int[2] padding, bool[3] output_mask) -> (Tensor, Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor,at::Tensor> _nnpack_spatial_convolution_backward(const at::Tensor & input, const at::Tensor & grad_output, const at::Tensor & weight, at::IntArrayRef padding, ::std::array<bool,3> output_mask) {
    return at::_ops::_nnpack_spatial_convolution_backward::call(input, grad_output, weight, padding, output_mask);
}

// aten::_nnpack_spatial_convolution_backward_input(Tensor input, Tensor grad_output, Tensor weight, int[2] padding) -> Tensor
TORCH_API inline at::Tensor _nnpack_spatial_convolution_backward_input(const at::Tensor & input, const at::Tensor & grad_output, const at::Tensor & weight, at::IntArrayRef padding) {
    return at::_ops::_nnpack_spatial_convolution_backward_input::call(input, grad_output, weight, padding);
}

// aten::_nnpack_spatial_convolution_backward_weight(Tensor input, int[] weightsize, Tensor grad_output, int[2] padding) -> Tensor
TORCH_API inline at::Tensor _nnpack_spatial_convolution_backward_weight(const at::Tensor & input, at::IntArrayRef weightsize, const at::Tensor & grad_output, at::IntArrayRef padding) {
    return at::_ops::_nnpack_spatial_convolution_backward_weight::call(input, weightsize, grad_output, padding);
}

// aten::ones.names(int[] size, *, Dimname[]? names, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor ones(at::IntArrayRef size, c10::optional<at::DimnameList> names, at::TensorOptions options={}) {
    return at::_ops::ones_names::call(size, names, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt());
}

// aten::ones.names(int[] size, *, Dimname[]? names, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor ones(at::IntArrayRef size, c10::optional<at::DimnameList> names, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory) {
    return at::_ops::ones_names::call(size, names, dtype, layout, device, pin_memory);
}

// aten::ones(int[] size, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor ones(at::IntArrayRef size, at::TensorOptions options={}) {
    return at::_ops::ones::call(size, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt());
}

// aten::ones(int[] size, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor ones(at::IntArrayRef size, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory) {
    return at::_ops::ones::call(size, dtype, layout, device, pin_memory);
}

// aten::ones.out(int[] size, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & ones_out(at::Tensor & out, at::IntArrayRef size) {
    return at::_ops::ones_out::call(size, out);
}

// aten::ones.out(int[] size, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & ones_outf(at::IntArrayRef size, at::Tensor & out) {
    return at::_ops::ones_out::call(size, out);
}

// aten::ones_like(Tensor self, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None, MemoryFormat? memory_format=None) -> Tensor
TORCH_API inline at::Tensor ones_like(const at::Tensor & self, at::TensorOptions options={}, c10::optional<at::MemoryFormat> memory_format=c10::nullopt) {
    return at::_ops::ones_like::call(self, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt(), c10::impl::check_tensor_options_and_extract_memory_format(options, memory_format));
}

// aten::ones_like(Tensor self, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None, MemoryFormat? memory_format=None) -> Tensor
TORCH_API inline at::Tensor ones_like(const at::Tensor & self, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory, c10::optional<at::MemoryFormat> memory_format) {
    return at::_ops::ones_like::call(self, dtype, layout, device, pin_memory, memory_format);
}

// aten::pairwise_distance(Tensor x1, Tensor x2, float p=2, float eps=1e-06, bool keepdim=False) -> Tensor
TORCH_API inline at::Tensor pairwise_distance(const at::Tensor & x1, const at::Tensor & x2, double p=2, double eps=1e-06, bool keepdim=false) {
    return at::_ops::pairwise_distance::call(x1, x2, p, eps, keepdim);
}

// aten::cdist(Tensor x1, Tensor x2, float p=2, int? compute_mode=None) -> Tensor
TORCH_API inline at::Tensor cdist(const at::Tensor & x1, const at::Tensor & x2, double p=2, c10::optional<int64_t> compute_mode=c10::nullopt) {
    return at::_ops::cdist::call(x1, x2, p, compute_mode);
}

// aten::_euclidean_dist(Tensor x1, Tensor x2) -> Tensor
TORCH_API inline at::Tensor _euclidean_dist(const at::Tensor & x1, const at::Tensor & x2) {
    return at::_ops::_euclidean_dist::call(x1, x2);
}

// aten::_cdist_forward(Tensor x1, Tensor x2, float p, int? compute_mode) -> Tensor
TORCH_API inline at::Tensor _cdist_forward(const at::Tensor & x1, const at::Tensor & x2, double p, c10::optional<int64_t> compute_mode) {
    return at::_ops::_cdist_forward::call(x1, x2, p, compute_mode);
}

// aten::_cdist_backward(Tensor grad, Tensor x1, Tensor x2, float p, Tensor cdist) -> Tensor
TORCH_API inline at::Tensor _cdist_backward(const at::Tensor & grad, const at::Tensor & x1, const at::Tensor & x2, double p, const at::Tensor & cdist) {
    return at::_ops::_cdist_backward::call(grad, x1, x2, p, cdist);
}

// aten::pdist(Tensor self, float p=2) -> Tensor
TORCH_API inline at::Tensor pdist(const at::Tensor & self, double p=2) {
    return at::_ops::pdist::call(self, p);
}

// aten::_pdist_forward(Tensor self, float p=2) -> Tensor
TORCH_API inline at::Tensor _pdist_forward(const at::Tensor & self, double p=2) {
    return at::_ops::_pdist_forward::call(self, p);
}

// aten::_pdist_backward(Tensor grad, Tensor self, float p, Tensor pdist) -> Tensor
TORCH_API inline at::Tensor _pdist_backward(const at::Tensor & grad, const at::Tensor & self, double p, const at::Tensor & pdist) {
    return at::_ops::_pdist_backward::call(grad, self, p, pdist);
}

// aten::cosine_similarity(Tensor x1, Tensor x2, int dim=1, float eps=1e-08) -> Tensor
TORCH_API inline at::Tensor cosine_similarity(const at::Tensor & x1, const at::Tensor & x2, int64_t dim=1, double eps=1e-08) {
    return at::_ops::cosine_similarity::call(x1, x2, dim, eps);
}

// aten::permute(Tensor(a) self, int[] dims) -> Tensor(a)
TORCH_API inline at::Tensor permute(const at::Tensor & self, at::IntArrayRef dims) {
    return at::_ops::permute::call(self, dims);
}

// aten::movedim.intlist(Tensor(a) self, int[] source, int[] destination) -> Tensor(a)
TORCH_API inline at::Tensor movedim(const at::Tensor & self, at::IntArrayRef source, at::IntArrayRef destination) {
    return at::_ops::movedim_intlist::call(self, source, destination);
}

// aten::movedim.int(Tensor(a) self, int source, int destination) -> Tensor(a)
TORCH_API inline at::Tensor movedim(const at::Tensor & self, int64_t source, int64_t destination) {
    return at::_ops::movedim_int::call(self, source, destination);
}

// aten::moveaxis.intlist(Tensor(a) self, int[] source, int[] destination) -> Tensor(a)
TORCH_API inline at::Tensor moveaxis(const at::Tensor & self, at::IntArrayRef source, at::IntArrayRef destination) {
    return at::_ops::moveaxis_intlist::call(self, source, destination);
}

// aten::moveaxis.int(Tensor(a) self, int source, int destination) -> Tensor(a)
TORCH_API inline at::Tensor moveaxis(const at::Tensor & self, int64_t source, int64_t destination) {
    return at::_ops::moveaxis_int::call(self, source, destination);
}

// aten::pixel_shuffle(Tensor self, int upscale_factor) -> Tensor
TORCH_API inline at::Tensor pixel_shuffle(const at::Tensor & self, int64_t upscale_factor) {
    return at::_ops::pixel_shuffle::call(self, upscale_factor);
}

// aten::pixel_unshuffle(Tensor self, int downscale_factor) -> Tensor
TORCH_API inline at::Tensor pixel_unshuffle(const at::Tensor & self, int64_t downscale_factor) {
    return at::_ops::pixel_unshuffle::call(self, downscale_factor);
}

// aten::channel_shuffle(Tensor self, int groups) -> Tensor
TORCH_API inline at::Tensor channel_shuffle(const at::Tensor & self, int64_t groups) {
    return at::_ops::channel_shuffle::call(self, groups);
}

// aten::_pin_memory(Tensor self, Device? device=None) -> Tensor
TORCH_API inline at::Tensor _pin_memory(const at::Tensor & self, c10::optional<at::Device> device=c10::nullopt) {
    return at::_ops::_pin_memory::call(self, device);
}

// aten::pinverse(Tensor self, float rcond=1e-15) -> Tensor
TORCH_API inline at::Tensor pinverse(const at::Tensor & self, double rcond=1e-15) {
    return at::_ops::pinverse::call(self, rcond);
}

// aten::poisson_nll_loss(Tensor input, Tensor target, bool log_input, bool full, float eps, int reduction) -> Tensor
TORCH_API inline at::Tensor poisson_nll_loss(const at::Tensor & input, const at::Tensor & target, bool log_input, bool full, double eps, int64_t reduction) {
    return at::_ops::poisson_nll_loss::call(input, target, log_input, full, eps, reduction);
}

// aten::rad2deg(Tensor self) -> Tensor
TORCH_API inline at::Tensor rad2deg(const at::Tensor & self) {
    return at::_ops::rad2deg::call(self);
}

// aten::rad2deg_(Tensor(a!) self) -> Tensor(a!)
TORCH_API inline at::Tensor & rad2deg_(at::Tensor & self) {
    return at::_ops::rad2deg_::call(self);
}

// aten::rad2deg.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & rad2deg_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::rad2deg_out::call(self, out);
}

// aten::rad2deg.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & rad2deg_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::rad2deg_out::call(self, out);
}

// aten::deg2rad(Tensor self) -> Tensor
TORCH_API inline at::Tensor deg2rad(const at::Tensor & self) {
    return at::_ops::deg2rad::call(self);
}

// aten::deg2rad_(Tensor(a!) self) -> Tensor(a!)
TORCH_API inline at::Tensor & deg2rad_(at::Tensor & self) {
    return at::_ops::deg2rad_::call(self);
}

// aten::deg2rad.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & deg2rad_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::deg2rad_out::call(self, out);
}

// aten::deg2rad.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & deg2rad_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::deg2rad_out::call(self, out);
}

// aten::scalar_tensor(Scalar s, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor scalar_tensor(const at::Scalar & s, at::TensorOptions options={}) {
    return at::_ops::scalar_tensor::call(s, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt());
}

// aten::scalar_tensor(Scalar s, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor scalar_tensor(const at::Scalar & s, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory) {
    return at::_ops::scalar_tensor::call(s, dtype, layout, device, pin_memory);
}

// aten::rand.names(int[] size, *, Dimname[]? names, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor rand(at::IntArrayRef size, c10::optional<at::DimnameList> names, at::TensorOptions options={}) {
    return at::_ops::rand_names::call(size, names, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt());
}

// aten::rand.names(int[] size, *, Dimname[]? names, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor rand(at::IntArrayRef size, c10::optional<at::DimnameList> names, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory) {
    return at::_ops::rand_names::call(size, names, dtype, layout, device, pin_memory);
}

// aten::rand.generator_with_names(int[] size, *, Generator? generator, Dimname[]? names, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor rand(at::IntArrayRef size, c10::optional<at::Generator> generator, c10::optional<at::DimnameList> names, at::TensorOptions options={}) {
    return at::_ops::rand_generator_with_names::call(size, generator, names, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt());
}

// aten::rand.generator_with_names(int[] size, *, Generator? generator, Dimname[]? names, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor rand(at::IntArrayRef size, c10::optional<at::Generator> generator, c10::optional<at::DimnameList> names, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory) {
    return at::_ops::rand_generator_with_names::call(size, generator, names, dtype, layout, device, pin_memory);
}

// aten::rand(int[] size, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor rand(at::IntArrayRef size, at::TensorOptions options={}) {
    return at::_ops::rand::call(size, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt());
}

// aten::rand(int[] size, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor rand(at::IntArrayRef size, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory) {
    return at::_ops::rand::call(size, dtype, layout, device, pin_memory);
}

// aten::rand.generator(int[] size, *, Generator? generator, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor rand(at::IntArrayRef size, c10::optional<at::Generator> generator, at::TensorOptions options={}) {
    return at::_ops::rand_generator::call(size, generator, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt());
}

// aten::rand.generator(int[] size, *, Generator? generator, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor rand(at::IntArrayRef size, c10::optional<at::Generator> generator, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory) {
    return at::_ops::rand_generator::call(size, generator, dtype, layout, device, pin_memory);
}

// aten::rand.out(int[] size, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & rand_out(at::Tensor & out, at::IntArrayRef size) {
    return at::_ops::rand_out::call(size, out);
}

// aten::rand.out(int[] size, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & rand_outf(at::IntArrayRef size, at::Tensor & out) {
    return at::_ops::rand_out::call(size, out);
}

// aten::rand.generator_out(int[] size, *, Generator? generator, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & rand_out(at::Tensor & out, at::IntArrayRef size, c10::optional<at::Generator> generator) {
    return at::_ops::rand_generator_out::call(size, generator, out);
}

// aten::rand.generator_out(int[] size, *, Generator? generator, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & rand_outf(at::IntArrayRef size, c10::optional<at::Generator> generator, at::Tensor & out) {
    return at::_ops::rand_generator_out::call(size, generator, out);
}

// aten::rand_like(Tensor self, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None, MemoryFormat? memory_format=None) -> Tensor
TORCH_API inline at::Tensor rand_like(const at::Tensor & self, at::TensorOptions options={}, c10::optional<at::MemoryFormat> memory_format=c10::nullopt) {
    return at::_ops::rand_like::call(self, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt(), c10::impl::check_tensor_options_and_extract_memory_format(options, memory_format));
}

// aten::rand_like(Tensor self, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None, MemoryFormat? memory_format=None) -> Tensor
TORCH_API inline at::Tensor rand_like(const at::Tensor & self, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory, c10::optional<at::MemoryFormat> memory_format) {
    return at::_ops::rand_like::call(self, dtype, layout, device, pin_memory, memory_format);
}

// aten::randint(int high, int[] size, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor randint(int64_t high, at::IntArrayRef size, at::TensorOptions options={}) {
    return at::_ops::randint::call(high, size, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt());
}

// aten::randint(int high, int[] size, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor randint(int64_t high, at::IntArrayRef size, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory) {
    return at::_ops::randint::call(high, size, dtype, layout, device, pin_memory);
}

// aten::randint.generator(int high, int[] size, *, Generator? generator, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor randint(int64_t high, at::IntArrayRef size, c10::optional<at::Generator> generator, at::TensorOptions options={}) {
    return at::_ops::randint_generator::call(high, size, generator, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt());
}

// aten::randint.generator(int high, int[] size, *, Generator? generator, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor randint(int64_t high, at::IntArrayRef size, c10::optional<at::Generator> generator, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory) {
    return at::_ops::randint_generator::call(high, size, generator, dtype, layout, device, pin_memory);
}

// aten::randint.low(int low, int high, int[] size, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor randint(int64_t low, int64_t high, at::IntArrayRef size, at::TensorOptions options={}) {
    return at::_ops::randint_low::call(low, high, size, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt());
}

// aten::randint.low(int low, int high, int[] size, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor randint(int64_t low, int64_t high, at::IntArrayRef size, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory) {
    return at::_ops::randint_low::call(low, high, size, dtype, layout, device, pin_memory);
}

// aten::randint.low_generator(int low, int high, int[] size, *, Generator? generator, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor randint(int64_t low, int64_t high, at::IntArrayRef size, c10::optional<at::Generator> generator, at::TensorOptions options={}) {
    return at::_ops::randint_low_generator::call(low, high, size, generator, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt());
}

// aten::randint.low_generator(int low, int high, int[] size, *, Generator? generator, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor randint(int64_t low, int64_t high, at::IntArrayRef size, c10::optional<at::Generator> generator, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory) {
    return at::_ops::randint_low_generator::call(low, high, size, generator, dtype, layout, device, pin_memory);
}

// aten::randint.out(int high, int[] size, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & randint_out(at::Tensor & out, int64_t high, at::IntArrayRef size) {
    return at::_ops::randint_out::call(high, size, out);
}

// aten::randint.out(int high, int[] size, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & randint_outf(int64_t high, at::IntArrayRef size, at::Tensor & out) {
    return at::_ops::randint_out::call(high, size, out);
}

// aten::randint.generator_out(int high, int[] size, *, Generator? generator, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & randint_out(at::Tensor & out, int64_t high, at::IntArrayRef size, c10::optional<at::Generator> generator) {
    return at::_ops::randint_generator_out::call(high, size, generator, out);
}

// aten::randint.generator_out(int high, int[] size, *, Generator? generator, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & randint_outf(int64_t high, at::IntArrayRef size, c10::optional<at::Generator> generator, at::Tensor & out) {
    return at::_ops::randint_generator_out::call(high, size, generator, out);
}

// aten::randint.low_out(int low, int high, int[] size, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & randint_out(at::Tensor & out, int64_t low, int64_t high, at::IntArrayRef size) {
    return at::_ops::randint_low_out::call(low, high, size, out);
}

// aten::randint.low_out(int low, int high, int[] size, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & randint_outf(int64_t low, int64_t high, at::IntArrayRef size, at::Tensor & out) {
    return at::_ops::randint_low_out::call(low, high, size, out);
}

// aten::randint.low_generator_out(int low, int high, int[] size, *, Generator? generator, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & randint_out(at::Tensor & out, int64_t low, int64_t high, at::IntArrayRef size, c10::optional<at::Generator> generator) {
    return at::_ops::randint_low_generator_out::call(low, high, size, generator, out);
}

// aten::randint.low_generator_out(int low, int high, int[] size, *, Generator? generator, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & randint_outf(int64_t low, int64_t high, at::IntArrayRef size, c10::optional<at::Generator> generator, at::Tensor & out) {
    return at::_ops::randint_low_generator_out::call(low, high, size, generator, out);
}

// aten::randint_like(Tensor self, int high, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None, MemoryFormat? memory_format=None) -> Tensor
TORCH_API inline at::Tensor randint_like(const at::Tensor & self, int64_t high, at::TensorOptions options={}, c10::optional<at::MemoryFormat> memory_format=c10::nullopt) {
    return at::_ops::randint_like::call(self, high, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt(), c10::impl::check_tensor_options_and_extract_memory_format(options, memory_format));
}

// aten::randint_like(Tensor self, int high, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None, MemoryFormat? memory_format=None) -> Tensor
TORCH_API inline at::Tensor randint_like(const at::Tensor & self, int64_t high, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory, c10::optional<at::MemoryFormat> memory_format) {
    return at::_ops::randint_like::call(self, high, dtype, layout, device, pin_memory, memory_format);
}

// aten::randint_like.low_dtype(Tensor self, int low, int high, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None, MemoryFormat? memory_format=None) -> Tensor
TORCH_API inline at::Tensor randint_like(const at::Tensor & self, int64_t low, int64_t high, at::TensorOptions options={}, c10::optional<at::MemoryFormat> memory_format=c10::nullopt) {
    return at::_ops::randint_like_low_dtype::call(self, low, high, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt(), c10::impl::check_tensor_options_and_extract_memory_format(options, memory_format));
}

// aten::randint_like.low_dtype(Tensor self, int low, int high, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None, MemoryFormat? memory_format=None) -> Tensor
TORCH_API inline at::Tensor randint_like(const at::Tensor & self, int64_t low, int64_t high, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory, c10::optional<at::MemoryFormat> memory_format) {
    return at::_ops::randint_like_low_dtype::call(self, low, high, dtype, layout, device, pin_memory, memory_format);
}

// aten::randn(int[] size, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor randn(at::IntArrayRef size, at::TensorOptions options={}) {
    return at::_ops::randn::call(size, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt());
}

// aten::randn(int[] size, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor randn(at::IntArrayRef size, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory) {
    return at::_ops::randn::call(size, dtype, layout, device, pin_memory);
}

// aten::randn.generator(int[] size, *, Generator? generator, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor randn(at::IntArrayRef size, c10::optional<at::Generator> generator, at::TensorOptions options={}) {
    return at::_ops::randn_generator::call(size, generator, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt());
}

// aten::randn.generator(int[] size, *, Generator? generator, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor randn(at::IntArrayRef size, c10::optional<at::Generator> generator, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory) {
    return at::_ops::randn_generator::call(size, generator, dtype, layout, device, pin_memory);
}

// aten::randn.names(int[] size, *, Dimname[]? names, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor randn(at::IntArrayRef size, c10::optional<at::DimnameList> names, at::TensorOptions options={}) {
    return at::_ops::randn_names::call(size, names, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt());
}

// aten::randn.names(int[] size, *, Dimname[]? names, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor randn(at::IntArrayRef size, c10::optional<at::DimnameList> names, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory) {
    return at::_ops::randn_names::call(size, names, dtype, layout, device, pin_memory);
}

// aten::randn.generator_with_names(int[] size, *, Generator? generator, Dimname[]? names, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor randn(at::IntArrayRef size, c10::optional<at::Generator> generator, c10::optional<at::DimnameList> names, at::TensorOptions options={}) {
    return at::_ops::randn_generator_with_names::call(size, generator, names, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt());
}

// aten::randn.generator_with_names(int[] size, *, Generator? generator, Dimname[]? names, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor randn(at::IntArrayRef size, c10::optional<at::Generator> generator, c10::optional<at::DimnameList> names, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory) {
    return at::_ops::randn_generator_with_names::call(size, generator, names, dtype, layout, device, pin_memory);
}

// aten::randn.out(int[] size, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & randn_out(at::Tensor & out, at::IntArrayRef size) {
    return at::_ops::randn_out::call(size, out);
}

// aten::randn.out(int[] size, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & randn_outf(at::IntArrayRef size, at::Tensor & out) {
    return at::_ops::randn_out::call(size, out);
}

// aten::randn.generator_out(int[] size, *, Generator? generator, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & randn_out(at::Tensor & out, at::IntArrayRef size, c10::optional<at::Generator> generator) {
    return at::_ops::randn_generator_out::call(size, generator, out);
}

// aten::randn.generator_out(int[] size, *, Generator? generator, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & randn_outf(at::IntArrayRef size, c10::optional<at::Generator> generator, at::Tensor & out) {
    return at::_ops::randn_generator_out::call(size, generator, out);
}

// aten::randn_like(Tensor self, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None, MemoryFormat? memory_format=None) -> Tensor
TORCH_API inline at::Tensor randn_like(const at::Tensor & self, at::TensorOptions options={}, c10::optional<at::MemoryFormat> memory_format=c10::nullopt) {
    return at::_ops::randn_like::call(self, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt(), c10::impl::check_tensor_options_and_extract_memory_format(options, memory_format));
}

// aten::randn_like(Tensor self, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None, MemoryFormat? memory_format=None) -> Tensor
TORCH_API inline at::Tensor randn_like(const at::Tensor & self, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory, c10::optional<at::MemoryFormat> memory_format) {
    return at::_ops::randn_like::call(self, dtype, layout, device, pin_memory, memory_format);
}

// aten::randperm(int n, *, ScalarType? dtype=long, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor randperm(int64_t n, at::TensorOptions options=at::kLong) {
    return at::_ops::randperm::call(n, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt());
}

// aten::randperm(int n, *, ScalarType? dtype=long, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor randperm(int64_t n, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory) {
    return at::_ops::randperm::call(n, dtype, layout, device, pin_memory);
}

// aten::randperm.generator(int n, *, Generator? generator, ScalarType? dtype=long, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor randperm(int64_t n, c10::optional<at::Generator> generator, at::TensorOptions options=at::kLong) {
    return at::_ops::randperm_generator::call(n, generator, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt());
}

// aten::randperm.generator(int n, *, Generator? generator, ScalarType? dtype=long, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor randperm(int64_t n, c10::optional<at::Generator> generator, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory) {
    return at::_ops::randperm_generator::call(n, generator, dtype, layout, device, pin_memory);
}

// aten::randperm.out(int n, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & randperm_out(at::Tensor & out, int64_t n) {
    return at::_ops::randperm_out::call(n, out);
}

// aten::randperm.out(int n, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & randperm_outf(int64_t n, at::Tensor & out) {
    return at::_ops::randperm_out::call(n, out);
}

// aten::randperm.generator_out(int n, *, Generator? generator, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & randperm_out(at::Tensor & out, int64_t n, c10::optional<at::Generator> generator) {
    return at::_ops::randperm_generator_out::call(n, generator, out);
}

// aten::randperm.generator_out(int n, *, Generator? generator, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & randperm_outf(int64_t n, c10::optional<at::Generator> generator, at::Tensor & out) {
    return at::_ops::randperm_generator_out::call(n, generator, out);
}

// aten::range.step(Scalar start, Scalar end, Scalar step=1, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor range(const at::Scalar & start, const at::Scalar & end, const at::Scalar & step=1, at::TensorOptions options={}) {
    return at::_ops::range_step::call(start, end, step, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt());
}

// aten::range.step(Scalar start, Scalar end, Scalar step=1, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor range(const at::Scalar & start, const at::Scalar & end, const at::Scalar & step, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory) {
    return at::_ops::range_step::call(start, end, step, dtype, layout, device, pin_memory);
}

// aten::range(Scalar start, Scalar end, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor range(const at::Scalar & start, const at::Scalar & end, at::TensorOptions options={}) {
    return at::_ops::range::call(start, end, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt());
}

// aten::range(Scalar start, Scalar end, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor range(const at::Scalar & start, const at::Scalar & end, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory) {
    return at::_ops::range::call(start, end, dtype, layout, device, pin_memory);
}

// aten::range.out(Scalar start, Scalar end, Scalar step=1, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & range_out(at::Tensor & out, const at::Scalar & start, const at::Scalar & end, const at::Scalar & step=1) {
    return at::_ops::range_out::call(start, end, step, out);
}

// aten::range.out(Scalar start, Scalar end, Scalar step=1, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & range_outf(const at::Scalar & start, const at::Scalar & end, const at::Scalar & step, at::Tensor & out) {
    return at::_ops::range_out::call(start, end, step, out);
}

// aten::ravel(Tensor(a) self) -> Tensor(a)
TORCH_API inline at::Tensor ravel(const at::Tensor & self) {
    return at::_ops::ravel::call(self);
}

// aten::reciprocal(Tensor self) -> Tensor
TORCH_API inline at::Tensor reciprocal(const at::Tensor & self) {
    return at::_ops::reciprocal::call(self);
}

// aten::reciprocal_(Tensor(a!) self) -> Tensor(a!)
TORCH_API inline at::Tensor & reciprocal_(at::Tensor & self) {
    return at::_ops::reciprocal_::call(self);
}

// aten::reciprocal.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & reciprocal_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::reciprocal_out::call(self, out);
}

// aten::reciprocal.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & reciprocal_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::reciprocal_out::call(self, out);
}

// aten::neg(Tensor self) -> Tensor
TORCH_API inline at::Tensor neg(const at::Tensor & self) {
    return at::_ops::neg::call(self);
}

// aten::neg_(Tensor(a!) self) -> Tensor(a!)
TORCH_API inline at::Tensor & neg_(at::Tensor & self) {
    return at::_ops::neg_::call(self);
}

// aten::neg.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & neg_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::neg_out::call(self, out);
}

// aten::neg.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & neg_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::neg_out::call(self, out);
}

// aten::negative(Tensor self) -> Tensor
TORCH_API inline at::Tensor negative(const at::Tensor & self) {
    return at::_ops::negative::call(self);
}

// aten::negative_(Tensor(a!) self) -> Tensor(a!)
TORCH_API inline at::Tensor & negative_(at::Tensor & self) {
    return at::_ops::negative_::call(self);
}

// aten::negative.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & negative_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::negative_out::call(self, out);
}

// aten::negative.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & negative_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::negative_out::call(self, out);
}

// aten::repeat_interleave.Tensor(Tensor repeats, *, int? output_size=None) -> Tensor
TORCH_API inline at::Tensor repeat_interleave(const at::Tensor & repeats, c10::optional<int64_t> output_size=c10::nullopt) {
    return at::_ops::repeat_interleave_Tensor::call(repeats, output_size);
}

// aten::repeat_interleave.self_Tensor(Tensor self, Tensor repeats, int? dim=None, *, int? output_size=None) -> Tensor
TORCH_API inline at::Tensor repeat_interleave(const at::Tensor & self, const at::Tensor & repeats, c10::optional<int64_t> dim=c10::nullopt, c10::optional<int64_t> output_size=c10::nullopt) {
    return at::_ops::repeat_interleave_self_Tensor::call(self, repeats, dim, output_size);
}

// aten::repeat_interleave.self_int(Tensor self, int repeats, int? dim=None, *, int? output_size=None) -> Tensor
TORCH_API inline at::Tensor repeat_interleave(const at::Tensor & self, int64_t repeats, c10::optional<int64_t> dim=c10::nullopt, c10::optional<int64_t> output_size=c10::nullopt) {
    return at::_ops::repeat_interleave_self_int::call(self, repeats, dim, output_size);
}

// aten::reshape(Tensor(a) self, int[] shape) -> Tensor(a)
TORCH_API inline at::Tensor reshape(const at::Tensor & self, at::IntArrayRef shape) {
    return at::_ops::reshape::call(self, shape);
}

// aten::_reshape_alias(Tensor(a) self, int[] size, int[] stride) -> Tensor(a)
TORCH_API inline at::Tensor _reshape_alias(const at::Tensor & self, at::IntArrayRef size, at::IntArrayRef stride) {
    return at::_ops::_reshape_alias::call(self, size, stride);
}

// aten::_mkldnn_reshape(Tensor self, int[] shape) -> Tensor
TORCH_API inline at::Tensor _mkldnn_reshape(const at::Tensor & self, at::IntArrayRef shape) {
    return at::_ops::_mkldnn_reshape::call(self, shape);
}

// aten::round(Tensor self) -> Tensor
TORCH_API inline at::Tensor round(const at::Tensor & self) {
    return at::_ops::round::call(self);
}

// aten::round_(Tensor(a!) self) -> Tensor(a!)
TORCH_API inline at::Tensor & round_(at::Tensor & self) {
    return at::_ops::round_::call(self);
}

// aten::round.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & round_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::round_out::call(self, out);
}

// aten::round.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & round_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::round_out::call(self, out);
}

// aten::rrelu(Tensor self, Scalar lower=0.125, Scalar upper=0.3333333333333333, bool training=False, Generator? generator=None) -> Tensor
TORCH_API inline at::Tensor rrelu(const at::Tensor & self, const at::Scalar & lower=0.125, const at::Scalar & upper=0.3333333333333333, bool training=false, c10::optional<at::Generator> generator=c10::nullopt) {
    return at::_ops::rrelu::call(self, lower, upper, training, generator);
}

// aten::rrelu_(Tensor(a!) self, Scalar lower=0.125, Scalar upper=0.3333333333333333, bool training=False, Generator? generator=None) -> Tensor(a!)
TORCH_API inline at::Tensor & rrelu_(at::Tensor & self, const at::Scalar & lower=0.125, const at::Scalar & upper=0.3333333333333333, bool training=false, c10::optional<at::Generator> generator=c10::nullopt) {
    return at::_ops::rrelu_::call(self, lower, upper, training, generator);
}

// aten::relu(Tensor self) -> Tensor
TORCH_API inline at::Tensor relu(const at::Tensor & self) {
    return at::_ops::relu::call(self);
}

// aten::relu_(Tensor(a!) self) -> Tensor(a!)
TORCH_API inline at::Tensor & relu_(at::Tensor & self) {
    return at::_ops::relu_::call(self);
}

// aten::relu6(Tensor self) -> Tensor
TORCH_API inline at::Tensor relu6(const at::Tensor & self) {
    return at::_ops::relu6::call(self);
}

// aten::relu6_(Tensor(a!) self) -> Tensor(a!)
TORCH_API inline at::Tensor & relu6_(at::Tensor & self) {
    return at::_ops::relu6_::call(self);
}

// aten::prelu(Tensor self, Tensor weight) -> Tensor
TORCH_API inline at::Tensor prelu(const at::Tensor & self, const at::Tensor & weight) {
    return at::_ops::prelu::call(self, weight);
}

// aten::prelu_backward(Tensor grad_output, Tensor self, Tensor weight) -> (Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> prelu_backward(const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & weight) {
    return at::_ops::prelu_backward::call(grad_output, self, weight);
}

// aten::gelu.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & gelu_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::gelu_out::call(self, out);
}

// aten::gelu.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & gelu_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::gelu_out::call(self, out);
}

// aten::gelu(Tensor self) -> Tensor
TORCH_API inline at::Tensor gelu(const at::Tensor & self) {
    return at::_ops::gelu::call(self);
}

// aten::gelu_backward.grad_input(Tensor grad, Tensor self, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & gelu_backward_out(at::Tensor & grad_input, const at::Tensor & grad, const at::Tensor & self) {
    return at::_ops::gelu_backward_grad_input::call(grad, self, grad_input);
}

// aten::gelu_backward.grad_input(Tensor grad, Tensor self, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & gelu_backward_outf(const at::Tensor & grad, const at::Tensor & self, at::Tensor & grad_input) {
    return at::_ops::gelu_backward_grad_input::call(grad, self, grad_input);
}

// aten::gelu_backward(Tensor grad, Tensor self) -> Tensor
TORCH_API inline at::Tensor gelu_backward(const at::Tensor & grad, const at::Tensor & self) {
    return at::_ops::gelu_backward::call(grad, self);
}

// aten::infinitely_differentiable_gelu_backward(Tensor grad, Tensor self) -> Tensor
TORCH_API inline at::Tensor infinitely_differentiable_gelu_backward(const at::Tensor & grad, const at::Tensor & self) {
    return at::_ops::infinitely_differentiable_gelu_backward::call(grad, self);
}

// aten::hardshrink.out(Tensor self, Scalar lambd=0.5, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & hardshrink_out(at::Tensor & out, const at::Tensor & self, const at::Scalar & lambd=0.5) {
    return at::_ops::hardshrink_out::call(self, lambd, out);
}

// aten::hardshrink.out(Tensor self, Scalar lambd=0.5, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & hardshrink_outf(const at::Tensor & self, const at::Scalar & lambd, at::Tensor & out) {
    return at::_ops::hardshrink_out::call(self, lambd, out);
}

// aten::hardshrink(Tensor self, Scalar lambd=0.5) -> Tensor
TORCH_API inline at::Tensor hardshrink(const at::Tensor & self, const at::Scalar & lambd=0.5) {
    return at::_ops::hardshrink::call(self, lambd);
}

// aten::hardshrink_backward.grad_input(Tensor grad_out, Tensor self, Scalar lambd, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & hardshrink_backward_out(at::Tensor & grad_input, const at::Tensor & grad_out, const at::Tensor & self, const at::Scalar & lambd) {
    return at::_ops::hardshrink_backward_grad_input::call(grad_out, self, lambd, grad_input);
}

// aten::hardshrink_backward.grad_input(Tensor grad_out, Tensor self, Scalar lambd, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & hardshrink_backward_outf(const at::Tensor & grad_out, const at::Tensor & self, const at::Scalar & lambd, at::Tensor & grad_input) {
    return at::_ops::hardshrink_backward_grad_input::call(grad_out, self, lambd, grad_input);
}

// aten::hardshrink_backward(Tensor grad_out, Tensor self, Scalar lambd) -> Tensor
TORCH_API inline at::Tensor hardshrink_backward(const at::Tensor & grad_out, const at::Tensor & self, const at::Scalar & lambd) {
    return at::_ops::hardshrink_backward::call(grad_out, self, lambd);
}

// aten::rsqrt(Tensor self) -> Tensor
TORCH_API inline at::Tensor rsqrt(const at::Tensor & self) {
    return at::_ops::rsqrt::call(self);
}

// aten::rsqrt_(Tensor(a!) self) -> Tensor(a!)
TORCH_API inline at::Tensor & rsqrt_(at::Tensor & self) {
    return at::_ops::rsqrt_::call(self);
}

// aten::rsqrt.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & rsqrt_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::rsqrt_out::call(self, out);
}

// aten::rsqrt.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & rsqrt_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::rsqrt_out::call(self, out);
}

// aten::select.Dimname(Tensor(a) self, Dimname dim, int index) -> Tensor(a)
TORCH_API inline at::Tensor select(const at::Tensor & self, at::Dimname dim, int64_t index) {
    return at::_ops::select_Dimname::call(self, dim, index);
}

// aten::select.int(Tensor(a) self, int dim, int index) -> Tensor(a)
TORCH_API inline at::Tensor select(const at::Tensor & self, int64_t dim, int64_t index) {
    return at::_ops::select_int::call(self, dim, index);
}

// aten::select_backward(Tensor grad_output, int[] input_sizes, int dim, int index) -> Tensor
TORCH_API inline at::Tensor select_backward(const at::Tensor & grad_output, at::IntArrayRef input_sizes, int64_t dim, int64_t index) {
    return at::_ops::select_backward::call(grad_output, input_sizes, dim, index);
}

// aten::selu(Tensor self) -> Tensor
TORCH_API inline at::Tensor selu(const at::Tensor & self) {
    return at::_ops::selu::call(self);
}

// aten::selu_(Tensor(a!) self) -> Tensor(a!)
TORCH_API inline at::Tensor & selu_(at::Tensor & self) {
    return at::_ops::selu_::call(self);
}

// aten::celu(Tensor self, Scalar alpha=1.0) -> Tensor
TORCH_API inline at::Tensor celu(const at::Tensor & self, const at::Scalar & alpha=1.0) {
    return at::_ops::celu::call(self, alpha);
}

// aten::celu_(Tensor(a!) self, Scalar alpha=1.0) -> Tensor(a!)
TORCH_API inline at::Tensor & celu_(at::Tensor & self, const at::Scalar & alpha=1.0) {
    return at::_ops::celu_::call(self, alpha);
}

// aten::silu(Tensor self) -> Tensor
TORCH_API inline at::Tensor silu(const at::Tensor & self) {
    return at::_ops::silu::call(self);
}

// aten::silu_(Tensor(a!) self) -> Tensor(a!)
TORCH_API inline at::Tensor & silu_(at::Tensor & self) {
    return at::_ops::silu_::call(self);
}

// aten::silu.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & silu_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::silu_out::call(self, out);
}

// aten::silu.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & silu_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::silu_out::call(self, out);
}

// aten::silu_backward.grad_input(Tensor grad_output, Tensor self, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & silu_backward_out(at::Tensor & grad_input, const at::Tensor & grad_output, const at::Tensor & self) {
    return at::_ops::silu_backward_grad_input::call(grad_output, self, grad_input);
}

// aten::silu_backward.grad_input(Tensor grad_output, Tensor self, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & silu_backward_outf(const at::Tensor & grad_output, const at::Tensor & self, at::Tensor & grad_input) {
    return at::_ops::silu_backward_grad_input::call(grad_output, self, grad_input);
}

// aten::silu_backward(Tensor grad_output, Tensor self) -> Tensor
TORCH_API inline at::Tensor silu_backward(const at::Tensor & grad_output, const at::Tensor & self) {
    return at::_ops::silu_backward::call(grad_output, self);
}

// aten::mish(Tensor self) -> Tensor
TORCH_API inline at::Tensor mish(const at::Tensor & self) {
    return at::_ops::mish::call(self);
}

// aten::mish_(Tensor(a!) self) -> Tensor(a!)
TORCH_API inline at::Tensor & mish_(at::Tensor & self) {
    return at::_ops::mish_::call(self);
}

// aten::mish.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & mish_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::mish_out::call(self, out);
}

// aten::mish.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & mish_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::mish_out::call(self, out);
}

// aten::mish_backward(Tensor grad_output, Tensor self) -> Tensor
TORCH_API inline at::Tensor mish_backward(const at::Tensor & grad_output, const at::Tensor & self) {
    return at::_ops::mish_backward::call(grad_output, self);
}

// aten::sigmoid(Tensor self) -> Tensor
TORCH_API inline at::Tensor sigmoid(const at::Tensor & self) {
    return at::_ops::sigmoid::call(self);
}

// aten::sigmoid_(Tensor(a!) self) -> Tensor(a!)
TORCH_API inline at::Tensor & sigmoid_(at::Tensor & self) {
    return at::_ops::sigmoid_::call(self);
}

// aten::sigmoid.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & sigmoid_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::sigmoid_out::call(self, out);
}

// aten::sigmoid.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & sigmoid_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::sigmoid_out::call(self, out);
}

// aten::logit(Tensor self, float? eps=None) -> Tensor
TORCH_API inline at::Tensor logit(const at::Tensor & self, c10::optional<double> eps=c10::nullopt) {
    return at::_ops::logit::call(self, eps);
}

// aten::logit_(Tensor(a!) self, float? eps=None) -> Tensor(a!)
TORCH_API inline at::Tensor & logit_(at::Tensor & self, c10::optional<double> eps=c10::nullopt) {
    return at::_ops::logit_::call(self, eps);
}

// aten::logit.out(Tensor self, float? eps=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & logit_out(at::Tensor & out, const at::Tensor & self, c10::optional<double> eps=c10::nullopt) {
    return at::_ops::logit_out::call(self, eps, out);
}

// aten::logit.out(Tensor self, float? eps=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & logit_outf(const at::Tensor & self, c10::optional<double> eps, at::Tensor & out) {
    return at::_ops::logit_out::call(self, eps, out);
}

// aten::sin(Tensor self) -> Tensor
TORCH_API inline at::Tensor sin(const at::Tensor & self) {
    return at::_ops::sin::call(self);
}

// aten::sin_(Tensor(a!) self) -> Tensor(a!)
TORCH_API inline at::Tensor & sin_(at::Tensor & self) {
    return at::_ops::sin_::call(self);
}

// aten::sin.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & sin_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::sin_out::call(self, out);
}

// aten::sin.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & sin_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::sin_out::call(self, out);
}

// aten::sinc(Tensor self) -> Tensor
TORCH_API inline at::Tensor sinc(const at::Tensor & self) {
    return at::_ops::sinc::call(self);
}

// aten::sinc_(Tensor(a!) self) -> Tensor(a!)
TORCH_API inline at::Tensor & sinc_(at::Tensor & self) {
    return at::_ops::sinc_::call(self);
}

// aten::sinc.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & sinc_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::sinc_out::call(self, out);
}

// aten::sinc.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & sinc_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::sinc_out::call(self, out);
}

// aten::sinh(Tensor self) -> Tensor
TORCH_API inline at::Tensor sinh(const at::Tensor & self) {
    return at::_ops::sinh::call(self);
}

// aten::sinh_(Tensor(a!) self) -> Tensor(a!)
TORCH_API inline at::Tensor & sinh_(at::Tensor & self) {
    return at::_ops::sinh_::call(self);
}

// aten::sinh.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & sinh_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::sinh_out::call(self, out);
}

// aten::sinh.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & sinh_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::sinh_out::call(self, out);
}

// aten::detach(Tensor(a) self) -> Tensor(a)
TORCH_API inline at::Tensor detach(const at::Tensor & self) {
    return at::_ops::detach::call(self);
}

// aten::detach_(Tensor(a!) self) -> Tensor(a!)
TORCH_API inline at::Tensor & detach_(at::Tensor & self) {
    return at::_ops::detach_::call(self);
}

// aten::size.int(Tensor self, int dim) -> int
TORCH_API inline int64_t __dispatch_size(const at::Tensor & self, int64_t dim) {
    return at::_ops::size_int::call(self, dim);
}

// aten::size.Dimname(Tensor self, Dimname dim) -> int
TORCH_API inline int64_t size(const at::Tensor & self, at::Dimname dim) {
    return at::_ops::size_Dimname::call(self, dim);
}

// aten::slice.Tensor(Tensor(a) self, int dim=0, int? start=None, int? end=None, int step=1) -> Tensor(a)
TORCH_API inline at::Tensor slice(const at::Tensor & self, int64_t dim=0, c10::optional<int64_t> start=c10::nullopt, c10::optional<int64_t> end=c10::nullopt, int64_t step=1) {
    return at::_ops::slice_Tensor::call(self, dim, start, end, step);
}

// aten::slice_backward(Tensor grad_output, int[] input_sizes, int dim, int start, int end, int step) -> Tensor
TORCH_API inline at::Tensor slice_backward(const at::Tensor & grad_output, at::IntArrayRef input_sizes, int64_t dim, int64_t start, int64_t end, int64_t step) {
    return at::_ops::slice_backward::call(grad_output, input_sizes, dim, start, end, step);
}

// aten::slogdet(Tensor self) -> (Tensor sign, Tensor logabsdet)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> slogdet(const at::Tensor & self) {
    return at::_ops::slogdet::call(self);
}

// aten::smm(Tensor self, Tensor mat2) -> Tensor
TORCH_API inline at::Tensor smm(const at::Tensor & self, const at::Tensor & mat2) {
    return at::_ops::smm::call(self, mat2);
}

// aten::softmax.int(Tensor self, int dim, ScalarType? dtype=None) -> Tensor
TORCH_API inline at::Tensor softmax(const at::Tensor & self, int64_t dim, c10::optional<at::ScalarType> dtype=c10::nullopt) {
    return at::_ops::softmax_int::call(self, dim, dtype);
}

// aten::softmax.Dimname(Tensor self, Dimname dim, *, ScalarType? dtype=None) -> Tensor
TORCH_API inline at::Tensor softmax(const at::Tensor & self, at::Dimname dim, c10::optional<at::ScalarType> dtype=c10::nullopt) {
    return at::_ops::softmax_Dimname::call(self, dim, dtype);
}

// aten::_softmax(Tensor self, int dim, bool half_to_float) -> Tensor
TORCH_API inline at::Tensor _softmax(const at::Tensor & self, int64_t dim, bool half_to_float) {
    return at::_ops::_softmax::call(self, dim, half_to_float);
}

// aten::_softmax.out(Tensor self, int dim, bool half_to_float, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & _softmax_out(at::Tensor & out, const at::Tensor & self, int64_t dim, bool half_to_float) {
    return at::_ops::_softmax_out::call(self, dim, half_to_float, out);
}

// aten::_softmax.out(Tensor self, int dim, bool half_to_float, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & _softmax_outf(const at::Tensor & self, int64_t dim, bool half_to_float, at::Tensor & out) {
    return at::_ops::_softmax_out::call(self, dim, half_to_float, out);
}

// aten::_softmax_backward_data(Tensor grad_output, Tensor output, int dim, Tensor self) -> Tensor
TORCH_API inline at::Tensor _softmax_backward_data(const at::Tensor & grad_output, const at::Tensor & output, int64_t dim, const at::Tensor & self) {
    return at::_ops::_softmax_backward_data::call(grad_output, output, dim, self);
}

// aten::_softmax_backward_data.out(Tensor grad_output, Tensor output, int dim, Tensor self, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & _softmax_backward_data_out(at::Tensor & grad_input, const at::Tensor & grad_output, const at::Tensor & output, int64_t dim, const at::Tensor & self) {
    return at::_ops::_softmax_backward_data_out::call(grad_output, output, dim, self, grad_input);
}

// aten::_softmax_backward_data.out(Tensor grad_output, Tensor output, int dim, Tensor self, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & _softmax_backward_data_outf(const at::Tensor & grad_output, const at::Tensor & output, int64_t dim, const at::Tensor & self, at::Tensor & grad_input) {
    return at::_ops::_softmax_backward_data_out::call(grad_output, output, dim, self, grad_input);
}

// aten::unsafe_split.Tensor(Tensor self, int split_size, int dim=0) -> Tensor[]
TORCH_API inline ::std::vector<at::Tensor> unsafe_split(const at::Tensor & self, int64_t split_size, int64_t dim=0) {
    return at::_ops::unsafe_split_Tensor::call(self, split_size, dim);
}

// aten::split.Tensor(Tensor(a) self, int split_size, int dim=0) -> Tensor(a)[]
TORCH_API inline ::std::vector<at::Tensor> split(const at::Tensor & self, int64_t split_size, int64_t dim=0) {
    return at::_ops::split_Tensor::call(self, split_size, dim);
}

// aten::unsafe_split_with_sizes(Tensor self, int[] split_sizes, int dim=0) -> Tensor[]
TORCH_API inline ::std::vector<at::Tensor> unsafe_split_with_sizes(const at::Tensor & self, at::IntArrayRef split_sizes, int64_t dim=0) {
    return at::_ops::unsafe_split_with_sizes::call(self, split_sizes, dim);
}

// aten::split_with_sizes(Tensor(a) self, int[] split_sizes, int dim=0) -> Tensor(a)[]
TORCH_API inline ::std::vector<at::Tensor> split_with_sizes(const at::Tensor & self, at::IntArrayRef split_sizes, int64_t dim=0) {
    return at::_ops::split_with_sizes::call(self, split_sizes, dim);
}

// aten::hsplit.int(Tensor(a) self, int sections) -> Tensor(a)[]
TORCH_API inline ::std::vector<at::Tensor> hsplit(const at::Tensor & self, int64_t sections) {
    return at::_ops::hsplit_int::call(self, sections);
}

// aten::hsplit.array(Tensor(a) self, int[] indices) -> Tensor(a)[]
TORCH_API inline ::std::vector<at::Tensor> hsplit(const at::Tensor & self, at::IntArrayRef indices) {
    return at::_ops::hsplit_array::call(self, indices);
}

// aten::vsplit.int(Tensor(a) self, int sections) -> Tensor(a)[]
TORCH_API inline ::std::vector<at::Tensor> vsplit(const at::Tensor & self, int64_t sections) {
    return at::_ops::vsplit_int::call(self, sections);
}

// aten::vsplit.array(Tensor(a) self, int[] indices) -> Tensor(a)[]
TORCH_API inline ::std::vector<at::Tensor> vsplit(const at::Tensor & self, at::IntArrayRef indices) {
    return at::_ops::vsplit_array::call(self, indices);
}

// aten::dsplit.int(Tensor(a) self, int sections) -> Tensor(a)[]
TORCH_API inline ::std::vector<at::Tensor> dsplit(const at::Tensor & self, int64_t sections) {
    return at::_ops::dsplit_int::call(self, sections);
}

// aten::dsplit.array(Tensor(a) self, int[] indices) -> Tensor(a)[]
TORCH_API inline ::std::vector<at::Tensor> dsplit(const at::Tensor & self, at::IntArrayRef indices) {
    return at::_ops::dsplit_array::call(self, indices);
}

// aten::squeeze(Tensor(a) self) -> Tensor(a)
TORCH_API inline at::Tensor squeeze(const at::Tensor & self) {
    return at::_ops::squeeze::call(self);
}

// aten::squeeze.dim(Tensor(a) self, int dim) -> Tensor(a)
TORCH_API inline at::Tensor squeeze(const at::Tensor & self, int64_t dim) {
    return at::_ops::squeeze_dim::call(self, dim);
}

// aten::squeeze.dimname(Tensor(a) self, Dimname dim) -> Tensor(a)
TORCH_API inline at::Tensor squeeze(const at::Tensor & self, at::Dimname dim) {
    return at::_ops::squeeze_dimname::call(self, dim);
}

// aten::sspaddmm(Tensor self, Tensor mat1, Tensor mat2, *, Scalar beta=1, Scalar alpha=1) -> Tensor
TORCH_API inline at::Tensor sspaddmm(const at::Tensor & self, const at::Tensor & mat1, const at::Tensor & mat2, const at::Scalar & beta=1, const at::Scalar & alpha=1) {
    return at::_ops::sspaddmm::call(self, mat1, mat2, beta, alpha);
}

// aten::sspaddmm.out(Tensor self, Tensor mat1, Tensor mat2, *, Scalar beta=1, Scalar alpha=1, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & sspaddmm_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & mat1, const at::Tensor & mat2, const at::Scalar & beta=1, const at::Scalar & alpha=1) {
    return at::_ops::sspaddmm_out::call(self, mat1, mat2, beta, alpha, out);
}

// aten::sspaddmm.out(Tensor self, Tensor mat1, Tensor mat2, *, Scalar beta=1, Scalar alpha=1, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & sspaddmm_outf(const at::Tensor & self, const at::Tensor & mat1, const at::Tensor & mat2, const at::Scalar & beta, const at::Scalar & alpha, at::Tensor & out) {
    return at::_ops::sspaddmm_out::call(self, mat1, mat2, beta, alpha, out);
}

// aten::stack(Tensor[] tensors, int dim=0) -> Tensor
TORCH_API inline at::Tensor stack(at::TensorList tensors, int64_t dim=0) {
    return at::_ops::stack::call(tensors, dim);
}

// aten::stack.out(Tensor[] tensors, int dim=0, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & stack_out(at::Tensor & out, at::TensorList tensors, int64_t dim=0) {
    return at::_ops::stack_out::call(tensors, dim, out);
}

// aten::stack.out(Tensor[] tensors, int dim=0, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & stack_outf(at::TensorList tensors, int64_t dim, at::Tensor & out) {
    return at::_ops::stack_out::call(tensors, dim, out);
}

// aten::_stack(Tensor[] tensors, int dim=0) -> Tensor
TORCH_API inline at::Tensor _stack(at::TensorList tensors, int64_t dim=0) {
    return at::_ops::_stack::call(tensors, dim);
}

// aten::_stack.out(Tensor[] tensors, int dim=0, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & _stack_out(at::Tensor & out, at::TensorList tensors, int64_t dim=0) {
    return at::_ops::_stack_out::call(tensors, dim, out);
}

// aten::_stack.out(Tensor[] tensors, int dim=0, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & _stack_outf(at::TensorList tensors, int64_t dim, at::Tensor & out) {
    return at::_ops::_stack_out::call(tensors, dim, out);
}

// aten::hstack(Tensor[] tensors) -> Tensor
TORCH_API inline at::Tensor hstack(at::TensorList tensors) {
    return at::_ops::hstack::call(tensors);
}

// aten::hstack.out(Tensor[] tensors, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & hstack_out(at::Tensor & out, at::TensorList tensors) {
    return at::_ops::hstack_out::call(tensors, out);
}

// aten::hstack.out(Tensor[] tensors, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & hstack_outf(at::TensorList tensors, at::Tensor & out) {
    return at::_ops::hstack_out::call(tensors, out);
}

// aten::vstack(Tensor[] tensors) -> Tensor
TORCH_API inline at::Tensor vstack(at::TensorList tensors) {
    return at::_ops::vstack::call(tensors);
}

// aten::vstack.out(Tensor[] tensors, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & vstack_out(at::Tensor & out, at::TensorList tensors) {
    return at::_ops::vstack_out::call(tensors, out);
}

// aten::vstack.out(Tensor[] tensors, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & vstack_outf(at::TensorList tensors, at::Tensor & out) {
    return at::_ops::vstack_out::call(tensors, out);
}

// aten::dstack(Tensor[] tensors) -> Tensor
TORCH_API inline at::Tensor dstack(at::TensorList tensors) {
    return at::_ops::dstack::call(tensors);
}

// aten::dstack.out(Tensor[] tensors, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & dstack_out(at::Tensor & out, at::TensorList tensors) {
    return at::_ops::dstack_out::call(tensors, out);
}

// aten::dstack.out(Tensor[] tensors, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & dstack_outf(at::TensorList tensors, at::Tensor & out) {
    return at::_ops::dstack_out::call(tensors, out);
}

// aten::stft(Tensor self, int n_fft, int? hop_length=None, int? win_length=None, Tensor? window=None, bool normalized=False, bool? onesided=None, bool? return_complex=None) -> Tensor
TORCH_API inline at::Tensor stft(const at::Tensor & self, int64_t n_fft, c10::optional<int64_t> hop_length=c10::nullopt, c10::optional<int64_t> win_length=c10::nullopt, const c10::optional<at::Tensor> & window={}, bool normalized=false, c10::optional<bool> onesided=c10::nullopt, c10::optional<bool> return_complex=c10::nullopt) {
    return at::_ops::stft::call(self, n_fft, hop_length, win_length, window, normalized, onesided, return_complex);
}

// aten::istft(Tensor self, int n_fft, int? hop_length=None, int? win_length=None, Tensor? window=None, bool center=True, bool normalized=False, bool? onesided=None, int? length=None, bool return_complex=False) -> Tensor
TORCH_API inline at::Tensor istft(const at::Tensor & self, int64_t n_fft, c10::optional<int64_t> hop_length=c10::nullopt, c10::optional<int64_t> win_length=c10::nullopt, const c10::optional<at::Tensor> & window={}, bool center=true, bool normalized=false, c10::optional<bool> onesided=c10::nullopt, c10::optional<int64_t> length=c10::nullopt, bool return_complex=false) {
    return at::_ops::istft::call(self, n_fft, hop_length, win_length, window, center, normalized, onesided, length, return_complex);
}

// aten::stride.int(Tensor self, int dim) -> int
TORCH_API inline int64_t __dispatch_stride(const at::Tensor & self, int64_t dim) {
    return at::_ops::stride_int::call(self, dim);
}

// aten::stride.Dimname(Tensor self, Dimname dim) -> int
TORCH_API inline int64_t stride(const at::Tensor & self, at::Dimname dim) {
    return at::_ops::stride_Dimname::call(self, dim);
}

// aten::sum(Tensor self, *, ScalarType? dtype=None) -> Tensor
TORCH_API inline at::Tensor sum(const at::Tensor & self, c10::optional<at::ScalarType> dtype=c10::nullopt) {
    return at::_ops::sum::call(self, dtype);
}

// aten::sum.dim_IntList(Tensor self, int[1] dim, bool keepdim=False, *, ScalarType? dtype=None) -> Tensor
TORCH_API inline at::Tensor sum(const at::Tensor & self, at::IntArrayRef dim, bool keepdim=false, c10::optional<at::ScalarType> dtype=c10::nullopt) {
    return at::_ops::sum_dim_IntList::call(self, dim, keepdim, dtype);
}

// aten::sum.dim_DimnameList(Tensor self, Dimname[1] dim, bool keepdim=False, *, ScalarType? dtype=None) -> Tensor
TORCH_API inline at::Tensor sum(const at::Tensor & self, at::DimnameList dim, bool keepdim=false, c10::optional<at::ScalarType> dtype=c10::nullopt) {
    return at::_ops::sum_dim_DimnameList::call(self, dim, keepdim, dtype);
}

// aten::sum.IntList_out(Tensor self, int[1] dim, bool keepdim=False, *, ScalarType? dtype=None, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & sum_out(at::Tensor & out, const at::Tensor & self, at::IntArrayRef dim, bool keepdim=false, c10::optional<at::ScalarType> dtype=c10::nullopt) {
    return at::_ops::sum_IntList_out::call(self, dim, keepdim, dtype, out);
}

// aten::sum.IntList_out(Tensor self, int[1] dim, bool keepdim=False, *, ScalarType? dtype=None, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & sum_outf(const at::Tensor & self, at::IntArrayRef dim, bool keepdim, c10::optional<at::ScalarType> dtype, at::Tensor & out) {
    return at::_ops::sum_IntList_out::call(self, dim, keepdim, dtype, out);
}

// aten::sum.DimnameList_out(Tensor self, Dimname[1] dim, bool keepdim=False, *, ScalarType? dtype=None, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & sum_out(at::Tensor & out, const at::Tensor & self, at::DimnameList dim, bool keepdim=false, c10::optional<at::ScalarType> dtype=c10::nullopt) {
    return at::_ops::sum_DimnameList_out::call(self, dim, keepdim, dtype, out);
}

// aten::sum.DimnameList_out(Tensor self, Dimname[1] dim, bool keepdim=False, *, ScalarType? dtype=None, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & sum_outf(const at::Tensor & self, at::DimnameList dim, bool keepdim, c10::optional<at::ScalarType> dtype, at::Tensor & out) {
    return at::_ops::sum_DimnameList_out::call(self, dim, keepdim, dtype, out);
}

// aten::nansum(Tensor self, *, ScalarType? dtype=None) -> Tensor
TORCH_API inline at::Tensor nansum(const at::Tensor & self, c10::optional<at::ScalarType> dtype=c10::nullopt) {
    return at::_ops::nansum::call(self, dtype);
}

// aten::nansum.dim_IntList(Tensor self, int[1] dim, bool keepdim=False, *, ScalarType? dtype=None) -> Tensor
TORCH_API inline at::Tensor nansum(const at::Tensor & self, at::IntArrayRef dim, bool keepdim=false, c10::optional<at::ScalarType> dtype=c10::nullopt) {
    return at::_ops::nansum_dim_IntList::call(self, dim, keepdim, dtype);
}

// aten::nansum.IntList_out(Tensor self, int[1] dim, bool keepdim=False, *, ScalarType? dtype=None, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & nansum_out(at::Tensor & out, const at::Tensor & self, at::IntArrayRef dim, bool keepdim=false, c10::optional<at::ScalarType> dtype=c10::nullopt) {
    return at::_ops::nansum_IntList_out::call(self, dim, keepdim, dtype, out);
}

// aten::nansum.IntList_out(Tensor self, int[1] dim, bool keepdim=False, *, ScalarType? dtype=None, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & nansum_outf(const at::Tensor & self, at::IntArrayRef dim, bool keepdim, c10::optional<at::ScalarType> dtype, at::Tensor & out) {
    return at::_ops::nansum_IntList_out::call(self, dim, keepdim, dtype, out);
}

// aten::sqrt(Tensor self) -> Tensor
TORCH_API inline at::Tensor sqrt(const at::Tensor & self) {
    return at::_ops::sqrt::call(self);
}

// aten::sqrt_(Tensor(a!) self) -> Tensor(a!)
TORCH_API inline at::Tensor & sqrt_(at::Tensor & self) {
    return at::_ops::sqrt_::call(self);
}

// aten::sqrt.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & sqrt_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::sqrt_out::call(self, out);
}

// aten::sqrt.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & sqrt_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::sqrt_out::call(self, out);
}

// aten::square(Tensor self) -> Tensor
TORCH_API inline at::Tensor square(const at::Tensor & self) {
    return at::_ops::square::call(self);
}

// aten::square_(Tensor(a!) self) -> Tensor(a!)
TORCH_API inline at::Tensor & square_(at::Tensor & self) {
    return at::_ops::square_::call(self);
}

// aten::square.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & square_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::square_out::call(self, out);
}

// aten::square.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & square_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::square_out::call(self, out);
}

// aten::std(Tensor self, bool unbiased=True) -> Tensor
TORCH_API inline at::Tensor std(const at::Tensor & self, bool unbiased=true) {
    return at::_ops::std::call(self, unbiased);
}

// aten::std.dim(Tensor self, int[1] dim, bool unbiased=True, bool keepdim=False) -> Tensor
TORCH_API inline at::Tensor std(const at::Tensor & self, at::IntArrayRef dim, bool unbiased=true, bool keepdim=false) {
    return at::_ops::std_dim::call(self, dim, unbiased, keepdim);
}

// aten::std.correction(Tensor self, int[1]? dim, *, int? correction, bool keepdim=False) -> Tensor
TORCH_API inline at::Tensor std(const at::Tensor & self, c10::optional<at::IntArrayRef> dim, c10::optional<int64_t> correction, bool keepdim=false) {
    return at::_ops::std_correction::call(self, dim, correction, keepdim);
}

// aten::std_mean(Tensor self, bool unbiased=True) -> (Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> std_mean(const at::Tensor & self, bool unbiased=true) {
    return at::_ops::std_mean::call(self, unbiased);
}

// aten::std_mean.dim(Tensor self, int[1] dim, bool unbiased=True, bool keepdim=False) -> (Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> std_mean(const at::Tensor & self, at::IntArrayRef dim, bool unbiased=true, bool keepdim=false) {
    return at::_ops::std_mean_dim::call(self, dim, unbiased, keepdim);
}

// aten::std_mean.correction(Tensor self, int[1]? dim, *, int? correction, bool keepdim=False) -> (Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> std_mean(const at::Tensor & self, c10::optional<at::IntArrayRef> dim, c10::optional<int64_t> correction, bool keepdim=false) {
    return at::_ops::std_mean_correction::call(self, dim, correction, keepdim);
}

// aten::std_mean.names_dim(Tensor self, Dimname[1] dim, bool unbiased=True, bool keepdim=False) -> (Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> std_mean(const at::Tensor & self, at::DimnameList dim, bool unbiased=true, bool keepdim=false) {
    return at::_ops::std_mean_names_dim::call(self, dim, unbiased, keepdim);
}

// aten::std_mean.correction_names(Tensor self, Dimname[1] dim, *, int? correction, bool keepdim=False) -> (Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> std_mean(const at::Tensor & self, at::DimnameList dim, c10::optional<int64_t> correction, bool keepdim=false) {
    return at::_ops::std_mean_correction_names::call(self, dim, correction, keepdim);
}

// aten::std.out(Tensor self, int[1] dim, bool unbiased=True, bool keepdim=False, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & std_out(at::Tensor & out, const at::Tensor & self, at::IntArrayRef dim, bool unbiased=true, bool keepdim=false) {
    return at::_ops::std_out::call(self, dim, unbiased, keepdim, out);
}

// aten::std.out(Tensor self, int[1] dim, bool unbiased=True, bool keepdim=False, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & std_outf(const at::Tensor & self, at::IntArrayRef dim, bool unbiased, bool keepdim, at::Tensor & out) {
    return at::_ops::std_out::call(self, dim, unbiased, keepdim, out);
}

// aten::std.correction_out(Tensor self, int[1]? dim, *, int? correction, bool keepdim=False, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & std_out(at::Tensor & out, const at::Tensor & self, c10::optional<at::IntArrayRef> dim, c10::optional<int64_t> correction, bool keepdim=false) {
    return at::_ops::std_correction_out::call(self, dim, correction, keepdim, out);
}

// aten::std.correction_out(Tensor self, int[1]? dim, *, int? correction, bool keepdim=False, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & std_outf(const at::Tensor & self, c10::optional<at::IntArrayRef> dim, c10::optional<int64_t> correction, bool keepdim, at::Tensor & out) {
    return at::_ops::std_correction_out::call(self, dim, correction, keepdim, out);
}

// aten::std.names_dim(Tensor self, Dimname[1] dim, bool unbiased=True, bool keepdim=False) -> Tensor
TORCH_API inline at::Tensor std(const at::Tensor & self, at::DimnameList dim, bool unbiased=true, bool keepdim=false) {
    return at::_ops::std_names_dim::call(self, dim, unbiased, keepdim);
}

// aten::std.names_out(Tensor self, Dimname[1] dim, bool unbiased=True, bool keepdim=False, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & std_out(at::Tensor & out, const at::Tensor & self, at::DimnameList dim, bool unbiased=true, bool keepdim=false) {
    return at::_ops::std_names_out::call(self, dim, unbiased, keepdim, out);
}

// aten::std.names_out(Tensor self, Dimname[1] dim, bool unbiased=True, bool keepdim=False, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & std_outf(const at::Tensor & self, at::DimnameList dim, bool unbiased, bool keepdim, at::Tensor & out) {
    return at::_ops::std_names_out::call(self, dim, unbiased, keepdim, out);
}

// aten::std.correction_names(Tensor self, Dimname[1] dim, *, int? correction, bool keepdim=False) -> Tensor
TORCH_API inline at::Tensor std(const at::Tensor & self, at::DimnameList dim, c10::optional<int64_t> correction, bool keepdim=false) {
    return at::_ops::std_correction_names::call(self, dim, correction, keepdim);
}

// aten::std.correction_names_out(Tensor self, Dimname[1] dim, *, int? correction, bool keepdim=False, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & std_out(at::Tensor & out, const at::Tensor & self, at::DimnameList dim, c10::optional<int64_t> correction, bool keepdim=false) {
    return at::_ops::std_correction_names_out::call(self, dim, correction, keepdim, out);
}

// aten::std.correction_names_out(Tensor self, Dimname[1] dim, *, int? correction, bool keepdim=False, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & std_outf(const at::Tensor & self, at::DimnameList dim, c10::optional<int64_t> correction, bool keepdim, at::Tensor & out) {
    return at::_ops::std_correction_names_out::call(self, dim, correction, keepdim, out);
}

// aten::prod(Tensor self, *, ScalarType? dtype=None) -> Tensor
TORCH_API inline at::Tensor prod(const at::Tensor & self, c10::optional<at::ScalarType> dtype=c10::nullopt) {
    return at::_ops::prod::call(self, dtype);
}

// aten::prod.dim_int(Tensor self, int dim, bool keepdim=False, *, ScalarType? dtype=None) -> Tensor
TORCH_API inline at::Tensor prod(const at::Tensor & self, int64_t dim, bool keepdim=false, c10::optional<at::ScalarType> dtype=c10::nullopt) {
    return at::_ops::prod_dim_int::call(self, dim, keepdim, dtype);
}

// aten::prod.int_out(Tensor self, int dim, bool keepdim=False, *, ScalarType? dtype=None, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & prod_out(at::Tensor & out, const at::Tensor & self, int64_t dim, bool keepdim=false, c10::optional<at::ScalarType> dtype=c10::nullopt) {
    return at::_ops::prod_int_out::call(self, dim, keepdim, dtype, out);
}

// aten::prod.int_out(Tensor self, int dim, bool keepdim=False, *, ScalarType? dtype=None, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & prod_outf(const at::Tensor & self, int64_t dim, bool keepdim, c10::optional<at::ScalarType> dtype, at::Tensor & out) {
    return at::_ops::prod_int_out::call(self, dim, keepdim, dtype, out);
}

// aten::prod.dim_Dimname(Tensor self, Dimname dim, bool keepdim=False, *, ScalarType? dtype=None) -> Tensor
TORCH_API inline at::Tensor prod(const at::Tensor & self, at::Dimname dim, bool keepdim=false, c10::optional<at::ScalarType> dtype=c10::nullopt) {
    return at::_ops::prod_dim_Dimname::call(self, dim, keepdim, dtype);
}

// aten::prod.Dimname_out(Tensor self, Dimname dim, bool keepdim=False, *, ScalarType? dtype=None, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & prod_out(at::Tensor & out, const at::Tensor & self, at::Dimname dim, bool keepdim=false, c10::optional<at::ScalarType> dtype=c10::nullopt) {
    return at::_ops::prod_Dimname_out::call(self, dim, keepdim, dtype, out);
}

// aten::prod.Dimname_out(Tensor self, Dimname dim, bool keepdim=False, *, ScalarType? dtype=None, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & prod_outf(const at::Tensor & self, at::Dimname dim, bool keepdim, c10::optional<at::ScalarType> dtype, at::Tensor & out) {
    return at::_ops::prod_Dimname_out::call(self, dim, keepdim, dtype, out);
}

// aten::t(Tensor(a) self) -> Tensor(a)
TORCH_API inline at::Tensor t(const at::Tensor & self) {
    return at::_ops::t::call(self);
}

// aten::tan(Tensor self) -> Tensor
TORCH_API inline at::Tensor tan(const at::Tensor & self) {
    return at::_ops::tan::call(self);
}

// aten::tan_(Tensor(a!) self) -> Tensor(a!)
TORCH_API inline at::Tensor & tan_(at::Tensor & self) {
    return at::_ops::tan_::call(self);
}

// aten::tan.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & tan_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::tan_out::call(self, out);
}

// aten::tan.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & tan_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::tan_out::call(self, out);
}

// aten::tanh(Tensor self) -> Tensor
TORCH_API inline at::Tensor tanh(const at::Tensor & self) {
    return at::_ops::tanh::call(self);
}

// aten::tanh_(Tensor(a!) self) -> Tensor(a!)
TORCH_API inline at::Tensor & tanh_(at::Tensor & self) {
    return at::_ops::tanh_::call(self);
}

// aten::tanh.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & tanh_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::tanh_out::call(self, out);
}

// aten::tanh.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & tanh_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::tanh_out::call(self, out);
}

// aten::tensordot(Tensor self, Tensor other, int[] dims_self, int[] dims_other) -> Tensor
TORCH_API inline at::Tensor tensordot(const at::Tensor & self, const at::Tensor & other, at::IntArrayRef dims_self, at::IntArrayRef dims_other) {
    return at::_ops::tensordot::call(self, other, dims_self, dims_other);
}

// aten::tensordot.out(Tensor self, Tensor other, int[] dims_self, int[] dims_other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & tensordot_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & other, at::IntArrayRef dims_self, at::IntArrayRef dims_other) {
    return at::_ops::tensordot_out::call(self, other, dims_self, dims_other, out);
}

// aten::tensordot.out(Tensor self, Tensor other, int[] dims_self, int[] dims_other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & tensordot_outf(const at::Tensor & self, const at::Tensor & other, at::IntArrayRef dims_self, at::IntArrayRef dims_other, at::Tensor & out) {
    return at::_ops::tensordot_out::call(self, other, dims_self, dims_other, out);
}

// aten::threshold(Tensor self, Scalar threshold, Scalar value) -> Tensor
TORCH_API inline at::Tensor threshold(const at::Tensor & self, const at::Scalar & threshold, const at::Scalar & value) {
    return at::_ops::threshold::call(self, threshold, value);
}

// aten::threshold_(Tensor(a!) self, Scalar threshold, Scalar value) -> Tensor(a!)
TORCH_API inline at::Tensor & threshold_(at::Tensor & self, const at::Scalar & threshold, const at::Scalar & value) {
    return at::_ops::threshold_::call(self, threshold, value);
}

// aten::threshold.out(Tensor self, Scalar threshold, Scalar value, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & threshold_out(at::Tensor & out, const at::Tensor & self, const at::Scalar & threshold, const at::Scalar & value) {
    return at::_ops::threshold_out::call(self, threshold, value, out);
}

// aten::threshold.out(Tensor self, Scalar threshold, Scalar value, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & threshold_outf(const at::Tensor & self, const at::Scalar & threshold, const at::Scalar & value, at::Tensor & out) {
    return at::_ops::threshold_out::call(self, threshold, value, out);
}

// aten::threshold_backward.grad_input(Tensor grad_output, Tensor self, Scalar threshold, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & threshold_backward_out(at::Tensor & grad_input, const at::Tensor & grad_output, const at::Tensor & self, const at::Scalar & threshold) {
    return at::_ops::threshold_backward_grad_input::call(grad_output, self, threshold, grad_input);
}

// aten::threshold_backward.grad_input(Tensor grad_output, Tensor self, Scalar threshold, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & threshold_backward_outf(const at::Tensor & grad_output, const at::Tensor & self, const at::Scalar & threshold, at::Tensor & grad_input) {
    return at::_ops::threshold_backward_grad_input::call(grad_output, self, threshold, grad_input);
}

// aten::threshold_backward(Tensor grad_output, Tensor self, Scalar threshold) -> Tensor
TORCH_API inline at::Tensor threshold_backward(const at::Tensor & grad_output, const at::Tensor & self, const at::Scalar & threshold) {
    return at::_ops::threshold_backward::call(grad_output, self, threshold);
}

// aten::tile(Tensor self, int[] dims) -> Tensor
TORCH_API inline at::Tensor tile(const at::Tensor & self, at::IntArrayRef dims) {
    return at::_ops::tile::call(self, dims);
}

// aten::transpose.int(Tensor(a) self, int dim0, int dim1) -> Tensor(a)
TORCH_API inline at::Tensor transpose(const at::Tensor & self, int64_t dim0, int64_t dim1) {
    return at::_ops::transpose_int::call(self, dim0, dim1);
}

// aten::transpose.Dimname(Tensor(a) self, Dimname dim0, Dimname dim1) -> Tensor(a)
TORCH_API inline at::Tensor transpose(const at::Tensor & self, at::Dimname dim0, at::Dimname dim1) {
    return at::_ops::transpose_Dimname::call(self, dim0, dim1);
}

// aten::_mkldnn_transpose(Tensor self, int dim0, int dim1) -> Tensor
TORCH_API inline at::Tensor _mkldnn_transpose(const at::Tensor & self, int64_t dim0, int64_t dim1) {
    return at::_ops::_mkldnn_transpose::call(self, dim0, dim1);
}

// aten::_mkldnn_transpose_(Tensor(a!) self, int dim0, int dim1) -> Tensor(a!)
TORCH_API inline at::Tensor & _mkldnn_transpose_(at::Tensor & self, int64_t dim0, int64_t dim1) {
    return at::_ops::_mkldnn_transpose_::call(self, dim0, dim1);
}

// aten::one_hot(Tensor self, int num_classes=-1) -> Tensor
TORCH_API inline at::Tensor one_hot(const at::Tensor & self, int64_t num_classes=-1) {
    return at::_ops::one_hot::call(self, num_classes);
}

// aten::flip(Tensor self, int[] dims) -> Tensor
TORCH_API inline at::Tensor flip(const at::Tensor & self, at::IntArrayRef dims) {
    return at::_ops::flip::call(self, dims);
}

// aten::fliplr(Tensor self) -> Tensor
TORCH_API inline at::Tensor fliplr(const at::Tensor & self) {
    return at::_ops::fliplr::call(self);
}

// aten::flipud(Tensor self) -> Tensor
TORCH_API inline at::Tensor flipud(const at::Tensor & self) {
    return at::_ops::flipud::call(self);
}

// aten::roll(Tensor self, int[1] shifts, int[1] dims=[]) -> Tensor
TORCH_API inline at::Tensor roll(const at::Tensor & self, at::IntArrayRef shifts, at::IntArrayRef dims={}) {
    return at::_ops::roll::call(self, shifts, dims);
}

// aten::rot90(Tensor self, int k=1, int[] dims=[0,1]) -> Tensor
TORCH_API inline at::Tensor rot90(const at::Tensor & self, int64_t k=1, at::IntArrayRef dims={0,1}) {
    return at::_ops::rot90::call(self, k, dims);
}

// aten::trapezoid.x(Tensor y, Tensor x, *, int dim=-1) -> Tensor
TORCH_API inline at::Tensor trapezoid(const at::Tensor & y, const at::Tensor & x, int64_t dim=-1) {
    return at::_ops::trapezoid_x::call(y, x, dim);
}

// aten::trapezoid.dx(Tensor y, *, Scalar dx=1, int dim=-1) -> Tensor
TORCH_API inline at::Tensor trapezoid(const at::Tensor & y, const at::Scalar & dx=1, int64_t dim=-1) {
    return at::_ops::trapezoid_dx::call(y, dx, dim);
}

// aten::trapz.x(Tensor y, Tensor x, *, int dim=-1) -> Tensor
TORCH_API inline at::Tensor trapz(const at::Tensor & y, const at::Tensor & x, int64_t dim=-1) {
    return at::_ops::trapz_x::call(y, x, dim);
}

// aten::trapz.dx(Tensor y, *, float dx=1, int dim=-1) -> Tensor
TORCH_API inline at::Tensor trapz(const at::Tensor & y, double dx=1, int64_t dim=-1) {
    return at::_ops::trapz_dx::call(y, dx, dim);
}

// aten::_trilinear(Tensor i1, Tensor i2, Tensor i3, int[] expand1, int[] expand2, int[] expand3, int[] sumdim, int unroll_dim=1) -> Tensor
TORCH_API inline at::Tensor _trilinear(const at::Tensor & i1, const at::Tensor & i2, const at::Tensor & i3, at::IntArrayRef expand1, at::IntArrayRef expand2, at::IntArrayRef expand3, at::IntArrayRef sumdim, int64_t unroll_dim=1) {
    return at::_ops::_trilinear::call(i1, i2, i3, expand1, expand2, expand3, sumdim, unroll_dim);
}

// aten::triplet_margin_loss(Tensor anchor, Tensor positive, Tensor negative, float margin=1.0, float p=2, float eps=1e-06, bool swap=False, int reduction=Mean) -> Tensor
TORCH_API inline at::Tensor triplet_margin_loss(const at::Tensor & anchor, const at::Tensor & positive, const at::Tensor & negative, double margin=1.0, double p=2, double eps=1e-06, bool swap=false, int64_t reduction=at::Reduction::Mean) {
    return at::_ops::triplet_margin_loss::call(anchor, positive, negative, margin, p, eps, swap, reduction);
}

// aten::trunc(Tensor self) -> Tensor
TORCH_API inline at::Tensor trunc(const at::Tensor & self) {
    return at::_ops::trunc::call(self);
}

// aten::trunc_(Tensor(a!) self) -> Tensor(a!)
TORCH_API inline at::Tensor & trunc_(at::Tensor & self) {
    return at::_ops::trunc_::call(self);
}

// aten::trunc.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & trunc_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::trunc_out::call(self, out);
}

// aten::trunc.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & trunc_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::trunc_out::call(self, out);
}

// aten::fix(Tensor self) -> Tensor
TORCH_API inline at::Tensor fix(const at::Tensor & self) {
    return at::_ops::fix::call(self);
}

// aten::fix_(Tensor(a!) self) -> Tensor(a!)
TORCH_API inline at::Tensor & fix_(at::Tensor & self) {
    return at::_ops::fix_::call(self);
}

// aten::fix.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & fix_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::fix_out::call(self, out);
}

// aten::fix.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & fix_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::fix_out::call(self, out);
}

// aten::_has_compatible_shallow_copy_type(Tensor self, Tensor from) -> bool
TORCH_API inline bool _has_compatible_shallow_copy_type(const at::Tensor & self, const at::Tensor & from) {
    return at::_ops::_has_compatible_shallow_copy_type::call(self, from);
}

// aten::_unique(Tensor self, bool sorted=True, bool return_inverse=False) -> (Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> _unique(const at::Tensor & self, bool sorted=true, bool return_inverse=false) {
    return at::_ops::_unique::call(self, sorted, return_inverse);
}

// aten::unique_dim(Tensor self, int dim, bool sorted=True, bool return_inverse=False, bool return_counts=False) -> (Tensor, Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor,at::Tensor> unique_dim(const at::Tensor & self, int64_t dim, bool sorted=true, bool return_inverse=false, bool return_counts=false) {
    return at::_ops::unique_dim::call(self, dim, sorted, return_inverse, return_counts);
}

// aten::unique_consecutive(Tensor self, bool return_inverse=False, bool return_counts=False, int? dim=None) -> (Tensor, Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor,at::Tensor> unique_consecutive(const at::Tensor & self, bool return_inverse=false, bool return_counts=false, c10::optional<int64_t> dim=c10::nullopt) {
    return at::_ops::unique_consecutive::call(self, return_inverse, return_counts, dim);
}

// aten::unique_dim_consecutive(Tensor self, int dim, bool return_inverse=False, bool return_counts=False) -> (Tensor, Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor,at::Tensor> unique_dim_consecutive(const at::Tensor & self, int64_t dim, bool return_inverse=false, bool return_counts=false) {
    return at::_ops::unique_dim_consecutive::call(self, dim, return_inverse, return_counts);
}

// aten::_unique2(Tensor self, bool sorted=True, bool return_inverse=False, bool return_counts=False) -> (Tensor, Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor,at::Tensor> _unique2(const at::Tensor & self, bool sorted=true, bool return_inverse=false, bool return_counts=false) {
    return at::_ops::_unique2::call(self, sorted, return_inverse, return_counts);
}

// aten::_unsafe_view(Tensor self, int[] size) -> Tensor
TORCH_API inline at::Tensor _unsafe_view(const at::Tensor & self, at::IntArrayRef size) {
    return at::_ops::_unsafe_view::call(self, size);
}

// aten::unsqueeze(Tensor(a) self, int dim) -> Tensor(a)
TORCH_API inline at::Tensor unsqueeze(const at::Tensor & self, int64_t dim) {
    return at::_ops::unsqueeze::call(self, dim);
}

// aten::vander(Tensor x, int? N=None, bool increasing=False) -> Tensor
TORCH_API inline at::Tensor vander(const at::Tensor & x, c10::optional<int64_t> N=c10::nullopt, bool increasing=false) {
    return at::_ops::vander::call(x, N, increasing);
}

// aten::var(Tensor self, bool unbiased=True) -> Tensor
TORCH_API inline at::Tensor var(const at::Tensor & self, bool unbiased=true) {
    return at::_ops::var::call(self, unbiased);
}

// aten::var.dim(Tensor self, int[1] dim, bool unbiased=True, bool keepdim=False) -> Tensor
TORCH_API inline at::Tensor var(const at::Tensor & self, at::IntArrayRef dim, bool unbiased=true, bool keepdim=false) {
    return at::_ops::var_dim::call(self, dim, unbiased, keepdim);
}

// aten::var.correction(Tensor self, int[1]? dim, *, int? correction, bool keepdim=False) -> Tensor
TORCH_API inline at::Tensor var(const at::Tensor & self, c10::optional<at::IntArrayRef> dim, c10::optional<int64_t> correction, bool keepdim=false) {
    return at::_ops::var_correction::call(self, dim, correction, keepdim);
}

// aten::var.out(Tensor self, int[1] dim, bool unbiased=True, bool keepdim=False, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & var_out(at::Tensor & out, const at::Tensor & self, at::IntArrayRef dim, bool unbiased=true, bool keepdim=false) {
    return at::_ops::var_out::call(self, dim, unbiased, keepdim, out);
}

// aten::var.out(Tensor self, int[1] dim, bool unbiased=True, bool keepdim=False, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & var_outf(const at::Tensor & self, at::IntArrayRef dim, bool unbiased, bool keepdim, at::Tensor & out) {
    return at::_ops::var_out::call(self, dim, unbiased, keepdim, out);
}

// aten::var.correction_out(Tensor self, int[1]? dim, *, int? correction, bool keepdim=False, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & var_out(at::Tensor & out, const at::Tensor & self, c10::optional<at::IntArrayRef> dim, c10::optional<int64_t> correction, bool keepdim=false) {
    return at::_ops::var_correction_out::call(self, dim, correction, keepdim, out);
}

// aten::var.correction_out(Tensor self, int[1]? dim, *, int? correction, bool keepdim=False, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & var_outf(const at::Tensor & self, c10::optional<at::IntArrayRef> dim, c10::optional<int64_t> correction, bool keepdim, at::Tensor & out) {
    return at::_ops::var_correction_out::call(self, dim, correction, keepdim, out);
}

// aten::var.names_dim(Tensor self, Dimname[1] dim, bool unbiased=True, bool keepdim=False) -> Tensor
TORCH_API inline at::Tensor var(const at::Tensor & self, at::DimnameList dim, bool unbiased=true, bool keepdim=false) {
    return at::_ops::var_names_dim::call(self, dim, unbiased, keepdim);
}

// aten::var.names_out(Tensor self, Dimname[1] dim, bool unbiased=True, bool keepdim=False, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & var_out(at::Tensor & out, const at::Tensor & self, at::DimnameList dim, bool unbiased=true, bool keepdim=false) {
    return at::_ops::var_names_out::call(self, dim, unbiased, keepdim, out);
}

// aten::var.names_out(Tensor self, Dimname[1] dim, bool unbiased=True, bool keepdim=False, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & var_outf(const at::Tensor & self, at::DimnameList dim, bool unbiased, bool keepdim, at::Tensor & out) {
    return at::_ops::var_names_out::call(self, dim, unbiased, keepdim, out);
}

// aten::var.correction_names(Tensor self, Dimname[1] dim, *, int? correction, bool keepdim=False) -> Tensor
TORCH_API inline at::Tensor var(const at::Tensor & self, at::DimnameList dim, c10::optional<int64_t> correction, bool keepdim=false) {
    return at::_ops::var_correction_names::call(self, dim, correction, keepdim);
}

// aten::var.correction_names_out(Tensor self, Dimname[1] dim, *, int? correction, bool keepdim=False, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & var_out(at::Tensor & out, const at::Tensor & self, at::DimnameList dim, c10::optional<int64_t> correction, bool keepdim=false) {
    return at::_ops::var_correction_names_out::call(self, dim, correction, keepdim, out);
}

// aten::var.correction_names_out(Tensor self, Dimname[1] dim, *, int? correction, bool keepdim=False, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & var_outf(const at::Tensor & self, at::DimnameList dim, c10::optional<int64_t> correction, bool keepdim, at::Tensor & out) {
    return at::_ops::var_correction_names_out::call(self, dim, correction, keepdim, out);
}

// aten::var_mean(Tensor self, bool unbiased=True) -> (Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> var_mean(const at::Tensor & self, bool unbiased=true) {
    return at::_ops::var_mean::call(self, unbiased);
}

// aten::var_mean.dim(Tensor self, int[1] dim, bool unbiased=True, bool keepdim=False) -> (Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> var_mean(const at::Tensor & self, at::IntArrayRef dim, bool unbiased=true, bool keepdim=false) {
    return at::_ops::var_mean_dim::call(self, dim, unbiased, keepdim);
}

// aten::var_mean.correction(Tensor self, int[1]? dim, *, int? correction, bool keepdim=False) -> (Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> var_mean(const at::Tensor & self, c10::optional<at::IntArrayRef> dim, c10::optional<int64_t> correction, bool keepdim=false) {
    return at::_ops::var_mean_correction::call(self, dim, correction, keepdim);
}

// aten::var_mean.names_dim(Tensor self, Dimname[1] dim, bool unbiased=True, bool keepdim=False) -> (Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> var_mean(const at::Tensor & self, at::DimnameList dim, bool unbiased=true, bool keepdim=false) {
    return at::_ops::var_mean_names_dim::call(self, dim, unbiased, keepdim);
}

// aten::var_mean.correction_names(Tensor self, Dimname[1] dim, *, int? correction, bool keepdim=False) -> (Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> var_mean(const at::Tensor & self, at::DimnameList dim, c10::optional<int64_t> correction, bool keepdim=false) {
    return at::_ops::var_mean_correction_names::call(self, dim, correction, keepdim);
}

// aten::where.self(Tensor condition, Tensor self, Tensor other) -> Tensor
TORCH_API inline at::Tensor where(const at::Tensor & condition, const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::where_self::call(condition, self, other);
}

// aten::where.ScalarSelf(Tensor condition, Scalar self, Tensor other) -> Tensor
TORCH_API inline at::Tensor where(const at::Tensor & condition, const at::Scalar & self, const at::Tensor & other) {
    return at::_ops::where_ScalarSelf::call(condition, self, other);
}

// aten::where.ScalarOther(Tensor condition, Tensor self, Scalar other) -> Tensor
TORCH_API inline at::Tensor where(const at::Tensor & condition, const at::Tensor & self, const at::Scalar & other) {
    return at::_ops::where_ScalarOther::call(condition, self, other);
}

// aten::where.Scalar(Tensor condition, Scalar self, Scalar other) -> Tensor
TORCH_API inline at::Tensor where(const at::Tensor & condition, const at::Scalar & self, const at::Scalar & other) {
    return at::_ops::where_Scalar::call(condition, self, other);
}

// aten::where(Tensor condition) -> Tensor[]
TORCH_API inline ::std::vector<at::Tensor> where(const at::Tensor & condition) {
    return at::_ops::where::call(condition);
}

// aten::_s_where(Tensor condition, Tensor self, Tensor other) -> Tensor
TORCH_API inline at::Tensor _s_where(const at::Tensor & condition, const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::_s_where::call(condition, self, other);
}

// aten::norm_except_dim(Tensor v, int pow=2, int dim=0) -> Tensor
TORCH_API inline at::Tensor norm_except_dim(const at::Tensor & v, int64_t pow=2, int64_t dim=0) {
    return at::_ops::norm_except_dim::call(v, pow, dim);
}

// aten::_weight_norm(Tensor v, Tensor g, int dim=0) -> Tensor
TORCH_API inline at::Tensor _weight_norm(const at::Tensor & v, const at::Tensor & g, int64_t dim=0) {
    return at::_ops::_weight_norm::call(v, g, dim);
}

// aten::_weight_norm_cuda_interface(Tensor v, Tensor g, int dim=0) -> (Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> _weight_norm_cuda_interface(const at::Tensor & v, const at::Tensor & g, int64_t dim=0) {
    return at::_ops::_weight_norm_cuda_interface::call(v, g, dim);
}

// aten::_weight_norm_cuda_interface_backward(Tensor grad_w, Tensor saved_v, Tensor saved_g, Tensor saved_norms, int dim) -> (Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> _weight_norm_cuda_interface_backward(const at::Tensor & grad_w, const at::Tensor & saved_v, const at::Tensor & saved_g, const at::Tensor & saved_norms, int64_t dim) {
    return at::_ops::_weight_norm_cuda_interface_backward::call(grad_w, saved_v, saved_g, saved_norms, dim);
}

// aten::_weight_norm_differentiable_backward(Tensor grad_w, Tensor saved_v, Tensor saved_g, Tensor saved_norms, int dim) -> (Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> _weight_norm_differentiable_backward(const at::Tensor & grad_w, const at::Tensor & saved_v, const at::Tensor & saved_g, const at::Tensor & saved_norms, int64_t dim) {
    return at::_ops::_weight_norm_differentiable_backward::call(grad_w, saved_v, saved_g, saved_norms, dim);
}

// aten::zeros.names(int[] size, *, Dimname[]? names, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor zeros(at::IntArrayRef size, c10::optional<at::DimnameList> names, at::TensorOptions options={}) {
    return at::_ops::zeros_names::call(size, names, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt());
}

// aten::zeros.names(int[] size, *, Dimname[]? names, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor zeros(at::IntArrayRef size, c10::optional<at::DimnameList> names, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory) {
    return at::_ops::zeros_names::call(size, names, dtype, layout, device, pin_memory);
}

// aten::zeros(int[] size, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor zeros(at::IntArrayRef size, at::TensorOptions options={}) {
    return at::_ops::zeros::call(size, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt());
}

// aten::zeros(int[] size, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor zeros(at::IntArrayRef size, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory) {
    return at::_ops::zeros::call(size, dtype, layout, device, pin_memory);
}

// aten::zeros.out(int[] size, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & zeros_out(at::Tensor & out, at::IntArrayRef size) {
    return at::_ops::zeros_out::call(size, out);
}

// aten::zeros.out(int[] size, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & zeros_outf(at::IntArrayRef size, at::Tensor & out) {
    return at::_ops::zeros_out::call(size, out);
}

// aten::zeros_like(Tensor self, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None, MemoryFormat? memory_format=None) -> Tensor
TORCH_API inline at::Tensor zeros_like(const at::Tensor & self, at::TensorOptions options={}, c10::optional<at::MemoryFormat> memory_format=c10::nullopt) {
    return at::_ops::zeros_like::call(self, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt(), c10::impl::check_tensor_options_and_extract_memory_format(options, memory_format));
}

// aten::zeros_like(Tensor self, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None, MemoryFormat? memory_format=None) -> Tensor
TORCH_API inline at::Tensor zeros_like(const at::Tensor & self, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory, c10::optional<at::MemoryFormat> memory_format) {
    return at::_ops::zeros_like::call(self, dtype, layout, device, pin_memory, memory_format);
}

// aten::_standard_gamma_grad(Tensor self, Tensor output) -> Tensor
TORCH_API inline at::Tensor _standard_gamma_grad(const at::Tensor & self, const at::Tensor & output) {
    return at::_ops::_standard_gamma_grad::call(self, output);
}

// aten::_standard_gamma(Tensor self, Generator? generator=None) -> Tensor
TORCH_API inline at::Tensor _standard_gamma(const at::Tensor & self, c10::optional<at::Generator> generator=c10::nullopt) {
    return at::_ops::_standard_gamma::call(self, generator);
}

// aten::_dirichlet_grad(Tensor x, Tensor alpha, Tensor total) -> Tensor
TORCH_API inline at::Tensor _dirichlet_grad(const at::Tensor & x, const at::Tensor & alpha, const at::Tensor & total) {
    return at::_ops::_dirichlet_grad::call(x, alpha, total);
}

// aten::_sample_dirichlet(Tensor self, Generator? generator=None) -> Tensor
TORCH_API inline at::Tensor _sample_dirichlet(const at::Tensor & self, c10::optional<at::Generator> generator=c10::nullopt) {
    return at::_ops::_sample_dirichlet::call(self, generator);
}

// aten::poisson(Tensor self, Generator? generator=None) -> Tensor
TORCH_API inline at::Tensor poisson(const at::Tensor & self, c10::optional<at::Generator> generator=c10::nullopt) {
    return at::_ops::poisson::call(self, generator);
}

// aten::binomial(Tensor count, Tensor prob, Generator? generator=None) -> Tensor
TORCH_API inline at::Tensor binomial(const at::Tensor & count, const at::Tensor & prob, c10::optional<at::Generator> generator=c10::nullopt) {
    return at::_ops::binomial::call(count, prob, generator);
}

// aten::native_norm(Tensor self, Scalar p=2) -> Tensor
TORCH_API inline at::Tensor native_norm(const at::Tensor & self, const at::Scalar & p=2) {
    return at::_ops::native_norm::call(self, p);
}

// aten::native_norm.ScalarOpt_dim_dtype(Tensor self, Scalar? p, int[1] dim, bool keepdim, ScalarType? dtype) -> Tensor
TORCH_API inline at::Tensor native_norm(const at::Tensor & self, const c10::optional<at::Scalar> & p, at::IntArrayRef dim, bool keepdim, c10::optional<at::ScalarType> dtype) {
    return at::_ops::native_norm_ScalarOpt_dim_dtype::call(self, p, dim, keepdim, dtype);
}

// aten::_sparse_sum(Tensor self) -> Tensor
TORCH_API inline at::Tensor _sparse_sum(const at::Tensor & self) {
    return at::_ops::_sparse_sum::call(self);
}

// aten::_sparse_sum.dtype(Tensor self, *, ScalarType dtype) -> Tensor
TORCH_API inline at::Tensor _sparse_sum(const at::Tensor & self, at::ScalarType dtype) {
    return at::_ops::_sparse_sum_dtype::call(self, dtype);
}

// aten::_sparse_sum.dim(Tensor self, int[1] dim) -> Tensor
TORCH_API inline at::Tensor _sparse_sum(const at::Tensor & self, at::IntArrayRef dim) {
    return at::_ops::_sparse_sum_dim::call(self, dim);
}

// aten::_sparse_sum.dim_dtype(Tensor self, int[1] dim, *, ScalarType dtype) -> Tensor
TORCH_API inline at::Tensor _sparse_sum(const at::Tensor & self, at::IntArrayRef dim, at::ScalarType dtype) {
    return at::_ops::_sparse_sum_dim_dtype::call(self, dim, dtype);
}

// aten::_sparse_sum_backward(Tensor grad, Tensor self, int[] dim) -> Tensor
TORCH_API inline at::Tensor _sparse_sum_backward(const at::Tensor & grad, const at::Tensor & self, at::IntArrayRef dim) {
    return at::_ops::_sparse_sum_backward::call(grad, self, dim);
}

// aten::_sparse_softmax.int(Tensor self, int dim, ScalarType? dtype=None) -> Tensor
TORCH_API inline at::Tensor _sparse_softmax(const at::Tensor & self, int64_t dim, c10::optional<at::ScalarType> dtype=c10::nullopt) {
    return at::_ops::_sparse_softmax_int::call(self, dim, dtype);
}

// aten::_sparse_softmax.Dimname(Tensor self, Dimname dim, *, ScalarType? dtype=None) -> Tensor
TORCH_API inline at::Tensor _sparse_softmax(const at::Tensor & self, at::Dimname dim, c10::optional<at::ScalarType> dtype=c10::nullopt) {
    return at::_ops::_sparse_softmax_Dimname::call(self, dim, dtype);
}

// aten::_sparse_softmax(Tensor self, int dim, bool half_to_float) -> Tensor
TORCH_API inline at::Tensor _sparse_softmax(const at::Tensor & self, int64_t dim, bool half_to_float) {
    return at::_ops::_sparse_softmax::call(self, dim, half_to_float);
}

// aten::_sparse_softmax_backward_data(Tensor grad_output, Tensor output, int dim, Tensor self) -> Tensor
TORCH_API inline at::Tensor _sparse_softmax_backward_data(const at::Tensor & grad_output, const at::Tensor & output, int64_t dim, const at::Tensor & self) {
    return at::_ops::_sparse_softmax_backward_data::call(grad_output, output, dim, self);
}

// aten::_sparse_log_softmax.int(Tensor self, int dim, ScalarType? dtype=None) -> Tensor
TORCH_API inline at::Tensor _sparse_log_softmax(const at::Tensor & self, int64_t dim, c10::optional<at::ScalarType> dtype=c10::nullopt) {
    return at::_ops::_sparse_log_softmax_int::call(self, dim, dtype);
}

// aten::_sparse_log_softmax.Dimname(Tensor self, Dimname dim, *, ScalarType? dtype=None) -> Tensor
TORCH_API inline at::Tensor _sparse_log_softmax(const at::Tensor & self, at::Dimname dim, c10::optional<at::ScalarType> dtype=c10::nullopt) {
    return at::_ops::_sparse_log_softmax_Dimname::call(self, dim, dtype);
}

// aten::_sparse_log_softmax(Tensor self, int dim, bool half_to_float) -> Tensor
TORCH_API inline at::Tensor _sparse_log_softmax(const at::Tensor & self, int64_t dim, bool half_to_float) {
    return at::_ops::_sparse_log_softmax::call(self, dim, half_to_float);
}

// aten::_sparse_log_softmax_backward_data(Tensor grad_output, Tensor output, int dim, Tensor self) -> Tensor
TORCH_API inline at::Tensor _sparse_log_softmax_backward_data(const at::Tensor & grad_output, const at::Tensor & output, int64_t dim, const at::Tensor & self) {
    return at::_ops::_sparse_log_softmax_backward_data::call(grad_output, output, dim, self);
}

// aten::norm.ScalarOpt_dtype(Tensor self, Scalar? p, *, ScalarType dtype) -> Tensor
TORCH_API inline at::Tensor norm(const at::Tensor & self, const c10::optional<at::Scalar> & p, at::ScalarType dtype) {
    return at::_ops::norm_ScalarOpt_dtype::call(self, p, dtype);
}

// aten::norm.Scalar(Tensor self, Scalar p=2) -> Tensor
TORCH_API inline at::Tensor norm(const at::Tensor & self, const at::Scalar & p=2) {
    return at::_ops::norm_Scalar::call(self, p);
}

// aten::norm.ScalarOpt_dim_dtype(Tensor self, Scalar? p, int[1] dim, bool keepdim, *, ScalarType dtype) -> Tensor
TORCH_API inline at::Tensor norm(const at::Tensor & self, const c10::optional<at::Scalar> & p, at::IntArrayRef dim, bool keepdim, at::ScalarType dtype) {
    return at::_ops::norm_ScalarOpt_dim_dtype::call(self, p, dim, keepdim, dtype);
}

// aten::norm.ScalarOpt_dim(Tensor self, Scalar? p, int[1] dim, bool keepdim=False) -> Tensor
TORCH_API inline at::Tensor norm(const at::Tensor & self, const c10::optional<at::Scalar> & p, at::IntArrayRef dim, bool keepdim=false) {
    return at::_ops::norm_ScalarOpt_dim::call(self, p, dim, keepdim);
}

// aten::norm.dtype_out(Tensor self, Scalar? p, int[1] dim, bool keepdim, *, ScalarType dtype, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & norm_out(at::Tensor & out, const at::Tensor & self, const c10::optional<at::Scalar> & p, at::IntArrayRef dim, bool keepdim, at::ScalarType dtype) {
    return at::_ops::norm_dtype_out::call(self, p, dim, keepdim, dtype, out);
}

// aten::norm.dtype_out(Tensor self, Scalar? p, int[1] dim, bool keepdim, *, ScalarType dtype, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & norm_outf(const at::Tensor & self, const c10::optional<at::Scalar> & p, at::IntArrayRef dim, bool keepdim, at::ScalarType dtype, at::Tensor & out) {
    return at::_ops::norm_dtype_out::call(self, p, dim, keepdim, dtype, out);
}

// aten::norm.out(Tensor self, Scalar? p, int[1] dim, bool keepdim=False, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & norm_out(at::Tensor & out, const at::Tensor & self, const c10::optional<at::Scalar> & p, at::IntArrayRef dim, bool keepdim=false) {
    return at::_ops::norm_out::call(self, p, dim, keepdim, out);
}

// aten::norm.out(Tensor self, Scalar? p, int[1] dim, bool keepdim=False, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & norm_outf(const at::Tensor & self, const c10::optional<at::Scalar> & p, at::IntArrayRef dim, bool keepdim, at::Tensor & out) {
    return at::_ops::norm_out::call(self, p, dim, keepdim, out);
}

// aten::norm.names_ScalarOpt_dim_dtype(Tensor self, Scalar? p, Dimname[1] dim, bool keepdim, *, ScalarType dtype) -> Tensor
TORCH_API inline at::Tensor norm(const at::Tensor & self, const c10::optional<at::Scalar> & p, at::DimnameList dim, bool keepdim, at::ScalarType dtype) {
    return at::_ops::norm_names_ScalarOpt_dim_dtype::call(self, p, dim, keepdim, dtype);
}

// aten::norm.names_ScalarOpt_dim(Tensor self, Scalar? p, Dimname[1] dim, bool keepdim=False) -> Tensor
TORCH_API inline at::Tensor norm(const at::Tensor & self, const c10::optional<at::Scalar> & p, at::DimnameList dim, bool keepdim=false) {
    return at::_ops::norm_names_ScalarOpt_dim::call(self, p, dim, keepdim);
}

// aten::norm.names_dtype_out(Tensor self, Scalar? p, Dimname[1] dim, bool keepdim, *, ScalarType dtype, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & norm_out(at::Tensor & out, const at::Tensor & self, const c10::optional<at::Scalar> & p, at::DimnameList dim, bool keepdim, at::ScalarType dtype) {
    return at::_ops::norm_names_dtype_out::call(self, p, dim, keepdim, dtype, out);
}

// aten::norm.names_dtype_out(Tensor self, Scalar? p, Dimname[1] dim, bool keepdim, *, ScalarType dtype, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & norm_outf(const at::Tensor & self, const c10::optional<at::Scalar> & p, at::DimnameList dim, bool keepdim, at::ScalarType dtype, at::Tensor & out) {
    return at::_ops::norm_names_dtype_out::call(self, p, dim, keepdim, dtype, out);
}

// aten::norm.names_out(Tensor self, Scalar? p, Dimname[1] dim, bool keepdim=False, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & norm_out(at::Tensor & out, const at::Tensor & self, const c10::optional<at::Scalar> & p, at::DimnameList dim, bool keepdim=false) {
    return at::_ops::norm_names_out::call(self, p, dim, keepdim, out);
}

// aten::norm.names_out(Tensor self, Scalar? p, Dimname[1] dim, bool keepdim=False, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & norm_outf(const at::Tensor & self, const c10::optional<at::Scalar> & p, at::DimnameList dim, bool keepdim, at::Tensor & out) {
    return at::_ops::norm_names_out::call(self, p, dim, keepdim, out);
}

// aten::frexp.Tensor(Tensor self) -> (Tensor mantissa, Tensor exponent)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> frexp(const at::Tensor & self) {
    return at::_ops::frexp_Tensor::call(self);
}

// aten::frexp.Tensor_out(Tensor self, *, Tensor(a!) mantissa, Tensor(b!) exponent) -> (Tensor(a!) mantissa, Tensor(b!) exponent)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> frexp_out(at::Tensor & mantissa, at::Tensor & exponent, const at::Tensor & self) {
    return at::_ops::frexp_Tensor_out::call(self, mantissa, exponent);
}

// aten::frexp.Tensor_out(Tensor self, *, Tensor(a!) mantissa, Tensor(b!) exponent) -> (Tensor(a!) mantissa, Tensor(b!) exponent)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> frexp_outf(const at::Tensor & self, at::Tensor & mantissa, at::Tensor & exponent) {
    return at::_ops::frexp_Tensor_out::call(self, mantissa, exponent);
}

// aten::frobenius_norm(Tensor self) -> Tensor
TORCH_API inline at::Tensor frobenius_norm(const at::Tensor & self) {
    return at::_ops::frobenius_norm::call(self);
}

// aten::frobenius_norm.dim(Tensor self, int[1] dim, bool keepdim=False) -> Tensor
TORCH_API inline at::Tensor frobenius_norm(const at::Tensor & self, at::IntArrayRef dim, bool keepdim=false) {
    return at::_ops::frobenius_norm_dim::call(self, dim, keepdim);
}

// aten::frobenius_norm.out(Tensor self, int[1] dim, bool keepdim=False, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & frobenius_norm_out(at::Tensor & out, const at::Tensor & self, at::IntArrayRef dim, bool keepdim=false) {
    return at::_ops::frobenius_norm_out::call(self, dim, keepdim, out);
}

// aten::frobenius_norm.out(Tensor self, int[1] dim, bool keepdim=False, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & frobenius_norm_outf(const at::Tensor & self, at::IntArrayRef dim, bool keepdim, at::Tensor & out) {
    return at::_ops::frobenius_norm_out::call(self, dim, keepdim, out);
}

// aten::nuclear_norm(Tensor self, bool keepdim=False) -> Tensor
TORCH_API inline at::Tensor nuclear_norm(const at::Tensor & self, bool keepdim=false) {
    return at::_ops::nuclear_norm::call(self, keepdim);
}

// aten::nuclear_norm.out(Tensor self, bool keepdim=False, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & nuclear_norm_out(at::Tensor & out, const at::Tensor & self, bool keepdim=false) {
    return at::_ops::nuclear_norm_out::call(self, keepdim, out);
}

// aten::nuclear_norm.out(Tensor self, bool keepdim=False, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & nuclear_norm_outf(const at::Tensor & self, bool keepdim, at::Tensor & out) {
    return at::_ops::nuclear_norm_out::call(self, keepdim, out);
}

// aten::nuclear_norm.dim(Tensor self, int[2] dim, bool keepdim=False) -> Tensor
TORCH_API inline at::Tensor nuclear_norm(const at::Tensor & self, at::IntArrayRef dim, bool keepdim=false) {
    return at::_ops::nuclear_norm_dim::call(self, dim, keepdim);
}

// aten::nuclear_norm.dim_out(Tensor self, int[2] dim, bool keepdim=False, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & nuclear_norm_out(at::Tensor & out, const at::Tensor & self, at::IntArrayRef dim, bool keepdim=false) {
    return at::_ops::nuclear_norm_dim_out::call(self, dim, keepdim, out);
}

// aten::nuclear_norm.dim_out(Tensor self, int[2] dim, bool keepdim=False, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & nuclear_norm_outf(const at::Tensor & self, at::IntArrayRef dim, bool keepdim, at::Tensor & out) {
    return at::_ops::nuclear_norm_dim_out::call(self, dim, keepdim, out);
}

// aten::clone(Tensor self, *, MemoryFormat? memory_format=None) -> Tensor
TORCH_API inline at::Tensor clone(const at::Tensor & self, c10::optional<at::MemoryFormat> memory_format=c10::nullopt) {
    return at::_ops::clone::call(self, memory_format);
}

// aten::positive(Tensor(a) self) -> Tensor(a)
TORCH_API inline at::Tensor positive(const at::Tensor & self) {
    return at::_ops::positive::call(self);
}

// aten::resize_as_(Tensor(a!) self, Tensor the_template, *, MemoryFormat? memory_format=None) -> Tensor(a!)
TORCH_API inline const at::Tensor & resize_as_(const at::Tensor & self, const at::Tensor & the_template, c10::optional<at::MemoryFormat> memory_format=c10::nullopt) {
    return at::_ops::resize_as_::call(self, the_template, memory_format);
}

// aten::resize_as_sparse_(Tensor(a!) self, Tensor the_template) -> Tensor(a!)
TORCH_API inline const at::Tensor & resize_as_sparse_(const at::Tensor & self, const at::Tensor & the_template) {
    return at::_ops::resize_as_sparse_::call(self, the_template);
}

// aten::zero_(Tensor(a!) self) -> Tensor(a!)
TORCH_API inline at::Tensor & zero_(at::Tensor & self) {
    return at::_ops::zero_::call(self);
}

// aten::sub.out(Tensor self, Tensor other, *, Scalar alpha=1, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & sub_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & other, const at::Scalar & alpha=1) {
    return at::_ops::sub_out::call(self, other, alpha, out);
}

// aten::sub.out(Tensor self, Tensor other, *, Scalar alpha=1, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & sub_outf(const at::Tensor & self, const at::Tensor & other, const at::Scalar & alpha, at::Tensor & out) {
    return at::_ops::sub_out::call(self, other, alpha, out);
}

// aten::sub.Tensor(Tensor self, Tensor other, *, Scalar alpha=1) -> Tensor
TORCH_API inline at::Tensor sub(const at::Tensor & self, const at::Tensor & other, const at::Scalar & alpha=1) {
    return at::_ops::sub_Tensor::call(self, other, alpha);
}

// aten::sub.Scalar(Tensor self, Scalar other, Scalar alpha=1) -> Tensor
TORCH_API inline at::Tensor sub(const at::Tensor & self, const at::Scalar & other, const at::Scalar & alpha=1) {
    return at::_ops::sub_Scalar::call(self, other, alpha);
}

// aten::subtract.out(Tensor self, Tensor other, *, Scalar alpha=1, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & subtract_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & other, const at::Scalar & alpha=1) {
    return at::_ops::subtract_out::call(self, other, alpha, out);
}

// aten::subtract.out(Tensor self, Tensor other, *, Scalar alpha=1, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & subtract_outf(const at::Tensor & self, const at::Tensor & other, const at::Scalar & alpha, at::Tensor & out) {
    return at::_ops::subtract_out::call(self, other, alpha, out);
}

// aten::subtract.Tensor(Tensor self, Tensor other, *, Scalar alpha=1) -> Tensor
TORCH_API inline at::Tensor subtract(const at::Tensor & self, const at::Tensor & other, const at::Scalar & alpha=1) {
    return at::_ops::subtract_Tensor::call(self, other, alpha);
}

// aten::subtract.Scalar(Tensor self, Scalar other, Scalar alpha=1) -> Tensor
TORCH_API inline at::Tensor subtract(const at::Tensor & self, const at::Scalar & other, const at::Scalar & alpha=1) {
    return at::_ops::subtract_Scalar::call(self, other, alpha);
}

// aten::rsub.Tensor(Tensor self, Tensor other, *, Scalar alpha=1) -> Tensor
TORCH_API inline at::Tensor rsub(const at::Tensor & self, const at::Tensor & other, const at::Scalar & alpha=1) {
    return at::_ops::rsub_Tensor::call(self, other, alpha);
}

// aten::heaviside.out(Tensor self, Tensor values, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & heaviside_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & values) {
    return at::_ops::heaviside_out::call(self, values, out);
}

// aten::heaviside.out(Tensor self, Tensor values, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & heaviside_outf(const at::Tensor & self, const at::Tensor & values, at::Tensor & out) {
    return at::_ops::heaviside_out::call(self, values, out);
}

// aten::heaviside(Tensor self, Tensor values) -> Tensor
TORCH_API inline at::Tensor heaviside(const at::Tensor & self, const at::Tensor & values) {
    return at::_ops::heaviside::call(self, values);
}

// aten::rsub.Scalar(Tensor self, Scalar other, Scalar alpha=1) -> Tensor
TORCH_API inline at::Tensor rsub(const at::Tensor & self, const at::Scalar & other, const at::Scalar & alpha=1) {
    return at::_ops::rsub_Scalar::call(self, other, alpha);
}

// aten::_sparse_addmm(Tensor self, Tensor sparse, Tensor dense, *, Scalar beta=1, Scalar alpha=1) -> Tensor
TORCH_API inline at::Tensor _sparse_addmm(const at::Tensor & self, const at::Tensor & sparse, const at::Tensor & dense, const at::Scalar & beta=1, const at::Scalar & alpha=1) {
    return at::_ops::_sparse_addmm::call(self, sparse, dense, beta, alpha);
}

// aten::addmm.out(Tensor self, Tensor mat1, Tensor mat2, *, Scalar beta=1, Scalar alpha=1, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & addmm_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & mat1, const at::Tensor & mat2, const at::Scalar & beta=1, const at::Scalar & alpha=1) {
    return at::_ops::addmm_out::call(self, mat1, mat2, beta, alpha, out);
}

// aten::addmm.out(Tensor self, Tensor mat1, Tensor mat2, *, Scalar beta=1, Scalar alpha=1, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & addmm_outf(const at::Tensor & self, const at::Tensor & mat1, const at::Tensor & mat2, const at::Scalar & beta, const at::Scalar & alpha, at::Tensor & out) {
    return at::_ops::addmm_out::call(self, mat1, mat2, beta, alpha, out);
}

// aten::addmm(Tensor self, Tensor mat1, Tensor mat2, *, Scalar beta=1, Scalar alpha=1) -> Tensor
TORCH_API inline at::Tensor addmm(const at::Tensor & self, const at::Tensor & mat1, const at::Tensor & mat2, const at::Scalar & beta=1, const at::Scalar & alpha=1) {
    return at::_ops::addmm::call(self, mat1, mat2, beta, alpha);
}

// aten::sparse_csr_tensor.crow_col_value_size(Tensor crow_indices, Tensor col_indices, Tensor values, int[] size, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=False) -> Tensor
TORCH_API inline at::Tensor sparse_csr_tensor(const at::Tensor & crow_indices, const at::Tensor & col_indices, const at::Tensor & values, at::IntArrayRef size, at::TensorOptions options) {
    return at::_ops::sparse_csr_tensor_crow_col_value_size::call(crow_indices, col_indices, values, size, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt());
}

// aten::sparse_csr_tensor.crow_col_value_size(Tensor crow_indices, Tensor col_indices, Tensor values, int[] size, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=False) -> Tensor
TORCH_API inline at::Tensor sparse_csr_tensor(const at::Tensor & crow_indices, const at::Tensor & col_indices, const at::Tensor & values, at::IntArrayRef size, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory) {
    return at::_ops::sparse_csr_tensor_crow_col_value_size::call(crow_indices, col_indices, values, size, dtype, layout, device, pin_memory);
}

// aten::sparse_csr_tensor.crow_col_value(Tensor crow_indices, Tensor col_indices, Tensor values, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=False) -> Tensor
TORCH_API inline at::Tensor sparse_csr_tensor(const at::Tensor & crow_indices, const at::Tensor & col_indices, const at::Tensor & values, at::TensorOptions options) {
    return at::_ops::sparse_csr_tensor_crow_col_value::call(crow_indices, col_indices, values, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt());
}

// aten::sparse_csr_tensor.crow_col_value(Tensor crow_indices, Tensor col_indices, Tensor values, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=False) -> Tensor
TORCH_API inline at::Tensor sparse_csr_tensor(const at::Tensor & crow_indices, const at::Tensor & col_indices, const at::Tensor & values, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory) {
    return at::_ops::sparse_csr_tensor_crow_col_value::call(crow_indices, col_indices, values, dtype, layout, device, pin_memory);
}

// aten::_sparse_csr_tensor_unsafe(Tensor crow_indices, Tensor col_indices, Tensor values, int[] size, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor _sparse_csr_tensor_unsafe(const at::Tensor & crow_indices, const at::Tensor & col_indices, const at::Tensor & values, at::IntArrayRef size, at::TensorOptions options={}) {
    return at::_ops::_sparse_csr_tensor_unsafe::call(crow_indices, col_indices, values, size, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt());
}

// aten::_sparse_csr_tensor_unsafe(Tensor crow_indices, Tensor col_indices, Tensor values, int[] size, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor _sparse_csr_tensor_unsafe(const at::Tensor & crow_indices, const at::Tensor & col_indices, const at::Tensor & values, at::IntArrayRef size, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory) {
    return at::_ops::_sparse_csr_tensor_unsafe::call(crow_indices, col_indices, values, size, dtype, layout, device, pin_memory);
}

// aten::sparse_coo_tensor.size(int[] size, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=False) -> Tensor
TORCH_API inline at::Tensor sparse_coo_tensor(at::IntArrayRef size, at::TensorOptions options) {
    return at::_ops::sparse_coo_tensor_size::call(size, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt());
}

// aten::sparse_coo_tensor.size(int[] size, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=False) -> Tensor
TORCH_API inline at::Tensor sparse_coo_tensor(at::IntArrayRef size, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory) {
    return at::_ops::sparse_coo_tensor_size::call(size, dtype, layout, device, pin_memory);
}

// aten::sparse_coo_tensor.indices(Tensor indices, Tensor values, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor sparse_coo_tensor(const at::Tensor & indices, const at::Tensor & values, at::TensorOptions options={}) {
    return at::_ops::sparse_coo_tensor_indices::call(indices, values, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt());
}

// aten::sparse_coo_tensor.indices(Tensor indices, Tensor values, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor sparse_coo_tensor(const at::Tensor & indices, const at::Tensor & values, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory) {
    return at::_ops::sparse_coo_tensor_indices::call(indices, values, dtype, layout, device, pin_memory);
}

// aten::sparse_coo_tensor.indices_size(Tensor indices, Tensor values, int[] size, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor sparse_coo_tensor(const at::Tensor & indices, const at::Tensor & values, at::IntArrayRef size, at::TensorOptions options={}) {
    return at::_ops::sparse_coo_tensor_indices_size::call(indices, values, size, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt());
}

// aten::sparse_coo_tensor.indices_size(Tensor indices, Tensor values, int[] size, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor sparse_coo_tensor(const at::Tensor & indices, const at::Tensor & values, at::IntArrayRef size, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory) {
    return at::_ops::sparse_coo_tensor_indices_size::call(indices, values, size, dtype, layout, device, pin_memory);
}

// aten::_sparse_coo_tensor_unsafe(Tensor indices, Tensor values, int[] size, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor _sparse_coo_tensor_unsafe(const at::Tensor & indices, const at::Tensor & values, at::IntArrayRef size, at::TensorOptions options={}) {
    return at::_ops::_sparse_coo_tensor_unsafe::call(indices, values, size, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt());
}

// aten::_sparse_coo_tensor_unsafe(Tensor indices, Tensor values, int[] size, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor _sparse_coo_tensor_unsafe(const at::Tensor & indices, const at::Tensor & values, at::IntArrayRef size, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory) {
    return at::_ops::_sparse_coo_tensor_unsafe::call(indices, values, size, dtype, layout, device, pin_memory);
}

// aten::_validate_sparse_coo_tensor_args(Tensor indices, Tensor values, int[] size) -> ()
TORCH_API inline void _validate_sparse_coo_tensor_args(const at::Tensor & indices, const at::Tensor & values, at::IntArrayRef size) {
    return at::_ops::_validate_sparse_coo_tensor_args::call(indices, values, size);
}

// aten::_validate_sparse_csr_tensor_args(Tensor crow_indices, Tensor col_indices, Tensor values, int[] size) -> ()
TORCH_API inline void _validate_sparse_csr_tensor_args(const at::Tensor & crow_indices, const at::Tensor & col_indices, const at::Tensor & values, at::IntArrayRef size) {
    return at::_ops::_validate_sparse_csr_tensor_args::call(crow_indices, col_indices, values, size);
}

// aten::_sparse_coo_tensor_with_dims(int sparse_dim, int dense_dim, int[] size, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=False) -> Tensor
TORCH_API inline at::Tensor _sparse_coo_tensor_with_dims(int64_t sparse_dim, int64_t dense_dim, at::IntArrayRef size, at::TensorOptions options) {
    return at::_ops::_sparse_coo_tensor_with_dims::call(sparse_dim, dense_dim, size, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt());
}

// aten::_sparse_coo_tensor_with_dims(int sparse_dim, int dense_dim, int[] size, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=False) -> Tensor
TORCH_API inline at::Tensor _sparse_coo_tensor_with_dims(int64_t sparse_dim, int64_t dense_dim, at::IntArrayRef size, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory) {
    return at::_ops::_sparse_coo_tensor_with_dims::call(sparse_dim, dense_dim, size, dtype, layout, device, pin_memory);
}

// aten::_sparse_coo_tensor_with_dims_and_tensors(int sparse_dim, int dense_dim, int[] size, Tensor indices, Tensor values, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=False) -> Tensor
TORCH_API inline at::Tensor _sparse_coo_tensor_with_dims_and_tensors(int64_t sparse_dim, int64_t dense_dim, at::IntArrayRef size, const at::Tensor & indices, const at::Tensor & values, at::TensorOptions options) {
    return at::_ops::_sparse_coo_tensor_with_dims_and_tensors::call(sparse_dim, dense_dim, size, indices, values, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt());
}

// aten::_sparse_coo_tensor_with_dims_and_tensors(int sparse_dim, int dense_dim, int[] size, Tensor indices, Tensor values, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=False) -> Tensor
TORCH_API inline at::Tensor _sparse_coo_tensor_with_dims_and_tensors(int64_t sparse_dim, int64_t dense_dim, at::IntArrayRef size, const at::Tensor & indices, const at::Tensor & values, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory) {
    return at::_ops::_sparse_coo_tensor_with_dims_and_tensors::call(sparse_dim, dense_dim, size, indices, values, dtype, layout, device, pin_memory);
}

// aten::_to_cpu(Tensor[] tensors) -> Tensor[]
TORCH_API inline ::std::vector<at::Tensor> _to_cpu(at::TensorList tensors) {
    return at::_ops::_to_cpu::call(tensors);
}

// aten::to_dense_backward(Tensor grad, Tensor input) -> Tensor
TORCH_API inline at::Tensor to_dense_backward(const at::Tensor & grad, const at::Tensor & input) {
    return at::_ops::to_dense_backward::call(grad, input);
}

// aten::_coalesce(Tensor self) -> Tensor
TORCH_API inline at::Tensor _coalesce(const at::Tensor & self) {
    return at::_ops::_coalesce::call(self);
}

// aten::hspmm.out(Tensor mat1, Tensor mat2, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & hspmm_out(at::Tensor & out, const at::Tensor & mat1, const at::Tensor & mat2) {
    return at::_ops::hspmm_out::call(mat1, mat2, out);
}

// aten::hspmm.out(Tensor mat1, Tensor mat2, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & hspmm_outf(const at::Tensor & mat1, const at::Tensor & mat2, at::Tensor & out) {
    return at::_ops::hspmm_out::call(mat1, mat2, out);
}

// aten::hspmm(Tensor mat1, Tensor mat2) -> Tensor
TORCH_API inline at::Tensor hspmm(const at::Tensor & mat1, const at::Tensor & mat2) {
    return at::_ops::hspmm::call(mat1, mat2);
}

// aten::copy_sparse_to_sparse_(Tensor(a!) self, Tensor src, bool non_blocking=False) -> Tensor(a!)
TORCH_API inline at::Tensor & copy_sparse_to_sparse_(at::Tensor & self, const at::Tensor & src, bool non_blocking=false) {
    return at::_ops::copy_sparse_to_sparse_::call(self, src, non_blocking);
}

// aten::unbind.int(Tensor(a) self, int dim=0) -> Tensor(a)[]
TORCH_API inline ::std::vector<at::Tensor> unbind(const at::Tensor & self, int64_t dim=0) {
    return at::_ops::unbind_int::call(self, dim);
}

// aten::unbind.Dimname(Tensor(a) self, Dimname dim) -> Tensor(a)[]
TORCH_API inline ::std::vector<at::Tensor> unbind(const at::Tensor & self, at::Dimname dim) {
    return at::_ops::unbind_Dimname::call(self, dim);
}

// aten::mkldnn_reorder_conv2d_weight(Tensor self, int[2] padding=0, int[2] stride=1, int[2] dilation=1, int groups=1) -> Tensor
TORCH_API inline at::Tensor mkldnn_reorder_conv2d_weight(const at::Tensor & self, at::IntArrayRef padding=0, at::IntArrayRef stride=1, at::IntArrayRef dilation=1, int64_t groups=1) {
    return at::_ops::mkldnn_reorder_conv2d_weight::call(self, padding, stride, dilation, groups);
}

// aten::mkldnn_reorder_conv3d_weight(Tensor self, int[3] padding=0, int[3] stride=1, int[3] dilation=1, int groups=1) -> Tensor
TORCH_API inline at::Tensor mkldnn_reorder_conv3d_weight(const at::Tensor & self, at::IntArrayRef padding=0, at::IntArrayRef stride=1, at::IntArrayRef dilation=1, int64_t groups=1) {
    return at::_ops::mkldnn_reorder_conv3d_weight::call(self, padding, stride, dilation, groups);
}

// aten::to_mkldnn_backward(Tensor grad, Tensor input) -> Tensor
TORCH_API inline at::Tensor to_mkldnn_backward(const at::Tensor & grad, const at::Tensor & input) {
    return at::_ops::to_mkldnn_backward::call(grad, input);
}

// aten::quantize_per_tensor(Tensor self, float scale, int zero_point, ScalarType dtype) -> Tensor
TORCH_API inline at::Tensor quantize_per_tensor(const at::Tensor & self, double scale, int64_t zero_point, at::ScalarType dtype) {
    return at::_ops::quantize_per_tensor::call(self, scale, zero_point, dtype);
}

// aten::quantize_per_tensor.tensor_qparams(Tensor self, Tensor scale, Tensor zero_point, ScalarType dtype) -> Tensor
TORCH_API inline at::Tensor quantize_per_tensor(const at::Tensor & self, const at::Tensor & scale, const at::Tensor & zero_point, at::ScalarType dtype) {
    return at::_ops::quantize_per_tensor_tensor_qparams::call(self, scale, zero_point, dtype);
}

// aten::quantize_per_tensor.tensors(Tensor[] tensors, Tensor scales, Tensor zero_points, ScalarType dtype) -> Tensor[]
TORCH_API inline ::std::vector<at::Tensor> quantize_per_tensor(at::TensorList tensors, const at::Tensor & scales, const at::Tensor & zero_points, at::ScalarType dtype) {
    return at::_ops::quantize_per_tensor_tensors::call(tensors, scales, zero_points, dtype);
}

// aten::quantize_per_channel(Tensor self, Tensor scales, Tensor zero_points, int axis, ScalarType dtype) -> Tensor
TORCH_API inline at::Tensor quantize_per_channel(const at::Tensor & self, const at::Tensor & scales, const at::Tensor & zero_points, int64_t axis, at::ScalarType dtype) {
    return at::_ops::quantize_per_channel::call(self, scales, zero_points, axis, dtype);
}

// aten::dequantize.self(Tensor self) -> Tensor
TORCH_API inline at::Tensor dequantize(const at::Tensor & self) {
    return at::_ops::dequantize_self::call(self);
}

// aten::dequantize.tensors(Tensor[] tensors) -> Tensor[]
TORCH_API inline ::std::vector<at::Tensor> dequantize(at::TensorList tensors) {
    return at::_ops::dequantize_tensors::call(tensors);
}

// aten::q_scale(Tensor self) -> float
TORCH_API inline double q_scale(const at::Tensor & self) {
    return at::_ops::q_scale::call(self);
}

// aten::q_zero_point(Tensor self) -> int
TORCH_API inline int64_t q_zero_point(const at::Tensor & self) {
    return at::_ops::q_zero_point::call(self);
}

// aten::q_per_channel_scales(Tensor self) -> Tensor
TORCH_API inline at::Tensor q_per_channel_scales(const at::Tensor & self) {
    return at::_ops::q_per_channel_scales::call(self);
}

// aten::q_per_channel_zero_points(Tensor self) -> Tensor
TORCH_API inline at::Tensor q_per_channel_zero_points(const at::Tensor & self) {
    return at::_ops::q_per_channel_zero_points::call(self);
}

// aten::q_per_channel_axis(Tensor self) -> int
TORCH_API inline int64_t q_per_channel_axis(const at::Tensor & self) {
    return at::_ops::q_per_channel_axis::call(self);
}

// aten::int_repr(Tensor self) -> Tensor
TORCH_API inline at::Tensor int_repr(const at::Tensor & self) {
    return at::_ops::int_repr::call(self);
}

// aten::_make_per_tensor_quantized_tensor(Tensor self, float scale, int zero_point) -> Tensor
TORCH_API inline at::Tensor _make_per_tensor_quantized_tensor(const at::Tensor & self, double scale, int64_t zero_point) {
    return at::_ops::_make_per_tensor_quantized_tensor::call(self, scale, zero_point);
}

// aten::_make_per_channel_quantized_tensor(Tensor self, Tensor scale, Tensor zero_point, int axis) -> Tensor
TORCH_API inline at::Tensor _make_per_channel_quantized_tensor(const at::Tensor & self, const at::Tensor & scale, const at::Tensor & zero_point, int64_t axis) {
    return at::_ops::_make_per_channel_quantized_tensor::call(self, scale, zero_point, axis);
}

// aten::fake_quantize_per_tensor_affine(Tensor self, float scale, int zero_point, int quant_min, int quant_max) -> Tensor
TORCH_API inline at::Tensor fake_quantize_per_tensor_affine(const at::Tensor & self, double scale, int64_t zero_point, int64_t quant_min, int64_t quant_max) {
    return at::_ops::fake_quantize_per_tensor_affine::call(self, scale, zero_point, quant_min, quant_max);
}

// aten::fake_quantize_per_tensor_affine.tensor_qparams(Tensor self, Tensor scale, Tensor zero_point, int quant_min, int quant_max) -> Tensor
TORCH_API inline at::Tensor fake_quantize_per_tensor_affine(const at::Tensor & self, const at::Tensor & scale, const at::Tensor & zero_point, int64_t quant_min, int64_t quant_max) {
    return at::_ops::fake_quantize_per_tensor_affine_tensor_qparams::call(self, scale, zero_point, quant_min, quant_max);
}

// aten::fake_quantize_per_tensor_affine_cachemask(Tensor self, float scale, int zero_point, int quant_min, int quant_max) -> (Tensor output, Tensor mask)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> fake_quantize_per_tensor_affine_cachemask(const at::Tensor & self, double scale, int64_t zero_point, int64_t quant_min, int64_t quant_max) {
    return at::_ops::fake_quantize_per_tensor_affine_cachemask::call(self, scale, zero_point, quant_min, quant_max);
}

// aten::_fake_quantize_per_tensor_affine_cachemask_tensor_qparams(Tensor self, Tensor scale, Tensor zero_point, Tensor fake_quant_enabled, int quant_min, int quant_max) -> (Tensor output, Tensor mask)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> _fake_quantize_per_tensor_affine_cachemask_tensor_qparams(const at::Tensor & self, const at::Tensor & scale, const at::Tensor & zero_point, const at::Tensor & fake_quant_enabled, int64_t quant_min, int64_t quant_max) {
    return at::_ops::_fake_quantize_per_tensor_affine_cachemask_tensor_qparams::call(self, scale, zero_point, fake_quant_enabled, quant_min, quant_max);
}

// aten::fake_quantize_per_tensor_affine_cachemask_backward(Tensor grad, Tensor mask) -> Tensor
TORCH_API inline at::Tensor fake_quantize_per_tensor_affine_cachemask_backward(const at::Tensor & grad, const at::Tensor & mask) {
    return at::_ops::fake_quantize_per_tensor_affine_cachemask_backward::call(grad, mask);
}

// aten::_fake_quantize_learnable_per_tensor_affine(Tensor self, Tensor scale, Tensor zero_point, int quant_min, int quant_max, float grad_factor=1.0) -> Tensor
TORCH_API inline at::Tensor _fake_quantize_learnable_per_tensor_affine(const at::Tensor & self, const at::Tensor & scale, const at::Tensor & zero_point, int64_t quant_min, int64_t quant_max, double grad_factor=1.0) {
    return at::_ops::_fake_quantize_learnable_per_tensor_affine::call(self, scale, zero_point, quant_min, quant_max, grad_factor);
}

// aten::_fake_quantize_learnable_per_tensor_affine_backward(Tensor grad, Tensor self, Tensor scale, Tensor zero_point, int quant_min, int quant_max, float grad_factor=1.0) -> (Tensor, Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor,at::Tensor> _fake_quantize_learnable_per_tensor_affine_backward(const at::Tensor & grad, const at::Tensor & self, const at::Tensor & scale, const at::Tensor & zero_point, int64_t quant_min, int64_t quant_max, double grad_factor=1.0) {
    return at::_ops::_fake_quantize_learnable_per_tensor_affine_backward::call(grad, self, scale, zero_point, quant_min, quant_max, grad_factor);
}

// aten::fake_quantize_per_channel_affine(Tensor self, Tensor scale, Tensor zero_point, int axis, int quant_min, int quant_max) -> Tensor
TORCH_API inline at::Tensor fake_quantize_per_channel_affine(const at::Tensor & self, const at::Tensor & scale, const at::Tensor & zero_point, int64_t axis, int64_t quant_min, int64_t quant_max) {
    return at::_ops::fake_quantize_per_channel_affine::call(self, scale, zero_point, axis, quant_min, quant_max);
}

// aten::fake_quantize_per_channel_affine_cachemask(Tensor self, Tensor scale, Tensor zero_point, int axis, int quant_min, int quant_max) -> (Tensor output, Tensor mask)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> fake_quantize_per_channel_affine_cachemask(const at::Tensor & self, const at::Tensor & scale, const at::Tensor & zero_point, int64_t axis, int64_t quant_min, int64_t quant_max) {
    return at::_ops::fake_quantize_per_channel_affine_cachemask::call(self, scale, zero_point, axis, quant_min, quant_max);
}

// aten::fake_quantize_per_channel_affine_cachemask_backward(Tensor grad, Tensor mask) -> Tensor
TORCH_API inline at::Tensor fake_quantize_per_channel_affine_cachemask_backward(const at::Tensor & grad, const at::Tensor & mask) {
    return at::_ops::fake_quantize_per_channel_affine_cachemask_backward::call(grad, mask);
}

// aten::_fake_quantize_learnable_per_channel_affine(Tensor self, Tensor scale, Tensor zero_point, int axis, int quant_min, int quant_max, float grad_factor=1.0) -> Tensor
TORCH_API inline at::Tensor _fake_quantize_learnable_per_channel_affine(const at::Tensor & self, const at::Tensor & scale, const at::Tensor & zero_point, int64_t axis, int64_t quant_min, int64_t quant_max, double grad_factor=1.0) {
    return at::_ops::_fake_quantize_learnable_per_channel_affine::call(self, scale, zero_point, axis, quant_min, quant_max, grad_factor);
}

// aten::_fake_quantize_learnable_per_channel_affine_backward(Tensor grad, Tensor self, Tensor scale, Tensor zero_point, int axis, int quant_min, int quant_max, float grad_factor=1.0) -> (Tensor, Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor,at::Tensor> _fake_quantize_learnable_per_channel_affine_backward(const at::Tensor & grad, const at::Tensor & self, const at::Tensor & scale, const at::Tensor & zero_point, int64_t axis, int64_t quant_min, int64_t quant_max, double grad_factor=1.0) {
    return at::_ops::_fake_quantize_learnable_per_channel_affine_backward::call(grad, self, scale, zero_point, axis, quant_min, quant_max, grad_factor);
}

// aten::fused_moving_avg_obs_fake_quant(Tensor self, Tensor observer_on, Tensor fake_quant_on, Tensor(a!) running_min, Tensor(b!) running_max, Tensor(c!) scale, Tensor(d!) zero_point, float averaging_const, int quant_min, int quant_max, int ch_axis, bool per_row_fake_quant=False, bool symmetric_quant=False) -> Tensor
TORCH_API inline at::Tensor fused_moving_avg_obs_fake_quant(const at::Tensor & self, const at::Tensor & observer_on, const at::Tensor & fake_quant_on, at::Tensor & running_min, at::Tensor & running_max, at::Tensor & scale, at::Tensor & zero_point, double averaging_const, int64_t quant_min, int64_t quant_max, int64_t ch_axis, bool per_row_fake_quant=false, bool symmetric_quant=false) {
    return at::_ops::fused_moving_avg_obs_fake_quant::call(self, observer_on, fake_quant_on, running_min, running_max, scale, zero_point, averaging_const, quant_min, quant_max, ch_axis, per_row_fake_quant, symmetric_quant);
}

// aten::_fused_moving_avg_obs_fq_helper(Tensor self, Tensor observer_on, Tensor fake_quant_on, Tensor(a!) running_min, Tensor(b!) running_max, Tensor(c!) scale, Tensor(d!) zero_point, float averaging_const, int quant_min, int quant_max, int ch_axis, bool per_row_fake_quant=False, bool symmetric_quant=False) -> (Tensor output, Tensor mask)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> _fused_moving_avg_obs_fq_helper(const at::Tensor & self, const at::Tensor & observer_on, const at::Tensor & fake_quant_on, at::Tensor & running_min, at::Tensor & running_max, at::Tensor & scale, at::Tensor & zero_point, double averaging_const, int64_t quant_min, int64_t quant_max, int64_t ch_axis, bool per_row_fake_quant=false, bool symmetric_quant=false) {
    return at::_ops::_fused_moving_avg_obs_fq_helper::call(self, observer_on, fake_quant_on, running_min, running_max, scale, zero_point, averaging_const, quant_min, quant_max, ch_axis, per_row_fake_quant, symmetric_quant);
}

// aten::_choose_qparams_per_tensor(Tensor self, bool reduce_range=False) -> (float, int)
TORCH_API inline ::std::tuple<double,int64_t> _choose_qparams_per_tensor(const at::Tensor & self, bool reduce_range=false) {
    return at::_ops::_choose_qparams_per_tensor::call(self, reduce_range);
}

// aten::_saturate_weight_to_fp16(Tensor weight) -> Tensor
TORCH_API inline at::Tensor _saturate_weight_to_fp16(const at::Tensor & weight) {
    return at::_ops::_saturate_weight_to_fp16::call(weight);
}

// aten::choose_qparams_optimized(Tensor input, int numel, int n_bins, float ratio, int bit_width) -> (Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> choose_qparams_optimized(const at::Tensor & input, int64_t numel, int64_t n_bins, double ratio, int64_t bit_width) {
    return at::_ops::choose_qparams_optimized::call(input, numel, n_bins, ratio, bit_width);
}

// aten::_to_copy(Tensor self, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None, bool non_blocking=False, MemoryFormat? memory_format=None) -> Tensor
TORCH_API inline at::Tensor _to_copy(const at::Tensor & self, at::TensorOptions options={}, bool non_blocking=false, c10::optional<at::MemoryFormat> memory_format=c10::nullopt) {
    return at::_ops::_to_copy::call(self, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt(), non_blocking, c10::impl::check_tensor_options_and_extract_memory_format(options, memory_format));
}

// aten::_to_copy(Tensor self, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None, bool non_blocking=False, MemoryFormat? memory_format=None) -> Tensor
TORCH_API inline at::Tensor _to_copy(const at::Tensor & self, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory, bool non_blocking, c10::optional<at::MemoryFormat> memory_format) {
    return at::_ops::_to_copy::call(self, dtype, layout, device, pin_memory, non_blocking, memory_format);
}

// aten::meshgrid(Tensor[] tensors) -> Tensor[]
TORCH_API inline ::std::vector<at::Tensor> meshgrid(at::TensorList tensors) {
    return at::_ops::meshgrid::call(tensors);
}

// aten::meshgrid.indexing(Tensor[] tensors, *, str indexing) -> Tensor[]
TORCH_API inline ::std::vector<at::Tensor> meshgrid(at::TensorList tensors, c10::string_view indexing) {
    return at::_ops::meshgrid_indexing::call(tensors, indexing);
}

// aten::cartesian_prod(Tensor[] tensors) -> Tensor
TORCH_API inline at::Tensor cartesian_prod(at::TensorList tensors) {
    return at::_ops::cartesian_prod::call(tensors);
}

// aten::combinations(Tensor self, int r=2, bool with_replacement=False) -> Tensor
TORCH_API inline at::Tensor combinations(const at::Tensor & self, int64_t r=2, bool with_replacement=false) {
    return at::_ops::combinations::call(self, r, with_replacement);
}

// aten::result_type.Tensor(Tensor tensor, Tensor other) -> ScalarType
TORCH_API inline at::ScalarType result_type(const at::Tensor & tensor, const at::Tensor & other) {
    return at::_ops::result_type_Tensor::call(tensor, other);
}

// aten::result_type.Scalar(Tensor tensor, Scalar other) -> ScalarType
TORCH_API inline at::ScalarType result_type(const at::Tensor & tensor, const at::Scalar & other) {
    return at::_ops::result_type_Scalar::call(tensor, other);
}

// aten::result_type.Scalar_Tensor(Scalar scalar, Tensor tensor) -> ScalarType
TORCH_API inline at::ScalarType result_type(const at::Scalar & scalar, const at::Tensor & tensor) {
    return at::_ops::result_type_Scalar_Tensor::call(scalar, tensor);
}

// aten::result_type.Scalar_Scalar(Scalar scalar1, Scalar scalar2) -> ScalarType
TORCH_API inline at::ScalarType result_type(const at::Scalar & scalar1, const at::Scalar & scalar2) {
    return at::_ops::result_type_Scalar_Scalar::call(scalar1, scalar2);
}

// aten::can_cast(ScalarType from, ScalarType to) -> bool
TORCH_API inline bool can_cast(at::ScalarType from, at::ScalarType to) {
    return at::_ops::can_cast::call(from, to);
}

// aten::promote_types(ScalarType type1, ScalarType type2) -> ScalarType
TORCH_API inline at::ScalarType promote_types(at::ScalarType type1, at::ScalarType type2) {
    return at::_ops::promote_types::call(type1, type2);
}

// aten::_local_scalar_dense(Tensor self) -> Scalar
TORCH_API inline at::Scalar _local_scalar_dense(const at::Tensor & self) {
    return at::_ops::_local_scalar_dense::call(self);
}

// aten::_thnn_fused_lstm_cell(Tensor input_gates, Tensor hidden_gates, Tensor cx, Tensor? input_bias=None, Tensor? hidden_bias=None) -> (Tensor, Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor,at::Tensor> _thnn_fused_lstm_cell(const at::Tensor & input_gates, const at::Tensor & hidden_gates, const at::Tensor & cx, const c10::optional<at::Tensor> & input_bias={}, const c10::optional<at::Tensor> & hidden_bias={}) {
    return at::_ops::_thnn_fused_lstm_cell::call(input_gates, hidden_gates, cx, input_bias, hidden_bias);
}

// aten::_thnn_fused_lstm_cell_backward(Tensor? grad_hy, Tensor? grad_cy, Tensor cx, Tensor cy, Tensor workspace, bool has_bias) -> (Tensor, Tensor, Tensor, Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor,at::Tensor,at::Tensor,at::Tensor> _thnn_fused_lstm_cell_backward(const c10::optional<at::Tensor> & grad_hy, const c10::optional<at::Tensor> & grad_cy, const at::Tensor & cx, const at::Tensor & cy, const at::Tensor & workspace, bool has_bias) {
    return at::_ops::_thnn_fused_lstm_cell_backward::call(grad_hy, grad_cy, cx, cy, workspace, has_bias);
}

// aten::_thnn_differentiable_lstm_cell_backward(Tensor? grad_hy, Tensor? grad_cy, Tensor input_gates, Tensor hidden_gates, Tensor? input_bias, Tensor? hidden_bias, Tensor cx, Tensor cy) -> (Tensor, Tensor, Tensor, Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor,at::Tensor,at::Tensor,at::Tensor> _thnn_differentiable_lstm_cell_backward(const c10::optional<at::Tensor> & grad_hy, const c10::optional<at::Tensor> & grad_cy, const at::Tensor & input_gates, const at::Tensor & hidden_gates, const c10::optional<at::Tensor> & input_bias, const c10::optional<at::Tensor> & hidden_bias, const at::Tensor & cx, const at::Tensor & cy) {
    return at::_ops::_thnn_differentiable_lstm_cell_backward::call(grad_hy, grad_cy, input_gates, hidden_gates, input_bias, hidden_bias, cx, cy);
}

// aten::_thnn_fused_gru_cell(Tensor input_gates, Tensor hidden_gates, Tensor hx, Tensor? input_bias=None, Tensor? hidden_bias=None) -> (Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> _thnn_fused_gru_cell(const at::Tensor & input_gates, const at::Tensor & hidden_gates, const at::Tensor & hx, const c10::optional<at::Tensor> & input_bias={}, const c10::optional<at::Tensor> & hidden_bias={}) {
    return at::_ops::_thnn_fused_gru_cell::call(input_gates, hidden_gates, hx, input_bias, hidden_bias);
}

// aten::_thnn_fused_gru_cell_backward(Tensor grad_hy, Tensor workspace, bool has_bias) -> (Tensor, Tensor, Tensor, Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor,at::Tensor,at::Tensor,at::Tensor> _thnn_fused_gru_cell_backward(const at::Tensor & grad_hy, const at::Tensor & workspace, bool has_bias) {
    return at::_ops::_thnn_fused_gru_cell_backward::call(grad_hy, workspace, has_bias);
}

// aten::_thnn_differentiable_gru_cell_backward(Tensor grad_hy, Tensor input_gates, Tensor hidden_gates, Tensor hx, Tensor? input_bias, Tensor? hidden_bias) -> (Tensor, Tensor, Tensor, Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor,at::Tensor,at::Tensor,at::Tensor> _thnn_differentiable_gru_cell_backward(const at::Tensor & grad_hy, const at::Tensor & input_gates, const at::Tensor & hidden_gates, const at::Tensor & hx, const c10::optional<at::Tensor> & input_bias, const c10::optional<at::Tensor> & hidden_bias) {
    return at::_ops::_thnn_differentiable_gru_cell_backward::call(grad_hy, input_gates, hidden_gates, hx, input_bias, hidden_bias);
}

// aten::lstm.input(Tensor input, Tensor[] hx, Tensor[] params, bool has_biases, int num_layers, float dropout, bool train, bool bidirectional, bool batch_first) -> (Tensor, Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor,at::Tensor> lstm(const at::Tensor & input, at::TensorList hx, at::TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional, bool batch_first) {
    return at::_ops::lstm_input::call(input, hx, params, has_biases, num_layers, dropout, train, bidirectional, batch_first);
}

// aten::lstm.data(Tensor data, Tensor batch_sizes, Tensor[] hx, Tensor[] params, bool has_biases, int num_layers, float dropout, bool train, bool bidirectional) -> (Tensor, Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor,at::Tensor> lstm(const at::Tensor & data, const at::Tensor & batch_sizes, at::TensorList hx, at::TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional) {
    return at::_ops::lstm_data::call(data, batch_sizes, hx, params, has_biases, num_layers, dropout, train, bidirectional);
}

// aten::gru.input(Tensor input, Tensor hx, Tensor[] params, bool has_biases, int num_layers, float dropout, bool train, bool bidirectional, bool batch_first) -> (Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> gru(const at::Tensor & input, const at::Tensor & hx, at::TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional, bool batch_first) {
    return at::_ops::gru_input::call(input, hx, params, has_biases, num_layers, dropout, train, bidirectional, batch_first);
}

// aten::gru.data(Tensor data, Tensor batch_sizes, Tensor hx, Tensor[] params, bool has_biases, int num_layers, float dropout, bool train, bool bidirectional) -> (Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> gru(const at::Tensor & data, const at::Tensor & batch_sizes, const at::Tensor & hx, at::TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional) {
    return at::_ops::gru_data::call(data, batch_sizes, hx, params, has_biases, num_layers, dropout, train, bidirectional);
}

// aten::rnn_tanh.input(Tensor input, Tensor hx, Tensor[] params, bool has_biases, int num_layers, float dropout, bool train, bool bidirectional, bool batch_first) -> (Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> rnn_tanh(const at::Tensor & input, const at::Tensor & hx, at::TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional, bool batch_first) {
    return at::_ops::rnn_tanh_input::call(input, hx, params, has_biases, num_layers, dropout, train, bidirectional, batch_first);
}

// aten::rnn_tanh.data(Tensor data, Tensor batch_sizes, Tensor hx, Tensor[] params, bool has_biases, int num_layers, float dropout, bool train, bool bidirectional) -> (Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> rnn_tanh(const at::Tensor & data, const at::Tensor & batch_sizes, const at::Tensor & hx, at::TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional) {
    return at::_ops::rnn_tanh_data::call(data, batch_sizes, hx, params, has_biases, num_layers, dropout, train, bidirectional);
}

// aten::rnn_relu.input(Tensor input, Tensor hx, Tensor[] params, bool has_biases, int num_layers, float dropout, bool train, bool bidirectional, bool batch_first) -> (Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> rnn_relu(const at::Tensor & input, const at::Tensor & hx, at::TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional, bool batch_first) {
    return at::_ops::rnn_relu_input::call(input, hx, params, has_biases, num_layers, dropout, train, bidirectional, batch_first);
}

// aten::rnn_relu.data(Tensor data, Tensor batch_sizes, Tensor hx, Tensor[] params, bool has_biases, int num_layers, float dropout, bool train, bool bidirectional) -> (Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> rnn_relu(const at::Tensor & data, const at::Tensor & batch_sizes, const at::Tensor & hx, at::TensorList params, bool has_biases, int64_t num_layers, double dropout, bool train, bool bidirectional) {
    return at::_ops::rnn_relu_data::call(data, batch_sizes, hx, params, has_biases, num_layers, dropout, train, bidirectional);
}

// aten::lstm_cell(Tensor input, Tensor[] hx, Tensor w_ih, Tensor w_hh, Tensor? b_ih=None, Tensor? b_hh=None) -> (Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> lstm_cell(const at::Tensor & input, at::TensorList hx, const at::Tensor & w_ih, const at::Tensor & w_hh, const c10::optional<at::Tensor> & b_ih={}, const c10::optional<at::Tensor> & b_hh={}) {
    return at::_ops::lstm_cell::call(input, hx, w_ih, w_hh, b_ih, b_hh);
}

// aten::gru_cell(Tensor input, Tensor hx, Tensor w_ih, Tensor w_hh, Tensor? b_ih=None, Tensor? b_hh=None) -> Tensor
TORCH_API inline at::Tensor gru_cell(const at::Tensor & input, const at::Tensor & hx, const at::Tensor & w_ih, const at::Tensor & w_hh, const c10::optional<at::Tensor> & b_ih={}, const c10::optional<at::Tensor> & b_hh={}) {
    return at::_ops::gru_cell::call(input, hx, w_ih, w_hh, b_ih, b_hh);
}

// aten::rnn_tanh_cell(Tensor input, Tensor hx, Tensor w_ih, Tensor w_hh, Tensor? b_ih=None, Tensor? b_hh=None) -> Tensor
TORCH_API inline at::Tensor rnn_tanh_cell(const at::Tensor & input, const at::Tensor & hx, const at::Tensor & w_ih, const at::Tensor & w_hh, const c10::optional<at::Tensor> & b_ih={}, const c10::optional<at::Tensor> & b_hh={}) {
    return at::_ops::rnn_tanh_cell::call(input, hx, w_ih, w_hh, b_ih, b_hh);
}

// aten::rnn_relu_cell(Tensor input, Tensor hx, Tensor w_ih, Tensor w_hh, Tensor? b_ih=None, Tensor? b_hh=None) -> Tensor
TORCH_API inline at::Tensor rnn_relu_cell(const at::Tensor & input, const at::Tensor & hx, const at::Tensor & w_ih, const at::Tensor & w_hh, const c10::optional<at::Tensor> & b_ih={}, const c10::optional<at::Tensor> & b_hh={}) {
    return at::_ops::rnn_relu_cell::call(input, hx, w_ih, w_hh, b_ih, b_hh);
}

// aten::quantized_lstm_cell(Tensor input, Tensor[] hx, Tensor w_ih, Tensor w_hh, Tensor b_ih, Tensor b_hh, Tensor packed_ih, Tensor packed_hh, Tensor col_offsets_ih, Tensor col_offsets_hh, Scalar scale_ih, Scalar scale_hh, Scalar zero_point_ih, Scalar zero_point_hh) -> (Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> quantized_lstm_cell(const at::Tensor & input, at::TensorList hx, const at::Tensor & w_ih, const at::Tensor & w_hh, const at::Tensor & b_ih, const at::Tensor & b_hh, const at::Tensor & packed_ih, const at::Tensor & packed_hh, const at::Tensor & col_offsets_ih, const at::Tensor & col_offsets_hh, const at::Scalar & scale_ih, const at::Scalar & scale_hh, const at::Scalar & zero_point_ih, const at::Scalar & zero_point_hh) {
    return at::_ops::quantized_lstm_cell::call(input, hx, w_ih, w_hh, b_ih, b_hh, packed_ih, packed_hh, col_offsets_ih, col_offsets_hh, scale_ih, scale_hh, zero_point_ih, zero_point_hh);
}

// aten::quantized_gru_cell(Tensor input, Tensor hx, Tensor w_ih, Tensor w_hh, Tensor b_ih, Tensor b_hh, Tensor packed_ih, Tensor packed_hh, Tensor col_offsets_ih, Tensor col_offsets_hh, Scalar scale_ih, Scalar scale_hh, Scalar zero_point_ih, Scalar zero_point_hh) -> Tensor
TORCH_API inline at::Tensor quantized_gru_cell(const at::Tensor & input, const at::Tensor & hx, const at::Tensor & w_ih, const at::Tensor & w_hh, const at::Tensor & b_ih, const at::Tensor & b_hh, const at::Tensor & packed_ih, const at::Tensor & packed_hh, const at::Tensor & col_offsets_ih, const at::Tensor & col_offsets_hh, const at::Scalar & scale_ih, const at::Scalar & scale_hh, const at::Scalar & zero_point_ih, const at::Scalar & zero_point_hh) {
    return at::_ops::quantized_gru_cell::call(input, hx, w_ih, w_hh, b_ih, b_hh, packed_ih, packed_hh, col_offsets_ih, col_offsets_hh, scale_ih, scale_hh, zero_point_ih, zero_point_hh);
}

// aten::quantized_rnn_relu_cell(Tensor input, Tensor hx, Tensor w_ih, Tensor w_hh, Tensor b_ih, Tensor b_hh, Tensor packed_ih, Tensor packed_hh, Tensor col_offsets_ih, Tensor col_offsets_hh, Scalar scale_ih, Scalar scale_hh, Scalar zero_point_ih, Scalar zero_point_hh) -> Tensor
TORCH_API inline at::Tensor quantized_rnn_relu_cell(const at::Tensor & input, const at::Tensor & hx, const at::Tensor & w_ih, const at::Tensor & w_hh, const at::Tensor & b_ih, const at::Tensor & b_hh, const at::Tensor & packed_ih, const at::Tensor & packed_hh, const at::Tensor & col_offsets_ih, const at::Tensor & col_offsets_hh, const at::Scalar & scale_ih, const at::Scalar & scale_hh, const at::Scalar & zero_point_ih, const at::Scalar & zero_point_hh) {
    return at::_ops::quantized_rnn_relu_cell::call(input, hx, w_ih, w_hh, b_ih, b_hh, packed_ih, packed_hh, col_offsets_ih, col_offsets_hh, scale_ih, scale_hh, zero_point_ih, zero_point_hh);
}

// aten::quantized_rnn_tanh_cell(Tensor input, Tensor hx, Tensor w_ih, Tensor w_hh, Tensor b_ih, Tensor b_hh, Tensor packed_ih, Tensor packed_hh, Tensor col_offsets_ih, Tensor col_offsets_hh, Scalar scale_ih, Scalar scale_hh, Scalar zero_point_ih, Scalar zero_point_hh) -> Tensor
TORCH_API inline at::Tensor quantized_rnn_tanh_cell(const at::Tensor & input, const at::Tensor & hx, const at::Tensor & w_ih, const at::Tensor & w_hh, const at::Tensor & b_ih, const at::Tensor & b_hh, const at::Tensor & packed_ih, const at::Tensor & packed_hh, const at::Tensor & col_offsets_ih, const at::Tensor & col_offsets_hh, const at::Scalar & scale_ih, const at::Scalar & scale_hh, const at::Scalar & zero_point_ih, const at::Scalar & zero_point_hh) {
    return at::_ops::quantized_rnn_tanh_cell::call(input, hx, w_ih, w_hh, b_ih, b_hh, packed_ih, packed_hh, col_offsets_ih, col_offsets_hh, scale_ih, scale_hh, zero_point_ih, zero_point_hh);
}

// aten::_pack_padded_sequence(Tensor input, Tensor lengths, bool batch_first) -> (Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> _pack_padded_sequence(const at::Tensor & input, const at::Tensor & lengths, bool batch_first) {
    return at::_ops::_pack_padded_sequence::call(input, lengths, batch_first);
}

// aten::_pack_padded_sequence_backward(Tensor grad, int[] input_size, Tensor batch_sizes, bool batch_first) -> Tensor
TORCH_API inline at::Tensor _pack_padded_sequence_backward(const at::Tensor & grad, at::IntArrayRef input_size, const at::Tensor & batch_sizes, bool batch_first) {
    return at::_ops::_pack_padded_sequence_backward::call(grad, input_size, batch_sizes, batch_first);
}

// aten::_pad_packed_sequence(Tensor data, Tensor batch_sizes, bool batch_first, Scalar padding_value, int total_length) -> (Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> _pad_packed_sequence(const at::Tensor & data, const at::Tensor & batch_sizes, bool batch_first, const at::Scalar & padding_value, int64_t total_length) {
    return at::_ops::_pad_packed_sequence::call(data, batch_sizes, batch_first, padding_value, total_length);
}

// aten::masked_fill.Scalar(Tensor self, Tensor mask, Scalar value) -> Tensor
TORCH_API inline at::Tensor masked_fill(const at::Tensor & self, const at::Tensor & mask, const at::Scalar & value) {
    return at::_ops::masked_fill_Scalar::call(self, mask, value);
}

// aten::masked_fill.Tensor(Tensor self, Tensor mask, Tensor value) -> Tensor
TORCH_API inline at::Tensor masked_fill(const at::Tensor & self, const at::Tensor & mask, const at::Tensor & value) {
    return at::_ops::masked_fill_Tensor::call(self, mask, value);
}

// aten::masked_scatter(Tensor self, Tensor mask, Tensor source) -> Tensor
TORCH_API inline at::Tensor masked_scatter(const at::Tensor & self, const at::Tensor & mask, const at::Tensor & source) {
    return at::_ops::masked_scatter::call(self, mask, source);
}

// aten::put(Tensor self, Tensor index, Tensor source, bool accumulate=False) -> Tensor
TORCH_API inline at::Tensor put(const at::Tensor & self, const at::Tensor & index, const at::Tensor & source, bool accumulate=false) {
    return at::_ops::put::call(self, index, source, accumulate);
}

// aten::index_add(Tensor self, int dim, Tensor index, Tensor source) -> Tensor
TORCH_API inline at::Tensor index_add(const at::Tensor & self, int64_t dim, const at::Tensor & index, const at::Tensor & source) {
    return at::_ops::index_add::call(self, dim, index, source);
}

// aten::index_add.alpha(Tensor self, int dim, Tensor index, Tensor source, *, Scalar alpha) -> Tensor
TORCH_API inline at::Tensor index_add(const at::Tensor & self, int64_t dim, const at::Tensor & index, const at::Tensor & source, const at::Scalar & alpha) {
    return at::_ops::index_add_alpha::call(self, dim, index, source, alpha);
}

// aten::index_add.dimname(Tensor self, Dimname dim, Tensor index, Tensor source, *, Scalar alpha=1) -> Tensor
TORCH_API inline at::Tensor index_add(const at::Tensor & self, at::Dimname dim, const at::Tensor & index, const at::Tensor & source, const at::Scalar & alpha=1) {
    return at::_ops::index_add_dimname::call(self, dim, index, source, alpha);
}

// aten::index_fill.int_Scalar(Tensor self, int dim, Tensor index, Scalar value) -> Tensor
TORCH_API inline at::Tensor index_fill(const at::Tensor & self, int64_t dim, const at::Tensor & index, const at::Scalar & value) {
    return at::_ops::index_fill_int_Scalar::call(self, dim, index, value);
}

// aten::index_fill.int_Tensor(Tensor self, int dim, Tensor index, Tensor value) -> Tensor
TORCH_API inline at::Tensor index_fill(const at::Tensor & self, int64_t dim, const at::Tensor & index, const at::Tensor & value) {
    return at::_ops::index_fill_int_Tensor::call(self, dim, index, value);
}

// aten::index_fill.Dimname_Scalar(Tensor self, Dimname dim, Tensor index, Scalar value) -> Tensor
TORCH_API inline at::Tensor index_fill(const at::Tensor & self, at::Dimname dim, const at::Tensor & index, const at::Scalar & value) {
    return at::_ops::index_fill_Dimname_Scalar::call(self, dim, index, value);
}

// aten::index_fill.Dimname_Tensor(Tensor self, Dimname dim, Tensor index, Tensor value) -> Tensor
TORCH_API inline at::Tensor index_fill(const at::Tensor & self, at::Dimname dim, const at::Tensor & index, const at::Tensor & value) {
    return at::_ops::index_fill_Dimname_Tensor::call(self, dim, index, value);
}

// aten::scatter.src(Tensor self, int dim, Tensor index, Tensor src) -> Tensor
TORCH_API inline at::Tensor scatter(const at::Tensor & self, int64_t dim, const at::Tensor & index, const at::Tensor & src) {
    return at::_ops::scatter_src::call(self, dim, index, src);
}

// aten::scatter.src_out(Tensor self, int dim, Tensor index, Tensor src, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & scatter_out(at::Tensor & out, const at::Tensor & self, int64_t dim, const at::Tensor & index, const at::Tensor & src) {
    return at::_ops::scatter_src_out::call(self, dim, index, src, out);
}

// aten::scatter.src_out(Tensor self, int dim, Tensor index, Tensor src, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & scatter_outf(const at::Tensor & self, int64_t dim, const at::Tensor & index, const at::Tensor & src, at::Tensor & out) {
    return at::_ops::scatter_src_out::call(self, dim, index, src, out);
}

// aten::scatter.value(Tensor self, int dim, Tensor index, Scalar value) -> Tensor
TORCH_API inline at::Tensor scatter(const at::Tensor & self, int64_t dim, const at::Tensor & index, const at::Scalar & value) {
    return at::_ops::scatter_value::call(self, dim, index, value);
}

// aten::scatter.value_out(Tensor self, int dim, Tensor index, Scalar value, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & scatter_out(at::Tensor & out, const at::Tensor & self, int64_t dim, const at::Tensor & index, const at::Scalar & value) {
    return at::_ops::scatter_value_out::call(self, dim, index, value, out);
}

// aten::scatter.value_out(Tensor self, int dim, Tensor index, Scalar value, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & scatter_outf(const at::Tensor & self, int64_t dim, const at::Tensor & index, const at::Scalar & value, at::Tensor & out) {
    return at::_ops::scatter_value_out::call(self, dim, index, value, out);
}

// aten::scatter.reduce(Tensor self, int dim, Tensor index, Tensor src, *, str reduce) -> Tensor
TORCH_API inline at::Tensor scatter(const at::Tensor & self, int64_t dim, const at::Tensor & index, const at::Tensor & src, c10::string_view reduce) {
    return at::_ops::scatter_reduce::call(self, dim, index, src, reduce);
}

// aten::scatter.reduce_out(Tensor self, int dim, Tensor index, Tensor src, *, str reduce, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & scatter_out(at::Tensor & out, const at::Tensor & self, int64_t dim, const at::Tensor & index, const at::Tensor & src, c10::string_view reduce) {
    return at::_ops::scatter_reduce_out::call(self, dim, index, src, reduce, out);
}

// aten::scatter.reduce_out(Tensor self, int dim, Tensor index, Tensor src, *, str reduce, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & scatter_outf(const at::Tensor & self, int64_t dim, const at::Tensor & index, const at::Tensor & src, c10::string_view reduce, at::Tensor & out) {
    return at::_ops::scatter_reduce_out::call(self, dim, index, src, reduce, out);
}

// aten::scatter.value_reduce(Tensor self, int dim, Tensor index, Scalar value, *, str reduce) -> Tensor
TORCH_API inline at::Tensor scatter(const at::Tensor & self, int64_t dim, const at::Tensor & index, const at::Scalar & value, c10::string_view reduce) {
    return at::_ops::scatter_value_reduce::call(self, dim, index, value, reduce);
}

// aten::scatter.value_reduce_out(Tensor self, int dim, Tensor index, Scalar value, *, str reduce, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & scatter_out(at::Tensor & out, const at::Tensor & self, int64_t dim, const at::Tensor & index, const at::Scalar & value, c10::string_view reduce) {
    return at::_ops::scatter_value_reduce_out::call(self, dim, index, value, reduce, out);
}

// aten::scatter.value_reduce_out(Tensor self, int dim, Tensor index, Scalar value, *, str reduce, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & scatter_outf(const at::Tensor & self, int64_t dim, const at::Tensor & index, const at::Scalar & value, c10::string_view reduce, at::Tensor & out) {
    return at::_ops::scatter_value_reduce_out::call(self, dim, index, value, reduce, out);
}

// aten::scatter.dimname_src(Tensor self, Dimname dim, Tensor index, Tensor src) -> Tensor
TORCH_API inline at::Tensor scatter(const at::Tensor & self, at::Dimname dim, const at::Tensor & index, const at::Tensor & src) {
    return at::_ops::scatter_dimname_src::call(self, dim, index, src);
}

// aten::scatter.dimname_value(Tensor self, Dimname dim, Tensor index, Scalar value) -> Tensor
TORCH_API inline at::Tensor scatter(const at::Tensor & self, at::Dimname dim, const at::Tensor & index, const at::Scalar & value) {
    return at::_ops::scatter_dimname_value::call(self, dim, index, value);
}

// aten::scatter_add(Tensor self, int dim, Tensor index, Tensor src) -> Tensor
TORCH_API inline at::Tensor scatter_add(const at::Tensor & self, int64_t dim, const at::Tensor & index, const at::Tensor & src) {
    return at::_ops::scatter_add::call(self, dim, index, src);
}

// aten::scatter_add.out(Tensor self, int dim, Tensor index, Tensor src, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & scatter_add_out(at::Tensor & out, const at::Tensor & self, int64_t dim, const at::Tensor & index, const at::Tensor & src) {
    return at::_ops::scatter_add_out::call(self, dim, index, src, out);
}

// aten::scatter_add.out(Tensor self, int dim, Tensor index, Tensor src, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & scatter_add_outf(const at::Tensor & self, int64_t dim, const at::Tensor & index, const at::Tensor & src, at::Tensor & out) {
    return at::_ops::scatter_add_out::call(self, dim, index, src, out);
}

// aten::scatter_add.dimname(Tensor self, Dimname dim, Tensor index, Tensor src) -> Tensor
TORCH_API inline at::Tensor scatter_add(const at::Tensor & self, at::Dimname dim, const at::Tensor & index, const at::Tensor & src) {
    return at::_ops::scatter_add_dimname::call(self, dim, index, src);
}

// aten::bitwise_and.Tensor_out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & bitwise_and_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::bitwise_and_Tensor_out::call(self, other, out);
}

// aten::bitwise_and.Tensor_out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & bitwise_and_outf(const at::Tensor & self, const at::Tensor & other, at::Tensor & out) {
    return at::_ops::bitwise_and_Tensor_out::call(self, other, out);
}

// aten::bitwise_and.Scalar_out(Tensor self, Scalar other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & bitwise_and_out(at::Tensor & out, const at::Tensor & self, const at::Scalar & other) {
    return at::_ops::bitwise_and_Scalar_out::call(self, other, out);
}

// aten::bitwise_and.Scalar_out(Tensor self, Scalar other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & bitwise_and_outf(const at::Tensor & self, const at::Scalar & other, at::Tensor & out) {
    return at::_ops::bitwise_and_Scalar_out::call(self, other, out);
}

// aten::bitwise_and.Scalar(Tensor self, Scalar other) -> Tensor
TORCH_API inline at::Tensor bitwise_and(const at::Tensor & self, const at::Scalar & other) {
    return at::_ops::bitwise_and_Scalar::call(self, other);
}

// aten::bitwise_and.Tensor(Tensor self, Tensor other) -> Tensor
TORCH_API inline at::Tensor bitwise_and(const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::bitwise_and_Tensor::call(self, other);
}

// aten::__and__.Scalar(Tensor self, Scalar other) -> Tensor
TORCH_API inline at::Tensor __and__(const at::Tensor & self, const at::Scalar & other) {
    return at::_ops::__and___Scalar::call(self, other);
}

// aten::__and__.Tensor(Tensor self, Tensor other) -> Tensor
TORCH_API inline at::Tensor __and__(const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::__and___Tensor::call(self, other);
}

// aten::bitwise_or.Tensor_out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & bitwise_or_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::bitwise_or_Tensor_out::call(self, other, out);
}

// aten::bitwise_or.Tensor_out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & bitwise_or_outf(const at::Tensor & self, const at::Tensor & other, at::Tensor & out) {
    return at::_ops::bitwise_or_Tensor_out::call(self, other, out);
}

// aten::bitwise_or.Scalar_out(Tensor self, Scalar other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & bitwise_or_out(at::Tensor & out, const at::Tensor & self, const at::Scalar & other) {
    return at::_ops::bitwise_or_Scalar_out::call(self, other, out);
}

// aten::bitwise_or.Scalar_out(Tensor self, Scalar other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & bitwise_or_outf(const at::Tensor & self, const at::Scalar & other, at::Tensor & out) {
    return at::_ops::bitwise_or_Scalar_out::call(self, other, out);
}

// aten::bitwise_or.Scalar(Tensor self, Scalar other) -> Tensor
TORCH_API inline at::Tensor bitwise_or(const at::Tensor & self, const at::Scalar & other) {
    return at::_ops::bitwise_or_Scalar::call(self, other);
}

// aten::bitwise_or.Tensor(Tensor self, Tensor other) -> Tensor
TORCH_API inline at::Tensor bitwise_or(const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::bitwise_or_Tensor::call(self, other);
}

// aten::__or__.Scalar(Tensor self, Scalar other) -> Tensor
TORCH_API inline at::Tensor __or__(const at::Tensor & self, const at::Scalar & other) {
    return at::_ops::__or___Scalar::call(self, other);
}

// aten::__or__.Tensor(Tensor self, Tensor other) -> Tensor
TORCH_API inline at::Tensor __or__(const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::__or___Tensor::call(self, other);
}

// aten::bitwise_xor.Tensor_out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & bitwise_xor_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::bitwise_xor_Tensor_out::call(self, other, out);
}

// aten::bitwise_xor.Tensor_out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & bitwise_xor_outf(const at::Tensor & self, const at::Tensor & other, at::Tensor & out) {
    return at::_ops::bitwise_xor_Tensor_out::call(self, other, out);
}

// aten::bitwise_xor.Scalar_out(Tensor self, Scalar other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & bitwise_xor_out(at::Tensor & out, const at::Tensor & self, const at::Scalar & other) {
    return at::_ops::bitwise_xor_Scalar_out::call(self, other, out);
}

// aten::bitwise_xor.Scalar_out(Tensor self, Scalar other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & bitwise_xor_outf(const at::Tensor & self, const at::Scalar & other, at::Tensor & out) {
    return at::_ops::bitwise_xor_Scalar_out::call(self, other, out);
}

// aten::bitwise_xor.Scalar(Tensor self, Scalar other) -> Tensor
TORCH_API inline at::Tensor bitwise_xor(const at::Tensor & self, const at::Scalar & other) {
    return at::_ops::bitwise_xor_Scalar::call(self, other);
}

// aten::bitwise_xor.Tensor(Tensor self, Tensor other) -> Tensor
TORCH_API inline at::Tensor bitwise_xor(const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::bitwise_xor_Tensor::call(self, other);
}

// aten::__xor__.Scalar(Tensor self, Scalar other) -> Tensor
TORCH_API inline at::Tensor __xor__(const at::Tensor & self, const at::Scalar & other) {
    return at::_ops::__xor___Scalar::call(self, other);
}

// aten::__xor__.Tensor(Tensor self, Tensor other) -> Tensor
TORCH_API inline at::Tensor __xor__(const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::__xor___Tensor::call(self, other);
}

// aten::__lshift__.Scalar(Tensor self, Scalar other) -> Tensor
TORCH_API inline at::Tensor __lshift__(const at::Tensor & self, const at::Scalar & other) {
    return at::_ops::__lshift___Scalar::call(self, other);
}

// aten::__lshift__.Tensor(Tensor self, Tensor other) -> Tensor
TORCH_API inline at::Tensor __lshift__(const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::__lshift___Tensor::call(self, other);
}

// aten::bitwise_left_shift.Tensor(Tensor self, Tensor other) -> Tensor
TORCH_API inline at::Tensor bitwise_left_shift(const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::bitwise_left_shift_Tensor::call(self, other);
}

// aten::bitwise_left_shift.Tensor_out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & bitwise_left_shift_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::bitwise_left_shift_Tensor_out::call(self, other, out);
}

// aten::bitwise_left_shift.Tensor_out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & bitwise_left_shift_outf(const at::Tensor & self, const at::Tensor & other, at::Tensor & out) {
    return at::_ops::bitwise_left_shift_Tensor_out::call(self, other, out);
}

// aten::bitwise_left_shift.Tensor_Scalar(Tensor self, Scalar other) -> Tensor
TORCH_API inline at::Tensor bitwise_left_shift(const at::Tensor & self, const at::Scalar & other) {
    return at::_ops::bitwise_left_shift_Tensor_Scalar::call(self, other);
}

// aten::bitwise_left_shift.Tensor_Scalar_out(Tensor self, Scalar other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & bitwise_left_shift_out(at::Tensor & out, const at::Tensor & self, const at::Scalar & other) {
    return at::_ops::bitwise_left_shift_Tensor_Scalar_out::call(self, other, out);
}

// aten::bitwise_left_shift.Tensor_Scalar_out(Tensor self, Scalar other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & bitwise_left_shift_outf(const at::Tensor & self, const at::Scalar & other, at::Tensor & out) {
    return at::_ops::bitwise_left_shift_Tensor_Scalar_out::call(self, other, out);
}

// aten::bitwise_left_shift.Scalar_Tensor(Scalar self, Tensor other) -> Tensor
TORCH_API inline at::Tensor bitwise_left_shift(const at::Scalar & self, const at::Tensor & other) {
    return at::_ops::bitwise_left_shift_Scalar_Tensor::call(self, other);
}

// aten::__rshift__.Scalar(Tensor self, Scalar other) -> Tensor
TORCH_API inline at::Tensor __rshift__(const at::Tensor & self, const at::Scalar & other) {
    return at::_ops::__rshift___Scalar::call(self, other);
}

// aten::__rshift__.Tensor(Tensor self, Tensor other) -> Tensor
TORCH_API inline at::Tensor __rshift__(const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::__rshift___Tensor::call(self, other);
}

// aten::bitwise_right_shift.Tensor(Tensor self, Tensor other) -> Tensor
TORCH_API inline at::Tensor bitwise_right_shift(const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::bitwise_right_shift_Tensor::call(self, other);
}

// aten::bitwise_right_shift.Tensor_out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & bitwise_right_shift_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::bitwise_right_shift_Tensor_out::call(self, other, out);
}

// aten::bitwise_right_shift.Tensor_out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & bitwise_right_shift_outf(const at::Tensor & self, const at::Tensor & other, at::Tensor & out) {
    return at::_ops::bitwise_right_shift_Tensor_out::call(self, other, out);
}

// aten::bitwise_right_shift.Tensor_Scalar(Tensor self, Scalar other) -> Tensor
TORCH_API inline at::Tensor bitwise_right_shift(const at::Tensor & self, const at::Scalar & other) {
    return at::_ops::bitwise_right_shift_Tensor_Scalar::call(self, other);
}

// aten::bitwise_right_shift.Tensor_Scalar_out(Tensor self, Scalar other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & bitwise_right_shift_out(at::Tensor & out, const at::Tensor & self, const at::Scalar & other) {
    return at::_ops::bitwise_right_shift_Tensor_Scalar_out::call(self, other, out);
}

// aten::bitwise_right_shift.Tensor_Scalar_out(Tensor self, Scalar other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & bitwise_right_shift_outf(const at::Tensor & self, const at::Scalar & other, at::Tensor & out) {
    return at::_ops::bitwise_right_shift_Tensor_Scalar_out::call(self, other, out);
}

// aten::bitwise_right_shift.Scalar_Tensor(Scalar self, Tensor other) -> Tensor
TORCH_API inline at::Tensor bitwise_right_shift(const at::Scalar & self, const at::Tensor & other) {
    return at::_ops::bitwise_right_shift_Scalar_Tensor::call(self, other);
}

// aten::addbmm.out(Tensor self, Tensor batch1, Tensor batch2, *, Scalar beta=1, Scalar alpha=1, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & addbmm_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & batch1, const at::Tensor & batch2, const at::Scalar & beta=1, const at::Scalar & alpha=1) {
    return at::_ops::addbmm_out::call(self, batch1, batch2, beta, alpha, out);
}

// aten::addbmm.out(Tensor self, Tensor batch1, Tensor batch2, *, Scalar beta=1, Scalar alpha=1, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & addbmm_outf(const at::Tensor & self, const at::Tensor & batch1, const at::Tensor & batch2, const at::Scalar & beta, const at::Scalar & alpha, at::Tensor & out) {
    return at::_ops::addbmm_out::call(self, batch1, batch2, beta, alpha, out);
}

// aten::addbmm(Tensor self, Tensor batch1, Tensor batch2, *, Scalar beta=1, Scalar alpha=1) -> Tensor
TORCH_API inline at::Tensor addbmm(const at::Tensor & self, const at::Tensor & batch1, const at::Tensor & batch2, const at::Scalar & beta=1, const at::Scalar & alpha=1) {
    return at::_ops::addbmm::call(self, batch1, batch2, beta, alpha);
}

// aten::diag.out(Tensor self, int diagonal=0, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & diag_out(at::Tensor & out, const at::Tensor & self, int64_t diagonal=0) {
    return at::_ops::diag_out::call(self, diagonal, out);
}

// aten::diag.out(Tensor self, int diagonal=0, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & diag_outf(const at::Tensor & self, int64_t diagonal, at::Tensor & out) {
    return at::_ops::diag_out::call(self, diagonal, out);
}

// aten::diag(Tensor self, int diagonal=0) -> Tensor
TORCH_API inline at::Tensor diag(const at::Tensor & self, int64_t diagonal=0) {
    return at::_ops::diag::call(self, diagonal);
}

// aten::diag_backward(Tensor grad, int[] input_sizes, int diagonal) -> Tensor
TORCH_API inline at::Tensor diag_backward(const at::Tensor & grad, at::IntArrayRef input_sizes, int64_t diagonal) {
    return at::_ops::diag_backward::call(grad, input_sizes, diagonal);
}

// aten::cross.out(Tensor self, Tensor other, int? dim=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & cross_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & other, c10::optional<int64_t> dim=c10::nullopt) {
    return at::_ops::cross_out::call(self, other, dim, out);
}

// aten::cross.out(Tensor self, Tensor other, int? dim=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & cross_outf(const at::Tensor & self, const at::Tensor & other, c10::optional<int64_t> dim, at::Tensor & out) {
    return at::_ops::cross_out::call(self, other, dim, out);
}

// aten::cross(Tensor self, Tensor other, int? dim=None) -> Tensor
TORCH_API inline at::Tensor cross(const at::Tensor & self, const at::Tensor & other, c10::optional<int64_t> dim=c10::nullopt) {
    return at::_ops::cross::call(self, other, dim);
}

// aten::triu.out(Tensor self, int diagonal=0, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & triu_out(at::Tensor & out, const at::Tensor & self, int64_t diagonal=0) {
    return at::_ops::triu_out::call(self, diagonal, out);
}

// aten::triu.out(Tensor self, int diagonal=0, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & triu_outf(const at::Tensor & self, int64_t diagonal, at::Tensor & out) {
    return at::_ops::triu_out::call(self, diagonal, out);
}

// aten::triu(Tensor self, int diagonal=0) -> Tensor
TORCH_API inline at::Tensor triu(const at::Tensor & self, int64_t diagonal=0) {
    return at::_ops::triu::call(self, diagonal);
}

// aten::tril.out(Tensor self, int diagonal=0, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & tril_out(at::Tensor & out, const at::Tensor & self, int64_t diagonal=0) {
    return at::_ops::tril_out::call(self, diagonal, out);
}

// aten::tril.out(Tensor self, int diagonal=0, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & tril_outf(const at::Tensor & self, int64_t diagonal, at::Tensor & out) {
    return at::_ops::tril_out::call(self, diagonal, out);
}

// aten::tril(Tensor self, int diagonal=0) -> Tensor
TORCH_API inline at::Tensor tril(const at::Tensor & self, int64_t diagonal=0) {
    return at::_ops::tril::call(self, diagonal);
}

// aten::tril_indices(int row, int col, int offset=0, *, ScalarType? dtype=long, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor tril_indices(int64_t row, int64_t col, int64_t offset=0, at::TensorOptions options=at::kLong) {
    return at::_ops::tril_indices::call(row, col, offset, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt());
}

// aten::tril_indices(int row, int col, int offset=0, *, ScalarType? dtype=long, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor tril_indices(int64_t row, int64_t col, int64_t offset, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory) {
    return at::_ops::tril_indices::call(row, col, offset, dtype, layout, device, pin_memory);
}

// aten::triu_indices(int row, int col, int offset=0, *, ScalarType? dtype=long, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor triu_indices(int64_t row, int64_t col, int64_t offset=0, at::TensorOptions options=at::kLong) {
    return at::_ops::triu_indices::call(row, col, offset, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt());
}

// aten::triu_indices(int row, int col, int offset=0, *, ScalarType? dtype=long, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor triu_indices(int64_t row, int64_t col, int64_t offset, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory) {
    return at::_ops::triu_indices::call(row, col, offset, dtype, layout, device, pin_memory);
}

// aten::trace(Tensor self) -> Tensor
TORCH_API inline at::Tensor trace(const at::Tensor & self) {
    return at::_ops::trace::call(self);
}

// aten::trace_backward(Tensor grad, int[] sizes) -> Tensor
TORCH_API inline at::Tensor trace_backward(const at::Tensor & grad, at::IntArrayRef sizes) {
    return at::_ops::trace_backward::call(grad, sizes);
}

// aten::ne.Scalar_out(Tensor self, Scalar other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & ne_out(at::Tensor & out, const at::Tensor & self, const at::Scalar & other) {
    return at::_ops::ne_Scalar_out::call(self, other, out);
}

// aten::ne.Scalar_out(Tensor self, Scalar other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & ne_outf(const at::Tensor & self, const at::Scalar & other, at::Tensor & out) {
    return at::_ops::ne_Scalar_out::call(self, other, out);
}

// aten::ne.Scalar(Tensor self, Scalar other) -> Tensor
TORCH_API inline at::Tensor ne(const at::Tensor & self, const at::Scalar & other) {
    return at::_ops::ne_Scalar::call(self, other);
}

// aten::ne.Tensor_out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & ne_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::ne_Tensor_out::call(self, other, out);
}

// aten::ne.Tensor_out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & ne_outf(const at::Tensor & self, const at::Tensor & other, at::Tensor & out) {
    return at::_ops::ne_Tensor_out::call(self, other, out);
}

// aten::ne.Tensor(Tensor self, Tensor other) -> Tensor
TORCH_API inline at::Tensor ne(const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::ne_Tensor::call(self, other);
}

// aten::not_equal.Scalar_out(Tensor self, Scalar other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & not_equal_out(at::Tensor & out, const at::Tensor & self, const at::Scalar & other) {
    return at::_ops::not_equal_Scalar_out::call(self, other, out);
}

// aten::not_equal.Scalar_out(Tensor self, Scalar other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & not_equal_outf(const at::Tensor & self, const at::Scalar & other, at::Tensor & out) {
    return at::_ops::not_equal_Scalar_out::call(self, other, out);
}

// aten::not_equal.Scalar(Tensor self, Scalar other) -> Tensor
TORCH_API inline at::Tensor not_equal(const at::Tensor & self, const at::Scalar & other) {
    return at::_ops::not_equal_Scalar::call(self, other);
}

// aten::not_equal.Tensor_out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & not_equal_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::not_equal_Tensor_out::call(self, other, out);
}

// aten::not_equal.Tensor_out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & not_equal_outf(const at::Tensor & self, const at::Tensor & other, at::Tensor & out) {
    return at::_ops::not_equal_Tensor_out::call(self, other, out);
}

// aten::not_equal.Tensor(Tensor self, Tensor other) -> Tensor
TORCH_API inline at::Tensor not_equal(const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::not_equal_Tensor::call(self, other);
}

// aten::eq.Scalar_out(Tensor self, Scalar other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & eq_out(at::Tensor & out, const at::Tensor & self, const at::Scalar & other) {
    return at::_ops::eq_Scalar_out::call(self, other, out);
}

// aten::eq.Scalar_out(Tensor self, Scalar other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & eq_outf(const at::Tensor & self, const at::Scalar & other, at::Tensor & out) {
    return at::_ops::eq_Scalar_out::call(self, other, out);
}

// aten::eq.Scalar(Tensor self, Scalar other) -> Tensor
TORCH_API inline at::Tensor eq(const at::Tensor & self, const at::Scalar & other) {
    return at::_ops::eq_Scalar::call(self, other);
}

// aten::eq.Tensor_out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & eq_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::eq_Tensor_out::call(self, other, out);
}

// aten::eq.Tensor_out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & eq_outf(const at::Tensor & self, const at::Tensor & other, at::Tensor & out) {
    return at::_ops::eq_Tensor_out::call(self, other, out);
}

// aten::eq.Tensor(Tensor self, Tensor other) -> Tensor
TORCH_API inline at::Tensor eq(const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::eq_Tensor::call(self, other);
}

// aten::ge.Scalar_out(Tensor self, Scalar other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & ge_out(at::Tensor & out, const at::Tensor & self, const at::Scalar & other) {
    return at::_ops::ge_Scalar_out::call(self, other, out);
}

// aten::ge.Scalar_out(Tensor self, Scalar other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & ge_outf(const at::Tensor & self, const at::Scalar & other, at::Tensor & out) {
    return at::_ops::ge_Scalar_out::call(self, other, out);
}

// aten::ge.Scalar(Tensor self, Scalar other) -> Tensor
TORCH_API inline at::Tensor ge(const at::Tensor & self, const at::Scalar & other) {
    return at::_ops::ge_Scalar::call(self, other);
}

// aten::ge.Tensor_out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & ge_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::ge_Tensor_out::call(self, other, out);
}

// aten::ge.Tensor_out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & ge_outf(const at::Tensor & self, const at::Tensor & other, at::Tensor & out) {
    return at::_ops::ge_Tensor_out::call(self, other, out);
}

// aten::ge.Tensor(Tensor self, Tensor other) -> Tensor
TORCH_API inline at::Tensor ge(const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::ge_Tensor::call(self, other);
}

// aten::greater_equal.Scalar_out(Tensor self, Scalar other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & greater_equal_out(at::Tensor & out, const at::Tensor & self, const at::Scalar & other) {
    return at::_ops::greater_equal_Scalar_out::call(self, other, out);
}

// aten::greater_equal.Scalar_out(Tensor self, Scalar other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & greater_equal_outf(const at::Tensor & self, const at::Scalar & other, at::Tensor & out) {
    return at::_ops::greater_equal_Scalar_out::call(self, other, out);
}

// aten::greater_equal.Scalar(Tensor self, Scalar other) -> Tensor
TORCH_API inline at::Tensor greater_equal(const at::Tensor & self, const at::Scalar & other) {
    return at::_ops::greater_equal_Scalar::call(self, other);
}

// aten::greater_equal.Tensor_out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & greater_equal_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::greater_equal_Tensor_out::call(self, other, out);
}

// aten::greater_equal.Tensor_out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & greater_equal_outf(const at::Tensor & self, const at::Tensor & other, at::Tensor & out) {
    return at::_ops::greater_equal_Tensor_out::call(self, other, out);
}

// aten::greater_equal.Tensor(Tensor self, Tensor other) -> Tensor
TORCH_API inline at::Tensor greater_equal(const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::greater_equal_Tensor::call(self, other);
}

// aten::le.Scalar_out(Tensor self, Scalar other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & le_out(at::Tensor & out, const at::Tensor & self, const at::Scalar & other) {
    return at::_ops::le_Scalar_out::call(self, other, out);
}

// aten::le.Scalar_out(Tensor self, Scalar other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & le_outf(const at::Tensor & self, const at::Scalar & other, at::Tensor & out) {
    return at::_ops::le_Scalar_out::call(self, other, out);
}

// aten::le.Scalar(Tensor self, Scalar other) -> Tensor
TORCH_API inline at::Tensor le(const at::Tensor & self, const at::Scalar & other) {
    return at::_ops::le_Scalar::call(self, other);
}

// aten::le.Tensor_out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & le_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::le_Tensor_out::call(self, other, out);
}

// aten::le.Tensor_out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & le_outf(const at::Tensor & self, const at::Tensor & other, at::Tensor & out) {
    return at::_ops::le_Tensor_out::call(self, other, out);
}

// aten::le.Tensor(Tensor self, Tensor other) -> Tensor
TORCH_API inline at::Tensor le(const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::le_Tensor::call(self, other);
}

// aten::less_equal.Scalar_out(Tensor self, Scalar other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & less_equal_out(at::Tensor & out, const at::Tensor & self, const at::Scalar & other) {
    return at::_ops::less_equal_Scalar_out::call(self, other, out);
}

// aten::less_equal.Scalar_out(Tensor self, Scalar other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & less_equal_outf(const at::Tensor & self, const at::Scalar & other, at::Tensor & out) {
    return at::_ops::less_equal_Scalar_out::call(self, other, out);
}

// aten::less_equal.Scalar(Tensor self, Scalar other) -> Tensor
TORCH_API inline at::Tensor less_equal(const at::Tensor & self, const at::Scalar & other) {
    return at::_ops::less_equal_Scalar::call(self, other);
}

// aten::less_equal.Tensor_out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & less_equal_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::less_equal_Tensor_out::call(self, other, out);
}

// aten::less_equal.Tensor_out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & less_equal_outf(const at::Tensor & self, const at::Tensor & other, at::Tensor & out) {
    return at::_ops::less_equal_Tensor_out::call(self, other, out);
}

// aten::less_equal.Tensor(Tensor self, Tensor other) -> Tensor
TORCH_API inline at::Tensor less_equal(const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::less_equal_Tensor::call(self, other);
}

// aten::gt.Scalar_out(Tensor self, Scalar other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & gt_out(at::Tensor & out, const at::Tensor & self, const at::Scalar & other) {
    return at::_ops::gt_Scalar_out::call(self, other, out);
}

// aten::gt.Scalar_out(Tensor self, Scalar other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & gt_outf(const at::Tensor & self, const at::Scalar & other, at::Tensor & out) {
    return at::_ops::gt_Scalar_out::call(self, other, out);
}

// aten::gt.Scalar(Tensor self, Scalar other) -> Tensor
TORCH_API inline at::Tensor gt(const at::Tensor & self, const at::Scalar & other) {
    return at::_ops::gt_Scalar::call(self, other);
}

// aten::gt.Tensor_out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & gt_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::gt_Tensor_out::call(self, other, out);
}

// aten::gt.Tensor_out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & gt_outf(const at::Tensor & self, const at::Tensor & other, at::Tensor & out) {
    return at::_ops::gt_Tensor_out::call(self, other, out);
}

// aten::gt.Tensor(Tensor self, Tensor other) -> Tensor
TORCH_API inline at::Tensor gt(const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::gt_Tensor::call(self, other);
}

// aten::greater.Scalar_out(Tensor self, Scalar other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & greater_out(at::Tensor & out, const at::Tensor & self, const at::Scalar & other) {
    return at::_ops::greater_Scalar_out::call(self, other, out);
}

// aten::greater.Scalar_out(Tensor self, Scalar other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & greater_outf(const at::Tensor & self, const at::Scalar & other, at::Tensor & out) {
    return at::_ops::greater_Scalar_out::call(self, other, out);
}

// aten::greater.Scalar(Tensor self, Scalar other) -> Tensor
TORCH_API inline at::Tensor greater(const at::Tensor & self, const at::Scalar & other) {
    return at::_ops::greater_Scalar::call(self, other);
}

// aten::greater.Tensor_out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & greater_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::greater_Tensor_out::call(self, other, out);
}

// aten::greater.Tensor_out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & greater_outf(const at::Tensor & self, const at::Tensor & other, at::Tensor & out) {
    return at::_ops::greater_Tensor_out::call(self, other, out);
}

// aten::greater.Tensor(Tensor self, Tensor other) -> Tensor
TORCH_API inline at::Tensor greater(const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::greater_Tensor::call(self, other);
}

// aten::lt.Scalar_out(Tensor self, Scalar other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & lt_out(at::Tensor & out, const at::Tensor & self, const at::Scalar & other) {
    return at::_ops::lt_Scalar_out::call(self, other, out);
}

// aten::lt.Scalar_out(Tensor self, Scalar other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & lt_outf(const at::Tensor & self, const at::Scalar & other, at::Tensor & out) {
    return at::_ops::lt_Scalar_out::call(self, other, out);
}

// aten::lt.Scalar(Tensor self, Scalar other) -> Tensor
TORCH_API inline at::Tensor lt(const at::Tensor & self, const at::Scalar & other) {
    return at::_ops::lt_Scalar::call(self, other);
}

// aten::lt.Tensor_out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & lt_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::lt_Tensor_out::call(self, other, out);
}

// aten::lt.Tensor_out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & lt_outf(const at::Tensor & self, const at::Tensor & other, at::Tensor & out) {
    return at::_ops::lt_Tensor_out::call(self, other, out);
}

// aten::lt.Tensor(Tensor self, Tensor other) -> Tensor
TORCH_API inline at::Tensor lt(const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::lt_Tensor::call(self, other);
}

// aten::less.Scalar_out(Tensor self, Scalar other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & less_out(at::Tensor & out, const at::Tensor & self, const at::Scalar & other) {
    return at::_ops::less_Scalar_out::call(self, other, out);
}

// aten::less.Scalar_out(Tensor self, Scalar other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & less_outf(const at::Tensor & self, const at::Scalar & other, at::Tensor & out) {
    return at::_ops::less_Scalar_out::call(self, other, out);
}

// aten::less.Scalar(Tensor self, Scalar other) -> Tensor
TORCH_API inline at::Tensor less(const at::Tensor & self, const at::Scalar & other) {
    return at::_ops::less_Scalar::call(self, other);
}

// aten::less.Tensor_out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & less_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::less_Tensor_out::call(self, other, out);
}

// aten::less.Tensor_out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & less_outf(const at::Tensor & self, const at::Tensor & other, at::Tensor & out) {
    return at::_ops::less_Tensor_out::call(self, other, out);
}

// aten::less.Tensor(Tensor self, Tensor other) -> Tensor
TORCH_API inline at::Tensor less(const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::less_Tensor::call(self, other);
}

// aten::take.out(Tensor self, Tensor index, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & take_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & index) {
    return at::_ops::take_out::call(self, index, out);
}

// aten::take.out(Tensor self, Tensor index, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & take_outf(const at::Tensor & self, const at::Tensor & index, at::Tensor & out) {
    return at::_ops::take_out::call(self, index, out);
}

// aten::take(Tensor self, Tensor index) -> Tensor
TORCH_API inline at::Tensor take(const at::Tensor & self, const at::Tensor & index) {
    return at::_ops::take::call(self, index);
}

// aten::take_along_dim.out(Tensor self, Tensor indices, int? dim=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & take_along_dim_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & indices, c10::optional<int64_t> dim=c10::nullopt) {
    return at::_ops::take_along_dim_out::call(self, indices, dim, out);
}

// aten::take_along_dim.out(Tensor self, Tensor indices, int? dim=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & take_along_dim_outf(const at::Tensor & self, const at::Tensor & indices, c10::optional<int64_t> dim, at::Tensor & out) {
    return at::_ops::take_along_dim_out::call(self, indices, dim, out);
}

// aten::take_along_dim(Tensor self, Tensor indices, int? dim=None) -> Tensor
TORCH_API inline at::Tensor take_along_dim(const at::Tensor & self, const at::Tensor & indices, c10::optional<int64_t> dim=c10::nullopt) {
    return at::_ops::take_along_dim::call(self, indices, dim);
}

// aten::index_select.out(Tensor self, int dim, Tensor index, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & index_select_out(at::Tensor & out, const at::Tensor & self, int64_t dim, const at::Tensor & index) {
    return at::_ops::index_select_out::call(self, dim, index, out);
}

// aten::index_select.out(Tensor self, int dim, Tensor index, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & index_select_outf(const at::Tensor & self, int64_t dim, const at::Tensor & index, at::Tensor & out) {
    return at::_ops::index_select_out::call(self, dim, index, out);
}

// aten::index_select(Tensor self, int dim, Tensor index) -> Tensor
TORCH_API inline at::Tensor index_select(const at::Tensor & self, int64_t dim, const at::Tensor & index) {
    return at::_ops::index_select::call(self, dim, index);
}

// aten::index_select.dimname_out(Tensor self, Dimname dim, Tensor index, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & index_select_out(at::Tensor & out, const at::Tensor & self, at::Dimname dim, const at::Tensor & index) {
    return at::_ops::index_select_dimname_out::call(self, dim, index, out);
}

// aten::index_select.dimname_out(Tensor self, Dimname dim, Tensor index, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & index_select_outf(const at::Tensor & self, at::Dimname dim, const at::Tensor & index, at::Tensor & out) {
    return at::_ops::index_select_dimname_out::call(self, dim, index, out);
}

// aten::index_select.dimname(Tensor self, Dimname dim, Tensor index) -> Tensor
TORCH_API inline at::Tensor index_select(const at::Tensor & self, at::Dimname dim, const at::Tensor & index) {
    return at::_ops::index_select_dimname::call(self, dim, index);
}

// aten::index_select_backward(Tensor grad, int[] self_sizes, int dim, Tensor index) -> Tensor
TORCH_API inline at::Tensor index_select_backward(const at::Tensor & grad, at::IntArrayRef self_sizes, int64_t dim, const at::Tensor & index) {
    return at::_ops::index_select_backward::call(grad, self_sizes, dim, index);
}

// aten::masked_select.out(Tensor self, Tensor mask, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & masked_select_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & mask) {
    return at::_ops::masked_select_out::call(self, mask, out);
}

// aten::masked_select.out(Tensor self, Tensor mask, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & masked_select_outf(const at::Tensor & self, const at::Tensor & mask, at::Tensor & out) {
    return at::_ops::masked_select_out::call(self, mask, out);
}

// aten::masked_select(Tensor self, Tensor mask) -> Tensor
TORCH_API inline at::Tensor masked_select(const at::Tensor & self, const at::Tensor & mask) {
    return at::_ops::masked_select::call(self, mask);
}

// aten::masked_select_backward(Tensor grad, Tensor input, Tensor mask) -> Tensor
TORCH_API inline at::Tensor masked_select_backward(const at::Tensor & grad, const at::Tensor & input, const at::Tensor & mask) {
    return at::_ops::masked_select_backward::call(grad, input, mask);
}

// aten::nonzero.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & nonzero_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::nonzero_out::call(self, out);
}

// aten::nonzero.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & nonzero_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::nonzero_out::call(self, out);
}

// aten::nonzero(Tensor self) -> Tensor
TORCH_API inline at::Tensor nonzero(const at::Tensor & self) {
    return at::_ops::nonzero::call(self);
}

// aten::nonzero_numpy(Tensor self) -> Tensor[]
TORCH_API inline ::std::vector<at::Tensor> nonzero_numpy(const at::Tensor & self) {
    return at::_ops::nonzero_numpy::call(self);
}

// aten::gather.out(Tensor self, int dim, Tensor index, *, bool sparse_grad=False, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & gather_out(at::Tensor & out, const at::Tensor & self, int64_t dim, const at::Tensor & index, bool sparse_grad=false) {
    return at::_ops::gather_out::call(self, dim, index, sparse_grad, out);
}

// aten::gather.out(Tensor self, int dim, Tensor index, *, bool sparse_grad=False, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & gather_outf(const at::Tensor & self, int64_t dim, const at::Tensor & index, bool sparse_grad, at::Tensor & out) {
    return at::_ops::gather_out::call(self, dim, index, sparse_grad, out);
}

// aten::gather(Tensor self, int dim, Tensor index, *, bool sparse_grad=False) -> Tensor
TORCH_API inline at::Tensor gather(const at::Tensor & self, int64_t dim, const at::Tensor & index, bool sparse_grad=false) {
    return at::_ops::gather::call(self, dim, index, sparse_grad);
}

// aten::gather_backward(Tensor grad, Tensor self, int dim, Tensor index, bool sparse_grad) -> Tensor
TORCH_API inline at::Tensor gather_backward(const at::Tensor & grad, const at::Tensor & self, int64_t dim, const at::Tensor & index, bool sparse_grad) {
    return at::_ops::gather_backward::call(grad, self, dim, index, sparse_grad);
}

// aten::gather.dimname_out(Tensor self, Dimname dim, Tensor index, *, bool sparse_grad=False, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & gather_out(at::Tensor & out, const at::Tensor & self, at::Dimname dim, const at::Tensor & index, bool sparse_grad=false) {
    return at::_ops::gather_dimname_out::call(self, dim, index, sparse_grad, out);
}

// aten::gather.dimname_out(Tensor self, Dimname dim, Tensor index, *, bool sparse_grad=False, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & gather_outf(const at::Tensor & self, at::Dimname dim, const at::Tensor & index, bool sparse_grad, at::Tensor & out) {
    return at::_ops::gather_dimname_out::call(self, dim, index, sparse_grad, out);
}

// aten::gather.dimname(Tensor self, Dimname dim, Tensor index, *, bool sparse_grad=False) -> Tensor
TORCH_API inline at::Tensor gather(const at::Tensor & self, at::Dimname dim, const at::Tensor & index, bool sparse_grad=false) {
    return at::_ops::gather_dimname::call(self, dim, index, sparse_grad);
}

// aten::_gather_sparse_backward(Tensor self, int dim, Tensor index, Tensor grad) -> Tensor
TORCH_API inline at::Tensor _gather_sparse_backward(const at::Tensor & self, int64_t dim, const at::Tensor & index, const at::Tensor & grad) {
    return at::_ops::_gather_sparse_backward::call(self, dim, index, grad);
}

// aten::addcmul.out(Tensor self, Tensor tensor1, Tensor tensor2, *, Scalar value=1, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & addcmul_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & tensor1, const at::Tensor & tensor2, const at::Scalar & value=1) {
    return at::_ops::addcmul_out::call(self, tensor1, tensor2, value, out);
}

// aten::addcmul.out(Tensor self, Tensor tensor1, Tensor tensor2, *, Scalar value=1, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & addcmul_outf(const at::Tensor & self, const at::Tensor & tensor1, const at::Tensor & tensor2, const at::Scalar & value, at::Tensor & out) {
    return at::_ops::addcmul_out::call(self, tensor1, tensor2, value, out);
}

// aten::addcmul(Tensor self, Tensor tensor1, Tensor tensor2, *, Scalar value=1) -> Tensor
TORCH_API inline at::Tensor addcmul(const at::Tensor & self, const at::Tensor & tensor1, const at::Tensor & tensor2, const at::Scalar & value=1) {
    return at::_ops::addcmul::call(self, tensor1, tensor2, value);
}

// aten::addcdiv.out(Tensor self, Tensor tensor1, Tensor tensor2, *, Scalar value=1, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & addcdiv_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & tensor1, const at::Tensor & tensor2, const at::Scalar & value=1) {
    return at::_ops::addcdiv_out::call(self, tensor1, tensor2, value, out);
}

// aten::addcdiv.out(Tensor self, Tensor tensor1, Tensor tensor2, *, Scalar value=1, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & addcdiv_outf(const at::Tensor & self, const at::Tensor & tensor1, const at::Tensor & tensor2, const at::Scalar & value, at::Tensor & out) {
    return at::_ops::addcdiv_out::call(self, tensor1, tensor2, value, out);
}

// aten::addcdiv(Tensor self, Tensor tensor1, Tensor tensor2, *, Scalar value=1) -> Tensor
TORCH_API inline at::Tensor addcdiv(const at::Tensor & self, const at::Tensor & tensor1, const at::Tensor & tensor2, const at::Scalar & value=1) {
    return at::_ops::addcdiv::call(self, tensor1, tensor2, value);
}

// aten::cross_entropy_loss(Tensor self, Tensor target, Tensor? weight=None, int reduction=Mean, int ignore_index=-100, float label_smoothing=0.0) -> Tensor
TORCH_API inline at::Tensor cross_entropy_loss(const at::Tensor & self, const at::Tensor & target, const c10::optional<at::Tensor> & weight={}, int64_t reduction=at::Reduction::Mean, int64_t ignore_index=-100, double label_smoothing=0.0) {
    return at::_ops::cross_entropy_loss::call(self, target, weight, reduction, ignore_index, label_smoothing);
}

// aten::lstsq.X(Tensor self, Tensor A, *, Tensor(a!) X, Tensor(b!) qr) -> (Tensor(a!) solution, Tensor(b!) QR)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> lstsq_out(at::Tensor & X, at::Tensor & qr, const at::Tensor & self, const at::Tensor & A) {
    return at::_ops::lstsq_X::call(self, A, X, qr);
}

// aten::lstsq.X(Tensor self, Tensor A, *, Tensor(a!) X, Tensor(b!) qr) -> (Tensor(a!) solution, Tensor(b!) QR)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> lstsq_outf(const at::Tensor & self, const at::Tensor & A, at::Tensor & X, at::Tensor & qr) {
    return at::_ops::lstsq_X::call(self, A, X, qr);
}

// aten::lstsq(Tensor self, Tensor A) -> (Tensor solution, Tensor QR)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> lstsq(const at::Tensor & self, const at::Tensor & A) {
    return at::_ops::lstsq::call(self, A);
}

// aten::triangular_solve.X(Tensor self, Tensor A, bool upper=True, bool transpose=False, bool unitriangular=False, *, Tensor(a!) X, Tensor(b!) M) -> (Tensor(a!) solution, Tensor(b!) cloned_coefficient)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> triangular_solve_out(at::Tensor & X, at::Tensor & M, const at::Tensor & self, const at::Tensor & A, bool upper=true, bool transpose=false, bool unitriangular=false) {
    return at::_ops::triangular_solve_X::call(self, A, upper, transpose, unitriangular, X, M);
}

// aten::triangular_solve.X(Tensor self, Tensor A, bool upper=True, bool transpose=False, bool unitriangular=False, *, Tensor(a!) X, Tensor(b!) M) -> (Tensor(a!) solution, Tensor(b!) cloned_coefficient)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> triangular_solve_outf(const at::Tensor & self, const at::Tensor & A, bool upper, bool transpose, bool unitriangular, at::Tensor & X, at::Tensor & M) {
    return at::_ops::triangular_solve_X::call(self, A, upper, transpose, unitriangular, X, M);
}

// aten::triangular_solve(Tensor self, Tensor A, bool upper=True, bool transpose=False, bool unitriangular=False) -> (Tensor solution, Tensor cloned_coefficient)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> triangular_solve(const at::Tensor & self, const at::Tensor & A, bool upper=true, bool transpose=false, bool unitriangular=false) {
    return at::_ops::triangular_solve::call(self, A, upper, transpose, unitriangular);
}

// aten::symeig.e(Tensor self, bool eigenvectors=False, bool upper=True, *, Tensor(a!) e, Tensor(b!) V) -> (Tensor(a!) eigenvalues, Tensor(b!) eigenvectors)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> symeig_out(at::Tensor & e, at::Tensor & V, const at::Tensor & self, bool eigenvectors=false, bool upper=true) {
    return at::_ops::symeig_e::call(self, eigenvectors, upper, e, V);
}

// aten::symeig.e(Tensor self, bool eigenvectors=False, bool upper=True, *, Tensor(a!) e, Tensor(b!) V) -> (Tensor(a!) eigenvalues, Tensor(b!) eigenvectors)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> symeig_outf(const at::Tensor & self, bool eigenvectors, bool upper, at::Tensor & e, at::Tensor & V) {
    return at::_ops::symeig_e::call(self, eigenvectors, upper, e, V);
}

// aten::symeig(Tensor self, bool eigenvectors=False, bool upper=True) -> (Tensor eigenvalues, Tensor eigenvectors)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> symeig(const at::Tensor & self, bool eigenvectors=false, bool upper=true) {
    return at::_ops::symeig::call(self, eigenvectors, upper);
}

// aten::_symeig_helper(Tensor self, bool eigenvectors, bool upper) -> (Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> _symeig_helper(const at::Tensor & self, bool eigenvectors, bool upper) {
    return at::_ops::_symeig_helper::call(self, eigenvectors, upper);
}

// aten::eig.e(Tensor self, bool eigenvectors=False, *, Tensor(a!) e, Tensor(b!) v) -> (Tensor(a!) eigenvalues, Tensor(b!) eigenvectors)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> eig_out(at::Tensor & e, at::Tensor & v, const at::Tensor & self, bool eigenvectors=false) {
    return at::_ops::eig_e::call(self, eigenvectors, e, v);
}

// aten::eig.e(Tensor self, bool eigenvectors=False, *, Tensor(a!) e, Tensor(b!) v) -> (Tensor(a!) eigenvalues, Tensor(b!) eigenvectors)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> eig_outf(const at::Tensor & self, bool eigenvectors, at::Tensor & e, at::Tensor & v) {
    return at::_ops::eig_e::call(self, eigenvectors, e, v);
}

// aten::eig(Tensor self, bool eigenvectors=False) -> (Tensor eigenvalues, Tensor eigenvectors)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> eig(const at::Tensor & self, bool eigenvectors=false) {
    return at::_ops::eig::call(self, eigenvectors);
}

// aten::svd.U(Tensor self, bool some=True, bool compute_uv=True, *, Tensor(a!) U, Tensor(b!) S, Tensor(c!) V) -> (Tensor(a!) U, Tensor(b!) S, Tensor(c!) V)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &,at::Tensor &> svd_out(at::Tensor & U, at::Tensor & S, at::Tensor & V, const at::Tensor & self, bool some=true, bool compute_uv=true) {
    return at::_ops::svd_U::call(self, some, compute_uv, U, S, V);
}

// aten::svd.U(Tensor self, bool some=True, bool compute_uv=True, *, Tensor(a!) U, Tensor(b!) S, Tensor(c!) V) -> (Tensor(a!) U, Tensor(b!) S, Tensor(c!) V)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &,at::Tensor &> svd_outf(const at::Tensor & self, bool some, bool compute_uv, at::Tensor & U, at::Tensor & S, at::Tensor & V) {
    return at::_ops::svd_U::call(self, some, compute_uv, U, S, V);
}

// aten::svd(Tensor self, bool some=True, bool compute_uv=True) -> (Tensor U, Tensor S, Tensor V)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor,at::Tensor> svd(const at::Tensor & self, bool some=true, bool compute_uv=true) {
    return at::_ops::svd::call(self, some, compute_uv);
}

// aten::_svd_helper(Tensor self, bool some, bool compute_uv) -> (Tensor U, Tensor S, Tensor V)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor,at::Tensor> _svd_helper(const at::Tensor & self, bool some, bool compute_uv) {
    return at::_ops::_svd_helper::call(self, some, compute_uv);
}

// aten::swapaxes(Tensor(a) self, int axis0, int axis1) -> Tensor(a)
TORCH_API inline at::Tensor swapaxes(const at::Tensor & self, int64_t axis0, int64_t axis1) {
    return at::_ops::swapaxes::call(self, axis0, axis1);
}

// aten::swapdims(Tensor(a) self, int dim0, int dim1) -> Tensor(a)
TORCH_API inline at::Tensor swapdims(const at::Tensor & self, int64_t dim0, int64_t dim1) {
    return at::_ops::swapdims::call(self, dim0, dim1);
}

// aten::cholesky.out(Tensor self, bool upper=False, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & cholesky_out(at::Tensor & out, const at::Tensor & self, bool upper=false) {
    return at::_ops::cholesky_out::call(self, upper, out);
}

// aten::cholesky.out(Tensor self, bool upper=False, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & cholesky_outf(const at::Tensor & self, bool upper, at::Tensor & out) {
    return at::_ops::cholesky_out::call(self, upper, out);
}

// aten::cholesky(Tensor self, bool upper=False) -> Tensor
TORCH_API inline at::Tensor cholesky(const at::Tensor & self, bool upper=false) {
    return at::_ops::cholesky::call(self, upper);
}

// aten::cholesky_solve.out(Tensor self, Tensor input2, bool upper=False, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & cholesky_solve_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & input2, bool upper=false) {
    return at::_ops::cholesky_solve_out::call(self, input2, upper, out);
}

// aten::cholesky_solve.out(Tensor self, Tensor input2, bool upper=False, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & cholesky_solve_outf(const at::Tensor & self, const at::Tensor & input2, bool upper, at::Tensor & out) {
    return at::_ops::cholesky_solve_out::call(self, input2, upper, out);
}

// aten::cholesky_solve(Tensor self, Tensor input2, bool upper=False) -> Tensor
TORCH_API inline at::Tensor cholesky_solve(const at::Tensor & self, const at::Tensor & input2, bool upper=false) {
    return at::_ops::cholesky_solve::call(self, input2, upper);
}

// aten::_cholesky_solve_helper(Tensor self, Tensor A, bool upper) -> Tensor
TORCH_API inline at::Tensor _cholesky_solve_helper(const at::Tensor & self, const at::Tensor & A, bool upper) {
    return at::_ops::_cholesky_solve_helper::call(self, A, upper);
}

// aten::solve(Tensor self, Tensor A) -> (Tensor solution, Tensor LU)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> solve(const at::Tensor & self, const at::Tensor & A) {
    return at::_ops::solve::call(self, A);
}

// aten::solve.solution(Tensor self, Tensor A, *, Tensor(a!) solution, Tensor(b!) lu) -> (Tensor(a!) solution, Tensor(b!) LU)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> solve_out(at::Tensor & solution, at::Tensor & lu, const at::Tensor & self, const at::Tensor & A) {
    return at::_ops::solve_solution::call(self, A, solution, lu);
}

// aten::solve.solution(Tensor self, Tensor A, *, Tensor(a!) solution, Tensor(b!) lu) -> (Tensor(a!) solution, Tensor(b!) LU)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> solve_outf(const at::Tensor & self, const at::Tensor & A, at::Tensor & solution, at::Tensor & lu) {
    return at::_ops::solve_solution::call(self, A, solution, lu);
}

// aten::_solve_helper(Tensor self, Tensor A) -> (Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> _solve_helper(const at::Tensor & self, const at::Tensor & A) {
    return at::_ops::_solve_helper::call(self, A);
}

// aten::cholesky_inverse(Tensor self, bool upper=False) -> Tensor
TORCH_API inline at::Tensor cholesky_inverse(const at::Tensor & self, bool upper=false) {
    return at::_ops::cholesky_inverse::call(self, upper);
}

// aten::cholesky_inverse.out(Tensor self, bool upper=False, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & cholesky_inverse_out(at::Tensor & out, const at::Tensor & self, bool upper=false) {
    return at::_ops::cholesky_inverse_out::call(self, upper, out);
}

// aten::cholesky_inverse.out(Tensor self, bool upper=False, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & cholesky_inverse_outf(const at::Tensor & self, bool upper, at::Tensor & out) {
    return at::_ops::cholesky_inverse_out::call(self, upper, out);
}

// aten::qr.Q(Tensor self, bool some=True, *, Tensor(a!) Q, Tensor(b!) R) -> (Tensor(a!) Q, Tensor(b!) R)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> qr_out(at::Tensor & Q, at::Tensor & R, const at::Tensor & self, bool some=true) {
    return at::_ops::qr_Q::call(self, some, Q, R);
}

// aten::qr.Q(Tensor self, bool some=True, *, Tensor(a!) Q, Tensor(b!) R) -> (Tensor(a!) Q, Tensor(b!) R)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> qr_outf(const at::Tensor & self, bool some, at::Tensor & Q, at::Tensor & R) {
    return at::_ops::qr_Q::call(self, some, Q, R);
}

// aten::qr(Tensor self, bool some=True) -> (Tensor Q, Tensor R)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> qr(const at::Tensor & self, bool some=true) {
    return at::_ops::qr::call(self, some);
}

// aten::geqrf.a(Tensor self, *, Tensor(a!) a, Tensor(b!) tau) -> (Tensor(a!) a, Tensor(b!) tau)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> geqrf_out(at::Tensor & a, at::Tensor & tau, const at::Tensor & self) {
    return at::_ops::geqrf_a::call(self, a, tau);
}

// aten::geqrf.a(Tensor self, *, Tensor(a!) a, Tensor(b!) tau) -> (Tensor(a!) a, Tensor(b!) tau)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> geqrf_outf(const at::Tensor & self, at::Tensor & a, at::Tensor & tau) {
    return at::_ops::geqrf_a::call(self, a, tau);
}

// aten::geqrf(Tensor self) -> (Tensor a, Tensor tau)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> geqrf(const at::Tensor & self) {
    return at::_ops::geqrf::call(self);
}

// aten::orgqr(Tensor self, Tensor input2) -> Tensor
TORCH_API inline at::Tensor orgqr(const at::Tensor & self, const at::Tensor & input2) {
    return at::_ops::orgqr::call(self, input2);
}

// aten::orgqr.out(Tensor self, Tensor input2, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & orgqr_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & input2) {
    return at::_ops::orgqr_out::call(self, input2, out);
}

// aten::orgqr.out(Tensor self, Tensor input2, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & orgqr_outf(const at::Tensor & self, const at::Tensor & input2, at::Tensor & out) {
    return at::_ops::orgqr_out::call(self, input2, out);
}

// aten::ormqr.out(Tensor self, Tensor input2, Tensor input3, bool left=True, bool transpose=False, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & ormqr_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & input2, const at::Tensor & input3, bool left=true, bool transpose=false) {
    return at::_ops::ormqr_out::call(self, input2, input3, left, transpose, out);
}

// aten::ormqr.out(Tensor self, Tensor input2, Tensor input3, bool left=True, bool transpose=False, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & ormqr_outf(const at::Tensor & self, const at::Tensor & input2, const at::Tensor & input3, bool left, bool transpose, at::Tensor & out) {
    return at::_ops::ormqr_out::call(self, input2, input3, left, transpose, out);
}

// aten::ormqr(Tensor self, Tensor input2, Tensor input3, bool left=True, bool transpose=False) -> Tensor
TORCH_API inline at::Tensor ormqr(const at::Tensor & self, const at::Tensor & input2, const at::Tensor & input3, bool left=true, bool transpose=false) {
    return at::_ops::ormqr::call(self, input2, input3, left, transpose);
}

// aten::_lu_with_info(Tensor self, bool pivot=True, bool check_errors=True) -> (Tensor LU, Tensor pivots, Tensor info)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor,at::Tensor> _lu_with_info(const at::Tensor & self, bool pivot=true, bool check_errors=true) {
    return at::_ops::_lu_with_info::call(self, pivot, check_errors);
}

// aten::lu_solve.out(Tensor self, Tensor LU_data, Tensor LU_pivots, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & lu_solve_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & LU_data, const at::Tensor & LU_pivots) {
    return at::_ops::lu_solve_out::call(self, LU_data, LU_pivots, out);
}

// aten::lu_solve.out(Tensor self, Tensor LU_data, Tensor LU_pivots, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & lu_solve_outf(const at::Tensor & self, const at::Tensor & LU_data, const at::Tensor & LU_pivots, at::Tensor & out) {
    return at::_ops::lu_solve_out::call(self, LU_data, LU_pivots, out);
}

// aten::lu_solve(Tensor self, Tensor LU_data, Tensor LU_pivots) -> Tensor
TORCH_API inline at::Tensor lu_solve(const at::Tensor & self, const at::Tensor & LU_data, const at::Tensor & LU_pivots) {
    return at::_ops::lu_solve::call(self, LU_data, LU_pivots);
}

// aten::lu_unpack(Tensor LU_data, Tensor LU_pivots, bool unpack_data=True, bool unpack_pivots=True) -> (Tensor P, Tensor L, Tensor U)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor,at::Tensor> lu_unpack(const at::Tensor & LU_data, const at::Tensor & LU_pivots, bool unpack_data=true, bool unpack_pivots=true) {
    return at::_ops::lu_unpack::call(LU_data, LU_pivots, unpack_data, unpack_pivots);
}

// aten::lu_unpack.out(Tensor LU_data, Tensor LU_pivots, bool unpack_data=True, bool unpack_pivots=True, *, Tensor(a!) P, Tensor(b!) L, Tensor(c!) U) -> (Tensor(a!) P, Tensor(b!) L, Tensor(c!) U)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &,at::Tensor &> lu_unpack_out(at::Tensor & P, at::Tensor & L, at::Tensor & U, const at::Tensor & LU_data, const at::Tensor & LU_pivots, bool unpack_data=true, bool unpack_pivots=true) {
    return at::_ops::lu_unpack_out::call(LU_data, LU_pivots, unpack_data, unpack_pivots, P, L, U);
}

// aten::lu_unpack.out(Tensor LU_data, Tensor LU_pivots, bool unpack_data=True, bool unpack_pivots=True, *, Tensor(a!) P, Tensor(b!) L, Tensor(c!) U) -> (Tensor(a!) P, Tensor(b!) L, Tensor(c!) U)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &,at::Tensor &> lu_unpack_outf(const at::Tensor & LU_data, const at::Tensor & LU_pivots, bool unpack_data, bool unpack_pivots, at::Tensor & P, at::Tensor & L, at::Tensor & U) {
    return at::_ops::lu_unpack_out::call(LU_data, LU_pivots, unpack_data, unpack_pivots, P, L, U);
}

// aten::multinomial.out(Tensor self, int num_samples, bool replacement=False, *, Generator? generator=None, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & multinomial_out(at::Tensor & out, const at::Tensor & self, int64_t num_samples, bool replacement=false, c10::optional<at::Generator> generator=c10::nullopt) {
    return at::_ops::multinomial_out::call(self, num_samples, replacement, generator, out);
}

// aten::multinomial.out(Tensor self, int num_samples, bool replacement=False, *, Generator? generator=None, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & multinomial_outf(const at::Tensor & self, int64_t num_samples, bool replacement, c10::optional<at::Generator> generator, at::Tensor & out) {
    return at::_ops::multinomial_out::call(self, num_samples, replacement, generator, out);
}

// aten::multinomial(Tensor self, int num_samples, bool replacement=False, *, Generator? generator=None) -> Tensor
TORCH_API inline at::Tensor multinomial(const at::Tensor & self, int64_t num_samples, bool replacement=false, c10::optional<at::Generator> generator=c10::nullopt) {
    return at::_ops::multinomial::call(self, num_samples, replacement, generator);
}

// aten::lgamma.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & lgamma_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::lgamma_out::call(self, out);
}

// aten::lgamma.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & lgamma_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::lgamma_out::call(self, out);
}

// aten::lgamma(Tensor self) -> Tensor
TORCH_API inline at::Tensor lgamma(const at::Tensor & self) {
    return at::_ops::lgamma::call(self);
}

// aten::digamma.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & digamma_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::digamma_out::call(self, out);
}

// aten::digamma.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & digamma_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::digamma_out::call(self, out);
}

// aten::digamma(Tensor self) -> Tensor
TORCH_API inline at::Tensor digamma(const at::Tensor & self) {
    return at::_ops::digamma::call(self);
}

// aten::polygamma.out(int n, Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & polygamma_out(at::Tensor & out, int64_t n, const at::Tensor & self) {
    return at::_ops::polygamma_out::call(n, self, out);
}

// aten::polygamma.out(int n, Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & polygamma_outf(int64_t n, const at::Tensor & self, at::Tensor & out) {
    return at::_ops::polygamma_out::call(n, self, out);
}

// aten::polygamma(int n, Tensor self) -> Tensor
TORCH_API inline at::Tensor polygamma(int64_t n, const at::Tensor & self) {
    return at::_ops::polygamma::call(n, self);
}

// aten::erfinv(Tensor self) -> Tensor
TORCH_API inline at::Tensor erfinv(const at::Tensor & self) {
    return at::_ops::erfinv::call(self);
}

// aten::erfinv.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & erfinv_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::erfinv_out::call(self, out);
}

// aten::erfinv.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & erfinv_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::erfinv_out::call(self, out);
}

// aten::i0(Tensor self) -> Tensor
TORCH_API inline at::Tensor i0(const at::Tensor & self) {
    return at::_ops::i0::call(self);
}

// aten::i0_(Tensor(a!) self) -> Tensor(a!)
TORCH_API inline at::Tensor & i0_(at::Tensor & self) {
    return at::_ops::i0_::call(self);
}

// aten::i0.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & i0_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::i0_out::call(self, out);
}

// aten::i0.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & i0_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::i0_out::call(self, out);
}

// aten::sign(Tensor self) -> Tensor
TORCH_API inline at::Tensor sign(const at::Tensor & self) {
    return at::_ops::sign::call(self);
}

// aten::sign.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & sign_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::sign_out::call(self, out);
}

// aten::sign.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & sign_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::sign_out::call(self, out);
}

// aten::signbit(Tensor self) -> Tensor
TORCH_API inline at::Tensor signbit(const at::Tensor & self) {
    return at::_ops::signbit::call(self);
}

// aten::signbit.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & signbit_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::signbit_out::call(self, out);
}

// aten::signbit.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & signbit_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::signbit_out::call(self, out);
}

// aten::dist(Tensor self, Tensor other, Scalar p=2) -> Tensor
TORCH_API inline at::Tensor dist(const at::Tensor & self, const at::Tensor & other, const at::Scalar & p=2) {
    return at::_ops::dist::call(self, other, p);
}

// aten::atan2.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & atan2_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::atan2_out::call(self, other, out);
}

// aten::atan2.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & atan2_outf(const at::Tensor & self, const at::Tensor & other, at::Tensor & out) {
    return at::_ops::atan2_out::call(self, other, out);
}

// aten::atan2(Tensor self, Tensor other) -> Tensor
TORCH_API inline at::Tensor atan2(const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::atan2::call(self, other);
}

// aten::lerp.Scalar_out(Tensor self, Tensor end, Scalar weight, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & lerp_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & end, const at::Scalar & weight) {
    return at::_ops::lerp_Scalar_out::call(self, end, weight, out);
}

// aten::lerp.Scalar_out(Tensor self, Tensor end, Scalar weight, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & lerp_outf(const at::Tensor & self, const at::Tensor & end, const at::Scalar & weight, at::Tensor & out) {
    return at::_ops::lerp_Scalar_out::call(self, end, weight, out);
}

// aten::lerp.Tensor_out(Tensor self, Tensor end, Tensor weight, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & lerp_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & end, const at::Tensor & weight) {
    return at::_ops::lerp_Tensor_out::call(self, end, weight, out);
}

// aten::lerp.Tensor_out(Tensor self, Tensor end, Tensor weight, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & lerp_outf(const at::Tensor & self, const at::Tensor & end, const at::Tensor & weight, at::Tensor & out) {
    return at::_ops::lerp_Tensor_out::call(self, end, weight, out);
}

// aten::lerp.Scalar(Tensor self, Tensor end, Scalar weight) -> Tensor
TORCH_API inline at::Tensor lerp(const at::Tensor & self, const at::Tensor & end, const at::Scalar & weight) {
    return at::_ops::lerp_Scalar::call(self, end, weight);
}

// aten::lerp.Tensor(Tensor self, Tensor end, Tensor weight) -> Tensor
TORCH_API inline at::Tensor lerp(const at::Tensor & self, const at::Tensor & end, const at::Tensor & weight) {
    return at::_ops::lerp_Tensor::call(self, end, weight);
}

// aten::histc.out(Tensor self, int bins=100, Scalar min=0, Scalar max=0, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & histc_out(at::Tensor & out, const at::Tensor & self, int64_t bins=100, const at::Scalar & min=0, const at::Scalar & max=0) {
    return at::_ops::histc_out::call(self, bins, min, max, out);
}

// aten::histc.out(Tensor self, int bins=100, Scalar min=0, Scalar max=0, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & histc_outf(const at::Tensor & self, int64_t bins, const at::Scalar & min, const at::Scalar & max, at::Tensor & out) {
    return at::_ops::histc_out::call(self, bins, min, max, out);
}

// aten::histc(Tensor self, int bins=100, Scalar min=0, Scalar max=0) -> Tensor
TORCH_API inline at::Tensor histc(const at::Tensor & self, int64_t bins=100, const at::Scalar & min=0, const at::Scalar & max=0) {
    return at::_ops::histc::call(self, bins, min, max);
}

// aten::histogram.bins_tensor_out(Tensor self, Tensor bins, *, Tensor? weight=None, bool density=False, Tensor(a!) hist, Tensor(b!) bin_edges) -> (Tensor(a!) hist, Tensor(b!) bin_edges)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> histogram_out(at::Tensor & hist, at::Tensor & bin_edges, const at::Tensor & self, const at::Tensor & bins, const c10::optional<at::Tensor> & weight={}, bool density=false) {
    return at::_ops::histogram_bins_tensor_out::call(self, bins, weight, density, hist, bin_edges);
}

// aten::histogram.bins_tensor_out(Tensor self, Tensor bins, *, Tensor? weight=None, bool density=False, Tensor(a!) hist, Tensor(b!) bin_edges) -> (Tensor(a!) hist, Tensor(b!) bin_edges)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> histogram_outf(const at::Tensor & self, const at::Tensor & bins, const c10::optional<at::Tensor> & weight, bool density, at::Tensor & hist, at::Tensor & bin_edges) {
    return at::_ops::histogram_bins_tensor_out::call(self, bins, weight, density, hist, bin_edges);
}

// aten::histogram.bins_tensor(Tensor self, Tensor bins, *, Tensor? weight=None, bool density=False) -> (Tensor hist, Tensor bin_edges)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> histogram(const at::Tensor & self, const at::Tensor & bins, const c10::optional<at::Tensor> & weight={}, bool density=false) {
    return at::_ops::histogram_bins_tensor::call(self, bins, weight, density);
}

// aten::histogram.bin_ct_out(Tensor self, int bins=100, *, float[]? range=None, Tensor? weight=None, bool density=False, Tensor(a!) hist, Tensor(b!) bin_edges) -> (Tensor(a!) hist, Tensor(b!) bin_edges)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> histogram_out(at::Tensor & hist, at::Tensor & bin_edges, const at::Tensor & self, int64_t bins=100, c10::optional<at::ArrayRef<double>> range=c10::nullopt, const c10::optional<at::Tensor> & weight={}, bool density=false) {
    return at::_ops::histogram_bin_ct_out::call(self, bins, range, weight, density, hist, bin_edges);
}

// aten::histogram.bin_ct_out(Tensor self, int bins=100, *, float[]? range=None, Tensor? weight=None, bool density=False, Tensor(a!) hist, Tensor(b!) bin_edges) -> (Tensor(a!) hist, Tensor(b!) bin_edges)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> histogram_outf(const at::Tensor & self, int64_t bins, c10::optional<at::ArrayRef<double>> range, const c10::optional<at::Tensor> & weight, bool density, at::Tensor & hist, at::Tensor & bin_edges) {
    return at::_ops::histogram_bin_ct_out::call(self, bins, range, weight, density, hist, bin_edges);
}

// aten::histogram.bin_ct(Tensor self, int bins=100, *, float[]? range=None, Tensor? weight=None, bool density=False) -> (Tensor hist, Tensor bin_edges)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> histogram(const at::Tensor & self, int64_t bins=100, c10::optional<at::ArrayRef<double>> range=c10::nullopt, const c10::optional<at::Tensor> & weight={}, bool density=false) {
    return at::_ops::histogram_bin_ct::call(self, bins, range, weight, density);
}

// aten::fmod.Scalar_out(Tensor self, Scalar other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & fmod_out(at::Tensor & out, const at::Tensor & self, const at::Scalar & other) {
    return at::_ops::fmod_Scalar_out::call(self, other, out);
}

// aten::fmod.Scalar_out(Tensor self, Scalar other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & fmod_outf(const at::Tensor & self, const at::Scalar & other, at::Tensor & out) {
    return at::_ops::fmod_Scalar_out::call(self, other, out);
}

// aten::fmod.Scalar(Tensor self, Scalar other) -> Tensor
TORCH_API inline at::Tensor fmod(const at::Tensor & self, const at::Scalar & other) {
    return at::_ops::fmod_Scalar::call(self, other);
}

// aten::fmod.Tensor_out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & fmod_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::fmod_Tensor_out::call(self, other, out);
}

// aten::fmod.Tensor_out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & fmod_outf(const at::Tensor & self, const at::Tensor & other, at::Tensor & out) {
    return at::_ops::fmod_Tensor_out::call(self, other, out);
}

// aten::fmod.Tensor(Tensor self, Tensor other) -> Tensor
TORCH_API inline at::Tensor fmod(const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::fmod_Tensor::call(self, other);
}

// aten::hypot.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & hypot_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::hypot_out::call(self, other, out);
}

// aten::hypot.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & hypot_outf(const at::Tensor & self, const at::Tensor & other, at::Tensor & out) {
    return at::_ops::hypot_out::call(self, other, out);
}

// aten::hypot(Tensor self, Tensor other) -> Tensor
TORCH_API inline at::Tensor hypot(const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::hypot::call(self, other);
}

// aten::igamma.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & igamma_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::igamma_out::call(self, other, out);
}

// aten::igamma.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & igamma_outf(const at::Tensor & self, const at::Tensor & other, at::Tensor & out) {
    return at::_ops::igamma_out::call(self, other, out);
}

// aten::igamma(Tensor self, Tensor other) -> Tensor
TORCH_API inline at::Tensor igamma(const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::igamma::call(self, other);
}

// aten::igammac.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & igammac_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::igammac_out::call(self, other, out);
}

// aten::igammac.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & igammac_outf(const at::Tensor & self, const at::Tensor & other, at::Tensor & out) {
    return at::_ops::igammac_out::call(self, other, out);
}

// aten::igammac(Tensor self, Tensor other) -> Tensor
TORCH_API inline at::Tensor igammac(const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::igammac::call(self, other);
}

// aten::nextafter.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & nextafter_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::nextafter_out::call(self, other, out);
}

// aten::nextafter.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & nextafter_outf(const at::Tensor & self, const at::Tensor & other, at::Tensor & out) {
    return at::_ops::nextafter_out::call(self, other, out);
}

// aten::nextafter(Tensor self, Tensor other) -> Tensor
TORCH_API inline at::Tensor nextafter(const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::nextafter::call(self, other);
}

// aten::remainder.Scalar_out(Tensor self, Scalar other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & remainder_out(at::Tensor & out, const at::Tensor & self, const at::Scalar & other) {
    return at::_ops::remainder_Scalar_out::call(self, other, out);
}

// aten::remainder.Scalar_out(Tensor self, Scalar other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & remainder_outf(const at::Tensor & self, const at::Scalar & other, at::Tensor & out) {
    return at::_ops::remainder_Scalar_out::call(self, other, out);
}

// aten::remainder.Scalar(Tensor self, Scalar other) -> Tensor
TORCH_API inline at::Tensor remainder(const at::Tensor & self, const at::Scalar & other) {
    return at::_ops::remainder_Scalar::call(self, other);
}

// aten::remainder.Tensor_out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & remainder_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::remainder_Tensor_out::call(self, other, out);
}

// aten::remainder.Tensor_out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & remainder_outf(const at::Tensor & self, const at::Tensor & other, at::Tensor & out) {
    return at::_ops::remainder_Tensor_out::call(self, other, out);
}

// aten::remainder.Tensor(Tensor self, Tensor other) -> Tensor
TORCH_API inline at::Tensor remainder(const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::remainder_Tensor::call(self, other);
}

// aten::remainder.Scalar_Tensor(Scalar self, Tensor other) -> Tensor
TORCH_API inline at::Tensor remainder(const at::Scalar & self, const at::Tensor & other) {
    return at::_ops::remainder_Scalar_Tensor::call(self, other);
}

// aten::min(Tensor self) -> Tensor
TORCH_API inline at::Tensor min(const at::Tensor & self) {
    return at::_ops::min::call(self);
}

// aten::fmin(Tensor self, Tensor other) -> Tensor
TORCH_API inline at::Tensor fmin(const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::fmin::call(self, other);
}

// aten::fmin.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & fmin_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::fmin_out::call(self, other, out);
}

// aten::fmin.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & fmin_outf(const at::Tensor & self, const at::Tensor & other, at::Tensor & out) {
    return at::_ops::fmin_out::call(self, other, out);
}

// aten::max(Tensor self) -> Tensor
TORCH_API inline at::Tensor max(const at::Tensor & self) {
    return at::_ops::max::call(self);
}

// aten::fmax(Tensor self, Tensor other) -> Tensor
TORCH_API inline at::Tensor fmax(const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::fmax::call(self, other);
}

// aten::fmax.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & fmax_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::fmax_out::call(self, other, out);
}

// aten::fmax.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & fmax_outf(const at::Tensor & self, const at::Tensor & other, at::Tensor & out) {
    return at::_ops::fmax_out::call(self, other, out);
}

// aten::maximum(Tensor self, Tensor other) -> Tensor
TORCH_API inline at::Tensor maximum(const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::maximum::call(self, other);
}

// aten::maximum.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & maximum_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::maximum_out::call(self, other, out);
}

// aten::maximum.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & maximum_outf(const at::Tensor & self, const at::Tensor & other, at::Tensor & out) {
    return at::_ops::maximum_out::call(self, other, out);
}

// aten::max.other(Tensor self, Tensor other) -> Tensor
TORCH_API inline at::Tensor max(const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::max_other::call(self, other);
}

// aten::max.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & max_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::max_out::call(self, other, out);
}

// aten::max.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & max_outf(const at::Tensor & self, const at::Tensor & other, at::Tensor & out) {
    return at::_ops::max_out::call(self, other, out);
}

// aten::minimum(Tensor self, Tensor other) -> Tensor
TORCH_API inline at::Tensor minimum(const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::minimum::call(self, other);
}

// aten::minimum.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & minimum_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::minimum_out::call(self, other, out);
}

// aten::minimum.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & minimum_outf(const at::Tensor & self, const at::Tensor & other, at::Tensor & out) {
    return at::_ops::minimum_out::call(self, other, out);
}

// aten::min.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & min_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::min_out::call(self, other, out);
}

// aten::min.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & min_outf(const at::Tensor & self, const at::Tensor & other, at::Tensor & out) {
    return at::_ops::min_out::call(self, other, out);
}

// aten::min.other(Tensor self, Tensor other) -> Tensor
TORCH_API inline at::Tensor min(const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::min_other::call(self, other);
}

// aten::quantile.scalar_out(Tensor self, float q, int? dim=None, bool keepdim=False, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & quantile_out(at::Tensor & out, const at::Tensor & self, double q, c10::optional<int64_t> dim=c10::nullopt, bool keepdim=false) {
    return at::_ops::quantile_scalar_out::call(self, q, dim, keepdim, out);
}

// aten::quantile.scalar_out(Tensor self, float q, int? dim=None, bool keepdim=False, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & quantile_outf(const at::Tensor & self, double q, c10::optional<int64_t> dim, bool keepdim, at::Tensor & out) {
    return at::_ops::quantile_scalar_out::call(self, q, dim, keepdim, out);
}

// aten::quantile.scalar(Tensor self, float q, int? dim=None, bool keepdim=False) -> Tensor
TORCH_API inline at::Tensor quantile(const at::Tensor & self, double q, c10::optional<int64_t> dim=c10::nullopt, bool keepdim=false) {
    return at::_ops::quantile_scalar::call(self, q, dim, keepdim);
}

// aten::quantile.out(Tensor self, Tensor q, int? dim=None, bool keepdim=False, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & quantile_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & q, c10::optional<int64_t> dim=c10::nullopt, bool keepdim=false) {
    return at::_ops::quantile_out::call(self, q, dim, keepdim, out);
}

// aten::quantile.out(Tensor self, Tensor q, int? dim=None, bool keepdim=False, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & quantile_outf(const at::Tensor & self, const at::Tensor & q, c10::optional<int64_t> dim, bool keepdim, at::Tensor & out) {
    return at::_ops::quantile_out::call(self, q, dim, keepdim, out);
}

// aten::quantile(Tensor self, Tensor q, int? dim=None, bool keepdim=False) -> Tensor
TORCH_API inline at::Tensor quantile(const at::Tensor & self, const at::Tensor & q, c10::optional<int64_t> dim=c10::nullopt, bool keepdim=false) {
    return at::_ops::quantile::call(self, q, dim, keepdim);
}

// aten::nanquantile.scalar_out(Tensor self, float q, int? dim=None, bool keepdim=False, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & nanquantile_out(at::Tensor & out, const at::Tensor & self, double q, c10::optional<int64_t> dim=c10::nullopt, bool keepdim=false) {
    return at::_ops::nanquantile_scalar_out::call(self, q, dim, keepdim, out);
}

// aten::nanquantile.scalar_out(Tensor self, float q, int? dim=None, bool keepdim=False, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & nanquantile_outf(const at::Tensor & self, double q, c10::optional<int64_t> dim, bool keepdim, at::Tensor & out) {
    return at::_ops::nanquantile_scalar_out::call(self, q, dim, keepdim, out);
}

// aten::nanquantile.scalar(Tensor self, float q, int? dim=None, bool keepdim=False) -> Tensor
TORCH_API inline at::Tensor nanquantile(const at::Tensor & self, double q, c10::optional<int64_t> dim=c10::nullopt, bool keepdim=false) {
    return at::_ops::nanquantile_scalar::call(self, q, dim, keepdim);
}

// aten::nanquantile.out(Tensor self, Tensor q, int? dim=None, bool keepdim=False, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & nanquantile_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & q, c10::optional<int64_t> dim=c10::nullopt, bool keepdim=false) {
    return at::_ops::nanquantile_out::call(self, q, dim, keepdim, out);
}

// aten::nanquantile.out(Tensor self, Tensor q, int? dim=None, bool keepdim=False, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & nanquantile_outf(const at::Tensor & self, const at::Tensor & q, c10::optional<int64_t> dim, bool keepdim, at::Tensor & out) {
    return at::_ops::nanquantile_out::call(self, q, dim, keepdim, out);
}

// aten::nanquantile(Tensor self, Tensor q, int? dim=None, bool keepdim=False) -> Tensor
TORCH_API inline at::Tensor nanquantile(const at::Tensor & self, const at::Tensor & q, c10::optional<int64_t> dim=c10::nullopt, bool keepdim=false) {
    return at::_ops::nanquantile::call(self, q, dim, keepdim);
}

// aten::quantile.new_scalar_out(Tensor self, float q, int? dim, bool keepdim, *, str interpolation, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & quantile_out(at::Tensor & out, const at::Tensor & self, double q, c10::optional<int64_t> dim, bool keepdim, c10::string_view interpolation) {
    return at::_ops::quantile_new_scalar_out::call(self, q, dim, keepdim, interpolation, out);
}

// aten::quantile.new_scalar_out(Tensor self, float q, int? dim, bool keepdim, *, str interpolation, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & quantile_outf(const at::Tensor & self, double q, c10::optional<int64_t> dim, bool keepdim, c10::string_view interpolation, at::Tensor & out) {
    return at::_ops::quantile_new_scalar_out::call(self, q, dim, keepdim, interpolation, out);
}

// aten::quantile.new_scalar(Tensor self, float q, int? dim, bool keepdim, *, str interpolation) -> Tensor
TORCH_API inline at::Tensor quantile(const at::Tensor & self, double q, c10::optional<int64_t> dim, bool keepdim, c10::string_view interpolation) {
    return at::_ops::quantile_new_scalar::call(self, q, dim, keepdim, interpolation);
}

// aten::quantile.new_out(Tensor self, Tensor q, int? dim, bool keepdim, *, str interpolation, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & quantile_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & q, c10::optional<int64_t> dim, bool keepdim, c10::string_view interpolation) {
    return at::_ops::quantile_new_out::call(self, q, dim, keepdim, interpolation, out);
}

// aten::quantile.new_out(Tensor self, Tensor q, int? dim, bool keepdim, *, str interpolation, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & quantile_outf(const at::Tensor & self, const at::Tensor & q, c10::optional<int64_t> dim, bool keepdim, c10::string_view interpolation, at::Tensor & out) {
    return at::_ops::quantile_new_out::call(self, q, dim, keepdim, interpolation, out);
}

// aten::quantile.new(Tensor self, Tensor q, int? dim, bool keepdim, *, str interpolation) -> Tensor
TORCH_API inline at::Tensor quantile(const at::Tensor & self, const at::Tensor & q, c10::optional<int64_t> dim, bool keepdim, c10::string_view interpolation) {
    return at::_ops::quantile_new::call(self, q, dim, keepdim, interpolation);
}

// aten::nanquantile.new_scalar_out(Tensor self, float q, int? dim, bool keepdim, *, str interpolation, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & nanquantile_out(at::Tensor & out, const at::Tensor & self, double q, c10::optional<int64_t> dim, bool keepdim, c10::string_view interpolation) {
    return at::_ops::nanquantile_new_scalar_out::call(self, q, dim, keepdim, interpolation, out);
}

// aten::nanquantile.new_scalar_out(Tensor self, float q, int? dim, bool keepdim, *, str interpolation, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & nanquantile_outf(const at::Tensor & self, double q, c10::optional<int64_t> dim, bool keepdim, c10::string_view interpolation, at::Tensor & out) {
    return at::_ops::nanquantile_new_scalar_out::call(self, q, dim, keepdim, interpolation, out);
}

// aten::nanquantile.new_scalar(Tensor self, float q, int? dim, bool keepdim, *, str interpolation) -> Tensor
TORCH_API inline at::Tensor nanquantile(const at::Tensor & self, double q, c10::optional<int64_t> dim, bool keepdim, c10::string_view interpolation) {
    return at::_ops::nanquantile_new_scalar::call(self, q, dim, keepdim, interpolation);
}

// aten::nanquantile.new_out(Tensor self, Tensor q, int? dim, bool keepdim, *, str interpolation, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & nanquantile_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & q, c10::optional<int64_t> dim, bool keepdim, c10::string_view interpolation) {
    return at::_ops::nanquantile_new_out::call(self, q, dim, keepdim, interpolation, out);
}

// aten::nanquantile.new_out(Tensor self, Tensor q, int? dim, bool keepdim, *, str interpolation, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & nanquantile_outf(const at::Tensor & self, const at::Tensor & q, c10::optional<int64_t> dim, bool keepdim, c10::string_view interpolation, at::Tensor & out) {
    return at::_ops::nanquantile_new_out::call(self, q, dim, keepdim, interpolation, out);
}

// aten::nanquantile.new(Tensor self, Tensor q, int? dim, bool keepdim, *, str interpolation) -> Tensor
TORCH_API inline at::Tensor nanquantile(const at::Tensor & self, const at::Tensor & q, c10::optional<int64_t> dim, bool keepdim, c10::string_view interpolation) {
    return at::_ops::nanquantile_new::call(self, q, dim, keepdim, interpolation);
}

// aten::sort.values(Tensor self, int dim=-1, bool descending=False, *, Tensor(a!) values, Tensor(b!) indices) -> (Tensor(a!) values, Tensor(b!) indices)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> sort_out(at::Tensor & values, at::Tensor & indices, const at::Tensor & self, int64_t dim=-1, bool descending=false) {
    return at::_ops::sort_values::call(self, dim, descending, values, indices);
}

// aten::sort.values(Tensor self, int dim=-1, bool descending=False, *, Tensor(a!) values, Tensor(b!) indices) -> (Tensor(a!) values, Tensor(b!) indices)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> sort_outf(const at::Tensor & self, int64_t dim, bool descending, at::Tensor & values, at::Tensor & indices) {
    return at::_ops::sort_values::call(self, dim, descending, values, indices);
}

// aten::sort.values_stable(Tensor self, *, bool? stable, int dim=-1, bool descending=False, Tensor(a!) values, Tensor(b!) indices) -> (Tensor(a!) values, Tensor(b!) indices)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> sort_out(at::Tensor & values, at::Tensor & indices, const at::Tensor & self, c10::optional<bool> stable, int64_t dim=-1, bool descending=false) {
    return at::_ops::sort_values_stable::call(self, stable, dim, descending, values, indices);
}

// aten::sort.values_stable(Tensor self, *, bool? stable, int dim=-1, bool descending=False, Tensor(a!) values, Tensor(b!) indices) -> (Tensor(a!) values, Tensor(b!) indices)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> sort_outf(const at::Tensor & self, c10::optional<bool> stable, int64_t dim, bool descending, at::Tensor & values, at::Tensor & indices) {
    return at::_ops::sort_values_stable::call(self, stable, dim, descending, values, indices);
}

// aten::sort(Tensor self, int dim=-1, bool descending=False) -> (Tensor values, Tensor indices)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> sort(const at::Tensor & self, int64_t dim=-1, bool descending=false) {
    return at::_ops::sort::call(self, dim, descending);
}

// aten::sort.stable(Tensor self, *, bool? stable, int dim=-1, bool descending=False) -> (Tensor values, Tensor indices)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> sort(const at::Tensor & self, c10::optional<bool> stable, int64_t dim=-1, bool descending=false) {
    return at::_ops::sort_stable::call(self, stable, dim, descending);
}

// aten::sort.dimname_values(Tensor self, Dimname dim, bool descending=False, *, Tensor(a!) values, Tensor(b!) indices) -> (Tensor(a!) values, Tensor(b!) indices)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> sort_out(at::Tensor & values, at::Tensor & indices, const at::Tensor & self, at::Dimname dim, bool descending=false) {
    return at::_ops::sort_dimname_values::call(self, dim, descending, values, indices);
}

// aten::sort.dimname_values(Tensor self, Dimname dim, bool descending=False, *, Tensor(a!) values, Tensor(b!) indices) -> (Tensor(a!) values, Tensor(b!) indices)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> sort_outf(const at::Tensor & self, at::Dimname dim, bool descending, at::Tensor & values, at::Tensor & indices) {
    return at::_ops::sort_dimname_values::call(self, dim, descending, values, indices);
}

// aten::sort.dimname_values_stable(Tensor self, *, bool? stable, Dimname dim, bool descending=False, Tensor(a!) values, Tensor(b!) indices) -> (Tensor(a!) values, Tensor(b!) indices)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> sort_out(at::Tensor & values, at::Tensor & indices, const at::Tensor & self, c10::optional<bool> stable, at::Dimname dim, bool descending=false) {
    return at::_ops::sort_dimname_values_stable::call(self, stable, dim, descending, values, indices);
}

// aten::sort.dimname_values_stable(Tensor self, *, bool? stable, Dimname dim, bool descending=False, Tensor(a!) values, Tensor(b!) indices) -> (Tensor(a!) values, Tensor(b!) indices)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> sort_outf(const at::Tensor & self, c10::optional<bool> stable, at::Dimname dim, bool descending, at::Tensor & values, at::Tensor & indices) {
    return at::_ops::sort_dimname_values_stable::call(self, stable, dim, descending, values, indices);
}

// aten::sort.dimname(Tensor self, Dimname dim, bool descending=False) -> (Tensor values, Tensor indices)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> sort(const at::Tensor & self, at::Dimname dim, bool descending=false) {
    return at::_ops::sort_dimname::call(self, dim, descending);
}

// aten::sort.dimname_stable(Tensor self, *, bool? stable, Dimname dim, bool descending=False) -> (Tensor values, Tensor indices)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> sort(const at::Tensor & self, c10::optional<bool> stable, at::Dimname dim, bool descending=false) {
    return at::_ops::sort_dimname_stable::call(self, stable, dim, descending);
}

// aten::msort.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & msort_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::msort_out::call(self, out);
}

// aten::msort.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & msort_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::msort_out::call(self, out);
}

// aten::msort(Tensor self) -> Tensor
TORCH_API inline at::Tensor msort(const at::Tensor & self) {
    return at::_ops::msort::call(self);
}

// aten::argsort(Tensor self, int dim=-1, bool descending=False) -> Tensor
TORCH_API inline at::Tensor argsort(const at::Tensor & self, int64_t dim=-1, bool descending=false) {
    return at::_ops::argsort::call(self, dim, descending);
}

// aten::argsort.dimname(Tensor self, Dimname dim, bool descending=False) -> Tensor
TORCH_API inline at::Tensor argsort(const at::Tensor & self, at::Dimname dim, bool descending=false) {
    return at::_ops::argsort_dimname::call(self, dim, descending);
}

// aten::topk.values(Tensor self, int k, int dim=-1, bool largest=True, bool sorted=True, *, Tensor(a!) values, Tensor(b!) indices) -> (Tensor(a!) values, Tensor(b!) indices)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> topk_out(at::Tensor & values, at::Tensor & indices, const at::Tensor & self, int64_t k, int64_t dim=-1, bool largest=true, bool sorted=true) {
    return at::_ops::topk_values::call(self, k, dim, largest, sorted, values, indices);
}

// aten::topk.values(Tensor self, int k, int dim=-1, bool largest=True, bool sorted=True, *, Tensor(a!) values, Tensor(b!) indices) -> (Tensor(a!) values, Tensor(b!) indices)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> topk_outf(const at::Tensor & self, int64_t k, int64_t dim, bool largest, bool sorted, at::Tensor & values, at::Tensor & indices) {
    return at::_ops::topk_values::call(self, k, dim, largest, sorted, values, indices);
}

// aten::topk(Tensor self, int k, int dim=-1, bool largest=True, bool sorted=True) -> (Tensor values, Tensor indices)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> topk(const at::Tensor & self, int64_t k, int64_t dim=-1, bool largest=true, bool sorted=true) {
    return at::_ops::topk::call(self, k, dim, largest, sorted);
}

// aten::all(Tensor self) -> Tensor
TORCH_API inline at::Tensor all(const at::Tensor & self) {
    return at::_ops::all::call(self);
}

// aten::all.all_out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & all_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::all_all_out::call(self, out);
}

// aten::all.all_out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & all_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::all_all_out::call(self, out);
}

// aten::any(Tensor self) -> Tensor
TORCH_API inline at::Tensor any(const at::Tensor & self) {
    return at::_ops::any::call(self);
}

// aten::any.all_out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & any_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::any_all_out::call(self, out);
}

// aten::any.all_out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & any_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::any_all_out::call(self, out);
}

// aten::renorm.out(Tensor self, Scalar p, int dim, Scalar maxnorm, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & renorm_out(at::Tensor & out, const at::Tensor & self, const at::Scalar & p, int64_t dim, const at::Scalar & maxnorm) {
    return at::_ops::renorm_out::call(self, p, dim, maxnorm, out);
}

// aten::renorm.out(Tensor self, Scalar p, int dim, Scalar maxnorm, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & renorm_outf(const at::Tensor & self, const at::Scalar & p, int64_t dim, const at::Scalar & maxnorm, at::Tensor & out) {
    return at::_ops::renorm_out::call(self, p, dim, maxnorm, out);
}

// aten::renorm(Tensor self, Scalar p, int dim, Scalar maxnorm) -> Tensor
TORCH_API inline at::Tensor renorm(const at::Tensor & self, const at::Scalar & p, int64_t dim, const at::Scalar & maxnorm) {
    return at::_ops::renorm::call(self, p, dim, maxnorm);
}

// aten::unfold_backward(Tensor grad_in, int[] input_sizes, int dim, int size, int step) -> Tensor
TORCH_API inline at::Tensor unfold_backward(const at::Tensor & grad_in, at::IntArrayRef input_sizes, int64_t dim, int64_t size, int64_t step) {
    return at::_ops::unfold_backward::call(grad_in, input_sizes, dim, size, step);
}

// aten::equal(Tensor self, Tensor other) -> bool
TORCH_API inline bool equal(const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::equal::call(self, other);
}

// aten::pow.Tensor_Tensor_out(Tensor self, Tensor exponent, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & pow_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & exponent) {
    return at::_ops::pow_Tensor_Tensor_out::call(self, exponent, out);
}

// aten::pow.Tensor_Tensor_out(Tensor self, Tensor exponent, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & pow_outf(const at::Tensor & self, const at::Tensor & exponent, at::Tensor & out) {
    return at::_ops::pow_Tensor_Tensor_out::call(self, exponent, out);
}

// aten::pow.Tensor_Tensor(Tensor self, Tensor exponent) -> Tensor
TORCH_API inline at::Tensor pow(const at::Tensor & self, const at::Tensor & exponent) {
    return at::_ops::pow_Tensor_Tensor::call(self, exponent);
}

// aten::pow.Scalar_out(Scalar self, Tensor exponent, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & pow_out(at::Tensor & out, const at::Scalar & self, const at::Tensor & exponent) {
    return at::_ops::pow_Scalar_out::call(self, exponent, out);
}

// aten::pow.Scalar_out(Scalar self, Tensor exponent, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & pow_outf(const at::Scalar & self, const at::Tensor & exponent, at::Tensor & out) {
    return at::_ops::pow_Scalar_out::call(self, exponent, out);
}

// aten::pow.Scalar(Scalar self, Tensor exponent) -> Tensor
TORCH_API inline at::Tensor pow(const at::Scalar & self, const at::Tensor & exponent) {
    return at::_ops::pow_Scalar::call(self, exponent);
}

// aten::pow.Tensor_Scalar_out(Tensor self, Scalar exponent, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & pow_out(at::Tensor & out, const at::Tensor & self, const at::Scalar & exponent) {
    return at::_ops::pow_Tensor_Scalar_out::call(self, exponent, out);
}

// aten::pow.Tensor_Scalar_out(Tensor self, Scalar exponent, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & pow_outf(const at::Tensor & self, const at::Scalar & exponent, at::Tensor & out) {
    return at::_ops::pow_Tensor_Scalar_out::call(self, exponent, out);
}

// aten::pow.Tensor_Scalar(Tensor self, Scalar exponent) -> Tensor
TORCH_API inline at::Tensor pow(const at::Tensor & self, const at::Scalar & exponent) {
    return at::_ops::pow_Tensor_Scalar::call(self, exponent);
}

// aten::float_power.Tensor_Tensor_out(Tensor self, Tensor exponent, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & float_power_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & exponent) {
    return at::_ops::float_power_Tensor_Tensor_out::call(self, exponent, out);
}

// aten::float_power.Tensor_Tensor_out(Tensor self, Tensor exponent, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & float_power_outf(const at::Tensor & self, const at::Tensor & exponent, at::Tensor & out) {
    return at::_ops::float_power_Tensor_Tensor_out::call(self, exponent, out);
}

// aten::float_power.Tensor_Tensor(Tensor self, Tensor exponent) -> Tensor
TORCH_API inline at::Tensor float_power(const at::Tensor & self, const at::Tensor & exponent) {
    return at::_ops::float_power_Tensor_Tensor::call(self, exponent);
}

// aten::float_power.Scalar_out(Scalar self, Tensor exponent, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & float_power_out(at::Tensor & out, const at::Scalar & self, const at::Tensor & exponent) {
    return at::_ops::float_power_Scalar_out::call(self, exponent, out);
}

// aten::float_power.Scalar_out(Scalar self, Tensor exponent, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & float_power_outf(const at::Scalar & self, const at::Tensor & exponent, at::Tensor & out) {
    return at::_ops::float_power_Scalar_out::call(self, exponent, out);
}

// aten::float_power.Scalar(Scalar self, Tensor exponent) -> Tensor
TORCH_API inline at::Tensor float_power(const at::Scalar & self, const at::Tensor & exponent) {
    return at::_ops::float_power_Scalar::call(self, exponent);
}

// aten::float_power.Tensor_Scalar_out(Tensor self, Scalar exponent, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & float_power_out(at::Tensor & out, const at::Tensor & self, const at::Scalar & exponent) {
    return at::_ops::float_power_Tensor_Scalar_out::call(self, exponent, out);
}

// aten::float_power.Tensor_Scalar_out(Tensor self, Scalar exponent, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & float_power_outf(const at::Tensor & self, const at::Scalar & exponent, at::Tensor & out) {
    return at::_ops::float_power_Tensor_Scalar_out::call(self, exponent, out);
}

// aten::float_power.Tensor_Scalar(Tensor self, Scalar exponent) -> Tensor
TORCH_API inline at::Tensor float_power(const at::Tensor & self, const at::Scalar & exponent) {
    return at::_ops::float_power_Tensor_Scalar::call(self, exponent);
}

// aten::normal.Tensor_float_out(Tensor mean, float std=1, *, Generator? generator=None, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & normal_out(at::Tensor & out, const at::Tensor & mean, double std=1, c10::optional<at::Generator> generator=c10::nullopt) {
    return at::_ops::normal_Tensor_float_out::call(mean, std, generator, out);
}

// aten::normal.Tensor_float_out(Tensor mean, float std=1, *, Generator? generator=None, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & normal_outf(const at::Tensor & mean, double std, c10::optional<at::Generator> generator, at::Tensor & out) {
    return at::_ops::normal_Tensor_float_out::call(mean, std, generator, out);
}

// aten::normal.Tensor_float(Tensor mean, float std=1, *, Generator? generator=None) -> Tensor
TORCH_API inline at::Tensor normal(const at::Tensor & mean, double std=1, c10::optional<at::Generator> generator=c10::nullopt) {
    return at::_ops::normal_Tensor_float::call(mean, std, generator);
}

// aten::normal.float_Tensor_out(float mean, Tensor std, *, Generator? generator=None, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & normal_out(at::Tensor & out, double mean, const at::Tensor & std, c10::optional<at::Generator> generator=c10::nullopt) {
    return at::_ops::normal_float_Tensor_out::call(mean, std, generator, out);
}

// aten::normal.float_Tensor_out(float mean, Tensor std, *, Generator? generator=None, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & normal_outf(double mean, const at::Tensor & std, c10::optional<at::Generator> generator, at::Tensor & out) {
    return at::_ops::normal_float_Tensor_out::call(mean, std, generator, out);
}

// aten::normal.float_Tensor(float mean, Tensor std, *, Generator? generator=None) -> Tensor
TORCH_API inline at::Tensor normal(double mean, const at::Tensor & std, c10::optional<at::Generator> generator=c10::nullopt) {
    return at::_ops::normal_float_Tensor::call(mean, std, generator);
}

// aten::normal.Tensor_Tensor_out(Tensor mean, Tensor std, *, Generator? generator=None, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & normal_out(at::Tensor & out, const at::Tensor & mean, const at::Tensor & std, c10::optional<at::Generator> generator=c10::nullopt) {
    return at::_ops::normal_Tensor_Tensor_out::call(mean, std, generator, out);
}

// aten::normal.Tensor_Tensor_out(Tensor mean, Tensor std, *, Generator? generator=None, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & normal_outf(const at::Tensor & mean, const at::Tensor & std, c10::optional<at::Generator> generator, at::Tensor & out) {
    return at::_ops::normal_Tensor_Tensor_out::call(mean, std, generator, out);
}

// aten::normal.Tensor_Tensor(Tensor mean, Tensor std, *, Generator? generator=None) -> Tensor
TORCH_API inline at::Tensor normal(const at::Tensor & mean, const at::Tensor & std, c10::optional<at::Generator> generator=c10::nullopt) {
    return at::_ops::normal_Tensor_Tensor::call(mean, std, generator);
}

// aten::normal.float_float(float mean, float std, int[] size, *, Generator? generator=None, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor normal(double mean, double std, at::IntArrayRef size, c10::optional<at::Generator> generator=c10::nullopt, at::TensorOptions options={}) {
    return at::_ops::normal_float_float::call(mean, std, size, generator, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt());
}

// aten::normal.float_float(float mean, float std, int[] size, *, Generator? generator=None, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor normal(double mean, double std, at::IntArrayRef size, c10::optional<at::Generator> generator, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory) {
    return at::_ops::normal_float_float::call(mean, std, size, generator, dtype, layout, device, pin_memory);
}

// aten::normal.float_float_out(float mean, float std, int[] size, *, Generator? generator=None, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & normal_out(at::Tensor & out, double mean, double std, at::IntArrayRef size, c10::optional<at::Generator> generator=c10::nullopt) {
    return at::_ops::normal_float_float_out::call(mean, std, size, generator, out);
}

// aten::normal.float_float_out(float mean, float std, int[] size, *, Generator? generator=None, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & normal_outf(double mean, double std, at::IntArrayRef size, c10::optional<at::Generator> generator, at::Tensor & out) {
    return at::_ops::normal_float_float_out::call(mean, std, size, generator, out);
}

// aten::alias(Tensor(a) self) -> Tensor(a)
TORCH_API inline at::Tensor alias(const at::Tensor & self) {
    return at::_ops::alias::call(self);
}

// aten::_index_copy_(Tensor(a!) self, int dim, Tensor index, Tensor source) -> Tensor(a!)
TORCH_API inline at::Tensor & _index_copy_(at::Tensor & self, int64_t dim, const at::Tensor & index, const at::Tensor & source) {
    return at::_ops::_index_copy_::call(self, dim, index, source);
}

// aten::_amp_foreach_non_finite_check_and_unscale_(Tensor(a!)[] self, Tensor(b!) found_inf, Tensor inv_scale) -> ()
TORCH_API inline void _amp_foreach_non_finite_check_and_unscale_(at::TensorList self, at::Tensor & found_inf, const at::Tensor & inv_scale) {
    return at::_ops::_amp_foreach_non_finite_check_and_unscale_::call(self, found_inf, inv_scale);
}

// aten::_amp_update_scale_(Tensor(a!) self, Tensor(b!) growth_tracker, Tensor found_inf, float scale_growth_factor, float scale_backoff_factor, int growth_interval) -> Tensor(a!)
TORCH_API inline at::Tensor & _amp_update_scale_(at::Tensor & self, at::Tensor & growth_tracker, const at::Tensor & found_inf, double scale_growth_factor, double scale_backoff_factor, int64_t growth_interval) {
    return at::_ops::_amp_update_scale_::call(self, growth_tracker, found_inf, scale_growth_factor, scale_backoff_factor, growth_interval);
}

// aten::_cat(Tensor[] tensors, int dim=0) -> Tensor
TORCH_API inline at::Tensor _cat(at::TensorList tensors, int64_t dim=0) {
    return at::_ops::_cat::call(tensors, dim);
}

// aten::_cat.out(Tensor[] tensors, int dim=0, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & _cat_out(at::Tensor & out, at::TensorList tensors, int64_t dim=0) {
    return at::_ops::_cat_out::call(tensors, dim, out);
}

// aten::_cat.out(Tensor[] tensors, int dim=0, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & _cat_outf(at::TensorList tensors, int64_t dim, at::Tensor & out) {
    return at::_ops::_cat_out::call(tensors, dim, out);
}

// aten::_foreach_add.Scalar(Tensor[] tensors, Scalar scalar) -> Tensor[]
TORCH_API inline ::std::vector<at::Tensor> _foreach_add(at::TensorList tensors, const at::Scalar & scalar) {
    return at::_ops::_foreach_add_Scalar::call(tensors, scalar);
}

// aten::_foreach_add_.Scalar(Tensor(a!)[] self, Scalar scalar) -> ()
TORCH_API inline void _foreach_add_(at::TensorList self, const at::Scalar & scalar) {
    return at::_ops::_foreach_add__Scalar::call(self, scalar);
}

// aten::_foreach_sub.Scalar(Tensor[] tensors, Scalar scalar) -> Tensor[]
TORCH_API inline ::std::vector<at::Tensor> _foreach_sub(at::TensorList tensors, const at::Scalar & scalar) {
    return at::_ops::_foreach_sub_Scalar::call(tensors, scalar);
}

// aten::_foreach_sub_.Scalar(Tensor(a!)[] self, Scalar scalar) -> ()
TORCH_API inline void _foreach_sub_(at::TensorList self, const at::Scalar & scalar) {
    return at::_ops::_foreach_sub__Scalar::call(self, scalar);
}

// aten::_foreach_mul.Scalar(Tensor[] tensors, Scalar scalar) -> Tensor[]
TORCH_API inline ::std::vector<at::Tensor> _foreach_mul(at::TensorList tensors, const at::Scalar & scalar) {
    return at::_ops::_foreach_mul_Scalar::call(tensors, scalar);
}

// aten::_foreach_mul_.Scalar(Tensor(a!)[] self, Scalar scalar) -> ()
TORCH_API inline void _foreach_mul_(at::TensorList self, const at::Scalar & scalar) {
    return at::_ops::_foreach_mul__Scalar::call(self, scalar);
}

// aten::_foreach_div.Scalar(Tensor[] tensors, Scalar scalar) -> Tensor[]
TORCH_API inline ::std::vector<at::Tensor> _foreach_div(at::TensorList tensors, const at::Scalar & scalar) {
    return at::_ops::_foreach_div_Scalar::call(tensors, scalar);
}

// aten::_foreach_div_.Scalar(Tensor(a!)[] self, Scalar scalar) -> ()
TORCH_API inline void _foreach_div_(at::TensorList self, const at::Scalar & scalar) {
    return at::_ops::_foreach_div__Scalar::call(self, scalar);
}

// aten::_foreach_add.List(Tensor[] tensors1, Tensor[] tensors2, *, Scalar alpha=1) -> Tensor[]
TORCH_API inline ::std::vector<at::Tensor> _foreach_add(at::TensorList tensors1, at::TensorList tensors2, const at::Scalar & alpha=1) {
    return at::_ops::_foreach_add_List::call(tensors1, tensors2, alpha);
}

// aten::_foreach_add_.List(Tensor(a!)[] self, Tensor[] other, *, Scalar alpha=1) -> ()
TORCH_API inline void _foreach_add_(at::TensorList self, at::TensorList other, const at::Scalar & alpha=1) {
    return at::_ops::_foreach_add__List::call(self, other, alpha);
}

// aten::_foreach_sub.List(Tensor[] tensors1, Tensor[] tensors2, *, Scalar alpha=1) -> Tensor[]
TORCH_API inline ::std::vector<at::Tensor> _foreach_sub(at::TensorList tensors1, at::TensorList tensors2, const at::Scalar & alpha=1) {
    return at::_ops::_foreach_sub_List::call(tensors1, tensors2, alpha);
}

// aten::_foreach_sub_.List(Tensor(a!)[] self, Tensor[] other, *, Scalar alpha=1) -> ()
TORCH_API inline void _foreach_sub_(at::TensorList self, at::TensorList other, const at::Scalar & alpha=1) {
    return at::_ops::_foreach_sub__List::call(self, other, alpha);
}

// aten::_foreach_mul.List(Tensor[] tensors1, Tensor[] tensors2) -> Tensor[]
TORCH_API inline ::std::vector<at::Tensor> _foreach_mul(at::TensorList tensors1, at::TensorList tensors2) {
    return at::_ops::_foreach_mul_List::call(tensors1, tensors2);
}

// aten::_foreach_mul_.List(Tensor(a!)[] self, Tensor[] other) -> ()
TORCH_API inline void _foreach_mul_(at::TensorList self, at::TensorList other) {
    return at::_ops::_foreach_mul__List::call(self, other);
}

// aten::_foreach_div.List(Tensor[] tensors1, Tensor[] tensors2) -> Tensor[]
TORCH_API inline ::std::vector<at::Tensor> _foreach_div(at::TensorList tensors1, at::TensorList tensors2) {
    return at::_ops::_foreach_div_List::call(tensors1, tensors2);
}

// aten::_foreach_div_.List(Tensor(a!)[] self, Tensor[] other) -> ()
TORCH_API inline void _foreach_div_(at::TensorList self, at::TensorList other) {
    return at::_ops::_foreach_div__List::call(self, other);
}

// aten::_foreach_add.ScalarList(Tensor[] tensors, Scalar[] scalars) -> Tensor[]
TORCH_API inline ::std::vector<at::Tensor> _foreach_add(at::TensorList tensors, at::ArrayRef<at::Scalar> scalars) {
    return at::_ops::_foreach_add_ScalarList::call(tensors, scalars);
}

// aten::_foreach_add_.ScalarList(Tensor(a!)[] self, Scalar[] scalars) -> ()
TORCH_API inline void _foreach_add_(at::TensorList self, at::ArrayRef<at::Scalar> scalars) {
    return at::_ops::_foreach_add__ScalarList::call(self, scalars);
}

// aten::_foreach_sub.ScalarList(Tensor[] tensors, Scalar[] scalars) -> Tensor[]
TORCH_API inline ::std::vector<at::Tensor> _foreach_sub(at::TensorList tensors, at::ArrayRef<at::Scalar> scalars) {
    return at::_ops::_foreach_sub_ScalarList::call(tensors, scalars);
}

// aten::_foreach_sub_.ScalarList(Tensor(a!)[] self, Scalar[] scalars) -> ()
TORCH_API inline void _foreach_sub_(at::TensorList self, at::ArrayRef<at::Scalar> scalars) {
    return at::_ops::_foreach_sub__ScalarList::call(self, scalars);
}

// aten::_foreach_div.ScalarList(Tensor[] tensors, Scalar[] scalars) -> Tensor[]
TORCH_API inline ::std::vector<at::Tensor> _foreach_div(at::TensorList tensors, at::ArrayRef<at::Scalar> scalars) {
    return at::_ops::_foreach_div_ScalarList::call(tensors, scalars);
}

// aten::_foreach_div_.ScalarList(Tensor(a!)[] self, Scalar[] scalars) -> ()
TORCH_API inline void _foreach_div_(at::TensorList self, at::ArrayRef<at::Scalar> scalars) {
    return at::_ops::_foreach_div__ScalarList::call(self, scalars);
}

// aten::_foreach_mul.ScalarList(Tensor[] tensors, Scalar[] scalars) -> Tensor[]
TORCH_API inline ::std::vector<at::Tensor> _foreach_mul(at::TensorList tensors, at::ArrayRef<at::Scalar> scalars) {
    return at::_ops::_foreach_mul_ScalarList::call(tensors, scalars);
}

// aten::_foreach_mul_.ScalarList(Tensor(a!)[] self, Scalar[] scalars) -> ()
TORCH_API inline void _foreach_mul_(at::TensorList self, at::ArrayRef<at::Scalar> scalars) {
    return at::_ops::_foreach_mul__ScalarList::call(self, scalars);
}

// aten::_foreach_exp(Tensor[] tensors) -> Tensor[]
TORCH_API inline ::std::vector<at::Tensor> _foreach_exp(at::TensorList tensors) {
    return at::_ops::_foreach_exp::call(tensors);
}

// aten::_foreach_zero_(Tensor(a!)[] self) -> ()
TORCH_API inline void _foreach_zero_(at::TensorList self) {
    return at::_ops::_foreach_zero_::call(self);
}

// aten::_foreach_exp_(Tensor(a!)[] self) -> ()
TORCH_API inline void _foreach_exp_(at::TensorList self) {
    return at::_ops::_foreach_exp_::call(self);
}

// aten::_foreach_sqrt(Tensor[] tensors) -> Tensor[]
TORCH_API inline ::std::vector<at::Tensor> _foreach_sqrt(at::TensorList tensors) {
    return at::_ops::_foreach_sqrt::call(tensors);
}

// aten::_foreach_sqrt_(Tensor(a!)[] self) -> ()
TORCH_API inline void _foreach_sqrt_(at::TensorList self) {
    return at::_ops::_foreach_sqrt_::call(self);
}

// aten::_foreach_abs(Tensor[] tensors) -> Tensor[]
TORCH_API inline ::std::vector<at::Tensor> _foreach_abs(at::TensorList tensors) {
    return at::_ops::_foreach_abs::call(tensors);
}

// aten::_foreach_abs_(Tensor(a!)[] self) -> ()
TORCH_API inline void _foreach_abs_(at::TensorList self) {
    return at::_ops::_foreach_abs_::call(self);
}

// aten::_foreach_acos(Tensor[] tensors) -> Tensor[]
TORCH_API inline ::std::vector<at::Tensor> _foreach_acos(at::TensorList tensors) {
    return at::_ops::_foreach_acos::call(tensors);
}

// aten::_foreach_acos_(Tensor(a!)[] self) -> ()
TORCH_API inline void _foreach_acos_(at::TensorList self) {
    return at::_ops::_foreach_acos_::call(self);
}

// aten::_foreach_asin(Tensor[] tensors) -> Tensor[]
TORCH_API inline ::std::vector<at::Tensor> _foreach_asin(at::TensorList tensors) {
    return at::_ops::_foreach_asin::call(tensors);
}

// aten::_foreach_asin_(Tensor(a!)[] self) -> ()
TORCH_API inline void _foreach_asin_(at::TensorList self) {
    return at::_ops::_foreach_asin_::call(self);
}

// aten::_foreach_atan(Tensor[] tensors) -> Tensor[]
TORCH_API inline ::std::vector<at::Tensor> _foreach_atan(at::TensorList tensors) {
    return at::_ops::_foreach_atan::call(tensors);
}

// aten::_foreach_atan_(Tensor(a!)[] self) -> ()
TORCH_API inline void _foreach_atan_(at::TensorList self) {
    return at::_ops::_foreach_atan_::call(self);
}

// aten::_foreach_ceil(Tensor[] tensors) -> Tensor[]
TORCH_API inline ::std::vector<at::Tensor> _foreach_ceil(at::TensorList tensors) {
    return at::_ops::_foreach_ceil::call(tensors);
}

// aten::_foreach_ceil_(Tensor(a!)[] self) -> ()
TORCH_API inline void _foreach_ceil_(at::TensorList self) {
    return at::_ops::_foreach_ceil_::call(self);
}

// aten::_foreach_cos(Tensor[] tensors) -> Tensor[]
TORCH_API inline ::std::vector<at::Tensor> _foreach_cos(at::TensorList tensors) {
    return at::_ops::_foreach_cos::call(tensors);
}

// aten::_foreach_cos_(Tensor(a!)[] self) -> ()
TORCH_API inline void _foreach_cos_(at::TensorList self) {
    return at::_ops::_foreach_cos_::call(self);
}

// aten::_foreach_cosh(Tensor[] tensors) -> Tensor[]
TORCH_API inline ::std::vector<at::Tensor> _foreach_cosh(at::TensorList tensors) {
    return at::_ops::_foreach_cosh::call(tensors);
}

// aten::_foreach_cosh_(Tensor(a!)[] self) -> ()
TORCH_API inline void _foreach_cosh_(at::TensorList self) {
    return at::_ops::_foreach_cosh_::call(self);
}

// aten::_foreach_erf(Tensor[] tensors) -> Tensor[]
TORCH_API inline ::std::vector<at::Tensor> _foreach_erf(at::TensorList tensors) {
    return at::_ops::_foreach_erf::call(tensors);
}

// aten::_foreach_erf_(Tensor(a!)[] self) -> ()
TORCH_API inline void _foreach_erf_(at::TensorList self) {
    return at::_ops::_foreach_erf_::call(self);
}

// aten::_foreach_erfc(Tensor[] tensors) -> Tensor[]
TORCH_API inline ::std::vector<at::Tensor> _foreach_erfc(at::TensorList tensors) {
    return at::_ops::_foreach_erfc::call(tensors);
}

// aten::_foreach_erfc_(Tensor(a!)[] self) -> ()
TORCH_API inline void _foreach_erfc_(at::TensorList self) {
    return at::_ops::_foreach_erfc_::call(self);
}

// aten::_foreach_expm1(Tensor[] tensors) -> Tensor[]
TORCH_API inline ::std::vector<at::Tensor> _foreach_expm1(at::TensorList tensors) {
    return at::_ops::_foreach_expm1::call(tensors);
}

// aten::_foreach_expm1_(Tensor(a!)[] self) -> ()
TORCH_API inline void _foreach_expm1_(at::TensorList self) {
    return at::_ops::_foreach_expm1_::call(self);
}

// aten::_foreach_floor(Tensor[] tensors) -> Tensor[]
TORCH_API inline ::std::vector<at::Tensor> _foreach_floor(at::TensorList tensors) {
    return at::_ops::_foreach_floor::call(tensors);
}

// aten::_foreach_floor_(Tensor(a!)[] self) -> ()
TORCH_API inline void _foreach_floor_(at::TensorList self) {
    return at::_ops::_foreach_floor_::call(self);
}

// aten::_foreach_log(Tensor[] tensors) -> Tensor[]
TORCH_API inline ::std::vector<at::Tensor> _foreach_log(at::TensorList tensors) {
    return at::_ops::_foreach_log::call(tensors);
}

// aten::_foreach_log_(Tensor(a!)[] self) -> ()
TORCH_API inline void _foreach_log_(at::TensorList self) {
    return at::_ops::_foreach_log_::call(self);
}

// aten::_foreach_log10(Tensor[] tensors) -> Tensor[]
TORCH_API inline ::std::vector<at::Tensor> _foreach_log10(at::TensorList tensors) {
    return at::_ops::_foreach_log10::call(tensors);
}

// aten::_foreach_log10_(Tensor(a!)[] self) -> ()
TORCH_API inline void _foreach_log10_(at::TensorList self) {
    return at::_ops::_foreach_log10_::call(self);
}

// aten::_foreach_log1p(Tensor[] tensors) -> Tensor[]
TORCH_API inline ::std::vector<at::Tensor> _foreach_log1p(at::TensorList tensors) {
    return at::_ops::_foreach_log1p::call(tensors);
}

// aten::_foreach_log1p_(Tensor(a!)[] self) -> ()
TORCH_API inline void _foreach_log1p_(at::TensorList self) {
    return at::_ops::_foreach_log1p_::call(self);
}

// aten::_foreach_log2(Tensor[] tensors) -> Tensor[]
TORCH_API inline ::std::vector<at::Tensor> _foreach_log2(at::TensorList tensors) {
    return at::_ops::_foreach_log2::call(tensors);
}

// aten::_foreach_log2_(Tensor(a!)[] self) -> ()
TORCH_API inline void _foreach_log2_(at::TensorList self) {
    return at::_ops::_foreach_log2_::call(self);
}

// aten::_foreach_neg(Tensor[] tensors) -> Tensor[]
TORCH_API inline ::std::vector<at::Tensor> _foreach_neg(at::TensorList tensors) {
    return at::_ops::_foreach_neg::call(tensors);
}

// aten::_foreach_neg_(Tensor(a!)[] self) -> ()
TORCH_API inline void _foreach_neg_(at::TensorList self) {
    return at::_ops::_foreach_neg_::call(self);
}

// aten::_foreach_tan(Tensor[] tensors) -> Tensor[]
TORCH_API inline ::std::vector<at::Tensor> _foreach_tan(at::TensorList tensors) {
    return at::_ops::_foreach_tan::call(tensors);
}

// aten::_foreach_tan_(Tensor(a!)[] self) -> ()
TORCH_API inline void _foreach_tan_(at::TensorList self) {
    return at::_ops::_foreach_tan_::call(self);
}

// aten::_foreach_tanh(Tensor[] tensors) -> Tensor[]
TORCH_API inline ::std::vector<at::Tensor> _foreach_tanh(at::TensorList tensors) {
    return at::_ops::_foreach_tanh::call(tensors);
}

// aten::_foreach_tanh_(Tensor(a!)[] self) -> ()
TORCH_API inline void _foreach_tanh_(at::TensorList self) {
    return at::_ops::_foreach_tanh_::call(self);
}

// aten::_foreach_sin(Tensor[] tensors) -> Tensor[]
TORCH_API inline ::std::vector<at::Tensor> _foreach_sin(at::TensorList tensors) {
    return at::_ops::_foreach_sin::call(tensors);
}

// aten::_foreach_sin_(Tensor(a!)[] self) -> ()
TORCH_API inline void _foreach_sin_(at::TensorList self) {
    return at::_ops::_foreach_sin_::call(self);
}

// aten::_foreach_sinh(Tensor[] tensors) -> Tensor[]
TORCH_API inline ::std::vector<at::Tensor> _foreach_sinh(at::TensorList tensors) {
    return at::_ops::_foreach_sinh::call(tensors);
}

// aten::_foreach_sinh_(Tensor(a!)[] self) -> ()
TORCH_API inline void _foreach_sinh_(at::TensorList self) {
    return at::_ops::_foreach_sinh_::call(self);
}

// aten::_foreach_round(Tensor[] tensors) -> Tensor[]
TORCH_API inline ::std::vector<at::Tensor> _foreach_round(at::TensorList tensors) {
    return at::_ops::_foreach_round::call(tensors);
}

// aten::_foreach_round_(Tensor(a!)[] self) -> ()
TORCH_API inline void _foreach_round_(at::TensorList self) {
    return at::_ops::_foreach_round_::call(self);
}

// aten::_foreach_lgamma(Tensor[] tensors) -> Tensor[]
TORCH_API inline ::std::vector<at::Tensor> _foreach_lgamma(at::TensorList tensors) {
    return at::_ops::_foreach_lgamma::call(tensors);
}

// aten::_foreach_lgamma_(Tensor(a!)[] self) -> ()
TORCH_API inline void _foreach_lgamma_(at::TensorList self) {
    return at::_ops::_foreach_lgamma_::call(self);
}

// aten::_foreach_frac(Tensor[] tensors) -> Tensor[]
TORCH_API inline ::std::vector<at::Tensor> _foreach_frac(at::TensorList tensors) {
    return at::_ops::_foreach_frac::call(tensors);
}

// aten::_foreach_frac_(Tensor(a!)[] self) -> ()
TORCH_API inline void _foreach_frac_(at::TensorList self) {
    return at::_ops::_foreach_frac_::call(self);
}

// aten::_foreach_reciprocal(Tensor[] tensors) -> Tensor[]
TORCH_API inline ::std::vector<at::Tensor> _foreach_reciprocal(at::TensorList tensors) {
    return at::_ops::_foreach_reciprocal::call(tensors);
}

// aten::_foreach_reciprocal_(Tensor(a!)[] self) -> ()
TORCH_API inline void _foreach_reciprocal_(at::TensorList self) {
    return at::_ops::_foreach_reciprocal_::call(self);
}

// aten::_foreach_sigmoid(Tensor[] tensors) -> Tensor[]
TORCH_API inline ::std::vector<at::Tensor> _foreach_sigmoid(at::TensorList tensors) {
    return at::_ops::_foreach_sigmoid::call(tensors);
}

// aten::_foreach_sigmoid_(Tensor(a!)[] self) -> ()
TORCH_API inline void _foreach_sigmoid_(at::TensorList self) {
    return at::_ops::_foreach_sigmoid_::call(self);
}

// aten::_foreach_trunc(Tensor[] tensors) -> Tensor[]
TORCH_API inline ::std::vector<at::Tensor> _foreach_trunc(at::TensorList tensors) {
    return at::_ops::_foreach_trunc::call(tensors);
}

// aten::_foreach_trunc_(Tensor(a!)[] self) -> ()
TORCH_API inline void _foreach_trunc_(at::TensorList self) {
    return at::_ops::_foreach_trunc_::call(self);
}

// aten::_foreach_addcdiv_.Scalar(Tensor(a!)[] self, Tensor[] tensor1, Tensor[] tensor2, Scalar value=1) -> ()
TORCH_API inline void _foreach_addcdiv_(at::TensorList self, at::TensorList tensor1, at::TensorList tensor2, const at::Scalar & value=1) {
    return at::_ops::_foreach_addcdiv__Scalar::call(self, tensor1, tensor2, value);
}

// aten::_foreach_addcmul_.Scalar(Tensor(a!)[] self, Tensor[] tensor1, Tensor[] tensor2, Scalar value=1) -> ()
TORCH_API inline void _foreach_addcmul_(at::TensorList self, at::TensorList tensor1, at::TensorList tensor2, const at::Scalar & value=1) {
    return at::_ops::_foreach_addcmul__Scalar::call(self, tensor1, tensor2, value);
}

// aten::_foreach_addcdiv_.ScalarList(Tensor(a!)[] self, Tensor[] tensor1, Tensor[] tensor2, Scalar[] scalars) -> ()
TORCH_API inline void _foreach_addcdiv_(at::TensorList self, at::TensorList tensor1, at::TensorList tensor2, at::ArrayRef<at::Scalar> scalars) {
    return at::_ops::_foreach_addcdiv__ScalarList::call(self, tensor1, tensor2, scalars);
}

// aten::_foreach_addcmul_.ScalarList(Tensor(a!)[] self, Tensor[] tensor1, Tensor[] tensor2, Scalar[] scalars) -> ()
TORCH_API inline void _foreach_addcmul_(at::TensorList self, at::TensorList tensor1, at::TensorList tensor2, at::ArrayRef<at::Scalar> scalars) {
    return at::_ops::_foreach_addcmul__ScalarList::call(self, tensor1, tensor2, scalars);
}

// aten::_foreach_addcdiv.Scalar(Tensor[] input, Tensor[] tensor1, Tensor[] tensor2, Scalar value=1) -> Tensor[]
TORCH_API inline ::std::vector<at::Tensor> _foreach_addcdiv(at::TensorList input, at::TensorList tensor1, at::TensorList tensor2, const at::Scalar & value=1) {
    return at::_ops::_foreach_addcdiv_Scalar::call(input, tensor1, tensor2, value);
}

// aten::_foreach_addcmul.Scalar(Tensor[] input, Tensor[] tensor1, Tensor[] tensor2, Scalar value=1) -> Tensor[]
TORCH_API inline ::std::vector<at::Tensor> _foreach_addcmul(at::TensorList input, at::TensorList tensor1, at::TensorList tensor2, const at::Scalar & value=1) {
    return at::_ops::_foreach_addcmul_Scalar::call(input, tensor1, tensor2, value);
}

// aten::_foreach_addcdiv.ScalarList(Tensor[] input, Tensor[] tensor1, Tensor[] tensor2, Scalar[] scalars) -> Tensor[]
TORCH_API inline ::std::vector<at::Tensor> _foreach_addcdiv(at::TensorList input, at::TensorList tensor1, at::TensorList tensor2, at::ArrayRef<at::Scalar> scalars) {
    return at::_ops::_foreach_addcdiv_ScalarList::call(input, tensor1, tensor2, scalars);
}

// aten::_foreach_addcmul.ScalarList(Tensor[] input, Tensor[] tensor1, Tensor[] tensor2, Scalar[] scalars) -> Tensor[]
TORCH_API inline ::std::vector<at::Tensor> _foreach_addcmul(at::TensorList input, at::TensorList tensor1, at::TensorList tensor2, at::ArrayRef<at::Scalar> scalars) {
    return at::_ops::_foreach_addcmul_ScalarList::call(input, tensor1, tensor2, scalars);
}

// aten::_foreach_maximum.List(Tensor[] tensors1, Tensor[] tensors2) -> Tensor[]
TORCH_API inline ::std::vector<at::Tensor> _foreach_maximum(at::TensorList tensors1, at::TensorList tensors2) {
    return at::_ops::_foreach_maximum_List::call(tensors1, tensors2);
}

// aten::_foreach_minimum.List(Tensor[] tensors1, Tensor[] tensors2) -> Tensor[]
TORCH_API inline ::std::vector<at::Tensor> _foreach_minimum(at::TensorList tensors1, at::TensorList tensors2) {
    return at::_ops::_foreach_minimum_List::call(tensors1, tensors2);
}

// aten::bucketize.Tensor(Tensor self, Tensor boundaries, *, bool out_int32=False, bool right=False) -> Tensor
TORCH_API inline at::Tensor bucketize(const at::Tensor & self, const at::Tensor & boundaries, bool out_int32=false, bool right=false) {
    return at::_ops::bucketize_Tensor::call(self, boundaries, out_int32, right);
}

// aten::bucketize.Tensor_out(Tensor self, Tensor boundaries, *, bool out_int32=False, bool right=False, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & bucketize_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & boundaries, bool out_int32=false, bool right=false) {
    return at::_ops::bucketize_Tensor_out::call(self, boundaries, out_int32, right, out);
}

// aten::bucketize.Tensor_out(Tensor self, Tensor boundaries, *, bool out_int32=False, bool right=False, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & bucketize_outf(const at::Tensor & self, const at::Tensor & boundaries, bool out_int32, bool right, at::Tensor & out) {
    return at::_ops::bucketize_Tensor_out::call(self, boundaries, out_int32, right, out);
}

// aten::bucketize.Scalar(Scalar self, Tensor boundaries, *, bool out_int32=False, bool right=False) -> Tensor
TORCH_API inline at::Tensor bucketize(const at::Scalar & self, const at::Tensor & boundaries, bool out_int32=false, bool right=false) {
    return at::_ops::bucketize_Scalar::call(self, boundaries, out_int32, right);
}

// aten::searchsorted.Tensor(Tensor sorted_sequence, Tensor self, *, bool out_int32=False, bool right=False) -> Tensor
TORCH_API inline at::Tensor searchsorted(const at::Tensor & sorted_sequence, const at::Tensor & self, bool out_int32=false, bool right=false) {
    return at::_ops::searchsorted_Tensor::call(sorted_sequence, self, out_int32, right);
}

// aten::searchsorted.Tensor_out(Tensor sorted_sequence, Tensor self, *, bool out_int32=False, bool right=False, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & searchsorted_out(at::Tensor & out, const at::Tensor & sorted_sequence, const at::Tensor & self, bool out_int32=false, bool right=false) {
    return at::_ops::searchsorted_Tensor_out::call(sorted_sequence, self, out_int32, right, out);
}

// aten::searchsorted.Tensor_out(Tensor sorted_sequence, Tensor self, *, bool out_int32=False, bool right=False, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & searchsorted_outf(const at::Tensor & sorted_sequence, const at::Tensor & self, bool out_int32, bool right, at::Tensor & out) {
    return at::_ops::searchsorted_Tensor_out::call(sorted_sequence, self, out_int32, right, out);
}

// aten::searchsorted.Scalar(Tensor sorted_sequence, Scalar self, *, bool out_int32=False, bool right=False) -> Tensor
TORCH_API inline at::Tensor searchsorted(const at::Tensor & sorted_sequence, const at::Scalar & self, bool out_int32=false, bool right=false) {
    return at::_ops::searchsorted_Scalar::call(sorted_sequence, self, out_int32, right);
}

// aten::_convert_indices_from_coo_to_csr(Tensor self, int size, *, bool out_int32=False) -> Tensor
TORCH_API inline at::Tensor _convert_indices_from_coo_to_csr(const at::Tensor & self, int64_t size, bool out_int32=false) {
    return at::_ops::_convert_indices_from_coo_to_csr::call(self, size, out_int32);
}

// aten::_convert_indices_from_coo_to_csr.out(Tensor self, int size, *, bool out_int32=False, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & _convert_indices_from_coo_to_csr_out(at::Tensor & out, const at::Tensor & self, int64_t size, bool out_int32=false) {
    return at::_ops::_convert_indices_from_coo_to_csr_out::call(self, size, out_int32, out);
}

// aten::_convert_indices_from_coo_to_csr.out(Tensor self, int size, *, bool out_int32=False, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & _convert_indices_from_coo_to_csr_outf(const at::Tensor & self, int64_t size, bool out_int32, at::Tensor & out) {
    return at::_ops::_convert_indices_from_coo_to_csr_out::call(self, size, out_int32, out);
}

// aten::mse_loss.out(Tensor self, Tensor target, int reduction=Mean, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & mse_loss_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & target, int64_t reduction=at::Reduction::Mean) {
    return at::_ops::mse_loss_out::call(self, target, reduction, out);
}

// aten::mse_loss.out(Tensor self, Tensor target, int reduction=Mean, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & mse_loss_outf(const at::Tensor & self, const at::Tensor & target, int64_t reduction, at::Tensor & out) {
    return at::_ops::mse_loss_out::call(self, target, reduction, out);
}

// aten::mse_loss(Tensor self, Tensor target, int reduction=Mean) -> Tensor
TORCH_API inline at::Tensor mse_loss(const at::Tensor & self, const at::Tensor & target, int64_t reduction=at::Reduction::Mean) {
    return at::_ops::mse_loss::call(self, target, reduction);
}

// aten::mse_loss_backward.grad_input(Tensor grad_output, Tensor self, Tensor target, int reduction, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & mse_loss_backward_out(at::Tensor & grad_input, const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & target, int64_t reduction) {
    return at::_ops::mse_loss_backward_grad_input::call(grad_output, self, target, reduction, grad_input);
}

// aten::mse_loss_backward.grad_input(Tensor grad_output, Tensor self, Tensor target, int reduction, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & mse_loss_backward_outf(const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & target, int64_t reduction, at::Tensor & grad_input) {
    return at::_ops::mse_loss_backward_grad_input::call(grad_output, self, target, reduction, grad_input);
}

// aten::mse_loss_backward(Tensor grad_output, Tensor self, Tensor target, int reduction) -> Tensor
TORCH_API inline at::Tensor mse_loss_backward(const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & target, int64_t reduction) {
    return at::_ops::mse_loss_backward::call(grad_output, self, target, reduction);
}

// aten::l1_loss.out(Tensor self, Tensor target, int reduction=Mean, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & l1_loss_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & target, int64_t reduction=at::Reduction::Mean) {
    return at::_ops::l1_loss_out::call(self, target, reduction, out);
}

// aten::l1_loss.out(Tensor self, Tensor target, int reduction=Mean, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & l1_loss_outf(const at::Tensor & self, const at::Tensor & target, int64_t reduction, at::Tensor & out) {
    return at::_ops::l1_loss_out::call(self, target, reduction, out);
}

// aten::l1_loss(Tensor self, Tensor target, int reduction=Mean) -> Tensor
TORCH_API inline at::Tensor l1_loss(const at::Tensor & self, const at::Tensor & target, int64_t reduction=at::Reduction::Mean) {
    return at::_ops::l1_loss::call(self, target, reduction);
}

// aten::l1_loss_backward.grad_input(Tensor grad_output, Tensor self, Tensor target, int reduction, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & l1_loss_backward_out(at::Tensor & grad_input, const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & target, int64_t reduction) {
    return at::_ops::l1_loss_backward_grad_input::call(grad_output, self, target, reduction, grad_input);
}

// aten::l1_loss_backward.grad_input(Tensor grad_output, Tensor self, Tensor target, int reduction, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & l1_loss_backward_outf(const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & target, int64_t reduction, at::Tensor & grad_input) {
    return at::_ops::l1_loss_backward_grad_input::call(grad_output, self, target, reduction, grad_input);
}

// aten::l1_loss_backward(Tensor grad_output, Tensor self, Tensor target, int reduction) -> Tensor
TORCH_API inline at::Tensor l1_loss_backward(const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & target, int64_t reduction) {
    return at::_ops::l1_loss_backward::call(grad_output, self, target, reduction);
}

// aten::multi_margin_loss.out(Tensor self, Tensor target, Scalar p=1, Scalar margin=1, Tensor? weight=None, int reduction=Mean, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & multi_margin_loss_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & target, const at::Scalar & p=1, const at::Scalar & margin=1, const c10::optional<at::Tensor> & weight={}, int64_t reduction=at::Reduction::Mean) {
    return at::_ops::multi_margin_loss_out::call(self, target, p, margin, weight, reduction, out);
}

// aten::multi_margin_loss.out(Tensor self, Tensor target, Scalar p=1, Scalar margin=1, Tensor? weight=None, int reduction=Mean, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & multi_margin_loss_outf(const at::Tensor & self, const at::Tensor & target, const at::Scalar & p, const at::Scalar & margin, const c10::optional<at::Tensor> & weight, int64_t reduction, at::Tensor & out) {
    return at::_ops::multi_margin_loss_out::call(self, target, p, margin, weight, reduction, out);
}

// aten::multi_margin_loss(Tensor self, Tensor target, Scalar p=1, Scalar margin=1, Tensor? weight=None, int reduction=Mean) -> Tensor
TORCH_API inline at::Tensor multi_margin_loss(const at::Tensor & self, const at::Tensor & target, const at::Scalar & p=1, const at::Scalar & margin=1, const c10::optional<at::Tensor> & weight={}, int64_t reduction=at::Reduction::Mean) {
    return at::_ops::multi_margin_loss::call(self, target, p, margin, weight, reduction);
}

// aten::multi_margin_loss_backward.grad_input(Tensor grad_output, Tensor self, Tensor target, Scalar p, Scalar margin, Tensor? weight=None, int reduction=Mean, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & multi_margin_loss_backward_out(at::Tensor & grad_input, const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & target, const at::Scalar & p, const at::Scalar & margin, const c10::optional<at::Tensor> & weight={}, int64_t reduction=at::Reduction::Mean) {
    return at::_ops::multi_margin_loss_backward_grad_input::call(grad_output, self, target, p, margin, weight, reduction, grad_input);
}

// aten::multi_margin_loss_backward.grad_input(Tensor grad_output, Tensor self, Tensor target, Scalar p, Scalar margin, Tensor? weight=None, int reduction=Mean, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & multi_margin_loss_backward_outf(const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & target, const at::Scalar & p, const at::Scalar & margin, const c10::optional<at::Tensor> & weight, int64_t reduction, at::Tensor & grad_input) {
    return at::_ops::multi_margin_loss_backward_grad_input::call(grad_output, self, target, p, margin, weight, reduction, grad_input);
}

// aten::multi_margin_loss_backward(Tensor grad_output, Tensor self, Tensor target, Scalar p, Scalar margin, Tensor? weight=None, int reduction=Mean) -> Tensor
TORCH_API inline at::Tensor multi_margin_loss_backward(const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & target, const at::Scalar & p, const at::Scalar & margin, const c10::optional<at::Tensor> & weight={}, int64_t reduction=at::Reduction::Mean) {
    return at::_ops::multi_margin_loss_backward::call(grad_output, self, target, p, margin, weight, reduction);
}

// aten::multilabel_margin_loss.out(Tensor self, Tensor target, int reduction=Mean, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & multilabel_margin_loss_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & target, int64_t reduction=at::Reduction::Mean) {
    return at::_ops::multilabel_margin_loss_out::call(self, target, reduction, out);
}

// aten::multilabel_margin_loss.out(Tensor self, Tensor target, int reduction=Mean, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & multilabel_margin_loss_outf(const at::Tensor & self, const at::Tensor & target, int64_t reduction, at::Tensor & out) {
    return at::_ops::multilabel_margin_loss_out::call(self, target, reduction, out);
}

// aten::multilabel_margin_loss(Tensor self, Tensor target, int reduction=Mean) -> Tensor
TORCH_API inline at::Tensor multilabel_margin_loss(const at::Tensor & self, const at::Tensor & target, int64_t reduction=at::Reduction::Mean) {
    return at::_ops::multilabel_margin_loss::call(self, target, reduction);
}

// aten::multilabel_margin_loss_forward.output(Tensor self, Tensor target, int reduction, *, Tensor(a!) output, Tensor(b!) is_target) -> (Tensor(a!), Tensor(b!))
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> multilabel_margin_loss_forward_out(at::Tensor & output, at::Tensor & is_target, const at::Tensor & self, const at::Tensor & target, int64_t reduction) {
    return at::_ops::multilabel_margin_loss_forward_output::call(self, target, reduction, output, is_target);
}

// aten::multilabel_margin_loss_forward.output(Tensor self, Tensor target, int reduction, *, Tensor(a!) output, Tensor(b!) is_target) -> (Tensor(a!), Tensor(b!))
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> multilabel_margin_loss_forward_outf(const at::Tensor & self, const at::Tensor & target, int64_t reduction, at::Tensor & output, at::Tensor & is_target) {
    return at::_ops::multilabel_margin_loss_forward_output::call(self, target, reduction, output, is_target);
}

// aten::multilabel_margin_loss_forward(Tensor self, Tensor target, int reduction) -> (Tensor output, Tensor is_target)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> multilabel_margin_loss_forward(const at::Tensor & self, const at::Tensor & target, int64_t reduction) {
    return at::_ops::multilabel_margin_loss_forward::call(self, target, reduction);
}

// aten::multilabel_margin_loss_backward.grad_input(Tensor grad_output, Tensor self, Tensor target, int reduction, Tensor is_target, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & multilabel_margin_loss_backward_out(at::Tensor & grad_input, const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & target, int64_t reduction, const at::Tensor & is_target) {
    return at::_ops::multilabel_margin_loss_backward_grad_input::call(grad_output, self, target, reduction, is_target, grad_input);
}

// aten::multilabel_margin_loss_backward.grad_input(Tensor grad_output, Tensor self, Tensor target, int reduction, Tensor is_target, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & multilabel_margin_loss_backward_outf(const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & target, int64_t reduction, const at::Tensor & is_target, at::Tensor & grad_input) {
    return at::_ops::multilabel_margin_loss_backward_grad_input::call(grad_output, self, target, reduction, is_target, grad_input);
}

// aten::multilabel_margin_loss_backward(Tensor grad_output, Tensor self, Tensor target, int reduction, Tensor is_target) -> Tensor
TORCH_API inline at::Tensor multilabel_margin_loss_backward(const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & target, int64_t reduction, const at::Tensor & is_target) {
    return at::_ops::multilabel_margin_loss_backward::call(grad_output, self, target, reduction, is_target);
}

// aten::nll_loss.out(Tensor self, Tensor target, Tensor? weight=None, int reduction=Mean, int ignore_index=-100, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & nll_loss_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & target, const c10::optional<at::Tensor> & weight={}, int64_t reduction=at::Reduction::Mean, int64_t ignore_index=-100) {
    return at::_ops::nll_loss_out::call(self, target, weight, reduction, ignore_index, out);
}

// aten::nll_loss.out(Tensor self, Tensor target, Tensor? weight=None, int reduction=Mean, int ignore_index=-100, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & nll_loss_outf(const at::Tensor & self, const at::Tensor & target, const c10::optional<at::Tensor> & weight, int64_t reduction, int64_t ignore_index, at::Tensor & out) {
    return at::_ops::nll_loss_out::call(self, target, weight, reduction, ignore_index, out);
}

// aten::nll_loss_nd(Tensor self, Tensor target, Tensor? weight=None, int reduction=Mean, int ignore_index=-100) -> Tensor
TORCH_API inline at::Tensor nll_loss_nd(const at::Tensor & self, const at::Tensor & target, const c10::optional<at::Tensor> & weight={}, int64_t reduction=at::Reduction::Mean, int64_t ignore_index=-100) {
    return at::_ops::nll_loss_nd::call(self, target, weight, reduction, ignore_index);
}

// aten::nll_loss(Tensor self, Tensor target, Tensor? weight=None, int reduction=Mean, int ignore_index=-100) -> Tensor
TORCH_API inline at::Tensor nll_loss(const at::Tensor & self, const at::Tensor & target, const c10::optional<at::Tensor> & weight={}, int64_t reduction=at::Reduction::Mean, int64_t ignore_index=-100) {
    return at::_ops::nll_loss::call(self, target, weight, reduction, ignore_index);
}

// aten::nll_loss_forward.output(Tensor self, Tensor target, Tensor? weight, int reduction, int ignore_index, *, Tensor(a!) output, Tensor(b!) total_weight) -> (Tensor(a!), Tensor(b!))
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> nll_loss_forward_out(at::Tensor & output, at::Tensor & total_weight, const at::Tensor & self, const at::Tensor & target, const c10::optional<at::Tensor> & weight, int64_t reduction, int64_t ignore_index) {
    return at::_ops::nll_loss_forward_output::call(self, target, weight, reduction, ignore_index, output, total_weight);
}

// aten::nll_loss_forward.output(Tensor self, Tensor target, Tensor? weight, int reduction, int ignore_index, *, Tensor(a!) output, Tensor(b!) total_weight) -> (Tensor(a!), Tensor(b!))
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> nll_loss_forward_outf(const at::Tensor & self, const at::Tensor & target, const c10::optional<at::Tensor> & weight, int64_t reduction, int64_t ignore_index, at::Tensor & output, at::Tensor & total_weight) {
    return at::_ops::nll_loss_forward_output::call(self, target, weight, reduction, ignore_index, output, total_weight);
}

// aten::nll_loss_forward(Tensor self, Tensor target, Tensor? weight, int reduction, int ignore_index) -> (Tensor output, Tensor total_weight)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> nll_loss_forward(const at::Tensor & self, const at::Tensor & target, const c10::optional<at::Tensor> & weight, int64_t reduction, int64_t ignore_index) {
    return at::_ops::nll_loss_forward::call(self, target, weight, reduction, ignore_index);
}

// aten::nll_loss_backward.grad_input(Tensor grad_output, Tensor self, Tensor target, Tensor? weight, int reduction, int ignore_index, Tensor total_weight, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & nll_loss_backward_out(at::Tensor & grad_input, const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & target, const c10::optional<at::Tensor> & weight, int64_t reduction, int64_t ignore_index, const at::Tensor & total_weight) {
    return at::_ops::nll_loss_backward_grad_input::call(grad_output, self, target, weight, reduction, ignore_index, total_weight, grad_input);
}

// aten::nll_loss_backward.grad_input(Tensor grad_output, Tensor self, Tensor target, Tensor? weight, int reduction, int ignore_index, Tensor total_weight, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & nll_loss_backward_outf(const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & target, const c10::optional<at::Tensor> & weight, int64_t reduction, int64_t ignore_index, const at::Tensor & total_weight, at::Tensor & grad_input) {
    return at::_ops::nll_loss_backward_grad_input::call(grad_output, self, target, weight, reduction, ignore_index, total_weight, grad_input);
}

// aten::nll_loss_backward(Tensor grad_output, Tensor self, Tensor target, Tensor? weight, int reduction, int ignore_index, Tensor total_weight) -> Tensor
TORCH_API inline at::Tensor nll_loss_backward(const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & target, const c10::optional<at::Tensor> & weight, int64_t reduction, int64_t ignore_index, const at::Tensor & total_weight) {
    return at::_ops::nll_loss_backward::call(grad_output, self, target, weight, reduction, ignore_index, total_weight);
}

// aten::nll_loss2d.out(Tensor self, Tensor target, Tensor? weight=None, int reduction=Mean, int ignore_index=-100, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & nll_loss2d_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & target, const c10::optional<at::Tensor> & weight={}, int64_t reduction=at::Reduction::Mean, int64_t ignore_index=-100) {
    return at::_ops::nll_loss2d_out::call(self, target, weight, reduction, ignore_index, out);
}

// aten::nll_loss2d.out(Tensor self, Tensor target, Tensor? weight=None, int reduction=Mean, int ignore_index=-100, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & nll_loss2d_outf(const at::Tensor & self, const at::Tensor & target, const c10::optional<at::Tensor> & weight, int64_t reduction, int64_t ignore_index, at::Tensor & out) {
    return at::_ops::nll_loss2d_out::call(self, target, weight, reduction, ignore_index, out);
}

// aten::nll_loss2d(Tensor self, Tensor target, Tensor? weight=None, int reduction=Mean, int ignore_index=-100) -> Tensor
TORCH_API inline at::Tensor nll_loss2d(const at::Tensor & self, const at::Tensor & target, const c10::optional<at::Tensor> & weight={}, int64_t reduction=at::Reduction::Mean, int64_t ignore_index=-100) {
    return at::_ops::nll_loss2d::call(self, target, weight, reduction, ignore_index);
}

// aten::nll_loss2d_forward.output(Tensor self, Tensor target, Tensor? weight, int reduction, int ignore_index, *, Tensor(a!) output, Tensor(b!) total_weight) -> (Tensor(a!), Tensor(b!))
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> nll_loss2d_forward_out(at::Tensor & output, at::Tensor & total_weight, const at::Tensor & self, const at::Tensor & target, const c10::optional<at::Tensor> & weight, int64_t reduction, int64_t ignore_index) {
    return at::_ops::nll_loss2d_forward_output::call(self, target, weight, reduction, ignore_index, output, total_weight);
}

// aten::nll_loss2d_forward.output(Tensor self, Tensor target, Tensor? weight, int reduction, int ignore_index, *, Tensor(a!) output, Tensor(b!) total_weight) -> (Tensor(a!), Tensor(b!))
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> nll_loss2d_forward_outf(const at::Tensor & self, const at::Tensor & target, const c10::optional<at::Tensor> & weight, int64_t reduction, int64_t ignore_index, at::Tensor & output, at::Tensor & total_weight) {
    return at::_ops::nll_loss2d_forward_output::call(self, target, weight, reduction, ignore_index, output, total_weight);
}

// aten::nll_loss2d_forward(Tensor self, Tensor target, Tensor? weight, int reduction, int ignore_index) -> (Tensor output, Tensor total_weight)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> nll_loss2d_forward(const at::Tensor & self, const at::Tensor & target, const c10::optional<at::Tensor> & weight, int64_t reduction, int64_t ignore_index) {
    return at::_ops::nll_loss2d_forward::call(self, target, weight, reduction, ignore_index);
}

// aten::nll_loss2d_backward.grad_input(Tensor grad_output, Tensor self, Tensor target, Tensor? weight, int reduction, int ignore_index, Tensor total_weight, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & nll_loss2d_backward_out(at::Tensor & grad_input, const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & target, const c10::optional<at::Tensor> & weight, int64_t reduction, int64_t ignore_index, const at::Tensor & total_weight) {
    return at::_ops::nll_loss2d_backward_grad_input::call(grad_output, self, target, weight, reduction, ignore_index, total_weight, grad_input);
}

// aten::nll_loss2d_backward.grad_input(Tensor grad_output, Tensor self, Tensor target, Tensor? weight, int reduction, int ignore_index, Tensor total_weight, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & nll_loss2d_backward_outf(const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & target, const c10::optional<at::Tensor> & weight, int64_t reduction, int64_t ignore_index, const at::Tensor & total_weight, at::Tensor & grad_input) {
    return at::_ops::nll_loss2d_backward_grad_input::call(grad_output, self, target, weight, reduction, ignore_index, total_weight, grad_input);
}

// aten::nll_loss2d_backward(Tensor grad_output, Tensor self, Tensor target, Tensor? weight, int reduction, int ignore_index, Tensor total_weight) -> Tensor
TORCH_API inline at::Tensor nll_loss2d_backward(const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & target, const c10::optional<at::Tensor> & weight, int64_t reduction, int64_t ignore_index, const at::Tensor & total_weight) {
    return at::_ops::nll_loss2d_backward::call(grad_output, self, target, weight, reduction, ignore_index, total_weight);
}

// aten::smooth_l1_loss.out(Tensor self, Tensor target, int reduction=Mean, float beta=1.0, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & smooth_l1_loss_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & target, int64_t reduction=at::Reduction::Mean, double beta=1.0) {
    return at::_ops::smooth_l1_loss_out::call(self, target, reduction, beta, out);
}

// aten::smooth_l1_loss.out(Tensor self, Tensor target, int reduction=Mean, float beta=1.0, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & smooth_l1_loss_outf(const at::Tensor & self, const at::Tensor & target, int64_t reduction, double beta, at::Tensor & out) {
    return at::_ops::smooth_l1_loss_out::call(self, target, reduction, beta, out);
}

// aten::smooth_l1_loss(Tensor self, Tensor target, int reduction=Mean, float beta=1.0) -> Tensor
TORCH_API inline at::Tensor smooth_l1_loss(const at::Tensor & self, const at::Tensor & target, int64_t reduction=at::Reduction::Mean, double beta=1.0) {
    return at::_ops::smooth_l1_loss::call(self, target, reduction, beta);
}

// aten::smooth_l1_loss_backward.grad_input(Tensor grad_output, Tensor self, Tensor target, int reduction, float beta, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & smooth_l1_loss_backward_out(at::Tensor & grad_input, const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & target, int64_t reduction, double beta) {
    return at::_ops::smooth_l1_loss_backward_grad_input::call(grad_output, self, target, reduction, beta, grad_input);
}

// aten::smooth_l1_loss_backward.grad_input(Tensor grad_output, Tensor self, Tensor target, int reduction, float beta, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & smooth_l1_loss_backward_outf(const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & target, int64_t reduction, double beta, at::Tensor & grad_input) {
    return at::_ops::smooth_l1_loss_backward_grad_input::call(grad_output, self, target, reduction, beta, grad_input);
}

// aten::smooth_l1_loss_backward(Tensor grad_output, Tensor self, Tensor target, int reduction, float beta) -> Tensor
TORCH_API inline at::Tensor smooth_l1_loss_backward(const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & target, int64_t reduction, double beta) {
    return at::_ops::smooth_l1_loss_backward::call(grad_output, self, target, reduction, beta);
}

// aten::huber_loss.out(Tensor self, Tensor target, int reduction=Mean, float delta=1.0, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & huber_loss_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & target, int64_t reduction=at::Reduction::Mean, double delta=1.0) {
    return at::_ops::huber_loss_out::call(self, target, reduction, delta, out);
}

// aten::huber_loss.out(Tensor self, Tensor target, int reduction=Mean, float delta=1.0, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & huber_loss_outf(const at::Tensor & self, const at::Tensor & target, int64_t reduction, double delta, at::Tensor & out) {
    return at::_ops::huber_loss_out::call(self, target, reduction, delta, out);
}

// aten::huber_loss(Tensor self, Tensor target, int reduction=Mean, float delta=1.0) -> Tensor
TORCH_API inline at::Tensor huber_loss(const at::Tensor & self, const at::Tensor & target, int64_t reduction=at::Reduction::Mean, double delta=1.0) {
    return at::_ops::huber_loss::call(self, target, reduction, delta);
}

// aten::huber_loss_backward.out(Tensor grad_output, Tensor self, Tensor target, int reduction, float delta, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & huber_loss_backward_out(at::Tensor & grad_input, const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & target, int64_t reduction, double delta) {
    return at::_ops::huber_loss_backward_out::call(grad_output, self, target, reduction, delta, grad_input);
}

// aten::huber_loss_backward.out(Tensor grad_output, Tensor self, Tensor target, int reduction, float delta, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & huber_loss_backward_outf(const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & target, int64_t reduction, double delta, at::Tensor & grad_input) {
    return at::_ops::huber_loss_backward_out::call(grad_output, self, target, reduction, delta, grad_input);
}

// aten::huber_loss_backward(Tensor grad_output, Tensor self, Tensor target, int reduction, float delta) -> Tensor
TORCH_API inline at::Tensor huber_loss_backward(const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & target, int64_t reduction, double delta) {
    return at::_ops::huber_loss_backward::call(grad_output, self, target, reduction, delta);
}

// aten::soft_margin_loss.out(Tensor self, Tensor target, int reduction=Mean, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & soft_margin_loss_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & target, int64_t reduction=at::Reduction::Mean) {
    return at::_ops::soft_margin_loss_out::call(self, target, reduction, out);
}

// aten::soft_margin_loss.out(Tensor self, Tensor target, int reduction=Mean, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & soft_margin_loss_outf(const at::Tensor & self, const at::Tensor & target, int64_t reduction, at::Tensor & out) {
    return at::_ops::soft_margin_loss_out::call(self, target, reduction, out);
}

// aten::soft_margin_loss(Tensor self, Tensor target, int reduction=Mean) -> Tensor
TORCH_API inline at::Tensor soft_margin_loss(const at::Tensor & self, const at::Tensor & target, int64_t reduction=at::Reduction::Mean) {
    return at::_ops::soft_margin_loss::call(self, target, reduction);
}

// aten::soft_margin_loss_backward.grad_input(Tensor grad_output, Tensor self, Tensor target, int reduction, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & soft_margin_loss_backward_out(at::Tensor & grad_input, const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & target, int64_t reduction) {
    return at::_ops::soft_margin_loss_backward_grad_input::call(grad_output, self, target, reduction, grad_input);
}

// aten::soft_margin_loss_backward.grad_input(Tensor grad_output, Tensor self, Tensor target, int reduction, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & soft_margin_loss_backward_outf(const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & target, int64_t reduction, at::Tensor & grad_input) {
    return at::_ops::soft_margin_loss_backward_grad_input::call(grad_output, self, target, reduction, grad_input);
}

// aten::soft_margin_loss_backward(Tensor grad_output, Tensor self, Tensor target, int reduction) -> Tensor
TORCH_API inline at::Tensor soft_margin_loss_backward(const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & target, int64_t reduction) {
    return at::_ops::soft_margin_loss_backward::call(grad_output, self, target, reduction);
}

// aten::elu.out(Tensor self, Scalar alpha=1, Scalar scale=1, Scalar input_scale=1, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & elu_out(at::Tensor & out, const at::Tensor & self, const at::Scalar & alpha=1, const at::Scalar & scale=1, const at::Scalar & input_scale=1) {
    return at::_ops::elu_out::call(self, alpha, scale, input_scale, out);
}

// aten::elu.out(Tensor self, Scalar alpha=1, Scalar scale=1, Scalar input_scale=1, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & elu_outf(const at::Tensor & self, const at::Scalar & alpha, const at::Scalar & scale, const at::Scalar & input_scale, at::Tensor & out) {
    return at::_ops::elu_out::call(self, alpha, scale, input_scale, out);
}

// aten::elu(Tensor self, Scalar alpha=1, Scalar scale=1, Scalar input_scale=1) -> Tensor
TORCH_API inline at::Tensor elu(const at::Tensor & self, const at::Scalar & alpha=1, const at::Scalar & scale=1, const at::Scalar & input_scale=1) {
    return at::_ops::elu::call(self, alpha, scale, input_scale);
}

// aten::elu_backward.grad_input(Tensor grad_output, Scalar alpha, Scalar scale, Scalar input_scale, bool is_result, Tensor self_or_result, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & elu_backward_out(at::Tensor & grad_input, const at::Tensor & grad_output, const at::Scalar & alpha, const at::Scalar & scale, const at::Scalar & input_scale, bool is_result, const at::Tensor & self_or_result) {
    return at::_ops::elu_backward_grad_input::call(grad_output, alpha, scale, input_scale, is_result, self_or_result, grad_input);
}

// aten::elu_backward.grad_input(Tensor grad_output, Scalar alpha, Scalar scale, Scalar input_scale, bool is_result, Tensor self_or_result, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & elu_backward_outf(const at::Tensor & grad_output, const at::Scalar & alpha, const at::Scalar & scale, const at::Scalar & input_scale, bool is_result, const at::Tensor & self_or_result, at::Tensor & grad_input) {
    return at::_ops::elu_backward_grad_input::call(grad_output, alpha, scale, input_scale, is_result, self_or_result, grad_input);
}

// aten::elu_backward(Tensor grad_output, Scalar alpha, Scalar scale, Scalar input_scale, bool is_result, Tensor self_or_result) -> Tensor
TORCH_API inline at::Tensor elu_backward(const at::Tensor & grad_output, const at::Scalar & alpha, const at::Scalar & scale, const at::Scalar & input_scale, bool is_result, const at::Tensor & self_or_result) {
    return at::_ops::elu_backward::call(grad_output, alpha, scale, input_scale, is_result, self_or_result);
}

// aten::elu_(Tensor(a!) self, Scalar alpha=1, Scalar scale=1, Scalar input_scale=1) -> Tensor(a!)
TORCH_API inline at::Tensor & elu_(at::Tensor & self, const at::Scalar & alpha=1, const at::Scalar & scale=1, const at::Scalar & input_scale=1) {
    return at::_ops::elu_::call(self, alpha, scale, input_scale);
}

// aten::glu.out(Tensor self, int dim=-1, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & glu_out(at::Tensor & out, const at::Tensor & self, int64_t dim=-1) {
    return at::_ops::glu_out::call(self, dim, out);
}

// aten::glu.out(Tensor self, int dim=-1, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & glu_outf(const at::Tensor & self, int64_t dim, at::Tensor & out) {
    return at::_ops::glu_out::call(self, dim, out);
}

// aten::glu(Tensor self, int dim=-1) -> Tensor
TORCH_API inline at::Tensor glu(const at::Tensor & self, int64_t dim=-1) {
    return at::_ops::glu::call(self, dim);
}

// aten::glu_backward.grad_input(Tensor grad_output, Tensor self, int dim, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & glu_backward_out(at::Tensor & grad_input, const at::Tensor & grad_output, const at::Tensor & self, int64_t dim) {
    return at::_ops::glu_backward_grad_input::call(grad_output, self, dim, grad_input);
}

// aten::glu_backward.grad_input(Tensor grad_output, Tensor self, int dim, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & glu_backward_outf(const at::Tensor & grad_output, const at::Tensor & self, int64_t dim, at::Tensor & grad_input) {
    return at::_ops::glu_backward_grad_input::call(grad_output, self, dim, grad_input);
}

// aten::glu_backward(Tensor grad_output, Tensor self, int dim) -> Tensor
TORCH_API inline at::Tensor glu_backward(const at::Tensor & grad_output, const at::Tensor & self, int64_t dim) {
    return at::_ops::glu_backward::call(grad_output, self, dim);
}

// aten::hardsigmoid.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & hardsigmoid_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::hardsigmoid_out::call(self, out);
}

// aten::hardsigmoid.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & hardsigmoid_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::hardsigmoid_out::call(self, out);
}

// aten::hardsigmoid(Tensor self) -> Tensor
TORCH_API inline at::Tensor hardsigmoid(const at::Tensor & self) {
    return at::_ops::hardsigmoid::call(self);
}

// aten::hardsigmoid_(Tensor(a!) self) -> Tensor(a!)
TORCH_API inline at::Tensor & hardsigmoid_(at::Tensor & self) {
    return at::_ops::hardsigmoid_::call(self);
}

// aten::hardsigmoid_backward.grad_input(Tensor grad_output, Tensor self, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & hardsigmoid_backward_out(at::Tensor & grad_input, const at::Tensor & grad_output, const at::Tensor & self) {
    return at::_ops::hardsigmoid_backward_grad_input::call(grad_output, self, grad_input);
}

// aten::hardsigmoid_backward.grad_input(Tensor grad_output, Tensor self, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & hardsigmoid_backward_outf(const at::Tensor & grad_output, const at::Tensor & self, at::Tensor & grad_input) {
    return at::_ops::hardsigmoid_backward_grad_input::call(grad_output, self, grad_input);
}

// aten::hardsigmoid_backward(Tensor grad_output, Tensor self) -> Tensor
TORCH_API inline at::Tensor hardsigmoid_backward(const at::Tensor & grad_output, const at::Tensor & self) {
    return at::_ops::hardsigmoid_backward::call(grad_output, self);
}

// aten::hardtanh.out(Tensor self, Scalar min_val=-1, Scalar max_val=1, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & hardtanh_out(at::Tensor & out, const at::Tensor & self, const at::Scalar & min_val=-1, const at::Scalar & max_val=1) {
    return at::_ops::hardtanh_out::call(self, min_val, max_val, out);
}

// aten::hardtanh.out(Tensor self, Scalar min_val=-1, Scalar max_val=1, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & hardtanh_outf(const at::Tensor & self, const at::Scalar & min_val, const at::Scalar & max_val, at::Tensor & out) {
    return at::_ops::hardtanh_out::call(self, min_val, max_val, out);
}

// aten::hardtanh(Tensor self, Scalar min_val=-1, Scalar max_val=1) -> Tensor
TORCH_API inline at::Tensor hardtanh(const at::Tensor & self, const at::Scalar & min_val=-1, const at::Scalar & max_val=1) {
    return at::_ops::hardtanh::call(self, min_val, max_val);
}

// aten::hardtanh_backward.grad_input(Tensor grad_output, Tensor self, Scalar min_val, Scalar max_val, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & hardtanh_backward_out(at::Tensor & grad_input, const at::Tensor & grad_output, const at::Tensor & self, const at::Scalar & min_val, const at::Scalar & max_val) {
    return at::_ops::hardtanh_backward_grad_input::call(grad_output, self, min_val, max_val, grad_input);
}

// aten::hardtanh_backward.grad_input(Tensor grad_output, Tensor self, Scalar min_val, Scalar max_val, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & hardtanh_backward_outf(const at::Tensor & grad_output, const at::Tensor & self, const at::Scalar & min_val, const at::Scalar & max_val, at::Tensor & grad_input) {
    return at::_ops::hardtanh_backward_grad_input::call(grad_output, self, min_val, max_val, grad_input);
}

// aten::hardtanh_backward(Tensor grad_output, Tensor self, Scalar min_val, Scalar max_val) -> Tensor
TORCH_API inline at::Tensor hardtanh_backward(const at::Tensor & grad_output, const at::Tensor & self, const at::Scalar & min_val, const at::Scalar & max_val) {
    return at::_ops::hardtanh_backward::call(grad_output, self, min_val, max_val);
}

// aten::hardtanh_(Tensor(a!) self, Scalar min_val=-1, Scalar max_val=1) -> Tensor(a!)
TORCH_API inline at::Tensor & hardtanh_(at::Tensor & self, const at::Scalar & min_val=-1, const at::Scalar & max_val=1) {
    return at::_ops::hardtanh_::call(self, min_val, max_val);
}

// aten::hardswish.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & hardswish_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::hardswish_out::call(self, out);
}

// aten::hardswish.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & hardswish_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::hardswish_out::call(self, out);
}

// aten::hardswish(Tensor self) -> Tensor
TORCH_API inline at::Tensor hardswish(const at::Tensor & self) {
    return at::_ops::hardswish::call(self);
}

// aten::hardswish_(Tensor(a!) self) -> Tensor(a!)
TORCH_API inline at::Tensor & hardswish_(at::Tensor & self) {
    return at::_ops::hardswish_::call(self);
}

// aten::hardswish_backward(Tensor grad_output, Tensor self) -> Tensor
TORCH_API inline at::Tensor hardswish_backward(const at::Tensor & grad_output, const at::Tensor & self) {
    return at::_ops::hardswish_backward::call(grad_output, self);
}

// aten::leaky_relu.out(Tensor self, Scalar negative_slope=0.01, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & leaky_relu_out(at::Tensor & out, const at::Tensor & self, const at::Scalar & negative_slope=0.01) {
    return at::_ops::leaky_relu_out::call(self, negative_slope, out);
}

// aten::leaky_relu.out(Tensor self, Scalar negative_slope=0.01, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & leaky_relu_outf(const at::Tensor & self, const at::Scalar & negative_slope, at::Tensor & out) {
    return at::_ops::leaky_relu_out::call(self, negative_slope, out);
}

// aten::leaky_relu(Tensor self, Scalar negative_slope=0.01) -> Tensor
TORCH_API inline at::Tensor leaky_relu(const at::Tensor & self, const at::Scalar & negative_slope=0.01) {
    return at::_ops::leaky_relu::call(self, negative_slope);
}

// aten::leaky_relu_backward.grad_input(Tensor grad_output, Tensor self, Scalar negative_slope, bool self_is_result, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & leaky_relu_backward_out(at::Tensor & grad_input, const at::Tensor & grad_output, const at::Tensor & self, const at::Scalar & negative_slope, bool self_is_result) {
    return at::_ops::leaky_relu_backward_grad_input::call(grad_output, self, negative_slope, self_is_result, grad_input);
}

// aten::leaky_relu_backward.grad_input(Tensor grad_output, Tensor self, Scalar negative_slope, bool self_is_result, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & leaky_relu_backward_outf(const at::Tensor & grad_output, const at::Tensor & self, const at::Scalar & negative_slope, bool self_is_result, at::Tensor & grad_input) {
    return at::_ops::leaky_relu_backward_grad_input::call(grad_output, self, negative_slope, self_is_result, grad_input);
}

// aten::leaky_relu_backward(Tensor grad_output, Tensor self, Scalar negative_slope, bool self_is_result) -> Tensor
TORCH_API inline at::Tensor leaky_relu_backward(const at::Tensor & grad_output, const at::Tensor & self, const at::Scalar & negative_slope, bool self_is_result) {
    return at::_ops::leaky_relu_backward::call(grad_output, self, negative_slope, self_is_result);
}

// aten::leaky_relu_(Tensor(a!) self, Scalar negative_slope=0.01) -> Tensor(a!)
TORCH_API inline at::Tensor & leaky_relu_(at::Tensor & self, const at::Scalar & negative_slope=0.01) {
    return at::_ops::leaky_relu_::call(self, negative_slope);
}

// aten::log_sigmoid.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & log_sigmoid_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::log_sigmoid_out::call(self, out);
}

// aten::log_sigmoid.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & log_sigmoid_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::log_sigmoid_out::call(self, out);
}

// aten::log_sigmoid(Tensor self) -> Tensor
TORCH_API inline at::Tensor log_sigmoid(const at::Tensor & self) {
    return at::_ops::log_sigmoid::call(self);
}

// aten::log_sigmoid_forward.output(Tensor self, *, Tensor(a!) output, Tensor(b!) buffer) -> (Tensor(a!), Tensor(b!))
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> log_sigmoid_forward_out(at::Tensor & output, at::Tensor & buffer, const at::Tensor & self) {
    return at::_ops::log_sigmoid_forward_output::call(self, output, buffer);
}

// aten::log_sigmoid_forward.output(Tensor self, *, Tensor(a!) output, Tensor(b!) buffer) -> (Tensor(a!), Tensor(b!))
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> log_sigmoid_forward_outf(const at::Tensor & self, at::Tensor & output, at::Tensor & buffer) {
    return at::_ops::log_sigmoid_forward_output::call(self, output, buffer);
}

// aten::log_sigmoid_forward(Tensor self) -> (Tensor output, Tensor buffer)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> log_sigmoid_forward(const at::Tensor & self) {
    return at::_ops::log_sigmoid_forward::call(self);
}

// aten::log_sigmoid_backward.grad_input(Tensor grad_output, Tensor self, Tensor buffer, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & log_sigmoid_backward_out(at::Tensor & grad_input, const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & buffer) {
    return at::_ops::log_sigmoid_backward_grad_input::call(grad_output, self, buffer, grad_input);
}

// aten::log_sigmoid_backward.grad_input(Tensor grad_output, Tensor self, Tensor buffer, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & log_sigmoid_backward_outf(const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & buffer, at::Tensor & grad_input) {
    return at::_ops::log_sigmoid_backward_grad_input::call(grad_output, self, buffer, grad_input);
}

// aten::log_sigmoid_backward(Tensor grad_output, Tensor self, Tensor buffer) -> Tensor
TORCH_API inline at::Tensor log_sigmoid_backward(const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & buffer) {
    return at::_ops::log_sigmoid_backward::call(grad_output, self, buffer);
}

// aten::rrelu_with_noise.out(Tensor self, Tensor noise, Scalar lower=0.125, Scalar upper=0.3333333333333333, bool training=False, Generator? generator=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & rrelu_with_noise_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & noise, const at::Scalar & lower=0.125, const at::Scalar & upper=0.3333333333333333, bool training=false, c10::optional<at::Generator> generator=c10::nullopt) {
    return at::_ops::rrelu_with_noise_out::call(self, noise, lower, upper, training, generator, out);
}

// aten::rrelu_with_noise.out(Tensor self, Tensor noise, Scalar lower=0.125, Scalar upper=0.3333333333333333, bool training=False, Generator? generator=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & rrelu_with_noise_outf(const at::Tensor & self, const at::Tensor & noise, const at::Scalar & lower, const at::Scalar & upper, bool training, c10::optional<at::Generator> generator, at::Tensor & out) {
    return at::_ops::rrelu_with_noise_out::call(self, noise, lower, upper, training, generator, out);
}

// aten::rrelu_with_noise(Tensor self, Tensor noise, Scalar lower=0.125, Scalar upper=0.3333333333333333, bool training=False, Generator? generator=None) -> Tensor
TORCH_API inline at::Tensor rrelu_with_noise(const at::Tensor & self, const at::Tensor & noise, const at::Scalar & lower=0.125, const at::Scalar & upper=0.3333333333333333, bool training=false, c10::optional<at::Generator> generator=c10::nullopt) {
    return at::_ops::rrelu_with_noise::call(self, noise, lower, upper, training, generator);
}

// aten::rrelu_with_noise_backward(Tensor grad_output, Tensor self, Tensor noise, Scalar lower, Scalar upper, bool training, bool self_is_result) -> Tensor
TORCH_API inline at::Tensor rrelu_with_noise_backward(const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & noise, const at::Scalar & lower, const at::Scalar & upper, bool training, bool self_is_result) {
    return at::_ops::rrelu_with_noise_backward::call(grad_output, self, noise, lower, upper, training, self_is_result);
}

// aten::rrelu_with_noise_(Tensor(a!) self, Tensor noise, Scalar lower=0.125, Scalar upper=0.3333333333333333, bool training=False, Generator? generator=None) -> Tensor(a!)
TORCH_API inline at::Tensor & rrelu_with_noise_(at::Tensor & self, const at::Tensor & noise, const at::Scalar & lower=0.125, const at::Scalar & upper=0.3333333333333333, bool training=false, c10::optional<at::Generator> generator=c10::nullopt) {
    return at::_ops::rrelu_with_noise_::call(self, noise, lower, upper, training, generator);
}

// aten::softplus.out(Tensor self, Scalar beta=1, Scalar threshold=20, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & softplus_out(at::Tensor & out, const at::Tensor & self, const at::Scalar & beta=1, const at::Scalar & threshold=20) {
    return at::_ops::softplus_out::call(self, beta, threshold, out);
}

// aten::softplus.out(Tensor self, Scalar beta=1, Scalar threshold=20, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & softplus_outf(const at::Tensor & self, const at::Scalar & beta, const at::Scalar & threshold, at::Tensor & out) {
    return at::_ops::softplus_out::call(self, beta, threshold, out);
}

// aten::softplus(Tensor self, Scalar beta=1, Scalar threshold=20) -> Tensor
TORCH_API inline at::Tensor softplus(const at::Tensor & self, const at::Scalar & beta=1, const at::Scalar & threshold=20) {
    return at::_ops::softplus::call(self, beta, threshold);
}

// aten::softplus_backward.grad_input(Tensor grad_output, Tensor self, Scalar beta, Scalar threshold, Tensor output, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & softplus_backward_out(at::Tensor & grad_input, const at::Tensor & grad_output, const at::Tensor & self, const at::Scalar & beta, const at::Scalar & threshold, const at::Tensor & output) {
    return at::_ops::softplus_backward_grad_input::call(grad_output, self, beta, threshold, output, grad_input);
}

// aten::softplus_backward.grad_input(Tensor grad_output, Tensor self, Scalar beta, Scalar threshold, Tensor output, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & softplus_backward_outf(const at::Tensor & grad_output, const at::Tensor & self, const at::Scalar & beta, const at::Scalar & threshold, const at::Tensor & output, at::Tensor & grad_input) {
    return at::_ops::softplus_backward_grad_input::call(grad_output, self, beta, threshold, output, grad_input);
}

// aten::softplus_backward(Tensor grad_output, Tensor self, Scalar beta, Scalar threshold, Tensor output) -> Tensor
TORCH_API inline at::Tensor softplus_backward(const at::Tensor & grad_output, const at::Tensor & self, const at::Scalar & beta, const at::Scalar & threshold, const at::Tensor & output) {
    return at::_ops::softplus_backward::call(grad_output, self, beta, threshold, output);
}

// aten::softshrink.out(Tensor self, Scalar lambd=0.5, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & softshrink_out(at::Tensor & out, const at::Tensor & self, const at::Scalar & lambd=0.5) {
    return at::_ops::softshrink_out::call(self, lambd, out);
}

// aten::softshrink.out(Tensor self, Scalar lambd=0.5, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & softshrink_outf(const at::Tensor & self, const at::Scalar & lambd, at::Tensor & out) {
    return at::_ops::softshrink_out::call(self, lambd, out);
}

// aten::softshrink(Tensor self, Scalar lambd=0.5) -> Tensor
TORCH_API inline at::Tensor softshrink(const at::Tensor & self, const at::Scalar & lambd=0.5) {
    return at::_ops::softshrink::call(self, lambd);
}

// aten::softshrink_backward.grad_input(Tensor grad_output, Tensor self, Scalar lambd, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & softshrink_backward_out(at::Tensor & grad_input, const at::Tensor & grad_output, const at::Tensor & self, const at::Scalar & lambd) {
    return at::_ops::softshrink_backward_grad_input::call(grad_output, self, lambd, grad_input);
}

// aten::softshrink_backward.grad_input(Tensor grad_output, Tensor self, Scalar lambd, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & softshrink_backward_outf(const at::Tensor & grad_output, const at::Tensor & self, const at::Scalar & lambd, at::Tensor & grad_input) {
    return at::_ops::softshrink_backward_grad_input::call(grad_output, self, lambd, grad_input);
}

// aten::softshrink_backward(Tensor grad_output, Tensor self, Scalar lambd) -> Tensor
TORCH_API inline at::Tensor softshrink_backward(const at::Tensor & grad_output, const at::Tensor & self, const at::Scalar & lambd) {
    return at::_ops::softshrink_backward::call(grad_output, self, lambd);
}

// aten::adaptive_avg_pool2d.out(Tensor self, int[2] output_size, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & adaptive_avg_pool2d_out(at::Tensor & out, const at::Tensor & self, at::IntArrayRef output_size) {
    return at::_ops::adaptive_avg_pool2d_out::call(self, output_size, out);
}

// aten::adaptive_avg_pool2d.out(Tensor self, int[2] output_size, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & adaptive_avg_pool2d_outf(const at::Tensor & self, at::IntArrayRef output_size, at::Tensor & out) {
    return at::_ops::adaptive_avg_pool2d_out::call(self, output_size, out);
}

// aten::adaptive_avg_pool2d(Tensor self, int[2] output_size) -> Tensor
TORCH_API inline at::Tensor adaptive_avg_pool2d(const at::Tensor & self, at::IntArrayRef output_size) {
    return at::_ops::adaptive_avg_pool2d::call(self, output_size);
}

// aten::mkldnn_adaptive_avg_pool2d(Tensor self, int[2] output_size) -> Tensor
TORCH_API inline at::Tensor mkldnn_adaptive_avg_pool2d(const at::Tensor & self, at::IntArrayRef output_size) {
    return at::_ops::mkldnn_adaptive_avg_pool2d::call(self, output_size);
}

// aten::mkldnn_adaptive_avg_pool2d_backward(Tensor grad_output, Tensor self) -> Tensor
TORCH_API inline at::Tensor mkldnn_adaptive_avg_pool2d_backward(const at::Tensor & grad_output, const at::Tensor & self) {
    return at::_ops::mkldnn_adaptive_avg_pool2d_backward::call(grad_output, self);
}

// aten::_adaptive_avg_pool2d(Tensor self, int[2] output_size) -> Tensor
TORCH_API inline at::Tensor _adaptive_avg_pool2d(const at::Tensor & self, at::IntArrayRef output_size) {
    return at::_ops::_adaptive_avg_pool2d::call(self, output_size);
}

// aten::_adaptive_avg_pool2d_backward(Tensor grad_output, Tensor self) -> Tensor
TORCH_API inline at::Tensor _adaptive_avg_pool2d_backward(const at::Tensor & grad_output, const at::Tensor & self) {
    return at::_ops::_adaptive_avg_pool2d_backward::call(grad_output, self);
}

// aten::adaptive_avg_pool3d.out(Tensor self, int[3] output_size, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & adaptive_avg_pool3d_out(at::Tensor & out, const at::Tensor & self, at::IntArrayRef output_size) {
    return at::_ops::adaptive_avg_pool3d_out::call(self, output_size, out);
}

// aten::adaptive_avg_pool3d.out(Tensor self, int[3] output_size, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & adaptive_avg_pool3d_outf(const at::Tensor & self, at::IntArrayRef output_size, at::Tensor & out) {
    return at::_ops::adaptive_avg_pool3d_out::call(self, output_size, out);
}

// aten::adaptive_avg_pool3d(Tensor self, int[3] output_size) -> Tensor
TORCH_API inline at::Tensor adaptive_avg_pool3d(const at::Tensor & self, at::IntArrayRef output_size) {
    return at::_ops::adaptive_avg_pool3d::call(self, output_size);
}

// aten::_adaptive_avg_pool3d(Tensor self, int[3] output_size) -> Tensor
TORCH_API inline at::Tensor _adaptive_avg_pool3d(const at::Tensor & self, at::IntArrayRef output_size) {
    return at::_ops::_adaptive_avg_pool3d::call(self, output_size);
}

// aten::adaptive_avg_pool3d_backward.grad_input(Tensor grad_output, Tensor self, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & adaptive_avg_pool3d_backward_out(at::Tensor & grad_input, const at::Tensor & grad_output, const at::Tensor & self) {
    return at::_ops::adaptive_avg_pool3d_backward_grad_input::call(grad_output, self, grad_input);
}

// aten::adaptive_avg_pool3d_backward.grad_input(Tensor grad_output, Tensor self, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & adaptive_avg_pool3d_backward_outf(const at::Tensor & grad_output, const at::Tensor & self, at::Tensor & grad_input) {
    return at::_ops::adaptive_avg_pool3d_backward_grad_input::call(grad_output, self, grad_input);
}

// aten::_adaptive_avg_pool3d_backward(Tensor grad_output, Tensor self) -> Tensor
TORCH_API inline at::Tensor _adaptive_avg_pool3d_backward(const at::Tensor & grad_output, const at::Tensor & self) {
    return at::_ops::_adaptive_avg_pool3d_backward::call(grad_output, self);
}

// aten::adaptive_max_pool2d.out(Tensor self, int[2] output_size, *, Tensor(a!) out, Tensor(b!) indices) -> (Tensor(a!), Tensor(b!))
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> adaptive_max_pool2d_out(at::Tensor & out, at::Tensor & indices, const at::Tensor & self, at::IntArrayRef output_size) {
    return at::_ops::adaptive_max_pool2d_out::call(self, output_size, out, indices);
}

// aten::adaptive_max_pool2d.out(Tensor self, int[2] output_size, *, Tensor(a!) out, Tensor(b!) indices) -> (Tensor(a!), Tensor(b!))
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> adaptive_max_pool2d_outf(const at::Tensor & self, at::IntArrayRef output_size, at::Tensor & out, at::Tensor & indices) {
    return at::_ops::adaptive_max_pool2d_out::call(self, output_size, out, indices);
}

// aten::adaptive_max_pool2d(Tensor self, int[2] output_size) -> (Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> adaptive_max_pool2d(const at::Tensor & self, at::IntArrayRef output_size) {
    return at::_ops::adaptive_max_pool2d::call(self, output_size);
}

// aten::adaptive_max_pool2d_backward.grad_input(Tensor grad_output, Tensor self, Tensor indices, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & adaptive_max_pool2d_backward_out(at::Tensor & grad_input, const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & indices) {
    return at::_ops::adaptive_max_pool2d_backward_grad_input::call(grad_output, self, indices, grad_input);
}

// aten::adaptive_max_pool2d_backward.grad_input(Tensor grad_output, Tensor self, Tensor indices, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & adaptive_max_pool2d_backward_outf(const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & indices, at::Tensor & grad_input) {
    return at::_ops::adaptive_max_pool2d_backward_grad_input::call(grad_output, self, indices, grad_input);
}

// aten::adaptive_max_pool2d_backward(Tensor grad_output, Tensor self, Tensor indices) -> Tensor
TORCH_API inline at::Tensor adaptive_max_pool2d_backward(const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & indices) {
    return at::_ops::adaptive_max_pool2d_backward::call(grad_output, self, indices);
}

// aten::adaptive_max_pool3d.out(Tensor self, int[3] output_size, *, Tensor(a!) out, Tensor(b!) indices) -> (Tensor(a!), Tensor(b!))
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> adaptive_max_pool3d_out(at::Tensor & out, at::Tensor & indices, const at::Tensor & self, at::IntArrayRef output_size) {
    return at::_ops::adaptive_max_pool3d_out::call(self, output_size, out, indices);
}

// aten::adaptive_max_pool3d.out(Tensor self, int[3] output_size, *, Tensor(a!) out, Tensor(b!) indices) -> (Tensor(a!), Tensor(b!))
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> adaptive_max_pool3d_outf(const at::Tensor & self, at::IntArrayRef output_size, at::Tensor & out, at::Tensor & indices) {
    return at::_ops::adaptive_max_pool3d_out::call(self, output_size, out, indices);
}

// aten::adaptive_max_pool3d(Tensor self, int[3] output_size) -> (Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> adaptive_max_pool3d(const at::Tensor & self, at::IntArrayRef output_size) {
    return at::_ops::adaptive_max_pool3d::call(self, output_size);
}

// aten::adaptive_max_pool3d_backward.grad_input(Tensor grad_output, Tensor self, Tensor indices, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & adaptive_max_pool3d_backward_out(at::Tensor & grad_input, const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & indices) {
    return at::_ops::adaptive_max_pool3d_backward_grad_input::call(grad_output, self, indices, grad_input);
}

// aten::adaptive_max_pool3d_backward.grad_input(Tensor grad_output, Tensor self, Tensor indices, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & adaptive_max_pool3d_backward_outf(const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & indices, at::Tensor & grad_input) {
    return at::_ops::adaptive_max_pool3d_backward_grad_input::call(grad_output, self, indices, grad_input);
}

// aten::adaptive_max_pool3d_backward(Tensor grad_output, Tensor self, Tensor indices) -> Tensor
TORCH_API inline at::Tensor adaptive_max_pool3d_backward(const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & indices) {
    return at::_ops::adaptive_max_pool3d_backward::call(grad_output, self, indices);
}

// aten::avg_pool2d.out(Tensor self, int[2] kernel_size, int[2] stride=[], int[2] padding=0, bool ceil_mode=False, bool count_include_pad=True, int? divisor_override=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & avg_pool2d_out(at::Tensor & out, const at::Tensor & self, at::IntArrayRef kernel_size, at::IntArrayRef stride={}, at::IntArrayRef padding=0, bool ceil_mode=false, bool count_include_pad=true, c10::optional<int64_t> divisor_override=c10::nullopt) {
    return at::_ops::avg_pool2d_out::call(self, kernel_size, stride, padding, ceil_mode, count_include_pad, divisor_override, out);
}

// aten::avg_pool2d.out(Tensor self, int[2] kernel_size, int[2] stride=[], int[2] padding=0, bool ceil_mode=False, bool count_include_pad=True, int? divisor_override=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & avg_pool2d_outf(const at::Tensor & self, at::IntArrayRef kernel_size, at::IntArrayRef stride, at::IntArrayRef padding, bool ceil_mode, bool count_include_pad, c10::optional<int64_t> divisor_override, at::Tensor & out) {
    return at::_ops::avg_pool2d_out::call(self, kernel_size, stride, padding, ceil_mode, count_include_pad, divisor_override, out);
}

// aten::avg_pool2d(Tensor self, int[2] kernel_size, int[2] stride=[], int[2] padding=0, bool ceil_mode=False, bool count_include_pad=True, int? divisor_override=None) -> Tensor
TORCH_API inline at::Tensor avg_pool2d(const at::Tensor & self, at::IntArrayRef kernel_size, at::IntArrayRef stride={}, at::IntArrayRef padding=0, bool ceil_mode=false, bool count_include_pad=true, c10::optional<int64_t> divisor_override=c10::nullopt) {
    return at::_ops::avg_pool2d::call(self, kernel_size, stride, padding, ceil_mode, count_include_pad, divisor_override);
}

// aten::avg_pool2d_backward.grad_input(Tensor grad_output, Tensor self, int[2] kernel_size, int[2] stride, int[2] padding, bool ceil_mode, bool count_include_pad, int? divisor_override, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & avg_pool2d_backward_out(at::Tensor & grad_input, const at::Tensor & grad_output, const at::Tensor & self, at::IntArrayRef kernel_size, at::IntArrayRef stride, at::IntArrayRef padding, bool ceil_mode, bool count_include_pad, c10::optional<int64_t> divisor_override) {
    return at::_ops::avg_pool2d_backward_grad_input::call(grad_output, self, kernel_size, stride, padding, ceil_mode, count_include_pad, divisor_override, grad_input);
}

// aten::avg_pool2d_backward.grad_input(Tensor grad_output, Tensor self, int[2] kernel_size, int[2] stride, int[2] padding, bool ceil_mode, bool count_include_pad, int? divisor_override, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & avg_pool2d_backward_outf(const at::Tensor & grad_output, const at::Tensor & self, at::IntArrayRef kernel_size, at::IntArrayRef stride, at::IntArrayRef padding, bool ceil_mode, bool count_include_pad, c10::optional<int64_t> divisor_override, at::Tensor & grad_input) {
    return at::_ops::avg_pool2d_backward_grad_input::call(grad_output, self, kernel_size, stride, padding, ceil_mode, count_include_pad, divisor_override, grad_input);
}

// aten::avg_pool2d_backward(Tensor grad_output, Tensor self, int[2] kernel_size, int[2] stride, int[2] padding, bool ceil_mode, bool count_include_pad, int? divisor_override) -> Tensor
TORCH_API inline at::Tensor avg_pool2d_backward(const at::Tensor & grad_output, const at::Tensor & self, at::IntArrayRef kernel_size, at::IntArrayRef stride, at::IntArrayRef padding, bool ceil_mode, bool count_include_pad, c10::optional<int64_t> divisor_override) {
    return at::_ops::avg_pool2d_backward::call(grad_output, self, kernel_size, stride, padding, ceil_mode, count_include_pad, divisor_override);
}

// aten::avg_pool3d.out(Tensor self, int[3] kernel_size, int[3] stride=[], int[3] padding=0, bool ceil_mode=False, bool count_include_pad=True, int? divisor_override=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & avg_pool3d_out(at::Tensor & out, const at::Tensor & self, at::IntArrayRef kernel_size, at::IntArrayRef stride={}, at::IntArrayRef padding=0, bool ceil_mode=false, bool count_include_pad=true, c10::optional<int64_t> divisor_override=c10::nullopt) {
    return at::_ops::avg_pool3d_out::call(self, kernel_size, stride, padding, ceil_mode, count_include_pad, divisor_override, out);
}

// aten::avg_pool3d.out(Tensor self, int[3] kernel_size, int[3] stride=[], int[3] padding=0, bool ceil_mode=False, bool count_include_pad=True, int? divisor_override=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & avg_pool3d_outf(const at::Tensor & self, at::IntArrayRef kernel_size, at::IntArrayRef stride, at::IntArrayRef padding, bool ceil_mode, bool count_include_pad, c10::optional<int64_t> divisor_override, at::Tensor & out) {
    return at::_ops::avg_pool3d_out::call(self, kernel_size, stride, padding, ceil_mode, count_include_pad, divisor_override, out);
}

// aten::avg_pool3d(Tensor self, int[3] kernel_size, int[3] stride=[], int[3] padding=0, bool ceil_mode=False, bool count_include_pad=True, int? divisor_override=None) -> Tensor
TORCH_API inline at::Tensor avg_pool3d(const at::Tensor & self, at::IntArrayRef kernel_size, at::IntArrayRef stride={}, at::IntArrayRef padding=0, bool ceil_mode=false, bool count_include_pad=true, c10::optional<int64_t> divisor_override=c10::nullopt) {
    return at::_ops::avg_pool3d::call(self, kernel_size, stride, padding, ceil_mode, count_include_pad, divisor_override);
}

// aten::avg_pool3d_backward.grad_input(Tensor grad_output, Tensor self, int[3] kernel_size, int[3] stride, int[3] padding, bool ceil_mode, bool count_include_pad, int? divisor_override, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & avg_pool3d_backward_out(at::Tensor & grad_input, const at::Tensor & grad_output, const at::Tensor & self, at::IntArrayRef kernel_size, at::IntArrayRef stride, at::IntArrayRef padding, bool ceil_mode, bool count_include_pad, c10::optional<int64_t> divisor_override) {
    return at::_ops::avg_pool3d_backward_grad_input::call(grad_output, self, kernel_size, stride, padding, ceil_mode, count_include_pad, divisor_override, grad_input);
}

// aten::avg_pool3d_backward.grad_input(Tensor grad_output, Tensor self, int[3] kernel_size, int[3] stride, int[3] padding, bool ceil_mode, bool count_include_pad, int? divisor_override, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & avg_pool3d_backward_outf(const at::Tensor & grad_output, const at::Tensor & self, at::IntArrayRef kernel_size, at::IntArrayRef stride, at::IntArrayRef padding, bool ceil_mode, bool count_include_pad, c10::optional<int64_t> divisor_override, at::Tensor & grad_input) {
    return at::_ops::avg_pool3d_backward_grad_input::call(grad_output, self, kernel_size, stride, padding, ceil_mode, count_include_pad, divisor_override, grad_input);
}

// aten::avg_pool3d_backward(Tensor grad_output, Tensor self, int[3] kernel_size, int[3] stride, int[3] padding, bool ceil_mode, bool count_include_pad, int? divisor_override) -> Tensor
TORCH_API inline at::Tensor avg_pool3d_backward(const at::Tensor & grad_output, const at::Tensor & self, at::IntArrayRef kernel_size, at::IntArrayRef stride, at::IntArrayRef padding, bool ceil_mode, bool count_include_pad, c10::optional<int64_t> divisor_override) {
    return at::_ops::avg_pool3d_backward::call(grad_output, self, kernel_size, stride, padding, ceil_mode, count_include_pad, divisor_override);
}

// aten::fractional_max_pool2d.output(Tensor self, int[2] kernel_size, int[2] output_size, Tensor random_samples, *, Tensor(a!) output, Tensor(b!) indices) -> (Tensor(a!), Tensor(b!))
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> fractional_max_pool2d_out(at::Tensor & output, at::Tensor & indices, const at::Tensor & self, at::IntArrayRef kernel_size, at::IntArrayRef output_size, const at::Tensor & random_samples) {
    return at::_ops::fractional_max_pool2d_output::call(self, kernel_size, output_size, random_samples, output, indices);
}

// aten::fractional_max_pool2d.output(Tensor self, int[2] kernel_size, int[2] output_size, Tensor random_samples, *, Tensor(a!) output, Tensor(b!) indices) -> (Tensor(a!), Tensor(b!))
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> fractional_max_pool2d_outf(const at::Tensor & self, at::IntArrayRef kernel_size, at::IntArrayRef output_size, const at::Tensor & random_samples, at::Tensor & output, at::Tensor & indices) {
    return at::_ops::fractional_max_pool2d_output::call(self, kernel_size, output_size, random_samples, output, indices);
}

// aten::fractional_max_pool2d(Tensor self, int[2] kernel_size, int[2] output_size, Tensor random_samples) -> (Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> fractional_max_pool2d(const at::Tensor & self, at::IntArrayRef kernel_size, at::IntArrayRef output_size, const at::Tensor & random_samples) {
    return at::_ops::fractional_max_pool2d::call(self, kernel_size, output_size, random_samples);
}

// aten::fractional_max_pool2d_backward.grad_input(Tensor grad_output, Tensor self, int[2] kernel_size, int[2] output_size, Tensor indices, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & fractional_max_pool2d_backward_out(at::Tensor & grad_input, const at::Tensor & grad_output, const at::Tensor & self, at::IntArrayRef kernel_size, at::IntArrayRef output_size, const at::Tensor & indices) {
    return at::_ops::fractional_max_pool2d_backward_grad_input::call(grad_output, self, kernel_size, output_size, indices, grad_input);
}

// aten::fractional_max_pool2d_backward.grad_input(Tensor grad_output, Tensor self, int[2] kernel_size, int[2] output_size, Tensor indices, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & fractional_max_pool2d_backward_outf(const at::Tensor & grad_output, const at::Tensor & self, at::IntArrayRef kernel_size, at::IntArrayRef output_size, const at::Tensor & indices, at::Tensor & grad_input) {
    return at::_ops::fractional_max_pool2d_backward_grad_input::call(grad_output, self, kernel_size, output_size, indices, grad_input);
}

// aten::fractional_max_pool2d_backward(Tensor grad_output, Tensor self, int[2] kernel_size, int[2] output_size, Tensor indices) -> Tensor
TORCH_API inline at::Tensor fractional_max_pool2d_backward(const at::Tensor & grad_output, const at::Tensor & self, at::IntArrayRef kernel_size, at::IntArrayRef output_size, const at::Tensor & indices) {
    return at::_ops::fractional_max_pool2d_backward::call(grad_output, self, kernel_size, output_size, indices);
}

// aten::fractional_max_pool3d.output(Tensor self, int[3] kernel_size, int[3] output_size, Tensor random_samples, *, Tensor(a!) output, Tensor(b!) indices) -> (Tensor(a!), Tensor(b!))
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> fractional_max_pool3d_out(at::Tensor & output, at::Tensor & indices, const at::Tensor & self, at::IntArrayRef kernel_size, at::IntArrayRef output_size, const at::Tensor & random_samples) {
    return at::_ops::fractional_max_pool3d_output::call(self, kernel_size, output_size, random_samples, output, indices);
}

// aten::fractional_max_pool3d.output(Tensor self, int[3] kernel_size, int[3] output_size, Tensor random_samples, *, Tensor(a!) output, Tensor(b!) indices) -> (Tensor(a!), Tensor(b!))
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> fractional_max_pool3d_outf(const at::Tensor & self, at::IntArrayRef kernel_size, at::IntArrayRef output_size, const at::Tensor & random_samples, at::Tensor & output, at::Tensor & indices) {
    return at::_ops::fractional_max_pool3d_output::call(self, kernel_size, output_size, random_samples, output, indices);
}

// aten::fractional_max_pool3d(Tensor self, int[3] kernel_size, int[3] output_size, Tensor random_samples) -> (Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> fractional_max_pool3d(const at::Tensor & self, at::IntArrayRef kernel_size, at::IntArrayRef output_size, const at::Tensor & random_samples) {
    return at::_ops::fractional_max_pool3d::call(self, kernel_size, output_size, random_samples);
}

// aten::fractional_max_pool3d_backward.grad_input(Tensor grad_output, Tensor self, int[3] kernel_size, int[3] output_size, Tensor indices, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & fractional_max_pool3d_backward_out(at::Tensor & grad_input, const at::Tensor & grad_output, const at::Tensor & self, at::IntArrayRef kernel_size, at::IntArrayRef output_size, const at::Tensor & indices) {
    return at::_ops::fractional_max_pool3d_backward_grad_input::call(grad_output, self, kernel_size, output_size, indices, grad_input);
}

// aten::fractional_max_pool3d_backward.grad_input(Tensor grad_output, Tensor self, int[3] kernel_size, int[3] output_size, Tensor indices, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & fractional_max_pool3d_backward_outf(const at::Tensor & grad_output, const at::Tensor & self, at::IntArrayRef kernel_size, at::IntArrayRef output_size, const at::Tensor & indices, at::Tensor & grad_input) {
    return at::_ops::fractional_max_pool3d_backward_grad_input::call(grad_output, self, kernel_size, output_size, indices, grad_input);
}

// aten::fractional_max_pool3d_backward(Tensor grad_output, Tensor self, int[3] kernel_size, int[3] output_size, Tensor indices) -> Tensor
TORCH_API inline at::Tensor fractional_max_pool3d_backward(const at::Tensor & grad_output, const at::Tensor & self, at::IntArrayRef kernel_size, at::IntArrayRef output_size, const at::Tensor & indices) {
    return at::_ops::fractional_max_pool3d_backward::call(grad_output, self, kernel_size, output_size, indices);
}

// aten::max_pool2d_with_indices.out(Tensor self, int[2] kernel_size, int[2] stride=[], int[2] padding=0, int[2] dilation=1, bool ceil_mode=False, *, Tensor(a!) out, Tensor(b!) indices) -> (Tensor(a!), Tensor(b!))
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> max_pool2d_with_indices_out(at::Tensor & out, at::Tensor & indices, const at::Tensor & self, at::IntArrayRef kernel_size, at::IntArrayRef stride={}, at::IntArrayRef padding=0, at::IntArrayRef dilation=1, bool ceil_mode=false) {
    return at::_ops::max_pool2d_with_indices_out::call(self, kernel_size, stride, padding, dilation, ceil_mode, out, indices);
}

// aten::max_pool2d_with_indices.out(Tensor self, int[2] kernel_size, int[2] stride=[], int[2] padding=0, int[2] dilation=1, bool ceil_mode=False, *, Tensor(a!) out, Tensor(b!) indices) -> (Tensor(a!), Tensor(b!))
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> max_pool2d_with_indices_outf(const at::Tensor & self, at::IntArrayRef kernel_size, at::IntArrayRef stride, at::IntArrayRef padding, at::IntArrayRef dilation, bool ceil_mode, at::Tensor & out, at::Tensor & indices) {
    return at::_ops::max_pool2d_with_indices_out::call(self, kernel_size, stride, padding, dilation, ceil_mode, out, indices);
}

// aten::max_pool2d_with_indices(Tensor self, int[2] kernel_size, int[2] stride=[], int[2] padding=0, int[2] dilation=1, bool ceil_mode=False) -> (Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> max_pool2d_with_indices(const at::Tensor & self, at::IntArrayRef kernel_size, at::IntArrayRef stride={}, at::IntArrayRef padding=0, at::IntArrayRef dilation=1, bool ceil_mode=false) {
    return at::_ops::max_pool2d_with_indices::call(self, kernel_size, stride, padding, dilation, ceil_mode);
}

// aten::max_pool2d_with_indices_backward.grad_input(Tensor grad_output, Tensor self, int[2] kernel_size, int[2] stride, int[2] padding, int[2] dilation, bool ceil_mode, Tensor indices, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & max_pool2d_with_indices_backward_out(at::Tensor & grad_input, const at::Tensor & grad_output, const at::Tensor & self, at::IntArrayRef kernel_size, at::IntArrayRef stride, at::IntArrayRef padding, at::IntArrayRef dilation, bool ceil_mode, const at::Tensor & indices) {
    return at::_ops::max_pool2d_with_indices_backward_grad_input::call(grad_output, self, kernel_size, stride, padding, dilation, ceil_mode, indices, grad_input);
}

// aten::max_pool2d_with_indices_backward.grad_input(Tensor grad_output, Tensor self, int[2] kernel_size, int[2] stride, int[2] padding, int[2] dilation, bool ceil_mode, Tensor indices, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & max_pool2d_with_indices_backward_outf(const at::Tensor & grad_output, const at::Tensor & self, at::IntArrayRef kernel_size, at::IntArrayRef stride, at::IntArrayRef padding, at::IntArrayRef dilation, bool ceil_mode, const at::Tensor & indices, at::Tensor & grad_input) {
    return at::_ops::max_pool2d_with_indices_backward_grad_input::call(grad_output, self, kernel_size, stride, padding, dilation, ceil_mode, indices, grad_input);
}

// aten::max_pool2d_with_indices_backward(Tensor grad_output, Tensor self, int[2] kernel_size, int[2] stride, int[2] padding, int[2] dilation, bool ceil_mode, Tensor indices) -> Tensor
TORCH_API inline at::Tensor max_pool2d_with_indices_backward(const at::Tensor & grad_output, const at::Tensor & self, at::IntArrayRef kernel_size, at::IntArrayRef stride, at::IntArrayRef padding, at::IntArrayRef dilation, bool ceil_mode, const at::Tensor & indices) {
    return at::_ops::max_pool2d_with_indices_backward::call(grad_output, self, kernel_size, stride, padding, dilation, ceil_mode, indices);
}

// aten::max_pool3d_with_indices.out(Tensor self, int[3] kernel_size, int[3] stride=[], int[3] padding=0, int[3] dilation=1, bool ceil_mode=False, *, Tensor(a!) out, Tensor(b!) indices) -> (Tensor(a!), Tensor(b!))
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> max_pool3d_with_indices_out(at::Tensor & out, at::Tensor & indices, const at::Tensor & self, at::IntArrayRef kernel_size, at::IntArrayRef stride={}, at::IntArrayRef padding=0, at::IntArrayRef dilation=1, bool ceil_mode=false) {
    return at::_ops::max_pool3d_with_indices_out::call(self, kernel_size, stride, padding, dilation, ceil_mode, out, indices);
}

// aten::max_pool3d_with_indices.out(Tensor self, int[3] kernel_size, int[3] stride=[], int[3] padding=0, int[3] dilation=1, bool ceil_mode=False, *, Tensor(a!) out, Tensor(b!) indices) -> (Tensor(a!), Tensor(b!))
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> max_pool3d_with_indices_outf(const at::Tensor & self, at::IntArrayRef kernel_size, at::IntArrayRef stride, at::IntArrayRef padding, at::IntArrayRef dilation, bool ceil_mode, at::Tensor & out, at::Tensor & indices) {
    return at::_ops::max_pool3d_with_indices_out::call(self, kernel_size, stride, padding, dilation, ceil_mode, out, indices);
}

// aten::max_pool3d_with_indices(Tensor self, int[3] kernel_size, int[3] stride=[], int[3] padding=0, int[3] dilation=1, bool ceil_mode=False) -> (Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> max_pool3d_with_indices(const at::Tensor & self, at::IntArrayRef kernel_size, at::IntArrayRef stride={}, at::IntArrayRef padding=0, at::IntArrayRef dilation=1, bool ceil_mode=false) {
    return at::_ops::max_pool3d_with_indices::call(self, kernel_size, stride, padding, dilation, ceil_mode);
}

// aten::max_pool3d_with_indices_backward.grad_input(Tensor grad_output, Tensor self, int[3] kernel_size, int[3] stride, int[3] padding, int[3] dilation, bool ceil_mode, Tensor indices, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & max_pool3d_with_indices_backward_out(at::Tensor & grad_input, const at::Tensor & grad_output, const at::Tensor & self, at::IntArrayRef kernel_size, at::IntArrayRef stride, at::IntArrayRef padding, at::IntArrayRef dilation, bool ceil_mode, const at::Tensor & indices) {
    return at::_ops::max_pool3d_with_indices_backward_grad_input::call(grad_output, self, kernel_size, stride, padding, dilation, ceil_mode, indices, grad_input);
}

// aten::max_pool3d_with_indices_backward.grad_input(Tensor grad_output, Tensor self, int[3] kernel_size, int[3] stride, int[3] padding, int[3] dilation, bool ceil_mode, Tensor indices, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & max_pool3d_with_indices_backward_outf(const at::Tensor & grad_output, const at::Tensor & self, at::IntArrayRef kernel_size, at::IntArrayRef stride, at::IntArrayRef padding, at::IntArrayRef dilation, bool ceil_mode, const at::Tensor & indices, at::Tensor & grad_input) {
    return at::_ops::max_pool3d_with_indices_backward_grad_input::call(grad_output, self, kernel_size, stride, padding, dilation, ceil_mode, indices, grad_input);
}

// aten::max_pool3d_with_indices_backward(Tensor grad_output, Tensor self, int[3] kernel_size, int[3] stride, int[3] padding, int[3] dilation, bool ceil_mode, Tensor indices) -> Tensor
TORCH_API inline at::Tensor max_pool3d_with_indices_backward(const at::Tensor & grad_output, const at::Tensor & self, at::IntArrayRef kernel_size, at::IntArrayRef stride, at::IntArrayRef padding, at::IntArrayRef dilation, bool ceil_mode, const at::Tensor & indices) {
    return at::_ops::max_pool3d_with_indices_backward::call(grad_output, self, kernel_size, stride, padding, dilation, ceil_mode, indices);
}

// aten::max_unpool2d.out(Tensor self, Tensor indices, int[2] output_size, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & max_unpool2d_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & indices, at::IntArrayRef output_size) {
    return at::_ops::max_unpool2d_out::call(self, indices, output_size, out);
}

// aten::max_unpool2d.out(Tensor self, Tensor indices, int[2] output_size, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & max_unpool2d_outf(const at::Tensor & self, const at::Tensor & indices, at::IntArrayRef output_size, at::Tensor & out) {
    return at::_ops::max_unpool2d_out::call(self, indices, output_size, out);
}

// aten::max_unpool2d(Tensor self, Tensor indices, int[2] output_size) -> Tensor
TORCH_API inline at::Tensor max_unpool2d(const at::Tensor & self, const at::Tensor & indices, at::IntArrayRef output_size) {
    return at::_ops::max_unpool2d::call(self, indices, output_size);
}

// aten::max_unpool2d_backward.grad_input(Tensor grad_output, Tensor self, Tensor indices, int[2] output_size, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & max_unpool2d_backward_out(at::Tensor & grad_input, const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & indices, at::IntArrayRef output_size) {
    return at::_ops::max_unpool2d_backward_grad_input::call(grad_output, self, indices, output_size, grad_input);
}

// aten::max_unpool2d_backward.grad_input(Tensor grad_output, Tensor self, Tensor indices, int[2] output_size, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & max_unpool2d_backward_outf(const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & indices, at::IntArrayRef output_size, at::Tensor & grad_input) {
    return at::_ops::max_unpool2d_backward_grad_input::call(grad_output, self, indices, output_size, grad_input);
}

// aten::max_unpool2d_backward(Tensor grad_output, Tensor self, Tensor indices, int[2] output_size) -> Tensor
TORCH_API inline at::Tensor max_unpool2d_backward(const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & indices, at::IntArrayRef output_size) {
    return at::_ops::max_unpool2d_backward::call(grad_output, self, indices, output_size);
}

// aten::max_unpool3d.out(Tensor self, Tensor indices, int[3] output_size, int[3] stride, int[3] padding, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & max_unpool3d_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & indices, at::IntArrayRef output_size, at::IntArrayRef stride, at::IntArrayRef padding) {
    return at::_ops::max_unpool3d_out::call(self, indices, output_size, stride, padding, out);
}

// aten::max_unpool3d.out(Tensor self, Tensor indices, int[3] output_size, int[3] stride, int[3] padding, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & max_unpool3d_outf(const at::Tensor & self, const at::Tensor & indices, at::IntArrayRef output_size, at::IntArrayRef stride, at::IntArrayRef padding, at::Tensor & out) {
    return at::_ops::max_unpool3d_out::call(self, indices, output_size, stride, padding, out);
}

// aten::max_unpool3d(Tensor self, Tensor indices, int[3] output_size, int[3] stride, int[3] padding) -> Tensor
TORCH_API inline at::Tensor max_unpool3d(const at::Tensor & self, const at::Tensor & indices, at::IntArrayRef output_size, at::IntArrayRef stride, at::IntArrayRef padding) {
    return at::_ops::max_unpool3d::call(self, indices, output_size, stride, padding);
}

// aten::max_unpool3d_backward.grad_input(Tensor grad_output, Tensor self, Tensor indices, int[3] output_size, int[3] stride, int[3] padding, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & max_unpool3d_backward_out(at::Tensor & grad_input, const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & indices, at::IntArrayRef output_size, at::IntArrayRef stride, at::IntArrayRef padding) {
    return at::_ops::max_unpool3d_backward_grad_input::call(grad_output, self, indices, output_size, stride, padding, grad_input);
}

// aten::max_unpool3d_backward.grad_input(Tensor grad_output, Tensor self, Tensor indices, int[3] output_size, int[3] stride, int[3] padding, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & max_unpool3d_backward_outf(const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & indices, at::IntArrayRef output_size, at::IntArrayRef stride, at::IntArrayRef padding, at::Tensor & grad_input) {
    return at::_ops::max_unpool3d_backward_grad_input::call(grad_output, self, indices, output_size, stride, padding, grad_input);
}

// aten::max_unpool3d_backward(Tensor grad_output, Tensor self, Tensor indices, int[3] output_size, int[3] stride, int[3] padding) -> Tensor
TORCH_API inline at::Tensor max_unpool3d_backward(const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & indices, at::IntArrayRef output_size, at::IntArrayRef stride, at::IntArrayRef padding) {
    return at::_ops::max_unpool3d_backward::call(grad_output, self, indices, output_size, stride, padding);
}

// aten::reflection_pad1d.out(Tensor self, int[2] padding, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & reflection_pad1d_out(at::Tensor & out, const at::Tensor & self, at::IntArrayRef padding) {
    return at::_ops::reflection_pad1d_out::call(self, padding, out);
}

// aten::reflection_pad1d.out(Tensor self, int[2] padding, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & reflection_pad1d_outf(const at::Tensor & self, at::IntArrayRef padding, at::Tensor & out) {
    return at::_ops::reflection_pad1d_out::call(self, padding, out);
}

// aten::reflection_pad1d(Tensor self, int[2] padding) -> Tensor
TORCH_API inline at::Tensor reflection_pad1d(const at::Tensor & self, at::IntArrayRef padding) {
    return at::_ops::reflection_pad1d::call(self, padding);
}

// aten::reflection_pad1d_backward.grad_input(Tensor grad_output, Tensor self, int[2] padding, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & reflection_pad1d_backward_out(at::Tensor & grad_input, const at::Tensor & grad_output, const at::Tensor & self, at::IntArrayRef padding) {
    return at::_ops::reflection_pad1d_backward_grad_input::call(grad_output, self, padding, grad_input);
}

// aten::reflection_pad1d_backward.grad_input(Tensor grad_output, Tensor self, int[2] padding, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & reflection_pad1d_backward_outf(const at::Tensor & grad_output, const at::Tensor & self, at::IntArrayRef padding, at::Tensor & grad_input) {
    return at::_ops::reflection_pad1d_backward_grad_input::call(grad_output, self, padding, grad_input);
}

// aten::reflection_pad1d_backward(Tensor grad_output, Tensor self, int[2] padding) -> Tensor
TORCH_API inline at::Tensor reflection_pad1d_backward(const at::Tensor & grad_output, const at::Tensor & self, at::IntArrayRef padding) {
    return at::_ops::reflection_pad1d_backward::call(grad_output, self, padding);
}

// aten::reflection_pad2d.out(Tensor self, int[4] padding, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & reflection_pad2d_out(at::Tensor & out, const at::Tensor & self, at::IntArrayRef padding) {
    return at::_ops::reflection_pad2d_out::call(self, padding, out);
}

// aten::reflection_pad2d.out(Tensor self, int[4] padding, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & reflection_pad2d_outf(const at::Tensor & self, at::IntArrayRef padding, at::Tensor & out) {
    return at::_ops::reflection_pad2d_out::call(self, padding, out);
}

// aten::reflection_pad2d(Tensor self, int[4] padding) -> Tensor
TORCH_API inline at::Tensor reflection_pad2d(const at::Tensor & self, at::IntArrayRef padding) {
    return at::_ops::reflection_pad2d::call(self, padding);
}

// aten::reflection_pad2d_backward.grad_input(Tensor grad_output, Tensor self, int[4] padding, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & reflection_pad2d_backward_out(at::Tensor & grad_input, const at::Tensor & grad_output, const at::Tensor & self, at::IntArrayRef padding) {
    return at::_ops::reflection_pad2d_backward_grad_input::call(grad_output, self, padding, grad_input);
}

// aten::reflection_pad2d_backward.grad_input(Tensor grad_output, Tensor self, int[4] padding, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & reflection_pad2d_backward_outf(const at::Tensor & grad_output, const at::Tensor & self, at::IntArrayRef padding, at::Tensor & grad_input) {
    return at::_ops::reflection_pad2d_backward_grad_input::call(grad_output, self, padding, grad_input);
}

// aten::reflection_pad2d_backward(Tensor grad_output, Tensor self, int[4] padding) -> Tensor
TORCH_API inline at::Tensor reflection_pad2d_backward(const at::Tensor & grad_output, const at::Tensor & self, at::IntArrayRef padding) {
    return at::_ops::reflection_pad2d_backward::call(grad_output, self, padding);
}

// aten::reflection_pad3d.out(Tensor self, int[6] padding, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & reflection_pad3d_out(at::Tensor & out, const at::Tensor & self, at::IntArrayRef padding) {
    return at::_ops::reflection_pad3d_out::call(self, padding, out);
}

// aten::reflection_pad3d.out(Tensor self, int[6] padding, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & reflection_pad3d_outf(const at::Tensor & self, at::IntArrayRef padding, at::Tensor & out) {
    return at::_ops::reflection_pad3d_out::call(self, padding, out);
}

// aten::reflection_pad3d(Tensor self, int[6] padding) -> Tensor
TORCH_API inline at::Tensor reflection_pad3d(const at::Tensor & self, at::IntArrayRef padding) {
    return at::_ops::reflection_pad3d::call(self, padding);
}

// aten::reflection_pad3d_backward.grad_input(Tensor grad_output, Tensor self, int[6] padding, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & reflection_pad3d_backward_out(at::Tensor & grad_input, const at::Tensor & grad_output, const at::Tensor & self, at::IntArrayRef padding) {
    return at::_ops::reflection_pad3d_backward_grad_input::call(grad_output, self, padding, grad_input);
}

// aten::reflection_pad3d_backward.grad_input(Tensor grad_output, Tensor self, int[6] padding, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & reflection_pad3d_backward_outf(const at::Tensor & grad_output, const at::Tensor & self, at::IntArrayRef padding, at::Tensor & grad_input) {
    return at::_ops::reflection_pad3d_backward_grad_input::call(grad_output, self, padding, grad_input);
}

// aten::reflection_pad3d_backward(Tensor grad_output, Tensor self, int[6] padding) -> Tensor
TORCH_API inline at::Tensor reflection_pad3d_backward(const at::Tensor & grad_output, const at::Tensor & self, at::IntArrayRef padding) {
    return at::_ops::reflection_pad3d_backward::call(grad_output, self, padding);
}

// aten::replication_pad1d.out(Tensor self, int[2] padding, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & replication_pad1d_out(at::Tensor & out, const at::Tensor & self, at::IntArrayRef padding) {
    return at::_ops::replication_pad1d_out::call(self, padding, out);
}

// aten::replication_pad1d.out(Tensor self, int[2] padding, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & replication_pad1d_outf(const at::Tensor & self, at::IntArrayRef padding, at::Tensor & out) {
    return at::_ops::replication_pad1d_out::call(self, padding, out);
}

// aten::replication_pad1d(Tensor self, int[2] padding) -> Tensor
TORCH_API inline at::Tensor replication_pad1d(const at::Tensor & self, at::IntArrayRef padding) {
    return at::_ops::replication_pad1d::call(self, padding);
}

// aten::replication_pad1d_backward.grad_input(Tensor grad_output, Tensor self, int[2] padding, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & replication_pad1d_backward_out(at::Tensor & grad_input, const at::Tensor & grad_output, const at::Tensor & self, at::IntArrayRef padding) {
    return at::_ops::replication_pad1d_backward_grad_input::call(grad_output, self, padding, grad_input);
}

// aten::replication_pad1d_backward.grad_input(Tensor grad_output, Tensor self, int[2] padding, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & replication_pad1d_backward_outf(const at::Tensor & grad_output, const at::Tensor & self, at::IntArrayRef padding, at::Tensor & grad_input) {
    return at::_ops::replication_pad1d_backward_grad_input::call(grad_output, self, padding, grad_input);
}

// aten::replication_pad1d_backward(Tensor grad_output, Tensor self, int[2] padding) -> Tensor
TORCH_API inline at::Tensor replication_pad1d_backward(const at::Tensor & grad_output, const at::Tensor & self, at::IntArrayRef padding) {
    return at::_ops::replication_pad1d_backward::call(grad_output, self, padding);
}

// aten::replication_pad2d.out(Tensor self, int[4] padding, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & replication_pad2d_out(at::Tensor & out, const at::Tensor & self, at::IntArrayRef padding) {
    return at::_ops::replication_pad2d_out::call(self, padding, out);
}

// aten::replication_pad2d.out(Tensor self, int[4] padding, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & replication_pad2d_outf(const at::Tensor & self, at::IntArrayRef padding, at::Tensor & out) {
    return at::_ops::replication_pad2d_out::call(self, padding, out);
}

// aten::replication_pad2d(Tensor self, int[4] padding) -> Tensor
TORCH_API inline at::Tensor replication_pad2d(const at::Tensor & self, at::IntArrayRef padding) {
    return at::_ops::replication_pad2d::call(self, padding);
}

// aten::replication_pad2d_backward.grad_input(Tensor grad_output, Tensor self, int[4] padding, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & replication_pad2d_backward_out(at::Tensor & grad_input, const at::Tensor & grad_output, const at::Tensor & self, at::IntArrayRef padding) {
    return at::_ops::replication_pad2d_backward_grad_input::call(grad_output, self, padding, grad_input);
}

// aten::replication_pad2d_backward.grad_input(Tensor grad_output, Tensor self, int[4] padding, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & replication_pad2d_backward_outf(const at::Tensor & grad_output, const at::Tensor & self, at::IntArrayRef padding, at::Tensor & grad_input) {
    return at::_ops::replication_pad2d_backward_grad_input::call(grad_output, self, padding, grad_input);
}

// aten::replication_pad2d_backward(Tensor grad_output, Tensor self, int[4] padding) -> Tensor
TORCH_API inline at::Tensor replication_pad2d_backward(const at::Tensor & grad_output, const at::Tensor & self, at::IntArrayRef padding) {
    return at::_ops::replication_pad2d_backward::call(grad_output, self, padding);
}

// aten::replication_pad3d.out(Tensor self, int[6] padding, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & replication_pad3d_out(at::Tensor & out, const at::Tensor & self, at::IntArrayRef padding) {
    return at::_ops::replication_pad3d_out::call(self, padding, out);
}

// aten::replication_pad3d.out(Tensor self, int[6] padding, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & replication_pad3d_outf(const at::Tensor & self, at::IntArrayRef padding, at::Tensor & out) {
    return at::_ops::replication_pad3d_out::call(self, padding, out);
}

// aten::replication_pad3d(Tensor self, int[6] padding) -> Tensor
TORCH_API inline at::Tensor replication_pad3d(const at::Tensor & self, at::IntArrayRef padding) {
    return at::_ops::replication_pad3d::call(self, padding);
}

// aten::replication_pad3d_backward.grad_input(Tensor grad_output, Tensor self, int[6] padding, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & replication_pad3d_backward_out(at::Tensor & grad_input, const at::Tensor & grad_output, const at::Tensor & self, at::IntArrayRef padding) {
    return at::_ops::replication_pad3d_backward_grad_input::call(grad_output, self, padding, grad_input);
}

// aten::replication_pad3d_backward.grad_input(Tensor grad_output, Tensor self, int[6] padding, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & replication_pad3d_backward_outf(const at::Tensor & grad_output, const at::Tensor & self, at::IntArrayRef padding, at::Tensor & grad_input) {
    return at::_ops::replication_pad3d_backward_grad_input::call(grad_output, self, padding, grad_input);
}

// aten::replication_pad3d_backward(Tensor grad_output, Tensor self, int[6] padding) -> Tensor
TORCH_API inline at::Tensor replication_pad3d_backward(const at::Tensor & grad_output, const at::Tensor & self, at::IntArrayRef padding) {
    return at::_ops::replication_pad3d_backward::call(grad_output, self, padding);
}

// aten::upsample_linear1d.vec(Tensor input, int[]? output_size, bool align_corners, float[]? scale_factors) -> Tensor
TORCH_API inline at::Tensor upsample_linear1d(const at::Tensor & input, c10::optional<at::IntArrayRef> output_size, bool align_corners, c10::optional<at::ArrayRef<double>> scale_factors) {
    return at::_ops::upsample_linear1d_vec::call(input, output_size, align_corners, scale_factors);
}

// aten::upsample_linear1d_backward.vec(Tensor grad_output, int[]? output_size, int[] input_size, bool align_corners, float[]? scale_factors) -> Tensor
TORCH_API inline at::Tensor upsample_linear1d_backward(const at::Tensor & grad_output, c10::optional<at::IntArrayRef> output_size, at::IntArrayRef input_size, bool align_corners, c10::optional<at::ArrayRef<double>> scale_factors) {
    return at::_ops::upsample_linear1d_backward_vec::call(grad_output, output_size, input_size, align_corners, scale_factors);
}

// aten::upsample_bilinear2d.vec(Tensor input, int[]? output_size, bool align_corners, float[]? scale_factors) -> Tensor
TORCH_API inline at::Tensor upsample_bilinear2d(const at::Tensor & input, c10::optional<at::IntArrayRef> output_size, bool align_corners, c10::optional<at::ArrayRef<double>> scale_factors) {
    return at::_ops::upsample_bilinear2d_vec::call(input, output_size, align_corners, scale_factors);
}

// aten::upsample_bilinear2d_backward.vec(Tensor grad_output, int[]? output_size, int[] input_size, bool align_corners, float[]? scale_factors) -> Tensor
TORCH_API inline at::Tensor upsample_bilinear2d_backward(const at::Tensor & grad_output, c10::optional<at::IntArrayRef> output_size, at::IntArrayRef input_size, bool align_corners, c10::optional<at::ArrayRef<double>> scale_factors) {
    return at::_ops::upsample_bilinear2d_backward_vec::call(grad_output, output_size, input_size, align_corners, scale_factors);
}

// aten::upsample_trilinear3d.vec(Tensor input, int[]? output_size, bool align_corners, float[]? scale_factors) -> Tensor
TORCH_API inline at::Tensor upsample_trilinear3d(const at::Tensor & input, c10::optional<at::IntArrayRef> output_size, bool align_corners, c10::optional<at::ArrayRef<double>> scale_factors) {
    return at::_ops::upsample_trilinear3d_vec::call(input, output_size, align_corners, scale_factors);
}

// aten::upsample_trilinear3d_backward.vec(Tensor grad_output, int[]? output_size, int[] input_size, bool align_corners, float[]? scale_factors) -> Tensor
TORCH_API inline at::Tensor upsample_trilinear3d_backward(const at::Tensor & grad_output, c10::optional<at::IntArrayRef> output_size, at::IntArrayRef input_size, bool align_corners, c10::optional<at::ArrayRef<double>> scale_factors) {
    return at::_ops::upsample_trilinear3d_backward_vec::call(grad_output, output_size, input_size, align_corners, scale_factors);
}

// aten::upsample_bicubic2d.vec(Tensor input, int[]? output_size, bool align_corners, float[]? scale_factors) -> Tensor
TORCH_API inline at::Tensor upsample_bicubic2d(const at::Tensor & input, c10::optional<at::IntArrayRef> output_size, bool align_corners, c10::optional<at::ArrayRef<double>> scale_factors) {
    return at::_ops::upsample_bicubic2d_vec::call(input, output_size, align_corners, scale_factors);
}

// aten::upsample_bicubic2d_backward.vec(Tensor grad_output, int[]? output_size, int[] input_size, bool align_corners, float[]? scale_factors) -> Tensor
TORCH_API inline at::Tensor upsample_bicubic2d_backward(const at::Tensor & grad_output, c10::optional<at::IntArrayRef> output_size, at::IntArrayRef input_size, bool align_corners, c10::optional<at::ArrayRef<double>> scale_factors) {
    return at::_ops::upsample_bicubic2d_backward_vec::call(grad_output, output_size, input_size, align_corners, scale_factors);
}

// aten::upsample_nearest1d.vec(Tensor input, int[]? output_size, float[]? scale_factors) -> Tensor
TORCH_API inline at::Tensor upsample_nearest1d(const at::Tensor & input, c10::optional<at::IntArrayRef> output_size, c10::optional<at::ArrayRef<double>> scale_factors) {
    return at::_ops::upsample_nearest1d_vec::call(input, output_size, scale_factors);
}

// aten::upsample_nearest1d_backward.vec(Tensor grad_output, int[]? output_size, int[] input_size, float[]? scale_factors) -> Tensor
TORCH_API inline at::Tensor upsample_nearest1d_backward(const at::Tensor & grad_output, c10::optional<at::IntArrayRef> output_size, at::IntArrayRef input_size, c10::optional<at::ArrayRef<double>> scale_factors) {
    return at::_ops::upsample_nearest1d_backward_vec::call(grad_output, output_size, input_size, scale_factors);
}

// aten::upsample_nearest2d.vec(Tensor input, int[]? output_size, float[]? scale_factors) -> Tensor
TORCH_API inline at::Tensor upsample_nearest2d(const at::Tensor & input, c10::optional<at::IntArrayRef> output_size, c10::optional<at::ArrayRef<double>> scale_factors) {
    return at::_ops::upsample_nearest2d_vec::call(input, output_size, scale_factors);
}

// aten::upsample_nearest2d_backward.vec(Tensor grad_output, int[]? output_size, int[] input_size, float[]? scale_factors) -> Tensor
TORCH_API inline at::Tensor upsample_nearest2d_backward(const at::Tensor & grad_output, c10::optional<at::IntArrayRef> output_size, at::IntArrayRef input_size, c10::optional<at::ArrayRef<double>> scale_factors) {
    return at::_ops::upsample_nearest2d_backward_vec::call(grad_output, output_size, input_size, scale_factors);
}

// aten::upsample_nearest3d.vec(Tensor input, int[]? output_size, float[]? scale_factors) -> Tensor
TORCH_API inline at::Tensor upsample_nearest3d(const at::Tensor & input, c10::optional<at::IntArrayRef> output_size, c10::optional<at::ArrayRef<double>> scale_factors) {
    return at::_ops::upsample_nearest3d_vec::call(input, output_size, scale_factors);
}

// aten::upsample_nearest3d_backward.vec(Tensor grad_output, int[]? output_size, int[] input_size, float[]? scale_factors) -> Tensor
TORCH_API inline at::Tensor upsample_nearest3d_backward(const at::Tensor & grad_output, c10::optional<at::IntArrayRef> output_size, at::IntArrayRef input_size, c10::optional<at::ArrayRef<double>> scale_factors) {
    return at::_ops::upsample_nearest3d_backward_vec::call(grad_output, output_size, input_size, scale_factors);
}

// aten::upsample_linear1d.out(Tensor self, int[1] output_size, bool align_corners, float? scales=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & upsample_linear1d_out(at::Tensor & out, const at::Tensor & self, at::IntArrayRef output_size, bool align_corners, c10::optional<double> scales=c10::nullopt) {
    return at::_ops::upsample_linear1d_out::call(self, output_size, align_corners, scales, out);
}

// aten::upsample_linear1d.out(Tensor self, int[1] output_size, bool align_corners, float? scales=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & upsample_linear1d_outf(const at::Tensor & self, at::IntArrayRef output_size, bool align_corners, c10::optional<double> scales, at::Tensor & out) {
    return at::_ops::upsample_linear1d_out::call(self, output_size, align_corners, scales, out);
}

// aten::upsample_linear1d(Tensor self, int[1] output_size, bool align_corners, float? scales=None) -> Tensor
TORCH_API inline at::Tensor upsample_linear1d(const at::Tensor & self, at::IntArrayRef output_size, bool align_corners, c10::optional<double> scales=c10::nullopt) {
    return at::_ops::upsample_linear1d::call(self, output_size, align_corners, scales);
}

// aten::upsample_linear1d_backward.grad_input(Tensor grad_output, int[1] output_size, int[3] input_size, bool align_corners, float? scales=None, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & upsample_linear1d_backward_out(at::Tensor & grad_input, const at::Tensor & grad_output, at::IntArrayRef output_size, at::IntArrayRef input_size, bool align_corners, c10::optional<double> scales=c10::nullopt) {
    return at::_ops::upsample_linear1d_backward_grad_input::call(grad_output, output_size, input_size, align_corners, scales, grad_input);
}

// aten::upsample_linear1d_backward.grad_input(Tensor grad_output, int[1] output_size, int[3] input_size, bool align_corners, float? scales=None, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & upsample_linear1d_backward_outf(const at::Tensor & grad_output, at::IntArrayRef output_size, at::IntArrayRef input_size, bool align_corners, c10::optional<double> scales, at::Tensor & grad_input) {
    return at::_ops::upsample_linear1d_backward_grad_input::call(grad_output, output_size, input_size, align_corners, scales, grad_input);
}

// aten::upsample_linear1d_backward(Tensor grad_output, int[1] output_size, int[3] input_size, bool align_corners, float? scales=None) -> Tensor
TORCH_API inline at::Tensor upsample_linear1d_backward(const at::Tensor & grad_output, at::IntArrayRef output_size, at::IntArrayRef input_size, bool align_corners, c10::optional<double> scales=c10::nullopt) {
    return at::_ops::upsample_linear1d_backward::call(grad_output, output_size, input_size, align_corners, scales);
}

// aten::upsample_bilinear2d.out(Tensor self, int[2] output_size, bool align_corners, float? scales_h=None, float? scales_w=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & upsample_bilinear2d_out(at::Tensor & out, const at::Tensor & self, at::IntArrayRef output_size, bool align_corners, c10::optional<double> scales_h=c10::nullopt, c10::optional<double> scales_w=c10::nullopt) {
    return at::_ops::upsample_bilinear2d_out::call(self, output_size, align_corners, scales_h, scales_w, out);
}

// aten::upsample_bilinear2d.out(Tensor self, int[2] output_size, bool align_corners, float? scales_h=None, float? scales_w=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & upsample_bilinear2d_outf(const at::Tensor & self, at::IntArrayRef output_size, bool align_corners, c10::optional<double> scales_h, c10::optional<double> scales_w, at::Tensor & out) {
    return at::_ops::upsample_bilinear2d_out::call(self, output_size, align_corners, scales_h, scales_w, out);
}

// aten::upsample_bilinear2d(Tensor self, int[2] output_size, bool align_corners, float? scales_h=None, float? scales_w=None) -> Tensor
TORCH_API inline at::Tensor upsample_bilinear2d(const at::Tensor & self, at::IntArrayRef output_size, bool align_corners, c10::optional<double> scales_h=c10::nullopt, c10::optional<double> scales_w=c10::nullopt) {
    return at::_ops::upsample_bilinear2d::call(self, output_size, align_corners, scales_h, scales_w);
}

// aten::upsample_bilinear2d_backward.grad_input(Tensor grad_output, int[2] output_size, int[4] input_size, bool align_corners, float? scales_h=None, float? scales_w=None, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & upsample_bilinear2d_backward_out(at::Tensor & grad_input, const at::Tensor & grad_output, at::IntArrayRef output_size, at::IntArrayRef input_size, bool align_corners, c10::optional<double> scales_h=c10::nullopt, c10::optional<double> scales_w=c10::nullopt) {
    return at::_ops::upsample_bilinear2d_backward_grad_input::call(grad_output, output_size, input_size, align_corners, scales_h, scales_w, grad_input);
}

// aten::upsample_bilinear2d_backward.grad_input(Tensor grad_output, int[2] output_size, int[4] input_size, bool align_corners, float? scales_h=None, float? scales_w=None, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & upsample_bilinear2d_backward_outf(const at::Tensor & grad_output, at::IntArrayRef output_size, at::IntArrayRef input_size, bool align_corners, c10::optional<double> scales_h, c10::optional<double> scales_w, at::Tensor & grad_input) {
    return at::_ops::upsample_bilinear2d_backward_grad_input::call(grad_output, output_size, input_size, align_corners, scales_h, scales_w, grad_input);
}

// aten::upsample_bilinear2d_backward(Tensor grad_output, int[2] output_size, int[4] input_size, bool align_corners, float? scales_h=None, float? scales_w=None) -> Tensor
TORCH_API inline at::Tensor upsample_bilinear2d_backward(const at::Tensor & grad_output, at::IntArrayRef output_size, at::IntArrayRef input_size, bool align_corners, c10::optional<double> scales_h=c10::nullopt, c10::optional<double> scales_w=c10::nullopt) {
    return at::_ops::upsample_bilinear2d_backward::call(grad_output, output_size, input_size, align_corners, scales_h, scales_w);
}

// aten::upsample_bicubic2d.out(Tensor self, int[2] output_size, bool align_corners, float? scales_h=None, float? scales_w=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & upsample_bicubic2d_out(at::Tensor & out, const at::Tensor & self, at::IntArrayRef output_size, bool align_corners, c10::optional<double> scales_h=c10::nullopt, c10::optional<double> scales_w=c10::nullopt) {
    return at::_ops::upsample_bicubic2d_out::call(self, output_size, align_corners, scales_h, scales_w, out);
}

// aten::upsample_bicubic2d.out(Tensor self, int[2] output_size, bool align_corners, float? scales_h=None, float? scales_w=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & upsample_bicubic2d_outf(const at::Tensor & self, at::IntArrayRef output_size, bool align_corners, c10::optional<double> scales_h, c10::optional<double> scales_w, at::Tensor & out) {
    return at::_ops::upsample_bicubic2d_out::call(self, output_size, align_corners, scales_h, scales_w, out);
}

// aten::upsample_bicubic2d(Tensor self, int[2] output_size, bool align_corners, float? scales_h=None, float? scales_w=None) -> Tensor
TORCH_API inline at::Tensor upsample_bicubic2d(const at::Tensor & self, at::IntArrayRef output_size, bool align_corners, c10::optional<double> scales_h=c10::nullopt, c10::optional<double> scales_w=c10::nullopt) {
    return at::_ops::upsample_bicubic2d::call(self, output_size, align_corners, scales_h, scales_w);
}

// aten::upsample_bicubic2d_backward.grad_input(Tensor grad_output, int[2] output_size, int[4] input_size, bool align_corners, float? scales_h=None, float? scales_w=None, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & upsample_bicubic2d_backward_out(at::Tensor & grad_input, const at::Tensor & grad_output, at::IntArrayRef output_size, at::IntArrayRef input_size, bool align_corners, c10::optional<double> scales_h=c10::nullopt, c10::optional<double> scales_w=c10::nullopt) {
    return at::_ops::upsample_bicubic2d_backward_grad_input::call(grad_output, output_size, input_size, align_corners, scales_h, scales_w, grad_input);
}

// aten::upsample_bicubic2d_backward.grad_input(Tensor grad_output, int[2] output_size, int[4] input_size, bool align_corners, float? scales_h=None, float? scales_w=None, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & upsample_bicubic2d_backward_outf(const at::Tensor & grad_output, at::IntArrayRef output_size, at::IntArrayRef input_size, bool align_corners, c10::optional<double> scales_h, c10::optional<double> scales_w, at::Tensor & grad_input) {
    return at::_ops::upsample_bicubic2d_backward_grad_input::call(grad_output, output_size, input_size, align_corners, scales_h, scales_w, grad_input);
}

// aten::upsample_bicubic2d_backward(Tensor grad_output, int[2] output_size, int[4] input_size, bool align_corners, float? scales_h=None, float? scales_w=None) -> Tensor
TORCH_API inline at::Tensor upsample_bicubic2d_backward(const at::Tensor & grad_output, at::IntArrayRef output_size, at::IntArrayRef input_size, bool align_corners, c10::optional<double> scales_h=c10::nullopt, c10::optional<double> scales_w=c10::nullopt) {
    return at::_ops::upsample_bicubic2d_backward::call(grad_output, output_size, input_size, align_corners, scales_h, scales_w);
}

// aten::upsample_trilinear3d.out(Tensor self, int[3] output_size, bool align_corners, float? scales_d=None, float? scales_h=None, float? scales_w=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & upsample_trilinear3d_out(at::Tensor & out, const at::Tensor & self, at::IntArrayRef output_size, bool align_corners, c10::optional<double> scales_d=c10::nullopt, c10::optional<double> scales_h=c10::nullopt, c10::optional<double> scales_w=c10::nullopt) {
    return at::_ops::upsample_trilinear3d_out::call(self, output_size, align_corners, scales_d, scales_h, scales_w, out);
}

// aten::upsample_trilinear3d.out(Tensor self, int[3] output_size, bool align_corners, float? scales_d=None, float? scales_h=None, float? scales_w=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & upsample_trilinear3d_outf(const at::Tensor & self, at::IntArrayRef output_size, bool align_corners, c10::optional<double> scales_d, c10::optional<double> scales_h, c10::optional<double> scales_w, at::Tensor & out) {
    return at::_ops::upsample_trilinear3d_out::call(self, output_size, align_corners, scales_d, scales_h, scales_w, out);
}

// aten::upsample_trilinear3d(Tensor self, int[3] output_size, bool align_corners, float? scales_d=None, float? scales_h=None, float? scales_w=None) -> Tensor
TORCH_API inline at::Tensor upsample_trilinear3d(const at::Tensor & self, at::IntArrayRef output_size, bool align_corners, c10::optional<double> scales_d=c10::nullopt, c10::optional<double> scales_h=c10::nullopt, c10::optional<double> scales_w=c10::nullopt) {
    return at::_ops::upsample_trilinear3d::call(self, output_size, align_corners, scales_d, scales_h, scales_w);
}

// aten::upsample_trilinear3d_backward.grad_input(Tensor grad_output, int[3] output_size, int[5] input_size, bool align_corners, float? scales_d=None, float? scales_h=None, float? scales_w=None, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & upsample_trilinear3d_backward_out(at::Tensor & grad_input, const at::Tensor & grad_output, at::IntArrayRef output_size, at::IntArrayRef input_size, bool align_corners, c10::optional<double> scales_d=c10::nullopt, c10::optional<double> scales_h=c10::nullopt, c10::optional<double> scales_w=c10::nullopt) {
    return at::_ops::upsample_trilinear3d_backward_grad_input::call(grad_output, output_size, input_size, align_corners, scales_d, scales_h, scales_w, grad_input);
}

// aten::upsample_trilinear3d_backward.grad_input(Tensor grad_output, int[3] output_size, int[5] input_size, bool align_corners, float? scales_d=None, float? scales_h=None, float? scales_w=None, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & upsample_trilinear3d_backward_outf(const at::Tensor & grad_output, at::IntArrayRef output_size, at::IntArrayRef input_size, bool align_corners, c10::optional<double> scales_d, c10::optional<double> scales_h, c10::optional<double> scales_w, at::Tensor & grad_input) {
    return at::_ops::upsample_trilinear3d_backward_grad_input::call(grad_output, output_size, input_size, align_corners, scales_d, scales_h, scales_w, grad_input);
}

// aten::upsample_trilinear3d_backward(Tensor grad_output, int[3] output_size, int[5] input_size, bool align_corners, float? scales_d=None, float? scales_h=None, float? scales_w=None) -> Tensor
TORCH_API inline at::Tensor upsample_trilinear3d_backward(const at::Tensor & grad_output, at::IntArrayRef output_size, at::IntArrayRef input_size, bool align_corners, c10::optional<double> scales_d=c10::nullopt, c10::optional<double> scales_h=c10::nullopt, c10::optional<double> scales_w=c10::nullopt) {
    return at::_ops::upsample_trilinear3d_backward::call(grad_output, output_size, input_size, align_corners, scales_d, scales_h, scales_w);
}

// aten::upsample_nearest1d.out(Tensor self, int[1] output_size, float? scales=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & upsample_nearest1d_out(at::Tensor & out, const at::Tensor & self, at::IntArrayRef output_size, c10::optional<double> scales=c10::nullopt) {
    return at::_ops::upsample_nearest1d_out::call(self, output_size, scales, out);
}

// aten::upsample_nearest1d.out(Tensor self, int[1] output_size, float? scales=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & upsample_nearest1d_outf(const at::Tensor & self, at::IntArrayRef output_size, c10::optional<double> scales, at::Tensor & out) {
    return at::_ops::upsample_nearest1d_out::call(self, output_size, scales, out);
}

// aten::upsample_nearest1d(Tensor self, int[1] output_size, float? scales=None) -> Tensor
TORCH_API inline at::Tensor upsample_nearest1d(const at::Tensor & self, at::IntArrayRef output_size, c10::optional<double> scales=c10::nullopt) {
    return at::_ops::upsample_nearest1d::call(self, output_size, scales);
}

// aten::upsample_nearest1d_backward.grad_input(Tensor grad_output, int[1] output_size, int[3] input_size, float? scales=None, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & upsample_nearest1d_backward_out(at::Tensor & grad_input, const at::Tensor & grad_output, at::IntArrayRef output_size, at::IntArrayRef input_size, c10::optional<double> scales=c10::nullopt) {
    return at::_ops::upsample_nearest1d_backward_grad_input::call(grad_output, output_size, input_size, scales, grad_input);
}

// aten::upsample_nearest1d_backward.grad_input(Tensor grad_output, int[1] output_size, int[3] input_size, float? scales=None, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & upsample_nearest1d_backward_outf(const at::Tensor & grad_output, at::IntArrayRef output_size, at::IntArrayRef input_size, c10::optional<double> scales, at::Tensor & grad_input) {
    return at::_ops::upsample_nearest1d_backward_grad_input::call(grad_output, output_size, input_size, scales, grad_input);
}

// aten::upsample_nearest1d_backward(Tensor grad_output, int[1] output_size, int[3] input_size, float? scales=None) -> Tensor
TORCH_API inline at::Tensor upsample_nearest1d_backward(const at::Tensor & grad_output, at::IntArrayRef output_size, at::IntArrayRef input_size, c10::optional<double> scales=c10::nullopt) {
    return at::_ops::upsample_nearest1d_backward::call(grad_output, output_size, input_size, scales);
}

// aten::upsample_nearest2d.out(Tensor self, int[2] output_size, float? scales_h=None, float? scales_w=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & upsample_nearest2d_out(at::Tensor & out, const at::Tensor & self, at::IntArrayRef output_size, c10::optional<double> scales_h=c10::nullopt, c10::optional<double> scales_w=c10::nullopt) {
    return at::_ops::upsample_nearest2d_out::call(self, output_size, scales_h, scales_w, out);
}

// aten::upsample_nearest2d.out(Tensor self, int[2] output_size, float? scales_h=None, float? scales_w=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & upsample_nearest2d_outf(const at::Tensor & self, at::IntArrayRef output_size, c10::optional<double> scales_h, c10::optional<double> scales_w, at::Tensor & out) {
    return at::_ops::upsample_nearest2d_out::call(self, output_size, scales_h, scales_w, out);
}

// aten::upsample_nearest2d(Tensor self, int[2] output_size, float? scales_h=None, float? scales_w=None) -> Tensor
TORCH_API inline at::Tensor upsample_nearest2d(const at::Tensor & self, at::IntArrayRef output_size, c10::optional<double> scales_h=c10::nullopt, c10::optional<double> scales_w=c10::nullopt) {
    return at::_ops::upsample_nearest2d::call(self, output_size, scales_h, scales_w);
}

// aten::upsample_nearest2d_backward.grad_input(Tensor grad_output, int[2] output_size, int[4] input_size, float? scales_h=None, float? scales_w=None, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & upsample_nearest2d_backward_out(at::Tensor & grad_input, const at::Tensor & grad_output, at::IntArrayRef output_size, at::IntArrayRef input_size, c10::optional<double> scales_h=c10::nullopt, c10::optional<double> scales_w=c10::nullopt) {
    return at::_ops::upsample_nearest2d_backward_grad_input::call(grad_output, output_size, input_size, scales_h, scales_w, grad_input);
}

// aten::upsample_nearest2d_backward.grad_input(Tensor grad_output, int[2] output_size, int[4] input_size, float? scales_h=None, float? scales_w=None, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & upsample_nearest2d_backward_outf(const at::Tensor & grad_output, at::IntArrayRef output_size, at::IntArrayRef input_size, c10::optional<double> scales_h, c10::optional<double> scales_w, at::Tensor & grad_input) {
    return at::_ops::upsample_nearest2d_backward_grad_input::call(grad_output, output_size, input_size, scales_h, scales_w, grad_input);
}

// aten::upsample_nearest2d_backward(Tensor grad_output, int[2] output_size, int[4] input_size, float? scales_h=None, float? scales_w=None) -> Tensor
TORCH_API inline at::Tensor upsample_nearest2d_backward(const at::Tensor & grad_output, at::IntArrayRef output_size, at::IntArrayRef input_size, c10::optional<double> scales_h=c10::nullopt, c10::optional<double> scales_w=c10::nullopt) {
    return at::_ops::upsample_nearest2d_backward::call(grad_output, output_size, input_size, scales_h, scales_w);
}

// aten::upsample_nearest3d.out(Tensor self, int[3] output_size, float? scales_d=None, float? scales_h=None, float? scales_w=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & upsample_nearest3d_out(at::Tensor & out, const at::Tensor & self, at::IntArrayRef output_size, c10::optional<double> scales_d=c10::nullopt, c10::optional<double> scales_h=c10::nullopt, c10::optional<double> scales_w=c10::nullopt) {
    return at::_ops::upsample_nearest3d_out::call(self, output_size, scales_d, scales_h, scales_w, out);
}

// aten::upsample_nearest3d.out(Tensor self, int[3] output_size, float? scales_d=None, float? scales_h=None, float? scales_w=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & upsample_nearest3d_outf(const at::Tensor & self, at::IntArrayRef output_size, c10::optional<double> scales_d, c10::optional<double> scales_h, c10::optional<double> scales_w, at::Tensor & out) {
    return at::_ops::upsample_nearest3d_out::call(self, output_size, scales_d, scales_h, scales_w, out);
}

// aten::upsample_nearest3d(Tensor self, int[3] output_size, float? scales_d=None, float? scales_h=None, float? scales_w=None) -> Tensor
TORCH_API inline at::Tensor upsample_nearest3d(const at::Tensor & self, at::IntArrayRef output_size, c10::optional<double> scales_d=c10::nullopt, c10::optional<double> scales_h=c10::nullopt, c10::optional<double> scales_w=c10::nullopt) {
    return at::_ops::upsample_nearest3d::call(self, output_size, scales_d, scales_h, scales_w);
}

// aten::upsample_nearest3d_backward.grad_input(Tensor grad_output, int[3] output_size, int[5] input_size, float? scales_d=None, float? scales_h=None, float? scales_w=None, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & upsample_nearest3d_backward_out(at::Tensor & grad_input, const at::Tensor & grad_output, at::IntArrayRef output_size, at::IntArrayRef input_size, c10::optional<double> scales_d=c10::nullopt, c10::optional<double> scales_h=c10::nullopt, c10::optional<double> scales_w=c10::nullopt) {
    return at::_ops::upsample_nearest3d_backward_grad_input::call(grad_output, output_size, input_size, scales_d, scales_h, scales_w, grad_input);
}

// aten::upsample_nearest3d_backward.grad_input(Tensor grad_output, int[3] output_size, int[5] input_size, float? scales_d=None, float? scales_h=None, float? scales_w=None, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & upsample_nearest3d_backward_outf(const at::Tensor & grad_output, at::IntArrayRef output_size, at::IntArrayRef input_size, c10::optional<double> scales_d, c10::optional<double> scales_h, c10::optional<double> scales_w, at::Tensor & grad_input) {
    return at::_ops::upsample_nearest3d_backward_grad_input::call(grad_output, output_size, input_size, scales_d, scales_h, scales_w, grad_input);
}

// aten::upsample_nearest3d_backward(Tensor grad_output, int[3] output_size, int[5] input_size, float? scales_d=None, float? scales_h=None, float? scales_w=None) -> Tensor
TORCH_API inline at::Tensor upsample_nearest3d_backward(const at::Tensor & grad_output, at::IntArrayRef output_size, at::IntArrayRef input_size, c10::optional<double> scales_d=c10::nullopt, c10::optional<double> scales_h=c10::nullopt, c10::optional<double> scales_w=c10::nullopt) {
    return at::_ops::upsample_nearest3d_backward::call(grad_output, output_size, input_size, scales_d, scales_h, scales_w);
}

// aten::sigmoid_backward.grad_input(Tensor grad_output, Tensor output, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & sigmoid_backward_out(at::Tensor & grad_input, const at::Tensor & grad_output, const at::Tensor & output) {
    return at::_ops::sigmoid_backward_grad_input::call(grad_output, output, grad_input);
}

// aten::sigmoid_backward.grad_input(Tensor grad_output, Tensor output, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & sigmoid_backward_outf(const at::Tensor & grad_output, const at::Tensor & output, at::Tensor & grad_input) {
    return at::_ops::sigmoid_backward_grad_input::call(grad_output, output, grad_input);
}

// aten::sigmoid_backward(Tensor grad_output, Tensor output) -> Tensor
TORCH_API inline at::Tensor sigmoid_backward(const at::Tensor & grad_output, const at::Tensor & output) {
    return at::_ops::sigmoid_backward::call(grad_output, output);
}

// aten::logit_backward.grad_input(Tensor grad_output, Tensor self, float? eps=None, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & logit_backward_out(at::Tensor & grad_input, const at::Tensor & grad_output, const at::Tensor & self, c10::optional<double> eps=c10::nullopt) {
    return at::_ops::logit_backward_grad_input::call(grad_output, self, eps, grad_input);
}

// aten::logit_backward.grad_input(Tensor grad_output, Tensor self, float? eps=None, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & logit_backward_outf(const at::Tensor & grad_output, const at::Tensor & self, c10::optional<double> eps, at::Tensor & grad_input) {
    return at::_ops::logit_backward_grad_input::call(grad_output, self, eps, grad_input);
}

// aten::logit_backward(Tensor grad_output, Tensor self, float? eps=None) -> Tensor
TORCH_API inline at::Tensor logit_backward(const at::Tensor & grad_output, const at::Tensor & self, c10::optional<double> eps=c10::nullopt) {
    return at::_ops::logit_backward::call(grad_output, self, eps);
}

// aten::tanh_backward.grad_input(Tensor grad_output, Tensor output, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & tanh_backward_out(at::Tensor & grad_input, const at::Tensor & grad_output, const at::Tensor & output) {
    return at::_ops::tanh_backward_grad_input::call(grad_output, output, grad_input);
}

// aten::tanh_backward.grad_input(Tensor grad_output, Tensor output, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & tanh_backward_outf(const at::Tensor & grad_output, const at::Tensor & output, at::Tensor & grad_input) {
    return at::_ops::tanh_backward_grad_input::call(grad_output, output, grad_input);
}

// aten::tanh_backward(Tensor grad_output, Tensor output) -> Tensor
TORCH_API inline at::Tensor tanh_backward(const at::Tensor & grad_output, const at::Tensor & output) {
    return at::_ops::tanh_backward::call(grad_output, output);
}

// aten::slow_conv_transpose2d.out(Tensor self, Tensor weight, int[2] kernel_size, Tensor? bias=None, int[2] stride=1, int[2] padding=0, int[2] output_padding=0, int[2] dilation=1, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & slow_conv_transpose2d_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & weight, at::IntArrayRef kernel_size, const c10::optional<at::Tensor> & bias={}, at::IntArrayRef stride=1, at::IntArrayRef padding=0, at::IntArrayRef output_padding=0, at::IntArrayRef dilation=1) {
    return at::_ops::slow_conv_transpose2d_out::call(self, weight, kernel_size, bias, stride, padding, output_padding, dilation, out);
}

// aten::slow_conv_transpose2d.out(Tensor self, Tensor weight, int[2] kernel_size, Tensor? bias=None, int[2] stride=1, int[2] padding=0, int[2] output_padding=0, int[2] dilation=1, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & slow_conv_transpose2d_outf(const at::Tensor & self, const at::Tensor & weight, at::IntArrayRef kernel_size, const c10::optional<at::Tensor> & bias, at::IntArrayRef stride, at::IntArrayRef padding, at::IntArrayRef output_padding, at::IntArrayRef dilation, at::Tensor & out) {
    return at::_ops::slow_conv_transpose2d_out::call(self, weight, kernel_size, bias, stride, padding, output_padding, dilation, out);
}

// aten::slow_conv_transpose2d(Tensor self, Tensor weight, int[2] kernel_size, Tensor? bias=None, int[2] stride=1, int[2] padding=0, int[2] output_padding=0, int[2] dilation=1) -> Tensor
TORCH_API inline at::Tensor slow_conv_transpose2d(const at::Tensor & self, const at::Tensor & weight, at::IntArrayRef kernel_size, const c10::optional<at::Tensor> & bias={}, at::IntArrayRef stride=1, at::IntArrayRef padding=0, at::IntArrayRef output_padding=0, at::IntArrayRef dilation=1) {
    return at::_ops::slow_conv_transpose2d::call(self, weight, kernel_size, bias, stride, padding, output_padding, dilation);
}

// aten::slow_conv_transpose2d_backward.grad_output(Tensor grad_output, Tensor self, Tensor weight, int[2] kernel_size, int[2] stride, int[2] padding, int[2] output_padding, int[2] dilation, Tensor columns, Tensor ones, *, Tensor(a!) grad_input, Tensor(b!) grad_weight, Tensor(c!) grad_bias) -> (Tensor(a!), Tensor(b!), Tensor(c!))
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &,at::Tensor &> slow_conv_transpose2d_backward_out(at::Tensor & grad_input, at::Tensor & grad_weight, at::Tensor & grad_bias, const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & weight, at::IntArrayRef kernel_size, at::IntArrayRef stride, at::IntArrayRef padding, at::IntArrayRef output_padding, at::IntArrayRef dilation, const at::Tensor & columns, const at::Tensor & ones) {
    return at::_ops::slow_conv_transpose2d_backward_grad_output::call(grad_output, self, weight, kernel_size, stride, padding, output_padding, dilation, columns, ones, grad_input, grad_weight, grad_bias);
}

// aten::slow_conv_transpose2d_backward.grad_output(Tensor grad_output, Tensor self, Tensor weight, int[2] kernel_size, int[2] stride, int[2] padding, int[2] output_padding, int[2] dilation, Tensor columns, Tensor ones, *, Tensor(a!) grad_input, Tensor(b!) grad_weight, Tensor(c!) grad_bias) -> (Tensor(a!), Tensor(b!), Tensor(c!))
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &,at::Tensor &> slow_conv_transpose2d_backward_outf(const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & weight, at::IntArrayRef kernel_size, at::IntArrayRef stride, at::IntArrayRef padding, at::IntArrayRef output_padding, at::IntArrayRef dilation, const at::Tensor & columns, const at::Tensor & ones, at::Tensor & grad_input, at::Tensor & grad_weight, at::Tensor & grad_bias) {
    return at::_ops::slow_conv_transpose2d_backward_grad_output::call(grad_output, self, weight, kernel_size, stride, padding, output_padding, dilation, columns, ones, grad_input, grad_weight, grad_bias);
}

// aten::slow_conv_transpose2d_backward.output_mask(Tensor grad_output, Tensor self, Tensor weight, int[2] kernel_size, int[2] stride, int[2] padding, int[2] output_padding, int[2] dilation, Tensor columns, Tensor ones, bool[3] output_mask) -> (Tensor grad_input, Tensor grad_weight, Tensor grad_bias)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor,at::Tensor> slow_conv_transpose2d_backward(const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & weight, at::IntArrayRef kernel_size, at::IntArrayRef stride, at::IntArrayRef padding, at::IntArrayRef output_padding, at::IntArrayRef dilation, const at::Tensor & columns, const at::Tensor & ones, ::std::array<bool,3> output_mask) {
    return at::_ops::slow_conv_transpose2d_backward_output_mask::call(grad_output, self, weight, kernel_size, stride, padding, output_padding, dilation, columns, ones, output_mask);
}

// aten::slow_conv_transpose3d.out(Tensor self, Tensor weight, int[3] kernel_size, Tensor? bias=None, int[3] stride=1, int[3] padding=0, int[3] output_padding=0, int[3] dilation=1, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & slow_conv_transpose3d_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & weight, at::IntArrayRef kernel_size, const c10::optional<at::Tensor> & bias={}, at::IntArrayRef stride=1, at::IntArrayRef padding=0, at::IntArrayRef output_padding=0, at::IntArrayRef dilation=1) {
    return at::_ops::slow_conv_transpose3d_out::call(self, weight, kernel_size, bias, stride, padding, output_padding, dilation, out);
}

// aten::slow_conv_transpose3d.out(Tensor self, Tensor weight, int[3] kernel_size, Tensor? bias=None, int[3] stride=1, int[3] padding=0, int[3] output_padding=0, int[3] dilation=1, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & slow_conv_transpose3d_outf(const at::Tensor & self, const at::Tensor & weight, at::IntArrayRef kernel_size, const c10::optional<at::Tensor> & bias, at::IntArrayRef stride, at::IntArrayRef padding, at::IntArrayRef output_padding, at::IntArrayRef dilation, at::Tensor & out) {
    return at::_ops::slow_conv_transpose3d_out::call(self, weight, kernel_size, bias, stride, padding, output_padding, dilation, out);
}

// aten::slow_conv_transpose3d(Tensor self, Tensor weight, int[3] kernel_size, Tensor? bias=None, int[3] stride=1, int[3] padding=0, int[3] output_padding=0, int[3] dilation=1) -> Tensor
TORCH_API inline at::Tensor slow_conv_transpose3d(const at::Tensor & self, const at::Tensor & weight, at::IntArrayRef kernel_size, const c10::optional<at::Tensor> & bias={}, at::IntArrayRef stride=1, at::IntArrayRef padding=0, at::IntArrayRef output_padding=0, at::IntArrayRef dilation=1) {
    return at::_ops::slow_conv_transpose3d::call(self, weight, kernel_size, bias, stride, padding, output_padding, dilation);
}

// aten::slow_conv_transpose3d_backward.grad_output(Tensor grad_output, Tensor self, Tensor weight, int[3] kernel_size, int[3] stride, int[3] padding, int[3] output_padding, int[3] dilation, Tensor finput, Tensor fgrad_input, *, Tensor(a!) grad_input, Tensor(b!) grad_weight, Tensor(c!) grad_bias) -> (Tensor(a!), Tensor(b!), Tensor(c!))
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &,at::Tensor &> slow_conv_transpose3d_backward_out(at::Tensor & grad_input, at::Tensor & grad_weight, at::Tensor & grad_bias, const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & weight, at::IntArrayRef kernel_size, at::IntArrayRef stride, at::IntArrayRef padding, at::IntArrayRef output_padding, at::IntArrayRef dilation, const at::Tensor & finput, const at::Tensor & fgrad_input) {
    return at::_ops::slow_conv_transpose3d_backward_grad_output::call(grad_output, self, weight, kernel_size, stride, padding, output_padding, dilation, finput, fgrad_input, grad_input, grad_weight, grad_bias);
}

// aten::slow_conv_transpose3d_backward.grad_output(Tensor grad_output, Tensor self, Tensor weight, int[3] kernel_size, int[3] stride, int[3] padding, int[3] output_padding, int[3] dilation, Tensor finput, Tensor fgrad_input, *, Tensor(a!) grad_input, Tensor(b!) grad_weight, Tensor(c!) grad_bias) -> (Tensor(a!), Tensor(b!), Tensor(c!))
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &,at::Tensor &> slow_conv_transpose3d_backward_outf(const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & weight, at::IntArrayRef kernel_size, at::IntArrayRef stride, at::IntArrayRef padding, at::IntArrayRef output_padding, at::IntArrayRef dilation, const at::Tensor & finput, const at::Tensor & fgrad_input, at::Tensor & grad_input, at::Tensor & grad_weight, at::Tensor & grad_bias) {
    return at::_ops::slow_conv_transpose3d_backward_grad_output::call(grad_output, self, weight, kernel_size, stride, padding, output_padding, dilation, finput, fgrad_input, grad_input, grad_weight, grad_bias);
}

// aten::slow_conv_transpose3d_backward.output_mask(Tensor grad_output, Tensor self, Tensor weight, int[3] kernel_size, int[3] stride, int[3] padding, int[3] output_padding, int[3] dilation, Tensor finput, Tensor fgrad_input, bool[3] output_mask) -> (Tensor grad_input, Tensor grad_weight, Tensor grad_bias)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor,at::Tensor> slow_conv_transpose3d_backward(const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & weight, at::IntArrayRef kernel_size, at::IntArrayRef stride, at::IntArrayRef padding, at::IntArrayRef output_padding, at::IntArrayRef dilation, const at::Tensor & finput, const at::Tensor & fgrad_input, ::std::array<bool,3> output_mask) {
    return at::_ops::slow_conv_transpose3d_backward_output_mask::call(grad_output, self, weight, kernel_size, stride, padding, output_padding, dilation, finput, fgrad_input, output_mask);
}

// aten::thnn_conv2d.out(Tensor self, Tensor weight, int[2] kernel_size, Tensor? bias=None, int[2] stride=1, int[2] padding=0, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & thnn_conv2d_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & weight, at::IntArrayRef kernel_size, const c10::optional<at::Tensor> & bias={}, at::IntArrayRef stride=1, at::IntArrayRef padding=0) {
    return at::_ops::thnn_conv2d_out::call(self, weight, kernel_size, bias, stride, padding, out);
}

// aten::thnn_conv2d.out(Tensor self, Tensor weight, int[2] kernel_size, Tensor? bias=None, int[2] stride=1, int[2] padding=0, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & thnn_conv2d_outf(const at::Tensor & self, const at::Tensor & weight, at::IntArrayRef kernel_size, const c10::optional<at::Tensor> & bias, at::IntArrayRef stride, at::IntArrayRef padding, at::Tensor & out) {
    return at::_ops::thnn_conv2d_out::call(self, weight, kernel_size, bias, stride, padding, out);
}

// aten::thnn_conv2d(Tensor self, Tensor weight, int[2] kernel_size, Tensor? bias=None, int[2] stride=1, int[2] padding=0) -> Tensor
TORCH_API inline at::Tensor thnn_conv2d(const at::Tensor & self, const at::Tensor & weight, at::IntArrayRef kernel_size, const c10::optional<at::Tensor> & bias={}, at::IntArrayRef stride=1, at::IntArrayRef padding=0) {
    return at::_ops::thnn_conv2d::call(self, weight, kernel_size, bias, stride, padding);
}

// aten::_slow_conv2d_forward.output(Tensor self, Tensor weight, int[2] kernel_size, Tensor? bias, int[2] stride, int[2] padding, *, Tensor(a!) output, Tensor(b!) finput) -> (Tensor(a!), Tensor(b!))
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> _slow_conv2d_forward_out(at::Tensor & output, at::Tensor & finput, const at::Tensor & self, const at::Tensor & weight, at::IntArrayRef kernel_size, const c10::optional<at::Tensor> & bias, at::IntArrayRef stride, at::IntArrayRef padding) {
    return at::_ops::_slow_conv2d_forward_output::call(self, weight, kernel_size, bias, stride, padding, output, finput);
}

// aten::_slow_conv2d_forward.output(Tensor self, Tensor weight, int[2] kernel_size, Tensor? bias, int[2] stride, int[2] padding, *, Tensor(a!) output, Tensor(b!) finput) -> (Tensor(a!), Tensor(b!))
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> _slow_conv2d_forward_outf(const at::Tensor & self, const at::Tensor & weight, at::IntArrayRef kernel_size, const c10::optional<at::Tensor> & bias, at::IntArrayRef stride, at::IntArrayRef padding, at::Tensor & output, at::Tensor & finput) {
    return at::_ops::_slow_conv2d_forward_output::call(self, weight, kernel_size, bias, stride, padding, output, finput);
}

// aten::_slow_conv2d_forward(Tensor self, Tensor weight, int[2] kernel_size, Tensor? bias, int[2] stride, int[2] padding) -> (Tensor output, Tensor finput)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> _slow_conv2d_forward(const at::Tensor & self, const at::Tensor & weight, at::IntArrayRef kernel_size, const c10::optional<at::Tensor> & bias, at::IntArrayRef stride, at::IntArrayRef padding) {
    return at::_ops::_slow_conv2d_forward::call(self, weight, kernel_size, bias, stride, padding);
}

// aten::_slow_conv2d_backward.grad_input(Tensor grad_output, Tensor self, Tensor weight, int[2] kernel_size, int[2] stride, int[2] padding, Tensor finput, *, Tensor(a!) grad_input, Tensor(b!) grad_weight, Tensor(c!) grad_bias) -> (Tensor(a!), Tensor(b!), Tensor(c!))
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &,at::Tensor &> _slow_conv2d_backward_out(at::Tensor & grad_input, at::Tensor & grad_weight, at::Tensor & grad_bias, const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & weight, at::IntArrayRef kernel_size, at::IntArrayRef stride, at::IntArrayRef padding, const at::Tensor & finput) {
    return at::_ops::_slow_conv2d_backward_grad_input::call(grad_output, self, weight, kernel_size, stride, padding, finput, grad_input, grad_weight, grad_bias);
}

// aten::_slow_conv2d_backward.grad_input(Tensor grad_output, Tensor self, Tensor weight, int[2] kernel_size, int[2] stride, int[2] padding, Tensor finput, *, Tensor(a!) grad_input, Tensor(b!) grad_weight, Tensor(c!) grad_bias) -> (Tensor(a!), Tensor(b!), Tensor(c!))
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &,at::Tensor &> _slow_conv2d_backward_outf(const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & weight, at::IntArrayRef kernel_size, at::IntArrayRef stride, at::IntArrayRef padding, const at::Tensor & finput, at::Tensor & grad_input, at::Tensor & grad_weight, at::Tensor & grad_bias) {
    return at::_ops::_slow_conv2d_backward_grad_input::call(grad_output, self, weight, kernel_size, stride, padding, finput, grad_input, grad_weight, grad_bias);
}

// aten::_slow_conv2d_backward.output_mask(Tensor grad_output, Tensor self, Tensor weight, int[2] kernel_size, int[2] stride, int[2] padding, Tensor finput, bool[3] output_mask) -> (Tensor grad_input, Tensor grad_weight, Tensor grad_bias)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor,at::Tensor> _slow_conv2d_backward(const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & weight, at::IntArrayRef kernel_size, at::IntArrayRef stride, at::IntArrayRef padding, const at::Tensor & finput, ::std::array<bool,3> output_mask) {
    return at::_ops::_slow_conv2d_backward_output_mask::call(grad_output, self, weight, kernel_size, stride, padding, finput, output_mask);
}

// aten::_conv_depthwise2d.out(Tensor self, Tensor weight, int[2] kernel_size, Tensor? bias, int[2] stride, int[2] padding, int[2] dilation, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline const at::Tensor & _conv_depthwise2d_out(const at::Tensor & out, const at::Tensor & self, const at::Tensor & weight, at::IntArrayRef kernel_size, const c10::optional<at::Tensor> & bias, at::IntArrayRef stride, at::IntArrayRef padding, at::IntArrayRef dilation) {
    return at::_ops::_conv_depthwise2d_out::call(self, weight, kernel_size, bias, stride, padding, dilation, out);
}

// aten::_conv_depthwise2d.out(Tensor self, Tensor weight, int[2] kernel_size, Tensor? bias, int[2] stride, int[2] padding, int[2] dilation, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline const at::Tensor & _conv_depthwise2d_outf(const at::Tensor & self, const at::Tensor & weight, at::IntArrayRef kernel_size, const c10::optional<at::Tensor> & bias, at::IntArrayRef stride, at::IntArrayRef padding, at::IntArrayRef dilation, const at::Tensor & out) {
    return at::_ops::_conv_depthwise2d_out::call(self, weight, kernel_size, bias, stride, padding, dilation, out);
}

// aten::_conv_depthwise2d(Tensor self, Tensor weight, int[2] kernel_size, Tensor? bias, int[2] stride, int[2] padding, int[2] dilation) -> Tensor
TORCH_API inline at::Tensor _conv_depthwise2d(const at::Tensor & self, const at::Tensor & weight, at::IntArrayRef kernel_size, const c10::optional<at::Tensor> & bias, at::IntArrayRef stride, at::IntArrayRef padding, at::IntArrayRef dilation) {
    return at::_ops::_conv_depthwise2d::call(self, weight, kernel_size, bias, stride, padding, dilation);
}

// aten::_conv_depthwise2d_backward.grad_input(Tensor grad_output, Tensor self, Tensor weight, int[2] kernel_size, int[2] stride, int[2] padding, int[2] dilation, *, Tensor(a!) grad_input, Tensor(b!) grad_weight) -> (Tensor(a!), Tensor(b!))
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> _conv_depthwise2d_backward_out(at::Tensor & grad_input, at::Tensor & grad_weight, const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & weight, at::IntArrayRef kernel_size, at::IntArrayRef stride, at::IntArrayRef padding, at::IntArrayRef dilation) {
    return at::_ops::_conv_depthwise2d_backward_grad_input::call(grad_output, self, weight, kernel_size, stride, padding, dilation, grad_input, grad_weight);
}

// aten::_conv_depthwise2d_backward.grad_input(Tensor grad_output, Tensor self, Tensor weight, int[2] kernel_size, int[2] stride, int[2] padding, int[2] dilation, *, Tensor(a!) grad_input, Tensor(b!) grad_weight) -> (Tensor(a!), Tensor(b!))
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> _conv_depthwise2d_backward_outf(const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & weight, at::IntArrayRef kernel_size, at::IntArrayRef stride, at::IntArrayRef padding, at::IntArrayRef dilation, at::Tensor & grad_input, at::Tensor & grad_weight) {
    return at::_ops::_conv_depthwise2d_backward_grad_input::call(grad_output, self, weight, kernel_size, stride, padding, dilation, grad_input, grad_weight);
}

// aten::_conv_depthwise2d_backward.output_mask(Tensor grad_output, Tensor self, Tensor weight, int[2] kernel_size, int[2] stride, int[2] padding, int[2] dilation, bool[2] output_mask) -> (Tensor grad_input, Tensor grad_weight)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> _conv_depthwise2d_backward(const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & weight, at::IntArrayRef kernel_size, at::IntArrayRef stride, at::IntArrayRef padding, at::IntArrayRef dilation, ::std::array<bool,2> output_mask) {
    return at::_ops::_conv_depthwise2d_backward_output_mask::call(grad_output, self, weight, kernel_size, stride, padding, dilation, output_mask);
}

// aten::conv_depthwise3d(Tensor self, Tensor weight, int[3] kernel_size, Tensor? bias, int[3] stride, int[3] padding, int[3] dilation) -> Tensor
TORCH_API inline at::Tensor conv_depthwise3d(const at::Tensor & self, const at::Tensor & weight, at::IntArrayRef kernel_size, const c10::optional<at::Tensor> & bias, at::IntArrayRef stride, at::IntArrayRef padding, at::IntArrayRef dilation) {
    return at::_ops::conv_depthwise3d::call(self, weight, kernel_size, bias, stride, padding, dilation);
}

// aten::conv_depthwise3d_backward.grad_input(Tensor grad_output, Tensor self, Tensor weight, int[3] kernel_size, int[3] stride, int[3] padding, int[3] dilation, *, Tensor(a!) grad_input, Tensor(b!) grad_weight, Tensor(c!) grad_bias) -> (Tensor(a!), Tensor(b!), Tensor(c!))
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &,at::Tensor &> conv_depthwise3d_backward_out(at::Tensor & grad_input, at::Tensor & grad_weight, at::Tensor & grad_bias, const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & weight, at::IntArrayRef kernel_size, at::IntArrayRef stride, at::IntArrayRef padding, at::IntArrayRef dilation) {
    return at::_ops::conv_depthwise3d_backward_grad_input::call(grad_output, self, weight, kernel_size, stride, padding, dilation, grad_input, grad_weight, grad_bias);
}

// aten::conv_depthwise3d_backward.grad_input(Tensor grad_output, Tensor self, Tensor weight, int[3] kernel_size, int[3] stride, int[3] padding, int[3] dilation, *, Tensor(a!) grad_input, Tensor(b!) grad_weight, Tensor(c!) grad_bias) -> (Tensor(a!), Tensor(b!), Tensor(c!))
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &,at::Tensor &> conv_depthwise3d_backward_outf(const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & weight, at::IntArrayRef kernel_size, at::IntArrayRef stride, at::IntArrayRef padding, at::IntArrayRef dilation, at::Tensor & grad_input, at::Tensor & grad_weight, at::Tensor & grad_bias) {
    return at::_ops::conv_depthwise3d_backward_grad_input::call(grad_output, self, weight, kernel_size, stride, padding, dilation, grad_input, grad_weight, grad_bias);
}

// aten::conv_depthwise3d_backward.output_mask(Tensor grad_output, Tensor self, Tensor weight, int[3] kernel_size, int[3] stride, int[3] padding, int[3] dilation, bool[3] output_mask) -> (Tensor grad_input, Tensor grad_weight, Tensor grad_bias)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor,at::Tensor> conv_depthwise3d_backward(const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & weight, at::IntArrayRef kernel_size, at::IntArrayRef stride, at::IntArrayRef padding, at::IntArrayRef dilation, ::std::array<bool,3> output_mask) {
    return at::_ops::conv_depthwise3d_backward_output_mask::call(grad_output, self, weight, kernel_size, stride, padding, dilation, output_mask);
}

// aten::slow_conv3d.out(Tensor self, Tensor weight, int[3] kernel_size, Tensor? bias=None, int[3] stride=1, int[3] padding=0, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & slow_conv3d_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & weight, at::IntArrayRef kernel_size, const c10::optional<at::Tensor> & bias={}, at::IntArrayRef stride=1, at::IntArrayRef padding=0) {
    return at::_ops::slow_conv3d_out::call(self, weight, kernel_size, bias, stride, padding, out);
}

// aten::slow_conv3d.out(Tensor self, Tensor weight, int[3] kernel_size, Tensor? bias=None, int[3] stride=1, int[3] padding=0, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & slow_conv3d_outf(const at::Tensor & self, const at::Tensor & weight, at::IntArrayRef kernel_size, const c10::optional<at::Tensor> & bias, at::IntArrayRef stride, at::IntArrayRef padding, at::Tensor & out) {
    return at::_ops::slow_conv3d_out::call(self, weight, kernel_size, bias, stride, padding, out);
}

// aten::slow_conv3d(Tensor self, Tensor weight, int[3] kernel_size, Tensor? bias=None, int[3] stride=1, int[3] padding=0) -> Tensor
TORCH_API inline at::Tensor slow_conv3d(const at::Tensor & self, const at::Tensor & weight, at::IntArrayRef kernel_size, const c10::optional<at::Tensor> & bias={}, at::IntArrayRef stride=1, at::IntArrayRef padding=0) {
    return at::_ops::slow_conv3d::call(self, weight, kernel_size, bias, stride, padding);
}

// aten::slow_conv3d_forward.output(Tensor self, Tensor weight, int[3] kernel_size, Tensor? bias, int[3] stride, int[3] padding, *, Tensor(a!) output, Tensor(b!) finput, Tensor(c!) fgrad_input) -> (Tensor(a!), Tensor(b!), Tensor(c!))
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &,at::Tensor &> slow_conv3d_forward_out(at::Tensor & output, at::Tensor & finput, at::Tensor & fgrad_input, const at::Tensor & self, const at::Tensor & weight, at::IntArrayRef kernel_size, const c10::optional<at::Tensor> & bias, at::IntArrayRef stride, at::IntArrayRef padding) {
    return at::_ops::slow_conv3d_forward_output::call(self, weight, kernel_size, bias, stride, padding, output, finput, fgrad_input);
}

// aten::slow_conv3d_forward.output(Tensor self, Tensor weight, int[3] kernel_size, Tensor? bias, int[3] stride, int[3] padding, *, Tensor(a!) output, Tensor(b!) finput, Tensor(c!) fgrad_input) -> (Tensor(a!), Tensor(b!), Tensor(c!))
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &,at::Tensor &> slow_conv3d_forward_outf(const at::Tensor & self, const at::Tensor & weight, at::IntArrayRef kernel_size, const c10::optional<at::Tensor> & bias, at::IntArrayRef stride, at::IntArrayRef padding, at::Tensor & output, at::Tensor & finput, at::Tensor & fgrad_input) {
    return at::_ops::slow_conv3d_forward_output::call(self, weight, kernel_size, bias, stride, padding, output, finput, fgrad_input);
}

// aten::slow_conv3d_forward(Tensor self, Tensor weight, int[3] kernel_size, Tensor? bias, int[3] stride, int[3] padding) -> (Tensor output, Tensor finput, Tensor fgrad_input)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor,at::Tensor> slow_conv3d_forward(const at::Tensor & self, const at::Tensor & weight, at::IntArrayRef kernel_size, const c10::optional<at::Tensor> & bias, at::IntArrayRef stride, at::IntArrayRef padding) {
    return at::_ops::slow_conv3d_forward::call(self, weight, kernel_size, bias, stride, padding);
}

// aten::slow_conv3d_backward.grad_input(Tensor grad_output, Tensor self, Tensor weight, int[3] kernel_size, int[3] stride, int[3] padding, Tensor finput, Tensor fgrad_input, *, Tensor(a!) grad_input, Tensor(b!) grad_weight, Tensor(c!) grad_bias) -> (Tensor(a!), Tensor(b!), Tensor(c!))
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &,at::Tensor &> slow_conv3d_backward_out(at::Tensor & grad_input, at::Tensor & grad_weight, at::Tensor & grad_bias, const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & weight, at::IntArrayRef kernel_size, at::IntArrayRef stride, at::IntArrayRef padding, const at::Tensor & finput, const at::Tensor & fgrad_input) {
    return at::_ops::slow_conv3d_backward_grad_input::call(grad_output, self, weight, kernel_size, stride, padding, finput, fgrad_input, grad_input, grad_weight, grad_bias);
}

// aten::slow_conv3d_backward.grad_input(Tensor grad_output, Tensor self, Tensor weight, int[3] kernel_size, int[3] stride, int[3] padding, Tensor finput, Tensor fgrad_input, *, Tensor(a!) grad_input, Tensor(b!) grad_weight, Tensor(c!) grad_bias) -> (Tensor(a!), Tensor(b!), Tensor(c!))
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &,at::Tensor &> slow_conv3d_backward_outf(const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & weight, at::IntArrayRef kernel_size, at::IntArrayRef stride, at::IntArrayRef padding, const at::Tensor & finput, const at::Tensor & fgrad_input, at::Tensor & grad_input, at::Tensor & grad_weight, at::Tensor & grad_bias) {
    return at::_ops::slow_conv3d_backward_grad_input::call(grad_output, self, weight, kernel_size, stride, padding, finput, fgrad_input, grad_input, grad_weight, grad_bias);
}

// aten::slow_conv3d_backward.output_mask(Tensor grad_output, Tensor self, Tensor weight, int[3] kernel_size, int[3] stride, int[3] padding, Tensor finput, Tensor fgrad_input, bool[3] output_mask) -> (Tensor grad_input, Tensor grad_weight, Tensor grad_bias)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor,at::Tensor> slow_conv3d_backward(const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & weight, at::IntArrayRef kernel_size, at::IntArrayRef stride, at::IntArrayRef padding, const at::Tensor & finput, const at::Tensor & fgrad_input, ::std::array<bool,3> output_mask) {
    return at::_ops::slow_conv3d_backward_output_mask::call(grad_output, self, weight, kernel_size, stride, padding, finput, fgrad_input, output_mask);
}

// aten::slow_conv_dilated2d(Tensor self, Tensor weight, int[2] kernel_size, Tensor? bias=None, int[2] stride=1, int[2] padding=0, int[2] dilation=1) -> Tensor
TORCH_API inline at::Tensor slow_conv_dilated2d(const at::Tensor & self, const at::Tensor & weight, at::IntArrayRef kernel_size, const c10::optional<at::Tensor> & bias={}, at::IntArrayRef stride=1, at::IntArrayRef padding=0, at::IntArrayRef dilation=1) {
    return at::_ops::slow_conv_dilated2d::call(self, weight, kernel_size, bias, stride, padding, dilation);
}

// aten::slow_conv_dilated2d_backward(Tensor grad_output, Tensor self, Tensor weight, int[2] kernel_size, int[2] stride, int[2] padding, int[2] dilation, bool[3] output_mask) -> (Tensor grad_input, Tensor grad_weight, Tensor grad_bias)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor,at::Tensor> slow_conv_dilated2d_backward(const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & weight, at::IntArrayRef kernel_size, at::IntArrayRef stride, at::IntArrayRef padding, at::IntArrayRef dilation, ::std::array<bool,3> output_mask) {
    return at::_ops::slow_conv_dilated2d_backward::call(grad_output, self, weight, kernel_size, stride, padding, dilation, output_mask);
}

// aten::slow_conv_dilated3d(Tensor self, Tensor weight, int[3] kernel_size, Tensor? bias=None, int[3] stride=1, int[3] padding=0, int[3] dilation=1) -> Tensor
TORCH_API inline at::Tensor slow_conv_dilated3d(const at::Tensor & self, const at::Tensor & weight, at::IntArrayRef kernel_size, const c10::optional<at::Tensor> & bias={}, at::IntArrayRef stride=1, at::IntArrayRef padding=0, at::IntArrayRef dilation=1) {
    return at::_ops::slow_conv_dilated3d::call(self, weight, kernel_size, bias, stride, padding, dilation);
}

// aten::slow_conv_dilated3d_backward(Tensor grad_output, Tensor self, Tensor weight, int[3] kernel_size, int[3] stride, int[3] padding, int[3] dilation, bool[3] output_mask) -> (Tensor grad_input, Tensor grad_weight, Tensor grad_bias)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor,at::Tensor> slow_conv_dilated3d_backward(const at::Tensor & grad_output, const at::Tensor & self, const at::Tensor & weight, at::IntArrayRef kernel_size, at::IntArrayRef stride, at::IntArrayRef padding, at::IntArrayRef dilation, ::std::array<bool,3> output_mask) {
    return at::_ops::slow_conv_dilated3d_backward::call(grad_output, self, weight, kernel_size, stride, padding, dilation, output_mask);
}

// aten::col2im.out(Tensor self, int[2] output_size, int[2] kernel_size, int[2] dilation, int[2] padding, int[2] stride, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & col2im_out(at::Tensor & out, const at::Tensor & self, at::IntArrayRef output_size, at::IntArrayRef kernel_size, at::IntArrayRef dilation, at::IntArrayRef padding, at::IntArrayRef stride) {
    return at::_ops::col2im_out::call(self, output_size, kernel_size, dilation, padding, stride, out);
}

// aten::col2im.out(Tensor self, int[2] output_size, int[2] kernel_size, int[2] dilation, int[2] padding, int[2] stride, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & col2im_outf(const at::Tensor & self, at::IntArrayRef output_size, at::IntArrayRef kernel_size, at::IntArrayRef dilation, at::IntArrayRef padding, at::IntArrayRef stride, at::Tensor & out) {
    return at::_ops::col2im_out::call(self, output_size, kernel_size, dilation, padding, stride, out);
}

// aten::col2im(Tensor self, int[2] output_size, int[2] kernel_size, int[2] dilation, int[2] padding, int[2] stride) -> Tensor
TORCH_API inline at::Tensor col2im(const at::Tensor & self, at::IntArrayRef output_size, at::IntArrayRef kernel_size, at::IntArrayRef dilation, at::IntArrayRef padding, at::IntArrayRef stride) {
    return at::_ops::col2im::call(self, output_size, kernel_size, dilation, padding, stride);
}

// aten::col2im_backward.grad_input(Tensor grad_output, int[2] kernel_size, int[2] dilation, int[2] padding, int[2] stride, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & col2im_backward_out(at::Tensor & grad_input, const at::Tensor & grad_output, at::IntArrayRef kernel_size, at::IntArrayRef dilation, at::IntArrayRef padding, at::IntArrayRef stride) {
    return at::_ops::col2im_backward_grad_input::call(grad_output, kernel_size, dilation, padding, stride, grad_input);
}

// aten::col2im_backward.grad_input(Tensor grad_output, int[2] kernel_size, int[2] dilation, int[2] padding, int[2] stride, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & col2im_backward_outf(const at::Tensor & grad_output, at::IntArrayRef kernel_size, at::IntArrayRef dilation, at::IntArrayRef padding, at::IntArrayRef stride, at::Tensor & grad_input) {
    return at::_ops::col2im_backward_grad_input::call(grad_output, kernel_size, dilation, padding, stride, grad_input);
}

// aten::col2im_backward(Tensor grad_output, int[2] kernel_size, int[2] dilation, int[2] padding, int[2] stride) -> Tensor
TORCH_API inline at::Tensor col2im_backward(const at::Tensor & grad_output, at::IntArrayRef kernel_size, at::IntArrayRef dilation, at::IntArrayRef padding, at::IntArrayRef stride) {
    return at::_ops::col2im_backward::call(grad_output, kernel_size, dilation, padding, stride);
}

// aten::column_stack(Tensor[] tensors) -> Tensor
TORCH_API inline at::Tensor column_stack(at::TensorList tensors) {
    return at::_ops::column_stack::call(tensors);
}

// aten::column_stack.out(Tensor[] tensors, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & column_stack_out(at::Tensor & out, at::TensorList tensors) {
    return at::_ops::column_stack_out::call(tensors, out);
}

// aten::column_stack.out(Tensor[] tensors, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & column_stack_outf(at::TensorList tensors, at::Tensor & out) {
    return at::_ops::column_stack_out::call(tensors, out);
}

// aten::im2col.out(Tensor self, int[2] kernel_size, int[2] dilation, int[2] padding, int[2] stride, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & im2col_out(at::Tensor & out, const at::Tensor & self, at::IntArrayRef kernel_size, at::IntArrayRef dilation, at::IntArrayRef padding, at::IntArrayRef stride) {
    return at::_ops::im2col_out::call(self, kernel_size, dilation, padding, stride, out);
}

// aten::im2col.out(Tensor self, int[2] kernel_size, int[2] dilation, int[2] padding, int[2] stride, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & im2col_outf(const at::Tensor & self, at::IntArrayRef kernel_size, at::IntArrayRef dilation, at::IntArrayRef padding, at::IntArrayRef stride, at::Tensor & out) {
    return at::_ops::im2col_out::call(self, kernel_size, dilation, padding, stride, out);
}

// aten::im2col(Tensor self, int[2] kernel_size, int[2] dilation, int[2] padding, int[2] stride) -> Tensor
TORCH_API inline at::Tensor im2col(const at::Tensor & self, at::IntArrayRef kernel_size, at::IntArrayRef dilation, at::IntArrayRef padding, at::IntArrayRef stride) {
    return at::_ops::im2col::call(self, kernel_size, dilation, padding, stride);
}

// aten::im2col_backward.grad_input(Tensor grad_output, int[2] input_size, int[2] kernel_size, int[2] dilation, int[2] padding, int[2] stride, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & im2col_backward_out(at::Tensor & grad_input, const at::Tensor & grad_output, at::IntArrayRef input_size, at::IntArrayRef kernel_size, at::IntArrayRef dilation, at::IntArrayRef padding, at::IntArrayRef stride) {
    return at::_ops::im2col_backward_grad_input::call(grad_output, input_size, kernel_size, dilation, padding, stride, grad_input);
}

// aten::im2col_backward.grad_input(Tensor grad_output, int[2] input_size, int[2] kernel_size, int[2] dilation, int[2] padding, int[2] stride, *, Tensor(a!) grad_input) -> Tensor(a!)
TORCH_API inline at::Tensor & im2col_backward_outf(const at::Tensor & grad_output, at::IntArrayRef input_size, at::IntArrayRef kernel_size, at::IntArrayRef dilation, at::IntArrayRef padding, at::IntArrayRef stride, at::Tensor & grad_input) {
    return at::_ops::im2col_backward_grad_input::call(grad_output, input_size, kernel_size, dilation, padding, stride, grad_input);
}

// aten::im2col_backward(Tensor grad_output, int[2] input_size, int[2] kernel_size, int[2] dilation, int[2] padding, int[2] stride) -> Tensor
TORCH_API inline at::Tensor im2col_backward(const at::Tensor & grad_output, at::IntArrayRef input_size, at::IntArrayRef kernel_size, at::IntArrayRef dilation, at::IntArrayRef padding, at::IntArrayRef stride) {
    return at::_ops::im2col_backward::call(grad_output, input_size, kernel_size, dilation, padding, stride);
}

// aten::isfinite(Tensor self) -> Tensor
TORCH_API inline at::Tensor isfinite(const at::Tensor & self) {
    return at::_ops::isfinite::call(self);
}

// aten::isinf(Tensor self) -> Tensor
TORCH_API inline at::Tensor isinf(const at::Tensor & self) {
    return at::_ops::isinf::call(self);
}

// aten::isposinf(Tensor self) -> Tensor
TORCH_API inline at::Tensor isposinf(const at::Tensor & self) {
    return at::_ops::isposinf::call(self);
}

// aten::isposinf.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & isposinf_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::isposinf_out::call(self, out);
}

// aten::isposinf.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & isposinf_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::isposinf_out::call(self, out);
}

// aten::isneginf(Tensor self) -> Tensor
TORCH_API inline at::Tensor isneginf(const at::Tensor & self) {
    return at::_ops::isneginf::call(self);
}

// aten::isneginf.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & isneginf_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::isneginf_out::call(self, out);
}

// aten::isneginf.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & isneginf_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::isneginf_out::call(self, out);
}

// aten::_add_batch_dim(Tensor self, int batch_dim, int level) -> Tensor
TORCH_API inline at::Tensor _add_batch_dim(const at::Tensor & self, int64_t batch_dim, int64_t level) {
    return at::_ops::_add_batch_dim::call(self, batch_dim, level);
}

// aten::_remove_batch_dim(Tensor self, int level, int batch_size, int out_dim) -> Tensor
TORCH_API inline at::Tensor _remove_batch_dim(const at::Tensor & self, int64_t level, int64_t batch_size, int64_t out_dim) {
    return at::_ops::_remove_batch_dim::call(self, level, batch_size, out_dim);
}

// aten::special_entr(Tensor self) -> Tensor
TORCH_API inline at::Tensor special_entr(const at::Tensor & self) {
    return at::_ops::special_entr::call(self);
}

// aten::special_entr.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_entr_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::special_entr_out::call(self, out);
}

// aten::special_entr.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_entr_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::special_entr_out::call(self, out);
}

// aten::special_ndtri(Tensor self) -> Tensor
TORCH_API inline at::Tensor special_ndtri(const at::Tensor & self) {
    return at::_ops::special_ndtri::call(self);
}

// aten::special_ndtri.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_ndtri_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::special_ndtri_out::call(self, out);
}

// aten::special_ndtri.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_ndtri_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::special_ndtri_out::call(self, out);
}

// aten::special_expm1(Tensor self) -> Tensor
TORCH_API inline at::Tensor special_expm1(const at::Tensor & self) {
    return at::_ops::special_expm1::call(self);
}

// aten::special_expm1.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_expm1_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::special_expm1_out::call(self, out);
}

// aten::special_expm1.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_expm1_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::special_expm1_out::call(self, out);
}

// aten::special_exp2(Tensor self) -> Tensor
TORCH_API inline at::Tensor special_exp2(const at::Tensor & self) {
    return at::_ops::special_exp2::call(self);
}

// aten::special_exp2.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_exp2_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::special_exp2_out::call(self, out);
}

// aten::special_exp2.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_exp2_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::special_exp2_out::call(self, out);
}

// aten::special_psi(Tensor self) -> Tensor
TORCH_API inline at::Tensor special_psi(const at::Tensor & self) {
    return at::_ops::special_psi::call(self);
}

// aten::special_psi.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_psi_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::special_psi_out::call(self, out);
}

// aten::special_psi.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_psi_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::special_psi_out::call(self, out);
}

// aten::special_digamma(Tensor self) -> Tensor
TORCH_API inline at::Tensor special_digamma(const at::Tensor & self) {
    return at::_ops::special_digamma::call(self);
}

// aten::special_digamma.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_digamma_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::special_digamma_out::call(self, out);
}

// aten::special_digamma.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_digamma_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::special_digamma_out::call(self, out);
}

// aten::special_gammaln(Tensor self) -> Tensor
TORCH_API inline at::Tensor special_gammaln(const at::Tensor & self) {
    return at::_ops::special_gammaln::call(self);
}

// aten::special_gammaln.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_gammaln_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::special_gammaln_out::call(self, out);
}

// aten::special_gammaln.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_gammaln_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::special_gammaln_out::call(self, out);
}

// aten::special_erf(Tensor self) -> Tensor
TORCH_API inline at::Tensor special_erf(const at::Tensor & self) {
    return at::_ops::special_erf::call(self);
}

// aten::special_erf.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_erf_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::special_erf_out::call(self, out);
}

// aten::special_erf.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_erf_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::special_erf_out::call(self, out);
}

// aten::special_erfc(Tensor self) -> Tensor
TORCH_API inline at::Tensor special_erfc(const at::Tensor & self) {
    return at::_ops::special_erfc::call(self);
}

// aten::special_erfc.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_erfc_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::special_erfc_out::call(self, out);
}

// aten::special_erfc.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_erfc_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::special_erfc_out::call(self, out);
}

// aten::special_erfcx(Tensor self) -> Tensor
TORCH_API inline at::Tensor special_erfcx(const at::Tensor & self) {
    return at::_ops::special_erfcx::call(self);
}

// aten::special_erfcx.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_erfcx_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::special_erfcx_out::call(self, out);
}

// aten::special_erfcx.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_erfcx_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::special_erfcx_out::call(self, out);
}

// aten::special_erfinv(Tensor self) -> Tensor
TORCH_API inline at::Tensor special_erfinv(const at::Tensor & self) {
    return at::_ops::special_erfinv::call(self);
}

// aten::special_erfinv.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_erfinv_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::special_erfinv_out::call(self, out);
}

// aten::special_erfinv.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_erfinv_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::special_erfinv_out::call(self, out);
}

// aten::special_ndtr(Tensor self) -> Tensor
TORCH_API inline at::Tensor special_ndtr(const at::Tensor & self) {
    return at::_ops::special_ndtr::call(self);
}

// aten::special_ndtr.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_ndtr_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::special_ndtr_out::call(self, out);
}

// aten::special_ndtr.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_ndtr_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::special_ndtr_out::call(self, out);
}

// aten::special_xlog1py(Tensor self, Tensor other) -> Tensor
TORCH_API inline at::Tensor special_xlog1py(const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::special_xlog1py::call(self, other);
}

// aten::special_xlog1py.self_scalar(Scalar self, Tensor other) -> Tensor
TORCH_API inline at::Tensor special_xlog1py(const at::Scalar & self, const at::Tensor & other) {
    return at::_ops::special_xlog1py_self_scalar::call(self, other);
}

// aten::special_xlog1py.other_scalar(Tensor self, Scalar other) -> Tensor
TORCH_API inline at::Tensor special_xlog1py(const at::Tensor & self, const at::Scalar & other) {
    return at::_ops::special_xlog1py_other_scalar::call(self, other);
}

// aten::special_xlog1py.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_xlog1py_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::special_xlog1py_out::call(self, other, out);
}

// aten::special_xlog1py.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_xlog1py_outf(const at::Tensor & self, const at::Tensor & other, at::Tensor & out) {
    return at::_ops::special_xlog1py_out::call(self, other, out);
}

// aten::special_xlog1py.self_scalar_out(Scalar self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_xlog1py_out(at::Tensor & out, const at::Scalar & self, const at::Tensor & other) {
    return at::_ops::special_xlog1py_self_scalar_out::call(self, other, out);
}

// aten::special_xlog1py.self_scalar_out(Scalar self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_xlog1py_outf(const at::Scalar & self, const at::Tensor & other, at::Tensor & out) {
    return at::_ops::special_xlog1py_self_scalar_out::call(self, other, out);
}

// aten::special_xlog1py.other_scalar_out(Tensor self, Scalar other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_xlog1py_out(at::Tensor & out, const at::Tensor & self, const at::Scalar & other) {
    return at::_ops::special_xlog1py_other_scalar_out::call(self, other, out);
}

// aten::special_xlog1py.other_scalar_out(Tensor self, Scalar other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_xlog1py_outf(const at::Tensor & self, const at::Scalar & other, at::Tensor & out) {
    return at::_ops::special_xlog1py_other_scalar_out::call(self, other, out);
}

// aten::special_xlogy(Tensor self, Tensor other) -> Tensor
TORCH_API inline at::Tensor special_xlogy(const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::special_xlogy::call(self, other);
}

// aten::special_xlogy.self_scalar(Scalar self, Tensor other) -> Tensor
TORCH_API inline at::Tensor special_xlogy(const at::Scalar & self, const at::Tensor & other) {
    return at::_ops::special_xlogy_self_scalar::call(self, other);
}

// aten::special_xlogy.other_scalar(Tensor self, Scalar other) -> Tensor
TORCH_API inline at::Tensor special_xlogy(const at::Tensor & self, const at::Scalar & other) {
    return at::_ops::special_xlogy_other_scalar::call(self, other);
}

// aten::special_xlogy.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_xlogy_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::special_xlogy_out::call(self, other, out);
}

// aten::special_xlogy.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_xlogy_outf(const at::Tensor & self, const at::Tensor & other, at::Tensor & out) {
    return at::_ops::special_xlogy_out::call(self, other, out);
}

// aten::special_xlogy.self_scalar_out(Scalar self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_xlogy_out(at::Tensor & out, const at::Scalar & self, const at::Tensor & other) {
    return at::_ops::special_xlogy_self_scalar_out::call(self, other, out);
}

// aten::special_xlogy.self_scalar_out(Scalar self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_xlogy_outf(const at::Scalar & self, const at::Tensor & other, at::Tensor & out) {
    return at::_ops::special_xlogy_self_scalar_out::call(self, other, out);
}

// aten::special_xlogy.other_scalar_out(Tensor self, Scalar other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_xlogy_out(at::Tensor & out, const at::Tensor & self, const at::Scalar & other) {
    return at::_ops::special_xlogy_other_scalar_out::call(self, other, out);
}

// aten::special_xlogy.other_scalar_out(Tensor self, Scalar other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_xlogy_outf(const at::Tensor & self, const at::Scalar & other, at::Tensor & out) {
    return at::_ops::special_xlogy_other_scalar_out::call(self, other, out);
}

// aten::special_zeta(Tensor self, Tensor other) -> Tensor
TORCH_API inline at::Tensor special_zeta(const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::special_zeta::call(self, other);
}

// aten::special_zeta.self_scalar(Scalar self, Tensor other) -> Tensor
TORCH_API inline at::Tensor special_zeta(const at::Scalar & self, const at::Tensor & other) {
    return at::_ops::special_zeta_self_scalar::call(self, other);
}

// aten::special_zeta.other_scalar(Tensor self, Scalar other) -> Tensor
TORCH_API inline at::Tensor special_zeta(const at::Tensor & self, const at::Scalar & other) {
    return at::_ops::special_zeta_other_scalar::call(self, other);
}

// aten::special_zeta.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_zeta_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::special_zeta_out::call(self, other, out);
}

// aten::special_zeta.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_zeta_outf(const at::Tensor & self, const at::Tensor & other, at::Tensor & out) {
    return at::_ops::special_zeta_out::call(self, other, out);
}

// aten::special_zeta.self_scalar_out(Scalar self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_zeta_out(at::Tensor & out, const at::Scalar & self, const at::Tensor & other) {
    return at::_ops::special_zeta_self_scalar_out::call(self, other, out);
}

// aten::special_zeta.self_scalar_out(Scalar self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_zeta_outf(const at::Scalar & self, const at::Tensor & other, at::Tensor & out) {
    return at::_ops::special_zeta_self_scalar_out::call(self, other, out);
}

// aten::special_zeta.other_scalar_out(Tensor self, Scalar other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_zeta_out(at::Tensor & out, const at::Tensor & self, const at::Scalar & other) {
    return at::_ops::special_zeta_other_scalar_out::call(self, other, out);
}

// aten::special_zeta.other_scalar_out(Tensor self, Scalar other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_zeta_outf(const at::Tensor & self, const at::Scalar & other, at::Tensor & out) {
    return at::_ops::special_zeta_other_scalar_out::call(self, other, out);
}

// aten::special_i0(Tensor self) -> Tensor
TORCH_API inline at::Tensor special_i0(const at::Tensor & self) {
    return at::_ops::special_i0::call(self);
}

// aten::special_i0.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_i0_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::special_i0_out::call(self, out);
}

// aten::special_i0.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_i0_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::special_i0_out::call(self, out);
}

// aten::special_i0e(Tensor self) -> Tensor
TORCH_API inline at::Tensor special_i0e(const at::Tensor & self) {
    return at::_ops::special_i0e::call(self);
}

// aten::special_i0e.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_i0e_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::special_i0e_out::call(self, out);
}

// aten::special_i0e.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_i0e_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::special_i0e_out::call(self, out);
}

// aten::special_i1(Tensor self) -> Tensor
TORCH_API inline at::Tensor special_i1(const at::Tensor & self) {
    return at::_ops::special_i1::call(self);
}

// aten::special_i1.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_i1_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::special_i1_out::call(self, out);
}

// aten::special_i1.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_i1_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::special_i1_out::call(self, out);
}

// aten::special_i1e(Tensor self) -> Tensor
TORCH_API inline at::Tensor special_i1e(const at::Tensor & self) {
    return at::_ops::special_i1e::call(self);
}

// aten::special_i1e.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_i1e_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::special_i1e_out::call(self, out);
}

// aten::special_i1e.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_i1e_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::special_i1e_out::call(self, out);
}

// aten::special_logit(Tensor self, float? eps=None) -> Tensor
TORCH_API inline at::Tensor special_logit(const at::Tensor & self, c10::optional<double> eps=c10::nullopt) {
    return at::_ops::special_logit::call(self, eps);
}

// aten::special_logit.out(Tensor self, float? eps=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_logit_out(at::Tensor & out, const at::Tensor & self, c10::optional<double> eps=c10::nullopt) {
    return at::_ops::special_logit_out::call(self, eps, out);
}

// aten::special_logit.out(Tensor self, float? eps=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_logit_outf(const at::Tensor & self, c10::optional<double> eps, at::Tensor & out) {
    return at::_ops::special_logit_out::call(self, eps, out);
}

// aten::special_polygamma(int n, Tensor self) -> Tensor
TORCH_API inline at::Tensor special_polygamma(int64_t n, const at::Tensor & self) {
    return at::_ops::special_polygamma::call(n, self);
}

// aten::special_polygamma.out(int n, Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_polygamma_out(at::Tensor & out, int64_t n, const at::Tensor & self) {
    return at::_ops::special_polygamma_out::call(n, self, out);
}

// aten::special_polygamma.out(int n, Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_polygamma_outf(int64_t n, const at::Tensor & self, at::Tensor & out) {
    return at::_ops::special_polygamma_out::call(n, self, out);
}

// aten::special_logsumexp(Tensor self, int[1] dim, bool keepdim=False) -> Tensor
TORCH_API inline at::Tensor special_logsumexp(const at::Tensor & self, at::IntArrayRef dim, bool keepdim=false) {
    return at::_ops::special_logsumexp::call(self, dim, keepdim);
}

// aten::special_logsumexp.out(Tensor self, int[1] dim, bool keepdim=False, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_logsumexp_out(at::Tensor & out, const at::Tensor & self, at::IntArrayRef dim, bool keepdim=false) {
    return at::_ops::special_logsumexp_out::call(self, dim, keepdim, out);
}

// aten::special_logsumexp.out(Tensor self, int[1] dim, bool keepdim=False, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_logsumexp_outf(const at::Tensor & self, at::IntArrayRef dim, bool keepdim, at::Tensor & out) {
    return at::_ops::special_logsumexp_out::call(self, dim, keepdim, out);
}

// aten::special_expit(Tensor self) -> Tensor
TORCH_API inline at::Tensor special_expit(const at::Tensor & self) {
    return at::_ops::special_expit::call(self);
}

// aten::special_expit.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_expit_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::special_expit_out::call(self, out);
}

// aten::special_expit.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_expit_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::special_expit_out::call(self, out);
}

// aten::special_sinc(Tensor self) -> Tensor
TORCH_API inline at::Tensor special_sinc(const at::Tensor & self) {
    return at::_ops::special_sinc::call(self);
}

// aten::special_sinc.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_sinc_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::special_sinc_out::call(self, out);
}

// aten::special_sinc.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_sinc_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::special_sinc_out::call(self, out);
}

// aten::special_round(Tensor self) -> Tensor
TORCH_API inline at::Tensor special_round(const at::Tensor & self) {
    return at::_ops::special_round::call(self);
}

// aten::special_round.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_round_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::special_round_out::call(self, out);
}

// aten::special_round.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_round_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::special_round_out::call(self, out);
}

// aten::special_log1p(Tensor self) -> Tensor
TORCH_API inline at::Tensor special_log1p(const at::Tensor & self) {
    return at::_ops::special_log1p::call(self);
}

// aten::special_log1p.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_log1p_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::special_log1p_out::call(self, out);
}

// aten::special_log1p.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_log1p_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::special_log1p_out::call(self, out);
}

// aten::special_log_softmax(Tensor self, int dim, *, ScalarType? dtype=None) -> Tensor
TORCH_API inline at::Tensor special_log_softmax(const at::Tensor & self, int64_t dim, c10::optional<at::ScalarType> dtype=c10::nullopt) {
    return at::_ops::special_log_softmax::call(self, dim, dtype);
}

// aten::special_gammainc.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_gammainc_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::special_gammainc_out::call(self, other, out);
}

// aten::special_gammainc.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_gammainc_outf(const at::Tensor & self, const at::Tensor & other, at::Tensor & out) {
    return at::_ops::special_gammainc_out::call(self, other, out);
}

// aten::special_gammainc(Tensor self, Tensor other) -> Tensor
TORCH_API inline at::Tensor special_gammainc(const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::special_gammainc::call(self, other);
}

// aten::special_gammaincc.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_gammaincc_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::special_gammaincc_out::call(self, other, out);
}

// aten::special_gammaincc.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_gammaincc_outf(const at::Tensor & self, const at::Tensor & other, at::Tensor & out) {
    return at::_ops::special_gammaincc_out::call(self, other, out);
}

// aten::special_gammaincc(Tensor self, Tensor other) -> Tensor
TORCH_API inline at::Tensor special_gammaincc(const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::special_gammaincc::call(self, other);
}

// aten::special_multigammaln(Tensor self, int p) -> Tensor
TORCH_API inline at::Tensor special_multigammaln(const at::Tensor & self, int64_t p) {
    return at::_ops::special_multigammaln::call(self, p);
}

// aten::special_multigammaln.out(Tensor self, int p, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_multigammaln_out(at::Tensor & out, const at::Tensor & self, int64_t p) {
    return at::_ops::special_multigammaln_out::call(self, p, out);
}

// aten::special_multigammaln.out(Tensor self, int p, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & special_multigammaln_outf(const at::Tensor & self, int64_t p, at::Tensor & out) {
    return at::_ops::special_multigammaln_out::call(self, p, out);
}

// aten::fft_fft(Tensor self, int? n=None, int dim=-1, str? norm=None) -> Tensor
TORCH_API inline at::Tensor fft_fft(const at::Tensor & self, c10::optional<int64_t> n=c10::nullopt, int64_t dim=-1, c10::optional<c10::string_view> norm=c10::nullopt) {
    return at::_ops::fft_fft::call(self, n, dim, norm);
}

// aten::fft_fft.out(Tensor self, int? n=None, int dim=-1, str? norm=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & fft_fft_out(at::Tensor & out, const at::Tensor & self, c10::optional<int64_t> n=c10::nullopt, int64_t dim=-1, c10::optional<c10::string_view> norm=c10::nullopt) {
    return at::_ops::fft_fft_out::call(self, n, dim, norm, out);
}

// aten::fft_fft.out(Tensor self, int? n=None, int dim=-1, str? norm=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & fft_fft_outf(const at::Tensor & self, c10::optional<int64_t> n, int64_t dim, c10::optional<c10::string_view> norm, at::Tensor & out) {
    return at::_ops::fft_fft_out::call(self, n, dim, norm, out);
}

// aten::fft_ifft(Tensor self, int? n=None, int dim=-1, str? norm=None) -> Tensor
TORCH_API inline at::Tensor fft_ifft(const at::Tensor & self, c10::optional<int64_t> n=c10::nullopt, int64_t dim=-1, c10::optional<c10::string_view> norm=c10::nullopt) {
    return at::_ops::fft_ifft::call(self, n, dim, norm);
}

// aten::fft_ifft.out(Tensor self, int? n=None, int dim=-1, str? norm=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & fft_ifft_out(at::Tensor & out, const at::Tensor & self, c10::optional<int64_t> n=c10::nullopt, int64_t dim=-1, c10::optional<c10::string_view> norm=c10::nullopt) {
    return at::_ops::fft_ifft_out::call(self, n, dim, norm, out);
}

// aten::fft_ifft.out(Tensor self, int? n=None, int dim=-1, str? norm=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & fft_ifft_outf(const at::Tensor & self, c10::optional<int64_t> n, int64_t dim, c10::optional<c10::string_view> norm, at::Tensor & out) {
    return at::_ops::fft_ifft_out::call(self, n, dim, norm, out);
}

// aten::fft_rfft(Tensor self, int? n=None, int dim=-1, str? norm=None) -> Tensor
TORCH_API inline at::Tensor fft_rfft(const at::Tensor & self, c10::optional<int64_t> n=c10::nullopt, int64_t dim=-1, c10::optional<c10::string_view> norm=c10::nullopt) {
    return at::_ops::fft_rfft::call(self, n, dim, norm);
}

// aten::fft_rfft.out(Tensor self, int? n=None, int dim=-1, str? norm=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & fft_rfft_out(at::Tensor & out, const at::Tensor & self, c10::optional<int64_t> n=c10::nullopt, int64_t dim=-1, c10::optional<c10::string_view> norm=c10::nullopt) {
    return at::_ops::fft_rfft_out::call(self, n, dim, norm, out);
}

// aten::fft_rfft.out(Tensor self, int? n=None, int dim=-1, str? norm=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & fft_rfft_outf(const at::Tensor & self, c10::optional<int64_t> n, int64_t dim, c10::optional<c10::string_view> norm, at::Tensor & out) {
    return at::_ops::fft_rfft_out::call(self, n, dim, norm, out);
}

// aten::fft_irfft(Tensor self, int? n=None, int dim=-1, str? norm=None) -> Tensor
TORCH_API inline at::Tensor fft_irfft(const at::Tensor & self, c10::optional<int64_t> n=c10::nullopt, int64_t dim=-1, c10::optional<c10::string_view> norm=c10::nullopt) {
    return at::_ops::fft_irfft::call(self, n, dim, norm);
}

// aten::fft_irfft.out(Tensor self, int? n=None, int dim=-1, str? norm=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & fft_irfft_out(at::Tensor & out, const at::Tensor & self, c10::optional<int64_t> n=c10::nullopt, int64_t dim=-1, c10::optional<c10::string_view> norm=c10::nullopt) {
    return at::_ops::fft_irfft_out::call(self, n, dim, norm, out);
}

// aten::fft_irfft.out(Tensor self, int? n=None, int dim=-1, str? norm=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & fft_irfft_outf(const at::Tensor & self, c10::optional<int64_t> n, int64_t dim, c10::optional<c10::string_view> norm, at::Tensor & out) {
    return at::_ops::fft_irfft_out::call(self, n, dim, norm, out);
}

// aten::fft_hfft(Tensor self, int? n=None, int dim=-1, str? norm=None) -> Tensor
TORCH_API inline at::Tensor fft_hfft(const at::Tensor & self, c10::optional<int64_t> n=c10::nullopt, int64_t dim=-1, c10::optional<c10::string_view> norm=c10::nullopt) {
    return at::_ops::fft_hfft::call(self, n, dim, norm);
}

// aten::fft_hfft.out(Tensor self, int? n=None, int dim=-1, str? norm=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & fft_hfft_out(at::Tensor & out, const at::Tensor & self, c10::optional<int64_t> n=c10::nullopt, int64_t dim=-1, c10::optional<c10::string_view> norm=c10::nullopt) {
    return at::_ops::fft_hfft_out::call(self, n, dim, norm, out);
}

// aten::fft_hfft.out(Tensor self, int? n=None, int dim=-1, str? norm=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & fft_hfft_outf(const at::Tensor & self, c10::optional<int64_t> n, int64_t dim, c10::optional<c10::string_view> norm, at::Tensor & out) {
    return at::_ops::fft_hfft_out::call(self, n, dim, norm, out);
}

// aten::fft_ihfft(Tensor self, int? n=None, int dim=-1, str? norm=None) -> Tensor
TORCH_API inline at::Tensor fft_ihfft(const at::Tensor & self, c10::optional<int64_t> n=c10::nullopt, int64_t dim=-1, c10::optional<c10::string_view> norm=c10::nullopt) {
    return at::_ops::fft_ihfft::call(self, n, dim, norm);
}

// aten::fft_ihfft.out(Tensor self, int? n=None, int dim=-1, str? norm=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & fft_ihfft_out(at::Tensor & out, const at::Tensor & self, c10::optional<int64_t> n=c10::nullopt, int64_t dim=-1, c10::optional<c10::string_view> norm=c10::nullopt) {
    return at::_ops::fft_ihfft_out::call(self, n, dim, norm, out);
}

// aten::fft_ihfft.out(Tensor self, int? n=None, int dim=-1, str? norm=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & fft_ihfft_outf(const at::Tensor & self, c10::optional<int64_t> n, int64_t dim, c10::optional<c10::string_view> norm, at::Tensor & out) {
    return at::_ops::fft_ihfft_out::call(self, n, dim, norm, out);
}

// aten::fft_fft2(Tensor self, int[1]? s=None, int[1] dim=[-2,-1], str? norm=None) -> Tensor
TORCH_API inline at::Tensor fft_fft2(const at::Tensor & self, c10::optional<at::IntArrayRef> s=c10::nullopt, at::IntArrayRef dim={-2,-1}, c10::optional<c10::string_view> norm=c10::nullopt) {
    return at::_ops::fft_fft2::call(self, s, dim, norm);
}

// aten::fft_fft2.out(Tensor self, int[1]? s=None, int[1] dim=[-2,-1], str? norm=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & fft_fft2_out(at::Tensor & out, const at::Tensor & self, c10::optional<at::IntArrayRef> s=c10::nullopt, at::IntArrayRef dim={-2,-1}, c10::optional<c10::string_view> norm=c10::nullopt) {
    return at::_ops::fft_fft2_out::call(self, s, dim, norm, out);
}

// aten::fft_fft2.out(Tensor self, int[1]? s=None, int[1] dim=[-2,-1], str? norm=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & fft_fft2_outf(const at::Tensor & self, c10::optional<at::IntArrayRef> s, at::IntArrayRef dim, c10::optional<c10::string_view> norm, at::Tensor & out) {
    return at::_ops::fft_fft2_out::call(self, s, dim, norm, out);
}

// aten::fft_ifft2(Tensor self, int[1]? s=None, int[1] dim=[-2,-1], str? norm=None) -> Tensor
TORCH_API inline at::Tensor fft_ifft2(const at::Tensor & self, c10::optional<at::IntArrayRef> s=c10::nullopt, at::IntArrayRef dim={-2,-1}, c10::optional<c10::string_view> norm=c10::nullopt) {
    return at::_ops::fft_ifft2::call(self, s, dim, norm);
}

// aten::fft_ifft2.out(Tensor self, int[1]? s=None, int[1] dim=[-2,-1], str? norm=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & fft_ifft2_out(at::Tensor & out, const at::Tensor & self, c10::optional<at::IntArrayRef> s=c10::nullopt, at::IntArrayRef dim={-2,-1}, c10::optional<c10::string_view> norm=c10::nullopt) {
    return at::_ops::fft_ifft2_out::call(self, s, dim, norm, out);
}

// aten::fft_ifft2.out(Tensor self, int[1]? s=None, int[1] dim=[-2,-1], str? norm=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & fft_ifft2_outf(const at::Tensor & self, c10::optional<at::IntArrayRef> s, at::IntArrayRef dim, c10::optional<c10::string_view> norm, at::Tensor & out) {
    return at::_ops::fft_ifft2_out::call(self, s, dim, norm, out);
}

// aten::fft_rfft2(Tensor self, int[1]? s=None, int[1] dim=[-2,-1], str? norm=None) -> Tensor
TORCH_API inline at::Tensor fft_rfft2(const at::Tensor & self, c10::optional<at::IntArrayRef> s=c10::nullopt, at::IntArrayRef dim={-2,-1}, c10::optional<c10::string_view> norm=c10::nullopt) {
    return at::_ops::fft_rfft2::call(self, s, dim, norm);
}

// aten::fft_rfft2.out(Tensor self, int[1]? s=None, int[1] dim=[-2,-1], str? norm=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & fft_rfft2_out(at::Tensor & out, const at::Tensor & self, c10::optional<at::IntArrayRef> s=c10::nullopt, at::IntArrayRef dim={-2,-1}, c10::optional<c10::string_view> norm=c10::nullopt) {
    return at::_ops::fft_rfft2_out::call(self, s, dim, norm, out);
}

// aten::fft_rfft2.out(Tensor self, int[1]? s=None, int[1] dim=[-2,-1], str? norm=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & fft_rfft2_outf(const at::Tensor & self, c10::optional<at::IntArrayRef> s, at::IntArrayRef dim, c10::optional<c10::string_view> norm, at::Tensor & out) {
    return at::_ops::fft_rfft2_out::call(self, s, dim, norm, out);
}

// aten::fft_irfft2(Tensor self, int[1]? s=None, int[1] dim=[-2,-1], str? norm=None) -> Tensor
TORCH_API inline at::Tensor fft_irfft2(const at::Tensor & self, c10::optional<at::IntArrayRef> s=c10::nullopt, at::IntArrayRef dim={-2,-1}, c10::optional<c10::string_view> norm=c10::nullopt) {
    return at::_ops::fft_irfft2::call(self, s, dim, norm);
}

// aten::fft_irfft2.out(Tensor self, int[1]? s=None, int[1] dim=[-2,-1], str? norm=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & fft_irfft2_out(at::Tensor & out, const at::Tensor & self, c10::optional<at::IntArrayRef> s=c10::nullopt, at::IntArrayRef dim={-2,-1}, c10::optional<c10::string_view> norm=c10::nullopt) {
    return at::_ops::fft_irfft2_out::call(self, s, dim, norm, out);
}

// aten::fft_irfft2.out(Tensor self, int[1]? s=None, int[1] dim=[-2,-1], str? norm=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & fft_irfft2_outf(const at::Tensor & self, c10::optional<at::IntArrayRef> s, at::IntArrayRef dim, c10::optional<c10::string_view> norm, at::Tensor & out) {
    return at::_ops::fft_irfft2_out::call(self, s, dim, norm, out);
}

// aten::fft_fftn(Tensor self, int[1]? s=None, int[1]? dim=None, str? norm=None) -> Tensor
TORCH_API inline at::Tensor fft_fftn(const at::Tensor & self, c10::optional<at::IntArrayRef> s=c10::nullopt, c10::optional<at::IntArrayRef> dim=c10::nullopt, c10::optional<c10::string_view> norm=c10::nullopt) {
    return at::_ops::fft_fftn::call(self, s, dim, norm);
}

// aten::fft_fftn.out(Tensor self, int[1]? s=None, int[1]? dim=None, str? norm=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & fft_fftn_out(at::Tensor & out, const at::Tensor & self, c10::optional<at::IntArrayRef> s=c10::nullopt, c10::optional<at::IntArrayRef> dim=c10::nullopt, c10::optional<c10::string_view> norm=c10::nullopt) {
    return at::_ops::fft_fftn_out::call(self, s, dim, norm, out);
}

// aten::fft_fftn.out(Tensor self, int[1]? s=None, int[1]? dim=None, str? norm=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & fft_fftn_outf(const at::Tensor & self, c10::optional<at::IntArrayRef> s, c10::optional<at::IntArrayRef> dim, c10::optional<c10::string_view> norm, at::Tensor & out) {
    return at::_ops::fft_fftn_out::call(self, s, dim, norm, out);
}

// aten::fft_ifftn(Tensor self, int[1]? s=None, int[1]? dim=None, str? norm=None) -> Tensor
TORCH_API inline at::Tensor fft_ifftn(const at::Tensor & self, c10::optional<at::IntArrayRef> s=c10::nullopt, c10::optional<at::IntArrayRef> dim=c10::nullopt, c10::optional<c10::string_view> norm=c10::nullopt) {
    return at::_ops::fft_ifftn::call(self, s, dim, norm);
}

// aten::fft_ifftn.out(Tensor self, int[1]? s=None, int[1]? dim=None, str? norm=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & fft_ifftn_out(at::Tensor & out, const at::Tensor & self, c10::optional<at::IntArrayRef> s=c10::nullopt, c10::optional<at::IntArrayRef> dim=c10::nullopt, c10::optional<c10::string_view> norm=c10::nullopt) {
    return at::_ops::fft_ifftn_out::call(self, s, dim, norm, out);
}

// aten::fft_ifftn.out(Tensor self, int[1]? s=None, int[1]? dim=None, str? norm=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & fft_ifftn_outf(const at::Tensor & self, c10::optional<at::IntArrayRef> s, c10::optional<at::IntArrayRef> dim, c10::optional<c10::string_view> norm, at::Tensor & out) {
    return at::_ops::fft_ifftn_out::call(self, s, dim, norm, out);
}

// aten::fft_rfftn(Tensor self, int[1]? s=None, int[1]? dim=None, str? norm=None) -> Tensor
TORCH_API inline at::Tensor fft_rfftn(const at::Tensor & self, c10::optional<at::IntArrayRef> s=c10::nullopt, c10::optional<at::IntArrayRef> dim=c10::nullopt, c10::optional<c10::string_view> norm=c10::nullopt) {
    return at::_ops::fft_rfftn::call(self, s, dim, norm);
}

// aten::fft_rfftn.out(Tensor self, int[1]? s=None, int[1]? dim=None, str? norm=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & fft_rfftn_out(at::Tensor & out, const at::Tensor & self, c10::optional<at::IntArrayRef> s=c10::nullopt, c10::optional<at::IntArrayRef> dim=c10::nullopt, c10::optional<c10::string_view> norm=c10::nullopt) {
    return at::_ops::fft_rfftn_out::call(self, s, dim, norm, out);
}

// aten::fft_rfftn.out(Tensor self, int[1]? s=None, int[1]? dim=None, str? norm=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & fft_rfftn_outf(const at::Tensor & self, c10::optional<at::IntArrayRef> s, c10::optional<at::IntArrayRef> dim, c10::optional<c10::string_view> norm, at::Tensor & out) {
    return at::_ops::fft_rfftn_out::call(self, s, dim, norm, out);
}

// aten::fft_irfftn(Tensor self, int[1]? s=None, int[1]? dim=None, str? norm=None) -> Tensor
TORCH_API inline at::Tensor fft_irfftn(const at::Tensor & self, c10::optional<at::IntArrayRef> s=c10::nullopt, c10::optional<at::IntArrayRef> dim=c10::nullopt, c10::optional<c10::string_view> norm=c10::nullopt) {
    return at::_ops::fft_irfftn::call(self, s, dim, norm);
}

// aten::fft_irfftn.out(Tensor self, int[1]? s=None, int[1]? dim=None, str? norm=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & fft_irfftn_out(at::Tensor & out, const at::Tensor & self, c10::optional<at::IntArrayRef> s=c10::nullopt, c10::optional<at::IntArrayRef> dim=c10::nullopt, c10::optional<c10::string_view> norm=c10::nullopt) {
    return at::_ops::fft_irfftn_out::call(self, s, dim, norm, out);
}

// aten::fft_irfftn.out(Tensor self, int[1]? s=None, int[1]? dim=None, str? norm=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & fft_irfftn_outf(const at::Tensor & self, c10::optional<at::IntArrayRef> s, c10::optional<at::IntArrayRef> dim, c10::optional<c10::string_view> norm, at::Tensor & out) {
    return at::_ops::fft_irfftn_out::call(self, s, dim, norm, out);
}

// aten::fft_fftfreq(int n, float d=1.0, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor fft_fftfreq(int64_t n, double d=1.0, at::TensorOptions options={}) {
    return at::_ops::fft_fftfreq::call(n, d, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt());
}

// aten::fft_fftfreq(int n, float d=1.0, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor fft_fftfreq(int64_t n, double d, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory) {
    return at::_ops::fft_fftfreq::call(n, d, dtype, layout, device, pin_memory);
}

// aten::fft_fftfreq.out(int n, float d=1.0, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & fft_fftfreq_out(at::Tensor & out, int64_t n, double d=1.0) {
    return at::_ops::fft_fftfreq_out::call(n, d, out);
}

// aten::fft_fftfreq.out(int n, float d=1.0, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & fft_fftfreq_outf(int64_t n, double d, at::Tensor & out) {
    return at::_ops::fft_fftfreq_out::call(n, d, out);
}

// aten::fft_rfftfreq(int n, float d=1.0, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor fft_rfftfreq(int64_t n, double d=1.0, at::TensorOptions options={}) {
    return at::_ops::fft_rfftfreq::call(n, d, optTypeMetaToScalarType(options.dtype_opt()), options.layout_opt(), options.device_opt(), options.pinned_memory_opt());
}

// aten::fft_rfftfreq(int n, float d=1.0, *, ScalarType? dtype=None, Layout? layout=None, Device? device=None, bool? pin_memory=None) -> Tensor
TORCH_API inline at::Tensor fft_rfftfreq(int64_t n, double d, c10::optional<at::ScalarType> dtype, c10::optional<at::Layout> layout, c10::optional<at::Device> device, c10::optional<bool> pin_memory) {
    return at::_ops::fft_rfftfreq::call(n, d, dtype, layout, device, pin_memory);
}

// aten::fft_rfftfreq.out(int n, float d=1.0, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & fft_rfftfreq_out(at::Tensor & out, int64_t n, double d=1.0) {
    return at::_ops::fft_rfftfreq_out::call(n, d, out);
}

// aten::fft_rfftfreq.out(int n, float d=1.0, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & fft_rfftfreq_outf(int64_t n, double d, at::Tensor & out) {
    return at::_ops::fft_rfftfreq_out::call(n, d, out);
}

// aten::fft_fftshift(Tensor self, int[1]? dim=None) -> Tensor
TORCH_API inline at::Tensor fft_fftshift(const at::Tensor & self, c10::optional<at::IntArrayRef> dim=c10::nullopt) {
    return at::_ops::fft_fftshift::call(self, dim);
}

// aten::fft_ifftshift(Tensor self, int[1]? dim=None) -> Tensor
TORCH_API inline at::Tensor fft_ifftshift(const at::Tensor & self, c10::optional<at::IntArrayRef> dim=c10::nullopt) {
    return at::_ops::fft_ifftshift::call(self, dim);
}

// aten::linalg_cholesky_ex(Tensor self, *, bool upper=False, bool check_errors=False) -> (Tensor L, Tensor info)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> linalg_cholesky_ex(const at::Tensor & self, bool upper=false, bool check_errors=false) {
    return at::_ops::linalg_cholesky_ex::call(self, upper, check_errors);
}

// aten::linalg_cholesky_ex.L(Tensor self, *, bool upper=False, bool check_errors=False, Tensor(a!) L, Tensor(b!) info) -> (Tensor(a!) L, Tensor(b!) info)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> linalg_cholesky_ex_out(at::Tensor & L, at::Tensor & info, const at::Tensor & self, bool upper=false, bool check_errors=false) {
    return at::_ops::linalg_cholesky_ex_L::call(self, upper, check_errors, L, info);
}

// aten::linalg_cholesky_ex.L(Tensor self, *, bool upper=False, bool check_errors=False, Tensor(a!) L, Tensor(b!) info) -> (Tensor(a!) L, Tensor(b!) info)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> linalg_cholesky_ex_outf(const at::Tensor & self, bool upper, bool check_errors, at::Tensor & L, at::Tensor & info) {
    return at::_ops::linalg_cholesky_ex_L::call(self, upper, check_errors, L, info);
}

// aten::linalg_cholesky(Tensor self, *, bool upper=False) -> Tensor
TORCH_API inline at::Tensor linalg_cholesky(const at::Tensor & self, bool upper=false) {
    return at::_ops::linalg_cholesky::call(self, upper);
}

// aten::linalg_cholesky.out(Tensor self, *, bool upper=False, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & linalg_cholesky_out(at::Tensor & out, const at::Tensor & self, bool upper=false) {
    return at::_ops::linalg_cholesky_out::call(self, upper, out);
}

// aten::linalg_cholesky.out(Tensor self, *, bool upper=False, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & linalg_cholesky_outf(const at::Tensor & self, bool upper, at::Tensor & out) {
    return at::_ops::linalg_cholesky_out::call(self, upper, out);
}

// aten::linalg_det(Tensor self) -> Tensor
TORCH_API inline at::Tensor linalg_det(const at::Tensor & self) {
    return at::_ops::linalg_det::call(self);
}

// aten::linalg_det.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & linalg_det_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::linalg_det_out::call(self, out);
}

// aten::linalg_det.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & linalg_det_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::linalg_det_out::call(self, out);
}

// aten::det(Tensor self) -> Tensor
TORCH_API inline at::Tensor det(const at::Tensor & self) {
    return at::_ops::det::call(self);
}

// aten::_det_lu_based_helper(Tensor self) -> (Tensor det, Tensor lu, Tensor pivs)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor,at::Tensor> _det_lu_based_helper(const at::Tensor & self) {
    return at::_ops::_det_lu_based_helper::call(self);
}

// aten::_det_lu_based_helper_backward_helper(Tensor det_grad, Tensor det, Tensor self, Tensor lu, Tensor pivs) -> Tensor
TORCH_API inline at::Tensor _det_lu_based_helper_backward_helper(const at::Tensor & det_grad, const at::Tensor & det, const at::Tensor & self, const at::Tensor & lu, const at::Tensor & pivs) {
    return at::_ops::_det_lu_based_helper_backward_helper::call(det_grad, det, self, lu, pivs);
}

// aten::linalg_lstsq(Tensor self, Tensor b, float? rcond=None, *, str? driver=None) -> (Tensor solution, Tensor residuals, Tensor rank, Tensor singular_values)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor,at::Tensor,at::Tensor> linalg_lstsq(const at::Tensor & self, const at::Tensor & b, c10::optional<double> rcond=c10::nullopt, c10::optional<c10::string_view> driver=c10::nullopt) {
    return at::_ops::linalg_lstsq::call(self, b, rcond, driver);
}

// aten::linalg_lstsq.out(Tensor self, Tensor b, float? rcond=None, *, str? driver=None, Tensor(a!) solution, Tensor(b!) residuals, Tensor(c!) rank, Tensor(d!) singular_values) -> (Tensor(a!) solution, Tensor(b!) residuals, Tensor(c!) rank, Tensor(d!) singular_values)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &,at::Tensor &,at::Tensor &> linalg_lstsq_out(at::Tensor & solution, at::Tensor & residuals, at::Tensor & rank, at::Tensor & singular_values, const at::Tensor & self, const at::Tensor & b, c10::optional<double> rcond=c10::nullopt, c10::optional<c10::string_view> driver=c10::nullopt) {
    return at::_ops::linalg_lstsq_out::call(self, b, rcond, driver, solution, residuals, rank, singular_values);
}

// aten::linalg_lstsq.out(Tensor self, Tensor b, float? rcond=None, *, str? driver=None, Tensor(a!) solution, Tensor(b!) residuals, Tensor(c!) rank, Tensor(d!) singular_values) -> (Tensor(a!) solution, Tensor(b!) residuals, Tensor(c!) rank, Tensor(d!) singular_values)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &,at::Tensor &,at::Tensor &> linalg_lstsq_outf(const at::Tensor & self, const at::Tensor & b, c10::optional<double> rcond, c10::optional<c10::string_view> driver, at::Tensor & solution, at::Tensor & residuals, at::Tensor & rank, at::Tensor & singular_values) {
    return at::_ops::linalg_lstsq_out::call(self, b, rcond, driver, solution, residuals, rank, singular_values);
}

// aten::linalg_matmul(Tensor self, Tensor other) -> Tensor
TORCH_API inline at::Tensor linalg_matmul(const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::linalg_matmul::call(self, other);
}

// aten::linalg_matmul.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & linalg_matmul_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::linalg_matmul_out::call(self, other, out);
}

// aten::linalg_matmul.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & linalg_matmul_outf(const at::Tensor & self, const at::Tensor & other, at::Tensor & out) {
    return at::_ops::linalg_matmul_out::call(self, other, out);
}

// aten::linalg_slogdet(Tensor self) -> (Tensor sign, Tensor logabsdet)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> linalg_slogdet(const at::Tensor & self) {
    return at::_ops::linalg_slogdet::call(self);
}

// aten::linalg_slogdet.out(Tensor self, *, Tensor(a!) sign, Tensor(b!) logabsdet) -> (Tensor(a!) sign, Tensor(b!) logabsdet)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> linalg_slogdet_out(at::Tensor & sign, at::Tensor & logabsdet, const at::Tensor & self) {
    return at::_ops::linalg_slogdet_out::call(self, sign, logabsdet);
}

// aten::linalg_slogdet.out(Tensor self, *, Tensor(a!) sign, Tensor(b!) logabsdet) -> (Tensor(a!) sign, Tensor(b!) logabsdet)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> linalg_slogdet_outf(const at::Tensor & self, at::Tensor & sign, at::Tensor & logabsdet) {
    return at::_ops::linalg_slogdet_out::call(self, sign, logabsdet);
}

// aten::linalg_eig(Tensor self) -> (Tensor eigenvalues, Tensor eigenvectors)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> linalg_eig(const at::Tensor & self) {
    return at::_ops::linalg_eig::call(self);
}

// aten::linalg_eig.out(Tensor self, *, Tensor(a!) eigenvalues, Tensor(b!) eigenvectors) -> (Tensor(a!) eigenvalues, Tensor(b!) eigenvectors)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> linalg_eig_out(at::Tensor & eigenvalues, at::Tensor & eigenvectors, const at::Tensor & self) {
    return at::_ops::linalg_eig_out::call(self, eigenvalues, eigenvectors);
}

// aten::linalg_eig.out(Tensor self, *, Tensor(a!) eigenvalues, Tensor(b!) eigenvectors) -> (Tensor(a!) eigenvalues, Tensor(b!) eigenvectors)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> linalg_eig_outf(const at::Tensor & self, at::Tensor & eigenvalues, at::Tensor & eigenvectors) {
    return at::_ops::linalg_eig_out::call(self, eigenvalues, eigenvectors);
}

// aten::linalg_eigvals(Tensor self) -> Tensor
TORCH_API inline at::Tensor linalg_eigvals(const at::Tensor & self) {
    return at::_ops::linalg_eigvals::call(self);
}

// aten::linalg_eigvals.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & linalg_eigvals_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::linalg_eigvals_out::call(self, out);
}

// aten::linalg_eigvals.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & linalg_eigvals_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::linalg_eigvals_out::call(self, out);
}

// aten::linalg_eigh(Tensor self, str UPLO="L") -> (Tensor eigenvalues, Tensor eigenvectors)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> linalg_eigh(const at::Tensor & self, c10::string_view UPLO="L") {
    return at::_ops::linalg_eigh::call(self, UPLO);
}

// aten::linalg_eigh.eigvals(Tensor self, str UPLO="L", *, Tensor(a!) eigvals, Tensor(b!) eigvecs) -> (Tensor(a!) eigenvalues, Tensor(b!) eigenvectors)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> linalg_eigh_out(at::Tensor & eigvals, at::Tensor & eigvecs, const at::Tensor & self, c10::string_view UPLO="L") {
    return at::_ops::linalg_eigh_eigvals::call(self, UPLO, eigvals, eigvecs);
}

// aten::linalg_eigh.eigvals(Tensor self, str UPLO="L", *, Tensor(a!) eigvals, Tensor(b!) eigvecs) -> (Tensor(a!) eigenvalues, Tensor(b!) eigenvectors)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> linalg_eigh_outf(const at::Tensor & self, c10::string_view UPLO, at::Tensor & eigvals, at::Tensor & eigvecs) {
    return at::_ops::linalg_eigh_eigvals::call(self, UPLO, eigvals, eigvecs);
}

// aten::linalg_eigvalsh(Tensor self, str UPLO="L") -> Tensor
TORCH_API inline at::Tensor linalg_eigvalsh(const at::Tensor & self, c10::string_view UPLO="L") {
    return at::_ops::linalg_eigvalsh::call(self, UPLO);
}

// aten::linalg_eigvalsh.out(Tensor self, str UPLO='L', *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & linalg_eigvalsh_out(at::Tensor & out, const at::Tensor & self, c10::string_view UPLO="L") {
    return at::_ops::linalg_eigvalsh_out::call(self, UPLO, out);
}

// aten::linalg_eigvalsh.out(Tensor self, str UPLO='L', *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & linalg_eigvalsh_outf(const at::Tensor & self, c10::string_view UPLO, at::Tensor & out) {
    return at::_ops::linalg_eigvalsh_out::call(self, UPLO, out);
}

// aten::linalg_householder_product(Tensor input, Tensor tau) -> Tensor
TORCH_API inline at::Tensor linalg_householder_product(const at::Tensor & input, const at::Tensor & tau) {
    return at::_ops::linalg_householder_product::call(input, tau);
}

// aten::linalg_householder_product.out(Tensor input, Tensor tau, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & linalg_householder_product_out(at::Tensor & out, const at::Tensor & input, const at::Tensor & tau) {
    return at::_ops::linalg_householder_product_out::call(input, tau, out);
}

// aten::linalg_householder_product.out(Tensor input, Tensor tau, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & linalg_householder_product_outf(const at::Tensor & input, const at::Tensor & tau, at::Tensor & out) {
    return at::_ops::linalg_householder_product_out::call(input, tau, out);
}

// aten::_linalg_inv_out_helper_(Tensor(a!) self, Tensor(b!) infos_lu, Tensor(c!) infos_getri) -> Tensor(a!)
TORCH_API inline at::Tensor & _linalg_inv_out_helper_(at::Tensor & self, at::Tensor & infos_lu, at::Tensor & infos_getri) {
    return at::_ops::_linalg_inv_out_helper_::call(self, infos_lu, infos_getri);
}

// aten::linalg_inv_ex(Tensor self, *, bool check_errors=False) -> (Tensor inverse, Tensor info)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> linalg_inv_ex(const at::Tensor & self, bool check_errors=false) {
    return at::_ops::linalg_inv_ex::call(self, check_errors);
}

// aten::linalg_inv_ex.inverse(Tensor self, *, bool check_errors=False, Tensor(a!) inverse, Tensor(b!) info) -> (Tensor(a!) inverse, Tensor(b!) info)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> linalg_inv_ex_out(at::Tensor & inverse, at::Tensor & info, const at::Tensor & self, bool check_errors=false) {
    return at::_ops::linalg_inv_ex_inverse::call(self, check_errors, inverse, info);
}

// aten::linalg_inv_ex.inverse(Tensor self, *, bool check_errors=False, Tensor(a!) inverse, Tensor(b!) info) -> (Tensor(a!) inverse, Tensor(b!) info)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> linalg_inv_ex_outf(const at::Tensor & self, bool check_errors, at::Tensor & inverse, at::Tensor & info) {
    return at::_ops::linalg_inv_ex_inverse::call(self, check_errors, inverse, info);
}

// aten::linalg_inv(Tensor self) -> Tensor
TORCH_API inline at::Tensor linalg_inv(const at::Tensor & self) {
    return at::_ops::linalg_inv::call(self);
}

// aten::linalg_inv.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & linalg_inv_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::linalg_inv_out::call(self, out);
}

// aten::linalg_inv.out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & linalg_inv_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::linalg_inv_out::call(self, out);
}

// aten::inner(Tensor self, Tensor other) -> Tensor
TORCH_API inline at::Tensor inner(const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::inner::call(self, other);
}

// aten::inner.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & inner_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::inner_out::call(self, other, out);
}

// aten::inner.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & inner_outf(const at::Tensor & self, const at::Tensor & other, at::Tensor & out) {
    return at::_ops::inner_out::call(self, other, out);
}

// aten::outer(Tensor self, Tensor vec2) -> Tensor
TORCH_API inline at::Tensor outer(const at::Tensor & self, const at::Tensor & vec2) {
    return at::_ops::outer::call(self, vec2);
}

// aten::outer.out(Tensor self, Tensor vec2, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & outer_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & vec2) {
    return at::_ops::outer_out::call(self, vec2, out);
}

// aten::outer.out(Tensor self, Tensor vec2, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & outer_outf(const at::Tensor & self, const at::Tensor & vec2, at::Tensor & out) {
    return at::_ops::outer_out::call(self, vec2, out);
}

// aten::ger(Tensor self, Tensor vec2) -> Tensor
TORCH_API inline at::Tensor ger(const at::Tensor & self, const at::Tensor & vec2) {
    return at::_ops::ger::call(self, vec2);
}

// aten::ger.out(Tensor self, Tensor vec2, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & ger_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & vec2) {
    return at::_ops::ger_out::call(self, vec2, out);
}

// aten::ger.out(Tensor self, Tensor vec2, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & ger_outf(const at::Tensor & self, const at::Tensor & vec2, at::Tensor & out) {
    return at::_ops::ger_out::call(self, vec2, out);
}

// aten::linalg_norm(Tensor self, Scalar? ord=None, int[1]? dim=None, bool keepdim=False, *, ScalarType? dtype=None) -> Tensor
TORCH_API inline at::Tensor linalg_norm(const at::Tensor & self, const c10::optional<at::Scalar> & ord=c10::nullopt, c10::optional<at::IntArrayRef> dim=c10::nullopt, bool keepdim=false, c10::optional<at::ScalarType> dtype=c10::nullopt) {
    return at::_ops::linalg_norm::call(self, ord, dim, keepdim, dtype);
}

// aten::linalg_norm.ord_str(Tensor self, str ord, int[1]? dim=None, bool keepdim=False, *, ScalarType? dtype=None) -> Tensor
TORCH_API inline at::Tensor linalg_norm(const at::Tensor & self, c10::string_view ord, c10::optional<at::IntArrayRef> dim=c10::nullopt, bool keepdim=false, c10::optional<at::ScalarType> dtype=c10::nullopt) {
    return at::_ops::linalg_norm_ord_str::call(self, ord, dim, keepdim, dtype);
}

// aten::linalg_norm.out(Tensor self, Scalar? ord=None, int[1]? dim=None, bool keepdim=False, *, ScalarType? dtype=None, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & linalg_norm_out(at::Tensor & out, const at::Tensor & self, const c10::optional<at::Scalar> & ord=c10::nullopt, c10::optional<at::IntArrayRef> dim=c10::nullopt, bool keepdim=false, c10::optional<at::ScalarType> dtype=c10::nullopt) {
    return at::_ops::linalg_norm_out::call(self, ord, dim, keepdim, dtype, out);
}

// aten::linalg_norm.out(Tensor self, Scalar? ord=None, int[1]? dim=None, bool keepdim=False, *, ScalarType? dtype=None, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & linalg_norm_outf(const at::Tensor & self, const c10::optional<at::Scalar> & ord, c10::optional<at::IntArrayRef> dim, bool keepdim, c10::optional<at::ScalarType> dtype, at::Tensor & out) {
    return at::_ops::linalg_norm_out::call(self, ord, dim, keepdim, dtype, out);
}

// aten::linalg_norm.ord_str_out(Tensor self, str ord, int[1]? dim=None, bool keepdim=False, *, ScalarType? dtype=None, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & linalg_norm_out(at::Tensor & out, const at::Tensor & self, c10::string_view ord, c10::optional<at::IntArrayRef> dim=c10::nullopt, bool keepdim=false, c10::optional<at::ScalarType> dtype=c10::nullopt) {
    return at::_ops::linalg_norm_ord_str_out::call(self, ord, dim, keepdim, dtype, out);
}

// aten::linalg_norm.ord_str_out(Tensor self, str ord, int[1]? dim=None, bool keepdim=False, *, ScalarType? dtype=None, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & linalg_norm_outf(const at::Tensor & self, c10::string_view ord, c10::optional<at::IntArrayRef> dim, bool keepdim, c10::optional<at::ScalarType> dtype, at::Tensor & out) {
    return at::_ops::linalg_norm_ord_str_out::call(self, ord, dim, keepdim, dtype, out);
}

// aten::linalg_vector_norm(Tensor self, Scalar ord=2, int[1]? dim=None, bool keepdim=False, *, ScalarType? dtype=None) -> Tensor
TORCH_API inline at::Tensor linalg_vector_norm(const at::Tensor & self, const at::Scalar & ord=2, c10::optional<at::IntArrayRef> dim=c10::nullopt, bool keepdim=false, c10::optional<at::ScalarType> dtype=c10::nullopt) {
    return at::_ops::linalg_vector_norm::call(self, ord, dim, keepdim, dtype);
}

// aten::linalg_vector_norm.out(Tensor self, Scalar ord=2, int[1]? dim=None, bool keepdim=False, *, ScalarType? dtype=None, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & linalg_vector_norm_out(at::Tensor & out, const at::Tensor & self, const at::Scalar & ord=2, c10::optional<at::IntArrayRef> dim=c10::nullopt, bool keepdim=false, c10::optional<at::ScalarType> dtype=c10::nullopt) {
    return at::_ops::linalg_vector_norm_out::call(self, ord, dim, keepdim, dtype, out);
}

// aten::linalg_vector_norm.out(Tensor self, Scalar ord=2, int[1]? dim=None, bool keepdim=False, *, ScalarType? dtype=None, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & linalg_vector_norm_outf(const at::Tensor & self, const at::Scalar & ord, c10::optional<at::IntArrayRef> dim, bool keepdim, c10::optional<at::ScalarType> dtype, at::Tensor & out) {
    return at::_ops::linalg_vector_norm_out::call(self, ord, dim, keepdim, dtype, out);
}

// aten::linalg_matrix_norm(Tensor self, Scalar ord, int[] dim=[-2,-1], bool keepdim=False, *, ScalarType? dtype=None) -> Tensor
TORCH_API inline at::Tensor linalg_matrix_norm(const at::Tensor & self, const at::Scalar & ord, at::IntArrayRef dim={-2,-1}, bool keepdim=false, c10::optional<at::ScalarType> dtype=c10::nullopt) {
    return at::_ops::linalg_matrix_norm::call(self, ord, dim, keepdim, dtype);
}

// aten::linalg_matrix_norm.out(Tensor self, Scalar ord, int[] dim=[-2,-1], bool keepdim=False, *, ScalarType? dtype=None, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & linalg_matrix_norm_out(at::Tensor & out, const at::Tensor & self, const at::Scalar & ord, at::IntArrayRef dim={-2,-1}, bool keepdim=false, c10::optional<at::ScalarType> dtype=c10::nullopt) {
    return at::_ops::linalg_matrix_norm_out::call(self, ord, dim, keepdim, dtype, out);
}

// aten::linalg_matrix_norm.out(Tensor self, Scalar ord, int[] dim=[-2,-1], bool keepdim=False, *, ScalarType? dtype=None, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & linalg_matrix_norm_outf(const at::Tensor & self, const at::Scalar & ord, at::IntArrayRef dim, bool keepdim, c10::optional<at::ScalarType> dtype, at::Tensor & out) {
    return at::_ops::linalg_matrix_norm_out::call(self, ord, dim, keepdim, dtype, out);
}

// aten::linalg_matrix_norm.str_ord(Tensor self, str ord='fro', int[] dim=[-2,-1], bool keepdim=False, *, ScalarType? dtype=None) -> Tensor
TORCH_API inline at::Tensor linalg_matrix_norm(const at::Tensor & self, c10::string_view ord="fro", at::IntArrayRef dim={-2,-1}, bool keepdim=false, c10::optional<at::ScalarType> dtype=c10::nullopt) {
    return at::_ops::linalg_matrix_norm_str_ord::call(self, ord, dim, keepdim, dtype);
}

// aten::linalg_matrix_norm.str_ord_out(Tensor self, str ord='fro', int[] dim=[-2,-1], bool keepdim=False, *, ScalarType? dtype=None, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & linalg_matrix_norm_out(at::Tensor & out, const at::Tensor & self, c10::string_view ord="fro", at::IntArrayRef dim={-2,-1}, bool keepdim=false, c10::optional<at::ScalarType> dtype=c10::nullopt) {
    return at::_ops::linalg_matrix_norm_str_ord_out::call(self, ord, dim, keepdim, dtype, out);
}

// aten::linalg_matrix_norm.str_ord_out(Tensor self, str ord='fro', int[] dim=[-2,-1], bool keepdim=False, *, ScalarType? dtype=None, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & linalg_matrix_norm_outf(const at::Tensor & self, c10::string_view ord, at::IntArrayRef dim, bool keepdim, c10::optional<at::ScalarType> dtype, at::Tensor & out) {
    return at::_ops::linalg_matrix_norm_str_ord_out::call(self, ord, dim, keepdim, dtype, out);
}

// aten::linalg_svd.U(Tensor self, bool full_matrices=True, *, Tensor(a!) U, Tensor(b!) S, Tensor(c!) Vh) -> (Tensor(a!) U, Tensor(b!) S, Tensor(c!) Vh)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &,at::Tensor &> linalg_svd_out(at::Tensor & U, at::Tensor & S, at::Tensor & Vh, const at::Tensor & self, bool full_matrices=true) {
    return at::_ops::linalg_svd_U::call(self, full_matrices, U, S, Vh);
}

// aten::linalg_svd.U(Tensor self, bool full_matrices=True, *, Tensor(a!) U, Tensor(b!) S, Tensor(c!) Vh) -> (Tensor(a!) U, Tensor(b!) S, Tensor(c!) Vh)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &,at::Tensor &> linalg_svd_outf(const at::Tensor & self, bool full_matrices, at::Tensor & U, at::Tensor & S, at::Tensor & Vh) {
    return at::_ops::linalg_svd_U::call(self, full_matrices, U, S, Vh);
}

// aten::linalg_svd(Tensor self, bool full_matrices=True) -> (Tensor U, Tensor S, Tensor Vh)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor,at::Tensor> linalg_svd(const at::Tensor & self, bool full_matrices=true) {
    return at::_ops::linalg_svd::call(self, full_matrices);
}

// aten::linalg_svdvals(Tensor input) -> Tensor
TORCH_API inline at::Tensor linalg_svdvals(const at::Tensor & input) {
    return at::_ops::linalg_svdvals::call(input);
}

// aten::linalg_svdvals.out(Tensor input, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & linalg_svdvals_out(at::Tensor & out, const at::Tensor & input) {
    return at::_ops::linalg_svdvals_out::call(input, out);
}

// aten::linalg_svdvals.out(Tensor input, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & linalg_svdvals_outf(const at::Tensor & input, at::Tensor & out) {
    return at::_ops::linalg_svdvals_out::call(input, out);
}

// aten::linalg_cond(Tensor self, Scalar? p=None) -> Tensor
TORCH_API inline at::Tensor linalg_cond(const at::Tensor & self, const c10::optional<at::Scalar> & p=c10::nullopt) {
    return at::_ops::linalg_cond::call(self, p);
}

// aten::linalg_cond.out(Tensor self, Scalar? p=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & linalg_cond_out(at::Tensor & out, const at::Tensor & self, const c10::optional<at::Scalar> & p=c10::nullopt) {
    return at::_ops::linalg_cond_out::call(self, p, out);
}

// aten::linalg_cond.out(Tensor self, Scalar? p=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & linalg_cond_outf(const at::Tensor & self, const c10::optional<at::Scalar> & p, at::Tensor & out) {
    return at::_ops::linalg_cond_out::call(self, p, out);
}

// aten::linalg_cond.p_str(Tensor self, str p) -> Tensor
TORCH_API inline at::Tensor linalg_cond(const at::Tensor & self, c10::string_view p) {
    return at::_ops::linalg_cond_p_str::call(self, p);
}

// aten::linalg_cond.p_str_out(Tensor self, str p, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & linalg_cond_out(at::Tensor & out, const at::Tensor & self, c10::string_view p) {
    return at::_ops::linalg_cond_p_str_out::call(self, p, out);
}

// aten::linalg_cond.p_str_out(Tensor self, str p, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & linalg_cond_outf(const at::Tensor & self, c10::string_view p, at::Tensor & out) {
    return at::_ops::linalg_cond_p_str_out::call(self, p, out);
}

// aten::linalg_pinv(Tensor self, float rcond=1e-15, bool hermitian=False) -> Tensor
TORCH_API inline at::Tensor linalg_pinv(const at::Tensor & self, double rcond=1e-15, bool hermitian=false) {
    return at::_ops::linalg_pinv::call(self, rcond, hermitian);
}

// aten::linalg_pinv.rcond_tensor(Tensor self, Tensor rcond, bool hermitian=False) -> Tensor
TORCH_API inline at::Tensor linalg_pinv(const at::Tensor & self, const at::Tensor & rcond, bool hermitian=false) {
    return at::_ops::linalg_pinv_rcond_tensor::call(self, rcond, hermitian);
}

// aten::linalg_pinv.out(Tensor self, float rcond=1e-15, bool hermitian=False, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & linalg_pinv_out(at::Tensor & out, const at::Tensor & self, double rcond=1e-15, bool hermitian=false) {
    return at::_ops::linalg_pinv_out::call(self, rcond, hermitian, out);
}

// aten::linalg_pinv.out(Tensor self, float rcond=1e-15, bool hermitian=False, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & linalg_pinv_outf(const at::Tensor & self, double rcond, bool hermitian, at::Tensor & out) {
    return at::_ops::linalg_pinv_out::call(self, rcond, hermitian, out);
}

// aten::linalg_pinv.out_rcond_tensor(Tensor self, Tensor rcond, bool hermitian=False, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & linalg_pinv_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & rcond, bool hermitian=false) {
    return at::_ops::linalg_pinv_out_rcond_tensor::call(self, rcond, hermitian, out);
}

// aten::linalg_pinv.out_rcond_tensor(Tensor self, Tensor rcond, bool hermitian=False, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & linalg_pinv_outf(const at::Tensor & self, const at::Tensor & rcond, bool hermitian, at::Tensor & out) {
    return at::_ops::linalg_pinv_out_rcond_tensor::call(self, rcond, hermitian, out);
}

// aten::linalg_solve(Tensor input, Tensor other) -> Tensor
TORCH_API inline at::Tensor linalg_solve(const at::Tensor & input, const at::Tensor & other) {
    return at::_ops::linalg_solve::call(input, other);
}

// aten::linalg_solve.out(Tensor input, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & linalg_solve_out(at::Tensor & out, const at::Tensor & input, const at::Tensor & other) {
    return at::_ops::linalg_solve_out::call(input, other, out);
}

// aten::linalg_solve.out(Tensor input, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & linalg_solve_outf(const at::Tensor & input, const at::Tensor & other, at::Tensor & out) {
    return at::_ops::linalg_solve_out::call(input, other, out);
}

// aten::linalg_tensorinv(Tensor self, int ind=2) -> Tensor
TORCH_API inline at::Tensor linalg_tensorinv(const at::Tensor & self, int64_t ind=2) {
    return at::_ops::linalg_tensorinv::call(self, ind);
}

// aten::linalg_tensorinv.out(Tensor self, int ind=2, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & linalg_tensorinv_out(at::Tensor & out, const at::Tensor & self, int64_t ind=2) {
    return at::_ops::linalg_tensorinv_out::call(self, ind, out);
}

// aten::linalg_tensorinv.out(Tensor self, int ind=2, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & linalg_tensorinv_outf(const at::Tensor & self, int64_t ind, at::Tensor & out) {
    return at::_ops::linalg_tensorinv_out::call(self, ind, out);
}

// aten::linalg_tensorsolve(Tensor self, Tensor other, int[]? dims=None) -> Tensor
TORCH_API inline at::Tensor linalg_tensorsolve(const at::Tensor & self, const at::Tensor & other, c10::optional<at::IntArrayRef> dims=c10::nullopt) {
    return at::_ops::linalg_tensorsolve::call(self, other, dims);
}

// aten::linalg_tensorsolve.out(Tensor self, Tensor other, int[]? dims=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & linalg_tensorsolve_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & other, c10::optional<at::IntArrayRef> dims=c10::nullopt) {
    return at::_ops::linalg_tensorsolve_out::call(self, other, dims, out);
}

// aten::linalg_tensorsolve.out(Tensor self, Tensor other, int[]? dims=None, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & linalg_tensorsolve_outf(const at::Tensor & self, const at::Tensor & other, c10::optional<at::IntArrayRef> dims, at::Tensor & out) {
    return at::_ops::linalg_tensorsolve_out::call(self, other, dims, out);
}

// aten::linalg_qr(Tensor self, str mode='reduced') -> (Tensor Q, Tensor R)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> linalg_qr(const at::Tensor & self, c10::string_view mode="reduced") {
    return at::_ops::linalg_qr::call(self, mode);
}

// aten::linalg_qr.out(Tensor self, str mode='reduced', *, Tensor(a!) Q, Tensor(b!) R) -> (Tensor(a!) Q, Tensor(b!) R)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> linalg_qr_out(at::Tensor & Q, at::Tensor & R, const at::Tensor & self, c10::string_view mode="reduced") {
    return at::_ops::linalg_qr_out::call(self, mode, Q, R);
}

// aten::linalg_qr.out(Tensor self, str mode='reduced', *, Tensor(a!) Q, Tensor(b!) R) -> (Tensor(a!) Q, Tensor(b!) R)
TORCH_API inline ::std::tuple<at::Tensor &,at::Tensor &> linalg_qr_outf(const at::Tensor & self, c10::string_view mode, at::Tensor & Q, at::Tensor & R) {
    return at::_ops::linalg_qr_out::call(self, mode, Q, R);
}

// aten::_linalg_qr_helper(Tensor self, str mode) -> (Tensor, Tensor)
TORCH_API inline ::std::tuple<at::Tensor,at::Tensor> _linalg_qr_helper(const at::Tensor & self, c10::string_view mode) {
    return at::_ops::_linalg_qr_helper::call(self, mode);
}

// aten::linalg_matrix_power(Tensor self, int n) -> Tensor
TORCH_API inline at::Tensor linalg_matrix_power(const at::Tensor & self, int64_t n) {
    return at::_ops::linalg_matrix_power::call(self, n);
}

// aten::linalg_matrix_power.out(Tensor self, int n, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & linalg_matrix_power_out(at::Tensor & out, const at::Tensor & self, int64_t n) {
    return at::_ops::linalg_matrix_power_out::call(self, n, out);
}

// aten::linalg_matrix_power.out(Tensor self, int n, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & linalg_matrix_power_outf(const at::Tensor & self, int64_t n, at::Tensor & out) {
    return at::_ops::linalg_matrix_power_out::call(self, n, out);
}

// aten::linalg_matrix_rank(Tensor self, float? tol=None, bool hermitian=False) -> Tensor
TORCH_API inline at::Tensor linalg_matrix_rank(const at::Tensor & self, c10::optional<double> tol=c10::nullopt, bool hermitian=false) {
    return at::_ops::linalg_matrix_rank::call(self, tol, hermitian);
}

// aten::linalg_matrix_rank.out(Tensor self, float? tol=None, bool hermitian=False, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & linalg_matrix_rank_out(at::Tensor & out, const at::Tensor & self, c10::optional<double> tol=c10::nullopt, bool hermitian=false) {
    return at::_ops::linalg_matrix_rank_out::call(self, tol, hermitian, out);
}

// aten::linalg_matrix_rank.out(Tensor self, float? tol=None, bool hermitian=False, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & linalg_matrix_rank_outf(const at::Tensor & self, c10::optional<double> tol, bool hermitian, at::Tensor & out) {
    return at::_ops::linalg_matrix_rank_out::call(self, tol, hermitian, out);
}

// aten::linalg_matrix_rank.tol_tensor(Tensor input, Tensor tol, bool hermitian=False) -> Tensor
TORCH_API inline at::Tensor linalg_matrix_rank(const at::Tensor & input, const at::Tensor & tol, bool hermitian=false) {
    return at::_ops::linalg_matrix_rank_tol_tensor::call(input, tol, hermitian);
}

// aten::linalg_matrix_rank.out_tol_tensor(Tensor input, Tensor tol, bool hermitian=False, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & linalg_matrix_rank_out(at::Tensor & out, const at::Tensor & input, const at::Tensor & tol, bool hermitian=false) {
    return at::_ops::linalg_matrix_rank_out_tol_tensor::call(input, tol, hermitian, out);
}

// aten::linalg_matrix_rank.out_tol_tensor(Tensor input, Tensor tol, bool hermitian=False, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & linalg_matrix_rank_outf(const at::Tensor & input, const at::Tensor & tol, bool hermitian, at::Tensor & out) {
    return at::_ops::linalg_matrix_rank_out_tol_tensor::call(input, tol, hermitian, out);
}

// aten::linalg_multi_dot(Tensor[] tensors) -> Tensor
TORCH_API inline at::Tensor linalg_multi_dot(at::TensorList tensors) {
    return at::_ops::linalg_multi_dot::call(tensors);
}

// aten::linalg_multi_dot.out(Tensor[] tensors, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & linalg_multi_dot_out(at::Tensor & out, at::TensorList tensors) {
    return at::_ops::linalg_multi_dot_out::call(tensors, out);
}

// aten::linalg_multi_dot.out(Tensor[] tensors, *, Tensor(a!) out) -> Tensor(a!)
TORCH_API inline at::Tensor & linalg_multi_dot_outf(at::TensorList tensors, at::Tensor & out) {
    return at::_ops::linalg_multi_dot_out::call(tensors, out);
}

// aten::_test_serialization_subcmul(Tensor self, Tensor other, Scalar alpha=1) -> Tensor
TORCH_API inline at::Tensor _test_serialization_subcmul(const at::Tensor & self, const at::Tensor & other, const at::Scalar & alpha=1) {
    return at::_ops::_test_serialization_subcmul::call(self, other, alpha);
}

// aten::_test_optional_intlist(Tensor values, int[]? addends) -> Tensor
TORCH_API inline at::Tensor _test_optional_intlist(const at::Tensor & values, c10::optional<at::IntArrayRef> addends) {
    return at::_ops::_test_optional_intlist::call(values, addends);
}

// aten::_test_optional_filled_intlist(Tensor values, int[2]? addends) -> Tensor
TORCH_API inline at::Tensor _test_optional_filled_intlist(const at::Tensor & values, c10::optional<at::IntArrayRef> addends) {
    return at::_ops::_test_optional_filled_intlist::call(values, addends);
}

// aten::_test_optional_floatlist(Tensor values, float[]? addends) -> Tensor
TORCH_API inline at::Tensor _test_optional_floatlist(const at::Tensor & values, c10::optional<at::ArrayRef<double>> addends) {
    return at::_ops::_test_optional_floatlist::call(values, addends);
}

// aten::_test_string_default(Tensor dummy, str a="\"'\\", str b='"\'\\') -> Tensor
TORCH_API inline at::Tensor _test_string_default(const at::Tensor & dummy, c10::string_view a="\"'\\", c10::string_view b="\"'\\") {
    return at::_ops::_test_string_default::call(dummy, a, b);
}

// aten::_test_ambiguous_defaults.a(Tensor dummy, int a=1, int b=1) -> Tensor
TORCH_API inline at::Tensor _test_ambiguous_defaults(const at::Tensor & dummy, int64_t a=1, int64_t b=1) {
    return at::_ops::_test_ambiguous_defaults_a::call(dummy, a, b);
}

// aten::_test_ambiguous_defaults.b(Tensor dummy, int a=2, str b="2") -> Tensor
TORCH_API inline at::Tensor _test_ambiguous_defaults(const at::Tensor & dummy, int64_t a, c10::string_view b) {
    return at::_ops::_test_ambiguous_defaults_b::call(dummy, a, b);
}

// aten::segment_reduce(Tensor data, str reduce, *, Tensor? lengths=None, Tensor? indices=None, int axis=0, bool unsafe=False, Scalar? initial=None) -> Tensor
TORCH_API inline at::Tensor segment_reduce(const at::Tensor & data, c10::string_view reduce, const c10::optional<at::Tensor> & lengths={}, const c10::optional<at::Tensor> & indices={}, int64_t axis=0, bool unsafe=false, const c10::optional<at::Scalar> & initial=c10::nullopt) {
    return at::_ops::segment_reduce::call(data, reduce, lengths, indices, axis, unsafe, initial);
}

// aten::_segment_reduce_backward(Tensor grad, Tensor output, Tensor data, str reduce, *, Tensor? lengths=None, int axis=0) -> Tensor
TORCH_API inline at::Tensor _segment_reduce_backward(const at::Tensor & grad, const at::Tensor & output, const at::Tensor & data, c10::string_view reduce, const c10::optional<at::Tensor> & lengths={}, int64_t axis=0) {
    return at::_ops::_segment_reduce_backward::call(grad, output, data, reduce, lengths, axis);
}

// aten::pad_sequence(Tensor[] sequences, bool batch_first=False, float padding_value=0.0) -> Tensor
TORCH_API inline at::Tensor pad_sequence(at::TensorList sequences, bool batch_first=false, double padding_value=0.0) {
    return at::_ops::pad_sequence::call(sequences, batch_first, padding_value);
}

// aten::flatten_dense_tensors(Tensor[] tensors) -> Tensor
TORCH_API inline at::Tensor flatten_dense_tensors(at::TensorList tensors) {
    return at::_ops::flatten_dense_tensors::call(tensors);
}

// aten::unflatten_dense_tensors(Tensor flat, Tensor[] tensors) -> Tensor[]
TORCH_API inline ::std::vector<at::Tensor> unflatten_dense_tensors(const at::Tensor & flat, at::TensorList tensors) {
    return at::_ops::unflatten_dense_tensors::call(flat, tensors);
}

// Special C++ only overloads for std()-like functions (See gh-40287)
// These are needed because int -> bool conversion takes precedence over int -> IntArrayRef
// So, for example std(0) would select the std(unbiased=False) overload
TORCH_API inline Tensor var(const Tensor& self, int dim) {
  return at::var(self, IntArrayRef{dim});
}
TORCH_API inline std::tuple<Tensor, Tensor> var_mean(const Tensor& self, int dim) {
  return at::var_mean(self, IntArrayRef{dim});
}
TORCH_API inline Tensor std(const Tensor& self, int dim) {
  return at::std(self, IntArrayRef{dim});
}
TORCH_API inline std::tuple<Tensor, Tensor> std_mean(const Tensor& self, int dim) {
  return at::std_mean(self, IntArrayRef{dim});
}

namespace detail {

TORCH_API inline void noopDelete(void*) {}

} // namespace detail

/// Provides a fluent API to construct tensors from external data.
///
/// The fluent API can be used instead of `from_blob` functions in case the
/// required set of parameters does not align with the existing overloads.
///
///     at::Tensor tensor = at::for_blob(data, sizes)
///             .strides(strides)
///             .context(context, [](void *ctx) { delete static_cast<Ctx*>(ctx); })
///             .options(...)
///             .make_tensor();
///
class TORCH_API TensorMaker {
  friend TensorMaker for_blob(void* data, IntArrayRef sizes) noexcept;

 public:
  using ContextDeleter = DeleterFnPtr;

  TensorMaker& strides(optional<IntArrayRef> value) noexcept {
    strides_ = value;

    return *this;
  }

  TensorMaker& deleter(std::function<void(void*)> value) noexcept {
    deleter_ = std::move(value);

    return *this;
  }

  TensorMaker& context(void* value, ContextDeleter deleter = nullptr) noexcept {
    ctx_ = std::unique_ptr<void, ContextDeleter>{
        value, deleter != nullptr ? deleter : detail::noopDelete};

    return *this;
  }

  TensorMaker& target_device(optional<Device> value) noexcept {
    device_ = value;

    return *this;
  }

  TensorMaker& options(TensorOptions value) noexcept {
    opts_ = value;

    return *this;
  }

  Tensor make_tensor();

 private:
  explicit TensorMaker(void* data, IntArrayRef sizes) noexcept
      : data_{data}, sizes_{sizes} {}

  std::size_t computeStorageSize() const noexcept;

  DataPtr makeDataPtrFromDeleter() const;

  DataPtr makeDataPtrFromContext() noexcept;

  IntArrayRef makeTempSizes() const noexcept;

  void* data_;
  IntArrayRef sizes_;
  optional<IntArrayRef> strides_{};
  std::function<void(void*)> deleter_{};
  std::unique_ptr<void, ContextDeleter> ctx_{nullptr, detail::noopDelete};
  optional<Device> device_{};
  TensorOptions opts_{};
};

inline TensorMaker for_blob(void* data, IntArrayRef sizes) noexcept {
  return TensorMaker{data, sizes};
}

inline Tensor from_blob(
    void* data,
    IntArrayRef sizes,
    IntArrayRef strides,
    const std::function<void(void*)>& deleter,
    const TensorOptions& options = {},
    const c10::optional<Device> target_device = c10::nullopt) {
  return for_blob(data, sizes)
      .strides(strides)
      .deleter(deleter)
      .options(options)
      .target_device(target_device)
      .make_tensor();
}

inline Tensor from_blob(
    void* data,
    IntArrayRef sizes,
    const std::function<void(void*)>& deleter,
    const TensorOptions& options = {}) {
  return for_blob(data, sizes)
      .deleter(deleter)
      .options(options)
      .make_tensor();
}

inline Tensor from_blob(
    void* data,
    IntArrayRef sizes,
    IntArrayRef strides,
    const TensorOptions& options = {}) {
  return for_blob(data, sizes)
      .strides(strides)
      .options(options)
      .make_tensor();
}

inline Tensor from_blob(
    void* data,
    IntArrayRef sizes,
    const TensorOptions& options = {}) {
  return for_blob(data, sizes).options(options).make_tensor();
}

inline int64_t numel(const Tensor& tensor) {
  return tensor.numel();
}

inline int64_t size(const Tensor& tensor, int64_t dim) {
  return tensor.size(dim);
}

inline int64_t stride(const Tensor& tensor, int64_t dim) {
  return tensor.stride(dim);
}

inline bool is_complex(const Tensor& tensor) {
  return tensor.is_complex();
}

inline bool is_floating_point(const Tensor& tensor) {
  return tensor.is_floating_point();
}

inline bool is_signed(const Tensor& tensor) {
  return tensor.is_signed();
}

inline bool is_inference(const Tensor& tensor) {
  return tensor.is_inference();
}

inline bool is_conj(const Tensor& tensor) {
  return tensor.is_conj();
}

inline Tensor conj(const Tensor& tensor) {
  return tensor.conj();
}

inline bool is_neg(const Tensor& tensor) {
  return tensor.is_neg();
}

}
