// Generated from "/pytorch/torch/csrc/jit/codegen/cuda/runtime/fp16_support.cu"
// 2022-03-08 16:20:33

namespace nvfuser_resources {

constexpr const char* fp16_support_cu = R"(

#define __NVFUSER_HALF_TO_US(var) *(reinterpret_cast<unsigned short*>(&(var)))
#define __NVFUSER_HALF_TO_CUS(var) \
  *(reinterpret_cast<const unsigned short*>(&(var)))

struct __half;
__device__ __half __float2half(const float);

struct __align__(2) __half {
  __half() = default;

  __device__ __half(const float f) {
    __x = __float2half(f).__x;
  }

 protected:
  unsigned short __x;
};

__device__ __half __float2half(const float f) {
  __half val;
  asm("{  cvt.rn.f16.f32 %0, %1;}\n"
      : "=h"(__NVFUSER_HALF_TO_US(val))
      : "f"(f));
  return val;
}

__device__ float __half2float(const __half h) {
  float val;
  asm("{  cvt.f32.f16 %0, %1;}\n" : "=f"(val) : "h"(__NVFUSER_HALF_TO_CUS(h)));
  return val;
}

// aligned vector generates vectorized load/store on CUDA
template <typename scalar_t, int vec_size>
struct alignas(sizeof(scalar_t) * vec_size) Array {
  scalar_t val[vec_size];
  __device__ void set(scalar_t v) {
    for (int i = 0; i < vec_size; ++i) {
      val[i] = v;
    }
  }
};
)";

} // namespace nvfuser_resources
